# Setting a password for the discovery ISO
The discovery ISO generated by the Assisted Installer comes with a `core` user that has its password login disabled (although SSH access using the provided public key is still supported).

However, it can sometimes be useful (e.g. when SSH isn't working), to login to the machine directly (with physical or BMC access), using a password. This can be done using the console login prompt that is shown after the ISO boots up.

To allow that, the user must have a password set. In order to set a password, it's possible to use the Assisted Installer API which provides support for editing the discovery ISO's ignition file with custom parameters.

The following script provides an example of how to use the API in order to modify the discovery ISO in a way that sets `core`'s password to any password of your choice.

For more information about the API and its various authentication methods, see [this document](cloud.md).

# Modify password script
```
#!/bin/bash

set -euo pipefail

## User specific configuration
WANTED_PASSWORD=mypass
TOKEN=$(ocm token)
OCM_API_ENDPOINT="https://api.openshift.com/api/" 
CLUSTER_ID="3e76dcd9-04d1-4540-b49a-9291f32a3ccc" # Copy from Assisted Installer URL
DEST_ISO_FILE="changed_password.iso"
###############################

echo Downloading the original ignition file into the '$ORIGINAL_IGNITION' variable
ORIGINAL_IGNITION=$(curl -s $OCM_API_ENDPOINT/assisted-install/v1/clusters/$CLUSTER_ID/downloads/files\?file_name\=discovery.ign -H "Authorization: Bearer $TOKEN")

echo Generating a salted hash from '$WANTED_PASSWORD'
PASS_HASH=$(mkpasswd --method=SHA-512 $WANTED_PASSWORD | tr -d '\n')

echo Modifying '$ORIGINAL_IGNITION' to contain the new password hash rather than the previous one
NEW_IGNITION=$(<<< "$ORIGINAL_IGNITION" jq --arg passhash $PASS_HASH '.passwd.users[0].passwordHash = $passhash')

echo Telling service to use our patched ignition file
curl -s $OCM_API_ENDPOINT/assisted-install/v1/clusters/$CLUSTER_ID/discovery-ignition -H "Authorization: Bearer $TOKEN" --request PATCH --header "Content-Type: application/json" --data @<(echo '{"config": "replaceme"}' | jq --rawfile ignition <(echo $NEW_IGNITION) '.config = $ignition')

echo Downloading the new ISO file into $DEST_ISO_FILE
curl $OCM_API_ENDPOINT/assisted-install/v1/clusters/$CLUSTER_ID/downloads/image -H "Authorization: Bearer $(ocm token)" > $DEST_ISO_FILE
```
