// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ConnectivityRemoteHost connectivity remote host
//
// swagger:model connectivity-remote-host
type ConnectivityRemoteHost struct {

	// host id
	// Format: uuid
	HostID strfmt.UUID `json:"host_id,omitempty"`

	// l2 connectivity
	L2Connectivity []*L2Connectivity `json:"l2_connectivity"`

	// l3 connectivity
	L3Connectivity []*L3Connectivity `json:"l3_connectivity"`
}

// Validate validates this connectivity remote host
func (m *ConnectivityRemoteHost) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateHostID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateL2Connectivity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateL3Connectivity(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConnectivityRemoteHost) validateHostID(formats strfmt.Registry) error {

	if swag.IsZero(m.HostID) { // not required
		return nil
	}

	if err := validate.FormatOf("host_id", "body", "uuid", m.HostID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *ConnectivityRemoteHost) validateL2Connectivity(formats strfmt.Registry) error {

	if swag.IsZero(m.L2Connectivity) { // not required
		return nil
	}

	for i := 0; i < len(m.L2Connectivity); i++ {
		if swag.IsZero(m.L2Connectivity[i]) { // not required
			continue
		}

		if m.L2Connectivity[i] != nil {
			if err := m.L2Connectivity[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("l2_connectivity" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConnectivityRemoteHost) validateL3Connectivity(formats strfmt.Registry) error {

	if swag.IsZero(m.L3Connectivity) { // not required
		return nil
	}

	for i := 0; i < len(m.L3Connectivity); i++ {
		if swag.IsZero(m.L3Connectivity[i]) { // not required
			continue
		}

		if m.L3Connectivity[i] != nil {
			if err := m.L3Connectivity[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("l3_connectivity" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConnectivityRemoteHost) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConnectivityRemoteHost) UnmarshalBinary(b []byte) error {
	var res ConnectivityRemoteHost
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
