/*
 * CLOUD API
 *
 * An enterprise-grade Infrastructure is provided as a Service (IaaS) solution that can be managed through a browser-based \"Data Center Designer\" (DCD) tool or via an easy to use API.   The API allows you to perform a variety of management tasks such as spinning up additional servers, adding volumes, adjusting networking, and so forth. It is designed to allow users to leverage the same power and flexibility found within the DCD visual tool. Both tools are consistent with their concepts and lend well to making the experience smooth and intuitive.
 *
 * API version: 5.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionossdk

import (
	"encoding/json"
)

// DatacenterEntities struct for DatacenterEntities
type DatacenterEntities struct {
	Servers *Servers `json:"servers,omitempty"`
	Volumes *Volumes `json:"volumes,omitempty"`
	Loadbalancers *Loadbalancers `json:"loadbalancers,omitempty"`
	Lans *Lans `json:"lans,omitempty"`
}



// GetServers returns the Servers field value
// If the value is explicit nil, the zero value for Servers will be returned
func (o *DatacenterEntities) GetServers() *Servers {
	if o == nil {
		return nil
	}

	return o.Servers
}

// GetServersOk returns a tuple with the Servers field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *DatacenterEntities) GetServersOk() (*Servers, bool) {
	if o == nil {
		return nil, false
	}
	return o.Servers, true
}

// SetServers sets field value
func (o *DatacenterEntities) SetServers(v Servers) {
	o.Servers = &v
}

// HasServers returns a boolean if a field has been set.
func (o *DatacenterEntities) HasServers() bool {
	if o != nil && o.Servers != nil {
		return true
	}

	return false
}



// GetVolumes returns the Volumes field value
// If the value is explicit nil, the zero value for Volumes will be returned
func (o *DatacenterEntities) GetVolumes() *Volumes {
	if o == nil {
		return nil
	}

	return o.Volumes
}

// GetVolumesOk returns a tuple with the Volumes field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *DatacenterEntities) GetVolumesOk() (*Volumes, bool) {
	if o == nil {
		return nil, false
	}
	return o.Volumes, true
}

// SetVolumes sets field value
func (o *DatacenterEntities) SetVolumes(v Volumes) {
	o.Volumes = &v
}

// HasVolumes returns a boolean if a field has been set.
func (o *DatacenterEntities) HasVolumes() bool {
	if o != nil && o.Volumes != nil {
		return true
	}

	return false
}



// GetLoadbalancers returns the Loadbalancers field value
// If the value is explicit nil, the zero value for Loadbalancers will be returned
func (o *DatacenterEntities) GetLoadbalancers() *Loadbalancers {
	if o == nil {
		return nil
	}

	return o.Loadbalancers
}

// GetLoadbalancersOk returns a tuple with the Loadbalancers field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *DatacenterEntities) GetLoadbalancersOk() (*Loadbalancers, bool) {
	if o == nil {
		return nil, false
	}
	return o.Loadbalancers, true
}

// SetLoadbalancers sets field value
func (o *DatacenterEntities) SetLoadbalancers(v Loadbalancers) {
	o.Loadbalancers = &v
}

// HasLoadbalancers returns a boolean if a field has been set.
func (o *DatacenterEntities) HasLoadbalancers() bool {
	if o != nil && o.Loadbalancers != nil {
		return true
	}

	return false
}



// GetLans returns the Lans field value
// If the value is explicit nil, the zero value for Lans will be returned
func (o *DatacenterEntities) GetLans() *Lans {
	if o == nil {
		return nil
	}

	return o.Lans
}

// GetLansOk returns a tuple with the Lans field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *DatacenterEntities) GetLansOk() (*Lans, bool) {
	if o == nil {
		return nil, false
	}
	return o.Lans, true
}

// SetLans sets field value
func (o *DatacenterEntities) SetLans(v Lans) {
	o.Lans = &v
}

// HasLans returns a boolean if a field has been set.
func (o *DatacenterEntities) HasLans() bool {
	if o != nil && o.Lans != nil {
		return true
	}

	return false
}


func (o DatacenterEntities) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}

	if o.Servers != nil {
		toSerialize["servers"] = o.Servers
	}
	

	if o.Volumes != nil {
		toSerialize["volumes"] = o.Volumes
	}
	

	if o.Loadbalancers != nil {
		toSerialize["loadbalancers"] = o.Loadbalancers
	}
	

	if o.Lans != nil {
		toSerialize["lans"] = o.Lans
	}
	
	return json.Marshal(toSerialize)
}

type NullableDatacenterEntities struct {
	value *DatacenterEntities
	isSet bool
}

func (v NullableDatacenterEntities) Get() *DatacenterEntities {
	return v.value
}

func (v *NullableDatacenterEntities) Set(val *DatacenterEntities) {
	v.value = val
	v.isSet = true
}

func (v NullableDatacenterEntities) IsSet() bool {
	return v.isSet
}

func (v *NullableDatacenterEntities) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDatacenterEntities(val *DatacenterEntities) *NullableDatacenterEntities {
	return &NullableDatacenterEntities{value: val, isSet: true}
}

func (v NullableDatacenterEntities) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDatacenterEntities) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


