/*
 * CLOUD API
 *
 * An enterprise-grade Infrastructure is provided as a Service (IaaS) solution that can be managed through a browser-based \"Data Center Designer\" (DCD) tool or via an easy to use API.   The API allows you to perform a variety of management tasks such as spinning up additional servers, adding volumes, adjusting networking, and so forth. It is designed to allow users to leverage the same power and flexibility found within the DCD visual tool. Both tools are consistent with their concepts and lend well to making the experience smooth and intuitive.
 *
 * API version: 5.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionossdk

import (
	"encoding/json"
)

// S3ObjectStorageSSO struct for S3ObjectStorageSSO
type S3ObjectStorageSSO struct {
	// The S3 object storage single sign on url
	SsoUrl *string `json:"ssoUrl,omitempty"`
}



// GetSsoUrl returns the SsoUrl field value
// If the value is explicit nil, the zero value for string will be returned
func (o *S3ObjectStorageSSO) GetSsoUrl() *string {
	if o == nil {
		return nil
	}

	return o.SsoUrl
}

// GetSsoUrlOk returns a tuple with the SsoUrl field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *S3ObjectStorageSSO) GetSsoUrlOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.SsoUrl, true
}

// SetSsoUrl sets field value
func (o *S3ObjectStorageSSO) SetSsoUrl(v string) {
	o.SsoUrl = &v
}

// HasSsoUrl returns a boolean if a field has been set.
func (o *S3ObjectStorageSSO) HasSsoUrl() bool {
	if o != nil && o.SsoUrl != nil {
		return true
	}

	return false
}


func (o S3ObjectStorageSSO) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}

	if o.SsoUrl != nil {
		toSerialize["ssoUrl"] = o.SsoUrl
	}
	
	return json.Marshal(toSerialize)
}

type NullableS3ObjectStorageSSO struct {
	value *S3ObjectStorageSSO
	isSet bool
}

func (v NullableS3ObjectStorageSSO) Get() *S3ObjectStorageSSO {
	return v.value
}

func (v *NullableS3ObjectStorageSSO) Set(val *S3ObjectStorageSSO) {
	v.value = val
	v.isSet = true
}

func (v NullableS3ObjectStorageSSO) IsSet() bool {
	return v.isSet
}

func (v *NullableS3ObjectStorageSSO) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableS3ObjectStorageSSO(val *S3ObjectStorageSSO) *NullableS3ObjectStorageSSO {
	return &NullableS3ObjectStorageSSO{value: val, isSet: true}
}

func (v NullableS3ObjectStorageSSO) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableS3ObjectStorageSSO) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


