// +build go1.9

// Copyright 2018 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package automation

import original "github.com/Azure/azure-sdk-for-go/services/preview/automation/mgmt/2017-05-15-preview/automation"

type AccountClient = original.AccountClient
type ActivityClient = original.ActivityClient
type AgentRegistrationInformationClient = original.AgentRegistrationInformationClient
type CertificateClient = original.CertificateClient

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type BaseClient = original.BaseClient
type ConnectionClient = original.ConnectionClient
type ConnectionTypeClient = original.ConnectionTypeClient
type CredentialClient = original.CredentialClient
type DscCompilationJobClient = original.DscCompilationJobClient
type DscCompilationJobStreamClient = original.DscCompilationJobStreamClient
type DscConfigurationClient = original.DscConfigurationClient
type DscNodeClient = original.DscNodeClient
type DscNodeConfigurationClient = original.DscNodeConfigurationClient
type FieldsClient = original.FieldsClient
type HybridRunbookWorkerGroupClient = original.HybridRunbookWorkerGroupClient
type JobClient = original.JobClient
type JobScheduleClient = original.JobScheduleClient
type JobStreamClient = original.JobStreamClient
type KeysClient = original.KeysClient
type LinkedWorkspaceClient = original.LinkedWorkspaceClient
type AccountState = original.AccountState

const (
	Ok          AccountState = original.Ok
	Suspended   AccountState = original.Suspended
	Unavailable AccountState = original.Unavailable
)

type AgentRegistrationKeyName = original.AgentRegistrationKeyName

const (
	Primary   AgentRegistrationKeyName = original.Primary
	Secondary AgentRegistrationKeyName = original.Secondary
)

type ContentSourceType = original.ContentSourceType

const (
	EmbeddedContent ContentSourceType = original.EmbeddedContent
	URI             ContentSourceType = original.URI
)

type DscConfigurationProvisioningState = original.DscConfigurationProvisioningState

const (
	Succeeded DscConfigurationProvisioningState = original.Succeeded
)

type DscConfigurationState = original.DscConfigurationState

const (
	DscConfigurationStateEdit      DscConfigurationState = original.DscConfigurationStateEdit
	DscConfigurationStateNew       DscConfigurationState = original.DscConfigurationStateNew
	DscConfigurationStatePublished DscConfigurationState = original.DscConfigurationStatePublished
)

type GroupTypeEnum = original.GroupTypeEnum

const (
	System GroupTypeEnum = original.System
	User   GroupTypeEnum = original.User
)

type HTTPStatusCode = original.HTTPStatusCode

const (
	Accepted                     HTTPStatusCode = original.Accepted
	Ambiguous                    HTTPStatusCode = original.Ambiguous
	BadGateway                   HTTPStatusCode = original.BadGateway
	BadRequest                   HTTPStatusCode = original.BadRequest
	Conflict                     HTTPStatusCode = original.Conflict
	Continue                     HTTPStatusCode = original.Continue
	Created                      HTTPStatusCode = original.Created
	ExpectationFailed            HTTPStatusCode = original.ExpectationFailed
	Forbidden                    HTTPStatusCode = original.Forbidden
	Found                        HTTPStatusCode = original.Found
	GatewayTimeout               HTTPStatusCode = original.GatewayTimeout
	Gone                         HTTPStatusCode = original.Gone
	HTTPVersionNotSupported      HTTPStatusCode = original.HTTPVersionNotSupported
	InternalServerError          HTTPStatusCode = original.InternalServerError
	LengthRequired               HTTPStatusCode = original.LengthRequired
	MethodNotAllowed             HTTPStatusCode = original.MethodNotAllowed
	Moved                        HTTPStatusCode = original.Moved
	MovedPermanently             HTTPStatusCode = original.MovedPermanently
	MultipleChoices              HTTPStatusCode = original.MultipleChoices
	NoContent                    HTTPStatusCode = original.NoContent
	NonAuthoritativeInformation  HTTPStatusCode = original.NonAuthoritativeInformation
	NotAcceptable                HTTPStatusCode = original.NotAcceptable
	NotFound                     HTTPStatusCode = original.NotFound
	NotImplemented               HTTPStatusCode = original.NotImplemented
	NotModified                  HTTPStatusCode = original.NotModified
	OK                           HTTPStatusCode = original.OK
	PartialContent               HTTPStatusCode = original.PartialContent
	PaymentRequired              HTTPStatusCode = original.PaymentRequired
	PreconditionFailed           HTTPStatusCode = original.PreconditionFailed
	ProxyAuthenticationRequired  HTTPStatusCode = original.ProxyAuthenticationRequired
	Redirect                     HTTPStatusCode = original.Redirect
	RedirectKeepVerb             HTTPStatusCode = original.RedirectKeepVerb
	RedirectMethod               HTTPStatusCode = original.RedirectMethod
	RequestedRangeNotSatisfiable HTTPStatusCode = original.RequestedRangeNotSatisfiable
	RequestEntityTooLarge        HTTPStatusCode = original.RequestEntityTooLarge
	RequestTimeout               HTTPStatusCode = original.RequestTimeout
	RequestURITooLong            HTTPStatusCode = original.RequestURITooLong
	ResetContent                 HTTPStatusCode = original.ResetContent
	SeeOther                     HTTPStatusCode = original.SeeOther
	ServiceUnavailable           HTTPStatusCode = original.ServiceUnavailable
	SwitchingProtocols           HTTPStatusCode = original.SwitchingProtocols
	TemporaryRedirect            HTTPStatusCode = original.TemporaryRedirect
	Unauthorized                 HTTPStatusCode = original.Unauthorized
	UnsupportedMediaType         HTTPStatusCode = original.UnsupportedMediaType
	Unused                       HTTPStatusCode = original.Unused
	UpgradeRequired              HTTPStatusCode = original.UpgradeRequired
	UseProxy                     HTTPStatusCode = original.UseProxy
)

type JobProvisioningState = original.JobProvisioningState

const (
	JobProvisioningStateFailed     JobProvisioningState = original.JobProvisioningStateFailed
	JobProvisioningStateProcessing JobProvisioningState = original.JobProvisioningStateProcessing
	JobProvisioningStateSucceeded  JobProvisioningState = original.JobProvisioningStateSucceeded
	JobProvisioningStateSuspended  JobProvisioningState = original.JobProvisioningStateSuspended
)

type JobStatus = original.JobStatus

const (
	JobStatusActivating   JobStatus = original.JobStatusActivating
	JobStatusBlocked      JobStatus = original.JobStatusBlocked
	JobStatusCompleted    JobStatus = original.JobStatusCompleted
	JobStatusDisconnected JobStatus = original.JobStatusDisconnected
	JobStatusFailed       JobStatus = original.JobStatusFailed
	JobStatusNew          JobStatus = original.JobStatusNew
	JobStatusRemoving     JobStatus = original.JobStatusRemoving
	JobStatusResuming     JobStatus = original.JobStatusResuming
	JobStatusRunning      JobStatus = original.JobStatusRunning
	JobStatusStopped      JobStatus = original.JobStatusStopped
	JobStatusStopping     JobStatus = original.JobStatusStopping
	JobStatusSuspended    JobStatus = original.JobStatusSuspended
	JobStatusSuspending   JobStatus = original.JobStatusSuspending
)

type JobStreamType = original.JobStreamType

const (
	Any      JobStreamType = original.Any
	Debug    JobStreamType = original.Debug
	Error    JobStreamType = original.Error
	Output   JobStreamType = original.Output
	Progress JobStreamType = original.Progress
	Verbose  JobStreamType = original.Verbose
	Warning  JobStreamType = original.Warning
)

type KeyName = original.KeyName

const (
	KeyNamePrimary   KeyName = original.KeyNamePrimary
	KeyNameSecondary KeyName = original.KeyNameSecondary
)

type KeyPermissions = original.KeyPermissions

const (
	Full KeyPermissions = original.Full
	Read KeyPermissions = original.Read
)

type LinuxUpdateClasses = original.LinuxUpdateClasses

const (
	Critical     LinuxUpdateClasses = original.Critical
	Other        LinuxUpdateClasses = original.Other
	Security     LinuxUpdateClasses = original.Security
	Unclassified LinuxUpdateClasses = original.Unclassified
)

type ModuleProvisioningState = original.ModuleProvisioningState

const (
	ModuleProvisioningStateActivitiesStored            ModuleProvisioningState = original.ModuleProvisioningStateActivitiesStored
	ModuleProvisioningStateCancelled                   ModuleProvisioningState = original.ModuleProvisioningStateCancelled
	ModuleProvisioningStateConnectionTypeImported      ModuleProvisioningState = original.ModuleProvisioningStateConnectionTypeImported
	ModuleProvisioningStateContentDownloaded           ModuleProvisioningState = original.ModuleProvisioningStateContentDownloaded
	ModuleProvisioningStateContentRetrieved            ModuleProvisioningState = original.ModuleProvisioningStateContentRetrieved
	ModuleProvisioningStateContentStored               ModuleProvisioningState = original.ModuleProvisioningStateContentStored
	ModuleProvisioningStateContentValidated            ModuleProvisioningState = original.ModuleProvisioningStateContentValidated
	ModuleProvisioningStateCreated                     ModuleProvisioningState = original.ModuleProvisioningStateCreated
	ModuleProvisioningStateCreating                    ModuleProvisioningState = original.ModuleProvisioningStateCreating
	ModuleProvisioningStateFailed                      ModuleProvisioningState = original.ModuleProvisioningStateFailed
	ModuleProvisioningStateModuleDataStored            ModuleProvisioningState = original.ModuleProvisioningStateModuleDataStored
	ModuleProvisioningStateModuleImportRunbookComplete ModuleProvisioningState = original.ModuleProvisioningStateModuleImportRunbookComplete
	ModuleProvisioningStateRunningImportModuleRunbook  ModuleProvisioningState = original.ModuleProvisioningStateRunningImportModuleRunbook
	ModuleProvisioningStateStartingImportModuleRunbook ModuleProvisioningState = original.ModuleProvisioningStateStartingImportModuleRunbook
	ModuleProvisioningStateSucceeded                   ModuleProvisioningState = original.ModuleProvisioningStateSucceeded
	ModuleProvisioningStateUpdating                    ModuleProvisioningState = original.ModuleProvisioningStateUpdating
)

type OperatingSystemType = original.OperatingSystemType

const (
	Linux   OperatingSystemType = original.Linux
	Windows OperatingSystemType = original.Windows
)

type ProvisioningState = original.ProvisioningState

const (
	Completed ProvisioningState = original.Completed
	Failed    ProvisioningState = original.Failed
	Running   ProvisioningState = original.Running
)

type RunbookProvisioningState = original.RunbookProvisioningState

const (
	RunbookProvisioningStateSucceeded RunbookProvisioningState = original.RunbookProvisioningStateSucceeded
)

type RunbookState = original.RunbookState

const (
	RunbookStateEdit      RunbookState = original.RunbookStateEdit
	RunbookStateNew       RunbookState = original.RunbookStateNew
	RunbookStatePublished RunbookState = original.RunbookStatePublished
)

type RunbookTypeEnum = original.RunbookTypeEnum

const (
	Graph                   RunbookTypeEnum = original.Graph
	GraphPowerShell         RunbookTypeEnum = original.GraphPowerShell
	GraphPowerShellWorkflow RunbookTypeEnum = original.GraphPowerShellWorkflow
	PowerShell              RunbookTypeEnum = original.PowerShell
	PowerShellWorkflow      RunbookTypeEnum = original.PowerShellWorkflow
	Script                  RunbookTypeEnum = original.Script
)

type ScheduleDay = original.ScheduleDay

const (
	Friday    ScheduleDay = original.Friday
	Monday    ScheduleDay = original.Monday
	Saturday  ScheduleDay = original.Saturday
	Sunday    ScheduleDay = original.Sunday
	Thursday  ScheduleDay = original.Thursday
	Tuesday   ScheduleDay = original.Tuesday
	Wednesday ScheduleDay = original.Wednesday
)

type ScheduleFrequency = original.ScheduleFrequency

const (
	Day     ScheduleFrequency = original.Day
	Hour    ScheduleFrequency = original.Hour
	Month   ScheduleFrequency = original.Month
	OneTime ScheduleFrequency = original.OneTime
	Week    ScheduleFrequency = original.Week
)

type SkuNameEnum = original.SkuNameEnum

const (
	Basic SkuNameEnum = original.Basic
	Free  SkuNameEnum = original.Free
)

type SourceType = original.SourceType

const (
	GitHub  SourceType = original.GitHub
	VsoGit  SourceType = original.VsoGit
	VsoTfvc SourceType = original.VsoTfvc
)

type StreamType = original.StreamType

const (
	StreamTypeError  StreamType = original.StreamTypeError
	StreamTypeOutput StreamType = original.StreamTypeOutput
)

type SyncType = original.SyncType

const (
	FullSync    SyncType = original.FullSync
	PartialSync SyncType = original.PartialSync
)

type TokenType = original.TokenType

const (
	Oauth               TokenType = original.Oauth
	PersonalAccessToken TokenType = original.PersonalAccessToken
)

type WindowsUpdateClasses = original.WindowsUpdateClasses

const (
	WindowsUpdateClassesCritical     WindowsUpdateClasses = original.WindowsUpdateClassesCritical
	WindowsUpdateClassesDefinition   WindowsUpdateClasses = original.WindowsUpdateClassesDefinition
	WindowsUpdateClassesFeaturePack  WindowsUpdateClasses = original.WindowsUpdateClassesFeaturePack
	WindowsUpdateClassesSecurity     WindowsUpdateClasses = original.WindowsUpdateClassesSecurity
	WindowsUpdateClassesServicePack  WindowsUpdateClasses = original.WindowsUpdateClassesServicePack
	WindowsUpdateClassesTools        WindowsUpdateClasses = original.WindowsUpdateClassesTools
	WindowsUpdateClassesUnclassified WindowsUpdateClasses = original.WindowsUpdateClassesUnclassified
	WindowsUpdateClassesUpdateRollup WindowsUpdateClasses = original.WindowsUpdateClassesUpdateRollup
	WindowsUpdateClassesUpdates      WindowsUpdateClasses = original.WindowsUpdateClassesUpdates
)

type Account = original.Account
type AccountCreateOrUpdateParameters = original.AccountCreateOrUpdateParameters
type AccountCreateOrUpdateProperties = original.AccountCreateOrUpdateProperties
type AccountListResult = original.AccountListResult
type AccountListResultIterator = original.AccountListResultIterator
type AccountListResultPage = original.AccountListResultPage
type AccountProperties = original.AccountProperties
type AccountUpdateParameters = original.AccountUpdateParameters
type AccountUpdateProperties = original.AccountUpdateProperties
type Activity = original.Activity
type ActivityListResult = original.ActivityListResult
type ActivityListResultIterator = original.ActivityListResultIterator
type ActivityListResultPage = original.ActivityListResultPage
type ActivityOutputType = original.ActivityOutputType
type ActivityParameter = original.ActivityParameter
type ActivityParameterSet = original.ActivityParameterSet
type ActivityParameterValidationSet = original.ActivityParameterValidationSet
type ActivityProperties = original.ActivityProperties
type AdvancedSchedule = original.AdvancedSchedule
type AdvancedScheduleMonthlyOccurrence = original.AdvancedScheduleMonthlyOccurrence
type AgentRegistration = original.AgentRegistration
type AgentRegistrationKeys = original.AgentRegistrationKeys
type AgentRegistrationRegenerateKeyParameter = original.AgentRegistrationRegenerateKeyParameter
type Certificate = original.Certificate
type CertificateCreateOrUpdateParameters = original.CertificateCreateOrUpdateParameters
type CertificateCreateOrUpdateProperties = original.CertificateCreateOrUpdateProperties
type CertificateListResult = original.CertificateListResult
type CertificateListResultIterator = original.CertificateListResultIterator
type CertificateListResultPage = original.CertificateListResultPage
type CertificateProperties = original.CertificateProperties
type CertificateUpdateParameters = original.CertificateUpdateParameters
type CertificateUpdateProperties = original.CertificateUpdateProperties
type CollectionItemUpdateConfiguration = original.CollectionItemUpdateConfiguration
type Connection = original.Connection
type ConnectionCreateOrUpdateParameters = original.ConnectionCreateOrUpdateParameters
type ConnectionCreateOrUpdateProperties = original.ConnectionCreateOrUpdateProperties
type ConnectionListResult = original.ConnectionListResult
type ConnectionListResultIterator = original.ConnectionListResultIterator
type ConnectionListResultPage = original.ConnectionListResultPage
type ConnectionProperties = original.ConnectionProperties
type ConnectionType = original.ConnectionType
type ConnectionTypeAssociationProperty = original.ConnectionTypeAssociationProperty
type ConnectionTypeCreateOrUpdateParameters = original.ConnectionTypeCreateOrUpdateParameters
type ConnectionTypeCreateOrUpdateProperties = original.ConnectionTypeCreateOrUpdateProperties
type ConnectionTypeListResult = original.ConnectionTypeListResult
type ConnectionTypeListResultIterator = original.ConnectionTypeListResultIterator
type ConnectionTypeListResultPage = original.ConnectionTypeListResultPage
type ConnectionTypeProperties = original.ConnectionTypeProperties
type ConnectionUpdateParameters = original.ConnectionUpdateParameters
type ConnectionUpdateProperties = original.ConnectionUpdateProperties
type ContentHash = original.ContentHash
type ContentLink = original.ContentLink
type ContentSource = original.ContentSource
type Credential = original.Credential
type CredentialCreateOrUpdateParameters = original.CredentialCreateOrUpdateParameters
type CredentialCreateOrUpdateProperties = original.CredentialCreateOrUpdateProperties
type CredentialListResult = original.CredentialListResult
type CredentialListResultIterator = original.CredentialListResultIterator
type CredentialListResultPage = original.CredentialListResultPage
type CredentialProperties = original.CredentialProperties
type CredentialUpdateParameters = original.CredentialUpdateParameters
type CredentialUpdateProperties = original.CredentialUpdateProperties
type DscCompilationJob = original.DscCompilationJob
type DscCompilationJobCreateParameters = original.DscCompilationJobCreateParameters
type DscCompilationJobCreateProperties = original.DscCompilationJobCreateProperties
type DscCompilationJobListResult = original.DscCompilationJobListResult
type DscCompilationJobListResultIterator = original.DscCompilationJobListResultIterator
type DscCompilationJobListResultPage = original.DscCompilationJobListResultPage
type DscCompilationJobProperties = original.DscCompilationJobProperties
type DscConfiguration = original.DscConfiguration
type DscConfigurationAssociationProperty = original.DscConfigurationAssociationProperty
type DscConfigurationCreateOrUpdateParameters = original.DscConfigurationCreateOrUpdateParameters
type DscConfigurationCreateOrUpdateProperties = original.DscConfigurationCreateOrUpdateProperties
type DscConfigurationListResult = original.DscConfigurationListResult
type DscConfigurationListResultIterator = original.DscConfigurationListResultIterator
type DscConfigurationListResultPage = original.DscConfigurationListResultPage
type DscConfigurationParameter = original.DscConfigurationParameter
type DscConfigurationProperties = original.DscConfigurationProperties
type DscConfigurationUpdateParameters = original.DscConfigurationUpdateParameters
type DscMetaConfiguration = original.DscMetaConfiguration
type DscNode = original.DscNode
type DscNodeConfiguration = original.DscNodeConfiguration
type DscNodeConfigurationAssociationProperty = original.DscNodeConfigurationAssociationProperty
type DscNodeConfigurationCreateOrUpdateParameters = original.DscNodeConfigurationCreateOrUpdateParameters
type DscNodeConfigurationListResult = original.DscNodeConfigurationListResult
type DscNodeConfigurationListResultIterator = original.DscNodeConfigurationListResultIterator
type DscNodeConfigurationListResultPage = original.DscNodeConfigurationListResultPage
type DscNodeExtensionHandlerAssociationProperty = original.DscNodeExtensionHandlerAssociationProperty
type DscNodeListResult = original.DscNodeListResult
type DscNodeListResultIterator = original.DscNodeListResultIterator
type DscNodeListResultPage = original.DscNodeListResultPage
type DscNodeReport = original.DscNodeReport
type DscNodeReportListResult = original.DscNodeReportListResult
type DscNodeReportListResultIterator = original.DscNodeReportListResultIterator
type DscNodeReportListResultPage = original.DscNodeReportListResultPage
type DscNodeUpdateParameters = original.DscNodeUpdateParameters
type DscReportError = original.DscReportError
type DscReportResource = original.DscReportResource
type DscReportResourceNavigation = original.DscReportResourceNavigation
type ErrorResponse = original.ErrorResponse
type FieldDefinition = original.FieldDefinition
type HybridRunbookWorker = original.HybridRunbookWorker
type HybridRunbookWorkerGroup = original.HybridRunbookWorkerGroup
type HybridRunbookWorkerGroupsListResult = original.HybridRunbookWorkerGroupsListResult
type HybridRunbookWorkerGroupsListResultIterator = original.HybridRunbookWorkerGroupsListResultIterator
type HybridRunbookWorkerGroupsListResultPage = original.HybridRunbookWorkerGroupsListResultPage
type HybridRunbookWorkerGroupUpdateParameters = original.HybridRunbookWorkerGroupUpdateParameters
type Job = original.Job
type JobCollectionItem = original.JobCollectionItem
type JobCollectionItemProperties = original.JobCollectionItemProperties
type JobCreateParameters = original.JobCreateParameters
type JobCreateProperties = original.JobCreateProperties
type JobListResultV2 = original.JobListResultV2
type JobListResultV2Iterator = original.JobListResultV2Iterator
type JobListResultV2Page = original.JobListResultV2Page
type JobNavigation = original.JobNavigation
type JobProperties = original.JobProperties
type JobSchedule = original.JobSchedule
type JobScheduleCreateParameters = original.JobScheduleCreateParameters
type JobScheduleCreateProperties = original.JobScheduleCreateProperties
type JobScheduleListResult = original.JobScheduleListResult
type JobScheduleListResultIterator = original.JobScheduleListResultIterator
type JobScheduleListResultPage = original.JobScheduleListResultPage
type JobScheduleProperties = original.JobScheduleProperties
type JobStream = original.JobStream
type JobStreamListResult = original.JobStreamListResult
type JobStreamListResultIterator = original.JobStreamListResultIterator
type JobStreamListResultPage = original.JobStreamListResultPage
type JobStreamProperties = original.JobStreamProperties
type Key = original.Key
type KeyListResult = original.KeyListResult
type LinkedWorkspace = original.LinkedWorkspace
type LinuxProperties = original.LinuxProperties
type Module = original.Module
type ModuleCreateOrUpdateParameters = original.ModuleCreateOrUpdateParameters
type ModuleCreateOrUpdateProperties = original.ModuleCreateOrUpdateProperties
type ModuleErrorInfo = original.ModuleErrorInfo
type ModuleListResult = original.ModuleListResult
type ModuleListResultIterator = original.ModuleListResultIterator
type ModuleListResultPage = original.ModuleListResultPage
type ModuleProperties = original.ModuleProperties
type ModuleUpdateParameters = original.ModuleUpdateParameters
type ModuleUpdateProperties = original.ModuleUpdateProperties
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationListResult = original.OperationListResult
type ProxyResource = original.ProxyResource
type ReadCloser = original.ReadCloser
type Resource = original.Resource
type RunAsCredentialAssociationProperty = original.RunAsCredentialAssociationProperty
type Runbook = original.Runbook
type RunbookAssociationProperty = original.RunbookAssociationProperty
type RunbookCreateOrUpdateDraftParameters = original.RunbookCreateOrUpdateDraftParameters
type RunbookCreateOrUpdateDraftProperties = original.RunbookCreateOrUpdateDraftProperties
type RunbookCreateOrUpdateParameters = original.RunbookCreateOrUpdateParameters
type RunbookCreateOrUpdateProperties = original.RunbookCreateOrUpdateProperties
type RunbookDraft = original.RunbookDraft
type RunbookDraftPublishFuture = original.RunbookDraftPublishFuture
type RunbookDraftReplaceContentFuture = original.RunbookDraftReplaceContentFuture
type RunbookDraftUndoEditResult = original.RunbookDraftUndoEditResult
type RunbookListResult = original.RunbookListResult
type RunbookListResultIterator = original.RunbookListResultIterator
type RunbookListResultPage = original.RunbookListResultPage
type RunbookParameter = original.RunbookParameter
type RunbookProperties = original.RunbookProperties
type RunbookUpdateParameters = original.RunbookUpdateParameters
type RunbookUpdateProperties = original.RunbookUpdateProperties
type Schedule = original.Schedule
type ScheduleAssociationProperty = original.ScheduleAssociationProperty
type ScheduleCreateOrUpdateParameters = original.ScheduleCreateOrUpdateParameters
type ScheduleCreateOrUpdateProperties = original.ScheduleCreateOrUpdateProperties
type ScheduleListResult = original.ScheduleListResult
type ScheduleListResultIterator = original.ScheduleListResultIterator
type ScheduleListResultPage = original.ScheduleListResultPage
type ScheduleProperties = original.ScheduleProperties
type ScheduleUpdateParameters = original.ScheduleUpdateParameters
type ScheduleUpdateProperties = original.ScheduleUpdateProperties
type SetObject = original.SetObject
type Sku = original.Sku
type SoftwareUpdateConfiguration = original.SoftwareUpdateConfiguration
type SoftwareUpdateConfigurationCollectionItem = original.SoftwareUpdateConfigurationCollectionItem
type SoftwareUpdateConfigurationCollectionItemProperties = original.SoftwareUpdateConfigurationCollectionItemProperties
type SoftwareUpdateConfigurationListResult = original.SoftwareUpdateConfigurationListResult
type SoftwareUpdateConfigurationMachineRun = original.SoftwareUpdateConfigurationMachineRun
type SoftwareUpdateConfigurationMachineRunListResult = original.SoftwareUpdateConfigurationMachineRunListResult
type SoftwareUpdateConfigurationProperties = original.SoftwareUpdateConfigurationProperties
type SoftwareUpdateConfigurationRun = original.SoftwareUpdateConfigurationRun
type SoftwareUpdateConfigurationRunListResult = original.SoftwareUpdateConfigurationRunListResult
type SoftwareUpdateConfigurationRunProperties = original.SoftwareUpdateConfigurationRunProperties
type SourceControl = original.SourceControl
type SourceControlCreateOrUpdateParameters = original.SourceControlCreateOrUpdateParameters
type SourceControlCreateOrUpdateProperties = original.SourceControlCreateOrUpdateProperties
type SourceControlListResult = original.SourceControlListResult
type SourceControlListResultIterator = original.SourceControlListResultIterator
type SourceControlListResultPage = original.SourceControlListResultPage
type SourceControlProperties = original.SourceControlProperties
type SourceControlSecurityTokenProperties = original.SourceControlSecurityTokenProperties
type SourceControlSyncJob = original.SourceControlSyncJob
type SourceControlSyncJobByID = original.SourceControlSyncJobByID
type SourceControlSyncJobByIDProperties = original.SourceControlSyncJobByIDProperties
type SourceControlSyncJobCreateParameters = original.SourceControlSyncJobCreateParameters
type SourceControlSyncJobCreateProperties = original.SourceControlSyncJobCreateProperties
type SourceControlSyncJobListResult = original.SourceControlSyncJobListResult
type SourceControlSyncJobListResultIterator = original.SourceControlSyncJobListResultIterator
type SourceControlSyncJobListResultPage = original.SourceControlSyncJobListResultPage
type SourceControlSyncJobProperties = original.SourceControlSyncJobProperties
type SourceControlSyncJobStream = original.SourceControlSyncJobStream
type SourceControlSyncJobStreamByID = original.SourceControlSyncJobStreamByID
type SourceControlSyncJobStreamByIDProperties = original.SourceControlSyncJobStreamByIDProperties
type SourceControlSyncJobStreamProperties = original.SourceControlSyncJobStreamProperties
type SourceControlSyncJobStreamsListBySyncJob = original.SourceControlSyncJobStreamsListBySyncJob
type SourceControlSyncJobStreamsListBySyncJobIterator = original.SourceControlSyncJobStreamsListBySyncJobIterator
type SourceControlSyncJobStreamsListBySyncJobPage = original.SourceControlSyncJobStreamsListBySyncJobPage
type SourceControlUpdateParameters = original.SourceControlUpdateParameters
type SourceControlUpdateProperties = original.SourceControlUpdateProperties
type Statistics = original.Statistics
type StatisticsListResult = original.StatisticsListResult
type String = original.String
type TestJob = original.TestJob
type TestJobCreateParameters = original.TestJobCreateParameters
type TrackedResource = original.TrackedResource
type TypeField = original.TypeField
type TypeFieldListResult = original.TypeFieldListResult
type UpdateConfiguration = original.UpdateConfiguration
type UpdateConfigurationMachineRunProperties = original.UpdateConfigurationMachineRunProperties
type UpdateConfigurationNavigation = original.UpdateConfigurationNavigation
type Usage = original.Usage
type UsageCounterName = original.UsageCounterName
type UsageListResult = original.UsageListResult
type Variable = original.Variable
type VariableCreateOrUpdateParameters = original.VariableCreateOrUpdateParameters
type VariableCreateOrUpdateProperties = original.VariableCreateOrUpdateProperties
type VariableListResult = original.VariableListResult
type VariableListResultIterator = original.VariableListResultIterator
type VariableListResultPage = original.VariableListResultPage
type VariableProperties = original.VariableProperties
type VariableUpdateParameters = original.VariableUpdateParameters
type VariableUpdateProperties = original.VariableUpdateProperties
type Webhook = original.Webhook
type WebhookCreateOrUpdateParameters = original.WebhookCreateOrUpdateParameters
type WebhookCreateOrUpdateProperties = original.WebhookCreateOrUpdateProperties
type WebhookListResult = original.WebhookListResult
type WebhookListResultIterator = original.WebhookListResultIterator
type WebhookListResultPage = original.WebhookListResultPage
type WebhookProperties = original.WebhookProperties
type WebhookUpdateParameters = original.WebhookUpdateParameters
type WebhookUpdateProperties = original.WebhookUpdateProperties
type WindowsProperties = original.WindowsProperties
type ModuleClient = original.ModuleClient
type NodeReportsClient = original.NodeReportsClient
type ObjectDataTypesClient = original.ObjectDataTypesClient
type OperationsClient = original.OperationsClient
type RunbookClient = original.RunbookClient
type RunbookDraftClient = original.RunbookDraftClient
type ScheduleClient = original.ScheduleClient
type SoftwareUpdateConfigurationMachineRunsClient = original.SoftwareUpdateConfigurationMachineRunsClient
type SoftwareUpdateConfigurationRunsClient = original.SoftwareUpdateConfigurationRunsClient
type SoftwareUpdateConfigurationsClient = original.SoftwareUpdateConfigurationsClient
type SourceControlClient = original.SourceControlClient
type SourceControlSyncJobClient = original.SourceControlSyncJobClient
type SourceControlSyncJobStreamsClient = original.SourceControlSyncJobStreamsClient
type StatisticsClient = original.StatisticsClient
type TestJobClient = original.TestJobClient
type TestJobStreamsClient = original.TestJobStreamsClient
type UsagesClient = original.UsagesClient
type VariableClient = original.VariableClient
type WebhookClient = original.WebhookClient

func NewAccountClient(subscriptionID string) AccountClient {
	return original.NewAccountClient(subscriptionID)
}
func NewAccountClientWithBaseURI(baseURI string, subscriptionID string) AccountClient {
	return original.NewAccountClientWithBaseURI(baseURI, subscriptionID)
}
func NewActivityClient(subscriptionID string) ActivityClient {
	return original.NewActivityClient(subscriptionID)
}
func NewActivityClientWithBaseURI(baseURI string, subscriptionID string) ActivityClient {
	return original.NewActivityClientWithBaseURI(baseURI, subscriptionID)
}
func NewAgentRegistrationInformationClient(subscriptionID string) AgentRegistrationInformationClient {
	return original.NewAgentRegistrationInformationClient(subscriptionID)
}
func NewAgentRegistrationInformationClientWithBaseURI(baseURI string, subscriptionID string) AgentRegistrationInformationClient {
	return original.NewAgentRegistrationInformationClientWithBaseURI(baseURI, subscriptionID)
}
func NewCertificateClient(subscriptionID string) CertificateClient {
	return original.NewCertificateClient(subscriptionID)
}
func NewCertificateClientWithBaseURI(baseURI string, subscriptionID string) CertificateClient {
	return original.NewCertificateClientWithBaseURI(baseURI, subscriptionID)
}
func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func NewConnectionClient(subscriptionID string) ConnectionClient {
	return original.NewConnectionClient(subscriptionID)
}
func NewConnectionClientWithBaseURI(baseURI string, subscriptionID string) ConnectionClient {
	return original.NewConnectionClientWithBaseURI(baseURI, subscriptionID)
}
func NewConnectionTypeClient(subscriptionID string) ConnectionTypeClient {
	return original.NewConnectionTypeClient(subscriptionID)
}
func NewConnectionTypeClientWithBaseURI(baseURI string, subscriptionID string) ConnectionTypeClient {
	return original.NewConnectionTypeClientWithBaseURI(baseURI, subscriptionID)
}
func NewCredentialClient(subscriptionID string) CredentialClient {
	return original.NewCredentialClient(subscriptionID)
}
func NewCredentialClientWithBaseURI(baseURI string, subscriptionID string) CredentialClient {
	return original.NewCredentialClientWithBaseURI(baseURI, subscriptionID)
}
func NewDscCompilationJobClient(subscriptionID string) DscCompilationJobClient {
	return original.NewDscCompilationJobClient(subscriptionID)
}
func NewDscCompilationJobClientWithBaseURI(baseURI string, subscriptionID string) DscCompilationJobClient {
	return original.NewDscCompilationJobClientWithBaseURI(baseURI, subscriptionID)
}
func NewDscCompilationJobStreamClient(subscriptionID string) DscCompilationJobStreamClient {
	return original.NewDscCompilationJobStreamClient(subscriptionID)
}
func NewDscCompilationJobStreamClientWithBaseURI(baseURI string, subscriptionID string) DscCompilationJobStreamClient {
	return original.NewDscCompilationJobStreamClientWithBaseURI(baseURI, subscriptionID)
}
func NewDscConfigurationClient(subscriptionID string) DscConfigurationClient {
	return original.NewDscConfigurationClient(subscriptionID)
}
func NewDscConfigurationClientWithBaseURI(baseURI string, subscriptionID string) DscConfigurationClient {
	return original.NewDscConfigurationClientWithBaseURI(baseURI, subscriptionID)
}
func NewDscNodeClient(subscriptionID string) DscNodeClient {
	return original.NewDscNodeClient(subscriptionID)
}
func NewDscNodeClientWithBaseURI(baseURI string, subscriptionID string) DscNodeClient {
	return original.NewDscNodeClientWithBaseURI(baseURI, subscriptionID)
}
func NewDscNodeConfigurationClient(subscriptionID string) DscNodeConfigurationClient {
	return original.NewDscNodeConfigurationClient(subscriptionID)
}
func NewDscNodeConfigurationClientWithBaseURI(baseURI string, subscriptionID string) DscNodeConfigurationClient {
	return original.NewDscNodeConfigurationClientWithBaseURI(baseURI, subscriptionID)
}
func NewFieldsClient(subscriptionID string) FieldsClient {
	return original.NewFieldsClient(subscriptionID)
}
func NewFieldsClientWithBaseURI(baseURI string, subscriptionID string) FieldsClient {
	return original.NewFieldsClientWithBaseURI(baseURI, subscriptionID)
}
func NewHybridRunbookWorkerGroupClient(subscriptionID string) HybridRunbookWorkerGroupClient {
	return original.NewHybridRunbookWorkerGroupClient(subscriptionID)
}
func NewHybridRunbookWorkerGroupClientWithBaseURI(baseURI string, subscriptionID string) HybridRunbookWorkerGroupClient {
	return original.NewHybridRunbookWorkerGroupClientWithBaseURI(baseURI, subscriptionID)
}
func NewJobClient(subscriptionID string) JobClient {
	return original.NewJobClient(subscriptionID)
}
func NewJobClientWithBaseURI(baseURI string, subscriptionID string) JobClient {
	return original.NewJobClientWithBaseURI(baseURI, subscriptionID)
}
func NewJobScheduleClient(subscriptionID string) JobScheduleClient {
	return original.NewJobScheduleClient(subscriptionID)
}
func NewJobScheduleClientWithBaseURI(baseURI string, subscriptionID string) JobScheduleClient {
	return original.NewJobScheduleClientWithBaseURI(baseURI, subscriptionID)
}
func NewJobStreamClient(subscriptionID string) JobStreamClient {
	return original.NewJobStreamClient(subscriptionID)
}
func NewJobStreamClientWithBaseURI(baseURI string, subscriptionID string) JobStreamClient {
	return original.NewJobStreamClientWithBaseURI(baseURI, subscriptionID)
}
func NewKeysClient(subscriptionID string) KeysClient {
	return original.NewKeysClient(subscriptionID)
}
func NewKeysClientWithBaseURI(baseURI string, subscriptionID string) KeysClient {
	return original.NewKeysClientWithBaseURI(baseURI, subscriptionID)
}
func NewLinkedWorkspaceClient(subscriptionID string) LinkedWorkspaceClient {
	return original.NewLinkedWorkspaceClient(subscriptionID)
}
func NewLinkedWorkspaceClientWithBaseURI(baseURI string, subscriptionID string) LinkedWorkspaceClient {
	return original.NewLinkedWorkspaceClientWithBaseURI(baseURI, subscriptionID)
}
func PossibleAccountStateValues() []AccountState {
	return original.PossibleAccountStateValues()
}
func PossibleAgentRegistrationKeyNameValues() []AgentRegistrationKeyName {
	return original.PossibleAgentRegistrationKeyNameValues()
}
func PossibleContentSourceTypeValues() []ContentSourceType {
	return original.PossibleContentSourceTypeValues()
}
func PossibleDscConfigurationProvisioningStateValues() []DscConfigurationProvisioningState {
	return original.PossibleDscConfigurationProvisioningStateValues()
}
func PossibleDscConfigurationStateValues() []DscConfigurationState {
	return original.PossibleDscConfigurationStateValues()
}
func PossibleGroupTypeEnumValues() []GroupTypeEnum {
	return original.PossibleGroupTypeEnumValues()
}
func PossibleHTTPStatusCodeValues() []HTTPStatusCode {
	return original.PossibleHTTPStatusCodeValues()
}
func PossibleJobProvisioningStateValues() []JobProvisioningState {
	return original.PossibleJobProvisioningStateValues()
}
func PossibleJobStatusValues() []JobStatus {
	return original.PossibleJobStatusValues()
}
func PossibleJobStreamTypeValues() []JobStreamType {
	return original.PossibleJobStreamTypeValues()
}
func PossibleKeyNameValues() []KeyName {
	return original.PossibleKeyNameValues()
}
func PossibleKeyPermissionsValues() []KeyPermissions {
	return original.PossibleKeyPermissionsValues()
}
func PossibleLinuxUpdateClassesValues() []LinuxUpdateClasses {
	return original.PossibleLinuxUpdateClassesValues()
}
func PossibleModuleProvisioningStateValues() []ModuleProvisioningState {
	return original.PossibleModuleProvisioningStateValues()
}
func PossibleOperatingSystemTypeValues() []OperatingSystemType {
	return original.PossibleOperatingSystemTypeValues()
}
func PossibleProvisioningStateValues() []ProvisioningState {
	return original.PossibleProvisioningStateValues()
}
func PossibleRunbookProvisioningStateValues() []RunbookProvisioningState {
	return original.PossibleRunbookProvisioningStateValues()
}
func PossibleRunbookStateValues() []RunbookState {
	return original.PossibleRunbookStateValues()
}
func PossibleRunbookTypeEnumValues() []RunbookTypeEnum {
	return original.PossibleRunbookTypeEnumValues()
}
func PossibleScheduleDayValues() []ScheduleDay {
	return original.PossibleScheduleDayValues()
}
func PossibleScheduleFrequencyValues() []ScheduleFrequency {
	return original.PossibleScheduleFrequencyValues()
}
func PossibleSkuNameEnumValues() []SkuNameEnum {
	return original.PossibleSkuNameEnumValues()
}
func PossibleSourceTypeValues() []SourceType {
	return original.PossibleSourceTypeValues()
}
func PossibleStreamTypeValues() []StreamType {
	return original.PossibleStreamTypeValues()
}
func PossibleSyncTypeValues() []SyncType {
	return original.PossibleSyncTypeValues()
}
func PossibleTokenTypeValues() []TokenType {
	return original.PossibleTokenTypeValues()
}
func PossibleWindowsUpdateClassesValues() []WindowsUpdateClasses {
	return original.PossibleWindowsUpdateClassesValues()
}
func NewModuleClient(subscriptionID string) ModuleClient {
	return original.NewModuleClient(subscriptionID)
}
func NewModuleClientWithBaseURI(baseURI string, subscriptionID string) ModuleClient {
	return original.NewModuleClientWithBaseURI(baseURI, subscriptionID)
}
func NewNodeReportsClient(subscriptionID string) NodeReportsClient {
	return original.NewNodeReportsClient(subscriptionID)
}
func NewNodeReportsClientWithBaseURI(baseURI string, subscriptionID string) NodeReportsClient {
	return original.NewNodeReportsClientWithBaseURI(baseURI, subscriptionID)
}
func NewObjectDataTypesClient(subscriptionID string) ObjectDataTypesClient {
	return original.NewObjectDataTypesClient(subscriptionID)
}
func NewObjectDataTypesClientWithBaseURI(baseURI string, subscriptionID string) ObjectDataTypesClient {
	return original.NewObjectDataTypesClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewRunbookClient(subscriptionID string) RunbookClient {
	return original.NewRunbookClient(subscriptionID)
}
func NewRunbookClientWithBaseURI(baseURI string, subscriptionID string) RunbookClient {
	return original.NewRunbookClientWithBaseURI(baseURI, subscriptionID)
}
func NewRunbookDraftClient(subscriptionID string) RunbookDraftClient {
	return original.NewRunbookDraftClient(subscriptionID)
}
func NewRunbookDraftClientWithBaseURI(baseURI string, subscriptionID string) RunbookDraftClient {
	return original.NewRunbookDraftClientWithBaseURI(baseURI, subscriptionID)
}
func NewScheduleClient(subscriptionID string) ScheduleClient {
	return original.NewScheduleClient(subscriptionID)
}
func NewScheduleClientWithBaseURI(baseURI string, subscriptionID string) ScheduleClient {
	return original.NewScheduleClientWithBaseURI(baseURI, subscriptionID)
}
func NewSoftwareUpdateConfigurationMachineRunsClient(subscriptionID string) SoftwareUpdateConfigurationMachineRunsClient {
	return original.NewSoftwareUpdateConfigurationMachineRunsClient(subscriptionID)
}
func NewSoftwareUpdateConfigurationMachineRunsClientWithBaseURI(baseURI string, subscriptionID string) SoftwareUpdateConfigurationMachineRunsClient {
	return original.NewSoftwareUpdateConfigurationMachineRunsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSoftwareUpdateConfigurationRunsClient(subscriptionID string) SoftwareUpdateConfigurationRunsClient {
	return original.NewSoftwareUpdateConfigurationRunsClient(subscriptionID)
}
func NewSoftwareUpdateConfigurationRunsClientWithBaseURI(baseURI string, subscriptionID string) SoftwareUpdateConfigurationRunsClient {
	return original.NewSoftwareUpdateConfigurationRunsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSoftwareUpdateConfigurationsClient(subscriptionID string) SoftwareUpdateConfigurationsClient {
	return original.NewSoftwareUpdateConfigurationsClient(subscriptionID)
}
func NewSoftwareUpdateConfigurationsClientWithBaseURI(baseURI string, subscriptionID string) SoftwareUpdateConfigurationsClient {
	return original.NewSoftwareUpdateConfigurationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSourceControlClient(subscriptionID string) SourceControlClient {
	return original.NewSourceControlClient(subscriptionID)
}
func NewSourceControlClientWithBaseURI(baseURI string, subscriptionID string) SourceControlClient {
	return original.NewSourceControlClientWithBaseURI(baseURI, subscriptionID)
}
func NewSourceControlSyncJobClient(subscriptionID string) SourceControlSyncJobClient {
	return original.NewSourceControlSyncJobClient(subscriptionID)
}
func NewSourceControlSyncJobClientWithBaseURI(baseURI string, subscriptionID string) SourceControlSyncJobClient {
	return original.NewSourceControlSyncJobClientWithBaseURI(baseURI, subscriptionID)
}
func NewSourceControlSyncJobStreamsClient(subscriptionID string) SourceControlSyncJobStreamsClient {
	return original.NewSourceControlSyncJobStreamsClient(subscriptionID)
}
func NewSourceControlSyncJobStreamsClientWithBaseURI(baseURI string, subscriptionID string) SourceControlSyncJobStreamsClient {
	return original.NewSourceControlSyncJobStreamsClientWithBaseURI(baseURI, subscriptionID)
}
func NewStatisticsClient(subscriptionID string) StatisticsClient {
	return original.NewStatisticsClient(subscriptionID)
}
func NewStatisticsClientWithBaseURI(baseURI string, subscriptionID string) StatisticsClient {
	return original.NewStatisticsClientWithBaseURI(baseURI, subscriptionID)
}
func NewTestJobClient(subscriptionID string) TestJobClient {
	return original.NewTestJobClient(subscriptionID)
}
func NewTestJobClientWithBaseURI(baseURI string, subscriptionID string) TestJobClient {
	return original.NewTestJobClientWithBaseURI(baseURI, subscriptionID)
}
func NewTestJobStreamsClient(subscriptionID string) TestJobStreamsClient {
	return original.NewTestJobStreamsClient(subscriptionID)
}
func NewTestJobStreamsClientWithBaseURI(baseURI string, subscriptionID string) TestJobStreamsClient {
	return original.NewTestJobStreamsClientWithBaseURI(baseURI, subscriptionID)
}
func NewUsagesClient(subscriptionID string) UsagesClient {
	return original.NewUsagesClient(subscriptionID)
}
func NewUsagesClientWithBaseURI(baseURI string, subscriptionID string) UsagesClient {
	return original.NewUsagesClientWithBaseURI(baseURI, subscriptionID)
}
func NewVariableClient(subscriptionID string) VariableClient {
	return original.NewVariableClient(subscriptionID)
}
func NewVariableClientWithBaseURI(baseURI string, subscriptionID string) VariableClient {
	return original.NewVariableClientWithBaseURI(baseURI, subscriptionID)
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
func NewWebhookClient(subscriptionID string) WebhookClient {
	return original.NewWebhookClient(subscriptionID)
}
func NewWebhookClientWithBaseURI(baseURI string, subscriptionID string) WebhookClient {
	return original.NewWebhookClientWithBaseURI(baseURI, subscriptionID)
}
