/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by protoc-gen-go. DO NOT EDIT.
// source: summarizer_service.proto

package summarizer_service

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	grpc "google.golang.org/grpc"
	response "k8s.io/test-infra/testgrid/cmd/summarizer/response"
	summary "k8s.io/test-infra/testgrid/summary"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type SummarizerRequest struct {
	// The response returned from updater collected test results.
	Response             *response.Response `protobuf:"bytes,1,opt,name=response,proto3" json:"response,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *SummarizerRequest) Reset()         { *m = SummarizerRequest{} }
func (m *SummarizerRequest) String() string { return proto.CompactTextString(m) }
func (*SummarizerRequest) ProtoMessage()    {}
func (*SummarizerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1f57e5f2d5bc19a3, []int{0}
}

func (m *SummarizerRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SummarizerRequest.Unmarshal(m, b)
}
func (m *SummarizerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SummarizerRequest.Marshal(b, m, deterministic)
}
func (m *SummarizerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SummarizerRequest.Merge(m, src)
}
func (m *SummarizerRequest) XXX_Size() int {
	return xxx_messageInfo_SummarizerRequest.Size(m)
}
func (m *SummarizerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SummarizerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SummarizerRequest proto.InternalMessageInfo

func (m *SummarizerRequest) GetResponse() *response.Response {
	if m != nil {
		return m.Response
	}
	return nil
}

type SummarizerResponse struct {
	// The Dashboard Tab Summary object that is translated by the summarizer.
	DashboardTabSummary  *summary.DashboardTabSummary `protobuf:"bytes,1,opt,name=dashboard_tab_summary,json=dashboardTabSummary,proto3" json:"dashboard_tab_summary,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *SummarizerResponse) Reset()         { *m = SummarizerResponse{} }
func (m *SummarizerResponse) String() string { return proto.CompactTextString(m) }
func (*SummarizerResponse) ProtoMessage()    {}
func (*SummarizerResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1f57e5f2d5bc19a3, []int{1}
}

func (m *SummarizerResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SummarizerResponse.Unmarshal(m, b)
}
func (m *SummarizerResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SummarizerResponse.Marshal(b, m, deterministic)
}
func (m *SummarizerResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SummarizerResponse.Merge(m, src)
}
func (m *SummarizerResponse) XXX_Size() int {
	return xxx_messageInfo_SummarizerResponse.Size(m)
}
func (m *SummarizerResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SummarizerResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SummarizerResponse proto.InternalMessageInfo

func (m *SummarizerResponse) GetDashboardTabSummary() *summary.DashboardTabSummary {
	if m != nil {
		return m.DashboardTabSummary
	}
	return nil
}

func init() {
	proto.RegisterType((*SummarizerRequest)(nil), "SummarizerRequest")
	proto.RegisterType((*SummarizerResponse)(nil), "SummarizerResponse")
}

func init() { proto.RegisterFile("summarizer_service.proto", fileDescriptor_1f57e5f2d5bc19a3) }

var fileDescriptor_1f57e5f2d5bc19a3 = []byte{
	// 209 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe2, 0x92, 0x28, 0x2e, 0xcd, 0xcd,
	0x4d, 0x2c, 0xca, 0xac, 0x4a, 0x2d, 0x8a, 0x2f, 0x4e, 0x2d, 0x2a, 0xcb, 0x4c, 0x4e, 0xd5, 0x2b,
	0x28, 0xca, 0x2f, 0xc9, 0x97, 0x92, 0x2b, 0x49, 0x2d, 0x2e, 0x49, 0x2f, 0xca, 0x4c, 0xd1, 0x87,
	0x28, 0xa9, 0x84, 0xd1, 0x50, 0x79, 0x1d, 0xb8, 0x7c, 0x72, 0x2e, 0x4c, 0x0d, 0xc8, 0x18, 0xfd,
	0xa2, 0xd4, 0xe2, 0x82, 0xfc, 0xbc, 0xe2, 0x54, 0xfd, 0x92, 0xca, 0x82, 0xd4, 0x62, 0x88, 0x6a,
	0x25, 0x2b, 0x2e, 0xc1, 0x60, 0xb8, 0x92, 0xa0, 0xd4, 0xc2, 0xd2, 0xd4, 0xe2, 0x12, 0x21, 0x55,
	0x2e, 0x0e, 0x98, 0x62, 0x09, 0x46, 0x05, 0x46, 0x0d, 0x6e, 0x23, 0x4e, 0xbd, 0x20, 0xa8, 0x40,
	0x10, 0x5c, 0x4a, 0x29, 0x8e, 0x4b, 0x08, 0x59, 0x2f, 0x44, 0x54, 0xc8, 0x83, 0x4b, 0x34, 0x25,
	0xb1, 0x38, 0x23, 0x29, 0x3f, 0xb1, 0x28, 0x25, 0xbe, 0x24, 0x31, 0x29, 0x1e, 0xea, 0x3c, 0xa8,
	0x49, 0x22, 0x7a, 0x2e, 0x30, 0xd9, 0x90, 0xc4, 0x24, 0x88, 0xfe, 0xca, 0x20, 0xe1, 0x14, 0x4c,
	0x41, 0x23, 0x1f, 0x64, 0xb7, 0x05, 0x43, 0x02, 0x41, 0xc8, 0x9c, 0x8b, 0xcb, 0x3d, 0xb5, 0x04,
	0xaa, 0x44, 0x48, 0x48, 0x0f, 0xc3, 0xf5, 0x52, 0xc2, 0x7a, 0x98, 0xae, 0x52, 0x62, 0x48, 0x62,
	0x03, 0x7b, 0xd8, 0x18, 0x10, 0x00, 0x00, 0xff, 0xff, 0x11, 0x78, 0xe5, 0xee, 0x5a, 0x01, 0x00,
	0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// SummarizerServiceClient is the client API for SummarizerService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SummarizerServiceClient interface {
	GetSummary(ctx context.Context, in *SummarizerRequest, opts ...grpc.CallOption) (*SummarizerResponse, error)
}

type summarizerServiceClient struct {
	cc *grpc.ClientConn
}

func NewSummarizerServiceClient(cc *grpc.ClientConn) SummarizerServiceClient {
	return &summarizerServiceClient{cc}
}

func (c *summarizerServiceClient) GetSummary(ctx context.Context, in *SummarizerRequest, opts ...grpc.CallOption) (*SummarizerResponse, error) {
	out := new(SummarizerResponse)
	err := c.cc.Invoke(ctx, "/SummarizerService/GetSummary", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SummarizerServiceServer is the server API for SummarizerService service.
type SummarizerServiceServer interface {
	GetSummary(context.Context, *SummarizerRequest) (*SummarizerResponse, error)
}

func RegisterSummarizerServiceServer(s *grpc.Server, srv SummarizerServiceServer) {
	s.RegisterService(&_SummarizerService_serviceDesc, srv)
}

func _SummarizerService_GetSummary_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SummarizerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SummarizerServiceServer).GetSummary(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/SummarizerService/GetSummary",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SummarizerServiceServer).GetSummary(ctx, req.(*SummarizerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SummarizerService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "SummarizerService",
	HandlerType: (*SummarizerServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetSummary",
			Handler:    _SummarizerService_GetSummary_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "summarizer_service.proto",
}
