// +build go1.9

// Copyright 2018 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package account

import original "github.com/Azure/azure-sdk-for-go/services/preview/datalake/store/mgmt/2015-10-01-preview/account"

type Client = original.Client

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type BaseClient = original.BaseClient
type DataLakeStoreAccountState = original.DataLakeStoreAccountState

const (
	Active    DataLakeStoreAccountState = original.Active
	Suspended DataLakeStoreAccountState = original.Suspended
)

type DataLakeStoreAccountStatus = original.DataLakeStoreAccountStatus

const (
	Creating   DataLakeStoreAccountStatus = original.Creating
	Deleted    DataLakeStoreAccountStatus = original.Deleted
	Deleting   DataLakeStoreAccountStatus = original.Deleting
	Failed     DataLakeStoreAccountStatus = original.Failed
	Patching   DataLakeStoreAccountStatus = original.Patching
	Resuming   DataLakeStoreAccountStatus = original.Resuming
	Running    DataLakeStoreAccountStatus = original.Running
	Succeeded  DataLakeStoreAccountStatus = original.Succeeded
	Suspending DataLakeStoreAccountStatus = original.Suspending
)

type EncryptionConfigType = original.EncryptionConfigType

const (
	ServiceManaged EncryptionConfigType = original.ServiceManaged
	UserManaged    EncryptionConfigType = original.UserManaged
)

type EncryptionIdentityType = original.EncryptionIdentityType

const (
	SystemAssigned EncryptionIdentityType = original.SystemAssigned
)

type EncryptionProvisioningState = original.EncryptionProvisioningState

const (
	EncryptionProvisioningStateCreating  EncryptionProvisioningState = original.EncryptionProvisioningStateCreating
	EncryptionProvisioningStateSucceeded EncryptionProvisioningState = original.EncryptionProvisioningStateSucceeded
)

type EncryptionState = original.EncryptionState

const (
	Disabled EncryptionState = original.Disabled
	Enabled  EncryptionState = original.Enabled
)

type OperationStatus = original.OperationStatus

const (
	OperationStatusFailed     OperationStatus = original.OperationStatusFailed
	OperationStatusInProgress OperationStatus = original.OperationStatusInProgress
	OperationStatusSucceeded  OperationStatus = original.OperationStatusSucceeded
)

type AzureAsyncOperationResult = original.AzureAsyncOperationResult
type CreateFuture = original.CreateFuture
type DataLakeStoreAccount = original.DataLakeStoreAccount
type DataLakeStoreAccountListResult = original.DataLakeStoreAccountListResult
type DataLakeStoreAccountListResultIterator = original.DataLakeStoreAccountListResultIterator
type DataLakeStoreAccountListResultPage = original.DataLakeStoreAccountListResultPage
type DataLakeStoreAccountProperties = original.DataLakeStoreAccountProperties
type DataLakeStoreFirewallRuleListResult = original.DataLakeStoreFirewallRuleListResult
type DataLakeStoreFirewallRuleListResultIterator = original.DataLakeStoreFirewallRuleListResultIterator
type DataLakeStoreFirewallRuleListResultPage = original.DataLakeStoreFirewallRuleListResultPage
type DeleteFuture = original.DeleteFuture
type EncryptionConfig = original.EncryptionConfig
type EncryptionIdentity = original.EncryptionIdentity
type Error = original.Error
type ErrorDetails = original.ErrorDetails
type FirewallRule = original.FirewallRule
type FirewallRuleProperties = original.FirewallRuleProperties
type InnerError = original.InnerError
type KeyVaultMetaInfo = original.KeyVaultMetaInfo
type UpdateFuture = original.UpdateFuture

func NewClient(subscriptionID string) Client {
	return original.NewClient(subscriptionID)
}
func NewClientWithBaseURI(baseURI string, subscriptionID string) Client {
	return original.NewClientWithBaseURI(baseURI, subscriptionID)
}
func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleDataLakeStoreAccountStateValues() []DataLakeStoreAccountState {
	return original.PossibleDataLakeStoreAccountStateValues()
}
func PossibleDataLakeStoreAccountStatusValues() []DataLakeStoreAccountStatus {
	return original.PossibleDataLakeStoreAccountStatusValues()
}
func PossibleEncryptionConfigTypeValues() []EncryptionConfigType {
	return original.PossibleEncryptionConfigTypeValues()
}
func PossibleEncryptionIdentityTypeValues() []EncryptionIdentityType {
	return original.PossibleEncryptionIdentityTypeValues()
}
func PossibleEncryptionProvisioningStateValues() []EncryptionProvisioningState {
	return original.PossibleEncryptionProvisioningStateValues()
}
func PossibleEncryptionStateValues() []EncryptionState {
	return original.PossibleEncryptionStateValues()
}
func PossibleOperationStatusValues() []OperationStatus {
	return original.PossibleOperationStatusValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
