// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: master/master.proto

/*
	Package master is a generated protocol buffer package.

	It is generated from these files:
		master/master.proto

	It has these top-level messages:
		Call
		Response
		Event
*/
package master

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import mesos "github.com/mesos/mesos-go/api/v1/lib"
import _ "github.com/mesos/mesos-go/api/v1/lib/allocator"
import mesos_maintenance "github.com/mesos/mesos-go/api/v1/lib/maintenance"
import mesos_quota "github.com/mesos/mesos-go/api/v1/lib/quota"
import _ "github.com/gogo/protobuf/gogoproto"

import strconv "strconv"

import bytes "bytes"

import strings "strings"
import reflect "reflect"

import github_com_gogo_protobuf_proto "github.com/gogo/protobuf/proto"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type Call_Type int32

const (
	// If a call of type `Call::FOO` requires additional parameters they can be
	// included in the corresponding `Call::Foo` message. Similarly, if a call
	// receives a synchronous response it will be returned as a `Response`
	// message of type `Response::FOO`. Currently all calls except
	// `Call::SUBSCRIBE` receive synchronous responses; `Call::SUBSCRIBE` returns
	// a streaming response of `Event`.
	Call_UNKNOWN             Call_Type = 0
	Call_GET_HEALTH          Call_Type = 1
	Call_GET_FLAGS           Call_Type = 2
	Call_GET_VERSION         Call_Type = 3
	Call_GET_METRICS         Call_Type = 4
	Call_GET_LOGGING_LEVEL   Call_Type = 5
	Call_SET_LOGGING_LEVEL   Call_Type = 6
	Call_LIST_FILES          Call_Type = 7
	Call_READ_FILE           Call_Type = 8
	Call_GET_STATE           Call_Type = 9
	Call_GET_AGENTS          Call_Type = 10
	Call_GET_FRAMEWORKS      Call_Type = 11
	Call_GET_EXECUTORS       Call_Type = 12
	Call_GET_TASKS           Call_Type = 13
	Call_GET_ROLES           Call_Type = 14
	Call_GET_WEIGHTS         Call_Type = 15
	Call_UPDATE_WEIGHTS      Call_Type = 16
	Call_GET_MASTER          Call_Type = 17
	Call_SUBSCRIBE           Call_Type = 18
	Call_RESERVE_RESOURCES   Call_Type = 19
	Call_UNRESERVE_RESOURCES Call_Type = 20
	Call_CREATE_VOLUMES      Call_Type = 21
	Call_DESTROY_VOLUMES     Call_Type = 22
	// Retrieves the cluster's maintenance status.
	Call_GET_MAINTENANCE_STATUS Call_Type = 23
	// Retrieves the cluster's maintenance schedule.
	Call_GET_MAINTENANCE_SCHEDULE    Call_Type = 24
	Call_UPDATE_MAINTENANCE_SCHEDULE Call_Type = 25
	Call_START_MAINTENANCE           Call_Type = 26
	Call_STOP_MAINTENANCE            Call_Type = 27
	Call_GET_QUOTA                   Call_Type = 28
	Call_SET_QUOTA                   Call_Type = 29
	Call_REMOVE_QUOTA                Call_Type = 30
	Call_TEARDOWN                    Call_Type = 31
	Call_MARK_AGENT_GONE             Call_Type = 32
)

var Call_Type_name = map[int32]string{
	0:  "UNKNOWN",
	1:  "GET_HEALTH",
	2:  "GET_FLAGS",
	3:  "GET_VERSION",
	4:  "GET_METRICS",
	5:  "GET_LOGGING_LEVEL",
	6:  "SET_LOGGING_LEVEL",
	7:  "LIST_FILES",
	8:  "READ_FILE",
	9:  "GET_STATE",
	10: "GET_AGENTS",
	11: "GET_FRAMEWORKS",
	12: "GET_EXECUTORS",
	13: "GET_TASKS",
	14: "GET_ROLES",
	15: "GET_WEIGHTS",
	16: "UPDATE_WEIGHTS",
	17: "GET_MASTER",
	18: "SUBSCRIBE",
	19: "RESERVE_RESOURCES",
	20: "UNRESERVE_RESOURCES",
	21: "CREATE_VOLUMES",
	22: "DESTROY_VOLUMES",
	23: "GET_MAINTENANCE_STATUS",
	24: "GET_MAINTENANCE_SCHEDULE",
	25: "UPDATE_MAINTENANCE_SCHEDULE",
	26: "START_MAINTENANCE",
	27: "STOP_MAINTENANCE",
	28: "GET_QUOTA",
	29: "SET_QUOTA",
	30: "REMOVE_QUOTA",
	31: "TEARDOWN",
	32: "MARK_AGENT_GONE",
}
var Call_Type_value = map[string]int32{
	"UNKNOWN":                     0,
	"GET_HEALTH":                  1,
	"GET_FLAGS":                   2,
	"GET_VERSION":                 3,
	"GET_METRICS":                 4,
	"GET_LOGGING_LEVEL":           5,
	"SET_LOGGING_LEVEL":           6,
	"LIST_FILES":                  7,
	"READ_FILE":                   8,
	"GET_STATE":                   9,
	"GET_AGENTS":                  10,
	"GET_FRAMEWORKS":              11,
	"GET_EXECUTORS":               12,
	"GET_TASKS":                   13,
	"GET_ROLES":                   14,
	"GET_WEIGHTS":                 15,
	"UPDATE_WEIGHTS":              16,
	"GET_MASTER":                  17,
	"SUBSCRIBE":                   18,
	"RESERVE_RESOURCES":           19,
	"UNRESERVE_RESOURCES":         20,
	"CREATE_VOLUMES":              21,
	"DESTROY_VOLUMES":             22,
	"GET_MAINTENANCE_STATUS":      23,
	"GET_MAINTENANCE_SCHEDULE":    24,
	"UPDATE_MAINTENANCE_SCHEDULE": 25,
	"START_MAINTENANCE":           26,
	"STOP_MAINTENANCE":            27,
	"GET_QUOTA":                   28,
	"SET_QUOTA":                   29,
	"REMOVE_QUOTA":                30,
	"TEARDOWN":                    31,
	"MARK_AGENT_GONE":             32,
}

func (x Call_Type) Enum() *Call_Type {
	p := new(Call_Type)
	*p = x
	return p
}
func (x Call_Type) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(Call_Type_name, int32(x))
}
func (x *Call_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Call_Type_value, data, "Call_Type")
	if err != nil {
		return err
	}
	*x = Call_Type(value)
	return nil
}
func (Call_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptorMaster, []int{0, 0} }

// Each of the responses of type `FOO` corresponds to `Foo` message below.
type Response_Type int32

const (
	Response_UNKNOWN                  Response_Type = 0
	Response_GET_HEALTH               Response_Type = 1
	Response_GET_FLAGS                Response_Type = 2
	Response_GET_VERSION              Response_Type = 3
	Response_GET_METRICS              Response_Type = 4
	Response_GET_LOGGING_LEVEL        Response_Type = 5
	Response_LIST_FILES               Response_Type = 6
	Response_READ_FILE                Response_Type = 7
	Response_GET_STATE                Response_Type = 8
	Response_GET_AGENTS               Response_Type = 9
	Response_GET_FRAMEWORKS           Response_Type = 10
	Response_GET_EXECUTORS            Response_Type = 11
	Response_GET_TASKS                Response_Type = 12
	Response_GET_ROLES                Response_Type = 13
	Response_GET_WEIGHTS              Response_Type = 14
	Response_GET_MASTER               Response_Type = 15
	Response_GET_MAINTENANCE_STATUS   Response_Type = 16
	Response_GET_MAINTENANCE_SCHEDULE Response_Type = 17
	Response_GET_QUOTA                Response_Type = 18
)

var Response_Type_name = map[int32]string{
	0:  "UNKNOWN",
	1:  "GET_HEALTH",
	2:  "GET_FLAGS",
	3:  "GET_VERSION",
	4:  "GET_METRICS",
	5:  "GET_LOGGING_LEVEL",
	6:  "LIST_FILES",
	7:  "READ_FILE",
	8:  "GET_STATE",
	9:  "GET_AGENTS",
	10: "GET_FRAMEWORKS",
	11: "GET_EXECUTORS",
	12: "GET_TASKS",
	13: "GET_ROLES",
	14: "GET_WEIGHTS",
	15: "GET_MASTER",
	16: "GET_MAINTENANCE_STATUS",
	17: "GET_MAINTENANCE_SCHEDULE",
	18: "GET_QUOTA",
}
var Response_Type_value = map[string]int32{
	"UNKNOWN":                  0,
	"GET_HEALTH":               1,
	"GET_FLAGS":                2,
	"GET_VERSION":              3,
	"GET_METRICS":              4,
	"GET_LOGGING_LEVEL":        5,
	"LIST_FILES":               6,
	"READ_FILE":                7,
	"GET_STATE":                8,
	"GET_AGENTS":               9,
	"GET_FRAMEWORKS":           10,
	"GET_EXECUTORS":            11,
	"GET_TASKS":                12,
	"GET_ROLES":                13,
	"GET_WEIGHTS":              14,
	"GET_MASTER":               15,
	"GET_MAINTENANCE_STATUS":   16,
	"GET_MAINTENANCE_SCHEDULE": 17,
	"GET_QUOTA":                18,
}

func (x Response_Type) Enum() *Response_Type {
	p := new(Response_Type)
	*p = x
	return p
}
func (x Response_Type) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(Response_Type_name, int32(x))
}
func (x *Response_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Response_Type_value, data, "Response_Type")
	if err != nil {
		return err
	}
	*x = Response_Type(value)
	return nil
}
func (Response_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptorMaster, []int{1, 0} }

type Event_Type int32

const (
	Event_UNKNOWN           Event_Type = 0
	Event_SUBSCRIBED        Event_Type = 1
	Event_TASK_ADDED        Event_Type = 2
	Event_TASK_UPDATED      Event_Type = 3
	Event_AGENT_ADDED       Event_Type = 4
	Event_AGENT_REMOVED     Event_Type = 5
	Event_FRAMEWORK_ADDED   Event_Type = 6
	Event_FRAMEWORK_UPDATED Event_Type = 7
	Event_FRAMEWORK_REMOVED Event_Type = 8
	// Periodic message sent by the master to the subscriber according to
	// 'Subscribed.heartbeat_interval_seconds'. If the subscriber does not
	// receive any events (including heartbeats) for an extended period of
	// time (e.g., 5 x heartbeat_interval_seconds), it is likely that the
	// connection is lost or there is a network partition. In that case,
	// the subscriber should close the existing subscription connection and
	// resubscribe using a backoff strategy.
	Event_HEARTBEAT Event_Type = 9
)

var Event_Type_name = map[int32]string{
	0: "UNKNOWN",
	1: "SUBSCRIBED",
	2: "TASK_ADDED",
	3: "TASK_UPDATED",
	4: "AGENT_ADDED",
	5: "AGENT_REMOVED",
	6: "FRAMEWORK_ADDED",
	7: "FRAMEWORK_UPDATED",
	8: "FRAMEWORK_REMOVED",
	9: "HEARTBEAT",
}
var Event_Type_value = map[string]int32{
	"UNKNOWN":           0,
	"SUBSCRIBED":        1,
	"TASK_ADDED":        2,
	"TASK_UPDATED":      3,
	"AGENT_ADDED":       4,
	"AGENT_REMOVED":     5,
	"FRAMEWORK_ADDED":   6,
	"FRAMEWORK_UPDATED": 7,
	"FRAMEWORK_REMOVED": 8,
	"HEARTBEAT":         9,
}

func (x Event_Type) Enum() *Event_Type {
	p := new(Event_Type)
	*p = x
	return p
}
func (x Event_Type) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(Event_Type_name, int32(x))
}
func (x *Event_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Event_Type_value, data, "Event_Type")
	if err != nil {
		return err
	}
	*x = Event_Type(value)
	return nil
}
func (Event_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptorMaster, []int{2, 0} }

// *
// Calls that can be sent to the v1 master API.
//
// A call is described using the standard protocol buffer "union"
// trick, see
// https://developers.google.com/protocol-buffers/docs/techniques#union.
type Call struct {
	Type                      Call_Type                       `protobuf:"varint,1,opt,name=type,enum=mesos.master.Call_Type" json:"type"`
	GetMetrics                *Call_GetMetrics                `protobuf:"bytes,2,opt,name=get_metrics,json=getMetrics" json:"get_metrics,omitempty"`
	SetLoggingLevel           *Call_SetLoggingLevel           `protobuf:"bytes,3,opt,name=set_logging_level,json=setLoggingLevel" json:"set_logging_level,omitempty"`
	ListFiles                 *Call_ListFiles                 `protobuf:"bytes,4,opt,name=list_files,json=listFiles" json:"list_files,omitempty"`
	ReadFile                  *Call_ReadFile                  `protobuf:"bytes,5,opt,name=read_file,json=readFile" json:"read_file,omitempty"`
	UpdateWeights             *Call_UpdateWeights             `protobuf:"bytes,6,opt,name=update_weights,json=updateWeights" json:"update_weights,omitempty"`
	ReserveResources          *Call_ReserveResources          `protobuf:"bytes,7,opt,name=reserve_resources,json=reserveResources" json:"reserve_resources,omitempty"`
	UnreserveResources        *Call_UnreserveResources        `protobuf:"bytes,8,opt,name=unreserve_resources,json=unreserveResources" json:"unreserve_resources,omitempty"`
	CreateVolumes             *Call_CreateVolumes             `protobuf:"bytes,9,opt,name=create_volumes,json=createVolumes" json:"create_volumes,omitempty"`
	DestroyVolumes            *Call_DestroyVolumes            `protobuf:"bytes,10,opt,name=destroy_volumes,json=destroyVolumes" json:"destroy_volumes,omitempty"`
	UpdateMaintenanceSchedule *Call_UpdateMaintenanceSchedule `protobuf:"bytes,11,opt,name=update_maintenance_schedule,json=updateMaintenanceSchedule" json:"update_maintenance_schedule,omitempty"`
	StartMaintenance          *Call_StartMaintenance          `protobuf:"bytes,12,opt,name=start_maintenance,json=startMaintenance" json:"start_maintenance,omitempty"`
	StopMaintenance           *Call_StopMaintenance           `protobuf:"bytes,13,opt,name=stop_maintenance,json=stopMaintenance" json:"stop_maintenance,omitempty"`
	SetQuota                  *Call_SetQuota                  `protobuf:"bytes,14,opt,name=set_quota,json=setQuota" json:"set_quota,omitempty"`
	RemoveQuota               *Call_RemoveQuota               `protobuf:"bytes,15,opt,name=remove_quota,json=removeQuota" json:"remove_quota,omitempty"`
	Teardown                  *Call_Teardown                  `protobuf:"bytes,16,opt,name=teardown" json:"teardown,omitempty"`
	MarkAgentGone             *Call_MarkAgentGone             `protobuf:"bytes,17,opt,name=mark_agent_gone,json=markAgentGone" json:"mark_agent_gone,omitempty"`
}

func (m *Call) Reset()                    { *m = Call{} }
func (*Call) ProtoMessage()               {}
func (*Call) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{0} }

func (m *Call) GetType() Call_Type {
	if m != nil {
		return m.Type
	}
	return Call_UNKNOWN
}

func (m *Call) GetGetMetrics() *Call_GetMetrics {
	if m != nil {
		return m.GetMetrics
	}
	return nil
}

func (m *Call) GetSetLoggingLevel() *Call_SetLoggingLevel {
	if m != nil {
		return m.SetLoggingLevel
	}
	return nil
}

func (m *Call) GetListFiles() *Call_ListFiles {
	if m != nil {
		return m.ListFiles
	}
	return nil
}

func (m *Call) GetReadFile() *Call_ReadFile {
	if m != nil {
		return m.ReadFile
	}
	return nil
}

func (m *Call) GetUpdateWeights() *Call_UpdateWeights {
	if m != nil {
		return m.UpdateWeights
	}
	return nil
}

func (m *Call) GetReserveResources() *Call_ReserveResources {
	if m != nil {
		return m.ReserveResources
	}
	return nil
}

func (m *Call) GetUnreserveResources() *Call_UnreserveResources {
	if m != nil {
		return m.UnreserveResources
	}
	return nil
}

func (m *Call) GetCreateVolumes() *Call_CreateVolumes {
	if m != nil {
		return m.CreateVolumes
	}
	return nil
}

func (m *Call) GetDestroyVolumes() *Call_DestroyVolumes {
	if m != nil {
		return m.DestroyVolumes
	}
	return nil
}

func (m *Call) GetUpdateMaintenanceSchedule() *Call_UpdateMaintenanceSchedule {
	if m != nil {
		return m.UpdateMaintenanceSchedule
	}
	return nil
}

func (m *Call) GetStartMaintenance() *Call_StartMaintenance {
	if m != nil {
		return m.StartMaintenance
	}
	return nil
}

func (m *Call) GetStopMaintenance() *Call_StopMaintenance {
	if m != nil {
		return m.StopMaintenance
	}
	return nil
}

func (m *Call) GetSetQuota() *Call_SetQuota {
	if m != nil {
		return m.SetQuota
	}
	return nil
}

func (m *Call) GetRemoveQuota() *Call_RemoveQuota {
	if m != nil {
		return m.RemoveQuota
	}
	return nil
}

func (m *Call) GetTeardown() *Call_Teardown {
	if m != nil {
		return m.Teardown
	}
	return nil
}

func (m *Call) GetMarkAgentGone() *Call_MarkAgentGone {
	if m != nil {
		return m.MarkAgentGone
	}
	return nil
}

// Provides a snapshot of the current metrics tracked by the master.
type Call_GetMetrics struct {
	// If set, `timeout` would be used to determines the maximum amount of time
	// the API will take to respond. If the timeout is exceeded, some metrics
	// may not be included in the response.
	Timeout *mesos.DurationInfo `protobuf:"bytes,1,opt,name=timeout" json:"timeout,omitempty"`
}

func (m *Call_GetMetrics) Reset()                    { *m = Call_GetMetrics{} }
func (*Call_GetMetrics) ProtoMessage()               {}
func (*Call_GetMetrics) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{0, 0} }

func (m *Call_GetMetrics) GetTimeout() *mesos.DurationInfo {
	if m != nil {
		return m.Timeout
	}
	return nil
}

// Sets the logging verbosity level for a specified duration. Mesos uses
// [glog](https://github.com/google/glog) for logging. The library only uses
// verbose logging which means nothing will be output unless the verbosity
// level is set (by default it's 0, libprocess uses levels 1, 2, and 3).
type Call_SetLoggingLevel struct {
	// The verbosity level.
	Level uint32 `protobuf:"varint,1,req,name=level" json:"level"`
	// The duration to keep verbosity level toggled. After this duration, the
	// verbosity level of log would revert to the original level.
	Duration mesos.DurationInfo `protobuf:"bytes,2,req,name=duration" json:"duration"`
}

func (m *Call_SetLoggingLevel) Reset()                    { *m = Call_SetLoggingLevel{} }
func (*Call_SetLoggingLevel) ProtoMessage()               {}
func (*Call_SetLoggingLevel) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{0, 1} }

func (m *Call_SetLoggingLevel) GetLevel() uint32 {
	if m != nil {
		return m.Level
	}
	return 0
}

func (m *Call_SetLoggingLevel) GetDuration() mesos.DurationInfo {
	if m != nil {
		return m.Duration
	}
	return mesos.DurationInfo{}
}

// Provides the file listing for a directory.
type Call_ListFiles struct {
	Path string `protobuf:"bytes,1,req,name=path" json:"path"`
}

func (m *Call_ListFiles) Reset()                    { *m = Call_ListFiles{} }
func (*Call_ListFiles) ProtoMessage()               {}
func (*Call_ListFiles) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{0, 2} }

func (m *Call_ListFiles) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

// Reads data from a file.
type Call_ReadFile struct {
	// The path of file.
	Path string `protobuf:"bytes,1,req,name=path" json:"path"`
	// Initial offset in file to start reading from.
	Offset uint64 `protobuf:"varint,2,req,name=offset" json:"offset"`
	// The maximum number of bytes to read. The read length is capped at 16
	// memory pages.
	Length *uint64 `protobuf:"varint,3,opt,name=length" json:"length,omitempty"`
}

func (m *Call_ReadFile) Reset()                    { *m = Call_ReadFile{} }
func (*Call_ReadFile) ProtoMessage()               {}
func (*Call_ReadFile) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{0, 3} }

func (m *Call_ReadFile) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *Call_ReadFile) GetOffset() uint64 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *Call_ReadFile) GetLength() uint64 {
	if m != nil && m.Length != nil {
		return *m.Length
	}
	return 0
}

type Call_UpdateWeights struct {
	WeightInfos []mesos.WeightInfo `protobuf:"bytes,1,rep,name=weight_infos,json=weightInfos" json:"weight_infos"`
}

func (m *Call_UpdateWeights) Reset()                    { *m = Call_UpdateWeights{} }
func (*Call_UpdateWeights) ProtoMessage()               {}
func (*Call_UpdateWeights) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{0, 4} }

func (m *Call_UpdateWeights) GetWeightInfos() []mesos.WeightInfo {
	if m != nil {
		return m.WeightInfos
	}
	return nil
}

// Reserve resources dynamically on a specific agent.
type Call_ReserveResources struct {
	AgentID   mesos.AgentID    `protobuf:"bytes,1,req,name=agent_id,json=agentId" json:"agent_id"`
	Resources []mesos.Resource `protobuf:"bytes,2,rep,name=resources" json:"resources"`
}

func (m *Call_ReserveResources) Reset()                    { *m = Call_ReserveResources{} }
func (*Call_ReserveResources) ProtoMessage()               {}
func (*Call_ReserveResources) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{0, 5} }

func (m *Call_ReserveResources) GetAgentID() mesos.AgentID {
	if m != nil {
		return m.AgentID
	}
	return mesos.AgentID{}
}

func (m *Call_ReserveResources) GetResources() []mesos.Resource {
	if m != nil {
		return m.Resources
	}
	return nil
}

// Unreserve resources dynamically on a specific agent.
type Call_UnreserveResources struct {
	AgentID   mesos.AgentID    `protobuf:"bytes,1,req,name=agent_id,json=agentId" json:"agent_id"`
	Resources []mesos.Resource `protobuf:"bytes,2,rep,name=resources" json:"resources"`
}

func (m *Call_UnreserveResources) Reset()                    { *m = Call_UnreserveResources{} }
func (*Call_UnreserveResources) ProtoMessage()               {}
func (*Call_UnreserveResources) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{0, 6} }

func (m *Call_UnreserveResources) GetAgentID() mesos.AgentID {
	if m != nil {
		return m.AgentID
	}
	return mesos.AgentID{}
}

func (m *Call_UnreserveResources) GetResources() []mesos.Resource {
	if m != nil {
		return m.Resources
	}
	return nil
}

// Create persistent volumes on reserved resources. The request is forwarded
// asynchronously to the Mesos agent where the reserved resources are located.
// That asynchronous message may not be delivered or creating the volumes at
// the agent might fail. Volume creation can be verified by sending a
// `GET_VOLUMES` call.
type Call_CreateVolumes struct {
	AgentID mesos.AgentID    `protobuf:"bytes,1,req,name=agent_id,json=agentId" json:"agent_id"`
	Volumes []mesos.Resource `protobuf:"bytes,2,rep,name=volumes" json:"volumes"`
}

func (m *Call_CreateVolumes) Reset()                    { *m = Call_CreateVolumes{} }
func (*Call_CreateVolumes) ProtoMessage()               {}
func (*Call_CreateVolumes) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{0, 7} }

func (m *Call_CreateVolumes) GetAgentID() mesos.AgentID {
	if m != nil {
		return m.AgentID
	}
	return mesos.AgentID{}
}

func (m *Call_CreateVolumes) GetVolumes() []mesos.Resource {
	if m != nil {
		return m.Volumes
	}
	return nil
}

// Destroy persistent volumes. The request is forwarded asynchronously to the
// Mesos agent where the reserved resources are located. That asynchronous
// message may not be delivered or destroying the volumes at the agent might
// fail. Volume deletion can be verified by sending a `GET_VOLUMES` call.
type Call_DestroyVolumes struct {
	AgentID mesos.AgentID    `protobuf:"bytes,1,req,name=agent_id,json=agentId" json:"agent_id"`
	Volumes []mesos.Resource `protobuf:"bytes,2,rep,name=volumes" json:"volumes"`
}

func (m *Call_DestroyVolumes) Reset()                    { *m = Call_DestroyVolumes{} }
func (*Call_DestroyVolumes) ProtoMessage()               {}
func (*Call_DestroyVolumes) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{0, 8} }

func (m *Call_DestroyVolumes) GetAgentID() mesos.AgentID {
	if m != nil {
		return m.AgentID
	}
	return mesos.AgentID{}
}

func (m *Call_DestroyVolumes) GetVolumes() []mesos.Resource {
	if m != nil {
		return m.Volumes
	}
	return nil
}

// Updates the cluster's maintenance schedule.
type Call_UpdateMaintenanceSchedule struct {
	Schedule mesos_maintenance.Schedule `protobuf:"bytes,1,req,name=schedule" json:"schedule"`
}

func (m *Call_UpdateMaintenanceSchedule) Reset()      { *m = Call_UpdateMaintenanceSchedule{} }
func (*Call_UpdateMaintenanceSchedule) ProtoMessage() {}
func (*Call_UpdateMaintenanceSchedule) Descriptor() ([]byte, []int) {
	return fileDescriptorMaster, []int{0, 9}
}

func (m *Call_UpdateMaintenanceSchedule) GetSchedule() mesos_maintenance.Schedule {
	if m != nil {
		return m.Schedule
	}
	return mesos_maintenance.Schedule{}
}

// Starts the maintenance of the cluster, this would bring a set of machines
// down.
type Call_StartMaintenance struct {
	Machines []mesos.MachineID `protobuf:"bytes,1,rep,name=machines" json:"machines"`
}

func (m *Call_StartMaintenance) Reset()                    { *m = Call_StartMaintenance{} }
func (*Call_StartMaintenance) ProtoMessage()               {}
func (*Call_StartMaintenance) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{0, 10} }

func (m *Call_StartMaintenance) GetMachines() []mesos.MachineID {
	if m != nil {
		return m.Machines
	}
	return nil
}

// Stops the maintenance of the cluster, this would bring a set of machines
// back up.
type Call_StopMaintenance struct {
	Machines []mesos.MachineID `protobuf:"bytes,1,rep,name=machines" json:"machines"`
}

func (m *Call_StopMaintenance) Reset()                    { *m = Call_StopMaintenance{} }
func (*Call_StopMaintenance) ProtoMessage()               {}
func (*Call_StopMaintenance) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{0, 11} }

func (m *Call_StopMaintenance) GetMachines() []mesos.MachineID {
	if m != nil {
		return m.Machines
	}
	return nil
}

// Sets the quota for resources to be used by a particular role.
type Call_SetQuota struct {
	QuotaRequest mesos_quota.QuotaRequest `protobuf:"bytes,1,req,name=quota_request,json=quotaRequest" json:"quota_request"`
}

func (m *Call_SetQuota) Reset()                    { *m = Call_SetQuota{} }
func (*Call_SetQuota) ProtoMessage()               {}
func (*Call_SetQuota) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{0, 12} }

func (m *Call_SetQuota) GetQuotaRequest() mesos_quota.QuotaRequest {
	if m != nil {
		return m.QuotaRequest
	}
	return mesos_quota.QuotaRequest{}
}

type Call_RemoveQuota struct {
	Role string `protobuf:"bytes,1,req,name=role" json:"role"`
}

func (m *Call_RemoveQuota) Reset()                    { *m = Call_RemoveQuota{} }
func (*Call_RemoveQuota) ProtoMessage()               {}
func (*Call_RemoveQuota) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{0, 13} }

func (m *Call_RemoveQuota) GetRole() string {
	if m != nil {
		return m.Role
	}
	return ""
}

// Tears down a running framework by shutting down all tasks/executors and
// removing the framework.
type Call_Teardown struct {
	FrameworkID mesos.FrameworkID `protobuf:"bytes,1,req,name=framework_id,json=frameworkId" json:"framework_id"`
}

func (m *Call_Teardown) Reset()                    { *m = Call_Teardown{} }
func (*Call_Teardown) ProtoMessage()               {}
func (*Call_Teardown) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{0, 14} }

func (m *Call_Teardown) GetFrameworkID() mesos.FrameworkID {
	if m != nil {
		return m.FrameworkID
	}
	return mesos.FrameworkID{}
}

// Mark an agent as gone. This can be used by an operator to assert
// that the agent instance has failed and is never coming back (e.g.,
// ephemeral instance from cloud provider). The master would shutdown
// the agent and send 'TASK_GONE_BY_OPERATOR' updates for all the running
// tasks. The persistent volumes/reservations on the agent won't be
// accessible anymore.
//
// NOTE: It is possible that the tasks might still be running
// if the operator's assertion was wrong and the agent was partitioned
// away from the master. The agent would be shutdown when it tries to
// re-register with the master when the partition heals.
type Call_MarkAgentGone struct {
	AgentID mesos.AgentID `protobuf:"bytes,1,req,name=agent_id,json=agentId" json:"agent_id"`
}

func (m *Call_MarkAgentGone) Reset()                    { *m = Call_MarkAgentGone{} }
func (*Call_MarkAgentGone) ProtoMessage()               {}
func (*Call_MarkAgentGone) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{0, 15} }

func (m *Call_MarkAgentGone) GetAgentID() mesos.AgentID {
	if m != nil {
		return m.AgentID
	}
	return mesos.AgentID{}
}

// *
// Synchronous responses for all calls (except Call::SUBSCRIBE) made to
// the v1 master API.
type Response struct {
	Type                   Response_Type                    `protobuf:"varint,1,opt,name=type,enum=mesos.master.Response_Type" json:"type"`
	GetHealth              *Response_GetHealth              `protobuf:"bytes,2,opt,name=get_health,json=getHealth" json:"get_health,omitempty"`
	GetFlags               *Response_GetFlags               `protobuf:"bytes,3,opt,name=get_flags,json=getFlags" json:"get_flags,omitempty"`
	GetVersion             *Response_GetVersion             `protobuf:"bytes,4,opt,name=get_version,json=getVersion" json:"get_version,omitempty"`
	GetMetrics             *Response_GetMetrics             `protobuf:"bytes,5,opt,name=get_metrics,json=getMetrics" json:"get_metrics,omitempty"`
	GetLoggingLevel        *Response_GetLoggingLevel        `protobuf:"bytes,6,opt,name=get_logging_level,json=getLoggingLevel" json:"get_logging_level,omitempty"`
	ListFiles              *Response_ListFiles              `protobuf:"bytes,7,opt,name=list_files,json=listFiles" json:"list_files,omitempty"`
	ReadFile               *Response_ReadFile               `protobuf:"bytes,8,opt,name=read_file,json=readFile" json:"read_file,omitempty"`
	GetState               *Response_GetState               `protobuf:"bytes,9,opt,name=get_state,json=getState" json:"get_state,omitempty"`
	GetAgents              *Response_GetAgents              `protobuf:"bytes,10,opt,name=get_agents,json=getAgents" json:"get_agents,omitempty"`
	GetFrameworks          *Response_GetFrameworks          `protobuf:"bytes,11,opt,name=get_frameworks,json=getFrameworks" json:"get_frameworks,omitempty"`
	GetExecutors           *Response_GetExecutors           `protobuf:"bytes,12,opt,name=get_executors,json=getExecutors" json:"get_executors,omitempty"`
	GetTasks               *Response_GetTasks               `protobuf:"bytes,13,opt,name=get_tasks,json=getTasks" json:"get_tasks,omitempty"`
	GetRoles               *Response_GetRoles               `protobuf:"bytes,14,opt,name=get_roles,json=getRoles" json:"get_roles,omitempty"`
	GetWeights             *Response_GetWeights             `protobuf:"bytes,15,opt,name=get_weights,json=getWeights" json:"get_weights,omitempty"`
	GetMaster              *Response_GetMaster              `protobuf:"bytes,16,opt,name=get_master,json=getMaster" json:"get_master,omitempty"`
	GetMaintenanceStatus   *Response_GetMaintenanceStatus   `protobuf:"bytes,17,opt,name=get_maintenance_status,json=getMaintenanceStatus" json:"get_maintenance_status,omitempty"`
	GetMaintenanceSchedule *Response_GetMaintenanceSchedule `protobuf:"bytes,18,opt,name=get_maintenance_schedule,json=getMaintenanceSchedule" json:"get_maintenance_schedule,omitempty"`
	GetQuota               *Response_GetQuota               `protobuf:"bytes,19,opt,name=get_quota,json=getQuota" json:"get_quota,omitempty"`
}

func (m *Response) Reset()                    { *m = Response{} }
func (*Response) ProtoMessage()               {}
func (*Response) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{1} }

func (m *Response) GetType() Response_Type {
	if m != nil {
		return m.Type
	}
	return Response_UNKNOWN
}

func (m *Response) GetGetHealth() *Response_GetHealth {
	if m != nil {
		return m.GetHealth
	}
	return nil
}

func (m *Response) GetGetFlags() *Response_GetFlags {
	if m != nil {
		return m.GetFlags
	}
	return nil
}

func (m *Response) GetGetVersion() *Response_GetVersion {
	if m != nil {
		return m.GetVersion
	}
	return nil
}

func (m *Response) GetGetMetrics() *Response_GetMetrics {
	if m != nil {
		return m.GetMetrics
	}
	return nil
}

func (m *Response) GetGetLoggingLevel() *Response_GetLoggingLevel {
	if m != nil {
		return m.GetLoggingLevel
	}
	return nil
}

func (m *Response) GetListFiles() *Response_ListFiles {
	if m != nil {
		return m.ListFiles
	}
	return nil
}

func (m *Response) GetReadFile() *Response_ReadFile {
	if m != nil {
		return m.ReadFile
	}
	return nil
}

func (m *Response) GetGetState() *Response_GetState {
	if m != nil {
		return m.GetState
	}
	return nil
}

func (m *Response) GetGetAgents() *Response_GetAgents {
	if m != nil {
		return m.GetAgents
	}
	return nil
}

func (m *Response) GetGetFrameworks() *Response_GetFrameworks {
	if m != nil {
		return m.GetFrameworks
	}
	return nil
}

func (m *Response) GetGetExecutors() *Response_GetExecutors {
	if m != nil {
		return m.GetExecutors
	}
	return nil
}

func (m *Response) GetGetTasks() *Response_GetTasks {
	if m != nil {
		return m.GetTasks
	}
	return nil
}

func (m *Response) GetGetRoles() *Response_GetRoles {
	if m != nil {
		return m.GetRoles
	}
	return nil
}

func (m *Response) GetGetWeights() *Response_GetWeights {
	if m != nil {
		return m.GetWeights
	}
	return nil
}

func (m *Response) GetGetMaster() *Response_GetMaster {
	if m != nil {
		return m.GetMaster
	}
	return nil
}

func (m *Response) GetGetMaintenanceStatus() *Response_GetMaintenanceStatus {
	if m != nil {
		return m.GetMaintenanceStatus
	}
	return nil
}

func (m *Response) GetGetMaintenanceSchedule() *Response_GetMaintenanceSchedule {
	if m != nil {
		return m.GetMaintenanceSchedule
	}
	return nil
}

func (m *Response) GetGetQuota() *Response_GetQuota {
	if m != nil {
		return m.GetQuota
	}
	return nil
}

// `healthy` would be true if the master is healthy. Delayed responses are
// also indicative of the poor health of the master.
type Response_GetHealth struct {
	Healthy bool `protobuf:"varint,1,req,name=healthy" json:"healthy"`
}

func (m *Response_GetHealth) Reset()                    { *m = Response_GetHealth{} }
func (*Response_GetHealth) ProtoMessage()               {}
func (*Response_GetHealth) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{1, 0} }

func (m *Response_GetHealth) GetHealthy() bool {
	if m != nil {
		return m.Healthy
	}
	return false
}

// Contains the flag configuration of the master.
type Response_GetFlags struct {
	Flags []mesos.Flag `protobuf:"bytes,1,rep,name=flags" json:"flags"`
}

func (m *Response_GetFlags) Reset()                    { *m = Response_GetFlags{} }
func (*Response_GetFlags) ProtoMessage()               {}
func (*Response_GetFlags) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{1, 1} }

func (m *Response_GetFlags) GetFlags() []mesos.Flag {
	if m != nil {
		return m.Flags
	}
	return nil
}

// Contains the version information of the master.
type Response_GetVersion struct {
	VersionInfo mesos.VersionInfo `protobuf:"bytes,1,req,name=version_info,json=versionInfo" json:"version_info"`
}

func (m *Response_GetVersion) Reset()                    { *m = Response_GetVersion{} }
func (*Response_GetVersion) ProtoMessage()               {}
func (*Response_GetVersion) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{1, 2} }

func (m *Response_GetVersion) GetVersionInfo() mesos.VersionInfo {
	if m != nil {
		return m.VersionInfo
	}
	return mesos.VersionInfo{}
}

// Contains a snapshot of the current metrics.
type Response_GetMetrics struct {
	Metrics []mesos.Metric `protobuf:"bytes,1,rep,name=metrics" json:"metrics"`
}

func (m *Response_GetMetrics) Reset()                    { *m = Response_GetMetrics{} }
func (*Response_GetMetrics) ProtoMessage()               {}
func (*Response_GetMetrics) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{1, 3} }

func (m *Response_GetMetrics) GetMetrics() []mesos.Metric {
	if m != nil {
		return m.Metrics
	}
	return nil
}

// Contains the logging level of the master.
type Response_GetLoggingLevel struct {
	Level uint32 `protobuf:"varint,1,req,name=level" json:"level"`
}

func (m *Response_GetLoggingLevel) Reset()      { *m = Response_GetLoggingLevel{} }
func (*Response_GetLoggingLevel) ProtoMessage() {}
func (*Response_GetLoggingLevel) Descriptor() ([]byte, []int) {
	return fileDescriptorMaster, []int{1, 4}
}

func (m *Response_GetLoggingLevel) GetLevel() uint32 {
	if m != nil {
		return m.Level
	}
	return 0
}

// Contains the file listing(similar to `ls -l`) for a directory.
type Response_ListFiles struct {
	FileInfos []mesos.FileInfo `protobuf:"bytes,1,rep,name=file_infos,json=fileInfos" json:"file_infos"`
}

func (m *Response_ListFiles) Reset()                    { *m = Response_ListFiles{} }
func (*Response_ListFiles) ProtoMessage()               {}
func (*Response_ListFiles) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{1, 5} }

func (m *Response_ListFiles) GetFileInfos() []mesos.FileInfo {
	if m != nil {
		return m.FileInfos
	}
	return nil
}

// Contains the file data.
type Response_ReadFile struct {
	// The size of file (in bytes).
	Size uint64 `protobuf:"varint,1,req,name=size" json:"size"`
	Data []byte `protobuf:"bytes,2,req,name=data" json:"data,omitempty"`
}

func (m *Response_ReadFile) Reset()                    { *m = Response_ReadFile{} }
func (*Response_ReadFile) ProtoMessage()               {}
func (*Response_ReadFile) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{1, 6} }

func (m *Response_ReadFile) GetSize() uint64 {
	if m != nil {
		return m.Size
	}
	return 0
}

func (m *Response_ReadFile) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

// Contains full state of the master i.e. information about the tasks,
// agents, frameworks and executors running in the cluster.
type Response_GetState struct {
	GetTasks      *Response_GetTasks      `protobuf:"bytes,1,opt,name=get_tasks,json=getTasks" json:"get_tasks,omitempty"`
	GetExecutors  *Response_GetExecutors  `protobuf:"bytes,2,opt,name=get_executors,json=getExecutors" json:"get_executors,omitempty"`
	GetFrameworks *Response_GetFrameworks `protobuf:"bytes,3,opt,name=get_frameworks,json=getFrameworks" json:"get_frameworks,omitempty"`
	GetAgents     *Response_GetAgents     `protobuf:"bytes,4,opt,name=get_agents,json=getAgents" json:"get_agents,omitempty"`
}

func (m *Response_GetState) Reset()                    { *m = Response_GetState{} }
func (*Response_GetState) ProtoMessage()               {}
func (*Response_GetState) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{1, 7} }

func (m *Response_GetState) GetGetTasks() *Response_GetTasks {
	if m != nil {
		return m.GetTasks
	}
	return nil
}

func (m *Response_GetState) GetGetExecutors() *Response_GetExecutors {
	if m != nil {
		return m.GetExecutors
	}
	return nil
}

func (m *Response_GetState) GetGetFrameworks() *Response_GetFrameworks {
	if m != nil {
		return m.GetFrameworks
	}
	return nil
}

func (m *Response_GetState) GetGetAgents() *Response_GetAgents {
	if m != nil {
		return m.GetAgents
	}
	return nil
}

type Response_GetAgents struct {
	// Registered agents.
	Agents []Response_GetAgents_Agent `protobuf:"bytes,1,rep,name=agents" json:"agents"`
	// Agents which are recovered from registry but not reregistered yet.
	RecoveredAgents []mesos.AgentInfo `protobuf:"bytes,2,rep,name=recovered_agents,json=recoveredAgents" json:"recovered_agents"`
}

func (m *Response_GetAgents) Reset()                    { *m = Response_GetAgents{} }
func (*Response_GetAgents) ProtoMessage()               {}
func (*Response_GetAgents) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{1, 8} }

func (m *Response_GetAgents) GetAgents() []Response_GetAgents_Agent {
	if m != nil {
		return m.Agents
	}
	return nil
}

func (m *Response_GetAgents) GetRecoveredAgents() []mesos.AgentInfo {
	if m != nil {
		return m.RecoveredAgents
	}
	return nil
}

type Response_GetAgents_Agent struct {
	AgentInfo        mesos.AgentInfo `protobuf:"bytes,1,req,name=agent_info,json=agentInfo" json:"agent_info"`
	Active           bool            `protobuf:"varint,2,req,name=active" json:"active"`
	Version          string          `protobuf:"bytes,3,req,name=version" json:"version"`
	PID              *string         `protobuf:"bytes,4,opt,name=pid" json:"pid,omitempty"`
	RegisteredTime   *mesos.TimeInfo `protobuf:"bytes,5,opt,name=registered_time,json=registeredTime" json:"registered_time,omitempty"`
	ReregisteredTime *mesos.TimeInfo `protobuf:"bytes,6,opt,name=reregistered_time,json=reregisteredTime" json:"reregistered_time,omitempty"`
	// Total resources (including oversubscribed resources) the agent
	// provides.
	TotalResources     []mesos.Resource                            `protobuf:"bytes,7,rep,name=total_resources,json=totalResources" json:"total_resources"`
	AllocatedResources []mesos.Resource                            `protobuf:"bytes,8,rep,name=allocated_resources,json=allocatedResources" json:"allocated_resources"`
	OfferedResources   []mesos.Resource                            `protobuf:"bytes,9,rep,name=offered_resources,json=offeredResources" json:"offered_resources"`
	Capabilities       []mesos.AgentInfo_Capability                `protobuf:"bytes,10,rep,name=capabilities" json:"capabilities"`
	ResourceProviders  []Response_GetAgents_Agent_ResourceProvider `protobuf:"bytes,11,rep,name=resource_providers,json=resourceProviders" json:"resource_providers"`
}

func (m *Response_GetAgents_Agent) Reset()      { *m = Response_GetAgents_Agent{} }
func (*Response_GetAgents_Agent) ProtoMessage() {}
func (*Response_GetAgents_Agent) Descriptor() ([]byte, []int) {
	return fileDescriptorMaster, []int{1, 8, 0}
}

func (m *Response_GetAgents_Agent) GetAgentInfo() mesos.AgentInfo {
	if m != nil {
		return m.AgentInfo
	}
	return mesos.AgentInfo{}
}

func (m *Response_GetAgents_Agent) GetActive() bool {
	if m != nil {
		return m.Active
	}
	return false
}

func (m *Response_GetAgents_Agent) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *Response_GetAgents_Agent) GetPID() string {
	if m != nil && m.PID != nil {
		return *m.PID
	}
	return ""
}

func (m *Response_GetAgents_Agent) GetRegisteredTime() *mesos.TimeInfo {
	if m != nil {
		return m.RegisteredTime
	}
	return nil
}

func (m *Response_GetAgents_Agent) GetReregisteredTime() *mesos.TimeInfo {
	if m != nil {
		return m.ReregisteredTime
	}
	return nil
}

func (m *Response_GetAgents_Agent) GetTotalResources() []mesos.Resource {
	if m != nil {
		return m.TotalResources
	}
	return nil
}

func (m *Response_GetAgents_Agent) GetAllocatedResources() []mesos.Resource {
	if m != nil {
		return m.AllocatedResources
	}
	return nil
}

func (m *Response_GetAgents_Agent) GetOfferedResources() []mesos.Resource {
	if m != nil {
		return m.OfferedResources
	}
	return nil
}

func (m *Response_GetAgents_Agent) GetCapabilities() []mesos.AgentInfo_Capability {
	if m != nil {
		return m.Capabilities
	}
	return nil
}

func (m *Response_GetAgents_Agent) GetResourceProviders() []Response_GetAgents_Agent_ResourceProvider {
	if m != nil {
		return m.ResourceProviders
	}
	return nil
}

type Response_GetAgents_Agent_ResourceProvider struct {
	ResourceProviderInfo mesos.ResourceProviderInfo `protobuf:"bytes,1,req,name=resource_provider_info,json=resourceProviderInfo" json:"resource_provider_info"`
}

func (m *Response_GetAgents_Agent_ResourceProvider) Reset() {
	*m = Response_GetAgents_Agent_ResourceProvider{}
}
func (*Response_GetAgents_Agent_ResourceProvider) ProtoMessage() {}
func (*Response_GetAgents_Agent_ResourceProvider) Descriptor() ([]byte, []int) {
	return fileDescriptorMaster, []int{1, 8, 0, 0}
}

func (m *Response_GetAgents_Agent_ResourceProvider) GetResourceProviderInfo() mesos.ResourceProviderInfo {
	if m != nil {
		return m.ResourceProviderInfo
	}
	return mesos.ResourceProviderInfo{}
}

// Information about all the frameworks known to the master at the current
// time. Note that there might be frameworks unknown to the master running
// on partitioned or unsubscribed agents.
type Response_GetFrameworks struct {
	// Frameworks that have subscribed with the master. Note that this includes
	// frameworks that are disconnected and in the process of re-subscribing.
	Frameworks []Response_GetFrameworks_Framework `protobuf:"bytes,1,rep,name=frameworks" json:"frameworks"`
	// Frameworks that have been teared down.
	CompletedFrameworks []Response_GetFrameworks_Framework `protobuf:"bytes,2,rep,name=completed_frameworks,json=completedFrameworks" json:"completed_frameworks"`
	// This field previously contained frameworks that previously
	// subscribed but haven't yet re-subscribed after a master failover.
	// As of Mesos 1.2, this field will always be empty; recovered
	// frameworks are now reported in the `frameworks` list with the
	// `recovered` field set to true.
	//
	// TODO(neilc): Remove this field in Mesos 2.0.
	RecoveredFrameworks []mesos.FrameworkInfo `protobuf:"bytes,3,rep,name=recovered_frameworks,json=recoveredFrameworks" json:"recovered_frameworks"`
}

func (m *Response_GetFrameworks) Reset()                    { *m = Response_GetFrameworks{} }
func (*Response_GetFrameworks) ProtoMessage()               {}
func (*Response_GetFrameworks) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{1, 9} }

func (m *Response_GetFrameworks) GetFrameworks() []Response_GetFrameworks_Framework {
	if m != nil {
		return m.Frameworks
	}
	return nil
}

func (m *Response_GetFrameworks) GetCompletedFrameworks() []Response_GetFrameworks_Framework {
	if m != nil {
		return m.CompletedFrameworks
	}
	return nil
}

func (m *Response_GetFrameworks) GetRecoveredFrameworks() []mesos.FrameworkInfo {
	if m != nil {
		return m.RecoveredFrameworks
	}
	return nil
}

type Response_GetFrameworks_Framework struct {
	FrameworkInfo mesos.FrameworkInfo `protobuf:"bytes,1,req,name=framework_info,json=frameworkInfo" json:"framework_info"`
	Active        bool                `protobuf:"varint,2,req,name=active" json:"active"`
	Connected     bool                `protobuf:"varint,3,req,name=connected" json:"connected"`
	// If true, this framework was previously subscribed but hasn't
	// yet re-subscribed after a master failover. Recovered frameworks
	// are only reported if one or more agents running a task or
	// executor for the framework have re-registered after master
	// failover.
	Recovered          bool                 `protobuf:"varint,11,req,name=recovered" json:"recovered"`
	RegisteredTime     *mesos.TimeInfo      `protobuf:"bytes,4,opt,name=registered_time,json=registeredTime" json:"registered_time,omitempty"`
	ReregisteredTime   *mesos.TimeInfo      `protobuf:"bytes,5,opt,name=reregistered_time,json=reregisteredTime" json:"reregistered_time,omitempty"`
	UnregisteredTime   *mesos.TimeInfo      `protobuf:"bytes,6,opt,name=unregistered_time,json=unregisteredTime" json:"unregistered_time,omitempty"`
	Offers             []mesos.Offer        `protobuf:"bytes,7,rep,name=offers" json:"offers"`
	InverseOffers      []mesos.InverseOffer `protobuf:"bytes,8,rep,name=inverse_offers,json=inverseOffers" json:"inverse_offers"`
	AllocatedResources []mesos.Resource     `protobuf:"bytes,9,rep,name=allocated_resources,json=allocatedResources" json:"allocated_resources"`
	OfferedResources   []mesos.Resource     `protobuf:"bytes,10,rep,name=offered_resources,json=offeredResources" json:"offered_resources"`
}

func (m *Response_GetFrameworks_Framework) Reset()      { *m = Response_GetFrameworks_Framework{} }
func (*Response_GetFrameworks_Framework) ProtoMessage() {}
func (*Response_GetFrameworks_Framework) Descriptor() ([]byte, []int) {
	return fileDescriptorMaster, []int{1, 9, 0}
}

func (m *Response_GetFrameworks_Framework) GetFrameworkInfo() mesos.FrameworkInfo {
	if m != nil {
		return m.FrameworkInfo
	}
	return mesos.FrameworkInfo{}
}

func (m *Response_GetFrameworks_Framework) GetActive() bool {
	if m != nil {
		return m.Active
	}
	return false
}

func (m *Response_GetFrameworks_Framework) GetConnected() bool {
	if m != nil {
		return m.Connected
	}
	return false
}

func (m *Response_GetFrameworks_Framework) GetRecovered() bool {
	if m != nil {
		return m.Recovered
	}
	return false
}

func (m *Response_GetFrameworks_Framework) GetRegisteredTime() *mesos.TimeInfo {
	if m != nil {
		return m.RegisteredTime
	}
	return nil
}

func (m *Response_GetFrameworks_Framework) GetReregisteredTime() *mesos.TimeInfo {
	if m != nil {
		return m.ReregisteredTime
	}
	return nil
}

func (m *Response_GetFrameworks_Framework) GetUnregisteredTime() *mesos.TimeInfo {
	if m != nil {
		return m.UnregisteredTime
	}
	return nil
}

func (m *Response_GetFrameworks_Framework) GetOffers() []mesos.Offer {
	if m != nil {
		return m.Offers
	}
	return nil
}

func (m *Response_GetFrameworks_Framework) GetInverseOffers() []mesos.InverseOffer {
	if m != nil {
		return m.InverseOffers
	}
	return nil
}

func (m *Response_GetFrameworks_Framework) GetAllocatedResources() []mesos.Resource {
	if m != nil {
		return m.AllocatedResources
	}
	return nil
}

func (m *Response_GetFrameworks_Framework) GetOfferedResources() []mesos.Resource {
	if m != nil {
		return m.OfferedResources
	}
	return nil
}

// Lists information about all the executors known to the master at the
// current time. Note that there might be executors unknown to the master
// running on partitioned or unsubscribed agents.
type Response_GetExecutors struct {
	Executors []Response_GetExecutors_Executor `protobuf:"bytes,1,rep,name=executors" json:"executors"`
	// As of Mesos 1.3.0, this field is deprecated and will always be empty.
	//
	// TODO(neilc): Remove this field in Mesos 2.0.
	OrphanExecutors []Response_GetExecutors_Executor `protobuf:"bytes,2,rep,name=orphan_executors,json=orphanExecutors" json:"orphan_executors"`
}

func (m *Response_GetExecutors) Reset()                    { *m = Response_GetExecutors{} }
func (*Response_GetExecutors) ProtoMessage()               {}
func (*Response_GetExecutors) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{1, 10} }

func (m *Response_GetExecutors) GetExecutors() []Response_GetExecutors_Executor {
	if m != nil {
		return m.Executors
	}
	return nil
}

func (m *Response_GetExecutors) GetOrphanExecutors() []Response_GetExecutors_Executor {
	if m != nil {
		return m.OrphanExecutors
	}
	return nil
}

type Response_GetExecutors_Executor struct {
	ExecutorInfo mesos.ExecutorInfo `protobuf:"bytes,1,req,name=executor_info,json=executorInfo" json:"executor_info"`
	AgentID      mesos.AgentID      `protobuf:"bytes,2,req,name=agent_id,json=agentId" json:"agent_id"`
}

func (m *Response_GetExecutors_Executor) Reset()      { *m = Response_GetExecutors_Executor{} }
func (*Response_GetExecutors_Executor) ProtoMessage() {}
func (*Response_GetExecutors_Executor) Descriptor() ([]byte, []int) {
	return fileDescriptorMaster, []int{1, 10, 0}
}

func (m *Response_GetExecutors_Executor) GetExecutorInfo() mesos.ExecutorInfo {
	if m != nil {
		return m.ExecutorInfo
	}
	return mesos.ExecutorInfo{}
}

func (m *Response_GetExecutors_Executor) GetAgentID() mesos.AgentID {
	if m != nil {
		return m.AgentID
	}
	return mesos.AgentID{}
}

// Lists information about all the tasks known to the master at the current
// time. Note that there might be tasks unknown to the master running on
// partitioned or unsubscribed agents.
type Response_GetTasks struct {
	// Tasks that are enqueued on the master waiting (e.g., authorizing)
	// to be launched.
	PendingTasks []mesos.Task `protobuf:"bytes,1,rep,name=pending_tasks,json=pendingTasks" json:"pending_tasks"`
	// Tasks that have been forwarded to the agent for launch. This
	// includes tasks that are staging or running; it also includes
	// tasks that have reached a terminal state but the terminal status
	// update has not yet been acknowledged by the scheduler.
	Tasks []mesos.Task `protobuf:"bytes,2,rep,name=tasks" json:"tasks"`
	// Tasks that were running on agents that have become partitioned
	// from the master. If/when the agent is no longer partitioned,
	// tasks running on that agent will no longer be unreachable (they
	// will either be running or completed). Note that the master only
	// stores a limited number of unreachable tasks; information about
	// unreachable tasks is also not preserved across master failover.
	UnreachableTasks []mesos.Task `protobuf:"bytes,5,rep,name=unreachable_tasks,json=unreachableTasks" json:"unreachable_tasks"`
	// Tasks that have reached terminal state and have all their updates
	// acknowledged by the scheduler.
	CompletedTasks []mesos.Task `protobuf:"bytes,3,rep,name=completed_tasks,json=completedTasks" json:"completed_tasks"`
	// As of Mesos 1.3.0, this field is deprecated and will always be empty.
	//
	// TODO(neilc): Remove this field in Mesos 2.0.
	OrphanTasks []mesos.Task `protobuf:"bytes,4,rep,name=orphan_tasks,json=orphanTasks" json:"orphan_tasks"`
}

func (m *Response_GetTasks) Reset()                    { *m = Response_GetTasks{} }
func (*Response_GetTasks) ProtoMessage()               {}
func (*Response_GetTasks) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{1, 11} }

func (m *Response_GetTasks) GetPendingTasks() []mesos.Task {
	if m != nil {
		return m.PendingTasks
	}
	return nil
}

func (m *Response_GetTasks) GetTasks() []mesos.Task {
	if m != nil {
		return m.Tasks
	}
	return nil
}

func (m *Response_GetTasks) GetUnreachableTasks() []mesos.Task {
	if m != nil {
		return m.UnreachableTasks
	}
	return nil
}

func (m *Response_GetTasks) GetCompletedTasks() []mesos.Task {
	if m != nil {
		return m.CompletedTasks
	}
	return nil
}

func (m *Response_GetTasks) GetOrphanTasks() []mesos.Task {
	if m != nil {
		return m.OrphanTasks
	}
	return nil
}

// Provides information about every role that is on the role whitelist (if
// enabled), has one or more registered frameworks or has a non-default weight
// or quota.
type Response_GetRoles struct {
	Roles []mesos.Role `protobuf:"bytes,1,rep,name=roles" json:"roles"`
}

func (m *Response_GetRoles) Reset()                    { *m = Response_GetRoles{} }
func (*Response_GetRoles) ProtoMessage()               {}
func (*Response_GetRoles) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{1, 12} }

func (m *Response_GetRoles) GetRoles() []mesos.Role {
	if m != nil {
		return m.Roles
	}
	return nil
}

// Provides the weight information about every role.
type Response_GetWeights struct {
	WeightInfos []mesos.WeightInfo `protobuf:"bytes,1,rep,name=weight_infos,json=weightInfos" json:"weight_infos"`
}

func (m *Response_GetWeights) Reset()                    { *m = Response_GetWeights{} }
func (*Response_GetWeights) ProtoMessage()               {}
func (*Response_GetWeights) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{1, 13} }

func (m *Response_GetWeights) GetWeightInfos() []mesos.WeightInfo {
	if m != nil {
		return m.WeightInfos
	}
	return nil
}

// Contains the master's information.
type Response_GetMaster struct {
	MasterInfo  *mesos.MasterInfo `protobuf:"bytes,1,opt,name=master_info,json=masterInfo" json:"master_info,omitempty"`
	StartTime   *float64          `protobuf:"fixed64,2,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	ElectedTime *float64          `protobuf:"fixed64,3,opt,name=elected_time,json=electedTime" json:"elected_time,omitempty"`
}

func (m *Response_GetMaster) Reset()                    { *m = Response_GetMaster{} }
func (*Response_GetMaster) ProtoMessage()               {}
func (*Response_GetMaster) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{1, 14} }

func (m *Response_GetMaster) GetMasterInfo() *mesos.MasterInfo {
	if m != nil {
		return m.MasterInfo
	}
	return nil
}

func (m *Response_GetMaster) GetStartTime() float64 {
	if m != nil && m.StartTime != nil {
		return *m.StartTime
	}
	return 0
}

func (m *Response_GetMaster) GetElectedTime() float64 {
	if m != nil && m.ElectedTime != nil {
		return *m.ElectedTime
	}
	return 0
}

// Contains the cluster's maintenance status.
type Response_GetMaintenanceStatus struct {
	Status mesos_maintenance.ClusterStatus `protobuf:"bytes,1,req,name=status" json:"status"`
}

func (m *Response_GetMaintenanceStatus) Reset()      { *m = Response_GetMaintenanceStatus{} }
func (*Response_GetMaintenanceStatus) ProtoMessage() {}
func (*Response_GetMaintenanceStatus) Descriptor() ([]byte, []int) {
	return fileDescriptorMaster, []int{1, 15}
}

func (m *Response_GetMaintenanceStatus) GetStatus() mesos_maintenance.ClusterStatus {
	if m != nil {
		return m.Status
	}
	return mesos_maintenance.ClusterStatus{}
}

// Contains the cluster's maintenance schedule.
type Response_GetMaintenanceSchedule struct {
	Schedule mesos_maintenance.Schedule `protobuf:"bytes,1,req,name=schedule" json:"schedule"`
}

func (m *Response_GetMaintenanceSchedule) Reset()      { *m = Response_GetMaintenanceSchedule{} }
func (*Response_GetMaintenanceSchedule) ProtoMessage() {}
func (*Response_GetMaintenanceSchedule) Descriptor() ([]byte, []int) {
	return fileDescriptorMaster, []int{1, 16}
}

func (m *Response_GetMaintenanceSchedule) GetSchedule() mesos_maintenance.Schedule {
	if m != nil {
		return m.Schedule
	}
	return mesos_maintenance.Schedule{}
}

// Contains the cluster's configured quotas.
type Response_GetQuota struct {
	Status mesos_quota.QuotaStatus `protobuf:"bytes,1,req,name=status" json:"status"`
}

func (m *Response_GetQuota) Reset()                    { *m = Response_GetQuota{} }
func (*Response_GetQuota) ProtoMessage()               {}
func (*Response_GetQuota) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{1, 17} }

func (m *Response_GetQuota) GetStatus() mesos_quota.QuotaStatus {
	if m != nil {
		return m.Status
	}
	return mesos_quota.QuotaStatus{}
}

// *
// Streaming response to `Call::SUBSCRIBE` made to the master.
type Event struct {
	Type             Event_Type              `protobuf:"varint,1,opt,name=type,enum=mesos.master.Event_Type" json:"type"`
	Subscribed       *Event_Subscribed       `protobuf:"bytes,2,opt,name=subscribed" json:"subscribed,omitempty"`
	TaskAdded        *Event_TaskAdded        `protobuf:"bytes,3,opt,name=task_added,json=taskAdded" json:"task_added,omitempty"`
	TaskUpdated      *Event_TaskUpdated      `protobuf:"bytes,4,opt,name=task_updated,json=taskUpdated" json:"task_updated,omitempty"`
	AgentAdded       *Event_AgentAdded       `protobuf:"bytes,5,opt,name=agent_added,json=agentAdded" json:"agent_added,omitempty"`
	AgentRemoved     *Event_AgentRemoved     `protobuf:"bytes,6,opt,name=agent_removed,json=agentRemoved" json:"agent_removed,omitempty"`
	FrameworkAdded   *Event_FrameworkAdded   `protobuf:"bytes,7,opt,name=framework_added,json=frameworkAdded" json:"framework_added,omitempty"`
	FrameworkUpdated *Event_FrameworkUpdated `protobuf:"bytes,8,opt,name=framework_updated,json=frameworkUpdated" json:"framework_updated,omitempty"`
	FrameworkRemoved *Event_FrameworkRemoved `protobuf:"bytes,9,opt,name=framework_removed,json=frameworkRemoved" json:"framework_removed,omitempty"`
}

func (m *Event) Reset()                    { *m = Event{} }
func (*Event) ProtoMessage()               {}
func (*Event) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{2} }

func (m *Event) GetType() Event_Type {
	if m != nil {
		return m.Type
	}
	return Event_UNKNOWN
}

func (m *Event) GetSubscribed() *Event_Subscribed {
	if m != nil {
		return m.Subscribed
	}
	return nil
}

func (m *Event) GetTaskAdded() *Event_TaskAdded {
	if m != nil {
		return m.TaskAdded
	}
	return nil
}

func (m *Event) GetTaskUpdated() *Event_TaskUpdated {
	if m != nil {
		return m.TaskUpdated
	}
	return nil
}

func (m *Event) GetAgentAdded() *Event_AgentAdded {
	if m != nil {
		return m.AgentAdded
	}
	return nil
}

func (m *Event) GetAgentRemoved() *Event_AgentRemoved {
	if m != nil {
		return m.AgentRemoved
	}
	return nil
}

func (m *Event) GetFrameworkAdded() *Event_FrameworkAdded {
	if m != nil {
		return m.FrameworkAdded
	}
	return nil
}

func (m *Event) GetFrameworkUpdated() *Event_FrameworkUpdated {
	if m != nil {
		return m.FrameworkUpdated
	}
	return nil
}

func (m *Event) GetFrameworkRemoved() *Event_FrameworkRemoved {
	if m != nil {
		return m.FrameworkRemoved
	}
	return nil
}

// First event received when a client subscribes.
type Event_Subscribed struct {
	// Snapshot of the entire cluster state. Further updates to the
	// cluster state are sent as separate events on the stream.
	GetState *Response_GetState `protobuf:"bytes,1,opt,name=get_state,json=getState" json:"get_state,omitempty"`
	// This value will be set if the master is sending heartbeats to
	// subscribers. See the comment above on 'HEARTBEAT' for more details.
	HeartbeatIntervalSeconds *float64 `protobuf:"fixed64,2,opt,name=heartbeat_interval_seconds,json=heartbeatIntervalSeconds" json:"heartbeat_interval_seconds,omitempty"`
}

func (m *Event_Subscribed) Reset()                    { *m = Event_Subscribed{} }
func (*Event_Subscribed) ProtoMessage()               {}
func (*Event_Subscribed) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{2, 0} }

func (m *Event_Subscribed) GetGetState() *Response_GetState {
	if m != nil {
		return m.GetState
	}
	return nil
}

func (m *Event_Subscribed) GetHeartbeatIntervalSeconds() float64 {
	if m != nil && m.HeartbeatIntervalSeconds != nil {
		return *m.HeartbeatIntervalSeconds
	}
	return 0
}

// Forwarded by the master when a task becomes known to it. This can happen
// when a new task is launched by the scheduler or when the task becomes
// known to the master upon an agent (re-)registration after a failover.
type Event_TaskAdded struct {
	Task mesos.Task `protobuf:"bytes,1,req,name=task" json:"task"`
}

func (m *Event_TaskAdded) Reset()                    { *m = Event_TaskAdded{} }
func (*Event_TaskAdded) ProtoMessage()               {}
func (*Event_TaskAdded) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{2, 1} }

func (m *Event_TaskAdded) GetTask() mesos.Task {
	if m != nil {
		return m.Task
	}
	return mesos.Task{}
}

// Forwarded by the master when an existing task transitions to a new state.
type Event_TaskUpdated struct {
	FrameworkID mesos.FrameworkID `protobuf:"bytes,1,req,name=framework_id,json=frameworkId" json:"framework_id"`
	// This is the status of the task corresponding to the last
	// status update acknowledged by the scheduler.
	Status mesos.TaskStatus `protobuf:"bytes,2,req,name=status" json:"status"`
	// This is the latest state of the task according to the agent.
	State *mesos.TaskState `protobuf:"varint,3,req,name=state,enum=mesos.TaskState" json:"state,omitempty"`
}

func (m *Event_TaskUpdated) Reset()                    { *m = Event_TaskUpdated{} }
func (*Event_TaskUpdated) ProtoMessage()               {}
func (*Event_TaskUpdated) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{2, 2} }

func (m *Event_TaskUpdated) GetFrameworkID() mesos.FrameworkID {
	if m != nil {
		return m.FrameworkID
	}
	return mesos.FrameworkID{}
}

func (m *Event_TaskUpdated) GetStatus() mesos.TaskStatus {
	if m != nil {
		return m.Status
	}
	return mesos.TaskStatus{}
}

func (m *Event_TaskUpdated) GetState() mesos.TaskState {
	if m != nil && m.State != nil {
		return *m.State
	}
	return mesos.TASK_STAGING
}

// Forwarded by the master when a framework becomes known to it.
// This can happen when a new framework registers with the master.
type Event_FrameworkAdded struct {
	Framework Response_GetFrameworks_Framework `protobuf:"bytes,1,req,name=framework" json:"framework"`
}

func (m *Event_FrameworkAdded) Reset()                    { *m = Event_FrameworkAdded{} }
func (*Event_FrameworkAdded) ProtoMessage()               {}
func (*Event_FrameworkAdded) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{2, 3} }

func (m *Event_FrameworkAdded) GetFramework() Response_GetFrameworks_Framework {
	if m != nil {
		return m.Framework
	}
	return Response_GetFrameworks_Framework{}
}

// Forwarded by the master when a framework re-registers with the master
// upon a disconnection (network error) or upon a master failover.
type Event_FrameworkUpdated struct {
	Framework Response_GetFrameworks_Framework `protobuf:"bytes,1,req,name=framework" json:"framework"`
}

func (m *Event_FrameworkUpdated) Reset()                    { *m = Event_FrameworkUpdated{} }
func (*Event_FrameworkUpdated) ProtoMessage()               {}
func (*Event_FrameworkUpdated) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{2, 4} }

func (m *Event_FrameworkUpdated) GetFramework() Response_GetFrameworks_Framework {
	if m != nil {
		return m.Framework
	}
	return Response_GetFrameworks_Framework{}
}

// Forwarded by the master when a framework is removed. This can happen when
// a framework is explicitly teardown by the operator or if it fails to
// re-register with the master within the failover timeout.
type Event_FrameworkRemoved struct {
	FrameworkInfo mesos.FrameworkInfo `protobuf:"bytes,1,req,name=framework_info,json=frameworkInfo" json:"framework_info"`
}

func (m *Event_FrameworkRemoved) Reset()                    { *m = Event_FrameworkRemoved{} }
func (*Event_FrameworkRemoved) ProtoMessage()               {}
func (*Event_FrameworkRemoved) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{2, 5} }

func (m *Event_FrameworkRemoved) GetFrameworkInfo() mesos.FrameworkInfo {
	if m != nil {
		return m.FrameworkInfo
	}
	return mesos.FrameworkInfo{}
}

// Forwarded by the master when an agent becomes known to it.
// This can happen when an agent registered for the first
// time, or reregistered after a master failover.
type Event_AgentAdded struct {
	Agent Response_GetAgents_Agent `protobuf:"bytes,1,req,name=agent" json:"agent"`
}

func (m *Event_AgentAdded) Reset()                    { *m = Event_AgentAdded{} }
func (*Event_AgentAdded) ProtoMessage()               {}
func (*Event_AgentAdded) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{2, 6} }

func (m *Event_AgentAdded) GetAgent() Response_GetAgents_Agent {
	if m != nil {
		return m.Agent
	}
	return Response_GetAgents_Agent{}
}

// Forwarded by the master when an agent is removed. This
// can happen when the agent is scheduled for maintenance.
//
// NOTE: It's possible that an agent might become
// active once it has been removed, i.e. if the master
// has gc'ed its list of known "dead" agents.
// See MESOS-5965 for context.
type Event_AgentRemoved struct {
	AgentID mesos.AgentID `protobuf:"bytes,1,req,name=agent_id,json=agentId" json:"agent_id"`
}

func (m *Event_AgentRemoved) Reset()                    { *m = Event_AgentRemoved{} }
func (*Event_AgentRemoved) ProtoMessage()               {}
func (*Event_AgentRemoved) Descriptor() ([]byte, []int) { return fileDescriptorMaster, []int{2, 7} }

func (m *Event_AgentRemoved) GetAgentID() mesos.AgentID {
	if m != nil {
		return m.AgentID
	}
	return mesos.AgentID{}
}

func init() {
	proto.RegisterType((*Call)(nil), "mesos.master.Call")
	proto.RegisterType((*Call_GetMetrics)(nil), "mesos.master.Call.GetMetrics")
	proto.RegisterType((*Call_SetLoggingLevel)(nil), "mesos.master.Call.SetLoggingLevel")
	proto.RegisterType((*Call_ListFiles)(nil), "mesos.master.Call.ListFiles")
	proto.RegisterType((*Call_ReadFile)(nil), "mesos.master.Call.ReadFile")
	proto.RegisterType((*Call_UpdateWeights)(nil), "mesos.master.Call.UpdateWeights")
	proto.RegisterType((*Call_ReserveResources)(nil), "mesos.master.Call.ReserveResources")
	proto.RegisterType((*Call_UnreserveResources)(nil), "mesos.master.Call.UnreserveResources")
	proto.RegisterType((*Call_CreateVolumes)(nil), "mesos.master.Call.CreateVolumes")
	proto.RegisterType((*Call_DestroyVolumes)(nil), "mesos.master.Call.DestroyVolumes")
	proto.RegisterType((*Call_UpdateMaintenanceSchedule)(nil), "mesos.master.Call.UpdateMaintenanceSchedule")
	proto.RegisterType((*Call_StartMaintenance)(nil), "mesos.master.Call.StartMaintenance")
	proto.RegisterType((*Call_StopMaintenance)(nil), "mesos.master.Call.StopMaintenance")
	proto.RegisterType((*Call_SetQuota)(nil), "mesos.master.Call.SetQuota")
	proto.RegisterType((*Call_RemoveQuota)(nil), "mesos.master.Call.RemoveQuota")
	proto.RegisterType((*Call_Teardown)(nil), "mesos.master.Call.Teardown")
	proto.RegisterType((*Call_MarkAgentGone)(nil), "mesos.master.Call.MarkAgentGone")
	proto.RegisterType((*Response)(nil), "mesos.master.Response")
	proto.RegisterType((*Response_GetHealth)(nil), "mesos.master.Response.GetHealth")
	proto.RegisterType((*Response_GetFlags)(nil), "mesos.master.Response.GetFlags")
	proto.RegisterType((*Response_GetVersion)(nil), "mesos.master.Response.GetVersion")
	proto.RegisterType((*Response_GetMetrics)(nil), "mesos.master.Response.GetMetrics")
	proto.RegisterType((*Response_GetLoggingLevel)(nil), "mesos.master.Response.GetLoggingLevel")
	proto.RegisterType((*Response_ListFiles)(nil), "mesos.master.Response.ListFiles")
	proto.RegisterType((*Response_ReadFile)(nil), "mesos.master.Response.ReadFile")
	proto.RegisterType((*Response_GetState)(nil), "mesos.master.Response.GetState")
	proto.RegisterType((*Response_GetAgents)(nil), "mesos.master.Response.GetAgents")
	proto.RegisterType((*Response_GetAgents_Agent)(nil), "mesos.master.Response.GetAgents.Agent")
	proto.RegisterType((*Response_GetAgents_Agent_ResourceProvider)(nil), "mesos.master.Response.GetAgents.Agent.ResourceProvider")
	proto.RegisterType((*Response_GetFrameworks)(nil), "mesos.master.Response.GetFrameworks")
	proto.RegisterType((*Response_GetFrameworks_Framework)(nil), "mesos.master.Response.GetFrameworks.Framework")
	proto.RegisterType((*Response_GetExecutors)(nil), "mesos.master.Response.GetExecutors")
	proto.RegisterType((*Response_GetExecutors_Executor)(nil), "mesos.master.Response.GetExecutors.Executor")
	proto.RegisterType((*Response_GetTasks)(nil), "mesos.master.Response.GetTasks")
	proto.RegisterType((*Response_GetRoles)(nil), "mesos.master.Response.GetRoles")
	proto.RegisterType((*Response_GetWeights)(nil), "mesos.master.Response.GetWeights")
	proto.RegisterType((*Response_GetMaster)(nil), "mesos.master.Response.GetMaster")
	proto.RegisterType((*Response_GetMaintenanceStatus)(nil), "mesos.master.Response.GetMaintenanceStatus")
	proto.RegisterType((*Response_GetMaintenanceSchedule)(nil), "mesos.master.Response.GetMaintenanceSchedule")
	proto.RegisterType((*Response_GetQuota)(nil), "mesos.master.Response.GetQuota")
	proto.RegisterType((*Event)(nil), "mesos.master.Event")
	proto.RegisterType((*Event_Subscribed)(nil), "mesos.master.Event.Subscribed")
	proto.RegisterType((*Event_TaskAdded)(nil), "mesos.master.Event.TaskAdded")
	proto.RegisterType((*Event_TaskUpdated)(nil), "mesos.master.Event.TaskUpdated")
	proto.RegisterType((*Event_FrameworkAdded)(nil), "mesos.master.Event.FrameworkAdded")
	proto.RegisterType((*Event_FrameworkUpdated)(nil), "mesos.master.Event.FrameworkUpdated")
	proto.RegisterType((*Event_FrameworkRemoved)(nil), "mesos.master.Event.FrameworkRemoved")
	proto.RegisterType((*Event_AgentAdded)(nil), "mesos.master.Event.AgentAdded")
	proto.RegisterType((*Event_AgentRemoved)(nil), "mesos.master.Event.AgentRemoved")
	proto.RegisterEnum("mesos.master.Call_Type", Call_Type_name, Call_Type_value)
	proto.RegisterEnum("mesos.master.Response_Type", Response_Type_name, Response_Type_value)
	proto.RegisterEnum("mesos.master.Event_Type", Event_Type_name, Event_Type_value)
}
func (x Call_Type) String() string {
	s, ok := Call_Type_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x Response_Type) String() string {
	s, ok := Response_Type_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x Event_Type) String() string {
	s, ok := Event_Type_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (this *Call) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call)
	if !ok {
		that2, ok := that.(Call)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call but is not nil && this == nil")
	}
	if this.Type != that1.Type {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !this.GetMetrics.Equal(that1.GetMetrics) {
		return fmt.Errorf("GetMetrics this(%v) Not Equal that(%v)", this.GetMetrics, that1.GetMetrics)
	}
	if !this.SetLoggingLevel.Equal(that1.SetLoggingLevel) {
		return fmt.Errorf("SetLoggingLevel this(%v) Not Equal that(%v)", this.SetLoggingLevel, that1.SetLoggingLevel)
	}
	if !this.ListFiles.Equal(that1.ListFiles) {
		return fmt.Errorf("ListFiles this(%v) Not Equal that(%v)", this.ListFiles, that1.ListFiles)
	}
	if !this.ReadFile.Equal(that1.ReadFile) {
		return fmt.Errorf("ReadFile this(%v) Not Equal that(%v)", this.ReadFile, that1.ReadFile)
	}
	if !this.UpdateWeights.Equal(that1.UpdateWeights) {
		return fmt.Errorf("UpdateWeights this(%v) Not Equal that(%v)", this.UpdateWeights, that1.UpdateWeights)
	}
	if !this.ReserveResources.Equal(that1.ReserveResources) {
		return fmt.Errorf("ReserveResources this(%v) Not Equal that(%v)", this.ReserveResources, that1.ReserveResources)
	}
	if !this.UnreserveResources.Equal(that1.UnreserveResources) {
		return fmt.Errorf("UnreserveResources this(%v) Not Equal that(%v)", this.UnreserveResources, that1.UnreserveResources)
	}
	if !this.CreateVolumes.Equal(that1.CreateVolumes) {
		return fmt.Errorf("CreateVolumes this(%v) Not Equal that(%v)", this.CreateVolumes, that1.CreateVolumes)
	}
	if !this.DestroyVolumes.Equal(that1.DestroyVolumes) {
		return fmt.Errorf("DestroyVolumes this(%v) Not Equal that(%v)", this.DestroyVolumes, that1.DestroyVolumes)
	}
	if !this.UpdateMaintenanceSchedule.Equal(that1.UpdateMaintenanceSchedule) {
		return fmt.Errorf("UpdateMaintenanceSchedule this(%v) Not Equal that(%v)", this.UpdateMaintenanceSchedule, that1.UpdateMaintenanceSchedule)
	}
	if !this.StartMaintenance.Equal(that1.StartMaintenance) {
		return fmt.Errorf("StartMaintenance this(%v) Not Equal that(%v)", this.StartMaintenance, that1.StartMaintenance)
	}
	if !this.StopMaintenance.Equal(that1.StopMaintenance) {
		return fmt.Errorf("StopMaintenance this(%v) Not Equal that(%v)", this.StopMaintenance, that1.StopMaintenance)
	}
	if !this.SetQuota.Equal(that1.SetQuota) {
		return fmt.Errorf("SetQuota this(%v) Not Equal that(%v)", this.SetQuota, that1.SetQuota)
	}
	if !this.RemoveQuota.Equal(that1.RemoveQuota) {
		return fmt.Errorf("RemoveQuota this(%v) Not Equal that(%v)", this.RemoveQuota, that1.RemoveQuota)
	}
	if !this.Teardown.Equal(that1.Teardown) {
		return fmt.Errorf("Teardown this(%v) Not Equal that(%v)", this.Teardown, that1.Teardown)
	}
	if !this.MarkAgentGone.Equal(that1.MarkAgentGone) {
		return fmt.Errorf("MarkAgentGone this(%v) Not Equal that(%v)", this.MarkAgentGone, that1.MarkAgentGone)
	}
	return nil
}
func (this *Call) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call)
	if !ok {
		that2, ok := that.(Call)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if !this.GetMetrics.Equal(that1.GetMetrics) {
		return false
	}
	if !this.SetLoggingLevel.Equal(that1.SetLoggingLevel) {
		return false
	}
	if !this.ListFiles.Equal(that1.ListFiles) {
		return false
	}
	if !this.ReadFile.Equal(that1.ReadFile) {
		return false
	}
	if !this.UpdateWeights.Equal(that1.UpdateWeights) {
		return false
	}
	if !this.ReserveResources.Equal(that1.ReserveResources) {
		return false
	}
	if !this.UnreserveResources.Equal(that1.UnreserveResources) {
		return false
	}
	if !this.CreateVolumes.Equal(that1.CreateVolumes) {
		return false
	}
	if !this.DestroyVolumes.Equal(that1.DestroyVolumes) {
		return false
	}
	if !this.UpdateMaintenanceSchedule.Equal(that1.UpdateMaintenanceSchedule) {
		return false
	}
	if !this.StartMaintenance.Equal(that1.StartMaintenance) {
		return false
	}
	if !this.StopMaintenance.Equal(that1.StopMaintenance) {
		return false
	}
	if !this.SetQuota.Equal(that1.SetQuota) {
		return false
	}
	if !this.RemoveQuota.Equal(that1.RemoveQuota) {
		return false
	}
	if !this.Teardown.Equal(that1.Teardown) {
		return false
	}
	if !this.MarkAgentGone.Equal(that1.MarkAgentGone) {
		return false
	}
	return true
}
func (this *Call_GetMetrics) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_GetMetrics)
	if !ok {
		that2, ok := that.(Call_GetMetrics)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_GetMetrics")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_GetMetrics but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_GetMetrics but is not nil && this == nil")
	}
	if !this.Timeout.Equal(that1.Timeout) {
		return fmt.Errorf("Timeout this(%v) Not Equal that(%v)", this.Timeout, that1.Timeout)
	}
	return nil
}
func (this *Call_GetMetrics) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_GetMetrics)
	if !ok {
		that2, ok := that.(Call_GetMetrics)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Timeout.Equal(that1.Timeout) {
		return false
	}
	return true
}
func (this *Call_SetLoggingLevel) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_SetLoggingLevel)
	if !ok {
		that2, ok := that.(Call_SetLoggingLevel)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_SetLoggingLevel")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_SetLoggingLevel but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_SetLoggingLevel but is not nil && this == nil")
	}
	if this.Level != that1.Level {
		return fmt.Errorf("Level this(%v) Not Equal that(%v)", this.Level, that1.Level)
	}
	if !this.Duration.Equal(&that1.Duration) {
		return fmt.Errorf("Duration this(%v) Not Equal that(%v)", this.Duration, that1.Duration)
	}
	return nil
}
func (this *Call_SetLoggingLevel) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_SetLoggingLevel)
	if !ok {
		that2, ok := that.(Call_SetLoggingLevel)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Level != that1.Level {
		return false
	}
	if !this.Duration.Equal(&that1.Duration) {
		return false
	}
	return true
}
func (this *Call_ListFiles) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_ListFiles)
	if !ok {
		that2, ok := that.(Call_ListFiles)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_ListFiles")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_ListFiles but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_ListFiles but is not nil && this == nil")
	}
	if this.Path != that1.Path {
		return fmt.Errorf("Path this(%v) Not Equal that(%v)", this.Path, that1.Path)
	}
	return nil
}
func (this *Call_ListFiles) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_ListFiles)
	if !ok {
		that2, ok := that.(Call_ListFiles)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	return true
}
func (this *Call_ReadFile) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_ReadFile)
	if !ok {
		that2, ok := that.(Call_ReadFile)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_ReadFile")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_ReadFile but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_ReadFile but is not nil && this == nil")
	}
	if this.Path != that1.Path {
		return fmt.Errorf("Path this(%v) Not Equal that(%v)", this.Path, that1.Path)
	}
	if this.Offset != that1.Offset {
		return fmt.Errorf("Offset this(%v) Not Equal that(%v)", this.Offset, that1.Offset)
	}
	if this.Length != nil && that1.Length != nil {
		if *this.Length != *that1.Length {
			return fmt.Errorf("Length this(%v) Not Equal that(%v)", *this.Length, *that1.Length)
		}
	} else if this.Length != nil {
		return fmt.Errorf("this.Length == nil && that.Length != nil")
	} else if that1.Length != nil {
		return fmt.Errorf("Length this(%v) Not Equal that(%v)", this.Length, that1.Length)
	}
	return nil
}
func (this *Call_ReadFile) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_ReadFile)
	if !ok {
		that2, ok := that.(Call_ReadFile)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	if this.Offset != that1.Offset {
		return false
	}
	if this.Length != nil && that1.Length != nil {
		if *this.Length != *that1.Length {
			return false
		}
	} else if this.Length != nil {
		return false
	} else if that1.Length != nil {
		return false
	}
	return true
}
func (this *Call_UpdateWeights) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_UpdateWeights)
	if !ok {
		that2, ok := that.(Call_UpdateWeights)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_UpdateWeights")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_UpdateWeights but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_UpdateWeights but is not nil && this == nil")
	}
	if len(this.WeightInfos) != len(that1.WeightInfos) {
		return fmt.Errorf("WeightInfos this(%v) Not Equal that(%v)", len(this.WeightInfos), len(that1.WeightInfos))
	}
	for i := range this.WeightInfos {
		if !this.WeightInfos[i].Equal(&that1.WeightInfos[i]) {
			return fmt.Errorf("WeightInfos this[%v](%v) Not Equal that[%v](%v)", i, this.WeightInfos[i], i, that1.WeightInfos[i])
		}
	}
	return nil
}
func (this *Call_UpdateWeights) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_UpdateWeights)
	if !ok {
		that2, ok := that.(Call_UpdateWeights)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.WeightInfos) != len(that1.WeightInfos) {
		return false
	}
	for i := range this.WeightInfos {
		if !this.WeightInfos[i].Equal(&that1.WeightInfos[i]) {
			return false
		}
	}
	return true
}
func (this *Call_ReserveResources) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_ReserveResources)
	if !ok {
		that2, ok := that.(Call_ReserveResources)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_ReserveResources")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_ReserveResources but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_ReserveResources but is not nil && this == nil")
	}
	if !this.AgentID.Equal(&that1.AgentID) {
		return fmt.Errorf("AgentID this(%v) Not Equal that(%v)", this.AgentID, that1.AgentID)
	}
	if len(this.Resources) != len(that1.Resources) {
		return fmt.Errorf("Resources this(%v) Not Equal that(%v)", len(this.Resources), len(that1.Resources))
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(&that1.Resources[i]) {
			return fmt.Errorf("Resources this[%v](%v) Not Equal that[%v](%v)", i, this.Resources[i], i, that1.Resources[i])
		}
	}
	return nil
}
func (this *Call_ReserveResources) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_ReserveResources)
	if !ok {
		that2, ok := that.(Call_ReserveResources)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.AgentID.Equal(&that1.AgentID) {
		return false
	}
	if len(this.Resources) != len(that1.Resources) {
		return false
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(&that1.Resources[i]) {
			return false
		}
	}
	return true
}
func (this *Call_UnreserveResources) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_UnreserveResources)
	if !ok {
		that2, ok := that.(Call_UnreserveResources)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_UnreserveResources")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_UnreserveResources but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_UnreserveResources but is not nil && this == nil")
	}
	if !this.AgentID.Equal(&that1.AgentID) {
		return fmt.Errorf("AgentID this(%v) Not Equal that(%v)", this.AgentID, that1.AgentID)
	}
	if len(this.Resources) != len(that1.Resources) {
		return fmt.Errorf("Resources this(%v) Not Equal that(%v)", len(this.Resources), len(that1.Resources))
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(&that1.Resources[i]) {
			return fmt.Errorf("Resources this[%v](%v) Not Equal that[%v](%v)", i, this.Resources[i], i, that1.Resources[i])
		}
	}
	return nil
}
func (this *Call_UnreserveResources) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_UnreserveResources)
	if !ok {
		that2, ok := that.(Call_UnreserveResources)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.AgentID.Equal(&that1.AgentID) {
		return false
	}
	if len(this.Resources) != len(that1.Resources) {
		return false
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(&that1.Resources[i]) {
			return false
		}
	}
	return true
}
func (this *Call_CreateVolumes) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_CreateVolumes)
	if !ok {
		that2, ok := that.(Call_CreateVolumes)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_CreateVolumes")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_CreateVolumes but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_CreateVolumes but is not nil && this == nil")
	}
	if !this.AgentID.Equal(&that1.AgentID) {
		return fmt.Errorf("AgentID this(%v) Not Equal that(%v)", this.AgentID, that1.AgentID)
	}
	if len(this.Volumes) != len(that1.Volumes) {
		return fmt.Errorf("Volumes this(%v) Not Equal that(%v)", len(this.Volumes), len(that1.Volumes))
	}
	for i := range this.Volumes {
		if !this.Volumes[i].Equal(&that1.Volumes[i]) {
			return fmt.Errorf("Volumes this[%v](%v) Not Equal that[%v](%v)", i, this.Volumes[i], i, that1.Volumes[i])
		}
	}
	return nil
}
func (this *Call_CreateVolumes) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_CreateVolumes)
	if !ok {
		that2, ok := that.(Call_CreateVolumes)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.AgentID.Equal(&that1.AgentID) {
		return false
	}
	if len(this.Volumes) != len(that1.Volumes) {
		return false
	}
	for i := range this.Volumes {
		if !this.Volumes[i].Equal(&that1.Volumes[i]) {
			return false
		}
	}
	return true
}
func (this *Call_DestroyVolumes) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_DestroyVolumes)
	if !ok {
		that2, ok := that.(Call_DestroyVolumes)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_DestroyVolumes")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_DestroyVolumes but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_DestroyVolumes but is not nil && this == nil")
	}
	if !this.AgentID.Equal(&that1.AgentID) {
		return fmt.Errorf("AgentID this(%v) Not Equal that(%v)", this.AgentID, that1.AgentID)
	}
	if len(this.Volumes) != len(that1.Volumes) {
		return fmt.Errorf("Volumes this(%v) Not Equal that(%v)", len(this.Volumes), len(that1.Volumes))
	}
	for i := range this.Volumes {
		if !this.Volumes[i].Equal(&that1.Volumes[i]) {
			return fmt.Errorf("Volumes this[%v](%v) Not Equal that[%v](%v)", i, this.Volumes[i], i, that1.Volumes[i])
		}
	}
	return nil
}
func (this *Call_DestroyVolumes) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_DestroyVolumes)
	if !ok {
		that2, ok := that.(Call_DestroyVolumes)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.AgentID.Equal(&that1.AgentID) {
		return false
	}
	if len(this.Volumes) != len(that1.Volumes) {
		return false
	}
	for i := range this.Volumes {
		if !this.Volumes[i].Equal(&that1.Volumes[i]) {
			return false
		}
	}
	return true
}
func (this *Call_UpdateMaintenanceSchedule) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_UpdateMaintenanceSchedule)
	if !ok {
		that2, ok := that.(Call_UpdateMaintenanceSchedule)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_UpdateMaintenanceSchedule")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_UpdateMaintenanceSchedule but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_UpdateMaintenanceSchedule but is not nil && this == nil")
	}
	if !this.Schedule.Equal(&that1.Schedule) {
		return fmt.Errorf("Schedule this(%v) Not Equal that(%v)", this.Schedule, that1.Schedule)
	}
	return nil
}
func (this *Call_UpdateMaintenanceSchedule) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_UpdateMaintenanceSchedule)
	if !ok {
		that2, ok := that.(Call_UpdateMaintenanceSchedule)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Schedule.Equal(&that1.Schedule) {
		return false
	}
	return true
}
func (this *Call_StartMaintenance) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_StartMaintenance)
	if !ok {
		that2, ok := that.(Call_StartMaintenance)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_StartMaintenance")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_StartMaintenance but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_StartMaintenance but is not nil && this == nil")
	}
	if len(this.Machines) != len(that1.Machines) {
		return fmt.Errorf("Machines this(%v) Not Equal that(%v)", len(this.Machines), len(that1.Machines))
	}
	for i := range this.Machines {
		if !this.Machines[i].Equal(&that1.Machines[i]) {
			return fmt.Errorf("Machines this[%v](%v) Not Equal that[%v](%v)", i, this.Machines[i], i, that1.Machines[i])
		}
	}
	return nil
}
func (this *Call_StartMaintenance) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_StartMaintenance)
	if !ok {
		that2, ok := that.(Call_StartMaintenance)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Machines) != len(that1.Machines) {
		return false
	}
	for i := range this.Machines {
		if !this.Machines[i].Equal(&that1.Machines[i]) {
			return false
		}
	}
	return true
}
func (this *Call_StopMaintenance) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_StopMaintenance)
	if !ok {
		that2, ok := that.(Call_StopMaintenance)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_StopMaintenance")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_StopMaintenance but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_StopMaintenance but is not nil && this == nil")
	}
	if len(this.Machines) != len(that1.Machines) {
		return fmt.Errorf("Machines this(%v) Not Equal that(%v)", len(this.Machines), len(that1.Machines))
	}
	for i := range this.Machines {
		if !this.Machines[i].Equal(&that1.Machines[i]) {
			return fmt.Errorf("Machines this[%v](%v) Not Equal that[%v](%v)", i, this.Machines[i], i, that1.Machines[i])
		}
	}
	return nil
}
func (this *Call_StopMaintenance) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_StopMaintenance)
	if !ok {
		that2, ok := that.(Call_StopMaintenance)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Machines) != len(that1.Machines) {
		return false
	}
	for i := range this.Machines {
		if !this.Machines[i].Equal(&that1.Machines[i]) {
			return false
		}
	}
	return true
}
func (this *Call_SetQuota) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_SetQuota)
	if !ok {
		that2, ok := that.(Call_SetQuota)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_SetQuota")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_SetQuota but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_SetQuota but is not nil && this == nil")
	}
	if !this.QuotaRequest.Equal(&that1.QuotaRequest) {
		return fmt.Errorf("QuotaRequest this(%v) Not Equal that(%v)", this.QuotaRequest, that1.QuotaRequest)
	}
	return nil
}
func (this *Call_SetQuota) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_SetQuota)
	if !ok {
		that2, ok := that.(Call_SetQuota)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.QuotaRequest.Equal(&that1.QuotaRequest) {
		return false
	}
	return true
}
func (this *Call_RemoveQuota) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_RemoveQuota)
	if !ok {
		that2, ok := that.(Call_RemoveQuota)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_RemoveQuota")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_RemoveQuota but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_RemoveQuota but is not nil && this == nil")
	}
	if this.Role != that1.Role {
		return fmt.Errorf("Role this(%v) Not Equal that(%v)", this.Role, that1.Role)
	}
	return nil
}
func (this *Call_RemoveQuota) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_RemoveQuota)
	if !ok {
		that2, ok := that.(Call_RemoveQuota)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Role != that1.Role {
		return false
	}
	return true
}
func (this *Call_Teardown) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_Teardown)
	if !ok {
		that2, ok := that.(Call_Teardown)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_Teardown")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_Teardown but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_Teardown but is not nil && this == nil")
	}
	if !this.FrameworkID.Equal(&that1.FrameworkID) {
		return fmt.Errorf("FrameworkID this(%v) Not Equal that(%v)", this.FrameworkID, that1.FrameworkID)
	}
	return nil
}
func (this *Call_Teardown) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_Teardown)
	if !ok {
		that2, ok := that.(Call_Teardown)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.FrameworkID.Equal(&that1.FrameworkID) {
		return false
	}
	return true
}
func (this *Call_MarkAgentGone) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_MarkAgentGone)
	if !ok {
		that2, ok := that.(Call_MarkAgentGone)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_MarkAgentGone")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_MarkAgentGone but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_MarkAgentGone but is not nil && this == nil")
	}
	if !this.AgentID.Equal(&that1.AgentID) {
		return fmt.Errorf("AgentID this(%v) Not Equal that(%v)", this.AgentID, that1.AgentID)
	}
	return nil
}
func (this *Call_MarkAgentGone) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_MarkAgentGone)
	if !ok {
		that2, ok := that.(Call_MarkAgentGone)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.AgentID.Equal(&that1.AgentID) {
		return false
	}
	return true
}
func (this *Response) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response)
	if !ok {
		that2, ok := that.(Response)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response but is not nil && this == nil")
	}
	if this.Type != that1.Type {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !this.GetHealth.Equal(that1.GetHealth) {
		return fmt.Errorf("GetHealth this(%v) Not Equal that(%v)", this.GetHealth, that1.GetHealth)
	}
	if !this.GetFlags.Equal(that1.GetFlags) {
		return fmt.Errorf("GetFlags this(%v) Not Equal that(%v)", this.GetFlags, that1.GetFlags)
	}
	if !this.GetVersion.Equal(that1.GetVersion) {
		return fmt.Errorf("GetVersion this(%v) Not Equal that(%v)", this.GetVersion, that1.GetVersion)
	}
	if !this.GetMetrics.Equal(that1.GetMetrics) {
		return fmt.Errorf("GetMetrics this(%v) Not Equal that(%v)", this.GetMetrics, that1.GetMetrics)
	}
	if !this.GetLoggingLevel.Equal(that1.GetLoggingLevel) {
		return fmt.Errorf("GetLoggingLevel this(%v) Not Equal that(%v)", this.GetLoggingLevel, that1.GetLoggingLevel)
	}
	if !this.ListFiles.Equal(that1.ListFiles) {
		return fmt.Errorf("ListFiles this(%v) Not Equal that(%v)", this.ListFiles, that1.ListFiles)
	}
	if !this.ReadFile.Equal(that1.ReadFile) {
		return fmt.Errorf("ReadFile this(%v) Not Equal that(%v)", this.ReadFile, that1.ReadFile)
	}
	if !this.GetState.Equal(that1.GetState) {
		return fmt.Errorf("GetState this(%v) Not Equal that(%v)", this.GetState, that1.GetState)
	}
	if !this.GetAgents.Equal(that1.GetAgents) {
		return fmt.Errorf("GetAgents this(%v) Not Equal that(%v)", this.GetAgents, that1.GetAgents)
	}
	if !this.GetFrameworks.Equal(that1.GetFrameworks) {
		return fmt.Errorf("GetFrameworks this(%v) Not Equal that(%v)", this.GetFrameworks, that1.GetFrameworks)
	}
	if !this.GetExecutors.Equal(that1.GetExecutors) {
		return fmt.Errorf("GetExecutors this(%v) Not Equal that(%v)", this.GetExecutors, that1.GetExecutors)
	}
	if !this.GetTasks.Equal(that1.GetTasks) {
		return fmt.Errorf("GetTasks this(%v) Not Equal that(%v)", this.GetTasks, that1.GetTasks)
	}
	if !this.GetRoles.Equal(that1.GetRoles) {
		return fmt.Errorf("GetRoles this(%v) Not Equal that(%v)", this.GetRoles, that1.GetRoles)
	}
	if !this.GetWeights.Equal(that1.GetWeights) {
		return fmt.Errorf("GetWeights this(%v) Not Equal that(%v)", this.GetWeights, that1.GetWeights)
	}
	if !this.GetMaster.Equal(that1.GetMaster) {
		return fmt.Errorf("GetMaster this(%v) Not Equal that(%v)", this.GetMaster, that1.GetMaster)
	}
	if !this.GetMaintenanceStatus.Equal(that1.GetMaintenanceStatus) {
		return fmt.Errorf("GetMaintenanceStatus this(%v) Not Equal that(%v)", this.GetMaintenanceStatus, that1.GetMaintenanceStatus)
	}
	if !this.GetMaintenanceSchedule.Equal(that1.GetMaintenanceSchedule) {
		return fmt.Errorf("GetMaintenanceSchedule this(%v) Not Equal that(%v)", this.GetMaintenanceSchedule, that1.GetMaintenanceSchedule)
	}
	if !this.GetQuota.Equal(that1.GetQuota) {
		return fmt.Errorf("GetQuota this(%v) Not Equal that(%v)", this.GetQuota, that1.GetQuota)
	}
	return nil
}
func (this *Response) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response)
	if !ok {
		that2, ok := that.(Response)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if !this.GetHealth.Equal(that1.GetHealth) {
		return false
	}
	if !this.GetFlags.Equal(that1.GetFlags) {
		return false
	}
	if !this.GetVersion.Equal(that1.GetVersion) {
		return false
	}
	if !this.GetMetrics.Equal(that1.GetMetrics) {
		return false
	}
	if !this.GetLoggingLevel.Equal(that1.GetLoggingLevel) {
		return false
	}
	if !this.ListFiles.Equal(that1.ListFiles) {
		return false
	}
	if !this.ReadFile.Equal(that1.ReadFile) {
		return false
	}
	if !this.GetState.Equal(that1.GetState) {
		return false
	}
	if !this.GetAgents.Equal(that1.GetAgents) {
		return false
	}
	if !this.GetFrameworks.Equal(that1.GetFrameworks) {
		return false
	}
	if !this.GetExecutors.Equal(that1.GetExecutors) {
		return false
	}
	if !this.GetTasks.Equal(that1.GetTasks) {
		return false
	}
	if !this.GetRoles.Equal(that1.GetRoles) {
		return false
	}
	if !this.GetWeights.Equal(that1.GetWeights) {
		return false
	}
	if !this.GetMaster.Equal(that1.GetMaster) {
		return false
	}
	if !this.GetMaintenanceStatus.Equal(that1.GetMaintenanceStatus) {
		return false
	}
	if !this.GetMaintenanceSchedule.Equal(that1.GetMaintenanceSchedule) {
		return false
	}
	if !this.GetQuota.Equal(that1.GetQuota) {
		return false
	}
	return true
}
func (this *Response_GetHealth) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_GetHealth)
	if !ok {
		that2, ok := that.(Response_GetHealth)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_GetHealth")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_GetHealth but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_GetHealth but is not nil && this == nil")
	}
	if this.Healthy != that1.Healthy {
		return fmt.Errorf("Healthy this(%v) Not Equal that(%v)", this.Healthy, that1.Healthy)
	}
	return nil
}
func (this *Response_GetHealth) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_GetHealth)
	if !ok {
		that2, ok := that.(Response_GetHealth)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Healthy != that1.Healthy {
		return false
	}
	return true
}
func (this *Response_GetFlags) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_GetFlags)
	if !ok {
		that2, ok := that.(Response_GetFlags)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_GetFlags")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_GetFlags but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_GetFlags but is not nil && this == nil")
	}
	if len(this.Flags) != len(that1.Flags) {
		return fmt.Errorf("Flags this(%v) Not Equal that(%v)", len(this.Flags), len(that1.Flags))
	}
	for i := range this.Flags {
		if !this.Flags[i].Equal(&that1.Flags[i]) {
			return fmt.Errorf("Flags this[%v](%v) Not Equal that[%v](%v)", i, this.Flags[i], i, that1.Flags[i])
		}
	}
	return nil
}
func (this *Response_GetFlags) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_GetFlags)
	if !ok {
		that2, ok := that.(Response_GetFlags)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Flags) != len(that1.Flags) {
		return false
	}
	for i := range this.Flags {
		if !this.Flags[i].Equal(&that1.Flags[i]) {
			return false
		}
	}
	return true
}
func (this *Response_GetVersion) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_GetVersion)
	if !ok {
		that2, ok := that.(Response_GetVersion)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_GetVersion")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_GetVersion but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_GetVersion but is not nil && this == nil")
	}
	if !this.VersionInfo.Equal(&that1.VersionInfo) {
		return fmt.Errorf("VersionInfo this(%v) Not Equal that(%v)", this.VersionInfo, that1.VersionInfo)
	}
	return nil
}
func (this *Response_GetVersion) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_GetVersion)
	if !ok {
		that2, ok := that.(Response_GetVersion)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.VersionInfo.Equal(&that1.VersionInfo) {
		return false
	}
	return true
}
func (this *Response_GetMetrics) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_GetMetrics)
	if !ok {
		that2, ok := that.(Response_GetMetrics)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_GetMetrics")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_GetMetrics but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_GetMetrics but is not nil && this == nil")
	}
	if len(this.Metrics) != len(that1.Metrics) {
		return fmt.Errorf("Metrics this(%v) Not Equal that(%v)", len(this.Metrics), len(that1.Metrics))
	}
	for i := range this.Metrics {
		if !this.Metrics[i].Equal(&that1.Metrics[i]) {
			return fmt.Errorf("Metrics this[%v](%v) Not Equal that[%v](%v)", i, this.Metrics[i], i, that1.Metrics[i])
		}
	}
	return nil
}
func (this *Response_GetMetrics) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_GetMetrics)
	if !ok {
		that2, ok := that.(Response_GetMetrics)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Metrics) != len(that1.Metrics) {
		return false
	}
	for i := range this.Metrics {
		if !this.Metrics[i].Equal(&that1.Metrics[i]) {
			return false
		}
	}
	return true
}
func (this *Response_GetLoggingLevel) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_GetLoggingLevel)
	if !ok {
		that2, ok := that.(Response_GetLoggingLevel)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_GetLoggingLevel")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_GetLoggingLevel but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_GetLoggingLevel but is not nil && this == nil")
	}
	if this.Level != that1.Level {
		return fmt.Errorf("Level this(%v) Not Equal that(%v)", this.Level, that1.Level)
	}
	return nil
}
func (this *Response_GetLoggingLevel) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_GetLoggingLevel)
	if !ok {
		that2, ok := that.(Response_GetLoggingLevel)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Level != that1.Level {
		return false
	}
	return true
}
func (this *Response_ListFiles) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_ListFiles)
	if !ok {
		that2, ok := that.(Response_ListFiles)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_ListFiles")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_ListFiles but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_ListFiles but is not nil && this == nil")
	}
	if len(this.FileInfos) != len(that1.FileInfos) {
		return fmt.Errorf("FileInfos this(%v) Not Equal that(%v)", len(this.FileInfos), len(that1.FileInfos))
	}
	for i := range this.FileInfos {
		if !this.FileInfos[i].Equal(&that1.FileInfos[i]) {
			return fmt.Errorf("FileInfos this[%v](%v) Not Equal that[%v](%v)", i, this.FileInfos[i], i, that1.FileInfos[i])
		}
	}
	return nil
}
func (this *Response_ListFiles) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_ListFiles)
	if !ok {
		that2, ok := that.(Response_ListFiles)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.FileInfos) != len(that1.FileInfos) {
		return false
	}
	for i := range this.FileInfos {
		if !this.FileInfos[i].Equal(&that1.FileInfos[i]) {
			return false
		}
	}
	return true
}
func (this *Response_ReadFile) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_ReadFile)
	if !ok {
		that2, ok := that.(Response_ReadFile)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_ReadFile")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_ReadFile but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_ReadFile but is not nil && this == nil")
	}
	if this.Size != that1.Size {
		return fmt.Errorf("Size this(%v) Not Equal that(%v)", this.Size, that1.Size)
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return fmt.Errorf("Data this(%v) Not Equal that(%v)", this.Data, that1.Data)
	}
	return nil
}
func (this *Response_ReadFile) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_ReadFile)
	if !ok {
		that2, ok := that.(Response_ReadFile)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Size != that1.Size {
		return false
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return false
	}
	return true
}
func (this *Response_GetState) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_GetState)
	if !ok {
		that2, ok := that.(Response_GetState)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_GetState")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_GetState but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_GetState but is not nil && this == nil")
	}
	if !this.GetTasks.Equal(that1.GetTasks) {
		return fmt.Errorf("GetTasks this(%v) Not Equal that(%v)", this.GetTasks, that1.GetTasks)
	}
	if !this.GetExecutors.Equal(that1.GetExecutors) {
		return fmt.Errorf("GetExecutors this(%v) Not Equal that(%v)", this.GetExecutors, that1.GetExecutors)
	}
	if !this.GetFrameworks.Equal(that1.GetFrameworks) {
		return fmt.Errorf("GetFrameworks this(%v) Not Equal that(%v)", this.GetFrameworks, that1.GetFrameworks)
	}
	if !this.GetAgents.Equal(that1.GetAgents) {
		return fmt.Errorf("GetAgents this(%v) Not Equal that(%v)", this.GetAgents, that1.GetAgents)
	}
	return nil
}
func (this *Response_GetState) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_GetState)
	if !ok {
		that2, ok := that.(Response_GetState)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.GetTasks.Equal(that1.GetTasks) {
		return false
	}
	if !this.GetExecutors.Equal(that1.GetExecutors) {
		return false
	}
	if !this.GetFrameworks.Equal(that1.GetFrameworks) {
		return false
	}
	if !this.GetAgents.Equal(that1.GetAgents) {
		return false
	}
	return true
}
func (this *Response_GetAgents) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_GetAgents)
	if !ok {
		that2, ok := that.(Response_GetAgents)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_GetAgents")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_GetAgents but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_GetAgents but is not nil && this == nil")
	}
	if len(this.Agents) != len(that1.Agents) {
		return fmt.Errorf("Agents this(%v) Not Equal that(%v)", len(this.Agents), len(that1.Agents))
	}
	for i := range this.Agents {
		if !this.Agents[i].Equal(&that1.Agents[i]) {
			return fmt.Errorf("Agents this[%v](%v) Not Equal that[%v](%v)", i, this.Agents[i], i, that1.Agents[i])
		}
	}
	if len(this.RecoveredAgents) != len(that1.RecoveredAgents) {
		return fmt.Errorf("RecoveredAgents this(%v) Not Equal that(%v)", len(this.RecoveredAgents), len(that1.RecoveredAgents))
	}
	for i := range this.RecoveredAgents {
		if !this.RecoveredAgents[i].Equal(&that1.RecoveredAgents[i]) {
			return fmt.Errorf("RecoveredAgents this[%v](%v) Not Equal that[%v](%v)", i, this.RecoveredAgents[i], i, that1.RecoveredAgents[i])
		}
	}
	return nil
}
func (this *Response_GetAgents) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_GetAgents)
	if !ok {
		that2, ok := that.(Response_GetAgents)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Agents) != len(that1.Agents) {
		return false
	}
	for i := range this.Agents {
		if !this.Agents[i].Equal(&that1.Agents[i]) {
			return false
		}
	}
	if len(this.RecoveredAgents) != len(that1.RecoveredAgents) {
		return false
	}
	for i := range this.RecoveredAgents {
		if !this.RecoveredAgents[i].Equal(&that1.RecoveredAgents[i]) {
			return false
		}
	}
	return true
}
func (this *Response_GetAgents_Agent) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_GetAgents_Agent)
	if !ok {
		that2, ok := that.(Response_GetAgents_Agent)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_GetAgents_Agent")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_GetAgents_Agent but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_GetAgents_Agent but is not nil && this == nil")
	}
	if !this.AgentInfo.Equal(&that1.AgentInfo) {
		return fmt.Errorf("AgentInfo this(%v) Not Equal that(%v)", this.AgentInfo, that1.AgentInfo)
	}
	if this.Active != that1.Active {
		return fmt.Errorf("Active this(%v) Not Equal that(%v)", this.Active, that1.Active)
	}
	if this.Version != that1.Version {
		return fmt.Errorf("Version this(%v) Not Equal that(%v)", this.Version, that1.Version)
	}
	if this.PID != nil && that1.PID != nil {
		if *this.PID != *that1.PID {
			return fmt.Errorf("PID this(%v) Not Equal that(%v)", *this.PID, *that1.PID)
		}
	} else if this.PID != nil {
		return fmt.Errorf("this.PID == nil && that.PID != nil")
	} else if that1.PID != nil {
		return fmt.Errorf("PID this(%v) Not Equal that(%v)", this.PID, that1.PID)
	}
	if !this.RegisteredTime.Equal(that1.RegisteredTime) {
		return fmt.Errorf("RegisteredTime this(%v) Not Equal that(%v)", this.RegisteredTime, that1.RegisteredTime)
	}
	if !this.ReregisteredTime.Equal(that1.ReregisteredTime) {
		return fmt.Errorf("ReregisteredTime this(%v) Not Equal that(%v)", this.ReregisteredTime, that1.ReregisteredTime)
	}
	if len(this.TotalResources) != len(that1.TotalResources) {
		return fmt.Errorf("TotalResources this(%v) Not Equal that(%v)", len(this.TotalResources), len(that1.TotalResources))
	}
	for i := range this.TotalResources {
		if !this.TotalResources[i].Equal(&that1.TotalResources[i]) {
			return fmt.Errorf("TotalResources this[%v](%v) Not Equal that[%v](%v)", i, this.TotalResources[i], i, that1.TotalResources[i])
		}
	}
	if len(this.AllocatedResources) != len(that1.AllocatedResources) {
		return fmt.Errorf("AllocatedResources this(%v) Not Equal that(%v)", len(this.AllocatedResources), len(that1.AllocatedResources))
	}
	for i := range this.AllocatedResources {
		if !this.AllocatedResources[i].Equal(&that1.AllocatedResources[i]) {
			return fmt.Errorf("AllocatedResources this[%v](%v) Not Equal that[%v](%v)", i, this.AllocatedResources[i], i, that1.AllocatedResources[i])
		}
	}
	if len(this.OfferedResources) != len(that1.OfferedResources) {
		return fmt.Errorf("OfferedResources this(%v) Not Equal that(%v)", len(this.OfferedResources), len(that1.OfferedResources))
	}
	for i := range this.OfferedResources {
		if !this.OfferedResources[i].Equal(&that1.OfferedResources[i]) {
			return fmt.Errorf("OfferedResources this[%v](%v) Not Equal that[%v](%v)", i, this.OfferedResources[i], i, that1.OfferedResources[i])
		}
	}
	if len(this.Capabilities) != len(that1.Capabilities) {
		return fmt.Errorf("Capabilities this(%v) Not Equal that(%v)", len(this.Capabilities), len(that1.Capabilities))
	}
	for i := range this.Capabilities {
		if !this.Capabilities[i].Equal(&that1.Capabilities[i]) {
			return fmt.Errorf("Capabilities this[%v](%v) Not Equal that[%v](%v)", i, this.Capabilities[i], i, that1.Capabilities[i])
		}
	}
	if len(this.ResourceProviders) != len(that1.ResourceProviders) {
		return fmt.Errorf("ResourceProviders this(%v) Not Equal that(%v)", len(this.ResourceProviders), len(that1.ResourceProviders))
	}
	for i := range this.ResourceProviders {
		if !this.ResourceProviders[i].Equal(&that1.ResourceProviders[i]) {
			return fmt.Errorf("ResourceProviders this[%v](%v) Not Equal that[%v](%v)", i, this.ResourceProviders[i], i, that1.ResourceProviders[i])
		}
	}
	return nil
}
func (this *Response_GetAgents_Agent) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_GetAgents_Agent)
	if !ok {
		that2, ok := that.(Response_GetAgents_Agent)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.AgentInfo.Equal(&that1.AgentInfo) {
		return false
	}
	if this.Active != that1.Active {
		return false
	}
	if this.Version != that1.Version {
		return false
	}
	if this.PID != nil && that1.PID != nil {
		if *this.PID != *that1.PID {
			return false
		}
	} else if this.PID != nil {
		return false
	} else if that1.PID != nil {
		return false
	}
	if !this.RegisteredTime.Equal(that1.RegisteredTime) {
		return false
	}
	if !this.ReregisteredTime.Equal(that1.ReregisteredTime) {
		return false
	}
	if len(this.TotalResources) != len(that1.TotalResources) {
		return false
	}
	for i := range this.TotalResources {
		if !this.TotalResources[i].Equal(&that1.TotalResources[i]) {
			return false
		}
	}
	if len(this.AllocatedResources) != len(that1.AllocatedResources) {
		return false
	}
	for i := range this.AllocatedResources {
		if !this.AllocatedResources[i].Equal(&that1.AllocatedResources[i]) {
			return false
		}
	}
	if len(this.OfferedResources) != len(that1.OfferedResources) {
		return false
	}
	for i := range this.OfferedResources {
		if !this.OfferedResources[i].Equal(&that1.OfferedResources[i]) {
			return false
		}
	}
	if len(this.Capabilities) != len(that1.Capabilities) {
		return false
	}
	for i := range this.Capabilities {
		if !this.Capabilities[i].Equal(&that1.Capabilities[i]) {
			return false
		}
	}
	if len(this.ResourceProviders) != len(that1.ResourceProviders) {
		return false
	}
	for i := range this.ResourceProviders {
		if !this.ResourceProviders[i].Equal(&that1.ResourceProviders[i]) {
			return false
		}
	}
	return true
}
func (this *Response_GetAgents_Agent_ResourceProvider) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_GetAgents_Agent_ResourceProvider)
	if !ok {
		that2, ok := that.(Response_GetAgents_Agent_ResourceProvider)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_GetAgents_Agent_ResourceProvider")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_GetAgents_Agent_ResourceProvider but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_GetAgents_Agent_ResourceProvider but is not nil && this == nil")
	}
	if !this.ResourceProviderInfo.Equal(&that1.ResourceProviderInfo) {
		return fmt.Errorf("ResourceProviderInfo this(%v) Not Equal that(%v)", this.ResourceProviderInfo, that1.ResourceProviderInfo)
	}
	return nil
}
func (this *Response_GetAgents_Agent_ResourceProvider) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_GetAgents_Agent_ResourceProvider)
	if !ok {
		that2, ok := that.(Response_GetAgents_Agent_ResourceProvider)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.ResourceProviderInfo.Equal(&that1.ResourceProviderInfo) {
		return false
	}
	return true
}
func (this *Response_GetFrameworks) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_GetFrameworks)
	if !ok {
		that2, ok := that.(Response_GetFrameworks)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_GetFrameworks")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_GetFrameworks but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_GetFrameworks but is not nil && this == nil")
	}
	if len(this.Frameworks) != len(that1.Frameworks) {
		return fmt.Errorf("Frameworks this(%v) Not Equal that(%v)", len(this.Frameworks), len(that1.Frameworks))
	}
	for i := range this.Frameworks {
		if !this.Frameworks[i].Equal(&that1.Frameworks[i]) {
			return fmt.Errorf("Frameworks this[%v](%v) Not Equal that[%v](%v)", i, this.Frameworks[i], i, that1.Frameworks[i])
		}
	}
	if len(this.CompletedFrameworks) != len(that1.CompletedFrameworks) {
		return fmt.Errorf("CompletedFrameworks this(%v) Not Equal that(%v)", len(this.CompletedFrameworks), len(that1.CompletedFrameworks))
	}
	for i := range this.CompletedFrameworks {
		if !this.CompletedFrameworks[i].Equal(&that1.CompletedFrameworks[i]) {
			return fmt.Errorf("CompletedFrameworks this[%v](%v) Not Equal that[%v](%v)", i, this.CompletedFrameworks[i], i, that1.CompletedFrameworks[i])
		}
	}
	if len(this.RecoveredFrameworks) != len(that1.RecoveredFrameworks) {
		return fmt.Errorf("RecoveredFrameworks this(%v) Not Equal that(%v)", len(this.RecoveredFrameworks), len(that1.RecoveredFrameworks))
	}
	for i := range this.RecoveredFrameworks {
		if !this.RecoveredFrameworks[i].Equal(&that1.RecoveredFrameworks[i]) {
			return fmt.Errorf("RecoveredFrameworks this[%v](%v) Not Equal that[%v](%v)", i, this.RecoveredFrameworks[i], i, that1.RecoveredFrameworks[i])
		}
	}
	return nil
}
func (this *Response_GetFrameworks) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_GetFrameworks)
	if !ok {
		that2, ok := that.(Response_GetFrameworks)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Frameworks) != len(that1.Frameworks) {
		return false
	}
	for i := range this.Frameworks {
		if !this.Frameworks[i].Equal(&that1.Frameworks[i]) {
			return false
		}
	}
	if len(this.CompletedFrameworks) != len(that1.CompletedFrameworks) {
		return false
	}
	for i := range this.CompletedFrameworks {
		if !this.CompletedFrameworks[i].Equal(&that1.CompletedFrameworks[i]) {
			return false
		}
	}
	if len(this.RecoveredFrameworks) != len(that1.RecoveredFrameworks) {
		return false
	}
	for i := range this.RecoveredFrameworks {
		if !this.RecoveredFrameworks[i].Equal(&that1.RecoveredFrameworks[i]) {
			return false
		}
	}
	return true
}
func (this *Response_GetFrameworks_Framework) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_GetFrameworks_Framework)
	if !ok {
		that2, ok := that.(Response_GetFrameworks_Framework)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_GetFrameworks_Framework")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_GetFrameworks_Framework but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_GetFrameworks_Framework but is not nil && this == nil")
	}
	if !this.FrameworkInfo.Equal(&that1.FrameworkInfo) {
		return fmt.Errorf("FrameworkInfo this(%v) Not Equal that(%v)", this.FrameworkInfo, that1.FrameworkInfo)
	}
	if this.Active != that1.Active {
		return fmt.Errorf("Active this(%v) Not Equal that(%v)", this.Active, that1.Active)
	}
	if this.Connected != that1.Connected {
		return fmt.Errorf("Connected this(%v) Not Equal that(%v)", this.Connected, that1.Connected)
	}
	if this.Recovered != that1.Recovered {
		return fmt.Errorf("Recovered this(%v) Not Equal that(%v)", this.Recovered, that1.Recovered)
	}
	if !this.RegisteredTime.Equal(that1.RegisteredTime) {
		return fmt.Errorf("RegisteredTime this(%v) Not Equal that(%v)", this.RegisteredTime, that1.RegisteredTime)
	}
	if !this.ReregisteredTime.Equal(that1.ReregisteredTime) {
		return fmt.Errorf("ReregisteredTime this(%v) Not Equal that(%v)", this.ReregisteredTime, that1.ReregisteredTime)
	}
	if !this.UnregisteredTime.Equal(that1.UnregisteredTime) {
		return fmt.Errorf("UnregisteredTime this(%v) Not Equal that(%v)", this.UnregisteredTime, that1.UnregisteredTime)
	}
	if len(this.Offers) != len(that1.Offers) {
		return fmt.Errorf("Offers this(%v) Not Equal that(%v)", len(this.Offers), len(that1.Offers))
	}
	for i := range this.Offers {
		if !this.Offers[i].Equal(&that1.Offers[i]) {
			return fmt.Errorf("Offers this[%v](%v) Not Equal that[%v](%v)", i, this.Offers[i], i, that1.Offers[i])
		}
	}
	if len(this.InverseOffers) != len(that1.InverseOffers) {
		return fmt.Errorf("InverseOffers this(%v) Not Equal that(%v)", len(this.InverseOffers), len(that1.InverseOffers))
	}
	for i := range this.InverseOffers {
		if !this.InverseOffers[i].Equal(&that1.InverseOffers[i]) {
			return fmt.Errorf("InverseOffers this[%v](%v) Not Equal that[%v](%v)", i, this.InverseOffers[i], i, that1.InverseOffers[i])
		}
	}
	if len(this.AllocatedResources) != len(that1.AllocatedResources) {
		return fmt.Errorf("AllocatedResources this(%v) Not Equal that(%v)", len(this.AllocatedResources), len(that1.AllocatedResources))
	}
	for i := range this.AllocatedResources {
		if !this.AllocatedResources[i].Equal(&that1.AllocatedResources[i]) {
			return fmt.Errorf("AllocatedResources this[%v](%v) Not Equal that[%v](%v)", i, this.AllocatedResources[i], i, that1.AllocatedResources[i])
		}
	}
	if len(this.OfferedResources) != len(that1.OfferedResources) {
		return fmt.Errorf("OfferedResources this(%v) Not Equal that(%v)", len(this.OfferedResources), len(that1.OfferedResources))
	}
	for i := range this.OfferedResources {
		if !this.OfferedResources[i].Equal(&that1.OfferedResources[i]) {
			return fmt.Errorf("OfferedResources this[%v](%v) Not Equal that[%v](%v)", i, this.OfferedResources[i], i, that1.OfferedResources[i])
		}
	}
	return nil
}
func (this *Response_GetFrameworks_Framework) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_GetFrameworks_Framework)
	if !ok {
		that2, ok := that.(Response_GetFrameworks_Framework)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.FrameworkInfo.Equal(&that1.FrameworkInfo) {
		return false
	}
	if this.Active != that1.Active {
		return false
	}
	if this.Connected != that1.Connected {
		return false
	}
	if this.Recovered != that1.Recovered {
		return false
	}
	if !this.RegisteredTime.Equal(that1.RegisteredTime) {
		return false
	}
	if !this.ReregisteredTime.Equal(that1.ReregisteredTime) {
		return false
	}
	if !this.UnregisteredTime.Equal(that1.UnregisteredTime) {
		return false
	}
	if len(this.Offers) != len(that1.Offers) {
		return false
	}
	for i := range this.Offers {
		if !this.Offers[i].Equal(&that1.Offers[i]) {
			return false
		}
	}
	if len(this.InverseOffers) != len(that1.InverseOffers) {
		return false
	}
	for i := range this.InverseOffers {
		if !this.InverseOffers[i].Equal(&that1.InverseOffers[i]) {
			return false
		}
	}
	if len(this.AllocatedResources) != len(that1.AllocatedResources) {
		return false
	}
	for i := range this.AllocatedResources {
		if !this.AllocatedResources[i].Equal(&that1.AllocatedResources[i]) {
			return false
		}
	}
	if len(this.OfferedResources) != len(that1.OfferedResources) {
		return false
	}
	for i := range this.OfferedResources {
		if !this.OfferedResources[i].Equal(&that1.OfferedResources[i]) {
			return false
		}
	}
	return true
}
func (this *Response_GetExecutors) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_GetExecutors)
	if !ok {
		that2, ok := that.(Response_GetExecutors)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_GetExecutors")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_GetExecutors but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_GetExecutors but is not nil && this == nil")
	}
	if len(this.Executors) != len(that1.Executors) {
		return fmt.Errorf("Executors this(%v) Not Equal that(%v)", len(this.Executors), len(that1.Executors))
	}
	for i := range this.Executors {
		if !this.Executors[i].Equal(&that1.Executors[i]) {
			return fmt.Errorf("Executors this[%v](%v) Not Equal that[%v](%v)", i, this.Executors[i], i, that1.Executors[i])
		}
	}
	if len(this.OrphanExecutors) != len(that1.OrphanExecutors) {
		return fmt.Errorf("OrphanExecutors this(%v) Not Equal that(%v)", len(this.OrphanExecutors), len(that1.OrphanExecutors))
	}
	for i := range this.OrphanExecutors {
		if !this.OrphanExecutors[i].Equal(&that1.OrphanExecutors[i]) {
			return fmt.Errorf("OrphanExecutors this[%v](%v) Not Equal that[%v](%v)", i, this.OrphanExecutors[i], i, that1.OrphanExecutors[i])
		}
	}
	return nil
}
func (this *Response_GetExecutors) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_GetExecutors)
	if !ok {
		that2, ok := that.(Response_GetExecutors)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Executors) != len(that1.Executors) {
		return false
	}
	for i := range this.Executors {
		if !this.Executors[i].Equal(&that1.Executors[i]) {
			return false
		}
	}
	if len(this.OrphanExecutors) != len(that1.OrphanExecutors) {
		return false
	}
	for i := range this.OrphanExecutors {
		if !this.OrphanExecutors[i].Equal(&that1.OrphanExecutors[i]) {
			return false
		}
	}
	return true
}
func (this *Response_GetExecutors_Executor) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_GetExecutors_Executor)
	if !ok {
		that2, ok := that.(Response_GetExecutors_Executor)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_GetExecutors_Executor")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_GetExecutors_Executor but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_GetExecutors_Executor but is not nil && this == nil")
	}
	if !this.ExecutorInfo.Equal(&that1.ExecutorInfo) {
		return fmt.Errorf("ExecutorInfo this(%v) Not Equal that(%v)", this.ExecutorInfo, that1.ExecutorInfo)
	}
	if !this.AgentID.Equal(&that1.AgentID) {
		return fmt.Errorf("AgentID this(%v) Not Equal that(%v)", this.AgentID, that1.AgentID)
	}
	return nil
}
func (this *Response_GetExecutors_Executor) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_GetExecutors_Executor)
	if !ok {
		that2, ok := that.(Response_GetExecutors_Executor)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.ExecutorInfo.Equal(&that1.ExecutorInfo) {
		return false
	}
	if !this.AgentID.Equal(&that1.AgentID) {
		return false
	}
	return true
}
func (this *Response_GetTasks) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_GetTasks)
	if !ok {
		that2, ok := that.(Response_GetTasks)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_GetTasks")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_GetTasks but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_GetTasks but is not nil && this == nil")
	}
	if len(this.PendingTasks) != len(that1.PendingTasks) {
		return fmt.Errorf("PendingTasks this(%v) Not Equal that(%v)", len(this.PendingTasks), len(that1.PendingTasks))
	}
	for i := range this.PendingTasks {
		if !this.PendingTasks[i].Equal(&that1.PendingTasks[i]) {
			return fmt.Errorf("PendingTasks this[%v](%v) Not Equal that[%v](%v)", i, this.PendingTasks[i], i, that1.PendingTasks[i])
		}
	}
	if len(this.Tasks) != len(that1.Tasks) {
		return fmt.Errorf("Tasks this(%v) Not Equal that(%v)", len(this.Tasks), len(that1.Tasks))
	}
	for i := range this.Tasks {
		if !this.Tasks[i].Equal(&that1.Tasks[i]) {
			return fmt.Errorf("Tasks this[%v](%v) Not Equal that[%v](%v)", i, this.Tasks[i], i, that1.Tasks[i])
		}
	}
	if len(this.UnreachableTasks) != len(that1.UnreachableTasks) {
		return fmt.Errorf("UnreachableTasks this(%v) Not Equal that(%v)", len(this.UnreachableTasks), len(that1.UnreachableTasks))
	}
	for i := range this.UnreachableTasks {
		if !this.UnreachableTasks[i].Equal(&that1.UnreachableTasks[i]) {
			return fmt.Errorf("UnreachableTasks this[%v](%v) Not Equal that[%v](%v)", i, this.UnreachableTasks[i], i, that1.UnreachableTasks[i])
		}
	}
	if len(this.CompletedTasks) != len(that1.CompletedTasks) {
		return fmt.Errorf("CompletedTasks this(%v) Not Equal that(%v)", len(this.CompletedTasks), len(that1.CompletedTasks))
	}
	for i := range this.CompletedTasks {
		if !this.CompletedTasks[i].Equal(&that1.CompletedTasks[i]) {
			return fmt.Errorf("CompletedTasks this[%v](%v) Not Equal that[%v](%v)", i, this.CompletedTasks[i], i, that1.CompletedTasks[i])
		}
	}
	if len(this.OrphanTasks) != len(that1.OrphanTasks) {
		return fmt.Errorf("OrphanTasks this(%v) Not Equal that(%v)", len(this.OrphanTasks), len(that1.OrphanTasks))
	}
	for i := range this.OrphanTasks {
		if !this.OrphanTasks[i].Equal(&that1.OrphanTasks[i]) {
			return fmt.Errorf("OrphanTasks this[%v](%v) Not Equal that[%v](%v)", i, this.OrphanTasks[i], i, that1.OrphanTasks[i])
		}
	}
	return nil
}
func (this *Response_GetTasks) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_GetTasks)
	if !ok {
		that2, ok := that.(Response_GetTasks)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.PendingTasks) != len(that1.PendingTasks) {
		return false
	}
	for i := range this.PendingTasks {
		if !this.PendingTasks[i].Equal(&that1.PendingTasks[i]) {
			return false
		}
	}
	if len(this.Tasks) != len(that1.Tasks) {
		return false
	}
	for i := range this.Tasks {
		if !this.Tasks[i].Equal(&that1.Tasks[i]) {
			return false
		}
	}
	if len(this.UnreachableTasks) != len(that1.UnreachableTasks) {
		return false
	}
	for i := range this.UnreachableTasks {
		if !this.UnreachableTasks[i].Equal(&that1.UnreachableTasks[i]) {
			return false
		}
	}
	if len(this.CompletedTasks) != len(that1.CompletedTasks) {
		return false
	}
	for i := range this.CompletedTasks {
		if !this.CompletedTasks[i].Equal(&that1.CompletedTasks[i]) {
			return false
		}
	}
	if len(this.OrphanTasks) != len(that1.OrphanTasks) {
		return false
	}
	for i := range this.OrphanTasks {
		if !this.OrphanTasks[i].Equal(&that1.OrphanTasks[i]) {
			return false
		}
	}
	return true
}
func (this *Response_GetRoles) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_GetRoles)
	if !ok {
		that2, ok := that.(Response_GetRoles)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_GetRoles")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_GetRoles but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_GetRoles but is not nil && this == nil")
	}
	if len(this.Roles) != len(that1.Roles) {
		return fmt.Errorf("Roles this(%v) Not Equal that(%v)", len(this.Roles), len(that1.Roles))
	}
	for i := range this.Roles {
		if !this.Roles[i].Equal(&that1.Roles[i]) {
			return fmt.Errorf("Roles this[%v](%v) Not Equal that[%v](%v)", i, this.Roles[i], i, that1.Roles[i])
		}
	}
	return nil
}
func (this *Response_GetRoles) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_GetRoles)
	if !ok {
		that2, ok := that.(Response_GetRoles)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Roles) != len(that1.Roles) {
		return false
	}
	for i := range this.Roles {
		if !this.Roles[i].Equal(&that1.Roles[i]) {
			return false
		}
	}
	return true
}
func (this *Response_GetWeights) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_GetWeights)
	if !ok {
		that2, ok := that.(Response_GetWeights)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_GetWeights")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_GetWeights but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_GetWeights but is not nil && this == nil")
	}
	if len(this.WeightInfos) != len(that1.WeightInfos) {
		return fmt.Errorf("WeightInfos this(%v) Not Equal that(%v)", len(this.WeightInfos), len(that1.WeightInfos))
	}
	for i := range this.WeightInfos {
		if !this.WeightInfos[i].Equal(&that1.WeightInfos[i]) {
			return fmt.Errorf("WeightInfos this[%v](%v) Not Equal that[%v](%v)", i, this.WeightInfos[i], i, that1.WeightInfos[i])
		}
	}
	return nil
}
func (this *Response_GetWeights) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_GetWeights)
	if !ok {
		that2, ok := that.(Response_GetWeights)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.WeightInfos) != len(that1.WeightInfos) {
		return false
	}
	for i := range this.WeightInfos {
		if !this.WeightInfos[i].Equal(&that1.WeightInfos[i]) {
			return false
		}
	}
	return true
}
func (this *Response_GetMaster) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_GetMaster)
	if !ok {
		that2, ok := that.(Response_GetMaster)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_GetMaster")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_GetMaster but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_GetMaster but is not nil && this == nil")
	}
	if !this.MasterInfo.Equal(that1.MasterInfo) {
		return fmt.Errorf("MasterInfo this(%v) Not Equal that(%v)", this.MasterInfo, that1.MasterInfo)
	}
	if this.StartTime != nil && that1.StartTime != nil {
		if *this.StartTime != *that1.StartTime {
			return fmt.Errorf("StartTime this(%v) Not Equal that(%v)", *this.StartTime, *that1.StartTime)
		}
	} else if this.StartTime != nil {
		return fmt.Errorf("this.StartTime == nil && that.StartTime != nil")
	} else if that1.StartTime != nil {
		return fmt.Errorf("StartTime this(%v) Not Equal that(%v)", this.StartTime, that1.StartTime)
	}
	if this.ElectedTime != nil && that1.ElectedTime != nil {
		if *this.ElectedTime != *that1.ElectedTime {
			return fmt.Errorf("ElectedTime this(%v) Not Equal that(%v)", *this.ElectedTime, *that1.ElectedTime)
		}
	} else if this.ElectedTime != nil {
		return fmt.Errorf("this.ElectedTime == nil && that.ElectedTime != nil")
	} else if that1.ElectedTime != nil {
		return fmt.Errorf("ElectedTime this(%v) Not Equal that(%v)", this.ElectedTime, that1.ElectedTime)
	}
	return nil
}
func (this *Response_GetMaster) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_GetMaster)
	if !ok {
		that2, ok := that.(Response_GetMaster)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.MasterInfo.Equal(that1.MasterInfo) {
		return false
	}
	if this.StartTime != nil && that1.StartTime != nil {
		if *this.StartTime != *that1.StartTime {
			return false
		}
	} else if this.StartTime != nil {
		return false
	} else if that1.StartTime != nil {
		return false
	}
	if this.ElectedTime != nil && that1.ElectedTime != nil {
		if *this.ElectedTime != *that1.ElectedTime {
			return false
		}
	} else if this.ElectedTime != nil {
		return false
	} else if that1.ElectedTime != nil {
		return false
	}
	return true
}
func (this *Response_GetMaintenanceStatus) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_GetMaintenanceStatus)
	if !ok {
		that2, ok := that.(Response_GetMaintenanceStatus)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_GetMaintenanceStatus")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_GetMaintenanceStatus but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_GetMaintenanceStatus but is not nil && this == nil")
	}
	if !this.Status.Equal(&that1.Status) {
		return fmt.Errorf("Status this(%v) Not Equal that(%v)", this.Status, that1.Status)
	}
	return nil
}
func (this *Response_GetMaintenanceStatus) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_GetMaintenanceStatus)
	if !ok {
		that2, ok := that.(Response_GetMaintenanceStatus)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Status.Equal(&that1.Status) {
		return false
	}
	return true
}
func (this *Response_GetMaintenanceSchedule) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_GetMaintenanceSchedule)
	if !ok {
		that2, ok := that.(Response_GetMaintenanceSchedule)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_GetMaintenanceSchedule")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_GetMaintenanceSchedule but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_GetMaintenanceSchedule but is not nil && this == nil")
	}
	if !this.Schedule.Equal(&that1.Schedule) {
		return fmt.Errorf("Schedule this(%v) Not Equal that(%v)", this.Schedule, that1.Schedule)
	}
	return nil
}
func (this *Response_GetMaintenanceSchedule) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_GetMaintenanceSchedule)
	if !ok {
		that2, ok := that.(Response_GetMaintenanceSchedule)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Schedule.Equal(&that1.Schedule) {
		return false
	}
	return true
}
func (this *Response_GetQuota) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_GetQuota)
	if !ok {
		that2, ok := that.(Response_GetQuota)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_GetQuota")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_GetQuota but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_GetQuota but is not nil && this == nil")
	}
	if !this.Status.Equal(&that1.Status) {
		return fmt.Errorf("Status this(%v) Not Equal that(%v)", this.Status, that1.Status)
	}
	return nil
}
func (this *Response_GetQuota) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_GetQuota)
	if !ok {
		that2, ok := that.(Response_GetQuota)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Status.Equal(&that1.Status) {
		return false
	}
	return true
}
func (this *Event) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Event)
	if !ok {
		that2, ok := that.(Event)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Event")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Event but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Event but is not nil && this == nil")
	}
	if this.Type != that1.Type {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !this.Subscribed.Equal(that1.Subscribed) {
		return fmt.Errorf("Subscribed this(%v) Not Equal that(%v)", this.Subscribed, that1.Subscribed)
	}
	if !this.TaskAdded.Equal(that1.TaskAdded) {
		return fmt.Errorf("TaskAdded this(%v) Not Equal that(%v)", this.TaskAdded, that1.TaskAdded)
	}
	if !this.TaskUpdated.Equal(that1.TaskUpdated) {
		return fmt.Errorf("TaskUpdated this(%v) Not Equal that(%v)", this.TaskUpdated, that1.TaskUpdated)
	}
	if !this.AgentAdded.Equal(that1.AgentAdded) {
		return fmt.Errorf("AgentAdded this(%v) Not Equal that(%v)", this.AgentAdded, that1.AgentAdded)
	}
	if !this.AgentRemoved.Equal(that1.AgentRemoved) {
		return fmt.Errorf("AgentRemoved this(%v) Not Equal that(%v)", this.AgentRemoved, that1.AgentRemoved)
	}
	if !this.FrameworkAdded.Equal(that1.FrameworkAdded) {
		return fmt.Errorf("FrameworkAdded this(%v) Not Equal that(%v)", this.FrameworkAdded, that1.FrameworkAdded)
	}
	if !this.FrameworkUpdated.Equal(that1.FrameworkUpdated) {
		return fmt.Errorf("FrameworkUpdated this(%v) Not Equal that(%v)", this.FrameworkUpdated, that1.FrameworkUpdated)
	}
	if !this.FrameworkRemoved.Equal(that1.FrameworkRemoved) {
		return fmt.Errorf("FrameworkRemoved this(%v) Not Equal that(%v)", this.FrameworkRemoved, that1.FrameworkRemoved)
	}
	return nil
}
func (this *Event) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Event)
	if !ok {
		that2, ok := that.(Event)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if !this.Subscribed.Equal(that1.Subscribed) {
		return false
	}
	if !this.TaskAdded.Equal(that1.TaskAdded) {
		return false
	}
	if !this.TaskUpdated.Equal(that1.TaskUpdated) {
		return false
	}
	if !this.AgentAdded.Equal(that1.AgentAdded) {
		return false
	}
	if !this.AgentRemoved.Equal(that1.AgentRemoved) {
		return false
	}
	if !this.FrameworkAdded.Equal(that1.FrameworkAdded) {
		return false
	}
	if !this.FrameworkUpdated.Equal(that1.FrameworkUpdated) {
		return false
	}
	if !this.FrameworkRemoved.Equal(that1.FrameworkRemoved) {
		return false
	}
	return true
}
func (this *Event_Subscribed) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Event_Subscribed)
	if !ok {
		that2, ok := that.(Event_Subscribed)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Event_Subscribed")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Event_Subscribed but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Event_Subscribed but is not nil && this == nil")
	}
	if !this.GetState.Equal(that1.GetState) {
		return fmt.Errorf("GetState this(%v) Not Equal that(%v)", this.GetState, that1.GetState)
	}
	if this.HeartbeatIntervalSeconds != nil && that1.HeartbeatIntervalSeconds != nil {
		if *this.HeartbeatIntervalSeconds != *that1.HeartbeatIntervalSeconds {
			return fmt.Errorf("HeartbeatIntervalSeconds this(%v) Not Equal that(%v)", *this.HeartbeatIntervalSeconds, *that1.HeartbeatIntervalSeconds)
		}
	} else if this.HeartbeatIntervalSeconds != nil {
		return fmt.Errorf("this.HeartbeatIntervalSeconds == nil && that.HeartbeatIntervalSeconds != nil")
	} else if that1.HeartbeatIntervalSeconds != nil {
		return fmt.Errorf("HeartbeatIntervalSeconds this(%v) Not Equal that(%v)", this.HeartbeatIntervalSeconds, that1.HeartbeatIntervalSeconds)
	}
	return nil
}
func (this *Event_Subscribed) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Event_Subscribed)
	if !ok {
		that2, ok := that.(Event_Subscribed)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.GetState.Equal(that1.GetState) {
		return false
	}
	if this.HeartbeatIntervalSeconds != nil && that1.HeartbeatIntervalSeconds != nil {
		if *this.HeartbeatIntervalSeconds != *that1.HeartbeatIntervalSeconds {
			return false
		}
	} else if this.HeartbeatIntervalSeconds != nil {
		return false
	} else if that1.HeartbeatIntervalSeconds != nil {
		return false
	}
	return true
}
func (this *Event_TaskAdded) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Event_TaskAdded)
	if !ok {
		that2, ok := that.(Event_TaskAdded)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Event_TaskAdded")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Event_TaskAdded but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Event_TaskAdded but is not nil && this == nil")
	}
	if !this.Task.Equal(&that1.Task) {
		return fmt.Errorf("Task this(%v) Not Equal that(%v)", this.Task, that1.Task)
	}
	return nil
}
func (this *Event_TaskAdded) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Event_TaskAdded)
	if !ok {
		that2, ok := that.(Event_TaskAdded)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Task.Equal(&that1.Task) {
		return false
	}
	return true
}
func (this *Event_TaskUpdated) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Event_TaskUpdated)
	if !ok {
		that2, ok := that.(Event_TaskUpdated)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Event_TaskUpdated")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Event_TaskUpdated but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Event_TaskUpdated but is not nil && this == nil")
	}
	if !this.FrameworkID.Equal(&that1.FrameworkID) {
		return fmt.Errorf("FrameworkID this(%v) Not Equal that(%v)", this.FrameworkID, that1.FrameworkID)
	}
	if !this.Status.Equal(&that1.Status) {
		return fmt.Errorf("Status this(%v) Not Equal that(%v)", this.Status, that1.Status)
	}
	if this.State != nil && that1.State != nil {
		if *this.State != *that1.State {
			return fmt.Errorf("State this(%v) Not Equal that(%v)", *this.State, *that1.State)
		}
	} else if this.State != nil {
		return fmt.Errorf("this.State == nil && that.State != nil")
	} else if that1.State != nil {
		return fmt.Errorf("State this(%v) Not Equal that(%v)", this.State, that1.State)
	}
	return nil
}
func (this *Event_TaskUpdated) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Event_TaskUpdated)
	if !ok {
		that2, ok := that.(Event_TaskUpdated)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.FrameworkID.Equal(&that1.FrameworkID) {
		return false
	}
	if !this.Status.Equal(&that1.Status) {
		return false
	}
	if this.State != nil && that1.State != nil {
		if *this.State != *that1.State {
			return false
		}
	} else if this.State != nil {
		return false
	} else if that1.State != nil {
		return false
	}
	return true
}
func (this *Event_FrameworkAdded) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Event_FrameworkAdded)
	if !ok {
		that2, ok := that.(Event_FrameworkAdded)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Event_FrameworkAdded")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Event_FrameworkAdded but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Event_FrameworkAdded but is not nil && this == nil")
	}
	if !this.Framework.Equal(&that1.Framework) {
		return fmt.Errorf("Framework this(%v) Not Equal that(%v)", this.Framework, that1.Framework)
	}
	return nil
}
func (this *Event_FrameworkAdded) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Event_FrameworkAdded)
	if !ok {
		that2, ok := that.(Event_FrameworkAdded)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Framework.Equal(&that1.Framework) {
		return false
	}
	return true
}
func (this *Event_FrameworkUpdated) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Event_FrameworkUpdated)
	if !ok {
		that2, ok := that.(Event_FrameworkUpdated)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Event_FrameworkUpdated")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Event_FrameworkUpdated but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Event_FrameworkUpdated but is not nil && this == nil")
	}
	if !this.Framework.Equal(&that1.Framework) {
		return fmt.Errorf("Framework this(%v) Not Equal that(%v)", this.Framework, that1.Framework)
	}
	return nil
}
func (this *Event_FrameworkUpdated) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Event_FrameworkUpdated)
	if !ok {
		that2, ok := that.(Event_FrameworkUpdated)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Framework.Equal(&that1.Framework) {
		return false
	}
	return true
}
func (this *Event_FrameworkRemoved) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Event_FrameworkRemoved)
	if !ok {
		that2, ok := that.(Event_FrameworkRemoved)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Event_FrameworkRemoved")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Event_FrameworkRemoved but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Event_FrameworkRemoved but is not nil && this == nil")
	}
	if !this.FrameworkInfo.Equal(&that1.FrameworkInfo) {
		return fmt.Errorf("FrameworkInfo this(%v) Not Equal that(%v)", this.FrameworkInfo, that1.FrameworkInfo)
	}
	return nil
}
func (this *Event_FrameworkRemoved) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Event_FrameworkRemoved)
	if !ok {
		that2, ok := that.(Event_FrameworkRemoved)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.FrameworkInfo.Equal(&that1.FrameworkInfo) {
		return false
	}
	return true
}
func (this *Event_AgentAdded) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Event_AgentAdded)
	if !ok {
		that2, ok := that.(Event_AgentAdded)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Event_AgentAdded")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Event_AgentAdded but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Event_AgentAdded but is not nil && this == nil")
	}
	if !this.Agent.Equal(&that1.Agent) {
		return fmt.Errorf("Agent this(%v) Not Equal that(%v)", this.Agent, that1.Agent)
	}
	return nil
}
func (this *Event_AgentAdded) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Event_AgentAdded)
	if !ok {
		that2, ok := that.(Event_AgentAdded)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Agent.Equal(&that1.Agent) {
		return false
	}
	return true
}
func (this *Event_AgentRemoved) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Event_AgentRemoved)
	if !ok {
		that2, ok := that.(Event_AgentRemoved)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Event_AgentRemoved")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Event_AgentRemoved but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Event_AgentRemoved but is not nil && this == nil")
	}
	if !this.AgentID.Equal(&that1.AgentID) {
		return fmt.Errorf("AgentID this(%v) Not Equal that(%v)", this.AgentID, that1.AgentID)
	}
	return nil
}
func (this *Event_AgentRemoved) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Event_AgentRemoved)
	if !ok {
		that2, ok := that.(Event_AgentRemoved)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.AgentID.Equal(&that1.AgentID) {
		return false
	}
	return true
}
func (this *Call) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 21)
	s = append(s, "&master.Call{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	if this.GetMetrics != nil {
		s = append(s, "GetMetrics: "+fmt.Sprintf("%#v", this.GetMetrics)+",\n")
	}
	if this.SetLoggingLevel != nil {
		s = append(s, "SetLoggingLevel: "+fmt.Sprintf("%#v", this.SetLoggingLevel)+",\n")
	}
	if this.ListFiles != nil {
		s = append(s, "ListFiles: "+fmt.Sprintf("%#v", this.ListFiles)+",\n")
	}
	if this.ReadFile != nil {
		s = append(s, "ReadFile: "+fmt.Sprintf("%#v", this.ReadFile)+",\n")
	}
	if this.UpdateWeights != nil {
		s = append(s, "UpdateWeights: "+fmt.Sprintf("%#v", this.UpdateWeights)+",\n")
	}
	if this.ReserveResources != nil {
		s = append(s, "ReserveResources: "+fmt.Sprintf("%#v", this.ReserveResources)+",\n")
	}
	if this.UnreserveResources != nil {
		s = append(s, "UnreserveResources: "+fmt.Sprintf("%#v", this.UnreserveResources)+",\n")
	}
	if this.CreateVolumes != nil {
		s = append(s, "CreateVolumes: "+fmt.Sprintf("%#v", this.CreateVolumes)+",\n")
	}
	if this.DestroyVolumes != nil {
		s = append(s, "DestroyVolumes: "+fmt.Sprintf("%#v", this.DestroyVolumes)+",\n")
	}
	if this.UpdateMaintenanceSchedule != nil {
		s = append(s, "UpdateMaintenanceSchedule: "+fmt.Sprintf("%#v", this.UpdateMaintenanceSchedule)+",\n")
	}
	if this.StartMaintenance != nil {
		s = append(s, "StartMaintenance: "+fmt.Sprintf("%#v", this.StartMaintenance)+",\n")
	}
	if this.StopMaintenance != nil {
		s = append(s, "StopMaintenance: "+fmt.Sprintf("%#v", this.StopMaintenance)+",\n")
	}
	if this.SetQuota != nil {
		s = append(s, "SetQuota: "+fmt.Sprintf("%#v", this.SetQuota)+",\n")
	}
	if this.RemoveQuota != nil {
		s = append(s, "RemoveQuota: "+fmt.Sprintf("%#v", this.RemoveQuota)+",\n")
	}
	if this.Teardown != nil {
		s = append(s, "Teardown: "+fmt.Sprintf("%#v", this.Teardown)+",\n")
	}
	if this.MarkAgentGone != nil {
		s = append(s, "MarkAgentGone: "+fmt.Sprintf("%#v", this.MarkAgentGone)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_GetMetrics) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&master.Call_GetMetrics{")
	if this.Timeout != nil {
		s = append(s, "Timeout: "+fmt.Sprintf("%#v", this.Timeout)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_SetLoggingLevel) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&master.Call_SetLoggingLevel{")
	s = append(s, "Level: "+fmt.Sprintf("%#v", this.Level)+",\n")
	s = append(s, "Duration: "+strings.Replace(this.Duration.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_ListFiles) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&master.Call_ListFiles{")
	s = append(s, "Path: "+fmt.Sprintf("%#v", this.Path)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_ReadFile) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&master.Call_ReadFile{")
	s = append(s, "Path: "+fmt.Sprintf("%#v", this.Path)+",\n")
	s = append(s, "Offset: "+fmt.Sprintf("%#v", this.Offset)+",\n")
	if this.Length != nil {
		s = append(s, "Length: "+valueToGoStringMaster(this.Length, "uint64")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_UpdateWeights) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&master.Call_UpdateWeights{")
	if this.WeightInfos != nil {
		s = append(s, "WeightInfos: "+fmt.Sprintf("%#v", this.WeightInfos)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_ReserveResources) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&master.Call_ReserveResources{")
	s = append(s, "AgentID: "+strings.Replace(this.AgentID.GoString(), `&`, ``, 1)+",\n")
	if this.Resources != nil {
		s = append(s, "Resources: "+fmt.Sprintf("%#v", this.Resources)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_UnreserveResources) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&master.Call_UnreserveResources{")
	s = append(s, "AgentID: "+strings.Replace(this.AgentID.GoString(), `&`, ``, 1)+",\n")
	if this.Resources != nil {
		s = append(s, "Resources: "+fmt.Sprintf("%#v", this.Resources)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_CreateVolumes) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&master.Call_CreateVolumes{")
	s = append(s, "AgentID: "+strings.Replace(this.AgentID.GoString(), `&`, ``, 1)+",\n")
	if this.Volumes != nil {
		s = append(s, "Volumes: "+fmt.Sprintf("%#v", this.Volumes)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_DestroyVolumes) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&master.Call_DestroyVolumes{")
	s = append(s, "AgentID: "+strings.Replace(this.AgentID.GoString(), `&`, ``, 1)+",\n")
	if this.Volumes != nil {
		s = append(s, "Volumes: "+fmt.Sprintf("%#v", this.Volumes)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_UpdateMaintenanceSchedule) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&master.Call_UpdateMaintenanceSchedule{")
	s = append(s, "Schedule: "+strings.Replace(this.Schedule.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_StartMaintenance) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&master.Call_StartMaintenance{")
	if this.Machines != nil {
		s = append(s, "Machines: "+fmt.Sprintf("%#v", this.Machines)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_StopMaintenance) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&master.Call_StopMaintenance{")
	if this.Machines != nil {
		s = append(s, "Machines: "+fmt.Sprintf("%#v", this.Machines)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_SetQuota) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&master.Call_SetQuota{")
	s = append(s, "QuotaRequest: "+strings.Replace(this.QuotaRequest.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_RemoveQuota) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&master.Call_RemoveQuota{")
	s = append(s, "Role: "+fmt.Sprintf("%#v", this.Role)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_Teardown) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&master.Call_Teardown{")
	s = append(s, "FrameworkID: "+strings.Replace(this.FrameworkID.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_MarkAgentGone) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&master.Call_MarkAgentGone{")
	s = append(s, "AgentID: "+strings.Replace(this.AgentID.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 23)
	s = append(s, "&master.Response{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	if this.GetHealth != nil {
		s = append(s, "GetHealth: "+fmt.Sprintf("%#v", this.GetHealth)+",\n")
	}
	if this.GetFlags != nil {
		s = append(s, "GetFlags: "+fmt.Sprintf("%#v", this.GetFlags)+",\n")
	}
	if this.GetVersion != nil {
		s = append(s, "GetVersion: "+fmt.Sprintf("%#v", this.GetVersion)+",\n")
	}
	if this.GetMetrics != nil {
		s = append(s, "GetMetrics: "+fmt.Sprintf("%#v", this.GetMetrics)+",\n")
	}
	if this.GetLoggingLevel != nil {
		s = append(s, "GetLoggingLevel: "+fmt.Sprintf("%#v", this.GetLoggingLevel)+",\n")
	}
	if this.ListFiles != nil {
		s = append(s, "ListFiles: "+fmt.Sprintf("%#v", this.ListFiles)+",\n")
	}
	if this.ReadFile != nil {
		s = append(s, "ReadFile: "+fmt.Sprintf("%#v", this.ReadFile)+",\n")
	}
	if this.GetState != nil {
		s = append(s, "GetState: "+fmt.Sprintf("%#v", this.GetState)+",\n")
	}
	if this.GetAgents != nil {
		s = append(s, "GetAgents: "+fmt.Sprintf("%#v", this.GetAgents)+",\n")
	}
	if this.GetFrameworks != nil {
		s = append(s, "GetFrameworks: "+fmt.Sprintf("%#v", this.GetFrameworks)+",\n")
	}
	if this.GetExecutors != nil {
		s = append(s, "GetExecutors: "+fmt.Sprintf("%#v", this.GetExecutors)+",\n")
	}
	if this.GetTasks != nil {
		s = append(s, "GetTasks: "+fmt.Sprintf("%#v", this.GetTasks)+",\n")
	}
	if this.GetRoles != nil {
		s = append(s, "GetRoles: "+fmt.Sprintf("%#v", this.GetRoles)+",\n")
	}
	if this.GetWeights != nil {
		s = append(s, "GetWeights: "+fmt.Sprintf("%#v", this.GetWeights)+",\n")
	}
	if this.GetMaster != nil {
		s = append(s, "GetMaster: "+fmt.Sprintf("%#v", this.GetMaster)+",\n")
	}
	if this.GetMaintenanceStatus != nil {
		s = append(s, "GetMaintenanceStatus: "+fmt.Sprintf("%#v", this.GetMaintenanceStatus)+",\n")
	}
	if this.GetMaintenanceSchedule != nil {
		s = append(s, "GetMaintenanceSchedule: "+fmt.Sprintf("%#v", this.GetMaintenanceSchedule)+",\n")
	}
	if this.GetQuota != nil {
		s = append(s, "GetQuota: "+fmt.Sprintf("%#v", this.GetQuota)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_GetHealth) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&master.Response_GetHealth{")
	s = append(s, "Healthy: "+fmt.Sprintf("%#v", this.Healthy)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_GetFlags) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&master.Response_GetFlags{")
	if this.Flags != nil {
		s = append(s, "Flags: "+fmt.Sprintf("%#v", this.Flags)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_GetVersion) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&master.Response_GetVersion{")
	s = append(s, "VersionInfo: "+strings.Replace(this.VersionInfo.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_GetMetrics) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&master.Response_GetMetrics{")
	if this.Metrics != nil {
		s = append(s, "Metrics: "+fmt.Sprintf("%#v", this.Metrics)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_GetLoggingLevel) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&master.Response_GetLoggingLevel{")
	s = append(s, "Level: "+fmt.Sprintf("%#v", this.Level)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_ListFiles) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&master.Response_ListFiles{")
	if this.FileInfos != nil {
		s = append(s, "FileInfos: "+fmt.Sprintf("%#v", this.FileInfos)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_ReadFile) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&master.Response_ReadFile{")
	s = append(s, "Size: "+fmt.Sprintf("%#v", this.Size)+",\n")
	if this.Data != nil {
		s = append(s, "Data: "+valueToGoStringMaster(this.Data, "byte")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_GetState) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&master.Response_GetState{")
	if this.GetTasks != nil {
		s = append(s, "GetTasks: "+fmt.Sprintf("%#v", this.GetTasks)+",\n")
	}
	if this.GetExecutors != nil {
		s = append(s, "GetExecutors: "+fmt.Sprintf("%#v", this.GetExecutors)+",\n")
	}
	if this.GetFrameworks != nil {
		s = append(s, "GetFrameworks: "+fmt.Sprintf("%#v", this.GetFrameworks)+",\n")
	}
	if this.GetAgents != nil {
		s = append(s, "GetAgents: "+fmt.Sprintf("%#v", this.GetAgents)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_GetAgents) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&master.Response_GetAgents{")
	if this.Agents != nil {
		s = append(s, "Agents: "+fmt.Sprintf("%#v", this.Agents)+",\n")
	}
	if this.RecoveredAgents != nil {
		s = append(s, "RecoveredAgents: "+fmt.Sprintf("%#v", this.RecoveredAgents)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_GetAgents_Agent) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 15)
	s = append(s, "&master.Response_GetAgents_Agent{")
	s = append(s, "AgentInfo: "+strings.Replace(this.AgentInfo.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "Active: "+fmt.Sprintf("%#v", this.Active)+",\n")
	s = append(s, "Version: "+fmt.Sprintf("%#v", this.Version)+",\n")
	if this.PID != nil {
		s = append(s, "PID: "+valueToGoStringMaster(this.PID, "string")+",\n")
	}
	if this.RegisteredTime != nil {
		s = append(s, "RegisteredTime: "+fmt.Sprintf("%#v", this.RegisteredTime)+",\n")
	}
	if this.ReregisteredTime != nil {
		s = append(s, "ReregisteredTime: "+fmt.Sprintf("%#v", this.ReregisteredTime)+",\n")
	}
	if this.TotalResources != nil {
		s = append(s, "TotalResources: "+fmt.Sprintf("%#v", this.TotalResources)+",\n")
	}
	if this.AllocatedResources != nil {
		s = append(s, "AllocatedResources: "+fmt.Sprintf("%#v", this.AllocatedResources)+",\n")
	}
	if this.OfferedResources != nil {
		s = append(s, "OfferedResources: "+fmt.Sprintf("%#v", this.OfferedResources)+",\n")
	}
	if this.Capabilities != nil {
		s = append(s, "Capabilities: "+fmt.Sprintf("%#v", this.Capabilities)+",\n")
	}
	if this.ResourceProviders != nil {
		s = append(s, "ResourceProviders: "+fmt.Sprintf("%#v", this.ResourceProviders)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_GetAgents_Agent_ResourceProvider) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&master.Response_GetAgents_Agent_ResourceProvider{")
	s = append(s, "ResourceProviderInfo: "+strings.Replace(this.ResourceProviderInfo.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_GetFrameworks) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&master.Response_GetFrameworks{")
	if this.Frameworks != nil {
		s = append(s, "Frameworks: "+fmt.Sprintf("%#v", this.Frameworks)+",\n")
	}
	if this.CompletedFrameworks != nil {
		s = append(s, "CompletedFrameworks: "+fmt.Sprintf("%#v", this.CompletedFrameworks)+",\n")
	}
	if this.RecoveredFrameworks != nil {
		s = append(s, "RecoveredFrameworks: "+fmt.Sprintf("%#v", this.RecoveredFrameworks)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_GetFrameworks_Framework) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 15)
	s = append(s, "&master.Response_GetFrameworks_Framework{")
	s = append(s, "FrameworkInfo: "+strings.Replace(this.FrameworkInfo.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "Active: "+fmt.Sprintf("%#v", this.Active)+",\n")
	s = append(s, "Connected: "+fmt.Sprintf("%#v", this.Connected)+",\n")
	s = append(s, "Recovered: "+fmt.Sprintf("%#v", this.Recovered)+",\n")
	if this.RegisteredTime != nil {
		s = append(s, "RegisteredTime: "+fmt.Sprintf("%#v", this.RegisteredTime)+",\n")
	}
	if this.ReregisteredTime != nil {
		s = append(s, "ReregisteredTime: "+fmt.Sprintf("%#v", this.ReregisteredTime)+",\n")
	}
	if this.UnregisteredTime != nil {
		s = append(s, "UnregisteredTime: "+fmt.Sprintf("%#v", this.UnregisteredTime)+",\n")
	}
	if this.Offers != nil {
		s = append(s, "Offers: "+fmt.Sprintf("%#v", this.Offers)+",\n")
	}
	if this.InverseOffers != nil {
		s = append(s, "InverseOffers: "+fmt.Sprintf("%#v", this.InverseOffers)+",\n")
	}
	if this.AllocatedResources != nil {
		s = append(s, "AllocatedResources: "+fmt.Sprintf("%#v", this.AllocatedResources)+",\n")
	}
	if this.OfferedResources != nil {
		s = append(s, "OfferedResources: "+fmt.Sprintf("%#v", this.OfferedResources)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_GetExecutors) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&master.Response_GetExecutors{")
	if this.Executors != nil {
		s = append(s, "Executors: "+fmt.Sprintf("%#v", this.Executors)+",\n")
	}
	if this.OrphanExecutors != nil {
		s = append(s, "OrphanExecutors: "+fmt.Sprintf("%#v", this.OrphanExecutors)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_GetExecutors_Executor) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&master.Response_GetExecutors_Executor{")
	s = append(s, "ExecutorInfo: "+strings.Replace(this.ExecutorInfo.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "AgentID: "+strings.Replace(this.AgentID.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_GetTasks) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&master.Response_GetTasks{")
	if this.PendingTasks != nil {
		s = append(s, "PendingTasks: "+fmt.Sprintf("%#v", this.PendingTasks)+",\n")
	}
	if this.Tasks != nil {
		s = append(s, "Tasks: "+fmt.Sprintf("%#v", this.Tasks)+",\n")
	}
	if this.UnreachableTasks != nil {
		s = append(s, "UnreachableTasks: "+fmt.Sprintf("%#v", this.UnreachableTasks)+",\n")
	}
	if this.CompletedTasks != nil {
		s = append(s, "CompletedTasks: "+fmt.Sprintf("%#v", this.CompletedTasks)+",\n")
	}
	if this.OrphanTasks != nil {
		s = append(s, "OrphanTasks: "+fmt.Sprintf("%#v", this.OrphanTasks)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_GetRoles) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&master.Response_GetRoles{")
	if this.Roles != nil {
		s = append(s, "Roles: "+fmt.Sprintf("%#v", this.Roles)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_GetWeights) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&master.Response_GetWeights{")
	if this.WeightInfos != nil {
		s = append(s, "WeightInfos: "+fmt.Sprintf("%#v", this.WeightInfos)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_GetMaster) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&master.Response_GetMaster{")
	if this.MasterInfo != nil {
		s = append(s, "MasterInfo: "+fmt.Sprintf("%#v", this.MasterInfo)+",\n")
	}
	if this.StartTime != nil {
		s = append(s, "StartTime: "+valueToGoStringMaster(this.StartTime, "float64")+",\n")
	}
	if this.ElectedTime != nil {
		s = append(s, "ElectedTime: "+valueToGoStringMaster(this.ElectedTime, "float64")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_GetMaintenanceStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&master.Response_GetMaintenanceStatus{")
	s = append(s, "Status: "+strings.Replace(this.Status.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_GetMaintenanceSchedule) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&master.Response_GetMaintenanceSchedule{")
	s = append(s, "Schedule: "+strings.Replace(this.Schedule.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_GetQuota) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&master.Response_GetQuota{")
	s = append(s, "Status: "+strings.Replace(this.Status.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Event) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 13)
	s = append(s, "&master.Event{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	if this.Subscribed != nil {
		s = append(s, "Subscribed: "+fmt.Sprintf("%#v", this.Subscribed)+",\n")
	}
	if this.TaskAdded != nil {
		s = append(s, "TaskAdded: "+fmt.Sprintf("%#v", this.TaskAdded)+",\n")
	}
	if this.TaskUpdated != nil {
		s = append(s, "TaskUpdated: "+fmt.Sprintf("%#v", this.TaskUpdated)+",\n")
	}
	if this.AgentAdded != nil {
		s = append(s, "AgentAdded: "+fmt.Sprintf("%#v", this.AgentAdded)+",\n")
	}
	if this.AgentRemoved != nil {
		s = append(s, "AgentRemoved: "+fmt.Sprintf("%#v", this.AgentRemoved)+",\n")
	}
	if this.FrameworkAdded != nil {
		s = append(s, "FrameworkAdded: "+fmt.Sprintf("%#v", this.FrameworkAdded)+",\n")
	}
	if this.FrameworkUpdated != nil {
		s = append(s, "FrameworkUpdated: "+fmt.Sprintf("%#v", this.FrameworkUpdated)+",\n")
	}
	if this.FrameworkRemoved != nil {
		s = append(s, "FrameworkRemoved: "+fmt.Sprintf("%#v", this.FrameworkRemoved)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Event_Subscribed) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&master.Event_Subscribed{")
	if this.GetState != nil {
		s = append(s, "GetState: "+fmt.Sprintf("%#v", this.GetState)+",\n")
	}
	if this.HeartbeatIntervalSeconds != nil {
		s = append(s, "HeartbeatIntervalSeconds: "+valueToGoStringMaster(this.HeartbeatIntervalSeconds, "float64")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Event_TaskAdded) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&master.Event_TaskAdded{")
	s = append(s, "Task: "+strings.Replace(this.Task.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Event_TaskUpdated) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&master.Event_TaskUpdated{")
	s = append(s, "FrameworkID: "+strings.Replace(this.FrameworkID.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "Status: "+strings.Replace(this.Status.GoString(), `&`, ``, 1)+",\n")
	if this.State != nil {
		s = append(s, "State: "+valueToGoStringMaster(this.State, "mesos.TaskState")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Event_FrameworkAdded) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&master.Event_FrameworkAdded{")
	s = append(s, "Framework: "+strings.Replace(this.Framework.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Event_FrameworkUpdated) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&master.Event_FrameworkUpdated{")
	s = append(s, "Framework: "+strings.Replace(this.Framework.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Event_FrameworkRemoved) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&master.Event_FrameworkRemoved{")
	s = append(s, "FrameworkInfo: "+strings.Replace(this.FrameworkInfo.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Event_AgentAdded) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&master.Event_AgentAdded{")
	s = append(s, "Agent: "+strings.Replace(this.Agent.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Event_AgentRemoved) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&master.Event_AgentRemoved{")
	s = append(s, "AgentID: "+strings.Replace(this.AgentID.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringMaster(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *Call) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMaster(dAtA, i, uint64(m.Type))
	if m.GetMetrics != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.GetMetrics.ProtoSize()))
		n1, err := m.GetMetrics.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.SetLoggingLevel != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.SetLoggingLevel.ProtoSize()))
		n2, err := m.SetLoggingLevel.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.ListFiles != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.ListFiles.ProtoSize()))
		n3, err := m.ListFiles.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.ReadFile != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.ReadFile.ProtoSize()))
		n4, err := m.ReadFile.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.UpdateWeights != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.UpdateWeights.ProtoSize()))
		n5, err := m.UpdateWeights.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.ReserveResources != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.ReserveResources.ProtoSize()))
		n6, err := m.ReserveResources.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.UnreserveResources != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.UnreserveResources.ProtoSize()))
		n7, err := m.UnreserveResources.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.CreateVolumes != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.CreateVolumes.ProtoSize()))
		n8, err := m.CreateVolumes.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.DestroyVolumes != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.DestroyVolumes.ProtoSize()))
		n9, err := m.DestroyVolumes.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if m.UpdateMaintenanceSchedule != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.UpdateMaintenanceSchedule.ProtoSize()))
		n10, err := m.UpdateMaintenanceSchedule.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	if m.StartMaintenance != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.StartMaintenance.ProtoSize()))
		n11, err := m.StartMaintenance.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	if m.StopMaintenance != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.StopMaintenance.ProtoSize()))
		n12, err := m.StopMaintenance.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	if m.SetQuota != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.SetQuota.ProtoSize()))
		n13, err := m.SetQuota.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	if m.RemoveQuota != nil {
		dAtA[i] = 0x7a
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.RemoveQuota.ProtoSize()))
		n14, err := m.RemoveQuota.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	if m.Teardown != nil {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.Teardown.ProtoSize()))
		n15, err := m.Teardown.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	if m.MarkAgentGone != nil {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.MarkAgentGone.ProtoSize()))
		n16, err := m.MarkAgentGone.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	return i, nil
}

func (m *Call_GetMetrics) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_GetMetrics) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Timeout != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.Timeout.ProtoSize()))
		n17, err := m.Timeout.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	return i, nil
}

func (m *Call_SetLoggingLevel) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_SetLoggingLevel) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMaster(dAtA, i, uint64(m.Level))
	dAtA[i] = 0x12
	i++
	i = encodeVarintMaster(dAtA, i, uint64(m.Duration.ProtoSize()))
	n18, err := m.Duration.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n18
	return i, nil
}

func (m *Call_ListFiles) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_ListFiles) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMaster(dAtA, i, uint64(len(m.Path)))
	i += copy(dAtA[i:], m.Path)
	return i, nil
}

func (m *Call_ReadFile) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_ReadFile) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMaster(dAtA, i, uint64(len(m.Path)))
	i += copy(dAtA[i:], m.Path)
	dAtA[i] = 0x10
	i++
	i = encodeVarintMaster(dAtA, i, uint64(m.Offset))
	if m.Length != nil {
		dAtA[i] = 0x18
		i++
		i = encodeVarintMaster(dAtA, i, uint64(*m.Length))
	}
	return i, nil
}

func (m *Call_UpdateWeights) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_UpdateWeights) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.WeightInfos) > 0 {
		for _, msg := range m.WeightInfos {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMaster(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Call_ReserveResources) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_ReserveResources) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMaster(dAtA, i, uint64(m.AgentID.ProtoSize()))
	n19, err := m.AgentID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n19
	if len(m.Resources) > 0 {
		for _, msg := range m.Resources {
			dAtA[i] = 0x12
			i++
			i = encodeVarintMaster(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Call_UnreserveResources) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_UnreserveResources) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMaster(dAtA, i, uint64(m.AgentID.ProtoSize()))
	n20, err := m.AgentID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n20
	if len(m.Resources) > 0 {
		for _, msg := range m.Resources {
			dAtA[i] = 0x12
			i++
			i = encodeVarintMaster(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Call_CreateVolumes) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_CreateVolumes) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMaster(dAtA, i, uint64(m.AgentID.ProtoSize()))
	n21, err := m.AgentID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n21
	if len(m.Volumes) > 0 {
		for _, msg := range m.Volumes {
			dAtA[i] = 0x12
			i++
			i = encodeVarintMaster(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Call_DestroyVolumes) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_DestroyVolumes) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMaster(dAtA, i, uint64(m.AgentID.ProtoSize()))
	n22, err := m.AgentID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n22
	if len(m.Volumes) > 0 {
		for _, msg := range m.Volumes {
			dAtA[i] = 0x12
			i++
			i = encodeVarintMaster(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Call_UpdateMaintenanceSchedule) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_UpdateMaintenanceSchedule) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMaster(dAtA, i, uint64(m.Schedule.ProtoSize()))
	n23, err := m.Schedule.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n23
	return i, nil
}

func (m *Call_StartMaintenance) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_StartMaintenance) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Machines) > 0 {
		for _, msg := range m.Machines {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMaster(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Call_StopMaintenance) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_StopMaintenance) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Machines) > 0 {
		for _, msg := range m.Machines {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMaster(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Call_SetQuota) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_SetQuota) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMaster(dAtA, i, uint64(m.QuotaRequest.ProtoSize()))
	n24, err := m.QuotaRequest.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n24
	return i, nil
}

func (m *Call_RemoveQuota) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_RemoveQuota) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMaster(dAtA, i, uint64(len(m.Role)))
	i += copy(dAtA[i:], m.Role)
	return i, nil
}

func (m *Call_Teardown) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_Teardown) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMaster(dAtA, i, uint64(m.FrameworkID.ProtoSize()))
	n25, err := m.FrameworkID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n25
	return i, nil
}

func (m *Call_MarkAgentGone) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_MarkAgentGone) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMaster(dAtA, i, uint64(m.AgentID.ProtoSize()))
	n26, err := m.AgentID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n26
	return i, nil
}

func (m *Response) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMaster(dAtA, i, uint64(m.Type))
	if m.GetHealth != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.GetHealth.ProtoSize()))
		n27, err := m.GetHealth.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n27
	}
	if m.GetFlags != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.GetFlags.ProtoSize()))
		n28, err := m.GetFlags.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n28
	}
	if m.GetVersion != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.GetVersion.ProtoSize()))
		n29, err := m.GetVersion.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n29
	}
	if m.GetMetrics != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.GetMetrics.ProtoSize()))
		n30, err := m.GetMetrics.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n30
	}
	if m.GetLoggingLevel != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.GetLoggingLevel.ProtoSize()))
		n31, err := m.GetLoggingLevel.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n31
	}
	if m.ListFiles != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.ListFiles.ProtoSize()))
		n32, err := m.ListFiles.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n32
	}
	if m.ReadFile != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.ReadFile.ProtoSize()))
		n33, err := m.ReadFile.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n33
	}
	if m.GetState != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.GetState.ProtoSize()))
		n34, err := m.GetState.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n34
	}
	if m.GetAgents != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.GetAgents.ProtoSize()))
		n35, err := m.GetAgents.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n35
	}
	if m.GetFrameworks != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.GetFrameworks.ProtoSize()))
		n36, err := m.GetFrameworks.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n36
	}
	if m.GetExecutors != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.GetExecutors.ProtoSize()))
		n37, err := m.GetExecutors.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n37
	}
	if m.GetTasks != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.GetTasks.ProtoSize()))
		n38, err := m.GetTasks.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n38
	}
	if m.GetRoles != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.GetRoles.ProtoSize()))
		n39, err := m.GetRoles.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n39
	}
	if m.GetWeights != nil {
		dAtA[i] = 0x7a
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.GetWeights.ProtoSize()))
		n40, err := m.GetWeights.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n40
	}
	if m.GetMaster != nil {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.GetMaster.ProtoSize()))
		n41, err := m.GetMaster.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n41
	}
	if m.GetMaintenanceStatus != nil {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.GetMaintenanceStatus.ProtoSize()))
		n42, err := m.GetMaintenanceStatus.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n42
	}
	if m.GetMaintenanceSchedule != nil {
		dAtA[i] = 0x92
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.GetMaintenanceSchedule.ProtoSize()))
		n43, err := m.GetMaintenanceSchedule.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n43
	}
	if m.GetQuota != nil {
		dAtA[i] = 0x9a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.GetQuota.ProtoSize()))
		n44, err := m.GetQuota.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n44
	}
	return i, nil
}

func (m *Response_GetHealth) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_GetHealth) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	if m.Healthy {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}

func (m *Response_GetFlags) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_GetFlags) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Flags) > 0 {
		for _, msg := range m.Flags {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMaster(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Response_GetVersion) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_GetVersion) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMaster(dAtA, i, uint64(m.VersionInfo.ProtoSize()))
	n45, err := m.VersionInfo.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n45
	return i, nil
}

func (m *Response_GetMetrics) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_GetMetrics) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Metrics) > 0 {
		for _, msg := range m.Metrics {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMaster(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Response_GetLoggingLevel) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_GetLoggingLevel) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMaster(dAtA, i, uint64(m.Level))
	return i, nil
}

func (m *Response_ListFiles) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_ListFiles) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.FileInfos) > 0 {
		for _, msg := range m.FileInfos {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMaster(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Response_ReadFile) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_ReadFile) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMaster(dAtA, i, uint64(m.Size))
	if m.Data == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("data")
	} else {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMaster(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	return i, nil
}

func (m *Response_GetState) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_GetState) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.GetTasks != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.GetTasks.ProtoSize()))
		n46, err := m.GetTasks.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n46
	}
	if m.GetExecutors != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.GetExecutors.ProtoSize()))
		n47, err := m.GetExecutors.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n47
	}
	if m.GetFrameworks != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.GetFrameworks.ProtoSize()))
		n48, err := m.GetFrameworks.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n48
	}
	if m.GetAgents != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.GetAgents.ProtoSize()))
		n49, err := m.GetAgents.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n49
	}
	return i, nil
}

func (m *Response_GetAgents) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_GetAgents) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Agents) > 0 {
		for _, msg := range m.Agents {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMaster(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.RecoveredAgents) > 0 {
		for _, msg := range m.RecoveredAgents {
			dAtA[i] = 0x12
			i++
			i = encodeVarintMaster(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Response_GetAgents_Agent) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_GetAgents_Agent) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMaster(dAtA, i, uint64(m.AgentInfo.ProtoSize()))
	n50, err := m.AgentInfo.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n50
	dAtA[i] = 0x10
	i++
	if m.Active {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	dAtA[i] = 0x1a
	i++
	i = encodeVarintMaster(dAtA, i, uint64(len(m.Version)))
	i += copy(dAtA[i:], m.Version)
	if m.PID != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintMaster(dAtA, i, uint64(len(*m.PID)))
		i += copy(dAtA[i:], *m.PID)
	}
	if m.RegisteredTime != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.RegisteredTime.ProtoSize()))
		n51, err := m.RegisteredTime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n51
	}
	if m.ReregisteredTime != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.ReregisteredTime.ProtoSize()))
		n52, err := m.ReregisteredTime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n52
	}
	if len(m.TotalResources) > 0 {
		for _, msg := range m.TotalResources {
			dAtA[i] = 0x3a
			i++
			i = encodeVarintMaster(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.AllocatedResources) > 0 {
		for _, msg := range m.AllocatedResources {
			dAtA[i] = 0x42
			i++
			i = encodeVarintMaster(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.OfferedResources) > 0 {
		for _, msg := range m.OfferedResources {
			dAtA[i] = 0x4a
			i++
			i = encodeVarintMaster(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Capabilities) > 0 {
		for _, msg := range m.Capabilities {
			dAtA[i] = 0x52
			i++
			i = encodeVarintMaster(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.ResourceProviders) > 0 {
		for _, msg := range m.ResourceProviders {
			dAtA[i] = 0x5a
			i++
			i = encodeVarintMaster(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Response_GetAgents_Agent_ResourceProvider) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_GetAgents_Agent_ResourceProvider) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMaster(dAtA, i, uint64(m.ResourceProviderInfo.ProtoSize()))
	n53, err := m.ResourceProviderInfo.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n53
	return i, nil
}

func (m *Response_GetFrameworks) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_GetFrameworks) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Frameworks) > 0 {
		for _, msg := range m.Frameworks {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMaster(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.CompletedFrameworks) > 0 {
		for _, msg := range m.CompletedFrameworks {
			dAtA[i] = 0x12
			i++
			i = encodeVarintMaster(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.RecoveredFrameworks) > 0 {
		for _, msg := range m.RecoveredFrameworks {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintMaster(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Response_GetFrameworks_Framework) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_GetFrameworks_Framework) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMaster(dAtA, i, uint64(m.FrameworkInfo.ProtoSize()))
	n54, err := m.FrameworkInfo.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n54
	dAtA[i] = 0x10
	i++
	if m.Active {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	dAtA[i] = 0x18
	i++
	if m.Connected {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	if m.RegisteredTime != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.RegisteredTime.ProtoSize()))
		n55, err := m.RegisteredTime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n55
	}
	if m.ReregisteredTime != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.ReregisteredTime.ProtoSize()))
		n56, err := m.ReregisteredTime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n56
	}
	if m.UnregisteredTime != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.UnregisteredTime.ProtoSize()))
		n57, err := m.UnregisteredTime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n57
	}
	if len(m.Offers) > 0 {
		for _, msg := range m.Offers {
			dAtA[i] = 0x3a
			i++
			i = encodeVarintMaster(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.InverseOffers) > 0 {
		for _, msg := range m.InverseOffers {
			dAtA[i] = 0x42
			i++
			i = encodeVarintMaster(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.AllocatedResources) > 0 {
		for _, msg := range m.AllocatedResources {
			dAtA[i] = 0x4a
			i++
			i = encodeVarintMaster(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.OfferedResources) > 0 {
		for _, msg := range m.OfferedResources {
			dAtA[i] = 0x52
			i++
			i = encodeVarintMaster(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x58
	i++
	if m.Recovered {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}

func (m *Response_GetExecutors) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_GetExecutors) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Executors) > 0 {
		for _, msg := range m.Executors {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMaster(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.OrphanExecutors) > 0 {
		for _, msg := range m.OrphanExecutors {
			dAtA[i] = 0x12
			i++
			i = encodeVarintMaster(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Response_GetExecutors_Executor) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_GetExecutors_Executor) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMaster(dAtA, i, uint64(m.ExecutorInfo.ProtoSize()))
	n58, err := m.ExecutorInfo.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n58
	dAtA[i] = 0x12
	i++
	i = encodeVarintMaster(dAtA, i, uint64(m.AgentID.ProtoSize()))
	n59, err := m.AgentID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n59
	return i, nil
}

func (m *Response_GetTasks) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_GetTasks) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.PendingTasks) > 0 {
		for _, msg := range m.PendingTasks {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMaster(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Tasks) > 0 {
		for _, msg := range m.Tasks {
			dAtA[i] = 0x12
			i++
			i = encodeVarintMaster(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.CompletedTasks) > 0 {
		for _, msg := range m.CompletedTasks {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintMaster(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.OrphanTasks) > 0 {
		for _, msg := range m.OrphanTasks {
			dAtA[i] = 0x22
			i++
			i = encodeVarintMaster(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.UnreachableTasks) > 0 {
		for _, msg := range m.UnreachableTasks {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintMaster(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Response_GetRoles) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_GetRoles) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Roles) > 0 {
		for _, msg := range m.Roles {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMaster(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Response_GetWeights) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_GetWeights) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.WeightInfos) > 0 {
		for _, msg := range m.WeightInfos {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMaster(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Response_GetMaster) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_GetMaster) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.MasterInfo != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.MasterInfo.ProtoSize()))
		n60, err := m.MasterInfo.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n60
	}
	if m.StartTime != nil {
		dAtA[i] = 0x11
		i++
		i = encodeFixed64Master(dAtA, i, uint64(math.Float64bits(float64(*m.StartTime))))
	}
	if m.ElectedTime != nil {
		dAtA[i] = 0x19
		i++
		i = encodeFixed64Master(dAtA, i, uint64(math.Float64bits(float64(*m.ElectedTime))))
	}
	return i, nil
}

func (m *Response_GetMaintenanceStatus) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_GetMaintenanceStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMaster(dAtA, i, uint64(m.Status.ProtoSize()))
	n61, err := m.Status.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n61
	return i, nil
}

func (m *Response_GetMaintenanceSchedule) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_GetMaintenanceSchedule) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMaster(dAtA, i, uint64(m.Schedule.ProtoSize()))
	n62, err := m.Schedule.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n62
	return i, nil
}

func (m *Response_GetQuota) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_GetQuota) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMaster(dAtA, i, uint64(m.Status.ProtoSize()))
	n63, err := m.Status.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n63
	return i, nil
}

func (m *Event) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMaster(dAtA, i, uint64(m.Type))
	if m.Subscribed != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.Subscribed.ProtoSize()))
		n64, err := m.Subscribed.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n64
	}
	if m.TaskAdded != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.TaskAdded.ProtoSize()))
		n65, err := m.TaskAdded.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n65
	}
	if m.TaskUpdated != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.TaskUpdated.ProtoSize()))
		n66, err := m.TaskUpdated.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n66
	}
	if m.AgentAdded != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.AgentAdded.ProtoSize()))
		n67, err := m.AgentAdded.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n67
	}
	if m.AgentRemoved != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.AgentRemoved.ProtoSize()))
		n68, err := m.AgentRemoved.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n68
	}
	if m.FrameworkAdded != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.FrameworkAdded.ProtoSize()))
		n69, err := m.FrameworkAdded.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n69
	}
	if m.FrameworkUpdated != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.FrameworkUpdated.ProtoSize()))
		n70, err := m.FrameworkUpdated.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n70
	}
	if m.FrameworkRemoved != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.FrameworkRemoved.ProtoSize()))
		n71, err := m.FrameworkRemoved.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n71
	}
	return i, nil
}

func (m *Event_Subscribed) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event_Subscribed) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.GetState != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMaster(dAtA, i, uint64(m.GetState.ProtoSize()))
		n72, err := m.GetState.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n72
	}
	if m.HeartbeatIntervalSeconds != nil {
		dAtA[i] = 0x11
		i++
		i = encodeFixed64Master(dAtA, i, uint64(math.Float64bits(float64(*m.HeartbeatIntervalSeconds))))
	}
	return i, nil
}

func (m *Event_TaskAdded) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event_TaskAdded) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMaster(dAtA, i, uint64(m.Task.ProtoSize()))
	n73, err := m.Task.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n73
	return i, nil
}

func (m *Event_TaskUpdated) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event_TaskUpdated) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMaster(dAtA, i, uint64(m.FrameworkID.ProtoSize()))
	n74, err := m.FrameworkID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n74
	dAtA[i] = 0x12
	i++
	i = encodeVarintMaster(dAtA, i, uint64(m.Status.ProtoSize()))
	n75, err := m.Status.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n75
	if m.State == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("state")
	} else {
		dAtA[i] = 0x18
		i++
		i = encodeVarintMaster(dAtA, i, uint64(*m.State))
	}
	return i, nil
}

func (m *Event_FrameworkAdded) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event_FrameworkAdded) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMaster(dAtA, i, uint64(m.Framework.ProtoSize()))
	n76, err := m.Framework.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n76
	return i, nil
}

func (m *Event_FrameworkUpdated) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event_FrameworkUpdated) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMaster(dAtA, i, uint64(m.Framework.ProtoSize()))
	n77, err := m.Framework.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n77
	return i, nil
}

func (m *Event_FrameworkRemoved) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event_FrameworkRemoved) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMaster(dAtA, i, uint64(m.FrameworkInfo.ProtoSize()))
	n78, err := m.FrameworkInfo.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n78
	return i, nil
}

func (m *Event_AgentAdded) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event_AgentAdded) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMaster(dAtA, i, uint64(m.Agent.ProtoSize()))
	n79, err := m.Agent.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n79
	return i, nil
}

func (m *Event_AgentRemoved) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event_AgentRemoved) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMaster(dAtA, i, uint64(m.AgentID.ProtoSize()))
	n80, err := m.AgentID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n80
	return i, nil
}

func encodeFixed64Master(dAtA []byte, offset int, v uint64) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	dAtA[offset+4] = uint8(v >> 32)
	dAtA[offset+5] = uint8(v >> 40)
	dAtA[offset+6] = uint8(v >> 48)
	dAtA[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Master(dAtA []byte, offset int, v uint32) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintMaster(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func NewPopulatedCall(r randyMaster, easy bool) *Call {
	this := &Call{}
	this.Type = Call_Type([]int32{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32}[r.Intn(33)])
	if r.Intn(10) != 0 {
		this.GetMetrics = NewPopulatedCall_GetMetrics(r, easy)
	}
	if r.Intn(10) != 0 {
		this.SetLoggingLevel = NewPopulatedCall_SetLoggingLevel(r, easy)
	}
	if r.Intn(10) != 0 {
		this.ListFiles = NewPopulatedCall_ListFiles(r, easy)
	}
	if r.Intn(10) != 0 {
		this.ReadFile = NewPopulatedCall_ReadFile(r, easy)
	}
	if r.Intn(10) != 0 {
		this.UpdateWeights = NewPopulatedCall_UpdateWeights(r, easy)
	}
	if r.Intn(10) != 0 {
		this.ReserveResources = NewPopulatedCall_ReserveResources(r, easy)
	}
	if r.Intn(10) != 0 {
		this.UnreserveResources = NewPopulatedCall_UnreserveResources(r, easy)
	}
	if r.Intn(10) != 0 {
		this.CreateVolumes = NewPopulatedCall_CreateVolumes(r, easy)
	}
	if r.Intn(10) != 0 {
		this.DestroyVolumes = NewPopulatedCall_DestroyVolumes(r, easy)
	}
	if r.Intn(10) != 0 {
		this.UpdateMaintenanceSchedule = NewPopulatedCall_UpdateMaintenanceSchedule(r, easy)
	}
	if r.Intn(10) != 0 {
		this.StartMaintenance = NewPopulatedCall_StartMaintenance(r, easy)
	}
	if r.Intn(10) != 0 {
		this.StopMaintenance = NewPopulatedCall_StopMaintenance(r, easy)
	}
	if r.Intn(10) != 0 {
		this.SetQuota = NewPopulatedCall_SetQuota(r, easy)
	}
	if r.Intn(10) != 0 {
		this.RemoveQuota = NewPopulatedCall_RemoveQuota(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Teardown = NewPopulatedCall_Teardown(r, easy)
	}
	if r.Intn(10) != 0 {
		this.MarkAgentGone = NewPopulatedCall_MarkAgentGone(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_GetMetrics(r randyMaster, easy bool) *Call_GetMetrics {
	this := &Call_GetMetrics{}
	if r.Intn(10) != 0 {
		this.Timeout = mesos.NewPopulatedDurationInfo(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_SetLoggingLevel(r randyMaster, easy bool) *Call_SetLoggingLevel {
	this := &Call_SetLoggingLevel{}
	this.Level = uint32(r.Uint32())
	v1 := mesos.NewPopulatedDurationInfo(r, easy)
	this.Duration = *v1
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_ListFiles(r randyMaster, easy bool) *Call_ListFiles {
	this := &Call_ListFiles{}
	this.Path = string(randStringMaster(r))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_ReadFile(r randyMaster, easy bool) *Call_ReadFile {
	this := &Call_ReadFile{}
	this.Path = string(randStringMaster(r))
	this.Offset = uint64(uint64(r.Uint32()))
	if r.Intn(10) != 0 {
		v2 := uint64(uint64(r.Uint32()))
		this.Length = &v2
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_UpdateWeights(r randyMaster, easy bool) *Call_UpdateWeights {
	this := &Call_UpdateWeights{}
	if r.Intn(10) != 0 {
		v3 := r.Intn(5)
		this.WeightInfos = make([]mesos.WeightInfo, v3)
		for i := 0; i < v3; i++ {
			v4 := mesos.NewPopulatedWeightInfo(r, easy)
			this.WeightInfos[i] = *v4
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_ReserveResources(r randyMaster, easy bool) *Call_ReserveResources {
	this := &Call_ReserveResources{}
	v5 := mesos.NewPopulatedAgentID(r, easy)
	this.AgentID = *v5
	if r.Intn(10) != 0 {
		v6 := r.Intn(5)
		this.Resources = make([]mesos.Resource, v6)
		for i := 0; i < v6; i++ {
			v7 := mesos.NewPopulatedResource(r, easy)
			this.Resources[i] = *v7
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_UnreserveResources(r randyMaster, easy bool) *Call_UnreserveResources {
	this := &Call_UnreserveResources{}
	v8 := mesos.NewPopulatedAgentID(r, easy)
	this.AgentID = *v8
	if r.Intn(10) != 0 {
		v9 := r.Intn(5)
		this.Resources = make([]mesos.Resource, v9)
		for i := 0; i < v9; i++ {
			v10 := mesos.NewPopulatedResource(r, easy)
			this.Resources[i] = *v10
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_CreateVolumes(r randyMaster, easy bool) *Call_CreateVolumes {
	this := &Call_CreateVolumes{}
	v11 := mesos.NewPopulatedAgentID(r, easy)
	this.AgentID = *v11
	if r.Intn(10) != 0 {
		v12 := r.Intn(5)
		this.Volumes = make([]mesos.Resource, v12)
		for i := 0; i < v12; i++ {
			v13 := mesos.NewPopulatedResource(r, easy)
			this.Volumes[i] = *v13
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_DestroyVolumes(r randyMaster, easy bool) *Call_DestroyVolumes {
	this := &Call_DestroyVolumes{}
	v14 := mesos.NewPopulatedAgentID(r, easy)
	this.AgentID = *v14
	if r.Intn(10) != 0 {
		v15 := r.Intn(5)
		this.Volumes = make([]mesos.Resource, v15)
		for i := 0; i < v15; i++ {
			v16 := mesos.NewPopulatedResource(r, easy)
			this.Volumes[i] = *v16
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_UpdateMaintenanceSchedule(r randyMaster, easy bool) *Call_UpdateMaintenanceSchedule {
	this := &Call_UpdateMaintenanceSchedule{}
	v17 := mesos_maintenance.NewPopulatedSchedule(r, easy)
	this.Schedule = *v17
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_StartMaintenance(r randyMaster, easy bool) *Call_StartMaintenance {
	this := &Call_StartMaintenance{}
	if r.Intn(10) != 0 {
		v18 := r.Intn(5)
		this.Machines = make([]mesos.MachineID, v18)
		for i := 0; i < v18; i++ {
			v19 := mesos.NewPopulatedMachineID(r, easy)
			this.Machines[i] = *v19
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_StopMaintenance(r randyMaster, easy bool) *Call_StopMaintenance {
	this := &Call_StopMaintenance{}
	if r.Intn(10) != 0 {
		v20 := r.Intn(5)
		this.Machines = make([]mesos.MachineID, v20)
		for i := 0; i < v20; i++ {
			v21 := mesos.NewPopulatedMachineID(r, easy)
			this.Machines[i] = *v21
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_SetQuota(r randyMaster, easy bool) *Call_SetQuota {
	this := &Call_SetQuota{}
	v22 := mesos_quota.NewPopulatedQuotaRequest(r, easy)
	this.QuotaRequest = *v22
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_RemoveQuota(r randyMaster, easy bool) *Call_RemoveQuota {
	this := &Call_RemoveQuota{}
	this.Role = string(randStringMaster(r))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_Teardown(r randyMaster, easy bool) *Call_Teardown {
	this := &Call_Teardown{}
	v23 := mesos.NewPopulatedFrameworkID(r, easy)
	this.FrameworkID = *v23
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_MarkAgentGone(r randyMaster, easy bool) *Call_MarkAgentGone {
	this := &Call_MarkAgentGone{}
	v24 := mesos.NewPopulatedAgentID(r, easy)
	this.AgentID = *v24
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse(r randyMaster, easy bool) *Response {
	this := &Response{}
	this.Type = Response_Type([]int32{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18}[r.Intn(19)])
	if r.Intn(10) != 0 {
		this.GetHealth = NewPopulatedResponse_GetHealth(r, easy)
	}
	if r.Intn(10) != 0 {
		this.GetFlags = NewPopulatedResponse_GetFlags(r, easy)
	}
	if r.Intn(10) != 0 {
		this.GetVersion = NewPopulatedResponse_GetVersion(r, easy)
	}
	if r.Intn(10) != 0 {
		this.GetMetrics = NewPopulatedResponse_GetMetrics(r, easy)
	}
	if r.Intn(10) != 0 {
		this.GetLoggingLevel = NewPopulatedResponse_GetLoggingLevel(r, easy)
	}
	if r.Intn(10) != 0 {
		this.ListFiles = NewPopulatedResponse_ListFiles(r, easy)
	}
	if r.Intn(10) != 0 {
		this.ReadFile = NewPopulatedResponse_ReadFile(r, easy)
	}
	if r.Intn(10) == 0 {
		this.GetState = NewPopulatedResponse_GetState(r, easy)
	}
	if r.Intn(10) != 0 {
		this.GetAgents = NewPopulatedResponse_GetAgents(r, easy)
	}
	if r.Intn(10) != 0 {
		this.GetFrameworks = NewPopulatedResponse_GetFrameworks(r, easy)
	}
	if r.Intn(10) != 0 {
		this.GetExecutors = NewPopulatedResponse_GetExecutors(r, easy)
	}
	if r.Intn(10) == 0 {
		this.GetTasks = NewPopulatedResponse_GetTasks(r, easy)
	}
	if r.Intn(10) != 0 {
		this.GetRoles = NewPopulatedResponse_GetRoles(r, easy)
	}
	if r.Intn(10) != 0 {
		this.GetWeights = NewPopulatedResponse_GetWeights(r, easy)
	}
	if r.Intn(10) != 0 {
		this.GetMaster = NewPopulatedResponse_GetMaster(r, easy)
	}
	if r.Intn(10) != 0 {
		this.GetMaintenanceStatus = NewPopulatedResponse_GetMaintenanceStatus(r, easy)
	}
	if r.Intn(10) != 0 {
		this.GetMaintenanceSchedule = NewPopulatedResponse_GetMaintenanceSchedule(r, easy)
	}
	if r.Intn(10) != 0 {
		this.GetQuota = NewPopulatedResponse_GetQuota(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_GetHealth(r randyMaster, easy bool) *Response_GetHealth {
	this := &Response_GetHealth{}
	this.Healthy = bool(bool(r.Intn(2) == 0))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_GetFlags(r randyMaster, easy bool) *Response_GetFlags {
	this := &Response_GetFlags{}
	if r.Intn(10) != 0 {
		v25 := r.Intn(5)
		this.Flags = make([]mesos.Flag, v25)
		for i := 0; i < v25; i++ {
			v26 := mesos.NewPopulatedFlag(r, easy)
			this.Flags[i] = *v26
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_GetVersion(r randyMaster, easy bool) *Response_GetVersion {
	this := &Response_GetVersion{}
	v27 := mesos.NewPopulatedVersionInfo(r, easy)
	this.VersionInfo = *v27
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_GetMetrics(r randyMaster, easy bool) *Response_GetMetrics {
	this := &Response_GetMetrics{}
	if r.Intn(10) != 0 {
		v28 := r.Intn(5)
		this.Metrics = make([]mesos.Metric, v28)
		for i := 0; i < v28; i++ {
			v29 := mesos.NewPopulatedMetric(r, easy)
			this.Metrics[i] = *v29
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_GetLoggingLevel(r randyMaster, easy bool) *Response_GetLoggingLevel {
	this := &Response_GetLoggingLevel{}
	this.Level = uint32(r.Uint32())
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_ListFiles(r randyMaster, easy bool) *Response_ListFiles {
	this := &Response_ListFiles{}
	if r.Intn(10) != 0 {
		v30 := r.Intn(5)
		this.FileInfos = make([]mesos.FileInfo, v30)
		for i := 0; i < v30; i++ {
			v31 := mesos.NewPopulatedFileInfo(r, easy)
			this.FileInfos[i] = *v31
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_ReadFile(r randyMaster, easy bool) *Response_ReadFile {
	this := &Response_ReadFile{}
	this.Size = uint64(uint64(r.Uint32()))
	v32 := r.Intn(100)
	this.Data = make([]byte, v32)
	for i := 0; i < v32; i++ {
		this.Data[i] = byte(r.Intn(256))
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_GetState(r randyMaster, easy bool) *Response_GetState {
	this := &Response_GetState{}
	if r.Intn(10) == 0 {
		this.GetTasks = NewPopulatedResponse_GetTasks(r, easy)
	}
	if r.Intn(10) != 0 {
		this.GetExecutors = NewPopulatedResponse_GetExecutors(r, easy)
	}
	if r.Intn(10) != 0 {
		this.GetFrameworks = NewPopulatedResponse_GetFrameworks(r, easy)
	}
	if r.Intn(10) != 0 {
		this.GetAgents = NewPopulatedResponse_GetAgents(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_GetAgents(r randyMaster, easy bool) *Response_GetAgents {
	this := &Response_GetAgents{}
	if r.Intn(10) != 0 {
		v33 := r.Intn(5)
		this.Agents = make([]Response_GetAgents_Agent, v33)
		for i := 0; i < v33; i++ {
			v34 := NewPopulatedResponse_GetAgents_Agent(r, easy)
			this.Agents[i] = *v34
		}
	}
	if r.Intn(10) != 0 {
		v35 := r.Intn(5)
		this.RecoveredAgents = make([]mesos.AgentInfo, v35)
		for i := 0; i < v35; i++ {
			v36 := mesos.NewPopulatedAgentInfo(r, easy)
			this.RecoveredAgents[i] = *v36
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_GetAgents_Agent(r randyMaster, easy bool) *Response_GetAgents_Agent {
	this := &Response_GetAgents_Agent{}
	v37 := mesos.NewPopulatedAgentInfo(r, easy)
	this.AgentInfo = *v37
	this.Active = bool(bool(r.Intn(2) == 0))
	this.Version = string(randStringMaster(r))
	if r.Intn(10) != 0 {
		v38 := string(randStringMaster(r))
		this.PID = &v38
	}
	if r.Intn(10) != 0 {
		this.RegisteredTime = mesos.NewPopulatedTimeInfo(r, easy)
	}
	if r.Intn(10) != 0 {
		this.ReregisteredTime = mesos.NewPopulatedTimeInfo(r, easy)
	}
	if r.Intn(10) != 0 {
		v39 := r.Intn(5)
		this.TotalResources = make([]mesos.Resource, v39)
		for i := 0; i < v39; i++ {
			v40 := mesos.NewPopulatedResource(r, easy)
			this.TotalResources[i] = *v40
		}
	}
	if r.Intn(10) != 0 {
		v41 := r.Intn(5)
		this.AllocatedResources = make([]mesos.Resource, v41)
		for i := 0; i < v41; i++ {
			v42 := mesos.NewPopulatedResource(r, easy)
			this.AllocatedResources[i] = *v42
		}
	}
	if r.Intn(10) != 0 {
		v43 := r.Intn(5)
		this.OfferedResources = make([]mesos.Resource, v43)
		for i := 0; i < v43; i++ {
			v44 := mesos.NewPopulatedResource(r, easy)
			this.OfferedResources[i] = *v44
		}
	}
	if r.Intn(10) != 0 {
		v45 := r.Intn(5)
		this.Capabilities = make([]mesos.AgentInfo_Capability, v45)
		for i := 0; i < v45; i++ {
			v46 := mesos.NewPopulatedAgentInfo_Capability(r, easy)
			this.Capabilities[i] = *v46
		}
	}
	if r.Intn(10) != 0 {
		v47 := r.Intn(5)
		this.ResourceProviders = make([]Response_GetAgents_Agent_ResourceProvider, v47)
		for i := 0; i < v47; i++ {
			v48 := NewPopulatedResponse_GetAgents_Agent_ResourceProvider(r, easy)
			this.ResourceProviders[i] = *v48
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_GetAgents_Agent_ResourceProvider(r randyMaster, easy bool) *Response_GetAgents_Agent_ResourceProvider {
	this := &Response_GetAgents_Agent_ResourceProvider{}
	v49 := mesos.NewPopulatedResourceProviderInfo(r, easy)
	this.ResourceProviderInfo = *v49
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_GetFrameworks(r randyMaster, easy bool) *Response_GetFrameworks {
	this := &Response_GetFrameworks{}
	if r.Intn(10) != 0 {
		v50 := r.Intn(5)
		this.Frameworks = make([]Response_GetFrameworks_Framework, v50)
		for i := 0; i < v50; i++ {
			v51 := NewPopulatedResponse_GetFrameworks_Framework(r, easy)
			this.Frameworks[i] = *v51
		}
	}
	if r.Intn(10) != 0 {
		v52 := r.Intn(5)
		this.CompletedFrameworks = make([]Response_GetFrameworks_Framework, v52)
		for i := 0; i < v52; i++ {
			v53 := NewPopulatedResponse_GetFrameworks_Framework(r, easy)
			this.CompletedFrameworks[i] = *v53
		}
	}
	if r.Intn(10) != 0 {
		v54 := r.Intn(5)
		this.RecoveredFrameworks = make([]mesos.FrameworkInfo, v54)
		for i := 0; i < v54; i++ {
			v55 := mesos.NewPopulatedFrameworkInfo(r, easy)
			this.RecoveredFrameworks[i] = *v55
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_GetFrameworks_Framework(r randyMaster, easy bool) *Response_GetFrameworks_Framework {
	this := &Response_GetFrameworks_Framework{}
	v56 := mesos.NewPopulatedFrameworkInfo(r, easy)
	this.FrameworkInfo = *v56
	this.Active = bool(bool(r.Intn(2) == 0))
	this.Connected = bool(bool(r.Intn(2) == 0))
	if r.Intn(10) != 0 {
		this.RegisteredTime = mesos.NewPopulatedTimeInfo(r, easy)
	}
	if r.Intn(10) != 0 {
		this.ReregisteredTime = mesos.NewPopulatedTimeInfo(r, easy)
	}
	if r.Intn(10) != 0 {
		this.UnregisteredTime = mesos.NewPopulatedTimeInfo(r, easy)
	}
	if r.Intn(10) != 0 {
		v57 := r.Intn(5)
		this.Offers = make([]mesos.Offer, v57)
		for i := 0; i < v57; i++ {
			v58 := mesos.NewPopulatedOffer(r, easy)
			this.Offers[i] = *v58
		}
	}
	if r.Intn(10) != 0 {
		v59 := r.Intn(5)
		this.InverseOffers = make([]mesos.InverseOffer, v59)
		for i := 0; i < v59; i++ {
			v60 := mesos.NewPopulatedInverseOffer(r, easy)
			this.InverseOffers[i] = *v60
		}
	}
	if r.Intn(10) != 0 {
		v61 := r.Intn(5)
		this.AllocatedResources = make([]mesos.Resource, v61)
		for i := 0; i < v61; i++ {
			v62 := mesos.NewPopulatedResource(r, easy)
			this.AllocatedResources[i] = *v62
		}
	}
	if r.Intn(10) != 0 {
		v63 := r.Intn(5)
		this.OfferedResources = make([]mesos.Resource, v63)
		for i := 0; i < v63; i++ {
			v64 := mesos.NewPopulatedResource(r, easy)
			this.OfferedResources[i] = *v64
		}
	}
	this.Recovered = bool(bool(r.Intn(2) == 0))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_GetExecutors(r randyMaster, easy bool) *Response_GetExecutors {
	this := &Response_GetExecutors{}
	if r.Intn(10) != 0 {
		v65 := r.Intn(5)
		this.Executors = make([]Response_GetExecutors_Executor, v65)
		for i := 0; i < v65; i++ {
			v66 := NewPopulatedResponse_GetExecutors_Executor(r, easy)
			this.Executors[i] = *v66
		}
	}
	if r.Intn(10) != 0 {
		v67 := r.Intn(5)
		this.OrphanExecutors = make([]Response_GetExecutors_Executor, v67)
		for i := 0; i < v67; i++ {
			v68 := NewPopulatedResponse_GetExecutors_Executor(r, easy)
			this.OrphanExecutors[i] = *v68
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_GetExecutors_Executor(r randyMaster, easy bool) *Response_GetExecutors_Executor {
	this := &Response_GetExecutors_Executor{}
	v69 := mesos.NewPopulatedExecutorInfo(r, easy)
	this.ExecutorInfo = *v69
	v70 := mesos.NewPopulatedAgentID(r, easy)
	this.AgentID = *v70
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_GetTasks(r randyMaster, easy bool) *Response_GetTasks {
	this := &Response_GetTasks{}
	if r.Intn(10) == 0 {
		v71 := r.Intn(5)
		this.PendingTasks = make([]mesos.Task, v71)
		for i := 0; i < v71; i++ {
			v72 := mesos.NewPopulatedTask(r, easy)
			this.PendingTasks[i] = *v72
		}
	}
	if r.Intn(10) == 0 {
		v73 := r.Intn(5)
		this.Tasks = make([]mesos.Task, v73)
		for i := 0; i < v73; i++ {
			v74 := mesos.NewPopulatedTask(r, easy)
			this.Tasks[i] = *v74
		}
	}
	if r.Intn(10) == 0 {
		v75 := r.Intn(5)
		this.CompletedTasks = make([]mesos.Task, v75)
		for i := 0; i < v75; i++ {
			v76 := mesos.NewPopulatedTask(r, easy)
			this.CompletedTasks[i] = *v76
		}
	}
	if r.Intn(10) == 0 {
		v77 := r.Intn(5)
		this.OrphanTasks = make([]mesos.Task, v77)
		for i := 0; i < v77; i++ {
			v78 := mesos.NewPopulatedTask(r, easy)
			this.OrphanTasks[i] = *v78
		}
	}
	if r.Intn(10) == 0 {
		v79 := r.Intn(5)
		this.UnreachableTasks = make([]mesos.Task, v79)
		for i := 0; i < v79; i++ {
			v80 := mesos.NewPopulatedTask(r, easy)
			this.UnreachableTasks[i] = *v80
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_GetRoles(r randyMaster, easy bool) *Response_GetRoles {
	this := &Response_GetRoles{}
	if r.Intn(10) != 0 {
		v81 := r.Intn(5)
		this.Roles = make([]mesos.Role, v81)
		for i := 0; i < v81; i++ {
			v82 := mesos.NewPopulatedRole(r, easy)
			this.Roles[i] = *v82
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_GetWeights(r randyMaster, easy bool) *Response_GetWeights {
	this := &Response_GetWeights{}
	if r.Intn(10) != 0 {
		v83 := r.Intn(5)
		this.WeightInfos = make([]mesos.WeightInfo, v83)
		for i := 0; i < v83; i++ {
			v84 := mesos.NewPopulatedWeightInfo(r, easy)
			this.WeightInfos[i] = *v84
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_GetMaster(r randyMaster, easy bool) *Response_GetMaster {
	this := &Response_GetMaster{}
	if r.Intn(10) != 0 {
		this.MasterInfo = mesos.NewPopulatedMasterInfo(r, easy)
	}
	if r.Intn(10) != 0 {
		v85 := float64(r.Float64())
		if r.Intn(2) == 0 {
			v85 *= -1
		}
		this.StartTime = &v85
	}
	if r.Intn(10) != 0 {
		v86 := float64(r.Float64())
		if r.Intn(2) == 0 {
			v86 *= -1
		}
		this.ElectedTime = &v86
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_GetMaintenanceStatus(r randyMaster, easy bool) *Response_GetMaintenanceStatus {
	this := &Response_GetMaintenanceStatus{}
	v87 := mesos_maintenance.NewPopulatedClusterStatus(r, easy)
	this.Status = *v87
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_GetMaintenanceSchedule(r randyMaster, easy bool) *Response_GetMaintenanceSchedule {
	this := &Response_GetMaintenanceSchedule{}
	v88 := mesos_maintenance.NewPopulatedSchedule(r, easy)
	this.Schedule = *v88
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_GetQuota(r randyMaster, easy bool) *Response_GetQuota {
	this := &Response_GetQuota{}
	v89 := mesos_quota.NewPopulatedQuotaStatus(r, easy)
	this.Status = *v89
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedEvent(r randyMaster, easy bool) *Event {
	this := &Event{}
	this.Type = Event_Type([]int32{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}[r.Intn(10)])
	if r.Intn(10) == 0 {
		this.Subscribed = NewPopulatedEvent_Subscribed(r, easy)
	}
	if r.Intn(10) == 0 {
		this.TaskAdded = NewPopulatedEvent_TaskAdded(r, easy)
	}
	if r.Intn(10) == 0 {
		this.TaskUpdated = NewPopulatedEvent_TaskUpdated(r, easy)
	}
	if r.Intn(10) != 0 {
		this.AgentAdded = NewPopulatedEvent_AgentAdded(r, easy)
	}
	if r.Intn(10) != 0 {
		this.AgentRemoved = NewPopulatedEvent_AgentRemoved(r, easy)
	}
	if r.Intn(10) != 0 {
		this.FrameworkAdded = NewPopulatedEvent_FrameworkAdded(r, easy)
	}
	if r.Intn(10) != 0 {
		this.FrameworkUpdated = NewPopulatedEvent_FrameworkUpdated(r, easy)
	}
	if r.Intn(10) != 0 {
		this.FrameworkRemoved = NewPopulatedEvent_FrameworkRemoved(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedEvent_Subscribed(r randyMaster, easy bool) *Event_Subscribed {
	this := &Event_Subscribed{}
	if r.Intn(10) == 0 {
		this.GetState = NewPopulatedResponse_GetState(r, easy)
	}
	if r.Intn(10) != 0 {
		v90 := float64(r.Float64())
		if r.Intn(2) == 0 {
			v90 *= -1
		}
		this.HeartbeatIntervalSeconds = &v90
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedEvent_TaskAdded(r randyMaster, easy bool) *Event_TaskAdded {
	this := &Event_TaskAdded{}
	v91 := mesos.NewPopulatedTask(r, easy)
	this.Task = *v91
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedEvent_TaskUpdated(r randyMaster, easy bool) *Event_TaskUpdated {
	this := &Event_TaskUpdated{}
	v92 := mesos.NewPopulatedFrameworkID(r, easy)
	this.FrameworkID = *v92
	v93 := mesos.NewPopulatedTaskStatus(r, easy)
	this.Status = *v93
	v94 := mesos.TaskState([]int32{6, 0, 1, 8, 2, 3, 4, 7, 5, 9, 10, 11, 12, 13}[r.Intn(14)])
	this.State = &v94
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedEvent_FrameworkAdded(r randyMaster, easy bool) *Event_FrameworkAdded {
	this := &Event_FrameworkAdded{}
	v95 := NewPopulatedResponse_GetFrameworks_Framework(r, easy)
	this.Framework = *v95
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedEvent_FrameworkUpdated(r randyMaster, easy bool) *Event_FrameworkUpdated {
	this := &Event_FrameworkUpdated{}
	v96 := NewPopulatedResponse_GetFrameworks_Framework(r, easy)
	this.Framework = *v96
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedEvent_FrameworkRemoved(r randyMaster, easy bool) *Event_FrameworkRemoved {
	this := &Event_FrameworkRemoved{}
	v97 := mesos.NewPopulatedFrameworkInfo(r, easy)
	this.FrameworkInfo = *v97
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedEvent_AgentAdded(r randyMaster, easy bool) *Event_AgentAdded {
	this := &Event_AgentAdded{}
	v98 := NewPopulatedResponse_GetAgents_Agent(r, easy)
	this.Agent = *v98
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedEvent_AgentRemoved(r randyMaster, easy bool) *Event_AgentRemoved {
	this := &Event_AgentRemoved{}
	v99 := mesos.NewPopulatedAgentID(r, easy)
	this.AgentID = *v99
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

type randyMaster interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneMaster(r randyMaster) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringMaster(r randyMaster) string {
	v100 := r.Intn(100)
	tmps := make([]rune, v100)
	for i := 0; i < v100; i++ {
		tmps[i] = randUTF8RuneMaster(r)
	}
	return string(tmps)
}
func randUnrecognizedMaster(r randyMaster, maxFieldNumber int) (dAtA []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		dAtA = randFieldMaster(dAtA, r, fieldNumber, wire)
	}
	return dAtA
}
func randFieldMaster(dAtA []byte, r randyMaster, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		dAtA = encodeVarintPopulateMaster(dAtA, uint64(key))
		v101 := r.Int63()
		if r.Intn(2) == 0 {
			v101 *= -1
		}
		dAtA = encodeVarintPopulateMaster(dAtA, uint64(v101))
	case 1:
		dAtA = encodeVarintPopulateMaster(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		dAtA = encodeVarintPopulateMaster(dAtA, uint64(key))
		ll := r.Intn(100)
		dAtA = encodeVarintPopulateMaster(dAtA, uint64(ll))
		for j := 0; j < ll; j++ {
			dAtA = append(dAtA, byte(r.Intn(256)))
		}
	default:
		dAtA = encodeVarintPopulateMaster(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return dAtA
}
func encodeVarintPopulateMaster(dAtA []byte, v uint64) []byte {
	for v >= 1<<7 {
		dAtA = append(dAtA, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	dAtA = append(dAtA, uint8(v))
	return dAtA
}
func (m *Call) ProtoSize() (n int) {
	var l int
	_ = l
	n += 1 + sovMaster(uint64(m.Type))
	if m.GetMetrics != nil {
		l = m.GetMetrics.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.SetLoggingLevel != nil {
		l = m.SetLoggingLevel.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.ListFiles != nil {
		l = m.ListFiles.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.ReadFile != nil {
		l = m.ReadFile.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.UpdateWeights != nil {
		l = m.UpdateWeights.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.ReserveResources != nil {
		l = m.ReserveResources.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.UnreserveResources != nil {
		l = m.UnreserveResources.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.CreateVolumes != nil {
		l = m.CreateVolumes.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.DestroyVolumes != nil {
		l = m.DestroyVolumes.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.UpdateMaintenanceSchedule != nil {
		l = m.UpdateMaintenanceSchedule.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.StartMaintenance != nil {
		l = m.StartMaintenance.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.StopMaintenance != nil {
		l = m.StopMaintenance.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.SetQuota != nil {
		l = m.SetQuota.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.RemoveQuota != nil {
		l = m.RemoveQuota.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.Teardown != nil {
		l = m.Teardown.ProtoSize()
		n += 2 + l + sovMaster(uint64(l))
	}
	if m.MarkAgentGone != nil {
		l = m.MarkAgentGone.ProtoSize()
		n += 2 + l + sovMaster(uint64(l))
	}
	return n
}

func (m *Call_GetMetrics) ProtoSize() (n int) {
	var l int
	_ = l
	if m.Timeout != nil {
		l = m.Timeout.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	return n
}

func (m *Call_SetLoggingLevel) ProtoSize() (n int) {
	var l int
	_ = l
	n += 1 + sovMaster(uint64(m.Level))
	l = m.Duration.ProtoSize()
	n += 1 + l + sovMaster(uint64(l))
	return n
}

func (m *Call_ListFiles) ProtoSize() (n int) {
	var l int
	_ = l
	l = len(m.Path)
	n += 1 + l + sovMaster(uint64(l))
	return n
}

func (m *Call_ReadFile) ProtoSize() (n int) {
	var l int
	_ = l
	l = len(m.Path)
	n += 1 + l + sovMaster(uint64(l))
	n += 1 + sovMaster(uint64(m.Offset))
	if m.Length != nil {
		n += 1 + sovMaster(uint64(*m.Length))
	}
	return n
}

func (m *Call_UpdateWeights) ProtoSize() (n int) {
	var l int
	_ = l
	if len(m.WeightInfos) > 0 {
		for _, e := range m.WeightInfos {
			l = e.ProtoSize()
			n += 1 + l + sovMaster(uint64(l))
		}
	}
	return n
}

func (m *Call_ReserveResources) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.AgentID.ProtoSize()
	n += 1 + l + sovMaster(uint64(l))
	if len(m.Resources) > 0 {
		for _, e := range m.Resources {
			l = e.ProtoSize()
			n += 1 + l + sovMaster(uint64(l))
		}
	}
	return n
}

func (m *Call_UnreserveResources) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.AgentID.ProtoSize()
	n += 1 + l + sovMaster(uint64(l))
	if len(m.Resources) > 0 {
		for _, e := range m.Resources {
			l = e.ProtoSize()
			n += 1 + l + sovMaster(uint64(l))
		}
	}
	return n
}

func (m *Call_CreateVolumes) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.AgentID.ProtoSize()
	n += 1 + l + sovMaster(uint64(l))
	if len(m.Volumes) > 0 {
		for _, e := range m.Volumes {
			l = e.ProtoSize()
			n += 1 + l + sovMaster(uint64(l))
		}
	}
	return n
}

func (m *Call_DestroyVolumes) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.AgentID.ProtoSize()
	n += 1 + l + sovMaster(uint64(l))
	if len(m.Volumes) > 0 {
		for _, e := range m.Volumes {
			l = e.ProtoSize()
			n += 1 + l + sovMaster(uint64(l))
		}
	}
	return n
}

func (m *Call_UpdateMaintenanceSchedule) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.Schedule.ProtoSize()
	n += 1 + l + sovMaster(uint64(l))
	return n
}

func (m *Call_StartMaintenance) ProtoSize() (n int) {
	var l int
	_ = l
	if len(m.Machines) > 0 {
		for _, e := range m.Machines {
			l = e.ProtoSize()
			n += 1 + l + sovMaster(uint64(l))
		}
	}
	return n
}

func (m *Call_StopMaintenance) ProtoSize() (n int) {
	var l int
	_ = l
	if len(m.Machines) > 0 {
		for _, e := range m.Machines {
			l = e.ProtoSize()
			n += 1 + l + sovMaster(uint64(l))
		}
	}
	return n
}

func (m *Call_SetQuota) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.QuotaRequest.ProtoSize()
	n += 1 + l + sovMaster(uint64(l))
	return n
}

func (m *Call_RemoveQuota) ProtoSize() (n int) {
	var l int
	_ = l
	l = len(m.Role)
	n += 1 + l + sovMaster(uint64(l))
	return n
}

func (m *Call_Teardown) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.FrameworkID.ProtoSize()
	n += 1 + l + sovMaster(uint64(l))
	return n
}

func (m *Call_MarkAgentGone) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.AgentID.ProtoSize()
	n += 1 + l + sovMaster(uint64(l))
	return n
}

func (m *Response) ProtoSize() (n int) {
	var l int
	_ = l
	n += 1 + sovMaster(uint64(m.Type))
	if m.GetHealth != nil {
		l = m.GetHealth.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.GetFlags != nil {
		l = m.GetFlags.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.GetVersion != nil {
		l = m.GetVersion.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.GetMetrics != nil {
		l = m.GetMetrics.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.GetLoggingLevel != nil {
		l = m.GetLoggingLevel.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.ListFiles != nil {
		l = m.ListFiles.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.ReadFile != nil {
		l = m.ReadFile.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.GetState != nil {
		l = m.GetState.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.GetAgents != nil {
		l = m.GetAgents.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.GetFrameworks != nil {
		l = m.GetFrameworks.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.GetExecutors != nil {
		l = m.GetExecutors.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.GetTasks != nil {
		l = m.GetTasks.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.GetRoles != nil {
		l = m.GetRoles.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.GetWeights != nil {
		l = m.GetWeights.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.GetMaster != nil {
		l = m.GetMaster.ProtoSize()
		n += 2 + l + sovMaster(uint64(l))
	}
	if m.GetMaintenanceStatus != nil {
		l = m.GetMaintenanceStatus.ProtoSize()
		n += 2 + l + sovMaster(uint64(l))
	}
	if m.GetMaintenanceSchedule != nil {
		l = m.GetMaintenanceSchedule.ProtoSize()
		n += 2 + l + sovMaster(uint64(l))
	}
	if m.GetQuota != nil {
		l = m.GetQuota.ProtoSize()
		n += 2 + l + sovMaster(uint64(l))
	}
	return n
}

func (m *Response_GetHealth) ProtoSize() (n int) {
	var l int
	_ = l
	n += 2
	return n
}

func (m *Response_GetFlags) ProtoSize() (n int) {
	var l int
	_ = l
	if len(m.Flags) > 0 {
		for _, e := range m.Flags {
			l = e.ProtoSize()
			n += 1 + l + sovMaster(uint64(l))
		}
	}
	return n
}

func (m *Response_GetVersion) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.VersionInfo.ProtoSize()
	n += 1 + l + sovMaster(uint64(l))
	return n
}

func (m *Response_GetMetrics) ProtoSize() (n int) {
	var l int
	_ = l
	if len(m.Metrics) > 0 {
		for _, e := range m.Metrics {
			l = e.ProtoSize()
			n += 1 + l + sovMaster(uint64(l))
		}
	}
	return n
}

func (m *Response_GetLoggingLevel) ProtoSize() (n int) {
	var l int
	_ = l
	n += 1 + sovMaster(uint64(m.Level))
	return n
}

func (m *Response_ListFiles) ProtoSize() (n int) {
	var l int
	_ = l
	if len(m.FileInfos) > 0 {
		for _, e := range m.FileInfos {
			l = e.ProtoSize()
			n += 1 + l + sovMaster(uint64(l))
		}
	}
	return n
}

func (m *Response_ReadFile) ProtoSize() (n int) {
	var l int
	_ = l
	n += 1 + sovMaster(uint64(m.Size))
	if m.Data != nil {
		l = len(m.Data)
		n += 1 + l + sovMaster(uint64(l))
	}
	return n
}

func (m *Response_GetState) ProtoSize() (n int) {
	var l int
	_ = l
	if m.GetTasks != nil {
		l = m.GetTasks.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.GetExecutors != nil {
		l = m.GetExecutors.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.GetFrameworks != nil {
		l = m.GetFrameworks.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.GetAgents != nil {
		l = m.GetAgents.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	return n
}

func (m *Response_GetAgents) ProtoSize() (n int) {
	var l int
	_ = l
	if len(m.Agents) > 0 {
		for _, e := range m.Agents {
			l = e.ProtoSize()
			n += 1 + l + sovMaster(uint64(l))
		}
	}
	if len(m.RecoveredAgents) > 0 {
		for _, e := range m.RecoveredAgents {
			l = e.ProtoSize()
			n += 1 + l + sovMaster(uint64(l))
		}
	}
	return n
}

func (m *Response_GetAgents_Agent) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.AgentInfo.ProtoSize()
	n += 1 + l + sovMaster(uint64(l))
	n += 2
	l = len(m.Version)
	n += 1 + l + sovMaster(uint64(l))
	if m.PID != nil {
		l = len(*m.PID)
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.RegisteredTime != nil {
		l = m.RegisteredTime.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.ReregisteredTime != nil {
		l = m.ReregisteredTime.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if len(m.TotalResources) > 0 {
		for _, e := range m.TotalResources {
			l = e.ProtoSize()
			n += 1 + l + sovMaster(uint64(l))
		}
	}
	if len(m.AllocatedResources) > 0 {
		for _, e := range m.AllocatedResources {
			l = e.ProtoSize()
			n += 1 + l + sovMaster(uint64(l))
		}
	}
	if len(m.OfferedResources) > 0 {
		for _, e := range m.OfferedResources {
			l = e.ProtoSize()
			n += 1 + l + sovMaster(uint64(l))
		}
	}
	if len(m.Capabilities) > 0 {
		for _, e := range m.Capabilities {
			l = e.ProtoSize()
			n += 1 + l + sovMaster(uint64(l))
		}
	}
	if len(m.ResourceProviders) > 0 {
		for _, e := range m.ResourceProviders {
			l = e.ProtoSize()
			n += 1 + l + sovMaster(uint64(l))
		}
	}
	return n
}

func (m *Response_GetAgents_Agent_ResourceProvider) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.ResourceProviderInfo.ProtoSize()
	n += 1 + l + sovMaster(uint64(l))
	return n
}

func (m *Response_GetFrameworks) ProtoSize() (n int) {
	var l int
	_ = l
	if len(m.Frameworks) > 0 {
		for _, e := range m.Frameworks {
			l = e.ProtoSize()
			n += 1 + l + sovMaster(uint64(l))
		}
	}
	if len(m.CompletedFrameworks) > 0 {
		for _, e := range m.CompletedFrameworks {
			l = e.ProtoSize()
			n += 1 + l + sovMaster(uint64(l))
		}
	}
	if len(m.RecoveredFrameworks) > 0 {
		for _, e := range m.RecoveredFrameworks {
			l = e.ProtoSize()
			n += 1 + l + sovMaster(uint64(l))
		}
	}
	return n
}

func (m *Response_GetFrameworks_Framework) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.FrameworkInfo.ProtoSize()
	n += 1 + l + sovMaster(uint64(l))
	n += 2
	n += 2
	if m.RegisteredTime != nil {
		l = m.RegisteredTime.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.ReregisteredTime != nil {
		l = m.ReregisteredTime.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.UnregisteredTime != nil {
		l = m.UnregisteredTime.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if len(m.Offers) > 0 {
		for _, e := range m.Offers {
			l = e.ProtoSize()
			n += 1 + l + sovMaster(uint64(l))
		}
	}
	if len(m.InverseOffers) > 0 {
		for _, e := range m.InverseOffers {
			l = e.ProtoSize()
			n += 1 + l + sovMaster(uint64(l))
		}
	}
	if len(m.AllocatedResources) > 0 {
		for _, e := range m.AllocatedResources {
			l = e.ProtoSize()
			n += 1 + l + sovMaster(uint64(l))
		}
	}
	if len(m.OfferedResources) > 0 {
		for _, e := range m.OfferedResources {
			l = e.ProtoSize()
			n += 1 + l + sovMaster(uint64(l))
		}
	}
	n += 2
	return n
}

func (m *Response_GetExecutors) ProtoSize() (n int) {
	var l int
	_ = l
	if len(m.Executors) > 0 {
		for _, e := range m.Executors {
			l = e.ProtoSize()
			n += 1 + l + sovMaster(uint64(l))
		}
	}
	if len(m.OrphanExecutors) > 0 {
		for _, e := range m.OrphanExecutors {
			l = e.ProtoSize()
			n += 1 + l + sovMaster(uint64(l))
		}
	}
	return n
}

func (m *Response_GetExecutors_Executor) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.ExecutorInfo.ProtoSize()
	n += 1 + l + sovMaster(uint64(l))
	l = m.AgentID.ProtoSize()
	n += 1 + l + sovMaster(uint64(l))
	return n
}

func (m *Response_GetTasks) ProtoSize() (n int) {
	var l int
	_ = l
	if len(m.PendingTasks) > 0 {
		for _, e := range m.PendingTasks {
			l = e.ProtoSize()
			n += 1 + l + sovMaster(uint64(l))
		}
	}
	if len(m.Tasks) > 0 {
		for _, e := range m.Tasks {
			l = e.ProtoSize()
			n += 1 + l + sovMaster(uint64(l))
		}
	}
	if len(m.CompletedTasks) > 0 {
		for _, e := range m.CompletedTasks {
			l = e.ProtoSize()
			n += 1 + l + sovMaster(uint64(l))
		}
	}
	if len(m.OrphanTasks) > 0 {
		for _, e := range m.OrphanTasks {
			l = e.ProtoSize()
			n += 1 + l + sovMaster(uint64(l))
		}
	}
	if len(m.UnreachableTasks) > 0 {
		for _, e := range m.UnreachableTasks {
			l = e.ProtoSize()
			n += 1 + l + sovMaster(uint64(l))
		}
	}
	return n
}

func (m *Response_GetRoles) ProtoSize() (n int) {
	var l int
	_ = l
	if len(m.Roles) > 0 {
		for _, e := range m.Roles {
			l = e.ProtoSize()
			n += 1 + l + sovMaster(uint64(l))
		}
	}
	return n
}

func (m *Response_GetWeights) ProtoSize() (n int) {
	var l int
	_ = l
	if len(m.WeightInfos) > 0 {
		for _, e := range m.WeightInfos {
			l = e.ProtoSize()
			n += 1 + l + sovMaster(uint64(l))
		}
	}
	return n
}

func (m *Response_GetMaster) ProtoSize() (n int) {
	var l int
	_ = l
	if m.MasterInfo != nil {
		l = m.MasterInfo.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.StartTime != nil {
		n += 9
	}
	if m.ElectedTime != nil {
		n += 9
	}
	return n
}

func (m *Response_GetMaintenanceStatus) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.Status.ProtoSize()
	n += 1 + l + sovMaster(uint64(l))
	return n
}

func (m *Response_GetMaintenanceSchedule) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.Schedule.ProtoSize()
	n += 1 + l + sovMaster(uint64(l))
	return n
}

func (m *Response_GetQuota) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.Status.ProtoSize()
	n += 1 + l + sovMaster(uint64(l))
	return n
}

func (m *Event) ProtoSize() (n int) {
	var l int
	_ = l
	n += 1 + sovMaster(uint64(m.Type))
	if m.Subscribed != nil {
		l = m.Subscribed.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.TaskAdded != nil {
		l = m.TaskAdded.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.TaskUpdated != nil {
		l = m.TaskUpdated.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.AgentAdded != nil {
		l = m.AgentAdded.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.AgentRemoved != nil {
		l = m.AgentRemoved.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.FrameworkAdded != nil {
		l = m.FrameworkAdded.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.FrameworkUpdated != nil {
		l = m.FrameworkUpdated.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.FrameworkRemoved != nil {
		l = m.FrameworkRemoved.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	return n
}

func (m *Event_Subscribed) ProtoSize() (n int) {
	var l int
	_ = l
	if m.GetState != nil {
		l = m.GetState.ProtoSize()
		n += 1 + l + sovMaster(uint64(l))
	}
	if m.HeartbeatIntervalSeconds != nil {
		n += 9
	}
	return n
}

func (m *Event_TaskAdded) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.Task.ProtoSize()
	n += 1 + l + sovMaster(uint64(l))
	return n
}

func (m *Event_TaskUpdated) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.FrameworkID.ProtoSize()
	n += 1 + l + sovMaster(uint64(l))
	l = m.Status.ProtoSize()
	n += 1 + l + sovMaster(uint64(l))
	if m.State != nil {
		n += 1 + sovMaster(uint64(*m.State))
	}
	return n
}

func (m *Event_FrameworkAdded) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.Framework.ProtoSize()
	n += 1 + l + sovMaster(uint64(l))
	return n
}

func (m *Event_FrameworkUpdated) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.Framework.ProtoSize()
	n += 1 + l + sovMaster(uint64(l))
	return n
}

func (m *Event_FrameworkRemoved) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.FrameworkInfo.ProtoSize()
	n += 1 + l + sovMaster(uint64(l))
	return n
}

func (m *Event_AgentAdded) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.Agent.ProtoSize()
	n += 1 + l + sovMaster(uint64(l))
	return n
}

func (m *Event_AgentRemoved) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.AgentID.ProtoSize()
	n += 1 + l + sovMaster(uint64(l))
	return n
}

func sovMaster(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozMaster(x uint64) (n int) {
	return sovMaster(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Call) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`GetMetrics:` + strings.Replace(fmt.Sprintf("%v", this.GetMetrics), "Call_GetMetrics", "Call_GetMetrics", 1) + `,`,
		`SetLoggingLevel:` + strings.Replace(fmt.Sprintf("%v", this.SetLoggingLevel), "Call_SetLoggingLevel", "Call_SetLoggingLevel", 1) + `,`,
		`ListFiles:` + strings.Replace(fmt.Sprintf("%v", this.ListFiles), "Call_ListFiles", "Call_ListFiles", 1) + `,`,
		`ReadFile:` + strings.Replace(fmt.Sprintf("%v", this.ReadFile), "Call_ReadFile", "Call_ReadFile", 1) + `,`,
		`UpdateWeights:` + strings.Replace(fmt.Sprintf("%v", this.UpdateWeights), "Call_UpdateWeights", "Call_UpdateWeights", 1) + `,`,
		`ReserveResources:` + strings.Replace(fmt.Sprintf("%v", this.ReserveResources), "Call_ReserveResources", "Call_ReserveResources", 1) + `,`,
		`UnreserveResources:` + strings.Replace(fmt.Sprintf("%v", this.UnreserveResources), "Call_UnreserveResources", "Call_UnreserveResources", 1) + `,`,
		`CreateVolumes:` + strings.Replace(fmt.Sprintf("%v", this.CreateVolumes), "Call_CreateVolumes", "Call_CreateVolumes", 1) + `,`,
		`DestroyVolumes:` + strings.Replace(fmt.Sprintf("%v", this.DestroyVolumes), "Call_DestroyVolumes", "Call_DestroyVolumes", 1) + `,`,
		`UpdateMaintenanceSchedule:` + strings.Replace(fmt.Sprintf("%v", this.UpdateMaintenanceSchedule), "Call_UpdateMaintenanceSchedule", "Call_UpdateMaintenanceSchedule", 1) + `,`,
		`StartMaintenance:` + strings.Replace(fmt.Sprintf("%v", this.StartMaintenance), "Call_StartMaintenance", "Call_StartMaintenance", 1) + `,`,
		`StopMaintenance:` + strings.Replace(fmt.Sprintf("%v", this.StopMaintenance), "Call_StopMaintenance", "Call_StopMaintenance", 1) + `,`,
		`SetQuota:` + strings.Replace(fmt.Sprintf("%v", this.SetQuota), "Call_SetQuota", "Call_SetQuota", 1) + `,`,
		`RemoveQuota:` + strings.Replace(fmt.Sprintf("%v", this.RemoveQuota), "Call_RemoveQuota", "Call_RemoveQuota", 1) + `,`,
		`Teardown:` + strings.Replace(fmt.Sprintf("%v", this.Teardown), "Call_Teardown", "Call_Teardown", 1) + `,`,
		`MarkAgentGone:` + strings.Replace(fmt.Sprintf("%v", this.MarkAgentGone), "Call_MarkAgentGone", "Call_MarkAgentGone", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_GetMetrics) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_GetMetrics{`,
		`Timeout:` + strings.Replace(fmt.Sprintf("%v", this.Timeout), "DurationInfo", "mesos.DurationInfo", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_SetLoggingLevel) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_SetLoggingLevel{`,
		`Level:` + fmt.Sprintf("%v", this.Level) + `,`,
		`Duration:` + strings.Replace(strings.Replace(this.Duration.String(), "DurationInfo", "mesos.DurationInfo", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_ListFiles) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_ListFiles{`,
		`Path:` + fmt.Sprintf("%v", this.Path) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_ReadFile) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_ReadFile{`,
		`Path:` + fmt.Sprintf("%v", this.Path) + `,`,
		`Offset:` + fmt.Sprintf("%v", this.Offset) + `,`,
		`Length:` + valueToStringMaster(this.Length) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_UpdateWeights) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_UpdateWeights{`,
		`WeightInfos:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.WeightInfos), "WeightInfo", "mesos.WeightInfo", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_ReserveResources) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_ReserveResources{`,
		`AgentID:` + strings.Replace(strings.Replace(this.AgentID.String(), "AgentID", "mesos.AgentID", 1), `&`, ``, 1) + `,`,
		`Resources:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Resources), "Resource", "mesos.Resource", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_UnreserveResources) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_UnreserveResources{`,
		`AgentID:` + strings.Replace(strings.Replace(this.AgentID.String(), "AgentID", "mesos.AgentID", 1), `&`, ``, 1) + `,`,
		`Resources:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Resources), "Resource", "mesos.Resource", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_CreateVolumes) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_CreateVolumes{`,
		`AgentID:` + strings.Replace(strings.Replace(this.AgentID.String(), "AgentID", "mesos.AgentID", 1), `&`, ``, 1) + `,`,
		`Volumes:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Volumes), "Resource", "mesos.Resource", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_DestroyVolumes) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_DestroyVolumes{`,
		`AgentID:` + strings.Replace(strings.Replace(this.AgentID.String(), "AgentID", "mesos.AgentID", 1), `&`, ``, 1) + `,`,
		`Volumes:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Volumes), "Resource", "mesos.Resource", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_UpdateMaintenanceSchedule) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_UpdateMaintenanceSchedule{`,
		`Schedule:` + strings.Replace(strings.Replace(this.Schedule.String(), "Schedule", "mesos_maintenance.Schedule", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_StartMaintenance) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_StartMaintenance{`,
		`Machines:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Machines), "MachineID", "mesos.MachineID", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_StopMaintenance) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_StopMaintenance{`,
		`Machines:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Machines), "MachineID", "mesos.MachineID", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_SetQuota) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_SetQuota{`,
		`QuotaRequest:` + strings.Replace(strings.Replace(this.QuotaRequest.String(), "QuotaRequest", "mesos_quota.QuotaRequest", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_RemoveQuota) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_RemoveQuota{`,
		`Role:` + fmt.Sprintf("%v", this.Role) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_Teardown) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_Teardown{`,
		`FrameworkID:` + strings.Replace(strings.Replace(this.FrameworkID.String(), "FrameworkID", "mesos.FrameworkID", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_MarkAgentGone) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_MarkAgentGone{`,
		`AgentID:` + strings.Replace(strings.Replace(this.AgentID.String(), "AgentID", "mesos.AgentID", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`GetHealth:` + strings.Replace(fmt.Sprintf("%v", this.GetHealth), "Response_GetHealth", "Response_GetHealth", 1) + `,`,
		`GetFlags:` + strings.Replace(fmt.Sprintf("%v", this.GetFlags), "Response_GetFlags", "Response_GetFlags", 1) + `,`,
		`GetVersion:` + strings.Replace(fmt.Sprintf("%v", this.GetVersion), "Response_GetVersion", "Response_GetVersion", 1) + `,`,
		`GetMetrics:` + strings.Replace(fmt.Sprintf("%v", this.GetMetrics), "Response_GetMetrics", "Response_GetMetrics", 1) + `,`,
		`GetLoggingLevel:` + strings.Replace(fmt.Sprintf("%v", this.GetLoggingLevel), "Response_GetLoggingLevel", "Response_GetLoggingLevel", 1) + `,`,
		`ListFiles:` + strings.Replace(fmt.Sprintf("%v", this.ListFiles), "Response_ListFiles", "Response_ListFiles", 1) + `,`,
		`ReadFile:` + strings.Replace(fmt.Sprintf("%v", this.ReadFile), "Response_ReadFile", "Response_ReadFile", 1) + `,`,
		`GetState:` + strings.Replace(fmt.Sprintf("%v", this.GetState), "Response_GetState", "Response_GetState", 1) + `,`,
		`GetAgents:` + strings.Replace(fmt.Sprintf("%v", this.GetAgents), "Response_GetAgents", "Response_GetAgents", 1) + `,`,
		`GetFrameworks:` + strings.Replace(fmt.Sprintf("%v", this.GetFrameworks), "Response_GetFrameworks", "Response_GetFrameworks", 1) + `,`,
		`GetExecutors:` + strings.Replace(fmt.Sprintf("%v", this.GetExecutors), "Response_GetExecutors", "Response_GetExecutors", 1) + `,`,
		`GetTasks:` + strings.Replace(fmt.Sprintf("%v", this.GetTasks), "Response_GetTasks", "Response_GetTasks", 1) + `,`,
		`GetRoles:` + strings.Replace(fmt.Sprintf("%v", this.GetRoles), "Response_GetRoles", "Response_GetRoles", 1) + `,`,
		`GetWeights:` + strings.Replace(fmt.Sprintf("%v", this.GetWeights), "Response_GetWeights", "Response_GetWeights", 1) + `,`,
		`GetMaster:` + strings.Replace(fmt.Sprintf("%v", this.GetMaster), "Response_GetMaster", "Response_GetMaster", 1) + `,`,
		`GetMaintenanceStatus:` + strings.Replace(fmt.Sprintf("%v", this.GetMaintenanceStatus), "Response_GetMaintenanceStatus", "Response_GetMaintenanceStatus", 1) + `,`,
		`GetMaintenanceSchedule:` + strings.Replace(fmt.Sprintf("%v", this.GetMaintenanceSchedule), "Response_GetMaintenanceSchedule", "Response_GetMaintenanceSchedule", 1) + `,`,
		`GetQuota:` + strings.Replace(fmt.Sprintf("%v", this.GetQuota), "Response_GetQuota", "Response_GetQuota", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_GetHealth) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_GetHealth{`,
		`Healthy:` + fmt.Sprintf("%v", this.Healthy) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_GetFlags) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_GetFlags{`,
		`Flags:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Flags), "Flag", "mesos.Flag", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_GetVersion) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_GetVersion{`,
		`VersionInfo:` + strings.Replace(strings.Replace(this.VersionInfo.String(), "VersionInfo", "mesos.VersionInfo", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_GetMetrics) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_GetMetrics{`,
		`Metrics:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Metrics), "Metric", "mesos.Metric", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_GetLoggingLevel) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_GetLoggingLevel{`,
		`Level:` + fmt.Sprintf("%v", this.Level) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_ListFiles) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_ListFiles{`,
		`FileInfos:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.FileInfos), "FileInfo", "mesos.FileInfo", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_ReadFile) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_ReadFile{`,
		`Size:` + fmt.Sprintf("%v", this.Size) + `,`,
		`Data:` + valueToStringMaster(this.Data) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_GetState) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_GetState{`,
		`GetTasks:` + strings.Replace(fmt.Sprintf("%v", this.GetTasks), "Response_GetTasks", "Response_GetTasks", 1) + `,`,
		`GetExecutors:` + strings.Replace(fmt.Sprintf("%v", this.GetExecutors), "Response_GetExecutors", "Response_GetExecutors", 1) + `,`,
		`GetFrameworks:` + strings.Replace(fmt.Sprintf("%v", this.GetFrameworks), "Response_GetFrameworks", "Response_GetFrameworks", 1) + `,`,
		`GetAgents:` + strings.Replace(fmt.Sprintf("%v", this.GetAgents), "Response_GetAgents", "Response_GetAgents", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_GetAgents) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_GetAgents{`,
		`Agents:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Agents), "Response_GetAgents_Agent", "Response_GetAgents_Agent", 1), `&`, ``, 1) + `,`,
		`RecoveredAgents:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.RecoveredAgents), "AgentInfo", "mesos.AgentInfo", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_GetAgents_Agent) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_GetAgents_Agent{`,
		`AgentInfo:` + strings.Replace(strings.Replace(this.AgentInfo.String(), "AgentInfo", "mesos.AgentInfo", 1), `&`, ``, 1) + `,`,
		`Active:` + fmt.Sprintf("%v", this.Active) + `,`,
		`Version:` + fmt.Sprintf("%v", this.Version) + `,`,
		`PID:` + valueToStringMaster(this.PID) + `,`,
		`RegisteredTime:` + strings.Replace(fmt.Sprintf("%v", this.RegisteredTime), "TimeInfo", "mesos.TimeInfo", 1) + `,`,
		`ReregisteredTime:` + strings.Replace(fmt.Sprintf("%v", this.ReregisteredTime), "TimeInfo", "mesos.TimeInfo", 1) + `,`,
		`TotalResources:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.TotalResources), "Resource", "mesos.Resource", 1), `&`, ``, 1) + `,`,
		`AllocatedResources:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.AllocatedResources), "Resource", "mesos.Resource", 1), `&`, ``, 1) + `,`,
		`OfferedResources:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.OfferedResources), "Resource", "mesos.Resource", 1), `&`, ``, 1) + `,`,
		`Capabilities:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Capabilities), "AgentInfo_Capability", "mesos.AgentInfo_Capability", 1), `&`, ``, 1) + `,`,
		`ResourceProviders:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.ResourceProviders), "Response_GetAgents_Agent_ResourceProvider", "Response_GetAgents_Agent_ResourceProvider", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_GetAgents_Agent_ResourceProvider) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_GetAgents_Agent_ResourceProvider{`,
		`ResourceProviderInfo:` + strings.Replace(strings.Replace(this.ResourceProviderInfo.String(), "ResourceProviderInfo", "mesos.ResourceProviderInfo", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_GetFrameworks) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_GetFrameworks{`,
		`Frameworks:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Frameworks), "Response_GetFrameworks_Framework", "Response_GetFrameworks_Framework", 1), `&`, ``, 1) + `,`,
		`CompletedFrameworks:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.CompletedFrameworks), "Response_GetFrameworks_Framework", "Response_GetFrameworks_Framework", 1), `&`, ``, 1) + `,`,
		`RecoveredFrameworks:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.RecoveredFrameworks), "FrameworkInfo", "mesos.FrameworkInfo", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_GetFrameworks_Framework) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_GetFrameworks_Framework{`,
		`FrameworkInfo:` + strings.Replace(strings.Replace(this.FrameworkInfo.String(), "FrameworkInfo", "mesos.FrameworkInfo", 1), `&`, ``, 1) + `,`,
		`Active:` + fmt.Sprintf("%v", this.Active) + `,`,
		`Connected:` + fmt.Sprintf("%v", this.Connected) + `,`,
		`RegisteredTime:` + strings.Replace(fmt.Sprintf("%v", this.RegisteredTime), "TimeInfo", "mesos.TimeInfo", 1) + `,`,
		`ReregisteredTime:` + strings.Replace(fmt.Sprintf("%v", this.ReregisteredTime), "TimeInfo", "mesos.TimeInfo", 1) + `,`,
		`UnregisteredTime:` + strings.Replace(fmt.Sprintf("%v", this.UnregisteredTime), "TimeInfo", "mesos.TimeInfo", 1) + `,`,
		`Offers:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Offers), "Offer", "mesos.Offer", 1), `&`, ``, 1) + `,`,
		`InverseOffers:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.InverseOffers), "InverseOffer", "mesos.InverseOffer", 1), `&`, ``, 1) + `,`,
		`AllocatedResources:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.AllocatedResources), "Resource", "mesos.Resource", 1), `&`, ``, 1) + `,`,
		`OfferedResources:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.OfferedResources), "Resource", "mesos.Resource", 1), `&`, ``, 1) + `,`,
		`Recovered:` + fmt.Sprintf("%v", this.Recovered) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_GetExecutors) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_GetExecutors{`,
		`Executors:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Executors), "Response_GetExecutors_Executor", "Response_GetExecutors_Executor", 1), `&`, ``, 1) + `,`,
		`OrphanExecutors:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.OrphanExecutors), "Response_GetExecutors_Executor", "Response_GetExecutors_Executor", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_GetExecutors_Executor) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_GetExecutors_Executor{`,
		`ExecutorInfo:` + strings.Replace(strings.Replace(this.ExecutorInfo.String(), "ExecutorInfo", "mesos.ExecutorInfo", 1), `&`, ``, 1) + `,`,
		`AgentID:` + strings.Replace(strings.Replace(this.AgentID.String(), "AgentID", "mesos.AgentID", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_GetTasks) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_GetTasks{`,
		`PendingTasks:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.PendingTasks), "Task", "mesos.Task", 1), `&`, ``, 1) + `,`,
		`Tasks:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Tasks), "Task", "mesos.Task", 1), `&`, ``, 1) + `,`,
		`CompletedTasks:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.CompletedTasks), "Task", "mesos.Task", 1), `&`, ``, 1) + `,`,
		`OrphanTasks:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.OrphanTasks), "Task", "mesos.Task", 1), `&`, ``, 1) + `,`,
		`UnreachableTasks:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.UnreachableTasks), "Task", "mesos.Task", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_GetRoles) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_GetRoles{`,
		`Roles:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Roles), "Role", "mesos.Role", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_GetWeights) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_GetWeights{`,
		`WeightInfos:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.WeightInfos), "WeightInfo", "mesos.WeightInfo", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_GetMaster) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_GetMaster{`,
		`MasterInfo:` + strings.Replace(fmt.Sprintf("%v", this.MasterInfo), "MasterInfo", "mesos.MasterInfo", 1) + `,`,
		`StartTime:` + valueToStringMaster(this.StartTime) + `,`,
		`ElectedTime:` + valueToStringMaster(this.ElectedTime) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_GetMaintenanceStatus) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_GetMaintenanceStatus{`,
		`Status:` + strings.Replace(strings.Replace(this.Status.String(), "ClusterStatus", "mesos_maintenance.ClusterStatus", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_GetMaintenanceSchedule) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_GetMaintenanceSchedule{`,
		`Schedule:` + strings.Replace(strings.Replace(this.Schedule.String(), "Schedule", "mesos_maintenance.Schedule", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_GetQuota) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_GetQuota{`,
		`Status:` + strings.Replace(strings.Replace(this.Status.String(), "QuotaStatus", "mesos_quota.QuotaStatus", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Event) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Event{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`Subscribed:` + strings.Replace(fmt.Sprintf("%v", this.Subscribed), "Event_Subscribed", "Event_Subscribed", 1) + `,`,
		`TaskAdded:` + strings.Replace(fmt.Sprintf("%v", this.TaskAdded), "Event_TaskAdded", "Event_TaskAdded", 1) + `,`,
		`TaskUpdated:` + strings.Replace(fmt.Sprintf("%v", this.TaskUpdated), "Event_TaskUpdated", "Event_TaskUpdated", 1) + `,`,
		`AgentAdded:` + strings.Replace(fmt.Sprintf("%v", this.AgentAdded), "Event_AgentAdded", "Event_AgentAdded", 1) + `,`,
		`AgentRemoved:` + strings.Replace(fmt.Sprintf("%v", this.AgentRemoved), "Event_AgentRemoved", "Event_AgentRemoved", 1) + `,`,
		`FrameworkAdded:` + strings.Replace(fmt.Sprintf("%v", this.FrameworkAdded), "Event_FrameworkAdded", "Event_FrameworkAdded", 1) + `,`,
		`FrameworkUpdated:` + strings.Replace(fmt.Sprintf("%v", this.FrameworkUpdated), "Event_FrameworkUpdated", "Event_FrameworkUpdated", 1) + `,`,
		`FrameworkRemoved:` + strings.Replace(fmt.Sprintf("%v", this.FrameworkRemoved), "Event_FrameworkRemoved", "Event_FrameworkRemoved", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Event_Subscribed) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Event_Subscribed{`,
		`GetState:` + strings.Replace(fmt.Sprintf("%v", this.GetState), "Response_GetState", "Response_GetState", 1) + `,`,
		`HeartbeatIntervalSeconds:` + valueToStringMaster(this.HeartbeatIntervalSeconds) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Event_TaskAdded) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Event_TaskAdded{`,
		`Task:` + strings.Replace(strings.Replace(this.Task.String(), "Task", "mesos.Task", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Event_TaskUpdated) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Event_TaskUpdated{`,
		`FrameworkID:` + strings.Replace(strings.Replace(this.FrameworkID.String(), "FrameworkID", "mesos.FrameworkID", 1), `&`, ``, 1) + `,`,
		`Status:` + strings.Replace(strings.Replace(this.Status.String(), "TaskStatus", "mesos.TaskStatus", 1), `&`, ``, 1) + `,`,
		`State:` + valueToStringMaster(this.State) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Event_FrameworkAdded) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Event_FrameworkAdded{`,
		`Framework:` + strings.Replace(strings.Replace(this.Framework.String(), "Response_GetFrameworks_Framework", "Response_GetFrameworks_Framework", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Event_FrameworkUpdated) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Event_FrameworkUpdated{`,
		`Framework:` + strings.Replace(strings.Replace(this.Framework.String(), "Response_GetFrameworks_Framework", "Response_GetFrameworks_Framework", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Event_FrameworkRemoved) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Event_FrameworkRemoved{`,
		`FrameworkInfo:` + strings.Replace(strings.Replace(this.FrameworkInfo.String(), "FrameworkInfo", "mesos.FrameworkInfo", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Event_AgentAdded) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Event_AgentAdded{`,
		`Agent:` + strings.Replace(strings.Replace(this.Agent.String(), "Response_GetAgents_Agent", "Response_GetAgents_Agent", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Event_AgentRemoved) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Event_AgentRemoved{`,
		`AgentID:` + strings.Replace(strings.Replace(this.AgentID.String(), "AgentID", "mesos.AgentID", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringMaster(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Call) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Call: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Call: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (Call_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetMetrics", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetMetrics == nil {
				m.GetMetrics = &Call_GetMetrics{}
			}
			if err := m.GetMetrics.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SetLoggingLevel", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SetLoggingLevel == nil {
				m.SetLoggingLevel = &Call_SetLoggingLevel{}
			}
			if err := m.SetLoggingLevel.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ListFiles", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ListFiles == nil {
				m.ListFiles = &Call_ListFiles{}
			}
			if err := m.ListFiles.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadFile", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReadFile == nil {
				m.ReadFile = &Call_ReadFile{}
			}
			if err := m.ReadFile.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpdateWeights", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UpdateWeights == nil {
				m.UpdateWeights = &Call_UpdateWeights{}
			}
			if err := m.UpdateWeights.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReserveResources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReserveResources == nil {
				m.ReserveResources = &Call_ReserveResources{}
			}
			if err := m.ReserveResources.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UnreserveResources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UnreserveResources == nil {
				m.UnreserveResources = &Call_UnreserveResources{}
			}
			if err := m.UnreserveResources.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreateVolumes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreateVolumes == nil {
				m.CreateVolumes = &Call_CreateVolumes{}
			}
			if err := m.CreateVolumes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestroyVolumes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DestroyVolumes == nil {
				m.DestroyVolumes = &Call_DestroyVolumes{}
			}
			if err := m.DestroyVolumes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpdateMaintenanceSchedule", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UpdateMaintenanceSchedule == nil {
				m.UpdateMaintenanceSchedule = &Call_UpdateMaintenanceSchedule{}
			}
			if err := m.UpdateMaintenanceSchedule.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartMaintenance", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartMaintenance == nil {
				m.StartMaintenance = &Call_StartMaintenance{}
			}
			if err := m.StartMaintenance.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StopMaintenance", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StopMaintenance == nil {
				m.StopMaintenance = &Call_StopMaintenance{}
			}
			if err := m.StopMaintenance.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SetQuota", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SetQuota == nil {
				m.SetQuota = &Call_SetQuota{}
			}
			if err := m.SetQuota.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RemoveQuota", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RemoveQuota == nil {
				m.RemoveQuota = &Call_RemoveQuota{}
			}
			if err := m.RemoveQuota.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Teardown", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Teardown == nil {
				m.Teardown = &Call_Teardown{}
			}
			if err := m.Teardown.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MarkAgentGone", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MarkAgentGone == nil {
				m.MarkAgentGone = &Call_MarkAgentGone{}
			}
			if err := m.MarkAgentGone.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_GetMetrics) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetMetrics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetMetrics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Timeout == nil {
				m.Timeout = &mesos.DurationInfo{}
			}
			if err := m.Timeout.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_SetLoggingLevel) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SetLoggingLevel: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SetLoggingLevel: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Level", wireType)
			}
			m.Level = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Level |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Duration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Duration.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("level")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("duration")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_ListFiles) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListFiles: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListFiles: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("path")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_ReadFile) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReadFile: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReadFile: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Offset", wireType)
			}
			m.Offset = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Offset |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Length", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Length = &v
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("path")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("offset")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_UpdateWeights) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateWeights: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateWeights: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WeightInfos", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WeightInfos = append(m.WeightInfos, mesos.WeightInfo{})
			if err := m.WeightInfos[len(m.WeightInfos)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_ReserveResources) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReserveResources: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReserveResources: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AgentID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.AgentID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Resources = append(m.Resources, mesos.Resource{})
			if err := m.Resources[len(m.Resources)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("agent_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_UnreserveResources) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UnreserveResources: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UnreserveResources: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AgentID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.AgentID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Resources = append(m.Resources, mesos.Resource{})
			if err := m.Resources[len(m.Resources)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("agent_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_CreateVolumes) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CreateVolumes: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CreateVolumes: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AgentID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.AgentID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Volumes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Volumes = append(m.Volumes, mesos.Resource{})
			if err := m.Volumes[len(m.Volumes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("agent_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_DestroyVolumes) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DestroyVolumes: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DestroyVolumes: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AgentID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.AgentID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Volumes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Volumes = append(m.Volumes, mesos.Resource{})
			if err := m.Volumes[len(m.Volumes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("agent_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_UpdateMaintenanceSchedule) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateMaintenanceSchedule: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateMaintenanceSchedule: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Schedule", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Schedule.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("schedule")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_StartMaintenance) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StartMaintenance: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StartMaintenance: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Machines", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Machines = append(m.Machines, mesos.MachineID{})
			if err := m.Machines[len(m.Machines)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_StopMaintenance) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StopMaintenance: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StopMaintenance: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Machines", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Machines = append(m.Machines, mesos.MachineID{})
			if err := m.Machines[len(m.Machines)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_SetQuota) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SetQuota: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SetQuota: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field QuotaRequest", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.QuotaRequest.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("quota_request")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_RemoveQuota) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RemoveQuota: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RemoveQuota: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Role", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Role = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("role")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_Teardown) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Teardown: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Teardown: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FrameworkID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.FrameworkID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("framework_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_MarkAgentGone) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MarkAgentGone: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MarkAgentGone: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AgentID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.AgentID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("agent_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Response: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Response: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (Response_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetHealth", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetHealth == nil {
				m.GetHealth = &Response_GetHealth{}
			}
			if err := m.GetHealth.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetFlags", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetFlags == nil {
				m.GetFlags = &Response_GetFlags{}
			}
			if err := m.GetFlags.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetVersion", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetVersion == nil {
				m.GetVersion = &Response_GetVersion{}
			}
			if err := m.GetVersion.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetMetrics", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetMetrics == nil {
				m.GetMetrics = &Response_GetMetrics{}
			}
			if err := m.GetMetrics.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetLoggingLevel", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetLoggingLevel == nil {
				m.GetLoggingLevel = &Response_GetLoggingLevel{}
			}
			if err := m.GetLoggingLevel.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ListFiles", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ListFiles == nil {
				m.ListFiles = &Response_ListFiles{}
			}
			if err := m.ListFiles.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadFile", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReadFile == nil {
				m.ReadFile = &Response_ReadFile{}
			}
			if err := m.ReadFile.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetState", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetState == nil {
				m.GetState = &Response_GetState{}
			}
			if err := m.GetState.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetAgents", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetAgents == nil {
				m.GetAgents = &Response_GetAgents{}
			}
			if err := m.GetAgents.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetFrameworks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetFrameworks == nil {
				m.GetFrameworks = &Response_GetFrameworks{}
			}
			if err := m.GetFrameworks.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetExecutors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetExecutors == nil {
				m.GetExecutors = &Response_GetExecutors{}
			}
			if err := m.GetExecutors.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetTasks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetTasks == nil {
				m.GetTasks = &Response_GetTasks{}
			}
			if err := m.GetTasks.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetRoles", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetRoles == nil {
				m.GetRoles = &Response_GetRoles{}
			}
			if err := m.GetRoles.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetWeights", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetWeights == nil {
				m.GetWeights = &Response_GetWeights{}
			}
			if err := m.GetWeights.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetMaster", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetMaster == nil {
				m.GetMaster = &Response_GetMaster{}
			}
			if err := m.GetMaster.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetMaintenanceStatus", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetMaintenanceStatus == nil {
				m.GetMaintenanceStatus = &Response_GetMaintenanceStatus{}
			}
			if err := m.GetMaintenanceStatus.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetMaintenanceSchedule", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetMaintenanceSchedule == nil {
				m.GetMaintenanceSchedule = &Response_GetMaintenanceSchedule{}
			}
			if err := m.GetMaintenanceSchedule.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 19:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetQuota", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetQuota == nil {
				m.GetQuota = &Response_GetQuota{}
			}
			if err := m.GetQuota.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_GetHealth) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetHealth: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetHealth: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Healthy", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Healthy = bool(v != 0)
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("healthy")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_GetFlags) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetFlags: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetFlags: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Flags", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Flags = append(m.Flags, mesos.Flag{})
			if err := m.Flags[len(m.Flags)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_GetVersion) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetVersion: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetVersion: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VersionInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.VersionInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("version_info")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_GetMetrics) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetMetrics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetMetrics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metrics", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Metrics = append(m.Metrics, mesos.Metric{})
			if err := m.Metrics[len(m.Metrics)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_GetLoggingLevel) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetLoggingLevel: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetLoggingLevel: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Level", wireType)
			}
			m.Level = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Level |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("level")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_ListFiles) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListFiles: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListFiles: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FileInfos", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FileInfos = append(m.FileInfos, mesos.FileInfo{})
			if err := m.FileInfos[len(m.FileInfos)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_ReadFile) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReadFile: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReadFile: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Size", wireType)
			}
			m.Size = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Size |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("size")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("data")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_GetState) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetState: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetState: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetTasks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetTasks == nil {
				m.GetTasks = &Response_GetTasks{}
			}
			if err := m.GetTasks.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetExecutors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetExecutors == nil {
				m.GetExecutors = &Response_GetExecutors{}
			}
			if err := m.GetExecutors.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetFrameworks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetFrameworks == nil {
				m.GetFrameworks = &Response_GetFrameworks{}
			}
			if err := m.GetFrameworks.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetAgents", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetAgents == nil {
				m.GetAgents = &Response_GetAgents{}
			}
			if err := m.GetAgents.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_GetAgents) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetAgents: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetAgents: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Agents", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Agents = append(m.Agents, Response_GetAgents_Agent{})
			if err := m.Agents[len(m.Agents)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RecoveredAgents", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RecoveredAgents = append(m.RecoveredAgents, mesos.AgentInfo{})
			if err := m.RecoveredAgents[len(m.RecoveredAgents)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_GetAgents_Agent) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Agent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Agent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AgentInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.AgentInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Active", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Active = bool(v != 0)
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000004)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.PID = &s
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegisteredTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegisteredTime == nil {
				m.RegisteredTime = &mesos.TimeInfo{}
			}
			if err := m.RegisteredTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReregisteredTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReregisteredTime == nil {
				m.ReregisteredTime = &mesos.TimeInfo{}
			}
			if err := m.ReregisteredTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalResources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TotalResources = append(m.TotalResources, mesos.Resource{})
			if err := m.TotalResources[len(m.TotalResources)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllocatedResources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AllocatedResources = append(m.AllocatedResources, mesos.Resource{})
			if err := m.AllocatedResources[len(m.AllocatedResources)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OfferedResources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OfferedResources = append(m.OfferedResources, mesos.Resource{})
			if err := m.OfferedResources[len(m.OfferedResources)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Capabilities", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Capabilities = append(m.Capabilities, mesos.AgentInfo_Capability{})
			if err := m.Capabilities[len(m.Capabilities)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceProviders", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResourceProviders = append(m.ResourceProviders, Response_GetAgents_Agent_ResourceProvider{})
			if err := m.ResourceProviders[len(m.ResourceProviders)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("agent_info")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("active")
	}
	if hasFields[0]&uint64(0x00000004) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("version")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_GetAgents_Agent_ResourceProvider) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResourceProvider: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResourceProvider: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceProviderInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResourceProviderInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("resource_provider_info")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_GetFrameworks) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetFrameworks: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetFrameworks: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Frameworks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Frameworks = append(m.Frameworks, Response_GetFrameworks_Framework{})
			if err := m.Frameworks[len(m.Frameworks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompletedFrameworks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CompletedFrameworks = append(m.CompletedFrameworks, Response_GetFrameworks_Framework{})
			if err := m.CompletedFrameworks[len(m.CompletedFrameworks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RecoveredFrameworks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RecoveredFrameworks = append(m.RecoveredFrameworks, mesos.FrameworkInfo{})
			if err := m.RecoveredFrameworks[len(m.RecoveredFrameworks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_GetFrameworks_Framework) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Framework: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Framework: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FrameworkInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.FrameworkInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Active", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Active = bool(v != 0)
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Connected", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Connected = bool(v != 0)
			hasFields[0] |= uint64(0x00000004)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegisteredTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegisteredTime == nil {
				m.RegisteredTime = &mesos.TimeInfo{}
			}
			if err := m.RegisteredTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReregisteredTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReregisteredTime == nil {
				m.ReregisteredTime = &mesos.TimeInfo{}
			}
			if err := m.ReregisteredTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UnregisteredTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UnregisteredTime == nil {
				m.UnregisteredTime = &mesos.TimeInfo{}
			}
			if err := m.UnregisteredTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Offers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Offers = append(m.Offers, mesos.Offer{})
			if err := m.Offers[len(m.Offers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InverseOffers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.InverseOffers = append(m.InverseOffers, mesos.InverseOffer{})
			if err := m.InverseOffers[len(m.InverseOffers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllocatedResources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AllocatedResources = append(m.AllocatedResources, mesos.Resource{})
			if err := m.AllocatedResources[len(m.AllocatedResources)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OfferedResources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OfferedResources = append(m.OfferedResources, mesos.Resource{})
			if err := m.OfferedResources[len(m.OfferedResources)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Recovered", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Recovered = bool(v != 0)
			hasFields[0] |= uint64(0x00000008)
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("framework_info")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("active")
	}
	if hasFields[0]&uint64(0x00000004) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("connected")
	}
	if hasFields[0]&uint64(0x00000008) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("recovered")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_GetExecutors) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetExecutors: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetExecutors: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Executors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Executors = append(m.Executors, Response_GetExecutors_Executor{})
			if err := m.Executors[len(m.Executors)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrphanExecutors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrphanExecutors = append(m.OrphanExecutors, Response_GetExecutors_Executor{})
			if err := m.OrphanExecutors[len(m.OrphanExecutors)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_GetExecutors_Executor) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Executor: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Executor: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecutorInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ExecutorInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AgentID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.AgentID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("executor_info")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("agent_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_GetTasks) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetTasks: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetTasks: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PendingTasks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PendingTasks = append(m.PendingTasks, mesos.Task{})
			if err := m.PendingTasks[len(m.PendingTasks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tasks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tasks = append(m.Tasks, mesos.Task{})
			if err := m.Tasks[len(m.Tasks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompletedTasks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CompletedTasks = append(m.CompletedTasks, mesos.Task{})
			if err := m.CompletedTasks[len(m.CompletedTasks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrphanTasks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrphanTasks = append(m.OrphanTasks, mesos.Task{})
			if err := m.OrphanTasks[len(m.OrphanTasks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UnreachableTasks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UnreachableTasks = append(m.UnreachableTasks, mesos.Task{})
			if err := m.UnreachableTasks[len(m.UnreachableTasks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_GetRoles) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetRoles: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetRoles: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Roles", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Roles = append(m.Roles, mesos.Role{})
			if err := m.Roles[len(m.Roles)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_GetWeights) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetWeights: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetWeights: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WeightInfos", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WeightInfos = append(m.WeightInfos, mesos.WeightInfo{})
			if err := m.WeightInfos[len(m.WeightInfos)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_GetMaster) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetMaster: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetMaster: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MasterInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MasterInfo == nil {
				m.MasterInfo = &mesos.MasterInfo{}
			}
			if err := m.MasterInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTime", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(dAtA[iNdEx-8])
			v |= uint64(dAtA[iNdEx-7]) << 8
			v |= uint64(dAtA[iNdEx-6]) << 16
			v |= uint64(dAtA[iNdEx-5]) << 24
			v |= uint64(dAtA[iNdEx-4]) << 32
			v |= uint64(dAtA[iNdEx-3]) << 40
			v |= uint64(dAtA[iNdEx-2]) << 48
			v |= uint64(dAtA[iNdEx-1]) << 56
			v2 := float64(math.Float64frombits(v))
			m.StartTime = &v2
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field ElectedTime", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(dAtA[iNdEx-8])
			v |= uint64(dAtA[iNdEx-7]) << 8
			v |= uint64(dAtA[iNdEx-6]) << 16
			v |= uint64(dAtA[iNdEx-5]) << 24
			v |= uint64(dAtA[iNdEx-4]) << 32
			v |= uint64(dAtA[iNdEx-3]) << 40
			v |= uint64(dAtA[iNdEx-2]) << 48
			v |= uint64(dAtA[iNdEx-1]) << 56
			v2 := float64(math.Float64frombits(v))
			m.ElectedTime = &v2
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_GetMaintenanceStatus) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetMaintenanceStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetMaintenanceStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("status")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_GetMaintenanceSchedule) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetMaintenanceSchedule: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetMaintenanceSchedule: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Schedule", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Schedule.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("schedule")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_GetQuota) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetQuota: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetQuota: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("status")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Event) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Event: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Event: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (Event_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subscribed", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Subscribed == nil {
				m.Subscribed = &Event_Subscribed{}
			}
			if err := m.Subscribed.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskAdded", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TaskAdded == nil {
				m.TaskAdded = &Event_TaskAdded{}
			}
			if err := m.TaskAdded.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskUpdated", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TaskUpdated == nil {
				m.TaskUpdated = &Event_TaskUpdated{}
			}
			if err := m.TaskUpdated.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AgentAdded", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AgentAdded == nil {
				m.AgentAdded = &Event_AgentAdded{}
			}
			if err := m.AgentAdded.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AgentRemoved", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AgentRemoved == nil {
				m.AgentRemoved = &Event_AgentRemoved{}
			}
			if err := m.AgentRemoved.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FrameworkAdded", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FrameworkAdded == nil {
				m.FrameworkAdded = &Event_FrameworkAdded{}
			}
			if err := m.FrameworkAdded.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FrameworkUpdated", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FrameworkUpdated == nil {
				m.FrameworkUpdated = &Event_FrameworkUpdated{}
			}
			if err := m.FrameworkUpdated.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FrameworkRemoved", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FrameworkRemoved == nil {
				m.FrameworkRemoved = &Event_FrameworkRemoved{}
			}
			if err := m.FrameworkRemoved.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Event_Subscribed) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Subscribed: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Subscribed: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetState", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetState == nil {
				m.GetState = &Response_GetState{}
			}
			if err := m.GetState.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeartbeatIntervalSeconds", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(dAtA[iNdEx-8])
			v |= uint64(dAtA[iNdEx-7]) << 8
			v |= uint64(dAtA[iNdEx-6]) << 16
			v |= uint64(dAtA[iNdEx-5]) << 24
			v |= uint64(dAtA[iNdEx-4]) << 32
			v |= uint64(dAtA[iNdEx-3]) << 40
			v |= uint64(dAtA[iNdEx-2]) << 48
			v |= uint64(dAtA[iNdEx-1]) << 56
			v2 := float64(math.Float64frombits(v))
			m.HeartbeatIntervalSeconds = &v2
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Event_TaskAdded) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TaskAdded: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TaskAdded: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Task", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Task.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("task")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Event_TaskUpdated) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TaskUpdated: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TaskUpdated: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FrameworkID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.FrameworkID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			var v mesos.TaskState
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (mesos.TaskState(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.State = &v
			hasFields[0] |= uint64(0x00000004)
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("framework_id")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("status")
	}
	if hasFields[0]&uint64(0x00000004) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("state")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Event_FrameworkAdded) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FrameworkAdded: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FrameworkAdded: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Framework", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Framework.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("framework")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Event_FrameworkUpdated) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FrameworkUpdated: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FrameworkUpdated: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Framework", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Framework.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("framework")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Event_FrameworkRemoved) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FrameworkRemoved: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FrameworkRemoved: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FrameworkInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.FrameworkInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("framework_info")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Event_AgentAdded) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AgentAdded: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AgentAdded: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Agent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Agent.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("agent")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Event_AgentRemoved) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AgentRemoved: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AgentRemoved: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AgentID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMaster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.AgentID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipMaster(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMaster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("agent_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipMaster(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowMaster
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMaster
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthMaster
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowMaster
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipMaster(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthMaster = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowMaster   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("master/master.proto", fileDescriptorMaster) }

var fileDescriptorMaster = []byte{
	// 3264 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x5a, 0x4d, 0x6c, 0x1b, 0xd7,
	0xb5, 0xf6, 0x50, 0xa4, 0x48, 0x1e, 0xfe, 0x0d, 0xaf, 0x14, 0x87, 0x1e, 0x3b, 0xb4, 0xe2, 0xf7,
	0x12, 0xfb, 0xbd, 0xc4, 0xd2, 0x8b, 0xf2, 0xf2, 0x83, 0xc4, 0xcf, 0x79, 0x94, 0x38, 0x96, 0x18,
	0x4b, 0xa2, 0x72, 0x87, 0x92, 0xdb, 0x6c, 0x88, 0x11, 0xe7, 0x8a, 0x22, 0x4c, 0x72, 0x98, 0x99,
	0xa1, 0x5c, 0x17, 0x2d, 0xd0, 0x22, 0x68, 0x90, 0x65, 0x17, 0xdd, 0x37, 0x40, 0x37, 0x5d, 0x77,
	0xd5, 0x65, 0xbb, 0x0b, 0xba, 0xca, 0xb2, 0x9b, 0x1a, 0xb5, 0x52, 0x14, 0x5d, 0x06, 0xe8, 0xa6,
	0x9b, 0x02, 0xc5, 0xfd, 0x9b, 0x1f, 0x72, 0x48, 0xcb, 0x76, 0x9a, 0x8d, 0x7d, 0xef, 0x99, 0xef,
	0x7c, 0xf7, 0xce, 0xfd, 0xf9, 0x78, 0xce, 0x19, 0xc1, 0xd2, 0xc0, 0x74, 0x3d, 0xe2, 0xac, 0xf1,
	0xff, 0x56, 0x47, 0x8e, 0xed, 0xd9, 0x28, 0x3f, 0x20, 0xae, 0xed, 0xae, 0x72, 0x9b, 0xf6, 0x3f,
	0xdd, 0x9e, 0x77, 0x32, 0x3e, 0x5a, 0xed, 0xd8, 0x83, 0x35, 0xf6, 0x80, 0xff, 0x7b, 0xb3, 0x6b,
	0xaf, 0x99, 0xa3, 0xde, 0xda, 0xe9, 0x1b, 0x6b, 0xfd, 0xde, 0x11, 0xb7, 0x71, 0x7f, 0xed, 0xf6,
	0xb9, 0x3c, 0xcc, 0x7e, 0xdf, 0xee, 0x98, 0x9e, 0xed, 0x04, 0x2d, 0xe1, 0xbf, 0x71, 0xbe, 0x11,
	0xcd, 0xde, 0xd0, 0x23, 0x43, 0x73, 0xd8, 0x21, 0xe1, 0xb6, 0xe0, 0x78, 0xfb, 0x5c, 0x1c, 0x9f,
	0x8c, 0x6d, 0xcf, 0xe4, 0xff, 0x0a, 0xbf, 0x9b, 0x21, 0xbf, 0xae, 0xdd, 0xb5, 0xd7, 0x98, 0xf9,
	0x68, 0x7c, 0xcc, 0x7a, 0xac, 0xc3, 0x5a, 0x1c, 0x7e, 0xed, 0xaf, 0x97, 0x20, 0xb9, 0x69, 0xf6,
	0xfb, 0xe8, 0x0d, 0x48, 0x7a, 0x0f, 0x47, 0xa4, 0xa2, 0xac, 0x28, 0x37, 0x8a, 0xeb, 0x2f, 0xae,
	0x86, 0x97, 0x70, 0x95, 0x22, 0x56, 0x5b, 0x0f, 0x47, 0x64, 0x23, 0xf9, 0xe5, 0xa3, 0xab, 0x17,
	0x30, 0x83, 0xa2, 0xdb, 0x90, 0xeb, 0x12, 0xaf, 0x3d, 0x20, 0x9e, 0xd3, 0xeb, 0xb8, 0x95, 0xc4,
	0x8a, 0x72, 0x23, 0xb7, 0xfe, 0x52, 0x8c, 0xe7, 0x16, 0xf1, 0x76, 0x39, 0x08, 0x43, 0xd7, 0x6f,
	0xa3, 0x3d, 0x28, 0xbb, 0xc4, 0x6b, 0xf7, 0xed, 0x6e, 0xb7, 0x37, 0xec, 0xb6, 0xfb, 0xe4, 0x94,
	0xf4, 0x2b, 0x0b, 0x8c, 0xe5, 0x5a, 0x0c, 0x8b, 0x41, 0xbc, 0x1d, 0x0e, 0xdd, 0xa1, 0x48, 0x5c,
	0x72, 0xa3, 0x06, 0xf4, 0x3e, 0x40, 0xbf, 0xe7, 0x7a, 0xed, 0xe3, 0x5e, 0x9f, 0xb8, 0x95, 0x24,
	0x23, 0xba, 0x12, 0x43, 0xb4, 0xd3, 0x73, 0xbd, 0x3b, 0x14, 0x83, 0xb3, 0x7d, 0xd9, 0x44, 0xef,
	0x42, 0xd6, 0x21, 0xa6, 0xc5, 0x9c, 0x2b, 0x29, 0xe6, 0x7b, 0x39, 0xc6, 0x17, 0x13, 0xd3, 0xa2,
	0x0e, 0x38, 0xe3, 0x88, 0x16, 0xda, 0x82, 0xe2, 0x78, 0x64, 0x99, 0x1e, 0x69, 0x3f, 0x20, 0xbd,
	0xee, 0x89, 0xe7, 0x56, 0x16, 0x99, 0xfb, 0x4a, 0x8c, 0xfb, 0x01, 0x03, 0xde, 0xe3, 0x38, 0x5c,
	0x18, 0x87, 0xbb, 0x68, 0x1f, 0xca, 0x0e, 0x71, 0x89, 0x73, 0x4a, 0xda, 0x0e, 0x71, 0xed, 0xb1,
	0xd3, 0x21, 0x6e, 0x25, 0xcd, 0xb8, 0xfe, 0x23, 0x76, 0x2a, 0x0c, 0x8b, 0x25, 0x14, 0xab, 0xce,
	0x84, 0x05, 0x1d, 0xc2, 0xd2, 0x78, 0x38, 0xcd, 0x99, 0x61, 0x9c, 0xaf, 0xc4, 0xcd, 0x6f, 0x38,
	0xc9, 0x81, 0xd1, 0x78, 0xca, 0x46, 0x5f, 0xb9, 0xe3, 0x10, 0xfa, 0xca, 0xa7, 0x76, 0x7f, 0x3c,
	0x20, 0x6e, 0x25, 0x3b, 0xf3, 0x95, 0x37, 0x19, 0xf0, 0x90, 0xe3, 0x70, 0xa1, 0x13, 0xee, 0xa2,
	0x0f, 0xa1, 0x64, 0x11, 0xd7, 0x73, 0xec, 0x87, 0x3e, 0x13, 0x30, 0xa6, 0x97, 0x63, 0x98, 0xea,
	0x1c, 0x29, 0xa9, 0x8a, 0x56, 0xa4, 0x8f, 0xfa, 0x70, 0x59, 0xec, 0x43, 0xe8, 0x36, 0xb5, 0xdd,
	0xce, 0x09, 0xb1, 0xc6, 0x7d, 0x52, 0xc9, 0x31, 0xde, 0xd7, 0x67, 0x6e, 0xca, 0x6e, 0xe0, 0x64,
	0x08, 0x1f, 0x7c, 0x69, 0x3c, 0xeb, 0x11, 0xdd, 0x2c, 0xd7, 0x33, 0x1d, 0x2f, 0x3c, 0x58, 0x25,
	0x3f, 0x73, 0xb3, 0x0c, 0x8a, 0x0d, 0xf1, 0x60, 0xd5, 0x9d, 0xb0, 0xa0, 0x5d, 0x50, 0x5d, 0xcf,
	0x1e, 0x45, 0x08, 0x0b, 0xb3, 0x6f, 0x83, 0x67, 0x8f, 0xc2, 0x7c, 0x25, 0x37, 0x6a, 0xa0, 0x07,
	0x9a, 0xde, 0x2e, 0xa6, 0x0d, 0x95, 0xe2, 0xcc, 0x03, 0x6d, 0x10, 0xef, 0x23, 0x0a, 0xc1, 0x19,
	0x57, 0xb4, 0x50, 0x0d, 0xf2, 0x0e, 0x19, 0xd8, 0xa7, 0x44, 0x38, 0x97, 0x98, 0x73, 0x35, 0xf6,
	0x08, 0x52, 0x18, 0xf7, 0xcf, 0x39, 0x41, 0x07, 0xbd, 0x03, 0x19, 0x8f, 0x98, 0x8e, 0x65, 0x3f,
	0x18, 0x56, 0xd4, 0x99, 0x63, 0xb7, 0x04, 0x04, 0xfb, 0x60, 0xb4, 0x0d, 0xa5, 0x81, 0xe9, 0xdc,
	0x6f, 0x9b, 0x5d, 0x32, 0xf4, 0xda, 0x5d, 0x7b, 0x48, 0x2a, 0xe5, 0x99, 0x47, 0x6b, 0xd7, 0x74,
	0xee, 0xd7, 0x28, 0x70, 0xcb, 0x1e, 0x12, 0x5c, 0x18, 0x84, 0xbb, 0xda, 0xfb, 0x00, 0x81, 0xee,
	0xa0, 0x9b, 0x90, 0xf6, 0x7a, 0x03, 0x62, 0x8f, 0x3d, 0xa6, 0x70, 0xb9, 0xf5, 0x25, 0xc1, 0x57,
	0x1f, 0x3b, 0xa6, 0xd7, 0xb3, 0x87, 0x8d, 0xe1, 0xb1, 0x8d, 0x25, 0x46, 0xb3, 0xa0, 0x34, 0x21,
	0x37, 0x48, 0x83, 0x14, 0x57, 0x28, 0x65, 0x25, 0x71, 0xa3, 0x20, 0x84, 0x90, 0x9b, 0xd0, 0x5b,
	0x90, 0xb1, 0x04, 0x4f, 0x25, 0xb1, 0x92, 0x98, 0x41, 0x2f, 0x7c, 0x7c, 0xa8, 0xf6, 0x0a, 0x64,
	0x7d, 0x2d, 0x42, 0x15, 0x48, 0x8e, 0x4c, 0xef, 0x84, 0xd1, 0x67, 0xa5, 0xce, 0x52, 0x8b, 0xf6,
	0x31, 0x64, 0xa4, 0xec, 0xcc, 0x46, 0xa1, 0x2b, 0xb0, 0x68, 0x1f, 0x1f, 0xbb, 0xc4, 0x63, 0x33,
	0x48, 0x8a, 0x67, 0xc2, 0x86, 0x2e, 0xc2, 0x62, 0x9f, 0x0c, 0xbb, 0xde, 0x09, 0x13, 0xd8, 0x24,
	0x16, 0x3d, 0xed, 0x2e, 0x14, 0x22, 0x9a, 0x84, 0xde, 0x83, 0x3c, 0x97, 0xb1, 0x76, 0x6f, 0x78,
	0x6c, 0xbb, 0x15, 0x65, 0x65, 0xe1, 0x46, 0x6e, 0xbd, 0x2c, 0x5e, 0x87, 0xa3, 0x42, 0x2f, 0x93,
	0x7b, 0xe0, 0x5b, 0x5c, 0xed, 0x53, 0x05, 0xd4, 0x49, 0x55, 0x42, 0xef, 0x41, 0x86, 0x6f, 0x66,
	0xcf, 0x62, 0xb3, 0xce, 0xad, 0x17, 0x05, 0x19, 0xdb, 0xab, 0x46, 0x7d, 0xa3, 0x44, 0x99, 0xce,
	0x1e, 0x5d, 0x4d, 0x0b, 0x03, 0x4e, 0x33, 0x87, 0x86, 0x85, 0xde, 0xa4, 0xa2, 0x2c, 0x55, 0x2b,
	0xc1, 0x66, 0x52, 0x12, 0xce, 0x72, 0x00, 0x31, 0x8f, 0x00, 0xa7, 0xfd, 0x4c, 0x01, 0x34, 0xad,
	0x63, 0xdf, 0xfd, 0x3c, 0x7e, 0x04, 0x85, 0x88, 0xf6, 0x3d, 0xd7, 0x0c, 0xd6, 0x20, 0x2d, 0x05,
	0x72, 0xee, 0xf8, 0x12, 0xa5, 0xfd, 0x18, 0x8a, 0x51, 0xbd, 0xfc, 0x6e, 0x87, 0xff, 0x18, 0x2e,
	0xcd, 0x94, 0x55, 0xf4, 0x7f, 0x90, 0xf1, 0x65, 0x99, 0xcf, 0x24, 0x50, 0x87, 0x20, 0x0e, 0x92,
	0x70, 0x79, 0x6d, 0xa4, 0x8b, 0x76, 0x07, 0xd4, 0x49, 0x39, 0x45, 0xeb, 0x90, 0x19, 0x98, 0x9d,
	0x93, 0xde, 0x90, 0xc8, 0x23, 0xab, 0x0a, 0xca, 0x5d, 0x6e, 0x6e, 0xd4, 0x25, 0x8f, 0xc4, 0x69,
	0x3a, 0x94, 0x26, 0x54, 0xf4, 0x99, 0x68, 0xf6, 0x21, 0x23, 0x45, 0x14, 0xd5, 0xa1, 0xc0, 0x34,
	0xb3, 0xed, 0x90, 0x4f, 0xc6, 0xc4, 0xf5, 0xc4, 0xeb, 0x5d, 0x12, 0x24, 0x3c, 0x50, 0xe3, 0x7a,
	0xc9, 0x01, 0x82, 0x2d, 0xff, 0x49, 0xc8, 0xa6, 0x5d, 0x87, 0x5c, 0x48, 0x59, 0xe9, 0x9d, 0x77,
	0x6c, 0xb1, 0x54, 0xfe, 0x9d, 0xa7, 0x16, 0xed, 0x10, 0x32, 0x52, 0x43, 0xd1, 0x87, 0x90, 0x3f,
	0x76, 0xcc, 0x01, 0x79, 0x60, 0x3b, 0xf7, 0x83, 0x2d, 0x46, 0x62, 0xe4, 0x3b, 0xf2, 0x51, 0xa3,
	0xbe, 0xb1, 0x24, 0xb6, 0x39, 0x17, 0x32, 0xe2, 0x9c, 0xef, 0xdc, 0xb0, 0xa8, 0x2a, 0x44, 0xb4,
	0xf5, 0x79, 0xce, 0xce, 0xb5, 0x4f, 0x53, 0x90, 0xa4, 0xb1, 0x23, 0xca, 0x41, 0xfa, 0x60, 0xef,
	0xee, 0x5e, 0xf3, 0xde, 0x9e, 0x7a, 0x01, 0x15, 0x01, 0xb6, 0xf4, 0x56, 0x7b, 0x5b, 0xaf, 0xed,
	0xb4, 0xb6, 0x55, 0x05, 0x15, 0x20, 0x4b, 0xfb, 0x77, 0x76, 0x6a, 0x5b, 0x86, 0x9a, 0x40, 0x25,
	0xc8, 0xd1, 0xee, 0xa1, 0x8e, 0x8d, 0x46, 0x73, 0x4f, 0x5d, 0x90, 0x86, 0x5d, 0xbd, 0x85, 0x1b,
	0x9b, 0x86, 0x9a, 0x44, 0x2f, 0x40, 0x99, 0x1a, 0x76, 0x9a, 0x5b, 0x5b, 0x8d, 0xbd, 0xad, 0xf6,
	0x8e, 0x7e, 0xa8, 0xef, 0xa8, 0x29, 0x6a, 0x36, 0xa6, 0xcc, 0x8b, 0x74, 0xb8, 0x9d, 0x86, 0xd1,
	0x6a, 0xdf, 0x69, 0xec, 0xe8, 0x86, 0x9a, 0xa6, 0xc3, 0x61, 0xbd, 0x56, 0x67, 0x7d, 0x35, 0x23,
	0x47, 0x37, 0x5a, 0xb5, 0x96, 0xae, 0x66, 0xe5, 0xe4, 0x6a, 0x5b, 0xfa, 0x5e, 0xcb, 0x50, 0x01,
	0x21, 0x28, 0xb2, 0xc9, 0xe1, 0xda, 0xae, 0x7e, 0xaf, 0x89, 0xef, 0x1a, 0x6a, 0x0e, 0x95, 0xa1,
	0x40, 0x6d, 0xfa, 0xf7, 0xf4, 0xcd, 0x83, 0x56, 0x13, 0x1b, 0x6a, 0x5e, 0xb2, 0xb4, 0x6a, 0xc6,
	0x5d, 0x43, 0x2d, 0xc8, 0x2e, 0x6e, 0xd2, 0x21, 0x8b, 0xf2, 0x0d, 0xee, 0xe9, 0x8d, 0xad, 0xed,
	0x96, 0xa1, 0x96, 0x28, 0xeb, 0xc1, 0x7e, 0xbd, 0xd6, 0xd2, 0x7d, 0x9b, 0x2a, 0x47, 0xde, 0xad,
	0x19, 0x2d, 0x1d, 0xab, 0x65, 0xca, 0x61, 0x1c, 0x6c, 0x18, 0x9b, 0xb8, 0xb1, 0xa1, 0xab, 0x88,
	0xbe, 0x1d, 0xd6, 0x0d, 0x1d, 0x1f, 0xea, 0x6d, 0xac, 0x1b, 0xcd, 0x03, 0xbc, 0xa9, 0x1b, 0xea,
	0x12, 0x7a, 0x11, 0x96, 0x0e, 0xf6, 0xa6, 0x1f, 0x2c, 0xd3, 0x21, 0x36, 0xb1, 0x4e, 0x87, 0x38,
	0x6c, 0xee, 0x1c, 0xec, 0xea, 0x86, 0xfa, 0x02, 0x5a, 0x82, 0x52, 0x5d, 0x37, 0x5a, 0xb8, 0xf9,
	0x7d, 0xdf, 0x78, 0x11, 0x69, 0x70, 0x91, 0x8f, 0xdb, 0xd8, 0x6b, 0xe9, 0x7b, 0xb5, 0xbd, 0x4d,
	0x9d, 0x2d, 0xc6, 0x81, 0xa1, 0xbe, 0x88, 0xae, 0x40, 0x65, 0xea, 0xd9, 0xe6, 0xb6, 0x5e, 0x3f,
	0xd8, 0xd1, 0xd5, 0x0a, 0xba, 0x0a, 0x97, 0xc5, 0x5b, 0xc4, 0x02, 0x2e, 0xb1, 0x1d, 0x69, 0xd5,
	0x70, 0x84, 0x40, 0xd5, 0xd0, 0x32, 0xa8, 0x46, 0xab, 0xb9, 0x1f, 0xb1, 0x5e, 0x96, 0x6b, 0xf6,
	0xd1, 0x41, 0xb3, 0x55, 0x53, 0xaf, 0xb0, 0xd7, 0xf7, 0xbb, 0x2f, 0x21, 0x15, 0xf2, 0x58, 0xdf,
	0x6d, 0x1e, 0xea, 0xc2, 0x52, 0x45, 0x79, 0xc8, 0xb4, 0xf4, 0x1a, 0xae, 0xd3, 0x43, 0x75, 0x95,
	0xbe, 0xda, 0x6e, 0x0d, 0xdf, 0xe5, 0x1b, 0xd7, 0xde, 0x6a, 0xee, 0xe9, 0xea, 0x8a, 0x96, 0xfc,
	0xfc, 0x57, 0x55, 0xe5, 0xda, 0x9f, 0xfe, 0x8b, 0xfe, 0x8a, 0xba, 0x23, 0x7b, 0xe8, 0x12, 0xf4,
	0x56, 0x24, 0xd9, 0x99, 0x08, 0x4d, 0x24, 0x6a, 0x3a, 0xe1, 0xf9, 0x00, 0x68, 0xfa, 0xd2, 0x3e,
	0x21, 0x66, 0xdf, 0x3b, 0x11, 0xf9, 0xce, 0xca, 0x0c, 0xe7, 0x2d, 0xe2, 0x6d, 0x33, 0x1c, 0xce,
	0x76, 0x65, 0x13, 0xdd, 0x02, 0xda, 0x69, 0x1f, 0xf7, 0xcd, 0xae, 0x2b, 0x32, 0x9d, 0xab, 0xb3,
	0xfd, 0xef, 0x50, 0x18, 0xce, 0x74, 0x45, 0x0b, 0x6d, 0xf0, 0x7c, 0xeb, 0x94, 0x38, 0x2e, 0x0d,
	0x34, 0x92, 0x71, 0x81, 0x72, 0xd8, 0xff, 0x90, 0x03, 0x59, 0xce, 0x25, 0xda, 0x92, 0x43, 0xe6,
	0x6c, 0xa9, 0x27, 0x71, 0xc4, 0xe5, 0x6d, 0x18, 0xca, 0xdd, 0xa9, 0xbc, 0x8d, 0xe7, 0x3c, 0xaf,
	0xce, 0x66, 0x8a, 0xe6, 0x6e, 0xdd, 0x89, 0xe8, 0xea, 0x83, 0x48, 0xee, 0x96, 0x9e, 0xbb, 0xb4,
	0xb1, 0xf9, 0xdb, 0xad, 0x70, 0xfe, 0x96, 0x99, 0xbb, 0xb4, 0x31, 0x39, 0x9c, 0xd8, 0x18, 0xd7,
	0x33, 0x3d, 0x22, 0x72, 0x99, 0x39, 0x1b, 0x63, 0x50, 0x18, 0xdb, 0x18, 0xd6, 0x92, 0xe7, 0x82,
	0x09, 0x9e, 0x4c, 0x60, 0xe6, 0x9c, 0x0b, 0xa6, 0x90, 0x2e, 0x3b, 0x17, 0xbc, 0x89, 0xee, 0x42,
	0x91, 0x9d, 0x0b, 0x29, 0xc1, 0xae, 0xc8, 0x56, 0xfe, 0x73, 0xce, 0xe1, 0xf0, 0xb1, 0xb8, 0xd0,
	0x0d, 0x77, 0xd1, 0x36, 0x50, 0x43, 0x9b, 0xfc, 0x80, 0x74, 0xc6, 0x9e, 0xed, 0xb8, 0xf1, 0x59,
	0x49, 0x98, 0x4b, 0x97, 0x50, 0x9c, 0xef, 0x86, 0x7a, 0x72, 0x55, 0x3c, 0xd3, 0xbd, 0xef, 0x8a,
	0x54, 0x64, 0xce, 0xaa, 0xb4, 0x28, 0x8c, 0xad, 0x0a, 0x6b, 0x49, 0x6f, 0xfa, 0x43, 0xe5, 0x8a,
	0x04, 0x64, 0x8e, 0x37, 0xa6, 0x30, 0xe6, 0xcd, 0x5a, 0xf2, 0xa0, 0xca, 0x94, 0xba, 0xf4, 0xa4,
	0x83, 0x2a, 0x73, 0x6a, 0xba, 0x13, 0x32, 0x96, 0x15, 0xfb, 0xc2, 0xd1, 0x22, 0x0f, 0x99, 0xb3,
	0x2f, 0xbb, 0xcc, 0xc4, 0xf6, 0x85, 0x37, 0x91, 0x09, 0x17, 0x39, 0x41, 0x28, 0x9f, 0xf4, 0x4c,
	0x6f, 0xec, 0x8a, 0xa4, 0xe4, 0xb5, 0x79, 0x64, 0x41, 0xdc, 0xc3, 0x5c, 0xf0, 0x72, 0x37, 0xc6,
	0x8a, 0xba, 0x50, 0x99, 0x1a, 0x42, 0xc6, 0x46, 0x88, 0x0d, 0x72, 0xf3, 0x7c, 0x83, 0xc8, 0x9c,
	0xf5, 0x62, 0x37, 0xd6, 0x2e, 0xb7, 0x83, 0xa7, 0x74, 0x4b, 0x4f, 0xda, 0x0e, 0x91, 0x13, 0x76,
	0x45, 0x4b, 0x7b, 0x0d, 0xb2, 0xbe, 0xa2, 0xa1, 0x2a, 0xa4, 0xb9, 0x06, 0x3e, 0x64, 0xc1, 0x40,
	0x46, 0x06, 0x7f, 0xc2, 0xa8, 0xbd, 0x09, 0x19, 0x29, 0x5f, 0xe8, 0x3a, 0xa4, 0xb8, 0xdc, 0xf1,
	0x70, 0x2a, 0x27, 0xe3, 0x91, 0xbe, 0xd9, 0x95, 0x39, 0x14, 0x7b, 0xae, 0x35, 0x58, 0xbe, 0x26,
	0x75, 0xea, 0x7d, 0xc8, 0x0b, 0x9d, 0x63, 0x79, 0xc8, 0x44, 0x34, 0x23, 0x50, 0xe1, 0x3c, 0xe4,
	0x34, 0x30, 0x4d, 0xa7, 0x7e, 0x52, 0xee, 0xf8, 0x1c, 0x0a, 0x32, 0xa4, 0x63, 0x56, 0x39, 0x79,
	0x81, 0xd1, 0x6e, 0x42, 0x69, 0xeb, 0xfc, 0xa9, 0x9f, 0x56, 0x0b, 0xe7, 0x70, 0xff, 0x0b, 0x40,
	0xf5, 0x27, 0x92, 0x3a, 0xc9, 0x48, 0x99, 0x22, 0x42, 0x13, 0xce, 0x1e, 0x8b, 0xbe, 0xab, 0xbd,
	0x1b, 0xcd, 0xef, 0xdc, 0xde, 0x0f, 0x79, 0xac, 0x27, 0x73, 0x38, 0x66, 0x41, 0x08, 0x92, 0x96,
	0xe9, 0x99, 0x2c, 0xbb, 0xcb, 0x63, 0xd6, 0xd6, 0xbe, 0x48, 0xb0, 0x95, 0xe6, 0x2a, 0x14, 0xb9,
	0xad, 0xca, 0xd3, 0xde, 0xd6, 0x29, 0xd5, 0x48, 0x3c, 0xab, 0x6a, 0x4c, 0x8b, 0xd9, 0xc2, 0xb3,
	0x8b, 0x59, 0x54, 0x5a, 0x93, 0x4f, 0x2d, 0xad, 0xda, 0x2f, 0xd2, 0xec, 0xe4, 0x0a, 0xa1, 0xad,
	0xc3, 0xa2, 0xa0, 0xe2, 0x9b, 0xf3, 0xea, 0x93, 0xa8, 0x78, 0x7c, 0x2b, 0x93, 0x69, 0xee, 0x8b,
	0x6a, 0xa0, 0x3a, 0xa4, 0x63, 0x9f, 0x12, 0x87, 0x58, 0x72, 0x6a, 0x89, 0x48, 0xb6, 0xc0, 0x83,
	0xe0, 0x60, 0xb7, 0x4b, 0x3e, 0x5e, 0x4c, 0xeb, 0x9f, 0x29, 0x48, 0xb1, 0x26, 0x7a, 0x0b, 0x40,
	0x84, 0xd6, 0xc1, 0x39, 0x9f, 0x45, 0x93, 0x35, 0xa5, 0x81, 0xa6, 0xfb, 0x66, 0xc7, 0xeb, 0x9d,
	0x12, 0x76, 0x20, 0x32, 0xfe, 0x0c, 0x99, 0x8d, 0xde, 0x50, 0x19, 0x26, 0x2c, 0x84, 0xb2, 0x06,
	0x69, 0x44, 0x97, 0x60, 0x61, 0xd4, 0xb3, 0xd8, 0x7a, 0x66, 0x37, 0xd2, 0x67, 0x8f, 0xae, 0x2e,
	0xec, 0x37, 0xea, 0x98, 0xda, 0xd0, 0xbb, 0x50, 0x72, 0x48, 0xb7, 0x47, 0xd7, 0x83, 0x58, 0x6d,
	0xaf, 0x37, 0x90, 0xe5, 0x50, 0x79, 0x90, 0x5b, 0xbd, 0x01, 0x3b, 0xb8, 0xb8, 0x18, 0xe0, 0xa8,
	0x0d, 0xdd, 0x82, 0xb2, 0x43, 0x26, 0x7d, 0x17, 0xe3, 0x7d, 0xd5, 0x30, 0x92, 0x79, 0xdf, 0x86,
	0x92, 0x67, 0x7b, 0x66, 0x3f, 0x52, 0xfb, 0x9c, 0x93, 0x6a, 0x16, 0x19, 0x3a, 0xc8, 0xef, 0xef,
	0xc0, 0x92, 0xa8, 0xc3, 0x13, 0x2b, 0x52, 0xeb, 0x9c, 0xc3, 0x81, 0x7c, 0x8f, 0x80, 0x67, 0x03,
	0xca, 0xf6, 0xf1, 0x31, 0x7b, 0x81, 0x80, 0x25, 0x3b, 0x8f, 0x45, 0x15, 0xf8, 0x80, 0x43, 0x87,
	0x7c, 0xc7, 0x1c, 0x99, 0x47, 0xbd, 0x7e, 0xcf, 0xeb, 0xb1, 0x9a, 0xe6, 0x42, 0x28, 0xc9, 0xf5,
	0x77, 0x75, 0x75, 0x53, 0x82, 0x1e, 0xca, 0x3c, 0x30, 0xec, 0x86, 0xfa, 0x80, 0xe4, 0x14, 0xda,
	0x23, 0xc7, 0x3e, 0xed, 0x59, 0xc4, 0xa1, 0xa1, 0x01, 0x25, 0x7b, 0xe7, 0x7c, 0x27, 0xd7, 0x9f,
	0xeb, 0xbe, 0xf0, 0x17, 0x03, 0x95, 0x9d, 0x09, 0xbb, 0xab, 0xdd, 0x67, 0xc5, 0x9b, 0x88, 0x11,
	0xdd, 0x83, 0x8b, 0x53, 0x33, 0x08, 0x1f, 0xd4, 0xcb, 0x13, 0x2b, 0x22, 0x1d, 0x43, 0x67, 0x76,
	0xd9, 0x89, 0x79, 0xa6, 0x7d, 0x96, 0x86, 0x42, 0xe4, 0xe2, 0xa3, 0x16, 0x40, 0x48, 0x32, 0xf8,
	0xf5, 0x5c, 0x3d, 0x8f, 0x64, 0x04, 0xb9, 0xad, 0x18, 0x31, 0xc4, 0x83, 0xba, 0xb0, 0xdc, 0xb1,
	0x07, 0xa3, 0x3e, 0xa1, 0xa7, 0x22, 0xc4, 0x9f, 0x78, 0x0e, 0xfe, 0x25, 0x9f, 0x31, 0x34, 0xfd,
	0x26, 0x2c, 0x07, 0x9a, 0x10, 0xd1, 0x3e, 0x3a, 0xd0, 0xf2, 0x54, 0x1a, 0x4e, 0x17, 0x68, 0x91,
	0xd2, 0x55, 0x14, 0xbc, 0xe4, 0x7b, 0x06, 0x84, 0xda, 0x5f, 0x92, 0x90, 0xf5, 0xbb, 0xa8, 0x06,
	0xc5, 0x50, 0x76, 0x1f, 0x6c, 0x40, 0x3c, 0x31, 0x9f, 0x67, 0xe1, 0x38, 0x6c, 0x7c, 0x82, 0x62,
	0x5c, 0x83, 0x6c, 0xc7, 0x1e, 0x0e, 0x49, 0xc7, 0x23, 0x16, 0xd3, 0x0c, 0x09, 0x08, 0xcc, 0x71,
	0xd2, 0x90, 0x7c, 0x0e, 0x69, 0x48, 0x9d, 0x57, 0x1a, 0x6e, 0x41, 0x79, 0x3c, 0x3c, 0xaf, 0xb0,
	0x84, 0x91, 0xcc, 0xfb, 0xbf, 0x59, 0x61, 0x94, 0xde, 0x1c, 0xae, 0x27, 0x79, 0xe1, 0xd2, 0xa4,
	0xc6, 0x50, 0x99, 0x94, 0x38, 0x2e, 0xfa, 0x7f, 0x28, 0xf6, 0x86, 0x54, 0x24, 0x49, 0x5b, 0xf8,
	0x70, 0xfd, 0x90, 0xe5, 0xdc, 0x06, 0x7f, 0x18, 0x76, 0x2d, 0xf4, 0x42, 0xb6, 0x99, 0x32, 0x94,
	0xfd, 0x56, 0x64, 0x08, 0x9e, 0x4e, 0x86, 0xae, 0xd1, 0x9c, 0x48, 0x9c, 0xac, 0x4a, 0x2e, 0xbc,
	0xa7, 0xbe, 0x59, 0xfb, 0x43, 0x02, 0xf2, 0xe1, 0x1f, 0x73, 0xb4, 0x0f, 0xd9, 0x20, 0x08, 0xe0,
	0xd7, 0xf0, 0xf5, 0x73, 0x04, 0x01, 0xab, 0xb2, 0x25, 0x87, 0xf0, 0x49, 0x50, 0x1b, 0x54, 0xdb,
	0x19, 0x9d, 0x98, 0xc3, 0x48, 0x74, 0xf1, 0xf4, 0xc4, 0xf2, 0xba, 0x94, 0x38, 0x9b, 0x8f, 0xd0,
	0x3e, 0x53, 0x20, 0x23, 0x7b, 0xe8, 0x36, 0x14, 0xe4, 0x30, 0xe1, 0x8b, 0x22, 0x77, 0x50, 0xe2,
	0x42, 0xf7, 0x24, 0x4f, 0x42, 0xb6, 0x48, 0xa9, 0x2b, 0xf1, 0x74, 0xa5, 0x2e, 0xed, 0x97, 0x3c,
	0x1e, 0xe3, 0x11, 0xd5, 0xdb, 0x50, 0x18, 0x91, 0xa1, 0x45, 0x53, 0x64, 0x19, 0x93, 0x85, 0x23,
	0x60, 0x0a, 0x92, 0x13, 0x10, 0x38, 0xee, 0x77, 0x1d, 0x52, 0x1c, 0x9f, 0x98, 0x85, 0xe7, 0xcf,
	0xd1, 0x7b, 0x50, 0x0a, 0xb4, 0x8d, 0xbb, 0x2c, 0xcc, 0x72, 0x29, 0xfa, 0x48, 0x39, 0xb9, 0xbc,
	0xd8, 0x13, 0xee, 0x98, 0x9c, 0x76, 0x94, 0xcb, 0x9d, 0xe3, 0x40, 0xee, 0x77, 0x9b, 0x5f, 0x45,
	0xb3, 0x73, 0x62, 0x1e, 0xf5, 0x89, 0x70, 0x4e, 0xcd, 0x1a, 0x55, 0x0d, 0x61, 0x99, 0xbf, 0x48,
	0x0d, 0x78, 0x8a, 0x77, 0x1d, 0x52, 0x3c, 0x39, 0x8c, 0x2e, 0x0c, 0x7d, 0x28, 0x5f, 0x94, 0x3d,
	0xd7, 0xb6, 0x59, 0x3c, 0xff, 0x6d, 0x7c, 0xa1, 0xf8, 0xa9, 0xc2, 0xa2, 0x41, 0x91, 0xde, 0xad,
	0x43, 0x8e, 0x9f, 0x3c, 0x79, 0x50, 0x94, 0x10, 0x11, 0xc7, 0x30, 0x4d, 0x81, 0x81, 0xdf, 0x46,
	0x2f, 0x01, 0xf0, 0xef, 0x7e, 0x4c, 0x84, 0x68, 0x90, 0xac, 0xe0, 0x2c, 0xb3, 0x30, 0xb1, 0x79,
	0x19, 0xf2, 0xa4, 0xcf, 0xd4, 0x92, 0x03, 0x16, 0x18, 0x20, 0x27, 0x6c, 0x14, 0xa2, 0x1d, 0xc2,
	0x72, 0x5c, 0x7e, 0x88, 0x6e, 0xc3, 0xa2, 0x48, 0x2e, 0xf9, 0x89, 0x5d, 0x89, 0xa9, 0x89, 0x6f,
	0xf6, 0xc7, 0x74, 0x26, 0xdc, 0x43, 0x6a, 0x17, 0xf7, 0xd2, 0xee, 0xc1, 0xc5, 0xf8, 0x94, 0xf0,
	0x79, 0xeb, 0xed, 0x1b, 0x6c, 0xcf, 0x78, 0x2d, 0xfa, 0xed, 0x89, 0x49, 0x56, 0xa6, 0x2b, 0xdb,
	0x71, 0x93, 0xbb, 0xf6, 0x28, 0xf1, 0x5d, 0x16, 0x81, 0xa3, 0xd5, 0xde, 0xc5, 0x68, 0xb5, 0x37,
	0x1d, 0xad, 0xf6, 0x66, 0x26, 0xaa, 0xbd, 0xd9, 0x98, 0x6a, 0x2f, 0x4c, 0x57, 0x7b, 0x73, 0xd1,
	0x6a, 0x6f, 0x3e, 0x5a, 0xed, 0x2d, 0x4c, 0x56, 0x7b, 0x8b, 0x13, 0x95, 0xdd, 0xd2, 0x9c, 0x8a,
	0xab, 0x3a, 0xb7, 0xe2, 0x5a, 0x8e, 0xd6, 0x48, 0x91, 0xa8, 0x6f, 0xfe, 0x3d, 0x0f, 0x29, 0xfd,
	0x94, 0x26, 0x14, 0xeb, 0x91, 0xe2, 0x66, 0x25, 0x2a, 0xb1, 0x0c, 0x12, 0xf7, 0xa7, 0x1c, 0xe0,
	0x8e, 0x8f, 0xdc, 0x8e, 0xd3, 0x3b, 0x22, 0x96, 0x48, 0xfd, 0xaa, 0x71, 0x9e, 0x86, 0x8f, 0xc2,
	0x21, 0x0f, 0x74, 0x0b, 0x80, 0x4a, 0x41, 0xdb, 0xb4, 0x2c, 0x16, 0x3e, 0xc4, 0xfc, 0x25, 0x88,
	0x18, 0xd9, 0x74, 0xef, 0xd7, 0x28, 0x08, 0x67, 0x3d, 0xd9, 0x44, 0x1b, 0x90, 0x67, 0xde, 0xfc,
	0x6b, 0xbb, 0x25, 0x82, 0x8a, 0xab, 0xb3, 0xfc, 0xf9, 0x87, 0x25, 0x0b, 0xe7, 0xbc, 0xa0, 0x83,
	0x3e, 0x80, 0x1c, 0x97, 0x6d, 0x3e, 0x85, 0xd4, 0xec, 0x57, 0x60, 0xaa, 0xcd, 0xe7, 0xc0, 0x33,
	0x2f, 0x3e, 0x09, 0x1d, 0x0a, 0x9c, 0x80, 0x7f, 0xc7, 0xb6, 0xe2, 0xff, 0x8a, 0x23, 0x44, 0xc1,
	0x3f, 0xd1, 0x58, 0x38, 0x6f, 0x86, 0x7a, 0xe8, 0x2e, 0x94, 0x82, 0x40, 0x8d, 0xcf, 0x25, 0x1d,
	0xf7, 0x11, 0x9f, 0x13, 0xf9, 0x61, 0x1b, 0x9f, 0x4f, 0x10, 0xe3, 0xf1, 0x39, 0x7d, 0x04, 0xe5,
	0x80, 0x4c, 0xae, 0x4e, 0x26, 0x2e, 0x9b, 0x9e, 0xa0, 0x93, 0x4b, 0xa4, 0x1e, 0x4f, 0x58, 0xa2,
	0x94, 0xf2, 0x55, 0xb3, 0xe7, 0xa0, 0x94, 0xaf, 0x1b, 0x50, 0x0a, 0x8b, 0xf6, 0xb9, 0x02, 0x60,
	0x84, 0xcf, 0x42, 0xa8, 0x96, 0xaa, 0x3c, 0x6d, 0x2d, 0xf5, 0x16, 0x68, 0x27, 0xc4, 0x74, 0xbc,
	0x23, 0x62, 0x52, 0x81, 0xf7, 0x88, 0x73, 0x6a, 0xf6, 0xdb, 0x2e, 0xe9, 0xd8, 0x43, 0xcb, 0x15,
	0x7a, 0x5b, 0xf1, 0x11, 0x0d, 0x01, 0x30, 0xf8, 0x73, 0x6d, 0x1d, 0xb2, 0xfe, 0x09, 0x43, 0xaf,
	0x40, 0x92, 0x9e, 0x10, 0xa1, 0x54, 0x31, 0x3f, 0x4f, 0xec, 0xb1, 0xf6, 0x1b, 0x05, 0x72, 0xa1,
	0x63, 0xf5, 0x6d, 0x7e, 0x48, 0x43, 0x6b, 0xbe, 0x5c, 0xf2, 0x50, 0xa2, 0x1c, 0x9a, 0x44, 0x9c,
	0x4e, 0xa2, 0x57, 0x21, 0xc5, 0x17, 0x8e, 0x86, 0xe0, 0x45, 0xbf, 0x10, 0x20, 0xf1, 0x04, 0xf3,
	0xc7, 0x9a, 0x05, 0xc5, 0xe8, 0xd9, 0x41, 0x18, 0xb2, 0xfe, 0xc8, 0x62, 0xce, 0xcf, 0x96, 0xde,
	0x04, 0x34, 0xda, 0x31, 0xa8, 0x93, 0x47, 0xea, 0xdf, 0x32, 0xce, 0x41, 0x68, 0x1c, 0x79, 0x91,
	0x9e, 0x3f, 0xe3, 0xd1, 0xf6, 0x01, 0x82, 0xcb, 0x8e, 0x36, 0x20, 0xc5, 0x6e, 0xaa, 0xe0, 0x79,
	0xba, 0xd2, 0x0f, 0x77, 0xd5, 0x3e, 0x84, 0x7c, 0xf8, 0xee, 0x3f, 0xd7, 0x77, 0xd1, 0xdf, 0x2b,
	0x33, 0x7e, 0x12, 0xfd, 0x0f, 0x7e, 0x75, 0x55, 0xa1, 0x7d, 0xfa, 0x0b, 0xd3, 0xae, 0xd5, 0xeb,
	0x7a, 0x5d, 0x4d, 0x20, 0x15, 0xf2, 0xac, 0xcf, 0xbf, 0xb9, 0xd5, 0xf9, 0x8f, 0x22, 0xff, 0xde,
	0xc5, 0x21, 0x49, 0xfa, 0x5b, 0xc5, 0x0d, 0xfc, 0x5b, 0x59, 0x5d, 0x4d, 0xa1, 0x25, 0x28, 0xf9,
	0x3f, 0x67, 0x02, 0xb7, 0x48, 0x7f, 0x3c, 0x03, 0xa3, 0xe4, 0x4b, 0x47, 0xcd, 0x92, 0x82, 0x7d,
	0x22, 0xdd, 0xd6, 0x6b, 0xb8, 0xb5, 0xa1, 0xd7, 0x5a, 0x6a, 0x96, 0xff, 0xea, 0x6c, 0xd4, 0xbf,
	0x7a, 0x5c, 0xbd, 0xf0, 0xc7, 0xc7, 0xd5, 0x0b, 0x7f, 0x7e, 0x5c, 0x55, 0xbe, 0x79, 0x5c, 0x55,
	0xfe, 0xf1, 0xb8, 0xaa, 0xfc, 0xe4, 0xac, 0xaa, 0xfc, 0xfa, 0xac, 0xaa, 0xfc, 0xf6, 0xac, 0xaa,
	0xfc, 0xee, 0xac, 0xaa, 0x7c, 0x79, 0x56, 0x55, 0xbe, 0x3a, 0xab, 0x2a, 0x7f, 0x3b, 0xab, 0x5e,
	0xf8, 0xe6, 0xac, 0xaa, 0xfc, 0xfc, 0xeb, 0xea, 0x85, 0x2f, 0xbe, 0xae, 0x2a, 0x1f, 0x2f, 0xf2,
	0xb5, 0xff, 0x57, 0x00, 0x00, 0x00, 0xff, 0xff, 0x74, 0xf2, 0xc6, 0x01, 0xc5, 0x29, 0x00, 0x00,
}
