// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: google/type/postal_address.proto

package _type

import (
	bytes "bytes"
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// Represents a postal address, e.g. for postal delivery or payments addresses.
// Given a postal address, a postal service can deliver items to a premise, P.O.
// Box or similar.
// It is not intended to model geographical locations (roads, towns,
// mountains).
//
// In typical usage an address would be created via user input or from importing
// existing data, depending on the type of process.
//
// Advice on address input / editing:
//  - Use an i18n-ready address widget such as
//    https://github.com/google/libaddressinput)
// - Users should not be presented with UI elements for input or editing of
//   fields outside countries where that field is used.
//
// For more guidance on how to use this schema, please see:
// https://support.google.com/business/answer/6397478
type PostalAddress struct {
	// The schema revision of the `PostalAddress`. This must be set to 0, which is
	// the latest revision.
	//
	// All new revisions **must** be backward compatible with old revisions.
	Revision int32 `protobuf:"varint,1,opt,name=revision,proto3" json:"revision,omitempty"`
	// Required. CLDR region code of the country/region of the address. This
	// is never inferred and it is up to the user to ensure the value is
	// correct. See http://cldr.unicode.org/ and
	// http://www.unicode.org/cldr/charts/30/supplemental/territory_information.html
	// for details. Example: "CH" for Switzerland.
	RegionCode string `protobuf:"bytes,2,opt,name=region_code,json=regionCode,proto3" json:"region_code,omitempty"`
	// Optional. BCP-47 language code of the contents of this address (if
	// known). This is often the UI language of the input form or is expected
	// to match one of the languages used in the address' country/region, or their
	// transliterated equivalents.
	// This can affect formatting in certain countries, but is not critical
	// to the correctness of the data and will never affect any validation or
	// other non-formatting related operations.
	//
	// If this value is not known, it should be omitted (rather than specifying a
	// possibly incorrect default).
	//
	// Examples: "zh-Hant", "ja", "ja-Latn", "en".
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. Postal code of the address. Not all countries use or require
	// postal codes to be present, but where they are used, they may trigger
	// additional validation with other parts of the address (e.g. state/zip
	// validation in the U.S.A.).
	PostalCode string `protobuf:"bytes,4,opt,name=postal_code,json=postalCode,proto3" json:"postal_code,omitempty"`
	// Optional. Additional, country-specific, sorting code. This is not used
	// in most regions. Where it is used, the value is either a string like
	// "CEDEX", optionally followed by a number (e.g. "CEDEX 7"), or just a number
	// alone, representing the "sector code" (Jamaica), "delivery area indicator"
	// (Malawi) or "post office indicator" (e.g. Côte d'Ivoire).
	SortingCode string `protobuf:"bytes,5,opt,name=sorting_code,json=sortingCode,proto3" json:"sorting_code,omitempty"`
	// Optional. Highest administrative subdivision which is used for postal
	// addresses of a country or region.
	// For example, this can be a state, a province, an oblast, or a prefecture.
	// Specifically, for Spain this is the province and not the autonomous
	// community (e.g. "Barcelona" and not "Catalonia").
	// Many countries don't use an administrative area in postal addresses. E.g.
	// in Switzerland this should be left unpopulated.
	AdministrativeArea string `protobuf:"bytes,6,opt,name=administrative_area,json=administrativeArea,proto3" json:"administrative_area,omitempty"`
	// Optional. Generally refers to the city/town portion of the address.
	// Examples: US city, IT comune, UK post town.
	// In regions of the world where localities are not well defined or do not fit
	// into this structure well, leave locality empty and use address_lines.
	Locality string `protobuf:"bytes,7,opt,name=locality,proto3" json:"locality,omitempty"`
	// Optional. Sublocality of the address.
	// For example, this can be neighborhoods, boroughs, districts.
	Sublocality string `protobuf:"bytes,8,opt,name=sublocality,proto3" json:"sublocality,omitempty"`
	// Unstructured address lines describing the lower levels of an address.
	//
	// Because values in address_lines do not have type information and may
	// sometimes contain multiple values in a single field (e.g.
	// "Austin, TX"), it is important that the line order is clear. The order of
	// address lines should be "envelope order" for the country/region of the
	// address. In places where this can vary (e.g. Japan), address_language is
	// used to make it explicit (e.g. "ja" for large-to-small ordering and
	// "ja-Latn" or "en" for small-to-large). This way, the most specific line of
	// an address can be selected based on the language.
	//
	// The minimum permitted structural representation of an address consists
	// of a region_code with all remaining information placed in the
	// address_lines. It would be possible to format such an address very
	// approximately without geocoding, but no semantic reasoning could be
	// made about any of the address components until it was at least
	// partially resolved.
	//
	// Creating an address only containing a region_code and address_lines, and
	// then geocoding is the recommended way to handle completely unstructured
	// addresses (as opposed to guessing which parts of the address should be
	// localities or administrative areas).
	AddressLines []string `protobuf:"bytes,9,rep,name=address_lines,json=addressLines,proto3" json:"address_lines,omitempty"`
	// Optional. The recipient at the address.
	// This field may, under certain circumstances, contain multiline information.
	// For example, it might contain "care of" information.
	Recipients []string `protobuf:"bytes,10,rep,name=recipients,proto3" json:"recipients,omitempty"`
	// Optional. The name of the organization at the address.
	Organization         string   `protobuf:"bytes,11,opt,name=organization,proto3" json:"organization,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PostalAddress) Reset()      { *m = PostalAddress{} }
func (*PostalAddress) ProtoMessage() {}
func (*PostalAddress) Descriptor() ([]byte, []int) {
	return fileDescriptor_17c0e9bca935790c, []int{0}
}
func (m *PostalAddress) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PostalAddress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PostalAddress.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PostalAddress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PostalAddress.Merge(m, src)
}
func (m *PostalAddress) XXX_Size() int {
	return m.Size()
}
func (m *PostalAddress) XXX_DiscardUnknown() {
	xxx_messageInfo_PostalAddress.DiscardUnknown(m)
}

var xxx_messageInfo_PostalAddress proto.InternalMessageInfo

func (m *PostalAddress) GetRevision() int32 {
	if m != nil {
		return m.Revision
	}
	return 0
}

func (m *PostalAddress) GetRegionCode() string {
	if m != nil {
		return m.RegionCode
	}
	return ""
}

func (m *PostalAddress) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *PostalAddress) GetPostalCode() string {
	if m != nil {
		return m.PostalCode
	}
	return ""
}

func (m *PostalAddress) GetSortingCode() string {
	if m != nil {
		return m.SortingCode
	}
	return ""
}

func (m *PostalAddress) GetAdministrativeArea() string {
	if m != nil {
		return m.AdministrativeArea
	}
	return ""
}

func (m *PostalAddress) GetLocality() string {
	if m != nil {
		return m.Locality
	}
	return ""
}

func (m *PostalAddress) GetSublocality() string {
	if m != nil {
		return m.Sublocality
	}
	return ""
}

func (m *PostalAddress) GetAddressLines() []string {
	if m != nil {
		return m.AddressLines
	}
	return nil
}

func (m *PostalAddress) GetRecipients() []string {
	if m != nil {
		return m.Recipients
	}
	return nil
}

func (m *PostalAddress) GetOrganization() string {
	if m != nil {
		return m.Organization
	}
	return ""
}

func (*PostalAddress) XXX_MessageName() string {
	return "google.type.PostalAddress"
}
func init() {
	proto.RegisterType((*PostalAddress)(nil), "google.type.PostalAddress")
}

func init() { proto.RegisterFile("google/type/postal_address.proto", fileDescriptor_17c0e9bca935790c) }

var fileDescriptor_17c0e9bca935790c = []byte{
	// 367 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x54, 0x92, 0xb1, 0x6e, 0xea, 0x30,
	0x14, 0x86, 0x31, 0x01, 0x2e, 0x38, 0xa0, 0x2b, 0xb9, 0x4b, 0xd4, 0xc1, 0xa4, 0x74, 0x61, 0x82,
	0xa1, 0x4f, 0x00, 0x1d, 0xba, 0x74, 0x88, 0x50, 0xa7, 0x2e, 0x91, 0x49, 0xdc, 0xc8, 0x52, 0xb0,
	0x23, 0xdb, 0x20, 0xd1, 0xa9, 0x2f, 0xd0, 0x97, 0xe8, 0xd4, 0x47, 0x61, 0xec, 0xd8, 0xb1, 0x84,
	0xa5, 0x23, 0x23, 0x63, 0x65, 0x3b, 0xa5, 0x30, 0x9e, 0xef, 0x7c, 0xb2, 0x7d, 0xce, 0x6f, 0x18,
	0x66, 0x42, 0x64, 0x39, 0x1d, 0xeb, 0x75, 0x41, 0xc7, 0x85, 0x50, 0x9a, 0xe4, 0x31, 0x49, 0x53,
	0x49, 0x95, 0x1a, 0x15, 0x52, 0x68, 0x81, 0x7c, 0x67, 0x8c, 0x8c, 0x31, 0x78, 0xf5, 0x60, 0x2f,
	0xb2, 0xd6, 0xc4, 0x49, 0xe8, 0x12, 0xb6, 0x25, 0x5d, 0x31, 0xc5, 0x04, 0x0f, 0x40, 0x08, 0x86,
	0xcd, 0xd9, 0xb1, 0x46, 0x7d, 0xe8, 0x4b, 0x9a, 0x31, 0xc1, 0xe3, 0x44, 0xa4, 0x34, 0xa8, 0x87,
	0x60, 0xd8, 0x99, 0x41, 0x87, 0x6e, 0x45, 0x4a, 0xd1, 0x35, 0xec, 0xe5, 0x84, 0x67, 0x4b, 0x92,
	0x51, 0xa7, 0x78, 0x56, 0xe9, 0xfe, 0x42, 0x2b, 0xf5, 0xa1, 0x5f, 0x3d, 0xcc, 0x2a, 0x0d, 0x77,
	0x8a, 0x43, 0x56, 0xb8, 0x82, 0x5d, 0x25, 0xa4, 0x66, 0x3c, 0x73, 0x46, 0xd3, 0x1a, 0x7e, 0xc5,
	0xac, 0x32, 0x86, 0x17, 0x24, 0x5d, 0x30, 0xce, 0x94, 0x96, 0x44, 0xb3, 0x15, 0x8d, 0x89, 0xa4,
	0x24, 0x68, 0x59, 0x13, 0x9d, 0xb7, 0x26, 0x92, 0x12, 0x33, 0x56, 0x2e, 0x12, 0x92, 0x33, 0xbd,
	0x0e, 0xfe, 0x59, 0xeb, 0x58, 0xa3, 0x10, 0xfa, 0x6a, 0x39, 0x3f, 0xb6, 0xdb, 0xd5, 0x75, 0x7f,
	0xc8, 0xcc, 0x55, 0x2d, 0x31, 0xce, 0x19, 0xa7, 0x2a, 0xe8, 0x84, 0x9e, 0x99, 0xab, 0x82, 0xf7,
	0x86, 0x21, 0x0c, 0xa1, 0xa4, 0x09, 0x2b, 0x18, 0xe5, 0x5a, 0x05, 0xd0, 0x1a, 0x27, 0x04, 0x0d,
	0x60, 0x57, 0xc8, 0x8c, 0x70, 0xf6, 0x4c, 0xb4, 0xd9, 0xae, 0xef, 0x76, 0x73, 0xca, 0xa6, 0x4f,
	0x9f, 0x5b, 0x5c, 0xdb, 0x6f, 0x31, 0x38, 0x6c, 0x31, 0x78, 0x29, 0x31, 0x78, 0x2f, 0x31, 0xd8,
	0x94, 0x18, 0x7c, 0x94, 0x18, 0x7c, 0x95, 0x18, 0x7c, 0x97, 0xb8, 0xb6, 0x37, 0x7c, 0x87, 0xc1,
	0x66, 0x87, 0x01, 0xfc, 0x9f, 0x88, 0xc5, 0xe8, 0x24, 0xd2, 0x29, 0x3a, 0xcb, 0x33, 0x32, 0x99,
	0x47, 0xe0, 0xb1, 0x61, 0x7a, 0x07, 0x00, 0xde, 0xea, 0xde, 0xdd, 0x43, 0x34, 0x6f, 0xd9, 0xbf,
	0x70, 0xf3, 0x13, 0x00, 0x00, 0xff, 0xff, 0xd3, 0x06, 0xa1, 0xfa, 0x2f, 0x02, 0x00, 0x00,
}

func (this *PostalAddress) Compare(that interface{}) int {
	if that == nil {
		if this == nil {
			return 0
		}
		return 1
	}

	that1, ok := that.(*PostalAddress)
	if !ok {
		that2, ok := that.(PostalAddress)
		if ok {
			that1 = &that2
		} else {
			return 1
		}
	}
	if that1 == nil {
		if this == nil {
			return 0
		}
		return 1
	} else if this == nil {
		return -1
	}
	if this.Revision != that1.Revision {
		if this.Revision < that1.Revision {
			return -1
		}
		return 1
	}
	if this.RegionCode != that1.RegionCode {
		if this.RegionCode < that1.RegionCode {
			return -1
		}
		return 1
	}
	if this.LanguageCode != that1.LanguageCode {
		if this.LanguageCode < that1.LanguageCode {
			return -1
		}
		return 1
	}
	if this.PostalCode != that1.PostalCode {
		if this.PostalCode < that1.PostalCode {
			return -1
		}
		return 1
	}
	if this.SortingCode != that1.SortingCode {
		if this.SortingCode < that1.SortingCode {
			return -1
		}
		return 1
	}
	if this.AdministrativeArea != that1.AdministrativeArea {
		if this.AdministrativeArea < that1.AdministrativeArea {
			return -1
		}
		return 1
	}
	if this.Locality != that1.Locality {
		if this.Locality < that1.Locality {
			return -1
		}
		return 1
	}
	if this.Sublocality != that1.Sublocality {
		if this.Sublocality < that1.Sublocality {
			return -1
		}
		return 1
	}
	if len(this.AddressLines) != len(that1.AddressLines) {
		if len(this.AddressLines) < len(that1.AddressLines) {
			return -1
		}
		return 1
	}
	for i := range this.AddressLines {
		if this.AddressLines[i] != that1.AddressLines[i] {
			if this.AddressLines[i] < that1.AddressLines[i] {
				return -1
			}
			return 1
		}
	}
	if len(this.Recipients) != len(that1.Recipients) {
		if len(this.Recipients) < len(that1.Recipients) {
			return -1
		}
		return 1
	}
	for i := range this.Recipients {
		if this.Recipients[i] != that1.Recipients[i] {
			if this.Recipients[i] < that1.Recipients[i] {
				return -1
			}
			return 1
		}
	}
	if this.Organization != that1.Organization {
		if this.Organization < that1.Organization {
			return -1
		}
		return 1
	}
	if c := bytes.Compare(this.XXX_unrecognized, that1.XXX_unrecognized); c != 0 {
		return c
	}
	return 0
}
func (this *PostalAddress) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PostalAddress)
	if !ok {
		that2, ok := that.(PostalAddress)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Revision != that1.Revision {
		return false
	}
	if this.RegionCode != that1.RegionCode {
		return false
	}
	if this.LanguageCode != that1.LanguageCode {
		return false
	}
	if this.PostalCode != that1.PostalCode {
		return false
	}
	if this.SortingCode != that1.SortingCode {
		return false
	}
	if this.AdministrativeArea != that1.AdministrativeArea {
		return false
	}
	if this.Locality != that1.Locality {
		return false
	}
	if this.Sublocality != that1.Sublocality {
		return false
	}
	if len(this.AddressLines) != len(that1.AddressLines) {
		return false
	}
	for i := range this.AddressLines {
		if this.AddressLines[i] != that1.AddressLines[i] {
			return false
		}
	}
	if len(this.Recipients) != len(that1.Recipients) {
		return false
	}
	for i := range this.Recipients {
		if this.Recipients[i] != that1.Recipients[i] {
			return false
		}
	}
	if this.Organization != that1.Organization {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *PostalAddress) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 15)
	s = append(s, "&_type.PostalAddress{")
	s = append(s, "Revision: "+fmt.Sprintf("%#v", this.Revision)+",\n")
	s = append(s, "RegionCode: "+fmt.Sprintf("%#v", this.RegionCode)+",\n")
	s = append(s, "LanguageCode: "+fmt.Sprintf("%#v", this.LanguageCode)+",\n")
	s = append(s, "PostalCode: "+fmt.Sprintf("%#v", this.PostalCode)+",\n")
	s = append(s, "SortingCode: "+fmt.Sprintf("%#v", this.SortingCode)+",\n")
	s = append(s, "AdministrativeArea: "+fmt.Sprintf("%#v", this.AdministrativeArea)+",\n")
	s = append(s, "Locality: "+fmt.Sprintf("%#v", this.Locality)+",\n")
	s = append(s, "Sublocality: "+fmt.Sprintf("%#v", this.Sublocality)+",\n")
	s = append(s, "AddressLines: "+fmt.Sprintf("%#v", this.AddressLines)+",\n")
	s = append(s, "Recipients: "+fmt.Sprintf("%#v", this.Recipients)+",\n")
	s = append(s, "Organization: "+fmt.Sprintf("%#v", this.Organization)+",\n")
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringPostalAddress(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *PostalAddress) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PostalAddress) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PostalAddress) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Organization) > 0 {
		i -= len(m.Organization)
		copy(dAtA[i:], m.Organization)
		i = encodeVarintPostalAddress(dAtA, i, uint64(len(m.Organization)))
		i--
		dAtA[i] = 0x5a
	}
	if len(m.Recipients) > 0 {
		for iNdEx := len(m.Recipients) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Recipients[iNdEx])
			copy(dAtA[i:], m.Recipients[iNdEx])
			i = encodeVarintPostalAddress(dAtA, i, uint64(len(m.Recipients[iNdEx])))
			i--
			dAtA[i] = 0x52
		}
	}
	if len(m.AddressLines) > 0 {
		for iNdEx := len(m.AddressLines) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.AddressLines[iNdEx])
			copy(dAtA[i:], m.AddressLines[iNdEx])
			i = encodeVarintPostalAddress(dAtA, i, uint64(len(m.AddressLines[iNdEx])))
			i--
			dAtA[i] = 0x4a
		}
	}
	if len(m.Sublocality) > 0 {
		i -= len(m.Sublocality)
		copy(dAtA[i:], m.Sublocality)
		i = encodeVarintPostalAddress(dAtA, i, uint64(len(m.Sublocality)))
		i--
		dAtA[i] = 0x42
	}
	if len(m.Locality) > 0 {
		i -= len(m.Locality)
		copy(dAtA[i:], m.Locality)
		i = encodeVarintPostalAddress(dAtA, i, uint64(len(m.Locality)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.AdministrativeArea) > 0 {
		i -= len(m.AdministrativeArea)
		copy(dAtA[i:], m.AdministrativeArea)
		i = encodeVarintPostalAddress(dAtA, i, uint64(len(m.AdministrativeArea)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.SortingCode) > 0 {
		i -= len(m.SortingCode)
		copy(dAtA[i:], m.SortingCode)
		i = encodeVarintPostalAddress(dAtA, i, uint64(len(m.SortingCode)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.PostalCode) > 0 {
		i -= len(m.PostalCode)
		copy(dAtA[i:], m.PostalCode)
		i = encodeVarintPostalAddress(dAtA, i, uint64(len(m.PostalCode)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.LanguageCode) > 0 {
		i -= len(m.LanguageCode)
		copy(dAtA[i:], m.LanguageCode)
		i = encodeVarintPostalAddress(dAtA, i, uint64(len(m.LanguageCode)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.RegionCode) > 0 {
		i -= len(m.RegionCode)
		copy(dAtA[i:], m.RegionCode)
		i = encodeVarintPostalAddress(dAtA, i, uint64(len(m.RegionCode)))
		i--
		dAtA[i] = 0x12
	}
	if m.Revision != 0 {
		i = encodeVarintPostalAddress(dAtA, i, uint64(m.Revision))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintPostalAddress(dAtA []byte, offset int, v uint64) int {
	offset -= sovPostalAddress(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func NewPopulatedPostalAddress(r randyPostalAddress, easy bool) *PostalAddress {
	this := &PostalAddress{}
	this.Revision = int32(r.Int31())
	if r.Intn(2) == 0 {
		this.Revision *= -1
	}
	this.RegionCode = string(randStringPostalAddress(r))
	this.LanguageCode = string(randStringPostalAddress(r))
	this.PostalCode = string(randStringPostalAddress(r))
	this.SortingCode = string(randStringPostalAddress(r))
	this.AdministrativeArea = string(randStringPostalAddress(r))
	this.Locality = string(randStringPostalAddress(r))
	this.Sublocality = string(randStringPostalAddress(r))
	v1 := r.Intn(10)
	this.AddressLines = make([]string, v1)
	for i := 0; i < v1; i++ {
		this.AddressLines[i] = string(randStringPostalAddress(r))
	}
	v2 := r.Intn(10)
	this.Recipients = make([]string, v2)
	for i := 0; i < v2; i++ {
		this.Recipients[i] = string(randStringPostalAddress(r))
	}
	this.Organization = string(randStringPostalAddress(r))
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedPostalAddress(r, 12)
	}
	return this
}

type randyPostalAddress interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RunePostalAddress(r randyPostalAddress) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringPostalAddress(r randyPostalAddress) string {
	v3 := r.Intn(100)
	tmps := make([]rune, v3)
	for i := 0; i < v3; i++ {
		tmps[i] = randUTF8RunePostalAddress(r)
	}
	return string(tmps)
}
func randUnrecognizedPostalAddress(r randyPostalAddress, maxFieldNumber int) (dAtA []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		dAtA = randFieldPostalAddress(dAtA, r, fieldNumber, wire)
	}
	return dAtA
}
func randFieldPostalAddress(dAtA []byte, r randyPostalAddress, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		dAtA = encodeVarintPopulatePostalAddress(dAtA, uint64(key))
		v4 := r.Int63()
		if r.Intn(2) == 0 {
			v4 *= -1
		}
		dAtA = encodeVarintPopulatePostalAddress(dAtA, uint64(v4))
	case 1:
		dAtA = encodeVarintPopulatePostalAddress(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		dAtA = encodeVarintPopulatePostalAddress(dAtA, uint64(key))
		ll := r.Intn(100)
		dAtA = encodeVarintPopulatePostalAddress(dAtA, uint64(ll))
		for j := 0; j < ll; j++ {
			dAtA = append(dAtA, byte(r.Intn(256)))
		}
	default:
		dAtA = encodeVarintPopulatePostalAddress(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return dAtA
}
func encodeVarintPopulatePostalAddress(dAtA []byte, v uint64) []byte {
	for v >= 1<<7 {
		dAtA = append(dAtA, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	dAtA = append(dAtA, uint8(v))
	return dAtA
}
func (m *PostalAddress) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Revision != 0 {
		n += 1 + sovPostalAddress(uint64(m.Revision))
	}
	l = len(m.RegionCode)
	if l > 0 {
		n += 1 + l + sovPostalAddress(uint64(l))
	}
	l = len(m.LanguageCode)
	if l > 0 {
		n += 1 + l + sovPostalAddress(uint64(l))
	}
	l = len(m.PostalCode)
	if l > 0 {
		n += 1 + l + sovPostalAddress(uint64(l))
	}
	l = len(m.SortingCode)
	if l > 0 {
		n += 1 + l + sovPostalAddress(uint64(l))
	}
	l = len(m.AdministrativeArea)
	if l > 0 {
		n += 1 + l + sovPostalAddress(uint64(l))
	}
	l = len(m.Locality)
	if l > 0 {
		n += 1 + l + sovPostalAddress(uint64(l))
	}
	l = len(m.Sublocality)
	if l > 0 {
		n += 1 + l + sovPostalAddress(uint64(l))
	}
	if len(m.AddressLines) > 0 {
		for _, s := range m.AddressLines {
			l = len(s)
			n += 1 + l + sovPostalAddress(uint64(l))
		}
	}
	if len(m.Recipients) > 0 {
		for _, s := range m.Recipients {
			l = len(s)
			n += 1 + l + sovPostalAddress(uint64(l))
		}
	}
	l = len(m.Organization)
	if l > 0 {
		n += 1 + l + sovPostalAddress(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovPostalAddress(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozPostalAddress(x uint64) (n int) {
	return sovPostalAddress(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *PostalAddress) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PostalAddress{`,
		`Revision:` + fmt.Sprintf("%v", this.Revision) + `,`,
		`RegionCode:` + fmt.Sprintf("%v", this.RegionCode) + `,`,
		`LanguageCode:` + fmt.Sprintf("%v", this.LanguageCode) + `,`,
		`PostalCode:` + fmt.Sprintf("%v", this.PostalCode) + `,`,
		`SortingCode:` + fmt.Sprintf("%v", this.SortingCode) + `,`,
		`AdministrativeArea:` + fmt.Sprintf("%v", this.AdministrativeArea) + `,`,
		`Locality:` + fmt.Sprintf("%v", this.Locality) + `,`,
		`Sublocality:` + fmt.Sprintf("%v", this.Sublocality) + `,`,
		`AddressLines:` + fmt.Sprintf("%v", this.AddressLines) + `,`,
		`Recipients:` + fmt.Sprintf("%v", this.Recipients) + `,`,
		`Organization:` + fmt.Sprintf("%v", this.Organization) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringPostalAddress(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *PostalAddress) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPostalAddress
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PostalAddress: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PostalAddress: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Revision", wireType)
			}
			m.Revision = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPostalAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Revision |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionCode", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPostalAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPostalAddress
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPostalAddress
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RegionCode = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LanguageCode", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPostalAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPostalAddress
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPostalAddress
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LanguageCode = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PostalCode", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPostalAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPostalAddress
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPostalAddress
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PostalCode = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SortingCode", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPostalAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPostalAddress
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPostalAddress
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SortingCode = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdministrativeArea", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPostalAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPostalAddress
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPostalAddress
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AdministrativeArea = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Locality", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPostalAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPostalAddress
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPostalAddress
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Locality = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sublocality", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPostalAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPostalAddress
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPostalAddress
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sublocality = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AddressLines", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPostalAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPostalAddress
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPostalAddress
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AddressLines = append(m.AddressLines, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Recipients", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPostalAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPostalAddress
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPostalAddress
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Recipients = append(m.Recipients, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Organization", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPostalAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPostalAddress
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPostalAddress
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Organization = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPostalAddress(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPostalAddress
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPostalAddress
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipPostalAddress(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowPostalAddress
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowPostalAddress
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowPostalAddress
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthPostalAddress
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthPostalAddress
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowPostalAddress
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipPostalAddress(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthPostalAddress
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthPostalAddress = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowPostalAddress   = fmt.Errorf("proto: integer overflow")
)
