/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by protoc-gen-go. DO NOT EDIT.
// source: config.proto

package config

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type TestGroup_TestsName int32

const (
	TestGroup_TESTS_NAME_MIN     TestGroup_TestsName = 0
	TestGroup_TESTS_NAME_IGNORE  TestGroup_TestsName = 1
	TestGroup_TESTS_NAME_REPLACE TestGroup_TestsName = 2
	TestGroup_TESTS_NAME_APPEND  TestGroup_TestsName = 3
)

var TestGroup_TestsName_name = map[int32]string{
	0: "TESTS_NAME_MIN",
	1: "TESTS_NAME_IGNORE",
	2: "TESTS_NAME_REPLACE",
	3: "TESTS_NAME_APPEND",
}

var TestGroup_TestsName_value = map[string]int32{
	"TESTS_NAME_MIN":     0,
	"TESTS_NAME_IGNORE":  1,
	"TESTS_NAME_REPLACE": 2,
	"TESTS_NAME_APPEND":  3,
}

func (x TestGroup_TestsName) String() string {
	return proto.EnumName(TestGroup_TestsName_name, int32(x))
}

func (TestGroup_TestsName) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{2, 0}
}

// Specifies the test name.
type TestNameConfig struct {
	// The name elements specifying the target test name for this tab.
	NameElements []*TestNameConfig_NameElement `protobuf:"bytes,1,rep,name=name_elements,json=nameElements,proto3" json:"name_elements,omitempty"`
	// Specifies a printf-style format string for name elements. The format
	// string should have as many conversions as there are name_elements.
	// For example, two name_elements could be used with name_format="%s: %s".
	NameFormat           string   `protobuf:"bytes,2,opt,name=name_format,json=nameFormat,proto3" json:"name_format,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TestNameConfig) Reset()         { *m = TestNameConfig{} }
func (m *TestNameConfig) String() string { return proto.CompactTextString(m) }
func (*TestNameConfig) ProtoMessage()    {}
func (*TestNameConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{0}
}

func (m *TestNameConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestNameConfig.Unmarshal(m, b)
}
func (m *TestNameConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestNameConfig.Marshal(b, m, deterministic)
}
func (m *TestNameConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestNameConfig.Merge(m, src)
}
func (m *TestNameConfig) XXX_Size() int {
	return xxx_messageInfo_TestNameConfig.Size(m)
}
func (m *TestNameConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_TestNameConfig.DiscardUnknown(m)
}

var xxx_messageInfo_TestNameConfig proto.InternalMessageInfo

func (m *TestNameConfig) GetNameElements() []*TestNameConfig_NameElement {
	if m != nil {
		return m.NameElements
	}
	return nil
}

func (m *TestNameConfig) GetNameFormat() string {
	if m != nil {
		return m.NameFormat
	}
	return ""
}

// Specifies name elements to be selected from configuration values
type TestNameConfig_NameElement struct {
	// Configuration value to use.
	// Valid choice are:
	// 'Tests name': The name of a test case
	// 'Commit': The commit number of the build
	// 'Context', 'Thread': The info extracted from each junit files:
	//    - junit_core-os_01.xml -> Context: core-os, Thread: 01
	//    - junit_runner.xml -> Context: runner
	//    - junit_01.xml -> Thread: 01
	// or any metadata key from finished.json, which is copied from your test suite.
	//
	// A valid sample TestNameConfig looks like:
	// test_name_config:
	//   name_elements:
	//   - target_config: Tests name
	//   - target_config: Context
	//   name_format: '%s [%s]'
	TargetConfig         string   `protobuf:"bytes,2,opt,name=target_config,json=targetConfig,proto3" json:"target_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TestNameConfig_NameElement) Reset()         { *m = TestNameConfig_NameElement{} }
func (m *TestNameConfig_NameElement) String() string { return proto.CompactTextString(m) }
func (*TestNameConfig_NameElement) ProtoMessage()    {}
func (*TestNameConfig_NameElement) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{0, 0}
}

func (m *TestNameConfig_NameElement) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestNameConfig_NameElement.Unmarshal(m, b)
}
func (m *TestNameConfig_NameElement) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestNameConfig_NameElement.Marshal(b, m, deterministic)
}
func (m *TestNameConfig_NameElement) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestNameConfig_NameElement.Merge(m, src)
}
func (m *TestNameConfig_NameElement) XXX_Size() int {
	return xxx_messageInfo_TestNameConfig_NameElement.Size(m)
}
func (m *TestNameConfig_NameElement) XXX_DiscardUnknown() {
	xxx_messageInfo_TestNameConfig_NameElement.DiscardUnknown(m)
}

var xxx_messageInfo_TestNameConfig_NameElement proto.InternalMessageInfo

func (m *TestNameConfig_NameElement) GetTargetConfig() string {
	if m != nil {
		return m.TargetConfig
	}
	return ""
}

// A single notification.
type Notification struct {
	// Required: Text summary of the issue or notice.
	Summary string `protobuf:"bytes,1,opt,name=summary,proto3" json:"summary,omitempty"`
	// Optional: Link to further information, such as a bug, email, document, etc.
	ContextLink          string   `protobuf:"bytes,2,opt,name=context_link,json=contextLink,proto3" json:"context_link,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Notification) Reset()         { *m = Notification{} }
func (m *Notification) String() string { return proto.CompactTextString(m) }
func (*Notification) ProtoMessage()    {}
func (*Notification) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{1}
}

func (m *Notification) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Notification.Unmarshal(m, b)
}
func (m *Notification) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Notification.Marshal(b, m, deterministic)
}
func (m *Notification) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Notification.Merge(m, src)
}
func (m *Notification) XXX_Size() int {
	return xxx_messageInfo_Notification.Size(m)
}
func (m *Notification) XXX_DiscardUnknown() {
	xxx_messageInfo_Notification.DiscardUnknown(m)
}

var xxx_messageInfo_Notification proto.InternalMessageInfo

func (m *Notification) GetSummary() string {
	if m != nil {
		return m.Summary
	}
	return ""
}

func (m *Notification) GetContextLink() string {
	if m != nil {
		return m.ContextLink
	}
	return ""
}

// Specifies a group of tests to gather.
type TestGroup struct {
	// Name of this TestGroup, for mapping dashboard tabs to tests.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Path to the test result stored in gcs
	GcsPrefix string `protobuf:"bytes,2,opt,name=gcs_prefix,json=gcsPrefix,proto3" json:"gcs_prefix,omitempty"`
	// Number of days of test results to gather and serve.
	DaysOfResults int32 `protobuf:"varint,3,opt,name=days_of_results,json=daysOfResults,proto3" json:"days_of_results,omitempty"`
	// Whether to ignore pending (currently running) test results.
	IgnorePending bool `protobuf:"varint,4,opt,name=ignore_pending,json=ignorePending,proto3" json:"ignore_pending,omitempty"`
	// What to do with the 'Tests name' configuration value. It can replace the
	// name of the test, be appended to the name of the test, or ignored. If it is
	// ignored, then the name of the tests will be the build target.
	TestsNamePolicy TestGroup_TestsName       `protobuf:"varint,6,opt,name=tests_name_policy,json=testsNamePolicy,proto3,enum=TestGroup_TestsName" json:"tests_name_policy,omitempty"`
	ColumnHeader    []*TestGroup_ColumnHeader `protobuf:"bytes,9,rep,name=column_header,json=columnHeader,proto3" json:"column_header,omitempty"`
	// Time in hours before an alert will be added to a test results table if the
	// run date of the latest results are older than this time.  If zero, no
	// alerts are raised.
	AlertStaleResultsHours int32 `protobuf:"varint,11,opt,name=alert_stale_results_hours,json=alertStaleResultsHours,proto3" json:"alert_stale_results_hours,omitempty"`
	// The number of consecutive test result failures to see before alerting of
	// a consistent failure. If zero, no alerts are raised.
	NumFailuresToAlert int32 `protobuf:"varint,12,opt,name=num_failures_to_alert,json=numFailuresToAlert,proto3" json:"num_failures_to_alert,omitempty"`
	// Default code search path for searching regressions. Overridden by
	// code_search_path in DashboardTab.
	CodeSearchPath string `protobuf:"bytes,14,opt,name=code_search_path,json=codeSearchPath,proto3" json:"code_search_path,omitempty"`
	// The number of columns to consider "recent" for a variety of purposes.
	NumColumnsRecent int32 `protobuf:"varint,15,opt,name=num_columns_recent,json=numColumnsRecent,proto3" json:"num_columns_recent,omitempty"`
	// deprecated - always set to true
	UseKubernetesClient bool `protobuf:"varint,24,opt,name=use_kubernetes_client,json=useKubernetesClient,proto3" json:"use_kubernetes_client,omitempty"`
	// deprecated - always set to true
	IsExternal bool `protobuf:"varint,25,opt,name=is_external,json=isExternal,proto3" json:"is_external,omitempty"`
	// Specifies the test name for a test.
	TestNameConfig *TestNameConfig `protobuf:"bytes,26,opt,name=test_name_config,json=testNameConfig,proto3" json:"test_name_config,omitempty"`
	// A list of notifications attached to this test group.
	// This is displayed on any dashboard tab backed by this test group.
	Notifications []*Notification `protobuf:"bytes,27,rep,name=notifications,proto3" json:"notifications,omitempty"`
	// Max number of days any single test can take.
	MaxTestRuntimeHours int32 `protobuf:"varint,37,opt,name=max_test_runtime_hours,json=maxTestRuntimeHours,proto3" json:"max_test_runtime_hours,omitempty"`
	// The number of consecutive test passes to close the alert.
	NumPassesToDisableAlert int32 `protobuf:"varint,38,opt,name=num_passes_to_disable_alert,json=numPassesToDisableAlert,proto3" json:"num_passes_to_disable_alert,omitempty"`
	// Numeric property metric value to be used for short text. If this property
	// is present, it will override all the other short text values.
	ShortTextMetric string `protobuf:"bytes,43,opt,name=short_text_metric,json=shortTextMetric,proto3" json:"short_text_metric,omitempty"`
	// If true, instead of updating the group, read the state proto from storage
	// and update summary, alerts, etc. from that state.
	// This only applies to test group state, not bug state for a test group.
	// This assumes that the state proto is updated through other means (another
	// updater, manually, etc).
	ReadStateFromStorage bool     `protobuf:"varint,52,opt,name=read_state_from_storage,json=readStateFromStorage,proto3" json:"read_state_from_storage,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TestGroup) Reset()         { *m = TestGroup{} }
func (m *TestGroup) String() string { return proto.CompactTextString(m) }
func (*TestGroup) ProtoMessage()    {}
func (*TestGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{2}
}

func (m *TestGroup) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestGroup.Unmarshal(m, b)
}
func (m *TestGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestGroup.Marshal(b, m, deterministic)
}
func (m *TestGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestGroup.Merge(m, src)
}
func (m *TestGroup) XXX_Size() int {
	return xxx_messageInfo_TestGroup.Size(m)
}
func (m *TestGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_TestGroup.DiscardUnknown(m)
}

var xxx_messageInfo_TestGroup proto.InternalMessageInfo

func (m *TestGroup) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *TestGroup) GetGcsPrefix() string {
	if m != nil {
		return m.GcsPrefix
	}
	return ""
}

func (m *TestGroup) GetDaysOfResults() int32 {
	if m != nil {
		return m.DaysOfResults
	}
	return 0
}

func (m *TestGroup) GetIgnorePending() bool {
	if m != nil {
		return m.IgnorePending
	}
	return false
}

func (m *TestGroup) GetTestsNamePolicy() TestGroup_TestsName {
	if m != nil {
		return m.TestsNamePolicy
	}
	return TestGroup_TESTS_NAME_MIN
}

func (m *TestGroup) GetColumnHeader() []*TestGroup_ColumnHeader {
	if m != nil {
		return m.ColumnHeader
	}
	return nil
}

func (m *TestGroup) GetAlertStaleResultsHours() int32 {
	if m != nil {
		return m.AlertStaleResultsHours
	}
	return 0
}

func (m *TestGroup) GetNumFailuresToAlert() int32 {
	if m != nil {
		return m.NumFailuresToAlert
	}
	return 0
}

func (m *TestGroup) GetCodeSearchPath() string {
	if m != nil {
		return m.CodeSearchPath
	}
	return ""
}

func (m *TestGroup) GetNumColumnsRecent() int32 {
	if m != nil {
		return m.NumColumnsRecent
	}
	return 0
}

func (m *TestGroup) GetUseKubernetesClient() bool {
	if m != nil {
		return m.UseKubernetesClient
	}
	return false
}

func (m *TestGroup) GetIsExternal() bool {
	if m != nil {
		return m.IsExternal
	}
	return false
}

func (m *TestGroup) GetTestNameConfig() *TestNameConfig {
	if m != nil {
		return m.TestNameConfig
	}
	return nil
}

func (m *TestGroup) GetNotifications() []*Notification {
	if m != nil {
		return m.Notifications
	}
	return nil
}

func (m *TestGroup) GetMaxTestRuntimeHours() int32 {
	if m != nil {
		return m.MaxTestRuntimeHours
	}
	return 0
}

func (m *TestGroup) GetNumPassesToDisableAlert() int32 {
	if m != nil {
		return m.NumPassesToDisableAlert
	}
	return 0
}

func (m *TestGroup) GetShortTextMetric() string {
	if m != nil {
		return m.ShortTextMetric
	}
	return ""
}

func (m *TestGroup) GetReadStateFromStorage() bool {
	if m != nil {
		return m.ReadStateFromStorage
	}
	return false
}

// Custom column headers for defining extra column-heading rows from values in
// the test result.
type TestGroup_ColumnHeader struct {
	ConfigurationValue   string   `protobuf:"bytes,3,opt,name=configuration_value,json=configurationValue,proto3" json:"configuration_value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TestGroup_ColumnHeader) Reset()         { *m = TestGroup_ColumnHeader{} }
func (m *TestGroup_ColumnHeader) String() string { return proto.CompactTextString(m) }
func (*TestGroup_ColumnHeader) ProtoMessage()    {}
func (*TestGroup_ColumnHeader) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{2, 0}
}

func (m *TestGroup_ColumnHeader) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestGroup_ColumnHeader.Unmarshal(m, b)
}
func (m *TestGroup_ColumnHeader) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestGroup_ColumnHeader.Marshal(b, m, deterministic)
}
func (m *TestGroup_ColumnHeader) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestGroup_ColumnHeader.Merge(m, src)
}
func (m *TestGroup_ColumnHeader) XXX_Size() int {
	return xxx_messageInfo_TestGroup_ColumnHeader.Size(m)
}
func (m *TestGroup_ColumnHeader) XXX_DiscardUnknown() {
	xxx_messageInfo_TestGroup_ColumnHeader.DiscardUnknown(m)
}

var xxx_messageInfo_TestGroup_ColumnHeader proto.InternalMessageInfo

func (m *TestGroup_ColumnHeader) GetConfigurationValue() string {
	if m != nil {
		return m.ConfigurationValue
	}
	return ""
}

// Specifies a dashboard.
type Dashboard struct {
	// A list of the tabs on the dashboard.
	DashboardTab []*DashboardTab `protobuf:"bytes,1,rep,name=dashboard_tab,json=dashboardTab,proto3" json:"dashboard_tab,omitempty"`
	// A name for the Dashboard.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// A list of notifications attached to this dashboard.
	// This is displayed on any dashboard tab in this dashboard.
	Notifications []*Notification `protobuf:"bytes,3,rep,name=notifications,proto3" json:"notifications,omitempty"`
	// Control which tab is displayed when first opening a dashboard.
	// Defaults to Summary
	DefaultTab           string   `protobuf:"bytes,5,opt,name=default_tab,json=defaultTab,proto3" json:"default_tab,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Dashboard) Reset()         { *m = Dashboard{} }
func (m *Dashboard) String() string { return proto.CompactTextString(m) }
func (*Dashboard) ProtoMessage()    {}
func (*Dashboard) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{3}
}

func (m *Dashboard) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Dashboard.Unmarshal(m, b)
}
func (m *Dashboard) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Dashboard.Marshal(b, m, deterministic)
}
func (m *Dashboard) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Dashboard.Merge(m, src)
}
func (m *Dashboard) XXX_Size() int {
	return xxx_messageInfo_Dashboard.Size(m)
}
func (m *Dashboard) XXX_DiscardUnknown() {
	xxx_messageInfo_Dashboard.DiscardUnknown(m)
}

var xxx_messageInfo_Dashboard proto.InternalMessageInfo

func (m *Dashboard) GetDashboardTab() []*DashboardTab {
	if m != nil {
		return m.DashboardTab
	}
	return nil
}

func (m *Dashboard) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Dashboard) GetNotifications() []*Notification {
	if m != nil {
		return m.Notifications
	}
	return nil
}

func (m *Dashboard) GetDefaultTab() string {
	if m != nil {
		return m.DefaultTab
	}
	return ""
}

type LinkTemplate struct {
	// The URL template.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// The options templates.
	Options              []*LinkOptionsTemplate `protobuf:"bytes,2,rep,name=options,proto3" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *LinkTemplate) Reset()         { *m = LinkTemplate{} }
func (m *LinkTemplate) String() string { return proto.CompactTextString(m) }
func (*LinkTemplate) ProtoMessage()    {}
func (*LinkTemplate) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{4}
}

func (m *LinkTemplate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LinkTemplate.Unmarshal(m, b)
}
func (m *LinkTemplate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LinkTemplate.Marshal(b, m, deterministic)
}
func (m *LinkTemplate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LinkTemplate.Merge(m, src)
}
func (m *LinkTemplate) XXX_Size() int {
	return xxx_messageInfo_LinkTemplate.Size(m)
}
func (m *LinkTemplate) XXX_DiscardUnknown() {
	xxx_messageInfo_LinkTemplate.DiscardUnknown(m)
}

var xxx_messageInfo_LinkTemplate proto.InternalMessageInfo

func (m *LinkTemplate) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *LinkTemplate) GetOptions() []*LinkOptionsTemplate {
	if m != nil {
		return m.Options
	}
	return nil
}

// A simple key/value pair for link options.
type LinkOptionsTemplate struct {
	// The key for the option. This is not expanded.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The value for the option. This is expanded the same as the LinkTemplate.
	Value                string   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LinkOptionsTemplate) Reset()         { *m = LinkOptionsTemplate{} }
func (m *LinkOptionsTemplate) String() string { return proto.CompactTextString(m) }
func (*LinkOptionsTemplate) ProtoMessage()    {}
func (*LinkOptionsTemplate) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{5}
}

func (m *LinkOptionsTemplate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LinkOptionsTemplate.Unmarshal(m, b)
}
func (m *LinkOptionsTemplate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LinkOptionsTemplate.Marshal(b, m, deterministic)
}
func (m *LinkOptionsTemplate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LinkOptionsTemplate.Merge(m, src)
}
func (m *LinkOptionsTemplate) XXX_Size() int {
	return xxx_messageInfo_LinkOptionsTemplate.Size(m)
}
func (m *LinkOptionsTemplate) XXX_DiscardUnknown() {
	xxx_messageInfo_LinkOptionsTemplate.DiscardUnknown(m)
}

var xxx_messageInfo_LinkOptionsTemplate proto.InternalMessageInfo

func (m *LinkOptionsTemplate) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *LinkOptionsTemplate) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// A single tab on a dashboard.
type DashboardTab struct {
	// The name of the dashboard tab to display in the client.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The name of the TestGroup specifying the test results for this tab.
	TestGroupName string `protobuf:"bytes,2,opt,name=test_group_name,json=testGroupName,proto3" json:"test_group_name,omitempty"`
	// Default bug component for manually filing bugs from the dashboard
	BugComponent int32 `protobuf:"varint,3,opt,name=bug_component,json=bugComponent,proto3" json:"bug_component,omitempty"`
	// Default code search path for searching regressions. This value overrides
	// the default in the TestGroup config so that dashboards may be customized
	// separately.
	CodeSearchPath string `protobuf:"bytes,4,opt,name=code_search_path,json=codeSearchPath,proto3" json:"code_search_path,omitempty"`
	// See TestGroup.num_columns_recent. This value overrides the default in the
	// TestGroup config so that dashboards may be customized separately.
	NumColumnsRecent int32 `protobuf:"varint,5,opt,name=num_columns_recent,json=numColumnsRecent,proto3" json:"num_columns_recent,omitempty"`
	// Base options to always include, for example:
	// width=20&include-filter-by-regex=level_tests
	// This is taken from the #fragment part of the testgrid url.
	// Best way to create these is to setup the options on testgrid and then
	// copy the #fragment part.
	BaseOptions string `protobuf:"bytes,6,opt,name=base_options,json=baseOptions,proto3" json:"base_options,omitempty"`
	// The URL template to visit after clicking on a cell.
	OpenTestTemplate *LinkTemplate `protobuf:"bytes,7,opt,name=open_test_template,json=openTestTemplate,proto3" json:"open_test_template,omitempty"`
	// The URL template to visit when filing a bug.
	FileBugTemplate *LinkTemplate `protobuf:"bytes,8,opt,name=file_bug_template,json=fileBugTemplate,proto3" json:"file_bug_template,omitempty"`
	// The URL template to visit when attaching a bug
	AttachBugTemplate *LinkTemplate `protobuf:"bytes,9,opt,name=attach_bug_template,json=attachBugTemplate,proto3" json:"attach_bug_template,omitempty"`
	// Text to show in the about menu as a link to another view of the results.
	ResultsText string `protobuf:"bytes,10,opt,name=results_text,json=resultsText,proto3" json:"results_text,omitempty"`
	// The URL template to visit after clicking.
	ResultsUrlTemplate *LinkTemplate `protobuf:"bytes,11,opt,name=results_url_template,json=resultsUrlTemplate,proto3" json:"results_url_template,omitempty"`
	// The URL template to visit when searching for changelists.
	CodeSearchUrlTemplate *LinkTemplate `protobuf:"bytes,12,opt,name=code_search_url_template,json=codeSearchUrlTemplate,proto3" json:"code_search_url_template,omitempty"`
	// A description paragraph to be displayed.
	Description string `protobuf:"bytes,13,opt,name=description,proto3" json:"description,omitempty"`
	// Configuration options for dashboard tab alerts.
	AlertOptions *DashboardTabAlertOptions `protobuf:"bytes,15,opt,name=alert_options,json=alertOptions,proto3" json:"alert_options,omitempty"`
	// The URL template to visit when viewing an associated bug.
	OpenBugTemplate      *LinkTemplate `protobuf:"bytes,17,opt,name=open_bug_template,json=openBugTemplate,proto3" json:"open_bug_template,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *DashboardTab) Reset()         { *m = DashboardTab{} }
func (m *DashboardTab) String() string { return proto.CompactTextString(m) }
func (*DashboardTab) ProtoMessage()    {}
func (*DashboardTab) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{6}
}

func (m *DashboardTab) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DashboardTab.Unmarshal(m, b)
}
func (m *DashboardTab) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DashboardTab.Marshal(b, m, deterministic)
}
func (m *DashboardTab) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DashboardTab.Merge(m, src)
}
func (m *DashboardTab) XXX_Size() int {
	return xxx_messageInfo_DashboardTab.Size(m)
}
func (m *DashboardTab) XXX_DiscardUnknown() {
	xxx_messageInfo_DashboardTab.DiscardUnknown(m)
}

var xxx_messageInfo_DashboardTab proto.InternalMessageInfo

func (m *DashboardTab) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DashboardTab) GetTestGroupName() string {
	if m != nil {
		return m.TestGroupName
	}
	return ""
}

func (m *DashboardTab) GetBugComponent() int32 {
	if m != nil {
		return m.BugComponent
	}
	return 0
}

func (m *DashboardTab) GetCodeSearchPath() string {
	if m != nil {
		return m.CodeSearchPath
	}
	return ""
}

func (m *DashboardTab) GetNumColumnsRecent() int32 {
	if m != nil {
		return m.NumColumnsRecent
	}
	return 0
}

func (m *DashboardTab) GetBaseOptions() string {
	if m != nil {
		return m.BaseOptions
	}
	return ""
}

func (m *DashboardTab) GetOpenTestTemplate() *LinkTemplate {
	if m != nil {
		return m.OpenTestTemplate
	}
	return nil
}

func (m *DashboardTab) GetFileBugTemplate() *LinkTemplate {
	if m != nil {
		return m.FileBugTemplate
	}
	return nil
}

func (m *DashboardTab) GetAttachBugTemplate() *LinkTemplate {
	if m != nil {
		return m.AttachBugTemplate
	}
	return nil
}

func (m *DashboardTab) GetResultsText() string {
	if m != nil {
		return m.ResultsText
	}
	return ""
}

func (m *DashboardTab) GetResultsUrlTemplate() *LinkTemplate {
	if m != nil {
		return m.ResultsUrlTemplate
	}
	return nil
}

func (m *DashboardTab) GetCodeSearchUrlTemplate() *LinkTemplate {
	if m != nil {
		return m.CodeSearchUrlTemplate
	}
	return nil
}

func (m *DashboardTab) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *DashboardTab) GetAlertOptions() *DashboardTabAlertOptions {
	if m != nil {
		return m.AlertOptions
	}
	return nil
}

func (m *DashboardTab) GetOpenBugTemplate() *LinkTemplate {
	if m != nil {
		return m.OpenBugTemplate
	}
	return nil
}

// Configuration options for dashboard tab alerts.
type DashboardTabAlertOptions struct {
	// Time in hours before an alert will be added to a test results table if the
	// run date of the latest results are older than this time.  If zero, no
	// alerts are raised.
	AlertStaleResultsHours int32 `protobuf:"varint,1,opt,name=alert_stale_results_hours,json=alertStaleResultsHours,proto3" json:"alert_stale_results_hours,omitempty"`
	// The number of consecutive test result failures to see before alerting of
	// a consistent failure. If zero, no alerts are raised.
	NumFailuresToAlert int32 `protobuf:"varint,2,opt,name=num_failures_to_alert,json=numFailuresToAlert,proto3" json:"num_failures_to_alert,omitempty"`
	// The comma-separated addresses to send mail.
	AlertMailToAddresses string `protobuf:"bytes,3,opt,name=alert_mail_to_addresses,json=alertMailToAddresses,proto3" json:"alert_mail_to_addresses,omitempty"`
	// The number of consecutive test passes to close the alert.
	NumPassesToDisableAlert int32 `protobuf:"varint,4,opt,name=num_passes_to_disable_alert,json=numPassesToDisableAlert,proto3" json:"num_passes_to_disable_alert,omitempty"`
	// Custom subject for alert mails.
	Subject string `protobuf:"bytes,5,opt,name=subject,proto3" json:"subject,omitempty"`
	// Custom link for further help/instructions on debugging this alert.
	DebugUrl string `protobuf:"bytes,6,opt,name=debug_url,json=debugUrl,proto3" json:"debug_url,omitempty"`
	// Custom text to show for the debug link.
	DebugMessage         string   `protobuf:"bytes,7,opt,name=debug_message,json=debugMessage,proto3" json:"debug_message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DashboardTabAlertOptions) Reset()         { *m = DashboardTabAlertOptions{} }
func (m *DashboardTabAlertOptions) String() string { return proto.CompactTextString(m) }
func (*DashboardTabAlertOptions) ProtoMessage()    {}
func (*DashboardTabAlertOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{7}
}

func (m *DashboardTabAlertOptions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DashboardTabAlertOptions.Unmarshal(m, b)
}
func (m *DashboardTabAlertOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DashboardTabAlertOptions.Marshal(b, m, deterministic)
}
func (m *DashboardTabAlertOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DashboardTabAlertOptions.Merge(m, src)
}
func (m *DashboardTabAlertOptions) XXX_Size() int {
	return xxx_messageInfo_DashboardTabAlertOptions.Size(m)
}
func (m *DashboardTabAlertOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_DashboardTabAlertOptions.DiscardUnknown(m)
}

var xxx_messageInfo_DashboardTabAlertOptions proto.InternalMessageInfo

func (m *DashboardTabAlertOptions) GetAlertStaleResultsHours() int32 {
	if m != nil {
		return m.AlertStaleResultsHours
	}
	return 0
}

func (m *DashboardTabAlertOptions) GetNumFailuresToAlert() int32 {
	if m != nil {
		return m.NumFailuresToAlert
	}
	return 0
}

func (m *DashboardTabAlertOptions) GetAlertMailToAddresses() string {
	if m != nil {
		return m.AlertMailToAddresses
	}
	return ""
}

func (m *DashboardTabAlertOptions) GetNumPassesToDisableAlert() int32 {
	if m != nil {
		return m.NumPassesToDisableAlert
	}
	return 0
}

func (m *DashboardTabAlertOptions) GetSubject() string {
	if m != nil {
		return m.Subject
	}
	return ""
}

func (m *DashboardTabAlertOptions) GetDebugUrl() string {
	if m != nil {
		return m.DebugUrl
	}
	return ""
}

func (m *DashboardTabAlertOptions) GetDebugMessage() string {
	if m != nil {
		return m.DebugMessage
	}
	return ""
}

// Specifies a dashboard group.
type DashboardGroup struct {
	// The name for the dashboard group.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A list of names specifying dashboards to show links to in a separate tabbed
	// bar at the top of the page for each of the given dashboards.
	DashboardNames       []string `protobuf:"bytes,2,rep,name=dashboard_names,json=dashboardNames,proto3" json:"dashboard_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DashboardGroup) Reset()         { *m = DashboardGroup{} }
func (m *DashboardGroup) String() string { return proto.CompactTextString(m) }
func (*DashboardGroup) ProtoMessage()    {}
func (*DashboardGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{8}
}

func (m *DashboardGroup) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DashboardGroup.Unmarshal(m, b)
}
func (m *DashboardGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DashboardGroup.Marshal(b, m, deterministic)
}
func (m *DashboardGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DashboardGroup.Merge(m, src)
}
func (m *DashboardGroup) XXX_Size() int {
	return xxx_messageInfo_DashboardGroup.Size(m)
}
func (m *DashboardGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_DashboardGroup.DiscardUnknown(m)
}

var xxx_messageInfo_DashboardGroup proto.InternalMessageInfo

func (m *DashboardGroup) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DashboardGroup) GetDashboardNames() []string {
	if m != nil {
		return m.DashboardNames
	}
	return nil
}

// A service configuration consisting of multiple test groups and dashboards.
type Configuration struct {
	// A list of groups of tests to gather.
	TestGroups []*TestGroup `protobuf:"bytes,1,rep,name=test_groups,json=testGroups,proto3" json:"test_groups,omitempty"`
	// A list of all of the dashboards for a server.
	Dashboards []*Dashboard `protobuf:"bytes,2,rep,name=dashboards,proto3" json:"dashboards,omitempty"`
	// A list of all the dashboard groups for a server.
	DashboardGroups      []*DashboardGroup `protobuf:"bytes,3,rep,name=dashboard_groups,json=dashboardGroups,proto3" json:"dashboard_groups,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Configuration) Reset()         { *m = Configuration{} }
func (m *Configuration) String() string { return proto.CompactTextString(m) }
func (*Configuration) ProtoMessage()    {}
func (*Configuration) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{9}
}

func (m *Configuration) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Configuration.Unmarshal(m, b)
}
func (m *Configuration) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Configuration.Marshal(b, m, deterministic)
}
func (m *Configuration) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Configuration.Merge(m, src)
}
func (m *Configuration) XXX_Size() int {
	return xxx_messageInfo_Configuration.Size(m)
}
func (m *Configuration) XXX_DiscardUnknown() {
	xxx_messageInfo_Configuration.DiscardUnknown(m)
}

var xxx_messageInfo_Configuration proto.InternalMessageInfo

func (m *Configuration) GetTestGroups() []*TestGroup {
	if m != nil {
		return m.TestGroups
	}
	return nil
}

func (m *Configuration) GetDashboards() []*Dashboard {
	if m != nil {
		return m.Dashboards
	}
	return nil
}

func (m *Configuration) GetDashboardGroups() []*DashboardGroup {
	if m != nil {
		return m.DashboardGroups
	}
	return nil
}

type DefaultConfiguration struct {
	// A default testgroup with default initialization data
	DefaultTestGroup *TestGroup `protobuf:"bytes,1,opt,name=default_test_group,json=defaultTestGroup,proto3" json:"default_test_group,omitempty"`
	// A default dashboard tab with default initialization data
	DefaultDashboardTab  *DashboardTab `protobuf:"bytes,2,opt,name=default_dashboard_tab,json=defaultDashboardTab,proto3" json:"default_dashboard_tab,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *DefaultConfiguration) Reset()         { *m = DefaultConfiguration{} }
func (m *DefaultConfiguration) String() string { return proto.CompactTextString(m) }
func (*DefaultConfiguration) ProtoMessage()    {}
func (*DefaultConfiguration) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{10}
}

func (m *DefaultConfiguration) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DefaultConfiguration.Unmarshal(m, b)
}
func (m *DefaultConfiguration) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DefaultConfiguration.Marshal(b, m, deterministic)
}
func (m *DefaultConfiguration) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DefaultConfiguration.Merge(m, src)
}
func (m *DefaultConfiguration) XXX_Size() int {
	return xxx_messageInfo_DefaultConfiguration.Size(m)
}
func (m *DefaultConfiguration) XXX_DiscardUnknown() {
	xxx_messageInfo_DefaultConfiguration.DiscardUnknown(m)
}

var xxx_messageInfo_DefaultConfiguration proto.InternalMessageInfo

func (m *DefaultConfiguration) GetDefaultTestGroup() *TestGroup {
	if m != nil {
		return m.DefaultTestGroup
	}
	return nil
}

func (m *DefaultConfiguration) GetDefaultDashboardTab() *DashboardTab {
	if m != nil {
		return m.DefaultDashboardTab
	}
	return nil
}

func init() {
	proto.RegisterEnum("TestGroup_TestsName", TestGroup_TestsName_name, TestGroup_TestsName_value)
	proto.RegisterType((*TestNameConfig)(nil), "TestNameConfig")
	proto.RegisterType((*TestNameConfig_NameElement)(nil), "TestNameConfig.NameElement")
	proto.RegisterType((*Notification)(nil), "Notification")
	proto.RegisterType((*TestGroup)(nil), "TestGroup")
	proto.RegisterType((*TestGroup_ColumnHeader)(nil), "TestGroup.ColumnHeader")
	proto.RegisterType((*Dashboard)(nil), "Dashboard")
	proto.RegisterType((*LinkTemplate)(nil), "LinkTemplate")
	proto.RegisterType((*LinkOptionsTemplate)(nil), "LinkOptionsTemplate")
	proto.RegisterType((*DashboardTab)(nil), "DashboardTab")
	proto.RegisterType((*DashboardTabAlertOptions)(nil), "DashboardTabAlertOptions")
	proto.RegisterType((*DashboardGroup)(nil), "DashboardGroup")
	proto.RegisterType((*Configuration)(nil), "Configuration")
	proto.RegisterType((*DefaultConfiguration)(nil), "DefaultConfiguration")
}

func init() { proto.RegisterFile("config.proto", fileDescriptor_3eaf2c85e69e9ea4) }

var fileDescriptor_3eaf2c85e69e9ea4 = []byte{
	// 1434 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x57, 0xdb, 0x72, 0xd3, 0xc6,
	0x1b, 0xff, 0xcb, 0x51, 0x12, 0xf9, 0xb3, 0x64, 0x2b, 0x9b, 0x84, 0x08, 0xf2, 0xef, 0x10, 0xcc,
	0x00, 0x19, 0x60, 0xdc, 0x69, 0x80, 0x99, 0xd2, 0x42, 0x4b, 0x9a, 0x38, 0x80, 0x21, 0xc1, 0xa3,
	0x98, 0xde, 0xee, 0xac, 0xe5, 0xb5, 0xad, 0x46, 0x07, 0xcf, 0xee, 0xaa, 0x13, 0x9e, 0xa3, 0xaf,
	0xd0, 0xfb, 0x5e, 0xf7, 0x4d, 0xda, 0x17, 0xe9, 0x75, 0x67, 0x77, 0x25, 0x59, 0xa6, 0x0e, 0x3d,
	0xdc, 0x69, 0x7f, 0xdf, 0x61, 0xf7, 0x3b, 0xec, 0xef, 0x5b, 0x81, 0x1d, 0xa4, 0xc9, 0x38, 0x9c,
	0x74, 0x66, 0x2c, 0x15, 0x69, 0xfb, 0x57, 0x03, 0x9a, 0x03, 0xca, 0xc5, 0x19, 0x89, 0xe9, 0x91,
	0x12, 0xa0, 0x17, 0xe0, 0x24, 0x24, 0xa6, 0x98, 0x46, 0x34, 0xa6, 0x89, 0xe0, 0x9e, 0xb1, 0xb7,
	0xb2, 0xdf, 0x38, 0xd8, 0xed, 0x2c, 0xea, 0x75, 0xe4, 0x67, 0x57, 0xeb, 0xf8, 0x76, 0x32, 0x5f,
	0x70, 0x74, 0x13, 0x1a, 0xca, 0xc3, 0x38, 0x65, 0x31, 0x11, 0x5e, 0x6d, 0xcf, 0xd8, 0xaf, 0xfb,
	0x20, 0xa1, 0x13, 0x85, 0xdc, 0x38, 0x86, 0x46, 0xc5, 0x1a, 0xdd, 0x06, 0x47, 0x10, 0x36, 0xa1,
	0x02, 0xeb, 0xb3, 0xe5, 0x16, 0xb6, 0x06, 0xf5, 0x76, 0x3d, 0xd3, 0x32, 0xdc, 0x5a, 0xcf, 0xb4,
	0x56, 0x5c, 0xb3, 0x67, 0x5a, 0xa6, 0xbb, 0xda, 0x7e, 0x03, 0xf6, 0x59, 0x2a, 0xc2, 0x71, 0x18,
	0x10, 0x11, 0xa6, 0x09, 0xf2, 0x60, 0x9d, 0x67, 0x71, 0x4c, 0xd8, 0x07, 0xcf, 0x50, 0x0e, 0x8a,
	0x25, 0xba, 0xa5, 0xa2, 0x16, 0xf4, 0x52, 0xe0, 0x28, 0x4c, 0x2e, 0x72, 0xff, 0x8d, 0x1c, 0x7b,
	0x1b, 0x26, 0x17, 0xed, 0xdf, 0x2c, 0xa8, 0xcb, 0x00, 0x5f, 0xb2, 0x34, 0x9b, 0x21, 0x04, 0xa6,
	0x3c, 0x6e, 0xee, 0x47, 0x7d, 0xa3, 0xcf, 0x00, 0x26, 0x01, 0xc7, 0x33, 0x46, 0xc7, 0xe1, 0x65,
	0xee, 0xa2, 0x3e, 0x09, 0x78, 0x5f, 0x01, 0xe8, 0x2e, 0xb4, 0x46, 0xe4, 0x03, 0xc7, 0xe9, 0x18,
	0x33, 0xca, 0xb3, 0x48, 0x70, 0x6f, 0x65, 0xcf, 0xd8, 0x5f, 0xf5, 0x1d, 0x09, 0xbf, 0x1b, 0xfb,
	0x1a, 0x44, 0x77, 0xa0, 0x19, 0x4e, 0x92, 0x94, 0x51, 0x3c, 0xa3, 0xc9, 0x28, 0x4c, 0x26, 0x9e,
	0xb9, 0x67, 0xec, 0x5b, 0xbe, 0xa3, 0xd1, 0xbe, 0x06, 0xd1, 0x0b, 0xd8, 0x10, 0x94, 0x0b, 0x8e,
	0x55, 0x26, 0x67, 0x69, 0x14, 0x06, 0x1f, 0xbc, 0xb5, 0x3d, 0x63, 0xbf, 0x79, 0xb0, 0xd5, 0x29,
	0x0f, 0xaa, 0xbe, 0xb8, 0xcc, 0xa5, 0xdf, 0x12, 0xc5, 0x67, 0x5f, 0x29, 0xa3, 0x67, 0xe0, 0x04,
	0x69, 0x94, 0xc5, 0x09, 0x9e, 0x52, 0x32, 0xa2, 0xcc, 0xab, 0xab, 0x3a, 0xee, 0x54, 0xac, 0x8f,
	0x94, 0xfc, 0x95, 0x12, 0xfb, 0x76, 0x50, 0x59, 0xa1, 0xa7, 0x70, 0x9d, 0x44, 0x94, 0x09, 0xcc,
	0x05, 0x89, 0x68, 0x11, 0x12, 0x9e, 0xa6, 0x19, 0xe3, 0x5e, 0x43, 0x05, 0x76, 0x4d, 0x29, 0x9c,
	0x4b, 0x79, 0x1e, 0xdc, 0x2b, 0x29, 0x45, 0x5f, 0xc0, 0x76, 0x92, 0xc5, 0x78, 0x4c, 0xc2, 0x28,
	0x63, 0x94, 0x63, 0x91, 0x62, 0xa5, 0xe9, 0xd9, 0xca, 0x0c, 0x25, 0x59, 0x7c, 0x92, 0xcb, 0x06,
	0xe9, 0xa1, 0x94, 0xa0, 0x7d, 0x70, 0x83, 0x74, 0x44, 0x31, 0xa7, 0x84, 0x05, 0x53, 0x3c, 0x23,
	0x62, 0xea, 0x35, 0x55, 0x86, 0x9b, 0x12, 0x3f, 0x57, 0x70, 0x9f, 0x88, 0x29, 0x7a, 0x08, 0xd2,
	0x1e, 0xeb, 0xb3, 0x72, 0xcc, 0x68, 0x40, 0x13, 0xe1, 0xb5, 0x94, 0x67, 0x37, 0xc9, 0x62, 0x1d,
	0x12, 0xf7, 0x15, 0x8e, 0x0e, 0x60, 0x3b, 0xe3, 0x14, 0x5f, 0x64, 0x43, 0xca, 0x12, 0x2a, 0x28,
	0xc7, 0x41, 0x14, 0x4a, 0x03, 0x4f, 0xe5, 0x7c, 0x33, 0xe3, 0xf4, 0x4d, 0x29, 0x3b, 0x52, 0x22,
	0xd9, 0xbd, 0x21, 0xc7, 0xf4, 0x52, 0x50, 0x96, 0x90, 0xc8, 0xbb, 0xae, 0x34, 0x21, 0xe4, 0xdd,
	0x1c, 0x41, 0x4f, 0xc1, 0x95, 0xb9, 0xd6, 0x95, 0xc9, 0x3b, 0xf6, 0xc6, 0x9e, 0xb1, 0xdf, 0x38,
	0x68, 0x7d, 0x74, 0x47, 0xfc, 0xa6, 0x58, 0xbc, 0x5b, 0x8f, 0xc0, 0x49, 0x2a, 0x2d, 0xcb, 0xbd,
	0x5d, 0x55, 0x13, 0xa7, 0x53, 0x6d, 0x64, 0x7f, 0x51, 0x07, 0x3d, 0x82, 0x6b, 0x31, 0xb9, 0xc4,
	0x6a, 0x4f, 0x96, 0x25, 0x22, 0x8c, 0x69, 0x5e, 0x87, 0x3b, 0x2a, 0xec, 0xcd, 0x98, 0x5c, 0xca,
	0x7d, 0x7d, 0x2d, 0xd3, 0x45, 0x78, 0x06, 0xbb, 0x32, 0x4f, 0x33, 0xc2, 0xb9, 0x2e, 0xc1, 0x28,
	0xe4, 0x64, 0x18, 0xd1, 0xbc, 0x14, 0x77, 0x95, 0xe5, 0x4e, 0x92, 0xc5, 0x7d, 0xa5, 0x31, 0x48,
	0x8f, 0xb5, 0x5c, 0xd7, 0xe3, 0x3e, 0x6c, 0xf0, 0x69, 0xca, 0x04, 0x56, 0x77, 0x26, 0xa6, 0x82,
	0x85, 0x81, 0xf7, 0x40, 0x15, 0xa4, 0xa5, 0x04, 0x03, 0x7a, 0x29, 0x4e, 0x15, 0x8c, 0x9e, 0xc0,
	0x0e, 0xa3, 0x64, 0x24, 0x1b, 0x45, 0x50, 0x3c, 0x66, 0x69, 0x8c, 0xb9, 0x48, 0x19, 0x99, 0x50,
	0xef, 0xb1, 0xca, 0xdd, 0x96, 0x14, 0x9f, 0x4b, 0xe9, 0x09, 0x4b, 0xe3, 0x73, 0x2d, 0xbb, 0xf1,
	0x06, 0xec, 0x6a, 0xfb, 0xa1, 0xcf, 0x61, 0x53, 0xe7, 0x32, 0x63, 0x2a, 0x6e, 0xfc, 0x23, 0x89,
	0x32, 0xaa, 0xee, 0x50, 0xdd, 0x47, 0x0b, 0xa2, 0xef, 0xa5, 0xa4, 0x24, 0x84, 0x9a, 0xbb, 0xd2,
	0xa6, 0xfa, 0xf2, 0xaa, 0xf6, 0x47, 0x08, 0x9a, 0x83, 0xee, 0xf9, 0xe0, 0x1c, 0x9f, 0x1d, 0x9e,
	0x76, 0xf1, 0xe9, 0xeb, 0x33, 0xf7, 0x7f, 0x68, 0x1b, 0x36, 0x2a, 0xd8, 0xeb, 0x97, 0x67, 0xef,
	0xfc, 0xae, 0x6b, 0xa0, 0x6b, 0x80, 0x2a, 0xb0, 0xdf, 0xed, 0xbf, 0x3d, 0x3c, 0xea, 0xba, 0xb5,
	0x8f, 0xd4, 0x0f, 0xfb, 0xfd, 0xee, 0xd9, 0xb1, 0xbb, 0xd2, 0x33, 0xad, 0x55, 0x77, 0xad, 0x67,
	0x5a, 0xeb, 0xae, 0xd5, 0x33, 0x2d, 0xcb, 0xad, 0xf7, 0x4c, 0x0b, 0xdc, 0x46, 0xcf, 0xb4, 0x1c,
	0xb7, 0xd9, 0x33, 0x2d, 0xd7, 0xf5, 0x7a, 0xa6, 0xf5, 0x7f, 0xf7, 0x4e, 0xcf, 0xb4, 0xee, 0xb9,
	0x0f, 0x7a, 0xa6, 0xf5, 0xd0, 0x7d, 0xdc, 0xfe, 0xc5, 0x80, 0xfa, 0x31, 0xe1, 0xd3, 0x61, 0x4a,
	0xd8, 0x08, 0x1d, 0x80, 0x33, 0x2a, 0x16, 0x58, 0x90, 0x61, 0x4e, 0xaf, 0x4e, 0xa7, 0x54, 0x19,
	0x90, 0xa1, 0x6f, 0x8f, 0x2a, 0xab, 0x92, 0x8e, 0x6a, 0x15, 0x3a, 0xfa, 0x4b, 0x2b, 0xad, 0xfc,
	0x83, 0x56, 0xba, 0x09, 0x8d, 0x11, 0x1d, 0x93, 0x2c, 0x12, 0x6a, 0xeb, 0x55, 0xcd, 0xcc, 0x39,
	0x34, 0x20, 0xc3, 0x9c, 0x59, 0xfb, 0x60, 0x4b, 0x52, 0x1c, 0xd0, 0x78, 0x16, 0x11, 0x41, 0x91,
	0x0b, 0x2b, 0x19, 0x8b, 0x72, 0x36, 0x94, 0x9f, 0xa8, 0x03, 0xeb, 0xe9, 0x4c, 0xef, 0x5b, 0x53,
	0xfb, 0x6e, 0x75, 0xa4, 0xc5, 0x3b, 0x8d, 0x15, 0x86, 0x7e, 0xa1, 0xd4, 0x7e, 0x0e, 0x9b, 0x4b,
	0xe4, 0xd2, 0xf1, 0x05, 0x2d, 0xe8, 0x5a, 0x7e, 0xa2, 0x2d, 0x58, 0xd5, 0x85, 0xd7, 0xb1, 0xea,
	0x45, 0xfb, 0x8f, 0x55, 0xb0, 0x8f, 0x97, 0x65, 0xa4, 0x4a, 0xd0, 0x77, 0x41, 0x71, 0x20, 0x9e,
	0x48, 0x6e, 0xc3, 0x95, 0x84, 0x39, 0xa2, 0x60, 0x3c, 0xd5, 0x1f, 0xb7, 0xc1, 0x19, 0x66, 0x13,
	0x1c, 0xa4, 0xf1, 0x2c, 0x4d, 0x24, 0x19, 0x68, 0x9e, 0xb6, 0x87, 0xd9, 0xe4, 0xa8, 0xc0, 0x96,
	0x32, 0x92, 0xf9, 0x2f, 0x18, 0x69, 0xf5, 0x0a, 0x46, 0xba, 0x05, 0xf6, 0x90, 0x70, 0x8a, 0x8b,
	0xec, 0xad, 0xe9, 0x51, 0x24, 0xb1, 0x3c, 0x39, 0xe8, 0x6b, 0x40, 0xe9, 0x8c, 0x26, 0xfa, 0xc2,
	0x8b, 0x3c, 0x55, 0xde, 0xba, 0x62, 0x18, 0xa7, 0x53, 0x2d, 0x8c, 0xef, 0x4a, 0x45, 0xd9, 0xf9,
	0x65, 0x46, 0x9f, 0xc2, 0xc6, 0x38, 0x8c, 0x28, 0x96, 0x11, 0x96, 0xb6, 0xd6, 0x32, 0xdb, 0x96,
	0xd4, 0xfb, 0x2e, 0x9b, 0x94, 0xa6, 0xcf, 0x61, 0x93, 0x08, 0x41, 0x82, 0xe9, 0xa2, 0x71, 0x7d,
	0x99, 0xf1, 0x86, 0xd6, 0xac, 0x9a, 0xdf, 0x02, 0xbb, 0x98, 0x12, 0x92, 0x35, 0x3c, 0xd0, 0x91,
	0xe5, 0x98, 0x24, 0x0c, 0xf4, 0x2d, 0x6c, 0x15, 0x2a, 0x19, 0x8b, 0xe6, 0x5b, 0x34, 0x96, 0x6d,
	0x81, 0x72, 0xd5, 0xf7, 0x2c, 0x2a, 0xf7, 0x38, 0x01, 0xaf, 0x5a, 0x95, 0x05, 0x27, 0xf6, 0x32,
	0x27, 0xdb, 0xf3, 0x62, 0x55, 0xfd, 0xec, 0xc9, 0x7b, 0xc0, 0x03, 0x16, 0xaa, 0x94, 0x7b, 0x8e,
	0x3e, 0x6a, 0x05, 0x42, 0xdf, 0x80, 0xa3, 0xe7, 0x5f, 0x51, 0xa8, 0x96, 0x72, 0x7f, 0x7d, 0xe1,
	0x9a, 0x2a, 0xb2, 0xcc, 0xcb, 0xe6, 0xdb, 0xa4, 0xb2, 0x92, 0x75, 0x50, 0x45, 0x5c, 0x48, 0xe5,
	0xc6, 0xd2, 0x3a, 0x48, 0xbd, 0x4a, 0x22, 0x7b, 0xa6, 0xd5, 0x74, 0x5b, 0x8a, 0x4d, 0x36, 0xda,
	0xbf, 0xd7, 0xc0, 0xbb, 0x6a, 0xc7, 0x4f, 0xcf, 0x68, 0xe3, 0xbf, 0xcd, 0xe8, 0xda, 0x95, 0x33,
	0xfa, 0x09, 0xec, 0xe8, 0xdd, 0x62, 0x12, 0x46, 0xca, 0x60, 0x34, 0x62, 0x54, 0x0e, 0x8f, 0x9c,
	0xa4, 0xb7, 0x94, 0xf8, 0x94, 0x84, 0xd1, 0x20, 0x3d, 0x2c, 0x64, 0x7f, 0x37, 0x88, 0xcc, 0x4f,
	0x0f, 0x22, 0xf5, 0xa6, 0x1b, 0xfe, 0x40, 0x03, 0x91, 0x93, 0x55, 0xb1, 0x44, 0xbb, 0x50, 0x1f,
	0x51, 0x99, 0x5d, 0xc9, 0x4c, 0xfa, 0x16, 0x59, 0x0a, 0x78, 0xcf, 0x22, 0x79, 0xc5, 0xb5, 0x30,
	0xa6, 0x9c, 0xcb, 0x49, 0xb4, 0xae, 0x5f, 0x94, 0x0a, 0x3c, 0xd5, 0x58, 0xfb, 0x14, 0x9a, 0x65,
	0x6a, 0xaf, 0x7e, 0xf6, 0xdd, 0x93, 0xef, 0xba, 0x82, 0xaf, 0x25, 0xa2, 0x19, 0xaf, 0xee, 0x37,
	0x4b, 0x58, 0xb2, 0x0a, 0x6f, 0xff, 0x6c, 0x80, 0x73, 0x54, 0x1d, 0x53, 0xe8, 0x01, 0x34, 0xe6,
	0x84, 0x54, 0xbc, 0xa3, 0x61, 0xfe, 0xfe, 0xf2, 0xa1, 0x24, 0x26, 0x8e, 0xee, 0x03, 0x94, 0x0e,
	0x0b, 0x52, 0x85, 0x79, 0xb7, 0xf9, 0x15, 0x29, 0xfa, 0x0a, 0xdc, 0xf9, 0x99, 0x72, 0xef, 0x9a,
	0xfe, 0x5b, 0x9d, 0xc5, 0x90, 0xfc, 0xf9, 0xe1, 0xf5, 0x3e, 0xed, 0x9f, 0x0c, 0xd8, 0x3a, 0xd6,
	0x84, 0xbf, 0x78, 0xda, 0x2f, 0x01, 0x95, 0xb3, 0xa1, 0x3c, 0xb5, 0x4a, 0xc5, 0xe2, 0xa1, 0xdd,
	0x62, 0x5c, 0x94, 0xaf, 0xe5, 0x43, 0xd8, 0x2e, 0x2c, 0x17, 0x47, 0x5b, 0x2d, 0xef, 0xf7, 0x85,
	0xd1, 0xb6, 0x99, 0xeb, 0x56, 0xc1, 0xe1, 0x9a, 0xfa, 0x1d, 0x79, 0xf4, 0x67, 0x00, 0x00, 0x00,
	0xff, 0xff, 0xb7, 0x55, 0x75, 0x58, 0x9e, 0x0c, 0x00, 0x00,
}
