/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by protoc-gen-go. DO NOT EDIT.
// source: types.proto

package response

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	config "k8s.io/test-infra/testgrid/config"
	summary "k8s.io/test-infra/testgrid/summary"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// PhaseTimer times the duration of each update cycle.
type PhaseTimer struct {
	Start                int32     `protobuf:"varint,1,opt,name=start,proto3" json:"start,omitempty"`
	Last                 int32     `protobuf:"varint,2,opt,name=last,proto3" json:"last,omitempty"`
	Phases               []string  `protobuf:"bytes,3,rep,name=phases,proto3" json:"phases,omitempty"`
	Delta                []float64 `protobuf:"fixed64,4,rep,packed,name=delta,proto3" json:"delta,omitempty"`
	Total                float64   `protobuf:"fixed64,5,opt,name=total,proto3" json:"total,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *PhaseTimer) Reset()         { *m = PhaseTimer{} }
func (m *PhaseTimer) String() string { return proto.CompactTextString(m) }
func (*PhaseTimer) ProtoMessage()    {}
func (*PhaseTimer) Descriptor() ([]byte, []int) {
	return fileDescriptor_d938547f84707355, []int{0}
}

func (m *PhaseTimer) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PhaseTimer.Unmarshal(m, b)
}
func (m *PhaseTimer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PhaseTimer.Marshal(b, m, deterministic)
}
func (m *PhaseTimer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PhaseTimer.Merge(m, src)
}
func (m *PhaseTimer) XXX_Size() int {
	return xxx_messageInfo_PhaseTimer.Size(m)
}
func (m *PhaseTimer) XXX_DiscardUnknown() {
	xxx_messageInfo_PhaseTimer.DiscardUnknown(m)
}

var xxx_messageInfo_PhaseTimer proto.InternalMessageInfo

func (m *PhaseTimer) GetStart() int32 {
	if m != nil {
		return m.Start
	}
	return 0
}

func (m *PhaseTimer) GetLast() int32 {
	if m != nil {
		return m.Last
	}
	return 0
}

func (m *PhaseTimer) GetPhases() []string {
	if m != nil {
		return m.Phases
	}
	return nil
}

func (m *PhaseTimer) GetDelta() []float64 {
	if m != nil {
		return m.Delta
	}
	return nil
}

func (m *PhaseTimer) GetTotal() float64 {
	if m != nil {
		return m.Total
	}
	return 0
}

type TestAlert struct {
	FailBuildId          string   `protobuf:"bytes,1,opt,name=fail_build_id,json=fail-build-id,proto3" json:"fail_build_id,omitempty"`
	FailCount            int64    `protobuf:"varint,2,opt,name=fail_count,json=fail-count,proto3" json:"fail_count,omitempty"`
	FailTime             int32    `protobuf:"varint,3,opt,name=fail_time,json=fail-time,proto3" json:"fail_time,omitempty"`
	Text                 string   `protobuf:"bytes,4,opt,name=text,proto3" json:"text,omitempty"`
	Message              string   `protobuf:"bytes,5,opt,name=message,proto3" json:"message,omitempty"`
	LinkText             string   `protobuf:"bytes,6,opt,name=link_text,json=link-text,proto3" json:"link_text,omitempty"`
	Link                 string   `protobuf:"bytes,7,opt,name=link,proto3" json:"link,omitempty"`
	UrlText              string   `protobuf:"bytes,8,opt,name=url_text,json=url-text,proto3" json:"url_text,omitempty"`
	TestId               string   `protobuf:"bytes,9,opt,name=test_id,json=test-id,proto3" json:"test_id,omitempty"`
	PassBuildId          string   `protobuf:"bytes,10,opt,name=pass_build_id,json=pass-build-id,proto3" json:"pass_build_id,omitempty"`
	PassCount            int64    `protobuf:"varint,11,opt,name=pass_count,json=pass-count,proto3" json:"pass_count,omitempty"`
	PassTime             int32    `protobuf:"varint,12,opt,name=pass_time,json=pass-time,proto3" json:"pass_time,omitempty"`
	CodeSearchPath       string   `protobuf:"bytes,13,opt,name=code_search_path,json=code-search-path,proto3" json:"code_search_path,omitempty"`
	TestName             string   `protobuf:"bytes,14,opt,name=test_name,json=test-name,proto3" json:"test_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TestAlert) Reset()         { *m = TestAlert{} }
func (m *TestAlert) String() string { return proto.CompactTextString(m) }
func (*TestAlert) ProtoMessage()    {}
func (*TestAlert) Descriptor() ([]byte, []int) {
	return fileDescriptor_d938547f84707355, []int{1}
}

func (m *TestAlert) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestAlert.Unmarshal(m, b)
}
func (m *TestAlert) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestAlert.Marshal(b, m, deterministic)
}
func (m *TestAlert) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestAlert.Merge(m, src)
}
func (m *TestAlert) XXX_Size() int {
	return xxx_messageInfo_TestAlert.Size(m)
}
func (m *TestAlert) XXX_DiscardUnknown() {
	xxx_messageInfo_TestAlert.DiscardUnknown(m)
}

var xxx_messageInfo_TestAlert proto.InternalMessageInfo

func (m *TestAlert) GetFailBuildId() string {
	if m != nil {
		return m.FailBuildId
	}
	return ""
}

func (m *TestAlert) GetFailCount() int64 {
	if m != nil {
		return m.FailCount
	}
	return 0
}

func (m *TestAlert) GetFailTime() int32 {
	if m != nil {
		return m.FailTime
	}
	return 0
}

func (m *TestAlert) GetText() string {
	if m != nil {
		return m.Text
	}
	return ""
}

func (m *TestAlert) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *TestAlert) GetLinkText() string {
	if m != nil {
		return m.LinkText
	}
	return ""
}

func (m *TestAlert) GetLink() string {
	if m != nil {
		return m.Link
	}
	return ""
}

func (m *TestAlert) GetUrlText() string {
	if m != nil {
		return m.UrlText
	}
	return ""
}

func (m *TestAlert) GetTestId() string {
	if m != nil {
		return m.TestId
	}
	return ""
}

func (m *TestAlert) GetPassBuildId() string {
	if m != nil {
		return m.PassBuildId
	}
	return ""
}

func (m *TestAlert) GetPassCount() int64 {
	if m != nil {
		return m.PassCount
	}
	return 0
}

func (m *TestAlert) GetPassTime() int32 {
	if m != nil {
		return m.PassTime
	}
	return 0
}

func (m *TestAlert) GetCodeSearchPath() string {
	if m != nil {
		return m.CodeSearchPath
	}
	return ""
}

func (m *TestAlert) GetTestName() string {
	if m != nil {
		return m.TestName
	}
	return ""
}

// RleStatus represents a run-length encoded test status:
// a run of Count cells with status Value.
type RleStatus struct {
	Count                int32    `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	Value                int32    `protobuf:"varint,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RleStatus) Reset()         { *m = RleStatus{} }
func (m *RleStatus) String() string { return proto.CompactTextString(m) }
func (*RleStatus) ProtoMessage()    {}
func (*RleStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_d938547f84707355, []int{2}
}

func (m *RleStatus) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RleStatus.Unmarshal(m, b)
}
func (m *RleStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RleStatus.Marshal(b, m, deterministic)
}
func (m *RleStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RleStatus.Merge(m, src)
}
func (m *RleStatus) XXX_Size() int {
	return xxx_messageInfo_RleStatus.Size(m)
}
func (m *RleStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_RleStatus.DiscardUnknown(m)
}

var xxx_messageInfo_RleStatus proto.InternalMessageInfo

func (m *RleStatus) GetCount() int32 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *RleStatus) GetValue() int32 {
	if m != nil {
		return m.Value
	}
	return 0
}

type RawMetric struct {
	// Name.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// A sparse encoding of densely stored values. The layout encodes the cycle
	// indices of the values in the value field below. The layout contains indices
	// followed by counts. The indices specify test cycles where contiguous
	// sequences of values start.
	Layout []int32 `protobuf:"varint,2,rep,packed,name=layout,proto3" json:"layout,omitempty"`
	// Non-empty values for each test result.
	Value                []float64 `protobuf:"fixed64,3,rep,packed,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *RawMetric) Reset()         { *m = RawMetric{} }
func (m *RawMetric) String() string { return proto.CompactTextString(m) }
func (*RawMetric) ProtoMessage()    {}
func (*RawMetric) Descriptor() ([]byte, []int) {
	return fileDescriptor_d938547f84707355, []int{3}
}

func (m *RawMetric) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RawMetric.Unmarshal(m, b)
}
func (m *RawMetric) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RawMetric.Marshal(b, m, deterministic)
}
func (m *RawMetric) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawMetric.Merge(m, src)
}
func (m *RawMetric) XXX_Size() int {
	return xxx_messageInfo_RawMetric.Size(m)
}
func (m *RawMetric) XXX_DiscardUnknown() {
	xxx_messageInfo_RawMetric.DiscardUnknown(m)
}

var xxx_messageInfo_RawMetric proto.InternalMessageInfo

func (m *RawMetric) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *RawMetric) GetLayout() []int32 {
	if m != nil {
		return m.Layout
	}
	return nil
}

func (m *RawMetric) GetValue() []float64 {
	if m != nil {
		return m.Value
	}
	return nil
}

type Graph struct {
	Metric               string          `protobuf:"bytes,1,opt,name=metric,proto3" json:"metric,omitempty"`
	Names                []string        `protobuf:"bytes,2,rep,name=names,proto3" json:"names,omitempty"`
	Labels               []string        `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty"`
	Values               []*Graph_Values `protobuf:"bytes,4,rep,name=values,proto3" json:"values,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *Graph) Reset()         { *m = Graph{} }
func (m *Graph) String() string { return proto.CompactTextString(m) }
func (*Graph) ProtoMessage()    {}
func (*Graph) Descriptor() ([]byte, []int) {
	return fileDescriptor_d938547f84707355, []int{4}
}

func (m *Graph) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Graph.Unmarshal(m, b)
}
func (m *Graph) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Graph.Marshal(b, m, deterministic)
}
func (m *Graph) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Graph.Merge(m, src)
}
func (m *Graph) XXX_Size() int {
	return xxx_messageInfo_Graph.Size(m)
}
func (m *Graph) XXX_DiscardUnknown() {
	xxx_messageInfo_Graph.DiscardUnknown(m)
}

var xxx_messageInfo_Graph proto.InternalMessageInfo

func (m *Graph) GetMetric() string {
	if m != nil {
		return m.Metric
	}
	return ""
}

func (m *Graph) GetNames() []string {
	if m != nil {
		return m.Names
	}
	return nil
}

func (m *Graph) GetLabels() []string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Graph) GetValues() []*Graph_Values {
	if m != nil {
		return m.Values
	}
	return nil
}

type Graph_Values struct {
	Values               []float64 `protobuf:"fixed64,1,rep,packed,name=values,proto3" json:"values,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *Graph_Values) Reset()         { *m = Graph_Values{} }
func (m *Graph_Values) String() string { return proto.CompactTextString(m) }
func (*Graph_Values) ProtoMessage()    {}
func (*Graph_Values) Descriptor() ([]byte, []int) {
	return fileDescriptor_d938547f84707355, []int{4, 0}
}

func (m *Graph_Values) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Graph_Values.Unmarshal(m, b)
}
func (m *Graph_Values) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Graph_Values.Marshal(b, m, deterministic)
}
func (m *Graph_Values) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Graph_Values.Merge(m, src)
}
func (m *Graph_Values) XXX_Size() int {
	return xxx_messageInfo_Graph_Values.Size(m)
}
func (m *Graph_Values) XXX_DiscardUnknown() {
	xxx_messageInfo_Graph_Values.DiscardUnknown(m)
}

var xxx_messageInfo_Graph_Values proto.InternalMessageInfo

func (m *Graph_Values) GetValues() []float64 {
	if m != nil {
		return m.Values
	}
	return nil
}

// Row describes a test row.
type Row struct {
	Name                 string       `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	OriginalName         string       `protobuf:"bytes,2,opt,name=original_name,json=original-name,proto3" json:"original_name,omitempty"`
	Alert                *TestAlert   `protobuf:"bytes,3,opt,name=alert,proto3" json:"alert,omitempty"`
	LinkedBugs           []string     `protobuf:"bytes,4,rep,name=linked_bugs,json=linkedBugs,proto3" json:"linked_bugs,omitempty"`
	Messages             []string     `protobuf:"bytes,5,rep,name=messages,proto3" json:"messages,omitempty"`
	ShortTexts           []string     `protobuf:"bytes,6,rep,name=short_texts,json=shortTexts,proto3" json:"short_texts,omitempty"`
	TestIds              []string     `protobuf:"bytes,7,rep,name=test_ids,json=testIds,proto3" json:"test_ids,omitempty"`
	ShortTestIds         []int64      `protobuf:"varint,8,rep,packed,name=short_test_ids,json=shortTestIds,proto3" json:"short_test_ids,omitempty"`
	Statuses             []*RleStatus `protobuf:"bytes,9,rep,name=statuses,proto3" json:"statuses,omitempty"`
	Target               string       `protobuf:"bytes,10,opt,name=target,proto3" json:"target,omitempty"`
	Tests                []*Row       `protobuf:"bytes,11,rep,name=tests,proto3" json:"tests,omitempty"`
	TabularNameGroups    []string     `protobuf:"bytes,12,rep,name=tabular_name_groups,json=tabular-name-groups,proto3" json:"tabular_name_groups,omitempty"`
	MetricInfo           []*RawMetric `protobuf:"bytes,13,rep,name=metric_info,json=-,proto3" json:"metric_info,omitempty"`
	Graphs               []*Graph     `protobuf:"bytes,14,rep,name=graphs,proto3" json:"graphs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *Row) Reset()         { *m = Row{} }
func (m *Row) String() string { return proto.CompactTextString(m) }
func (*Row) ProtoMessage()    {}
func (*Row) Descriptor() ([]byte, []int) {
	return fileDescriptor_d938547f84707355, []int{5}
}

func (m *Row) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Row.Unmarshal(m, b)
}
func (m *Row) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Row.Marshal(b, m, deterministic)
}
func (m *Row) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Row.Merge(m, src)
}
func (m *Row) XXX_Size() int {
	return xxx_messageInfo_Row.Size(m)
}
func (m *Row) XXX_DiscardUnknown() {
	xxx_messageInfo_Row.DiscardUnknown(m)
}

var xxx_messageInfo_Row proto.InternalMessageInfo

func (m *Row) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Row) GetOriginalName() string {
	if m != nil {
		return m.OriginalName
	}
	return ""
}

func (m *Row) GetAlert() *TestAlert {
	if m != nil {
		return m.Alert
	}
	return nil
}

func (m *Row) GetLinkedBugs() []string {
	if m != nil {
		return m.LinkedBugs
	}
	return nil
}

func (m *Row) GetMessages() []string {
	if m != nil {
		return m.Messages
	}
	return nil
}

func (m *Row) GetShortTexts() []string {
	if m != nil {
		return m.ShortTexts
	}
	return nil
}

func (m *Row) GetTestIds() []string {
	if m != nil {
		return m.TestIds
	}
	return nil
}

func (m *Row) GetShortTestIds() []int64 {
	if m != nil {
		return m.ShortTestIds
	}
	return nil
}

func (m *Row) GetStatuses() []*RleStatus {
	if m != nil {
		return m.Statuses
	}
	return nil
}

func (m *Row) GetTarget() string {
	if m != nil {
		return m.Target
	}
	return ""
}

func (m *Row) GetTests() []*Row {
	if m != nil {
		return m.Tests
	}
	return nil
}

func (m *Row) GetTabularNameGroups() []string {
	if m != nil {
		return m.TabularNameGroups
	}
	return nil
}

func (m *Row) GetMetricInfo() []*RawMetric {
	if m != nil {
		return m.MetricInfo
	}
	return nil
}

func (m *Row) GetGraphs() []*Graph {
	if m != nil {
		return m.Graphs
	}
	return nil
}

type TestMetadata struct {
	BugComponent         int32    `protobuf:"varint,1,opt,name=bug_component,json=bug-component,proto3" json:"bug_component,omitempty"`
	Owner                string   `protobuf:"bytes,2,opt,name=owner,proto3" json:"owner,omitempty"`
	Cc                   []string `protobuf:"bytes,3,rep,name=cc,proto3" json:"cc,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TestMetadata) Reset()         { *m = TestMetadata{} }
func (m *TestMetadata) String() string { return proto.CompactTextString(m) }
func (*TestMetadata) ProtoMessage()    {}
func (*TestMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_d938547f84707355, []int{6}
}

func (m *TestMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestMetadata.Unmarshal(m, b)
}
func (m *TestMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestMetadata.Marshal(b, m, deterministic)
}
func (m *TestMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestMetadata.Merge(m, src)
}
func (m *TestMetadata) XXX_Size() int {
	return xxx_messageInfo_TestMetadata.Size(m)
}
func (m *TestMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_TestMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_TestMetadata proto.InternalMessageInfo

func (m *TestMetadata) GetBugComponent() int32 {
	if m != nil {
		return m.BugComponent
	}
	return 0
}

func (m *TestMetadata) GetOwner() string {
	if m != nil {
		return m.Owner
	}
	return ""
}

func (m *TestMetadata) GetCc() []string {
	if m != nil {
		return m.Cc
	}
	return nil
}

// Response has all the fields expected by TestGrid's javascript client.
// It represents a grid of test results, with additional annotations for metadata.
type Response struct {
	// Display the Test Group name
	TestGroupName string `protobuf:"bytes,1,opt,name=test_group_name,json=test-group-name,proto3" json:"test_group_name,omitempty"`
	QueryParam    string `protobuf:"bytes,2,opt,name=query_param,json=query,proto3" json:"query_param,omitempty"`
	Status        string `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	// The duration of each update cycle
	PhaseTimer *PhaseTimer `protobuf:"bytes,4,opt,name=phase_timer,json=phase-timer,proto3" json:"phase_timer,omitempty"`
	// Boolean to determine if the response is loaded from a cache
	Cached            bool                      `protobuf:"varint,5,opt,name=cached,proto3" json:"cached,omitempty"`
	Summary           string                    `protobuf:"bytes,6,opt,name=summary,proto3" json:"summary,omitempty"`
	Bugs              map[string]string         `protobuf:"bytes,7,rep,name=bugs,proto3" json:"bugs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	BuildIds          []string                  `protobuf:"bytes,8,rep,name=build_ids,json=build-ids,proto3" json:"build_ids,omitempty"`
	ColumnIds         []string                  `protobuf:"bytes,9,rep,name=column_ids,json=columnIds,proto3" json:"column_ids,omitempty"`
	CustomColumns     []*Response_CustomColumns `protobuf:"bytes,10,rep,name=custom_columns,json=custom-columns,proto3" json:"custom_columns,omitempty"`
	ColumnHeaderNames []string                  `protobuf:"bytes,11,rep,name=column_header_names,json=column-header-names,proto3" json:"column_header_names,omitempty"`
	Groups            []string                  `protobuf:"bytes,12,rep,name=groups,proto3" json:"groups,omitempty"`
	Metrics           []string                  `protobuf:"bytes,13,rep,name=metrics,proto3" json:"metrics,omitempty"`
	Tests             []*Row                    `protobuf:"bytes,14,rep,name=tests,proto3" json:"tests,omitempty"`
	// Client wants nullable strings here
	RowIds     []string `protobuf:"bytes,15,rep,name=row_ids,json=rowIds,proto3" json:"row_ids,omitempty"`
	Timestamps []int64  `protobuf:"varint,16,rep,packed,name=timestamps,proto3" json:"timestamps,omitempty"`
	// Lookup map for shortening long test IDs in each row.
	TestIdMap                 map[int64]string                      `protobuf:"bytes,17,rep,name=test_id_map,json=testIdMap,proto3" json:"test_id_map,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	TestMetadata              map[string]*TestMetadata              `protobuf:"bytes,18,rep,name=test_metadata,json=test-metadata,proto3" json:"test_metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	StaleTestThreshold        int32                                 `protobuf:"varint,19,opt,name=stale_test_threshold,json=stale-test-threshold,proto3" json:"stale_test_threshold,omitempty"`
	NumStaleTests             int64                                 `protobuf:"varint,20,opt,name=num_stale_tests,json=num-stale-tests,proto3" json:"num_stale_tests,omitempty"`
	Alerts                    string                                `protobuf:"bytes,21,opt,name=alerts,proto3" json:"alerts,omitempty"`
	AddTabularNamesOption     bool                                  `protobuf:"varint,22,opt,name=add_tabular_names_option,json=add-tabular-names-option,proto3" json:"add_tabular_names_option,omitempty"`
	ShowTabularNames          bool                                  `protobuf:"varint,23,opt,name=show_tabular_names,json=show-tabular-names,proto3" json:"show_tabular_names,omitempty"`
	TabularNamesColumnHeaders []string                              `protobuf:"bytes,24,rep,name=tabular_names_column_headers,json=tabular-names-column-headers,proto3" json:"tabular_names_column_headers,omitempty"`
	Description               string                                `protobuf:"bytes,25,opt,name=description,proto3" json:"description,omitempty"`
	BugComponent              int32                                 `protobuf:"varint,26,opt,name=bug_component,json=bug-component,proto3" json:"bug_component,omitempty"`
	CodeSearchPath            string                                `protobuf:"bytes,27,opt,name=code_search_path,json=code-search-path,proto3" json:"code_search_path,omitempty"`
	OpenTestTemplate          *config.LinkTemplate                  `protobuf:"bytes,28,opt,name=open_test_template,json=open-test-template,proto3" json:"open_test_template,omitempty"`
	FileBugTemplate           *config.LinkTemplate                  `protobuf:"bytes,29,opt,name=file_bug_template,json=file-bug-template,proto3" json:"file_bug_template,omitempty"`
	AttachBugTemplate         *config.LinkTemplate                  `protobuf:"bytes,30,opt,name=attach_bug_template,json=attach-bug-template,proto3" json:"attach_bug_template,omitempty"`
	ResultsUrlTemplate        *config.LinkTemplate                  `protobuf:"bytes,31,opt,name=results_url_template,json=results-url-template,proto3" json:"results_url_template,omitempty"`
	CodeSearchUrlTemplate     *config.LinkTemplate                  `protobuf:"bytes,32,opt,name=code_search_url_template,json=code-search-url-template,proto3" json:"code_search_url_template,omitempty"`
	OpenBugTemplate           *config.LinkTemplate                  `protobuf:"bytes,33,opt,name=open_bug_template,json=open-bug-template,proto3" json:"open_bug_template,omitempty"`
	AboutDashboardUrl         string                                `protobuf:"bytes,34,opt,name=about_dashboard_url,json=about-dashboard-url,proto3" json:"about_dashboard_url,omitempty"`
	ResultsText               string                                `protobuf:"bytes,35,opt,name=results_text,json=results-text,proto3" json:"results_text,omitempty"`
	LatestGreen               string                                `protobuf:"bytes,36,opt,name=latest_green,json=latest-green,proto3" json:"latest_green,omitempty"`
	TriageEnabled             bool                                  `protobuf:"varint,37,opt,name=triage_enabled,json=triage-enabled,proto3" json:"triage_enabled,omitempty"`
	Notifications             []*config.Notification                `protobuf:"bytes,38,rep,name=notifications,proto3" json:"notifications,omitempty"`
	TestGroup                 *config.TestGroup                     `protobuf:"bytes,39,opt,name=test_group,json=-,proto3" json:"test_group,omitempty"`
	DashboardTab              *config.DashboardTab                  `protobuf:"bytes,40,opt,name=dashboard_tab,json=-,proto3" json:"dashboard_tab,omitempty"`
	OverallStatus             summary.DashboardTabSummary_TabStatus `protobuf:"varint,41,opt,name=overall_status,json=overall-status,proto3,enum=DashboardTabSummary_TabStatus" json:"overall_status,omitempty"`
	DashboardName             string                                `protobuf:"bytes,42,opt,name=dashboard_name,json=dashboardName,proto3" json:"dashboard_name,omitempty"`
	UpdateTimestamp           int64                                 `protobuf:"varint,43,opt,name=update_timestamp,json=updateTimestamp,proto3" json:"update_timestamp,omitempty"`
	XXX_NoUnkeyedLiteral      struct{}                              `json:"-"`
	XXX_unrecognized          []byte                                `json:"-"`
	XXX_sizecache             int32                                 `json:"-"`
}

func (m *Response) Reset()         { *m = Response{} }
func (m *Response) String() string { return proto.CompactTextString(m) }
func (*Response) ProtoMessage()    {}
func (*Response) Descriptor() ([]byte, []int) {
	return fileDescriptor_d938547f84707355, []int{7}
}

func (m *Response) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Response.Unmarshal(m, b)
}
func (m *Response) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Response.Marshal(b, m, deterministic)
}
func (m *Response) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Response.Merge(m, src)
}
func (m *Response) XXX_Size() int {
	return xxx_messageInfo_Response.Size(m)
}
func (m *Response) XXX_DiscardUnknown() {
	xxx_messageInfo_Response.DiscardUnknown(m)
}

var xxx_messageInfo_Response proto.InternalMessageInfo

func (m *Response) GetTestGroupName() string {
	if m != nil {
		return m.TestGroupName
	}
	return ""
}

func (m *Response) GetQueryParam() string {
	if m != nil {
		return m.QueryParam
	}
	return ""
}

func (m *Response) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *Response) GetPhaseTimer() *PhaseTimer {
	if m != nil {
		return m.PhaseTimer
	}
	return nil
}

func (m *Response) GetCached() bool {
	if m != nil {
		return m.Cached
	}
	return false
}

func (m *Response) GetSummary() string {
	if m != nil {
		return m.Summary
	}
	return ""
}

func (m *Response) GetBugs() map[string]string {
	if m != nil {
		return m.Bugs
	}
	return nil
}

func (m *Response) GetBuildIds() []string {
	if m != nil {
		return m.BuildIds
	}
	return nil
}

func (m *Response) GetColumnIds() []string {
	if m != nil {
		return m.ColumnIds
	}
	return nil
}

func (m *Response) GetCustomColumns() []*Response_CustomColumns {
	if m != nil {
		return m.CustomColumns
	}
	return nil
}

func (m *Response) GetColumnHeaderNames() []string {
	if m != nil {
		return m.ColumnHeaderNames
	}
	return nil
}

func (m *Response) GetGroups() []string {
	if m != nil {
		return m.Groups
	}
	return nil
}

func (m *Response) GetMetrics() []string {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func (m *Response) GetTests() []*Row {
	if m != nil {
		return m.Tests
	}
	return nil
}

func (m *Response) GetRowIds() []string {
	if m != nil {
		return m.RowIds
	}
	return nil
}

func (m *Response) GetTimestamps() []int64 {
	if m != nil {
		return m.Timestamps
	}
	return nil
}

func (m *Response) GetTestIdMap() map[int64]string {
	if m != nil {
		return m.TestIdMap
	}
	return nil
}

func (m *Response) GetTestMetadata() map[string]*TestMetadata {
	if m != nil {
		return m.TestMetadata
	}
	return nil
}

func (m *Response) GetStaleTestThreshold() int32 {
	if m != nil {
		return m.StaleTestThreshold
	}
	return 0
}

func (m *Response) GetNumStaleTests() int64 {
	if m != nil {
		return m.NumStaleTests
	}
	return 0
}

func (m *Response) GetAlerts() string {
	if m != nil {
		return m.Alerts
	}
	return ""
}

func (m *Response) GetAddTabularNamesOption() bool {
	if m != nil {
		return m.AddTabularNamesOption
	}
	return false
}

func (m *Response) GetShowTabularNames() bool {
	if m != nil {
		return m.ShowTabularNames
	}
	return false
}

func (m *Response) GetTabularNamesColumnHeaders() []string {
	if m != nil {
		return m.TabularNamesColumnHeaders
	}
	return nil
}

func (m *Response) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Response) GetBugComponent() int32 {
	if m != nil {
		return m.BugComponent
	}
	return 0
}

func (m *Response) GetCodeSearchPath() string {
	if m != nil {
		return m.CodeSearchPath
	}
	return ""
}

func (m *Response) GetOpenTestTemplate() *config.LinkTemplate {
	if m != nil {
		return m.OpenTestTemplate
	}
	return nil
}

func (m *Response) GetFileBugTemplate() *config.LinkTemplate {
	if m != nil {
		return m.FileBugTemplate
	}
	return nil
}

func (m *Response) GetAttachBugTemplate() *config.LinkTemplate {
	if m != nil {
		return m.AttachBugTemplate
	}
	return nil
}

func (m *Response) GetResultsUrlTemplate() *config.LinkTemplate {
	if m != nil {
		return m.ResultsUrlTemplate
	}
	return nil
}

func (m *Response) GetCodeSearchUrlTemplate() *config.LinkTemplate {
	if m != nil {
		return m.CodeSearchUrlTemplate
	}
	return nil
}

func (m *Response) GetOpenBugTemplate() *config.LinkTemplate {
	if m != nil {
		return m.OpenBugTemplate
	}
	return nil
}

func (m *Response) GetAboutDashboardUrl() string {
	if m != nil {
		return m.AboutDashboardUrl
	}
	return ""
}

func (m *Response) GetResultsText() string {
	if m != nil {
		return m.ResultsText
	}
	return ""
}

func (m *Response) GetLatestGreen() string {
	if m != nil {
		return m.LatestGreen
	}
	return ""
}

func (m *Response) GetTriageEnabled() bool {
	if m != nil {
		return m.TriageEnabled
	}
	return false
}

func (m *Response) GetNotifications() []*config.Notification {
	if m != nil {
		return m.Notifications
	}
	return nil
}

func (m *Response) GetTestGroup() *config.TestGroup {
	if m != nil {
		return m.TestGroup
	}
	return nil
}

func (m *Response) GetDashboardTab() *config.DashboardTab {
	if m != nil {
		return m.DashboardTab
	}
	return nil
}

func (m *Response) GetOverallStatus() summary.DashboardTabSummary_TabStatus {
	if m != nil {
		return m.OverallStatus
	}
	return summary.DashboardTabSummary_NOT_SET
}

func (m *Response) GetDashboardName() string {
	if m != nil {
		return m.DashboardName
	}
	return ""
}

func (m *Response) GetUpdateTimestamp() int64 {
	if m != nil {
		return m.UpdateTimestamp
	}
	return 0
}

type Response_CustomColumns struct {
	CustomColumns        []string `protobuf:"bytes,1,rep,name=custom_columns,json=customColumns,proto3" json:"custom_columns,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Response_CustomColumns) Reset()         { *m = Response_CustomColumns{} }
func (m *Response_CustomColumns) String() string { return proto.CompactTextString(m) }
func (*Response_CustomColumns) ProtoMessage()    {}
func (*Response_CustomColumns) Descriptor() ([]byte, []int) {
	return fileDescriptor_d938547f84707355, []int{7, 1}
}

func (m *Response_CustomColumns) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Response_CustomColumns.Unmarshal(m, b)
}
func (m *Response_CustomColumns) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Response_CustomColumns.Marshal(b, m, deterministic)
}
func (m *Response_CustomColumns) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Response_CustomColumns.Merge(m, src)
}
func (m *Response_CustomColumns) XXX_Size() int {
	return xxx_messageInfo_Response_CustomColumns.Size(m)
}
func (m *Response_CustomColumns) XXX_DiscardUnknown() {
	xxx_messageInfo_Response_CustomColumns.DiscardUnknown(m)
}

var xxx_messageInfo_Response_CustomColumns proto.InternalMessageInfo

func (m *Response_CustomColumns) GetCustomColumns() []string {
	if m != nil {
		return m.CustomColumns
	}
	return nil
}

func init() {
	proto.RegisterType((*PhaseTimer)(nil), "PhaseTimer")
	proto.RegisterType((*TestAlert)(nil), "TestAlert")
	proto.RegisterType((*RleStatus)(nil), "RleStatus")
	proto.RegisterType((*RawMetric)(nil), "RawMetric")
	proto.RegisterType((*Graph)(nil), "Graph")
	proto.RegisterType((*Graph_Values)(nil), "Graph.Values")
	proto.RegisterType((*Row)(nil), "Row")
	proto.RegisterType((*TestMetadata)(nil), "TestMetadata")
	proto.RegisterType((*Response)(nil), "Response")
	proto.RegisterMapType((map[string]string)(nil), "Response.BugsEntry")
	proto.RegisterMapType((map[int64]string)(nil), "Response.TestIdMapEntry")
	proto.RegisterMapType((map[string]*TestMetadata)(nil), "Response.TestMetadataEntry")
	proto.RegisterType((*Response_CustomColumns)(nil), "Response.CustomColumns")
}

func init() { proto.RegisterFile("types.proto", fileDescriptor_d938547f84707355) }

var fileDescriptor_d938547f84707355 = []byte{
	// 1584 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x84, 0x57, 0xef, 0x6e, 0xe3, 0xc6,
	0x11, 0x87, 0x2c, 0x4b, 0x16, 0x47, 0x96, 0x72, 0x5e, 0xbb, 0xb9, 0x8d, 0xe2, 0x38, 0x8a, 0xe2,
	0xbb, 0x53, 0x52, 0x50, 0x0d, 0x1c, 0xa0, 0x09, 0x92, 0x16, 0xc1, 0x5d, 0xda, 0x06, 0x07, 0xf4,
	0x0e, 0x05, 0x63, 0xf4, 0x43, 0xbe, 0x10, 0x2b, 0x72, 0x2d, 0x11, 0xe6, 0xbf, 0x72, 0x97, 0x71,
	0xdd, 0xcf, 0x7d, 0x86, 0xbe, 0x48, 0xdf, 0xa4, 0x4f, 0x54, 0xcc, 0xcc, 0x92, 0x12, 0x7b, 0x2a,
	0xf2, 0x49, 0x9c, 0xdf, 0xec, 0xcc, 0xce, 0xcc, 0xfe, 0x76, 0x66, 0x05, 0x63, 0xfb, 0x58, 0x6a,
	0xb3, 0x2a, 0xab, 0xc2, 0x16, 0xb3, 0x4b, 0xab, 0x8d, 0xdd, 0x54, 0x49, 0xfc, 0x9b, 0xa8, 0xc8,
	0xef, 0x92, 0x8d, 0xfb, 0x71, 0xda, 0xab, 0x56, 0x6b, 0xea, 0x2c, 0x53, 0xd5, 0x63, 0xf3, 0xcb,
	0xfa, 0xc5, 0x3f, 0x00, 0xfe, 0xb2, 0x55, 0x46, 0xdf, 0x26, 0x99, 0xae, 0xc4, 0x05, 0x0c, 0x8c,
	0x55, 0x95, 0x95, 0xbd, 0x79, 0x6f, 0x39, 0x08, 0x58, 0x10, 0x02, 0x8e, 0x53, 0x65, 0xac, 0x3c,
	0x22, 0x90, 0xbe, 0xc5, 0xfb, 0x30, 0x2c, 0xd1, 0xce, 0xc8, 0xfe, 0xbc, 0xbf, 0xf4, 0x02, 0x27,
	0xa1, 0x87, 0x58, 0xa7, 0x56, 0xc9, 0xe3, 0x79, 0x7f, 0xd9, 0x0b, 0x58, 0x40, 0xd4, 0x16, 0x56,
	0xa5, 0x72, 0x30, 0xef, 0x21, 0x4a, 0xc2, 0xe2, 0xdf, 0x7d, 0xf0, 0x6e, 0xb5, 0xb1, 0x2f, 0x53,
	0x5d, 0x59, 0x71, 0x0d, 0x93, 0x3b, 0x95, 0xa4, 0xe1, 0xba, 0x4e, 0xd2, 0x38, 0x4c, 0x62, 0x8a,
	0xc1, 0x0b, 0x08, 0xf4, 0x09, 0xf4, 0x93, 0x58, 0x5c, 0x01, 0xd0, 0xaa, 0xa8, 0xa8, 0x73, 0x8e,
	0xa8, 0x1f, 0x10, 0xe2, 0x13, 0x22, 0x2e, 0xc1, 0x23, 0xbd, 0x4d, 0x32, 0x2d, 0xfb, 0x14, 0x30,
	0x01, 0x3e, 0x02, 0x98, 0x89, 0xd5, 0x7f, 0xb7, 0xf2, 0x98, 0x5c, 0xd3, 0xb7, 0x90, 0x70, 0x92,
	0x69, 0x63, 0xd4, 0x46, 0x53, 0x74, 0x5e, 0xd0, 0x88, 0xe8, 0x2b, 0x4d, 0xf2, 0xfb, 0x90, 0x4c,
	0x86, 0xa4, 0x23, 0xc0, 0x27, 0x3b, 0xac, 0x4a, 0x92, 0xdf, 0xcb, 0x13, 0xf6, 0x85, 0xdf, 0x62,
	0x06, 0xa3, 0xba, 0x4a, 0xd9, 0x60, 0x44, 0x38, 0xca, 0x7e, 0xb3, 0x0f, 0x9e, 0x05, 0x66, 0xe6,
	0xf1, 0x3e, 0x28, 0x62, 0x4e, 0xd7, 0x30, 0x29, 0x95, 0x31, 0xbb, 0xcc, 0x81, 0x33, 0x47, 0xb0,
	0x93, 0x39, 0xad, 0xe2, 0xcc, 0xc7, 0x9c, 0x39, 0x2d, 0x69, 0x33, 0x27, 0x3d, 0x65, 0x7e, 0xca,
	0x99, 0x93, 0x9a, 0x32, 0xff, 0x1c, 0x9e, 0x44, 0x45, 0xac, 0x43, 0xa3, 0x55, 0x15, 0x6d, 0xc3,
	0x52, 0xd9, 0xad, 0x9c, 0xd0, 0x36, 0x84, 0xfb, 0x8c, 0xfb, 0x88, 0xa3, 0x27, 0x8a, 0x34, 0x57,
	0x99, 0x96, 0x53, 0xce, 0x9b, 0x62, 0x45, 0x60, 0xf1, 0x15, 0x78, 0x41, 0xaa, 0x7f, 0xb4, 0xca,
	0xd6, 0x74, 0xdc, 0x1c, 0x8f, 0x23, 0x0c, 0x87, 0x72, 0x01, 0x83, 0x9f, 0x55, 0x5a, 0x6b, 0xc7,
	0x18, 0x16, 0x16, 0xaf, 0xc1, 0x0b, 0xd4, 0xc3, 0x1b, 0x6d, 0xab, 0x24, 0x12, 0x53, 0x38, 0x6a,
	0x8f, 0xf8, 0x28, 0x89, 0x91, 0x4f, 0xa9, 0x7a, 0x2c, 0x6a, 0x3c, 0xd3, 0xfe, 0x72, 0x10, 0x38,
	0x69, 0xe7, 0xaa, 0xcf, 0x7c, 0x62, 0x57, 0xff, 0xea, 0xc1, 0xe0, 0x87, 0x4a, 0x95, 0x5b, 0xb4,
	0xcb, 0xc8, 0xa3, 0xf3, 0xe5, 0x24, 0xb4, 0xc3, 0x68, 0x0d, 0xb9, 0xf3, 0x02, 0x16, 0x78, 0x97,
	0xb5, 0x4e, 0x5b, 0xd6, 0xb2, 0x24, 0x9e, 0xc1, 0x90, 0x1c, 0x1b, 0xa2, 0xed, 0xf8, 0x66, 0xb2,
	0x22, 0xef, 0xab, 0xbf, 0x12, 0x18, 0x38, 0xe5, 0x6c, 0x0e, 0x43, 0x46, 0xd0, 0x91, 0x33, 0xe8,
	0x51, 0x5c, 0x4e, 0x5a, 0xfc, 0xa7, 0x0f, 0xfd, 0xa0, 0x78, 0x40, 0x72, 0x50, 0xf5, 0x38, 0x28,
	0xfa, 0xc6, 0x63, 0x2e, 0xaa, 0x64, 0x93, 0xe4, 0x2a, 0xe5, 0xd2, 0x1e, 0xf1, 0x31, 0x37, 0x20,
	0x95, 0x57, 0xcc, 0x61, 0xa0, 0xf0, 0x3e, 0x10, 0x79, 0xc7, 0x37, 0xb0, 0x6a, 0x6f, 0x48, 0xc0,
	0x0a, 0xf1, 0x31, 0x8c, 0x91, 0x6c, 0x3a, 0x0e, 0xd7, 0xf5, 0x86, 0x23, 0xf6, 0x02, 0x60, 0xe8,
	0x55, 0xbd, 0x31, 0xc8, 0x42, 0x47, 0x61, 0x23, 0x07, 0xa4, 0x6d, 0x65, 0x34, 0x36, 0xdb, 0xa2,
	0xb2, 0xc4, 0x51, 0x23, 0x87, 0x6c, 0x4c, 0xd0, 0x2d, 0x22, 0xe2, 0x03, 0x18, 0x39, 0x9a, 0x1a,
	0x79, 0x42, 0x5a, 0xe2, 0xe9, 0xeb, 0xd8, 0x88, 0x6b, 0x98, 0x36, 0xb6, 0x6e, 0xc1, 0x68, 0xde,
	0x5f, 0xf6, 0x83, 0x53, 0x67, 0xce, 0xab, 0x9e, 0xc3, 0xc8, 0x10, 0x39, 0xb4, 0x91, 0x1e, 0x55,
	0x13, 0x56, 0x2d, 0x61, 0x82, 0x56, 0x87, 0x25, 0xb4, 0xaa, 0xda, 0x68, 0xeb, 0xe8, 0xee, 0x24,
	0x31, 0x83, 0x01, 0xfa, 0x37, 0x72, 0x4c, 0xc6, 0xc7, 0xab, 0xa0, 0x78, 0x08, 0x18, 0x12, 0x5f,
	0xc0, 0xb9, 0x55, 0xeb, 0x3a, 0x55, 0x15, 0x55, 0x30, 0xdc, 0x54, 0x45, 0x5d, 0x1a, 0x79, 0x4a,
	0x71, 0x36, 0x2a, 0xaa, 0xa3, 0xcf, 0x2a, 0xb1, 0x80, 0x31, 0x33, 0x22, 0x4c, 0xf2, 0xbb, 0x42,
	0x4e, 0x9a, 0x80, 0x1a, 0x22, 0x06, 0x3d, 0x5f, 0x5c, 0xc1, 0x70, 0x83, 0xc7, 0x6d, 0xe4, 0x94,
	0xd4, 0x43, 0x3e, 0xfd, 0xc0, 0xa1, 0x8b, 0x9f, 0xe0, 0x14, 0x93, 0x7b, 0xa3, 0xad, 0x8a, 0x95,
	0x55, 0x78, 0x90, 0xeb, 0x7a, 0x13, 0x46, 0x45, 0x56, 0x16, 0xb9, 0x6e, 0xc9, 0x8f, 0xa0, 0xdf,
	0x82, 0xc8, 0xc0, 0xe2, 0x21, 0xd7, 0x95, 0x3b, 0x66, 0x16, 0x90, 0xf7, 0x51, 0xe4, 0xd8, 0x77,
	0x14, 0x45, 0x8b, 0x7f, 0x9e, 0xc1, 0x28, 0xd0, 0xa6, 0x2c, 0x72, 0xa3, 0xc5, 0x12, 0xde, 0xa3,
	0xd2, 0x52, 0xec, 0xe1, 0x1e, 0x81, 0x08, 0xe6, 0x94, 0x98, 0x25, 0x33, 0x18, 0xff, 0xad, 0xd6,
	0xd5, 0x63, 0x58, 0xaa, 0x4a, 0x65, 0xcd, 0x16, 0x04, 0x61, 0x61, 0xb9, 0xc8, 0x44, 0x21, 0x2f,
	0x70, 0x92, 0xf0, 0x61, 0x4c, 0x4d, 0x9a, 0x3a, 0x44, 0x45, 0x3d, 0x70, 0x7c, 0x33, 0x5e, 0xed,
	0xda, 0x7f, 0xc0, 0x7a, 0x6a, 0x18, 0x15, 0xba, 0x89, 0x54, 0xb4, 0xd5, 0x31, 0xb5, 0xc5, 0x51,
	0xe0, 0x24, 0xec, 0x63, 0x6e, 0x84, 0xb8, 0x9e, 0xd8, 0x88, 0xe2, 0x05, 0x1c, 0x13, 0x23, 0x4f,
	0xa8, 0x8a, 0xe7, 0xab, 0x26, 0xaf, 0x15, 0xb2, 0xf2, 0x8f, 0xb9, 0xad, 0x1e, 0x03, 0x5a, 0x80,
	0x0d, 0xa6, 0xe9, 0x75, 0xcc, 0x21, 0x2f, 0xf0, 0x9a, 0x3e, 0x67, 0xc4, 0x47, 0x00, 0x51, 0x91,
	0xd6, 0x59, 0x4e, 0x6a, 0x8f, 0xd5, 0x8c, 0x20, 0xbf, 0xbe, 0x83, 0x69, 0x54, 0x1b, 0x5b, 0x64,
	0x21, 0x63, 0x46, 0x02, 0xed, 0xf7, 0x74, 0xb7, 0xdf, 0xf7, 0xa4, 0xff, 0x9e, 0xd5, 0x81, 0x5b,
	0xee, 0xbb, 0xe5, 0x48, 0x22, 0xe7, 0x7f, 0xab, 0x55, 0xac, 0x99, 0x4a, 0x4c, 0x37, 0x2f, 0x70,
	0x2a, 0x9f, 0x55, 0x7e, 0xdb, 0x36, 0x3a, 0x4c, 0x73, 0x12, 0x8f, 0x0e, 0x64, 0x91, 0x21, 0x62,
	0xd1, 0xe8, 0x20, 0x71, 0x47, 0xe2, 0xe9, 0xbb, 0x24, 0x7e, 0x0a, 0x27, 0x55, 0xf1, 0x40, 0xc9,
	0xbd, 0xc7, 0xee, 0xaa, 0xe2, 0x01, 0x33, 0xbb, 0x02, 0xc0, 0xd2, 0x1b, 0xab, 0xb2, 0xd2, 0xc8,
	0x27, 0x74, 0xb7, 0xf6, 0x10, 0xf1, 0x35, 0x8c, 0xdd, 0xcd, 0x0b, 0x33, 0x55, 0xca, 0x33, 0x72,
	0x2d, 0x77, 0x69, 0xf3, 0x0d, 0x7c, 0xa3, 0x4a, 0xae, 0xb5, 0x67, 0x1b, 0x59, 0xbc, 0x84, 0x09,
	0x59, 0x66, 0x8e, 0xc2, 0x52, 0x90, 0xed, 0x87, 0x5d, 0xdb, 0x86, 0xe0, 0x6c, 0x4e, 0x16, 0x7e,
	0x63, 0x21, 0x6e, 0xe0, 0xc2, 0x58, 0x95, 0x6a, 0xbe, 0xfc, 0x76, 0x5b, 0x69, 0xb3, 0x2d, 0xd2,
	0x58, 0x9e, 0x13, 0xf7, 0x59, 0xe7, 0x93, 0x49, 0xab, 0x43, 0x3e, 0xe7, 0x75, 0x16, 0xee, 0xec,
	0x8c, 0xbc, 0xa0, 0xb9, 0x85, 0xb0, 0xbf, 0x33, 0xa1, 0x0a, 0x53, 0x73, 0x33, 0xf2, 0x57, 0xcc,
	0x59, 0x96, 0xc4, 0x37, 0x20, 0x55, 0x1c, 0x87, 0xfb, 0x97, 0xde, 0x84, 0x45, 0x69, 0x93, 0x22,
	0x97, 0xef, 0x13, 0x2d, 0x51, 0xef, 0xef, 0xdf, 0x7c, 0xe3, 0xb3, 0x5e, 0xac, 0x40, 0x98, 0x6d,
	0xf1, 0xd0, 0x35, 0x96, 0x4f, 0xc9, 0x8a, 0x34, 0x5d, 0x33, 0xf1, 0x0a, 0x2e, 0xbb, 0xfb, 0x74,
	0x58, 0x62, 0xa4, 0xa4, 0xc3, 0xba, 0xec, 0xee, 0xd5, 0xa1, 0x8b, 0x11, 0x73, 0x18, 0xc7, 0xda,
	0x44, 0x55, 0xc2, 0x21, 0x7e, 0x40, 0xc9, 0xec, 0x43, 0xef, 0x36, 0x8f, 0xd9, 0xa1, 0xe6, 0x71,
	0x68, 0x5c, 0x7f, 0xf8, 0x7f, 0xc6, 0xf5, 0xef, 0x41, 0x14, 0xa5, 0xce, 0xdd, 0xc1, 0xe8, 0xac,
	0x4c, 0x95, 0xd5, 0xf2, 0x92, 0xae, 0xf7, 0x64, 0xf5, 0xe7, 0x24, 0xbf, 0xbf, 0x75, 0x60, 0x40,
	0x0b, 0xdd, 0x29, 0x39, 0x4c, 0x7c, 0x0b, 0x67, 0x77, 0x49, 0xaa, 0x71, 0x98, 0xec, 0xac, 0x3f,
	0x3a, 0x64, 0x4d, 0xeb, 0x7c, 0x0c, 0xb4, 0x35, 0xfe, 0x0e, 0xce, 0x95, 0xb5, 0x2a, 0xda, 0x76,
	0xcd, 0xaf, 0x0e, 0x99, 0xbb, 0x95, 0x5d, 0x07, 0x2f, 0xe1, 0xa2, 0xd2, 0xa6, 0x4e, 0xad, 0x09,
	0xf9, 0xe5, 0xe4, 0x3c, 0x7c, 0x7c, 0xc8, 0x43, 0xb3, 0xd4, 0xe7, 0x47, 0x95, 0x73, 0xf1, 0x1a,
	0xe4, 0x7e, 0xad, 0x3a, 0x6e, 0xe6, 0x87, 0xdc, 0xc8, 0xfd, 0x12, 0x76, 0x5c, 0x7d, 0x0b, 0x67,
	0x54, 0xca, 0x4e, 0x32, 0x9f, 0x1c, 0xac, 0x05, 0x55, 0xb2, 0x93, 0xca, 0x17, 0x70, 0xae, 0xd6,
	0x45, 0x6d, 0xc3, 0x58, 0x99, 0xed, 0xba, 0x50, 0x55, 0x8c, 0xb1, 0xc8, 0x05, 0x1d, 0x1b, 0xab,
	0xfc, 0x56, 0x85, 0xfb, 0x8a, 0x05, 0x9c, 0x36, 0xc9, 0xd3, 0x93, 0xf1, 0x53, 0x5a, 0xda, 0x60,
	0xfc, 0x6c, 0x5c, 0xc0, 0x29, 0x7a, 0xa7, 0xa9, 0xa0, 0x75, 0x2e, 0xaf, 0x79, 0x0d, 0x63, 0x3e,
	0x61, 0xe2, 0x39, 0x4c, 0x6d, 0x95, 0xa8, 0x8d, 0x0e, 0x75, 0xae, 0xd6, 0xa9, 0x8e, 0xe5, 0x33,
	0x62, 0xb9, 0x43, 0x7d, 0x87, 0x8a, 0x2f, 0x61, 0x92, 0x17, 0x36, 0xb9, 0x4b, 0x22, 0x85, 0x5c,
	0x34, 0xf2, 0xb9, 0x7b, 0xed, 0xbc, 0xdd, 0x43, 0x83, 0xee, 0x1a, 0xf1, 0x09, 0xc0, 0x6e, 0x28,
	0xc9, 0x17, 0x7b, 0xaf, 0x92, 0x1f, 0x10, 0xc1, 0x01, 0xfa, 0x02, 0x26, 0xbb, 0x9c, 0xad, 0x5a,
	0xcb, 0xa5, 0x2b, 0xd9, 0x1f, 0x1a, 0xf4, 0x56, 0xad, 0x71, 0xe1, 0x9f, 0x60, 0x5a, 0xfc, 0xac,
	0x2b, 0x95, 0xa6, 0xa1, 0x1b, 0x51, 0x9f, 0xcd, 0x7b, 0xcb, 0xe9, 0xcd, 0x55, 0x67, 0xe5, 0x8f,
	0xee, 0x1f, 0x0a, 0x7e, 0xf2, 0xab, 0xa1, 0xb1, 0xf2, 0xdd, 0x28, 0x7b, 0x06, 0xd3, 0xdd, 0x86,
	0x34, 0x27, 0x3f, 0xe7, 0xb7, 0x54, 0x8b, 0xbe, 0xc5, 0x29, 0xf9, 0x19, 0x3c, 0xa9, 0xcb, 0x58,
	0x59, 0x1e, 0x79, 0xd4, 0x45, 0xe5, 0xaf, 0xb9, 0x01, 0x31, 0x7e, 0xdb, 0xc0, 0xb3, 0xaf, 0xc0,
	0x6b, 0xa7, 0x94, 0x78, 0x02, 0xfd, 0x7b, 0xfd, 0xe8, 0x66, 0x2f, 0x7e, 0x76, 0x5f, 0xb4, 0x9e,
	0x7b, 0x86, 0x7e, 0x73, 0xf4, 0x75, 0x6f, 0xf6, 0x5b, 0x98, 0x74, 0xc6, 0x0d, 0xc6, 0xf6, 0x3f,
	0xf3, 0xa9, 0x47, 0x8d, 0x63, 0x12, 0xed, 0x2f, 0x9b, 0xfd, 0x0e, 0xa6, 0xdd, 0x7e, 0xbd, 0xbf,
	0x6b, 0xff, 0x97, 0x76, 0x7d, 0x0b, 0x67, 0xef, 0x74, 0xec, 0x03, 0x61, 0x7f, 0xba, 0xef, 0x00,
	0x0f, 0x64, 0xdf, 0x68, 0xcf, 0xdf, 0x2b, 0xf8, 0x69, 0x54, 0xb9, 0x51, 0xb0, 0x1e, 0xd2, 0x3f,
	0xc3, 0x2f, 0xff, 0x1b, 0x00, 0x00, 0xff, 0xff, 0x86, 0xb7, 0xb9, 0x9c, 0x66, 0x0e, 0x00, 0x00,
}
