// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/automl/v1/service.proto

package automl

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for
// [AutoMl.CreateDataset][google.cloud.automl.v1.AutoMl.CreateDataset].
type CreateDatasetRequest struct {
	// The resource name of the project to create the dataset for.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The dataset to create.
	Dataset              *Dataset `protobuf:"bytes,2,opt,name=dataset,proto3" json:"dataset,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateDatasetRequest) Reset()         { *m = CreateDatasetRequest{} }
func (m *CreateDatasetRequest) String() string { return proto.CompactTextString(m) }
func (*CreateDatasetRequest) ProtoMessage()    {}
func (*CreateDatasetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{0}
}

func (m *CreateDatasetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateDatasetRequest.Unmarshal(m, b)
}
func (m *CreateDatasetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateDatasetRequest.Marshal(b, m, deterministic)
}
func (m *CreateDatasetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateDatasetRequest.Merge(m, src)
}
func (m *CreateDatasetRequest) XXX_Size() int {
	return xxx_messageInfo_CreateDatasetRequest.Size(m)
}
func (m *CreateDatasetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateDatasetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateDatasetRequest proto.InternalMessageInfo

func (m *CreateDatasetRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateDatasetRequest) GetDataset() *Dataset {
	if m != nil {
		return m.Dataset
	}
	return nil
}

// Request message for
// [AutoMl.GetDataset][google.cloud.automl.v1.AutoMl.GetDataset].
type GetDatasetRequest struct {
	// The resource name of the dataset to retrieve.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetDatasetRequest) Reset()         { *m = GetDatasetRequest{} }
func (m *GetDatasetRequest) String() string { return proto.CompactTextString(m) }
func (*GetDatasetRequest) ProtoMessage()    {}
func (*GetDatasetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{1}
}

func (m *GetDatasetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetDatasetRequest.Unmarshal(m, b)
}
func (m *GetDatasetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetDatasetRequest.Marshal(b, m, deterministic)
}
func (m *GetDatasetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDatasetRequest.Merge(m, src)
}
func (m *GetDatasetRequest) XXX_Size() int {
	return xxx_messageInfo_GetDatasetRequest.Size(m)
}
func (m *GetDatasetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDatasetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDatasetRequest proto.InternalMessageInfo

func (m *GetDatasetRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for
// [AutoMl.ListDatasets][google.cloud.automl.v1.AutoMl.ListDatasets].
type ListDatasetsRequest struct {
	// The resource name of the project from which to list datasets.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// An expression for filtering the results of the request.
	//
	//   * `dataset_metadata` - for existence of the case (e.g.
	//             image_classification_dataset_metadata:*). Some examples of
	//             using the filter are:
	//
	//   * `translation_dataset_metadata:*` --> The dataset has
	//                                          translation_dataset_metadata.
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// Requested page size. Server may return fewer results than requested.
	// If unspecified, server will pick a default size.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results for the server to return
	// Typically obtained via
	// [ListDatasetsResponse.next_page_token][google.cloud.automl.v1.ListDatasetsResponse.next_page_token]
	// of the previous
	// [AutoMl.ListDatasets][google.cloud.automl.v1.AutoMl.ListDatasets] call.
	PageToken            string   `protobuf:"bytes,6,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDatasetsRequest) Reset()         { *m = ListDatasetsRequest{} }
func (m *ListDatasetsRequest) String() string { return proto.CompactTextString(m) }
func (*ListDatasetsRequest) ProtoMessage()    {}
func (*ListDatasetsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{2}
}

func (m *ListDatasetsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDatasetsRequest.Unmarshal(m, b)
}
func (m *ListDatasetsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDatasetsRequest.Marshal(b, m, deterministic)
}
func (m *ListDatasetsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDatasetsRequest.Merge(m, src)
}
func (m *ListDatasetsRequest) XXX_Size() int {
	return xxx_messageInfo_ListDatasetsRequest.Size(m)
}
func (m *ListDatasetsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDatasetsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListDatasetsRequest proto.InternalMessageInfo

func (m *ListDatasetsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListDatasetsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListDatasetsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListDatasetsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for
// [AutoMl.ListDatasets][google.cloud.automl.v1.AutoMl.ListDatasets].
type ListDatasetsResponse struct {
	// The datasets read.
	Datasets []*Dataset `protobuf:"bytes,1,rep,name=datasets,proto3" json:"datasets,omitempty"`
	// A token to retrieve next page of results.
	// Pass to
	// [ListDatasetsRequest.page_token][google.cloud.automl.v1.ListDatasetsRequest.page_token]
	// to obtain that page.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDatasetsResponse) Reset()         { *m = ListDatasetsResponse{} }
func (m *ListDatasetsResponse) String() string { return proto.CompactTextString(m) }
func (*ListDatasetsResponse) ProtoMessage()    {}
func (*ListDatasetsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{3}
}

func (m *ListDatasetsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDatasetsResponse.Unmarshal(m, b)
}
func (m *ListDatasetsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDatasetsResponse.Marshal(b, m, deterministic)
}
func (m *ListDatasetsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDatasetsResponse.Merge(m, src)
}
func (m *ListDatasetsResponse) XXX_Size() int {
	return xxx_messageInfo_ListDatasetsResponse.Size(m)
}
func (m *ListDatasetsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDatasetsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListDatasetsResponse proto.InternalMessageInfo

func (m *ListDatasetsResponse) GetDatasets() []*Dataset {
	if m != nil {
		return m.Datasets
	}
	return nil
}

func (m *ListDatasetsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for
// [AutoMl.UpdateDataset][google.cloud.automl.v1.AutoMl.UpdateDataset]
type UpdateDatasetRequest struct {
	// The dataset which replaces the resource on the server.
	Dataset *Dataset `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// Required. The update mask applies to the resource.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateDatasetRequest) Reset()         { *m = UpdateDatasetRequest{} }
func (m *UpdateDatasetRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateDatasetRequest) ProtoMessage()    {}
func (*UpdateDatasetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{4}
}

func (m *UpdateDatasetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateDatasetRequest.Unmarshal(m, b)
}
func (m *UpdateDatasetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateDatasetRequest.Marshal(b, m, deterministic)
}
func (m *UpdateDatasetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateDatasetRequest.Merge(m, src)
}
func (m *UpdateDatasetRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateDatasetRequest.Size(m)
}
func (m *UpdateDatasetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateDatasetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateDatasetRequest proto.InternalMessageInfo

func (m *UpdateDatasetRequest) GetDataset() *Dataset {
	if m != nil {
		return m.Dataset
	}
	return nil
}

func (m *UpdateDatasetRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for
// [AutoMl.DeleteDataset][google.cloud.automl.v1.AutoMl.DeleteDataset].
type DeleteDatasetRequest struct {
	// The resource name of the dataset to delete.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteDatasetRequest) Reset()         { *m = DeleteDatasetRequest{} }
func (m *DeleteDatasetRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteDatasetRequest) ProtoMessage()    {}
func (*DeleteDatasetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{5}
}

func (m *DeleteDatasetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteDatasetRequest.Unmarshal(m, b)
}
func (m *DeleteDatasetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteDatasetRequest.Marshal(b, m, deterministic)
}
func (m *DeleteDatasetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteDatasetRequest.Merge(m, src)
}
func (m *DeleteDatasetRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteDatasetRequest.Size(m)
}
func (m *DeleteDatasetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteDatasetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteDatasetRequest proto.InternalMessageInfo

func (m *DeleteDatasetRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for
// [AutoMl.ImportData][google.cloud.automl.v1.AutoMl.ImportData].
type ImportDataRequest struct {
	// Required. Dataset name. Dataset must already exist. All imported
	// annotations and examples will be added.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The desired input location and its domain specific semantics,
	// if any.
	InputConfig          *InputConfig `protobuf:"bytes,3,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *ImportDataRequest) Reset()         { *m = ImportDataRequest{} }
func (m *ImportDataRequest) String() string { return proto.CompactTextString(m) }
func (*ImportDataRequest) ProtoMessage()    {}
func (*ImportDataRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{6}
}

func (m *ImportDataRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportDataRequest.Unmarshal(m, b)
}
func (m *ImportDataRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportDataRequest.Marshal(b, m, deterministic)
}
func (m *ImportDataRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportDataRequest.Merge(m, src)
}
func (m *ImportDataRequest) XXX_Size() int {
	return xxx_messageInfo_ImportDataRequest.Size(m)
}
func (m *ImportDataRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportDataRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ImportDataRequest proto.InternalMessageInfo

func (m *ImportDataRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ImportDataRequest) GetInputConfig() *InputConfig {
	if m != nil {
		return m.InputConfig
	}
	return nil
}

// Request message for
// [AutoMl.ExportData][google.cloud.automl.v1.AutoMl.ExportData].
type ExportDataRequest struct {
	// Required. The resource name of the dataset.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The desired output location.
	OutputConfig         *OutputConfig `protobuf:"bytes,3,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ExportDataRequest) Reset()         { *m = ExportDataRequest{} }
func (m *ExportDataRequest) String() string { return proto.CompactTextString(m) }
func (*ExportDataRequest) ProtoMessage()    {}
func (*ExportDataRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{7}
}

func (m *ExportDataRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportDataRequest.Unmarshal(m, b)
}
func (m *ExportDataRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportDataRequest.Marshal(b, m, deterministic)
}
func (m *ExportDataRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportDataRequest.Merge(m, src)
}
func (m *ExportDataRequest) XXX_Size() int {
	return xxx_messageInfo_ExportDataRequest.Size(m)
}
func (m *ExportDataRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportDataRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExportDataRequest proto.InternalMessageInfo

func (m *ExportDataRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ExportDataRequest) GetOutputConfig() *OutputConfig {
	if m != nil {
		return m.OutputConfig
	}
	return nil
}

// Request message for
// [AutoMl.GetAnnotationSpec][google.cloud.automl.v1.AutoMl.GetAnnotationSpec].
type GetAnnotationSpecRequest struct {
	// The resource name of the annotation spec to retrieve.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetAnnotationSpecRequest) Reset()         { *m = GetAnnotationSpecRequest{} }
func (m *GetAnnotationSpecRequest) String() string { return proto.CompactTextString(m) }
func (*GetAnnotationSpecRequest) ProtoMessage()    {}
func (*GetAnnotationSpecRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{8}
}

func (m *GetAnnotationSpecRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetAnnotationSpecRequest.Unmarshal(m, b)
}
func (m *GetAnnotationSpecRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetAnnotationSpecRequest.Marshal(b, m, deterministic)
}
func (m *GetAnnotationSpecRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetAnnotationSpecRequest.Merge(m, src)
}
func (m *GetAnnotationSpecRequest) XXX_Size() int {
	return xxx_messageInfo_GetAnnotationSpecRequest.Size(m)
}
func (m *GetAnnotationSpecRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetAnnotationSpecRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetAnnotationSpecRequest proto.InternalMessageInfo

func (m *GetAnnotationSpecRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for
// [AutoMl.CreateModel][google.cloud.automl.v1.AutoMl.CreateModel].
type CreateModelRequest struct {
	// Resource name of the parent project where the model is being created.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The model to create.
	Model                *Model   `protobuf:"bytes,4,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateModelRequest) Reset()         { *m = CreateModelRequest{} }
func (m *CreateModelRequest) String() string { return proto.CompactTextString(m) }
func (*CreateModelRequest) ProtoMessage()    {}
func (*CreateModelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{9}
}

func (m *CreateModelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateModelRequest.Unmarshal(m, b)
}
func (m *CreateModelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateModelRequest.Marshal(b, m, deterministic)
}
func (m *CreateModelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateModelRequest.Merge(m, src)
}
func (m *CreateModelRequest) XXX_Size() int {
	return xxx_messageInfo_CreateModelRequest.Size(m)
}
func (m *CreateModelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateModelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateModelRequest proto.InternalMessageInfo

func (m *CreateModelRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateModelRequest) GetModel() *Model {
	if m != nil {
		return m.Model
	}
	return nil
}

// Request message for
// [AutoMl.GetModel][google.cloud.automl.v1.AutoMl.GetModel].
type GetModelRequest struct {
	// Resource name of the model.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetModelRequest) Reset()         { *m = GetModelRequest{} }
func (m *GetModelRequest) String() string { return proto.CompactTextString(m) }
func (*GetModelRequest) ProtoMessage()    {}
func (*GetModelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{10}
}

func (m *GetModelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetModelRequest.Unmarshal(m, b)
}
func (m *GetModelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetModelRequest.Marshal(b, m, deterministic)
}
func (m *GetModelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetModelRequest.Merge(m, src)
}
func (m *GetModelRequest) XXX_Size() int {
	return xxx_messageInfo_GetModelRequest.Size(m)
}
func (m *GetModelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetModelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetModelRequest proto.InternalMessageInfo

func (m *GetModelRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for
// [AutoMl.ListModels][google.cloud.automl.v1.AutoMl.ListModels].
type ListModelsRequest struct {
	// Resource name of the project, from which to list the models.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// An expression for filtering the results of the request.
	//
	//   * `model_metadata` - for existence of the case (e.g.
	//             image_classification_model_metadata:*).
	//   * `dataset_id` - for = or !=. Some examples of using the filter are:
	//
	//   * `image_classification_model_metadata:*` --> The model has
	//                                        image_classification_model_metadata.
	//   * `dataset_id=5` --> The model was created from a dataset with ID 5.
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// Requested page size.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results for the server to return
	// Typically obtained via
	// [ListModelsResponse.next_page_token][google.cloud.automl.v1.ListModelsResponse.next_page_token]
	// of the previous
	// [AutoMl.ListModels][google.cloud.automl.v1.AutoMl.ListModels] call.
	PageToken            string   `protobuf:"bytes,6,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListModelsRequest) Reset()         { *m = ListModelsRequest{} }
func (m *ListModelsRequest) String() string { return proto.CompactTextString(m) }
func (*ListModelsRequest) ProtoMessage()    {}
func (*ListModelsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{11}
}

func (m *ListModelsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListModelsRequest.Unmarshal(m, b)
}
func (m *ListModelsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListModelsRequest.Marshal(b, m, deterministic)
}
func (m *ListModelsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListModelsRequest.Merge(m, src)
}
func (m *ListModelsRequest) XXX_Size() int {
	return xxx_messageInfo_ListModelsRequest.Size(m)
}
func (m *ListModelsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListModelsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListModelsRequest proto.InternalMessageInfo

func (m *ListModelsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListModelsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListModelsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListModelsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for
// [AutoMl.ListModels][google.cloud.automl.v1.AutoMl.ListModels].
type ListModelsResponse struct {
	// List of models in the requested page.
	Model []*Model `protobuf:"bytes,1,rep,name=model,proto3" json:"model,omitempty"`
	// A token to retrieve next page of results.
	// Pass to
	// [ListModelsRequest.page_token][google.cloud.automl.v1.ListModelsRequest.page_token]
	// to obtain that page.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListModelsResponse) Reset()         { *m = ListModelsResponse{} }
func (m *ListModelsResponse) String() string { return proto.CompactTextString(m) }
func (*ListModelsResponse) ProtoMessage()    {}
func (*ListModelsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{12}
}

func (m *ListModelsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListModelsResponse.Unmarshal(m, b)
}
func (m *ListModelsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListModelsResponse.Marshal(b, m, deterministic)
}
func (m *ListModelsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListModelsResponse.Merge(m, src)
}
func (m *ListModelsResponse) XXX_Size() int {
	return xxx_messageInfo_ListModelsResponse.Size(m)
}
func (m *ListModelsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListModelsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListModelsResponse proto.InternalMessageInfo

func (m *ListModelsResponse) GetModel() []*Model {
	if m != nil {
		return m.Model
	}
	return nil
}

func (m *ListModelsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for
// [AutoMl.DeleteModel][google.cloud.automl.v1.AutoMl.DeleteModel].
type DeleteModelRequest struct {
	// Resource name of the model being deleted.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteModelRequest) Reset()         { *m = DeleteModelRequest{} }
func (m *DeleteModelRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteModelRequest) ProtoMessage()    {}
func (*DeleteModelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{13}
}

func (m *DeleteModelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteModelRequest.Unmarshal(m, b)
}
func (m *DeleteModelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteModelRequest.Marshal(b, m, deterministic)
}
func (m *DeleteModelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteModelRequest.Merge(m, src)
}
func (m *DeleteModelRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteModelRequest.Size(m)
}
func (m *DeleteModelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteModelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteModelRequest proto.InternalMessageInfo

func (m *DeleteModelRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for
// [AutoMl.UpdateModel][google.cloud.automl.v1.AutoMl.UpdateModel]
type UpdateModelRequest struct {
	// The model which replaces the resource on the server.
	Model *Model `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// Required. The update mask applies to the resource.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateModelRequest) Reset()         { *m = UpdateModelRequest{} }
func (m *UpdateModelRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateModelRequest) ProtoMessage()    {}
func (*UpdateModelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{14}
}

func (m *UpdateModelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateModelRequest.Unmarshal(m, b)
}
func (m *UpdateModelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateModelRequest.Marshal(b, m, deterministic)
}
func (m *UpdateModelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateModelRequest.Merge(m, src)
}
func (m *UpdateModelRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateModelRequest.Size(m)
}
func (m *UpdateModelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateModelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateModelRequest proto.InternalMessageInfo

func (m *UpdateModelRequest) GetModel() *Model {
	if m != nil {
		return m.Model
	}
	return nil
}

func (m *UpdateModelRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for
// [AutoMl.DeployModel][google.cloud.automl.v1.AutoMl.DeployModel].
type DeployModelRequest struct {
	// The per-domain specific deployment parameters.
	//
	// Types that are valid to be assigned to ModelDeploymentMetadata:
	//	*DeployModelRequest_ImageObjectDetectionModelDeploymentMetadata
	//	*DeployModelRequest_ImageClassificationModelDeploymentMetadata
	ModelDeploymentMetadata isDeployModelRequest_ModelDeploymentMetadata `protobuf_oneof:"model_deployment_metadata"`
	// Resource name of the model to deploy.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeployModelRequest) Reset()         { *m = DeployModelRequest{} }
func (m *DeployModelRequest) String() string { return proto.CompactTextString(m) }
func (*DeployModelRequest) ProtoMessage()    {}
func (*DeployModelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{15}
}

func (m *DeployModelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeployModelRequest.Unmarshal(m, b)
}
func (m *DeployModelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeployModelRequest.Marshal(b, m, deterministic)
}
func (m *DeployModelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeployModelRequest.Merge(m, src)
}
func (m *DeployModelRequest) XXX_Size() int {
	return xxx_messageInfo_DeployModelRequest.Size(m)
}
func (m *DeployModelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeployModelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeployModelRequest proto.InternalMessageInfo

type isDeployModelRequest_ModelDeploymentMetadata interface {
	isDeployModelRequest_ModelDeploymentMetadata()
}

type DeployModelRequest_ImageObjectDetectionModelDeploymentMetadata struct {
	ImageObjectDetectionModelDeploymentMetadata *ImageObjectDetectionModelDeploymentMetadata `protobuf:"bytes,2,opt,name=image_object_detection_model_deployment_metadata,json=imageObjectDetectionModelDeploymentMetadata,proto3,oneof"`
}

type DeployModelRequest_ImageClassificationModelDeploymentMetadata struct {
	ImageClassificationModelDeploymentMetadata *ImageClassificationModelDeploymentMetadata `protobuf:"bytes,4,opt,name=image_classification_model_deployment_metadata,json=imageClassificationModelDeploymentMetadata,proto3,oneof"`
}

func (*DeployModelRequest_ImageObjectDetectionModelDeploymentMetadata) isDeployModelRequest_ModelDeploymentMetadata() {
}

func (*DeployModelRequest_ImageClassificationModelDeploymentMetadata) isDeployModelRequest_ModelDeploymentMetadata() {
}

func (m *DeployModelRequest) GetModelDeploymentMetadata() isDeployModelRequest_ModelDeploymentMetadata {
	if m != nil {
		return m.ModelDeploymentMetadata
	}
	return nil
}

func (m *DeployModelRequest) GetImageObjectDetectionModelDeploymentMetadata() *ImageObjectDetectionModelDeploymentMetadata {
	if x, ok := m.GetModelDeploymentMetadata().(*DeployModelRequest_ImageObjectDetectionModelDeploymentMetadata); ok {
		return x.ImageObjectDetectionModelDeploymentMetadata
	}
	return nil
}

func (m *DeployModelRequest) GetImageClassificationModelDeploymentMetadata() *ImageClassificationModelDeploymentMetadata {
	if x, ok := m.GetModelDeploymentMetadata().(*DeployModelRequest_ImageClassificationModelDeploymentMetadata); ok {
		return x.ImageClassificationModelDeploymentMetadata
	}
	return nil
}

func (m *DeployModelRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*DeployModelRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*DeployModelRequest_ImageObjectDetectionModelDeploymentMetadata)(nil),
		(*DeployModelRequest_ImageClassificationModelDeploymentMetadata)(nil),
	}
}

// Request message for
// [AutoMl.UndeployModel][google.cloud.automl.v1.AutoMl.UndeployModel].
type UndeployModelRequest struct {
	// Resource name of the model to undeploy.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UndeployModelRequest) Reset()         { *m = UndeployModelRequest{} }
func (m *UndeployModelRequest) String() string { return proto.CompactTextString(m) }
func (*UndeployModelRequest) ProtoMessage()    {}
func (*UndeployModelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{16}
}

func (m *UndeployModelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UndeployModelRequest.Unmarshal(m, b)
}
func (m *UndeployModelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UndeployModelRequest.Marshal(b, m, deterministic)
}
func (m *UndeployModelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UndeployModelRequest.Merge(m, src)
}
func (m *UndeployModelRequest) XXX_Size() int {
	return xxx_messageInfo_UndeployModelRequest.Size(m)
}
func (m *UndeployModelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UndeployModelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UndeployModelRequest proto.InternalMessageInfo

func (m *UndeployModelRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for
// [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]. Models need
// to be enabled for exporting, otherwise an error code will be returned.
type ExportModelRequest struct {
	// Required. The resource name of the model to export.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The desired output location and configuration.
	OutputConfig         *ModelExportOutputConfig `protobuf:"bytes,3,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *ExportModelRequest) Reset()         { *m = ExportModelRequest{} }
func (m *ExportModelRequest) String() string { return proto.CompactTextString(m) }
func (*ExportModelRequest) ProtoMessage()    {}
func (*ExportModelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{17}
}

func (m *ExportModelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportModelRequest.Unmarshal(m, b)
}
func (m *ExportModelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportModelRequest.Marshal(b, m, deterministic)
}
func (m *ExportModelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportModelRequest.Merge(m, src)
}
func (m *ExportModelRequest) XXX_Size() int {
	return xxx_messageInfo_ExportModelRequest.Size(m)
}
func (m *ExportModelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportModelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExportModelRequest proto.InternalMessageInfo

func (m *ExportModelRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ExportModelRequest) GetOutputConfig() *ModelExportOutputConfig {
	if m != nil {
		return m.OutputConfig
	}
	return nil
}

// Request message for
// [AutoMl.GetModelEvaluation][google.cloud.automl.v1.AutoMl.GetModelEvaluation].
type GetModelEvaluationRequest struct {
	// Resource name for the model evaluation.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetModelEvaluationRequest) Reset()         { *m = GetModelEvaluationRequest{} }
func (m *GetModelEvaluationRequest) String() string { return proto.CompactTextString(m) }
func (*GetModelEvaluationRequest) ProtoMessage()    {}
func (*GetModelEvaluationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{18}
}

func (m *GetModelEvaluationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetModelEvaluationRequest.Unmarshal(m, b)
}
func (m *GetModelEvaluationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetModelEvaluationRequest.Marshal(b, m, deterministic)
}
func (m *GetModelEvaluationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetModelEvaluationRequest.Merge(m, src)
}
func (m *GetModelEvaluationRequest) XXX_Size() int {
	return xxx_messageInfo_GetModelEvaluationRequest.Size(m)
}
func (m *GetModelEvaluationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetModelEvaluationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetModelEvaluationRequest proto.InternalMessageInfo

func (m *GetModelEvaluationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for
// [AutoMl.ListModelEvaluations][google.cloud.automl.v1.AutoMl.ListModelEvaluations].
type ListModelEvaluationsRequest struct {
	// Resource name of the model to list the model evaluations for.
	// If modelId is set as "-", this will list model evaluations from across all
	// models of the parent location.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// An expression for filtering the results of the request.
	//
	//   * `annotation_spec_id` - for =, !=  or existence. See example below for
	//                          the last.
	//
	// Some examples of using the filter are:
	//
	//   * `annotation_spec_id!=4` --> The model evaluation was done for
	//                             annotation spec with ID different than 4.
	//   * `NOT annotation_spec_id:*` --> The model evaluation was done for
	//                                aggregate of all annotation specs.
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// Requested page size.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results for the server to return.
	// Typically obtained via
	// [ListModelEvaluationsResponse.next_page_token][google.cloud.automl.v1.ListModelEvaluationsResponse.next_page_token]
	// of the previous
	// [AutoMl.ListModelEvaluations][google.cloud.automl.v1.AutoMl.ListModelEvaluations]
	// call.
	PageToken            string   `protobuf:"bytes,6,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListModelEvaluationsRequest) Reset()         { *m = ListModelEvaluationsRequest{} }
func (m *ListModelEvaluationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListModelEvaluationsRequest) ProtoMessage()    {}
func (*ListModelEvaluationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{19}
}

func (m *ListModelEvaluationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListModelEvaluationsRequest.Unmarshal(m, b)
}
func (m *ListModelEvaluationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListModelEvaluationsRequest.Marshal(b, m, deterministic)
}
func (m *ListModelEvaluationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListModelEvaluationsRequest.Merge(m, src)
}
func (m *ListModelEvaluationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListModelEvaluationsRequest.Size(m)
}
func (m *ListModelEvaluationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListModelEvaluationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListModelEvaluationsRequest proto.InternalMessageInfo

func (m *ListModelEvaluationsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListModelEvaluationsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListModelEvaluationsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListModelEvaluationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for
// [AutoMl.ListModelEvaluations][google.cloud.automl.v1.AutoMl.ListModelEvaluations].
type ListModelEvaluationsResponse struct {
	// List of model evaluations in the requested page.
	ModelEvaluation []*ModelEvaluation `protobuf:"bytes,1,rep,name=model_evaluation,json=modelEvaluation,proto3" json:"model_evaluation,omitempty"`
	// A token to retrieve next page of results.
	// Pass to the
	// [ListModelEvaluationsRequest.page_token][google.cloud.automl.v1.ListModelEvaluationsRequest.page_token]
	// field of a new
	// [AutoMl.ListModelEvaluations][google.cloud.automl.v1.AutoMl.ListModelEvaluations]
	// request to obtain that page.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListModelEvaluationsResponse) Reset()         { *m = ListModelEvaluationsResponse{} }
func (m *ListModelEvaluationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListModelEvaluationsResponse) ProtoMessage()    {}
func (*ListModelEvaluationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{20}
}

func (m *ListModelEvaluationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListModelEvaluationsResponse.Unmarshal(m, b)
}
func (m *ListModelEvaluationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListModelEvaluationsResponse.Marshal(b, m, deterministic)
}
func (m *ListModelEvaluationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListModelEvaluationsResponse.Merge(m, src)
}
func (m *ListModelEvaluationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListModelEvaluationsResponse.Size(m)
}
func (m *ListModelEvaluationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListModelEvaluationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListModelEvaluationsResponse proto.InternalMessageInfo

func (m *ListModelEvaluationsResponse) GetModelEvaluation() []*ModelEvaluation {
	if m != nil {
		return m.ModelEvaluation
	}
	return nil
}

func (m *ListModelEvaluationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*CreateDatasetRequest)(nil), "google.cloud.automl.v1.CreateDatasetRequest")
	proto.RegisterType((*GetDatasetRequest)(nil), "google.cloud.automl.v1.GetDatasetRequest")
	proto.RegisterType((*ListDatasetsRequest)(nil), "google.cloud.automl.v1.ListDatasetsRequest")
	proto.RegisterType((*ListDatasetsResponse)(nil), "google.cloud.automl.v1.ListDatasetsResponse")
	proto.RegisterType((*UpdateDatasetRequest)(nil), "google.cloud.automl.v1.UpdateDatasetRequest")
	proto.RegisterType((*DeleteDatasetRequest)(nil), "google.cloud.automl.v1.DeleteDatasetRequest")
	proto.RegisterType((*ImportDataRequest)(nil), "google.cloud.automl.v1.ImportDataRequest")
	proto.RegisterType((*ExportDataRequest)(nil), "google.cloud.automl.v1.ExportDataRequest")
	proto.RegisterType((*GetAnnotationSpecRequest)(nil), "google.cloud.automl.v1.GetAnnotationSpecRequest")
	proto.RegisterType((*CreateModelRequest)(nil), "google.cloud.automl.v1.CreateModelRequest")
	proto.RegisterType((*GetModelRequest)(nil), "google.cloud.automl.v1.GetModelRequest")
	proto.RegisterType((*ListModelsRequest)(nil), "google.cloud.automl.v1.ListModelsRequest")
	proto.RegisterType((*ListModelsResponse)(nil), "google.cloud.automl.v1.ListModelsResponse")
	proto.RegisterType((*DeleteModelRequest)(nil), "google.cloud.automl.v1.DeleteModelRequest")
	proto.RegisterType((*UpdateModelRequest)(nil), "google.cloud.automl.v1.UpdateModelRequest")
	proto.RegisterType((*DeployModelRequest)(nil), "google.cloud.automl.v1.DeployModelRequest")
	proto.RegisterType((*UndeployModelRequest)(nil), "google.cloud.automl.v1.UndeployModelRequest")
	proto.RegisterType((*ExportModelRequest)(nil), "google.cloud.automl.v1.ExportModelRequest")
	proto.RegisterType((*GetModelEvaluationRequest)(nil), "google.cloud.automl.v1.GetModelEvaluationRequest")
	proto.RegisterType((*ListModelEvaluationsRequest)(nil), "google.cloud.automl.v1.ListModelEvaluationsRequest")
	proto.RegisterType((*ListModelEvaluationsResponse)(nil), "google.cloud.automl.v1.ListModelEvaluationsResponse")
}

func init() {
	proto.RegisterFile("google/cloud/automl/v1/service.proto", fileDescriptor_d14ac936eda1c3a8)
}

var fileDescriptor_d14ac936eda1c3a8 = []byte{
	// 1501 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x58, 0x5b, 0x8f, 0x14, 0x45,
	0x14, 0xb6, 0x16, 0x58, 0xe1, 0x0c, 0x1b, 0xdc, 0x72, 0x5d, 0x66, 0x07, 0x08, 0x9b, 0x06, 0xd9,
	0x75, 0x58, 0xba, 0x99, 0x59, 0x22, 0x32, 0xdc, 0xdc, 0x0b, 0xac, 0x9b, 0xb0, 0x81, 0x0c, 0x97,
	0x07, 0x43, 0x32, 0x69, 0x66, 0x6a, 0x87, 0x96, 0x9e, 0xae, 0xa6, 0xbb, 0x7a, 0xb9, 0x05, 0x8d,
	0x3e, 0x90, 0x98, 0x28, 0x0f, 0x92, 0x68, 0x44, 0x13, 0x9e, 0x4c, 0x8c, 0xf1, 0xd5, 0xf0, 0x17,
	0x0c, 0x8f, 0xfa, 0x17, 0x7c, 0xf2, 0x57, 0x98, 0xae, 0xaa, 0x9e, 0xe9, 0x9e, 0xbe, 0x4e, 0x0c,
	0xe1, 0x6d, 0xba, 0xeb, 0xab, 0x3a, 0x5f, 0x7d, 0x75, 0xce, 0xa9, 0xaf, 0x07, 0x0e, 0x77, 0x29,
	0xed, 0x9a, 0x44, 0x6b, 0x9b, 0xd4, 0xeb, 0x68, 0xba, 0xc7, 0x68, 0xcf, 0xd4, 0xb6, 0x6a, 0x9a,
	0x4b, 0x9c, 0x2d, 0xa3, 0x4d, 0x54, 0xdb, 0xa1, 0x8c, 0xe2, 0x69, 0x81, 0x52, 0x39, 0x4a, 0x15,
	0x28, 0x75, 0xab, 0x56, 0xd9, 0x2f, 0x67, 0xeb, 0xb6, 0xa1, 0xe9, 0x96, 0x45, 0x99, 0xce, 0x0c,
	0x6a, 0xb9, 0x62, 0x56, 0x65, 0x6f, 0x68, 0xb4, 0x6d, 0x1a, 0xc4, 0x62, 0x72, 0x60, 0x26, 0x34,
	0xe0, 0x10, 0x97, 0x7a, 0x4e, 0x10, 0xa9, 0xa2, 0xa5, 0xf0, 0x19, 0xac, 0xde, 0xb2, 0xf5, 0x07,
	0x26, 0xd5, 0x3b, 0x72, 0xc2, 0x42, 0xfe, 0x04, 0xd7, 0x26, 0x6d, 0x89, 0x4e, 0xdb, 0x6e, 0x47,
	0x67, 0xba, 0x4b, 0x02, 0x7e, 0x4a, 0x0a, 0xca, 0xe8, 0xe9, 0xdd, 0x80, 0xe8, 0xc1, 0x34, 0x0c,
	0xcd, 0x59, 0xa4, 0x47, 0x3b, 0xc4, 0x94, 0x98, 0x63, 0x59, 0x98, 0x16, 0xd9, 0xd2, 0x4d, 0x8f,
	0x6f, 0x41, 0xc2, 0xe7, 0x52, 0xe0, 0xd4, 0x26, 0x4e, 0x44, 0xf9, 0x43, 0x12, 0x68, 0x52, 0xab,
	0xeb, 0x78, 0x96, 0x65, 0x58, 0xdd, 0x38, 0x68, 0x56, 0x82, 0xf8, 0xd3, 0x2d, 0x6f, 0x53, 0xdb,
	0x34, 0x88, 0xd9, 0x69, 0xf5, 0x74, 0xf7, 0x8e, 0x40, 0x28, 0x06, 0x4c, 0xad, 0x38, 0x44, 0x67,
	0x64, 0x55, 0xc8, 0xd3, 0x24, 0x77, 0x3d, 0xe2, 0x32, 0x3c, 0x0d, 0xe3, 0xb6, 0xee, 0x10, 0x8b,
	0x95, 0xd1, 0x2c, 0x9a, 0xdf, 0xd5, 0x94, 0x4f, 0xf8, 0x14, 0xbc, 0x2d, 0x85, 0x2c, 0x8f, 0xcd,
	0xa2, 0xf9, 0x52, 0xfd, 0xa0, 0x9a, 0x9c, 0x38, 0x6a, 0xb0, 0x60, 0x80, 0x57, 0xe6, 0x60, 0x72,
	0x8d, 0xb0, 0xa1, 0x38, 0x18, 0xb6, 0x5b, 0x7a, 0x8f, 0xc8, 0x28, 0xfc, 0xb7, 0xf2, 0x25, 0x82,
	0x77, 0x2f, 0x19, 0x6e, 0x00, 0x75, 0xf3, 0x38, 0x4d, 0xc3, 0xf8, 0xa6, 0x61, 0x32, 0xe2, 0x94,
	0xb7, 0x89, 0xf7, 0xe2, 0x09, 0xef, 0x83, 0x5d, 0xb6, 0xde, 0x25, 0x2d, 0xd7, 0x78, 0x48, 0xca,
	0xdb, 0x67, 0xd1, 0xfc, 0x8e, 0xe6, 0x4e, 0xff, 0xc5, 0x55, 0xe3, 0x21, 0xc1, 0x07, 0x00, 0xf8,
	0x20, 0xa3, 0x77, 0x88, 0x55, 0x1e, 0xe7, 0x13, 0x39, 0xfc, 0x9a, 0xff, 0x42, 0x79, 0x04, 0x53,
	0x51, 0x0a, 0xae, 0x4d, 0x2d, 0x97, 0xe0, 0xd3, 0xb0, 0x53, 0xee, 0xc7, 0x2d, 0xa3, 0xd9, 0x6d,
	0x45, 0x04, 0xe8, 0x4f, 0xc0, 0x47, 0x60, 0x8f, 0x45, 0xee, 0xb3, 0x56, 0x28, 0xf0, 0x18, 0x0f,
	0x3c, 0xe1, 0xbf, 0xbe, 0xd2, 0x0f, 0xfe, 0x14, 0xc1, 0xd4, 0x75, 0xbb, 0x13, 0x3f, 0x95, 0x90,
	0xfa, 0x68, 0x34, 0xf5, 0xf1, 0x69, 0x28, 0x79, 0x7c, 0x49, 0x7e, 0xfa, 0xf2, 0xf0, 0x2a, 0xc1,
	0xf4, 0x20, 0x41, 0xd4, 0x8b, 0x7e, 0x82, 0x6c, 0xe8, 0xee, 0x9d, 0x26, 0x08, 0xb8, 0xff, 0x5b,
	0xa9, 0xc2, 0xd4, 0x2a, 0x31, 0x49, 0x8c, 0x4f, 0xd2, 0xe9, 0x51, 0x98, 0x5c, 0xef, 0xd9, 0xd4,
	0xe1, 0xda, 0x65, 0x00, 0xf1, 0x45, 0xd8, 0x6d, 0x58, 0xb6, 0xc7, 0x5a, 0x6d, 0x6a, 0x6d, 0x1a,
	0x5d, 0x7e, 0x78, 0xa5, 0xfa, 0xa1, 0xb4, 0x1d, 0xad, 0xfb, 0xd8, 0x15, 0x0e, 0x6d, 0x96, 0x8c,
	0xc1, 0x83, 0xe2, 0xc0, 0xe4, 0x85, 0xfb, 0x45, 0x02, 0xae, 0xc3, 0x04, 0xf5, 0x58, 0x2c, 0xe2,
	0xe1, 0xb4, 0x88, 0x97, 0x39, 0x58, 0x86, 0xdc, 0x4d, 0x43, 0x4f, 0x8a, 0x0a, 0xe5, 0x35, 0xc2,
	0x96, 0xfa, 0x0d, 0xe8, 0xaa, 0x4d, 0xda, 0x59, 0xa2, 0xe8, 0x80, 0x45, 0x99, 0x6d, 0xf8, 0x65,
	0x9f, 0x97, 0xd0, 0x8b, 0xb0, 0x83, 0xb7, 0x07, 0x9e, 0xb4, 0xa5, 0xfa, 0x81, 0x34, 0x82, 0x62,
	0x31, 0x81, 0x55, 0xde, 0x87, 0x3d, 0x6b, 0x84, 0x45, 0xd6, 0x4f, 0x62, 0xf2, 0x05, 0x4c, 0xfa,
	0x89, 0xcd, 0x71, 0x6f, 0xa4, 0xb2, 0xee, 0x02, 0x0e, 0x13, 0x90, 0x75, 0xd5, 0xdf, 0xb2, 0x28,
	0xaa, 0x42, 0x5b, 0x2e, 0x5c, 0x4f, 0xf3, 0x80, 0x45, 0xfa, 0xe6, 0xaa, 0xf3, 0x04, 0x01, 0x16,
	0x95, 0x17, 0x81, 0x86, 0xd8, 0x15, 0x3e, 0x90, 0xff, 0x57, 0x71, 0x2f, 0xb6, 0xf9, 0x9c, 0x6d,
	0x93, 0x3e, 0x88, 0x10, 0xf9, 0x1d, 0xc1, 0x71, 0x7e, 0x45, 0xb5, 0xe8, 0xad, 0xcf, 0x48, 0x9b,
	0xb5, 0x3a, 0x84, 0x91, 0x36, 0xbf, 0x02, 0xc5, 0x85, 0xd2, 0xe1, 0x73, 0x7a, 0xc4, 0x62, 0xad,
	0x1e, 0x61, 0xba, 0x5f, 0xfd, 0x32, 0xf2, 0x4a, 0x6a, 0x61, 0xf9, 0xeb, 0x5d, 0xe6, 0xcb, 0xad,
	0x06, 0xab, 0xf1, 0xa0, 0xab, 0xfd, 0xb5, 0x36, 0xe4, 0x52, 0x9f, 0xbc, 0xd5, 0x3c, 0x6a, 0x14,
	0x87, 0xe3, 0x5f, 0x11, 0xa8, 0x82, 0x6e, 0xdb, 0xd4, 0x5d, 0xd7, 0xd8, 0x34, 0xda, 0x7a, 0x0e,
	0x59, 0x91, 0xf2, 0xcb, 0x99, 0x64, 0x57, 0x22, 0x8b, 0xa5, 0x73, 0xad, 0x1a, 0x85, 0xd1, 0x49,
	0xd9, 0xb0, 0xbc, 0x0f, 0x66, 0x52, 0x89, 0xfa, 0x3d, 0xf1, 0xba, 0xd5, 0x89, 0x1f, 0x51, 0x52,
	0x5a, 0x7d, 0x0e, 0x58, 0xb4, 0xa8, 0x3c, 0x24, 0xbe, 0x96, 0xdc, 0xa3, 0xb4, 0xcc, 0x8c, 0x13,
	0x6b, 0x67, 0xb4, 0x2b, 0x0d, 0x66, 0x82, 0xde, 0x70, 0xa1, 0xef, 0x38, 0xb2, 0x08, 0x7f, 0x8d,
	0x60, 0x5f, 0xbf, 0x4a, 0x07, 0x53, 0xde, 0x48, 0xc3, 0x78, 0x8e, 0x60, 0x7f, 0x32, 0x17, 0xd9,
	0x3b, 0x9a, 0xf0, 0xce, 0xb0, 0x9b, 0x92, 0x6d, 0x64, 0x2e, 0x5b, 0xb6, 0x81, 0x14, 0x7b, 0x7a,
	0xd1, 0x17, 0x45, 0x5b, 0x4b, 0xfd, 0xdb, 0xbd, 0x30, 0xbe, 0xe4, 0x31, 0xba, 0x61, 0xe2, 0x9f,
	0x10, 0x4c, 0x44, 0xbc, 0x14, 0x5e, 0x48, 0x0b, 0x9f, 0x64, 0xb9, 0x2a, 0xfd, 0xae, 0x12, 0xb2,
	0x74, 0xea, 0xe5, 0xc0, 0xd2, 0x29, 0x67, 0xbf, 0xfa, 0xfb, 0x9f, 0x67, 0x63, 0x27, 0x95, 0x05,
	0xdf, 0x0e, 0x3e, 0x12, 0x7a, 0x9f, 0xb5, 0x1d, 0xea, 0x17, 0xa2, 0xab, 0x55, 0x35, 0x93, 0x8a,
	0x04, 0x77, 0xb5, 0xea, 0xe3, 0xc0, 0xec, 0xba, 0x8d, 0xfe, 0xfd, 0xff, 0x14, 0x01, 0x0c, 0xec,
	0x17, 0xfe, 0x20, 0x8d, 0x5a, 0xcc, 0xa2, 0x55, 0xf2, 0x3c, 0x86, 0x72, 0x82, 0x33, 0x53, 0xb1,
	0x60, 0xe6, 0xe7, 0x4f, 0x0a, 0xaf, 0x3e, 0x2d, 0xad, 0xfa, 0x18, 0xbf, 0x40, 0xb0, 0x3b, 0x6c,
	0xb1, 0xf0, 0xd1, 0xb4, 0x38, 0x09, 0x5e, 0xb0, 0xb2, 0x50, 0x0c, 0x2c, 0x32, 0x64, 0x88, 0x61,
	0x41, 0xed, 0xf0, 0x2f, 0x08, 0x26, 0x22, 0x36, 0x2c, 0xfd, 0x40, 0x93, 0xdc, 0x5a, 0xbe, 0x70,
	0x17, 0x38, 0xad, 0xf3, 0xf5, 0x13, 0x9c, 0x56, 0xf0, 0x81, 0x52, 0x50, 0xc0, 0xc1, 0xd1, 0x7e,
	0x87, 0x60, 0x22, 0x62, 0xcf, 0xd2, 0x79, 0x26, 0xb9, 0xb8, 0xbc, 0xc4, 0x93, 0xe2, 0x55, 0x47,
	0x3b, 0xde, 0xe7, 0x08, 0x60, 0xe0, 0x03, 0xd3, 0xf3, 0x2d, 0xe6, 0x15, 0xf3, 0xe8, 0x2c, 0x73,
	0x3a, 0x67, 0x94, 0x93, 0xa3, 0xd0, 0x69, 0x18, 0xfd, 0x30, 0x0d, 0x54, 0xe5, 0xe4, 0x06, 0x9e,
	0x31, 0x9d, 0x5c, 0xcc, 0x57, 0xbe, 0x1e, 0x72, 0xe4, 0x7e, 0x98, 0xdc, 0x1f, 0x88, 0x7f, 0x28,
	0x45, 0xcd, 0x25, 0x3e, 0x9e, 0x51, 0xb0, 0x89, 0x3e, 0xb4, 0x72, 0x24, 0x6d, 0x46, 0x14, 0xae,
	0x5c, 0xe4, 0x9c, 0x3f, 0xc6, 0xe7, 0x46, 0xe0, 0x1c, 0xfa, 0xf6, 0xf6, 0xd7, 0xe0, 0x27, 0xfe,
	0x0c, 0x41, 0x29, 0x64, 0x72, 0x71, 0x35, 0xbb, 0xfb, 0x85, 0xaf, 0xc2, 0x3c, 0x59, 0x4f, 0x71,
	0x8a, 0x8b, 0x4a, 0xb5, 0x48, 0xfd, 0xf2, 0x56, 0xee, 0x36, 0xa4, 0x0b, 0x7b, 0x82, 0x60, 0x67,
	0x70, 0xf7, 0xe1, 0xb9, 0x0c, 0x11, 0x93, 0xf9, 0x24, 0x5e, 0x1c, 0x4a, 0x9d, 0xf3, 0x59, 0xc0,
	0xd5, 0x5c, 0xc9, 0x04, 0x19, 0x5f, 0x9e, 0x1f, 0x10, 0xc0, 0xc0, 0xf8, 0xa6, 0xe7, 0x5c, 0xcc,
	0x9d, 0x57, 0xaa, 0x45, 0xa0, 0xb2, 0xd3, 0x45, 0x99, 0x15, 0x52, 0x0a, 0x7f, 0x83, 0xa0, 0x14,
	0xf2, 0xc7, 0xe9, 0x07, 0x17, 0x37, 0xd1, 0x79, 0x07, 0x27, 0xe9, 0x54, 0x47, 0x11, 0xea, 0x47,
	0x04, 0xa5, 0x90, 0x07, 0x4f, 0xa7, 0x13, 0x37, 0xea, 0x79, 0xe7, 0x76, 0x9e, 0xd3, 0x39, 0x55,
	0x3f, 0xce, 0xe9, 0x88, 0xbf, 0x69, 0x0a, 0x91, 0x0a, 0xb2, 0xe9, 0x7b, 0x2e, 0x55, 0xdf, 0xf3,
	0x65, 0x49, 0x35, 0x6c, 0x0c, 0xf3, 0xa4, 0x3a, 0xc3, 0xb9, 0x7d, 0xa8, 0xd4, 0x8a, 0x4b, 0xd5,
	0x10, 0xf6, 0xd3, 0x6f, 0x1a, 0x3f, 0xfb, 0x77, 0x55, 0xd8, 0x8e, 0x66, 0xdc, 0x55, 0x09, 0xae,
	0x35, 0x8f, 0xdc, 0x39, 0x4e, 0xee, 0x23, 0x65, 0x71, 0x04, 0x72, 0x9e, 0x35, 0xa0, 0xe7, 0xeb,
	0x16, 0x72, 0xc0, 0xe9, 0xba, 0xc5, 0x6d, 0xf2, 0xeb, 0xd0, 0x4d, 0x34, 0x5c, 0x9f, 0xd8, 0x4b,
	0x04, 0x38, 0x6e, 0x8d, 0x71, 0x2d, 0xaf, 0x51, 0xc4, 0x6c, 0x74, 0xa5, 0xa8, 0xd7, 0x0c, 0x6e,
	0x7d, 0x7c, 0xb6, 0x30, 0x61, 0x6d, 0xc8, 0x9d, 0xf2, 0x32, 0xf9, 0x13, 0x89, 0xbf, 0xa8, 0x86,
	0x6d, 0x31, 0x5e, 0xcc, 0x6d, 0x17, 0x71, 0x43, 0x5f, 0x39, 0x31, 0xda, 0x24, 0xd9, 0x6d, 0xa2,
	0x5b, 0xc9, 0xec, 0x36, 0x03, 0xf5, 0x63, 0xbb, 0xa9, 0xac, 0xbf, 0x5a, 0x7a, 0x4f, 0x46, 0x14,
	0x2c, 0x74, 0xdb, 0x70, 0xd5, 0x36, 0xed, 0xfd, 0xb5, 0xa4, 0xde, 0x66, 0xcc, 0x76, 0x1b, 0x9a,
	0x76, 0xef, 0xde, 0xbd, 0xa1, 0x41, 0x4d, 0xf7, 0xd8, 0x6d, 0xf1, 0x47, 0xe9, 0x31, 0xdb, 0xd4,
	0xd9, 0x26, 0x75, 0x7a, 0xcb, 0x2f, 0x11, 0x54, 0xda, 0xb4, 0x97, 0xb2, 0x9b, 0xe5, 0x92, 0xf0,
	0xea, 0x57, 0xfc, 0x8f, 0xef, 0x2b, 0xe8, 0xd3, 0x33, 0x12, 0xd6, 0xa5, 0xa6, 0x6e, 0x75, 0x55,
	0xea, 0x74, 0xb5, 0x2e, 0xb1, 0xf8, 0xa7, 0xb9, 0x36, 0x08, 0x36, 0xfc, 0x67, 0xec, 0x69, 0xf1,
	0xeb, 0xb7, 0xb1, 0xe9, 0x35, 0x31, 0x7d, 0x85, 0x47, 0xe1, 0x4b, 0x5f, 0x52, 0x6f, 0xd4, 0x5e,
	0x05, 0x03, 0x37, 0xf9, 0xc0, 0x4d, 0x11, 0xf3, 0xe6, 0x8d, 0xda, 0xbf, 0x63, 0x33, 0x62, 0xa0,
	0xd1, 0xe0, 0x23, 0x8d, 0x86, 0x98, 0xd3, 0x68, 0xdc, 0xa8, 0xdd, 0x1a, 0xe7, 0x61, 0x17, 0xff,
	0x0b, 0x00, 0x00, 0xff, 0xff, 0x5c, 0x32, 0x93, 0xb7, 0xaf, 0x17, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// AutoMlClient is the client API for AutoMl service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AutoMlClient interface {
	// Creates a dataset.
	CreateDataset(ctx context.Context, in *CreateDatasetRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets a dataset.
	GetDataset(ctx context.Context, in *GetDatasetRequest, opts ...grpc.CallOption) (*Dataset, error)
	// Lists datasets in a project.
	ListDatasets(ctx context.Context, in *ListDatasetsRequest, opts ...grpc.CallOption) (*ListDatasetsResponse, error)
	// Updates a dataset.
	UpdateDataset(ctx context.Context, in *UpdateDatasetRequest, opts ...grpc.CallOption) (*Dataset, error)
	// Deletes a dataset and all of its contents.
	// Returns empty response in the
	// [response][google.longrunning.Operation.response] field when it completes,
	// and `delete_details` in the
	// [metadata][google.longrunning.Operation.metadata] field.
	DeleteDataset(ctx context.Context, in *DeleteDatasetRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Imports data into a dataset.
	ImportData(ctx context.Context, in *ImportDataRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Exports dataset's data to the provided output location.
	// Returns an empty response in the
	// [response][google.longrunning.Operation.response] field when it completes.
	ExportData(ctx context.Context, in *ExportDataRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets an annotation spec.
	GetAnnotationSpec(ctx context.Context, in *GetAnnotationSpecRequest, opts ...grpc.CallOption) (*AnnotationSpec, error)
	// Creates a model.
	// Returns a Model in the [response][google.longrunning.Operation.response]
	// field when it completes.
	// When you create a model, several model evaluations are created for it:
	// a global evaluation, and one evaluation for each annotation spec.
	CreateModel(ctx context.Context, in *CreateModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets a model.
	GetModel(ctx context.Context, in *GetModelRequest, opts ...grpc.CallOption) (*Model, error)
	// Lists models.
	ListModels(ctx context.Context, in *ListModelsRequest, opts ...grpc.CallOption) (*ListModelsResponse, error)
	// Deletes a model.
	// Returns `google.protobuf.Empty` in the
	// [response][google.longrunning.Operation.response] field when it completes,
	// and `delete_details` in the
	// [metadata][google.longrunning.Operation.metadata] field.
	DeleteModel(ctx context.Context, in *DeleteModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates a model.
	UpdateModel(ctx context.Context, in *UpdateModelRequest, opts ...grpc.CallOption) (*Model, error)
	// Deploys a model. If a model is already deployed, deploying it with the
	// same parameters has no effect. Deploying with different parametrs
	// (as e.g. changing
	//
	// [node_number][google.cloud.automl.v1.ImageObjectDetectionModelDeploymentMetadata.node_number])
	//  will reset the deployment state without pausing the model's availability.
	//
	// Only applicable for Text Classification, Image Object Detection; all other
	// domains manage deployment automatically.
	//
	// Returns an empty response in the
	// [response][google.longrunning.Operation.response] field when it completes.
	DeployModel(ctx context.Context, in *DeployModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Undeploys a model. If the model is not deployed this method has no effect.
	//
	// Only applicable for Text Classification, Image Object Detection;
	// all other domains manage deployment automatically.
	//
	// Returns an empty response in the
	// [response][google.longrunning.Operation.response] field when it completes.
	UndeployModel(ctx context.Context, in *UndeployModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Exports a trained, "export-able", model to a user specified Google Cloud
	// Storage location. A model is considered export-able if and only if it has
	// an export format defined for it in
	// [ModelExportOutputConfig][google.cloud.automl.v1.ModelExportOutputConfig].
	//
	// Returns an empty response in the
	// [response][google.longrunning.Operation.response] field when it completes.
	ExportModel(ctx context.Context, in *ExportModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets a model evaluation.
	GetModelEvaluation(ctx context.Context, in *GetModelEvaluationRequest, opts ...grpc.CallOption) (*ModelEvaluation, error)
	// Lists model evaluations.
	ListModelEvaluations(ctx context.Context, in *ListModelEvaluationsRequest, opts ...grpc.CallOption) (*ListModelEvaluationsResponse, error)
}

type autoMlClient struct {
	cc *grpc.ClientConn
}

func NewAutoMlClient(cc *grpc.ClientConn) AutoMlClient {
	return &autoMlClient{cc}
}

func (c *autoMlClient) CreateDataset(ctx context.Context, in *CreateDatasetRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/CreateDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) GetDataset(ctx context.Context, in *GetDatasetRequest, opts ...grpc.CallOption) (*Dataset, error) {
	out := new(Dataset)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/GetDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) ListDatasets(ctx context.Context, in *ListDatasetsRequest, opts ...grpc.CallOption) (*ListDatasetsResponse, error) {
	out := new(ListDatasetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/ListDatasets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) UpdateDataset(ctx context.Context, in *UpdateDatasetRequest, opts ...grpc.CallOption) (*Dataset, error) {
	out := new(Dataset)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/UpdateDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) DeleteDataset(ctx context.Context, in *DeleteDatasetRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/DeleteDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) ImportData(ctx context.Context, in *ImportDataRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/ImportData", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) ExportData(ctx context.Context, in *ExportDataRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/ExportData", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) GetAnnotationSpec(ctx context.Context, in *GetAnnotationSpecRequest, opts ...grpc.CallOption) (*AnnotationSpec, error) {
	out := new(AnnotationSpec)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/GetAnnotationSpec", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) CreateModel(ctx context.Context, in *CreateModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/CreateModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) GetModel(ctx context.Context, in *GetModelRequest, opts ...grpc.CallOption) (*Model, error) {
	out := new(Model)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/GetModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) ListModels(ctx context.Context, in *ListModelsRequest, opts ...grpc.CallOption) (*ListModelsResponse, error) {
	out := new(ListModelsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/ListModels", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) DeleteModel(ctx context.Context, in *DeleteModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/DeleteModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) UpdateModel(ctx context.Context, in *UpdateModelRequest, opts ...grpc.CallOption) (*Model, error) {
	out := new(Model)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/UpdateModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) DeployModel(ctx context.Context, in *DeployModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/DeployModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) UndeployModel(ctx context.Context, in *UndeployModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/UndeployModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) ExportModel(ctx context.Context, in *ExportModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/ExportModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) GetModelEvaluation(ctx context.Context, in *GetModelEvaluationRequest, opts ...grpc.CallOption) (*ModelEvaluation, error) {
	out := new(ModelEvaluation)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/GetModelEvaluation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) ListModelEvaluations(ctx context.Context, in *ListModelEvaluationsRequest, opts ...grpc.CallOption) (*ListModelEvaluationsResponse, error) {
	out := new(ListModelEvaluationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/ListModelEvaluations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AutoMlServer is the server API for AutoMl service.
type AutoMlServer interface {
	// Creates a dataset.
	CreateDataset(context.Context, *CreateDatasetRequest) (*longrunning.Operation, error)
	// Gets a dataset.
	GetDataset(context.Context, *GetDatasetRequest) (*Dataset, error)
	// Lists datasets in a project.
	ListDatasets(context.Context, *ListDatasetsRequest) (*ListDatasetsResponse, error)
	// Updates a dataset.
	UpdateDataset(context.Context, *UpdateDatasetRequest) (*Dataset, error)
	// Deletes a dataset and all of its contents.
	// Returns empty response in the
	// [response][google.longrunning.Operation.response] field when it completes,
	// and `delete_details` in the
	// [metadata][google.longrunning.Operation.metadata] field.
	DeleteDataset(context.Context, *DeleteDatasetRequest) (*longrunning.Operation, error)
	// Imports data into a dataset.
	ImportData(context.Context, *ImportDataRequest) (*longrunning.Operation, error)
	// Exports dataset's data to the provided output location.
	// Returns an empty response in the
	// [response][google.longrunning.Operation.response] field when it completes.
	ExportData(context.Context, *ExportDataRequest) (*longrunning.Operation, error)
	// Gets an annotation spec.
	GetAnnotationSpec(context.Context, *GetAnnotationSpecRequest) (*AnnotationSpec, error)
	// Creates a model.
	// Returns a Model in the [response][google.longrunning.Operation.response]
	// field when it completes.
	// When you create a model, several model evaluations are created for it:
	// a global evaluation, and one evaluation for each annotation spec.
	CreateModel(context.Context, *CreateModelRequest) (*longrunning.Operation, error)
	// Gets a model.
	GetModel(context.Context, *GetModelRequest) (*Model, error)
	// Lists models.
	ListModels(context.Context, *ListModelsRequest) (*ListModelsResponse, error)
	// Deletes a model.
	// Returns `google.protobuf.Empty` in the
	// [response][google.longrunning.Operation.response] field when it completes,
	// and `delete_details` in the
	// [metadata][google.longrunning.Operation.metadata] field.
	DeleteModel(context.Context, *DeleteModelRequest) (*longrunning.Operation, error)
	// Updates a model.
	UpdateModel(context.Context, *UpdateModelRequest) (*Model, error)
	// Deploys a model. If a model is already deployed, deploying it with the
	// same parameters has no effect. Deploying with different parametrs
	// (as e.g. changing
	//
	// [node_number][google.cloud.automl.v1.ImageObjectDetectionModelDeploymentMetadata.node_number])
	//  will reset the deployment state without pausing the model's availability.
	//
	// Only applicable for Text Classification, Image Object Detection; all other
	// domains manage deployment automatically.
	//
	// Returns an empty response in the
	// [response][google.longrunning.Operation.response] field when it completes.
	DeployModel(context.Context, *DeployModelRequest) (*longrunning.Operation, error)
	// Undeploys a model. If the model is not deployed this method has no effect.
	//
	// Only applicable for Text Classification, Image Object Detection;
	// all other domains manage deployment automatically.
	//
	// Returns an empty response in the
	// [response][google.longrunning.Operation.response] field when it completes.
	UndeployModel(context.Context, *UndeployModelRequest) (*longrunning.Operation, error)
	// Exports a trained, "export-able", model to a user specified Google Cloud
	// Storage location. A model is considered export-able if and only if it has
	// an export format defined for it in
	// [ModelExportOutputConfig][google.cloud.automl.v1.ModelExportOutputConfig].
	//
	// Returns an empty response in the
	// [response][google.longrunning.Operation.response] field when it completes.
	ExportModel(context.Context, *ExportModelRequest) (*longrunning.Operation, error)
	// Gets a model evaluation.
	GetModelEvaluation(context.Context, *GetModelEvaluationRequest) (*ModelEvaluation, error)
	// Lists model evaluations.
	ListModelEvaluations(context.Context, *ListModelEvaluationsRequest) (*ListModelEvaluationsResponse, error)
}

// UnimplementedAutoMlServer can be embedded to have forward compatible implementations.
type UnimplementedAutoMlServer struct {
}

func (*UnimplementedAutoMlServer) CreateDataset(ctx context.Context, req *CreateDatasetRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDataset not implemented")
}
func (*UnimplementedAutoMlServer) GetDataset(ctx context.Context, req *GetDatasetRequest) (*Dataset, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataset not implemented")
}
func (*UnimplementedAutoMlServer) ListDatasets(ctx context.Context, req *ListDatasetsRequest) (*ListDatasetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDatasets not implemented")
}
func (*UnimplementedAutoMlServer) UpdateDataset(ctx context.Context, req *UpdateDatasetRequest) (*Dataset, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDataset not implemented")
}
func (*UnimplementedAutoMlServer) DeleteDataset(ctx context.Context, req *DeleteDatasetRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDataset not implemented")
}
func (*UnimplementedAutoMlServer) ImportData(ctx context.Context, req *ImportDataRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportData not implemented")
}
func (*UnimplementedAutoMlServer) ExportData(ctx context.Context, req *ExportDataRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportData not implemented")
}
func (*UnimplementedAutoMlServer) GetAnnotationSpec(ctx context.Context, req *GetAnnotationSpecRequest) (*AnnotationSpec, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAnnotationSpec not implemented")
}
func (*UnimplementedAutoMlServer) CreateModel(ctx context.Context, req *CreateModelRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateModel not implemented")
}
func (*UnimplementedAutoMlServer) GetModel(ctx context.Context, req *GetModelRequest) (*Model, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetModel not implemented")
}
func (*UnimplementedAutoMlServer) ListModels(ctx context.Context, req *ListModelsRequest) (*ListModelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListModels not implemented")
}
func (*UnimplementedAutoMlServer) DeleteModel(ctx context.Context, req *DeleteModelRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteModel not implemented")
}
func (*UnimplementedAutoMlServer) UpdateModel(ctx context.Context, req *UpdateModelRequest) (*Model, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateModel not implemented")
}
func (*UnimplementedAutoMlServer) DeployModel(ctx context.Context, req *DeployModelRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeployModel not implemented")
}
func (*UnimplementedAutoMlServer) UndeployModel(ctx context.Context, req *UndeployModelRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UndeployModel not implemented")
}
func (*UnimplementedAutoMlServer) ExportModel(ctx context.Context, req *ExportModelRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportModel not implemented")
}
func (*UnimplementedAutoMlServer) GetModelEvaluation(ctx context.Context, req *GetModelEvaluationRequest) (*ModelEvaluation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetModelEvaluation not implemented")
}
func (*UnimplementedAutoMlServer) ListModelEvaluations(ctx context.Context, req *ListModelEvaluationsRequest) (*ListModelEvaluationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListModelEvaluations not implemented")
}

func RegisterAutoMlServer(s *grpc.Server, srv AutoMlServer) {
	s.RegisterService(&_AutoMl_serviceDesc, srv)
}

func _AutoMl_CreateDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).CreateDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/CreateDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).CreateDataset(ctx, req.(*CreateDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_GetDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).GetDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/GetDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).GetDataset(ctx, req.(*GetDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_ListDatasets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDatasetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).ListDatasets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/ListDatasets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).ListDatasets(ctx, req.(*ListDatasetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_UpdateDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).UpdateDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/UpdateDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).UpdateDataset(ctx, req.(*UpdateDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_DeleteDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).DeleteDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/DeleteDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).DeleteDataset(ctx, req.(*DeleteDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_ImportData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).ImportData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/ImportData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).ImportData(ctx, req.(*ImportDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_ExportData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).ExportData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/ExportData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).ExportData(ctx, req.(*ExportDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_GetAnnotationSpec_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAnnotationSpecRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).GetAnnotationSpec(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/GetAnnotationSpec",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).GetAnnotationSpec(ctx, req.(*GetAnnotationSpecRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_CreateModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).CreateModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/CreateModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).CreateModel(ctx, req.(*CreateModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_GetModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).GetModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/GetModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).GetModel(ctx, req.(*GetModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_ListModels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListModelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).ListModels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/ListModels",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).ListModels(ctx, req.(*ListModelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_DeleteModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).DeleteModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/DeleteModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).DeleteModel(ctx, req.(*DeleteModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_UpdateModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).UpdateModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/UpdateModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).UpdateModel(ctx, req.(*UpdateModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_DeployModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeployModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).DeployModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/DeployModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).DeployModel(ctx, req.(*DeployModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_UndeployModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeployModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).UndeployModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/UndeployModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).UndeployModel(ctx, req.(*UndeployModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_ExportModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).ExportModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/ExportModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).ExportModel(ctx, req.(*ExportModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_GetModelEvaluation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetModelEvaluationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).GetModelEvaluation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/GetModelEvaluation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).GetModelEvaluation(ctx, req.(*GetModelEvaluationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_ListModelEvaluations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListModelEvaluationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).ListModelEvaluations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/ListModelEvaluations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).ListModelEvaluations(ctx, req.(*ListModelEvaluationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AutoMl_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.automl.v1.AutoMl",
	HandlerType: (*AutoMlServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateDataset",
			Handler:    _AutoMl_CreateDataset_Handler,
		},
		{
			MethodName: "GetDataset",
			Handler:    _AutoMl_GetDataset_Handler,
		},
		{
			MethodName: "ListDatasets",
			Handler:    _AutoMl_ListDatasets_Handler,
		},
		{
			MethodName: "UpdateDataset",
			Handler:    _AutoMl_UpdateDataset_Handler,
		},
		{
			MethodName: "DeleteDataset",
			Handler:    _AutoMl_DeleteDataset_Handler,
		},
		{
			MethodName: "ImportData",
			Handler:    _AutoMl_ImportData_Handler,
		},
		{
			MethodName: "ExportData",
			Handler:    _AutoMl_ExportData_Handler,
		},
		{
			MethodName: "GetAnnotationSpec",
			Handler:    _AutoMl_GetAnnotationSpec_Handler,
		},
		{
			MethodName: "CreateModel",
			Handler:    _AutoMl_CreateModel_Handler,
		},
		{
			MethodName: "GetModel",
			Handler:    _AutoMl_GetModel_Handler,
		},
		{
			MethodName: "ListModels",
			Handler:    _AutoMl_ListModels_Handler,
		},
		{
			MethodName: "DeleteModel",
			Handler:    _AutoMl_DeleteModel_Handler,
		},
		{
			MethodName: "UpdateModel",
			Handler:    _AutoMl_UpdateModel_Handler,
		},
		{
			MethodName: "DeployModel",
			Handler:    _AutoMl_DeployModel_Handler,
		},
		{
			MethodName: "UndeployModel",
			Handler:    _AutoMl_UndeployModel_Handler,
		},
		{
			MethodName: "ExportModel",
			Handler:    _AutoMl_ExportModel_Handler,
		},
		{
			MethodName: "GetModelEvaluation",
			Handler:    _AutoMl_GetModelEvaluation_Handler,
		},
		{
			MethodName: "ListModelEvaluations",
			Handler:    _AutoMl_ListModelEvaluations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/automl/v1/service.proto",
}
