#!/usr/bin/env bash

#  Copyright 2018 The Kubernetes Authors.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

set -e

export GO111MODULE=on
export TRACE=1

# Not included or existing by default in Prow
export PATH=$(go env GOPATH)/bin:$PATH
mkdir -p $(go env GOPATH)/bin

echo "Installing dep"
export DEP_RELEASE_TAG=v0.5.4
curl --location --silent --retry 5 --fail https://raw.githubusercontent.com/golang/dep/master/install.sh | sh
echo "Finished installing dep"

echo "Installing golangci-lint"
curl --location --silent --retry 5 --fail  https://install.goreleaser.com/github.com/golangci/golangci-lint.sh | sh -s -- -b $(go env GOPATH)/bin v1.15.0
echo "Finished installing golangci-lint"

$(dirname ${BASH_SOURCE})/check-everything.sh
