// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directoryservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ShareDirectoryInput struct {
	_ struct{} `type:"structure"`

	// Identifier of the AWS Managed Microsoft AD directory that you want to share
	// with other AWS accounts.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The method used when sharing a directory to determine whether the directory
	// should be shared within your AWS organization (ORGANIZATIONS) or with any
	// AWS account by sending a directory sharing request (HANDSHAKE).
	//
	// ShareMethod is a required field
	ShareMethod ShareMethod `type:"string" required:"true" enum:"true"`

	// A directory share request that is sent by the directory owner to the directory
	// consumer. The request includes a typed message to help the directory consumer
	// administrator determine whether to approve or reject the share invitation.
	ShareNotes *string `type:"string" sensitive:"true"`

	// Identifier for the directory consumer account with whom the directory is
	// to be shared.
	//
	// ShareTarget is a required field
	ShareTarget *ShareTarget `type:"structure" required:"true"`
}

// String returns the string representation
func (s ShareDirectoryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ShareDirectoryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ShareDirectoryInput"}

	if s.DirectoryId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DirectoryId"))
	}
	if len(s.ShareMethod) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ShareMethod"))
	}

	if s.ShareTarget == nil {
		invalidParams.Add(aws.NewErrParamRequired("ShareTarget"))
	}
	if s.ShareTarget != nil {
		if err := s.ShareTarget.Validate(); err != nil {
			invalidParams.AddNested("ShareTarget", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ShareDirectoryOutput struct {
	_ struct{} `type:"structure"`

	// Identifier of the directory that is stored in the directory consumer account
	// that is shared from the specified directory (DirectoryId).
	SharedDirectoryId *string `type:"string"`
}

// String returns the string representation
func (s ShareDirectoryOutput) String() string {
	return awsutil.Prettify(s)
}

const opShareDirectory = "ShareDirectory"

// ShareDirectoryRequest returns a request value for making API operation for
// AWS Directory Service.
//
// Shares a specified directory (DirectoryId) in your AWS account (directory
// owner) with another AWS account (directory consumer). With this operation
// you can use your directory from any AWS account and from any Amazon VPC within
// an AWS Region.
//
// When you share your AWS Managed Microsoft AD directory, AWS Directory Service
// creates a shared directory in the directory consumer account. This shared
// directory contains the metadata to provide access to the directory within
// the directory owner account. The shared directory is visible in all VPCs
// in the directory consumer account.
//
// The ShareMethod parameter determines whether the specified directory can
// be shared between AWS accounts inside the same AWS organization (ORGANIZATIONS).
// It also determines whether you can share the directory with any other AWS
// account either inside or outside of the organization (HANDSHAKE).
//
// The ShareNotes parameter is only used when HANDSHAKE is called, which sends
// a directory sharing request to the directory consumer.
//
//    // Example sending a request using ShareDirectoryRequest.
//    req := client.ShareDirectoryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ShareDirectory
func (c *Client) ShareDirectoryRequest(input *ShareDirectoryInput) ShareDirectoryRequest {
	op := &aws.Operation{
		Name:       opShareDirectory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ShareDirectoryInput{}
	}

	req := c.newRequest(op, input, &ShareDirectoryOutput{})
	return ShareDirectoryRequest{Request: req, Input: input, Copy: c.ShareDirectoryRequest}
}

// ShareDirectoryRequest is the request type for the
// ShareDirectory API operation.
type ShareDirectoryRequest struct {
	*aws.Request
	Input *ShareDirectoryInput
	Copy  func(*ShareDirectoryInput) ShareDirectoryRequest
}

// Send marshals and sends the ShareDirectory API request.
func (r ShareDirectoryRequest) Send(ctx context.Context) (*ShareDirectoryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ShareDirectoryResponse{
		ShareDirectoryOutput: r.Request.Data.(*ShareDirectoryOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ShareDirectoryResponse is the response type for the
// ShareDirectory API operation.
type ShareDirectoryResponse struct {
	*ShareDirectoryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ShareDirectory request.
func (r *ShareDirectoryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
