// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package frauddetector

import (
	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Provides the error of the batch create variable API.
type BatchCreateVariableError struct {
	_ struct{} `type:"structure"`

	// The error code.
	Code *int64 `locationName:"code" type:"integer"`

	// The error message.
	Message *string `locationName:"message" type:"string"`

	// The name.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s BatchCreateVariableError) String() string {
	return awsutil.Prettify(s)
}

// Provides the error of the batch get variable API.
type BatchGetVariableError struct {
	_ struct{} `type:"structure"`

	// The error code.
	Code *int64 `locationName:"code" type:"integer"`

	// The error message.
	Message *string `locationName:"message" type:"string"`

	// The error name.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s BatchGetVariableError) String() string {
	return awsutil.Prettify(s)
}

// The detector.
type Detector struct {
	_ struct{} `type:"structure"`

	// Timestamp of when the detector was created.
	CreatedTime *string `locationName:"createdTime" type:"string"`

	// The detector description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The detector ID.
	DetectorId *string `locationName:"detectorId" min:"1" type:"string"`

	// Timestamp of when the detector was last updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" type:"string"`
}

// String returns the string representation
func (s Detector) String() string {
	return awsutil.Prettify(s)
}

// The summary of the detector version.
type DetectorVersionSummary struct {
	_ struct{} `type:"structure"`

	// The detector version description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The detector version ID.
	DetectorVersionId *string `locationName:"detectorVersionId" min:"1" type:"string"`

	// Timestamp of when the detector version was last updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" type:"string"`

	// The detector version status.
	Status DetectorVersionStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s DetectorVersionSummary) String() string {
	return awsutil.Prettify(s)
}

// The Amazon SageMaker model.
type ExternalModel struct {
	_ struct{} `type:"structure"`

	// Timestamp of when the model was last created.
	CreatedTime *string `locationName:"createdTime" type:"string"`

	// The input configuration.
	InputConfiguration *ModelInputConfiguration `locationName:"inputConfiguration" type:"structure"`

	// Timestamp of when the model was last updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" type:"string"`

	// The Amazon SageMaker model endpoints.
	ModelEndpoint *string `locationName:"modelEndpoint" type:"string"`

	// The Amazon Fraud Detector status for the external model endpoint
	ModelEndpointStatus ModelEndpointStatus `locationName:"modelEndpointStatus" type:"string" enum:"true"`

	// The source of the model.
	ModelSource ModelSource `locationName:"modelSource" type:"string" enum:"true"`

	// The output configuration.
	OutputConfiguration *ModelOutputConfiguration `locationName:"outputConfiguration" type:"structure"`

	// The role used to invoke the model.
	Role *Role `locationName:"role" type:"structure"`
}

// String returns the string representation
func (s ExternalModel) String() string {
	return awsutil.Prettify(s)
}

// The label schema.
type LabelSchema struct {
	_ struct{} `type:"structure"`

	// The label key.
	//
	// LabelKey is a required field
	LabelKey *string `locationName:"labelKey" type:"string" required:"true"`

	// The label mapper maps the Amazon Fraud Detector supported label to the appropriate
	// source labels. For example, if "FRAUD" and "LEGIT" are Amazon Fraud Detector
	// supported labels, this mapper could be: {"FRAUD" => ["0"], "LEGIT" => ["1"]}
	// or {"FRAUD" => ["false"], "LEGIT" => ["true"]} or {"FRAUD" => ["fraud", "abuse"],
	// "LEGIT" => ["legit", "safe"]}. The value part of the mapper is a list, because
	// you may have multiple variants for a single Amazon Fraud Detector label.
	//
	// LabelMapper is a required field
	LabelMapper map[string][]string `locationName:"labelMapper" type:"map" required:"true"`
}

// String returns the string representation
func (s LabelSchema) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LabelSchema) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LabelSchema"}

	if s.LabelKey == nil {
		invalidParams.Add(aws.NewErrParamRequired("LabelKey"))
	}

	if s.LabelMapper == nil {
		invalidParams.Add(aws.NewErrParamRequired("LabelMapper"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The model.
type Model struct {
	_ struct{} `type:"structure"`

	// Timestamp of when the model was created.
	CreatedTime *string `locationName:"createdTime" type:"string"`

	// The model description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The model label schema.
	LabelSchema *LabelSchema `locationName:"labelSchema" type:"structure"`

	// Timestamp of last time the model was updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" type:"string"`

	// The model ID.
	ModelId *string `locationName:"modelId" min:"1" type:"string"`

	// The model type.
	ModelType ModelTypeEnum `locationName:"modelType" type:"string" enum:"true"`

	// The model input variables.
	ModelVariables []ModelVariable `locationName:"modelVariables" type:"list"`

	// The model training data source in Amazon S3.
	TrainingDataSource *TrainingDataSource `locationName:"trainingDataSource" type:"structure"`
}

// String returns the string representation
func (s Model) String() string {
	return awsutil.Prettify(s)
}

// A pre-formed Amazon SageMaker model input you can include if your detector
// version includes an imported Amazon SageMaker model endpoint with pass-through
// input configuration.
type ModelEndpointDataBlob struct {
	_ struct{} `type:"structure"`

	// The byte buffer of the Amazon SageMaker model endpoint input data blob.
	//
	// ByteBuffer is automatically base64 encoded/decoded by the SDK.
	ByteBuffer []byte `locationName:"byteBuffer" type:"blob"`

	// The content type of the Amazon SageMaker model endpoint input data blob.
	ContentType *string `locationName:"contentType" min:"1" type:"string"`
}

// String returns the string representation
func (s ModelEndpointDataBlob) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModelEndpointDataBlob) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModelEndpointDataBlob"}
	if s.ContentType != nil && len(*s.ContentType) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ContentType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The model input configuration.
type ModelInputConfiguration struct {
	_ struct{} `type:"structure"`

	// Template for constructing the CSV input-data sent to SageMaker. At event-evaluation,
	// the placeholders for variable-names in the template will be replaced with
	// the variable values before being sent to SageMaker.
	CsvInputTemplate *string `locationName:"csvInputTemplate" type:"string"`

	// The format of the model input configuration. The format differs depending
	// on if it is passed through to SageMaker or constructed by Amazon Fraud Detector.
	Format ModelInputDataFormat `locationName:"format" type:"string" enum:"true"`

	// For an opaque-model, the input to the model will be a ByteBuffer blob provided
	// in the getPrediction request, and will be passed to SageMaker as-is. For
	// non-opaque models, the input will be constructed by Amazon Fraud Detector
	// based on the model-configuration.
	//
	// IsOpaque is a required field
	IsOpaque *bool `locationName:"isOpaque" type:"boolean" required:"true"`

	// Template for constructing the JSON input-data sent to SageMaker. At event-evaluation,
	// the placeholders for variable names in the template will be replaced with
	// the variable values before being sent to SageMaker.
	JsonInputTemplate *string `locationName:"jsonInputTemplate" type:"string"`
}

// String returns the string representation
func (s ModelInputConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModelInputConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModelInputConfiguration"}

	if s.IsOpaque == nil {
		invalidParams.Add(aws.NewErrParamRequired("IsOpaque"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides the model output configuration.
type ModelOutputConfiguration struct {
	_ struct{} `type:"structure"`

	// A map of CSV index values in the SageMaker response to the Amazon Fraud Detector
	// variables.
	CsvIndexToVariableMap map[string]string `locationName:"csvIndexToVariableMap" type:"map"`

	// The format of the model output configuration.
	//
	// Format is a required field
	Format ModelOutputDataFormat `locationName:"format" type:"string" required:"true" enum:"true"`

	// A map of JSON keys in response from SageMaker to the Amazon Fraud Detector
	// variables.
	JsonKeyToVariableMap map[string]string `locationName:"jsonKeyToVariableMap" type:"map"`
}

// String returns the string representation
func (s ModelOutputConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModelOutputConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModelOutputConfiguration"}
	if len(s.Format) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Format"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The fraud prediction scores.
type ModelScores struct {
	_ struct{} `type:"structure"`

	// The model version.
	ModelVersion *ModelVersion `locationName:"modelVersion" type:"structure"`

	// The model's fraud prediction scores.
	Scores map[string]float64 `locationName:"scores" type:"map"`
}

// String returns the string representation
func (s ModelScores) String() string {
	return awsutil.Prettify(s)
}

// The model variable.>
type ModelVariable struct {
	_ struct{} `type:"structure"`

	// The model variable's index.>
	Index *int64 `locationName:"index" type:"integer"`

	// The model variable's name.>
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation
func (s ModelVariable) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModelVariable) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModelVariable"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The model version.
type ModelVersion struct {
	_ struct{} `type:"structure"`

	// The parent model ID.
	//
	// ModelId is a required field
	ModelId *string `locationName:"modelId" min:"1" type:"string" required:"true"`

	// The model type.
	//
	// ModelType is a required field
	ModelType ModelTypeEnum `locationName:"modelType" type:"string" required:"true" enum:"true"`

	// The model version.
	//
	// ModelVersionNumber is a required field
	ModelVersionNumber *string `locationName:"modelVersionNumber" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ModelVersion) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModelVersion) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModelVersion"}

	if s.ModelId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ModelId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ModelId", 1))
	}
	if len(s.ModelType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ModelType"))
	}

	if s.ModelVersionNumber == nil {
		invalidParams.Add(aws.NewErrParamRequired("ModelVersionNumber"))
	}
	if s.ModelVersionNumber != nil && len(*s.ModelVersionNumber) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ModelVersionNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides the model version details.
type ModelVersionDetail struct {
	_ struct{} `type:"structure"`

	// The timestamp when the model was created.
	CreatedTime *string `locationName:"createdTime" type:"string"`

	// The model description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The model label schema.
	LabelSchema *LabelSchema `locationName:"labelSchema" type:"structure"`

	// The timestamp when the model was last updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" type:"string"`

	// The model ID.
	ModelId *string `locationName:"modelId" min:"1" type:"string"`

	// The model type.
	ModelType ModelTypeEnum `locationName:"modelType" type:"string" enum:"true"`

	// The model variables.
	ModelVariables []ModelVariable `locationName:"modelVariables" type:"list"`

	// The model version.
	ModelVersionNumber *string `locationName:"modelVersionNumber" min:"1" type:"string"`

	// The model status.
	Status *string `locationName:"status" type:"string"`

	// The model training data source.
	TrainingDataSource *TrainingDataSource `locationName:"trainingDataSource" type:"structure"`

	// The model training metrics.
	TrainingMetrics map[string]string `locationName:"trainingMetrics" type:"map"`

	// The model validation metrics.
	ValidationMetrics map[string]string `locationName:"validationMetrics" type:"map"`
}

// String returns the string representation
func (s ModelVersionDetail) String() string {
	return awsutil.Prettify(s)
}

// The outcome.
type Outcome struct {
	_ struct{} `type:"structure"`

	// The timestamp when the outcome was created.
	CreatedTime *string `locationName:"createdTime" type:"string"`

	// The outcome description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The timestamp when the outcome was last updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" type:"string"`

	// The outcome name.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation
func (s Outcome) String() string {
	return awsutil.Prettify(s)
}

// The role used to invoke external model endpoints.
type Role struct {
	_ struct{} `type:"structure"`

	// The role ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The role name.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation
func (s Role) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Role) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Role"}

	if s.Arn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arn"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A rule.
type Rule struct {
	_ struct{} `type:"structure"`

	// The detector for which the rule is associated.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The rule ID.
	//
	// RuleId is a required field
	RuleId *string `locationName:"ruleId" min:"1" type:"string" required:"true"`

	// The rule version.
	//
	// RuleVersion is a required field
	RuleVersion *string `locationName:"ruleVersion" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Rule) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Rule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Rule"}

	if s.DetectorId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DetectorId", 1))
	}

	if s.RuleId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RuleId"))
	}
	if s.RuleId != nil && len(*s.RuleId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RuleId", 1))
	}

	if s.RuleVersion == nil {
		invalidParams.Add(aws.NewErrParamRequired("RuleVersion"))
	}
	if s.RuleVersion != nil && len(*s.RuleVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RuleVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The details of the rule.
type RuleDetail struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the rule was created.
	CreatedTime *string `locationName:"createdTime" type:"string"`

	// The rule description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The detector for which the rule is associated.
	DetectorId *string `locationName:"detectorId" min:"1" type:"string"`

	// The rule expression.
	Expression *string `locationName:"expression" min:"1" type:"string"`

	// The rule language.
	Language Language `locationName:"language" type:"string" enum:"true"`

	// Timestamp of the last time the rule was updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" type:"string"`

	// The rule outcomes.
	Outcomes []string `locationName:"outcomes" min:"1" type:"list"`

	// The rule ID.
	RuleId *string `locationName:"ruleId" min:"1" type:"string"`

	// The rule version.
	RuleVersion *string `locationName:"ruleVersion" min:"1" type:"string"`
}

// String returns the string representation
func (s RuleDetail) String() string {
	return awsutil.Prettify(s)
}

// The training data source.
type TrainingDataSource struct {
	_ struct{} `type:"structure"`

	// The data access role ARN for the training data source.
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `locationName:"dataAccessRoleArn" min:"1" type:"string" required:"true"`

	// The data location of the training data source.
	//
	// DataLocation is a required field
	DataLocation *string `locationName:"dataLocation" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TrainingDataSource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TrainingDataSource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TrainingDataSource"}

	if s.DataAccessRoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DataAccessRoleArn", 1))
	}

	if s.DataLocation == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataLocation"))
	}
	if s.DataLocation != nil && len(*s.DataLocation) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DataLocation", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The variable.
type Variable struct {
	_ struct{} `type:"structure"`

	// The time when the variable was created.
	CreatedTime *string `locationName:"createdTime" type:"string"`

	// The data source of the variable.
	DataSource DataSource `locationName:"dataSource" type:"string" enum:"true"`

	// The data type of the variable.
	DataType DataType `locationName:"dataType" type:"string" enum:"true"`

	// The default value of the variable.
	DefaultValue *string `locationName:"defaultValue" type:"string"`

	// The description of the variable.
	Description *string `locationName:"description" type:"string"`

	// The time when variable was last updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" type:"string"`

	// The name of the variable.
	Name *string `locationName:"name" type:"string"`

	// The variable type of the variable.
	VariableType *string `locationName:"variableType" type:"string"`
}

// String returns the string representation
func (s Variable) String() string {
	return awsutil.Prettify(s)
}

// The variable entry in a list.
type VariableEntry struct {
	_ struct{} `type:"structure"`

	// The data source of the variable entry.
	DataSource *string `locationName:"dataSource" type:"string"`

	// The data type of the variable entry.
	DataType *string `locationName:"dataType" type:"string"`

	// The default value of the variable entry.
	DefaultValue *string `locationName:"defaultValue" type:"string"`

	// The description of the variable entry.
	Description *string `locationName:"description" type:"string"`

	// The name of the variable entry.
	Name *string `locationName:"name" type:"string"`

	// The type of the variable entry.
	VariableType *string `locationName:"variableType" type:"string"`
}

// String returns the string representation
func (s VariableEntry) String() string {
	return awsutil.Prettify(s)
}
