// +build go1.9

// Copyright 2021 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package blockchain

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/blockchain/mgmt/2018-06-01-preview/blockchain"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type MemberProvisioningState = original.MemberProvisioningState

const (
	Deleting     MemberProvisioningState = original.Deleting
	Failed       MemberProvisioningState = original.Failed
	NotSpecified MemberProvisioningState = original.NotSpecified
	Stale        MemberProvisioningState = original.Stale
	Succeeded    MemberProvisioningState = original.Succeeded
	Updating     MemberProvisioningState = original.Updating
)

type NameAvailabilityReason = original.NameAvailabilityReason

const (
	NameAvailabilityReasonAlreadyExists NameAvailabilityReason = original.NameAvailabilityReasonAlreadyExists
	NameAvailabilityReasonInvalid       NameAvailabilityReason = original.NameAvailabilityReasonInvalid
	NameAvailabilityReasonNotSpecified  NameAvailabilityReason = original.NameAvailabilityReasonNotSpecified
)

type NodeProvisioningState = original.NodeProvisioningState

const (
	NodeProvisioningStateDeleting     NodeProvisioningState = original.NodeProvisioningStateDeleting
	NodeProvisioningStateFailed       NodeProvisioningState = original.NodeProvisioningStateFailed
	NodeProvisioningStateNotSpecified NodeProvisioningState = original.NodeProvisioningStateNotSpecified
	NodeProvisioningStateSucceeded    NodeProvisioningState = original.NodeProvisioningStateSucceeded
	NodeProvisioningStateUpdating     NodeProvisioningState = original.NodeProvisioningStateUpdating
)

type Protocol = original.Protocol

const (
	ProtocolCorda        Protocol = original.ProtocolCorda
	ProtocolNotSpecified Protocol = original.ProtocolNotSpecified
	ProtocolParity       Protocol = original.ProtocolParity
	ProtocolQuorum       Protocol = original.ProtocolQuorum
)

type APIKey = original.APIKey
type APIKeyCollection = original.APIKeyCollection
type BaseClient = original.BaseClient
type Consortium = original.Consortium
type ConsortiumCollection = original.ConsortiumCollection
type ConsortiumMember = original.ConsortiumMember
type ConsortiumMemberCollection = original.ConsortiumMemberCollection
type ConsortiumMemberCollectionIterator = original.ConsortiumMemberCollectionIterator
type ConsortiumMemberCollectionPage = original.ConsortiumMemberCollectionPage
type FirewallRule = original.FirewallRule
type LocationsClient = original.LocationsClient
type Member = original.Member
type MemberCollection = original.MemberCollection
type MemberCollectionIterator = original.MemberCollectionIterator
type MemberCollectionPage = original.MemberCollectionPage
type MemberNodesSku = original.MemberNodesSku
type MemberOperationResultsClient = original.MemberOperationResultsClient
type MemberProperties = original.MemberProperties
type MemberPropertiesUpdate = original.MemberPropertiesUpdate
type MemberUpdate = original.MemberUpdate
type MembersClient = original.MembersClient
type MembersCreateFuture = original.MembersCreateFuture
type MembersDeleteFuture = original.MembersDeleteFuture
type NameAvailability = original.NameAvailability
type NameAvailabilityRequest = original.NameAvailabilityRequest
type OperationResult = original.OperationResult
type OperationsClient = original.OperationsClient
type Resource = original.Resource
type ResourceProviderOperation = original.ResourceProviderOperation
type ResourceProviderOperationCollection = original.ResourceProviderOperationCollection
type ResourceProviderOperationCollectionIterator = original.ResourceProviderOperationCollectionIterator
type ResourceProviderOperationCollectionPage = original.ResourceProviderOperationCollectionPage
type ResourceProviderOperationDisplay = original.ResourceProviderOperationDisplay
type ResourceTypeSku = original.ResourceTypeSku
type ResourceTypeSkuCollection = original.ResourceTypeSkuCollection
type Sku = original.Sku
type SkuSetting = original.SkuSetting
type SkusClient = original.SkusClient
type TrackedResource = original.TrackedResource
type TransactionNode = original.TransactionNode
type TransactionNodeCollection = original.TransactionNodeCollection
type TransactionNodeCollectionIterator = original.TransactionNodeCollectionIterator
type TransactionNodeCollectionPage = original.TransactionNodeCollectionPage
type TransactionNodeProperties = original.TransactionNodeProperties
type TransactionNodePropertiesUpdate = original.TransactionNodePropertiesUpdate
type TransactionNodeUpdate = original.TransactionNodeUpdate
type TransactionNodesClient = original.TransactionNodesClient
type TransactionNodesCreateFuture = original.TransactionNodesCreateFuture
type TransactionNodesDeleteFuture = original.TransactionNodesDeleteFuture

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewConsortiumMemberCollectionIterator(page ConsortiumMemberCollectionPage) ConsortiumMemberCollectionIterator {
	return original.NewConsortiumMemberCollectionIterator(page)
}
func NewConsortiumMemberCollectionPage(cur ConsortiumMemberCollection, getNextPage func(context.Context, ConsortiumMemberCollection) (ConsortiumMemberCollection, error)) ConsortiumMemberCollectionPage {
	return original.NewConsortiumMemberCollectionPage(cur, getNextPage)
}
func NewLocationsClient(subscriptionID string) LocationsClient {
	return original.NewLocationsClient(subscriptionID)
}
func NewLocationsClientWithBaseURI(baseURI string, subscriptionID string) LocationsClient {
	return original.NewLocationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewMemberCollectionIterator(page MemberCollectionPage) MemberCollectionIterator {
	return original.NewMemberCollectionIterator(page)
}
func NewMemberCollectionPage(cur MemberCollection, getNextPage func(context.Context, MemberCollection) (MemberCollection, error)) MemberCollectionPage {
	return original.NewMemberCollectionPage(cur, getNextPage)
}
func NewMemberOperationResultsClient(subscriptionID string) MemberOperationResultsClient {
	return original.NewMemberOperationResultsClient(subscriptionID)
}
func NewMemberOperationResultsClientWithBaseURI(baseURI string, subscriptionID string) MemberOperationResultsClient {
	return original.NewMemberOperationResultsClientWithBaseURI(baseURI, subscriptionID)
}
func NewMembersClient(subscriptionID string) MembersClient {
	return original.NewMembersClient(subscriptionID)
}
func NewMembersClientWithBaseURI(baseURI string, subscriptionID string) MembersClient {
	return original.NewMembersClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewResourceProviderOperationCollectionIterator(page ResourceProviderOperationCollectionPage) ResourceProviderOperationCollectionIterator {
	return original.NewResourceProviderOperationCollectionIterator(page)
}
func NewResourceProviderOperationCollectionPage(cur ResourceProviderOperationCollection, getNextPage func(context.Context, ResourceProviderOperationCollection) (ResourceProviderOperationCollection, error)) ResourceProviderOperationCollectionPage {
	return original.NewResourceProviderOperationCollectionPage(cur, getNextPage)
}
func NewSkusClient(subscriptionID string) SkusClient {
	return original.NewSkusClient(subscriptionID)
}
func NewSkusClientWithBaseURI(baseURI string, subscriptionID string) SkusClient {
	return original.NewSkusClientWithBaseURI(baseURI, subscriptionID)
}
func NewTransactionNodeCollectionIterator(page TransactionNodeCollectionPage) TransactionNodeCollectionIterator {
	return original.NewTransactionNodeCollectionIterator(page)
}
func NewTransactionNodeCollectionPage(cur TransactionNodeCollection, getNextPage func(context.Context, TransactionNodeCollection) (TransactionNodeCollection, error)) TransactionNodeCollectionPage {
	return original.NewTransactionNodeCollectionPage(cur, getNextPage)
}
func NewTransactionNodesClient(subscriptionID string) TransactionNodesClient {
	return original.NewTransactionNodesClient(subscriptionID)
}
func NewTransactionNodesClientWithBaseURI(baseURI string, subscriptionID string) TransactionNodesClient {
	return original.NewTransactionNodesClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleMemberProvisioningStateValues() []MemberProvisioningState {
	return original.PossibleMemberProvisioningStateValues()
}
func PossibleNameAvailabilityReasonValues() []NameAvailabilityReason {
	return original.PossibleNameAvailabilityReasonValues()
}
func PossibleNodeProvisioningStateValues() []NodeProvisioningState {
	return original.PossibleNodeProvisioningStateValues()
}
func PossibleProtocolValues() []Protocol {
	return original.PossibleProtocolValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
