// +build go1.9

// Copyright 2021 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package hybridnetwork

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/hybridnetwork/mgmt/2020-01-01-preview/hybridnetwork"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type DeviceType = original.DeviceType

const (
	DeviceTypeDevicePropertiesFormat DeviceType = original.DeviceTypeDevicePropertiesFormat
)

type DiskCreateOptionTypes = original.DiskCreateOptionTypes

const (
	Empty   DiskCreateOptionTypes = original.Empty
	Unknown DiskCreateOptionTypes = original.Unknown
)

type IPAllocationMethod = original.IPAllocationMethod

const (
	IPAllocationMethodDynamic IPAllocationMethod = original.IPAllocationMethodDynamic
	IPAllocationMethodStatic  IPAllocationMethod = original.IPAllocationMethodStatic
	IPAllocationMethodUnknown IPAllocationMethod = original.IPAllocationMethodUnknown
)

type IPVersion = original.IPVersion

const (
	IPVersionIPv4    IPVersion = original.IPVersionIPv4
	IPVersionUnknown IPVersion = original.IPVersionUnknown
)

type NetworkFunctionRoleConfigurationType = original.NetworkFunctionRoleConfigurationType

const (
	NetworkFunctionRoleConfigurationTypeUnknown        NetworkFunctionRoleConfigurationType = original.NetworkFunctionRoleConfigurationTypeUnknown
	NetworkFunctionRoleConfigurationTypeVirtualMachine NetworkFunctionRoleConfigurationType = original.NetworkFunctionRoleConfigurationTypeVirtualMachine
)

type OperatingSystemTypes = original.OperatingSystemTypes

const (
	OperatingSystemTypesLinux   OperatingSystemTypes = original.OperatingSystemTypesLinux
	OperatingSystemTypesUnknown OperatingSystemTypes = original.OperatingSystemTypesUnknown
	OperatingSystemTypesWindows OperatingSystemTypes = original.OperatingSystemTypesWindows
)

type OperationalState = original.OperationalState

const (
	OperationalStateRunning  OperationalState = original.OperationalStateRunning
	OperationalStateStarting OperationalState = original.OperationalStateStarting
	OperationalStateStopped  OperationalState = original.OperationalStateStopped
	OperationalStateStopping OperationalState = original.OperationalStateStopping
	OperationalStateUnknown  OperationalState = original.OperationalStateUnknown
)

type ProvisioningState = original.ProvisioningState

const (
	ProvisioningStateAccepted  ProvisioningState = original.ProvisioningStateAccepted
	ProvisioningStateCanceled  ProvisioningState = original.ProvisioningStateCanceled
	ProvisioningStateDeleted   ProvisioningState = original.ProvisioningStateDeleted
	ProvisioningStateDeleting  ProvisioningState = original.ProvisioningStateDeleting
	ProvisioningStateFailed    ProvisioningState = original.ProvisioningStateFailed
	ProvisioningStateSucceeded ProvisioningState = original.ProvisioningStateSucceeded
	ProvisioningStateUnknown   ProvisioningState = original.ProvisioningStateUnknown
)

type SkuDeploymentMode = original.SkuDeploymentMode

const (
	SkuDeploymentModeAzure           SkuDeploymentMode = original.SkuDeploymentModeAzure
	SkuDeploymentModePrivateEdgeZone SkuDeploymentMode = original.SkuDeploymentModePrivateEdgeZone
	SkuDeploymentModeUnknown         SkuDeploymentMode = original.SkuDeploymentModeUnknown
)

type SkuType = original.SkuType

const (
	SkuTypeEvolvedPacketCore SkuType = original.SkuTypeEvolvedPacketCore
	SkuTypeFirewall          SkuType = original.SkuTypeFirewall
	SkuTypeSDWAN             SkuType = original.SkuTypeSDWAN
	SkuTypeUnknown           SkuType = original.SkuTypeUnknown
)

type Status = original.Status

const (
	StatusDeleted       Status = original.StatusDeleted
	StatusNotRegistered Status = original.StatusNotRegistered
	StatusRegistered    Status = original.StatusRegistered
	StatusUnknown       Status = original.StatusUnknown
)

type VMSwitchType = original.VMSwitchType

const (
	VMSwitchTypeLan        VMSwitchType = original.VMSwitchTypeLan
	VMSwitchTypeManagement VMSwitchType = original.VMSwitchTypeManagement
	VMSwitchTypeUnknown    VMSwitchType = original.VMSwitchTypeUnknown
	VMSwitchTypeWan        VMSwitchType = original.VMSwitchTypeWan
)

type VendorProvisioningState = original.VendorProvisioningState

const (
	VendorProvisioningStateDeprovisioned            VendorProvisioningState = original.VendorProvisioningStateDeprovisioned
	VendorProvisioningStateNotProvisioned           VendorProvisioningState = original.VendorProvisioningStateNotProvisioned
	VendorProvisioningStateProvisioned              VendorProvisioningState = original.VendorProvisioningStateProvisioned
	VendorProvisioningStateProvisioning             VendorProvisioningState = original.VendorProvisioningStateProvisioning
	VendorProvisioningStateUnknown                  VendorProvisioningState = original.VendorProvisioningStateUnknown
	VendorProvisioningStateUserDataValidationFailed VendorProvisioningState = original.VendorProvisioningStateUserDataValidationFailed
)

type VirtualMachineSizeTypes = original.VirtualMachineSizeTypes

const (
	VirtualMachineSizeTypesStandardD11V2  VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD11V2
	VirtualMachineSizeTypesStandardD12V2  VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD12V2
	VirtualMachineSizeTypesStandardD13V2  VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD13V2
	VirtualMachineSizeTypesStandardD1V2   VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD1V2
	VirtualMachineSizeTypesStandardD2V2   VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD2V2
	VirtualMachineSizeTypesStandardD3V2   VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD3V2
	VirtualMachineSizeTypesStandardD4V2   VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD4V2
	VirtualMachineSizeTypesStandardD5V2   VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD5V2
	VirtualMachineSizeTypesStandardDS11V2 VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardDS11V2
	VirtualMachineSizeTypesStandardDS12V2 VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardDS12V2
	VirtualMachineSizeTypesStandardDS13V2 VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardDS13V2
	VirtualMachineSizeTypesStandardDS1V2  VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardDS1V2
	VirtualMachineSizeTypesStandardDS2V2  VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardDS2V2
	VirtualMachineSizeTypesStandardDS3V2  VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardDS3V2
	VirtualMachineSizeTypesStandardDS4V2  VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardDS4V2
	VirtualMachineSizeTypesStandardDS5V2  VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardDS5V2
	VirtualMachineSizeTypesStandardF1     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardF1
	VirtualMachineSizeTypesStandardF16    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardF16
	VirtualMachineSizeTypesStandardF16s   VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardF16s
	VirtualMachineSizeTypesStandardF1s    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardF1s
	VirtualMachineSizeTypesStandardF2     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardF2
	VirtualMachineSizeTypesStandardF2s    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardF2s
	VirtualMachineSizeTypesStandardF4     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardF4
	VirtualMachineSizeTypesStandardF4s    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardF4s
	VirtualMachineSizeTypesStandardF8     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardF8
	VirtualMachineSizeTypesStandardF8s    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardF8s
	VirtualMachineSizeTypesUnknown        VirtualMachineSizeTypes = original.VirtualMachineSizeTypesUnknown
)

type AzureEntityResource = original.AzureEntityResource
type BaseClient = original.BaseClient
type BasicDevicePropertiesFormat = original.BasicDevicePropertiesFormat
type CustomProfile = original.CustomProfile
type DataDisk = original.DataDisk
type Device = original.Device
type DeviceListResult = original.DeviceListResult
type DeviceListResultIterator = original.DeviceListResultIterator
type DeviceListResultPage = original.DeviceListResultPage
type DevicePropertiesFormat = original.DevicePropertiesFormat
type DeviceRegistrationKey = original.DeviceRegistrationKey
type DevicesClient = original.DevicesClient
type DevicesCreateOrUpdateFuture = original.DevicesCreateOrUpdateFuture
type DevicesDeleteFuture = original.DevicesDeleteFuture
type ErrorAdditionalInfo = original.ErrorAdditionalInfo
type ErrorDetail = original.ErrorDetail
type ErrorResponse = original.ErrorResponse
type ImageReference = original.ImageReference
type LinuxConfiguration = original.LinuxConfiguration
type NetworkFunction = original.NetworkFunction
type NetworkFunctionListResult = original.NetworkFunctionListResult
type NetworkFunctionListResultIterator = original.NetworkFunctionListResultIterator
type NetworkFunctionListResultPage = original.NetworkFunctionListResultPage
type NetworkFunctionPropertiesFormat = original.NetworkFunctionPropertiesFormat
type NetworkFunctionRoleConfiguration = original.NetworkFunctionRoleConfiguration
type NetworkFunctionRoleInstanceListResult = original.NetworkFunctionRoleInstanceListResult
type NetworkFunctionRoleInstanceListResultIterator = original.NetworkFunctionRoleInstanceListResultIterator
type NetworkFunctionRoleInstanceListResultPage = original.NetworkFunctionRoleInstanceListResultPage
type NetworkFunctionSkuDetails = original.NetworkFunctionSkuDetails
type NetworkFunctionSkuDetailsIterator = original.NetworkFunctionSkuDetailsIterator
type NetworkFunctionSkuDetailsPage = original.NetworkFunctionSkuDetailsPage
type NetworkFunctionSkuListResult = original.NetworkFunctionSkuListResult
type NetworkFunctionSkuListResultIterator = original.NetworkFunctionSkuListResultIterator
type NetworkFunctionSkuListResultPage = original.NetworkFunctionSkuListResultPage
type NetworkFunctionSkuRoleDetails = original.NetworkFunctionSkuRoleDetails
type NetworkFunctionTemplate = original.NetworkFunctionTemplate
type NetworkFunctionUserConfiguration = original.NetworkFunctionUserConfiguration
type NetworkFunctionUserConfigurationOsProfile = original.NetworkFunctionUserConfigurationOsProfile
type NetworkFunctionVendor = original.NetworkFunctionVendor
type NetworkFunctionVendorConfiguration = original.NetworkFunctionVendorConfiguration
type NetworkFunctionVendorListResult = original.NetworkFunctionVendorListResult
type NetworkFunctionVendorListResultIterator = original.NetworkFunctionVendorListResultIterator
type NetworkFunctionVendorListResultPage = original.NetworkFunctionVendorListResultPage
type NetworkFunctionVendorSkusClient = original.NetworkFunctionVendorSkusClient
type NetworkFunctionVendorsClient = original.NetworkFunctionVendorsClient
type NetworkFunctionsClient = original.NetworkFunctionsClient
type NetworkFunctionsCreateOrUpdateFuture = original.NetworkFunctionsCreateOrUpdateFuture
type NetworkFunctionsDeleteFuture = original.NetworkFunctionsDeleteFuture
type NetworkInterface = original.NetworkInterface
type NetworkInterfaceIPConfiguration = original.NetworkInterfaceIPConfiguration
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationList = original.OperationList
type OperationListIterator = original.OperationListIterator
type OperationListPage = original.OperationListPage
type OperationsClient = original.OperationsClient
type OsDisk = original.OsDisk
type OsProfile = original.OsProfile
type PreviewSubscription = original.PreviewSubscription
type PreviewSubscriptionsList = original.PreviewSubscriptionsList
type PreviewSubscriptionsListIterator = original.PreviewSubscriptionsListIterator
type PreviewSubscriptionsListPage = original.PreviewSubscriptionsListPage
type ProxyResource = original.ProxyResource
type Resource = original.Resource
type RoleInstance = original.RoleInstance
type RoleInstanceProperties = original.RoleInstanceProperties
type RoleInstancesClient = original.RoleInstancesClient
type RoleInstancesRestartFuture = original.RoleInstancesRestartFuture
type RoleInstancesStartFuture = original.RoleInstancesStartFuture
type RoleInstancesStopFuture = original.RoleInstancesStopFuture
type SSHConfiguration = original.SSHConfiguration
type SSHPublicKey = original.SSHPublicKey
type SkuOverview = original.SkuOverview
type StorageProfile = original.StorageProfile
type SubResource = original.SubResource
type TagsObject = original.TagsObject
type TrackedResource = original.TrackedResource
type Vendor = original.Vendor
type VendorDetails = original.VendorDetails
type VendorListResult = original.VendorListResult
type VendorListResultIterator = original.VendorListResultIterator
type VendorListResultPage = original.VendorListResultPage
type VendorNetworkFunction = original.VendorNetworkFunction
type VendorNetworkFunctionListResult = original.VendorNetworkFunctionListResult
type VendorNetworkFunctionListResultIterator = original.VendorNetworkFunctionListResultIterator
type VendorNetworkFunctionListResultPage = original.VendorNetworkFunctionListResultPage
type VendorNetworkFunctionPropertiesFormat = original.VendorNetworkFunctionPropertiesFormat
type VendorNetworkFunctionsClient = original.VendorNetworkFunctionsClient
type VendorNetworkFunctionsCreateOrUpdateFuture = original.VendorNetworkFunctionsCreateOrUpdateFuture
type VendorPropertiesFormat = original.VendorPropertiesFormat
type VendorSku = original.VendorSku
type VendorSkuListResult = original.VendorSkuListResult
type VendorSkuListResultIterator = original.VendorSkuListResultIterator
type VendorSkuListResultPage = original.VendorSkuListResultPage
type VendorSkuPreviewClient = original.VendorSkuPreviewClient
type VendorSkuPreviewCreateOrUpdateFuture = original.VendorSkuPreviewCreateOrUpdateFuture
type VendorSkuPreviewDeleteFuture = original.VendorSkuPreviewDeleteFuture
type VendorSkuPropertiesFormat = original.VendorSkuPropertiesFormat
type VendorSkusClient = original.VendorSkusClient
type VendorSkusCreateOrUpdateFuture = original.VendorSkusCreateOrUpdateFuture
type VendorSkusDeleteFuture = original.VendorSkusDeleteFuture
type VendorsClient = original.VendorsClient
type VendorsCreateOrUpdateFuture = original.VendorsCreateOrUpdateFuture
type VendorsDeleteFuture = original.VendorsDeleteFuture
type VirtualHardDisk = original.VirtualHardDisk

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewDeviceListResultIterator(page DeviceListResultPage) DeviceListResultIterator {
	return original.NewDeviceListResultIterator(page)
}
func NewDeviceListResultPage(cur DeviceListResult, getNextPage func(context.Context, DeviceListResult) (DeviceListResult, error)) DeviceListResultPage {
	return original.NewDeviceListResultPage(cur, getNextPage)
}
func NewDevicesClient(subscriptionID string) DevicesClient {
	return original.NewDevicesClient(subscriptionID)
}
func NewDevicesClientWithBaseURI(baseURI string, subscriptionID string) DevicesClient {
	return original.NewDevicesClientWithBaseURI(baseURI, subscriptionID)
}
func NewNetworkFunctionListResultIterator(page NetworkFunctionListResultPage) NetworkFunctionListResultIterator {
	return original.NewNetworkFunctionListResultIterator(page)
}
func NewNetworkFunctionListResultPage(cur NetworkFunctionListResult, getNextPage func(context.Context, NetworkFunctionListResult) (NetworkFunctionListResult, error)) NetworkFunctionListResultPage {
	return original.NewNetworkFunctionListResultPage(cur, getNextPage)
}
func NewNetworkFunctionRoleInstanceListResultIterator(page NetworkFunctionRoleInstanceListResultPage) NetworkFunctionRoleInstanceListResultIterator {
	return original.NewNetworkFunctionRoleInstanceListResultIterator(page)
}
func NewNetworkFunctionRoleInstanceListResultPage(cur NetworkFunctionRoleInstanceListResult, getNextPage func(context.Context, NetworkFunctionRoleInstanceListResult) (NetworkFunctionRoleInstanceListResult, error)) NetworkFunctionRoleInstanceListResultPage {
	return original.NewNetworkFunctionRoleInstanceListResultPage(cur, getNextPage)
}
func NewNetworkFunctionSkuDetailsIterator(page NetworkFunctionSkuDetailsPage) NetworkFunctionSkuDetailsIterator {
	return original.NewNetworkFunctionSkuDetailsIterator(page)
}
func NewNetworkFunctionSkuDetailsPage(cur NetworkFunctionSkuDetails, getNextPage func(context.Context, NetworkFunctionSkuDetails) (NetworkFunctionSkuDetails, error)) NetworkFunctionSkuDetailsPage {
	return original.NewNetworkFunctionSkuDetailsPage(cur, getNextPage)
}
func NewNetworkFunctionSkuListResultIterator(page NetworkFunctionSkuListResultPage) NetworkFunctionSkuListResultIterator {
	return original.NewNetworkFunctionSkuListResultIterator(page)
}
func NewNetworkFunctionSkuListResultPage(cur NetworkFunctionSkuListResult, getNextPage func(context.Context, NetworkFunctionSkuListResult) (NetworkFunctionSkuListResult, error)) NetworkFunctionSkuListResultPage {
	return original.NewNetworkFunctionSkuListResultPage(cur, getNextPage)
}
func NewNetworkFunctionVendorListResultIterator(page NetworkFunctionVendorListResultPage) NetworkFunctionVendorListResultIterator {
	return original.NewNetworkFunctionVendorListResultIterator(page)
}
func NewNetworkFunctionVendorListResultPage(cur NetworkFunctionVendorListResult, getNextPage func(context.Context, NetworkFunctionVendorListResult) (NetworkFunctionVendorListResult, error)) NetworkFunctionVendorListResultPage {
	return original.NewNetworkFunctionVendorListResultPage(cur, getNextPage)
}
func NewNetworkFunctionVendorSkusClient(subscriptionID string) NetworkFunctionVendorSkusClient {
	return original.NewNetworkFunctionVendorSkusClient(subscriptionID)
}
func NewNetworkFunctionVendorSkusClientWithBaseURI(baseURI string, subscriptionID string) NetworkFunctionVendorSkusClient {
	return original.NewNetworkFunctionVendorSkusClientWithBaseURI(baseURI, subscriptionID)
}
func NewNetworkFunctionVendorsClient(subscriptionID string) NetworkFunctionVendorsClient {
	return original.NewNetworkFunctionVendorsClient(subscriptionID)
}
func NewNetworkFunctionVendorsClientWithBaseURI(baseURI string, subscriptionID string) NetworkFunctionVendorsClient {
	return original.NewNetworkFunctionVendorsClientWithBaseURI(baseURI, subscriptionID)
}
func NewNetworkFunctionsClient(subscriptionID string) NetworkFunctionsClient {
	return original.NewNetworkFunctionsClient(subscriptionID)
}
func NewNetworkFunctionsClientWithBaseURI(baseURI string, subscriptionID string) NetworkFunctionsClient {
	return original.NewNetworkFunctionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationListIterator(page OperationListPage) OperationListIterator {
	return original.NewOperationListIterator(page)
}
func NewOperationListPage(cur OperationList, getNextPage func(context.Context, OperationList) (OperationList, error)) OperationListPage {
	return original.NewOperationListPage(cur, getNextPage)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPreviewSubscriptionsListIterator(page PreviewSubscriptionsListPage) PreviewSubscriptionsListIterator {
	return original.NewPreviewSubscriptionsListIterator(page)
}
func NewPreviewSubscriptionsListPage(cur PreviewSubscriptionsList, getNextPage func(context.Context, PreviewSubscriptionsList) (PreviewSubscriptionsList, error)) PreviewSubscriptionsListPage {
	return original.NewPreviewSubscriptionsListPage(cur, getNextPage)
}
func NewRoleInstancesClient(subscriptionID string) RoleInstancesClient {
	return original.NewRoleInstancesClient(subscriptionID)
}
func NewRoleInstancesClientWithBaseURI(baseURI string, subscriptionID string) RoleInstancesClient {
	return original.NewRoleInstancesClientWithBaseURI(baseURI, subscriptionID)
}
func NewVendorListResultIterator(page VendorListResultPage) VendorListResultIterator {
	return original.NewVendorListResultIterator(page)
}
func NewVendorListResultPage(cur VendorListResult, getNextPage func(context.Context, VendorListResult) (VendorListResult, error)) VendorListResultPage {
	return original.NewVendorListResultPage(cur, getNextPage)
}
func NewVendorNetworkFunctionListResultIterator(page VendorNetworkFunctionListResultPage) VendorNetworkFunctionListResultIterator {
	return original.NewVendorNetworkFunctionListResultIterator(page)
}
func NewVendorNetworkFunctionListResultPage(cur VendorNetworkFunctionListResult, getNextPage func(context.Context, VendorNetworkFunctionListResult) (VendorNetworkFunctionListResult, error)) VendorNetworkFunctionListResultPage {
	return original.NewVendorNetworkFunctionListResultPage(cur, getNextPage)
}
func NewVendorNetworkFunctionsClient(subscriptionID string) VendorNetworkFunctionsClient {
	return original.NewVendorNetworkFunctionsClient(subscriptionID)
}
func NewVendorNetworkFunctionsClientWithBaseURI(baseURI string, subscriptionID string) VendorNetworkFunctionsClient {
	return original.NewVendorNetworkFunctionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVendorSkuListResultIterator(page VendorSkuListResultPage) VendorSkuListResultIterator {
	return original.NewVendorSkuListResultIterator(page)
}
func NewVendorSkuListResultPage(cur VendorSkuListResult, getNextPage func(context.Context, VendorSkuListResult) (VendorSkuListResult, error)) VendorSkuListResultPage {
	return original.NewVendorSkuListResultPage(cur, getNextPage)
}
func NewVendorSkuPreviewClient(subscriptionID string) VendorSkuPreviewClient {
	return original.NewVendorSkuPreviewClient(subscriptionID)
}
func NewVendorSkuPreviewClientWithBaseURI(baseURI string, subscriptionID string) VendorSkuPreviewClient {
	return original.NewVendorSkuPreviewClientWithBaseURI(baseURI, subscriptionID)
}
func NewVendorSkusClient(subscriptionID string) VendorSkusClient {
	return original.NewVendorSkusClient(subscriptionID)
}
func NewVendorSkusClientWithBaseURI(baseURI string, subscriptionID string) VendorSkusClient {
	return original.NewVendorSkusClientWithBaseURI(baseURI, subscriptionID)
}
func NewVendorsClient(subscriptionID string) VendorsClient {
	return original.NewVendorsClient(subscriptionID)
}
func NewVendorsClientWithBaseURI(baseURI string, subscriptionID string) VendorsClient {
	return original.NewVendorsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleDeviceTypeValues() []DeviceType {
	return original.PossibleDeviceTypeValues()
}
func PossibleDiskCreateOptionTypesValues() []DiskCreateOptionTypes {
	return original.PossibleDiskCreateOptionTypesValues()
}
func PossibleIPAllocationMethodValues() []IPAllocationMethod {
	return original.PossibleIPAllocationMethodValues()
}
func PossibleIPVersionValues() []IPVersion {
	return original.PossibleIPVersionValues()
}
func PossibleNetworkFunctionRoleConfigurationTypeValues() []NetworkFunctionRoleConfigurationType {
	return original.PossibleNetworkFunctionRoleConfigurationTypeValues()
}
func PossibleOperatingSystemTypesValues() []OperatingSystemTypes {
	return original.PossibleOperatingSystemTypesValues()
}
func PossibleOperationalStateValues() []OperationalState {
	return original.PossibleOperationalStateValues()
}
func PossibleProvisioningStateValues() []ProvisioningState {
	return original.PossibleProvisioningStateValues()
}
func PossibleSkuDeploymentModeValues() []SkuDeploymentMode {
	return original.PossibleSkuDeploymentModeValues()
}
func PossibleSkuTypeValues() []SkuType {
	return original.PossibleSkuTypeValues()
}
func PossibleStatusValues() []Status {
	return original.PossibleStatusValues()
}
func PossibleVMSwitchTypeValues() []VMSwitchType {
	return original.PossibleVMSwitchTypeValues()
}
func PossibleVendorProvisioningStateValues() []VendorProvisioningState {
	return original.PossibleVendorProvisioningStateValues()
}
func PossibleVirtualMachineSizeTypesValues() []VirtualMachineSizeTypes {
	return original.PossibleVirtualMachineSizeTypesValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
