package programmatic

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/satori/go.uuid"
	"net/http"
)

// ModelClient is the client for the Model methods of the Programmatic service.
type ModelClient struct {
	BaseClient
}

// NewModelClient creates an instance of the ModelClient client.
func NewModelClient(azureRegion AzureRegions) ModelClient {
	return ModelClient{New(azureRegion)}
}

// AddClosedList adds a closed list model to the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// closedListModelCreateObject - a model containing the name and words for the new closed list entity
// extractor.
func (client ModelClient) AddClosedList(ctx context.Context, appID uuid.UUID, versionID string, closedListModelCreateObject ClosedListModelCreateObject) (result UUID, err error) {
	req, err := client.AddClosedListPreparer(ctx, appID, versionID, closedListModelCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddClosedList", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddClosedListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddClosedList", resp, "Failure sending request")
		return
	}

	result, err = client.AddClosedListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddClosedList", resp, "Failure responding to request")
		return
	}

	return
}

// AddClosedListPreparer prepares the AddClosedList request.
func (client ModelClient) AddClosedListPreparer(ctx context.Context, appID uuid.UUID, versionID string, closedListModelCreateObject ClosedListModelCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/closedlists", pathParameters),
		autorest.WithJSON(closedListModelCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddClosedListSender sends the AddClosedList request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) AddClosedListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddClosedListResponder handles the response to the AddClosedList request. The method always
// closes the http.Response Body.
func (client ModelClient) AddClosedListResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddCompositeEntity adds a composite entity extractor to the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// compositeModelCreateObject - a model containing the name and children of the new entity extractor.
func (client ModelClient) AddCompositeEntity(ctx context.Context, appID uuid.UUID, versionID string, compositeModelCreateObject CompositeEntityModel) (result UUID, err error) {
	req, err := client.AddCompositeEntityPreparer(ctx, appID, versionID, compositeModelCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddCompositeEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddCompositeEntitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddCompositeEntity", resp, "Failure sending request")
		return
	}

	result, err = client.AddCompositeEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddCompositeEntity", resp, "Failure responding to request")
		return
	}

	return
}

// AddCompositeEntityPreparer prepares the AddCompositeEntity request.
func (client ModelClient) AddCompositeEntityPreparer(ctx context.Context, appID uuid.UUID, versionID string, compositeModelCreateObject CompositeEntityModel) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/compositeentities", pathParameters),
		autorest.WithJSON(compositeModelCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddCompositeEntitySender sends the AddCompositeEntity request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) AddCompositeEntitySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddCompositeEntityResponder handles the response to the AddCompositeEntity request. The method always
// closes the http.Response Body.
func (client ModelClient) AddCompositeEntityResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddCompositeEntityChild creates a single child in an existing composite entity model.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// cEntityID - the composite entity extractor ID.
// compositeChildModelCreateObject - a model object containing the name of the new composite child model.
func (client ModelClient) AddCompositeEntityChild(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID, compositeChildModelCreateObject CompositeChildModelCreateObject) (result UUID, err error) {
	req, err := client.AddCompositeEntityChildPreparer(ctx, appID, versionID, cEntityID, compositeChildModelCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddCompositeEntityChild", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddCompositeEntityChildSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddCompositeEntityChild", resp, "Failure sending request")
		return
	}

	result, err = client.AddCompositeEntityChildResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddCompositeEntityChild", resp, "Failure responding to request")
		return
	}

	return
}

// AddCompositeEntityChildPreparer prepares the AddCompositeEntityChild request.
func (client ModelClient) AddCompositeEntityChildPreparer(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID, compositeChildModelCreateObject CompositeChildModelCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"cEntityId": autorest.Encode("path", cEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/compositeentities/{cEntityId}/children", pathParameters),
		autorest.WithJSON(compositeChildModelCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddCompositeEntityChildSender sends the AddCompositeEntityChild request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) AddCompositeEntityChildSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddCompositeEntityChildResponder handles the response to the AddCompositeEntityChild request. The method always
// closes the http.Response Body.
func (client ModelClient) AddCompositeEntityChildResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddCustomPrebuiltDomain adds a customizable prebuilt domain along with all of its models to this application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// prebuiltDomainObject - a prebuilt domain create object containing the name of the domain.
func (client ModelClient) AddCustomPrebuiltDomain(ctx context.Context, appID uuid.UUID, versionID string, prebuiltDomainObject PrebuiltDomainCreateBaseObject) (result ListUUID, err error) {
	req, err := client.AddCustomPrebuiltDomainPreparer(ctx, appID, versionID, prebuiltDomainObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddCustomPrebuiltDomain", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddCustomPrebuiltDomainSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddCustomPrebuiltDomain", resp, "Failure sending request")
		return
	}

	result, err = client.AddCustomPrebuiltDomainResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddCustomPrebuiltDomain", resp, "Failure responding to request")
		return
	}

	return
}

// AddCustomPrebuiltDomainPreparer prepares the AddCustomPrebuiltDomain request.
func (client ModelClient) AddCustomPrebuiltDomainPreparer(ctx context.Context, appID uuid.UUID, versionID string, prebuiltDomainObject PrebuiltDomainCreateBaseObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/customprebuiltdomains", pathParameters),
		autorest.WithJSON(prebuiltDomainObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddCustomPrebuiltDomainSender sends the AddCustomPrebuiltDomain request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) AddCustomPrebuiltDomainSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddCustomPrebuiltDomainResponder handles the response to the AddCustomPrebuiltDomain request. The method always
// closes the http.Response Body.
func (client ModelClient) AddCustomPrebuiltDomainResponder(resp *http.Response) (result ListUUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddCustomPrebuiltEntity adds a custom prebuilt entity model to the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// prebuiltDomainModelCreateObject - a model object containing the name of the custom prebuilt entity and the
// name of the domain to which this model belongs.
func (client ModelClient) AddCustomPrebuiltEntity(ctx context.Context, appID uuid.UUID, versionID string, prebuiltDomainModelCreateObject PrebuiltDomainModelCreateObject) (result UUID, err error) {
	req, err := client.AddCustomPrebuiltEntityPreparer(ctx, appID, versionID, prebuiltDomainModelCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddCustomPrebuiltEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddCustomPrebuiltEntitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddCustomPrebuiltEntity", resp, "Failure sending request")
		return
	}

	result, err = client.AddCustomPrebuiltEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddCustomPrebuiltEntity", resp, "Failure responding to request")
		return
	}

	return
}

// AddCustomPrebuiltEntityPreparer prepares the AddCustomPrebuiltEntity request.
func (client ModelClient) AddCustomPrebuiltEntityPreparer(ctx context.Context, appID uuid.UUID, versionID string, prebuiltDomainModelCreateObject PrebuiltDomainModelCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/customprebuiltentities", pathParameters),
		autorest.WithJSON(prebuiltDomainModelCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddCustomPrebuiltEntitySender sends the AddCustomPrebuiltEntity request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) AddCustomPrebuiltEntitySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddCustomPrebuiltEntityResponder handles the response to the AddCustomPrebuiltEntity request. The method always
// closes the http.Response Body.
func (client ModelClient) AddCustomPrebuiltEntityResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddCustomPrebuiltIntent adds a custom prebuilt intent model to the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// prebuiltDomainModelCreateObject - a model object containing the name of the custom prebuilt intent and the
// name of the domain to which this model belongs.
func (client ModelClient) AddCustomPrebuiltIntent(ctx context.Context, appID uuid.UUID, versionID string, prebuiltDomainModelCreateObject PrebuiltDomainModelCreateObject) (result UUID, err error) {
	req, err := client.AddCustomPrebuiltIntentPreparer(ctx, appID, versionID, prebuiltDomainModelCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddCustomPrebuiltIntent", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddCustomPrebuiltIntentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddCustomPrebuiltIntent", resp, "Failure sending request")
		return
	}

	result, err = client.AddCustomPrebuiltIntentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddCustomPrebuiltIntent", resp, "Failure responding to request")
		return
	}

	return
}

// AddCustomPrebuiltIntentPreparer prepares the AddCustomPrebuiltIntent request.
func (client ModelClient) AddCustomPrebuiltIntentPreparer(ctx context.Context, appID uuid.UUID, versionID string, prebuiltDomainModelCreateObject PrebuiltDomainModelCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/customprebuiltintents", pathParameters),
		autorest.WithJSON(prebuiltDomainModelCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddCustomPrebuiltIntentSender sends the AddCustomPrebuiltIntent request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) AddCustomPrebuiltIntentSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddCustomPrebuiltIntentResponder handles the response to the AddCustomPrebuiltIntent request. The method always
// closes the http.Response Body.
func (client ModelClient) AddCustomPrebuiltIntentResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddEntity adds an entity extractor to the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// modelCreateObject - a model object containing the name for the new entity extractor.
func (client ModelClient) AddEntity(ctx context.Context, appID uuid.UUID, versionID string, modelCreateObject ModelCreateObject) (result UUID, err error) {
	req, err := client.AddEntityPreparer(ctx, appID, versionID, modelCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddEntitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddEntity", resp, "Failure sending request")
		return
	}

	result, err = client.AddEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddEntity", resp, "Failure responding to request")
		return
	}

	return
}

// AddEntityPreparer prepares the AddEntity request.
func (client ModelClient) AddEntityPreparer(ctx context.Context, appID uuid.UUID, versionID string, modelCreateObject ModelCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/entities", pathParameters),
		autorest.WithJSON(modelCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddEntitySender sends the AddEntity request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) AddEntitySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddEntityResponder handles the response to the AddEntity request. The method always
// closes the http.Response Body.
func (client ModelClient) AddEntityResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddExplicitListItem sends the add explicit list item request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the Pattern.Any entity extractor ID.
// item - the new explicit list item.
func (client ModelClient) AddExplicitListItem(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, item ExplicitListItemCreateObject) (result Int32, err error) {
	req, err := client.AddExplicitListItemPreparer(ctx, appID, versionID, entityID, item)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddExplicitListItem", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddExplicitListItemSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddExplicitListItem", resp, "Failure sending request")
		return
	}

	result, err = client.AddExplicitListItemResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddExplicitListItem", resp, "Failure responding to request")
		return
	}

	return
}

// AddExplicitListItemPreparer prepares the AddExplicitListItem request.
func (client ModelClient) AddExplicitListItemPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, item ExplicitListItemCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}/explicitlist", pathParameters),
		autorest.WithJSON(item))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddExplicitListItemSender sends the AddExplicitListItem request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) AddExplicitListItemSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddExplicitListItemResponder handles the response to the AddExplicitListItem request. The method always
// closes the http.Response Body.
func (client ModelClient) AddExplicitListItemResponder(resp *http.Response) (result Int32, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddHierarchicalEntity adds a hierarchical entity extractor to the application version.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// hierarchicalModelCreateObject - a model containing the name and children of the new entity extractor.
func (client ModelClient) AddHierarchicalEntity(ctx context.Context, appID uuid.UUID, versionID string, hierarchicalModelCreateObject HierarchicalEntityModel) (result UUID, err error) {
	req, err := client.AddHierarchicalEntityPreparer(ctx, appID, versionID, hierarchicalModelCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddHierarchicalEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddHierarchicalEntitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddHierarchicalEntity", resp, "Failure sending request")
		return
	}

	result, err = client.AddHierarchicalEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddHierarchicalEntity", resp, "Failure responding to request")
		return
	}

	return
}

// AddHierarchicalEntityPreparer prepares the AddHierarchicalEntity request.
func (client ModelClient) AddHierarchicalEntityPreparer(ctx context.Context, appID uuid.UUID, versionID string, hierarchicalModelCreateObject HierarchicalEntityModel) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/hierarchicalentities", pathParameters),
		autorest.WithJSON(hierarchicalModelCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddHierarchicalEntitySender sends the AddHierarchicalEntity request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) AddHierarchicalEntitySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddHierarchicalEntityResponder handles the response to the AddHierarchicalEntity request. The method always
// closes the http.Response Body.
func (client ModelClient) AddHierarchicalEntityResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddHierarchicalEntityChild creates a single child in an existing hierarchical entity model.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// hEntityID - the hierarchical entity extractor ID.
// hierarchicalChildModelCreateObject - a model object containing the name of the new hierarchical child model.
func (client ModelClient) AddHierarchicalEntityChild(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, hierarchicalChildModelCreateObject HierarchicalChildModelCreateObject) (result UUID, err error) {
	req, err := client.AddHierarchicalEntityChildPreparer(ctx, appID, versionID, hEntityID, hierarchicalChildModelCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddHierarchicalEntityChild", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddHierarchicalEntityChildSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddHierarchicalEntityChild", resp, "Failure sending request")
		return
	}

	result, err = client.AddHierarchicalEntityChildResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddHierarchicalEntityChild", resp, "Failure responding to request")
		return
	}

	return
}

// AddHierarchicalEntityChildPreparer prepares the AddHierarchicalEntityChild request.
func (client ModelClient) AddHierarchicalEntityChildPreparer(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, hierarchicalChildModelCreateObject HierarchicalChildModelCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"hEntityId": autorest.Encode("path", hEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}/children", pathParameters),
		autorest.WithJSON(hierarchicalChildModelCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddHierarchicalEntityChildSender sends the AddHierarchicalEntityChild request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) AddHierarchicalEntityChildSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddHierarchicalEntityChildResponder handles the response to the AddHierarchicalEntityChild request. The method always
// closes the http.Response Body.
func (client ModelClient) AddHierarchicalEntityChildResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddIntent adds an intent classifier to the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// intentCreateObject - a model object containing the name of the new intent classifier.
func (client ModelClient) AddIntent(ctx context.Context, appID uuid.UUID, versionID string, intentCreateObject ModelCreateObject) (result UUID, err error) {
	req, err := client.AddIntentPreparer(ctx, appID, versionID, intentCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddIntent", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddIntentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddIntent", resp, "Failure sending request")
		return
	}

	result, err = client.AddIntentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddIntent", resp, "Failure responding to request")
		return
	}

	return
}

// AddIntentPreparer prepares the AddIntent request.
func (client ModelClient) AddIntentPreparer(ctx context.Context, appID uuid.UUID, versionID string, intentCreateObject ModelCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/intents", pathParameters),
		autorest.WithJSON(intentCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddIntentSender sends the AddIntent request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) AddIntentSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddIntentResponder handles the response to the AddIntent request. The method always
// closes the http.Response Body.
func (client ModelClient) AddIntentResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddPrebuilt adds a list of prebuilt entity extractors to the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// prebuiltExtractorNames - an array of prebuilt entity extractor names.
func (client ModelClient) AddPrebuilt(ctx context.Context, appID uuid.UUID, versionID string, prebuiltExtractorNames []string) (result ListPrebuiltEntityExtractor, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: prebuiltExtractorNames,
			Constraints: []validation.Constraint{{Target: "prebuiltExtractorNames", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("programmatic.ModelClient", "AddPrebuilt", err.Error())
	}

	req, err := client.AddPrebuiltPreparer(ctx, appID, versionID, prebuiltExtractorNames)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddPrebuilt", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddPrebuiltSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddPrebuilt", resp, "Failure sending request")
		return
	}

	result, err = client.AddPrebuiltResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddPrebuilt", resp, "Failure responding to request")
		return
	}

	return
}

// AddPrebuiltPreparer prepares the AddPrebuilt request.
func (client ModelClient) AddPrebuiltPreparer(ctx context.Context, appID uuid.UUID, versionID string, prebuiltExtractorNames []string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/prebuilts", pathParameters),
		autorest.WithJSON(prebuiltExtractorNames))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddPrebuiltSender sends the AddPrebuilt request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) AddPrebuiltSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddPrebuiltResponder handles the response to the AddPrebuilt request. The method always
// closes the http.Response Body.
func (client ModelClient) AddPrebuiltResponder(resp *http.Response) (result ListPrebuiltEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddSubList adds a list to an existing closed list.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// clEntityID - the closed list entity extractor ID.
// wordListCreateObject - words list.
func (client ModelClient) AddSubList(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID, wordListCreateObject WordListObject) (result Int32, err error) {
	req, err := client.AddSubListPreparer(ctx, appID, versionID, clEntityID, wordListCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddSubList", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddSubListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddSubList", resp, "Failure sending request")
		return
	}

	result, err = client.AddSubListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddSubList", resp, "Failure responding to request")
		return
	}

	return
}

// AddSubListPreparer prepares the AddSubList request.
func (client ModelClient) AddSubListPreparer(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID, wordListCreateObject WordListObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":      autorest.Encode("path", appID),
		"clEntityId": autorest.Encode("path", clEntityID),
		"versionId":  autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/closedlists/{clEntityId}/sublists", pathParameters),
		autorest.WithJSON(wordListCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddSubListSender sends the AddSubList request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) AddSubListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddSubListResponder handles the response to the AddSubList request. The method always
// closes the http.Response Body.
func (client ModelClient) AddSubListResponder(resp *http.Response) (result Int32, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateClosedListEntityRole sends the create closed list entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity model ID.
// entityRoleCreateObject - an entity role object containing the name of role.
func (client ModelClient) CreateClosedListEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, entityRoleCreateObject EntityRoleCreateObject) (result UUID, err error) {
	req, err := client.CreateClosedListEntityRolePreparer(ctx, appID, versionID, entityID, entityRoleCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "CreateClosedListEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateClosedListEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "CreateClosedListEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.CreateClosedListEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "CreateClosedListEntityRole", resp, "Failure responding to request")
		return
	}

	return
}

// CreateClosedListEntityRolePreparer prepares the CreateClosedListEntityRole request.
func (client ModelClient) CreateClosedListEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, entityRoleCreateObject EntityRoleCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/closedlists/{entityId}/roles", pathParameters),
		autorest.WithJSON(entityRoleCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateClosedListEntityRoleSender sends the CreateClosedListEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) CreateClosedListEntityRoleSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreateClosedListEntityRoleResponder handles the response to the CreateClosedListEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) CreateClosedListEntityRoleResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateCompositeEntityRole sends the create composite entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// cEntityID - the composite entity extractor ID.
// entityRoleCreateObject - an entity role object containing the name of role.
func (client ModelClient) CreateCompositeEntityRole(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID, entityRoleCreateObject EntityRoleCreateObject) (result UUID, err error) {
	req, err := client.CreateCompositeEntityRolePreparer(ctx, appID, versionID, cEntityID, entityRoleCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "CreateCompositeEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateCompositeEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "CreateCompositeEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.CreateCompositeEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "CreateCompositeEntityRole", resp, "Failure responding to request")
		return
	}

	return
}

// CreateCompositeEntityRolePreparer prepares the CreateCompositeEntityRole request.
func (client ModelClient) CreateCompositeEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID, entityRoleCreateObject EntityRoleCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"cEntityId": autorest.Encode("path", cEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/compositeentities/{cEntityId}/roles", pathParameters),
		autorest.WithJSON(entityRoleCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateCompositeEntityRoleSender sends the CreateCompositeEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) CreateCompositeEntityRoleSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreateCompositeEntityRoleResponder handles the response to the CreateCompositeEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) CreateCompositeEntityRoleResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateCustomPrebuiltEntityRole sends the create custom prebuilt entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity model ID.
// entityRoleCreateObject - an entity role object containing the name of role.
func (client ModelClient) CreateCustomPrebuiltEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, entityRoleCreateObject EntityRoleCreateObject) (result UUID, err error) {
	req, err := client.CreateCustomPrebuiltEntityRolePreparer(ctx, appID, versionID, entityID, entityRoleCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "CreateCustomPrebuiltEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateCustomPrebuiltEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "CreateCustomPrebuiltEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.CreateCustomPrebuiltEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "CreateCustomPrebuiltEntityRole", resp, "Failure responding to request")
		return
	}

	return
}

// CreateCustomPrebuiltEntityRolePreparer prepares the CreateCustomPrebuiltEntityRole request.
func (client ModelClient) CreateCustomPrebuiltEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, entityRoleCreateObject EntityRoleCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/customprebuiltentities/{entityId}/roles", pathParameters),
		autorest.WithJSON(entityRoleCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateCustomPrebuiltEntityRoleSender sends the CreateCustomPrebuiltEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) CreateCustomPrebuiltEntityRoleSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreateCustomPrebuiltEntityRoleResponder handles the response to the CreateCustomPrebuiltEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) CreateCustomPrebuiltEntityRoleResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateEntityRole sends the create entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity model ID.
// entityRoleCreateObject - an entity role object containing the name of role.
func (client ModelClient) CreateEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, entityRoleCreateObject EntityRoleCreateObject) (result UUID, err error) {
	req, err := client.CreateEntityRolePreparer(ctx, appID, versionID, entityID, entityRoleCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "CreateEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "CreateEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.CreateEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "CreateEntityRole", resp, "Failure responding to request")
		return
	}

	return
}

// CreateEntityRolePreparer prepares the CreateEntityRole request.
func (client ModelClient) CreateEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, entityRoleCreateObject EntityRoleCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/entities/{entityId}/roles", pathParameters),
		autorest.WithJSON(entityRoleCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateEntityRoleSender sends the CreateEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) CreateEntityRoleSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreateEntityRoleResponder handles the response to the CreateEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) CreateEntityRoleResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateHierarchicalEntityRole sends the create hierarchical entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// hEntityID - the hierarchical entity extractor ID.
// entityRoleCreateObject - an entity role object containing the name of role.
func (client ModelClient) CreateHierarchicalEntityRole(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, entityRoleCreateObject EntityRoleCreateObject) (result UUID, err error) {
	req, err := client.CreateHierarchicalEntityRolePreparer(ctx, appID, versionID, hEntityID, entityRoleCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "CreateHierarchicalEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateHierarchicalEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "CreateHierarchicalEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.CreateHierarchicalEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "CreateHierarchicalEntityRole", resp, "Failure responding to request")
		return
	}

	return
}

// CreateHierarchicalEntityRolePreparer prepares the CreateHierarchicalEntityRole request.
func (client ModelClient) CreateHierarchicalEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, entityRoleCreateObject EntityRoleCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"hEntityId": autorest.Encode("path", hEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}/roles", pathParameters),
		autorest.WithJSON(entityRoleCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateHierarchicalEntityRoleSender sends the CreateHierarchicalEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) CreateHierarchicalEntityRoleSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreateHierarchicalEntityRoleResponder handles the response to the CreateHierarchicalEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) CreateHierarchicalEntityRoleResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreatePatternAnyEntityModel sends the create pattern any entity model request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// extractorCreateObject - a model object containing the name and explicit list for the new Pattern.Any entity
// extractor.
func (client ModelClient) CreatePatternAnyEntityModel(ctx context.Context, appID uuid.UUID, versionID string, extractorCreateObject PatternAnyModelCreateObject) (result UUID, err error) {
	req, err := client.CreatePatternAnyEntityModelPreparer(ctx, appID, versionID, extractorCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "CreatePatternAnyEntityModel", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreatePatternAnyEntityModelSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "CreatePatternAnyEntityModel", resp, "Failure sending request")
		return
	}

	result, err = client.CreatePatternAnyEntityModelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "CreatePatternAnyEntityModel", resp, "Failure responding to request")
		return
	}

	return
}

// CreatePatternAnyEntityModelPreparer prepares the CreatePatternAnyEntityModel request.
func (client ModelClient) CreatePatternAnyEntityModelPreparer(ctx context.Context, appID uuid.UUID, versionID string, extractorCreateObject PatternAnyModelCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/patternanyentities", pathParameters),
		autorest.WithJSON(extractorCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreatePatternAnyEntityModelSender sends the CreatePatternAnyEntityModel request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) CreatePatternAnyEntityModelSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreatePatternAnyEntityModelResponder handles the response to the CreatePatternAnyEntityModel request. The method always
// closes the http.Response Body.
func (client ModelClient) CreatePatternAnyEntityModelResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreatePatternAnyEntityRole sends the create pattern any entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity model ID.
// entityRoleCreateObject - an entity role object containing the name of role.
func (client ModelClient) CreatePatternAnyEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, entityRoleCreateObject EntityRoleCreateObject) (result UUID, err error) {
	req, err := client.CreatePatternAnyEntityRolePreparer(ctx, appID, versionID, entityID, entityRoleCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "CreatePatternAnyEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreatePatternAnyEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "CreatePatternAnyEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.CreatePatternAnyEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "CreatePatternAnyEntityRole", resp, "Failure responding to request")
		return
	}

	return
}

// CreatePatternAnyEntityRolePreparer prepares the CreatePatternAnyEntityRole request.
func (client ModelClient) CreatePatternAnyEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, entityRoleCreateObject EntityRoleCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}/roles", pathParameters),
		autorest.WithJSON(entityRoleCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreatePatternAnyEntityRoleSender sends the CreatePatternAnyEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) CreatePatternAnyEntityRoleSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreatePatternAnyEntityRoleResponder handles the response to the CreatePatternAnyEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) CreatePatternAnyEntityRoleResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreatePrebuiltEntityRole sends the create prebuilt entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity model ID.
// entityRoleCreateObject - an entity role object containing the name of role.
func (client ModelClient) CreatePrebuiltEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, entityRoleCreateObject EntityRoleCreateObject) (result UUID, err error) {
	req, err := client.CreatePrebuiltEntityRolePreparer(ctx, appID, versionID, entityID, entityRoleCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "CreatePrebuiltEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreatePrebuiltEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "CreatePrebuiltEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.CreatePrebuiltEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "CreatePrebuiltEntityRole", resp, "Failure responding to request")
		return
	}

	return
}

// CreatePrebuiltEntityRolePreparer prepares the CreatePrebuiltEntityRole request.
func (client ModelClient) CreatePrebuiltEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, entityRoleCreateObject EntityRoleCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/prebuilts/{entityId}/roles", pathParameters),
		autorest.WithJSON(entityRoleCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreatePrebuiltEntityRoleSender sends the CreatePrebuiltEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) CreatePrebuiltEntityRoleSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreatePrebuiltEntityRoleResponder handles the response to the CreatePrebuiltEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) CreatePrebuiltEntityRoleResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateRegexEntityModel sends the create regex entity model request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// regexEntityExtractorCreateObj - a model object containing the name and regex pattern for the new regex
// entity extractor.
func (client ModelClient) CreateRegexEntityModel(ctx context.Context, appID uuid.UUID, versionID string, regexEntityExtractorCreateObj RegexModelCreateObject) (result UUID, err error) {
	req, err := client.CreateRegexEntityModelPreparer(ctx, appID, versionID, regexEntityExtractorCreateObj)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "CreateRegexEntityModel", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateRegexEntityModelSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "CreateRegexEntityModel", resp, "Failure sending request")
		return
	}

	result, err = client.CreateRegexEntityModelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "CreateRegexEntityModel", resp, "Failure responding to request")
		return
	}

	return
}

// CreateRegexEntityModelPreparer prepares the CreateRegexEntityModel request.
func (client ModelClient) CreateRegexEntityModelPreparer(ctx context.Context, appID uuid.UUID, versionID string, regexEntityExtractorCreateObj RegexModelCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/regexentities", pathParameters),
		autorest.WithJSON(regexEntityExtractorCreateObj))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateRegexEntityModelSender sends the CreateRegexEntityModel request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) CreateRegexEntityModelSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreateRegexEntityModelResponder handles the response to the CreateRegexEntityModel request. The method always
// closes the http.Response Body.
func (client ModelClient) CreateRegexEntityModelResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateRegexEntityRole sends the create regex entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity model ID.
// entityRoleCreateObject - an entity role object containing the name of role.
func (client ModelClient) CreateRegexEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, entityRoleCreateObject EntityRoleCreateObject) (result UUID, err error) {
	req, err := client.CreateRegexEntityRolePreparer(ctx, appID, versionID, entityID, entityRoleCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "CreateRegexEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateRegexEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "CreateRegexEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.CreateRegexEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "CreateRegexEntityRole", resp, "Failure responding to request")
		return
	}

	return
}

// CreateRegexEntityRolePreparer prepares the CreateRegexEntityRole request.
func (client ModelClient) CreateRegexEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, entityRoleCreateObject EntityRoleCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/regexentities/{entityId}/roles", pathParameters),
		autorest.WithJSON(entityRoleCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateRegexEntityRoleSender sends the CreateRegexEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) CreateRegexEntityRoleSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreateRegexEntityRoleResponder handles the response to the CreateRegexEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) CreateRegexEntityRoleResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteClosedList deletes a closed list model from the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// clEntityID - the closed list model ID.
func (client ModelClient) DeleteClosedList(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID) (result OperationStatus, err error) {
	req, err := client.DeleteClosedListPreparer(ctx, appID, versionID, clEntityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteClosedList", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteClosedListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteClosedList", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteClosedListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteClosedList", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteClosedListPreparer prepares the DeleteClosedList request.
func (client ModelClient) DeleteClosedListPreparer(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":      autorest.Encode("path", appID),
		"clEntityId": autorest.Encode("path", clEntityID),
		"versionId":  autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/closedlists/{clEntityId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteClosedListSender sends the DeleteClosedList request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteClosedListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteClosedListResponder handles the response to the DeleteClosedList request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteClosedListResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteClosedListEntityRole sends the delete closed list entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity ID.
// roleID - the entity role Id.
func (client ModelClient) DeleteClosedListEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (result OperationStatus, err error) {
	req, err := client.DeleteClosedListEntityRolePreparer(ctx, appID, versionID, entityID, roleID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteClosedListEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteClosedListEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteClosedListEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteClosedListEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteClosedListEntityRole", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteClosedListEntityRolePreparer prepares the DeleteClosedListEntityRole request.
func (client ModelClient) DeleteClosedListEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/closedlists/{entityId}/roles/{roleId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteClosedListEntityRoleSender sends the DeleteClosedListEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteClosedListEntityRoleSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteClosedListEntityRoleResponder handles the response to the DeleteClosedListEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteClosedListEntityRoleResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteCompositeEntity deletes a composite entity extractor from the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// cEntityID - the composite entity extractor ID.
func (client ModelClient) DeleteCompositeEntity(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID) (result OperationStatus, err error) {
	req, err := client.DeleteCompositeEntityPreparer(ctx, appID, versionID, cEntityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteCompositeEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteCompositeEntitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteCompositeEntity", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteCompositeEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteCompositeEntity", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteCompositeEntityPreparer prepares the DeleteCompositeEntity request.
func (client ModelClient) DeleteCompositeEntityPreparer(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"cEntityId": autorest.Encode("path", cEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/compositeentities/{cEntityId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteCompositeEntitySender sends the DeleteCompositeEntity request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteCompositeEntitySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteCompositeEntityResponder handles the response to the DeleteCompositeEntity request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteCompositeEntityResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteCompositeEntityChild deletes a composite entity extractor child from the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// cEntityID - the composite entity extractor ID.
// cChildID - the hierarchical entity extractor child ID.
func (client ModelClient) DeleteCompositeEntityChild(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID, cChildID uuid.UUID) (result OperationStatus, err error) {
	req, err := client.DeleteCompositeEntityChildPreparer(ctx, appID, versionID, cEntityID, cChildID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteCompositeEntityChild", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteCompositeEntityChildSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteCompositeEntityChild", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteCompositeEntityChildResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteCompositeEntityChild", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteCompositeEntityChildPreparer prepares the DeleteCompositeEntityChild request.
func (client ModelClient) DeleteCompositeEntityChildPreparer(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID, cChildID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"cChildId":  autorest.Encode("path", cChildID),
		"cEntityId": autorest.Encode("path", cEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/compositeentities/{cEntityId}/children/{cChildId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteCompositeEntityChildSender sends the DeleteCompositeEntityChild request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteCompositeEntityChildSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteCompositeEntityChildResponder handles the response to the DeleteCompositeEntityChild request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteCompositeEntityChildResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteCompositeEntityRole sends the delete composite entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// cEntityID - the composite entity extractor ID.
// roleID - the entity role Id.
func (client ModelClient) DeleteCompositeEntityRole(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID, roleID uuid.UUID) (result OperationStatus, err error) {
	req, err := client.DeleteCompositeEntityRolePreparer(ctx, appID, versionID, cEntityID, roleID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteCompositeEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteCompositeEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteCompositeEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteCompositeEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteCompositeEntityRole", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteCompositeEntityRolePreparer prepares the DeleteCompositeEntityRole request.
func (client ModelClient) DeleteCompositeEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID, roleID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"cEntityId": autorest.Encode("path", cEntityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/compositeentities/{cEntityId}/roles/{roleId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteCompositeEntityRoleSender sends the DeleteCompositeEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteCompositeEntityRoleSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteCompositeEntityRoleResponder handles the response to the DeleteCompositeEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteCompositeEntityRoleResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteCustomEntityRole sends the delete custom entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity ID.
// roleID - the entity role Id.
func (client ModelClient) DeleteCustomEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (result OperationStatus, err error) {
	req, err := client.DeleteCustomEntityRolePreparer(ctx, appID, versionID, entityID, roleID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteCustomEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteCustomEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteCustomEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteCustomEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteCustomEntityRole", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteCustomEntityRolePreparer prepares the DeleteCustomEntityRole request.
func (client ModelClient) DeleteCustomEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/customprebuiltentities/{entityId}/roles/{roleId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteCustomEntityRoleSender sends the DeleteCustomEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteCustomEntityRoleSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteCustomEntityRoleResponder handles the response to the DeleteCustomEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteCustomEntityRoleResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteCustomPrebuiltDomain deletes a prebuilt domain's models from the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// domainName - domain name.
func (client ModelClient) DeleteCustomPrebuiltDomain(ctx context.Context, appID uuid.UUID, versionID string, domainName string) (result OperationStatus, err error) {
	req, err := client.DeleteCustomPrebuiltDomainPreparer(ctx, appID, versionID, domainName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteCustomPrebuiltDomain", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteCustomPrebuiltDomainSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteCustomPrebuiltDomain", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteCustomPrebuiltDomainResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteCustomPrebuiltDomain", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteCustomPrebuiltDomainPreparer prepares the DeleteCustomPrebuiltDomain request.
func (client ModelClient) DeleteCustomPrebuiltDomainPreparer(ctx context.Context, appID uuid.UUID, versionID string, domainName string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":      autorest.Encode("path", appID),
		"domainName": autorest.Encode("path", domainName),
		"versionId":  autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/customprebuiltdomains/{domainName}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteCustomPrebuiltDomainSender sends the DeleteCustomPrebuiltDomain request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteCustomPrebuiltDomainSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteCustomPrebuiltDomainResponder handles the response to the DeleteCustomPrebuiltDomain request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteCustomPrebuiltDomainResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteEntity deletes an entity extractor from the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity extractor ID.
func (client ModelClient) DeleteEntity(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (result OperationStatus, err error) {
	req, err := client.DeleteEntityPreparer(ctx, appID, versionID, entityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteEntitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteEntity", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteEntity", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteEntityPreparer prepares the DeleteEntity request.
func (client ModelClient) DeleteEntityPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/entities/{entityId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteEntitySender sends the DeleteEntity request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteEntitySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteEntityResponder handles the response to the DeleteEntity request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteEntityResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteEntityRole sends the delete entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity ID.
// roleID - the entity role Id.
func (client ModelClient) DeleteEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (result OperationStatus, err error) {
	req, err := client.DeleteEntityRolePreparer(ctx, appID, versionID, entityID, roleID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteEntityRole", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteEntityRolePreparer prepares the DeleteEntityRole request.
func (client ModelClient) DeleteEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/entities/{entityId}/roles/{roleId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteEntityRoleSender sends the DeleteEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteEntityRoleSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteEntityRoleResponder handles the response to the DeleteEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteEntityRoleResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteExplicitListItem sends the delete explicit list item request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the pattern.any entity id.
// itemID - the explicit list item which will be deleted.
func (client ModelClient) DeleteExplicitListItem(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, itemID int64) (result OperationStatus, err error) {
	req, err := client.DeleteExplicitListItemPreparer(ctx, appID, versionID, entityID, itemID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteExplicitListItem", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteExplicitListItemSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteExplicitListItem", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteExplicitListItemResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteExplicitListItem", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteExplicitListItemPreparer prepares the DeleteExplicitListItem request.
func (client ModelClient) DeleteExplicitListItemPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, itemID int64) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"itemId":    autorest.Encode("path", itemID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}/explicitlist/{itemId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteExplicitListItemSender sends the DeleteExplicitListItem request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteExplicitListItemSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteExplicitListItemResponder handles the response to the DeleteExplicitListItem request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteExplicitListItemResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteHierarchicalEntity deletes a hierarchical entity extractor from the application version.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// hEntityID - the hierarchical entity extractor ID.
func (client ModelClient) DeleteHierarchicalEntity(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID) (result OperationStatus, err error) {
	req, err := client.DeleteHierarchicalEntityPreparer(ctx, appID, versionID, hEntityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteHierarchicalEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteHierarchicalEntitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteHierarchicalEntity", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteHierarchicalEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteHierarchicalEntity", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteHierarchicalEntityPreparer prepares the DeleteHierarchicalEntity request.
func (client ModelClient) DeleteHierarchicalEntityPreparer(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"hEntityId": autorest.Encode("path", hEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteHierarchicalEntitySender sends the DeleteHierarchicalEntity request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteHierarchicalEntitySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteHierarchicalEntityResponder handles the response to the DeleteHierarchicalEntity request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteHierarchicalEntityResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteHierarchicalEntityChild deletes a hierarchical entity extractor child from the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// hEntityID - the hierarchical entity extractor ID.
// hChildID - the hierarchical entity extractor child ID.
func (client ModelClient) DeleteHierarchicalEntityChild(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, hChildID uuid.UUID) (result OperationStatus, err error) {
	req, err := client.DeleteHierarchicalEntityChildPreparer(ctx, appID, versionID, hEntityID, hChildID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteHierarchicalEntityChild", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteHierarchicalEntityChildSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteHierarchicalEntityChild", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteHierarchicalEntityChildResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteHierarchicalEntityChild", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteHierarchicalEntityChildPreparer prepares the DeleteHierarchicalEntityChild request.
func (client ModelClient) DeleteHierarchicalEntityChildPreparer(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, hChildID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"hChildId":  autorest.Encode("path", hChildID),
		"hEntityId": autorest.Encode("path", hEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}/children/{hChildId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteHierarchicalEntityChildSender sends the DeleteHierarchicalEntityChild request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteHierarchicalEntityChildSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteHierarchicalEntityChildResponder handles the response to the DeleteHierarchicalEntityChild request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteHierarchicalEntityChildResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteHierarchicalEntityRole sends the delete hierarchical entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// hEntityID - the hierarchical entity extractor ID.
// roleID - the entity role Id.
func (client ModelClient) DeleteHierarchicalEntityRole(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, roleID uuid.UUID) (result OperationStatus, err error) {
	req, err := client.DeleteHierarchicalEntityRolePreparer(ctx, appID, versionID, hEntityID, roleID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteHierarchicalEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteHierarchicalEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteHierarchicalEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteHierarchicalEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteHierarchicalEntityRole", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteHierarchicalEntityRolePreparer prepares the DeleteHierarchicalEntityRole request.
func (client ModelClient) DeleteHierarchicalEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, roleID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"hEntityId": autorest.Encode("path", hEntityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}/roles/{roleId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteHierarchicalEntityRoleSender sends the DeleteHierarchicalEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteHierarchicalEntityRoleSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteHierarchicalEntityRoleResponder handles the response to the DeleteHierarchicalEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteHierarchicalEntityRoleResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteIntent deletes an intent classifier from the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// intentID - the intent classifier ID.
// deleteUtterances - also delete the intent's utterances (true). Or move the utterances to the None intent
// (false - the default value).
func (client ModelClient) DeleteIntent(ctx context.Context, appID uuid.UUID, versionID string, intentID uuid.UUID, deleteUtterances *bool) (result OperationStatus, err error) {
	req, err := client.DeleteIntentPreparer(ctx, appID, versionID, intentID, deleteUtterances)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteIntent", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteIntentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteIntent", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteIntentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteIntent", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteIntentPreparer prepares the DeleteIntent request.
func (client ModelClient) DeleteIntentPreparer(ctx context.Context, appID uuid.UUID, versionID string, intentID uuid.UUID, deleteUtterances *bool) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"intentId":  autorest.Encode("path", intentID),
		"versionId": autorest.Encode("path", versionID),
	}

	queryParameters := map[string]interface{}{}
	if deleteUtterances != nil {
		queryParameters["deleteUtterances"] = autorest.Encode("query", *deleteUtterances)
	} else {
		queryParameters["deleteUtterances"] = autorest.Encode("query", false)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/intents/{intentId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteIntentSender sends the DeleteIntent request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteIntentSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteIntentResponder handles the response to the DeleteIntent request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteIntentResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeletePatternAnyEntityModel sends the delete pattern any entity model request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the Pattern.Any entity extractor ID.
func (client ModelClient) DeletePatternAnyEntityModel(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (result OperationStatus, err error) {
	req, err := client.DeletePatternAnyEntityModelPreparer(ctx, appID, versionID, entityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeletePatternAnyEntityModel", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeletePatternAnyEntityModelSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeletePatternAnyEntityModel", resp, "Failure sending request")
		return
	}

	result, err = client.DeletePatternAnyEntityModelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeletePatternAnyEntityModel", resp, "Failure responding to request")
		return
	}

	return
}

// DeletePatternAnyEntityModelPreparer prepares the DeletePatternAnyEntityModel request.
func (client ModelClient) DeletePatternAnyEntityModelPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeletePatternAnyEntityModelSender sends the DeletePatternAnyEntityModel request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeletePatternAnyEntityModelSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeletePatternAnyEntityModelResponder handles the response to the DeletePatternAnyEntityModel request. The method always
// closes the http.Response Body.
func (client ModelClient) DeletePatternAnyEntityModelResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeletePatternAnyEntityRole sends the delete pattern any entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity ID.
// roleID - the entity role Id.
func (client ModelClient) DeletePatternAnyEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (result OperationStatus, err error) {
	req, err := client.DeletePatternAnyEntityRolePreparer(ctx, appID, versionID, entityID, roleID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeletePatternAnyEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeletePatternAnyEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeletePatternAnyEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.DeletePatternAnyEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeletePatternAnyEntityRole", resp, "Failure responding to request")
		return
	}

	return
}

// DeletePatternAnyEntityRolePreparer prepares the DeletePatternAnyEntityRole request.
func (client ModelClient) DeletePatternAnyEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}/roles/{roleId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeletePatternAnyEntityRoleSender sends the DeletePatternAnyEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeletePatternAnyEntityRoleSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeletePatternAnyEntityRoleResponder handles the response to the DeletePatternAnyEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) DeletePatternAnyEntityRoleResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeletePrebuilt deletes a prebuilt entity extractor from the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// prebuiltID - the prebuilt entity extractor ID.
func (client ModelClient) DeletePrebuilt(ctx context.Context, appID uuid.UUID, versionID string, prebuiltID uuid.UUID) (result OperationStatus, err error) {
	req, err := client.DeletePrebuiltPreparer(ctx, appID, versionID, prebuiltID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeletePrebuilt", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeletePrebuiltSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeletePrebuilt", resp, "Failure sending request")
		return
	}

	result, err = client.DeletePrebuiltResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeletePrebuilt", resp, "Failure responding to request")
		return
	}

	return
}

// DeletePrebuiltPreparer prepares the DeletePrebuilt request.
func (client ModelClient) DeletePrebuiltPreparer(ctx context.Context, appID uuid.UUID, versionID string, prebuiltID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":      autorest.Encode("path", appID),
		"prebuiltId": autorest.Encode("path", prebuiltID),
		"versionId":  autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/prebuilts/{prebuiltId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeletePrebuiltSender sends the DeletePrebuilt request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeletePrebuiltSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeletePrebuiltResponder handles the response to the DeletePrebuilt request. The method always
// closes the http.Response Body.
func (client ModelClient) DeletePrebuiltResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeletePrebuiltEntityRole sends the delete prebuilt entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity ID.
// roleID - the entity role Id.
func (client ModelClient) DeletePrebuiltEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (result OperationStatus, err error) {
	req, err := client.DeletePrebuiltEntityRolePreparer(ctx, appID, versionID, entityID, roleID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeletePrebuiltEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeletePrebuiltEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeletePrebuiltEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.DeletePrebuiltEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeletePrebuiltEntityRole", resp, "Failure responding to request")
		return
	}

	return
}

// DeletePrebuiltEntityRolePreparer prepares the DeletePrebuiltEntityRole request.
func (client ModelClient) DeletePrebuiltEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/prebuilts/{entityId}/roles/{roleId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeletePrebuiltEntityRoleSender sends the DeletePrebuiltEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeletePrebuiltEntityRoleSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeletePrebuiltEntityRoleResponder handles the response to the DeletePrebuiltEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) DeletePrebuiltEntityRoleResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteRegexEntityModel sends the delete regex entity model request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// regexEntityID - the regex entity extractor ID.
func (client ModelClient) DeleteRegexEntityModel(ctx context.Context, appID uuid.UUID, versionID string, regexEntityID uuid.UUID) (result OperationStatus, err error) {
	req, err := client.DeleteRegexEntityModelPreparer(ctx, appID, versionID, regexEntityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteRegexEntityModel", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteRegexEntityModelSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteRegexEntityModel", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteRegexEntityModelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteRegexEntityModel", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteRegexEntityModelPreparer prepares the DeleteRegexEntityModel request.
func (client ModelClient) DeleteRegexEntityModelPreparer(ctx context.Context, appID uuid.UUID, versionID string, regexEntityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":         autorest.Encode("path", appID),
		"regexEntityId": autorest.Encode("path", regexEntityID),
		"versionId":     autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/regexentities/{regexEntityId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteRegexEntityModelSender sends the DeleteRegexEntityModel request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteRegexEntityModelSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteRegexEntityModelResponder handles the response to the DeleteRegexEntityModel request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteRegexEntityModelResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteRegexEntityRole sends the delete regex entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity ID.
// roleID - the entity role Id.
func (client ModelClient) DeleteRegexEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (result OperationStatus, err error) {
	req, err := client.DeleteRegexEntityRolePreparer(ctx, appID, versionID, entityID, roleID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteRegexEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteRegexEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteRegexEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteRegexEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteRegexEntityRole", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteRegexEntityRolePreparer prepares the DeleteRegexEntityRole request.
func (client ModelClient) DeleteRegexEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/regexentities/{entityId}/roles/{roleId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteRegexEntityRoleSender sends the DeleteRegexEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteRegexEntityRoleSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteRegexEntityRoleResponder handles the response to the DeleteRegexEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteRegexEntityRoleResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteSubList deletes a sublist of a specific closed list model.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// clEntityID - the closed list entity extractor ID.
// subListID - the sublist ID.
func (client ModelClient) DeleteSubList(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID, subListID int32) (result OperationStatus, err error) {
	req, err := client.DeleteSubListPreparer(ctx, appID, versionID, clEntityID, subListID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteSubList", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSubListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteSubList", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteSubListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteSubList", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteSubListPreparer prepares the DeleteSubList request.
func (client ModelClient) DeleteSubListPreparer(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID, subListID int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":      autorest.Encode("path", appID),
		"clEntityId": autorest.Encode("path", clEntityID),
		"subListId":  autorest.Encode("path", subListID),
		"versionId":  autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/closedlists/{clEntityId}/sublists/{subListId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSubListSender sends the DeleteSubList request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteSubListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteSubListResponder handles the response to the DeleteSubList request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteSubListResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetClosedList gets information of a closed list model.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// clEntityID - the closed list model ID.
func (client ModelClient) GetClosedList(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID) (result ClosedListEntityExtractor, err error) {
	req, err := client.GetClosedListPreparer(ctx, appID, versionID, clEntityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetClosedList", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetClosedListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetClosedList", resp, "Failure sending request")
		return
	}

	result, err = client.GetClosedListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetClosedList", resp, "Failure responding to request")
		return
	}

	return
}

// GetClosedListPreparer prepares the GetClosedList request.
func (client ModelClient) GetClosedListPreparer(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":      autorest.Encode("path", appID),
		"clEntityId": autorest.Encode("path", clEntityID),
		"versionId":  autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/closedlists/{clEntityId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetClosedListSender sends the GetClosedList request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetClosedListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetClosedListResponder handles the response to the GetClosedList request. The method always
// closes the http.Response Body.
func (client ModelClient) GetClosedListResponder(resp *http.Response) (result ClosedListEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetClosedListEntityRole sends the get closed list entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - entity ID.
// roleID - entity role ID.
func (client ModelClient) GetClosedListEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (result EntityRole, err error) {
	req, err := client.GetClosedListEntityRolePreparer(ctx, appID, versionID, entityID, roleID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetClosedListEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetClosedListEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetClosedListEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.GetClosedListEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetClosedListEntityRole", resp, "Failure responding to request")
		return
	}

	return
}

// GetClosedListEntityRolePreparer prepares the GetClosedListEntityRole request.
func (client ModelClient) GetClosedListEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/closedlists/{entityId}/roles/{roleId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetClosedListEntityRoleSender sends the GetClosedListEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetClosedListEntityRoleSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetClosedListEntityRoleResponder handles the response to the GetClosedListEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) GetClosedListEntityRoleResponder(resp *http.Response) (result EntityRole, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetClosedListEntityRoles sends the get closed list entity roles request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - entity Id
func (client ModelClient) GetClosedListEntityRoles(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (result ListEntityRole, err error) {
	req, err := client.GetClosedListEntityRolesPreparer(ctx, appID, versionID, entityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetClosedListEntityRoles", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetClosedListEntityRolesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetClosedListEntityRoles", resp, "Failure sending request")
		return
	}

	result, err = client.GetClosedListEntityRolesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetClosedListEntityRoles", resp, "Failure responding to request")
		return
	}

	return
}

// GetClosedListEntityRolesPreparer prepares the GetClosedListEntityRoles request.
func (client ModelClient) GetClosedListEntityRolesPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/closedlists/{entityId}/roles", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetClosedListEntityRolesSender sends the GetClosedListEntityRoles request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetClosedListEntityRolesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetClosedListEntityRolesResponder handles the response to the GetClosedListEntityRoles request. The method always
// closes the http.Response Body.
func (client ModelClient) GetClosedListEntityRolesResponder(resp *http.Response) (result ListEntityRole, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetCompositeEntity gets information about the composite entity model.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// cEntityID - the composite entity extractor ID.
func (client ModelClient) GetCompositeEntity(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID) (result CompositeEntityExtractor, err error) {
	req, err := client.GetCompositeEntityPreparer(ctx, appID, versionID, cEntityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetCompositeEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetCompositeEntitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetCompositeEntity", resp, "Failure sending request")
		return
	}

	result, err = client.GetCompositeEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetCompositeEntity", resp, "Failure responding to request")
		return
	}

	return
}

// GetCompositeEntityPreparer prepares the GetCompositeEntity request.
func (client ModelClient) GetCompositeEntityPreparer(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"cEntityId": autorest.Encode("path", cEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/compositeentities/{cEntityId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetCompositeEntitySender sends the GetCompositeEntity request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetCompositeEntitySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetCompositeEntityResponder handles the response to the GetCompositeEntity request. The method always
// closes the http.Response Body.
func (client ModelClient) GetCompositeEntityResponder(resp *http.Response) (result CompositeEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetCompositeEntityRole sends the get composite entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// cEntityID - the composite entity extractor ID.
// roleID - entity role ID.
func (client ModelClient) GetCompositeEntityRole(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID, roleID uuid.UUID) (result EntityRole, err error) {
	req, err := client.GetCompositeEntityRolePreparer(ctx, appID, versionID, cEntityID, roleID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetCompositeEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetCompositeEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetCompositeEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.GetCompositeEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetCompositeEntityRole", resp, "Failure responding to request")
		return
	}

	return
}

// GetCompositeEntityRolePreparer prepares the GetCompositeEntityRole request.
func (client ModelClient) GetCompositeEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID, roleID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"cEntityId": autorest.Encode("path", cEntityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/compositeentities/{cEntityId}/roles/{roleId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetCompositeEntityRoleSender sends the GetCompositeEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetCompositeEntityRoleSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetCompositeEntityRoleResponder handles the response to the GetCompositeEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) GetCompositeEntityRoleResponder(resp *http.Response) (result EntityRole, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetCompositeEntityRoles sends the get composite entity roles request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// cEntityID - the composite entity extractor ID.
func (client ModelClient) GetCompositeEntityRoles(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID) (result ListEntityRole, err error) {
	req, err := client.GetCompositeEntityRolesPreparer(ctx, appID, versionID, cEntityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetCompositeEntityRoles", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetCompositeEntityRolesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetCompositeEntityRoles", resp, "Failure sending request")
		return
	}

	result, err = client.GetCompositeEntityRolesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetCompositeEntityRoles", resp, "Failure responding to request")
		return
	}

	return
}

// GetCompositeEntityRolesPreparer prepares the GetCompositeEntityRoles request.
func (client ModelClient) GetCompositeEntityRolesPreparer(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"cEntityId": autorest.Encode("path", cEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/compositeentities/{cEntityId}/roles", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetCompositeEntityRolesSender sends the GetCompositeEntityRoles request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetCompositeEntityRolesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetCompositeEntityRolesResponder handles the response to the GetCompositeEntityRoles request. The method always
// closes the http.Response Body.
func (client ModelClient) GetCompositeEntityRolesResponder(resp *http.Response) (result ListEntityRole, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetCustomEntityRole sends the get custom entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - entity ID.
// roleID - entity role ID.
func (client ModelClient) GetCustomEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (result EntityRole, err error) {
	req, err := client.GetCustomEntityRolePreparer(ctx, appID, versionID, entityID, roleID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetCustomEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetCustomEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetCustomEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.GetCustomEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetCustomEntityRole", resp, "Failure responding to request")
		return
	}

	return
}

// GetCustomEntityRolePreparer prepares the GetCustomEntityRole request.
func (client ModelClient) GetCustomEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/customprebuiltentities/{entityId}/roles/{roleId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetCustomEntityRoleSender sends the GetCustomEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetCustomEntityRoleSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetCustomEntityRoleResponder handles the response to the GetCustomEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) GetCustomEntityRoleResponder(resp *http.Response) (result EntityRole, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetCustomPrebuiltEntityRoles sends the get custom prebuilt entity roles request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - entity Id
func (client ModelClient) GetCustomPrebuiltEntityRoles(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (result ListEntityRole, err error) {
	req, err := client.GetCustomPrebuiltEntityRolesPreparer(ctx, appID, versionID, entityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetCustomPrebuiltEntityRoles", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetCustomPrebuiltEntityRolesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetCustomPrebuiltEntityRoles", resp, "Failure sending request")
		return
	}

	result, err = client.GetCustomPrebuiltEntityRolesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetCustomPrebuiltEntityRoles", resp, "Failure responding to request")
		return
	}

	return
}

// GetCustomPrebuiltEntityRolesPreparer prepares the GetCustomPrebuiltEntityRoles request.
func (client ModelClient) GetCustomPrebuiltEntityRolesPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/customprebuiltentities/{entityId}/roles", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetCustomPrebuiltEntityRolesSender sends the GetCustomPrebuiltEntityRoles request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetCustomPrebuiltEntityRolesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetCustomPrebuiltEntityRolesResponder handles the response to the GetCustomPrebuiltEntityRoles request. The method always
// closes the http.Response Body.
func (client ModelClient) GetCustomPrebuiltEntityRolesResponder(resp *http.Response) (result ListEntityRole, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetEntity gets information about the entity model.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity extractor ID.
func (client ModelClient) GetEntity(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (result EntityExtractor, err error) {
	req, err := client.GetEntityPreparer(ctx, appID, versionID, entityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetEntitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetEntity", resp, "Failure sending request")
		return
	}

	result, err = client.GetEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetEntity", resp, "Failure responding to request")
		return
	}

	return
}

// GetEntityPreparer prepares the GetEntity request.
func (client ModelClient) GetEntityPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/entities/{entityId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetEntitySender sends the GetEntity request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetEntitySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetEntityResponder handles the response to the GetEntity request. The method always
// closes the http.Response Body.
func (client ModelClient) GetEntityResponder(resp *http.Response) (result EntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetEntityRole sends the get entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - entity ID.
// roleID - entity role ID.
func (client ModelClient) GetEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (result EntityRole, err error) {
	req, err := client.GetEntityRolePreparer(ctx, appID, versionID, entityID, roleID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.GetEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetEntityRole", resp, "Failure responding to request")
		return
	}

	return
}

// GetEntityRolePreparer prepares the GetEntityRole request.
func (client ModelClient) GetEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/entities/{entityId}/roles/{roleId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetEntityRoleSender sends the GetEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetEntityRoleSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetEntityRoleResponder handles the response to the GetEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) GetEntityRoleResponder(resp *http.Response) (result EntityRole, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetEntityRoles sends the get entity roles request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - entity Id
func (client ModelClient) GetEntityRoles(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (result ListEntityRole, err error) {
	req, err := client.GetEntityRolesPreparer(ctx, appID, versionID, entityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetEntityRoles", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetEntityRolesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetEntityRoles", resp, "Failure sending request")
		return
	}

	result, err = client.GetEntityRolesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetEntityRoles", resp, "Failure responding to request")
		return
	}

	return
}

// GetEntityRolesPreparer prepares the GetEntityRoles request.
func (client ModelClient) GetEntityRolesPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/entities/{entityId}/roles", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetEntityRolesSender sends the GetEntityRoles request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetEntityRolesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetEntityRolesResponder handles the response to the GetEntityRoles request. The method always
// closes the http.Response Body.
func (client ModelClient) GetEntityRolesResponder(resp *http.Response) (result ListEntityRole, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetEntitySuggestions get suggestion examples that would improve the accuracy of the entity model.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the target entity extractor model to enhance.
// take - the number of entries to return. Maximum page size is 500. Default is 100.
func (client ModelClient) GetEntitySuggestions(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, take *int32) (result ListEntitiesSuggestionExample, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: take,
			Constraints: []validation.Constraint{{Target: "take", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "take", Name: validation.InclusiveMaximum, Rule: 500, Chain: nil},
					{Target: "take", Name: validation.InclusiveMinimum, Rule: 0, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("programmatic.ModelClient", "GetEntitySuggestions", err.Error())
	}

	req, err := client.GetEntitySuggestionsPreparer(ctx, appID, versionID, entityID, take)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetEntitySuggestions", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetEntitySuggestionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetEntitySuggestions", resp, "Failure sending request")
		return
	}

	result, err = client.GetEntitySuggestionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetEntitySuggestions", resp, "Failure responding to request")
		return
	}

	return
}

// GetEntitySuggestionsPreparer prepares the GetEntitySuggestions request.
func (client ModelClient) GetEntitySuggestionsPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, take *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	queryParameters := map[string]interface{}{}
	if take != nil {
		queryParameters["take"] = autorest.Encode("query", *take)
	} else {
		queryParameters["take"] = autorest.Encode("query", 100)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/entities/{entityId}/suggest", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetEntitySuggestionsSender sends the GetEntitySuggestions request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetEntitySuggestionsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetEntitySuggestionsResponder handles the response to the GetEntitySuggestions request. The method always
// closes the http.Response Body.
func (client ModelClient) GetEntitySuggestionsResponder(resp *http.Response) (result ListEntitiesSuggestionExample, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetExplicitList sends the get explicit list request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the Pattern.Any entity id.
func (client ModelClient) GetExplicitList(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (result ListExplicitListItem, err error) {
	req, err := client.GetExplicitListPreparer(ctx, appID, versionID, entityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetExplicitList", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetExplicitListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetExplicitList", resp, "Failure sending request")
		return
	}

	result, err = client.GetExplicitListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetExplicitList", resp, "Failure responding to request")
		return
	}

	return
}

// GetExplicitListPreparer prepares the GetExplicitList request.
func (client ModelClient) GetExplicitListPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}/explicitlist", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetExplicitListSender sends the GetExplicitList request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetExplicitListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetExplicitListResponder handles the response to the GetExplicitList request. The method always
// closes the http.Response Body.
func (client ModelClient) GetExplicitListResponder(resp *http.Response) (result ListExplicitListItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetExplicitListItem sends the get explicit list item request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the Pattern.Any entity Id.
// itemID - the explicit list item Id.
func (client ModelClient) GetExplicitListItem(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, itemID int64) (result ExplicitListItem, err error) {
	req, err := client.GetExplicitListItemPreparer(ctx, appID, versionID, entityID, itemID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetExplicitListItem", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetExplicitListItemSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetExplicitListItem", resp, "Failure sending request")
		return
	}

	result, err = client.GetExplicitListItemResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetExplicitListItem", resp, "Failure responding to request")
		return
	}

	return
}

// GetExplicitListItemPreparer prepares the GetExplicitListItem request.
func (client ModelClient) GetExplicitListItemPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, itemID int64) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"itemId":    autorest.Encode("path", itemID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}/explicitlist/{itemId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetExplicitListItemSender sends the GetExplicitListItem request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetExplicitListItemSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetExplicitListItemResponder handles the response to the GetExplicitListItem request. The method always
// closes the http.Response Body.
func (client ModelClient) GetExplicitListItemResponder(resp *http.Response) (result ExplicitListItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHierarchicalEntity gets information about the hierarchical entity model.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// hEntityID - the hierarchical entity extractor ID.
func (client ModelClient) GetHierarchicalEntity(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID) (result HierarchicalEntityExtractor, err error) {
	req, err := client.GetHierarchicalEntityPreparer(ctx, appID, versionID, hEntityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetHierarchicalEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHierarchicalEntitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetHierarchicalEntity", resp, "Failure sending request")
		return
	}

	result, err = client.GetHierarchicalEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetHierarchicalEntity", resp, "Failure responding to request")
		return
	}

	return
}

// GetHierarchicalEntityPreparer prepares the GetHierarchicalEntity request.
func (client ModelClient) GetHierarchicalEntityPreparer(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"hEntityId": autorest.Encode("path", hEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetHierarchicalEntitySender sends the GetHierarchicalEntity request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetHierarchicalEntitySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetHierarchicalEntityResponder handles the response to the GetHierarchicalEntity request. The method always
// closes the http.Response Body.
func (client ModelClient) GetHierarchicalEntityResponder(resp *http.Response) (result HierarchicalEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHierarchicalEntityChild gets information about the hierarchical entity child model.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// hEntityID - the hierarchical entity extractor ID.
// hChildID - the hierarchical entity extractor child ID.
func (client ModelClient) GetHierarchicalEntityChild(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, hChildID uuid.UUID) (result HierarchicalChildEntity, err error) {
	req, err := client.GetHierarchicalEntityChildPreparer(ctx, appID, versionID, hEntityID, hChildID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetHierarchicalEntityChild", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHierarchicalEntityChildSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetHierarchicalEntityChild", resp, "Failure sending request")
		return
	}

	result, err = client.GetHierarchicalEntityChildResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetHierarchicalEntityChild", resp, "Failure responding to request")
		return
	}

	return
}

// GetHierarchicalEntityChildPreparer prepares the GetHierarchicalEntityChild request.
func (client ModelClient) GetHierarchicalEntityChildPreparer(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, hChildID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"hChildId":  autorest.Encode("path", hChildID),
		"hEntityId": autorest.Encode("path", hEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}/children/{hChildId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetHierarchicalEntityChildSender sends the GetHierarchicalEntityChild request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetHierarchicalEntityChildSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetHierarchicalEntityChildResponder handles the response to the GetHierarchicalEntityChild request. The method always
// closes the http.Response Body.
func (client ModelClient) GetHierarchicalEntityChildResponder(resp *http.Response) (result HierarchicalChildEntity, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHierarchicalEntityRole sends the get hierarchical entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// hEntityID - the hierarchical entity extractor ID.
// roleID - entity role ID.
func (client ModelClient) GetHierarchicalEntityRole(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, roleID uuid.UUID) (result EntityRole, err error) {
	req, err := client.GetHierarchicalEntityRolePreparer(ctx, appID, versionID, hEntityID, roleID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetHierarchicalEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHierarchicalEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetHierarchicalEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.GetHierarchicalEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetHierarchicalEntityRole", resp, "Failure responding to request")
		return
	}

	return
}

// GetHierarchicalEntityRolePreparer prepares the GetHierarchicalEntityRole request.
func (client ModelClient) GetHierarchicalEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, roleID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"hEntityId": autorest.Encode("path", hEntityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}/roles/{roleId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetHierarchicalEntityRoleSender sends the GetHierarchicalEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetHierarchicalEntityRoleSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetHierarchicalEntityRoleResponder handles the response to the GetHierarchicalEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) GetHierarchicalEntityRoleResponder(resp *http.Response) (result EntityRole, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHierarchicalEntityRoles sends the get hierarchical entity roles request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// hEntityID - the hierarchical entity extractor ID.
func (client ModelClient) GetHierarchicalEntityRoles(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID) (result ListEntityRole, err error) {
	req, err := client.GetHierarchicalEntityRolesPreparer(ctx, appID, versionID, hEntityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetHierarchicalEntityRoles", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHierarchicalEntityRolesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetHierarchicalEntityRoles", resp, "Failure sending request")
		return
	}

	result, err = client.GetHierarchicalEntityRolesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetHierarchicalEntityRoles", resp, "Failure responding to request")
		return
	}

	return
}

// GetHierarchicalEntityRolesPreparer prepares the GetHierarchicalEntityRoles request.
func (client ModelClient) GetHierarchicalEntityRolesPreparer(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"hEntityId": autorest.Encode("path", hEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}/roles", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetHierarchicalEntityRolesSender sends the GetHierarchicalEntityRoles request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetHierarchicalEntityRolesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetHierarchicalEntityRolesResponder handles the response to the GetHierarchicalEntityRoles request. The method always
// closes the http.Response Body.
func (client ModelClient) GetHierarchicalEntityRolesResponder(resp *http.Response) (result ListEntityRole, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetIntent gets information about the intent model.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// intentID - the intent classifier ID.
func (client ModelClient) GetIntent(ctx context.Context, appID uuid.UUID, versionID string, intentID uuid.UUID) (result IntentClassifier, err error) {
	req, err := client.GetIntentPreparer(ctx, appID, versionID, intentID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetIntent", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetIntentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetIntent", resp, "Failure sending request")
		return
	}

	result, err = client.GetIntentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetIntent", resp, "Failure responding to request")
		return
	}

	return
}

// GetIntentPreparer prepares the GetIntent request.
func (client ModelClient) GetIntentPreparer(ctx context.Context, appID uuid.UUID, versionID string, intentID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"intentId":  autorest.Encode("path", intentID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/intents/{intentId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetIntentSender sends the GetIntent request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetIntentSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetIntentResponder handles the response to the GetIntent request. The method always
// closes the http.Response Body.
func (client ModelClient) GetIntentResponder(resp *http.Response) (result IntentClassifier, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetIntentSuggestions suggests examples that would improve the accuracy of the intent model.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// intentID - the intent classifier ID.
// take - the number of entries to return. Maximum page size is 500. Default is 100.
func (client ModelClient) GetIntentSuggestions(ctx context.Context, appID uuid.UUID, versionID string, intentID uuid.UUID, take *int32) (result ListIntentsSuggestionExample, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: take,
			Constraints: []validation.Constraint{{Target: "take", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "take", Name: validation.InclusiveMaximum, Rule: 500, Chain: nil},
					{Target: "take", Name: validation.InclusiveMinimum, Rule: 0, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("programmatic.ModelClient", "GetIntentSuggestions", err.Error())
	}

	req, err := client.GetIntentSuggestionsPreparer(ctx, appID, versionID, intentID, take)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetIntentSuggestions", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetIntentSuggestionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetIntentSuggestions", resp, "Failure sending request")
		return
	}

	result, err = client.GetIntentSuggestionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetIntentSuggestions", resp, "Failure responding to request")
		return
	}

	return
}

// GetIntentSuggestionsPreparer prepares the GetIntentSuggestions request.
func (client ModelClient) GetIntentSuggestionsPreparer(ctx context.Context, appID uuid.UUID, versionID string, intentID uuid.UUID, take *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"intentId":  autorest.Encode("path", intentID),
		"versionId": autorest.Encode("path", versionID),
	}

	queryParameters := map[string]interface{}{}
	if take != nil {
		queryParameters["take"] = autorest.Encode("query", *take)
	} else {
		queryParameters["take"] = autorest.Encode("query", 100)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/intents/{intentId}/suggest", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetIntentSuggestionsSender sends the GetIntentSuggestions request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetIntentSuggestionsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetIntentSuggestionsResponder handles the response to the GetIntentSuggestions request. The method always
// closes the http.Response Body.
func (client ModelClient) GetIntentSuggestionsResponder(resp *http.Response) (result ListIntentsSuggestionExample, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetPatternAnyEntityInfo sends the get pattern any entity info request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity extractor ID.
func (client ModelClient) GetPatternAnyEntityInfo(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (result PatternAnyEntityExtractor, err error) {
	req, err := client.GetPatternAnyEntityInfoPreparer(ctx, appID, versionID, entityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetPatternAnyEntityInfo", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPatternAnyEntityInfoSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetPatternAnyEntityInfo", resp, "Failure sending request")
		return
	}

	result, err = client.GetPatternAnyEntityInfoResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetPatternAnyEntityInfo", resp, "Failure responding to request")
		return
	}

	return
}

// GetPatternAnyEntityInfoPreparer prepares the GetPatternAnyEntityInfo request.
func (client ModelClient) GetPatternAnyEntityInfoPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetPatternAnyEntityInfoSender sends the GetPatternAnyEntityInfo request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetPatternAnyEntityInfoSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetPatternAnyEntityInfoResponder handles the response to the GetPatternAnyEntityInfo request. The method always
// closes the http.Response Body.
func (client ModelClient) GetPatternAnyEntityInfoResponder(resp *http.Response) (result PatternAnyEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetPatternAnyEntityInfos sends the get pattern any entity infos request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// skip - the number of entries to skip. Default value is 0.
// take - the number of entries to return. Maximum page size is 500. Default is 100.
func (client ModelClient) GetPatternAnyEntityInfos(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (result ListPatternAnyEntityExtractor, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: skip,
			Constraints: []validation.Constraint{{Target: "skip", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "skip", Name: validation.InclusiveMinimum, Rule: 0, Chain: nil}}}}},
		{TargetValue: take,
			Constraints: []validation.Constraint{{Target: "take", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "take", Name: validation.InclusiveMaximum, Rule: 500, Chain: nil},
					{Target: "take", Name: validation.InclusiveMinimum, Rule: 0, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("programmatic.ModelClient", "GetPatternAnyEntityInfos", err.Error())
	}

	req, err := client.GetPatternAnyEntityInfosPreparer(ctx, appID, versionID, skip, take)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetPatternAnyEntityInfos", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPatternAnyEntityInfosSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetPatternAnyEntityInfos", resp, "Failure sending request")
		return
	}

	result, err = client.GetPatternAnyEntityInfosResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetPatternAnyEntityInfos", resp, "Failure responding to request")
		return
	}

	return
}

// GetPatternAnyEntityInfosPreparer prepares the GetPatternAnyEntityInfos request.
func (client ModelClient) GetPatternAnyEntityInfosPreparer(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	queryParameters := map[string]interface{}{}
	if skip != nil {
		queryParameters["skip"] = autorest.Encode("query", *skip)
	} else {
		queryParameters["skip"] = autorest.Encode("query", 0)
	}
	if take != nil {
		queryParameters["take"] = autorest.Encode("query", *take)
	} else {
		queryParameters["take"] = autorest.Encode("query", 100)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/patternanyentities", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetPatternAnyEntityInfosSender sends the GetPatternAnyEntityInfos request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetPatternAnyEntityInfosSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetPatternAnyEntityInfosResponder handles the response to the GetPatternAnyEntityInfos request. The method always
// closes the http.Response Body.
func (client ModelClient) GetPatternAnyEntityInfosResponder(resp *http.Response) (result ListPatternAnyEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetPatternAnyEntityRole sends the get pattern any entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - entity ID.
// roleID - entity role ID.
func (client ModelClient) GetPatternAnyEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (result EntityRole, err error) {
	req, err := client.GetPatternAnyEntityRolePreparer(ctx, appID, versionID, entityID, roleID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetPatternAnyEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPatternAnyEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetPatternAnyEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.GetPatternAnyEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetPatternAnyEntityRole", resp, "Failure responding to request")
		return
	}

	return
}

// GetPatternAnyEntityRolePreparer prepares the GetPatternAnyEntityRole request.
func (client ModelClient) GetPatternAnyEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}/roles/{roleId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetPatternAnyEntityRoleSender sends the GetPatternAnyEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetPatternAnyEntityRoleSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetPatternAnyEntityRoleResponder handles the response to the GetPatternAnyEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) GetPatternAnyEntityRoleResponder(resp *http.Response) (result EntityRole, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetPatternAnyEntityRoles sends the get pattern any entity roles request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - entity Id
func (client ModelClient) GetPatternAnyEntityRoles(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (result ListEntityRole, err error) {
	req, err := client.GetPatternAnyEntityRolesPreparer(ctx, appID, versionID, entityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetPatternAnyEntityRoles", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPatternAnyEntityRolesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetPatternAnyEntityRoles", resp, "Failure sending request")
		return
	}

	result, err = client.GetPatternAnyEntityRolesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetPatternAnyEntityRoles", resp, "Failure responding to request")
		return
	}

	return
}

// GetPatternAnyEntityRolesPreparer prepares the GetPatternAnyEntityRoles request.
func (client ModelClient) GetPatternAnyEntityRolesPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}/roles", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetPatternAnyEntityRolesSender sends the GetPatternAnyEntityRoles request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetPatternAnyEntityRolesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetPatternAnyEntityRolesResponder handles the response to the GetPatternAnyEntityRoles request. The method always
// closes the http.Response Body.
func (client ModelClient) GetPatternAnyEntityRolesResponder(resp *http.Response) (result ListEntityRole, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetPrebuilt gets information about the prebuilt entity model.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// prebuiltID - the prebuilt entity extractor ID.
func (client ModelClient) GetPrebuilt(ctx context.Context, appID uuid.UUID, versionID string, prebuiltID uuid.UUID) (result PrebuiltEntityExtractor, err error) {
	req, err := client.GetPrebuiltPreparer(ctx, appID, versionID, prebuiltID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetPrebuilt", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPrebuiltSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetPrebuilt", resp, "Failure sending request")
		return
	}

	result, err = client.GetPrebuiltResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetPrebuilt", resp, "Failure responding to request")
		return
	}

	return
}

// GetPrebuiltPreparer prepares the GetPrebuilt request.
func (client ModelClient) GetPrebuiltPreparer(ctx context.Context, appID uuid.UUID, versionID string, prebuiltID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":      autorest.Encode("path", appID),
		"prebuiltId": autorest.Encode("path", prebuiltID),
		"versionId":  autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/prebuilts/{prebuiltId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetPrebuiltSender sends the GetPrebuilt request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetPrebuiltSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetPrebuiltResponder handles the response to the GetPrebuilt request. The method always
// closes the http.Response Body.
func (client ModelClient) GetPrebuiltResponder(resp *http.Response) (result PrebuiltEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetPrebuiltEntityRole sends the get prebuilt entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - entity ID.
// roleID - entity role ID.
func (client ModelClient) GetPrebuiltEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (result EntityRole, err error) {
	req, err := client.GetPrebuiltEntityRolePreparer(ctx, appID, versionID, entityID, roleID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetPrebuiltEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPrebuiltEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetPrebuiltEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.GetPrebuiltEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetPrebuiltEntityRole", resp, "Failure responding to request")
		return
	}

	return
}

// GetPrebuiltEntityRolePreparer prepares the GetPrebuiltEntityRole request.
func (client ModelClient) GetPrebuiltEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/prebuilts/{entityId}/roles/{roleId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetPrebuiltEntityRoleSender sends the GetPrebuiltEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetPrebuiltEntityRoleSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetPrebuiltEntityRoleResponder handles the response to the GetPrebuiltEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) GetPrebuiltEntityRoleResponder(resp *http.Response) (result EntityRole, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetPrebuiltEntityRoles sends the get prebuilt entity roles request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - entity Id
func (client ModelClient) GetPrebuiltEntityRoles(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (result ListEntityRole, err error) {
	req, err := client.GetPrebuiltEntityRolesPreparer(ctx, appID, versionID, entityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetPrebuiltEntityRoles", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPrebuiltEntityRolesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetPrebuiltEntityRoles", resp, "Failure sending request")
		return
	}

	result, err = client.GetPrebuiltEntityRolesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetPrebuiltEntityRoles", resp, "Failure responding to request")
		return
	}

	return
}

// GetPrebuiltEntityRolesPreparer prepares the GetPrebuiltEntityRoles request.
func (client ModelClient) GetPrebuiltEntityRolesPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/prebuilts/{entityId}/roles", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetPrebuiltEntityRolesSender sends the GetPrebuiltEntityRoles request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetPrebuiltEntityRolesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetPrebuiltEntityRolesResponder handles the response to the GetPrebuiltEntityRoles request. The method always
// closes the http.Response Body.
func (client ModelClient) GetPrebuiltEntityRolesResponder(resp *http.Response) (result ListEntityRole, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetRegexEntityEntityInfo sends the get regex entity entity info request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// regexEntityID - the regex entity model ID.
func (client ModelClient) GetRegexEntityEntityInfo(ctx context.Context, appID uuid.UUID, versionID string, regexEntityID uuid.UUID) (result RegexEntityExtractor, err error) {
	req, err := client.GetRegexEntityEntityInfoPreparer(ctx, appID, versionID, regexEntityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetRegexEntityEntityInfo", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetRegexEntityEntityInfoSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetRegexEntityEntityInfo", resp, "Failure sending request")
		return
	}

	result, err = client.GetRegexEntityEntityInfoResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetRegexEntityEntityInfo", resp, "Failure responding to request")
		return
	}

	return
}

// GetRegexEntityEntityInfoPreparer prepares the GetRegexEntityEntityInfo request.
func (client ModelClient) GetRegexEntityEntityInfoPreparer(ctx context.Context, appID uuid.UUID, versionID string, regexEntityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":         autorest.Encode("path", appID),
		"regexEntityId": autorest.Encode("path", regexEntityID),
		"versionId":     autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/regexentities/{regexEntityId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetRegexEntityEntityInfoSender sends the GetRegexEntityEntityInfo request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetRegexEntityEntityInfoSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetRegexEntityEntityInfoResponder handles the response to the GetRegexEntityEntityInfo request. The method always
// closes the http.Response Body.
func (client ModelClient) GetRegexEntityEntityInfoResponder(resp *http.Response) (result RegexEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetRegexEntityInfos sends the get regex entity infos request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// skip - the number of entries to skip. Default value is 0.
// take - the number of entries to return. Maximum page size is 500. Default is 100.
func (client ModelClient) GetRegexEntityInfos(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (result ListRegexEntityExtractor, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: skip,
			Constraints: []validation.Constraint{{Target: "skip", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "skip", Name: validation.InclusiveMinimum, Rule: 0, Chain: nil}}}}},
		{TargetValue: take,
			Constraints: []validation.Constraint{{Target: "take", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "take", Name: validation.InclusiveMaximum, Rule: 500, Chain: nil},
					{Target: "take", Name: validation.InclusiveMinimum, Rule: 0, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("programmatic.ModelClient", "GetRegexEntityInfos", err.Error())
	}

	req, err := client.GetRegexEntityInfosPreparer(ctx, appID, versionID, skip, take)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetRegexEntityInfos", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetRegexEntityInfosSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetRegexEntityInfos", resp, "Failure sending request")
		return
	}

	result, err = client.GetRegexEntityInfosResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetRegexEntityInfos", resp, "Failure responding to request")
		return
	}

	return
}

// GetRegexEntityInfosPreparer prepares the GetRegexEntityInfos request.
func (client ModelClient) GetRegexEntityInfosPreparer(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	queryParameters := map[string]interface{}{}
	if skip != nil {
		queryParameters["skip"] = autorest.Encode("query", *skip)
	} else {
		queryParameters["skip"] = autorest.Encode("query", 0)
	}
	if take != nil {
		queryParameters["take"] = autorest.Encode("query", *take)
	} else {
		queryParameters["take"] = autorest.Encode("query", 100)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/regexentities", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetRegexEntityInfosSender sends the GetRegexEntityInfos request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetRegexEntityInfosSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetRegexEntityInfosResponder handles the response to the GetRegexEntityInfos request. The method always
// closes the http.Response Body.
func (client ModelClient) GetRegexEntityInfosResponder(resp *http.Response) (result ListRegexEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetRegexEntityRole sends the get regex entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - entity ID.
// roleID - entity role ID.
func (client ModelClient) GetRegexEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (result EntityRole, err error) {
	req, err := client.GetRegexEntityRolePreparer(ctx, appID, versionID, entityID, roleID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetRegexEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetRegexEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetRegexEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.GetRegexEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetRegexEntityRole", resp, "Failure responding to request")
		return
	}

	return
}

// GetRegexEntityRolePreparer prepares the GetRegexEntityRole request.
func (client ModelClient) GetRegexEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/regexentities/{entityId}/roles/{roleId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetRegexEntityRoleSender sends the GetRegexEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetRegexEntityRoleSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetRegexEntityRoleResponder handles the response to the GetRegexEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) GetRegexEntityRoleResponder(resp *http.Response) (result EntityRole, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetRegexEntityRoles sends the get regex entity roles request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - entity Id
func (client ModelClient) GetRegexEntityRoles(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (result ListEntityRole, err error) {
	req, err := client.GetRegexEntityRolesPreparer(ctx, appID, versionID, entityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetRegexEntityRoles", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetRegexEntityRolesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetRegexEntityRoles", resp, "Failure sending request")
		return
	}

	result, err = client.GetRegexEntityRolesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetRegexEntityRoles", resp, "Failure responding to request")
		return
	}

	return
}

// GetRegexEntityRolesPreparer prepares the GetRegexEntityRoles request.
func (client ModelClient) GetRegexEntityRolesPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/regexentities/{entityId}/roles", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetRegexEntityRolesSender sends the GetRegexEntityRoles request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetRegexEntityRolesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetRegexEntityRolesResponder handles the response to the GetRegexEntityRoles request. The method always
// closes the http.Response Body.
func (client ModelClient) GetRegexEntityRolesResponder(resp *http.Response) (result ListEntityRole, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListClosedLists gets information about the closedlist models.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// skip - the number of entries to skip. Default value is 0.
// take - the number of entries to return. Maximum page size is 500. Default is 100.
func (client ModelClient) ListClosedLists(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (result ListClosedListEntityExtractor, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: skip,
			Constraints: []validation.Constraint{{Target: "skip", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "skip", Name: validation.InclusiveMinimum, Rule: 0, Chain: nil}}}}},
		{TargetValue: take,
			Constraints: []validation.Constraint{{Target: "take", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "take", Name: validation.InclusiveMaximum, Rule: 500, Chain: nil},
					{Target: "take", Name: validation.InclusiveMinimum, Rule: 0, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("programmatic.ModelClient", "ListClosedLists", err.Error())
	}

	req, err := client.ListClosedListsPreparer(ctx, appID, versionID, skip, take)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListClosedLists", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListClosedListsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListClosedLists", resp, "Failure sending request")
		return
	}

	result, err = client.ListClosedListsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListClosedLists", resp, "Failure responding to request")
		return
	}

	return
}

// ListClosedListsPreparer prepares the ListClosedLists request.
func (client ModelClient) ListClosedListsPreparer(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	queryParameters := map[string]interface{}{}
	if skip != nil {
		queryParameters["skip"] = autorest.Encode("query", *skip)
	} else {
		queryParameters["skip"] = autorest.Encode("query", 0)
	}
	if take != nil {
		queryParameters["take"] = autorest.Encode("query", *take)
	} else {
		queryParameters["take"] = autorest.Encode("query", 100)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/closedlists", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListClosedListsSender sends the ListClosedLists request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListClosedListsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListClosedListsResponder handles the response to the ListClosedLists request. The method always
// closes the http.Response Body.
func (client ModelClient) ListClosedListsResponder(resp *http.Response) (result ListClosedListEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListCompositeEntities gets information about the composite entity models.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// skip - the number of entries to skip. Default value is 0.
// take - the number of entries to return. Maximum page size is 500. Default is 100.
func (client ModelClient) ListCompositeEntities(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (result ListCompositeEntityExtractor, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: skip,
			Constraints: []validation.Constraint{{Target: "skip", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "skip", Name: validation.InclusiveMinimum, Rule: 0, Chain: nil}}}}},
		{TargetValue: take,
			Constraints: []validation.Constraint{{Target: "take", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "take", Name: validation.InclusiveMaximum, Rule: 500, Chain: nil},
					{Target: "take", Name: validation.InclusiveMinimum, Rule: 0, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("programmatic.ModelClient", "ListCompositeEntities", err.Error())
	}

	req, err := client.ListCompositeEntitiesPreparer(ctx, appID, versionID, skip, take)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListCompositeEntities", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListCompositeEntitiesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListCompositeEntities", resp, "Failure sending request")
		return
	}

	result, err = client.ListCompositeEntitiesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListCompositeEntities", resp, "Failure responding to request")
		return
	}

	return
}

// ListCompositeEntitiesPreparer prepares the ListCompositeEntities request.
func (client ModelClient) ListCompositeEntitiesPreparer(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	queryParameters := map[string]interface{}{}
	if skip != nil {
		queryParameters["skip"] = autorest.Encode("query", *skip)
	} else {
		queryParameters["skip"] = autorest.Encode("query", 0)
	}
	if take != nil {
		queryParameters["take"] = autorest.Encode("query", *take)
	} else {
		queryParameters["take"] = autorest.Encode("query", 100)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/compositeentities", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListCompositeEntitiesSender sends the ListCompositeEntities request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListCompositeEntitiesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListCompositeEntitiesResponder handles the response to the ListCompositeEntities request. The method always
// closes the http.Response Body.
func (client ModelClient) ListCompositeEntitiesResponder(resp *http.Response) (result ListCompositeEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListCustomPrebuiltEntities gets all custom prebuilt entities information of this application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
func (client ModelClient) ListCustomPrebuiltEntities(ctx context.Context, appID uuid.UUID, versionID string) (result ListEntityExtractor, err error) {
	req, err := client.ListCustomPrebuiltEntitiesPreparer(ctx, appID, versionID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListCustomPrebuiltEntities", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListCustomPrebuiltEntitiesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListCustomPrebuiltEntities", resp, "Failure sending request")
		return
	}

	result, err = client.ListCustomPrebuiltEntitiesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListCustomPrebuiltEntities", resp, "Failure responding to request")
		return
	}

	return
}

// ListCustomPrebuiltEntitiesPreparer prepares the ListCustomPrebuiltEntities request.
func (client ModelClient) ListCustomPrebuiltEntitiesPreparer(ctx context.Context, appID uuid.UUID, versionID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/customprebuiltentities", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListCustomPrebuiltEntitiesSender sends the ListCustomPrebuiltEntities request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListCustomPrebuiltEntitiesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListCustomPrebuiltEntitiesResponder handles the response to the ListCustomPrebuiltEntities request. The method always
// closes the http.Response Body.
func (client ModelClient) ListCustomPrebuiltEntitiesResponder(resp *http.Response) (result ListEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListCustomPrebuiltIntents gets custom prebuilt intents information of this application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
func (client ModelClient) ListCustomPrebuiltIntents(ctx context.Context, appID uuid.UUID, versionID string) (result ListIntentClassifier, err error) {
	req, err := client.ListCustomPrebuiltIntentsPreparer(ctx, appID, versionID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListCustomPrebuiltIntents", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListCustomPrebuiltIntentsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListCustomPrebuiltIntents", resp, "Failure sending request")
		return
	}

	result, err = client.ListCustomPrebuiltIntentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListCustomPrebuiltIntents", resp, "Failure responding to request")
		return
	}

	return
}

// ListCustomPrebuiltIntentsPreparer prepares the ListCustomPrebuiltIntents request.
func (client ModelClient) ListCustomPrebuiltIntentsPreparer(ctx context.Context, appID uuid.UUID, versionID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/customprebuiltintents", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListCustomPrebuiltIntentsSender sends the ListCustomPrebuiltIntents request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListCustomPrebuiltIntentsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListCustomPrebuiltIntentsResponder handles the response to the ListCustomPrebuiltIntents request. The method always
// closes the http.Response Body.
func (client ModelClient) ListCustomPrebuiltIntentsResponder(resp *http.Response) (result ListIntentClassifier, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListCustomPrebuiltModels gets all custom prebuilt models information of this application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
func (client ModelClient) ListCustomPrebuiltModels(ctx context.Context, appID uuid.UUID, versionID string) (result ListCustomPrebuiltModel, err error) {
	req, err := client.ListCustomPrebuiltModelsPreparer(ctx, appID, versionID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListCustomPrebuiltModels", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListCustomPrebuiltModelsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListCustomPrebuiltModels", resp, "Failure sending request")
		return
	}

	result, err = client.ListCustomPrebuiltModelsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListCustomPrebuiltModels", resp, "Failure responding to request")
		return
	}

	return
}

// ListCustomPrebuiltModelsPreparer prepares the ListCustomPrebuiltModels request.
func (client ModelClient) ListCustomPrebuiltModelsPreparer(ctx context.Context, appID uuid.UUID, versionID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/customprebuiltmodels", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListCustomPrebuiltModelsSender sends the ListCustomPrebuiltModels request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListCustomPrebuiltModelsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListCustomPrebuiltModelsResponder handles the response to the ListCustomPrebuiltModels request. The method always
// closes the http.Response Body.
func (client ModelClient) ListCustomPrebuiltModelsResponder(resp *http.Response) (result ListCustomPrebuiltModel, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListEntities gets information about the entity models.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// skip - the number of entries to skip. Default value is 0.
// take - the number of entries to return. Maximum page size is 500. Default is 100.
func (client ModelClient) ListEntities(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (result ListEntityExtractor, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: skip,
			Constraints: []validation.Constraint{{Target: "skip", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "skip", Name: validation.InclusiveMinimum, Rule: 0, Chain: nil}}}}},
		{TargetValue: take,
			Constraints: []validation.Constraint{{Target: "take", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "take", Name: validation.InclusiveMaximum, Rule: 500, Chain: nil},
					{Target: "take", Name: validation.InclusiveMinimum, Rule: 0, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("programmatic.ModelClient", "ListEntities", err.Error())
	}

	req, err := client.ListEntitiesPreparer(ctx, appID, versionID, skip, take)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListEntities", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListEntitiesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListEntities", resp, "Failure sending request")
		return
	}

	result, err = client.ListEntitiesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListEntities", resp, "Failure responding to request")
		return
	}

	return
}

// ListEntitiesPreparer prepares the ListEntities request.
func (client ModelClient) ListEntitiesPreparer(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	queryParameters := map[string]interface{}{}
	if skip != nil {
		queryParameters["skip"] = autorest.Encode("query", *skip)
	} else {
		queryParameters["skip"] = autorest.Encode("query", 0)
	}
	if take != nil {
		queryParameters["take"] = autorest.Encode("query", *take)
	} else {
		queryParameters["take"] = autorest.Encode("query", 100)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/entities", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListEntitiesSender sends the ListEntities request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListEntitiesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListEntitiesResponder handles the response to the ListEntities request. The method always
// closes the http.Response Body.
func (client ModelClient) ListEntitiesResponder(resp *http.Response) (result ListEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListHierarchicalEntities gets information about the hierarchical entity models.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// skip - the number of entries to skip. Default value is 0.
// take - the number of entries to return. Maximum page size is 500. Default is 100.
func (client ModelClient) ListHierarchicalEntities(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (result ListHierarchicalEntityExtractor, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: skip,
			Constraints: []validation.Constraint{{Target: "skip", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "skip", Name: validation.InclusiveMinimum, Rule: 0, Chain: nil}}}}},
		{TargetValue: take,
			Constraints: []validation.Constraint{{Target: "take", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "take", Name: validation.InclusiveMaximum, Rule: 500, Chain: nil},
					{Target: "take", Name: validation.InclusiveMinimum, Rule: 0, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("programmatic.ModelClient", "ListHierarchicalEntities", err.Error())
	}

	req, err := client.ListHierarchicalEntitiesPreparer(ctx, appID, versionID, skip, take)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListHierarchicalEntities", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListHierarchicalEntitiesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListHierarchicalEntities", resp, "Failure sending request")
		return
	}

	result, err = client.ListHierarchicalEntitiesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListHierarchicalEntities", resp, "Failure responding to request")
		return
	}

	return
}

// ListHierarchicalEntitiesPreparer prepares the ListHierarchicalEntities request.
func (client ModelClient) ListHierarchicalEntitiesPreparer(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	queryParameters := map[string]interface{}{}
	if skip != nil {
		queryParameters["skip"] = autorest.Encode("query", *skip)
	} else {
		queryParameters["skip"] = autorest.Encode("query", 0)
	}
	if take != nil {
		queryParameters["take"] = autorest.Encode("query", *take)
	} else {
		queryParameters["take"] = autorest.Encode("query", 100)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/hierarchicalentities", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListHierarchicalEntitiesSender sends the ListHierarchicalEntities request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListHierarchicalEntitiesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListHierarchicalEntitiesResponder handles the response to the ListHierarchicalEntities request. The method always
// closes the http.Response Body.
func (client ModelClient) ListHierarchicalEntitiesResponder(resp *http.Response) (result ListHierarchicalEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListIntents gets information about the intent models.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// skip - the number of entries to skip. Default value is 0.
// take - the number of entries to return. Maximum page size is 500. Default is 100.
func (client ModelClient) ListIntents(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (result ListIntentClassifier, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: skip,
			Constraints: []validation.Constraint{{Target: "skip", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "skip", Name: validation.InclusiveMinimum, Rule: 0, Chain: nil}}}}},
		{TargetValue: take,
			Constraints: []validation.Constraint{{Target: "take", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "take", Name: validation.InclusiveMaximum, Rule: 500, Chain: nil},
					{Target: "take", Name: validation.InclusiveMinimum, Rule: 0, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("programmatic.ModelClient", "ListIntents", err.Error())
	}

	req, err := client.ListIntentsPreparer(ctx, appID, versionID, skip, take)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListIntents", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListIntentsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListIntents", resp, "Failure sending request")
		return
	}

	result, err = client.ListIntentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListIntents", resp, "Failure responding to request")
		return
	}

	return
}

// ListIntentsPreparer prepares the ListIntents request.
func (client ModelClient) ListIntentsPreparer(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	queryParameters := map[string]interface{}{}
	if skip != nil {
		queryParameters["skip"] = autorest.Encode("query", *skip)
	} else {
		queryParameters["skip"] = autorest.Encode("query", 0)
	}
	if take != nil {
		queryParameters["take"] = autorest.Encode("query", *take)
	} else {
		queryParameters["take"] = autorest.Encode("query", 100)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/intents", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListIntentsSender sends the ListIntents request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListIntentsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListIntentsResponder handles the response to the ListIntents request. The method always
// closes the http.Response Body.
func (client ModelClient) ListIntentsResponder(resp *http.Response) (result ListIntentClassifier, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListModels gets information about the application version models.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// skip - the number of entries to skip. Default value is 0.
// take - the number of entries to return. Maximum page size is 500. Default is 100.
func (client ModelClient) ListModels(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (result ListModelInfoResponse, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: skip,
			Constraints: []validation.Constraint{{Target: "skip", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "skip", Name: validation.InclusiveMinimum, Rule: 0, Chain: nil}}}}},
		{TargetValue: take,
			Constraints: []validation.Constraint{{Target: "take", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "take", Name: validation.InclusiveMaximum, Rule: 500, Chain: nil},
					{Target: "take", Name: validation.InclusiveMinimum, Rule: 0, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("programmatic.ModelClient", "ListModels", err.Error())
	}

	req, err := client.ListModelsPreparer(ctx, appID, versionID, skip, take)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListModels", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListModelsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListModels", resp, "Failure sending request")
		return
	}

	result, err = client.ListModelsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListModels", resp, "Failure responding to request")
		return
	}

	return
}

// ListModelsPreparer prepares the ListModels request.
func (client ModelClient) ListModelsPreparer(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	queryParameters := map[string]interface{}{}
	if skip != nil {
		queryParameters["skip"] = autorest.Encode("query", *skip)
	} else {
		queryParameters["skip"] = autorest.Encode("query", 0)
	}
	if take != nil {
		queryParameters["take"] = autorest.Encode("query", *take)
	} else {
		queryParameters["take"] = autorest.Encode("query", 100)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/models", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListModelsSender sends the ListModels request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListModelsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListModelsResponder handles the response to the ListModels request. The method always
// closes the http.Response Body.
func (client ModelClient) ListModelsResponder(resp *http.Response) (result ListModelInfoResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListPrebuiltEntities gets all the available prebuilt entity extractors for the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
func (client ModelClient) ListPrebuiltEntities(ctx context.Context, appID uuid.UUID, versionID string) (result ListAvailablePrebuiltEntityModel, err error) {
	req, err := client.ListPrebuiltEntitiesPreparer(ctx, appID, versionID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListPrebuiltEntities", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListPrebuiltEntitiesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListPrebuiltEntities", resp, "Failure sending request")
		return
	}

	result, err = client.ListPrebuiltEntitiesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListPrebuiltEntities", resp, "Failure responding to request")
		return
	}

	return
}

// ListPrebuiltEntitiesPreparer prepares the ListPrebuiltEntities request.
func (client ModelClient) ListPrebuiltEntitiesPreparer(ctx context.Context, appID uuid.UUID, versionID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/listprebuilts", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListPrebuiltEntitiesSender sends the ListPrebuiltEntities request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListPrebuiltEntitiesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListPrebuiltEntitiesResponder handles the response to the ListPrebuiltEntities request. The method always
// closes the http.Response Body.
func (client ModelClient) ListPrebuiltEntitiesResponder(resp *http.Response) (result ListAvailablePrebuiltEntityModel, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListPrebuilts gets information about the prebuilt entity models.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// skip - the number of entries to skip. Default value is 0.
// take - the number of entries to return. Maximum page size is 500. Default is 100.
func (client ModelClient) ListPrebuilts(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (result ListPrebuiltEntityExtractor, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: skip,
			Constraints: []validation.Constraint{{Target: "skip", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "skip", Name: validation.InclusiveMinimum, Rule: 0, Chain: nil}}}}},
		{TargetValue: take,
			Constraints: []validation.Constraint{{Target: "take", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "take", Name: validation.InclusiveMaximum, Rule: 500, Chain: nil},
					{Target: "take", Name: validation.InclusiveMinimum, Rule: 0, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("programmatic.ModelClient", "ListPrebuilts", err.Error())
	}

	req, err := client.ListPrebuiltsPreparer(ctx, appID, versionID, skip, take)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListPrebuilts", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListPrebuiltsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListPrebuilts", resp, "Failure sending request")
		return
	}

	result, err = client.ListPrebuiltsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListPrebuilts", resp, "Failure responding to request")
		return
	}

	return
}

// ListPrebuiltsPreparer prepares the ListPrebuilts request.
func (client ModelClient) ListPrebuiltsPreparer(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	queryParameters := map[string]interface{}{}
	if skip != nil {
		queryParameters["skip"] = autorest.Encode("query", *skip)
	} else {
		queryParameters["skip"] = autorest.Encode("query", 0)
	}
	if take != nil {
		queryParameters["take"] = autorest.Encode("query", *take)
	} else {
		queryParameters["take"] = autorest.Encode("query", 100)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/prebuilts", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListPrebuiltsSender sends the ListPrebuilts request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListPrebuiltsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListPrebuiltsResponder handles the response to the ListPrebuilts request. The method always
// closes the http.Response Body.
func (client ModelClient) ListPrebuiltsResponder(resp *http.Response) (result ListPrebuiltEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// PatchClosedList adds a batch of sublists to an existing closedlist.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// clEntityID - the closed list model ID.
// closedListModelPatchObject - a words list batch.
func (client ModelClient) PatchClosedList(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID, closedListModelPatchObject ClosedListModelPatchObject) (result OperationStatus, err error) {
	req, err := client.PatchClosedListPreparer(ctx, appID, versionID, clEntityID, closedListModelPatchObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "PatchClosedList", nil, "Failure preparing request")
		return
	}

	resp, err := client.PatchClosedListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "PatchClosedList", resp, "Failure sending request")
		return
	}

	result, err = client.PatchClosedListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "PatchClosedList", resp, "Failure responding to request")
		return
	}

	return
}

// PatchClosedListPreparer prepares the PatchClosedList request.
func (client ModelClient) PatchClosedListPreparer(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID, closedListModelPatchObject ClosedListModelPatchObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":      autorest.Encode("path", appID),
		"clEntityId": autorest.Encode("path", clEntityID),
		"versionId":  autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/closedlists/{clEntityId}", pathParameters),
		autorest.WithJSON(closedListModelPatchObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// PatchClosedListSender sends the PatchClosedList request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) PatchClosedListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// PatchClosedListResponder handles the response to the PatchClosedList request. The method always
// closes the http.Response Body.
func (client ModelClient) PatchClosedListResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateClosedList updates the closed list model.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// clEntityID - the closed list model ID.
// closedListModelUpdateObject - the new entity name and words list.
func (client ModelClient) UpdateClosedList(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID, closedListModelUpdateObject ClosedListModelUpdateObject) (result OperationStatus, err error) {
	req, err := client.UpdateClosedListPreparer(ctx, appID, versionID, clEntityID, closedListModelUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateClosedList", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateClosedListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateClosedList", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateClosedListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateClosedList", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateClosedListPreparer prepares the UpdateClosedList request.
func (client ModelClient) UpdateClosedListPreparer(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID, closedListModelUpdateObject ClosedListModelUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":      autorest.Encode("path", appID),
		"clEntityId": autorest.Encode("path", clEntityID),
		"versionId":  autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/closedlists/{clEntityId}", pathParameters),
		autorest.WithJSON(closedListModelUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateClosedListSender sends the UpdateClosedList request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdateClosedListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateClosedListResponder handles the response to the UpdateClosedList request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdateClosedListResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateClosedListEntityRole sends the update closed list entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity ID.
// roleID - the entity role ID.
// entityRoleUpdateObject - the new entity role.
func (client ModelClient) UpdateClosedListEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID, entityRoleUpdateObject EntityRoleUpdateObject) (result OperationStatus, err error) {
	req, err := client.UpdateClosedListEntityRolePreparer(ctx, appID, versionID, entityID, roleID, entityRoleUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateClosedListEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateClosedListEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateClosedListEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateClosedListEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateClosedListEntityRole", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateClosedListEntityRolePreparer prepares the UpdateClosedListEntityRole request.
func (client ModelClient) UpdateClosedListEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID, entityRoleUpdateObject EntityRoleUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/closedlists/{entityId}/roles/{roleId}", pathParameters),
		autorest.WithJSON(entityRoleUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateClosedListEntityRoleSender sends the UpdateClosedListEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdateClosedListEntityRoleSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateClosedListEntityRoleResponder handles the response to the UpdateClosedListEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdateClosedListEntityRoleResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateCompositeEntity updates the composite entity extractor.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// cEntityID - the composite entity extractor ID.
// compositeModelUpdateObject - a model object containing the new entity extractor name and children.
func (client ModelClient) UpdateCompositeEntity(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID, compositeModelUpdateObject CompositeEntityModel) (result OperationStatus, err error) {
	req, err := client.UpdateCompositeEntityPreparer(ctx, appID, versionID, cEntityID, compositeModelUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateCompositeEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateCompositeEntitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateCompositeEntity", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateCompositeEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateCompositeEntity", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateCompositeEntityPreparer prepares the UpdateCompositeEntity request.
func (client ModelClient) UpdateCompositeEntityPreparer(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID, compositeModelUpdateObject CompositeEntityModel) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"cEntityId": autorest.Encode("path", cEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/compositeentities/{cEntityId}", pathParameters),
		autorest.WithJSON(compositeModelUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateCompositeEntitySender sends the UpdateCompositeEntity request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdateCompositeEntitySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateCompositeEntityResponder handles the response to the UpdateCompositeEntity request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdateCompositeEntityResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateCompositeEntityRole sends the update composite entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// cEntityID - the composite entity extractor ID.
// roleID - the entity role ID.
// entityRoleUpdateObject - the new entity role.
func (client ModelClient) UpdateCompositeEntityRole(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID, roleID uuid.UUID, entityRoleUpdateObject EntityRoleUpdateObject) (result OperationStatus, err error) {
	req, err := client.UpdateCompositeEntityRolePreparer(ctx, appID, versionID, cEntityID, roleID, entityRoleUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateCompositeEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateCompositeEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateCompositeEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateCompositeEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateCompositeEntityRole", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateCompositeEntityRolePreparer prepares the UpdateCompositeEntityRole request.
func (client ModelClient) UpdateCompositeEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID, roleID uuid.UUID, entityRoleUpdateObject EntityRoleUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"cEntityId": autorest.Encode("path", cEntityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/compositeentities/{cEntityId}/roles/{roleId}", pathParameters),
		autorest.WithJSON(entityRoleUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateCompositeEntityRoleSender sends the UpdateCompositeEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdateCompositeEntityRoleSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateCompositeEntityRoleResponder handles the response to the UpdateCompositeEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdateCompositeEntityRoleResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateCustomPrebuiltEntityRole sends the update custom prebuilt entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity ID.
// roleID - the entity role ID.
// entityRoleUpdateObject - the new entity role.
func (client ModelClient) UpdateCustomPrebuiltEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID, entityRoleUpdateObject EntityRoleUpdateObject) (result OperationStatus, err error) {
	req, err := client.UpdateCustomPrebuiltEntityRolePreparer(ctx, appID, versionID, entityID, roleID, entityRoleUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateCustomPrebuiltEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateCustomPrebuiltEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateCustomPrebuiltEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateCustomPrebuiltEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateCustomPrebuiltEntityRole", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateCustomPrebuiltEntityRolePreparer prepares the UpdateCustomPrebuiltEntityRole request.
func (client ModelClient) UpdateCustomPrebuiltEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID, entityRoleUpdateObject EntityRoleUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/customprebuiltentities/{entityId}/roles/{roleId}", pathParameters),
		autorest.WithJSON(entityRoleUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateCustomPrebuiltEntityRoleSender sends the UpdateCustomPrebuiltEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdateCustomPrebuiltEntityRoleSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateCustomPrebuiltEntityRoleResponder handles the response to the UpdateCustomPrebuiltEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdateCustomPrebuiltEntityRoleResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateEntity updates the name of an entity extractor.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity extractor ID.
// modelUpdateObject - a model object containing the new entity extractor name.
func (client ModelClient) UpdateEntity(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, modelUpdateObject ModelUpdateObject) (result OperationStatus, err error) {
	req, err := client.UpdateEntityPreparer(ctx, appID, versionID, entityID, modelUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateEntitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateEntity", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateEntity", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateEntityPreparer prepares the UpdateEntity request.
func (client ModelClient) UpdateEntityPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, modelUpdateObject ModelUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/entities/{entityId}", pathParameters),
		autorest.WithJSON(modelUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateEntitySender sends the UpdateEntity request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdateEntitySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateEntityResponder handles the response to the UpdateEntity request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdateEntityResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateEntityRole sends the update entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity ID.
// roleID - the entity role ID.
// entityRoleUpdateObject - the new entity role.
func (client ModelClient) UpdateEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID, entityRoleUpdateObject EntityRoleUpdateObject) (result OperationStatus, err error) {
	req, err := client.UpdateEntityRolePreparer(ctx, appID, versionID, entityID, roleID, entityRoleUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateEntityRole", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateEntityRolePreparer prepares the UpdateEntityRole request.
func (client ModelClient) UpdateEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID, entityRoleUpdateObject EntityRoleUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/entities/{entityId}/roles/{roleId}", pathParameters),
		autorest.WithJSON(entityRoleUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateEntityRoleSender sends the UpdateEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdateEntityRoleSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateEntityRoleResponder handles the response to the UpdateEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdateEntityRoleResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateExplicitListItem sends the update explicit list item request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the Pattern.Any entity extractor ID.
// itemID - the explicit list item ID.
// item - the new explicit list item.
func (client ModelClient) UpdateExplicitListItem(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, itemID int64, item ExplicitListItemUpdateObject) (result OperationStatus, err error) {
	req, err := client.UpdateExplicitListItemPreparer(ctx, appID, versionID, entityID, itemID, item)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateExplicitListItem", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateExplicitListItemSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateExplicitListItem", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateExplicitListItemResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateExplicitListItem", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateExplicitListItemPreparer prepares the UpdateExplicitListItem request.
func (client ModelClient) UpdateExplicitListItemPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, itemID int64, item ExplicitListItemUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"itemId":    autorest.Encode("path", itemID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}/explicitlist/{itemId}", pathParameters),
		autorest.WithJSON(item))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateExplicitListItemSender sends the UpdateExplicitListItem request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdateExplicitListItemSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateExplicitListItemResponder handles the response to the UpdateExplicitListItem request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdateExplicitListItemResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateHierarchicalEntity updates the name and children of a hierarchical entity model.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// hEntityID - the hierarchical entity extractor ID.
// hierarchicalModelUpdateObject - model containing names of the children of the hierarchical entity.
func (client ModelClient) UpdateHierarchicalEntity(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, hierarchicalModelUpdateObject HierarchicalEntityModel) (result OperationStatus, err error) {
	req, err := client.UpdateHierarchicalEntityPreparer(ctx, appID, versionID, hEntityID, hierarchicalModelUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateHierarchicalEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateHierarchicalEntitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateHierarchicalEntity", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateHierarchicalEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateHierarchicalEntity", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateHierarchicalEntityPreparer prepares the UpdateHierarchicalEntity request.
func (client ModelClient) UpdateHierarchicalEntityPreparer(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, hierarchicalModelUpdateObject HierarchicalEntityModel) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"hEntityId": autorest.Encode("path", hEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}", pathParameters),
		autorest.WithJSON(hierarchicalModelUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateHierarchicalEntitySender sends the UpdateHierarchicalEntity request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdateHierarchicalEntitySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateHierarchicalEntityResponder handles the response to the UpdateHierarchicalEntity request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdateHierarchicalEntityResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateHierarchicalEntityChild renames a single child in an existing hierarchical entity model.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// hEntityID - the hierarchical entity extractor ID.
// hChildID - the hierarchical entity extractor child ID.
// hierarchicalChildModelUpdateObject - model object containing new name of the hierarchical entity child.
func (client ModelClient) UpdateHierarchicalEntityChild(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, hChildID uuid.UUID, hierarchicalChildModelUpdateObject HierarchicalChildModelUpdateObject) (result OperationStatus, err error) {
	req, err := client.UpdateHierarchicalEntityChildPreparer(ctx, appID, versionID, hEntityID, hChildID, hierarchicalChildModelUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateHierarchicalEntityChild", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateHierarchicalEntityChildSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateHierarchicalEntityChild", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateHierarchicalEntityChildResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateHierarchicalEntityChild", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateHierarchicalEntityChildPreparer prepares the UpdateHierarchicalEntityChild request.
func (client ModelClient) UpdateHierarchicalEntityChildPreparer(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, hChildID uuid.UUID, hierarchicalChildModelUpdateObject HierarchicalChildModelUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"hChildId":  autorest.Encode("path", hChildID),
		"hEntityId": autorest.Encode("path", hEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}/children/{hChildId}", pathParameters),
		autorest.WithJSON(hierarchicalChildModelUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateHierarchicalEntityChildSender sends the UpdateHierarchicalEntityChild request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdateHierarchicalEntityChildSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateHierarchicalEntityChildResponder handles the response to the UpdateHierarchicalEntityChild request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdateHierarchicalEntityChildResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateHierarchicalEntityRole sends the update hierarchical entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// hEntityID - the hierarchical entity extractor ID.
// roleID - the entity role ID.
// entityRoleUpdateObject - the new entity role.
func (client ModelClient) UpdateHierarchicalEntityRole(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, roleID uuid.UUID, entityRoleUpdateObject EntityRoleUpdateObject) (result OperationStatus, err error) {
	req, err := client.UpdateHierarchicalEntityRolePreparer(ctx, appID, versionID, hEntityID, roleID, entityRoleUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateHierarchicalEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateHierarchicalEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateHierarchicalEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateHierarchicalEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateHierarchicalEntityRole", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateHierarchicalEntityRolePreparer prepares the UpdateHierarchicalEntityRole request.
func (client ModelClient) UpdateHierarchicalEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, roleID uuid.UUID, entityRoleUpdateObject EntityRoleUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"hEntityId": autorest.Encode("path", hEntityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}/roles/{roleId}", pathParameters),
		autorest.WithJSON(entityRoleUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateHierarchicalEntityRoleSender sends the UpdateHierarchicalEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdateHierarchicalEntityRoleSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateHierarchicalEntityRoleResponder handles the response to the UpdateHierarchicalEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdateHierarchicalEntityRoleResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateIntent updates the name of an intent classifier.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// intentID - the intent classifier ID.
// modelUpdateObject - a model object containing the new intent classifier name.
func (client ModelClient) UpdateIntent(ctx context.Context, appID uuid.UUID, versionID string, intentID uuid.UUID, modelUpdateObject ModelUpdateObject) (result OperationStatus, err error) {
	req, err := client.UpdateIntentPreparer(ctx, appID, versionID, intentID, modelUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateIntent", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateIntentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateIntent", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateIntentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateIntent", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateIntentPreparer prepares the UpdateIntent request.
func (client ModelClient) UpdateIntentPreparer(ctx context.Context, appID uuid.UUID, versionID string, intentID uuid.UUID, modelUpdateObject ModelUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"intentId":  autorest.Encode("path", intentID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/intents/{intentId}", pathParameters),
		autorest.WithJSON(modelUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateIntentSender sends the UpdateIntent request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdateIntentSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateIntentResponder handles the response to the UpdateIntent request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdateIntentResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdatePatternAnyEntityModel sends the update pattern any entity model request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the Pattern.Any entity extractor ID.
// patternAnyUpdateObject - an object containing the explicit list of the Pattern.Any entity.
func (client ModelClient) UpdatePatternAnyEntityModel(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, patternAnyUpdateObject PatternAnyModelUpdateObject) (result OperationStatus, err error) {
	req, err := client.UpdatePatternAnyEntityModelPreparer(ctx, appID, versionID, entityID, patternAnyUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdatePatternAnyEntityModel", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdatePatternAnyEntityModelSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdatePatternAnyEntityModel", resp, "Failure sending request")
		return
	}

	result, err = client.UpdatePatternAnyEntityModelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdatePatternAnyEntityModel", resp, "Failure responding to request")
		return
	}

	return
}

// UpdatePatternAnyEntityModelPreparer prepares the UpdatePatternAnyEntityModel request.
func (client ModelClient) UpdatePatternAnyEntityModelPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, patternAnyUpdateObject PatternAnyModelUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}", pathParameters),
		autorest.WithJSON(patternAnyUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdatePatternAnyEntityModelSender sends the UpdatePatternAnyEntityModel request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdatePatternAnyEntityModelSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdatePatternAnyEntityModelResponder handles the response to the UpdatePatternAnyEntityModel request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdatePatternAnyEntityModelResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdatePatternAnyEntityRole sends the update pattern any entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity ID.
// roleID - the entity role ID.
// entityRoleUpdateObject - the new entity role.
func (client ModelClient) UpdatePatternAnyEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID, entityRoleUpdateObject EntityRoleUpdateObject) (result OperationStatus, err error) {
	req, err := client.UpdatePatternAnyEntityRolePreparer(ctx, appID, versionID, entityID, roleID, entityRoleUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdatePatternAnyEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdatePatternAnyEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdatePatternAnyEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.UpdatePatternAnyEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdatePatternAnyEntityRole", resp, "Failure responding to request")
		return
	}

	return
}

// UpdatePatternAnyEntityRolePreparer prepares the UpdatePatternAnyEntityRole request.
func (client ModelClient) UpdatePatternAnyEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID, entityRoleUpdateObject EntityRoleUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}/roles/{roleId}", pathParameters),
		autorest.WithJSON(entityRoleUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdatePatternAnyEntityRoleSender sends the UpdatePatternAnyEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdatePatternAnyEntityRoleSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdatePatternAnyEntityRoleResponder handles the response to the UpdatePatternAnyEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdatePatternAnyEntityRoleResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdatePrebuiltEntityRole sends the update prebuilt entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity ID.
// roleID - the entity role ID.
// entityRoleUpdateObject - the new entity role.
func (client ModelClient) UpdatePrebuiltEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID, entityRoleUpdateObject EntityRoleUpdateObject) (result OperationStatus, err error) {
	req, err := client.UpdatePrebuiltEntityRolePreparer(ctx, appID, versionID, entityID, roleID, entityRoleUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdatePrebuiltEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdatePrebuiltEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdatePrebuiltEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.UpdatePrebuiltEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdatePrebuiltEntityRole", resp, "Failure responding to request")
		return
	}

	return
}

// UpdatePrebuiltEntityRolePreparer prepares the UpdatePrebuiltEntityRole request.
func (client ModelClient) UpdatePrebuiltEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID, entityRoleUpdateObject EntityRoleUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/prebuilts/{entityId}/roles/{roleId}", pathParameters),
		autorest.WithJSON(entityRoleUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdatePrebuiltEntityRoleSender sends the UpdatePrebuiltEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdatePrebuiltEntityRoleSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdatePrebuiltEntityRoleResponder handles the response to the UpdatePrebuiltEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdatePrebuiltEntityRoleResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateRegexEntityModel sends the update regex entity model request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// regexEntityID - the regex entity extractor ID.
// regexEntityUpdateObject - an object containing the new entity name and regex pattern.
func (client ModelClient) UpdateRegexEntityModel(ctx context.Context, appID uuid.UUID, versionID string, regexEntityID uuid.UUID, regexEntityUpdateObject RegexModelUpdateObject) (result OperationStatus, err error) {
	req, err := client.UpdateRegexEntityModelPreparer(ctx, appID, versionID, regexEntityID, regexEntityUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateRegexEntityModel", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateRegexEntityModelSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateRegexEntityModel", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateRegexEntityModelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateRegexEntityModel", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateRegexEntityModelPreparer prepares the UpdateRegexEntityModel request.
func (client ModelClient) UpdateRegexEntityModelPreparer(ctx context.Context, appID uuid.UUID, versionID string, regexEntityID uuid.UUID, regexEntityUpdateObject RegexModelUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":         autorest.Encode("path", appID),
		"regexEntityId": autorest.Encode("path", regexEntityID),
		"versionId":     autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/regexentities/{regexEntityId}", pathParameters),
		autorest.WithJSON(regexEntityUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateRegexEntityModelSender sends the UpdateRegexEntityModel request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdateRegexEntityModelSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateRegexEntityModelResponder handles the response to the UpdateRegexEntityModel request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdateRegexEntityModelResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateRegexEntityRole sends the update regex entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity ID.
// roleID - the entity role ID.
// entityRoleUpdateObject - the new entity role.
func (client ModelClient) UpdateRegexEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID, entityRoleUpdateObject EntityRoleUpdateObject) (result OperationStatus, err error) {
	req, err := client.UpdateRegexEntityRolePreparer(ctx, appID, versionID, entityID, roleID, entityRoleUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateRegexEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateRegexEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateRegexEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateRegexEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateRegexEntityRole", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateRegexEntityRolePreparer prepares the UpdateRegexEntityRole request.
func (client ModelClient) UpdateRegexEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID, entityRoleUpdateObject EntityRoleUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/regexentities/{entityId}/roles/{roleId}", pathParameters),
		autorest.WithJSON(entityRoleUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateRegexEntityRoleSender sends the UpdateRegexEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdateRegexEntityRoleSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateRegexEntityRoleResponder handles the response to the UpdateRegexEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdateRegexEntityRoleResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSubList updates one of the closed list's sublists.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// clEntityID - the closed list entity extractor ID.
// subListID - the sublist ID.
// wordListBaseUpdateObject - a sublist update object containing the new canonical form and the list of words.
func (client ModelClient) UpdateSubList(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID, subListID int32, wordListBaseUpdateObject WordListBaseUpdateObject) (result OperationStatus, err error) {
	req, err := client.UpdateSubListPreparer(ctx, appID, versionID, clEntityID, subListID, wordListBaseUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateSubList", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSubListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateSubList", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSubListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateSubList", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateSubListPreparer prepares the UpdateSubList request.
func (client ModelClient) UpdateSubListPreparer(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID, subListID int32, wordListBaseUpdateObject WordListBaseUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":      autorest.Encode("path", appID),
		"clEntityId": autorest.Encode("path", clEntityID),
		"subListId":  autorest.Encode("path", subListID),
		"versionId":  autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/closedlists/{clEntityId}/sublists/{subListId}", pathParameters),
		autorest.WithJSON(wordListBaseUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSubListSender sends the UpdateSubList request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdateSubListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateSubListResponder handles the response to the UpdateSubList request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdateSubListResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
