package hybridcomputeapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/hybridcompute/mgmt/2020-08-02/hybridcompute"
	"github.com/Azure/go-autorest/autorest"
)

// MachinesClientAPI contains the set of methods on the MachinesClient type.
type MachinesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, name string, parameters hybridcompute.Machine) (result hybridcompute.Machine, err error)
	Delete(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, name string, expand hybridcompute.InstanceViewTypes) (result hybridcompute.Machine, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result hybridcompute.MachineListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result hybridcompute.MachineListResultIterator, err error)
	ListBySubscription(ctx context.Context) (result hybridcompute.MachineListResultPage, err error)
	ListBySubscriptionComplete(ctx context.Context) (result hybridcompute.MachineListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, name string, parameters hybridcompute.MachineUpdate) (result hybridcompute.Machine, err error)
}

var _ MachinesClientAPI = (*hybridcompute.MachinesClient)(nil)

// MachineExtensionsClientAPI contains the set of methods on the MachineExtensionsClient type.
type MachineExtensionsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, name string, extensionName string, extensionParameters hybridcompute.MachineExtension) (result hybridcompute.MachineExtensionsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, name string, extensionName string) (result hybridcompute.MachineExtensionsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, name string, extensionName string) (result hybridcompute.MachineExtension, err error)
	List(ctx context.Context, resourceGroupName string, name string, expand string) (result hybridcompute.MachineExtensionsListResultPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, name string, expand string) (result hybridcompute.MachineExtensionsListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, name string, extensionName string, extensionParameters hybridcompute.MachineExtensionUpdate) (result hybridcompute.MachineExtensionsUpdateFuture, err error)
}

var _ MachineExtensionsClientAPI = (*hybridcompute.MachineExtensionsClient)(nil)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result hybridcompute.OperationListResult, err error)
}

var _ OperationsClientAPI = (*hybridcompute.OperationsClient)(nil)
