package hybridcompute

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/hybridcompute/mgmt/2020-08-02/hybridcompute"

// AzureEntityResource the resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// ErrorDetail ...
type ErrorDetail struct {
	// Code - The error's code.
	Code *string `json:"code,omitempty"`
	// Message - A human readable error message.
	Message *string `json:"message,omitempty"`
	// Target - Indicates which property in the request is responsible for the error.
	Target *string `json:"target,omitempty"`
	// Details - Additional error details.
	Details *[]ErrorDetail `json:"details,omitempty"`
}

// ErrorResponse contains details when the response code indicates an error.
type ErrorResponse struct {
	// Error - The error details.
	Error *ErrorDetail `json:"error,omitempty"`
}

// Identity ...
type Identity struct {
	// Type - The identity type.
	Type *string `json:"type,omitempty"`
	// PrincipalID - READ-ONLY; The identity's principal id.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The identity's tenant id.
	TenantID *string `json:"tenantId,omitempty"`
}

// MarshalJSON is the custom marshaler for Identity.
func (i Identity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.Type != nil {
		objectMap["type"] = i.Type
	}
	return json.Marshal(objectMap)
}

// LocationData metadata pertaining to the geographic location of the resource.
type LocationData struct {
	// Name - A canonical name for the geographic or physical location.
	Name *string `json:"name,omitempty"`
	// City - The city or locality where the resource is located.
	City *string `json:"city,omitempty"`
	// District - The district, state, or province where the resource is located.
	District *string `json:"district,omitempty"`
	// CountryOrRegion - The country or region where the resource is located
	CountryOrRegion *string `json:"countryOrRegion,omitempty"`
}

// Machine describes a hybrid machine.
type Machine struct {
	autorest.Response `json:"-"`
	// MachinePropertiesModel - Hybrid Compute Machine properties
	*MachinePropertiesModel `json:"properties,omitempty"`
	Identity                *MachineIdentity `json:"identity,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Machine.
func (mVar Machine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mVar.MachinePropertiesModel != nil {
		objectMap["properties"] = mVar.MachinePropertiesModel
	}
	if mVar.Identity != nil {
		objectMap["identity"] = mVar.Identity
	}
	if mVar.Tags != nil {
		objectMap["tags"] = mVar.Tags
	}
	if mVar.Location != nil {
		objectMap["location"] = mVar.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Machine struct.
func (mVar *Machine) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var machinePropertiesModel MachinePropertiesModel
				err = json.Unmarshal(*v, &machinePropertiesModel)
				if err != nil {
					return err
				}
				mVar.MachinePropertiesModel = &machinePropertiesModel
			}
		case "identity":
			if v != nil {
				var identity MachineIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				mVar.Identity = &identity
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mVar.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mVar.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mVar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mVar.Type = &typeVar
			}
		}
	}

	return nil
}

// MachineExtension describes a Machine Extension.
type MachineExtension struct {
	autorest.Response `json:"-"`
	// MachineExtensionProperties - Describes Machine Extension Properties.
	*MachineExtensionProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for MachineExtension.
func (me MachineExtension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if me.MachineExtensionProperties != nil {
		objectMap["properties"] = me.MachineExtensionProperties
	}
	if me.Tags != nil {
		objectMap["tags"] = me.Tags
	}
	if me.Location != nil {
		objectMap["location"] = me.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MachineExtension struct.
func (me *MachineExtension) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var machineExtensionProperties MachineExtensionProperties
				err = json.Unmarshal(*v, &machineExtensionProperties)
				if err != nil {
					return err
				}
				me.MachineExtensionProperties = &machineExtensionProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				me.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				me.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				me.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				me.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				me.Type = &typeVar
			}
		}
	}

	return nil
}

// MachineExtensionInstanceView describes the Machine Extension Instance View.
type MachineExtensionInstanceView struct {
	// Name - READ-ONLY; The machine extension name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Specifies the type of the extension; an example is "CustomScriptExtension".
	Type *string `json:"type,omitempty"`
	// TypeHandlerVersion - READ-ONLY; Specifies the version of the script handler.
	TypeHandlerVersion *string `json:"typeHandlerVersion,omitempty"`
	// Status - Instance view status.
	Status *MachineExtensionInstanceViewStatus `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for MachineExtensionInstanceView.
func (meiv MachineExtensionInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if meiv.Status != nil {
		objectMap["status"] = meiv.Status
	}
	return json.Marshal(objectMap)
}

// MachineExtensionInstanceViewStatus instance view status.
type MachineExtensionInstanceViewStatus struct {
	// Code - READ-ONLY; The status code.
	Code *string `json:"code,omitempty"`
	// Level - READ-ONLY; The level code. Possible values include: 'Info', 'Warning', 'Error'
	Level StatusLevelTypes `json:"level,omitempty"`
	// DisplayStatus - READ-ONLY; The short localizable label for the status.
	DisplayStatus *string `json:"displayStatus,omitempty"`
	// Message - READ-ONLY; The detailed status message, including for alerts and error messages.
	Message *string `json:"message,omitempty"`
	// Time - READ-ONLY; The time of the status.
	Time *date.Time `json:"time,omitempty"`
}

// MachineExtensionProperties describes Machine Extension Properties.
type MachineExtensionProperties struct {
	// ForceUpdateTag - How the extension handler should be forced to update even if the extension configuration has not changed.
	ForceUpdateTag *string `json:"forceUpdateTag,omitempty"`
	// Publisher - The name of the extension handler publisher.
	Publisher *string `json:"publisher,omitempty"`
	// Type - Specifies the type of the extension; an example is "CustomScriptExtension".
	Type *string `json:"type,omitempty"`
	// TypeHandlerVersion - Specifies the version of the script handler.
	TypeHandlerVersion *string `json:"typeHandlerVersion,omitempty"`
	// AutoUpgradeMinorVersion - Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
	AutoUpgradeMinorVersion *bool `json:"autoUpgradeMinorVersion,omitempty"`
	// Settings - Json formatted public settings for the extension.
	Settings interface{} `json:"settings,omitempty"`
	// ProtectedSettings - The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
	ProtectedSettings interface{} `json:"protectedSettings,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// InstanceView - The machine extension instance view.
	InstanceView *MachineExtensionPropertiesInstanceView `json:"instanceView,omitempty"`
}

// MarshalJSON is the custom marshaler for MachineExtensionProperties.
func (me MachineExtensionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if me.ForceUpdateTag != nil {
		objectMap["forceUpdateTag"] = me.ForceUpdateTag
	}
	if me.Publisher != nil {
		objectMap["publisher"] = me.Publisher
	}
	if me.Type != nil {
		objectMap["type"] = me.Type
	}
	if me.TypeHandlerVersion != nil {
		objectMap["typeHandlerVersion"] = me.TypeHandlerVersion
	}
	if me.AutoUpgradeMinorVersion != nil {
		objectMap["autoUpgradeMinorVersion"] = me.AutoUpgradeMinorVersion
	}
	if me.Settings != nil {
		objectMap["settings"] = me.Settings
	}
	if me.ProtectedSettings != nil {
		objectMap["protectedSettings"] = me.ProtectedSettings
	}
	if me.InstanceView != nil {
		objectMap["instanceView"] = me.InstanceView
	}
	return json.Marshal(objectMap)
}

// MachineExtensionPropertiesInstanceView the machine extension instance view.
type MachineExtensionPropertiesInstanceView struct {
	// Name - READ-ONLY; The machine extension name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Specifies the type of the extension; an example is "CustomScriptExtension".
	Type *string `json:"type,omitempty"`
	// TypeHandlerVersion - READ-ONLY; Specifies the version of the script handler.
	TypeHandlerVersion *string `json:"typeHandlerVersion,omitempty"`
	// Status - Instance view status.
	Status *MachineExtensionInstanceViewStatus `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for MachineExtensionPropertiesInstanceView.
func (mepV MachineExtensionPropertiesInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mepV.Status != nil {
		objectMap["status"] = mepV.Status
	}
	return json.Marshal(objectMap)
}

// MachineExtensionPropertiesModel describes the properties of a Machine Extension.
type MachineExtensionPropertiesModel struct {
	// ForceUpdateTag - How the extension handler should be forced to update even if the extension configuration has not changed.
	ForceUpdateTag *string `json:"forceUpdateTag,omitempty"`
	// Publisher - The name of the extension handler publisher.
	Publisher *string `json:"publisher,omitempty"`
	// Type - Specifies the type of the extension; an example is "CustomScriptExtension".
	Type *string `json:"type,omitempty"`
	// TypeHandlerVersion - Specifies the version of the script handler.
	TypeHandlerVersion *string `json:"typeHandlerVersion,omitempty"`
	// AutoUpgradeMinorVersion - Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
	AutoUpgradeMinorVersion *bool `json:"autoUpgradeMinorVersion,omitempty"`
	// Settings - Json formatted public settings for the extension.
	Settings interface{} `json:"settings,omitempty"`
	// ProtectedSettings - The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
	ProtectedSettings interface{} `json:"protectedSettings,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// InstanceView - The machine extension instance view.
	InstanceView *MachineExtensionPropertiesInstanceView `json:"instanceView,omitempty"`
}

// MarshalJSON is the custom marshaler for MachineExtensionPropertiesModel.
func (mepm MachineExtensionPropertiesModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mepm.ForceUpdateTag != nil {
		objectMap["forceUpdateTag"] = mepm.ForceUpdateTag
	}
	if mepm.Publisher != nil {
		objectMap["publisher"] = mepm.Publisher
	}
	if mepm.Type != nil {
		objectMap["type"] = mepm.Type
	}
	if mepm.TypeHandlerVersion != nil {
		objectMap["typeHandlerVersion"] = mepm.TypeHandlerVersion
	}
	if mepm.AutoUpgradeMinorVersion != nil {
		objectMap["autoUpgradeMinorVersion"] = mepm.AutoUpgradeMinorVersion
	}
	if mepm.Settings != nil {
		objectMap["settings"] = mepm.Settings
	}
	if mepm.ProtectedSettings != nil {
		objectMap["protectedSettings"] = mepm.ProtectedSettings
	}
	if mepm.InstanceView != nil {
		objectMap["instanceView"] = mepm.InstanceView
	}
	return json.Marshal(objectMap)
}

// MachineExtensionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type MachineExtensionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MachineExtensionsClient) (MachineExtension, error)
}

// MachineExtensionsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type MachineExtensionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MachineExtensionsClient) (autorest.Response, error)
}

// MachineExtensionsListResult describes the Machine Extensions List Result.
type MachineExtensionsListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of extensions
	Value *[]MachineExtension `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of machine extensions. Call ListNext() with this to fetch the next page of extensions.
	NextLink *string `json:"nextLink,omitempty"`
}

// MachineExtensionsListResultIterator provides access to a complete listing of MachineExtension values.
type MachineExtensionsListResultIterator struct {
	i    int
	page MachineExtensionsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *MachineExtensionsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MachineExtensionsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *MachineExtensionsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter MachineExtensionsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter MachineExtensionsListResultIterator) Response() MachineExtensionsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter MachineExtensionsListResultIterator) Value() MachineExtension {
	if !iter.page.NotDone() {
		return MachineExtension{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the MachineExtensionsListResultIterator type.
func NewMachineExtensionsListResultIterator(page MachineExtensionsListResultPage) MachineExtensionsListResultIterator {
	return MachineExtensionsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (melr MachineExtensionsListResult) IsEmpty() bool {
	return melr.Value == nil || len(*melr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (melr MachineExtensionsListResult) hasNextLink() bool {
	return melr.NextLink != nil && len(*melr.NextLink) != 0
}

// machineExtensionsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (melr MachineExtensionsListResult) machineExtensionsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !melr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(melr.NextLink)))
}

// MachineExtensionsListResultPage contains a page of MachineExtension values.
type MachineExtensionsListResultPage struct {
	fn   func(context.Context, MachineExtensionsListResult) (MachineExtensionsListResult, error)
	melr MachineExtensionsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *MachineExtensionsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MachineExtensionsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.melr)
		if err != nil {
			return err
		}
		page.melr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *MachineExtensionsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page MachineExtensionsListResultPage) NotDone() bool {
	return !page.melr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page MachineExtensionsListResultPage) Response() MachineExtensionsListResult {
	return page.melr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page MachineExtensionsListResultPage) Values() []MachineExtension {
	if page.melr.IsEmpty() {
		return nil
	}
	return *page.melr.Value
}

// Creates a new instance of the MachineExtensionsListResultPage type.
func NewMachineExtensionsListResultPage(cur MachineExtensionsListResult, getNextPage func(context.Context, MachineExtensionsListResult) (MachineExtensionsListResult, error)) MachineExtensionsListResultPage {
	return MachineExtensionsListResultPage{
		fn:   getNextPage,
		melr: cur,
	}
}

// MachineExtensionsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type MachineExtensionsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MachineExtensionsClient) (MachineExtension, error)
}

// MachineExtensionUpdate describes a Machine Extension Update.
type MachineExtensionUpdate struct {
	// MachineExtensionUpdateProperties - Describes Machine Extension Update Properties.
	*MachineExtensionUpdateProperties `json:"properties,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for MachineExtensionUpdate.
func (meu MachineExtensionUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if meu.MachineExtensionUpdateProperties != nil {
		objectMap["properties"] = meu.MachineExtensionUpdateProperties
	}
	if meu.Tags != nil {
		objectMap["tags"] = meu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MachineExtensionUpdate struct.
func (meu *MachineExtensionUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var machineExtensionUpdateProperties MachineExtensionUpdateProperties
				err = json.Unmarshal(*v, &machineExtensionUpdateProperties)
				if err != nil {
					return err
				}
				meu.MachineExtensionUpdateProperties = &machineExtensionUpdateProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				meu.Tags = tags
			}
		}
	}

	return nil
}

// MachineExtensionUpdateProperties describes Machine Extension Update Properties.
type MachineExtensionUpdateProperties struct {
	// ForceUpdateTag - How the extension handler should be forced to update even if the extension configuration has not changed.
	ForceUpdateTag *string `json:"forceUpdateTag,omitempty"`
	// Publisher - The name of the extension handler publisher.
	Publisher *string `json:"publisher,omitempty"`
	// Type - Specifies the type of the extension; an example is "CustomScriptExtension".
	Type *string `json:"type,omitempty"`
	// TypeHandlerVersion - Specifies the version of the script handler.
	TypeHandlerVersion *string `json:"typeHandlerVersion,omitempty"`
	// AutoUpgradeMinorVersion - Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
	AutoUpgradeMinorVersion *bool `json:"autoUpgradeMinorVersion,omitempty"`
	// Settings - Json formatted public settings for the extension.
	Settings interface{} `json:"settings,omitempty"`
	// ProtectedSettings - The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
	ProtectedSettings interface{} `json:"protectedSettings,omitempty"`
}

// MachineExtensionUpdatePropertiesModel describes the properties of a Machine Extension.
type MachineExtensionUpdatePropertiesModel struct {
	// ForceUpdateTag - How the extension handler should be forced to update even if the extension configuration has not changed.
	ForceUpdateTag *string `json:"forceUpdateTag,omitempty"`
	// Publisher - The name of the extension handler publisher.
	Publisher *string `json:"publisher,omitempty"`
	// Type - Specifies the type of the extension; an example is "CustomScriptExtension".
	Type *string `json:"type,omitempty"`
	// TypeHandlerVersion - Specifies the version of the script handler.
	TypeHandlerVersion *string `json:"typeHandlerVersion,omitempty"`
	// AutoUpgradeMinorVersion - Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
	AutoUpgradeMinorVersion *bool `json:"autoUpgradeMinorVersion,omitempty"`
	// Settings - Json formatted public settings for the extension.
	Settings interface{} `json:"settings,omitempty"`
	// ProtectedSettings - The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
	ProtectedSettings interface{} `json:"protectedSettings,omitempty"`
}

// MachineIdentity ...
type MachineIdentity struct {
	// Type - The identity type.
	Type *string `json:"type,omitempty"`
	// PrincipalID - READ-ONLY; The identity's principal id.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The identity's tenant id.
	TenantID *string `json:"tenantId,omitempty"`
}

// MarshalJSON is the custom marshaler for MachineIdentity.
func (mVar MachineIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mVar.Type != nil {
		objectMap["type"] = mVar.Type
	}
	return json.Marshal(objectMap)
}

// MachineListResult the List hybrid machine operation response.
type MachineListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of hybrid machines.
	Value *[]Machine `json:"value,omitempty"`
	// NextLink - The URI to fetch the next page of Machines. Call ListNext() with this URI to fetch the next page of hybrid machines.
	NextLink *string `json:"nextLink,omitempty"`
}

// MachineListResultIterator provides access to a complete listing of Machine values.
type MachineListResultIterator struct {
	i    int
	page MachineListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *MachineListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MachineListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *MachineListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter MachineListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter MachineListResultIterator) Response() MachineListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter MachineListResultIterator) Value() Machine {
	if !iter.page.NotDone() {
		return Machine{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the MachineListResultIterator type.
func NewMachineListResultIterator(page MachineListResultPage) MachineListResultIterator {
	return MachineListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mlr MachineListResult) IsEmpty() bool {
	return mlr.Value == nil || len(*mlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mlr MachineListResult) hasNextLink() bool {
	return mlr.NextLink != nil && len(*mlr.NextLink) != 0
}

// machineListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mlr MachineListResult) machineListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !mlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mlr.NextLink)))
}

// MachineListResultPage contains a page of Machine values.
type MachineListResultPage struct {
	fn  func(context.Context, MachineListResult) (MachineListResult, error)
	mlr MachineListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *MachineListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MachineListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mlr)
		if err != nil {
			return err
		}
		page.mlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *MachineListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page MachineListResultPage) NotDone() bool {
	return !page.mlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page MachineListResultPage) Response() MachineListResult {
	return page.mlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page MachineListResultPage) Values() []Machine {
	if page.mlr.IsEmpty() {
		return nil
	}
	return *page.mlr.Value
}

// Creates a new instance of the MachineListResultPage type.
func NewMachineListResultPage(cur MachineListResult, getNextPage func(context.Context, MachineListResult) (MachineListResult, error)) MachineListResultPage {
	return MachineListResultPage{
		fn:  getNextPage,
		mlr: cur,
	}
}

// MachineProperties describes the properties of a hybrid machine.
type MachineProperties struct {
	LocationData *LocationData `json:"locationData,omitempty"`
	// OsProfile - Specifies the operating system settings for the hybrid machine.
	OsProfile *MachinePropertiesOsProfile `json:"osProfile,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// Status - READ-ONLY; The status of the hybrid machine agent. Possible values include: 'StatusTypesConnected', 'StatusTypesDisconnected', 'StatusTypesError'
	Status StatusTypes `json:"status,omitempty"`
	// LastStatusChange - READ-ONLY; The time of the last status change.
	LastStatusChange *date.Time `json:"lastStatusChange,omitempty"`
	// ErrorDetails - READ-ONLY; Details about the error state.
	ErrorDetails *[]ErrorDetail `json:"errorDetails,omitempty"`
	// AgentVersion - READ-ONLY; The hybrid machine agent full version.
	AgentVersion *string `json:"agentVersion,omitempty"`
	// VMID - Specifies the hybrid machine unique ID.
	VMID *string `json:"vmId,omitempty"`
	// DisplayName - READ-ONLY; Specifies the hybrid machine display name.
	DisplayName *string `json:"displayName,omitempty"`
	// MachineFqdn - READ-ONLY; Specifies the hybrid machine FQDN.
	MachineFqdn *string `json:"machineFqdn,omitempty"`
	// ClientPublicKey - Public Key that the client provides to be used during initial resource onboarding
	ClientPublicKey *string `json:"clientPublicKey,omitempty"`
	// OsName - READ-ONLY; The Operating System running on the hybrid machine.
	OsName *string `json:"osName,omitempty"`
	// OsVersion - READ-ONLY; The version of Operating System running on the hybrid machine.
	OsVersion *string `json:"osVersion,omitempty"`
	// VMUUID - READ-ONLY; Specifies the Arc Machine's unique SMBIOS ID
	VMUUID *string `json:"vmUuid,omitempty"`
	// Extensions - READ-ONLY; Machine Extensions information
	Extensions *[]MachineExtensionInstanceView `json:"extensions,omitempty"`
	// OsSku - READ-ONLY; Specifies the Operating System product SKU.
	OsSku *string `json:"osSku,omitempty"`
	// DomainName - READ-ONLY; Specifies the Windows domain name.
	DomainName *string `json:"domainName,omitempty"`
	// AdFqdn - READ-ONLY; Specifies the AD fully qualified display name.
	AdFqdn *string `json:"adFqdn,omitempty"`
	// DNSFqdn - READ-ONLY; Specifies the DNS fully qualified display name.
	DNSFqdn *string `json:"dnsFqdn,omitempty"`
}

// MarshalJSON is the custom marshaler for MachineProperties.
func (mp MachineProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mp.LocationData != nil {
		objectMap["locationData"] = mp.LocationData
	}
	if mp.OsProfile != nil {
		objectMap["osProfile"] = mp.OsProfile
	}
	if mp.VMID != nil {
		objectMap["vmId"] = mp.VMID
	}
	if mp.ClientPublicKey != nil {
		objectMap["clientPublicKey"] = mp.ClientPublicKey
	}
	return json.Marshal(objectMap)
}

// MachinePropertiesModel hybrid Compute Machine properties
type MachinePropertiesModel struct {
	LocationData *LocationData `json:"locationData,omitempty"`
	// OsProfile - Specifies the operating system settings for the hybrid machine.
	OsProfile *MachinePropertiesOsProfile `json:"osProfile,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// Status - READ-ONLY; The status of the hybrid machine agent. Possible values include: 'StatusTypesConnected', 'StatusTypesDisconnected', 'StatusTypesError'
	Status StatusTypes `json:"status,omitempty"`
	// LastStatusChange - READ-ONLY; The time of the last status change.
	LastStatusChange *date.Time `json:"lastStatusChange,omitempty"`
	// ErrorDetails - READ-ONLY; Details about the error state.
	ErrorDetails *[]ErrorDetail `json:"errorDetails,omitempty"`
	// AgentVersion - READ-ONLY; The hybrid machine agent full version.
	AgentVersion *string `json:"agentVersion,omitempty"`
	// VMID - Specifies the hybrid machine unique ID.
	VMID *string `json:"vmId,omitempty"`
	// DisplayName - READ-ONLY; Specifies the hybrid machine display name.
	DisplayName *string `json:"displayName,omitempty"`
	// MachineFqdn - READ-ONLY; Specifies the hybrid machine FQDN.
	MachineFqdn *string `json:"machineFqdn,omitempty"`
	// ClientPublicKey - Public Key that the client provides to be used during initial resource onboarding
	ClientPublicKey *string `json:"clientPublicKey,omitempty"`
	// OsName - READ-ONLY; The Operating System running on the hybrid machine.
	OsName *string `json:"osName,omitempty"`
	// OsVersion - READ-ONLY; The version of Operating System running on the hybrid machine.
	OsVersion *string `json:"osVersion,omitempty"`
	// VMUUID - READ-ONLY; Specifies the Arc Machine's unique SMBIOS ID
	VMUUID *string `json:"vmUuid,omitempty"`
	// Extensions - READ-ONLY; Machine Extensions information
	Extensions *[]MachineExtensionInstanceView `json:"extensions,omitempty"`
	// OsSku - READ-ONLY; Specifies the Operating System product SKU.
	OsSku *string `json:"osSku,omitempty"`
	// DomainName - READ-ONLY; Specifies the Windows domain name.
	DomainName *string `json:"domainName,omitempty"`
	// AdFqdn - READ-ONLY; Specifies the AD fully qualified display name.
	AdFqdn *string `json:"adFqdn,omitempty"`
	// DNSFqdn - READ-ONLY; Specifies the DNS fully qualified display name.
	DNSFqdn *string `json:"dnsFqdn,omitempty"`
}

// MarshalJSON is the custom marshaler for MachinePropertiesModel.
func (mpm MachinePropertiesModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mpm.LocationData != nil {
		objectMap["locationData"] = mpm.LocationData
	}
	if mpm.OsProfile != nil {
		objectMap["osProfile"] = mpm.OsProfile
	}
	if mpm.VMID != nil {
		objectMap["vmId"] = mpm.VMID
	}
	if mpm.ClientPublicKey != nil {
		objectMap["clientPublicKey"] = mpm.ClientPublicKey
	}
	return json.Marshal(objectMap)
}

// MachinePropertiesOsProfile specifies the operating system settings for the hybrid machine.
type MachinePropertiesOsProfile struct {
	// ComputerName - READ-ONLY; Specifies the host OS name of the hybrid machine.
	ComputerName *string `json:"computerName,omitempty"`
}

// MachineUpdate describes a hybrid machine Update.
type MachineUpdate struct {
	// MachineUpdateIdentity - Hybrid Compute Machine Managed Identity
	*MachineUpdateIdentity `json:"identity,omitempty"`
	// MachineUpdatePropertiesModel - Hybrid Compute Machine properties
	*MachineUpdatePropertiesModel `json:"properties,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for MachineUpdate.
func (mu MachineUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mu.MachineUpdateIdentity != nil {
		objectMap["identity"] = mu.MachineUpdateIdentity
	}
	if mu.MachineUpdatePropertiesModel != nil {
		objectMap["properties"] = mu.MachineUpdatePropertiesModel
	}
	if mu.Tags != nil {
		objectMap["tags"] = mu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MachineUpdate struct.
func (mu *MachineUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "identity":
			if v != nil {
				var machineUpdateIdentity MachineUpdateIdentity
				err = json.Unmarshal(*v, &machineUpdateIdentity)
				if err != nil {
					return err
				}
				mu.MachineUpdateIdentity = &machineUpdateIdentity
			}
		case "properties":
			if v != nil {
				var machineUpdatePropertiesModel MachineUpdatePropertiesModel
				err = json.Unmarshal(*v, &machineUpdatePropertiesModel)
				if err != nil {
					return err
				}
				mu.MachineUpdatePropertiesModel = &machineUpdatePropertiesModel
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mu.Tags = tags
			}
		}
	}

	return nil
}

// MachineUpdateIdentity hybrid Compute Machine Managed Identity
type MachineUpdateIdentity struct {
	// Type - The identity type.
	Type *string `json:"type,omitempty"`
	// PrincipalID - READ-ONLY; The identity's principal id.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The identity's tenant id.
	TenantID *string `json:"tenantId,omitempty"`
}

// MarshalJSON is the custom marshaler for MachineUpdateIdentity.
func (mu MachineUpdateIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mu.Type != nil {
		objectMap["type"] = mu.Type
	}
	return json.Marshal(objectMap)
}

// MachineUpdateProperties describes the ARM updatable properties of a hybrid machine.
type MachineUpdateProperties struct {
	LocationData *LocationData `json:"locationData,omitempty"`
}

// MachineUpdatePropertiesModel hybrid Compute Machine properties
type MachineUpdatePropertiesModel struct {
	LocationData *LocationData `json:"locationData,omitempty"`
}

// OperationListResult the List Compute Operation operation response.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of compute operations
	Value *[]OperationValue `json:"value,omitempty"`
}

// OperationValue describes the properties of a Compute Operation value.
type OperationValue struct {
	// Origin - READ-ONLY; The origin of the compute operation.
	Origin *string `json:"origin,omitempty"`
	// Name - READ-ONLY; The name of the compute operation.
	Name *string `json:"name,omitempty"`
	// OperationValueDisplay - Display properties
	*OperationValueDisplay `json:"display,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationValue.
func (ov OperationValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ov.OperationValueDisplay != nil {
		objectMap["display"] = ov.OperationValueDisplay
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OperationValue struct.
func (ov *OperationValue) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "origin":
			if v != nil {
				var origin string
				err = json.Unmarshal(*v, &origin)
				if err != nil {
					return err
				}
				ov.Origin = &origin
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ov.Name = &name
			}
		case "display":
			if v != nil {
				var operationValueDisplay OperationValueDisplay
				err = json.Unmarshal(*v, &operationValueDisplay)
				if err != nil {
					return err
				}
				ov.OperationValueDisplay = &operationValueDisplay
			}
		}
	}

	return nil
}

// OperationValueDisplay display properties
type OperationValueDisplay struct {
	// Operation - READ-ONLY; The display name of the compute operation.
	Operation *string `json:"operation,omitempty"`
	// Resource - READ-ONLY; The display name of the resource the operation applies to.
	Resource *string `json:"resource,omitempty"`
	// Description - READ-ONLY; The description of the operation.
	Description *string `json:"description,omitempty"`
	// Provider - READ-ONLY; The resource provider for the operation.
	Provider *string `json:"provider,omitempty"`
}

// OperationValueDisplayModel describes the properties of a Hybrid Compute Operation Value Display.
type OperationValueDisplayModel struct {
	// Operation - READ-ONLY; The display name of the compute operation.
	Operation *string `json:"operation,omitempty"`
	// Resource - READ-ONLY; The display name of the resource the operation applies to.
	Resource *string `json:"resource,omitempty"`
	// Description - READ-ONLY; The description of the operation.
	Description *string `json:"description,omitempty"`
	// Provider - READ-ONLY; The resource provider for the operation.
	Provider *string `json:"provider,omitempty"`
}

// OSProfile specifies the operating system settings for the hybrid machine.
type OSProfile struct {
	// ComputerName - READ-ONLY; Specifies the host OS name of the hybrid machine.
	ComputerName *string `json:"computerName,omitempty"`
}

// ProxyResource the resource model definition for a Azure Resource Manager proxy resource. It will not
// have tags and a location
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// TrackedResource the resource model definition for an Azure Resource Manager tracked top level resource
// which has 'tags' and a 'location'
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// UpdateResource the Update Resource model definition.
type UpdateResource struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for UpdateResource.
func (ur UpdateResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ur.Tags != nil {
		objectMap["tags"] = ur.Tags
	}
	return json.Marshal(objectMap)
}
