package keyvault

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ActionType enumerates the values for action type.
type ActionType string

const (
	// AutoRenew ...
	AutoRenew ActionType = "AutoRenew"
	// EmailContacts ...
	EmailContacts ActionType = "EmailContacts"
)

// PossibleActionTypeValues returns an array of possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{AutoRenew, EmailContacts}
}

// DeletionRecoveryLevel enumerates the values for deletion recovery level.
type DeletionRecoveryLevel string

const (
	// Purgeable Soft-delete is not enabled for this vault. A DELETE operation results in immediate and
	// irreversible data loss.
	Purgeable DeletionRecoveryLevel = "Purgeable"
	// Recoverable Soft-delete is enabled for this vault and purge has been disabled. A deleted entity will
	// remain in this state until recovered, or the end of the retention interval.
	Recoverable DeletionRecoveryLevel = "Recoverable"
	// RecoverableProtectedSubscription Soft-delete is enabled for this vault, and the subscription is
	// protected against immediate deletion.
	RecoverableProtectedSubscription DeletionRecoveryLevel = "Recoverable+ProtectedSubscription"
	// RecoverablePurgeable Soft-delete is enabled for this vault; A privileged user may trigger an immediate,
	// irreversible deletion(purge) of a deleted entity.
	RecoverablePurgeable DeletionRecoveryLevel = "Recoverable+Purgeable"
)

// PossibleDeletionRecoveryLevelValues returns an array of possible values for the DeletionRecoveryLevel const type.
func PossibleDeletionRecoveryLevelValues() []DeletionRecoveryLevel {
	return []DeletionRecoveryLevel{Purgeable, Recoverable, RecoverableProtectedSubscription, RecoverablePurgeable}
}

// JSONWebKeyCurveName enumerates the values for json web key curve name.
type JSONWebKeyCurveName string

const (
	// P256 The NIST P-256 elliptic curve, AKA SECG curve SECP256R1.
	P256 JSONWebKeyCurveName = "P-256"
	// P384 The NIST P-384 elliptic curve, AKA SECG curve SECP384R1.
	P384 JSONWebKeyCurveName = "P-384"
	// P521 The NIST P-521 elliptic curve, AKA SECG curve SECP521R1.
	P521 JSONWebKeyCurveName = "P-521"
	// SECP256K1 The SECG SECP256K1 elliptic curve.
	SECP256K1 JSONWebKeyCurveName = "SECP256K1"
)

// PossibleJSONWebKeyCurveNameValues returns an array of possible values for the JSONWebKeyCurveName const type.
func PossibleJSONWebKeyCurveNameValues() []JSONWebKeyCurveName {
	return []JSONWebKeyCurveName{P256, P384, P521, SECP256K1}
}

// JSONWebKeyEncryptionAlgorithm enumerates the values for json web key encryption algorithm.
type JSONWebKeyEncryptionAlgorithm string

const (
	// RSA15 ...
	RSA15 JSONWebKeyEncryptionAlgorithm = "RSA1_5"
	// RSAOAEP ...
	RSAOAEP JSONWebKeyEncryptionAlgorithm = "RSA-OAEP"
	// RSAOAEP256 ...
	RSAOAEP256 JSONWebKeyEncryptionAlgorithm = "RSA-OAEP-256"
)

// PossibleJSONWebKeyEncryptionAlgorithmValues returns an array of possible values for the JSONWebKeyEncryptionAlgorithm const type.
func PossibleJSONWebKeyEncryptionAlgorithmValues() []JSONWebKeyEncryptionAlgorithm {
	return []JSONWebKeyEncryptionAlgorithm{RSA15, RSAOAEP, RSAOAEP256}
}

// JSONWebKeyOperation enumerates the values for json web key operation.
type JSONWebKeyOperation string

const (
	// Decrypt ...
	Decrypt JSONWebKeyOperation = "decrypt"
	// Encrypt ...
	Encrypt JSONWebKeyOperation = "encrypt"
	// Sign ...
	Sign JSONWebKeyOperation = "sign"
	// UnwrapKey ...
	UnwrapKey JSONWebKeyOperation = "unwrapKey"
	// Verify ...
	Verify JSONWebKeyOperation = "verify"
	// WrapKey ...
	WrapKey JSONWebKeyOperation = "wrapKey"
)

// PossibleJSONWebKeyOperationValues returns an array of possible values for the JSONWebKeyOperation const type.
func PossibleJSONWebKeyOperationValues() []JSONWebKeyOperation {
	return []JSONWebKeyOperation{Decrypt, Encrypt, Sign, UnwrapKey, Verify, WrapKey}
}

// JSONWebKeySignatureAlgorithm enumerates the values for json web key signature algorithm.
type JSONWebKeySignatureAlgorithm string

const (
	// ECDSA256 ...
	ECDSA256 JSONWebKeySignatureAlgorithm = "ECDSA256"
	// ES256 ...
	ES256 JSONWebKeySignatureAlgorithm = "ES256"
	// ES384 ...
	ES384 JSONWebKeySignatureAlgorithm = "ES384"
	// ES512 ...
	ES512 JSONWebKeySignatureAlgorithm = "ES512"
	// PS256 ...
	PS256 JSONWebKeySignatureAlgorithm = "PS256"
	// PS384 ...
	PS384 JSONWebKeySignatureAlgorithm = "PS384"
	// PS512 ...
	PS512 JSONWebKeySignatureAlgorithm = "PS512"
	// RS256 ...
	RS256 JSONWebKeySignatureAlgorithm = "RS256"
	// RS384 ...
	RS384 JSONWebKeySignatureAlgorithm = "RS384"
	// RS512 ...
	RS512 JSONWebKeySignatureAlgorithm = "RS512"
	// RSNULL ...
	RSNULL JSONWebKeySignatureAlgorithm = "RSNULL"
)

// PossibleJSONWebKeySignatureAlgorithmValues returns an array of possible values for the JSONWebKeySignatureAlgorithm const type.
func PossibleJSONWebKeySignatureAlgorithmValues() []JSONWebKeySignatureAlgorithm {
	return []JSONWebKeySignatureAlgorithm{ECDSA256, ES256, ES384, ES512, PS256, PS384, PS512, RS256, RS384, RS512, RSNULL}
}

// JSONWebKeyType enumerates the values for json web key type.
type JSONWebKeyType string

const (
	// EC ...
	EC JSONWebKeyType = "EC"
	// ECHSM ...
	ECHSM JSONWebKeyType = "EC-HSM"
	// Oct ...
	Oct JSONWebKeyType = "oct"
	// RSA ...
	RSA JSONWebKeyType = "RSA"
	// RSAHSM ...
	RSAHSM JSONWebKeyType = "RSA-HSM"
)

// PossibleJSONWebKeyTypeValues returns an array of possible values for the JSONWebKeyType const type.
func PossibleJSONWebKeyTypeValues() []JSONWebKeyType {
	return []JSONWebKeyType{EC, ECHSM, Oct, RSA, RSAHSM}
}

// KeyUsageType enumerates the values for key usage type.
type KeyUsageType string

const (
	// CRLSign ...
	CRLSign KeyUsageType = "cRLSign"
	// DataEncipherment ...
	DataEncipherment KeyUsageType = "dataEncipherment"
	// DecipherOnly ...
	DecipherOnly KeyUsageType = "decipherOnly"
	// DigitalSignature ...
	DigitalSignature KeyUsageType = "digitalSignature"
	// EncipherOnly ...
	EncipherOnly KeyUsageType = "encipherOnly"
	// KeyAgreement ...
	KeyAgreement KeyUsageType = "keyAgreement"
	// KeyCertSign ...
	KeyCertSign KeyUsageType = "keyCertSign"
	// KeyEncipherment ...
	KeyEncipherment KeyUsageType = "keyEncipherment"
	// NonRepudiation ...
	NonRepudiation KeyUsageType = "nonRepudiation"
)

// PossibleKeyUsageTypeValues returns an array of possible values for the KeyUsageType const type.
func PossibleKeyUsageTypeValues() []KeyUsageType {
	return []KeyUsageType{CRLSign, DataEncipherment, DecipherOnly, DigitalSignature, EncipherOnly, KeyAgreement, KeyCertSign, KeyEncipherment, NonRepudiation}
}
