package network

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/network/mgmt/2016-06-01/network"

// AddressSpace addressSpace contains an array of IP address ranges that can be used by subnets
type AddressSpace struct {
	// AddressPrefixes - Gets or sets list of address blocks reserved for this virtual network in CIDR notation
	AddressPrefixes *[]string `json:"addressPrefixes,omitempty"`
}

// ApplicationGateway applicationGateways resource
type ApplicationGateway struct {
	autorest.Response                   `json:"-"`
	*ApplicationGatewayPropertiesFormat `json:"properties,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ApplicationGateway.
func (ag ApplicationGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ag.ApplicationGatewayPropertiesFormat != nil {
		objectMap["properties"] = ag.ApplicationGatewayPropertiesFormat
	}
	if ag.Etag != nil {
		objectMap["etag"] = ag.Etag
	}
	if ag.ID != nil {
		objectMap["id"] = ag.ID
	}
	if ag.Location != nil {
		objectMap["location"] = ag.Location
	}
	if ag.Tags != nil {
		objectMap["tags"] = ag.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGateway struct.
func (ag *ApplicationGateway) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayPropertiesFormat ApplicationGatewayPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayPropertiesFormat)
				if err != nil {
					return err
				}
				ag.ApplicationGatewayPropertiesFormat = &applicationGatewayPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ag.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ag.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ag.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ag.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ag.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ag.Tags = tags
			}
		}
	}

	return nil
}

// ApplicationGatewayAuthenticationCertificate authentication certificates of application gateway
type ApplicationGatewayAuthenticationCertificate struct {
	*ApplicationGatewayAuthenticationCertificatePropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayAuthenticationCertificate.
func (agac ApplicationGatewayAuthenticationCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agac.ApplicationGatewayAuthenticationCertificatePropertiesFormat != nil {
		objectMap["properties"] = agac.ApplicationGatewayAuthenticationCertificatePropertiesFormat
	}
	if agac.Name != nil {
		objectMap["name"] = agac.Name
	}
	if agac.Etag != nil {
		objectMap["etag"] = agac.Etag
	}
	if agac.ID != nil {
		objectMap["id"] = agac.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayAuthenticationCertificate struct.
func (agac *ApplicationGatewayAuthenticationCertificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayAuthenticationCertificatePropertiesFormat ApplicationGatewayAuthenticationCertificatePropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayAuthenticationCertificatePropertiesFormat)
				if err != nil {
					return err
				}
				agac.ApplicationGatewayAuthenticationCertificatePropertiesFormat = &applicationGatewayAuthenticationCertificatePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agac.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agac.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agac.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayAuthenticationCertificatePropertiesFormat properties of Authentication certificates of
// application gateway
type ApplicationGatewayAuthenticationCertificatePropertiesFormat struct {
	// Data - Certificate public data
	Data *string `json:"data,omitempty"`
	// ProvisioningState - Provisioning state of the authentication certificate resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewayBackendAddress backend Address of application gateway
type ApplicationGatewayBackendAddress struct {
	// Fqdn - Dns name
	Fqdn *string `json:"fqdn,omitempty"`
	// IPAddress - Ip address
	IPAddress *string `json:"ipAddress,omitempty"`
}

// ApplicationGatewayBackendAddressPool backend Address Pool of application gateway
type ApplicationGatewayBackendAddressPool struct {
	*ApplicationGatewayBackendAddressPoolPropertiesFormat `json:"properties,omitempty"`
	// Name - Resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayBackendAddressPool.
func (agbap ApplicationGatewayBackendAddressPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agbap.ApplicationGatewayBackendAddressPoolPropertiesFormat != nil {
		objectMap["properties"] = agbap.ApplicationGatewayBackendAddressPoolPropertiesFormat
	}
	if agbap.Name != nil {
		objectMap["name"] = agbap.Name
	}
	if agbap.Etag != nil {
		objectMap["etag"] = agbap.Etag
	}
	if agbap.ID != nil {
		objectMap["id"] = agbap.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayBackendAddressPool struct.
func (agbap *ApplicationGatewayBackendAddressPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayBackendAddressPoolPropertiesFormat ApplicationGatewayBackendAddressPoolPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayBackendAddressPoolPropertiesFormat)
				if err != nil {
					return err
				}
				agbap.ApplicationGatewayBackendAddressPoolPropertiesFormat = &applicationGatewayBackendAddressPoolPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agbap.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agbap.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agbap.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayBackendAddressPoolPropertiesFormat properties of Backend Address Pool of application
// gateway
type ApplicationGatewayBackendAddressPoolPropertiesFormat struct {
	// BackendIPConfigurations - Collection of references to IPs defined in NICs
	BackendIPConfigurations *[]InterfaceIPConfiguration `json:"backendIPConfigurations,omitempty"`
	// BackendAddresses - Backend addresses
	BackendAddresses *[]ApplicationGatewayBackendAddress `json:"backendAddresses,omitempty"`
	// ProvisioningState - Provisioning state of the backend address pool resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewayBackendHTTPSettings backend address pool settings of application gateway
type ApplicationGatewayBackendHTTPSettings struct {
	*ApplicationGatewayBackendHTTPSettingsPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayBackendHTTPSettings.
func (agbhs ApplicationGatewayBackendHTTPSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agbhs.ApplicationGatewayBackendHTTPSettingsPropertiesFormat != nil {
		objectMap["properties"] = agbhs.ApplicationGatewayBackendHTTPSettingsPropertiesFormat
	}
	if agbhs.Name != nil {
		objectMap["name"] = agbhs.Name
	}
	if agbhs.Etag != nil {
		objectMap["etag"] = agbhs.Etag
	}
	if agbhs.ID != nil {
		objectMap["id"] = agbhs.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayBackendHTTPSettings struct.
func (agbhs *ApplicationGatewayBackendHTTPSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayBackendHTTPSettingsPropertiesFormat ApplicationGatewayBackendHTTPSettingsPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayBackendHTTPSettingsPropertiesFormat)
				if err != nil {
					return err
				}
				agbhs.ApplicationGatewayBackendHTTPSettingsPropertiesFormat = &applicationGatewayBackendHTTPSettingsPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agbhs.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agbhs.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agbhs.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayBackendHTTPSettingsPropertiesFormat properties of Backend address pool settings of
// application gateway
type ApplicationGatewayBackendHTTPSettingsPropertiesFormat struct {
	// Port - Port
	Port *int32 `json:"port,omitempty"`
	// Protocol - Protocol. Possible values include: 'HTTP', 'HTTPS'
	Protocol ApplicationGatewayProtocol `json:"protocol,omitempty"`
	// CookieBasedAffinity - Cookie affinity. Possible values include: 'Enabled', 'Disabled'
	CookieBasedAffinity ApplicationGatewayCookieBasedAffinity `json:"cookieBasedAffinity,omitempty"`
	// RequestTimeout - Request timeout
	RequestTimeout *int32 `json:"requestTimeout,omitempty"`
	// Probe - Probe resource of application gateway
	Probe *SubResource `json:"probe,omitempty"`
	// AuthenticationCertificates - Array of references to Application Gateway Authentication Certificates
	AuthenticationCertificates *[]SubResource `json:"authenticationCertificates,omitempty"`
	// ProvisioningState - Provisioning state of the backend http settings resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewayFrontendIPConfiguration frontend IP configuration of application gateway
type ApplicationGatewayFrontendIPConfiguration struct {
	*ApplicationGatewayFrontendIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayFrontendIPConfiguration.
func (agfic ApplicationGatewayFrontendIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agfic.ApplicationGatewayFrontendIPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = agfic.ApplicationGatewayFrontendIPConfigurationPropertiesFormat
	}
	if agfic.Name != nil {
		objectMap["name"] = agfic.Name
	}
	if agfic.Etag != nil {
		objectMap["etag"] = agfic.Etag
	}
	if agfic.ID != nil {
		objectMap["id"] = agfic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayFrontendIPConfiguration struct.
func (agfic *ApplicationGatewayFrontendIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayFrontendIPConfigurationPropertiesFormat ApplicationGatewayFrontendIPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayFrontendIPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				agfic.ApplicationGatewayFrontendIPConfigurationPropertiesFormat = &applicationGatewayFrontendIPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agfic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agfic.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agfic.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayFrontendIPConfigurationPropertiesFormat properties of Frontend IP configuration of
// application gateway
type ApplicationGatewayFrontendIPConfigurationPropertiesFormat struct {
	// PrivateIPAddress - PrivateIPAddress of the Network Interface IP Configuration
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`
	// PrivateIPAllocationMethod - PrivateIP allocation method (Static/Dynamic). Possible values include: 'Static', 'Dynamic'
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	// Subnet - Reference of the subnet resource
	Subnet *SubResource `json:"subnet,omitempty"`
	// PublicIPAddress - Reference of the PublicIP resource
	PublicIPAddress *SubResource `json:"publicIPAddress,omitempty"`
	// ProvisioningState - Provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewayFrontendPort frontend Port of application gateway
type ApplicationGatewayFrontendPort struct {
	*ApplicationGatewayFrontendPortPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayFrontendPort.
func (agfp ApplicationGatewayFrontendPort) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agfp.ApplicationGatewayFrontendPortPropertiesFormat != nil {
		objectMap["properties"] = agfp.ApplicationGatewayFrontendPortPropertiesFormat
	}
	if agfp.Name != nil {
		objectMap["name"] = agfp.Name
	}
	if agfp.Etag != nil {
		objectMap["etag"] = agfp.Etag
	}
	if agfp.ID != nil {
		objectMap["id"] = agfp.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayFrontendPort struct.
func (agfp *ApplicationGatewayFrontendPort) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayFrontendPortPropertiesFormat ApplicationGatewayFrontendPortPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayFrontendPortPropertiesFormat)
				if err != nil {
					return err
				}
				agfp.ApplicationGatewayFrontendPortPropertiesFormat = &applicationGatewayFrontendPortPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agfp.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agfp.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agfp.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayFrontendPortPropertiesFormat properties of Frontend Port of application gateway
type ApplicationGatewayFrontendPortPropertiesFormat struct {
	// Port - Frontend port
	Port *int32 `json:"port,omitempty"`
	// ProvisioningState - Provisioning state of the frontend port resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewayHTTPListener http listener of application gateway
type ApplicationGatewayHTTPListener struct {
	*ApplicationGatewayHTTPListenerPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayHTTPListener.
func (aghl ApplicationGatewayHTTPListener) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aghl.ApplicationGatewayHTTPListenerPropertiesFormat != nil {
		objectMap["properties"] = aghl.ApplicationGatewayHTTPListenerPropertiesFormat
	}
	if aghl.Name != nil {
		objectMap["name"] = aghl.Name
	}
	if aghl.Etag != nil {
		objectMap["etag"] = aghl.Etag
	}
	if aghl.ID != nil {
		objectMap["id"] = aghl.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayHTTPListener struct.
func (aghl *ApplicationGatewayHTTPListener) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayHTTPListenerPropertiesFormat ApplicationGatewayHTTPListenerPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayHTTPListenerPropertiesFormat)
				if err != nil {
					return err
				}
				aghl.ApplicationGatewayHTTPListenerPropertiesFormat = &applicationGatewayHTTPListenerPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				aghl.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				aghl.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				aghl.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayHTTPListenerPropertiesFormat properties of Http listener of application gateway
type ApplicationGatewayHTTPListenerPropertiesFormat struct {
	// FrontendIPConfiguration - Frontend IP configuration resource of application gateway
	FrontendIPConfiguration *SubResource `json:"frontendIPConfiguration,omitempty"`
	// FrontendPort - Frontend port resource of application gateway
	FrontendPort *SubResource `json:"frontendPort,omitempty"`
	// Protocol - Protocol. Possible values include: 'HTTP', 'HTTPS'
	Protocol ApplicationGatewayProtocol `json:"protocol,omitempty"`
	// HostName - Host name of http listener
	HostName *string `json:"hostName,omitempty"`
	// SslCertificate - Ssl certificate resource of application gateway
	SslCertificate *SubResource `json:"sslCertificate,omitempty"`
	// RequireServerNameIndication - RequireServerNameIndication of http listener
	RequireServerNameIndication *bool `json:"requireServerNameIndication,omitempty"`
	// ProvisioningState - Provisioning state of the http listener resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewayIPConfiguration IP configuration of application gateway
type ApplicationGatewayIPConfiguration struct {
	*ApplicationGatewayIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayIPConfiguration.
func (agic ApplicationGatewayIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agic.ApplicationGatewayIPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = agic.ApplicationGatewayIPConfigurationPropertiesFormat
	}
	if agic.Name != nil {
		objectMap["name"] = agic.Name
	}
	if agic.Etag != nil {
		objectMap["etag"] = agic.Etag
	}
	if agic.ID != nil {
		objectMap["id"] = agic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayIPConfiguration struct.
func (agic *ApplicationGatewayIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayIPConfigurationPropertiesFormat ApplicationGatewayIPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayIPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				agic.ApplicationGatewayIPConfigurationPropertiesFormat = &applicationGatewayIPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agic.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agic.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayIPConfigurationPropertiesFormat properties of IP configuration of application gateway
type ApplicationGatewayIPConfigurationPropertiesFormat struct {
	// Subnet - Reference of the subnet resource. A subnet from where application gateway gets its private address
	Subnet *SubResource `json:"subnet,omitempty"`
	// ProvisioningState - Provisioning state of the application gateway subnet resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewayListResult response for ListApplicationGateways Api service call
type ApplicationGatewayListResult struct {
	autorest.Response `json:"-"`
	// Value - List of ApplicationGateways in a resource group
	Value *[]ApplicationGateway `json:"value,omitempty"`
	// NextLink - URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ApplicationGatewayListResultIterator provides access to a complete listing of ApplicationGateway values.
type ApplicationGatewayListResultIterator struct {
	i    int
	page ApplicationGatewayListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApplicationGatewayListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationGatewayListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ApplicationGatewayListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApplicationGatewayListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ApplicationGatewayListResultIterator) Response() ApplicationGatewayListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApplicationGatewayListResultIterator) Value() ApplicationGateway {
	if !iter.page.NotDone() {
		return ApplicationGateway{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ApplicationGatewayListResultIterator type.
func NewApplicationGatewayListResultIterator(page ApplicationGatewayListResultPage) ApplicationGatewayListResultIterator {
	return ApplicationGatewayListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (aglr ApplicationGatewayListResult) IsEmpty() bool {
	return aglr.Value == nil || len(*aglr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (aglr ApplicationGatewayListResult) hasNextLink() bool {
	return aglr.NextLink != nil && len(*aglr.NextLink) != 0
}

// applicationGatewayListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (aglr ApplicationGatewayListResult) applicationGatewayListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !aglr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(aglr.NextLink)))
}

// ApplicationGatewayListResultPage contains a page of ApplicationGateway values.
type ApplicationGatewayListResultPage struct {
	fn   func(context.Context, ApplicationGatewayListResult) (ApplicationGatewayListResult, error)
	aglr ApplicationGatewayListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApplicationGatewayListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationGatewayListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.aglr)
		if err != nil {
			return err
		}
		page.aglr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ApplicationGatewayListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApplicationGatewayListResultPage) NotDone() bool {
	return !page.aglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ApplicationGatewayListResultPage) Response() ApplicationGatewayListResult {
	return page.aglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ApplicationGatewayListResultPage) Values() []ApplicationGateway {
	if page.aglr.IsEmpty() {
		return nil
	}
	return *page.aglr.Value
}

// Creates a new instance of the ApplicationGatewayListResultPage type.
func NewApplicationGatewayListResultPage(cur ApplicationGatewayListResult, getNextPage func(context.Context, ApplicationGatewayListResult) (ApplicationGatewayListResult, error)) ApplicationGatewayListResultPage {
	return ApplicationGatewayListResultPage{
		fn:   getNextPage,
		aglr: cur,
	}
}

// ApplicationGatewayPathRule path rule of URL path map of application gateway
type ApplicationGatewayPathRule struct {
	*ApplicationGatewayPathRulePropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayPathRule.
func (agpr ApplicationGatewayPathRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agpr.ApplicationGatewayPathRulePropertiesFormat != nil {
		objectMap["properties"] = agpr.ApplicationGatewayPathRulePropertiesFormat
	}
	if agpr.Name != nil {
		objectMap["name"] = agpr.Name
	}
	if agpr.Etag != nil {
		objectMap["etag"] = agpr.Etag
	}
	if agpr.ID != nil {
		objectMap["id"] = agpr.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayPathRule struct.
func (agpr *ApplicationGatewayPathRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayPathRulePropertiesFormat ApplicationGatewayPathRulePropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayPathRulePropertiesFormat)
				if err != nil {
					return err
				}
				agpr.ApplicationGatewayPathRulePropertiesFormat = &applicationGatewayPathRulePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agpr.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agpr.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agpr.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayPathRulePropertiesFormat properties of probe of application gateway
type ApplicationGatewayPathRulePropertiesFormat struct {
	// Paths - Path rules of URL path map
	Paths *[]string `json:"paths,omitempty"`
	// BackendAddressPool - Backend address pool resource of URL path map
	BackendAddressPool *SubResource `json:"backendAddressPool,omitempty"`
	// BackendHTTPSettings - Backend http settings resource of URL path map
	BackendHTTPSettings *SubResource `json:"backendHttpSettings,omitempty"`
	// ProvisioningState - Path rule of URL path map resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewayProbe probe of application gateway
type ApplicationGatewayProbe struct {
	*ApplicationGatewayProbePropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayProbe.
func (agp ApplicationGatewayProbe) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agp.ApplicationGatewayProbePropertiesFormat != nil {
		objectMap["properties"] = agp.ApplicationGatewayProbePropertiesFormat
	}
	if agp.Name != nil {
		objectMap["name"] = agp.Name
	}
	if agp.Etag != nil {
		objectMap["etag"] = agp.Etag
	}
	if agp.ID != nil {
		objectMap["id"] = agp.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayProbe struct.
func (agp *ApplicationGatewayProbe) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayProbePropertiesFormat ApplicationGatewayProbePropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayProbePropertiesFormat)
				if err != nil {
					return err
				}
				agp.ApplicationGatewayProbePropertiesFormat = &applicationGatewayProbePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agp.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agp.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agp.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayProbePropertiesFormat properties of probe of application gateway
type ApplicationGatewayProbePropertiesFormat struct {
	// Protocol - Protocol. Possible values include: 'HTTP', 'HTTPS'
	Protocol ApplicationGatewayProtocol `json:"protocol,omitempty"`
	// Host - Host to send probe to
	Host *string `json:"host,omitempty"`
	// Path - Relative path of probe
	Path *string `json:"path,omitempty"`
	// Interval - Probing interval in seconds
	Interval *int32 `json:"interval,omitempty"`
	// Timeout - Probing timeout in seconds
	Timeout *int32 `json:"timeout,omitempty"`
	// UnhealthyThreshold - Probing unhealthy threshold
	UnhealthyThreshold *int32 `json:"unhealthyThreshold,omitempty"`
	// ProvisioningState - Provisioning state of the backend http settings resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewayPropertiesFormat properties of Application Gateway
type ApplicationGatewayPropertiesFormat struct {
	// Sku - Sku of application gateway resource
	Sku *ApplicationGatewaySku `json:"sku,omitempty"`
	// SslPolicy - SSL policy of application gateway resource
	SslPolicy *ApplicationGatewaySslPolicy `json:"sslPolicy,omitempty"`
	// OperationalState - READ-ONLY; Operational state of application gateway resource. Possible values include: 'Stopped', 'Starting', 'Running', 'Stopping'
	OperationalState ApplicationGatewayOperationalState `json:"operationalState,omitempty"`
	// GatewayIPConfigurations - Subnets of application gateway resource
	GatewayIPConfigurations *[]ApplicationGatewayIPConfiguration `json:"gatewayIPConfigurations,omitempty"`
	// AuthenticationCertificates - Authentication certificates of application gateway resource
	AuthenticationCertificates *[]ApplicationGatewayAuthenticationCertificate `json:"authenticationCertificates,omitempty"`
	// SslCertificates - SSL certificates of application gateway resource
	SslCertificates *[]ApplicationGatewaySslCertificate `json:"sslCertificates,omitempty"`
	// FrontendIPConfigurations - Frontend IP addresses of application gateway resource
	FrontendIPConfigurations *[]ApplicationGatewayFrontendIPConfiguration `json:"frontendIPConfigurations,omitempty"`
	// FrontendPorts - Frontend ports of application gateway resource
	FrontendPorts *[]ApplicationGatewayFrontendPort `json:"frontendPorts,omitempty"`
	// Probes - Probes of application gateway resource
	Probes *[]ApplicationGatewayProbe `json:"probes,omitempty"`
	// BackendAddressPools - Backend address pool of application gateway resource
	BackendAddressPools *[]ApplicationGatewayBackendAddressPool `json:"backendAddressPools,omitempty"`
	// BackendHTTPSettingsCollection - Backend http settings of application gateway resource
	BackendHTTPSettingsCollection *[]ApplicationGatewayBackendHTTPSettings `json:"backendHttpSettingsCollection,omitempty"`
	// HTTPListeners - HTTP listeners of application gateway resource
	HTTPListeners *[]ApplicationGatewayHTTPListener `json:"httpListeners,omitempty"`
	// URLPathMaps - URL path map of application gateway resource
	URLPathMaps *[]ApplicationGatewayURLPathMap `json:"urlPathMaps,omitempty"`
	// RequestRoutingRules - Request routing rules of application gateway resource
	RequestRoutingRules *[]ApplicationGatewayRequestRoutingRule `json:"requestRoutingRules,omitempty"`
	// ResourceGUID - Resource guid property of the ApplicationGateway resource
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - Provisioning state of the ApplicationGateway resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayPropertiesFormat.
func (agpf ApplicationGatewayPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agpf.Sku != nil {
		objectMap["sku"] = agpf.Sku
	}
	if agpf.SslPolicy != nil {
		objectMap["sslPolicy"] = agpf.SslPolicy
	}
	if agpf.GatewayIPConfigurations != nil {
		objectMap["gatewayIPConfigurations"] = agpf.GatewayIPConfigurations
	}
	if agpf.AuthenticationCertificates != nil {
		objectMap["authenticationCertificates"] = agpf.AuthenticationCertificates
	}
	if agpf.SslCertificates != nil {
		objectMap["sslCertificates"] = agpf.SslCertificates
	}
	if agpf.FrontendIPConfigurations != nil {
		objectMap["frontendIPConfigurations"] = agpf.FrontendIPConfigurations
	}
	if agpf.FrontendPorts != nil {
		objectMap["frontendPorts"] = agpf.FrontendPorts
	}
	if agpf.Probes != nil {
		objectMap["probes"] = agpf.Probes
	}
	if agpf.BackendAddressPools != nil {
		objectMap["backendAddressPools"] = agpf.BackendAddressPools
	}
	if agpf.BackendHTTPSettingsCollection != nil {
		objectMap["backendHttpSettingsCollection"] = agpf.BackendHTTPSettingsCollection
	}
	if agpf.HTTPListeners != nil {
		objectMap["httpListeners"] = agpf.HTTPListeners
	}
	if agpf.URLPathMaps != nil {
		objectMap["urlPathMaps"] = agpf.URLPathMaps
	}
	if agpf.RequestRoutingRules != nil {
		objectMap["requestRoutingRules"] = agpf.RequestRoutingRules
	}
	if agpf.ResourceGUID != nil {
		objectMap["resourceGuid"] = agpf.ResourceGUID
	}
	if agpf.ProvisioningState != nil {
		objectMap["provisioningState"] = agpf.ProvisioningState
	}
	return json.Marshal(objectMap)
}

// ApplicationGatewayRequestRoutingRule request routing rule of application gateway
type ApplicationGatewayRequestRoutingRule struct {
	*ApplicationGatewayRequestRoutingRulePropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayRequestRoutingRule.
func (agrrr ApplicationGatewayRequestRoutingRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agrrr.ApplicationGatewayRequestRoutingRulePropertiesFormat != nil {
		objectMap["properties"] = agrrr.ApplicationGatewayRequestRoutingRulePropertiesFormat
	}
	if agrrr.Name != nil {
		objectMap["name"] = agrrr.Name
	}
	if agrrr.Etag != nil {
		objectMap["etag"] = agrrr.Etag
	}
	if agrrr.ID != nil {
		objectMap["id"] = agrrr.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayRequestRoutingRule struct.
func (agrrr *ApplicationGatewayRequestRoutingRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayRequestRoutingRulePropertiesFormat ApplicationGatewayRequestRoutingRulePropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayRequestRoutingRulePropertiesFormat)
				if err != nil {
					return err
				}
				agrrr.ApplicationGatewayRequestRoutingRulePropertiesFormat = &applicationGatewayRequestRoutingRulePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agrrr.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agrrr.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agrrr.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayRequestRoutingRulePropertiesFormat properties of Request routing rule of application
// gateway
type ApplicationGatewayRequestRoutingRulePropertiesFormat struct {
	// RuleType - Rule type. Possible values include: 'Basic', 'PathBasedRouting'
	RuleType ApplicationGatewayRequestRoutingRuleType `json:"ruleType,omitempty"`
	// BackendAddressPool - Backend address pool resource of application gateway
	BackendAddressPool *SubResource `json:"backendAddressPool,omitempty"`
	// BackendHTTPSettings - Frontend port resource of application gateway
	BackendHTTPSettings *SubResource `json:"backendHttpSettings,omitempty"`
	// HTTPListener - Http listener resource of application gateway
	HTTPListener *SubResource `json:"httpListener,omitempty"`
	// URLPathMap - Url path map resource of application gateway
	URLPathMap *SubResource `json:"urlPathMap,omitempty"`
	// ProvisioningState - Provisioning state of the request routing rule resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewaysCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ApplicationGatewaysCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplicationGatewaysClient) (ApplicationGateway, error)
}

// ApplicationGatewaysDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ApplicationGatewaysDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplicationGatewaysClient) (autorest.Response, error)
}

// ApplicationGatewaySku SKU of application gateway
type ApplicationGatewaySku struct {
	// Name - Name of application gateway SKU. Possible values include: 'StandardSmall', 'StandardMedium', 'StandardLarge'
	Name ApplicationGatewaySkuName `json:"name,omitempty"`
	// Tier - Tier of application gateway. Possible values include: 'Standard'
	Tier ApplicationGatewayTier `json:"tier,omitempty"`
	// Capacity - Capacity (instance count) of application gateway
	Capacity *int32 `json:"capacity,omitempty"`
}

// ApplicationGatewaySslCertificate SSL certificates of application gateway
type ApplicationGatewaySslCertificate struct {
	*ApplicationGatewaySslCertificatePropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewaySslCertificate.
func (agsc ApplicationGatewaySslCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agsc.ApplicationGatewaySslCertificatePropertiesFormat != nil {
		objectMap["properties"] = agsc.ApplicationGatewaySslCertificatePropertiesFormat
	}
	if agsc.Name != nil {
		objectMap["name"] = agsc.Name
	}
	if agsc.Etag != nil {
		objectMap["etag"] = agsc.Etag
	}
	if agsc.ID != nil {
		objectMap["id"] = agsc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewaySslCertificate struct.
func (agsc *ApplicationGatewaySslCertificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewaySslCertificatePropertiesFormat ApplicationGatewaySslCertificatePropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewaySslCertificatePropertiesFormat)
				if err != nil {
					return err
				}
				agsc.ApplicationGatewaySslCertificatePropertiesFormat = &applicationGatewaySslCertificatePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agsc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agsc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agsc.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewaySslCertificatePropertiesFormat properties of SSL certificates of application gateway
type ApplicationGatewaySslCertificatePropertiesFormat struct {
	// Data - SSL Certificate data
	Data *string `json:"data,omitempty"`
	// Password - SSL Certificate password
	Password *string `json:"password,omitempty"`
	// PublicCertData - SSL Certificate public data
	PublicCertData *string `json:"publicCertData,omitempty"`
	// ProvisioningState - Provisioning state of the ssl certificate resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewaySslPolicy application gateway SSL policy
type ApplicationGatewaySslPolicy struct {
	// DisabledSslProtocols - SSL protocols to be disabled on Application Gateway
	DisabledSslProtocols *[]ApplicationGatewaySslProtocol `json:"disabledSslProtocols,omitempty"`
}

// ApplicationGatewaysStartFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ApplicationGatewaysStartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplicationGatewaysClient) (autorest.Response, error)
}

// ApplicationGatewaysStopFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ApplicationGatewaysStopFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplicationGatewaysClient) (autorest.Response, error)
}

// ApplicationGatewayURLPathMap urlPathMap of application gateway
type ApplicationGatewayURLPathMap struct {
	*ApplicationGatewayURLPathMapPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayURLPathMap.
func (agupm ApplicationGatewayURLPathMap) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agupm.ApplicationGatewayURLPathMapPropertiesFormat != nil {
		objectMap["properties"] = agupm.ApplicationGatewayURLPathMapPropertiesFormat
	}
	if agupm.Name != nil {
		objectMap["name"] = agupm.Name
	}
	if agupm.Etag != nil {
		objectMap["etag"] = agupm.Etag
	}
	if agupm.ID != nil {
		objectMap["id"] = agupm.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayURLPathMap struct.
func (agupm *ApplicationGatewayURLPathMap) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayURLPathMapPropertiesFormat ApplicationGatewayURLPathMapPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayURLPathMapPropertiesFormat)
				if err != nil {
					return err
				}
				agupm.ApplicationGatewayURLPathMapPropertiesFormat = &applicationGatewayURLPathMapPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agupm.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agupm.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agupm.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayURLPathMapPropertiesFormat properties of UrlPathMap of application gateway
type ApplicationGatewayURLPathMapPropertiesFormat struct {
	// DefaultBackendAddressPool - Default backend address pool resource of URL path map
	DefaultBackendAddressPool *SubResource `json:"defaultBackendAddressPool,omitempty"`
	// DefaultBackendHTTPSettings - Default backend http settings resource of URL path map
	DefaultBackendHTTPSettings *SubResource `json:"defaultBackendHttpSettings,omitempty"`
	// PathRules - Path rule of URL path map resource
	PathRules *[]ApplicationGatewayPathRule `json:"pathRules,omitempty"`
	// ProvisioningState - Provisioning state of the backend http settings resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// AuthorizationListResult response for ListAuthorizations Api service callRetrieves all authorizations
// that belongs to an ExpressRouteCircuit
type AuthorizationListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets the authorizations in an ExpressRoute Circuit
	Value *[]ExpressRouteCircuitAuthorization `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// AuthorizationListResultIterator provides access to a complete listing of
// ExpressRouteCircuitAuthorization values.
type AuthorizationListResultIterator struct {
	i    int
	page AuthorizationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AuthorizationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AuthorizationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AuthorizationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AuthorizationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AuthorizationListResultIterator) Response() AuthorizationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AuthorizationListResultIterator) Value() ExpressRouteCircuitAuthorization {
	if !iter.page.NotDone() {
		return ExpressRouteCircuitAuthorization{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AuthorizationListResultIterator type.
func NewAuthorizationListResultIterator(page AuthorizationListResultPage) AuthorizationListResultIterator {
	return AuthorizationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (alr AuthorizationListResult) IsEmpty() bool {
	return alr.Value == nil || len(*alr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (alr AuthorizationListResult) hasNextLink() bool {
	return alr.NextLink != nil && len(*alr.NextLink) != 0
}

// authorizationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (alr AuthorizationListResult) authorizationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !alr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(alr.NextLink)))
}

// AuthorizationListResultPage contains a page of ExpressRouteCircuitAuthorization values.
type AuthorizationListResultPage struct {
	fn  func(context.Context, AuthorizationListResult) (AuthorizationListResult, error)
	alr AuthorizationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AuthorizationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AuthorizationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.alr)
		if err != nil {
			return err
		}
		page.alr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AuthorizationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AuthorizationListResultPage) NotDone() bool {
	return !page.alr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AuthorizationListResultPage) Response() AuthorizationListResult {
	return page.alr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AuthorizationListResultPage) Values() []ExpressRouteCircuitAuthorization {
	if page.alr.IsEmpty() {
		return nil
	}
	return *page.alr.Value
}

// Creates a new instance of the AuthorizationListResultPage type.
func NewAuthorizationListResultPage(cur AuthorizationListResult, getNextPage func(context.Context, AuthorizationListResult) (AuthorizationListResult, error)) AuthorizationListResultPage {
	return AuthorizationListResultPage{
		fn:  getNextPage,
		alr: cur,
	}
}

// AuthorizationPropertiesFormat ...
type AuthorizationPropertiesFormat struct {
	// AuthorizationKey - Gets or sets the authorization key
	AuthorizationKey *string `json:"authorizationKey,omitempty"`
	// AuthorizationUseStatus - Gets or sets AuthorizationUseStatus. Possible values include: 'Available', 'InUse'
	AuthorizationUseStatus AuthorizationUseStatus `json:"authorizationUseStatus,omitempty"`
	// ProvisioningState - Gets provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// AzureAsyncOperationResult the response body contains the status of the specified asynchronous operation,
// indicating whether it has succeeded, is in progress, or has failed. Note that this status is distinct
// from the HTTP status code returned for the Get Operation Status operation itself. If the asynchronous
// operation succeeded, the response body includes the HTTP status code for the successful request. If the
// asynchronous operation failed, the response body includes the HTTP status code for the failed request
// and error information regarding the failure.
type AzureAsyncOperationResult struct {
	// Status - Status of the AzureAsyncOperation. Possible values include: 'InProgress', 'Succeeded', 'Failed'
	Status OperationStatus `json:"status,omitempty"`
	Error  *Error          `json:"error,omitempty"`
}

// BackendAddressPool pool of backend IP addresses
type BackendAddressPool struct {
	*BackendAddressPoolPropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for BackendAddressPool.
func (bap BackendAddressPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bap.BackendAddressPoolPropertiesFormat != nil {
		objectMap["properties"] = bap.BackendAddressPoolPropertiesFormat
	}
	if bap.Name != nil {
		objectMap["name"] = bap.Name
	}
	if bap.Etag != nil {
		objectMap["etag"] = bap.Etag
	}
	if bap.ID != nil {
		objectMap["id"] = bap.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BackendAddressPool struct.
func (bap *BackendAddressPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var backendAddressPoolPropertiesFormat BackendAddressPoolPropertiesFormat
				err = json.Unmarshal(*v, &backendAddressPoolPropertiesFormat)
				if err != nil {
					return err
				}
				bap.BackendAddressPoolPropertiesFormat = &backendAddressPoolPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bap.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				bap.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bap.ID = &ID
			}
		}
	}

	return nil
}

// BackendAddressPoolPropertiesFormat properties of BackendAddressPool
type BackendAddressPoolPropertiesFormat struct {
	// BackendIPConfigurations - READ-ONLY; Gets collection of references to IPs defined in NICs
	BackendIPConfigurations *[]InterfaceIPConfiguration `json:"backendIPConfigurations,omitempty"`
	// LoadBalancingRules - READ-ONLY; Gets Load Balancing rules that use this Backend Address Pool
	LoadBalancingRules *[]SubResource `json:"loadBalancingRules,omitempty"`
	// OutboundNatRule - READ-ONLY; Gets outbound rules that use this Backend Address Pool
	OutboundNatRule *SubResource `json:"outboundNatRule,omitempty"`
	// ProvisioningState - Get provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for BackendAddressPoolPropertiesFormat.
func (bappf BackendAddressPoolPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bappf.ProvisioningState != nil {
		objectMap["provisioningState"] = bappf.ProvisioningState
	}
	return json.Marshal(objectMap)
}

// BgpSettings ...
type BgpSettings struct {
	// Asn - Gets or sets this BGP speaker's ASN
	Asn *int64 `json:"asn,omitempty"`
	// BgpPeeringAddress - Gets or sets the BGP peering address and BGP identifier of this BGP speaker
	BgpPeeringAddress *string `json:"bgpPeeringAddress,omitempty"`
	// PeerWeight - Gets or sets the weight added to routes learned from this BGP speaker
	PeerWeight *int32 `json:"peerWeight,omitempty"`
}

// ConnectionResetSharedKey ...
type ConnectionResetSharedKey struct {
	autorest.Response `json:"-"`
	// KeyLength - The virtual network connection reset shared key length
	KeyLength *int64 `json:"keyLength,omitempty"`
}

// ConnectionSharedKey response for GetConnectionSharedKey Api service call
type ConnectionSharedKey struct {
	autorest.Response `json:"-"`
	// Value - The virtual network connection shared key value
	Value *string `json:"value,omitempty"`
}

// ConnectionSharedKeyResult response for CheckConnectionSharedKey Api service call
type ConnectionSharedKeyResult struct {
	autorest.Response `json:"-"`
	// Value - The virtual network connection shared key value
	Value *string `json:"value,omitempty"`
}

// DhcpOptions dHCPOptions contains an array of DNS servers available to VMs deployed in the virtual
// networkStandard DHCP option for a subnet overrides VNET DHCP options.
type DhcpOptions struct {
	// DNSServers - Gets or sets list of DNS servers IP addresses
	DNSServers *[]string `json:"dnsServers,omitempty"`
}

// DNSNameAvailabilityResult response for CheckDnsNameAvailability Api service call
type DNSNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	// Available - Domain availability (True/False)
	Available *bool `json:"available,omitempty"`
}

// EffectiveNetworkSecurityGroup effective NetworkSecurityGroup
type EffectiveNetworkSecurityGroup struct {
	// NetworkSecurityGroup - Gets the id of network security group that is applied
	NetworkSecurityGroup *SubResource                              `json:"networkSecurityGroup,omitempty"`
	Association          *EffectiveNetworkSecurityGroupAssociation `json:"association,omitempty"`
	// EffectiveSecurityRules - Gets collection of effective security rules
	EffectiveSecurityRules *[]EffectiveNetworkSecurityRule `json:"effectiveSecurityRules,omitempty"`
}

// EffectiveNetworkSecurityGroupAssociation effective NetworkSecurityGroup association
type EffectiveNetworkSecurityGroupAssociation struct {
	// Subnet - Gets the id of subnet if assigned
	Subnet *SubResource `json:"subnet,omitempty"`
	// NetworkInterface - Gets the id of network interface if assigned
	NetworkInterface *SubResource `json:"networkInterface,omitempty"`
}

// EffectiveNetworkSecurityGroupListResult response for list effective network security groups api service
// call
type EffectiveNetworkSecurityGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets list of effective network security groups
	Value *[]EffectiveNetworkSecurityGroup `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// EffectiveNetworkSecurityRule effective NetworkSecurityRules
type EffectiveNetworkSecurityRule struct {
	// Name - Gets the name of the security rule specified by the user (if created by the user)
	Name *string `json:"name,omitempty"`
	// Protocol - Gets Network protocol this rule applies to. Possible values include: 'TCP', 'UDP', 'Asterisk'
	Protocol SecurityRuleProtocol `json:"protocol,omitempty"`
	// SourcePortRange - Gets source port or range
	SourcePortRange *string `json:"sourcePortRange,omitempty"`
	// DestinationPortRange - Gets destination port or range
	DestinationPortRange *string `json:"destinationPortRange,omitempty"`
	// SourceAddressPrefix - Gets source address prefix
	SourceAddressPrefix *string `json:"sourceAddressPrefix,omitempty"`
	// DestinationAddressPrefix - Gets destination address prefix
	DestinationAddressPrefix *string `json:"destinationAddressPrefix,omitempty"`
	// ExpandedSourceAddressPrefix - Gets expanded source address prefix
	ExpandedSourceAddressPrefix *[]string `json:"expandedSourceAddressPrefix,omitempty"`
	// ExpandedDestinationAddressPrefix - Gets expanded destination address prefix
	ExpandedDestinationAddressPrefix *[]string `json:"expandedDestinationAddressPrefix,omitempty"`
	// Access - Gets network traffic is allowed or denied. Possible values include: 'Allow', 'Deny'
	Access SecurityRuleAccess `json:"access,omitempty"`
	// Priority - Gets the priority of the rule
	Priority *int32 `json:"priority,omitempty"`
	// Direction - Gets the direction of the rule. Possible values include: 'Inbound', 'Outbound'
	Direction SecurityRuleDirection `json:"direction,omitempty"`
}

// EffectiveRoute effective Route
type EffectiveRoute struct {
	// Name - Gets the name of the user defined route. This is optional.
	Name *string `json:"name,omitempty"`
	// Source - Gets who created the route. Possible values include: 'EffectiveRouteSourceUnknown', 'EffectiveRouteSourceUser', 'EffectiveRouteSourceVirtualNetworkGateway', 'EffectiveRouteSourceDefault'
	Source EffectiveRouteSource `json:"source,omitempty"`
	// State - Gets value of effective route. Possible values include: 'Active', 'Invalid'
	State EffectiveRouteState `json:"state,omitempty"`
	// AddressPrefix - Gets address prefixes of the effective routes in CIDR notation.
	AddressPrefix *[]string `json:"addressPrefix,omitempty"`
	// NextHopIPAddress - Gets the IP address of the next hop of the effective route
	NextHopIPAddress *[]string `json:"nextHopIpAddress,omitempty"`
	// NextHopType - Gets or sets the type of Azure hop the packet should be sent to. Possible values include: 'RouteNextHopTypeVirtualNetworkGateway', 'RouteNextHopTypeVnetLocal', 'RouteNextHopTypeInternet', 'RouteNextHopTypeVirtualAppliance', 'RouteNextHopTypeNone'
	NextHopType RouteNextHopType `json:"nextHopType,omitempty"`
}

// EffectiveRouteListResult response for list effective route api service call
type EffectiveRouteListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets list of effective routes
	Value *[]EffectiveRoute `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// Error ...
type Error struct {
	Code       *string         `json:"code,omitempty"`
	Message    *string         `json:"message,omitempty"`
	Target     *string         `json:"target,omitempty"`
	Details    *[]ErrorDetails `json:"details,omitempty"`
	InnerError *string         `json:"innerError,omitempty"`
}

// ErrorDetails ...
type ErrorDetails struct {
	Code    *string `json:"code,omitempty"`
	Target  *string `json:"target,omitempty"`
	Message *string `json:"message,omitempty"`
}

// ExpressRouteCircuit expressRouteCircuit resource
type ExpressRouteCircuit struct {
	autorest.Response `json:"-"`
	// Sku - Gets or sets sku
	Sku                                  *ExpressRouteCircuitSku `json:"sku,omitempty"`
	*ExpressRouteCircuitPropertiesFormat `json:"properties,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCircuit.
func (erc ExpressRouteCircuit) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erc.Sku != nil {
		objectMap["sku"] = erc.Sku
	}
	if erc.ExpressRouteCircuitPropertiesFormat != nil {
		objectMap["properties"] = erc.ExpressRouteCircuitPropertiesFormat
	}
	if erc.Etag != nil {
		objectMap["etag"] = erc.Etag
	}
	if erc.ID != nil {
		objectMap["id"] = erc.ID
	}
	if erc.Location != nil {
		objectMap["location"] = erc.Location
	}
	if erc.Tags != nil {
		objectMap["tags"] = erc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRouteCircuit struct.
func (erc *ExpressRouteCircuit) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku ExpressRouteCircuitSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				erc.Sku = &sku
			}
		case "properties":
			if v != nil {
				var expressRouteCircuitPropertiesFormat ExpressRouteCircuitPropertiesFormat
				err = json.Unmarshal(*v, &expressRouteCircuitPropertiesFormat)
				if err != nil {
					return err
				}
				erc.ExpressRouteCircuitPropertiesFormat = &expressRouteCircuitPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				erc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				erc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				erc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				erc.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				erc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				erc.Tags = tags
			}
		}
	}

	return nil
}

// ExpressRouteCircuitArpTable the arp table associated with the ExpressRouteCircuit
type ExpressRouteCircuitArpTable struct {
	// Age - Age.
	Age *int32 `json:"age,omitempty"`
	// Interface - Interface.
	Interface *string `json:"interface,omitempty"`
	// IPAddress - Gets ipAddress.
	IPAddress *string `json:"ipAddress,omitempty"`
	// MacAddress - Gets macAddress.
	MacAddress *string `json:"macAddress,omitempty"`
}

// ExpressRouteCircuitAuthorization authorization in a ExpressRouteCircuit resource
type ExpressRouteCircuitAuthorization struct {
	autorest.Response              `json:"-"`
	*AuthorizationPropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCircuitAuthorization.
func (erca ExpressRouteCircuitAuthorization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erca.AuthorizationPropertiesFormat != nil {
		objectMap["properties"] = erca.AuthorizationPropertiesFormat
	}
	if erca.Name != nil {
		objectMap["name"] = erca.Name
	}
	if erca.Etag != nil {
		objectMap["etag"] = erca.Etag
	}
	if erca.ID != nil {
		objectMap["id"] = erca.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRouteCircuitAuthorization struct.
func (erca *ExpressRouteCircuitAuthorization) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var authorizationPropertiesFormat AuthorizationPropertiesFormat
				err = json.Unmarshal(*v, &authorizationPropertiesFormat)
				if err != nil {
					return err
				}
				erca.AuthorizationPropertiesFormat = &authorizationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				erca.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				erca.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				erca.ID = &ID
			}
		}
	}

	return nil
}

// ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCircuitAuthorizationsClient) (ExpressRouteCircuitAuthorization, error)
}

// ExpressRouteCircuitAuthorizationsDeleteFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type ExpressRouteCircuitAuthorizationsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCircuitAuthorizationsClient) (autorest.Response, error)
}

// ExpressRouteCircuitListResult response for ListExpressRouteCircuit Api service call
type ExpressRouteCircuitListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets a list of ExpressRouteCircuits in a resource group
	Value *[]ExpressRouteCircuit `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRouteCircuitListResultIterator provides access to a complete listing of ExpressRouteCircuit
// values.
type ExpressRouteCircuitListResultIterator struct {
	i    int
	page ExpressRouteCircuitListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRouteCircuitListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteCircuitListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExpressRouteCircuitListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRouteCircuitListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExpressRouteCircuitListResultIterator) Response() ExpressRouteCircuitListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRouteCircuitListResultIterator) Value() ExpressRouteCircuit {
	if !iter.page.NotDone() {
		return ExpressRouteCircuit{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExpressRouteCircuitListResultIterator type.
func NewExpressRouteCircuitListResultIterator(page ExpressRouteCircuitListResultPage) ExpressRouteCircuitListResultIterator {
	return ExpressRouteCircuitListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (erclr ExpressRouteCircuitListResult) IsEmpty() bool {
	return erclr.Value == nil || len(*erclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (erclr ExpressRouteCircuitListResult) hasNextLink() bool {
	return erclr.NextLink != nil && len(*erclr.NextLink) != 0
}

// expressRouteCircuitListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (erclr ExpressRouteCircuitListResult) expressRouteCircuitListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !erclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(erclr.NextLink)))
}

// ExpressRouteCircuitListResultPage contains a page of ExpressRouteCircuit values.
type ExpressRouteCircuitListResultPage struct {
	fn    func(context.Context, ExpressRouteCircuitListResult) (ExpressRouteCircuitListResult, error)
	erclr ExpressRouteCircuitListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRouteCircuitListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteCircuitListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.erclr)
		if err != nil {
			return err
		}
		page.erclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExpressRouteCircuitListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRouteCircuitListResultPage) NotDone() bool {
	return !page.erclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExpressRouteCircuitListResultPage) Response() ExpressRouteCircuitListResult {
	return page.erclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRouteCircuitListResultPage) Values() []ExpressRouteCircuit {
	if page.erclr.IsEmpty() {
		return nil
	}
	return *page.erclr.Value
}

// Creates a new instance of the ExpressRouteCircuitListResultPage type.
func NewExpressRouteCircuitListResultPage(cur ExpressRouteCircuitListResult, getNextPage func(context.Context, ExpressRouteCircuitListResult) (ExpressRouteCircuitListResult, error)) ExpressRouteCircuitListResultPage {
	return ExpressRouteCircuitListResultPage{
		fn:    getNextPage,
		erclr: cur,
	}
}

// ExpressRouteCircuitPeering peering in a ExpressRouteCircuit resource
type ExpressRouteCircuitPeering struct {
	autorest.Response                           `json:"-"`
	*ExpressRouteCircuitPeeringPropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCircuitPeering.
func (ercp ExpressRouteCircuitPeering) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ercp.ExpressRouteCircuitPeeringPropertiesFormat != nil {
		objectMap["properties"] = ercp.ExpressRouteCircuitPeeringPropertiesFormat
	}
	if ercp.Name != nil {
		objectMap["name"] = ercp.Name
	}
	if ercp.Etag != nil {
		objectMap["etag"] = ercp.Etag
	}
	if ercp.ID != nil {
		objectMap["id"] = ercp.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRouteCircuitPeering struct.
func (ercp *ExpressRouteCircuitPeering) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var expressRouteCircuitPeeringPropertiesFormat ExpressRouteCircuitPeeringPropertiesFormat
				err = json.Unmarshal(*v, &expressRouteCircuitPeeringPropertiesFormat)
				if err != nil {
					return err
				}
				ercp.ExpressRouteCircuitPeeringPropertiesFormat = &expressRouteCircuitPeeringPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ercp.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ercp.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ercp.ID = &ID
			}
		}
	}

	return nil
}

// ExpressRouteCircuitPeeringConfig specifies the peering config
type ExpressRouteCircuitPeeringConfig struct {
	// AdvertisedPublicPrefixes - Gets or sets the reference of AdvertisedPublicPrefixes
	AdvertisedPublicPrefixes *[]string `json:"advertisedPublicPrefixes,omitempty"`
	// AdvertisedPublicPrefixesState - Gets or sets AdvertisedPublicPrefixState of the Peering resource. Possible values include: 'NotConfigured', 'Configuring', 'Configured', 'ValidationNeeded'
	AdvertisedPublicPrefixesState ExpressRouteCircuitPeeringAdvertisedPublicPrefixState `json:"advertisedPublicPrefixesState,omitempty"`
	// CustomerASN - Gets or Sets CustomerAsn of the peering.
	CustomerASN *int32 `json:"customerASN,omitempty"`
	// RoutingRegistryName - Gets or Sets RoutingRegistryName of the config.
	RoutingRegistryName *string `json:"routingRegistryName,omitempty"`
}

// ExpressRouteCircuitPeeringListResult response for ListPeering Api service callRetrieves all Peerings
// that belongs to an ExpressRouteCircuit
type ExpressRouteCircuitPeeringListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets the peerings in an express route circuit
	Value *[]ExpressRouteCircuitPeering `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRouteCircuitPeeringListResultIterator provides access to a complete listing of
// ExpressRouteCircuitPeering values.
type ExpressRouteCircuitPeeringListResultIterator struct {
	i    int
	page ExpressRouteCircuitPeeringListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRouteCircuitPeeringListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteCircuitPeeringListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExpressRouteCircuitPeeringListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRouteCircuitPeeringListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExpressRouteCircuitPeeringListResultIterator) Response() ExpressRouteCircuitPeeringListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRouteCircuitPeeringListResultIterator) Value() ExpressRouteCircuitPeering {
	if !iter.page.NotDone() {
		return ExpressRouteCircuitPeering{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExpressRouteCircuitPeeringListResultIterator type.
func NewExpressRouteCircuitPeeringListResultIterator(page ExpressRouteCircuitPeeringListResultPage) ExpressRouteCircuitPeeringListResultIterator {
	return ExpressRouteCircuitPeeringListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ercplr ExpressRouteCircuitPeeringListResult) IsEmpty() bool {
	return ercplr.Value == nil || len(*ercplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ercplr ExpressRouteCircuitPeeringListResult) hasNextLink() bool {
	return ercplr.NextLink != nil && len(*ercplr.NextLink) != 0
}

// expressRouteCircuitPeeringListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ercplr ExpressRouteCircuitPeeringListResult) expressRouteCircuitPeeringListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ercplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ercplr.NextLink)))
}

// ExpressRouteCircuitPeeringListResultPage contains a page of ExpressRouteCircuitPeering values.
type ExpressRouteCircuitPeeringListResultPage struct {
	fn     func(context.Context, ExpressRouteCircuitPeeringListResult) (ExpressRouteCircuitPeeringListResult, error)
	ercplr ExpressRouteCircuitPeeringListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRouteCircuitPeeringListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteCircuitPeeringListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ercplr)
		if err != nil {
			return err
		}
		page.ercplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExpressRouteCircuitPeeringListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRouteCircuitPeeringListResultPage) NotDone() bool {
	return !page.ercplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExpressRouteCircuitPeeringListResultPage) Response() ExpressRouteCircuitPeeringListResult {
	return page.ercplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRouteCircuitPeeringListResultPage) Values() []ExpressRouteCircuitPeering {
	if page.ercplr.IsEmpty() {
		return nil
	}
	return *page.ercplr.Value
}

// Creates a new instance of the ExpressRouteCircuitPeeringListResultPage type.
func NewExpressRouteCircuitPeeringListResultPage(cur ExpressRouteCircuitPeeringListResult, getNextPage func(context.Context, ExpressRouteCircuitPeeringListResult) (ExpressRouteCircuitPeeringListResult, error)) ExpressRouteCircuitPeeringListResultPage {
	return ExpressRouteCircuitPeeringListResultPage{
		fn:     getNextPage,
		ercplr: cur,
	}
}

// ExpressRouteCircuitPeeringPropertiesFormat ...
type ExpressRouteCircuitPeeringPropertiesFormat struct {
	// PeeringType - Gets or sets PeeringType. Possible values include: 'AzurePublicPeering', 'AzurePrivatePeering', 'MicrosoftPeering'
	PeeringType ExpressRouteCircuitPeeringType `json:"peeringType,omitempty"`
	// State - Gets or sets state of Peering. Possible values include: 'ExpressRouteCircuitPeeringStateDisabled', 'ExpressRouteCircuitPeeringStateEnabled'
	State ExpressRouteCircuitPeeringState `json:"state,omitempty"`
	// AzureASN - Gets or sets the azure ASN
	AzureASN *int32 `json:"azureASN,omitempty"`
	// PeerASN - Gets or sets the peer ASN
	PeerASN *int32 `json:"peerASN,omitempty"`
	// PrimaryPeerAddressPrefix - Gets or sets the primary address prefix
	PrimaryPeerAddressPrefix *string `json:"primaryPeerAddressPrefix,omitempty"`
	// SecondaryPeerAddressPrefix - Gets or sets the secondary address prefix
	SecondaryPeerAddressPrefix *string `json:"secondaryPeerAddressPrefix,omitempty"`
	// PrimaryAzurePort - Gets or sets the primary port
	PrimaryAzurePort *string `json:"primaryAzurePort,omitempty"`
	// SecondaryAzurePort - Gets or sets the secondary port
	SecondaryAzurePort *string `json:"secondaryAzurePort,omitempty"`
	// SharedKey - Gets or sets the shared key
	SharedKey *string `json:"sharedKey,omitempty"`
	// VlanID - Gets or sets the vlan id
	VlanID *int32 `json:"vlanId,omitempty"`
	// MicrosoftPeeringConfig - Gets or sets the Microsoft peering config
	MicrosoftPeeringConfig *ExpressRouteCircuitPeeringConfig `json:"microsoftPeeringConfig,omitempty"`
	// Stats - Gets or peering stats
	Stats *ExpressRouteCircuitStats `json:"stats,omitempty"`
	// ProvisioningState - Gets provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// GatewayManagerEtag - Gets or sets the GatewayManager Etag
	GatewayManagerEtag *string `json:"gatewayManagerEtag,omitempty"`
	// LastModifiedBy - Gets whether the provider or the customer last modified the peering
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
}

// ExpressRouteCircuitPeeringsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type ExpressRouteCircuitPeeringsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCircuitPeeringsClient) (ExpressRouteCircuitPeering, error)
}

// ExpressRouteCircuitPeeringsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteCircuitPeeringsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCircuitPeeringsClient) (autorest.Response, error)
}

// ExpressRouteCircuitPropertiesFormat properties of ExpressRouteCircuit
type ExpressRouteCircuitPropertiesFormat struct {
	// AllowClassicOperations - allow classic operations
	AllowClassicOperations *bool `json:"allowClassicOperations,omitempty"`
	// CircuitProvisioningState - Gets or sets CircuitProvisioningState state of the resource
	CircuitProvisioningState *string `json:"circuitProvisioningState,omitempty"`
	// ServiceProviderProvisioningState - Gets or sets ServiceProviderProvisioningState state of the resource. Possible values include: 'NotProvisioned', 'Provisioning', 'Provisioned', 'Deprovisioning'
	ServiceProviderProvisioningState ServiceProviderProvisioningState `json:"serviceProviderProvisioningState,omitempty"`
	// Authorizations - Gets or sets list of authorizations
	Authorizations *[]ExpressRouteCircuitAuthorization `json:"authorizations,omitempty"`
	// Peerings - Gets or sets list of peerings
	Peerings *[]ExpressRouteCircuitPeering `json:"peerings,omitempty"`
	// ServiceKey - Gets or sets ServiceKey
	ServiceKey *string `json:"serviceKey,omitempty"`
	// ServiceProviderNotes - Gets or sets ServiceProviderNotes
	ServiceProviderNotes *string `json:"serviceProviderNotes,omitempty"`
	// ServiceProviderProperties - Gets or sets ServiceProviderProperties
	ServiceProviderProperties *ExpressRouteCircuitServiceProviderProperties `json:"serviceProviderProperties,omitempty"`
	// ProvisioningState - Gets provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// GatewayManagerEtag - Gets or sets the GatewayManager Etag
	GatewayManagerEtag *string `json:"gatewayManagerEtag,omitempty"`
}

// ExpressRouteCircuitRoutesTable the routes table associated with the ExpressRouteCircuit
type ExpressRouteCircuitRoutesTable struct {
	// NetworkProperty - network.
	NetworkProperty *string `json:"network,omitempty"`
	// NextHop - nextHop
	NextHop *string `json:"nextHop,omitempty"`
	// LocPrf - locPrf.
	LocPrf *string `json:"locPrf,omitempty"`
	// Weight - weight.
	Weight *int32 `json:"weight,omitempty"`
	// Path - path .
	Path *string `json:"path,omitempty"`
}

// ExpressRouteCircuitRoutesTableSummary the routes table associated with the ExpressRouteCircuit
type ExpressRouteCircuitRoutesTableSummary struct {
	// Neighbor - Neighbor.
	Neighbor *string `json:"neighbor,omitempty"`
	// V - BGP version number spoken to the neighbor.
	V *int32 `json:"v,omitempty"`
	// As - Autonomous system number.
	As *int32 `json:"as,omitempty"`
	// UpDown - The length of time that the BGP session has been in the Established state, or the current status if not in the Established state.
	UpDown *string `json:"upDown,omitempty"`
	// StatePfxRcd - Current state of the BGP session, and the number of prefixes that have been received from a neighbor or peer group.
	StatePfxRcd *string `json:"statePfxRcd,omitempty"`
}

// ExpressRouteCircuitsArpTableListResult response for ListArpTable associated with the Express Route
// Circuits Api
type ExpressRouteCircuitsArpTableListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets List of ArpTable
	Value *[]ExpressRouteCircuitArpTable `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRouteCircuitsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteCircuitsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCircuitsClient) (ExpressRouteCircuit, error)
}

// ExpressRouteCircuitsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteCircuitsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCircuitsClient) (autorest.Response, error)
}

// ExpressRouteCircuitServiceProviderProperties contains ServiceProviderProperties in an
// ExpressRouteCircuit
type ExpressRouteCircuitServiceProviderProperties struct {
	// ServiceProviderName - Gets or sets serviceProviderName.
	ServiceProviderName *string `json:"serviceProviderName,omitempty"`
	// PeeringLocation - Gets or sets peering location.
	PeeringLocation *string `json:"peeringLocation,omitempty"`
	// BandwidthInMbps - Gets or sets BandwidthInMbps.
	BandwidthInMbps *int32 `json:"bandwidthInMbps,omitempty"`
}

// ExpressRouteCircuitSku contains sku in an ExpressRouteCircuit
type ExpressRouteCircuitSku struct {
	// Name - Gets or sets name of the sku.
	Name *string `json:"name,omitempty"`
	// Tier - Gets or sets tier of the sku. Possible values include: 'ExpressRouteCircuitSkuTierStandard', 'ExpressRouteCircuitSkuTierPremium'
	Tier ExpressRouteCircuitSkuTier `json:"tier,omitempty"`
	// Family - Gets or sets family of the sku. Possible values include: 'UnlimitedData', 'MeteredData'
	Family ExpressRouteCircuitSkuFamily `json:"family,omitempty"`
}

// ExpressRouteCircuitsListArpTableFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteCircuitsListArpTableFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCircuitsClient) (ExpressRouteCircuitsArpTableListResult, error)
}

// ExpressRouteCircuitsListRoutesTableFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteCircuitsListRoutesTableFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCircuitsClient) (ExpressRouteCircuitsRoutesTableListResult, error)
}

// ExpressRouteCircuitsListRoutesTableSummaryFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ExpressRouteCircuitsListRoutesTableSummaryFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCircuitsClient) (ExpressRouteCircuitsRoutesTableSummaryListResult, error)
}

// ExpressRouteCircuitsRoutesTableListResult response for ListRoutesTable associated with the Express Route
// Circuits Api
type ExpressRouteCircuitsRoutesTableListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets List of RoutesTable
	Value *[]ExpressRouteCircuitRoutesTable `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRouteCircuitsRoutesTableSummaryListResult response for ListRoutesTable associated with the
// Express Route Circuits Api
type ExpressRouteCircuitsRoutesTableSummaryListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets List of RoutesTable
	Value *[]ExpressRouteCircuitRoutesTableSummary `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRouteCircuitStats contains Stats associated with the peering
type ExpressRouteCircuitStats struct {
	autorest.Response `json:"-"`
	// PrimarybytesIn - Gets BytesIn of the peering.
	PrimarybytesIn *int64 `json:"primarybytesIn,omitempty"`
	// PrimarybytesOut - Gets BytesOut of the peering.
	PrimarybytesOut *int64 `json:"primarybytesOut,omitempty"`
	// SecondarybytesIn - Gets BytesIn of the peering.
	SecondarybytesIn *int64 `json:"secondarybytesIn,omitempty"`
	// SecondarybytesOut - Gets BytesOut of the peering.
	SecondarybytesOut *int64 `json:"secondarybytesOut,omitempty"`
}

// ExpressRouteServiceProvider expressRouteResourceProvider object
type ExpressRouteServiceProvider struct {
	*ExpressRouteServiceProviderPropertiesFormat `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ExpressRouteServiceProvider.
func (ersp ExpressRouteServiceProvider) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ersp.ExpressRouteServiceProviderPropertiesFormat != nil {
		objectMap["properties"] = ersp.ExpressRouteServiceProviderPropertiesFormat
	}
	if ersp.ID != nil {
		objectMap["id"] = ersp.ID
	}
	if ersp.Location != nil {
		objectMap["location"] = ersp.Location
	}
	if ersp.Tags != nil {
		objectMap["tags"] = ersp.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRouteServiceProvider struct.
func (ersp *ExpressRouteServiceProvider) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var expressRouteServiceProviderPropertiesFormat ExpressRouteServiceProviderPropertiesFormat
				err = json.Unmarshal(*v, &expressRouteServiceProviderPropertiesFormat)
				if err != nil {
					return err
				}
				ersp.ExpressRouteServiceProviderPropertiesFormat = &expressRouteServiceProviderPropertiesFormat
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ersp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ersp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ersp.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ersp.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ersp.Tags = tags
			}
		}
	}

	return nil
}

// ExpressRouteServiceProviderBandwidthsOffered contains Bandwidths offered in ExpressRouteServiceProviders
type ExpressRouteServiceProviderBandwidthsOffered struct {
	// OfferName - Gets the OfferName
	OfferName *string `json:"offerName,omitempty"`
	// ValueInMbps - Gets the ValueInMbps.
	ValueInMbps *int32 `json:"valueInMbps,omitempty"`
}

// ExpressRouteServiceProviderListResult response for ListExpressRouteServiceProvider Api service call
type ExpressRouteServiceProviderListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets List of ExpressRouteResourceProvider
	Value *[]ExpressRouteServiceProvider `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRouteServiceProviderListResultIterator provides access to a complete listing of
// ExpressRouteServiceProvider values.
type ExpressRouteServiceProviderListResultIterator struct {
	i    int
	page ExpressRouteServiceProviderListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRouteServiceProviderListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteServiceProviderListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExpressRouteServiceProviderListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRouteServiceProviderListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExpressRouteServiceProviderListResultIterator) Response() ExpressRouteServiceProviderListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRouteServiceProviderListResultIterator) Value() ExpressRouteServiceProvider {
	if !iter.page.NotDone() {
		return ExpressRouteServiceProvider{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExpressRouteServiceProviderListResultIterator type.
func NewExpressRouteServiceProviderListResultIterator(page ExpressRouteServiceProviderListResultPage) ExpressRouteServiceProviderListResultIterator {
	return ExpressRouteServiceProviderListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ersplr ExpressRouteServiceProviderListResult) IsEmpty() bool {
	return ersplr.Value == nil || len(*ersplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ersplr ExpressRouteServiceProviderListResult) hasNextLink() bool {
	return ersplr.NextLink != nil && len(*ersplr.NextLink) != 0
}

// expressRouteServiceProviderListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ersplr ExpressRouteServiceProviderListResult) expressRouteServiceProviderListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ersplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ersplr.NextLink)))
}

// ExpressRouteServiceProviderListResultPage contains a page of ExpressRouteServiceProvider values.
type ExpressRouteServiceProviderListResultPage struct {
	fn     func(context.Context, ExpressRouteServiceProviderListResult) (ExpressRouteServiceProviderListResult, error)
	ersplr ExpressRouteServiceProviderListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRouteServiceProviderListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteServiceProviderListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ersplr)
		if err != nil {
			return err
		}
		page.ersplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExpressRouteServiceProviderListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRouteServiceProviderListResultPage) NotDone() bool {
	return !page.ersplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExpressRouteServiceProviderListResultPage) Response() ExpressRouteServiceProviderListResult {
	return page.ersplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRouteServiceProviderListResultPage) Values() []ExpressRouteServiceProvider {
	if page.ersplr.IsEmpty() {
		return nil
	}
	return *page.ersplr.Value
}

// Creates a new instance of the ExpressRouteServiceProviderListResultPage type.
func NewExpressRouteServiceProviderListResultPage(cur ExpressRouteServiceProviderListResult, getNextPage func(context.Context, ExpressRouteServiceProviderListResult) (ExpressRouteServiceProviderListResult, error)) ExpressRouteServiceProviderListResultPage {
	return ExpressRouteServiceProviderListResultPage{
		fn:     getNextPage,
		ersplr: cur,
	}
}

// ExpressRouteServiceProviderPropertiesFormat properties of ExpressRouteServiceProvider
type ExpressRouteServiceProviderPropertiesFormat struct {
	// PeeringLocations - Gets or list of peering locations
	PeeringLocations *[]string `json:"peeringLocations,omitempty"`
	// BandwidthsOffered - Gets or bandwidths offered
	BandwidthsOffered *[]ExpressRouteServiceProviderBandwidthsOffered `json:"bandwidthsOffered,omitempty"`
	// ProvisioningState - Gets provisioning state of the resource
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// FrontendIPConfiguration frontend IP address of the load balancer
type FrontendIPConfiguration struct {
	*FrontendIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for FrontendIPConfiguration.
func (fic FrontendIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fic.FrontendIPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = fic.FrontendIPConfigurationPropertiesFormat
	}
	if fic.Name != nil {
		objectMap["name"] = fic.Name
	}
	if fic.Etag != nil {
		objectMap["etag"] = fic.Etag
	}
	if fic.ID != nil {
		objectMap["id"] = fic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FrontendIPConfiguration struct.
func (fic *FrontendIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var frontendIPConfigurationPropertiesFormat FrontendIPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &frontendIPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				fic.FrontendIPConfigurationPropertiesFormat = &frontendIPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				fic.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fic.ID = &ID
			}
		}
	}

	return nil
}

// FrontendIPConfigurationPropertiesFormat properties of Frontend IP Configuration of the load balancer
type FrontendIPConfigurationPropertiesFormat struct {
	// InboundNatRules - READ-ONLY; Read only. Inbound rules URIs that use this frontend IP
	InboundNatRules *[]SubResource `json:"inboundNatRules,omitempty"`
	// InboundNatPools - READ-ONLY; Read only. Inbound pools URIs that use this frontend IP
	InboundNatPools *[]SubResource `json:"inboundNatPools,omitempty"`
	// OutboundNatRules - READ-ONLY; Read only. Outbound rules URIs that use this frontend IP
	OutboundNatRules *[]SubResource `json:"outboundNatRules,omitempty"`
	// LoadBalancingRules - READ-ONLY; Gets Load Balancing rules URIs that use this frontend IP
	LoadBalancingRules *[]SubResource `json:"loadBalancingRules,omitempty"`
	// PrivateIPAddress - Gets or sets the privateIPAddress of the IP Configuration
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`
	// PrivateIPAllocationMethod - Gets or sets PrivateIP allocation method. Possible values include: 'Static', 'Dynamic'
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	// Subnet - Gets or sets the reference of the subnet resource
	Subnet *Subnet `json:"subnet,omitempty"`
	// PublicIPAddress - Gets or sets the reference of the PublicIP resource
	PublicIPAddress *PublicIPAddress `json:"publicIPAddress,omitempty"`
	// ProvisioningState - Gets provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for FrontendIPConfigurationPropertiesFormat.
func (ficpf FrontendIPConfigurationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ficpf.PrivateIPAddress != nil {
		objectMap["privateIPAddress"] = ficpf.PrivateIPAddress
	}
	if ficpf.PrivateIPAllocationMethod != "" {
		objectMap["privateIPAllocationMethod"] = ficpf.PrivateIPAllocationMethod
	}
	if ficpf.Subnet != nil {
		objectMap["subnet"] = ficpf.Subnet
	}
	if ficpf.PublicIPAddress != nil {
		objectMap["publicIPAddress"] = ficpf.PublicIPAddress
	}
	if ficpf.ProvisioningState != nil {
		objectMap["provisioningState"] = ficpf.ProvisioningState
	}
	return json.Marshal(objectMap)
}

// InboundNatPool inbound NAT pool of the load balancer
type InboundNatPool struct {
	*InboundNatPoolPropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for InboundNatPool.
func (inp InboundNatPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if inp.InboundNatPoolPropertiesFormat != nil {
		objectMap["properties"] = inp.InboundNatPoolPropertiesFormat
	}
	if inp.Name != nil {
		objectMap["name"] = inp.Name
	}
	if inp.Etag != nil {
		objectMap["etag"] = inp.Etag
	}
	if inp.ID != nil {
		objectMap["id"] = inp.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InboundNatPool struct.
func (inp *InboundNatPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var inboundNatPoolPropertiesFormat InboundNatPoolPropertiesFormat
				err = json.Unmarshal(*v, &inboundNatPoolPropertiesFormat)
				if err != nil {
					return err
				}
				inp.InboundNatPoolPropertiesFormat = &inboundNatPoolPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				inp.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				inp.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				inp.ID = &ID
			}
		}
	}

	return nil
}

// InboundNatPoolPropertiesFormat properties of Inbound NAT pool
type InboundNatPoolPropertiesFormat struct {
	// FrontendIPConfiguration - Gets or sets a reference to frontend IP Addresses
	FrontendIPConfiguration *SubResource `json:"frontendIPConfiguration,omitempty"`
	// Protocol - Gets or sets the transport protocol for the endpoint. Possible values are Udp or Tcp. Possible values include: 'TransportProtocolUDP', 'TransportProtocolTCP'
	Protocol TransportProtocol `json:"protocol,omitempty"`
	// FrontendPortRangeStart - Gets or sets the starting port range for the NAT pool. You can specify any port number you choose, but the port numbers specified for each role in the service must be unique. Possible values range between 1 and 65535, inclusive
	FrontendPortRangeStart *int32 `json:"frontendPortRangeStart,omitempty"`
	// FrontendPortRangeEnd - Gets or sets the ending port range for the NAT pool. You can specify any port number you choose, but the port numbers specified for each role in the service must be unique. Possible values range between 1 and 65535, inclusive
	FrontendPortRangeEnd *int32 `json:"frontendPortRangeEnd,omitempty"`
	// BackendPort - Gets or sets a port used for internal connections on the endpoint. The localPort attribute maps the eternal port of the endpoint to an internal port on a role. This is useful in scenarios where a role must communicate to an internal component on a port that is different from the one that is exposed externally. If not specified, the value of localPort is the same as the port attribute. Set the value of localPort to '*' to automatically assign an unallocated port that is discoverable using the runtime API
	BackendPort *int32 `json:"backendPort,omitempty"`
	// ProvisioningState - Gets provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// InboundNatRule inbound NAT rule of the loadbalancer
type InboundNatRule struct {
	*InboundNatRulePropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for InboundNatRule.
func (inr InboundNatRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if inr.InboundNatRulePropertiesFormat != nil {
		objectMap["properties"] = inr.InboundNatRulePropertiesFormat
	}
	if inr.Name != nil {
		objectMap["name"] = inr.Name
	}
	if inr.Etag != nil {
		objectMap["etag"] = inr.Etag
	}
	if inr.ID != nil {
		objectMap["id"] = inr.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InboundNatRule struct.
func (inr *InboundNatRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var inboundNatRulePropertiesFormat InboundNatRulePropertiesFormat
				err = json.Unmarshal(*v, &inboundNatRulePropertiesFormat)
				if err != nil {
					return err
				}
				inr.InboundNatRulePropertiesFormat = &inboundNatRulePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				inr.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				inr.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				inr.ID = &ID
			}
		}
	}

	return nil
}

// InboundNatRulePropertiesFormat properties of Inbound NAT rule
type InboundNatRulePropertiesFormat struct {
	// FrontendIPConfiguration - Gets or sets a reference to frontend IP Addresses
	FrontendIPConfiguration *SubResource `json:"frontendIPConfiguration,omitempty"`
	// BackendIPConfiguration - READ-ONLY; Gets or sets a reference to a private ip address defined on a NetworkInterface of a VM. Traffic sent to frontendPort of each of the frontendIPConfigurations is forwarded to the backed IP
	BackendIPConfiguration *InterfaceIPConfiguration `json:"backendIPConfiguration,omitempty"`
	// Protocol - Gets or sets the transport protocol for the endpoint. Possible values are Udp or Tcp. Possible values include: 'TransportProtocolUDP', 'TransportProtocolTCP'
	Protocol TransportProtocol `json:"protocol,omitempty"`
	// FrontendPort - Gets or sets the port for the external endpoint. You can specify any port number you choose, but the port numbers specified for each role in the service must be unique. Possible values range between 1 and 65535, inclusive
	FrontendPort *int32 `json:"frontendPort,omitempty"`
	// BackendPort - Gets or sets a port used for internal connections on the endpoint. The localPort attribute maps the eternal port of the endpoint to an internal port on a role. This is useful in scenarios where a role must communicate to an internal component on a port that is different from the one that is exposed externally. If not specified, the value of localPort is the same as the port attribute. Set the value of localPort to '*' to automatically assign an unallocated port that is discoverable using the runtime API
	BackendPort *int32 `json:"backendPort,omitempty"`
	// IdleTimeoutInMinutes - Gets or sets the timeout for the Tcp idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to Tcp
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`
	// EnableFloatingIP - Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn availability Group. This setting is required when using the SQL Always ON availability Groups in SQL server. This setting can't be changed after you create the endpoint
	EnableFloatingIP *bool `json:"enableFloatingIP,omitempty"`
	// ProvisioningState - Gets provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for InboundNatRulePropertiesFormat.
func (inrpf InboundNatRulePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if inrpf.FrontendIPConfiguration != nil {
		objectMap["frontendIPConfiguration"] = inrpf.FrontendIPConfiguration
	}
	if inrpf.Protocol != "" {
		objectMap["protocol"] = inrpf.Protocol
	}
	if inrpf.FrontendPort != nil {
		objectMap["frontendPort"] = inrpf.FrontendPort
	}
	if inrpf.BackendPort != nil {
		objectMap["backendPort"] = inrpf.BackendPort
	}
	if inrpf.IdleTimeoutInMinutes != nil {
		objectMap["idleTimeoutInMinutes"] = inrpf.IdleTimeoutInMinutes
	}
	if inrpf.EnableFloatingIP != nil {
		objectMap["enableFloatingIP"] = inrpf.EnableFloatingIP
	}
	if inrpf.ProvisioningState != nil {
		objectMap["provisioningState"] = inrpf.ProvisioningState
	}
	return json.Marshal(objectMap)
}

// Interface a NetworkInterface in a resource group
type Interface struct {
	autorest.Response          `json:"-"`
	*InterfacePropertiesFormat `json:"properties,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Interface.
func (i Interface) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.InterfacePropertiesFormat != nil {
		objectMap["properties"] = i.InterfacePropertiesFormat
	}
	if i.Etag != nil {
		objectMap["etag"] = i.Etag
	}
	if i.ID != nil {
		objectMap["id"] = i.ID
	}
	if i.Location != nil {
		objectMap["location"] = i.Location
	}
	if i.Tags != nil {
		objectMap["tags"] = i.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Interface struct.
func (i *Interface) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var interfacePropertiesFormat InterfacePropertiesFormat
				err = json.Unmarshal(*v, &interfacePropertiesFormat)
				if err != nil {
					return err
				}
				i.InterfacePropertiesFormat = &interfacePropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				i.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				i.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				i.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				i.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				i.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				i.Tags = tags
			}
		}
	}

	return nil
}

// InterfaceDNSSettings dns settings of a network interface
type InterfaceDNSSettings struct {
	// DNSServers - Gets or sets list of DNS servers IP addresses
	DNSServers *[]string `json:"dnsServers,omitempty"`
	// AppliedDNSServers - Gets or sets list of Applied DNS servers IP addresses
	AppliedDNSServers *[]string `json:"appliedDnsServers,omitempty"`
	// InternalDNSNameLabel - Gets or sets the internal DNS name
	InternalDNSNameLabel *string `json:"internalDnsNameLabel,omitempty"`
	// InternalFqdn - Gets or sets the internal fqdn.
	InternalFqdn *string `json:"internalFqdn,omitempty"`
	// InternalDomainNameSuffix - Gets or sets internal domain name suffix of the NIC.
	InternalDomainNameSuffix *string `json:"internalDomainNameSuffix,omitempty"`
}

// InterfaceIPConfiguration iPConfiguration in a NetworkInterface
type InterfaceIPConfiguration struct {
	*InterfaceIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for InterfaceIPConfiguration.
func (iic InterfaceIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iic.InterfaceIPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = iic.InterfaceIPConfigurationPropertiesFormat
	}
	if iic.Name != nil {
		objectMap["name"] = iic.Name
	}
	if iic.Etag != nil {
		objectMap["etag"] = iic.Etag
	}
	if iic.ID != nil {
		objectMap["id"] = iic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InterfaceIPConfiguration struct.
func (iic *InterfaceIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var interfaceIPConfigurationPropertiesFormat InterfaceIPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &interfaceIPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				iic.InterfaceIPConfigurationPropertiesFormat = &interfaceIPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				iic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				iic.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				iic.ID = &ID
			}
		}
	}

	return nil
}

// InterfaceIPConfigurationPropertiesFormat properties of IPConfiguration
type InterfaceIPConfigurationPropertiesFormat struct {
	// ApplicationGatewayBackendAddressPools - Gets or sets the reference of ApplicationGatewayBackendAddressPool resource
	ApplicationGatewayBackendAddressPools *[]ApplicationGatewayBackendAddressPool `json:"applicationGatewayBackendAddressPools,omitempty"`
	// LoadBalancerBackendAddressPools - Gets or sets the reference of LoadBalancerBackendAddressPool resource
	LoadBalancerBackendAddressPools *[]BackendAddressPool `json:"loadBalancerBackendAddressPools,omitempty"`
	// LoadBalancerInboundNatRules - Gets or sets list of references of LoadBalancerInboundNatRules
	LoadBalancerInboundNatRules *[]InboundNatRule `json:"loadBalancerInboundNatRules,omitempty"`
	PrivateIPAddress            *string           `json:"privateIPAddress,omitempty"`
	// PrivateIPAllocationMethod - Gets or sets PrivateIP allocation method. Possible values include: 'Static', 'Dynamic'
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	// PrivateIPAddressVersion - Gets or sets PrivateIP address version (IPv4/IPv6). Possible values include: 'IPv4', 'IPv6'
	PrivateIPAddressVersion IPVersion `json:"privateIPAddressVersion,omitempty"`
	Subnet                  *Subnet   `json:"subnet,omitempty"`
	// Primary - Gets whether this is a primary customer address on the NIC
	Primary           *bool            `json:"primary,omitempty"`
	PublicIPAddress   *PublicIPAddress `json:"publicIPAddress,omitempty"`
	ProvisioningState *string          `json:"provisioningState,omitempty"`
}

// InterfaceListResult response for ListNetworkInterface Api service call
type InterfaceListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets list of NetworkInterfaces in a resource group
	Value *[]Interface `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// InterfaceListResultIterator provides access to a complete listing of Interface values.
type InterfaceListResultIterator struct {
	i    int
	page InterfaceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InterfaceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InterfaceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *InterfaceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InterfaceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter InterfaceListResultIterator) Response() InterfaceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InterfaceListResultIterator) Value() Interface {
	if !iter.page.NotDone() {
		return Interface{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the InterfaceListResultIterator type.
func NewInterfaceListResultIterator(page InterfaceListResultPage) InterfaceListResultIterator {
	return InterfaceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ilr InterfaceListResult) IsEmpty() bool {
	return ilr.Value == nil || len(*ilr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ilr InterfaceListResult) hasNextLink() bool {
	return ilr.NextLink != nil && len(*ilr.NextLink) != 0
}

// interfaceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ilr InterfaceListResult) interfaceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ilr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ilr.NextLink)))
}

// InterfaceListResultPage contains a page of Interface values.
type InterfaceListResultPage struct {
	fn  func(context.Context, InterfaceListResult) (InterfaceListResult, error)
	ilr InterfaceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InterfaceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InterfaceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ilr)
		if err != nil {
			return err
		}
		page.ilr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *InterfaceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InterfaceListResultPage) NotDone() bool {
	return !page.ilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page InterfaceListResultPage) Response() InterfaceListResult {
	return page.ilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page InterfaceListResultPage) Values() []Interface {
	if page.ilr.IsEmpty() {
		return nil
	}
	return *page.ilr.Value
}

// Creates a new instance of the InterfaceListResultPage type.
func NewInterfaceListResultPage(cur InterfaceListResult, getNextPage func(context.Context, InterfaceListResult) (InterfaceListResult, error)) InterfaceListResultPage {
	return InterfaceListResultPage{
		fn:  getNextPage,
		ilr: cur,
	}
}

// InterfacePropertiesFormat networkInterface properties.
type InterfacePropertiesFormat struct {
	// VirtualMachine - Gets or sets the reference of a VirtualMachine
	VirtualMachine *SubResource `json:"virtualMachine,omitempty"`
	// NetworkSecurityGroup - Gets or sets the reference of the NetworkSecurityGroup resource
	NetworkSecurityGroup *SecurityGroup `json:"networkSecurityGroup,omitempty"`
	// IPConfigurations - Gets or sets list of IPConfigurations of the network interface
	IPConfigurations *[]InterfaceIPConfiguration `json:"ipConfigurations,omitempty"`
	// DNSSettings - Gets or sets DNS settings in network interface
	DNSSettings *InterfaceDNSSettings `json:"dnsSettings,omitempty"`
	// MacAddress - Gets the MAC address of the network interface
	MacAddress *string `json:"macAddress,omitempty"`
	// Primary - Gets whether this is a primary NIC on a virtual machine
	Primary *bool `json:"primary,omitempty"`
	// EnableIPForwarding - Gets or sets whether IPForwarding is enabled on the NIC
	EnableIPForwarding *bool `json:"enableIPForwarding,omitempty"`
	// ResourceGUID - Gets or sets resource guid property of the network interface resource
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - Gets provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// InterfacesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type InterfacesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(InterfacesClient) (Interface, error)
}

// InterfacesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type InterfacesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(InterfacesClient) (autorest.Response, error)
}

// InterfacesGetEffectiveRouteTableFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type InterfacesGetEffectiveRouteTableFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(InterfacesClient) (EffectiveRouteListResult, error)
}

// InterfacesListEffectiveNetworkSecurityGroupsFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type InterfacesListEffectiveNetworkSecurityGroupsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(InterfacesClient) (EffectiveNetworkSecurityGroupListResult, error)
}

// IPAddressAvailabilityResult response for CheckIPAddressAvailability Api service call
type IPAddressAvailabilityResult struct {
	autorest.Response `json:"-"`
	// Available - Private IP address availability
	Available *bool `json:"available,omitempty"`
	// AvailableIPAddresses - Contains other available private IP addresses if the asked for address is taken
	AvailableIPAddresses *[]string `json:"availableIPAddresses,omitempty"`
}

// IPConfiguration iPConfiguration
type IPConfiguration struct {
	*IPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for IPConfiguration.
func (ic IPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ic.IPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = ic.IPConfigurationPropertiesFormat
	}
	if ic.Name != nil {
		objectMap["name"] = ic.Name
	}
	if ic.Etag != nil {
		objectMap["etag"] = ic.Etag
	}
	if ic.ID != nil {
		objectMap["id"] = ic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IPConfiguration struct.
func (ic *IPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var IPConfigurationPropertiesFormat IPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &IPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				ic.IPConfigurationPropertiesFormat = &IPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ic.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ic.ID = &ID
			}
		}
	}

	return nil
}

// IPConfigurationPropertiesFormat properties of IPConfiguration
type IPConfigurationPropertiesFormat struct {
	// PrivateIPAddress - Gets or sets the privateIPAddress of the IP Configuration
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`
	// PrivateIPAllocationMethod - Gets or sets PrivateIP allocation method. Possible values include: 'Static', 'Dynamic'
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	// Subnet - Gets or sets the reference of the subnet resource
	Subnet *Subnet `json:"subnet,omitempty"`
	// PublicIPAddress - Gets or sets the reference of the PublicIP resource
	PublicIPAddress *PublicIPAddress `json:"publicIPAddress,omitempty"`
	// ProvisioningState - Gets provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// LoadBalancer loadBalancer resource
type LoadBalancer struct {
	autorest.Response             `json:"-"`
	*LoadBalancerPropertiesFormat `json:"properties,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for LoadBalancer.
func (lb LoadBalancer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lb.LoadBalancerPropertiesFormat != nil {
		objectMap["properties"] = lb.LoadBalancerPropertiesFormat
	}
	if lb.Etag != nil {
		objectMap["etag"] = lb.Etag
	}
	if lb.ID != nil {
		objectMap["id"] = lb.ID
	}
	if lb.Location != nil {
		objectMap["location"] = lb.Location
	}
	if lb.Tags != nil {
		objectMap["tags"] = lb.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LoadBalancer struct.
func (lb *LoadBalancer) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var loadBalancerPropertiesFormat LoadBalancerPropertiesFormat
				err = json.Unmarshal(*v, &loadBalancerPropertiesFormat)
				if err != nil {
					return err
				}
				lb.LoadBalancerPropertiesFormat = &loadBalancerPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				lb.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lb.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lb.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lb.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				lb.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				lb.Tags = tags
			}
		}
	}

	return nil
}

// LoadBalancerListResult response for ListLoadBalancers Api service call
type LoadBalancerListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets a list of LoadBalancers in a resource group
	Value *[]LoadBalancer `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// LoadBalancerListResultIterator provides access to a complete listing of LoadBalancer values.
type LoadBalancerListResultIterator struct {
	i    int
	page LoadBalancerListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LoadBalancerListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LoadBalancerListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LoadBalancerListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LoadBalancerListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LoadBalancerListResultIterator) Response() LoadBalancerListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LoadBalancerListResultIterator) Value() LoadBalancer {
	if !iter.page.NotDone() {
		return LoadBalancer{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LoadBalancerListResultIterator type.
func NewLoadBalancerListResultIterator(page LoadBalancerListResultPage) LoadBalancerListResultIterator {
	return LoadBalancerListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lblr LoadBalancerListResult) IsEmpty() bool {
	return lblr.Value == nil || len(*lblr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lblr LoadBalancerListResult) hasNextLink() bool {
	return lblr.NextLink != nil && len(*lblr.NextLink) != 0
}

// loadBalancerListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lblr LoadBalancerListResult) loadBalancerListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lblr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lblr.NextLink)))
}

// LoadBalancerListResultPage contains a page of LoadBalancer values.
type LoadBalancerListResultPage struct {
	fn   func(context.Context, LoadBalancerListResult) (LoadBalancerListResult, error)
	lblr LoadBalancerListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LoadBalancerListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LoadBalancerListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lblr)
		if err != nil {
			return err
		}
		page.lblr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LoadBalancerListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LoadBalancerListResultPage) NotDone() bool {
	return !page.lblr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LoadBalancerListResultPage) Response() LoadBalancerListResult {
	return page.lblr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LoadBalancerListResultPage) Values() []LoadBalancer {
	if page.lblr.IsEmpty() {
		return nil
	}
	return *page.lblr.Value
}

// Creates a new instance of the LoadBalancerListResultPage type.
func NewLoadBalancerListResultPage(cur LoadBalancerListResult, getNextPage func(context.Context, LoadBalancerListResult) (LoadBalancerListResult, error)) LoadBalancerListResultPage {
	return LoadBalancerListResultPage{
		fn:   getNextPage,
		lblr: cur,
	}
}

// LoadBalancerPropertiesFormat properties of Load Balancer
type LoadBalancerPropertiesFormat struct {
	// FrontendIPConfigurations - Gets or sets frontend IP addresses of the load balancer
	FrontendIPConfigurations *[]FrontendIPConfiguration `json:"frontendIPConfigurations,omitempty"`
	// BackendAddressPools - Gets or sets Pools of backend IP addresses
	BackendAddressPools *[]BackendAddressPool `json:"backendAddressPools,omitempty"`
	// LoadBalancingRules - Gets or sets load balancing rules
	LoadBalancingRules *[]LoadBalancingRule `json:"loadBalancingRules,omitempty"`
	// Probes - Gets or sets list of Load balancer probes
	Probes *[]Probe `json:"probes,omitempty"`
	// InboundNatRules - Gets or sets list of inbound rules
	InboundNatRules *[]InboundNatRule `json:"inboundNatRules,omitempty"`
	// InboundNatPools - Gets or sets inbound NAT pools
	InboundNatPools *[]InboundNatPool `json:"inboundNatPools,omitempty"`
	// OutboundNatRules - Gets or sets outbound NAT rules
	OutboundNatRules *[]OutboundNatRule `json:"outboundNatRules,omitempty"`
	// ResourceGUID - Gets or sets resource guid property of the Load balancer resource
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - Gets provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// LoadBalancersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type LoadBalancersCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LoadBalancersClient) (LoadBalancer, error)
}

// LoadBalancersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LoadBalancersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LoadBalancersClient) (autorest.Response, error)
}

// LoadBalancingRule rules of the load balancer
type LoadBalancingRule struct {
	*LoadBalancingRulePropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for LoadBalancingRule.
func (lbr LoadBalancingRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lbr.LoadBalancingRulePropertiesFormat != nil {
		objectMap["properties"] = lbr.LoadBalancingRulePropertiesFormat
	}
	if lbr.Name != nil {
		objectMap["name"] = lbr.Name
	}
	if lbr.Etag != nil {
		objectMap["etag"] = lbr.Etag
	}
	if lbr.ID != nil {
		objectMap["id"] = lbr.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LoadBalancingRule struct.
func (lbr *LoadBalancingRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var loadBalancingRulePropertiesFormat LoadBalancingRulePropertiesFormat
				err = json.Unmarshal(*v, &loadBalancingRulePropertiesFormat)
				if err != nil {
					return err
				}
				lbr.LoadBalancingRulePropertiesFormat = &loadBalancingRulePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lbr.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				lbr.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lbr.ID = &ID
			}
		}
	}

	return nil
}

// LoadBalancingRulePropertiesFormat properties of the load balancer
type LoadBalancingRulePropertiesFormat struct {
	// FrontendIPConfiguration - Gets or sets a reference to frontend IP Addresses
	FrontendIPConfiguration *SubResource `json:"frontendIPConfiguration,omitempty"`
	// BackendAddressPool - Gets or sets  a reference to a pool of DIPs. Inbound traffic is randomly load balanced across IPs in the backend IPs
	BackendAddressPool *SubResource `json:"backendAddressPool,omitempty"`
	// Probe - Gets or sets the reference of the load balancer probe used by the Load Balancing rule.
	Probe *SubResource `json:"probe,omitempty"`
	// Protocol - Gets or sets the transport protocol for the external endpoint. Possible values are Udp or Tcp. Possible values include: 'TransportProtocolUDP', 'TransportProtocolTCP'
	Protocol TransportProtocol `json:"protocol,omitempty"`
	// LoadDistribution - Gets or sets the load distribution policy for this rule. Possible values include: 'Default', 'SourceIP', 'SourceIPProtocol'
	LoadDistribution LoadDistribution `json:"loadDistribution,omitempty"`
	// FrontendPort - Gets or sets the port for the external endpoint. You can specify any port number you choose, but the port numbers specified for each role in the service must be unique. Possible values range between 1 and 65535, inclusive
	FrontendPort *int32 `json:"frontendPort,omitempty"`
	// BackendPort - Gets or sets a port used for internal connections on the endpoint. The localPort attribute maps the eternal port of the endpoint to an internal port on a role. This is useful in scenarios where a role must communicate to an internal component on a port that is different from the one that is exposed externally. If not specified, the value of localPort is the same as the port attribute. Set the value of localPort to '*' to automatically assign an unallocated port that is discoverable using the runtime API
	BackendPort *int32 `json:"backendPort,omitempty"`
	// IdleTimeoutInMinutes - Gets or sets the timeout for the Tcp idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to Tcp
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`
	// EnableFloatingIP - Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn availability Group. This setting is required when using the SQL Always ON availability Groups in SQL server. This setting can't be changed after you create the endpoint
	EnableFloatingIP *bool `json:"enableFloatingIP,omitempty"`
	// ProvisioningState - Gets provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// LocalNetworkGateway a common class for general resource information
type LocalNetworkGateway struct {
	autorest.Response                    `json:"-"`
	*LocalNetworkGatewayPropertiesFormat `json:"properties,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for LocalNetworkGateway.
func (lng LocalNetworkGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lng.LocalNetworkGatewayPropertiesFormat != nil {
		objectMap["properties"] = lng.LocalNetworkGatewayPropertiesFormat
	}
	if lng.Etag != nil {
		objectMap["etag"] = lng.Etag
	}
	if lng.ID != nil {
		objectMap["id"] = lng.ID
	}
	if lng.Location != nil {
		objectMap["location"] = lng.Location
	}
	if lng.Tags != nil {
		objectMap["tags"] = lng.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LocalNetworkGateway struct.
func (lng *LocalNetworkGateway) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var localNetworkGatewayPropertiesFormat LocalNetworkGatewayPropertiesFormat
				err = json.Unmarshal(*v, &localNetworkGatewayPropertiesFormat)
				if err != nil {
					return err
				}
				lng.LocalNetworkGatewayPropertiesFormat = &localNetworkGatewayPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				lng.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lng.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lng.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lng.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				lng.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				lng.Tags = tags
			}
		}
	}

	return nil
}

// LocalNetworkGatewayListResult response for ListLocalNetworkGateways Api service call
type LocalNetworkGatewayListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets List of LocalNetworkGateways that exists in a resource group
	Value *[]LocalNetworkGateway `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// LocalNetworkGatewayListResultIterator provides access to a complete listing of LocalNetworkGateway
// values.
type LocalNetworkGatewayListResultIterator struct {
	i    int
	page LocalNetworkGatewayListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LocalNetworkGatewayListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LocalNetworkGatewayListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LocalNetworkGatewayListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LocalNetworkGatewayListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LocalNetworkGatewayListResultIterator) Response() LocalNetworkGatewayListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LocalNetworkGatewayListResultIterator) Value() LocalNetworkGateway {
	if !iter.page.NotDone() {
		return LocalNetworkGateway{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LocalNetworkGatewayListResultIterator type.
func NewLocalNetworkGatewayListResultIterator(page LocalNetworkGatewayListResultPage) LocalNetworkGatewayListResultIterator {
	return LocalNetworkGatewayListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lnglr LocalNetworkGatewayListResult) IsEmpty() bool {
	return lnglr.Value == nil || len(*lnglr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lnglr LocalNetworkGatewayListResult) hasNextLink() bool {
	return lnglr.NextLink != nil && len(*lnglr.NextLink) != 0
}

// localNetworkGatewayListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lnglr LocalNetworkGatewayListResult) localNetworkGatewayListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lnglr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lnglr.NextLink)))
}

// LocalNetworkGatewayListResultPage contains a page of LocalNetworkGateway values.
type LocalNetworkGatewayListResultPage struct {
	fn    func(context.Context, LocalNetworkGatewayListResult) (LocalNetworkGatewayListResult, error)
	lnglr LocalNetworkGatewayListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LocalNetworkGatewayListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LocalNetworkGatewayListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lnglr)
		if err != nil {
			return err
		}
		page.lnglr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LocalNetworkGatewayListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LocalNetworkGatewayListResultPage) NotDone() bool {
	return !page.lnglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LocalNetworkGatewayListResultPage) Response() LocalNetworkGatewayListResult {
	return page.lnglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LocalNetworkGatewayListResultPage) Values() []LocalNetworkGateway {
	if page.lnglr.IsEmpty() {
		return nil
	}
	return *page.lnglr.Value
}

// Creates a new instance of the LocalNetworkGatewayListResultPage type.
func NewLocalNetworkGatewayListResultPage(cur LocalNetworkGatewayListResult, getNextPage func(context.Context, LocalNetworkGatewayListResult) (LocalNetworkGatewayListResult, error)) LocalNetworkGatewayListResultPage {
	return LocalNetworkGatewayListResultPage{
		fn:    getNextPage,
		lnglr: cur,
	}
}

// LocalNetworkGatewayPropertiesFormat localNetworkGateway properties
type LocalNetworkGatewayPropertiesFormat struct {
	// LocalNetworkAddressSpace - Local network site Address space
	LocalNetworkAddressSpace *AddressSpace `json:"localNetworkAddressSpace,omitempty"`
	// GatewayIPAddress - IP address of local network gateway.
	GatewayIPAddress *string `json:"gatewayIpAddress,omitempty"`
	// BgpSettings - Local network gateway's BGP speaker settings
	BgpSettings *BgpSettings `json:"bgpSettings,omitempty"`
	// ResourceGUID - Gets or sets resource guid property of the LocalNetworkGateway resource
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - Gets provisioning state of the LocalNetworkGateway resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// LocalNetworkGatewaysCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type LocalNetworkGatewaysCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LocalNetworkGatewaysClient) (LocalNetworkGateway, error)
}

// LocalNetworkGatewaysDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type LocalNetworkGatewaysDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LocalNetworkGatewaysClient) (autorest.Response, error)
}

// OutboundNatRule outbound NAT pool of the load balancer
type OutboundNatRule struct {
	*OutboundNatRulePropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for OutboundNatRule.
func (onr OutboundNatRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if onr.OutboundNatRulePropertiesFormat != nil {
		objectMap["properties"] = onr.OutboundNatRulePropertiesFormat
	}
	if onr.Name != nil {
		objectMap["name"] = onr.Name
	}
	if onr.Etag != nil {
		objectMap["etag"] = onr.Etag
	}
	if onr.ID != nil {
		objectMap["id"] = onr.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OutboundNatRule struct.
func (onr *OutboundNatRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var outboundNatRulePropertiesFormat OutboundNatRulePropertiesFormat
				err = json.Unmarshal(*v, &outboundNatRulePropertiesFormat)
				if err != nil {
					return err
				}
				onr.OutboundNatRulePropertiesFormat = &outboundNatRulePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				onr.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				onr.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				onr.ID = &ID
			}
		}
	}

	return nil
}

// OutboundNatRulePropertiesFormat outbound NAT pool of the load balancer
type OutboundNatRulePropertiesFormat struct {
	// AllocatedOutboundPorts - Gets or sets the number of outbound ports to be used for SNAT
	AllocatedOutboundPorts *int32 `json:"allocatedOutboundPorts,omitempty"`
	// FrontendIPConfigurations - Gets or sets Frontend IP addresses of the load balancer
	FrontendIPConfigurations *[]SubResource `json:"frontendIPConfigurations,omitempty"`
	// BackendAddressPool - Gets or sets a reference to a pool of DIPs. Outbound traffic is randomly load balanced across IPs in the backend IPs
	BackendAddressPool *SubResource `json:"backendAddressPool,omitempty"`
	// ProvisioningState - Gets provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Probe load balancer Probe
type Probe struct {
	*ProbePropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for Probe.
func (p Probe) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.ProbePropertiesFormat != nil {
		objectMap["properties"] = p.ProbePropertiesFormat
	}
	if p.Name != nil {
		objectMap["name"] = p.Name
	}
	if p.Etag != nil {
		objectMap["etag"] = p.Etag
	}
	if p.ID != nil {
		objectMap["id"] = p.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Probe struct.
func (p *Probe) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var probePropertiesFormat ProbePropertiesFormat
				err = json.Unmarshal(*v, &probePropertiesFormat)
				if err != nil {
					return err
				}
				p.ProbePropertiesFormat = &probePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				p.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		}
	}

	return nil
}

// ProbePropertiesFormat ...
type ProbePropertiesFormat struct {
	// LoadBalancingRules - READ-ONLY; Gets Load balancer rules that use this probe
	LoadBalancingRules *[]SubResource `json:"loadBalancingRules,omitempty"`
	// Protocol - Gets or sets the protocol of the end point. Possible values are http or Tcp. If Tcp is specified, a received ACK is required for the probe to be successful. If http is specified,a 200 OK response from the specifies URI is required for the probe to be successful. Possible values include: 'ProbeProtocolHTTP', 'ProbeProtocolTCP'
	Protocol ProbeProtocol `json:"protocol,omitempty"`
	// Port - Gets or sets Port for communicating the probe. Possible values range from 1 to 65535, inclusive.
	Port *int32 `json:"port,omitempty"`
	// IntervalInSeconds - Gets or sets the interval, in seconds, for how frequently to probe the endpoint for health status. Typically, the interval is slightly less than half the allocated timeout period (in seconds) which allows two full probes before taking the instance out of rotation. The default value is 15, the minimum value is 5
	IntervalInSeconds *int32 `json:"intervalInSeconds,omitempty"`
	// NumberOfProbes - Gets or sets the number of probes where if no response, will result in stopping further traffic from being delivered to the endpoint. This values allows endpoints to be taken out of rotation faster or slower than the typical times used in Azure.
	NumberOfProbes *int32 `json:"numberOfProbes,omitempty"`
	// RequestPath - Gets or sets the URI used for requesting health status from the VM. Path is required if a protocol is set to http. Otherwise, it is not allowed. There is no default value
	RequestPath *string `json:"requestPath,omitempty"`
	// ProvisioningState - Gets provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ProbePropertiesFormat.
func (ppf ProbePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ppf.Protocol != "" {
		objectMap["protocol"] = ppf.Protocol
	}
	if ppf.Port != nil {
		objectMap["port"] = ppf.Port
	}
	if ppf.IntervalInSeconds != nil {
		objectMap["intervalInSeconds"] = ppf.IntervalInSeconds
	}
	if ppf.NumberOfProbes != nil {
		objectMap["numberOfProbes"] = ppf.NumberOfProbes
	}
	if ppf.RequestPath != nil {
		objectMap["requestPath"] = ppf.RequestPath
	}
	if ppf.ProvisioningState != nil {
		objectMap["provisioningState"] = ppf.ProvisioningState
	}
	return json.Marshal(objectMap)
}

// PublicIPAddress publicIPAddress resource
type PublicIPAddress struct {
	autorest.Response                `json:"-"`
	*PublicIPAddressPropertiesFormat `json:"properties,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for PublicIPAddress.
func (pia PublicIPAddress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pia.PublicIPAddressPropertiesFormat != nil {
		objectMap["properties"] = pia.PublicIPAddressPropertiesFormat
	}
	if pia.Etag != nil {
		objectMap["etag"] = pia.Etag
	}
	if pia.ID != nil {
		objectMap["id"] = pia.ID
	}
	if pia.Location != nil {
		objectMap["location"] = pia.Location
	}
	if pia.Tags != nil {
		objectMap["tags"] = pia.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PublicIPAddress struct.
func (pia *PublicIPAddress) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var publicIPAddressPropertiesFormat PublicIPAddressPropertiesFormat
				err = json.Unmarshal(*v, &publicIPAddressPropertiesFormat)
				if err != nil {
					return err
				}
				pia.PublicIPAddressPropertiesFormat = &publicIPAddressPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				pia.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pia.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pia.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pia.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pia.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pia.Tags = tags
			}
		}
	}

	return nil
}

// PublicIPAddressDNSSettings contains FQDN of the DNS record associated with the public IP address
type PublicIPAddressDNSSettings struct {
	// DomainNameLabel - Gets or sets the Domain name label.The concatenation of the domain name label and the regionalized DNS zone make up the fully qualified domain name associated with the public IP address. If a domain name label is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system.
	DomainNameLabel *string `json:"domainNameLabel,omitempty"`
	// Fqdn - Gets the FQDN, Fully qualified domain name of the A DNS record associated with the public IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone.
	Fqdn *string `json:"fqdn,omitempty"`
	// ReverseFqdn - Gets or Sets the Reverse FQDN. A user-visible, fully qualified domain name that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN.
	ReverseFqdn *string `json:"reverseFqdn,omitempty"`
}

// PublicIPAddressesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PublicIPAddressesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PublicIPAddressesClient) (PublicIPAddress, error)
}

// PublicIPAddressesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PublicIPAddressesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PublicIPAddressesClient) (autorest.Response, error)
}

// PublicIPAddressListResult response for ListPublicIpAddresses Api service call
type PublicIPAddressListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets List of publicIP addresses that exists in a resource group
	Value *[]PublicIPAddress `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// PublicIPAddressListResultIterator provides access to a complete listing of PublicIPAddress values.
type PublicIPAddressListResultIterator struct {
	i    int
	page PublicIPAddressListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PublicIPAddressListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PublicIPAddressListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PublicIPAddressListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PublicIPAddressListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PublicIPAddressListResultIterator) Response() PublicIPAddressListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PublicIPAddressListResultIterator) Value() PublicIPAddress {
	if !iter.page.NotDone() {
		return PublicIPAddress{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PublicIPAddressListResultIterator type.
func NewPublicIPAddressListResultIterator(page PublicIPAddressListResultPage) PublicIPAddressListResultIterator {
	return PublicIPAddressListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pialr PublicIPAddressListResult) IsEmpty() bool {
	return pialr.Value == nil || len(*pialr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pialr PublicIPAddressListResult) hasNextLink() bool {
	return pialr.NextLink != nil && len(*pialr.NextLink) != 0
}

// publicIPAddressListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pialr PublicIPAddressListResult) publicIPAddressListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !pialr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pialr.NextLink)))
}

// PublicIPAddressListResultPage contains a page of PublicIPAddress values.
type PublicIPAddressListResultPage struct {
	fn    func(context.Context, PublicIPAddressListResult) (PublicIPAddressListResult, error)
	pialr PublicIPAddressListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PublicIPAddressListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PublicIPAddressListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pialr)
		if err != nil {
			return err
		}
		page.pialr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PublicIPAddressListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PublicIPAddressListResultPage) NotDone() bool {
	return !page.pialr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PublicIPAddressListResultPage) Response() PublicIPAddressListResult {
	return page.pialr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PublicIPAddressListResultPage) Values() []PublicIPAddress {
	if page.pialr.IsEmpty() {
		return nil
	}
	return *page.pialr.Value
}

// Creates a new instance of the PublicIPAddressListResultPage type.
func NewPublicIPAddressListResultPage(cur PublicIPAddressListResult, getNextPage func(context.Context, PublicIPAddressListResult) (PublicIPAddressListResult, error)) PublicIPAddressListResultPage {
	return PublicIPAddressListResultPage{
		fn:    getNextPage,
		pialr: cur,
	}
}

// PublicIPAddressPropertiesFormat publicIpAddress properties
type PublicIPAddressPropertiesFormat struct {
	// PublicIPAllocationMethod - Gets or sets PublicIP allocation method (Static/Dynamic). Possible values include: 'Static', 'Dynamic'
	PublicIPAllocationMethod IPAllocationMethod `json:"publicIPAllocationMethod,omitempty"`
	// PublicIPAddressVersion - Gets or sets PublicIP address version (IPv4/IPv6). Possible values include: 'IPv4', 'IPv6'
	PublicIPAddressVersion IPVersion `json:"publicIPAddressVersion,omitempty"`
	// IPConfiguration - READ-ONLY
	IPConfiguration *IPConfiguration `json:"ipConfiguration,omitempty"`
	// DNSSettings - Gets or sets FQDN of the DNS record associated with the public IP address
	DNSSettings *PublicIPAddressDNSSettings `json:"dnsSettings,omitempty"`
	IPAddress   *string                     `json:"ipAddress,omitempty"`
	// IdleTimeoutInMinutes - Gets or sets the idle timeout of the public IP address
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`
	// ResourceGUID - Gets or sets resource guid property of the PublicIP resource
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - Gets provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for PublicIPAddressPropertiesFormat.
func (piapf PublicIPAddressPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if piapf.PublicIPAllocationMethod != "" {
		objectMap["publicIPAllocationMethod"] = piapf.PublicIPAllocationMethod
	}
	if piapf.PublicIPAddressVersion != "" {
		objectMap["publicIPAddressVersion"] = piapf.PublicIPAddressVersion
	}
	if piapf.DNSSettings != nil {
		objectMap["dnsSettings"] = piapf.DNSSettings
	}
	if piapf.IPAddress != nil {
		objectMap["ipAddress"] = piapf.IPAddress
	}
	if piapf.IdleTimeoutInMinutes != nil {
		objectMap["idleTimeoutInMinutes"] = piapf.IdleTimeoutInMinutes
	}
	if piapf.ResourceGUID != nil {
		objectMap["resourceGuid"] = piapf.ResourceGUID
	}
	if piapf.ProvisioningState != nil {
		objectMap["provisioningState"] = piapf.ProvisioningState
	}
	return json.Marshal(objectMap)
}

// Resource ...
type Resource struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// ResourceNavigationLink resourceNavigationLink resource
type ResourceNavigationLink struct {
	*ResourceNavigationLinkFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceNavigationLink.
func (rnl ResourceNavigationLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rnl.ResourceNavigationLinkFormat != nil {
		objectMap["properties"] = rnl.ResourceNavigationLinkFormat
	}
	if rnl.Name != nil {
		objectMap["name"] = rnl.Name
	}
	if rnl.ID != nil {
		objectMap["id"] = rnl.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ResourceNavigationLink struct.
func (rnl *ResourceNavigationLink) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var resourceNavigationLinkFormat ResourceNavigationLinkFormat
				err = json.Unmarshal(*v, &resourceNavigationLinkFormat)
				if err != nil {
					return err
				}
				rnl.ResourceNavigationLinkFormat = &resourceNavigationLinkFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rnl.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				rnl.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rnl.ID = &ID
			}
		}
	}

	return nil
}

// ResourceNavigationLinkFormat properties of ResourceNavigationLink
type ResourceNavigationLinkFormat struct {
	// LinkedResourceType - Resource type of the linked resource
	LinkedResourceType *string `json:"linkedResourceType,omitempty"`
	// Link - Link to the external resource
	Link *string `json:"link,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the ResourceNavigationLink resource
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceNavigationLinkFormat.
func (rnlf ResourceNavigationLinkFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rnlf.LinkedResourceType != nil {
		objectMap["linkedResourceType"] = rnlf.LinkedResourceType
	}
	if rnlf.Link != nil {
		objectMap["link"] = rnlf.Link
	}
	return json.Marshal(objectMap)
}

// Route route resource
type Route struct {
	autorest.Response      `json:"-"`
	*RoutePropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for Route.
func (r Route) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.RoutePropertiesFormat != nil {
		objectMap["properties"] = r.RoutePropertiesFormat
	}
	if r.Name != nil {
		objectMap["name"] = r.Name
	}
	if r.Etag != nil {
		objectMap["etag"] = r.Etag
	}
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Route struct.
func (r *Route) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var routePropertiesFormat RoutePropertiesFormat
				err = json.Unmarshal(*v, &routePropertiesFormat)
				if err != nil {
					return err
				}
				r.RoutePropertiesFormat = &routePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				r.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				r.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				r.ID = &ID
			}
		}
	}

	return nil
}

// RouteListResult response for ListRoute Api service call
type RouteListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets List of Routes in a resource group
	Value *[]Route `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RouteListResultIterator provides access to a complete listing of Route values.
type RouteListResultIterator struct {
	i    int
	page RouteListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RouteListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RouteListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RouteListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RouteListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RouteListResultIterator) Response() RouteListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RouteListResultIterator) Value() Route {
	if !iter.page.NotDone() {
		return Route{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RouteListResultIterator type.
func NewRouteListResultIterator(page RouteListResultPage) RouteListResultIterator {
	return RouteListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rlr RouteListResult) IsEmpty() bool {
	return rlr.Value == nil || len(*rlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rlr RouteListResult) hasNextLink() bool {
	return rlr.NextLink != nil && len(*rlr.NextLink) != 0
}

// routeListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rlr RouteListResult) routeListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rlr.NextLink)))
}

// RouteListResultPage contains a page of Route values.
type RouteListResultPage struct {
	fn  func(context.Context, RouteListResult) (RouteListResult, error)
	rlr RouteListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RouteListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RouteListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rlr)
		if err != nil {
			return err
		}
		page.rlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RouteListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RouteListResultPage) NotDone() bool {
	return !page.rlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RouteListResultPage) Response() RouteListResult {
	return page.rlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RouteListResultPage) Values() []Route {
	if page.rlr.IsEmpty() {
		return nil
	}
	return *page.rlr.Value
}

// Creates a new instance of the RouteListResultPage type.
func NewRouteListResultPage(cur RouteListResult, getNextPage func(context.Context, RouteListResult) (RouteListResult, error)) RouteListResultPage {
	return RouteListResultPage{
		fn:  getNextPage,
		rlr: cur,
	}
}

// RoutePropertiesFormat route resource
type RoutePropertiesFormat struct {
	// AddressPrefix - Gets or sets the destination CIDR to which the route applies.
	AddressPrefix *string `json:"addressPrefix,omitempty"`
	// NextHopType - Gets or sets the type of Azure hop the packet should be sent to. Possible values include: 'RouteNextHopTypeVirtualNetworkGateway', 'RouteNextHopTypeVnetLocal', 'RouteNextHopTypeInternet', 'RouteNextHopTypeVirtualAppliance', 'RouteNextHopTypeNone'
	NextHopType RouteNextHopType `json:"nextHopType,omitempty"`
	// NextHopIPAddress - Gets or sets the IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
	NextHopIPAddress *string `json:"nextHopIpAddress,omitempty"`
	// ProvisioningState - Gets provisioning state of the resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// RoutesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RoutesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RoutesClient) (Route, error)
}

// RoutesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type RoutesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RoutesClient) (autorest.Response, error)
}

// RouteTable routeTable resource
type RouteTable struct {
	autorest.Response           `json:"-"`
	*RouteTablePropertiesFormat `json:"properties,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for RouteTable.
func (rt RouteTable) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rt.RouteTablePropertiesFormat != nil {
		objectMap["properties"] = rt.RouteTablePropertiesFormat
	}
	if rt.Etag != nil {
		objectMap["etag"] = rt.Etag
	}
	if rt.ID != nil {
		objectMap["id"] = rt.ID
	}
	if rt.Location != nil {
		objectMap["location"] = rt.Location
	}
	if rt.Tags != nil {
		objectMap["tags"] = rt.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RouteTable struct.
func (rt *RouteTable) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var routeTablePropertiesFormat RouteTablePropertiesFormat
				err = json.Unmarshal(*v, &routeTablePropertiesFormat)
				if err != nil {
					return err
				}
				rt.RouteTablePropertiesFormat = &routeTablePropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				rt.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rt.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rt.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rt.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rt.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rt.Tags = tags
			}
		}
	}

	return nil
}

// RouteTableListResult response for ListRouteTable Api service call
type RouteTableListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets List of RouteTables in a resource group
	Value *[]RouteTable `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RouteTableListResultIterator provides access to a complete listing of RouteTable values.
type RouteTableListResultIterator struct {
	i    int
	page RouteTableListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RouteTableListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RouteTableListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RouteTableListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RouteTableListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RouteTableListResultIterator) Response() RouteTableListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RouteTableListResultIterator) Value() RouteTable {
	if !iter.page.NotDone() {
		return RouteTable{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RouteTableListResultIterator type.
func NewRouteTableListResultIterator(page RouteTableListResultPage) RouteTableListResultIterator {
	return RouteTableListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rtlr RouteTableListResult) IsEmpty() bool {
	return rtlr.Value == nil || len(*rtlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rtlr RouteTableListResult) hasNextLink() bool {
	return rtlr.NextLink != nil && len(*rtlr.NextLink) != 0
}

// routeTableListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rtlr RouteTableListResult) routeTableListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rtlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rtlr.NextLink)))
}

// RouteTableListResultPage contains a page of RouteTable values.
type RouteTableListResultPage struct {
	fn   func(context.Context, RouteTableListResult) (RouteTableListResult, error)
	rtlr RouteTableListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RouteTableListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RouteTableListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rtlr)
		if err != nil {
			return err
		}
		page.rtlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RouteTableListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RouteTableListResultPage) NotDone() bool {
	return !page.rtlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RouteTableListResultPage) Response() RouteTableListResult {
	return page.rtlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RouteTableListResultPage) Values() []RouteTable {
	if page.rtlr.IsEmpty() {
		return nil
	}
	return *page.rtlr.Value
}

// Creates a new instance of the RouteTableListResultPage type.
func NewRouteTableListResultPage(cur RouteTableListResult, getNextPage func(context.Context, RouteTableListResult) (RouteTableListResult, error)) RouteTableListResultPage {
	return RouteTableListResultPage{
		fn:   getNextPage,
		rtlr: cur,
	}
}

// RouteTablePropertiesFormat route Table resource
type RouteTablePropertiesFormat struct {
	// Routes - Gets or sets Routes in a Route Table
	Routes *[]Route `json:"routes,omitempty"`
	// Subnets - READ-ONLY; Gets collection of references to subnets
	Subnets *[]Subnet `json:"subnets,omitempty"`
	// ProvisioningState - Gets provisioning state of the resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for RouteTablePropertiesFormat.
func (rtpf RouteTablePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rtpf.Routes != nil {
		objectMap["routes"] = rtpf.Routes
	}
	if rtpf.ProvisioningState != nil {
		objectMap["provisioningState"] = rtpf.ProvisioningState
	}
	return json.Marshal(objectMap)
}

// RouteTablesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type RouteTablesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RouteTablesClient) (RouteTable, error)
}

// RouteTablesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RouteTablesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RouteTablesClient) (autorest.Response, error)
}

// SecurityGroup networkSecurityGroup resource
type SecurityGroup struct {
	autorest.Response              `json:"-"`
	*SecurityGroupPropertiesFormat `json:"properties,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SecurityGroup.
func (sg SecurityGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sg.SecurityGroupPropertiesFormat != nil {
		objectMap["properties"] = sg.SecurityGroupPropertiesFormat
	}
	if sg.Etag != nil {
		objectMap["etag"] = sg.Etag
	}
	if sg.ID != nil {
		objectMap["id"] = sg.ID
	}
	if sg.Location != nil {
		objectMap["location"] = sg.Location
	}
	if sg.Tags != nil {
		objectMap["tags"] = sg.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SecurityGroup struct.
func (sg *SecurityGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var securityGroupPropertiesFormat SecurityGroupPropertiesFormat
				err = json.Unmarshal(*v, &securityGroupPropertiesFormat)
				if err != nil {
					return err
				}
				sg.SecurityGroupPropertiesFormat = &securityGroupPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				sg.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sg.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sg.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sg.Tags = tags
			}
		}
	}

	return nil
}

// SecurityGroupListResult response for ListNetworkSecurityGroups Api service call
type SecurityGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets List of NetworkSecurityGroups
	Value *[]SecurityGroup `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SecurityGroupListResultIterator provides access to a complete listing of SecurityGroup values.
type SecurityGroupListResultIterator struct {
	i    int
	page SecurityGroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SecurityGroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecurityGroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SecurityGroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SecurityGroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SecurityGroupListResultIterator) Response() SecurityGroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SecurityGroupListResultIterator) Value() SecurityGroup {
	if !iter.page.NotDone() {
		return SecurityGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SecurityGroupListResultIterator type.
func NewSecurityGroupListResultIterator(page SecurityGroupListResultPage) SecurityGroupListResultIterator {
	return SecurityGroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sglr SecurityGroupListResult) IsEmpty() bool {
	return sglr.Value == nil || len(*sglr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sglr SecurityGroupListResult) hasNextLink() bool {
	return sglr.NextLink != nil && len(*sglr.NextLink) != 0
}

// securityGroupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sglr SecurityGroupListResult) securityGroupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !sglr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sglr.NextLink)))
}

// SecurityGroupListResultPage contains a page of SecurityGroup values.
type SecurityGroupListResultPage struct {
	fn   func(context.Context, SecurityGroupListResult) (SecurityGroupListResult, error)
	sglr SecurityGroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SecurityGroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecurityGroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sglr)
		if err != nil {
			return err
		}
		page.sglr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SecurityGroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SecurityGroupListResultPage) NotDone() bool {
	return !page.sglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SecurityGroupListResultPage) Response() SecurityGroupListResult {
	return page.sglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SecurityGroupListResultPage) Values() []SecurityGroup {
	if page.sglr.IsEmpty() {
		return nil
	}
	return *page.sglr.Value
}

// Creates a new instance of the SecurityGroupListResultPage type.
func NewSecurityGroupListResultPage(cur SecurityGroupListResult, getNextPage func(context.Context, SecurityGroupListResult) (SecurityGroupListResult, error)) SecurityGroupListResultPage {
	return SecurityGroupListResultPage{
		fn:   getNextPage,
		sglr: cur,
	}
}

// SecurityGroupPropertiesFormat network Security Group resource
type SecurityGroupPropertiesFormat struct {
	// SecurityRules - Gets or sets security rules of network security group
	SecurityRules *[]SecurityRule `json:"securityRules,omitempty"`
	// DefaultSecurityRules - Gets or default security rules of network security group
	DefaultSecurityRules *[]SecurityRule `json:"defaultSecurityRules,omitempty"`
	// NetworkInterfaces - READ-ONLY; Gets collection of references to Network Interfaces
	NetworkInterfaces *[]Interface `json:"networkInterfaces,omitempty"`
	// Subnets - READ-ONLY; Gets collection of references to subnets
	Subnets *[]Subnet `json:"subnets,omitempty"`
	// ResourceGUID - Gets or sets resource guid property of the network security group resource
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - Gets provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for SecurityGroupPropertiesFormat.
func (sgpf SecurityGroupPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sgpf.SecurityRules != nil {
		objectMap["securityRules"] = sgpf.SecurityRules
	}
	if sgpf.DefaultSecurityRules != nil {
		objectMap["defaultSecurityRules"] = sgpf.DefaultSecurityRules
	}
	if sgpf.ResourceGUID != nil {
		objectMap["resourceGuid"] = sgpf.ResourceGUID
	}
	if sgpf.ProvisioningState != nil {
		objectMap["provisioningState"] = sgpf.ProvisioningState
	}
	return json.Marshal(objectMap)
}

// SecurityGroupsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SecurityGroupsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SecurityGroupsClient) (SecurityGroup, error)
}

// SecurityGroupsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SecurityGroupsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SecurityGroupsClient) (autorest.Response, error)
}

// SecurityRule network security rule
type SecurityRule struct {
	autorest.Response             `json:"-"`
	*SecurityRulePropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for SecurityRule.
func (sr SecurityRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sr.SecurityRulePropertiesFormat != nil {
		objectMap["properties"] = sr.SecurityRulePropertiesFormat
	}
	if sr.Name != nil {
		objectMap["name"] = sr.Name
	}
	if sr.Etag != nil {
		objectMap["etag"] = sr.Etag
	}
	if sr.ID != nil {
		objectMap["id"] = sr.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SecurityRule struct.
func (sr *SecurityRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var securityRulePropertiesFormat SecurityRulePropertiesFormat
				err = json.Unmarshal(*v, &securityRulePropertiesFormat)
				if err != nil {
					return err
				}
				sr.SecurityRulePropertiesFormat = &securityRulePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sr.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				sr.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sr.ID = &ID
			}
		}
	}

	return nil
}

// SecurityRuleListResult response for ListSecurityRule Api service callRetrieves all security rules that
// belongs to a network security group
type SecurityRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets security rules in a network security group
	Value *[]SecurityRule `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SecurityRuleListResultIterator provides access to a complete listing of SecurityRule values.
type SecurityRuleListResultIterator struct {
	i    int
	page SecurityRuleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SecurityRuleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecurityRuleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SecurityRuleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SecurityRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SecurityRuleListResultIterator) Response() SecurityRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SecurityRuleListResultIterator) Value() SecurityRule {
	if !iter.page.NotDone() {
		return SecurityRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SecurityRuleListResultIterator type.
func NewSecurityRuleListResultIterator(page SecurityRuleListResultPage) SecurityRuleListResultIterator {
	return SecurityRuleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (srlr SecurityRuleListResult) IsEmpty() bool {
	return srlr.Value == nil || len(*srlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (srlr SecurityRuleListResult) hasNextLink() bool {
	return srlr.NextLink != nil && len(*srlr.NextLink) != 0
}

// securityRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (srlr SecurityRuleListResult) securityRuleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !srlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(srlr.NextLink)))
}

// SecurityRuleListResultPage contains a page of SecurityRule values.
type SecurityRuleListResultPage struct {
	fn   func(context.Context, SecurityRuleListResult) (SecurityRuleListResult, error)
	srlr SecurityRuleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SecurityRuleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecurityRuleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.srlr)
		if err != nil {
			return err
		}
		page.srlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SecurityRuleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SecurityRuleListResultPage) NotDone() bool {
	return !page.srlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SecurityRuleListResultPage) Response() SecurityRuleListResult {
	return page.srlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SecurityRuleListResultPage) Values() []SecurityRule {
	if page.srlr.IsEmpty() {
		return nil
	}
	return *page.srlr.Value
}

// Creates a new instance of the SecurityRuleListResultPage type.
func NewSecurityRuleListResultPage(cur SecurityRuleListResult, getNextPage func(context.Context, SecurityRuleListResult) (SecurityRuleListResult, error)) SecurityRuleListResultPage {
	return SecurityRuleListResultPage{
		fn:   getNextPage,
		srlr: cur,
	}
}

// SecurityRulePropertiesFormat ...
type SecurityRulePropertiesFormat struct {
	// Description - Gets or sets a description for this rule. Restricted to 140 chars.
	Description *string `json:"description,omitempty"`
	// Protocol - Gets or sets Network protocol this rule applies to. Can be Tcp, Udp or All(*). Possible values include: 'TCP', 'UDP', 'Asterisk'
	Protocol SecurityRuleProtocol `json:"protocol,omitempty"`
	// SourcePortRange - Gets or sets Source Port or Range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
	SourcePortRange *string `json:"sourcePortRange,omitempty"`
	// DestinationPortRange - Gets or sets Destination Port or Range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
	DestinationPortRange *string `json:"destinationPortRange,omitempty"`
	// SourceAddressPrefix - Gets or sets source address prefix. CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from.
	SourceAddressPrefix *string `json:"sourceAddressPrefix,omitempty"`
	// DestinationAddressPrefix - Gets or sets destination address prefix. CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.
	DestinationAddressPrefix *string `json:"destinationAddressPrefix,omitempty"`
	// Access - Gets or sets network traffic is allowed or denied. Possible values are 'Allow' and 'Deny'. Possible values include: 'Allow', 'Deny'
	Access SecurityRuleAccess `json:"access,omitempty"`
	// Priority - Gets or sets the priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
	Priority *int32 `json:"priority,omitempty"`
	// Direction - Gets or sets the direction of the rule.InBound or Outbound. The direction specifies if rule will be evaluated on incoming or outgoing traffic. Possible values include: 'Inbound', 'Outbound'
	Direction SecurityRuleDirection `json:"direction,omitempty"`
	// ProvisioningState - Gets provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// SecurityRulesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SecurityRulesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SecurityRulesClient) (SecurityRule, error)
}

// SecurityRulesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SecurityRulesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SecurityRulesClient) (autorest.Response, error)
}

// String ...
type String struct {
	autorest.Response `json:"-"`
	Value             *string `json:"value,omitempty"`
}

// Subnet subnet in a VirtualNetwork resource
type Subnet struct {
	autorest.Response       `json:"-"`
	*SubnetPropertiesFormat `json:"properties,omitempty"`
	// Name - Gets or sets the name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for Subnet.
func (s Subnet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.SubnetPropertiesFormat != nil {
		objectMap["properties"] = s.SubnetPropertiesFormat
	}
	if s.Name != nil {
		objectMap["name"] = s.Name
	}
	if s.Etag != nil {
		objectMap["etag"] = s.Etag
	}
	if s.ID != nil {
		objectMap["id"] = s.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Subnet struct.
func (s *Subnet) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var subnetPropertiesFormat SubnetPropertiesFormat
				err = json.Unmarshal(*v, &subnetPropertiesFormat)
				if err != nil {
					return err
				}
				s.SubnetPropertiesFormat = &subnetPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				s.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		}
	}

	return nil
}

// SubnetListResult response for ListSubnets Api service callRetrieves all subnet that belongs to a virtual
// network
type SubnetListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets the subnets in a virtual network
	Value *[]Subnet `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SubnetListResultIterator provides access to a complete listing of Subnet values.
type SubnetListResultIterator struct {
	i    int
	page SubnetListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SubnetListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubnetListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SubnetListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SubnetListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SubnetListResultIterator) Response() SubnetListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SubnetListResultIterator) Value() Subnet {
	if !iter.page.NotDone() {
		return Subnet{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SubnetListResultIterator type.
func NewSubnetListResultIterator(page SubnetListResultPage) SubnetListResultIterator {
	return SubnetListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (slr SubnetListResult) IsEmpty() bool {
	return slr.Value == nil || len(*slr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (slr SubnetListResult) hasNextLink() bool {
	return slr.NextLink != nil && len(*slr.NextLink) != 0
}

// subnetListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (slr SubnetListResult) subnetListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !slr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(slr.NextLink)))
}

// SubnetListResultPage contains a page of Subnet values.
type SubnetListResultPage struct {
	fn  func(context.Context, SubnetListResult) (SubnetListResult, error)
	slr SubnetListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SubnetListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubnetListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.slr)
		if err != nil {
			return err
		}
		page.slr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SubnetListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SubnetListResultPage) NotDone() bool {
	return !page.slr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SubnetListResultPage) Response() SubnetListResult {
	return page.slr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SubnetListResultPage) Values() []Subnet {
	if page.slr.IsEmpty() {
		return nil
	}
	return *page.slr.Value
}

// Creates a new instance of the SubnetListResultPage type.
func NewSubnetListResultPage(cur SubnetListResult, getNextPage func(context.Context, SubnetListResult) (SubnetListResult, error)) SubnetListResultPage {
	return SubnetListResultPage{
		fn:  getNextPage,
		slr: cur,
	}
}

// SubnetPropertiesFormat ...
type SubnetPropertiesFormat struct {
	// AddressPrefix - Gets or sets Address prefix for the subnet.
	AddressPrefix *string `json:"addressPrefix,omitempty"`
	// NetworkSecurityGroup - Gets or sets the reference of the NetworkSecurityGroup resource
	NetworkSecurityGroup *SecurityGroup `json:"networkSecurityGroup,omitempty"`
	// RouteTable - Gets or sets the reference of the RouteTable resource
	RouteTable *RouteTable `json:"routeTable,omitempty"`
	// IPConfigurations - READ-ONLY; Gets array of references to the network interface IP configurations using subnet
	IPConfigurations *[]IPConfiguration `json:"ipConfigurations,omitempty"`
	// ResourceNavigationLinks - Gets array of references to the external resources using subnet
	ResourceNavigationLinks *[]ResourceNavigationLink `json:"resourceNavigationLinks,omitempty"`
	// ProvisioningState - Gets provisioning state of the resource
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for SubnetPropertiesFormat.
func (spf SubnetPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spf.AddressPrefix != nil {
		objectMap["addressPrefix"] = spf.AddressPrefix
	}
	if spf.NetworkSecurityGroup != nil {
		objectMap["networkSecurityGroup"] = spf.NetworkSecurityGroup
	}
	if spf.RouteTable != nil {
		objectMap["routeTable"] = spf.RouteTable
	}
	if spf.ResourceNavigationLinks != nil {
		objectMap["resourceNavigationLinks"] = spf.ResourceNavigationLinks
	}
	if spf.ProvisioningState != nil {
		objectMap["provisioningState"] = spf.ProvisioningState
	}
	return json.Marshal(objectMap)
}

// SubnetsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SubnetsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SubnetsClient) (Subnet, error)
}

// SubnetsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SubnetsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SubnetsClient) (autorest.Response, error)
}

// SubResource ...
type SubResource struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// Usage describes Network Resource Usage.
type Usage struct {
	// Unit - Gets or sets an enum describing the unit of measurement.
	Unit *string `json:"unit,omitempty"`
	// CurrentValue - Gets or sets the current value of the usage.
	CurrentValue *int64 `json:"currentValue,omitempty"`
	// Limit - Gets or sets the limit of usage.
	Limit *int64 `json:"limit,omitempty"`
	// Name - Gets or sets the name of the type of usage.
	Name *UsageName `json:"name,omitempty"`
}

// UsageName the Usage Names.
type UsageName struct {
	// Value - Gets or sets a string describing the resource name.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - Gets or sets a localized string describing the resource name.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// UsagesListResult the List Usages operation response.
type UsagesListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets the list Network Resource Usages.
	Value *[]Usage `json:"value,omitempty"`
	// NextLink - URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// UsagesListResultIterator provides access to a complete listing of Usage values.
type UsagesListResultIterator struct {
	i    int
	page UsagesListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *UsagesListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UsagesListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *UsagesListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter UsagesListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter UsagesListResultIterator) Response() UsagesListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter UsagesListResultIterator) Value() Usage {
	if !iter.page.NotDone() {
		return Usage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the UsagesListResultIterator type.
func NewUsagesListResultIterator(page UsagesListResultPage) UsagesListResultIterator {
	return UsagesListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ulr UsagesListResult) IsEmpty() bool {
	return ulr.Value == nil || len(*ulr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ulr UsagesListResult) hasNextLink() bool {
	return ulr.NextLink != nil && len(*ulr.NextLink) != 0
}

// usagesListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ulr UsagesListResult) usagesListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ulr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ulr.NextLink)))
}

// UsagesListResultPage contains a page of Usage values.
type UsagesListResultPage struct {
	fn  func(context.Context, UsagesListResult) (UsagesListResult, error)
	ulr UsagesListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *UsagesListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UsagesListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ulr)
		if err != nil {
			return err
		}
		page.ulr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *UsagesListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page UsagesListResultPage) NotDone() bool {
	return !page.ulr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page UsagesListResultPage) Response() UsagesListResult {
	return page.ulr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page UsagesListResultPage) Values() []Usage {
	if page.ulr.IsEmpty() {
		return nil
	}
	return *page.ulr.Value
}

// Creates a new instance of the UsagesListResultPage type.
func NewUsagesListResultPage(cur UsagesListResult, getNextPage func(context.Context, UsagesListResult) (UsagesListResult, error)) UsagesListResultPage {
	return UsagesListResultPage{
		fn:  getNextPage,
		ulr: cur,
	}
}

// VirtualNetwork virtual Network resource
type VirtualNetwork struct {
	autorest.Response               `json:"-"`
	*VirtualNetworkPropertiesFormat `json:"properties,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VirtualNetwork.
func (vn VirtualNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vn.VirtualNetworkPropertiesFormat != nil {
		objectMap["properties"] = vn.VirtualNetworkPropertiesFormat
	}
	if vn.Etag != nil {
		objectMap["etag"] = vn.Etag
	}
	if vn.ID != nil {
		objectMap["id"] = vn.ID
	}
	if vn.Location != nil {
		objectMap["location"] = vn.Location
	}
	if vn.Tags != nil {
		objectMap["tags"] = vn.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualNetwork struct.
func (vn *VirtualNetwork) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualNetworkPropertiesFormat VirtualNetworkPropertiesFormat
				err = json.Unmarshal(*v, &virtualNetworkPropertiesFormat)
				if err != nil {
					return err
				}
				vn.VirtualNetworkPropertiesFormat = &virtualNetworkPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				vn.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vn.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vn.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vn.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vn.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vn.Tags = tags
			}
		}
	}

	return nil
}

// VirtualNetworkGateway a common class for general resource information
type VirtualNetworkGateway struct {
	autorest.Response                      `json:"-"`
	*VirtualNetworkGatewayPropertiesFormat `json:"properties,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkGateway.
func (vng VirtualNetworkGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vng.VirtualNetworkGatewayPropertiesFormat != nil {
		objectMap["properties"] = vng.VirtualNetworkGatewayPropertiesFormat
	}
	if vng.Etag != nil {
		objectMap["etag"] = vng.Etag
	}
	if vng.ID != nil {
		objectMap["id"] = vng.ID
	}
	if vng.Location != nil {
		objectMap["location"] = vng.Location
	}
	if vng.Tags != nil {
		objectMap["tags"] = vng.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualNetworkGateway struct.
func (vng *VirtualNetworkGateway) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualNetworkGatewayPropertiesFormat VirtualNetworkGatewayPropertiesFormat
				err = json.Unmarshal(*v, &virtualNetworkGatewayPropertiesFormat)
				if err != nil {
					return err
				}
				vng.VirtualNetworkGatewayPropertiesFormat = &virtualNetworkGatewayPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				vng.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vng.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vng.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vng.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vng.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vng.Tags = tags
			}
		}
	}

	return nil
}

// VirtualNetworkGatewayConnection a common class for general resource information
type VirtualNetworkGatewayConnection struct {
	autorest.Response                                `json:"-"`
	*VirtualNetworkGatewayConnectionPropertiesFormat `json:"properties,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkGatewayConnection.
func (vngc VirtualNetworkGatewayConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vngc.VirtualNetworkGatewayConnectionPropertiesFormat != nil {
		objectMap["properties"] = vngc.VirtualNetworkGatewayConnectionPropertiesFormat
	}
	if vngc.Etag != nil {
		objectMap["etag"] = vngc.Etag
	}
	if vngc.ID != nil {
		objectMap["id"] = vngc.ID
	}
	if vngc.Location != nil {
		objectMap["location"] = vngc.Location
	}
	if vngc.Tags != nil {
		objectMap["tags"] = vngc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualNetworkGatewayConnection struct.
func (vngc *VirtualNetworkGatewayConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualNetworkGatewayConnectionPropertiesFormat VirtualNetworkGatewayConnectionPropertiesFormat
				err = json.Unmarshal(*v, &virtualNetworkGatewayConnectionPropertiesFormat)
				if err != nil {
					return err
				}
				vngc.VirtualNetworkGatewayConnectionPropertiesFormat = &virtualNetworkGatewayConnectionPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				vngc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vngc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vngc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vngc.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vngc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vngc.Tags = tags
			}
		}
	}

	return nil
}

// VirtualNetworkGatewayConnectionListResult response for ListVirtualNetworkGatewayConnections Api service
// call
type VirtualNetworkGatewayConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets List of VirtualNetworkGatewayConnections that exists in a resource group
	Value *[]VirtualNetworkGatewayConnection `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualNetworkGatewayConnectionListResultIterator provides access to a complete listing of
// VirtualNetworkGatewayConnection values.
type VirtualNetworkGatewayConnectionListResultIterator struct {
	i    int
	page VirtualNetworkGatewayConnectionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualNetworkGatewayConnectionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkGatewayConnectionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VirtualNetworkGatewayConnectionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualNetworkGatewayConnectionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualNetworkGatewayConnectionListResultIterator) Response() VirtualNetworkGatewayConnectionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualNetworkGatewayConnectionListResultIterator) Value() VirtualNetworkGatewayConnection {
	if !iter.page.NotDone() {
		return VirtualNetworkGatewayConnection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VirtualNetworkGatewayConnectionListResultIterator type.
func NewVirtualNetworkGatewayConnectionListResultIterator(page VirtualNetworkGatewayConnectionListResultPage) VirtualNetworkGatewayConnectionListResultIterator {
	return VirtualNetworkGatewayConnectionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vngclr VirtualNetworkGatewayConnectionListResult) IsEmpty() bool {
	return vngclr.Value == nil || len(*vngclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vngclr VirtualNetworkGatewayConnectionListResult) hasNextLink() bool {
	return vngclr.NextLink != nil && len(*vngclr.NextLink) != 0
}

// virtualNetworkGatewayConnectionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vngclr VirtualNetworkGatewayConnectionListResult) virtualNetworkGatewayConnectionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !vngclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vngclr.NextLink)))
}

// VirtualNetworkGatewayConnectionListResultPage contains a page of VirtualNetworkGatewayConnection values.
type VirtualNetworkGatewayConnectionListResultPage struct {
	fn     func(context.Context, VirtualNetworkGatewayConnectionListResult) (VirtualNetworkGatewayConnectionListResult, error)
	vngclr VirtualNetworkGatewayConnectionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualNetworkGatewayConnectionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkGatewayConnectionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vngclr)
		if err != nil {
			return err
		}
		page.vngclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VirtualNetworkGatewayConnectionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualNetworkGatewayConnectionListResultPage) NotDone() bool {
	return !page.vngclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualNetworkGatewayConnectionListResultPage) Response() VirtualNetworkGatewayConnectionListResult {
	return page.vngclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualNetworkGatewayConnectionListResultPage) Values() []VirtualNetworkGatewayConnection {
	if page.vngclr.IsEmpty() {
		return nil
	}
	return *page.vngclr.Value
}

// Creates a new instance of the VirtualNetworkGatewayConnectionListResultPage type.
func NewVirtualNetworkGatewayConnectionListResultPage(cur VirtualNetworkGatewayConnectionListResult, getNextPage func(context.Context, VirtualNetworkGatewayConnectionListResult) (VirtualNetworkGatewayConnectionListResult, error)) VirtualNetworkGatewayConnectionListResultPage {
	return VirtualNetworkGatewayConnectionListResultPage{
		fn:     getNextPage,
		vngclr: cur,
	}
}

// VirtualNetworkGatewayConnectionPropertiesFormat virtualNetworkGatewayConnection properties
type VirtualNetworkGatewayConnectionPropertiesFormat struct {
	// AuthorizationKey - The authorizationKey.
	AuthorizationKey       *string                `json:"authorizationKey,omitempty"`
	VirtualNetworkGateway1 *VirtualNetworkGateway `json:"virtualNetworkGateway1,omitempty"`
	VirtualNetworkGateway2 *VirtualNetworkGateway `json:"virtualNetworkGateway2,omitempty"`
	LocalNetworkGateway2   *LocalNetworkGateway   `json:"localNetworkGateway2,omitempty"`
	// ConnectionType - Gateway connection type IPsec/Dedicated/VpnClient/Vnet2Vnet. Possible values include: 'IPsec', 'Vnet2Vnet', 'ExpressRoute', 'VPNClient'
	ConnectionType VirtualNetworkGatewayConnectionType `json:"connectionType,omitempty"`
	// RoutingWeight - The Routing weight.
	RoutingWeight *int32 `json:"routingWeight,omitempty"`
	// SharedKey - The IPsec share key.
	SharedKey *string `json:"sharedKey,omitempty"`
	// ConnectionStatus - Virtual network Gateway connection status. Possible values include: 'Unknown', 'Connecting', 'Connected', 'NotConnected'
	ConnectionStatus VirtualNetworkGatewayConnectionStatus `json:"connectionStatus,omitempty"`
	// EgressBytesTransferred - The Egress Bytes Transferred in this connection
	EgressBytesTransferred *int64 `json:"egressBytesTransferred,omitempty"`
	// IngressBytesTransferred - The Ingress Bytes Transferred in this connection
	IngressBytesTransferred *int64 `json:"ingressBytesTransferred,omitempty"`
	// Peer - The reference to peerings resource.
	Peer *SubResource `json:"peer,omitempty"`
	// EnableBgp - EnableBgp Flag
	EnableBgp *bool `json:"enableBgp,omitempty"`
	// ResourceGUID - Gets or sets resource guid property of the VirtualNetworkGatewayConnection resource
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - Gets provisioning state of the VirtualNetworkGatewayConnection resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// VirtualNetworkGatewayConnectionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type VirtualNetworkGatewayConnectionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualNetworkGatewayConnectionsClient) (VirtualNetworkGatewayConnection, error)
}

// VirtualNetworkGatewayConnectionsDeleteFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type VirtualNetworkGatewayConnectionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualNetworkGatewayConnectionsClient) (autorest.Response, error)
}

// VirtualNetworkGatewayConnectionsResetSharedKeyFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type VirtualNetworkGatewayConnectionsResetSharedKeyFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualNetworkGatewayConnectionsClient) (ConnectionResetSharedKey, error)
}

// VirtualNetworkGatewayConnectionsSetSharedKeyFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type VirtualNetworkGatewayConnectionsSetSharedKeyFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualNetworkGatewayConnectionsClient) (ConnectionSharedKey, error)
}

// VirtualNetworkGatewayIPConfiguration ipConfiguration for Virtual network gateway
type VirtualNetworkGatewayIPConfiguration struct {
	*VirtualNetworkGatewayIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkGatewayIPConfiguration.
func (vngic VirtualNetworkGatewayIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vngic.VirtualNetworkGatewayIPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = vngic.VirtualNetworkGatewayIPConfigurationPropertiesFormat
	}
	if vngic.Name != nil {
		objectMap["name"] = vngic.Name
	}
	if vngic.Etag != nil {
		objectMap["etag"] = vngic.Etag
	}
	if vngic.ID != nil {
		objectMap["id"] = vngic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualNetworkGatewayIPConfiguration struct.
func (vngic *VirtualNetworkGatewayIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualNetworkGatewayIPConfigurationPropertiesFormat VirtualNetworkGatewayIPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &virtualNetworkGatewayIPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				vngic.VirtualNetworkGatewayIPConfigurationPropertiesFormat = &virtualNetworkGatewayIPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vngic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				vngic.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vngic.ID = &ID
			}
		}
	}

	return nil
}

// VirtualNetworkGatewayIPConfigurationPropertiesFormat properties of VirtualNetworkGatewayIPConfiguration
type VirtualNetworkGatewayIPConfigurationPropertiesFormat struct {
	// PrivateIPAllocationMethod - Gets or sets PrivateIP allocation method. Possible values include: 'Static', 'Dynamic'
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	// Subnet - Gets or sets the reference of the subnet resource
	Subnet *SubResource `json:"subnet,omitempty"`
	// PublicIPAddress - Gets or sets the reference of the PublicIP resource
	PublicIPAddress *SubResource `json:"publicIPAddress,omitempty"`
	// ProvisioningState - Gets provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// VirtualNetworkGatewayListResult response for ListVirtualNetworkGateways Api service call
type VirtualNetworkGatewayListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets List of VirtualNetworkGateways that exists in a resource group
	Value *[]VirtualNetworkGateway `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualNetworkGatewayListResultIterator provides access to a complete listing of VirtualNetworkGateway
// values.
type VirtualNetworkGatewayListResultIterator struct {
	i    int
	page VirtualNetworkGatewayListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualNetworkGatewayListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkGatewayListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VirtualNetworkGatewayListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualNetworkGatewayListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualNetworkGatewayListResultIterator) Response() VirtualNetworkGatewayListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualNetworkGatewayListResultIterator) Value() VirtualNetworkGateway {
	if !iter.page.NotDone() {
		return VirtualNetworkGateway{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VirtualNetworkGatewayListResultIterator type.
func NewVirtualNetworkGatewayListResultIterator(page VirtualNetworkGatewayListResultPage) VirtualNetworkGatewayListResultIterator {
	return VirtualNetworkGatewayListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vnglr VirtualNetworkGatewayListResult) IsEmpty() bool {
	return vnglr.Value == nil || len(*vnglr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vnglr VirtualNetworkGatewayListResult) hasNextLink() bool {
	return vnglr.NextLink != nil && len(*vnglr.NextLink) != 0
}

// virtualNetworkGatewayListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vnglr VirtualNetworkGatewayListResult) virtualNetworkGatewayListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !vnglr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vnglr.NextLink)))
}

// VirtualNetworkGatewayListResultPage contains a page of VirtualNetworkGateway values.
type VirtualNetworkGatewayListResultPage struct {
	fn    func(context.Context, VirtualNetworkGatewayListResult) (VirtualNetworkGatewayListResult, error)
	vnglr VirtualNetworkGatewayListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualNetworkGatewayListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkGatewayListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vnglr)
		if err != nil {
			return err
		}
		page.vnglr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VirtualNetworkGatewayListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualNetworkGatewayListResultPage) NotDone() bool {
	return !page.vnglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualNetworkGatewayListResultPage) Response() VirtualNetworkGatewayListResult {
	return page.vnglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualNetworkGatewayListResultPage) Values() []VirtualNetworkGateway {
	if page.vnglr.IsEmpty() {
		return nil
	}
	return *page.vnglr.Value
}

// Creates a new instance of the VirtualNetworkGatewayListResultPage type.
func NewVirtualNetworkGatewayListResultPage(cur VirtualNetworkGatewayListResult, getNextPage func(context.Context, VirtualNetworkGatewayListResult) (VirtualNetworkGatewayListResult, error)) VirtualNetworkGatewayListResultPage {
	return VirtualNetworkGatewayListResultPage{
		fn:    getNextPage,
		vnglr: cur,
	}
}

// VirtualNetworkGatewayPropertiesFormat virtualNetworkGateway properties
type VirtualNetworkGatewayPropertiesFormat struct {
	// IPConfigurations - IpConfigurations for Virtual network gateway.
	IPConfigurations *[]VirtualNetworkGatewayIPConfiguration `json:"ipConfigurations,omitempty"`
	// GatewayType - The type of this virtual network gateway. Possible values include: 'VirtualNetworkGatewayTypeVpn', 'VirtualNetworkGatewayTypeExpressRoute'
	GatewayType VirtualNetworkGatewayType `json:"gatewayType,omitempty"`
	// VpnType - The type of this virtual network gateway. Possible values include: 'PolicyBased', 'RouteBased'
	VpnType VpnType `json:"vpnType,omitempty"`
	// EnableBgp - EnableBgp Flag
	EnableBgp *bool `json:"enableBgp,omitempty"`
	// ActiveActive - ActiveActive flag
	ActiveActive *bool `json:"activeActive,omitempty"`
	// GatewayDefaultSite - Gets or sets the reference of the LocalNetworkGateway resource which represents Local network site having default routes. Assign Null value in case of removing existing default site setting.
	GatewayDefaultSite *SubResource `json:"gatewayDefaultSite,omitempty"`
	// Sku - Gets or sets the reference of the VirtualNetworkGatewaySku resource which represents the sku selected for Virtual network gateway.
	Sku *VirtualNetworkGatewaySku `json:"sku,omitempty"`
	// VpnClientConfiguration - Gets or sets the reference of the VpnClientConfiguration resource which represents the P2S VpnClient configurations.
	VpnClientConfiguration *VpnClientConfiguration `json:"vpnClientConfiguration,omitempty"`
	// BgpSettings - Virtual network gateway's BGP speaker settings
	BgpSettings *BgpSettings `json:"bgpSettings,omitempty"`
	// ResourceGUID - Gets or sets resource guid property of the VirtualNetworkGateway resource
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - Gets provisioning state of the VirtualNetworkGateway resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// VirtualNetworkGatewaysCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualNetworkGatewaysCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualNetworkGatewaysClient) (VirtualNetworkGateway, error)
}

// VirtualNetworkGatewaysDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualNetworkGatewaysDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualNetworkGatewaysClient) (autorest.Response, error)
}

// VirtualNetworkGatewaySku virtualNetworkGatewaySku details
type VirtualNetworkGatewaySku struct {
	// Name - Gateway sku name -Basic/HighPerformance/Standard/UltraPerformance. Possible values include: 'VirtualNetworkGatewaySkuNameBasic', 'VirtualNetworkGatewaySkuNameHighPerformance', 'VirtualNetworkGatewaySkuNameStandard', 'VirtualNetworkGatewaySkuNameUltraPerformance'
	Name VirtualNetworkGatewaySkuName `json:"name,omitempty"`
	// Tier - Gateway sku tier -Basic/HighPerformance/Standard/UltraPerformance. Possible values include: 'VirtualNetworkGatewaySkuTierBasic', 'VirtualNetworkGatewaySkuTierHighPerformance', 'VirtualNetworkGatewaySkuTierStandard', 'VirtualNetworkGatewaySkuTierUltraPerformance'
	Tier VirtualNetworkGatewaySkuTier `json:"tier,omitempty"`
	// Capacity - The capacity
	Capacity *int32 `json:"capacity,omitempty"`
}

// VirtualNetworkGatewaysResetFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualNetworkGatewaysResetFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualNetworkGatewaysClient) (VirtualNetworkGateway, error)
}

// VirtualNetworkListResult response for ListVirtualNetworks Api service call
type VirtualNetworkListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets list of VirtualNetworks in a resource group
	Value *[]VirtualNetwork `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualNetworkListResultIterator provides access to a complete listing of VirtualNetwork values.
type VirtualNetworkListResultIterator struct {
	i    int
	page VirtualNetworkListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualNetworkListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VirtualNetworkListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualNetworkListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualNetworkListResultIterator) Response() VirtualNetworkListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualNetworkListResultIterator) Value() VirtualNetwork {
	if !iter.page.NotDone() {
		return VirtualNetwork{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VirtualNetworkListResultIterator type.
func NewVirtualNetworkListResultIterator(page VirtualNetworkListResultPage) VirtualNetworkListResultIterator {
	return VirtualNetworkListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vnlr VirtualNetworkListResult) IsEmpty() bool {
	return vnlr.Value == nil || len(*vnlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vnlr VirtualNetworkListResult) hasNextLink() bool {
	return vnlr.NextLink != nil && len(*vnlr.NextLink) != 0
}

// virtualNetworkListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vnlr VirtualNetworkListResult) virtualNetworkListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !vnlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vnlr.NextLink)))
}

// VirtualNetworkListResultPage contains a page of VirtualNetwork values.
type VirtualNetworkListResultPage struct {
	fn   func(context.Context, VirtualNetworkListResult) (VirtualNetworkListResult, error)
	vnlr VirtualNetworkListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualNetworkListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vnlr)
		if err != nil {
			return err
		}
		page.vnlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VirtualNetworkListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualNetworkListResultPage) NotDone() bool {
	return !page.vnlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualNetworkListResultPage) Response() VirtualNetworkListResult {
	return page.vnlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualNetworkListResultPage) Values() []VirtualNetwork {
	if page.vnlr.IsEmpty() {
		return nil
	}
	return *page.vnlr.Value
}

// Creates a new instance of the VirtualNetworkListResultPage type.
func NewVirtualNetworkListResultPage(cur VirtualNetworkListResult, getNextPage func(context.Context, VirtualNetworkListResult) (VirtualNetworkListResult, error)) VirtualNetworkListResultPage {
	return VirtualNetworkListResultPage{
		fn:   getNextPage,
		vnlr: cur,
	}
}

// VirtualNetworkPeering peerings in a VirtualNetwork resource
type VirtualNetworkPeering struct {
	autorest.Response                      `json:"-"`
	*VirtualNetworkPeeringPropertiesFormat `json:"properties,omitempty"`
	// Name - Gets or sets the name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkPeering.
func (vnp VirtualNetworkPeering) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vnp.VirtualNetworkPeeringPropertiesFormat != nil {
		objectMap["properties"] = vnp.VirtualNetworkPeeringPropertiesFormat
	}
	if vnp.Name != nil {
		objectMap["name"] = vnp.Name
	}
	if vnp.Etag != nil {
		objectMap["etag"] = vnp.Etag
	}
	if vnp.ID != nil {
		objectMap["id"] = vnp.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualNetworkPeering struct.
func (vnp *VirtualNetworkPeering) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualNetworkPeeringPropertiesFormat VirtualNetworkPeeringPropertiesFormat
				err = json.Unmarshal(*v, &virtualNetworkPeeringPropertiesFormat)
				if err != nil {
					return err
				}
				vnp.VirtualNetworkPeeringPropertiesFormat = &virtualNetworkPeeringPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vnp.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				vnp.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vnp.ID = &ID
			}
		}
	}

	return nil
}

// VirtualNetworkPeeringListResult response for ListSubnets Api service callRetrieves all subnet that
// belongs to a virtual network
type VirtualNetworkPeeringListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets the peerings in a virtual network
	Value *[]VirtualNetworkPeering `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualNetworkPeeringListResultIterator provides access to a complete listing of VirtualNetworkPeering
// values.
type VirtualNetworkPeeringListResultIterator struct {
	i    int
	page VirtualNetworkPeeringListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualNetworkPeeringListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkPeeringListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VirtualNetworkPeeringListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualNetworkPeeringListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualNetworkPeeringListResultIterator) Response() VirtualNetworkPeeringListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualNetworkPeeringListResultIterator) Value() VirtualNetworkPeering {
	if !iter.page.NotDone() {
		return VirtualNetworkPeering{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VirtualNetworkPeeringListResultIterator type.
func NewVirtualNetworkPeeringListResultIterator(page VirtualNetworkPeeringListResultPage) VirtualNetworkPeeringListResultIterator {
	return VirtualNetworkPeeringListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vnplr VirtualNetworkPeeringListResult) IsEmpty() bool {
	return vnplr.Value == nil || len(*vnplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vnplr VirtualNetworkPeeringListResult) hasNextLink() bool {
	return vnplr.NextLink != nil && len(*vnplr.NextLink) != 0
}

// virtualNetworkPeeringListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vnplr VirtualNetworkPeeringListResult) virtualNetworkPeeringListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !vnplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vnplr.NextLink)))
}

// VirtualNetworkPeeringListResultPage contains a page of VirtualNetworkPeering values.
type VirtualNetworkPeeringListResultPage struct {
	fn    func(context.Context, VirtualNetworkPeeringListResult) (VirtualNetworkPeeringListResult, error)
	vnplr VirtualNetworkPeeringListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualNetworkPeeringListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkPeeringListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vnplr)
		if err != nil {
			return err
		}
		page.vnplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VirtualNetworkPeeringListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualNetworkPeeringListResultPage) NotDone() bool {
	return !page.vnplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualNetworkPeeringListResultPage) Response() VirtualNetworkPeeringListResult {
	return page.vnplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualNetworkPeeringListResultPage) Values() []VirtualNetworkPeering {
	if page.vnplr.IsEmpty() {
		return nil
	}
	return *page.vnplr.Value
}

// Creates a new instance of the VirtualNetworkPeeringListResultPage type.
func NewVirtualNetworkPeeringListResultPage(cur VirtualNetworkPeeringListResult, getNextPage func(context.Context, VirtualNetworkPeeringListResult) (VirtualNetworkPeeringListResult, error)) VirtualNetworkPeeringListResultPage {
	return VirtualNetworkPeeringListResultPage{
		fn:    getNextPage,
		vnplr: cur,
	}
}

// VirtualNetworkPeeringPropertiesFormat ...
type VirtualNetworkPeeringPropertiesFormat struct {
	// AllowVirtualNetworkAccess - Gets or sets whether the VMs in the linked virtual network space would be able to access all the VMs in local Virtual network space
	AllowVirtualNetworkAccess *bool `json:"allowVirtualNetworkAccess,omitempty"`
	// AllowForwardedTraffic - Gets or sets whether the forwarded traffic from the VMs in the remote virtual network will be allowed/disallowed
	AllowForwardedTraffic *bool `json:"allowForwardedTraffic,omitempty"`
	// AllowGatewayTransit - Gets or sets if gatewayLinks can be used in remote virtual network’s link to this virtual network
	AllowGatewayTransit *bool `json:"allowGatewayTransit,omitempty"`
	// UseRemoteGateways - Gets or sets if remote gateways can be used on this virtual network. If the flag is set to true, and allowGatewayTransit on remote peering is also true, virtual network will use gateways of remote virtual network for transit. Only 1 peering can have this flag set to true. This flag cannot be set if virtual network already has a gateway.
	UseRemoteGateways *bool `json:"useRemoteGateways,omitempty"`
	// RemoteVirtualNetwork - Gets or sets the reference of the remote virtual network
	RemoteVirtualNetwork *SubResource `json:"remoteVirtualNetwork,omitempty"`
	// PeeringState - Gets the status of the virtual network peering. Possible values include: 'VirtualNetworkPeeringStateInitiated', 'VirtualNetworkPeeringStateConnected', 'VirtualNetworkPeeringStateDisconnected'
	PeeringState VirtualNetworkPeeringState `json:"peeringState,omitempty"`
	// ProvisioningState - Gets provisioning state of the resource
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// VirtualNetworkPeeringsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualNetworkPeeringsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualNetworkPeeringsClient) (VirtualNetworkPeering, error)
}

// VirtualNetworkPeeringsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualNetworkPeeringsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualNetworkPeeringsClient) (autorest.Response, error)
}

// VirtualNetworkPropertiesFormat ...
type VirtualNetworkPropertiesFormat struct {
	// AddressSpace - Gets or sets AddressSpace that contains an array of IP address ranges that can be used by subnets
	AddressSpace *AddressSpace `json:"addressSpace,omitempty"`
	// DhcpOptions - Gets or sets DHCPOptions that contains an array of DNS servers available to VMs deployed in the virtual network
	DhcpOptions *DhcpOptions `json:"dhcpOptions,omitempty"`
	// Subnets - Gets or sets list of subnets in a VirtualNetwork
	Subnets *[]Subnet `json:"subnets,omitempty"`
	// VirtualNetworkPeerings - Gets or sets list of peerings in a VirtualNetwork
	VirtualNetworkPeerings *[]VirtualNetworkPeering `json:"VirtualNetworkPeerings,omitempty"`
	// ResourceGUID - Gets or sets resource guid property of the VirtualNetwork resource
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - Gets provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// VirtualNetworksCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualNetworksCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualNetworksClient) (VirtualNetwork, error)
}

// VirtualNetworksDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualNetworksDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualNetworksClient) (autorest.Response, error)
}

// VpnClientConfiguration vpnClientConfiguration for P2S client
type VpnClientConfiguration struct {
	// VpnClientAddressPool - Gets or sets the reference of the Address space resource which represents Address space for P2S VpnClient.
	VpnClientAddressPool *AddressSpace `json:"vpnClientAddressPool,omitempty"`
	// VpnClientRootCertificates - VpnClientRootCertificate for Virtual network gateway.
	VpnClientRootCertificates *[]VpnClientRootCertificate `json:"vpnClientRootCertificates,omitempty"`
	// VpnClientRevokedCertificates - VpnClientRevokedCertificate for Virtual network gateway.
	VpnClientRevokedCertificates *[]VpnClientRevokedCertificate `json:"vpnClientRevokedCertificates,omitempty"`
}

// VpnClientParameters vpnClientParameters
type VpnClientParameters struct {
	// ProcessorArchitecture - VPN client Processor Architecture -Amd64/X86. Possible values include: 'Amd64', 'X86'
	ProcessorArchitecture ProcessorArchitecture `json:"ProcessorArchitecture,omitempty"`
}

// VpnClientRevokedCertificate VPN client revoked certificate of virtual network gateway
type VpnClientRevokedCertificate struct {
	*VpnClientRevokedCertificatePropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for VpnClientRevokedCertificate.
func (vcrc VpnClientRevokedCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vcrc.VpnClientRevokedCertificatePropertiesFormat != nil {
		objectMap["properties"] = vcrc.VpnClientRevokedCertificatePropertiesFormat
	}
	if vcrc.Name != nil {
		objectMap["name"] = vcrc.Name
	}
	if vcrc.Etag != nil {
		objectMap["etag"] = vcrc.Etag
	}
	if vcrc.ID != nil {
		objectMap["id"] = vcrc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VpnClientRevokedCertificate struct.
func (vcrc *VpnClientRevokedCertificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var vpnClientRevokedCertificatePropertiesFormat VpnClientRevokedCertificatePropertiesFormat
				err = json.Unmarshal(*v, &vpnClientRevokedCertificatePropertiesFormat)
				if err != nil {
					return err
				}
				vcrc.VpnClientRevokedCertificatePropertiesFormat = &vpnClientRevokedCertificatePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vcrc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				vcrc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vcrc.ID = &ID
			}
		}
	}

	return nil
}

// VpnClientRevokedCertificatePropertiesFormat properties of the revoked VPN client certificate of virtual
// network gateway
type VpnClientRevokedCertificatePropertiesFormat struct {
	// Thumbprint - Gets or sets the revoked Vpn client certificate thumbprint
	Thumbprint *string `json:"thumbprint,omitempty"`
	// ProvisioningState - Gets provisioning state of the VPN client revoked certificate resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// VpnClientRootCertificate VPN client root certificate of virtual network gateway
type VpnClientRootCertificate struct {
	*VpnClientRootCertificatePropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for VpnClientRootCertificate.
func (vcrc VpnClientRootCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vcrc.VpnClientRootCertificatePropertiesFormat != nil {
		objectMap["properties"] = vcrc.VpnClientRootCertificatePropertiesFormat
	}
	if vcrc.Name != nil {
		objectMap["name"] = vcrc.Name
	}
	if vcrc.Etag != nil {
		objectMap["etag"] = vcrc.Etag
	}
	if vcrc.ID != nil {
		objectMap["id"] = vcrc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VpnClientRootCertificate struct.
func (vcrc *VpnClientRootCertificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var vpnClientRootCertificatePropertiesFormat VpnClientRootCertificatePropertiesFormat
				err = json.Unmarshal(*v, &vpnClientRootCertificatePropertiesFormat)
				if err != nil {
					return err
				}
				vcrc.VpnClientRootCertificatePropertiesFormat = &vpnClientRootCertificatePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vcrc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				vcrc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vcrc.ID = &ID
			}
		}
	}

	return nil
}

// VpnClientRootCertificatePropertiesFormat properties of SSL certificates of application gateway
type VpnClientRootCertificatePropertiesFormat struct {
	// PublicCertData - Gets or sets the certificate public data
	PublicCertData *string `json:"publicCertData,omitempty"`
	// ProvisioningState - Gets provisioning state of the VPN client root certificate resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}
