package azureadb2capi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/azureadb2c/mgmt/2020-05-01-preview/azureadb2c"
	"github.com/Azure/go-autorest/autorest"
)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result azureadb2c.OperationListResult, err error)
}

var _ OperationsClientAPI = (*azureadb2c.OperationsClient)(nil)

// GuestUsagesClientAPI contains the set of methods on the GuestUsagesClient type.
type GuestUsagesClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, resourceName string, resource *azureadb2c.GuestUsagesResource) (result azureadb2c.GuestUsagesResource, err error)
	Delete(ctx context.Context, resourceGroupName string, resourceName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, resourceName string) (result azureadb2c.GuestUsagesResource, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result azureadb2c.GuestUsagesResourceList, err error)
	ListBySubscription(ctx context.Context) (result azureadb2c.GuestUsagesResourceList, err error)
	Update(ctx context.Context, resourceGroupName string, resourceName string, resourcePatch *azureadb2c.GuestUsagesResourcePatch) (result azureadb2c.GuestUsagesResource, err error)
}

var _ GuestUsagesClientAPI = (*azureadb2c.GuestUsagesClient)(nil)
