package managednetwork

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/managednetwork/mgmt/2019-06-01-preview/managednetwork"

// ConnectivityCollection the collection of Connectivity related groups and policies within the Managed
// Network
type ConnectivityCollection struct {
	// Groups - READ-ONLY; The collection of connectivity related Managed Network Groups within the Managed Network
	Groups *[]Group `json:"groups,omitempty"`
	// Peerings - READ-ONLY; The collection of Managed Network Peering Policies within the Managed Network
	Peerings *[]PeeringPolicy `json:"peerings,omitempty"`
}

// ErrorResponse the error response that indicates why an operation has failed.
type ErrorResponse struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
}

// Group the Managed Network Group resource
type Group struct {
	autorest.Response `json:"-"`
	// GroupProperties - Gets or sets the properties of a network group
	*GroupProperties `json:"properties,omitempty"`
	// Kind - Responsibility role under which this Managed Network Group will be created. Possible values include: 'Connectivity'
	Kind Kind `json:"kind,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for Group.
func (g Group) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if g.GroupProperties != nil {
		objectMap["properties"] = g.GroupProperties
	}
	if g.Kind != "" {
		objectMap["kind"] = g.Kind
	}
	if g.Location != nil {
		objectMap["location"] = g.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Group struct.
func (g *Group) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var groupProperties GroupProperties
				err = json.Unmarshal(*v, &groupProperties)
				if err != nil {
					return err
				}
				g.GroupProperties = &groupProperties
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				g.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				g.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				g.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				g.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				g.Location = &location
			}
		}
	}

	return nil
}

// GroupListResult result of the request to list Managed Network Groups. It contains a list of groups and a
// URL link to get the next set of results.
type GroupListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets a page of ManagedNetworkGroup
	Value *[]Group `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// GroupListResultIterator provides access to a complete listing of Group values.
type GroupListResultIterator struct {
	i    int
	page GroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *GroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *GroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter GroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter GroupListResultIterator) Response() GroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter GroupListResultIterator) Value() Group {
	if !iter.page.NotDone() {
		return Group{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the GroupListResultIterator type.
func NewGroupListResultIterator(page GroupListResultPage) GroupListResultIterator {
	return GroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (glr GroupListResult) IsEmpty() bool {
	return glr.Value == nil || len(*glr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (glr GroupListResult) hasNextLink() bool {
	return glr.NextLink != nil && len(*glr.NextLink) != 0
}

// groupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (glr GroupListResult) groupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !glr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(glr.NextLink)))
}

// GroupListResultPage contains a page of Group values.
type GroupListResultPage struct {
	fn  func(context.Context, GroupListResult) (GroupListResult, error)
	glr GroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *GroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.glr)
		if err != nil {
			return err
		}
		page.glr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *GroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page GroupListResultPage) NotDone() bool {
	return !page.glr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page GroupListResultPage) Response() GroupListResult {
	return page.glr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page GroupListResultPage) Values() []Group {
	if page.glr.IsEmpty() {
		return nil
	}
	return *page.glr.Value
}

// Creates a new instance of the GroupListResultPage type.
func NewGroupListResultPage(cur GroupListResult, getNextPage func(context.Context, GroupListResult) (GroupListResult, error)) GroupListResultPage {
	return GroupListResultPage{
		fn:  getNextPage,
		glr: cur,
	}
}

// GroupProperties properties of a Managed Network Group
type GroupProperties struct {
	// ManagementGroups - The collection of management groups covered by the Managed Network
	ManagementGroups *[]ResourceID `json:"managementGroups,omitempty"`
	// Subscriptions - The collection of subscriptions covered by the Managed Network
	Subscriptions *[]ResourceID `json:"subscriptions,omitempty"`
	// VirtualNetworks - The collection of virtual nets covered by the Managed Network
	VirtualNetworks *[]ResourceID `json:"virtualNetworks,omitempty"`
	// Subnets - The collection of  subnets covered by the Managed Network
	Subnets *[]ResourceID `json:"subnets,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the ManagedNetwork resource. Possible values include: 'Updating', 'Deleting', 'Failed', 'Succeeded'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for GroupProperties.
func (gp GroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gp.ManagementGroups != nil {
		objectMap["managementGroups"] = gp.ManagementGroups
	}
	if gp.Subscriptions != nil {
		objectMap["subscriptions"] = gp.Subscriptions
	}
	if gp.VirtualNetworks != nil {
		objectMap["virtualNetworks"] = gp.VirtualNetworks
	}
	if gp.Subnets != nil {
		objectMap["subnets"] = gp.Subnets
	}
	return json.Marshal(objectMap)
}

// GroupsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type GroupsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GroupsClient) (Group, error)
}

// GroupsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type GroupsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GroupsClient) (autorest.Response, error)
}

// HubAndSpokePeeringPolicyProperties properties of a Hub and Spoke Peering Policy
type HubAndSpokePeeringPolicyProperties struct {
	// Type - Gets or sets the connectivity type of a network structure policy. Possible values include: 'HubAndSpokeTopology', 'MeshTopology'
	Type Type `json:"type,omitempty"`
	// Hub - Gets or sets the hub virtual network ID
	Hub *ResourceID `json:"hub,omitempty"`
	// Spokes - Gets or sets the spokes group IDs
	Spokes *[]ResourceID `json:"spokes,omitempty"`
	// Mesh - Gets or sets the mesh group IDs
	Mesh *[]ResourceID `json:"mesh,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the ManagedNetwork resource. Possible values include: 'Updating', 'Deleting', 'Failed', 'Succeeded'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for HubAndSpokePeeringPolicyProperties.
func (hasppp HubAndSpokePeeringPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hasppp.Type != "" {
		objectMap["type"] = hasppp.Type
	}
	if hasppp.Hub != nil {
		objectMap["hub"] = hasppp.Hub
	}
	if hasppp.Spokes != nil {
		objectMap["spokes"] = hasppp.Spokes
	}
	if hasppp.Mesh != nil {
		objectMap["mesh"] = hasppp.Mesh
	}
	return json.Marshal(objectMap)
}

// ListResult result of the request to list Managed Network. It contains a list of Managed Networks and a
// URL link to get the next set of results.
type ListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets a page of ManagedNetworks
	Value *[]ManagedNetwork `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListResultIterator provides access to a complete listing of ManagedNetwork values.
type ListResultIterator struct {
	i    int
	page ListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListResultIterator) Response() ListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListResultIterator) Value() ManagedNetwork {
	if !iter.page.NotDone() {
		return ManagedNetwork{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListResultIterator type.
func NewListResultIterator(page ListResultPage) ListResultIterator {
	return ListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lr ListResult) IsEmpty() bool {
	return lr.Value == nil || len(*lr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lr ListResult) hasNextLink() bool {
	return lr.NextLink != nil && len(*lr.NextLink) != 0
}

// listResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lr ListResult) listResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lr.NextLink)))
}

// ListResultPage contains a page of ManagedNetwork values.
type ListResultPage struct {
	fn func(context.Context, ListResult) (ListResult, error)
	lr ListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lr)
		if err != nil {
			return err
		}
		page.lr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListResultPage) NotDone() bool {
	return !page.lr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListResultPage) Response() ListResult {
	return page.lr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListResultPage) Values() []ManagedNetwork {
	if page.lr.IsEmpty() {
		return nil
	}
	return *page.lr.Value
}

// Creates a new instance of the ListResultPage type.
func NewListResultPage(cur ListResult, getNextPage func(context.Context, ListResult) (ListResult, error)) ListResultPage {
	return ListResultPage{
		fn: getNextPage,
		lr: cur,
	}
}

// ManagedNetwork the Managed Network resource
type ManagedNetwork struct {
	autorest.Response `json:"-"`
	// Properties - The MNC properties
	*Properties `json:"properties,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedNetwork.
func (mn ManagedNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mn.Properties != nil {
		objectMap["properties"] = mn.Properties
	}
	if mn.Tags != nil {
		objectMap["tags"] = mn.Tags
	}
	if mn.Location != nil {
		objectMap["location"] = mn.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedNetwork struct.
func (mn *ManagedNetwork) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var properties Properties
				err = json.Unmarshal(*v, &properties)
				if err != nil {
					return err
				}
				mn.Properties = &properties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mn.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mn.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mn.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mn.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mn.Location = &location
			}
		}
	}

	return nil
}

// ManagedNetworksDeleteFutureType an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedNetworksDeleteFutureType struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedNetworksClient) (autorest.Response, error)
}

// ManagedNetworksUpdateFutureType an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedNetworksUpdateFutureType struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedNetworksClient) (ManagedNetwork, error)
}

// MeshPeeringPolicyProperties properties of a Mesh Peering Policy
type MeshPeeringPolicyProperties struct {
	// Type - Gets or sets the connectivity type of a network structure policy. Possible values include: 'HubAndSpokeTopology', 'MeshTopology'
	Type Type `json:"type,omitempty"`
	// Hub - Gets or sets the hub virtual network ID
	Hub *ResourceID `json:"hub,omitempty"`
	// Spokes - Gets or sets the spokes group IDs
	Spokes *[]ResourceID `json:"spokes,omitempty"`
	// Mesh - Gets or sets the mesh group IDs
	Mesh *[]ResourceID `json:"mesh,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the ManagedNetwork resource. Possible values include: 'Updating', 'Deleting', 'Failed', 'Succeeded'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for MeshPeeringPolicyProperties.
func (mppp MeshPeeringPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mppp.Type != "" {
		objectMap["type"] = mppp.Type
	}
	if mppp.Hub != nil {
		objectMap["hub"] = mppp.Hub
	}
	if mppp.Spokes != nil {
		objectMap["spokes"] = mppp.Spokes
	}
	if mppp.Mesh != nil {
		objectMap["mesh"] = mppp.Mesh
	}
	return json.Marshal(objectMap)
}

// Operation REST API operation
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft.ManagedNetwork
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed: Profile, endpoint, etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
}

// OperationListResult result of the request to list Managed Network operations. It contains a list of
// operations and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Resource Provider operations supported by the Managed Network resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// PeeringPoliciesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PeeringPoliciesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PeeringPoliciesClient) (PeeringPolicy, error)
}

// PeeringPoliciesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PeeringPoliciesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PeeringPoliciesClient) (autorest.Response, error)
}

// PeeringPolicy the Managed Network Peering Policy resource
type PeeringPolicy struct {
	autorest.Response `json:"-"`
	// Properties - Gets or sets the properties of a Managed Network Policy
	Properties *PeeringPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for PeeringPolicy.
func (pp PeeringPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pp.Properties != nil {
		objectMap["properties"] = pp.Properties
	}
	if pp.Location != nil {
		objectMap["location"] = pp.Location
	}
	return json.Marshal(objectMap)
}

// PeeringPolicyListResult result of the request to list Managed Network Peering Policies. It contains a
// list of policies and a URL link to get the next set of results.
type PeeringPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets a page of Peering Policies
	Value *[]PeeringPolicy `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// PeeringPolicyListResultIterator provides access to a complete listing of PeeringPolicy values.
type PeeringPolicyListResultIterator struct {
	i    int
	page PeeringPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PeeringPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PeeringPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PeeringPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PeeringPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PeeringPolicyListResultIterator) Response() PeeringPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PeeringPolicyListResultIterator) Value() PeeringPolicy {
	if !iter.page.NotDone() {
		return PeeringPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PeeringPolicyListResultIterator type.
func NewPeeringPolicyListResultIterator(page PeeringPolicyListResultPage) PeeringPolicyListResultIterator {
	return PeeringPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pplr PeeringPolicyListResult) IsEmpty() bool {
	return pplr.Value == nil || len(*pplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pplr PeeringPolicyListResult) hasNextLink() bool {
	return pplr.NextLink != nil && len(*pplr.NextLink) != 0
}

// peeringPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pplr PeeringPolicyListResult) peeringPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !pplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pplr.NextLink)))
}

// PeeringPolicyListResultPage contains a page of PeeringPolicy values.
type PeeringPolicyListResultPage struct {
	fn   func(context.Context, PeeringPolicyListResult) (PeeringPolicyListResult, error)
	pplr PeeringPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PeeringPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PeeringPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pplr)
		if err != nil {
			return err
		}
		page.pplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PeeringPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PeeringPolicyListResultPage) NotDone() bool {
	return !page.pplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PeeringPolicyListResultPage) Response() PeeringPolicyListResult {
	return page.pplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PeeringPolicyListResultPage) Values() []PeeringPolicy {
	if page.pplr.IsEmpty() {
		return nil
	}
	return *page.pplr.Value
}

// Creates a new instance of the PeeringPolicyListResultPage type.
func NewPeeringPolicyListResultPage(cur PeeringPolicyListResult, getNextPage func(context.Context, PeeringPolicyListResult) (PeeringPolicyListResult, error)) PeeringPolicyListResultPage {
	return PeeringPolicyListResultPage{
		fn:   getNextPage,
		pplr: cur,
	}
}

// PeeringPolicyProperties properties of a Managed Network Peering Policy
type PeeringPolicyProperties struct {
	// Type - Gets or sets the connectivity type of a network structure policy. Possible values include: 'HubAndSpokeTopology', 'MeshTopology'
	Type Type `json:"type,omitempty"`
	// Hub - Gets or sets the hub virtual network ID
	Hub *ResourceID `json:"hub,omitempty"`
	// Spokes - Gets or sets the spokes group IDs
	Spokes *[]ResourceID `json:"spokes,omitempty"`
	// Mesh - Gets or sets the mesh group IDs
	Mesh *[]ResourceID `json:"mesh,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the ManagedNetwork resource. Possible values include: 'Updating', 'Deleting', 'Failed', 'Succeeded'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for PeeringPolicyProperties.
func (ppp PeeringPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ppp.Type != "" {
		objectMap["type"] = ppp.Type
	}
	if ppp.Hub != nil {
		objectMap["hub"] = ppp.Hub
	}
	if ppp.Spokes != nil {
		objectMap["spokes"] = ppp.Spokes
	}
	if ppp.Mesh != nil {
		objectMap["mesh"] = ppp.Mesh
	}
	return json.Marshal(objectMap)
}

// Properties properties of Managed Network
type Properties struct {
	// Scope - The collection of management groups, subscriptions, virtual networks, and subnets by the Managed Network. This is a read-only property that is reflective of all ScopeAssignments for this Managed Network
	Scope *Scope `json:"scope,omitempty"`
	// Connectivity - READ-ONLY; The collection of groups and policies concerned with connectivity
	Connectivity *ConnectivityCollection `json:"connectivity,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the ManagedNetwork resource. Possible values include: 'Updating', 'Deleting', 'Failed', 'Succeeded'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for Properties.
func (p Properties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.Scope != nil {
		objectMap["scope"] = p.Scope
	}
	return json.Marshal(objectMap)
}

// ProxyResource the resource model definition for a ARM proxy resource. It will have everything other than
// required location and tags
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pr.Location != nil {
		objectMap["location"] = pr.Location
	}
	return json.Marshal(objectMap)
}

// Resource the general resource model definition
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	return json.Marshal(objectMap)
}

// ResourceID generic pointer to a resource
type ResourceID struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// ResourceProperties base for resource properties.
type ResourceProperties struct {
	// ProvisioningState - READ-ONLY; Provisioning state of the ManagedNetwork resource. Possible values include: 'Updating', 'Deleting', 'Failed', 'Succeeded'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
}

// Scope scope of a Managed Network
type Scope struct {
	// ManagementGroups - The collection of management groups covered by the Managed Network
	ManagementGroups *[]ResourceID `json:"managementGroups,omitempty"`
	// Subscriptions - The collection of subscriptions covered by the Managed Network
	Subscriptions *[]ResourceID `json:"subscriptions,omitempty"`
	// VirtualNetworks - The collection of virtual nets covered by the Managed Network
	VirtualNetworks *[]ResourceID `json:"virtualNetworks,omitempty"`
	// Subnets - The collection of  subnets covered by the Managed Network
	Subnets *[]ResourceID `json:"subnets,omitempty"`
}

// ScopeAssignment the Managed Network resource
type ScopeAssignment struct {
	autorest.Response `json:"-"`
	// ScopeAssignmentProperties - The Scope Assignment properties
	*ScopeAssignmentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for ScopeAssignment.
func (sa ScopeAssignment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sa.ScopeAssignmentProperties != nil {
		objectMap["properties"] = sa.ScopeAssignmentProperties
	}
	if sa.Location != nil {
		objectMap["location"] = sa.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ScopeAssignment struct.
func (sa *ScopeAssignment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var scopeAssignmentProperties ScopeAssignmentProperties
				err = json.Unmarshal(*v, &scopeAssignmentProperties)
				if err != nil {
					return err
				}
				sa.ScopeAssignmentProperties = &scopeAssignmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sa.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sa.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sa.Location = &location
			}
		}
	}

	return nil
}

// ScopeAssignmentListResult result of the request to list ScopeAssignment. It contains a list of groups
// and a URL link to get the next set of results.
type ScopeAssignmentListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets a page of ScopeAssignment
	Value *[]ScopeAssignment `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ScopeAssignmentListResultIterator provides access to a complete listing of ScopeAssignment values.
type ScopeAssignmentListResultIterator struct {
	i    int
	page ScopeAssignmentListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ScopeAssignmentListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ScopeAssignmentListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ScopeAssignmentListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ScopeAssignmentListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ScopeAssignmentListResultIterator) Response() ScopeAssignmentListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ScopeAssignmentListResultIterator) Value() ScopeAssignment {
	if !iter.page.NotDone() {
		return ScopeAssignment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ScopeAssignmentListResultIterator type.
func NewScopeAssignmentListResultIterator(page ScopeAssignmentListResultPage) ScopeAssignmentListResultIterator {
	return ScopeAssignmentListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (salr ScopeAssignmentListResult) IsEmpty() bool {
	return salr.Value == nil || len(*salr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (salr ScopeAssignmentListResult) hasNextLink() bool {
	return salr.NextLink != nil && len(*salr.NextLink) != 0
}

// scopeAssignmentListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (salr ScopeAssignmentListResult) scopeAssignmentListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !salr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(salr.NextLink)))
}

// ScopeAssignmentListResultPage contains a page of ScopeAssignment values.
type ScopeAssignmentListResultPage struct {
	fn   func(context.Context, ScopeAssignmentListResult) (ScopeAssignmentListResult, error)
	salr ScopeAssignmentListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ScopeAssignmentListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ScopeAssignmentListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.salr)
		if err != nil {
			return err
		}
		page.salr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ScopeAssignmentListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ScopeAssignmentListResultPage) NotDone() bool {
	return !page.salr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ScopeAssignmentListResultPage) Response() ScopeAssignmentListResult {
	return page.salr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ScopeAssignmentListResultPage) Values() []ScopeAssignment {
	if page.salr.IsEmpty() {
		return nil
	}
	return *page.salr.Value
}

// Creates a new instance of the ScopeAssignmentListResultPage type.
func NewScopeAssignmentListResultPage(cur ScopeAssignmentListResult, getNextPage func(context.Context, ScopeAssignmentListResult) (ScopeAssignmentListResult, error)) ScopeAssignmentListResultPage {
	return ScopeAssignmentListResultPage{
		fn:   getNextPage,
		salr: cur,
	}
}

// ScopeAssignmentProperties properties of Managed Network
type ScopeAssignmentProperties struct {
	// AssignedManagedNetwork - The managed network ID with scope will be assigned to.
	AssignedManagedNetwork *string `json:"assignedManagedNetwork,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the ManagedNetwork resource. Possible values include: 'Updating', 'Deleting', 'Failed', 'Succeeded'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for ScopeAssignmentProperties.
func (sap ScopeAssignmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sap.AssignedManagedNetwork != nil {
		objectMap["assignedManagedNetwork"] = sap.AssignedManagedNetwork
	}
	return json.Marshal(objectMap)
}

// TrackedResource the resource model definition for a ARM tracked top level resource
type TrackedResource struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// Update update Tags of Managed Network
type Update struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Update.
func (u Update) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if u.Tags != nil {
		objectMap["tags"] = u.Tags
	}
	return json.Marshal(objectMap)
}
