package spark

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// BatchJobResultType enumerates the values for batch job result type.
type BatchJobResultType string

const (
	// Cancelled ...
	Cancelled BatchJobResultType = "Cancelled"
	// Failed ...
	Failed BatchJobResultType = "Failed"
	// Succeeded ...
	Succeeded BatchJobResultType = "Succeeded"
	// Uncertain ...
	Uncertain BatchJobResultType = "Uncertain"
)

// PossibleBatchJobResultTypeValues returns an array of possible values for the BatchJobResultType const type.
func PossibleBatchJobResultTypeValues() []BatchJobResultType {
	return []BatchJobResultType{Cancelled, Failed, Succeeded, Uncertain}
}

// ErrorSource enumerates the values for error source.
type ErrorSource string

const (
	// Dependency ...
	Dependency ErrorSource = "Dependency"
	// System ...
	System ErrorSource = "System"
	// Unknown ...
	Unknown ErrorSource = "Unknown"
	// User ...
	User ErrorSource = "User"
)

// PossibleErrorSourceValues returns an array of possible values for the ErrorSource const type.
func PossibleErrorSourceValues() []ErrorSource {
	return []ErrorSource{Dependency, System, Unknown, User}
}

// JobType enumerates the values for job type.
type JobType string

const (
	// SparkBatch ...
	SparkBatch JobType = "SparkBatch"
	// SparkSession ...
	SparkSession JobType = "SparkSession"
)

// PossibleJobTypeValues returns an array of possible values for the JobType const type.
func PossibleJobTypeValues() []JobType {
	return []JobType{SparkBatch, SparkSession}
}

// PluginCurrentState enumerates the values for plugin current state.
type PluginCurrentState string

const (
	// Cleanup ...
	Cleanup PluginCurrentState = "Cleanup"
	// Ended ...
	Ended PluginCurrentState = "Ended"
	// Monitoring ...
	Monitoring PluginCurrentState = "Monitoring"
	// Preparation ...
	Preparation PluginCurrentState = "Preparation"
	// Queued ...
	Queued PluginCurrentState = "Queued"
	// ResourceAcquisition ...
	ResourceAcquisition PluginCurrentState = "ResourceAcquisition"
	// Submission ...
	Submission PluginCurrentState = "Submission"
)

// PossiblePluginCurrentStateValues returns an array of possible values for the PluginCurrentState const type.
func PossiblePluginCurrentStateValues() []PluginCurrentState {
	return []PluginCurrentState{Cleanup, Ended, Monitoring, Preparation, Queued, ResourceAcquisition, Submission}
}

// SchedulerCurrentState enumerates the values for scheduler current state.
type SchedulerCurrentState string

const (
	// SchedulerCurrentStateEnded ...
	SchedulerCurrentStateEnded SchedulerCurrentState = "Ended"
	// SchedulerCurrentStateQueued ...
	SchedulerCurrentStateQueued SchedulerCurrentState = "Queued"
	// SchedulerCurrentStateScheduled ...
	SchedulerCurrentStateScheduled SchedulerCurrentState = "Scheduled"
)

// PossibleSchedulerCurrentStateValues returns an array of possible values for the SchedulerCurrentState const type.
func PossibleSchedulerCurrentStateValues() []SchedulerCurrentState {
	return []SchedulerCurrentState{SchedulerCurrentStateEnded, SchedulerCurrentStateQueued, SchedulerCurrentStateScheduled}
}

// SessionResultType enumerates the values for session result type.
type SessionResultType string

const (
	// SessionResultTypeCancelled ...
	SessionResultTypeCancelled SessionResultType = "Cancelled"
	// SessionResultTypeFailed ...
	SessionResultTypeFailed SessionResultType = "Failed"
	// SessionResultTypeSucceeded ...
	SessionResultTypeSucceeded SessionResultType = "Succeeded"
	// SessionResultTypeUncertain ...
	SessionResultTypeUncertain SessionResultType = "Uncertain"
)

// PossibleSessionResultTypeValues returns an array of possible values for the SessionResultType const type.
func PossibleSessionResultTypeValues() []SessionResultType {
	return []SessionResultType{SessionResultTypeCancelled, SessionResultTypeFailed, SessionResultTypeSucceeded, SessionResultTypeUncertain}
}

// StatementLanguageType enumerates the values for statement language type.
type StatementLanguageType string

const (
	// Dotnetspark ...
	Dotnetspark StatementLanguageType = "dotnetspark"
	// Pyspark ...
	Pyspark StatementLanguageType = "pyspark"
	// Spark ...
	Spark StatementLanguageType = "spark"
	// SQL ...
	SQL StatementLanguageType = "sql"
)

// PossibleStatementLanguageTypeValues returns an array of possible values for the StatementLanguageType const type.
func PossibleStatementLanguageTypeValues() []StatementLanguageType {
	return []StatementLanguageType{Dotnetspark, Pyspark, Spark, SQL}
}
