package scheduler

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// DayOfWeek enumerates the values for day of week.
type DayOfWeek string

const (
	// Friday ...
	Friday DayOfWeek = "Friday"
	// Monday ...
	Monday DayOfWeek = "Monday"
	// Saturday ...
	Saturday DayOfWeek = "Saturday"
	// Sunday ...
	Sunday DayOfWeek = "Sunday"
	// Thursday ...
	Thursday DayOfWeek = "Thursday"
	// Tuesday ...
	Tuesday DayOfWeek = "Tuesday"
	// Wednesday ...
	Wednesday DayOfWeek = "Wednesday"
)

// PossibleDayOfWeekValues returns an array of possible values for the DayOfWeek const type.
func PossibleDayOfWeekValues() []DayOfWeek {
	return []DayOfWeek{Friday, Monday, Saturday, Sunday, Thursday, Tuesday, Wednesday}
}

// JobActionType enumerates the values for job action type.
type JobActionType string

const (
	// HTTP ...
	HTTP JobActionType = "Http"
	// HTTPS ...
	HTTPS JobActionType = "Https"
	// ServiceBusQueue ...
	ServiceBusQueue JobActionType = "ServiceBusQueue"
	// ServiceBusTopic ...
	ServiceBusTopic JobActionType = "ServiceBusTopic"
	// StorageQueue ...
	StorageQueue JobActionType = "StorageQueue"
)

// PossibleJobActionTypeValues returns an array of possible values for the JobActionType const type.
func PossibleJobActionTypeValues() []JobActionType {
	return []JobActionType{HTTP, HTTPS, ServiceBusQueue, ServiceBusTopic, StorageQueue}
}

// JobCollectionState enumerates the values for job collection state.
type JobCollectionState string

const (
	// Deleted ...
	Deleted JobCollectionState = "Deleted"
	// Disabled ...
	Disabled JobCollectionState = "Disabled"
	// Enabled ...
	Enabled JobCollectionState = "Enabled"
	// Suspended ...
	Suspended JobCollectionState = "Suspended"
)

// PossibleJobCollectionStateValues returns an array of possible values for the JobCollectionState const type.
func PossibleJobCollectionStateValues() []JobCollectionState {
	return []JobCollectionState{Deleted, Disabled, Enabled, Suspended}
}

// JobExecutionStatus enumerates the values for job execution status.
type JobExecutionStatus string

const (
	// Completed ...
	Completed JobExecutionStatus = "Completed"
	// Failed ...
	Failed JobExecutionStatus = "Failed"
	// Postponed ...
	Postponed JobExecutionStatus = "Postponed"
)

// PossibleJobExecutionStatusValues returns an array of possible values for the JobExecutionStatus const type.
func PossibleJobExecutionStatusValues() []JobExecutionStatus {
	return []JobExecutionStatus{Completed, Failed, Postponed}
}

// JobHistoryActionName enumerates the values for job history action name.
type JobHistoryActionName string

const (
	// ErrorAction ...
	ErrorAction JobHistoryActionName = "ErrorAction"
	// MainAction ...
	MainAction JobHistoryActionName = "MainAction"
)

// PossibleJobHistoryActionNameValues returns an array of possible values for the JobHistoryActionName const type.
func PossibleJobHistoryActionNameValues() []JobHistoryActionName {
	return []JobHistoryActionName{ErrorAction, MainAction}
}

// JobScheduleDay enumerates the values for job schedule day.
type JobScheduleDay string

const (
	// JobScheduleDayFriday ...
	JobScheduleDayFriday JobScheduleDay = "Friday"
	// JobScheduleDayMonday ...
	JobScheduleDayMonday JobScheduleDay = "Monday"
	// JobScheduleDaySaturday ...
	JobScheduleDaySaturday JobScheduleDay = "Saturday"
	// JobScheduleDaySunday ...
	JobScheduleDaySunday JobScheduleDay = "Sunday"
	// JobScheduleDayThursday ...
	JobScheduleDayThursday JobScheduleDay = "Thursday"
	// JobScheduleDayTuesday ...
	JobScheduleDayTuesday JobScheduleDay = "Tuesday"
	// JobScheduleDayWednesday ...
	JobScheduleDayWednesday JobScheduleDay = "Wednesday"
)

// PossibleJobScheduleDayValues returns an array of possible values for the JobScheduleDay const type.
func PossibleJobScheduleDayValues() []JobScheduleDay {
	return []JobScheduleDay{JobScheduleDayFriday, JobScheduleDayMonday, JobScheduleDaySaturday, JobScheduleDaySunday, JobScheduleDayThursday, JobScheduleDayTuesday, JobScheduleDayWednesday}
}

// JobState enumerates the values for job state.
type JobState string

const (
	// JobStateCompleted ...
	JobStateCompleted JobState = "Completed"
	// JobStateDisabled ...
	JobStateDisabled JobState = "Disabled"
	// JobStateEnabled ...
	JobStateEnabled JobState = "Enabled"
	// JobStateFaulted ...
	JobStateFaulted JobState = "Faulted"
)

// PossibleJobStateValues returns an array of possible values for the JobState const type.
func PossibleJobStateValues() []JobState {
	return []JobState{JobStateCompleted, JobStateDisabled, JobStateEnabled, JobStateFaulted}
}

// RecurrenceFrequency enumerates the values for recurrence frequency.
type RecurrenceFrequency string

const (
	// Day ...
	Day RecurrenceFrequency = "Day"
	// Hour ...
	Hour RecurrenceFrequency = "Hour"
	// Minute ...
	Minute RecurrenceFrequency = "Minute"
	// Month ...
	Month RecurrenceFrequency = "Month"
	// Week ...
	Week RecurrenceFrequency = "Week"
)

// PossibleRecurrenceFrequencyValues returns an array of possible values for the RecurrenceFrequency const type.
func PossibleRecurrenceFrequencyValues() []RecurrenceFrequency {
	return []RecurrenceFrequency{Day, Hour, Minute, Month, Week}
}

// RetryType enumerates the values for retry type.
type RetryType string

const (
	// Fixed ...
	Fixed RetryType = "Fixed"
	// None ...
	None RetryType = "None"
)

// PossibleRetryTypeValues returns an array of possible values for the RetryType const type.
func PossibleRetryTypeValues() []RetryType {
	return []RetryType{Fixed, None}
}

// ServiceBusAuthenticationType enumerates the values for service bus authentication type.
type ServiceBusAuthenticationType string

const (
	// NotSpecified ...
	NotSpecified ServiceBusAuthenticationType = "NotSpecified"
	// SharedAccessKey ...
	SharedAccessKey ServiceBusAuthenticationType = "SharedAccessKey"
)

// PossibleServiceBusAuthenticationTypeValues returns an array of possible values for the ServiceBusAuthenticationType const type.
func PossibleServiceBusAuthenticationTypeValues() []ServiceBusAuthenticationType {
	return []ServiceBusAuthenticationType{NotSpecified, SharedAccessKey}
}

// ServiceBusTransportType enumerates the values for service bus transport type.
type ServiceBusTransportType string

const (
	// ServiceBusTransportTypeAMQP ...
	ServiceBusTransportTypeAMQP ServiceBusTransportType = "AMQP"
	// ServiceBusTransportTypeNetMessaging ...
	ServiceBusTransportTypeNetMessaging ServiceBusTransportType = "NetMessaging"
	// ServiceBusTransportTypeNotSpecified ...
	ServiceBusTransportTypeNotSpecified ServiceBusTransportType = "NotSpecified"
)

// PossibleServiceBusTransportTypeValues returns an array of possible values for the ServiceBusTransportType const type.
func PossibleServiceBusTransportTypeValues() []ServiceBusTransportType {
	return []ServiceBusTransportType{ServiceBusTransportTypeAMQP, ServiceBusTransportTypeNetMessaging, ServiceBusTransportTypeNotSpecified}
}

// SkuDefinition enumerates the values for sku definition.
type SkuDefinition string

const (
	// Free ...
	Free SkuDefinition = "Free"
	// P10Premium ...
	P10Premium SkuDefinition = "P10Premium"
	// P20Premium ...
	P20Premium SkuDefinition = "P20Premium"
	// Standard ...
	Standard SkuDefinition = "Standard"
)

// PossibleSkuDefinitionValues returns an array of possible values for the SkuDefinition const type.
func PossibleSkuDefinitionValues() []SkuDefinition {
	return []SkuDefinition{Free, P10Premium, P20Premium, Standard}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeActiveDirectoryOAuth ...
	TypeActiveDirectoryOAuth Type = "ActiveDirectoryOAuth"
	// TypeBasic ...
	TypeBasic Type = "Basic"
	// TypeClientCertificate ...
	TypeClientCertificate Type = "ClientCertificate"
	// TypeHTTPAuthentication ...
	TypeHTTPAuthentication Type = "HttpAuthentication"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeActiveDirectoryOAuth, TypeBasic, TypeClientCertificate, TypeHTTPAuthentication}
}
