package consumption

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// ReservationRecommendationDetailsClient is the consumption management client provides access to consumption resources
// for Azure Enterprise Subscriptions.
type ReservationRecommendationDetailsClient struct {
	BaseClient
}

// NewReservationRecommendationDetailsClient creates an instance of the ReservationRecommendationDetailsClient client.
func NewReservationRecommendationDetailsClient(subscriptionID string) ReservationRecommendationDetailsClient {
	return NewReservationRecommendationDetailsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewReservationRecommendationDetailsClientWithBaseURI creates an instance of the
// ReservationRecommendationDetailsClient client using a custom endpoint.  Use this when interacting with an Azure
// cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewReservationRecommendationDetailsClientWithBaseURI(baseURI string, subscriptionID string) ReservationRecommendationDetailsClient {
	return ReservationRecommendationDetailsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Get details of a reservation recommendation for what-if analysis of reserved instances.
// Parameters:
// billingScope - the scope associated with reservation recommendation details operations. This includes
// '/subscriptions/{subscriptionId}/' for subscription scope,
// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resource group scope,
// /providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for BillingAccount scope, and
// '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for
// billingProfile scope
// scope - scope of the reservation.
// region - used to select the region the recommendation should be generated for.
// term - specify length of reservation recommendation term.
// lookBackPeriod - filter the time period on which reservation recommendation results are based.
// product - filter the products for which reservation recommendation results are generated. Examples:
// Standard_DS1_v2 (for VM), Premium_SSD_Managed_Disks_P30 (for Managed Disks)
func (client ReservationRecommendationDetailsClient) Get(ctx context.Context, billingScope string, scope Scope11, region string, term Term, lookBackPeriod LookBackPeriod, product string) (result ReservationRecommendationDetailsModel, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReservationRecommendationDetailsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, billingScope, scope, region, term, lookBackPeriod, product)
	if err != nil {
		err = autorest.NewErrorWithError(err, "consumption.ReservationRecommendationDetailsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "consumption.ReservationRecommendationDetailsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "consumption.ReservationRecommendationDetailsClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client ReservationRecommendationDetailsClient) GetPreparer(ctx context.Context, billingScope string, scope Scope11, region string, term Term, lookBackPeriod LookBackPeriod, product string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"billingScope": billingScope,
	}

	const APIVersion = "2019-10-01"
	queryParameters := map[string]interface{}{
		"api-version":    APIVersion,
		"lookBackPeriod": autorest.Encode("query", lookBackPeriod),
		"product":        autorest.Encode("query", product),
		"region":         autorest.Encode("query", region),
		"scope":          autorest.Encode("query", scope),
		"term":           autorest.Encode("query", term),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{billingScope}/providers/Microsoft.Consumption/reservationRecommendationDetails", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client ReservationRecommendationDetailsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client ReservationRecommendationDetailsClient) GetResponder(resp *http.Response) (result ReservationRecommendationDetailsModel, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
