/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
	v1alpha1 "sigs.k8s.io/kube-storage-version-migrator/pkg/apis/migration/v1alpha1"
)

// FakeStorageStates implements StorageStateInterface
type FakeStorageStates struct {
	Fake *FakeMigrationV1alpha1
}

var storagestatesResource = schema.GroupVersionResource{Group: "migration.k8s.io", Version: "v1alpha1", Resource: "storagestates"}

var storagestatesKind = schema.GroupVersionKind{Group: "migration.k8s.io", Version: "v1alpha1", Kind: "StorageState"}

// Get takes name of the storageState, and returns the corresponding storageState object, and an error if there is any.
func (c *FakeStorageStates) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.StorageState, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(storagestatesResource, name), &v1alpha1.StorageState{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.StorageState), err
}

// List takes label and field selectors, and returns the list of StorageStates that match those selectors.
func (c *FakeStorageStates) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.StorageStateList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(storagestatesResource, storagestatesKind, opts), &v1alpha1.StorageStateList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.StorageStateList{ListMeta: obj.(*v1alpha1.StorageStateList).ListMeta}
	for _, item := range obj.(*v1alpha1.StorageStateList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested storageStates.
func (c *FakeStorageStates) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(storagestatesResource, opts))
}

// Create takes the representation of a storageState and creates it.  Returns the server's representation of the storageState, and an error, if there is any.
func (c *FakeStorageStates) Create(ctx context.Context, storageState *v1alpha1.StorageState, opts v1.CreateOptions) (result *v1alpha1.StorageState, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(storagestatesResource, storageState), &v1alpha1.StorageState{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.StorageState), err
}

// Update takes the representation of a storageState and updates it. Returns the server's representation of the storageState, and an error, if there is any.
func (c *FakeStorageStates) Update(ctx context.Context, storageState *v1alpha1.StorageState, opts v1.UpdateOptions) (result *v1alpha1.StorageState, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(storagestatesResource, storageState), &v1alpha1.StorageState{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.StorageState), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeStorageStates) UpdateStatus(ctx context.Context, storageState *v1alpha1.StorageState, opts v1.UpdateOptions) (*v1alpha1.StorageState, error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateSubresourceAction(storagestatesResource, "status", storageState), &v1alpha1.StorageState{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.StorageState), err
}

// Delete takes name of the storageState and deletes it. Returns an error if one occurs.
func (c *FakeStorageStates) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteAction(storagestatesResource, name), &v1alpha1.StorageState{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeStorageStates) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(storagestatesResource, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha1.StorageStateList{})
	return err
}

// Patch applies the patch and returns the patched storageState.
func (c *FakeStorageStates) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.StorageState, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(storagestatesResource, name, pt, data, subresources...), &v1alpha1.StorageState{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.StorageState), err
}
