// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v1/services/label_service.proto

package services

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	resources "google.golang.org/genproto/googleapis/ads/googleads/v1/resources"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for [LabelService.GetLabel][google.ads.googleads.v1.services.LabelService.GetLabel].
type GetLabelRequest struct {
	// The resource name of the label to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetLabelRequest) Reset()         { *m = GetLabelRequest{} }
func (m *GetLabelRequest) String() string { return proto.CompactTextString(m) }
func (*GetLabelRequest) ProtoMessage()    {}
func (*GetLabelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_43c34accccca4b63, []int{0}
}

func (m *GetLabelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetLabelRequest.Unmarshal(m, b)
}
func (m *GetLabelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetLabelRequest.Marshal(b, m, deterministic)
}
func (m *GetLabelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetLabelRequest.Merge(m, src)
}
func (m *GetLabelRequest) XXX_Size() int {
	return xxx_messageInfo_GetLabelRequest.Size(m)
}
func (m *GetLabelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetLabelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetLabelRequest proto.InternalMessageInfo

func (m *GetLabelRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [LabelService.MutateLabels][google.ads.googleads.v1.services.LabelService.MutateLabels].
type MutateLabelsRequest struct {
	// ID of the customer whose labels are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// The list of operations to perform on labels.
	Operations []*LabelOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	// If true, successful operations will be carried out and invalid
	// operations will return errors. If false, all operations will be carried
	// out in one transaction if and only if they are all valid.
	// Default is false.
	PartialFailure bool `protobuf:"varint,3,opt,name=partial_failure,json=partialFailure,proto3" json:"partial_failure,omitempty"`
	// If true, the request is validated but not executed. Only errors are
	// returned, not results.
	ValidateOnly         bool     `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateLabelsRequest) Reset()         { *m = MutateLabelsRequest{} }
func (m *MutateLabelsRequest) String() string { return proto.CompactTextString(m) }
func (*MutateLabelsRequest) ProtoMessage()    {}
func (*MutateLabelsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_43c34accccca4b63, []int{1}
}

func (m *MutateLabelsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateLabelsRequest.Unmarshal(m, b)
}
func (m *MutateLabelsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateLabelsRequest.Marshal(b, m, deterministic)
}
func (m *MutateLabelsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateLabelsRequest.Merge(m, src)
}
func (m *MutateLabelsRequest) XXX_Size() int {
	return xxx_messageInfo_MutateLabelsRequest.Size(m)
}
func (m *MutateLabelsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateLabelsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateLabelsRequest proto.InternalMessageInfo

func (m *MutateLabelsRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateLabelsRequest) GetOperations() []*LabelOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *MutateLabelsRequest) GetPartialFailure() bool {
	if m != nil {
		return m.PartialFailure
	}
	return false
}

func (m *MutateLabelsRequest) GetValidateOnly() bool {
	if m != nil {
		return m.ValidateOnly
	}
	return false
}

// A single operation (create, remove, update) on a label.
type LabelOperation struct {
	// FieldMask that determines which resource fields are modified in an update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The mutate operation.
	//
	// Types that are valid to be assigned to Operation:
	//	*LabelOperation_Create
	//	*LabelOperation_Update
	//	*LabelOperation_Remove
	Operation            isLabelOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *LabelOperation) Reset()         { *m = LabelOperation{} }
func (m *LabelOperation) String() string { return proto.CompactTextString(m) }
func (*LabelOperation) ProtoMessage()    {}
func (*LabelOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_43c34accccca4b63, []int{2}
}

func (m *LabelOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelOperation.Unmarshal(m, b)
}
func (m *LabelOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelOperation.Marshal(b, m, deterministic)
}
func (m *LabelOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelOperation.Merge(m, src)
}
func (m *LabelOperation) XXX_Size() int {
	return xxx_messageInfo_LabelOperation.Size(m)
}
func (m *LabelOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelOperation.DiscardUnknown(m)
}

var xxx_messageInfo_LabelOperation proto.InternalMessageInfo

func (m *LabelOperation) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

type isLabelOperation_Operation interface {
	isLabelOperation_Operation()
}

type LabelOperation_Create struct {
	Create *resources.Label `protobuf:"bytes,1,opt,name=create,proto3,oneof"`
}

type LabelOperation_Update struct {
	Update *resources.Label `protobuf:"bytes,2,opt,name=update,proto3,oneof"`
}

type LabelOperation_Remove struct {
	Remove string `protobuf:"bytes,3,opt,name=remove,proto3,oneof"`
}

func (*LabelOperation_Create) isLabelOperation_Operation() {}

func (*LabelOperation_Update) isLabelOperation_Operation() {}

func (*LabelOperation_Remove) isLabelOperation_Operation() {}

func (m *LabelOperation) GetOperation() isLabelOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *LabelOperation) GetCreate() *resources.Label {
	if x, ok := m.GetOperation().(*LabelOperation_Create); ok {
		return x.Create
	}
	return nil
}

func (m *LabelOperation) GetUpdate() *resources.Label {
	if x, ok := m.GetOperation().(*LabelOperation_Update); ok {
		return x.Update
	}
	return nil
}

func (m *LabelOperation) GetRemove() string {
	if x, ok := m.GetOperation().(*LabelOperation_Remove); ok {
		return x.Remove
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*LabelOperation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*LabelOperation_Create)(nil),
		(*LabelOperation_Update)(nil),
		(*LabelOperation_Remove)(nil),
	}
}

// Response message for a labels mutate.
type MutateLabelsResponse struct {
	// Errors that pertain to operation failures in the partial failure mode.
	// Returned only when partial_failure = true and all errors occur inside the
	// operations. If any errors occur outside the operations (e.g. auth errors),
	// we return an RPC level error.
	PartialFailureError *status.Status `protobuf:"bytes,3,opt,name=partial_failure_error,json=partialFailureError,proto3" json:"partial_failure_error,omitempty"`
	// All results for the mutate.
	Results              []*MutateLabelResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *MutateLabelsResponse) Reset()         { *m = MutateLabelsResponse{} }
func (m *MutateLabelsResponse) String() string { return proto.CompactTextString(m) }
func (*MutateLabelsResponse) ProtoMessage()    {}
func (*MutateLabelsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_43c34accccca4b63, []int{3}
}

func (m *MutateLabelsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateLabelsResponse.Unmarshal(m, b)
}
func (m *MutateLabelsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateLabelsResponse.Marshal(b, m, deterministic)
}
func (m *MutateLabelsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateLabelsResponse.Merge(m, src)
}
func (m *MutateLabelsResponse) XXX_Size() int {
	return xxx_messageInfo_MutateLabelsResponse.Size(m)
}
func (m *MutateLabelsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateLabelsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateLabelsResponse proto.InternalMessageInfo

func (m *MutateLabelsResponse) GetPartialFailureError() *status.Status {
	if m != nil {
		return m.PartialFailureError
	}
	return nil
}

func (m *MutateLabelsResponse) GetResults() []*MutateLabelResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// The result for a label mutate.
type MutateLabelResult struct {
	// Returned for successful operations.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateLabelResult) Reset()         { *m = MutateLabelResult{} }
func (m *MutateLabelResult) String() string { return proto.CompactTextString(m) }
func (*MutateLabelResult) ProtoMessage()    {}
func (*MutateLabelResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_43c34accccca4b63, []int{4}
}

func (m *MutateLabelResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateLabelResult.Unmarshal(m, b)
}
func (m *MutateLabelResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateLabelResult.Marshal(b, m, deterministic)
}
func (m *MutateLabelResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateLabelResult.Merge(m, src)
}
func (m *MutateLabelResult) XXX_Size() int {
	return xxx_messageInfo_MutateLabelResult.Size(m)
}
func (m *MutateLabelResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateLabelResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateLabelResult proto.InternalMessageInfo

func (m *MutateLabelResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetLabelRequest)(nil), "google.ads.googleads.v1.services.GetLabelRequest")
	proto.RegisterType((*MutateLabelsRequest)(nil), "google.ads.googleads.v1.services.MutateLabelsRequest")
	proto.RegisterType((*LabelOperation)(nil), "google.ads.googleads.v1.services.LabelOperation")
	proto.RegisterType((*MutateLabelsResponse)(nil), "google.ads.googleads.v1.services.MutateLabelsResponse")
	proto.RegisterType((*MutateLabelResult)(nil), "google.ads.googleads.v1.services.MutateLabelResult")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v1/services/label_service.proto", fileDescriptor_43c34accccca4b63)
}

var fileDescriptor_43c34accccca4b63 = []byte{
	// 712 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x54, 0xc1, 0x6a, 0xdb, 0x4a,
	0x14, 0x7d, 0x52, 0x1e, 0x79, 0xc9, 0xc8, 0x2f, 0x21, 0x93, 0xf7, 0xa8, 0x70, 0x0b, 0x35, 0x6a,
	0xa0, 0xc6, 0xa5, 0x52, 0xec, 0xb4, 0xa1, 0x28, 0x64, 0x61, 0x43, 0x93, 0x14, 0x9a, 0x26, 0x28,
	0x90, 0x45, 0x31, 0x88, 0x89, 0x34, 0x31, 0x22, 0x92, 0x46, 0x9d, 0x19, 0x19, 0x42, 0xc8, 0xa6,
	0xbf, 0xd0, 0x55, 0xb7, 0x5d, 0x16, 0xba, 0xec, 0x4f, 0x64, 0x5b, 0xe8, 0x17, 0x74, 0xd5, 0x2f,
	0xe8, 0xa2, 0xd0, 0x32, 0x33, 0x1a, 0xc7, 0x4e, 0x09, 0x4e, 0x76, 0x57, 0x77, 0xce, 0x39, 0xf7,
	0xcc, 0xbd, 0xba, 0x03, 0x9e, 0x0c, 0x08, 0x19, 0xa4, 0xd8, 0x43, 0x31, 0xf3, 0x54, 0x28, 0xa2,
	0x61, 0xdb, 0x63, 0x98, 0x0e, 0x93, 0x08, 0x33, 0x2f, 0x45, 0x47, 0x38, 0x0d, 0xab, 0x4f, 0xb7,
	0xa0, 0x84, 0x13, 0xd8, 0x50, 0x50, 0x17, 0xc5, 0xcc, 0x1d, 0xb1, 0xdc, 0x61, 0xdb, 0xd5, 0xac,
	0xfa, 0xe3, 0xeb, 0x74, 0x29, 0x66, 0xa4, 0xa4, 0x23, 0x61, 0x25, 0x58, 0xbf, 0xa7, 0xe1, 0x45,
	0xe2, 0xa1, 0x3c, 0x27, 0x1c, 0xf1, 0x84, 0xe4, 0xac, 0x3a, 0xad, 0xca, 0x79, 0xf2, 0xeb, 0xa8,
	0x3c, 0xf6, 0x8e, 0x13, 0x9c, 0xc6, 0x61, 0x86, 0xd8, 0x49, 0x85, 0xb8, 0x53, 0x21, 0x68, 0x11,
	0x79, 0x8c, 0x23, 0x5e, 0xb2, 0x2b, 0x07, 0x42, 0x38, 0x4a, 0x13, 0x9c, 0x73, 0x75, 0xe0, 0xac,
	0x83, 0xc5, 0x6d, 0xcc, 0x5f, 0x0a, 0x0f, 0x01, 0x7e, 0x53, 0x62, 0xc6, 0xe1, 0x03, 0xf0, 0xaf,
	0x76, 0x17, 0xe6, 0x28, 0xc3, 0xb6, 0xd1, 0x30, 0x9a, 0xf3, 0x41, 0x4d, 0x27, 0x5f, 0xa1, 0x0c,
	0x3b, 0x5f, 0x0d, 0xb0, 0xbc, 0x5b, 0x72, 0xc4, 0xb1, 0xe4, 0x32, 0x4d, 0xbe, 0x0f, 0xac, 0xa8,
	0x64, 0x9c, 0x64, 0x98, 0x86, 0x49, 0x5c, 0x51, 0x81, 0x4e, 0xbd, 0x88, 0xe1, 0x3e, 0x00, 0xa4,
	0xc0, 0x54, 0x5d, 0xcc, 0x36, 0x1b, 0x33, 0x4d, 0xab, 0xb3, 0xea, 0x4e, 0x6b, 0xa4, 0x2b, 0xab,
	0xec, 0x69, 0x62, 0x30, 0xa6, 0x01, 0x1f, 0x82, 0xc5, 0x02, 0x51, 0x9e, 0xa0, 0x34, 0x3c, 0x46,
	0x49, 0x5a, 0x52, 0x6c, 0xcf, 0x34, 0x8c, 0xe6, 0x5c, 0xb0, 0x50, 0xa5, 0xb7, 0x54, 0x56, 0x5c,
	0x6c, 0x88, 0xd2, 0x24, 0x46, 0x1c, 0x87, 0x24, 0x4f, 0x4f, 0xed, 0xbf, 0x25, 0xac, 0xa6, 0x93,
	0x7b, 0x79, 0x7a, 0xea, 0xfc, 0x34, 0xc0, 0xc2, 0x64, 0x31, 0xb8, 0x01, 0xac, 0xb2, 0x90, 0x2c,
	0xd1, 0x6a, 0xc9, 0xb2, 0x3a, 0x75, 0xed, 0x59, 0x4f, 0xc3, 0xdd, 0x12, 0xd3, 0xd8, 0x45, 0xec,
	0x24, 0x00, 0x0a, 0x2e, 0x62, 0xd8, 0x03, 0xb3, 0x11, 0xc5, 0x88, 0xab, 0x36, 0x5a, 0x9d, 0xe6,
	0xb5, 0x77, 0x1d, 0xfd, 0x12, 0xea, 0xb2, 0x3b, 0x7f, 0x05, 0x15, 0x53, 0x68, 0x28, 0x45, 0xdb,
	0xbc, 0xbd, 0x86, 0x62, 0x42, 0x1b, 0xcc, 0x52, 0x9c, 0x91, 0xa1, 0x6a, 0xce, 0xbc, 0x38, 0x51,
	0xdf, 0x3d, 0x0b, 0xcc, 0x8f, 0xba, 0xe9, 0x7c, 0x32, 0xc0, 0x7f, 0x93, 0x73, 0x65, 0x05, 0xc9,
	0x19, 0x86, 0x5b, 0xe0, 0xff, 0x2b, 0x5d, 0x0e, 0x31, 0xa5, 0x84, 0x4a, 0x39, 0xab, 0x03, 0xb5,
	0x25, 0x5a, 0x44, 0xee, 0x81, 0xfc, 0xf5, 0x82, 0xe5, 0xc9, 0xfe, 0x3f, 0x17, 0x70, 0xb8, 0x0b,
	0xfe, 0xa1, 0x98, 0x95, 0x29, 0xd7, 0xc3, 0x5f, 0x9b, 0x3e, 0xfc, 0x31, 0x43, 0x81, 0xe4, 0x06,
	0x5a, 0xc3, 0x79, 0x06, 0x96, 0xfe, 0x38, 0xbd, 0xd1, 0x1f, 0xdc, 0xf9, 0x65, 0x82, 0x9a, 0x24,
	0x1d, 0xa8, 0x32, 0xf0, 0xbd, 0x01, 0xe6, 0xf4, 0x2e, 0xc0, 0xf6, 0x74, 0x57, 0x57, 0xf6, 0xa6,
	0x7e, 0xe3, 0xa9, 0x38, 0xab, 0x6f, 0xbf, 0x7c, 0x7b, 0x67, 0xb6, 0x60, 0x53, 0xbc, 0x04, 0x67,
	0x13, 0x56, 0x37, 0xf5, 0xaa, 0x30, 0xaf, 0xa5, 0x9e, 0x06, 0xe6, 0xb5, 0xce, 0xe1, 0x67, 0x03,
	0xd4, 0xc6, 0xc7, 0x02, 0x9f, 0xde, 0xaa, 0x6b, 0x7a, 0x3d, 0xeb, 0xeb, 0xb7, 0xa5, 0xa9, 0xe9,
	0x3b, 0xeb, 0xd2, 0xf1, 0xaa, 0xf3, 0x48, 0x38, 0xbe, 0xb4, 0x78, 0x36, 0xb6, 0xeb, 0x9b, 0xad,
	0xf3, 0xca, 0xb0, 0x9f, 0x49, 0x09, 0xdf, 0x68, 0xd5, 0xef, 0x5e, 0x74, 0xed, 0xcb, 0x32, 0x55,
	0x54, 0x24, 0xcc, 0x8d, 0x48, 0xd6, 0xfb, 0x61, 0x80, 0x95, 0x88, 0x64, 0x53, 0x2d, 0xf5, 0x96,
	0xc6, 0xe7, 0xb4, 0x2f, 0xf6, 0x6d, 0xdf, 0x78, 0xbd, 0x53, 0xd1, 0x06, 0x24, 0x45, 0xf9, 0xc0,
	0x25, 0x74, 0xe0, 0x0d, 0x70, 0x2e, 0xb7, 0xd1, 0xbb, 0x2c, 0x74, 0xfd, 0x8b, 0xbe, 0xa1, 0x83,
	0x0f, 0xe6, 0xcc, 0x76, 0xb7, 0xfb, 0xd1, 0x6c, 0x6c, 0x2b, 0xc1, 0x6e, 0xcc, 0x5c, 0x15, 0x8a,
	0xe8, 0xb0, 0xed, 0x56, 0x85, 0xd9, 0x85, 0x86, 0xf4, 0xbb, 0x31, 0xeb, 0x8f, 0x20, 0xfd, 0xc3,
	0x76, 0x5f, 0x43, 0xbe, 0x9b, 0x2b, 0x2a, 0xef, 0xfb, 0xdd, 0x98, 0xf9, 0xfe, 0x08, 0xe4, 0xfb,
	0x87, 0x6d, 0xdf, 0xd7, 0xb0, 0xa3, 0x59, 0xe9, 0x73, 0xed, 0x77, 0x00, 0x00, 0x00, 0xff, 0xff,
	0x63, 0x77, 0x36, 0x76, 0x78, 0x06, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// LabelServiceClient is the client API for LabelService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type LabelServiceClient interface {
	// Returns the requested label in full detail.
	GetLabel(ctx context.Context, in *GetLabelRequest, opts ...grpc.CallOption) (*resources.Label, error)
	// Creates, updates, or removes labels. Operation statuses are returned.
	MutateLabels(ctx context.Context, in *MutateLabelsRequest, opts ...grpc.CallOption) (*MutateLabelsResponse, error)
}

type labelServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewLabelServiceClient(cc grpc.ClientConnInterface) LabelServiceClient {
	return &labelServiceClient{cc}
}

func (c *labelServiceClient) GetLabel(ctx context.Context, in *GetLabelRequest, opts ...grpc.CallOption) (*resources.Label, error) {
	out := new(resources.Label)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v1.services.LabelService/GetLabel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *labelServiceClient) MutateLabels(ctx context.Context, in *MutateLabelsRequest, opts ...grpc.CallOption) (*MutateLabelsResponse, error) {
	out := new(MutateLabelsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v1.services.LabelService/MutateLabels", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// LabelServiceServer is the server API for LabelService service.
type LabelServiceServer interface {
	// Returns the requested label in full detail.
	GetLabel(context.Context, *GetLabelRequest) (*resources.Label, error)
	// Creates, updates, or removes labels. Operation statuses are returned.
	MutateLabels(context.Context, *MutateLabelsRequest) (*MutateLabelsResponse, error)
}

// UnimplementedLabelServiceServer can be embedded to have forward compatible implementations.
type UnimplementedLabelServiceServer struct {
}

func (*UnimplementedLabelServiceServer) GetLabel(ctx context.Context, req *GetLabelRequest) (*resources.Label, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetLabel not implemented")
}
func (*UnimplementedLabelServiceServer) MutateLabels(ctx context.Context, req *MutateLabelsRequest) (*MutateLabelsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method MutateLabels not implemented")
}

func RegisterLabelServiceServer(s *grpc.Server, srv LabelServiceServer) {
	s.RegisterService(&_LabelService_serviceDesc, srv)
}

func _LabelService_GetLabel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLabelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LabelServiceServer).GetLabel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v1.services.LabelService/GetLabel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LabelServiceServer).GetLabel(ctx, req.(*GetLabelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LabelService_MutateLabels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateLabelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LabelServiceServer).MutateLabels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v1.services.LabelService/MutateLabels",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LabelServiceServer).MutateLabels(ctx, req.(*MutateLabelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _LabelService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v1.services.LabelService",
	HandlerType: (*LabelServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetLabel",
			Handler:    _LabelService_GetLabel_Handler,
		},
		{
			MethodName: "MutateLabels",
			Handler:    _LabelService_MutateLabels_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v1/services/label_service.proto",
}
