// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v3/services/customer_manager_link_service.proto

package services

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	resources "google.golang.org/genproto/googleapis/ads/googleads/v3/resources"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for [CustomerManagerLinkService.GetCustomerManagerLink][google.ads.googleads.v3.services.CustomerManagerLinkService.GetCustomerManagerLink].
type GetCustomerManagerLinkRequest struct {
	// Required. The resource name of the CustomerManagerLink to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetCustomerManagerLinkRequest) Reset()         { *m = GetCustomerManagerLinkRequest{} }
func (m *GetCustomerManagerLinkRequest) String() string { return proto.CompactTextString(m) }
func (*GetCustomerManagerLinkRequest) ProtoMessage()    {}
func (*GetCustomerManagerLinkRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_68d211747141de49, []int{0}
}

func (m *GetCustomerManagerLinkRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetCustomerManagerLinkRequest.Unmarshal(m, b)
}
func (m *GetCustomerManagerLinkRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetCustomerManagerLinkRequest.Marshal(b, m, deterministic)
}
func (m *GetCustomerManagerLinkRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetCustomerManagerLinkRequest.Merge(m, src)
}
func (m *GetCustomerManagerLinkRequest) XXX_Size() int {
	return xxx_messageInfo_GetCustomerManagerLinkRequest.Size(m)
}
func (m *GetCustomerManagerLinkRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetCustomerManagerLinkRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetCustomerManagerLinkRequest proto.InternalMessageInfo

func (m *GetCustomerManagerLinkRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [CustomerManagerLinkService.MutateCustomerManagerLink][google.ads.googleads.v3.services.CustomerManagerLinkService.MutateCustomerManagerLink].
type MutateCustomerManagerLinkRequest struct {
	// Required. The ID of the customer whose customer manager links are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The list of operations to perform on individual customer manager links.
	Operations           []*CustomerManagerLinkOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *MutateCustomerManagerLinkRequest) Reset()         { *m = MutateCustomerManagerLinkRequest{} }
func (m *MutateCustomerManagerLinkRequest) String() string { return proto.CompactTextString(m) }
func (*MutateCustomerManagerLinkRequest) ProtoMessage()    {}
func (*MutateCustomerManagerLinkRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_68d211747141de49, []int{1}
}

func (m *MutateCustomerManagerLinkRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateCustomerManagerLinkRequest.Unmarshal(m, b)
}
func (m *MutateCustomerManagerLinkRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateCustomerManagerLinkRequest.Marshal(b, m, deterministic)
}
func (m *MutateCustomerManagerLinkRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateCustomerManagerLinkRequest.Merge(m, src)
}
func (m *MutateCustomerManagerLinkRequest) XXX_Size() int {
	return xxx_messageInfo_MutateCustomerManagerLinkRequest.Size(m)
}
func (m *MutateCustomerManagerLinkRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateCustomerManagerLinkRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateCustomerManagerLinkRequest proto.InternalMessageInfo

func (m *MutateCustomerManagerLinkRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateCustomerManagerLinkRequest) GetOperations() []*CustomerManagerLinkOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

// Request message for [CustomerManagerLinkService.MoveManagerLink][google.ads.googleads.v3.services.CustomerManagerLinkService.MoveManagerLink].
type MoveManagerLinkRequest struct {
	// Required. The ID of the client customer that is being moved.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The resource name of the previous CustomerManagerLink.
	// The resource name has the form:
	// `customers/{customer_id}/customerManagerLinks/{manager_customer_id}~{manager_link_id}`
	PreviousCustomerManagerLink string `protobuf:"bytes,2,opt,name=previous_customer_manager_link,json=previousCustomerManagerLink,proto3" json:"previous_customer_manager_link,omitempty"`
	// Required. The resource name of the new manager customer that the client wants to move
	// to. Customer resource names have the format: "customers/{customer_id}"
	NewManager           string   `protobuf:"bytes,3,opt,name=new_manager,json=newManager,proto3" json:"new_manager,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MoveManagerLinkRequest) Reset()         { *m = MoveManagerLinkRequest{} }
func (m *MoveManagerLinkRequest) String() string { return proto.CompactTextString(m) }
func (*MoveManagerLinkRequest) ProtoMessage()    {}
func (*MoveManagerLinkRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_68d211747141de49, []int{2}
}

func (m *MoveManagerLinkRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MoveManagerLinkRequest.Unmarshal(m, b)
}
func (m *MoveManagerLinkRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MoveManagerLinkRequest.Marshal(b, m, deterministic)
}
func (m *MoveManagerLinkRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MoveManagerLinkRequest.Merge(m, src)
}
func (m *MoveManagerLinkRequest) XXX_Size() int {
	return xxx_messageInfo_MoveManagerLinkRequest.Size(m)
}
func (m *MoveManagerLinkRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MoveManagerLinkRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MoveManagerLinkRequest proto.InternalMessageInfo

func (m *MoveManagerLinkRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MoveManagerLinkRequest) GetPreviousCustomerManagerLink() string {
	if m != nil {
		return m.PreviousCustomerManagerLink
	}
	return ""
}

func (m *MoveManagerLinkRequest) GetNewManager() string {
	if m != nil {
		return m.NewManager
	}
	return ""
}

// Updates the status of a CustomerManagerLink.
// The following actions are possible:
// 1. Update operation with status ACTIVE accepts a pending invitation.
// 2. Update operation with status REFUSED declines a pending invitation.
// 3. Update operation with status INACTIVE terminates link to manager.
type CustomerManagerLinkOperation struct {
	// FieldMask that determines which resource fields are modified in an update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The mutate operation.
	//
	// Types that are valid to be assigned to Operation:
	//	*CustomerManagerLinkOperation_Update
	Operation            isCustomerManagerLinkOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                                 `json:"-"`
	XXX_unrecognized     []byte                                   `json:"-"`
	XXX_sizecache        int32                                    `json:"-"`
}

func (m *CustomerManagerLinkOperation) Reset()         { *m = CustomerManagerLinkOperation{} }
func (m *CustomerManagerLinkOperation) String() string { return proto.CompactTextString(m) }
func (*CustomerManagerLinkOperation) ProtoMessage()    {}
func (*CustomerManagerLinkOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_68d211747141de49, []int{3}
}

func (m *CustomerManagerLinkOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CustomerManagerLinkOperation.Unmarshal(m, b)
}
func (m *CustomerManagerLinkOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CustomerManagerLinkOperation.Marshal(b, m, deterministic)
}
func (m *CustomerManagerLinkOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CustomerManagerLinkOperation.Merge(m, src)
}
func (m *CustomerManagerLinkOperation) XXX_Size() int {
	return xxx_messageInfo_CustomerManagerLinkOperation.Size(m)
}
func (m *CustomerManagerLinkOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_CustomerManagerLinkOperation.DiscardUnknown(m)
}

var xxx_messageInfo_CustomerManagerLinkOperation proto.InternalMessageInfo

func (m *CustomerManagerLinkOperation) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

type isCustomerManagerLinkOperation_Operation interface {
	isCustomerManagerLinkOperation_Operation()
}

type CustomerManagerLinkOperation_Update struct {
	Update *resources.CustomerManagerLink `protobuf:"bytes,2,opt,name=update,proto3,oneof"`
}

func (*CustomerManagerLinkOperation_Update) isCustomerManagerLinkOperation_Operation() {}

func (m *CustomerManagerLinkOperation) GetOperation() isCustomerManagerLinkOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *CustomerManagerLinkOperation) GetUpdate() *resources.CustomerManagerLink {
	if x, ok := m.GetOperation().(*CustomerManagerLinkOperation_Update); ok {
		return x.Update
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*CustomerManagerLinkOperation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*CustomerManagerLinkOperation_Update)(nil),
	}
}

// Response message for a CustomerManagerLink mutate.
type MutateCustomerManagerLinkResponse struct {
	// A result that identifies the resource affected by the mutate request.
	Results              []*MutateCustomerManagerLinkResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *MutateCustomerManagerLinkResponse) Reset()         { *m = MutateCustomerManagerLinkResponse{} }
func (m *MutateCustomerManagerLinkResponse) String() string { return proto.CompactTextString(m) }
func (*MutateCustomerManagerLinkResponse) ProtoMessage()    {}
func (*MutateCustomerManagerLinkResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_68d211747141de49, []int{4}
}

func (m *MutateCustomerManagerLinkResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateCustomerManagerLinkResponse.Unmarshal(m, b)
}
func (m *MutateCustomerManagerLinkResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateCustomerManagerLinkResponse.Marshal(b, m, deterministic)
}
func (m *MutateCustomerManagerLinkResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateCustomerManagerLinkResponse.Merge(m, src)
}
func (m *MutateCustomerManagerLinkResponse) XXX_Size() int {
	return xxx_messageInfo_MutateCustomerManagerLinkResponse.Size(m)
}
func (m *MutateCustomerManagerLinkResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateCustomerManagerLinkResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateCustomerManagerLinkResponse proto.InternalMessageInfo

func (m *MutateCustomerManagerLinkResponse) GetResults() []*MutateCustomerManagerLinkResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// Response message for a CustomerManagerLink moveManagerLink.
type MoveManagerLinkResponse struct {
	// Returned for successful operations. Represents a CustomerManagerLink
	// resource of the newly created link between client customer and new manager
	// customer.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MoveManagerLinkResponse) Reset()         { *m = MoveManagerLinkResponse{} }
func (m *MoveManagerLinkResponse) String() string { return proto.CompactTextString(m) }
func (*MoveManagerLinkResponse) ProtoMessage()    {}
func (*MoveManagerLinkResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_68d211747141de49, []int{5}
}

func (m *MoveManagerLinkResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MoveManagerLinkResponse.Unmarshal(m, b)
}
func (m *MoveManagerLinkResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MoveManagerLinkResponse.Marshal(b, m, deterministic)
}
func (m *MoveManagerLinkResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MoveManagerLinkResponse.Merge(m, src)
}
func (m *MoveManagerLinkResponse) XXX_Size() int {
	return xxx_messageInfo_MoveManagerLinkResponse.Size(m)
}
func (m *MoveManagerLinkResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MoveManagerLinkResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MoveManagerLinkResponse proto.InternalMessageInfo

func (m *MoveManagerLinkResponse) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// The result for the customer manager link mutate.
type MutateCustomerManagerLinkResult struct {
	// Returned for successful operations.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateCustomerManagerLinkResult) Reset()         { *m = MutateCustomerManagerLinkResult{} }
func (m *MutateCustomerManagerLinkResult) String() string { return proto.CompactTextString(m) }
func (*MutateCustomerManagerLinkResult) ProtoMessage()    {}
func (*MutateCustomerManagerLinkResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_68d211747141de49, []int{6}
}

func (m *MutateCustomerManagerLinkResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateCustomerManagerLinkResult.Unmarshal(m, b)
}
func (m *MutateCustomerManagerLinkResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateCustomerManagerLinkResult.Marshal(b, m, deterministic)
}
func (m *MutateCustomerManagerLinkResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateCustomerManagerLinkResult.Merge(m, src)
}
func (m *MutateCustomerManagerLinkResult) XXX_Size() int {
	return xxx_messageInfo_MutateCustomerManagerLinkResult.Size(m)
}
func (m *MutateCustomerManagerLinkResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateCustomerManagerLinkResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateCustomerManagerLinkResult proto.InternalMessageInfo

func (m *MutateCustomerManagerLinkResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetCustomerManagerLinkRequest)(nil), "google.ads.googleads.v3.services.GetCustomerManagerLinkRequest")
	proto.RegisterType((*MutateCustomerManagerLinkRequest)(nil), "google.ads.googleads.v3.services.MutateCustomerManagerLinkRequest")
	proto.RegisterType((*MoveManagerLinkRequest)(nil), "google.ads.googleads.v3.services.MoveManagerLinkRequest")
	proto.RegisterType((*CustomerManagerLinkOperation)(nil), "google.ads.googleads.v3.services.CustomerManagerLinkOperation")
	proto.RegisterType((*MutateCustomerManagerLinkResponse)(nil), "google.ads.googleads.v3.services.MutateCustomerManagerLinkResponse")
	proto.RegisterType((*MoveManagerLinkResponse)(nil), "google.ads.googleads.v3.services.MoveManagerLinkResponse")
	proto.RegisterType((*MutateCustomerManagerLinkResult)(nil), "google.ads.googleads.v3.services.MutateCustomerManagerLinkResult")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v3/services/customer_manager_link_service.proto", fileDescriptor_68d211747141de49)
}

var fileDescriptor_68d211747141de49 = []byte{
	// 762 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x56, 0xc1, 0x6e, 0xd3, 0x4c,
	0x10, 0xfe, 0xed, 0xfc, 0x2a, 0xea, 0x06, 0x84, 0xe4, 0x43, 0x1b, 0xdc, 0x42, 0x83, 0xe9, 0x21,
	0x8a, 0x2a, 0x5b, 0x4a, 0xa4, 0xaa, 0x75, 0xd5, 0x22, 0xa7, 0xa8, 0x69, 0x25, 0x52, 0xaa, 0x20,
	0xf5, 0x00, 0x41, 0xd1, 0x36, 0xde, 0x1a, 0xab, 0xf6, 0xae, 0xf1, 0xda, 0xe9, 0xa1, 0xaa, 0x84,
	0x40, 0xea, 0x95, 0x03, 0x6f, 0xc0, 0x11, 0x09, 0x6e, 0x5c, 0x78, 0x84, 0x5e, 0xb9, 0xf5, 0x04,
	0x12, 0x27, 0x9e, 0x02, 0xd9, 0xde, 0x75, 0xdc, 0xe2, 0x24, 0x55, 0x7a, 0x9b, 0x78, 0x66, 0xbe,
	0x6f, 0xbe, 0x99, 0xd9, 0x51, 0xc0, 0x13, 0x8b, 0x10, 0xcb, 0x41, 0x1a, 0x34, 0xa9, 0x96, 0x98,
	0x91, 0xd5, 0xaf, 0x6b, 0x14, 0xf9, 0x7d, 0xbb, 0x87, 0xa8, 0xd6, 0x0b, 0x69, 0x40, 0x5c, 0xe4,
	0x77, 0x5d, 0x88, 0xa1, 0x85, 0xfc, 0xae, 0x63, 0xe3, 0xa3, 0x2e, 0x73, 0xab, 0x9e, 0x4f, 0x02,
	0x22, 0x95, 0x93, 0x54, 0x15, 0x9a, 0x54, 0x4d, 0x51, 0xd4, 0x7e, 0x5d, 0xe5, 0x28, 0xf2, 0xfa,
	0x30, 0x1e, 0x1f, 0x51, 0x12, 0xfa, 0x43, 0x89, 0x12, 0x02, 0x79, 0x9e, 0xa7, 0x7b, 0xb6, 0x06,
	0x31, 0x26, 0x01, 0x0c, 0x6c, 0x82, 0x29, 0xf3, 0xce, 0x66, 0xbc, 0x3d, 0xc7, 0x46, 0x38, 0x60,
	0x8e, 0x85, 0x8c, 0xe3, 0xd0, 0x46, 0x8e, 0xd9, 0x3d, 0x40, 0xaf, 0x61, 0xdf, 0x26, 0x3e, 0x0b,
	0x60, 0x85, 0x6b, 0xf1, 0xaf, 0x83, 0xf0, 0x90, 0x45, 0xb9, 0x90, 0x32, 0x66, 0x65, 0x07, 0xdc,
	0x6f, 0xa2, 0x60, 0x93, 0xd5, 0xd6, 0x4a, 0x4a, 0x7b, 0x6a, 0xe3, 0xa3, 0x36, 0x7a, 0x13, 0x22,
	0x1a, 0x48, 0x15, 0x70, 0x87, 0x6b, 0xe8, 0x62, 0xe8, 0xa2, 0x92, 0x50, 0x16, 0x2a, 0xd3, 0x8d,
	0xc2, 0x4f, 0x43, 0x6c, 0xdf, 0xe6, 0x9e, 0x5d, 0xe8, 0x22, 0xe5, 0x8b, 0x00, 0xca, 0xad, 0x30,
	0x80, 0x01, 0x1a, 0x01, 0xb7, 0x08, 0x8a, 0x69, 0x23, 0x6c, 0x33, 0x0b, 0x06, 0xf8, 0xf7, 0x1d,
	0x53, 0xea, 0x01, 0x40, 0x3c, 0xe4, 0x27, 0x5d, 0x28, 0x89, 0xe5, 0x42, 0xa5, 0x58, 0xdb, 0x50,
	0xc7, 0x4d, 0x41, 0xcd, 0xe1, 0x7d, 0xc6, 0x61, 0x18, 0xc9, 0x00, 0x56, 0xf9, 0x2a, 0x80, 0x99,
	0x16, 0xe9, 0xa3, 0x89, 0xab, 0xdc, 0x06, 0x0f, 0x3c, 0x1f, 0xf5, 0x6d, 0x12, 0xd2, 0x6e, 0xee,
	0x74, 0x4b, 0xe2, 0x20, 0x71, 0x8e, 0x87, 0xe6, 0x14, 0x19, 0xf1, 0x61, 0x74, 0xcc, 0x73, 0x4b,
	0x85, 0x0c, 0x1f, 0x46, 0xc7, 0x2c, 0x52, 0xf9, 0x2e, 0x80, 0xf9, 0x51, 0x12, 0xa5, 0x35, 0x50,
	0x0c, 0x3d, 0x13, 0x06, 0x28, 0x9e, 0x70, 0xe9, 0xff, 0xb2, 0x50, 0x29, 0xd6, 0x64, 0xde, 0x37,
	0xbe, 0x04, 0xea, 0x56, 0xb4, 0x04, 0x2d, 0x48, 0x8f, 0xda, 0x20, 0x09, 0x8f, 0x6c, 0x69, 0x0f,
	0x4c, 0x25, 0xbf, 0xe2, 0xaa, 0x8b, 0xb5, 0xe5, 0xa1, 0xfd, 0x4e, 0x77, 0x3a, 0xaf, 0xe1, 0xdb,
	0xff, 0xb5, 0x19, 0x4e, 0xa3, 0x08, 0xa6, 0xd3, 0x76, 0x2b, 0x6f, 0x05, 0xf0, 0x70, 0xc4, 0x76,
	0x50, 0x8f, 0x60, 0x8a, 0xa4, 0x97, 0xe0, 0x96, 0x8f, 0x68, 0xe8, 0x04, 0xb4, 0x24, 0xc4, 0x53,
	0x37, 0xc6, 0x4f, 0x7d, 0x14, 0x6a, 0xe8, 0x04, 0x6d, 0x8e, 0xa8, 0x6c, 0x80, 0xd9, 0x7f, 0xe6,
	0xcd, 0x78, 0x1f, 0xe5, 0x6e, 0xf9, 0x95, 0x05, 0xdf, 0x02, 0x0b, 0x63, 0xb8, 0xae, 0x85, 0x53,
	0xfb, 0x36, 0x05, 0xe4, 0x1c, 0x88, 0xe7, 0x89, 0x20, 0xe9, 0x97, 0x00, 0x66, 0xf2, 0xdf, 0xa4,
	0xf4, 0x78, 0x7c, 0x37, 0x46, 0xbe, 0x66, 0x79, 0xc2, 0xa1, 0x2a, 0xbb, 0x17, 0xc6, 0x65, 0x61,
	0xef, 0x7e, 0xfc, 0xfe, 0x28, 0xae, 0x48, 0xcb, 0xd1, 0x8d, 0x3b, 0xb9, 0xe4, 0x59, 0xe7, 0x4f,
	0x81, 0x6a, 0xd5, 0xf4, 0xe8, 0x65, 0xb0, 0xa8, 0x56, 0x3d, 0x95, 0xde, 0x8b, 0xe0, 0xde, 0xd0,
	0x5e, 0x4a, 0x8d, 0x1b, 0x0d, 0x3d, 0x51, 0xba, 0x79, 0xb3, 0xc5, 0x89, 0xd7, 0x42, 0x79, 0x75,
	0x61, 0xcc, 0x64, 0x0e, 0xc1, 0xd2, 0xe0, 0x7a, 0xc4, 0xfa, 0x37, 0x94, 0xd5, 0x48, 0xff, 0x40,
	0xf0, 0x49, 0x26, 0x78, 0xbd, 0x7a, 0x9a, 0x2b, 0x5f, 0x77, 0x63, 0x5a, 0x5d, 0xa8, 0x4a, 0x1f,
	0x44, 0x70, 0xf7, 0xca, 0x46, 0x4a, 0x2b, 0xd7, 0xa8, 0x3b, 0xf7, 0x68, 0xc9, 0xab, 0x13, 0x64,
	0x32, 0x9d, 0x67, 0xc2, 0x85, 0xb1, 0x9c, 0x15, 0x3a, 0xfa, 0xae, 0x2d, 0x65, 0x8e, 0x55, 0xdc,
	0x88, 0xa6, 0xd2, 0x98, 0xa4, 0x11, 0x97, 0xab, 0xd1, 0x85, 0xaa, 0x3c, 0x77, 0x6e, 0x94, 0x06,
	0xa5, 0x33, 0xcb, 0xb3, 0xa9, 0xda, 0x23, 0x6e, 0xe3, 0x4c, 0x04, 0x8b, 0x3d, 0xe2, 0x8e, 0x95,
	0xd9, 0x58, 0x18, 0xfe, 0xba, 0xf6, 0xa2, 0x23, 0xb8, 0x27, 0xbc, 0xd8, 0x66, 0x20, 0x16, 0x71,
	0x20, 0xb6, 0x54, 0xe2, 0x5b, 0x9a, 0x85, 0x70, 0x7c, 0x22, 0xb5, 0x01, 0xed, 0xf0, 0xff, 0x0d,
	0x6b, 0xdc, 0xf8, 0x24, 0x16, 0x9a, 0x86, 0xf1, 0x59, 0x2c, 0x37, 0x13, 0x40, 0xc3, 0xa4, 0x6a,
	0x62, 0x46, 0xd6, 0x7e, 0x5d, 0x65, 0xc4, 0xf4, 0x9c, 0x87, 0x74, 0x0c, 0x93, 0x76, 0xd2, 0x90,
	0xce, 0x7e, 0xbd, 0xc3, 0x43, 0xfe, 0x88, 0x8b, 0xc9, 0x77, 0x5d, 0x37, 0x4c, 0xaa, 0xeb, 0x69,
	0x90, 0xae, 0xef, 0xd7, 0x75, 0x9d, 0x87, 0x1d, 0x4c, 0xc5, 0x75, 0xd6, 0xff, 0x06, 0x00, 0x00,
	0xff, 0xff, 0x63, 0xd6, 0xc1, 0xd0, 0xde, 0x08, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CustomerManagerLinkServiceClient is the client API for CustomerManagerLinkService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CustomerManagerLinkServiceClient interface {
	// Returns the requested CustomerManagerLink in full detail.
	GetCustomerManagerLink(ctx context.Context, in *GetCustomerManagerLinkRequest, opts ...grpc.CallOption) (*resources.CustomerManagerLink, error)
	// Creates or updates customer manager links. Operation statuses are returned.
	MutateCustomerManagerLink(ctx context.Context, in *MutateCustomerManagerLinkRequest, opts ...grpc.CallOption) (*MutateCustomerManagerLinkResponse, error)
	// Moves a client customer to a new manager customer.
	// This simplifies the complex request that requires two operations to move
	// a client customer to a new manager. i.e:
	// 1. Update operation with Status INACTIVE (previous manager) and,
	// 2. Update operation with Status ACTIVE (new manager).
	MoveManagerLink(ctx context.Context, in *MoveManagerLinkRequest, opts ...grpc.CallOption) (*MoveManagerLinkResponse, error)
}

type customerManagerLinkServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCustomerManagerLinkServiceClient(cc grpc.ClientConnInterface) CustomerManagerLinkServiceClient {
	return &customerManagerLinkServiceClient{cc}
}

func (c *customerManagerLinkServiceClient) GetCustomerManagerLink(ctx context.Context, in *GetCustomerManagerLinkRequest, opts ...grpc.CallOption) (*resources.CustomerManagerLink, error) {
	out := new(resources.CustomerManagerLink)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.CustomerManagerLinkService/GetCustomerManagerLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *customerManagerLinkServiceClient) MutateCustomerManagerLink(ctx context.Context, in *MutateCustomerManagerLinkRequest, opts ...grpc.CallOption) (*MutateCustomerManagerLinkResponse, error) {
	out := new(MutateCustomerManagerLinkResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.CustomerManagerLinkService/MutateCustomerManagerLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *customerManagerLinkServiceClient) MoveManagerLink(ctx context.Context, in *MoveManagerLinkRequest, opts ...grpc.CallOption) (*MoveManagerLinkResponse, error) {
	out := new(MoveManagerLinkResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.CustomerManagerLinkService/MoveManagerLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CustomerManagerLinkServiceServer is the server API for CustomerManagerLinkService service.
type CustomerManagerLinkServiceServer interface {
	// Returns the requested CustomerManagerLink in full detail.
	GetCustomerManagerLink(context.Context, *GetCustomerManagerLinkRequest) (*resources.CustomerManagerLink, error)
	// Creates or updates customer manager links. Operation statuses are returned.
	MutateCustomerManagerLink(context.Context, *MutateCustomerManagerLinkRequest) (*MutateCustomerManagerLinkResponse, error)
	// Moves a client customer to a new manager customer.
	// This simplifies the complex request that requires two operations to move
	// a client customer to a new manager. i.e:
	// 1. Update operation with Status INACTIVE (previous manager) and,
	// 2. Update operation with Status ACTIVE (new manager).
	MoveManagerLink(context.Context, *MoveManagerLinkRequest) (*MoveManagerLinkResponse, error)
}

// UnimplementedCustomerManagerLinkServiceServer can be embedded to have forward compatible implementations.
type UnimplementedCustomerManagerLinkServiceServer struct {
}

func (*UnimplementedCustomerManagerLinkServiceServer) GetCustomerManagerLink(ctx context.Context, req *GetCustomerManagerLinkRequest) (*resources.CustomerManagerLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCustomerManagerLink not implemented")
}
func (*UnimplementedCustomerManagerLinkServiceServer) MutateCustomerManagerLink(ctx context.Context, req *MutateCustomerManagerLinkRequest) (*MutateCustomerManagerLinkResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MutateCustomerManagerLink not implemented")
}
func (*UnimplementedCustomerManagerLinkServiceServer) MoveManagerLink(ctx context.Context, req *MoveManagerLinkRequest) (*MoveManagerLinkResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MoveManagerLink not implemented")
}

func RegisterCustomerManagerLinkServiceServer(s *grpc.Server, srv CustomerManagerLinkServiceServer) {
	s.RegisterService(&_CustomerManagerLinkService_serviceDesc, srv)
}

func _CustomerManagerLinkService_GetCustomerManagerLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCustomerManagerLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CustomerManagerLinkServiceServer).GetCustomerManagerLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.CustomerManagerLinkService/GetCustomerManagerLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CustomerManagerLinkServiceServer).GetCustomerManagerLink(ctx, req.(*GetCustomerManagerLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CustomerManagerLinkService_MutateCustomerManagerLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateCustomerManagerLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CustomerManagerLinkServiceServer).MutateCustomerManagerLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.CustomerManagerLinkService/MutateCustomerManagerLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CustomerManagerLinkServiceServer).MutateCustomerManagerLink(ctx, req.(*MutateCustomerManagerLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CustomerManagerLinkService_MoveManagerLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MoveManagerLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CustomerManagerLinkServiceServer).MoveManagerLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.CustomerManagerLinkService/MoveManagerLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CustomerManagerLinkServiceServer).MoveManagerLink(ctx, req.(*MoveManagerLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CustomerManagerLinkService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v3.services.CustomerManagerLinkService",
	HandlerType: (*CustomerManagerLinkServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetCustomerManagerLink",
			Handler:    _CustomerManagerLinkService_GetCustomerManagerLink_Handler,
		},
		{
			MethodName: "MutateCustomerManagerLink",
			Handler:    _CustomerManagerLinkService_MutateCustomerManagerLink_Handler,
		},
		{
			MethodName: "MoveManagerLink",
			Handler:    _CustomerManagerLinkService_MoveManagerLink_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v3/services/customer_manager_link_service.proto",
}
