// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/datalabeling/v1beta1/operations.proto

package datalabeling

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Response used for ImportData longrunning operation.
type ImportDataOperationResponse struct {
	// Ouptut only. The name of imported dataset.
	Dataset string `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// Output only. Total number of examples requested to import
	TotalCount int32 `protobuf:"varint,2,opt,name=total_count,json=totalCount,proto3" json:"total_count,omitempty"`
	// Output only. Number of examples imported successfully.
	ImportCount          int32    `protobuf:"varint,3,opt,name=import_count,json=importCount,proto3" json:"import_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ImportDataOperationResponse) Reset()         { *m = ImportDataOperationResponse{} }
func (m *ImportDataOperationResponse) String() string { return proto.CompactTextString(m) }
func (*ImportDataOperationResponse) ProtoMessage()    {}
func (*ImportDataOperationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1364cf1609076a0d, []int{0}
}

func (m *ImportDataOperationResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportDataOperationResponse.Unmarshal(m, b)
}
func (m *ImportDataOperationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportDataOperationResponse.Marshal(b, m, deterministic)
}
func (m *ImportDataOperationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportDataOperationResponse.Merge(m, src)
}
func (m *ImportDataOperationResponse) XXX_Size() int {
	return xxx_messageInfo_ImportDataOperationResponse.Size(m)
}
func (m *ImportDataOperationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportDataOperationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ImportDataOperationResponse proto.InternalMessageInfo

func (m *ImportDataOperationResponse) GetDataset() string {
	if m != nil {
		return m.Dataset
	}
	return ""
}

func (m *ImportDataOperationResponse) GetTotalCount() int32 {
	if m != nil {
		return m.TotalCount
	}
	return 0
}

func (m *ImportDataOperationResponse) GetImportCount() int32 {
	if m != nil {
		return m.ImportCount
	}
	return 0
}

// Response used for ExportDataset longrunning operation.
type ExportDataOperationResponse struct {
	// Ouptut only. The name of dataset.
	// "projects/*/datasets/*"
	Dataset string `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// Output only. Total number of examples requested to export
	TotalCount int32 `protobuf:"varint,2,opt,name=total_count,json=totalCount,proto3" json:"total_count,omitempty"`
	// Output only. Number of examples exported successfully.
	ExportCount int32 `protobuf:"varint,3,opt,name=export_count,json=exportCount,proto3" json:"export_count,omitempty"`
	// Output only. Statistic infos of labels in the exported dataset.
	LabelStats *LabelStats `protobuf:"bytes,4,opt,name=label_stats,json=labelStats,proto3" json:"label_stats,omitempty"`
	// Output only. output_config in the ExportData request.
	OutputConfig         *OutputConfig `protobuf:"bytes,5,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ExportDataOperationResponse) Reset()         { *m = ExportDataOperationResponse{} }
func (m *ExportDataOperationResponse) String() string { return proto.CompactTextString(m) }
func (*ExportDataOperationResponse) ProtoMessage()    {}
func (*ExportDataOperationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1364cf1609076a0d, []int{1}
}

func (m *ExportDataOperationResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportDataOperationResponse.Unmarshal(m, b)
}
func (m *ExportDataOperationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportDataOperationResponse.Marshal(b, m, deterministic)
}
func (m *ExportDataOperationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportDataOperationResponse.Merge(m, src)
}
func (m *ExportDataOperationResponse) XXX_Size() int {
	return xxx_messageInfo_ExportDataOperationResponse.Size(m)
}
func (m *ExportDataOperationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportDataOperationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ExportDataOperationResponse proto.InternalMessageInfo

func (m *ExportDataOperationResponse) GetDataset() string {
	if m != nil {
		return m.Dataset
	}
	return ""
}

func (m *ExportDataOperationResponse) GetTotalCount() int32 {
	if m != nil {
		return m.TotalCount
	}
	return 0
}

func (m *ExportDataOperationResponse) GetExportCount() int32 {
	if m != nil {
		return m.ExportCount
	}
	return 0
}

func (m *ExportDataOperationResponse) GetLabelStats() *LabelStats {
	if m != nil {
		return m.LabelStats
	}
	return nil
}

func (m *ExportDataOperationResponse) GetOutputConfig() *OutputConfig {
	if m != nil {
		return m.OutputConfig
	}
	return nil
}

// Metadata of an ImportData operation.
type ImportDataOperationMetadata struct {
	// Output only. The name of imported dataset.
	// "projects/*/datasets/*"
	Dataset string `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// Output only. Partial failures encountered.
	// E.g. single files that couldn't be read.
	// Status details field will contain standard GCP error details.
	PartialFailures []*status.Status `protobuf:"bytes,2,rep,name=partial_failures,json=partialFailures,proto3" json:"partial_failures,omitempty"`
	// Output only. Timestamp when import dataset request was created.
	CreateTime           *timestamp.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ImportDataOperationMetadata) Reset()         { *m = ImportDataOperationMetadata{} }
func (m *ImportDataOperationMetadata) String() string { return proto.CompactTextString(m) }
func (*ImportDataOperationMetadata) ProtoMessage()    {}
func (*ImportDataOperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_1364cf1609076a0d, []int{2}
}

func (m *ImportDataOperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportDataOperationMetadata.Unmarshal(m, b)
}
func (m *ImportDataOperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportDataOperationMetadata.Marshal(b, m, deterministic)
}
func (m *ImportDataOperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportDataOperationMetadata.Merge(m, src)
}
func (m *ImportDataOperationMetadata) XXX_Size() int {
	return xxx_messageInfo_ImportDataOperationMetadata.Size(m)
}
func (m *ImportDataOperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportDataOperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ImportDataOperationMetadata proto.InternalMessageInfo

func (m *ImportDataOperationMetadata) GetDataset() string {
	if m != nil {
		return m.Dataset
	}
	return ""
}

func (m *ImportDataOperationMetadata) GetPartialFailures() []*status.Status {
	if m != nil {
		return m.PartialFailures
	}
	return nil
}

func (m *ImportDataOperationMetadata) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

// Metadata of an ExportData operation.
type ExportDataOperationMetadata struct {
	// Output only. The name of dataset to be exported.
	// "projects/*/datasets/*"
	Dataset string `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// Output only. Partial failures encountered.
	// E.g. single files that couldn't be read.
	// Status details field will contain standard GCP error details.
	PartialFailures []*status.Status `protobuf:"bytes,2,rep,name=partial_failures,json=partialFailures,proto3" json:"partial_failures,omitempty"`
	// Output only. Timestamp when export dataset request was created.
	CreateTime           *timestamp.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ExportDataOperationMetadata) Reset()         { *m = ExportDataOperationMetadata{} }
func (m *ExportDataOperationMetadata) String() string { return proto.CompactTextString(m) }
func (*ExportDataOperationMetadata) ProtoMessage()    {}
func (*ExportDataOperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_1364cf1609076a0d, []int{3}
}

func (m *ExportDataOperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportDataOperationMetadata.Unmarshal(m, b)
}
func (m *ExportDataOperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportDataOperationMetadata.Marshal(b, m, deterministic)
}
func (m *ExportDataOperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportDataOperationMetadata.Merge(m, src)
}
func (m *ExportDataOperationMetadata) XXX_Size() int {
	return xxx_messageInfo_ExportDataOperationMetadata.Size(m)
}
func (m *ExportDataOperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportDataOperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ExportDataOperationMetadata proto.InternalMessageInfo

func (m *ExportDataOperationMetadata) GetDataset() string {
	if m != nil {
		return m.Dataset
	}
	return ""
}

func (m *ExportDataOperationMetadata) GetPartialFailures() []*status.Status {
	if m != nil {
		return m.PartialFailures
	}
	return nil
}

func (m *ExportDataOperationMetadata) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

// Metadata of a labeling operation, such as LabelImage or LabelVideo.
// Next tag: 20
type LabelOperationMetadata struct {
	// Ouptut only. Details of specific label operation.
	//
	// Types that are valid to be assigned to Details:
	//	*LabelOperationMetadata_ImageClassificationDetails
	//	*LabelOperationMetadata_ImageBoundingBoxDetails
	//	*LabelOperationMetadata_ImageBoundingPolyDetails
	//	*LabelOperationMetadata_ImageOrientedBoundingBoxDetails
	//	*LabelOperationMetadata_ImagePolylineDetails
	//	*LabelOperationMetadata_ImageSegmentationDetails
	//	*LabelOperationMetadata_VideoClassificationDetails
	//	*LabelOperationMetadata_VideoObjectDetectionDetails
	//	*LabelOperationMetadata_VideoObjectTrackingDetails
	//	*LabelOperationMetadata_VideoEventDetails
	//	*LabelOperationMetadata_TextClassificationDetails
	//	*LabelOperationMetadata_TextEntityExtractionDetails
	Details isLabelOperationMetadata_Details `protobuf_oneof:"details"`
	// Output only. Progress of label operation. Range: [0, 100].
	ProgressPercent int32 `protobuf:"varint,1,opt,name=progress_percent,json=progressPercent,proto3" json:"progress_percent,omitempty"`
	// Output only. Partial failures encountered.
	// E.g. single files that couldn't be read.
	// Status details field will contain standard GCP error details.
	PartialFailures []*status.Status `protobuf:"bytes,2,rep,name=partial_failures,json=partialFailures,proto3" json:"partial_failures,omitempty"`
	// Output only. Timestamp when labeling request was created.
	CreateTime           *timestamp.Timestamp `protobuf:"bytes,16,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *LabelOperationMetadata) Reset()         { *m = LabelOperationMetadata{} }
func (m *LabelOperationMetadata) String() string { return proto.CompactTextString(m) }
func (*LabelOperationMetadata) ProtoMessage()    {}
func (*LabelOperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_1364cf1609076a0d, []int{4}
}

func (m *LabelOperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelOperationMetadata.Unmarshal(m, b)
}
func (m *LabelOperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelOperationMetadata.Marshal(b, m, deterministic)
}
func (m *LabelOperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelOperationMetadata.Merge(m, src)
}
func (m *LabelOperationMetadata) XXX_Size() int {
	return xxx_messageInfo_LabelOperationMetadata.Size(m)
}
func (m *LabelOperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelOperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_LabelOperationMetadata proto.InternalMessageInfo

type isLabelOperationMetadata_Details interface {
	isLabelOperationMetadata_Details()
}

type LabelOperationMetadata_ImageClassificationDetails struct {
	ImageClassificationDetails *LabelImageClassificationOperationMetadata `protobuf:"bytes,3,opt,name=image_classification_details,json=imageClassificationDetails,proto3,oneof"`
}

type LabelOperationMetadata_ImageBoundingBoxDetails struct {
	ImageBoundingBoxDetails *LabelImageBoundingBoxOperationMetadata `protobuf:"bytes,4,opt,name=image_bounding_box_details,json=imageBoundingBoxDetails,proto3,oneof"`
}

type LabelOperationMetadata_ImageBoundingPolyDetails struct {
	ImageBoundingPolyDetails *LabelImageBoundingPolyOperationMetadata `protobuf:"bytes,11,opt,name=image_bounding_poly_details,json=imageBoundingPolyDetails,proto3,oneof"`
}

type LabelOperationMetadata_ImageOrientedBoundingBoxDetails struct {
	ImageOrientedBoundingBoxDetails *LabelImageOrientedBoundingBoxOperationMetadata `protobuf:"bytes,14,opt,name=image_oriented_bounding_box_details,json=imageOrientedBoundingBoxDetails,proto3,oneof"`
}

type LabelOperationMetadata_ImagePolylineDetails struct {
	ImagePolylineDetails *LabelImagePolylineOperationMetadata `protobuf:"bytes,12,opt,name=image_polyline_details,json=imagePolylineDetails,proto3,oneof"`
}

type LabelOperationMetadata_ImageSegmentationDetails struct {
	ImageSegmentationDetails *LabelImageSegmentationOperationMetadata `protobuf:"bytes,15,opt,name=image_segmentation_details,json=imageSegmentationDetails,proto3,oneof"`
}

type LabelOperationMetadata_VideoClassificationDetails struct {
	VideoClassificationDetails *LabelVideoClassificationOperationMetadata `protobuf:"bytes,5,opt,name=video_classification_details,json=videoClassificationDetails,proto3,oneof"`
}

type LabelOperationMetadata_VideoObjectDetectionDetails struct {
	VideoObjectDetectionDetails *LabelVideoObjectDetectionOperationMetadata `protobuf:"bytes,6,opt,name=video_object_detection_details,json=videoObjectDetectionDetails,proto3,oneof"`
}

type LabelOperationMetadata_VideoObjectTrackingDetails struct {
	VideoObjectTrackingDetails *LabelVideoObjectTrackingOperationMetadata `protobuf:"bytes,7,opt,name=video_object_tracking_details,json=videoObjectTrackingDetails,proto3,oneof"`
}

type LabelOperationMetadata_VideoEventDetails struct {
	VideoEventDetails *LabelVideoEventOperationMetadata `protobuf:"bytes,8,opt,name=video_event_details,json=videoEventDetails,proto3,oneof"`
}

type LabelOperationMetadata_TextClassificationDetails struct {
	TextClassificationDetails *LabelTextClassificationOperationMetadata `protobuf:"bytes,9,opt,name=text_classification_details,json=textClassificationDetails,proto3,oneof"`
}

type LabelOperationMetadata_TextEntityExtractionDetails struct {
	TextEntityExtractionDetails *LabelTextEntityExtractionOperationMetadata `protobuf:"bytes,13,opt,name=text_entity_extraction_details,json=textEntityExtractionDetails,proto3,oneof"`
}

func (*LabelOperationMetadata_ImageClassificationDetails) isLabelOperationMetadata_Details() {}

func (*LabelOperationMetadata_ImageBoundingBoxDetails) isLabelOperationMetadata_Details() {}

func (*LabelOperationMetadata_ImageBoundingPolyDetails) isLabelOperationMetadata_Details() {}

func (*LabelOperationMetadata_ImageOrientedBoundingBoxDetails) isLabelOperationMetadata_Details() {}

func (*LabelOperationMetadata_ImagePolylineDetails) isLabelOperationMetadata_Details() {}

func (*LabelOperationMetadata_ImageSegmentationDetails) isLabelOperationMetadata_Details() {}

func (*LabelOperationMetadata_VideoClassificationDetails) isLabelOperationMetadata_Details() {}

func (*LabelOperationMetadata_VideoObjectDetectionDetails) isLabelOperationMetadata_Details() {}

func (*LabelOperationMetadata_VideoObjectTrackingDetails) isLabelOperationMetadata_Details() {}

func (*LabelOperationMetadata_VideoEventDetails) isLabelOperationMetadata_Details() {}

func (*LabelOperationMetadata_TextClassificationDetails) isLabelOperationMetadata_Details() {}

func (*LabelOperationMetadata_TextEntityExtractionDetails) isLabelOperationMetadata_Details() {}

func (m *LabelOperationMetadata) GetDetails() isLabelOperationMetadata_Details {
	if m != nil {
		return m.Details
	}
	return nil
}

func (m *LabelOperationMetadata) GetImageClassificationDetails() *LabelImageClassificationOperationMetadata {
	if x, ok := m.GetDetails().(*LabelOperationMetadata_ImageClassificationDetails); ok {
		return x.ImageClassificationDetails
	}
	return nil
}

func (m *LabelOperationMetadata) GetImageBoundingBoxDetails() *LabelImageBoundingBoxOperationMetadata {
	if x, ok := m.GetDetails().(*LabelOperationMetadata_ImageBoundingBoxDetails); ok {
		return x.ImageBoundingBoxDetails
	}
	return nil
}

func (m *LabelOperationMetadata) GetImageBoundingPolyDetails() *LabelImageBoundingPolyOperationMetadata {
	if x, ok := m.GetDetails().(*LabelOperationMetadata_ImageBoundingPolyDetails); ok {
		return x.ImageBoundingPolyDetails
	}
	return nil
}

func (m *LabelOperationMetadata) GetImageOrientedBoundingBoxDetails() *LabelImageOrientedBoundingBoxOperationMetadata {
	if x, ok := m.GetDetails().(*LabelOperationMetadata_ImageOrientedBoundingBoxDetails); ok {
		return x.ImageOrientedBoundingBoxDetails
	}
	return nil
}

func (m *LabelOperationMetadata) GetImagePolylineDetails() *LabelImagePolylineOperationMetadata {
	if x, ok := m.GetDetails().(*LabelOperationMetadata_ImagePolylineDetails); ok {
		return x.ImagePolylineDetails
	}
	return nil
}

func (m *LabelOperationMetadata) GetImageSegmentationDetails() *LabelImageSegmentationOperationMetadata {
	if x, ok := m.GetDetails().(*LabelOperationMetadata_ImageSegmentationDetails); ok {
		return x.ImageSegmentationDetails
	}
	return nil
}

func (m *LabelOperationMetadata) GetVideoClassificationDetails() *LabelVideoClassificationOperationMetadata {
	if x, ok := m.GetDetails().(*LabelOperationMetadata_VideoClassificationDetails); ok {
		return x.VideoClassificationDetails
	}
	return nil
}

func (m *LabelOperationMetadata) GetVideoObjectDetectionDetails() *LabelVideoObjectDetectionOperationMetadata {
	if x, ok := m.GetDetails().(*LabelOperationMetadata_VideoObjectDetectionDetails); ok {
		return x.VideoObjectDetectionDetails
	}
	return nil
}

func (m *LabelOperationMetadata) GetVideoObjectTrackingDetails() *LabelVideoObjectTrackingOperationMetadata {
	if x, ok := m.GetDetails().(*LabelOperationMetadata_VideoObjectTrackingDetails); ok {
		return x.VideoObjectTrackingDetails
	}
	return nil
}

func (m *LabelOperationMetadata) GetVideoEventDetails() *LabelVideoEventOperationMetadata {
	if x, ok := m.GetDetails().(*LabelOperationMetadata_VideoEventDetails); ok {
		return x.VideoEventDetails
	}
	return nil
}

func (m *LabelOperationMetadata) GetTextClassificationDetails() *LabelTextClassificationOperationMetadata {
	if x, ok := m.GetDetails().(*LabelOperationMetadata_TextClassificationDetails); ok {
		return x.TextClassificationDetails
	}
	return nil
}

func (m *LabelOperationMetadata) GetTextEntityExtractionDetails() *LabelTextEntityExtractionOperationMetadata {
	if x, ok := m.GetDetails().(*LabelOperationMetadata_TextEntityExtractionDetails); ok {
		return x.TextEntityExtractionDetails
	}
	return nil
}

func (m *LabelOperationMetadata) GetProgressPercent() int32 {
	if m != nil {
		return m.ProgressPercent
	}
	return 0
}

func (m *LabelOperationMetadata) GetPartialFailures() []*status.Status {
	if m != nil {
		return m.PartialFailures
	}
	return nil
}

func (m *LabelOperationMetadata) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*LabelOperationMetadata) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*LabelOperationMetadata_ImageClassificationDetails)(nil),
		(*LabelOperationMetadata_ImageBoundingBoxDetails)(nil),
		(*LabelOperationMetadata_ImageBoundingPolyDetails)(nil),
		(*LabelOperationMetadata_ImageOrientedBoundingBoxDetails)(nil),
		(*LabelOperationMetadata_ImagePolylineDetails)(nil),
		(*LabelOperationMetadata_ImageSegmentationDetails)(nil),
		(*LabelOperationMetadata_VideoClassificationDetails)(nil),
		(*LabelOperationMetadata_VideoObjectDetectionDetails)(nil),
		(*LabelOperationMetadata_VideoObjectTrackingDetails)(nil),
		(*LabelOperationMetadata_VideoEventDetails)(nil),
		(*LabelOperationMetadata_TextClassificationDetails)(nil),
		(*LabelOperationMetadata_TextEntityExtractionDetails)(nil),
	}
}

// Metadata of a LabelImageClassification operation.
type LabelImageClassificationOperationMetadata struct {
	// Basic human annotation config used in labeling request.
	BasicConfig          *HumanAnnotationConfig `protobuf:"bytes,1,opt,name=basic_config,json=basicConfig,proto3" json:"basic_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *LabelImageClassificationOperationMetadata) Reset() {
	*m = LabelImageClassificationOperationMetadata{}
}
func (m *LabelImageClassificationOperationMetadata) String() string { return proto.CompactTextString(m) }
func (*LabelImageClassificationOperationMetadata) ProtoMessage()    {}
func (*LabelImageClassificationOperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_1364cf1609076a0d, []int{5}
}

func (m *LabelImageClassificationOperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelImageClassificationOperationMetadata.Unmarshal(m, b)
}
func (m *LabelImageClassificationOperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelImageClassificationOperationMetadata.Marshal(b, m, deterministic)
}
func (m *LabelImageClassificationOperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelImageClassificationOperationMetadata.Merge(m, src)
}
func (m *LabelImageClassificationOperationMetadata) XXX_Size() int {
	return xxx_messageInfo_LabelImageClassificationOperationMetadata.Size(m)
}
func (m *LabelImageClassificationOperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelImageClassificationOperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_LabelImageClassificationOperationMetadata proto.InternalMessageInfo

func (m *LabelImageClassificationOperationMetadata) GetBasicConfig() *HumanAnnotationConfig {
	if m != nil {
		return m.BasicConfig
	}
	return nil
}

// Details of a LabelImageBoundingBox operation metadata.
type LabelImageBoundingBoxOperationMetadata struct {
	// Basic human annotation config used in labeling request.
	BasicConfig          *HumanAnnotationConfig `protobuf:"bytes,1,opt,name=basic_config,json=basicConfig,proto3" json:"basic_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *LabelImageBoundingBoxOperationMetadata) Reset() {
	*m = LabelImageBoundingBoxOperationMetadata{}
}
func (m *LabelImageBoundingBoxOperationMetadata) String() string { return proto.CompactTextString(m) }
func (*LabelImageBoundingBoxOperationMetadata) ProtoMessage()    {}
func (*LabelImageBoundingBoxOperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_1364cf1609076a0d, []int{6}
}

func (m *LabelImageBoundingBoxOperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelImageBoundingBoxOperationMetadata.Unmarshal(m, b)
}
func (m *LabelImageBoundingBoxOperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelImageBoundingBoxOperationMetadata.Marshal(b, m, deterministic)
}
func (m *LabelImageBoundingBoxOperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelImageBoundingBoxOperationMetadata.Merge(m, src)
}
func (m *LabelImageBoundingBoxOperationMetadata) XXX_Size() int {
	return xxx_messageInfo_LabelImageBoundingBoxOperationMetadata.Size(m)
}
func (m *LabelImageBoundingBoxOperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelImageBoundingBoxOperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_LabelImageBoundingBoxOperationMetadata proto.InternalMessageInfo

func (m *LabelImageBoundingBoxOperationMetadata) GetBasicConfig() *HumanAnnotationConfig {
	if m != nil {
		return m.BasicConfig
	}
	return nil
}

// Details of a LabelImageOrientedBoundingBox operation metadata.
type LabelImageOrientedBoundingBoxOperationMetadata struct {
	// Basic human annotation config.
	BasicConfig          *HumanAnnotationConfig `protobuf:"bytes,1,opt,name=basic_config,json=basicConfig,proto3" json:"basic_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *LabelImageOrientedBoundingBoxOperationMetadata) Reset() {
	*m = LabelImageOrientedBoundingBoxOperationMetadata{}
}
func (m *LabelImageOrientedBoundingBoxOperationMetadata) String() string {
	return proto.CompactTextString(m)
}
func (*LabelImageOrientedBoundingBoxOperationMetadata) ProtoMessage() {}
func (*LabelImageOrientedBoundingBoxOperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_1364cf1609076a0d, []int{7}
}

func (m *LabelImageOrientedBoundingBoxOperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelImageOrientedBoundingBoxOperationMetadata.Unmarshal(m, b)
}
func (m *LabelImageOrientedBoundingBoxOperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelImageOrientedBoundingBoxOperationMetadata.Marshal(b, m, deterministic)
}
func (m *LabelImageOrientedBoundingBoxOperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelImageOrientedBoundingBoxOperationMetadata.Merge(m, src)
}
func (m *LabelImageOrientedBoundingBoxOperationMetadata) XXX_Size() int {
	return xxx_messageInfo_LabelImageOrientedBoundingBoxOperationMetadata.Size(m)
}
func (m *LabelImageOrientedBoundingBoxOperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelImageOrientedBoundingBoxOperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_LabelImageOrientedBoundingBoxOperationMetadata proto.InternalMessageInfo

func (m *LabelImageOrientedBoundingBoxOperationMetadata) GetBasicConfig() *HumanAnnotationConfig {
	if m != nil {
		return m.BasicConfig
	}
	return nil
}

// Details of LabelImageBoundingPoly operation metadata.
type LabelImageBoundingPolyOperationMetadata struct {
	// Basic human annotation config used in labeling request.
	BasicConfig          *HumanAnnotationConfig `protobuf:"bytes,1,opt,name=basic_config,json=basicConfig,proto3" json:"basic_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *LabelImageBoundingPolyOperationMetadata) Reset() {
	*m = LabelImageBoundingPolyOperationMetadata{}
}
func (m *LabelImageBoundingPolyOperationMetadata) String() string { return proto.CompactTextString(m) }
func (*LabelImageBoundingPolyOperationMetadata) ProtoMessage()    {}
func (*LabelImageBoundingPolyOperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_1364cf1609076a0d, []int{8}
}

func (m *LabelImageBoundingPolyOperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelImageBoundingPolyOperationMetadata.Unmarshal(m, b)
}
func (m *LabelImageBoundingPolyOperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelImageBoundingPolyOperationMetadata.Marshal(b, m, deterministic)
}
func (m *LabelImageBoundingPolyOperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelImageBoundingPolyOperationMetadata.Merge(m, src)
}
func (m *LabelImageBoundingPolyOperationMetadata) XXX_Size() int {
	return xxx_messageInfo_LabelImageBoundingPolyOperationMetadata.Size(m)
}
func (m *LabelImageBoundingPolyOperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelImageBoundingPolyOperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_LabelImageBoundingPolyOperationMetadata proto.InternalMessageInfo

func (m *LabelImageBoundingPolyOperationMetadata) GetBasicConfig() *HumanAnnotationConfig {
	if m != nil {
		return m.BasicConfig
	}
	return nil
}

// Details of LabelImagePolyline operation metadata.
type LabelImagePolylineOperationMetadata struct {
	// Basic human annotation config used in labeling request.
	BasicConfig          *HumanAnnotationConfig `protobuf:"bytes,1,opt,name=basic_config,json=basicConfig,proto3" json:"basic_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *LabelImagePolylineOperationMetadata) Reset()         { *m = LabelImagePolylineOperationMetadata{} }
func (m *LabelImagePolylineOperationMetadata) String() string { return proto.CompactTextString(m) }
func (*LabelImagePolylineOperationMetadata) ProtoMessage()    {}
func (*LabelImagePolylineOperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_1364cf1609076a0d, []int{9}
}

func (m *LabelImagePolylineOperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelImagePolylineOperationMetadata.Unmarshal(m, b)
}
func (m *LabelImagePolylineOperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelImagePolylineOperationMetadata.Marshal(b, m, deterministic)
}
func (m *LabelImagePolylineOperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelImagePolylineOperationMetadata.Merge(m, src)
}
func (m *LabelImagePolylineOperationMetadata) XXX_Size() int {
	return xxx_messageInfo_LabelImagePolylineOperationMetadata.Size(m)
}
func (m *LabelImagePolylineOperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelImagePolylineOperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_LabelImagePolylineOperationMetadata proto.InternalMessageInfo

func (m *LabelImagePolylineOperationMetadata) GetBasicConfig() *HumanAnnotationConfig {
	if m != nil {
		return m.BasicConfig
	}
	return nil
}

// Details of a LabelImageSegmentation operation metadata.
type LabelImageSegmentationOperationMetadata struct {
	// Basic human annotation config.
	BasicConfig          *HumanAnnotationConfig `protobuf:"bytes,1,opt,name=basic_config,json=basicConfig,proto3" json:"basic_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *LabelImageSegmentationOperationMetadata) Reset() {
	*m = LabelImageSegmentationOperationMetadata{}
}
func (m *LabelImageSegmentationOperationMetadata) String() string { return proto.CompactTextString(m) }
func (*LabelImageSegmentationOperationMetadata) ProtoMessage()    {}
func (*LabelImageSegmentationOperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_1364cf1609076a0d, []int{10}
}

func (m *LabelImageSegmentationOperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelImageSegmentationOperationMetadata.Unmarshal(m, b)
}
func (m *LabelImageSegmentationOperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelImageSegmentationOperationMetadata.Marshal(b, m, deterministic)
}
func (m *LabelImageSegmentationOperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelImageSegmentationOperationMetadata.Merge(m, src)
}
func (m *LabelImageSegmentationOperationMetadata) XXX_Size() int {
	return xxx_messageInfo_LabelImageSegmentationOperationMetadata.Size(m)
}
func (m *LabelImageSegmentationOperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelImageSegmentationOperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_LabelImageSegmentationOperationMetadata proto.InternalMessageInfo

func (m *LabelImageSegmentationOperationMetadata) GetBasicConfig() *HumanAnnotationConfig {
	if m != nil {
		return m.BasicConfig
	}
	return nil
}

// Details of a LabelVideoClassification operation metadata.
type LabelVideoClassificationOperationMetadata struct {
	// Basic human annotation config used in labeling request.
	BasicConfig          *HumanAnnotationConfig `protobuf:"bytes,1,opt,name=basic_config,json=basicConfig,proto3" json:"basic_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *LabelVideoClassificationOperationMetadata) Reset() {
	*m = LabelVideoClassificationOperationMetadata{}
}
func (m *LabelVideoClassificationOperationMetadata) String() string { return proto.CompactTextString(m) }
func (*LabelVideoClassificationOperationMetadata) ProtoMessage()    {}
func (*LabelVideoClassificationOperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_1364cf1609076a0d, []int{11}
}

func (m *LabelVideoClassificationOperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelVideoClassificationOperationMetadata.Unmarshal(m, b)
}
func (m *LabelVideoClassificationOperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelVideoClassificationOperationMetadata.Marshal(b, m, deterministic)
}
func (m *LabelVideoClassificationOperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelVideoClassificationOperationMetadata.Merge(m, src)
}
func (m *LabelVideoClassificationOperationMetadata) XXX_Size() int {
	return xxx_messageInfo_LabelVideoClassificationOperationMetadata.Size(m)
}
func (m *LabelVideoClassificationOperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelVideoClassificationOperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_LabelVideoClassificationOperationMetadata proto.InternalMessageInfo

func (m *LabelVideoClassificationOperationMetadata) GetBasicConfig() *HumanAnnotationConfig {
	if m != nil {
		return m.BasicConfig
	}
	return nil
}

// Details of a LabelVideoObjectDetection operation metadata.
type LabelVideoObjectDetectionOperationMetadata struct {
	// Basic human annotation config used in labeling request.
	BasicConfig          *HumanAnnotationConfig `protobuf:"bytes,1,opt,name=basic_config,json=basicConfig,proto3" json:"basic_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *LabelVideoObjectDetectionOperationMetadata) Reset() {
	*m = LabelVideoObjectDetectionOperationMetadata{}
}
func (m *LabelVideoObjectDetectionOperationMetadata) String() string {
	return proto.CompactTextString(m)
}
func (*LabelVideoObjectDetectionOperationMetadata) ProtoMessage() {}
func (*LabelVideoObjectDetectionOperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_1364cf1609076a0d, []int{12}
}

func (m *LabelVideoObjectDetectionOperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelVideoObjectDetectionOperationMetadata.Unmarshal(m, b)
}
func (m *LabelVideoObjectDetectionOperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelVideoObjectDetectionOperationMetadata.Marshal(b, m, deterministic)
}
func (m *LabelVideoObjectDetectionOperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelVideoObjectDetectionOperationMetadata.Merge(m, src)
}
func (m *LabelVideoObjectDetectionOperationMetadata) XXX_Size() int {
	return xxx_messageInfo_LabelVideoObjectDetectionOperationMetadata.Size(m)
}
func (m *LabelVideoObjectDetectionOperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelVideoObjectDetectionOperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_LabelVideoObjectDetectionOperationMetadata proto.InternalMessageInfo

func (m *LabelVideoObjectDetectionOperationMetadata) GetBasicConfig() *HumanAnnotationConfig {
	if m != nil {
		return m.BasicConfig
	}
	return nil
}

// Details of a LabelVideoObjectTracking operation metadata.
type LabelVideoObjectTrackingOperationMetadata struct {
	// Basic human annotation config used in labeling request.
	BasicConfig          *HumanAnnotationConfig `protobuf:"bytes,1,opt,name=basic_config,json=basicConfig,proto3" json:"basic_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *LabelVideoObjectTrackingOperationMetadata) Reset() {
	*m = LabelVideoObjectTrackingOperationMetadata{}
}
func (m *LabelVideoObjectTrackingOperationMetadata) String() string { return proto.CompactTextString(m) }
func (*LabelVideoObjectTrackingOperationMetadata) ProtoMessage()    {}
func (*LabelVideoObjectTrackingOperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_1364cf1609076a0d, []int{13}
}

func (m *LabelVideoObjectTrackingOperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelVideoObjectTrackingOperationMetadata.Unmarshal(m, b)
}
func (m *LabelVideoObjectTrackingOperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelVideoObjectTrackingOperationMetadata.Marshal(b, m, deterministic)
}
func (m *LabelVideoObjectTrackingOperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelVideoObjectTrackingOperationMetadata.Merge(m, src)
}
func (m *LabelVideoObjectTrackingOperationMetadata) XXX_Size() int {
	return xxx_messageInfo_LabelVideoObjectTrackingOperationMetadata.Size(m)
}
func (m *LabelVideoObjectTrackingOperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelVideoObjectTrackingOperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_LabelVideoObjectTrackingOperationMetadata proto.InternalMessageInfo

func (m *LabelVideoObjectTrackingOperationMetadata) GetBasicConfig() *HumanAnnotationConfig {
	if m != nil {
		return m.BasicConfig
	}
	return nil
}

// Details of a LabelVideoEvent operation metadata.
type LabelVideoEventOperationMetadata struct {
	// Basic human annotation config used in labeling request.
	BasicConfig          *HumanAnnotationConfig `protobuf:"bytes,1,opt,name=basic_config,json=basicConfig,proto3" json:"basic_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *LabelVideoEventOperationMetadata) Reset()         { *m = LabelVideoEventOperationMetadata{} }
func (m *LabelVideoEventOperationMetadata) String() string { return proto.CompactTextString(m) }
func (*LabelVideoEventOperationMetadata) ProtoMessage()    {}
func (*LabelVideoEventOperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_1364cf1609076a0d, []int{14}
}

func (m *LabelVideoEventOperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelVideoEventOperationMetadata.Unmarshal(m, b)
}
func (m *LabelVideoEventOperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelVideoEventOperationMetadata.Marshal(b, m, deterministic)
}
func (m *LabelVideoEventOperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelVideoEventOperationMetadata.Merge(m, src)
}
func (m *LabelVideoEventOperationMetadata) XXX_Size() int {
	return xxx_messageInfo_LabelVideoEventOperationMetadata.Size(m)
}
func (m *LabelVideoEventOperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelVideoEventOperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_LabelVideoEventOperationMetadata proto.InternalMessageInfo

func (m *LabelVideoEventOperationMetadata) GetBasicConfig() *HumanAnnotationConfig {
	if m != nil {
		return m.BasicConfig
	}
	return nil
}

// Details of a LabelTextClassification operation metadata.
type LabelTextClassificationOperationMetadata struct {
	// Basic human annotation config used in labeling request.
	BasicConfig          *HumanAnnotationConfig `protobuf:"bytes,1,opt,name=basic_config,json=basicConfig,proto3" json:"basic_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *LabelTextClassificationOperationMetadata) Reset() {
	*m = LabelTextClassificationOperationMetadata{}
}
func (m *LabelTextClassificationOperationMetadata) String() string { return proto.CompactTextString(m) }
func (*LabelTextClassificationOperationMetadata) ProtoMessage()    {}
func (*LabelTextClassificationOperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_1364cf1609076a0d, []int{15}
}

func (m *LabelTextClassificationOperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelTextClassificationOperationMetadata.Unmarshal(m, b)
}
func (m *LabelTextClassificationOperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelTextClassificationOperationMetadata.Marshal(b, m, deterministic)
}
func (m *LabelTextClassificationOperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelTextClassificationOperationMetadata.Merge(m, src)
}
func (m *LabelTextClassificationOperationMetadata) XXX_Size() int {
	return xxx_messageInfo_LabelTextClassificationOperationMetadata.Size(m)
}
func (m *LabelTextClassificationOperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelTextClassificationOperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_LabelTextClassificationOperationMetadata proto.InternalMessageInfo

func (m *LabelTextClassificationOperationMetadata) GetBasicConfig() *HumanAnnotationConfig {
	if m != nil {
		return m.BasicConfig
	}
	return nil
}

// Details of a LabelTextEntityExtraction operation metadata.
type LabelTextEntityExtractionOperationMetadata struct {
	// Basic human annotation config used in labeling request.
	BasicConfig          *HumanAnnotationConfig `protobuf:"bytes,1,opt,name=basic_config,json=basicConfig,proto3" json:"basic_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *LabelTextEntityExtractionOperationMetadata) Reset() {
	*m = LabelTextEntityExtractionOperationMetadata{}
}
func (m *LabelTextEntityExtractionOperationMetadata) String() string {
	return proto.CompactTextString(m)
}
func (*LabelTextEntityExtractionOperationMetadata) ProtoMessage() {}
func (*LabelTextEntityExtractionOperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_1364cf1609076a0d, []int{16}
}

func (m *LabelTextEntityExtractionOperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelTextEntityExtractionOperationMetadata.Unmarshal(m, b)
}
func (m *LabelTextEntityExtractionOperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelTextEntityExtractionOperationMetadata.Marshal(b, m, deterministic)
}
func (m *LabelTextEntityExtractionOperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelTextEntityExtractionOperationMetadata.Merge(m, src)
}
func (m *LabelTextEntityExtractionOperationMetadata) XXX_Size() int {
	return xxx_messageInfo_LabelTextEntityExtractionOperationMetadata.Size(m)
}
func (m *LabelTextEntityExtractionOperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelTextEntityExtractionOperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_LabelTextEntityExtractionOperationMetadata proto.InternalMessageInfo

func (m *LabelTextEntityExtractionOperationMetadata) GetBasicConfig() *HumanAnnotationConfig {
	if m != nil {
		return m.BasicConfig
	}
	return nil
}

// Metadata of a CreateInstruction operation.
type CreateInstructionMetadata struct {
	// The name of the created Instruction.
	// projects/{project_id}/instructions/{instruction_id}
	Instruction string `protobuf:"bytes,1,opt,name=instruction,proto3" json:"instruction,omitempty"`
	// Partial failures encountered.
	// E.g. single files that couldn't be read.
	// Status details field will contain standard GCP error details.
	PartialFailures []*status.Status `protobuf:"bytes,2,rep,name=partial_failures,json=partialFailures,proto3" json:"partial_failures,omitempty"`
	// Timestamp when create instruction request was created.
	CreateTime           *timestamp.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *CreateInstructionMetadata) Reset()         { *m = CreateInstructionMetadata{} }
func (m *CreateInstructionMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateInstructionMetadata) ProtoMessage()    {}
func (*CreateInstructionMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_1364cf1609076a0d, []int{17}
}

func (m *CreateInstructionMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateInstructionMetadata.Unmarshal(m, b)
}
func (m *CreateInstructionMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateInstructionMetadata.Marshal(b, m, deterministic)
}
func (m *CreateInstructionMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateInstructionMetadata.Merge(m, src)
}
func (m *CreateInstructionMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateInstructionMetadata.Size(m)
}
func (m *CreateInstructionMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateInstructionMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateInstructionMetadata proto.InternalMessageInfo

func (m *CreateInstructionMetadata) GetInstruction() string {
	if m != nil {
		return m.Instruction
	}
	return ""
}

func (m *CreateInstructionMetadata) GetPartialFailures() []*status.Status {
	if m != nil {
		return m.PartialFailures
	}
	return nil
}

func (m *CreateInstructionMetadata) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func init() {
	proto.RegisterType((*ImportDataOperationResponse)(nil), "google.cloud.datalabeling.v1beta1.ImportDataOperationResponse")
	proto.RegisterType((*ExportDataOperationResponse)(nil), "google.cloud.datalabeling.v1beta1.ExportDataOperationResponse")
	proto.RegisterType((*ImportDataOperationMetadata)(nil), "google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata")
	proto.RegisterType((*ExportDataOperationMetadata)(nil), "google.cloud.datalabeling.v1beta1.ExportDataOperationMetadata")
	proto.RegisterType((*LabelOperationMetadata)(nil), "google.cloud.datalabeling.v1beta1.LabelOperationMetadata")
	proto.RegisterType((*LabelImageClassificationOperationMetadata)(nil), "google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata")
	proto.RegisterType((*LabelImageBoundingBoxOperationMetadata)(nil), "google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata")
	proto.RegisterType((*LabelImageOrientedBoundingBoxOperationMetadata)(nil), "google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata")
	proto.RegisterType((*LabelImageBoundingPolyOperationMetadata)(nil), "google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata")
	proto.RegisterType((*LabelImagePolylineOperationMetadata)(nil), "google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata")
	proto.RegisterType((*LabelImageSegmentationOperationMetadata)(nil), "google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata")
	proto.RegisterType((*LabelVideoClassificationOperationMetadata)(nil), "google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata")
	proto.RegisterType((*LabelVideoObjectDetectionOperationMetadata)(nil), "google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata")
	proto.RegisterType((*LabelVideoObjectTrackingOperationMetadata)(nil), "google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata")
	proto.RegisterType((*LabelVideoEventOperationMetadata)(nil), "google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata")
	proto.RegisterType((*LabelTextClassificationOperationMetadata)(nil), "google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata")
	proto.RegisterType((*LabelTextEntityExtractionOperationMetadata)(nil), "google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata")
	proto.RegisterType((*CreateInstructionMetadata)(nil), "google.cloud.datalabeling.v1beta1.CreateInstructionMetadata")
}

func init() {
	proto.RegisterFile("google/cloud/datalabeling/v1beta1/operations.proto", fileDescriptor_1364cf1609076a0d)
}

var fileDescriptor_1364cf1609076a0d = []byte{
	// 1040 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x98, 0xd1, 0x6e, 0x1b, 0x45,
	0x17, 0xc7, 0xbf, 0x49, 0xbf, 0x34, 0xe4, 0x6c, 0x4a, 0x82, 0x41, 0xad, 0x13, 0x17, 0xe2, 0xa6,
	0x02, 0x5c, 0x24, 0xbc, 0x6a, 0xb8, 0x41, 0xaa, 0x10, 0x22, 0x4e, 0xaa, 0x06, 0x1a, 0x12, 0x9c,
	0x88, 0x0b, 0xb8, 0x58, 0x8d, 0xd7, 0x93, 0x65, 0x60, 0x3d, 0xb3, 0xda, 0x99, 0xb5, 0x1c, 0x21,
	0x81, 0x04, 0x02, 0x0a, 0xa8, 0x12, 0x48, 0xbc, 0x40, 0x9f, 0x81, 0x2b, 0xde, 0x0e, 0xcd, 0xec,
	0xcc, 0x76, 0x1d, 0xaf, 0xe3, 0x75, 0xc4, 0x06, 0xee, 0xe2, 0xb3, 0xff, 0xf3, 0x3f, 0xbf, 0x9c,
	0x39, 0xa3, 0xb3, 0x36, 0x6c, 0x07, 0x9c, 0x07, 0x21, 0x71, 0xfd, 0x90, 0x27, 0x7d, 0xb7, 0x8f,
	0x25, 0x0e, 0x71, 0x8f, 0x84, 0x94, 0x05, 0xee, 0xf0, 0x7e, 0x8f, 0x48, 0x7c, 0xdf, 0xe5, 0x11,
	0x89, 0xb1, 0xa4, 0x9c, 0x89, 0x76, 0x14, 0x73, 0xc9, 0x6b, 0x77, 0xd2, 0x9c, 0xb6, 0xce, 0x69,
	0xe7, 0x73, 0xda, 0x26, 0x67, 0xe3, 0xb6, 0xb1, 0xc5, 0x11, 0x75, 0x31, 0x63, 0x5c, 0xe6, 0x0d,
	0x36, 0xd6, 0x73, 0x4f, 0x63, 0x22, 0x78, 0x12, 0xfb, 0xc4, 0x3c, 0x72, 0x67, 0xf3, 0xa8, 0xa0,
	0x20, 0xd2, 0x24, 0xbc, 0x3f, 0x3b, 0xe1, 0x8b, 0x64, 0x80, 0x99, 0xf7, 0x1c, 0xc3, 0xf3, 0x39,
	0x3b, 0xa5, 0x81, 0x31, 0xd8, 0x34, 0x06, 0xfa, 0x53, 0x2f, 0x39, 0x75, 0x25, 0x1d, 0x10, 0x21,
	0xf1, 0x20, 0x32, 0x82, 0x5b, 0x46, 0x10, 0x47, 0xbe, 0x2b, 0x24, 0x96, 0x89, 0xf9, 0x37, 0xb6,
	0xbe, 0x86, 0xc6, 0xfe, 0x20, 0xe2, 0xb1, 0xdc, 0xc5, 0x12, 0x1f, 0xda, 0x2e, 0x75, 0x89, 0x88,
	0x38, 0x13, 0xa4, 0x56, 0x87, 0x25, 0x83, 0x5a, 0x47, 0x4d, 0xd4, 0x5a, 0xee, 0xda, 0x8f, 0xb5,
	0x4d, 0x70, 0x24, 0x97, 0x38, 0xf4, 0x7c, 0x9e, 0x30, 0x59, 0x5f, 0x68, 0xa2, 0xd6, 0x62, 0x17,
	0x74, 0xa8, 0xa3, 0x22, 0xb5, 0x3b, 0xb0, 0x42, 0xb5, 0xb3, 0x51, 0x5c, 0xd3, 0x0a, 0x27, 0x8d,
	0x69, 0xc9, 0xd6, 0xb3, 0x05, 0x68, 0xec, 0x8d, 0xaa, 0xaa, 0x4e, 0x46, 0x93, 0xd5, 0xd3, 0x58,
	0x2a, 0xf9, 0x18, 0x1c, 0xdd, 0x66, 0x4f, 0x35, 0x44, 0xd4, 0xff, 0xdf, 0x44, 0x2d, 0x67, 0xfb,
	0xed, 0xf6, 0xcc, 0xc1, 0x68, 0x3f, 0x56, 0x81, 0x63, 0x95, 0xd4, 0x85, 0x30, 0xfb, 0xbb, 0x76,
	0x02, 0x37, 0x78, 0x22, 0xa3, 0x44, 0x9a, 0xb3, 0xa9, 0x2f, 0x6a, 0x47, 0xb7, 0x84, 0xe3, 0xa1,
	0xce, 0xeb, 0xe8, 0xb4, 0xee, 0x0a, 0xcf, 0x7d, 0xda, 0xfa, 0x13, 0x15, 0x9e, 0xd0, 0x01, 0x91,
	0x58, 0x59, 0x5d, 0xd0, 0xa3, 0xf7, 0x60, 0x2d, 0xc2, 0xb1, 0xa4, 0x38, 0xf4, 0x4e, 0x31, 0x0d,
	0x93, 0x98, 0x88, 0xfa, 0x42, 0xf3, 0x5a, 0xcb, 0xd9, 0xae, 0x59, 0xa4, 0x38, 0xf2, 0xdb, 0xc7,
	0x7a, 0x1c, 0xba, 0xab, 0x46, 0xfb, 0xd0, 0x48, 0x6b, 0x0f, 0xc0, 0xf1, 0x63, 0x82, 0x25, 0xf1,
	0xd4, 0x30, 0xe9, 0x06, 0x3a, 0xdb, 0x1b, 0x36, 0xd3, 0x4e, 0x5a, 0xfb, 0xc4, 0x4e, 0x5a, 0x17,
	0x52, 0xb9, 0x0a, 0x68, 0xea, 0x82, 0x93, 0xfd, 0x8f, 0x53, 0x7f, 0xbf, 0x0a, 0x37, 0xf5, 0xe1,
	0x4e, 0x02, 0xff, 0x86, 0xe0, 0x36, 0x1d, 0xe0, 0x80, 0x78, 0x7e, 0x88, 0x85, 0xa0, 0xa7, 0xd4,
	0x4f, 0xef, 0x61, 0x9f, 0x48, 0x4c, 0x43, 0x61, 0x2a, 0x3d, 0x2e, 0x3b, 0x3e, 0xfb, 0xca, 0xab,
	0x33, 0x66, 0x35, 0x51, 0xf4, 0xd1, 0xff, 0xba, 0x1b, 0x74, 0x52, 0xb7, 0x9b, 0x56, 0xac, 0x3d,
	0x41, 0x90, 0x3e, 0xf6, 0x7a, 0x3c, 0x61, 0x7d, 0xca, 0x02, 0xaf, 0xc7, 0x47, 0x19, 0x50, 0x3a,
	0xcf, 0xfb, 0x73, 0x01, 0xed, 0x18, 0xa3, 0x1d, 0x3e, 0x2a, 0xa2, 0xb9, 0x45, 0xcf, 0x89, 0x2c,
	0xca, 0xaf, 0x08, 0x1a, 0xe7, 0x50, 0x22, 0x1e, 0x9e, 0x65, 0x2c, 0x8e, 0x66, 0xf9, 0xf0, 0x52,
	0x2c, 0x47, 0x3c, 0x3c, 0x2b, 0x82, 0xa9, 0xd3, 0xf3, 0x2a, 0x4b, 0xf3, 0x0c, 0xc1, 0xdd, 0x94,
	0x86, 0xc7, 0x94, 0x30, 0x49, 0xfa, 0xc5, 0x1d, 0x7a, 0x51, 0x53, 0x7d, 0x32, 0x17, 0xd5, 0xa1,
	0x71, 0x9c, 0xd1, 0xa9, 0x4d, 0x3a, 0x45, 0x6c, 0x19, 0xbf, 0x81, 0x9b, 0x29, 0xa2, 0xea, 0x53,
	0x48, 0x19, 0xc9, 0xa8, 0x56, 0x34, 0xd5, 0xc3, 0xb9, 0xa8, 0x8e, 0x8c, 0x49, 0x11, 0xca, 0x2b,
	0x34, 0xaf, 0xb0, 0xf5, 0x7f, 0xc9, 0x86, 0x47, 0x90, 0x60, 0x40, 0x98, 0x1c, 0x9f, 0xe6, 0xd5,
	0x4b, 0x1c, 0xd8, 0x71, 0xce, 0x68, 0xfa, 0x81, 0xe5, 0x55, 0x16, 0x46, 0x5d, 0xae, 0x21, 0xed,
	0x13, 0x3e, 0xed, 0x72, 0x2d, 0xce, 0x77, 0xb9, 0x3e, 0x55, 0x5e, 0x25, 0x2e, 0xd7, 0x70, 0x52,
	0x67, 0x91, 0xfe, 0x40, 0xf0, 0x5a, 0x8a, 0xc4, 0x7b, 0x5f, 0x12, 0x5f, 0x2a, 0x14, 0xe2, 0x8f,
	0x41, 0x5d, 0xd7, 0x50, 0x07, 0x73, 0x41, 0x1d, 0x6a, 0xb3, 0x5d, 0xeb, 0x55, 0x44, 0xd5, 0x18,
	0x16, 0x08, 0x2d, 0xd6, 0xef, 0x08, 0x5e, 0x1d, 0xc3, 0x92, 0x31, 0xf6, 0xbf, 0x52, 0x83, 0x6d,
	0xa9, 0x96, 0x2e, 0xd1, 0xaa, 0xb4, 0xd8, 0x89, 0xb1, 0x9a, 0xde, 0xaa, 0x71, 0x9d, 0x65, 0x4a,
	0xe0, 0xe5, 0x14, 0x89, 0x0c, 0x09, 0x93, 0x19, 0xc8, 0x0b, 0x1a, 0xa4, 0x33, 0x17, 0xc8, 0x9e,
	0x72, 0x28, 0xaa, 0xff, 0xd2, 0x30, 0x7b, 0x6c, 0xcb, 0x3e, 0x45, 0xd0, 0x90, 0x64, 0x24, 0xa7,
	0xcd, 0xcc, 0xb2, 0xae, 0xff, 0x51, 0xd9, 0xfa, 0x27, 0x64, 0x24, 0x67, 0x8f, 0xcc, 0xba, 0x9c,
	0x90, 0xe5, 0x27, 0x46, 0xf3, 0x10, 0x26, 0xa9, 0x3c, 0xf3, 0xc8, 0x48, 0x9d, 0xcd, 0x18, 0xd2,
	0x8d, 0xf9, 0x26, 0x46, 0x21, 0xed, 0x69, 0xb3, 0xbd, 0xcc, 0xab, 0x70, 0x62, 0x64, 0x81, 0xd0,
	0x62, 0xdd, 0x83, 0xb5, 0x28, 0xe6, 0x41, 0x4c, 0x84, 0xf0, 0x22, 0x12, 0xfb, 0x84, 0xa5, 0x2b,
	0x77, 0xb1, 0xbb, 0x6a, 0xe3, 0x47, 0x69, 0xf8, 0x1f, 0x5e, 0xbd, 0x6b, 0xf3, 0xac, 0xde, 0x9d,
	0x65, 0x58, 0x32, 0x5d, 0xda, 0x7a, 0x82, 0xe0, 0x5e, 0xe9, 0x1d, 0x59, 0xfb, 0x1c, 0x56, 0x7a,
	0x58, 0x50, 0xdf, 0xbe, 0x74, 0x21, 0x5d, 0xf6, 0xdd, 0x12, 0x3d, 0x7e, 0xa4, 0x5e, 0xa9, 0x3f,
	0xc8, 0xde, 0xa8, 0xcd, 0xdb, 0x97, 0xa3, 0xdd, 0xcc, 0xcb, 0xd7, 0x0f, 0x08, 0xde, 0x28, 0xb7,
	0x1d, 0xab, 0xe5, 0x78, 0x8a, 0x60, 0xce, 0x1d, 0x54, 0x2d, 0xcf, 0x8f, 0x08, 0xde, 0x2c, 0xb9,
	0xa9, 0xab, 0x05, 0xf9, 0x0e, 0xc1, 0xdd, 0x12, 0x6b, 0xf0, 0x2a, 0xbb, 0x71, 0xe1, 0x1a, 0xac,
	0x16, 0x24, 0xbb, 0x39, 0x65, 0x16, 0x60, 0xb5, 0x28, 0x3f, 0x23, 0x78, 0xab, 0xfc, 0xda, 0xbb,
	0xca, 0xb6, 0xcc, 0x58, 0x76, 0xd5, 0xa2, 0x7c, 0x0b, 0xcd, 0x59, 0xdb, 0xae, 0x5a, 0x80, 0x9f,
	0x10, 0xb4, 0xca, 0xee, 0xbb, 0x2b, 0x9a, 0x90, 0x52, 0x6b, 0xae, 0x5a, 0x96, 0xbf, 0x10, 0xac,
	0x77, 0xf4, 0x32, 0xda, 0x67, 0x42, 0xc6, 0x89, 0x3f, 0x56, 0xba, 0x09, 0x0e, 0x7d, 0x1e, 0x36,
	0x5f, 0x58, 0xf3, 0xa1, 0x7f, 0xf3, 0x4b, 0xeb, 0xce, 0x08, 0x5e, 0xf7, 0xf9, 0x60, 0x76, 0x1f,
	0x8e, 0xd0, 0x67, 0x07, 0x46, 0x14, 0xf0, 0x10, 0xb3, 0xa0, 0xcd, 0xe3, 0xc0, 0x0d, 0x08, 0xd3,
	0xfe, 0xe6, 0x37, 0x2b, 0x1c, 0x51, 0x71, 0xc1, 0xcf, 0x50, 0x0f, 0xf2, 0xc1, 0xde, 0x75, 0x9d,
	0xf9, 0xce, 0xdf, 0x01, 0x00, 0x00, 0xff, 0xff, 0x28, 0xe6, 0x49, 0x4e, 0x80, 0x13, 0x00, 0x00,
}
