// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/dialogflow/v2/session.proto

package dialogflow

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	_struct "github.com/golang/protobuf/ptypes/struct"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	latlng "google.golang.org/genproto/googleapis/type/latlng"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Type of the response message.
type StreamingRecognitionResult_MessageType int32

const (
	// Not specified. Should never be used.
	StreamingRecognitionResult_MESSAGE_TYPE_UNSPECIFIED StreamingRecognitionResult_MessageType = 0
	// Message contains a (possibly partial) transcript.
	StreamingRecognitionResult_TRANSCRIPT StreamingRecognitionResult_MessageType = 1
	// Event indicates that the server has detected the end of the user's speech
	// utterance and expects no additional inputs.
	// Therefore, the server will not process additional audio (although it may subsequently return additional results). The
	// client should stop sending additional audio data, half-close the gRPC
	// connection, and wait for any additional results until the server closes
	// the gRPC connection. This message is only sent if `single_utterance` was
	// set to `true`, and is not used otherwise.
	StreamingRecognitionResult_END_OF_SINGLE_UTTERANCE StreamingRecognitionResult_MessageType = 2
)

var StreamingRecognitionResult_MessageType_name = map[int32]string{
	0: "MESSAGE_TYPE_UNSPECIFIED",
	1: "TRANSCRIPT",
	2: "END_OF_SINGLE_UTTERANCE",
}

var StreamingRecognitionResult_MessageType_value = map[string]int32{
	"MESSAGE_TYPE_UNSPECIFIED": 0,
	"TRANSCRIPT":               1,
	"END_OF_SINGLE_UTTERANCE":  2,
}

func (x StreamingRecognitionResult_MessageType) String() string {
	return proto.EnumName(StreamingRecognitionResult_MessageType_name, int32(x))
}

func (StreamingRecognitionResult_MessageType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_2f8892c06d516e44, []int{7, 0}
}

// ============================================================================
// Requests and responses for custom methods.
// The request to detect user's intent.
type DetectIntentRequest struct {
	// Required. The name of the session this query is sent to. Format:
	// `projects/<Project ID>/agent/sessions/<Session ID>`. It's up to the API
	// caller to choose an appropriate session ID. It can be a random number or
	// some type of user identifier (preferably hashed). The length of the session
	// ID must not exceed 36 bytes.
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// The parameters of this query.
	QueryParams *QueryParameters `protobuf:"bytes,2,opt,name=query_params,json=queryParams,proto3" json:"query_params,omitempty"`
	// Required. The input specification. It can be set to:
	//
	// 1.  an audio config
	//     which instructs the speech recognizer how to process the speech audio,
	//
	// 2.  a conversational query in the form of text, or
	//
	// 3.  an event that specifies which intent to trigger.
	QueryInput *QueryInput `protobuf:"bytes,3,opt,name=query_input,json=queryInput,proto3" json:"query_input,omitempty"`
	// Instructs the speech synthesizer how to generate the output
	// audio. If this field is not set and agent-level speech synthesizer is not
	// configured, no output audio is generated.
	OutputAudioConfig *OutputAudioConfig `protobuf:"bytes,4,opt,name=output_audio_config,json=outputAudioConfig,proto3" json:"output_audio_config,omitempty"`
	// Mask for [output_audio_config][google.cloud.dialogflow.v2.DetectIntentRequest.output_audio_config] indicating which settings in this
	// request-level config should override speech synthesizer settings defined at
	// agent-level.
	//
	// If unspecified or empty, [output_audio_config][google.cloud.dialogflow.v2.DetectIntentRequest.output_audio_config] replaces the agent-level
	// config in its entirety.
	OutputAudioConfigMask *field_mask.FieldMask `protobuf:"bytes,7,opt,name=output_audio_config_mask,json=outputAudioConfigMask,proto3" json:"output_audio_config_mask,omitempty"`
	// The natural language speech audio to be processed. This field
	// should be populated iff `query_input` is set to an input audio config.
	// A single request can contain up to 1 minute of speech audio data.
	InputAudio           []byte   `protobuf:"bytes,5,opt,name=input_audio,json=inputAudio,proto3" json:"input_audio,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DetectIntentRequest) Reset()         { *m = DetectIntentRequest{} }
func (m *DetectIntentRequest) String() string { return proto.CompactTextString(m) }
func (*DetectIntentRequest) ProtoMessage()    {}
func (*DetectIntentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2f8892c06d516e44, []int{0}
}

func (m *DetectIntentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DetectIntentRequest.Unmarshal(m, b)
}
func (m *DetectIntentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DetectIntentRequest.Marshal(b, m, deterministic)
}
func (m *DetectIntentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DetectIntentRequest.Merge(m, src)
}
func (m *DetectIntentRequest) XXX_Size() int {
	return xxx_messageInfo_DetectIntentRequest.Size(m)
}
func (m *DetectIntentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DetectIntentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DetectIntentRequest proto.InternalMessageInfo

func (m *DetectIntentRequest) GetSession() string {
	if m != nil {
		return m.Session
	}
	return ""
}

func (m *DetectIntentRequest) GetQueryParams() *QueryParameters {
	if m != nil {
		return m.QueryParams
	}
	return nil
}

func (m *DetectIntentRequest) GetQueryInput() *QueryInput {
	if m != nil {
		return m.QueryInput
	}
	return nil
}

func (m *DetectIntentRequest) GetOutputAudioConfig() *OutputAudioConfig {
	if m != nil {
		return m.OutputAudioConfig
	}
	return nil
}

func (m *DetectIntentRequest) GetOutputAudioConfigMask() *field_mask.FieldMask {
	if m != nil {
		return m.OutputAudioConfigMask
	}
	return nil
}

func (m *DetectIntentRequest) GetInputAudio() []byte {
	if m != nil {
		return m.InputAudio
	}
	return nil
}

// The message returned from the DetectIntent method.
type DetectIntentResponse struct {
	// The unique identifier of the response. It can be used to
	// locate a response in the training example set or for reporting issues.
	ResponseId string `protobuf:"bytes,1,opt,name=response_id,json=responseId,proto3" json:"response_id,omitempty"`
	// The selected results of the conversational query or event processing.
	// See `alternative_query_results` for additional potential results.
	QueryResult *QueryResult `protobuf:"bytes,2,opt,name=query_result,json=queryResult,proto3" json:"query_result,omitempty"`
	// Specifies the status of the webhook request.
	WebhookStatus *status.Status `protobuf:"bytes,3,opt,name=webhook_status,json=webhookStatus,proto3" json:"webhook_status,omitempty"`
	// The audio data bytes encoded as specified in the request.
	// Note: The output audio is generated based on the values of default platform
	// text responses found in the `query_result.fulfillment_messages` field. If
	// multiple default text responses exist, they will be concatenated when
	// generating audio. If no default platform text responses exist, the
	// generated audio content will be empty.
	OutputAudio []byte `protobuf:"bytes,4,opt,name=output_audio,json=outputAudio,proto3" json:"output_audio,omitempty"`
	// The config used by the speech synthesizer to generate the output audio.
	OutputAudioConfig    *OutputAudioConfig `protobuf:"bytes,6,opt,name=output_audio_config,json=outputAudioConfig,proto3" json:"output_audio_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *DetectIntentResponse) Reset()         { *m = DetectIntentResponse{} }
func (m *DetectIntentResponse) String() string { return proto.CompactTextString(m) }
func (*DetectIntentResponse) ProtoMessage()    {}
func (*DetectIntentResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_2f8892c06d516e44, []int{1}
}

func (m *DetectIntentResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DetectIntentResponse.Unmarshal(m, b)
}
func (m *DetectIntentResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DetectIntentResponse.Marshal(b, m, deterministic)
}
func (m *DetectIntentResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DetectIntentResponse.Merge(m, src)
}
func (m *DetectIntentResponse) XXX_Size() int {
	return xxx_messageInfo_DetectIntentResponse.Size(m)
}
func (m *DetectIntentResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DetectIntentResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DetectIntentResponse proto.InternalMessageInfo

func (m *DetectIntentResponse) GetResponseId() string {
	if m != nil {
		return m.ResponseId
	}
	return ""
}

func (m *DetectIntentResponse) GetQueryResult() *QueryResult {
	if m != nil {
		return m.QueryResult
	}
	return nil
}

func (m *DetectIntentResponse) GetWebhookStatus() *status.Status {
	if m != nil {
		return m.WebhookStatus
	}
	return nil
}

func (m *DetectIntentResponse) GetOutputAudio() []byte {
	if m != nil {
		return m.OutputAudio
	}
	return nil
}

func (m *DetectIntentResponse) GetOutputAudioConfig() *OutputAudioConfig {
	if m != nil {
		return m.OutputAudioConfig
	}
	return nil
}

// Represents the parameters of the conversational query.
type QueryParameters struct {
	// The time zone of this conversational query from the
	// [time zone database](https://www.iana.org/time-zones), e.g.,
	// America/New_York, Europe/Paris. If not provided, the time zone specified in
	// agent settings is used.
	TimeZone string `protobuf:"bytes,1,opt,name=time_zone,json=timeZone,proto3" json:"time_zone,omitempty"`
	// The geo location of this conversational query.
	GeoLocation *latlng.LatLng `protobuf:"bytes,2,opt,name=geo_location,json=geoLocation,proto3" json:"geo_location,omitempty"`
	// The collection of contexts to be activated before this query is
	// executed.
	Contexts []*Context `protobuf:"bytes,3,rep,name=contexts,proto3" json:"contexts,omitempty"`
	// Specifies whether to delete all contexts in the current session
	// before the new ones are activated.
	ResetContexts bool `protobuf:"varint,4,opt,name=reset_contexts,json=resetContexts,proto3" json:"reset_contexts,omitempty"`
	// Additional session entity types to replace or extend developer
	// entity types with. The entity synonyms apply to all languages and persist
	// for the session of this query.
	SessionEntityTypes []*SessionEntityType `protobuf:"bytes,5,rep,name=session_entity_types,json=sessionEntityTypes,proto3" json:"session_entity_types,omitempty"`
	// This field can be used to pass custom data into the webhook
	// associated with the agent. Arbitrary JSON objects are supported.
	Payload *_struct.Struct `protobuf:"bytes,6,opt,name=payload,proto3" json:"payload,omitempty"`
	// Configures the type of sentiment analysis to perform. If not
	// provided, sentiment analysis is not performed.
	SentimentAnalysisRequestConfig *SentimentAnalysisRequestConfig `protobuf:"bytes,10,opt,name=sentiment_analysis_request_config,json=sentimentAnalysisRequestConfig,proto3" json:"sentiment_analysis_request_config,omitempty"`
	XXX_NoUnkeyedLiteral           struct{}                        `json:"-"`
	XXX_unrecognized               []byte                          `json:"-"`
	XXX_sizecache                  int32                           `json:"-"`
}

func (m *QueryParameters) Reset()         { *m = QueryParameters{} }
func (m *QueryParameters) String() string { return proto.CompactTextString(m) }
func (*QueryParameters) ProtoMessage()    {}
func (*QueryParameters) Descriptor() ([]byte, []int) {
	return fileDescriptor_2f8892c06d516e44, []int{2}
}

func (m *QueryParameters) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryParameters.Unmarshal(m, b)
}
func (m *QueryParameters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryParameters.Marshal(b, m, deterministic)
}
func (m *QueryParameters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryParameters.Merge(m, src)
}
func (m *QueryParameters) XXX_Size() int {
	return xxx_messageInfo_QueryParameters.Size(m)
}
func (m *QueryParameters) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryParameters.DiscardUnknown(m)
}

var xxx_messageInfo_QueryParameters proto.InternalMessageInfo

func (m *QueryParameters) GetTimeZone() string {
	if m != nil {
		return m.TimeZone
	}
	return ""
}

func (m *QueryParameters) GetGeoLocation() *latlng.LatLng {
	if m != nil {
		return m.GeoLocation
	}
	return nil
}

func (m *QueryParameters) GetContexts() []*Context {
	if m != nil {
		return m.Contexts
	}
	return nil
}

func (m *QueryParameters) GetResetContexts() bool {
	if m != nil {
		return m.ResetContexts
	}
	return false
}

func (m *QueryParameters) GetSessionEntityTypes() []*SessionEntityType {
	if m != nil {
		return m.SessionEntityTypes
	}
	return nil
}

func (m *QueryParameters) GetPayload() *_struct.Struct {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *QueryParameters) GetSentimentAnalysisRequestConfig() *SentimentAnalysisRequestConfig {
	if m != nil {
		return m.SentimentAnalysisRequestConfig
	}
	return nil
}

// Represents the query input. It can contain either:
//
// 1.  An audio config which
//     instructs the speech recognizer how to process the speech audio.
//
// 2.  A conversational query in the form of text,.
//
// 3.  An event that specifies which intent to trigger.
type QueryInput struct {
	// Required. The input specification.
	//
	// Types that are valid to be assigned to Input:
	//	*QueryInput_AudioConfig
	//	*QueryInput_Text
	//	*QueryInput_Event
	Input                isQueryInput_Input `protobuf_oneof:"input"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *QueryInput) Reset()         { *m = QueryInput{} }
func (m *QueryInput) String() string { return proto.CompactTextString(m) }
func (*QueryInput) ProtoMessage()    {}
func (*QueryInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_2f8892c06d516e44, []int{3}
}

func (m *QueryInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryInput.Unmarshal(m, b)
}
func (m *QueryInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryInput.Marshal(b, m, deterministic)
}
func (m *QueryInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryInput.Merge(m, src)
}
func (m *QueryInput) XXX_Size() int {
	return xxx_messageInfo_QueryInput.Size(m)
}
func (m *QueryInput) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryInput.DiscardUnknown(m)
}

var xxx_messageInfo_QueryInput proto.InternalMessageInfo

type isQueryInput_Input interface {
	isQueryInput_Input()
}

type QueryInput_AudioConfig struct {
	AudioConfig *InputAudioConfig `protobuf:"bytes,1,opt,name=audio_config,json=audioConfig,proto3,oneof"`
}

type QueryInput_Text struct {
	Text *TextInput `protobuf:"bytes,2,opt,name=text,proto3,oneof"`
}

type QueryInput_Event struct {
	Event *EventInput `protobuf:"bytes,3,opt,name=event,proto3,oneof"`
}

func (*QueryInput_AudioConfig) isQueryInput_Input() {}

func (*QueryInput_Text) isQueryInput_Input() {}

func (*QueryInput_Event) isQueryInput_Input() {}

func (m *QueryInput) GetInput() isQueryInput_Input {
	if m != nil {
		return m.Input
	}
	return nil
}

func (m *QueryInput) GetAudioConfig() *InputAudioConfig {
	if x, ok := m.GetInput().(*QueryInput_AudioConfig); ok {
		return x.AudioConfig
	}
	return nil
}

func (m *QueryInput) GetText() *TextInput {
	if x, ok := m.GetInput().(*QueryInput_Text); ok {
		return x.Text
	}
	return nil
}

func (m *QueryInput) GetEvent() *EventInput {
	if x, ok := m.GetInput().(*QueryInput_Event); ok {
		return x.Event
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*QueryInput) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*QueryInput_AudioConfig)(nil),
		(*QueryInput_Text)(nil),
		(*QueryInput_Event)(nil),
	}
}

// Represents the result of conversational query or event processing.
type QueryResult struct {
	// The original conversational query text:
	//
	// - If natural language text was provided as input, `query_text` contains
	//   a copy of the input.
	// - If natural language speech audio was provided as input, `query_text`
	//   contains the speech recognition result. If speech recognizer produced
	//   multiple alternatives, a particular one is picked.
	// - If automatic spell correction is enabled, `query_text` will contain the
	//   corrected user input.
	QueryText string `protobuf:"bytes,1,opt,name=query_text,json=queryText,proto3" json:"query_text,omitempty"`
	// The language that was triggered during intent detection.
	// See [Language
	// Support](https://cloud.google.com/dialogflow/docs/reference/language)
	// for a list of the currently supported language codes.
	LanguageCode string `protobuf:"bytes,15,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// The Speech recognition confidence between 0.0 and 1.0. A higher number
	// indicates an estimated greater likelihood that the recognized words are
	// correct. The default of 0.0 is a sentinel value indicating that confidence
	// was not set.
	//
	// This field is not guaranteed to be accurate or set. In particular this
	// field isn't set for StreamingDetectIntent since the streaming endpoint has
	// separate confidence estimates per portion of the audio in
	// StreamingRecognitionResult.
	SpeechRecognitionConfidence float32 `protobuf:"fixed32,2,opt,name=speech_recognition_confidence,json=speechRecognitionConfidence,proto3" json:"speech_recognition_confidence,omitempty"`
	// The action name from the matched intent.
	Action string `protobuf:"bytes,3,opt,name=action,proto3" json:"action,omitempty"`
	// The collection of extracted parameters.
	Parameters *_struct.Struct `protobuf:"bytes,4,opt,name=parameters,proto3" json:"parameters,omitempty"`
	// This field is set to:
	//
	// - `false` if the matched intent has required parameters and not all of
	//    the required parameter values have been collected.
	// - `true` if all required parameter values have been collected, or if the
	//    matched intent doesn't contain any required parameters.
	AllRequiredParamsPresent bool `protobuf:"varint,5,opt,name=all_required_params_present,json=allRequiredParamsPresent,proto3" json:"all_required_params_present,omitempty"`
	// The text to be pronounced to the user or shown on the screen.
	// Note: This is a legacy field, `fulfillment_messages` should be preferred.
	FulfillmentText string `protobuf:"bytes,6,opt,name=fulfillment_text,json=fulfillmentText,proto3" json:"fulfillment_text,omitempty"`
	// The collection of rich messages to present to the user.
	FulfillmentMessages []*Intent_Message `protobuf:"bytes,7,rep,name=fulfillment_messages,json=fulfillmentMessages,proto3" json:"fulfillment_messages,omitempty"`
	// If the query was fulfilled by a webhook call, this field is set to the
	// value of the `source` field returned in the webhook response.
	WebhookSource string `protobuf:"bytes,8,opt,name=webhook_source,json=webhookSource,proto3" json:"webhook_source,omitempty"`
	// If the query was fulfilled by a webhook call, this field is set to the
	// value of the `payload` field returned in the webhook response.
	WebhookPayload *_struct.Struct `protobuf:"bytes,9,opt,name=webhook_payload,json=webhookPayload,proto3" json:"webhook_payload,omitempty"`
	// The collection of output contexts. If applicable,
	// `output_contexts.parameters` contains entries with name
	// `<parameter name>.original` containing the original parameter values
	// before the query.
	OutputContexts []*Context `protobuf:"bytes,10,rep,name=output_contexts,json=outputContexts,proto3" json:"output_contexts,omitempty"`
	// The intent that matched the conversational query. Some, not
	// all fields are filled in this message, including but not limited to:
	// `name`, `display_name`, `end_interaction` and `is_fallback`.
	Intent *Intent `protobuf:"bytes,11,opt,name=intent,proto3" json:"intent,omitempty"`
	// The intent detection confidence. Values range from 0.0
	// (completely uncertain) to 1.0 (completely certain).
	// This value is for informational purpose only and is only used to
	// help match the best intent within the classification threshold.
	// This value may change for the same end-user expression at any time due to a
	// model retraining or change in implementation.
	// If there are `multiple knowledge_answers` messages, this value is set to
	// the greatest `knowledgeAnswers.match_confidence` value in the list.
	IntentDetectionConfidence float32 `protobuf:"fixed32,12,opt,name=intent_detection_confidence,json=intentDetectionConfidence,proto3" json:"intent_detection_confidence,omitempty"`
	// Free-form diagnostic information for the associated detect intent request.
	// The fields of this data can change without notice, so you should not write
	// code that depends on its structure.
	// The data may contain:
	//
	// - webhook call latency
	// - webhook errors
	DiagnosticInfo *_struct.Struct `protobuf:"bytes,14,opt,name=diagnostic_info,json=diagnosticInfo,proto3" json:"diagnostic_info,omitempty"`
	// The sentiment analysis result, which depends on the
	// `sentiment_analysis_request_config` specified in the request.
	SentimentAnalysisResult *SentimentAnalysisResult `protobuf:"bytes,17,opt,name=sentiment_analysis_result,json=sentimentAnalysisResult,proto3" json:"sentiment_analysis_result,omitempty"`
	XXX_NoUnkeyedLiteral    struct{}                 `json:"-"`
	XXX_unrecognized        []byte                   `json:"-"`
	XXX_sizecache           int32                    `json:"-"`
}

func (m *QueryResult) Reset()         { *m = QueryResult{} }
func (m *QueryResult) String() string { return proto.CompactTextString(m) }
func (*QueryResult) ProtoMessage()    {}
func (*QueryResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_2f8892c06d516e44, []int{4}
}

func (m *QueryResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryResult.Unmarshal(m, b)
}
func (m *QueryResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryResult.Marshal(b, m, deterministic)
}
func (m *QueryResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryResult.Merge(m, src)
}
func (m *QueryResult) XXX_Size() int {
	return xxx_messageInfo_QueryResult.Size(m)
}
func (m *QueryResult) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryResult.DiscardUnknown(m)
}

var xxx_messageInfo_QueryResult proto.InternalMessageInfo

func (m *QueryResult) GetQueryText() string {
	if m != nil {
		return m.QueryText
	}
	return ""
}

func (m *QueryResult) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *QueryResult) GetSpeechRecognitionConfidence() float32 {
	if m != nil {
		return m.SpeechRecognitionConfidence
	}
	return 0
}

func (m *QueryResult) GetAction() string {
	if m != nil {
		return m.Action
	}
	return ""
}

func (m *QueryResult) GetParameters() *_struct.Struct {
	if m != nil {
		return m.Parameters
	}
	return nil
}

func (m *QueryResult) GetAllRequiredParamsPresent() bool {
	if m != nil {
		return m.AllRequiredParamsPresent
	}
	return false
}

func (m *QueryResult) GetFulfillmentText() string {
	if m != nil {
		return m.FulfillmentText
	}
	return ""
}

func (m *QueryResult) GetFulfillmentMessages() []*Intent_Message {
	if m != nil {
		return m.FulfillmentMessages
	}
	return nil
}

func (m *QueryResult) GetWebhookSource() string {
	if m != nil {
		return m.WebhookSource
	}
	return ""
}

func (m *QueryResult) GetWebhookPayload() *_struct.Struct {
	if m != nil {
		return m.WebhookPayload
	}
	return nil
}

func (m *QueryResult) GetOutputContexts() []*Context {
	if m != nil {
		return m.OutputContexts
	}
	return nil
}

func (m *QueryResult) GetIntent() *Intent {
	if m != nil {
		return m.Intent
	}
	return nil
}

func (m *QueryResult) GetIntentDetectionConfidence() float32 {
	if m != nil {
		return m.IntentDetectionConfidence
	}
	return 0
}

func (m *QueryResult) GetDiagnosticInfo() *_struct.Struct {
	if m != nil {
		return m.DiagnosticInfo
	}
	return nil
}

func (m *QueryResult) GetSentimentAnalysisResult() *SentimentAnalysisResult {
	if m != nil {
		return m.SentimentAnalysisResult
	}
	return nil
}

// The top-level message sent by the client to the
// [Sessions.StreamingDetectIntent][google.cloud.dialogflow.v2.Sessions.StreamingDetectIntent] method.
//
// Multiple request messages should be sent in order:
//
// 1.  The first message must contain
// [session][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.session],
//     [query_input][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.query_input] plus optionally
//     [query_params][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.query_params]. If the client
//     wants to receive an audio response, it should also contain
//     [output_audio_config][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.output_audio_config].
//     The message must not contain
//     [input_audio][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.input_audio].
// 2.  If [query_input][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.query_input] was set to
//     [query_input.audio_config][google.cloud.dialogflow.v2.InputAudioConfig], all subsequent
//     messages must contain
//     [input_audio][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.input_audio] to continue with
//     Speech recognition.
//     If you decide to rather detect an intent from text input after you
//     already started Speech recognition, please send a message with
//     [query_input.text][google.cloud.dialogflow.v2.QueryInput.text].
//
//     However, note that:
//
//     * Dialogflow will bill you for the audio duration so far.
//     * Dialogflow discards all Speech recognition results in favor of the
//       input text.
//     * Dialogflow will use the language code from the first message.
//
// After you sent all input, you must half-close or abort the request stream.
type StreamingDetectIntentRequest struct {
	// Required. The name of the session the query is sent to.
	// Format of the session name:
	// `projects/<Project ID>/agent/sessions/<Session ID>`. It's up to the API
	// caller to choose an appropriate `Session ID`. It can be a random number or
	// some type of user identifier (preferably hashed). The length of the session
	// ID must not exceed 36 characters.
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// The parameters of this query.
	QueryParams *QueryParameters `protobuf:"bytes,2,opt,name=query_params,json=queryParams,proto3" json:"query_params,omitempty"`
	// Required. The input specification. It can be set to:
	//
	// 1.  an audio config which instructs the speech recognizer how to process
	//     the speech audio,
	//
	// 2.  a conversational query in the form of text, or
	//
	// 3.  an event that specifies which intent to trigger.
	QueryInput *QueryInput `protobuf:"bytes,3,opt,name=query_input,json=queryInput,proto3" json:"query_input,omitempty"`
	// Please use [InputAudioConfig.single_utterance][google.cloud.dialogflow.v2.InputAudioConfig.single_utterance] instead.
	// If `false` (default), recognition does not cease until
	// the client closes the stream. If `true`, the recognizer will detect a
	// single spoken utterance in input audio. Recognition ceases when it detects
	// the audio's voice has stopped or paused. In this case, once a detected
	// intent is received, the client should close the stream and start a new
	// request with a new stream as needed.
	// This setting is ignored when `query_input` is a piece of text or an event.
	SingleUtterance bool `protobuf:"varint,4,opt,name=single_utterance,json=singleUtterance,proto3" json:"single_utterance,omitempty"` // Deprecated: Do not use.
	// Instructs the speech synthesizer how to generate the output
	// audio. If this field is not set and agent-level speech synthesizer is not
	// configured, no output audio is generated.
	OutputAudioConfig *OutputAudioConfig `protobuf:"bytes,5,opt,name=output_audio_config,json=outputAudioConfig,proto3" json:"output_audio_config,omitempty"`
	// Mask for [output_audio_config][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.output_audio_config] indicating which settings in this
	// request-level config should override speech synthesizer settings defined at
	// agent-level.
	//
	// If unspecified or empty, [output_audio_config][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.output_audio_config] replaces the agent-level
	// config in its entirety.
	OutputAudioConfigMask *field_mask.FieldMask `protobuf:"bytes,7,opt,name=output_audio_config_mask,json=outputAudioConfigMask,proto3" json:"output_audio_config_mask,omitempty"`
	// The input audio content to be recognized. Must be sent if
	// `query_input` was set to a streaming input audio config. The complete audio
	// over all streaming messages must not exceed 1 minute.
	InputAudio           []byte   `protobuf:"bytes,6,opt,name=input_audio,json=inputAudio,proto3" json:"input_audio,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamingDetectIntentRequest) Reset()         { *m = StreamingDetectIntentRequest{} }
func (m *StreamingDetectIntentRequest) String() string { return proto.CompactTextString(m) }
func (*StreamingDetectIntentRequest) ProtoMessage()    {}
func (*StreamingDetectIntentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2f8892c06d516e44, []int{5}
}

func (m *StreamingDetectIntentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingDetectIntentRequest.Unmarshal(m, b)
}
func (m *StreamingDetectIntentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingDetectIntentRequest.Marshal(b, m, deterministic)
}
func (m *StreamingDetectIntentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingDetectIntentRequest.Merge(m, src)
}
func (m *StreamingDetectIntentRequest) XXX_Size() int {
	return xxx_messageInfo_StreamingDetectIntentRequest.Size(m)
}
func (m *StreamingDetectIntentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingDetectIntentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingDetectIntentRequest proto.InternalMessageInfo

func (m *StreamingDetectIntentRequest) GetSession() string {
	if m != nil {
		return m.Session
	}
	return ""
}

func (m *StreamingDetectIntentRequest) GetQueryParams() *QueryParameters {
	if m != nil {
		return m.QueryParams
	}
	return nil
}

func (m *StreamingDetectIntentRequest) GetQueryInput() *QueryInput {
	if m != nil {
		return m.QueryInput
	}
	return nil
}

// Deprecated: Do not use.
func (m *StreamingDetectIntentRequest) GetSingleUtterance() bool {
	if m != nil {
		return m.SingleUtterance
	}
	return false
}

func (m *StreamingDetectIntentRequest) GetOutputAudioConfig() *OutputAudioConfig {
	if m != nil {
		return m.OutputAudioConfig
	}
	return nil
}

func (m *StreamingDetectIntentRequest) GetOutputAudioConfigMask() *field_mask.FieldMask {
	if m != nil {
		return m.OutputAudioConfigMask
	}
	return nil
}

func (m *StreamingDetectIntentRequest) GetInputAudio() []byte {
	if m != nil {
		return m.InputAudio
	}
	return nil
}

// The top-level message returned from the
// `StreamingDetectIntent` method.
//
// Multiple response messages can be returned in order:
//
// 1.  If the input was set to streaming audio, the first one or more messages
//     contain `recognition_result`. Each `recognition_result` represents a more
//     complete transcript of what the user said. The last `recognition_result`
//     has `is_final` set to `true`.
//
// 2.  The next message contains `response_id`, `query_result`
//     and optionally `webhook_status` if a WebHook was called.
type StreamingDetectIntentResponse struct {
	// The unique identifier of the response. It can be used to
	// locate a response in the training example set or for reporting issues.
	ResponseId string `protobuf:"bytes,1,opt,name=response_id,json=responseId,proto3" json:"response_id,omitempty"`
	// The result of speech recognition.
	RecognitionResult *StreamingRecognitionResult `protobuf:"bytes,2,opt,name=recognition_result,json=recognitionResult,proto3" json:"recognition_result,omitempty"`
	// The result of the conversational query or event processing.
	QueryResult *QueryResult `protobuf:"bytes,3,opt,name=query_result,json=queryResult,proto3" json:"query_result,omitempty"`
	// Specifies the status of the webhook request.
	WebhookStatus *status.Status `protobuf:"bytes,4,opt,name=webhook_status,json=webhookStatus,proto3" json:"webhook_status,omitempty"`
	// The audio data bytes encoded as specified in the request.
	// Note: The output audio is generated based on the values of default platform
	// text responses found in the `query_result.fulfillment_messages` field. If
	// multiple default text responses exist, they will be concatenated when
	// generating audio. If no default platform text responses exist, the
	// generated audio content will be empty.
	OutputAudio []byte `protobuf:"bytes,5,opt,name=output_audio,json=outputAudio,proto3" json:"output_audio,omitempty"`
	// The config used by the speech synthesizer to generate the output audio.
	OutputAudioConfig    *OutputAudioConfig `protobuf:"bytes,6,opt,name=output_audio_config,json=outputAudioConfig,proto3" json:"output_audio_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *StreamingDetectIntentResponse) Reset()         { *m = StreamingDetectIntentResponse{} }
func (m *StreamingDetectIntentResponse) String() string { return proto.CompactTextString(m) }
func (*StreamingDetectIntentResponse) ProtoMessage()    {}
func (*StreamingDetectIntentResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_2f8892c06d516e44, []int{6}
}

func (m *StreamingDetectIntentResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingDetectIntentResponse.Unmarshal(m, b)
}
func (m *StreamingDetectIntentResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingDetectIntentResponse.Marshal(b, m, deterministic)
}
func (m *StreamingDetectIntentResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingDetectIntentResponse.Merge(m, src)
}
func (m *StreamingDetectIntentResponse) XXX_Size() int {
	return xxx_messageInfo_StreamingDetectIntentResponse.Size(m)
}
func (m *StreamingDetectIntentResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingDetectIntentResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingDetectIntentResponse proto.InternalMessageInfo

func (m *StreamingDetectIntentResponse) GetResponseId() string {
	if m != nil {
		return m.ResponseId
	}
	return ""
}

func (m *StreamingDetectIntentResponse) GetRecognitionResult() *StreamingRecognitionResult {
	if m != nil {
		return m.RecognitionResult
	}
	return nil
}

func (m *StreamingDetectIntentResponse) GetQueryResult() *QueryResult {
	if m != nil {
		return m.QueryResult
	}
	return nil
}

func (m *StreamingDetectIntentResponse) GetWebhookStatus() *status.Status {
	if m != nil {
		return m.WebhookStatus
	}
	return nil
}

func (m *StreamingDetectIntentResponse) GetOutputAudio() []byte {
	if m != nil {
		return m.OutputAudio
	}
	return nil
}

func (m *StreamingDetectIntentResponse) GetOutputAudioConfig() *OutputAudioConfig {
	if m != nil {
		return m.OutputAudioConfig
	}
	return nil
}

// Contains a speech recognition result corresponding to a portion of the audio
// that is currently being processed or an indication that this is the end
// of the single requested utterance.
//
// Example:
//
// 1.  transcript: "tube"
//
// 2.  transcript: "to be a"
//
// 3.  transcript: "to be"
//
// 4.  transcript: "to be or not to be"
//     is_final: true
//
// 5.  transcript: " that's"
//
// 6.  transcript: " that is"
//
// 7.  message_type: `END_OF_SINGLE_UTTERANCE`
//
// 8.  transcript: " that is the question"
//     is_final: true
//
// Only two of the responses contain final results (#4 and #8 indicated by
// `is_final: true`). Concatenating these generates the full transcript: "to be
// or not to be that is the question".
//
// In each response we populate:
//
// *  for `TRANSCRIPT`: `transcript` and possibly `is_final`.
//
// *  for `END_OF_SINGLE_UTTERANCE`: only `message_type`.
type StreamingRecognitionResult struct {
	// Type of the result message.
	MessageType StreamingRecognitionResult_MessageType `protobuf:"varint,1,opt,name=message_type,json=messageType,proto3,enum=google.cloud.dialogflow.v2.StreamingRecognitionResult_MessageType" json:"message_type,omitempty"`
	// Transcript text representing the words that the user spoke.
	// Populated if and only if `message_type` = `TRANSCRIPT`.
	Transcript string `protobuf:"bytes,2,opt,name=transcript,proto3" json:"transcript,omitempty"`
	// If `false`, the `StreamingRecognitionResult` represents an
	// interim result that may change. If `true`, the recognizer will not return
	// any further hypotheses about this piece of the audio. May only be populated
	// for `message_type` = `TRANSCRIPT`.
	IsFinal bool `protobuf:"varint,3,opt,name=is_final,json=isFinal,proto3" json:"is_final,omitempty"`
	// The Speech confidence between 0.0 and 1.0 for the current portion of audio.
	// A higher number indicates an estimated greater likelihood that the
	// recognized words are correct. The default of 0.0 is a sentinel value
	// indicating that confidence was not set.
	//
	// This field is typically only provided if `is_final` is true and you should
	// not rely on it being accurate or even set.
	Confidence float32 `protobuf:"fixed32,4,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Word-specific information for the words recognized by Speech in
	// [transcript][google.cloud.dialogflow.v2.StreamingRecognitionResult.transcript]. Populated if and only if `message_type` = `TRANSCRIPT` and
	// [InputAudioConfig.enable_word_info] is set.
	SpeechWordInfo []*SpeechWordInfo `protobuf:"bytes,7,rep,name=speech_word_info,json=speechWordInfo,proto3" json:"speech_word_info,omitempty"`
	// Time offset of the end of this Speech recognition result relative to the
	// beginning of the audio. Only populated for `message_type` = `TRANSCRIPT`.
	SpeechEndOffset      *duration.Duration `protobuf:"bytes,8,opt,name=speech_end_offset,json=speechEndOffset,proto3" json:"speech_end_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *StreamingRecognitionResult) Reset()         { *m = StreamingRecognitionResult{} }
func (m *StreamingRecognitionResult) String() string { return proto.CompactTextString(m) }
func (*StreamingRecognitionResult) ProtoMessage()    {}
func (*StreamingRecognitionResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_2f8892c06d516e44, []int{7}
}

func (m *StreamingRecognitionResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingRecognitionResult.Unmarshal(m, b)
}
func (m *StreamingRecognitionResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingRecognitionResult.Marshal(b, m, deterministic)
}
func (m *StreamingRecognitionResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingRecognitionResult.Merge(m, src)
}
func (m *StreamingRecognitionResult) XXX_Size() int {
	return xxx_messageInfo_StreamingRecognitionResult.Size(m)
}
func (m *StreamingRecognitionResult) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingRecognitionResult.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingRecognitionResult proto.InternalMessageInfo

func (m *StreamingRecognitionResult) GetMessageType() StreamingRecognitionResult_MessageType {
	if m != nil {
		return m.MessageType
	}
	return StreamingRecognitionResult_MESSAGE_TYPE_UNSPECIFIED
}

func (m *StreamingRecognitionResult) GetTranscript() string {
	if m != nil {
		return m.Transcript
	}
	return ""
}

func (m *StreamingRecognitionResult) GetIsFinal() bool {
	if m != nil {
		return m.IsFinal
	}
	return false
}

func (m *StreamingRecognitionResult) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *StreamingRecognitionResult) GetSpeechWordInfo() []*SpeechWordInfo {
	if m != nil {
		return m.SpeechWordInfo
	}
	return nil
}

func (m *StreamingRecognitionResult) GetSpeechEndOffset() *duration.Duration {
	if m != nil {
		return m.SpeechEndOffset
	}
	return nil
}

// Represents the natural language text to be processed.
type TextInput struct {
	// Required. The UTF-8 encoded natural language text to be processed.
	// Text length must not exceed 256 characters.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// Required. The language of this conversational query. See [Language
	// Support](https://cloud.google.com/dialogflow/docs/reference/language)
	// for a list of the currently supported language codes. Note that queries in
	// the same session do not necessarily need to specify the same language.
	LanguageCode         string   `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TextInput) Reset()         { *m = TextInput{} }
func (m *TextInput) String() string { return proto.CompactTextString(m) }
func (*TextInput) ProtoMessage()    {}
func (*TextInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_2f8892c06d516e44, []int{8}
}

func (m *TextInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TextInput.Unmarshal(m, b)
}
func (m *TextInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TextInput.Marshal(b, m, deterministic)
}
func (m *TextInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TextInput.Merge(m, src)
}
func (m *TextInput) XXX_Size() int {
	return xxx_messageInfo_TextInput.Size(m)
}
func (m *TextInput) XXX_DiscardUnknown() {
	xxx_messageInfo_TextInput.DiscardUnknown(m)
}

var xxx_messageInfo_TextInput proto.InternalMessageInfo

func (m *TextInput) GetText() string {
	if m != nil {
		return m.Text
	}
	return ""
}

func (m *TextInput) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// Events allow for matching intents by event name instead of the natural
// language input. For instance, input `<event: { name: "welcome_event",
// parameters: { name: "Sam" } }>` can trigger a personalized welcome response.
// The parameter `name` may be used by the agent in the response:
// `"Hello #welcome_event.name! What can I do for you today?"`.
type EventInput struct {
	// Required. The unique identifier of the event.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The collection of parameters associated with the event.
	Parameters *_struct.Struct `protobuf:"bytes,2,opt,name=parameters,proto3" json:"parameters,omitempty"`
	// Required. The language of this query. See [Language
	// Support](https://cloud.google.com/dialogflow/docs/reference/language)
	// for a list of the currently supported language codes. Note that queries in
	// the same session do not necessarily need to specify the same language.
	LanguageCode         string   `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EventInput) Reset()         { *m = EventInput{} }
func (m *EventInput) String() string { return proto.CompactTextString(m) }
func (*EventInput) ProtoMessage()    {}
func (*EventInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_2f8892c06d516e44, []int{9}
}

func (m *EventInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventInput.Unmarshal(m, b)
}
func (m *EventInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventInput.Marshal(b, m, deterministic)
}
func (m *EventInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventInput.Merge(m, src)
}
func (m *EventInput) XXX_Size() int {
	return xxx_messageInfo_EventInput.Size(m)
}
func (m *EventInput) XXX_DiscardUnknown() {
	xxx_messageInfo_EventInput.DiscardUnknown(m)
}

var xxx_messageInfo_EventInput proto.InternalMessageInfo

func (m *EventInput) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EventInput) GetParameters() *_struct.Struct {
	if m != nil {
		return m.Parameters
	}
	return nil
}

func (m *EventInput) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// Configures the types of sentiment analysis to perform.
type SentimentAnalysisRequestConfig struct {
	// Instructs the service to perform sentiment analysis on
	// `query_text`. If not provided, sentiment analysis is not performed on
	// `query_text`.
	AnalyzeQueryTextSentiment bool     `protobuf:"varint,1,opt,name=analyze_query_text_sentiment,json=analyzeQueryTextSentiment,proto3" json:"analyze_query_text_sentiment,omitempty"`
	XXX_NoUnkeyedLiteral      struct{} `json:"-"`
	XXX_unrecognized          []byte   `json:"-"`
	XXX_sizecache             int32    `json:"-"`
}

func (m *SentimentAnalysisRequestConfig) Reset()         { *m = SentimentAnalysisRequestConfig{} }
func (m *SentimentAnalysisRequestConfig) String() string { return proto.CompactTextString(m) }
func (*SentimentAnalysisRequestConfig) ProtoMessage()    {}
func (*SentimentAnalysisRequestConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_2f8892c06d516e44, []int{10}
}

func (m *SentimentAnalysisRequestConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SentimentAnalysisRequestConfig.Unmarshal(m, b)
}
func (m *SentimentAnalysisRequestConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SentimentAnalysisRequestConfig.Marshal(b, m, deterministic)
}
func (m *SentimentAnalysisRequestConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SentimentAnalysisRequestConfig.Merge(m, src)
}
func (m *SentimentAnalysisRequestConfig) XXX_Size() int {
	return xxx_messageInfo_SentimentAnalysisRequestConfig.Size(m)
}
func (m *SentimentAnalysisRequestConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_SentimentAnalysisRequestConfig.DiscardUnknown(m)
}

var xxx_messageInfo_SentimentAnalysisRequestConfig proto.InternalMessageInfo

func (m *SentimentAnalysisRequestConfig) GetAnalyzeQueryTextSentiment() bool {
	if m != nil {
		return m.AnalyzeQueryTextSentiment
	}
	return false
}

// The result of sentiment analysis as configured by
// `sentiment_analysis_request_config`.
type SentimentAnalysisResult struct {
	// The sentiment analysis result for `query_text`.
	QueryTextSentiment   *Sentiment `protobuf:"bytes,1,opt,name=query_text_sentiment,json=queryTextSentiment,proto3" json:"query_text_sentiment,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *SentimentAnalysisResult) Reset()         { *m = SentimentAnalysisResult{} }
func (m *SentimentAnalysisResult) String() string { return proto.CompactTextString(m) }
func (*SentimentAnalysisResult) ProtoMessage()    {}
func (*SentimentAnalysisResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_2f8892c06d516e44, []int{11}
}

func (m *SentimentAnalysisResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SentimentAnalysisResult.Unmarshal(m, b)
}
func (m *SentimentAnalysisResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SentimentAnalysisResult.Marshal(b, m, deterministic)
}
func (m *SentimentAnalysisResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SentimentAnalysisResult.Merge(m, src)
}
func (m *SentimentAnalysisResult) XXX_Size() int {
	return xxx_messageInfo_SentimentAnalysisResult.Size(m)
}
func (m *SentimentAnalysisResult) XXX_DiscardUnknown() {
	xxx_messageInfo_SentimentAnalysisResult.DiscardUnknown(m)
}

var xxx_messageInfo_SentimentAnalysisResult proto.InternalMessageInfo

func (m *SentimentAnalysisResult) GetQueryTextSentiment() *Sentiment {
	if m != nil {
		return m.QueryTextSentiment
	}
	return nil
}

// The sentiment, such as positive/negative feeling or association, for a unit
// of analysis, such as the query text.
type Sentiment struct {
	// Sentiment score between -1.0 (negative sentiment) and 1.0 (positive
	// sentiment).
	Score float32 `protobuf:"fixed32,1,opt,name=score,proto3" json:"score,omitempty"`
	// A non-negative number in the [0, +inf) range, which represents the absolute
	// magnitude of sentiment, regardless of score (positive or negative).
	Magnitude            float32  `protobuf:"fixed32,2,opt,name=magnitude,proto3" json:"magnitude,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Sentiment) Reset()         { *m = Sentiment{} }
func (m *Sentiment) String() string { return proto.CompactTextString(m) }
func (*Sentiment) ProtoMessage()    {}
func (*Sentiment) Descriptor() ([]byte, []int) {
	return fileDescriptor_2f8892c06d516e44, []int{12}
}

func (m *Sentiment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Sentiment.Unmarshal(m, b)
}
func (m *Sentiment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Sentiment.Marshal(b, m, deterministic)
}
func (m *Sentiment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Sentiment.Merge(m, src)
}
func (m *Sentiment) XXX_Size() int {
	return xxx_messageInfo_Sentiment.Size(m)
}
func (m *Sentiment) XXX_DiscardUnknown() {
	xxx_messageInfo_Sentiment.DiscardUnknown(m)
}

var xxx_messageInfo_Sentiment proto.InternalMessageInfo

func (m *Sentiment) GetScore() float32 {
	if m != nil {
		return m.Score
	}
	return 0
}

func (m *Sentiment) GetMagnitude() float32 {
	if m != nil {
		return m.Magnitude
	}
	return 0
}

func init() {
	proto.RegisterEnum("google.cloud.dialogflow.v2.StreamingRecognitionResult_MessageType", StreamingRecognitionResult_MessageType_name, StreamingRecognitionResult_MessageType_value)
	proto.RegisterType((*DetectIntentRequest)(nil), "google.cloud.dialogflow.v2.DetectIntentRequest")
	proto.RegisterType((*DetectIntentResponse)(nil), "google.cloud.dialogflow.v2.DetectIntentResponse")
	proto.RegisterType((*QueryParameters)(nil), "google.cloud.dialogflow.v2.QueryParameters")
	proto.RegisterType((*QueryInput)(nil), "google.cloud.dialogflow.v2.QueryInput")
	proto.RegisterType((*QueryResult)(nil), "google.cloud.dialogflow.v2.QueryResult")
	proto.RegisterType((*StreamingDetectIntentRequest)(nil), "google.cloud.dialogflow.v2.StreamingDetectIntentRequest")
	proto.RegisterType((*StreamingDetectIntentResponse)(nil), "google.cloud.dialogflow.v2.StreamingDetectIntentResponse")
	proto.RegisterType((*StreamingRecognitionResult)(nil), "google.cloud.dialogflow.v2.StreamingRecognitionResult")
	proto.RegisterType((*TextInput)(nil), "google.cloud.dialogflow.v2.TextInput")
	proto.RegisterType((*EventInput)(nil), "google.cloud.dialogflow.v2.EventInput")
	proto.RegisterType((*SentimentAnalysisRequestConfig)(nil), "google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig")
	proto.RegisterType((*SentimentAnalysisResult)(nil), "google.cloud.dialogflow.v2.SentimentAnalysisResult")
	proto.RegisterType((*Sentiment)(nil), "google.cloud.dialogflow.v2.Sentiment")
}

func init() {
	proto.RegisterFile("google/cloud/dialogflow/v2/session.proto", fileDescriptor_2f8892c06d516e44)
}

var fileDescriptor_2f8892c06d516e44 = []byte{
	// 1846 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x58, 0x4f, 0x6f, 0x1b, 0xc7,
	0x15, 0xf7, 0x92, 0x96, 0x44, 0x3d, 0x32, 0x92, 0x3c, 0x52, 0x2a, 0xea, 0x8f, 0x15, 0x9b, 0x46,
	0x1a, 0xc5, 0xb1, 0xb9, 0x29, 0x53, 0xb8, 0x8d, 0x8c, 0xc4, 0xa6, 0x28, 0xca, 0x61, 0x21, 0xcb,
	0xf2, 0x52, 0xae, 0x9b, 0x00, 0xc1, 0x62, 0xbc, 0x3b, 0x5c, 0x6d, 0xbd, 0x9c, 0x59, 0xed, 0xcc,
	0x4a, 0x56, 0x0c, 0x5f, 0x0a, 0x14, 0xe8, 0x39, 0x45, 0xbf, 0x40, 0x8f, 0x3d, 0xb5, 0xdf, 0xa0,
	0xe7, 0x00, 0xbd, 0xb4, 0xe8, 0xa5, 0x97, 0xe6, 0xd0, 0xf6, 0x90, 0x4f, 0x50, 0xf4, 0x54, 0xec,
	0xcc, 0x2c, 0xb9, 0xa2, 0x48, 0x4a, 0x35, 0x82, 0x02, 0xb9, 0x71, 0xde, 0xfc, 0xde, 0x9b, 0x37,
	0xef, 0xbd, 0xf9, 0xbd, 0xc7, 0x85, 0x75, 0x8f, 0x31, 0x2f, 0x20, 0xa6, 0x13, 0xb0, 0xd8, 0x35,
	0x5d, 0x1f, 0x07, 0xcc, 0xeb, 0x04, 0xec, 0xd8, 0x3c, 0xaa, 0x99, 0x9c, 0x70, 0xee, 0x33, 0x5a,
	0x0d, 0x23, 0x26, 0x18, 0x5a, 0x56, 0xc8, 0xaa, 0x44, 0x56, 0xfb, 0xc8, 0xea, 0x51, 0x6d, 0x79,
	0x55, 0x5b, 0xc1, 0xa1, 0x6f, 0x62, 0x4a, 0x99, 0xc0, 0xc2, 0x67, 0x94, 0x2b, 0xcd, 0xe5, 0xc5,
	0xcc, 0xae, 0x13, 0xf8, 0x84, 0x0a, 0xbd, 0xf1, 0x56, 0x66, 0xa3, 0xe3, 0x93, 0xc0, 0xb5, 0x9f,
	0x91, 0x03, 0x7c, 0xe4, 0xb3, 0x48, 0x03, 0x96, 0x32, 0x80, 0x88, 0x70, 0x16, 0x47, 0x0e, 0xd1,
	0x5b, 0xb7, 0xc7, 0x38, 0x8e, 0x63, 0xd7, 0x67, 0xb6, 0xc3, 0x68, 0xc7, 0xf7, 0x34, 0x7c, 0xdc,
	0x3d, 0x1d, 0x46, 0x05, 0x79, 0x91, 0x3a, 0xf5, 0xce, 0x18, 0xa4, 0x4f, 0x45, 0xdf, 0xfb, 0x1f,
	0x9e, 0x1f, 0x3a, 0x9b, 0x50, 0xe1, 0x8b, 0x13, 0x5b, 0x9c, 0x84, 0xa9, 0xdf, 0x6b, 0x5a, 0x4b,
	0xae, 0x9e, 0xc5, 0x1d, 0xd3, 0x8d, 0x23, 0x19, 0x2d, 0xbd, 0x7f, 0x6d, 0x70, 0x5f, 0x05, 0xa6,
	0x8b, 0xf9, 0x73, 0x8d, 0x58, 0x1d, 0x44, 0x70, 0x11, 0xc5, 0x8e, 0x18, 0x08, 0x76, 0x14, 0x3a,
	0x26, 0x17, 0x58, 0xc4, 0x69, 0x16, 0xca, 0x7a, 0x23, 0xf1, 0xc5, 0x0c, 0xb0, 0x08, 0xa8, 0x8e,
	0x4d, 0xe5, 0x4f, 0x79, 0x98, 0xdf, 0x22, 0x82, 0x38, 0xa2, 0x25, 0xef, 0x67, 0x91, 0xc3, 0x98,
	0x70, 0x81, 0x1a, 0x30, 0xa5, 0xef, 0x51, 0x36, 0xae, 0x19, 0xeb, 0xd3, 0x9b, 0xef, 0x7e, 0x5d,
	0xcf, 0xfd, 0xa7, 0x7e, 0x03, 0xae, 0x67, 0xb2, 0xaf, 0xac, 0xe2, 0xd0, 0xe7, 0x55, 0x87, 0x75,
	0xcd, 0xb6, 0x52, 0xb0, 0x52, 0x4d, 0xb4, 0x0b, 0xa5, 0xc3, 0x98, 0x44, 0x27, 0x76, 0x88, 0x23,
	0xdc, 0xe5, 0xe5, 0xdc, 0x35, 0x63, 0xbd, 0x58, 0x7b, 0xaf, 0x3a, 0xba, 0x9a, 0xaa, 0x8f, 0x13,
	0xfc, 0x5e, 0x02, 0x27, 0x82, 0x44, 0xdc, 0x2a, 0x1e, 0xf6, 0x04, 0x1c, 0xed, 0x80, 0x5a, 0xda,
	0x3e, 0x0d, 0x63, 0x51, 0xce, 0x4b, 0x73, 0xdf, 0x3f, 0xd7, 0x5c, 0x2b, 0x41, 0x6f, 0xe6, 0xbf,
	0xae, 0xe7, 0x2c, 0x38, 0xec, 0x09, 0xd0, 0xe7, 0x30, 0xcf, 0x62, 0x11, 0xc6, 0xc2, 0xce, 0xd6,
	0x4c, 0xf9, 0xb2, 0xb4, 0x7a, 0x7b, 0x9c, 0xd5, 0x47, 0x52, 0xad, 0x9e, 0x68, 0x35, 0xa4, 0x92,
	0x75, 0x85, 0x0d, 0x8a, 0x50, 0x1b, 0xca, 0x43, 0xcc, 0xcb, 0x64, 0x96, 0xa7, 0xe4, 0x19, 0xcb,
	0xe9, 0x19, 0x69, 0x36, 0xab, 0xdb, 0x49, 0xbe, 0x1f, 0x62, 0xfe, 0xdc, 0x7a, 0xf3, 0x8c, 0xc1,
	0x44, 0x8c, 0xde, 0x82, 0xa2, 0xbc, 0xbb, 0xb2, 0x59, 0x9e, 0xb8, 0x66, 0xac, 0x97, 0x2c, 0x90,
	0x22, 0x09, 0xad, 0xfc, 0x31, 0x07, 0x0b, 0xa7, 0xf3, 0xc9, 0x43, 0x46, 0x39, 0x49, 0x34, 0x23,
	0xfd, 0xdb, 0xf6, 0x5d, 0x95, 0x54, 0x0b, 0x52, 0x51, 0xcb, 0x45, 0x3f, 0x49, 0x93, 0x15, 0x11,
	0x1e, 0x07, 0x42, 0x27, 0xeb, 0x9d, 0x73, 0xa3, 0x6b, 0x49, 0xb8, 0x4e, 0x94, 0x5a, 0xa0, 0x0f,
	0x61, 0xe6, 0x98, 0x3c, 0x3b, 0x60, 0xec, 0xb9, 0xad, 0xea, 0x50, 0xe7, 0x0a, 0xa5, 0xd6, 0xa2,
	0xd0, 0xa9, 0xb6, 0xe5, 0x8e, 0xf5, 0x86, 0x46, 0xaa, 0x25, 0xba, 0x0e, 0xa5, 0x6c, 0xd8, 0x64,
	0x3a, 0x4a, 0x56, 0x31, 0x13, 0x8e, 0x51, 0x89, 0x9b, 0xfc, 0x76, 0x12, 0x57, 0xf9, 0x26, 0x0f,
	0xb3, 0x03, 0x65, 0x88, 0x56, 0x60, 0x5a, 0xf8, 0x5d, 0x62, 0x7f, 0xc1, 0x28, 0xd1, 0xb1, 0x2b,
	0x24, 0x82, 0xcf, 0x18, 0x25, 0xe8, 0x0e, 0x94, 0x3c, 0xc2, 0xec, 0x80, 0x39, 0xf2, 0x31, 0xeb,
	0xc8, 0xcd, 0xa7, 0x8e, 0x48, 0x02, 0xd8, 0xc1, 0x62, 0x87, 0x7a, 0x56, 0xd1, 0x23, 0x6c, 0x47,
	0xe3, 0xd0, 0x3d, 0x28, 0x68, 0xfa, 0x49, 0xe2, 0x93, 0x5f, 0x2f, 0xd6, 0x6e, 0x8c, 0x73, 0xbe,
	0xa1, 0xb0, 0x56, 0x4f, 0x09, 0xbd, 0x0d, 0x33, 0x11, 0xe1, 0x44, 0xd8, 0x3d, 0x33, 0x49, 0xb4,
	0x0a, 0xd6, 0x1b, 0x52, 0xda, 0x48, 0x61, 0x36, 0x2c, 0x0c, 0xe1, 0x24, 0x5e, 0x9e, 0x90, 0x67,
	0x8e, 0x0d, 0x98, 0x7e, 0xd2, 0x4d, 0xa9, 0xb6, 0x7f, 0x12, 0x12, 0x0b, 0xf1, 0x41, 0x11, 0x47,
	0x3f, 0x80, 0xa9, 0x10, 0x9f, 0x04, 0x0c, 0xbb, 0x3a, 0x09, 0x8b, 0x67, 0x2a, 0xbb, 0x2d, 0x79,
	0xca, 0x4a, 0x71, 0xe8, 0x97, 0x06, 0x5c, 0xe7, 0x89, 0x37, 0x5d, 0x42, 0x85, 0x8d, 0x29, 0x0e,
	0x4e, 0xb8, 0xcf, 0xed, 0x48, 0xd1, 0x4f, 0x9a, 0x52, 0x90, 0xd6, 0x36, 0xc6, 0x7b, 0xa8, 0x8d,
	0xd4, 0xb5, 0x0d, 0xcd, 0x60, 0x3a, 0xbf, 0x6b, 0x7c, 0xec, 0x7e, 0xe5, 0x9f, 0x06, 0x40, 0x9f,
	0x24, 0xd0, 0x63, 0x28, 0x9d, 0xaa, 0x29, 0x43, 0x3a, 0x70, 0x6b, 0x9c, 0x03, 0x2d, 0x7a, 0xba,
	0x7e, 0x3e, 0xb9, 0x64, 0x15, 0x71, 0x86, 0x07, 0xee, 0xc2, 0xe5, 0x24, 0x0d, 0xba, 0x2a, 0xde,
	0x1e, 0x67, 0x6a, 0x9f, 0xbc, 0x10, 0xd2, 0xdc, 0x27, 0x97, 0x2c, 0xa9, 0x84, 0x3e, 0x86, 0x09,
	0x72, 0x44, 0xe8, 0x85, 0xb8, 0xae, 0x99, 0x00, 0x53, 0x75, 0xa5, 0xb6, 0x39, 0x05, 0x13, 0x92,
	0x1c, 0x2a, 0xbf, 0x99, 0x82, 0x62, 0xe6, 0xb9, 0xa2, 0xab, 0xa0, 0xa8, 0xd0, 0x96, 0xbe, 0xa9,
	0x8a, 0x9e, 0x96, 0x92, 0xc4, 0x09, 0x74, 0x03, 0xde, 0x08, 0x30, 0xf5, 0x62, 0xec, 0x11, 0xdb,
	0x61, 0x2e, 0x29, 0xcf, 0x4a, 0x44, 0x29, 0x15, 0x36, 0x98, 0x4b, 0xd0, 0x26, 0x5c, 0xe5, 0x21,
	0x21, 0xce, 0x81, 0x1d, 0x11, 0x87, 0x79, 0xd4, 0x4f, 0xaa, 0x5a, 0x45, 0xce, 0x25, 0xd4, 0x21,
	0xf2, 0xca, 0x39, 0x6b, 0x45, 0x81, 0xac, 0x3e, 0xa6, 0xd1, 0x83, 0xa0, 0xef, 0xc1, 0x24, 0x76,
	0xe4, 0xab, 0xc9, 0xcb, 0x13, 0xf4, 0x0a, 0xfd, 0x08, 0x20, 0xec, 0x3d, 0x3f, 0xcd, 0xc9, 0x23,
	0xab, 0x2a, 0x03, 0x45, 0x1f, 0xc1, 0x0a, 0x0e, 0x02, 0x59, 0x48, 0x7e, 0x44, 0x5c, 0xdd, 0x7a,
	0xec, 0x30, 0x79, 0x12, 0x54, 0x48, 0xc6, 0x2c, 0x58, 0x65, 0x1c, 0x04, 0x96, 0x46, 0xa8, 0xde,
	0xb2, 0xa7, 0xf6, 0xd1, 0xbb, 0x30, 0xd7, 0x89, 0x83, 0x8e, 0x1f, 0x04, 0xb2, 0x30, 0x65, 0x74,
	0x26, 0xa5, 0x67, 0xb3, 0x19, 0xb9, 0x8c, 0xd1, 0xe7, 0xb0, 0x90, 0x85, 0x76, 0x09, 0xe7, 0xd8,
	0x23, 0xbc, 0x3c, 0x25, 0x9f, 0xd5, 0xcd, 0xf1, 0x35, 0x23, 0x67, 0x89, 0x87, 0x4a, 0xc5, 0x9a,
	0xcf, 0xd8, 0xd1, 0x32, 0xf9, 0xb8, 0x7b, 0x1c, 0x2a, 0x87, 0x9f, 0x72, 0x41, 0xfa, 0xd1, 0xe3,
	0x4b, 0x29, 0x44, 0xf7, 0x61, 0x36, 0x85, 0xa5, 0x6f, 0x70, 0x7a, 0x7c, 0xb4, 0x52, 0xb3, 0x7b,
	0xfa, 0x29, 0xee, 0xc0, 0xac, 0xa6, 0xd3, 0x1e, 0x8d, 0xc0, 0xc5, 0xd9, 0x68, 0x46, 0xe9, 0xf6,
	0xc8, 0x66, 0x03, 0x26, 0xd5, 0xa4, 0x54, 0x2e, 0x4a, 0x37, 0x2a, 0xe7, 0xc7, 0xc1, 0xd2, 0x1a,
	0xe8, 0x63, 0x58, 0x51, 0xbf, 0x6c, 0x57, 0xb6, 0xb0, 0x81, 0x72, 0x2a, 0xc9, 0x72, 0x5a, 0x52,
	0x90, 0xad, 0x14, 0x91, 0x29, 0xa6, 0xfb, 0x30, 0xeb, 0xfa, 0xd8, 0xa3, 0x8c, 0x0b, 0xdf, 0xb1,
	0x7d, 0xda, 0x61, 0xe5, 0x99, 0x73, 0x62, 0xd1, 0xc7, 0xb7, 0x68, 0x87, 0x21, 0x06, 0x4b, 0x43,
	0x59, 0x49, 0x76, 0xc4, 0x2b, 0xd2, 0xd6, 0x07, 0xff, 0x23, 0x1b, 0xc9, 0xee, 0xb8, 0xc8, 0x87,
	0x6f, 0x54, 0xfe, 0x9e, 0x87, 0xd5, 0xb6, 0x88, 0x08, 0xee, 0xfa, 0xd4, 0x1b, 0x36, 0x88, 0x5d,
	0x1d, 0x1c, 0xc4, 0xe4, 0x1c, 0xf3, 0x1d, 0x19, 0xb1, 0x6e, 0xc3, 0x1c, 0xf7, 0xa9, 0x17, 0x10,
	0x3b, 0x16, 0x82, 0x44, 0x38, 0xc9, 0xa2, 0x6c, 0x51, 0x9b, 0xb9, 0xb2, 0x61, 0xcd, 0xaa, 0xbd,
	0x27, 0xe9, 0xd6, 0xa8, 0xc6, 0x3e, 0xf1, 0x1d, 0x9a, 0xc8, 0x26, 0xcf, 0x4c, 0x64, 0xbf, 0xcf,
	0xc3, 0xd5, 0x11, 0x19, 0xbe, 0xe8, 0x68, 0x46, 0x00, 0x65, 0x19, 0xf6, 0xd4, 0x80, 0x76, 0x67,
	0x6c, 0x39, 0xa6, 0xe7, 0x66, 0xc8, 0x57, 0x57, 0xe4, 0x95, 0x68, 0x50, 0x74, 0x66, 0x02, 0xcc,
	0x7f, 0xab, 0x13, 0xe0, 0xe5, 0xd7, 0x9d, 0x00, 0x27, 0xfe, 0xef, 0x13, 0xe0, 0x5f, 0xf3, 0xb0,
	0x3c, 0x3a, 0x74, 0x88, 0x40, 0x49, 0x93, 0xbd, 0x1c, 0xa4, 0x64, 0xc2, 0x66, 0x6a, 0x9b, 0xaf,
	0x97, 0x88, 0xb4, 0x09, 0xc8, 0xe1, 0xaa, 0xd8, 0xed, 0x2f, 0xd0, 0x1a, 0x80, 0x88, 0x30, 0xe5,
	0x4e, 0xe4, 0x87, 0x2a, 0xdb, 0xd3, 0x56, 0x46, 0x82, 0x96, 0xa0, 0xe0, 0x73, 0xbb, 0xe3, 0x53,
	0x1c, 0xc8, 0x54, 0x15, 0xac, 0x29, 0x9f, 0x6f, 0x27, 0xcb, 0x44, 0x35, 0xc3, 0x9b, 0x97, 0x25,
	0x6f, 0x66, 0x24, 0x68, 0x1f, 0xe6, 0x74, 0xe7, 0x3e, 0x66, 0x91, 0xab, 0x98, 0xf2, 0x02, 0x6d,
	0xab, 0x2d, 0x75, 0x9e, 0xb2, 0xc8, 0x4d, 0xc8, 0xd2, 0x9a, 0xe1, 0xa7, 0xd6, 0xa8, 0x09, 0x57,
	0xb4, 0x55, 0x42, 0x5d, 0x9b, 0x75, 0x3a, 0x9c, 0x08, 0xd9, 0xb4, 0x8a, 0xb5, 0xa5, 0x33, 0x0f,
	0x6b, 0x4b, 0xff, 0xf5, 0xb5, 0x66, 0x95, 0x4e, 0x93, 0xba, 0x8f, 0xa4, 0x46, 0xe5, 0x67, 0x50,
	0xcc, 0xc4, 0x04, 0xad, 0x42, 0xf9, 0x61, 0xb3, 0xdd, 0xae, 0x3f, 0x68, 0xda, 0xfb, 0x9f, 0xee,
	0x35, 0xed, 0x27, 0xbb, 0xed, 0xbd, 0x66, 0xa3, 0xb5, 0xdd, 0x6a, 0x6e, 0xcd, 0x5d, 0x42, 0x33,
	0x00, 0xfb, 0x56, 0x7d, 0xb7, 0xdd, 0xb0, 0x5a, 0x7b, 0xfb, 0x73, 0x06, 0x5a, 0x81, 0xc5, 0xe6,
	0xee, 0x96, 0xfd, 0x68, 0xdb, 0x6e, 0xb7, 0x76, 0x1f, 0xec, 0x34, 0xed, 0x27, 0xfb, 0xfb, 0x4d,
	0xab, 0xbe, 0xdb, 0x68, 0xce, 0xe5, 0x2a, 0xbb, 0x30, 0xdd, 0x1b, 0xb1, 0xd0, 0xa2, 0x9e, 0xcb,
	0x32, 0xac, 0xaa, 0x66, 0xae, 0xf5, 0xc1, 0xd9, 0x27, 0xd7, 0x47, 0x9c, 0x1a, 0x80, 0x2a, 0xbf,
	0x32, 0x00, 0xfa, 0x53, 0x57, 0x62, 0x91, 0xe2, 0x2e, 0x39, 0x65, 0x31, 0x11, 0x0c, 0x0c, 0x33,
	0xb9, 0x8b, 0x0f, 0x33, 0x67, 0x5c, 0xc9, 0x8f, 0x72, 0x05, 0xc3, 0xda, 0xf8, 0x49, 0x18, 0xdd,
	0x83, 0x55, 0xd9, 0xd0, 0xbe, 0x20, 0x76, 0x7f, 0xf2, 0xb3, 0x7b, 0x7d, 0x49, 0x7a, 0x5d, 0xb0,
	0x96, 0x34, 0xe6, 0x71, 0x3a, 0x0a, 0xf6, 0xac, 0x56, 0x22, 0x58, 0x1c, 0xd1, 0xde, 0xd0, 0x53,
	0x58, 0x18, 0x69, 0xf3, 0x9c, 0x99, 0xb7, 0x67, 0xd2, 0x42, 0x87, 0x67, 0xcf, 0xbc, 0x07, 0xd3,
	0xbd, 0x05, 0x5a, 0x80, 0x09, 0xee, 0xb0, 0x48, 0x05, 0x38, 0x67, 0xa9, 0x05, 0x5a, 0x85, 0xe9,
	0x2e, 0x4e, 0x9e, 0x54, 0xec, 0xa6, 0x13, 0x67, 0x5f, 0x50, 0xfb, 0x57, 0x1e, 0x0a, 0xfa, 0x4f,
	0x0c, 0x47, 0x5f, 0x19, 0x50, 0xca, 0x32, 0x30, 0x32, 0xc7, 0x79, 0x36, 0xa4, 0x1b, 0x2f, 0xbf,
	0x7f, 0x71, 0x05, 0xc5, 0xde, 0x95, 0xa7, 0x7f, 0xab, 0xcf, 0xeb, 0x66, 0x7d, 0x2b, 0xd3, 0x59,
	0x7f, 0xf1, 0x97, 0x7f, 0xfc, 0x3a, 0x77, 0xb7, 0x72, 0xc7, 0x3c, 0xaa, 0x99, 0x2f, 0xf5, 0xfe,
	0x47, 0x61, 0xc4, 0x7e, 0x4e, 0x1c, 0xc1, 0xcd, 0x9b, 0x26, 0xf6, 0x08, 0x15, 0xe9, 0xa7, 0x24,
	0x6e, 0xde, 0x7c, 0xb5, 0xe1, 0x66, 0xac, 0x6f, 0x18, 0x37, 0xd1, 0x97, 0x06, 0xbc, 0x39, 0xb4,
	0xaf, 0xa0, 0x1f, 0x5f, 0x88, 0x89, 0x86, 0x5d, 0xef, 0xc3, 0xd7, 0xd0, 0xd4, 0xf7, 0xbc, 0xb4,
	0x6e, 0xbc, 0x6f, 0x2c, 0xbf, 0xf8, 0xaa, 0xbe, 0x34, 0xf2, 0x03, 0xd1, 0x9f, 0xeb, 0x9f, 0x1e,
	0x08, 0x11, 0xf2, 0x0d, 0xd3, 0x3c, 0x3e, 0x3e, 0xf3, 0xf5, 0x08, 0xc7, 0xe2, 0x40, 0x7d, 0x4f,
	0xbb, 0x1d, 0x06, 0x58, 0x74, 0x58, 0xd4, 0xbd, 0x75, 0x1e, 0xbc, 0x7f, 0xd4, 0xe6, 0x1f, 0x72,
	0xdf, 0xd4, 0xbf, 0x34, 0x2e, 0xf0, 0x79, 0x0a, 0xdd, 0xef, 0x85, 0xf9, 0xa5, 0xfe, 0xf5, 0xca,
	0x4c, 0xff, 0xbb, 0x73, 0xf3, 0x65, 0xfa, 0xf3, 0xd5, 0x60, 0x0e, 0xd2, 0x34, 0xbd, 0x42, 0xef,
	0x0d, 0xb1, 0x30, 0x0a, 0x0c, 0x6b, 0x0e, 0xeb, 0x8e, 0x09, 0xeb, 0x66, 0x49, 0xfb, 0xb5, 0x97,
	0xf0, 0xc0, 0x9e, 0xf1, 0xd9, 0x96, 0xc6, 0x7a, 0x2c, 0x79, 0xe0, 0x55, 0x16, 0x79, 0xa6, 0x47,
	0xa8, 0x64, 0x09, 0xb3, 0x7f, 0xa3, 0x61, 0x5f, 0x1e, 0xef, 0xf6, 0x57, 0xff, 0x36, 0x8c, 0xdf,
	0xe6, 0x72, 0x5b, 0xdb, 0xbf, 0xcb, 0x2d, 0x3f, 0x50, 0xe6, 0x1a, 0xf2, 0xe8, 0xad, 0xfe, 0xd1,
	0x3f, 0xad, 0x3d, 0x9b, 0x94, 0x56, 0x3f, 0xf8, 0x6f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x6b, 0xf3,
	0xf3, 0xe4, 0x09, 0x16, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SessionsClient is the client API for Sessions service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SessionsClient interface {
	// Processes a natural language query and returns structured, actionable data
	// as a result. This method is not idempotent, because it may cause contexts
	// and session entity types to be updated, which in turn might affect
	// results of future queries.
	DetectIntent(ctx context.Context, in *DetectIntentRequest, opts ...grpc.CallOption) (*DetectIntentResponse, error)
	// Processes a natural language query in audio format in a streaming fashion
	// and returns structured, actionable data as a result. This method is only
	// available via the gRPC API (not REST).
	StreamingDetectIntent(ctx context.Context, opts ...grpc.CallOption) (Sessions_StreamingDetectIntentClient, error)
}

type sessionsClient struct {
	cc grpc.ClientConnInterface
}

func NewSessionsClient(cc grpc.ClientConnInterface) SessionsClient {
	return &sessionsClient{cc}
}

func (c *sessionsClient) DetectIntent(ctx context.Context, in *DetectIntentRequest, opts ...grpc.CallOption) (*DetectIntentResponse, error) {
	out := new(DetectIntentResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Sessions/DetectIntent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sessionsClient) StreamingDetectIntent(ctx context.Context, opts ...grpc.CallOption) (Sessions_StreamingDetectIntentClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Sessions_serviceDesc.Streams[0], "/google.cloud.dialogflow.v2.Sessions/StreamingDetectIntent", opts...)
	if err != nil {
		return nil, err
	}
	x := &sessionsStreamingDetectIntentClient{stream}
	return x, nil
}

type Sessions_StreamingDetectIntentClient interface {
	Send(*StreamingDetectIntentRequest) error
	Recv() (*StreamingDetectIntentResponse, error)
	grpc.ClientStream
}

type sessionsStreamingDetectIntentClient struct {
	grpc.ClientStream
}

func (x *sessionsStreamingDetectIntentClient) Send(m *StreamingDetectIntentRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *sessionsStreamingDetectIntentClient) Recv() (*StreamingDetectIntentResponse, error) {
	m := new(StreamingDetectIntentResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// SessionsServer is the server API for Sessions service.
type SessionsServer interface {
	// Processes a natural language query and returns structured, actionable data
	// as a result. This method is not idempotent, because it may cause contexts
	// and session entity types to be updated, which in turn might affect
	// results of future queries.
	DetectIntent(context.Context, *DetectIntentRequest) (*DetectIntentResponse, error)
	// Processes a natural language query in audio format in a streaming fashion
	// and returns structured, actionable data as a result. This method is only
	// available via the gRPC API (not REST).
	StreamingDetectIntent(Sessions_StreamingDetectIntentServer) error
}

// UnimplementedSessionsServer can be embedded to have forward compatible implementations.
type UnimplementedSessionsServer struct {
}

func (*UnimplementedSessionsServer) DetectIntent(ctx context.Context, req *DetectIntentRequest) (*DetectIntentResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DetectIntent not implemented")
}
func (*UnimplementedSessionsServer) StreamingDetectIntent(srv Sessions_StreamingDetectIntentServer) error {
	return status1.Errorf(codes.Unimplemented, "method StreamingDetectIntent not implemented")
}

func RegisterSessionsServer(s *grpc.Server, srv SessionsServer) {
	s.RegisterService(&_Sessions_serviceDesc, srv)
}

func _Sessions_DetectIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DetectIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionsServer).DetectIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Sessions/DetectIntent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionsServer).DetectIntent(ctx, req.(*DetectIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Sessions_StreamingDetectIntent_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SessionsServer).StreamingDetectIntent(&sessionsStreamingDetectIntentServer{stream})
}

type Sessions_StreamingDetectIntentServer interface {
	Send(*StreamingDetectIntentResponse) error
	Recv() (*StreamingDetectIntentRequest, error)
	grpc.ServerStream
}

type sessionsStreamingDetectIntentServer struct {
	grpc.ServerStream
}

func (x *sessionsStreamingDetectIntentServer) Send(m *StreamingDetectIntentResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *sessionsStreamingDetectIntentServer) Recv() (*StreamingDetectIntentRequest, error) {
	m := new(StreamingDetectIntentRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _Sessions_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2.Sessions",
	HandlerType: (*SessionsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "DetectIntent",
			Handler:    _Sessions_DetectIntent_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamingDetectIntent",
			Handler:       _Sessions_StreamingDetectIntent_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/dialogflow/v2/session.proto",
}
