// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kinesisanalytics

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DiscoverInputSchemaInput struct {
	_ struct{} `type:"structure"`

	// The InputProcessingConfiguration (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html)
	// to use to preprocess the records before discovering the schema of the records.
	InputProcessingConfiguration *InputProcessingConfiguration `type:"structure"`

	// Point at which you want Amazon Kinesis Analytics to start reading records
	// from the specified streaming source discovery purposes.
	InputStartingPositionConfiguration *InputStartingPositionConfiguration `type:"structure"`

	// Amazon Resource Name (ARN) of the streaming source.
	ResourceARN *string `min:"1" type:"string"`

	// ARN of the IAM role that Amazon Kinesis Analytics can assume to access the
	// stream on your behalf.
	RoleARN *string `min:"1" type:"string"`

	// Specify this parameter to discover a schema from data in an Amazon S3 object.
	S3Configuration *S3Configuration `type:"structure"`
}

// String returns the string representation
func (s DiscoverInputSchemaInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DiscoverInputSchemaInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DiscoverInputSchemaInput"}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleARN", 1))
	}
	if s.InputProcessingConfiguration != nil {
		if err := s.InputProcessingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("InputProcessingConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.S3Configuration != nil {
		if err := s.S3Configuration.Validate(); err != nil {
			invalidParams.AddNested("S3Configuration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DiscoverInputSchemaOutput struct {
	_ struct{} `type:"structure"`

	// Schema inferred from the streaming source. It identifies the format of the
	// data in the streaming source and how each data element maps to corresponding
	// columns in the in-application stream that you can create.
	InputSchema *SourceSchema `type:"structure"`

	// An array of elements, where each element corresponds to a row in a stream
	// record (a stream record can have more than one row).
	ParsedInputRecords [][]string `type:"list"`

	// Stream data that was modified by the processor specified in the InputProcessingConfiguration
	// parameter.
	ProcessedInputRecords []string `type:"list"`

	// Raw stream data that was sampled to infer the schema.
	RawInputRecords []string `type:"list"`
}

// String returns the string representation
func (s DiscoverInputSchemaOutput) String() string {
	return awsutil.Prettify(s)
}

const opDiscoverInputSchema = "DiscoverInputSchema"

// DiscoverInputSchemaRequest returns a request value for making API operation for
// Amazon Kinesis Analytics.
//
//
// This documentation is for version 1 of the Amazon Kinesis Data Analytics
// API, which only supports SQL applications. Version 2 of the API supports
// SQL and Java applications. For more information about version 2, see Amazon
// Kinesis Data Analytics API V2 Documentation (/kinesisanalytics/latest/apiv2/Welcome.html).
//
// Infers a schema by evaluating sample records on the specified streaming source
// (Amazon Kinesis stream or Amazon Kinesis Firehose delivery stream) or S3
// object. In the response, the operation returns the inferred schema and also
// the sample records that the operation used to infer the schema.
//
// You can use the inferred schema when configuring a streaming source for your
// application. For conceptual information, see Configuring Application Input
// (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html).
// Note that when you create an application using the Amazon Kinesis Analytics
// console, the console uses this operation to infer a schema and show it in
// the console user interface.
//
// This operation requires permissions to perform the kinesisanalytics:DiscoverInputSchema
// action.
//
//    // Example sending a request using DiscoverInputSchemaRequest.
//    req := client.DiscoverInputSchemaRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/DiscoverInputSchema
func (c *Client) DiscoverInputSchemaRequest(input *DiscoverInputSchemaInput) DiscoverInputSchemaRequest {
	op := &aws.Operation{
		Name:       opDiscoverInputSchema,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DiscoverInputSchemaInput{}
	}

	req := c.newRequest(op, input, &DiscoverInputSchemaOutput{})
	return DiscoverInputSchemaRequest{Request: req, Input: input, Copy: c.DiscoverInputSchemaRequest}
}

// DiscoverInputSchemaRequest is the request type for the
// DiscoverInputSchema API operation.
type DiscoverInputSchemaRequest struct {
	*aws.Request
	Input *DiscoverInputSchemaInput
	Copy  func(*DiscoverInputSchemaInput) DiscoverInputSchemaRequest
}

// Send marshals and sends the DiscoverInputSchema API request.
func (r DiscoverInputSchemaRequest) Send(ctx context.Context) (*DiscoverInputSchemaResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DiscoverInputSchemaResponse{
		DiscoverInputSchemaOutput: r.Request.Data.(*DiscoverInputSchemaOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DiscoverInputSchemaResponse is the response type for the
// DiscoverInputSchema API operation.
type DiscoverInputSchemaResponse struct {
	*DiscoverInputSchemaOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DiscoverInputSchema request.
func (r *DiscoverInputSchemaResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
