package security

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// AlertsClient is the API spec for Microsoft.Security (Azure Security Center) resource provider
type AlertsClient struct {
	BaseClient
}

// NewAlertsClient creates an instance of the AlertsClient client.
func NewAlertsClient(subscriptionID string, ascLocation string) AlertsClient {
	return NewAlertsClientWithBaseURI(DefaultBaseURI, subscriptionID, ascLocation)
}

// NewAlertsClientWithBaseURI creates an instance of the AlertsClient client using a custom endpoint.  Use this when
// interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewAlertsClientWithBaseURI(baseURI string, subscriptionID string, ascLocation string) AlertsClient {
	return AlertsClient{NewWithBaseURI(baseURI, subscriptionID, ascLocation)}
}

// GetResourceGroupLevel get an alert that is associated a resource group or a resource in a resource group
// Parameters:
// alertName - name of the alert object
// resourceGroupName - the name of the resource group within the user's subscription. The name is case
// insensitive.
func (client AlertsClient) GetResourceGroupLevel(ctx context.Context, alertName string, resourceGroupName string) (result Alert, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.GetResourceGroupLevel")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.Pattern, Rule: `^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$`, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("security.AlertsClient", "GetResourceGroupLevel", err.Error())
	}

	req, err := client.GetResourceGroupLevelPreparer(ctx, alertName, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "GetResourceGroupLevel", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetResourceGroupLevelSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "GetResourceGroupLevel", resp, "Failure sending request")
		return
	}

	result, err = client.GetResourceGroupLevelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "GetResourceGroupLevel", resp, "Failure responding to request")
	}

	return
}

// GetResourceGroupLevelPreparer prepares the GetResourceGroupLevel request.
func (client AlertsClient) GetResourceGroupLevelPreparer(ctx context.Context, alertName string, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"alertName":         autorest.Encode("path", alertName),
		"ascLocation":       autorest.Encode("path", client.AscLocation),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/alerts/{alertName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetResourceGroupLevelSender sends the GetResourceGroupLevel request. The method will close the
// http.Response Body if it receives an error.
func (client AlertsClient) GetResourceGroupLevelSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResourceGroupLevelResponder handles the response to the GetResourceGroupLevel request. The method always
// closes the http.Response Body.
func (client AlertsClient) GetResourceGroupLevelResponder(resp *http.Response) (result Alert, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSubscriptionLevel get an alert that is associated with a subscription
// Parameters:
// alertName - name of the alert object
func (client AlertsClient) GetSubscriptionLevel(ctx context.Context, alertName string) (result Alert, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.GetSubscriptionLevel")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.Pattern, Rule: `^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("security.AlertsClient", "GetSubscriptionLevel", err.Error())
	}

	req, err := client.GetSubscriptionLevelPreparer(ctx, alertName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "GetSubscriptionLevel", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSubscriptionLevelSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "GetSubscriptionLevel", resp, "Failure sending request")
		return
	}

	result, err = client.GetSubscriptionLevelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "GetSubscriptionLevel", resp, "Failure responding to request")
	}

	return
}

// GetSubscriptionLevelPreparer prepares the GetSubscriptionLevel request.
func (client AlertsClient) GetSubscriptionLevelPreparer(ctx context.Context, alertName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"alertName":      autorest.Encode("path", alertName),
		"ascLocation":    autorest.Encode("path", client.AscLocation),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/alerts/{alertName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSubscriptionLevelSender sends the GetSubscriptionLevel request. The method will close the
// http.Response Body if it receives an error.
func (client AlertsClient) GetSubscriptionLevelSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSubscriptionLevelResponder handles the response to the GetSubscriptionLevel request. The method always
// closes the http.Response Body.
func (client AlertsClient) GetSubscriptionLevelResponder(resp *http.Response) (result Alert, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List list all the alerts that are associated with the subscription
func (client AlertsClient) List(ctx context.Context) (result AlertListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.List")
		defer func() {
			sc := -1
			if result.al.Response.Response != nil {
				sc = result.al.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.Pattern, Rule: `^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("security.AlertsClient", "List", err.Error())
	}

	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.al.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "List", resp, "Failure sending request")
		return
	}

	result.al, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "List", resp, "Failure responding to request")
	}
	if result.al.hasNextLink() && result.al.IsEmpty() {
		err = result.NextWithContext(ctx)
	}

	return
}

// ListPreparer prepares the List request.
func (client AlertsClient) ListPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Security/alerts", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client AlertsClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client AlertsClient) ListResponder(resp *http.Response) (result AlertList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client AlertsClient) listNextResults(ctx context.Context, lastResults AlertList) (result AlertList, err error) {
	req, err := lastResults.alertListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "security.AlertsClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "security.AlertsClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client AlertsClient) ListComplete(ctx context.Context) (result AlertListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx)
	return
}

// ListByResourceGroup list all the alerts that are associated with the resource group
// Parameters:
// resourceGroupName - the name of the resource group within the user's subscription. The name is case
// insensitive.
func (client AlertsClient) ListByResourceGroup(ctx context.Context, resourceGroupName string) (result AlertListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.ListByResourceGroup")
		defer func() {
			sc := -1
			if result.al.Response.Response != nil {
				sc = result.al.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.Pattern, Rule: `^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$`, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("security.AlertsClient", "ListByResourceGroup", err.Error())
	}

	result.fn = client.listByResourceGroupNextResults
	req, err := client.ListByResourceGroupPreparer(ctx, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "ListByResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.al.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "ListByResourceGroup", resp, "Failure sending request")
		return
	}

	result.al, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "ListByResourceGroup", resp, "Failure responding to request")
	}
	if result.al.hasNextLink() && result.al.IsEmpty() {
		err = result.NextWithContext(ctx)
	}

	return
}

// ListByResourceGroupPreparer prepares the ListByResourceGroup request.
func (client AlertsClient) ListByResourceGroupPreparer(ctx context.Context, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/alerts", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByResourceGroupSender sends the ListByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client AlertsClient) ListByResourceGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByResourceGroupResponder handles the response to the ListByResourceGroup request. The method always
// closes the http.Response Body.
func (client AlertsClient) ListByResourceGroupResponder(resp *http.Response) (result AlertList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByResourceGroupNextResults retrieves the next set of results, if any.
func (client AlertsClient) listByResourceGroupNextResults(ctx context.Context, lastResults AlertList) (result AlertList, err error) {
	req, err := lastResults.alertListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "security.AlertsClient", "listByResourceGroupNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "security.AlertsClient", "listByResourceGroupNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "listByResourceGroupNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByResourceGroupComplete enumerates all values, automatically crossing page boundaries as required.
func (client AlertsClient) ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result AlertListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.ListByResourceGroup")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByResourceGroup(ctx, resourceGroupName)
	return
}

// ListResourceGroupLevelByRegion list all the alerts that are associated with the resource group that are stored in a
// specific location
// Parameters:
// resourceGroupName - the name of the resource group within the user's subscription. The name is case
// insensitive.
func (client AlertsClient) ListResourceGroupLevelByRegion(ctx context.Context, resourceGroupName string) (result AlertListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.ListResourceGroupLevelByRegion")
		defer func() {
			sc := -1
			if result.al.Response.Response != nil {
				sc = result.al.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.Pattern, Rule: `^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$`, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("security.AlertsClient", "ListResourceGroupLevelByRegion", err.Error())
	}

	result.fn = client.listResourceGroupLevelByRegionNextResults
	req, err := client.ListResourceGroupLevelByRegionPreparer(ctx, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "ListResourceGroupLevelByRegion", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListResourceGroupLevelByRegionSender(req)
	if err != nil {
		result.al.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "ListResourceGroupLevelByRegion", resp, "Failure sending request")
		return
	}

	result.al, err = client.ListResourceGroupLevelByRegionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "ListResourceGroupLevelByRegion", resp, "Failure responding to request")
	}
	if result.al.hasNextLink() && result.al.IsEmpty() {
		err = result.NextWithContext(ctx)
	}

	return
}

// ListResourceGroupLevelByRegionPreparer prepares the ListResourceGroupLevelByRegion request.
func (client AlertsClient) ListResourceGroupLevelByRegionPreparer(ctx context.Context, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"ascLocation":       autorest.Encode("path", client.AscLocation),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/alerts", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListResourceGroupLevelByRegionSender sends the ListResourceGroupLevelByRegion request. The method will close the
// http.Response Body if it receives an error.
func (client AlertsClient) ListResourceGroupLevelByRegionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListResourceGroupLevelByRegionResponder handles the response to the ListResourceGroupLevelByRegion request. The method always
// closes the http.Response Body.
func (client AlertsClient) ListResourceGroupLevelByRegionResponder(resp *http.Response) (result AlertList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listResourceGroupLevelByRegionNextResults retrieves the next set of results, if any.
func (client AlertsClient) listResourceGroupLevelByRegionNextResults(ctx context.Context, lastResults AlertList) (result AlertList, err error) {
	req, err := lastResults.alertListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "security.AlertsClient", "listResourceGroupLevelByRegionNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListResourceGroupLevelByRegionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "security.AlertsClient", "listResourceGroupLevelByRegionNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResourceGroupLevelByRegionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "listResourceGroupLevelByRegionNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListResourceGroupLevelByRegionComplete enumerates all values, automatically crossing page boundaries as required.
func (client AlertsClient) ListResourceGroupLevelByRegionComplete(ctx context.Context, resourceGroupName string) (result AlertListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.ListResourceGroupLevelByRegion")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListResourceGroupLevelByRegion(ctx, resourceGroupName)
	return
}

// ListSubscriptionLevelByRegion list all the alerts that are associated with the subscription that are stored in a
// specific location
func (client AlertsClient) ListSubscriptionLevelByRegion(ctx context.Context) (result AlertListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.ListSubscriptionLevelByRegion")
		defer func() {
			sc := -1
			if result.al.Response.Response != nil {
				sc = result.al.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.Pattern, Rule: `^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("security.AlertsClient", "ListSubscriptionLevelByRegion", err.Error())
	}

	result.fn = client.listSubscriptionLevelByRegionNextResults
	req, err := client.ListSubscriptionLevelByRegionPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "ListSubscriptionLevelByRegion", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSubscriptionLevelByRegionSender(req)
	if err != nil {
		result.al.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "ListSubscriptionLevelByRegion", resp, "Failure sending request")
		return
	}

	result.al, err = client.ListSubscriptionLevelByRegionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "ListSubscriptionLevelByRegion", resp, "Failure responding to request")
	}
	if result.al.hasNextLink() && result.al.IsEmpty() {
		err = result.NextWithContext(ctx)
	}

	return
}

// ListSubscriptionLevelByRegionPreparer prepares the ListSubscriptionLevelByRegion request.
func (client AlertsClient) ListSubscriptionLevelByRegionPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"ascLocation":    autorest.Encode("path", client.AscLocation),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/alerts", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSubscriptionLevelByRegionSender sends the ListSubscriptionLevelByRegion request. The method will close the
// http.Response Body if it receives an error.
func (client AlertsClient) ListSubscriptionLevelByRegionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSubscriptionLevelByRegionResponder handles the response to the ListSubscriptionLevelByRegion request. The method always
// closes the http.Response Body.
func (client AlertsClient) ListSubscriptionLevelByRegionResponder(resp *http.Response) (result AlertList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listSubscriptionLevelByRegionNextResults retrieves the next set of results, if any.
func (client AlertsClient) listSubscriptionLevelByRegionNextResults(ctx context.Context, lastResults AlertList) (result AlertList, err error) {
	req, err := lastResults.alertListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "security.AlertsClient", "listSubscriptionLevelByRegionNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSubscriptionLevelByRegionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "security.AlertsClient", "listSubscriptionLevelByRegionNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListSubscriptionLevelByRegionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "listSubscriptionLevelByRegionNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListSubscriptionLevelByRegionComplete enumerates all values, automatically crossing page boundaries as required.
func (client AlertsClient) ListSubscriptionLevelByRegionComplete(ctx context.Context) (result AlertListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.ListSubscriptionLevelByRegion")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListSubscriptionLevelByRegion(ctx)
	return
}

// UpdateResourceGroupLevelStateToActivate update the alert's state
// Parameters:
// alertName - name of the alert object
// resourceGroupName - the name of the resource group within the user's subscription. The name is case
// insensitive.
func (client AlertsClient) UpdateResourceGroupLevelStateToActivate(ctx context.Context, alertName string, resourceGroupName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.UpdateResourceGroupLevelStateToActivate")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.Pattern, Rule: `^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$`, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("security.AlertsClient", "UpdateResourceGroupLevelStateToActivate", err.Error())
	}

	req, err := client.UpdateResourceGroupLevelStateToActivatePreparer(ctx, alertName, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "UpdateResourceGroupLevelStateToActivate", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateResourceGroupLevelStateToActivateSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "UpdateResourceGroupLevelStateToActivate", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateResourceGroupLevelStateToActivateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "UpdateResourceGroupLevelStateToActivate", resp, "Failure responding to request")
	}

	return
}

// UpdateResourceGroupLevelStateToActivatePreparer prepares the UpdateResourceGroupLevelStateToActivate request.
func (client AlertsClient) UpdateResourceGroupLevelStateToActivatePreparer(ctx context.Context, alertName string, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"alertName":         autorest.Encode("path", alertName),
		"ascLocation":       autorest.Encode("path", client.AscLocation),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/alerts/{alertName}/activate", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateResourceGroupLevelStateToActivateSender sends the UpdateResourceGroupLevelStateToActivate request. The method will close the
// http.Response Body if it receives an error.
func (client AlertsClient) UpdateResourceGroupLevelStateToActivateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateResourceGroupLevelStateToActivateResponder handles the response to the UpdateResourceGroupLevelStateToActivate request. The method always
// closes the http.Response Body.
func (client AlertsClient) UpdateResourceGroupLevelStateToActivateResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// UpdateResourceGroupLevelStateToDismiss update the alert's state
// Parameters:
// alertName - name of the alert object
// resourceGroupName - the name of the resource group within the user's subscription. The name is case
// insensitive.
func (client AlertsClient) UpdateResourceGroupLevelStateToDismiss(ctx context.Context, alertName string, resourceGroupName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.UpdateResourceGroupLevelStateToDismiss")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.Pattern, Rule: `^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$`, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("security.AlertsClient", "UpdateResourceGroupLevelStateToDismiss", err.Error())
	}

	req, err := client.UpdateResourceGroupLevelStateToDismissPreparer(ctx, alertName, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "UpdateResourceGroupLevelStateToDismiss", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateResourceGroupLevelStateToDismissSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "UpdateResourceGroupLevelStateToDismiss", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateResourceGroupLevelStateToDismissResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "UpdateResourceGroupLevelStateToDismiss", resp, "Failure responding to request")
	}

	return
}

// UpdateResourceGroupLevelStateToDismissPreparer prepares the UpdateResourceGroupLevelStateToDismiss request.
func (client AlertsClient) UpdateResourceGroupLevelStateToDismissPreparer(ctx context.Context, alertName string, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"alertName":         autorest.Encode("path", alertName),
		"ascLocation":       autorest.Encode("path", client.AscLocation),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/alerts/{alertName}/dismiss", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateResourceGroupLevelStateToDismissSender sends the UpdateResourceGroupLevelStateToDismiss request. The method will close the
// http.Response Body if it receives an error.
func (client AlertsClient) UpdateResourceGroupLevelStateToDismissSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateResourceGroupLevelStateToDismissResponder handles the response to the UpdateResourceGroupLevelStateToDismiss request. The method always
// closes the http.Response Body.
func (client AlertsClient) UpdateResourceGroupLevelStateToDismissResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// UpdateResourceGroupLevelStateToResolve update the alert's state
// Parameters:
// alertName - name of the alert object
// resourceGroupName - the name of the resource group within the user's subscription. The name is case
// insensitive.
func (client AlertsClient) UpdateResourceGroupLevelStateToResolve(ctx context.Context, alertName string, resourceGroupName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.UpdateResourceGroupLevelStateToResolve")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.Pattern, Rule: `^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$`, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("security.AlertsClient", "UpdateResourceGroupLevelStateToResolve", err.Error())
	}

	req, err := client.UpdateResourceGroupLevelStateToResolvePreparer(ctx, alertName, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "UpdateResourceGroupLevelStateToResolve", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateResourceGroupLevelStateToResolveSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "UpdateResourceGroupLevelStateToResolve", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateResourceGroupLevelStateToResolveResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "UpdateResourceGroupLevelStateToResolve", resp, "Failure responding to request")
	}

	return
}

// UpdateResourceGroupLevelStateToResolvePreparer prepares the UpdateResourceGroupLevelStateToResolve request.
func (client AlertsClient) UpdateResourceGroupLevelStateToResolvePreparer(ctx context.Context, alertName string, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"alertName":         autorest.Encode("path", alertName),
		"ascLocation":       autorest.Encode("path", client.AscLocation),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/alerts/{alertName}/resolve", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateResourceGroupLevelStateToResolveSender sends the UpdateResourceGroupLevelStateToResolve request. The method will close the
// http.Response Body if it receives an error.
func (client AlertsClient) UpdateResourceGroupLevelStateToResolveSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateResourceGroupLevelStateToResolveResponder handles the response to the UpdateResourceGroupLevelStateToResolve request. The method always
// closes the http.Response Body.
func (client AlertsClient) UpdateResourceGroupLevelStateToResolveResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// UpdateSubscriptionLevelStateToActivate update the alert's state
// Parameters:
// alertName - name of the alert object
func (client AlertsClient) UpdateSubscriptionLevelStateToActivate(ctx context.Context, alertName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.UpdateSubscriptionLevelStateToActivate")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.Pattern, Rule: `^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("security.AlertsClient", "UpdateSubscriptionLevelStateToActivate", err.Error())
	}

	req, err := client.UpdateSubscriptionLevelStateToActivatePreparer(ctx, alertName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "UpdateSubscriptionLevelStateToActivate", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSubscriptionLevelStateToActivateSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "UpdateSubscriptionLevelStateToActivate", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSubscriptionLevelStateToActivateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "UpdateSubscriptionLevelStateToActivate", resp, "Failure responding to request")
	}

	return
}

// UpdateSubscriptionLevelStateToActivatePreparer prepares the UpdateSubscriptionLevelStateToActivate request.
func (client AlertsClient) UpdateSubscriptionLevelStateToActivatePreparer(ctx context.Context, alertName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"alertName":      autorest.Encode("path", alertName),
		"ascLocation":    autorest.Encode("path", client.AscLocation),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/alerts/{alertName}/activate", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSubscriptionLevelStateToActivateSender sends the UpdateSubscriptionLevelStateToActivate request. The method will close the
// http.Response Body if it receives an error.
func (client AlertsClient) UpdateSubscriptionLevelStateToActivateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateSubscriptionLevelStateToActivateResponder handles the response to the UpdateSubscriptionLevelStateToActivate request. The method always
// closes the http.Response Body.
func (client AlertsClient) UpdateSubscriptionLevelStateToActivateResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// UpdateSubscriptionLevelStateToDismiss update the alert's state
// Parameters:
// alertName - name of the alert object
func (client AlertsClient) UpdateSubscriptionLevelStateToDismiss(ctx context.Context, alertName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.UpdateSubscriptionLevelStateToDismiss")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.Pattern, Rule: `^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("security.AlertsClient", "UpdateSubscriptionLevelStateToDismiss", err.Error())
	}

	req, err := client.UpdateSubscriptionLevelStateToDismissPreparer(ctx, alertName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "UpdateSubscriptionLevelStateToDismiss", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSubscriptionLevelStateToDismissSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "UpdateSubscriptionLevelStateToDismiss", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSubscriptionLevelStateToDismissResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "UpdateSubscriptionLevelStateToDismiss", resp, "Failure responding to request")
	}

	return
}

// UpdateSubscriptionLevelStateToDismissPreparer prepares the UpdateSubscriptionLevelStateToDismiss request.
func (client AlertsClient) UpdateSubscriptionLevelStateToDismissPreparer(ctx context.Context, alertName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"alertName":      autorest.Encode("path", alertName),
		"ascLocation":    autorest.Encode("path", client.AscLocation),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/alerts/{alertName}/dismiss", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSubscriptionLevelStateToDismissSender sends the UpdateSubscriptionLevelStateToDismiss request. The method will close the
// http.Response Body if it receives an error.
func (client AlertsClient) UpdateSubscriptionLevelStateToDismissSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateSubscriptionLevelStateToDismissResponder handles the response to the UpdateSubscriptionLevelStateToDismiss request. The method always
// closes the http.Response Body.
func (client AlertsClient) UpdateSubscriptionLevelStateToDismissResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// UpdateSubscriptionLevelStateToResolve update the alert's state
// Parameters:
// alertName - name of the alert object
func (client AlertsClient) UpdateSubscriptionLevelStateToResolve(ctx context.Context, alertName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsClient.UpdateSubscriptionLevelStateToResolve")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.Pattern, Rule: `^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("security.AlertsClient", "UpdateSubscriptionLevelStateToResolve", err.Error())
	}

	req, err := client.UpdateSubscriptionLevelStateToResolvePreparer(ctx, alertName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "UpdateSubscriptionLevelStateToResolve", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSubscriptionLevelStateToResolveSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "UpdateSubscriptionLevelStateToResolve", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSubscriptionLevelStateToResolveResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsClient", "UpdateSubscriptionLevelStateToResolve", resp, "Failure responding to request")
	}

	return
}

// UpdateSubscriptionLevelStateToResolvePreparer prepares the UpdateSubscriptionLevelStateToResolve request.
func (client AlertsClient) UpdateSubscriptionLevelStateToResolvePreparer(ctx context.Context, alertName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"alertName":      autorest.Encode("path", alertName),
		"ascLocation":    autorest.Encode("path", client.AscLocation),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/alerts/{alertName}/resolve", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSubscriptionLevelStateToResolveSender sends the UpdateSubscriptionLevelStateToResolve request. The method will close the
// http.Response Body if it receives an error.
func (client AlertsClient) UpdateSubscriptionLevelStateToResolveSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateSubscriptionLevelStateToResolveResponder handles the response to the UpdateSubscriptionLevelStateToResolve request. The method always
// closes the http.Response Body.
func (client AlertsClient) UpdateSubscriptionLevelStateToResolveResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}
