package sql

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AdvisorStatus enumerates the values for advisor status.
type AdvisorStatus string

const (
	// GA ...
	GA AdvisorStatus = "GA"
	// LimitedPublicPreview ...
	LimitedPublicPreview AdvisorStatus = "LimitedPublicPreview"
	// PrivatePreview ...
	PrivatePreview AdvisorStatus = "PrivatePreview"
	// PublicPreview ...
	PublicPreview AdvisorStatus = "PublicPreview"
)

// PossibleAdvisorStatusValues returns an array of possible values for the AdvisorStatus const type.
func PossibleAdvisorStatusValues() []AdvisorStatus {
	return []AdvisorStatus{GA, LimitedPublicPreview, PrivatePreview, PublicPreview}
}

// AuthenticationType enumerates the values for authentication type.
type AuthenticationType string

const (
	// ADPassword ...
	ADPassword AuthenticationType = "ADPassword"
	// SQL ...
	SQL AuthenticationType = "SQL"
)

// PossibleAuthenticationTypeValues returns an array of possible values for the AuthenticationType const type.
func PossibleAuthenticationTypeValues() []AuthenticationType {
	return []AuthenticationType{ADPassword, SQL}
}

// AutoExecuteStatus enumerates the values for auto execute status.
type AutoExecuteStatus string

const (
	// Default ...
	Default AutoExecuteStatus = "Default"
	// Disabled ...
	Disabled AutoExecuteStatus = "Disabled"
	// Enabled ...
	Enabled AutoExecuteStatus = "Enabled"
)

// PossibleAutoExecuteStatusValues returns an array of possible values for the AutoExecuteStatus const type.
func PossibleAutoExecuteStatusValues() []AutoExecuteStatus {
	return []AutoExecuteStatus{Default, Disabled, Enabled}
}

// CapabilityStatus enumerates the values for capability status.
type CapabilityStatus string

const (
	// CapabilityStatusAvailable ...
	CapabilityStatusAvailable CapabilityStatus = "Available"
	// CapabilityStatusDefault ...
	CapabilityStatusDefault CapabilityStatus = "Default"
	// CapabilityStatusDisabled ...
	CapabilityStatusDisabled CapabilityStatus = "Disabled"
	// CapabilityStatusVisible ...
	CapabilityStatusVisible CapabilityStatus = "Visible"
)

// PossibleCapabilityStatusValues returns an array of possible values for the CapabilityStatus const type.
func PossibleCapabilityStatusValues() []CapabilityStatus {
	return []CapabilityStatus{CapabilityStatusAvailable, CapabilityStatusDefault, CapabilityStatusDisabled, CapabilityStatusVisible}
}

// CheckNameAvailabilityReason enumerates the values for check name availability reason.
type CheckNameAvailabilityReason string

const (
	// AlreadyExists ...
	AlreadyExists CheckNameAvailabilityReason = "AlreadyExists"
	// Invalid ...
	Invalid CheckNameAvailabilityReason = "Invalid"
)

// PossibleCheckNameAvailabilityReasonValues returns an array of possible values for the CheckNameAvailabilityReason const type.
func PossibleCheckNameAvailabilityReasonValues() []CheckNameAvailabilityReason {
	return []CheckNameAvailabilityReason{AlreadyExists, Invalid}
}

// CreateMode enumerates the values for create mode.
type CreateMode string

const (
	// CreateModeCopy ...
	CreateModeCopy CreateMode = "Copy"
	// CreateModeDefault ...
	CreateModeDefault CreateMode = "Default"
	// CreateModeNonReadableSecondary ...
	CreateModeNonReadableSecondary CreateMode = "NonReadableSecondary"
	// CreateModeOnlineSecondary ...
	CreateModeOnlineSecondary CreateMode = "OnlineSecondary"
	// CreateModePointInTimeRestore ...
	CreateModePointInTimeRestore CreateMode = "PointInTimeRestore"
	// CreateModeRecovery ...
	CreateModeRecovery CreateMode = "Recovery"
	// CreateModeRestore ...
	CreateModeRestore CreateMode = "Restore"
	// CreateModeRestoreLongTermRetentionBackup ...
	CreateModeRestoreLongTermRetentionBackup CreateMode = "RestoreLongTermRetentionBackup"
)

// PossibleCreateModeValues returns an array of possible values for the CreateMode const type.
func PossibleCreateModeValues() []CreateMode {
	return []CreateMode{CreateModeCopy, CreateModeDefault, CreateModeNonReadableSecondary, CreateModeOnlineSecondary, CreateModePointInTimeRestore, CreateModeRecovery, CreateModeRestore, CreateModeRestoreLongTermRetentionBackup}
}

// DatabaseEdition enumerates the values for database edition.
type DatabaseEdition string

const (
	// Basic ...
	Basic DatabaseEdition = "Basic"
	// Business ...
	Business DatabaseEdition = "Business"
	// BusinessCritical ...
	BusinessCritical DatabaseEdition = "BusinessCritical"
	// DataWarehouse ...
	DataWarehouse DatabaseEdition = "DataWarehouse"
	// Free ...
	Free DatabaseEdition = "Free"
	// GeneralPurpose ...
	GeneralPurpose DatabaseEdition = "GeneralPurpose"
	// Hyperscale ...
	Hyperscale DatabaseEdition = "Hyperscale"
	// Premium ...
	Premium DatabaseEdition = "Premium"
	// PremiumRS ...
	PremiumRS DatabaseEdition = "PremiumRS"
	// Standard ...
	Standard DatabaseEdition = "Standard"
	// Stretch ...
	Stretch DatabaseEdition = "Stretch"
	// System ...
	System DatabaseEdition = "System"
	// System2 ...
	System2 DatabaseEdition = "System2"
	// Web ...
	Web DatabaseEdition = "Web"
)

// PossibleDatabaseEditionValues returns an array of possible values for the DatabaseEdition const type.
func PossibleDatabaseEditionValues() []DatabaseEdition {
	return []DatabaseEdition{Basic, Business, BusinessCritical, DataWarehouse, Free, GeneralPurpose, Hyperscale, Premium, PremiumRS, Standard, Stretch, System, System2, Web}
}

// DataMaskingFunction enumerates the values for data masking function.
type DataMaskingFunction string

const (
	// DataMaskingFunctionCCN ...
	DataMaskingFunctionCCN DataMaskingFunction = "CCN"
	// DataMaskingFunctionDefault ...
	DataMaskingFunctionDefault DataMaskingFunction = "Default"
	// DataMaskingFunctionEmail ...
	DataMaskingFunctionEmail DataMaskingFunction = "Email"
	// DataMaskingFunctionNumber ...
	DataMaskingFunctionNumber DataMaskingFunction = "Number"
	// DataMaskingFunctionSSN ...
	DataMaskingFunctionSSN DataMaskingFunction = "SSN"
	// DataMaskingFunctionText ...
	DataMaskingFunctionText DataMaskingFunction = "Text"
)

// PossibleDataMaskingFunctionValues returns an array of possible values for the DataMaskingFunction const type.
func PossibleDataMaskingFunctionValues() []DataMaskingFunction {
	return []DataMaskingFunction{DataMaskingFunctionCCN, DataMaskingFunctionDefault, DataMaskingFunctionEmail, DataMaskingFunctionNumber, DataMaskingFunctionSSN, DataMaskingFunctionText}
}

// DataMaskingRuleState enumerates the values for data masking rule state.
type DataMaskingRuleState string

const (
	// DataMaskingRuleStateDisabled ...
	DataMaskingRuleStateDisabled DataMaskingRuleState = "Disabled"
	// DataMaskingRuleStateEnabled ...
	DataMaskingRuleStateEnabled DataMaskingRuleState = "Enabled"
)

// PossibleDataMaskingRuleStateValues returns an array of possible values for the DataMaskingRuleState const type.
func PossibleDataMaskingRuleStateValues() []DataMaskingRuleState {
	return []DataMaskingRuleState{DataMaskingRuleStateDisabled, DataMaskingRuleStateEnabled}
}

// DataMaskingState enumerates the values for data masking state.
type DataMaskingState string

const (
	// DataMaskingStateDisabled ...
	DataMaskingStateDisabled DataMaskingState = "Disabled"
	// DataMaskingStateEnabled ...
	DataMaskingStateEnabled DataMaskingState = "Enabled"
)

// PossibleDataMaskingStateValues returns an array of possible values for the DataMaskingState const type.
func PossibleDataMaskingStateValues() []DataMaskingState {
	return []DataMaskingState{DataMaskingStateDisabled, DataMaskingStateEnabled}
}

// DisasterRecoveryConfigurationAutoFailover enumerates the values for disaster recovery configuration auto
// failover.
type DisasterRecoveryConfigurationAutoFailover string

const (
	// Off ...
	Off DisasterRecoveryConfigurationAutoFailover = "Off"
	// On ...
	On DisasterRecoveryConfigurationAutoFailover = "On"
)

// PossibleDisasterRecoveryConfigurationAutoFailoverValues returns an array of possible values for the DisasterRecoveryConfigurationAutoFailover const type.
func PossibleDisasterRecoveryConfigurationAutoFailoverValues() []DisasterRecoveryConfigurationAutoFailover {
	return []DisasterRecoveryConfigurationAutoFailover{Off, On}
}

// DisasterRecoveryConfigurationFailoverPolicy enumerates the values for disaster recovery configuration
// failover policy.
type DisasterRecoveryConfigurationFailoverPolicy string

const (
	// Automatic ...
	Automatic DisasterRecoveryConfigurationFailoverPolicy = "Automatic"
	// Manual ...
	Manual DisasterRecoveryConfigurationFailoverPolicy = "Manual"
)

// PossibleDisasterRecoveryConfigurationFailoverPolicyValues returns an array of possible values for the DisasterRecoveryConfigurationFailoverPolicy const type.
func PossibleDisasterRecoveryConfigurationFailoverPolicyValues() []DisasterRecoveryConfigurationFailoverPolicy {
	return []DisasterRecoveryConfigurationFailoverPolicy{Automatic, Manual}
}

// DisasterRecoveryConfigurationRole enumerates the values for disaster recovery configuration role.
type DisasterRecoveryConfigurationRole string

const (
	// None ...
	None DisasterRecoveryConfigurationRole = "None"
	// Primary ...
	Primary DisasterRecoveryConfigurationRole = "Primary"
	// Secondary ...
	Secondary DisasterRecoveryConfigurationRole = "Secondary"
)

// PossibleDisasterRecoveryConfigurationRoleValues returns an array of possible values for the DisasterRecoveryConfigurationRole const type.
func PossibleDisasterRecoveryConfigurationRoleValues() []DisasterRecoveryConfigurationRole {
	return []DisasterRecoveryConfigurationRole{None, Primary, Secondary}
}

// DisasterRecoveryConfigurationStatus enumerates the values for disaster recovery configuration status.
type DisasterRecoveryConfigurationStatus string

const (
	// Creating ...
	Creating DisasterRecoveryConfigurationStatus = "Creating"
	// Dropping ...
	Dropping DisasterRecoveryConfigurationStatus = "Dropping"
	// FailingOver ...
	FailingOver DisasterRecoveryConfigurationStatus = "FailingOver"
	// Ready ...
	Ready DisasterRecoveryConfigurationStatus = "Ready"
)

// PossibleDisasterRecoveryConfigurationStatusValues returns an array of possible values for the DisasterRecoveryConfigurationStatus const type.
func PossibleDisasterRecoveryConfigurationStatusValues() []DisasterRecoveryConfigurationStatus {
	return []DisasterRecoveryConfigurationStatus{Creating, Dropping, FailingOver, Ready}
}

// ElasticPoolEdition enumerates the values for elastic pool edition.
type ElasticPoolEdition string

const (
	// ElasticPoolEditionBasic ...
	ElasticPoolEditionBasic ElasticPoolEdition = "Basic"
	// ElasticPoolEditionBusinessCritical ...
	ElasticPoolEditionBusinessCritical ElasticPoolEdition = "BusinessCritical"
	// ElasticPoolEditionGeneralPurpose ...
	ElasticPoolEditionGeneralPurpose ElasticPoolEdition = "GeneralPurpose"
	// ElasticPoolEditionPremium ...
	ElasticPoolEditionPremium ElasticPoolEdition = "Premium"
	// ElasticPoolEditionStandard ...
	ElasticPoolEditionStandard ElasticPoolEdition = "Standard"
)

// PossibleElasticPoolEditionValues returns an array of possible values for the ElasticPoolEdition const type.
func PossibleElasticPoolEditionValues() []ElasticPoolEdition {
	return []ElasticPoolEdition{ElasticPoolEditionBasic, ElasticPoolEditionBusinessCritical, ElasticPoolEditionGeneralPurpose, ElasticPoolEditionPremium, ElasticPoolEditionStandard}
}

// ElasticPoolState enumerates the values for elastic pool state.
type ElasticPoolState string

const (
	// ElasticPoolStateCreating ...
	ElasticPoolStateCreating ElasticPoolState = "Creating"
	// ElasticPoolStateDisabled ...
	ElasticPoolStateDisabled ElasticPoolState = "Disabled"
	// ElasticPoolStateReady ...
	ElasticPoolStateReady ElasticPoolState = "Ready"
)

// PossibleElasticPoolStateValues returns an array of possible values for the ElasticPoolState const type.
func PossibleElasticPoolStateValues() []ElasticPoolState {
	return []ElasticPoolState{ElasticPoolStateCreating, ElasticPoolStateDisabled, ElasticPoolStateReady}
}

// GeoBackupPolicyState enumerates the values for geo backup policy state.
type GeoBackupPolicyState string

const (
	// GeoBackupPolicyStateDisabled ...
	GeoBackupPolicyStateDisabled GeoBackupPolicyState = "Disabled"
	// GeoBackupPolicyStateEnabled ...
	GeoBackupPolicyStateEnabled GeoBackupPolicyState = "Enabled"
)

// PossibleGeoBackupPolicyStateValues returns an array of possible values for the GeoBackupPolicyState const type.
func PossibleGeoBackupPolicyStateValues() []GeoBackupPolicyState {
	return []GeoBackupPolicyState{GeoBackupPolicyStateDisabled, GeoBackupPolicyStateEnabled}
}

// MaxSizeUnits enumerates the values for max size units.
type MaxSizeUnits string

const (
	// Gigabytes ...
	Gigabytes MaxSizeUnits = "Gigabytes"
	// Megabytes ...
	Megabytes MaxSizeUnits = "Megabytes"
	// Petabytes ...
	Petabytes MaxSizeUnits = "Petabytes"
	// Terabytes ...
	Terabytes MaxSizeUnits = "Terabytes"
)

// PossibleMaxSizeUnitsValues returns an array of possible values for the MaxSizeUnits const type.
func PossibleMaxSizeUnitsValues() []MaxSizeUnits {
	return []MaxSizeUnits{Gigabytes, Megabytes, Petabytes, Terabytes}
}

// PerformanceLevelUnit enumerates the values for performance level unit.
type PerformanceLevelUnit string

const (
	// DTU ...
	DTU PerformanceLevelUnit = "DTU"
)

// PossiblePerformanceLevelUnitValues returns an array of possible values for the PerformanceLevelUnit const type.
func PossiblePerformanceLevelUnitValues() []PerformanceLevelUnit {
	return []PerformanceLevelUnit{DTU}
}

// PrimaryAggregationType enumerates the values for primary aggregation type.
type PrimaryAggregationType string

const (
	// PrimaryAggregationTypeAverage ...
	PrimaryAggregationTypeAverage PrimaryAggregationType = "Average"
	// PrimaryAggregationTypeCount ...
	PrimaryAggregationTypeCount PrimaryAggregationType = "Count"
	// PrimaryAggregationTypeMaximum ...
	PrimaryAggregationTypeMaximum PrimaryAggregationType = "Maximum"
	// PrimaryAggregationTypeMinimum ...
	PrimaryAggregationTypeMinimum PrimaryAggregationType = "Minimum"
	// PrimaryAggregationTypeNone ...
	PrimaryAggregationTypeNone PrimaryAggregationType = "None"
	// PrimaryAggregationTypeTotal ...
	PrimaryAggregationTypeTotal PrimaryAggregationType = "Total"
)

// PossiblePrimaryAggregationTypeValues returns an array of possible values for the PrimaryAggregationType const type.
func PossiblePrimaryAggregationTypeValues() []PrimaryAggregationType {
	return []PrimaryAggregationType{PrimaryAggregationTypeAverage, PrimaryAggregationTypeCount, PrimaryAggregationTypeMaximum, PrimaryAggregationTypeMinimum, PrimaryAggregationTypeNone, PrimaryAggregationTypeTotal}
}

// QueryAggregationFunction enumerates the values for query aggregation function.
type QueryAggregationFunction string

const (
	// Avg ...
	Avg QueryAggregationFunction = "avg"
	// Max ...
	Max QueryAggregationFunction = "max"
	// Min ...
	Min QueryAggregationFunction = "min"
	// Sum ...
	Sum QueryAggregationFunction = "sum"
)

// PossibleQueryAggregationFunctionValues returns an array of possible values for the QueryAggregationFunction const type.
func PossibleQueryAggregationFunctionValues() []QueryAggregationFunction {
	return []QueryAggregationFunction{Avg, Max, Min, Sum}
}

// QueryExecutionType enumerates the values for query execution type.
type QueryExecutionType string

const (
	// Aborted ...
	Aborted QueryExecutionType = "aborted"
	// Any ...
	Any QueryExecutionType = "any"
	// Exception ...
	Exception QueryExecutionType = "exception"
	// Irregular ...
	Irregular QueryExecutionType = "irregular"
	// Regular ...
	Regular QueryExecutionType = "regular"
)

// PossibleQueryExecutionTypeValues returns an array of possible values for the QueryExecutionType const type.
func PossibleQueryExecutionTypeValues() []QueryExecutionType {
	return []QueryExecutionType{Aborted, Any, Exception, Irregular, Regular}
}

// QueryMetricUnit enumerates the values for query metric unit.
type QueryMetricUnit string

const (
	// KB ...
	KB QueryMetricUnit = "KB"
	// Microseconds ...
	Microseconds QueryMetricUnit = "microseconds"
	// Percentage ...
	Percentage QueryMetricUnit = "percentage"
)

// PossibleQueryMetricUnitValues returns an array of possible values for the QueryMetricUnit const type.
func PossibleQueryMetricUnitValues() []QueryMetricUnit {
	return []QueryMetricUnit{KB, Microseconds, Percentage}
}

// QueryObservedMetricType enumerates the values for query observed metric type.
type QueryObservedMetricType string

const (
	// CPU ...
	CPU QueryObservedMetricType = "cpu"
	// Duration ...
	Duration QueryObservedMetricType = "duration"
	// ExecutionCount ...
	ExecutionCount QueryObservedMetricType = "executionCount"
	// Io ...
	Io QueryObservedMetricType = "io"
	// Logio ...
	Logio QueryObservedMetricType = "logio"
)

// PossibleQueryObservedMetricTypeValues returns an array of possible values for the QueryObservedMetricType const type.
func PossibleQueryObservedMetricTypeValues() []QueryObservedMetricType {
	return []QueryObservedMetricType{CPU, Duration, ExecutionCount, Io, Logio}
}

// ReadScale enumerates the values for read scale.
type ReadScale string

const (
	// ReadScaleDisabled ...
	ReadScaleDisabled ReadScale = "Disabled"
	// ReadScaleEnabled ...
	ReadScaleEnabled ReadScale = "Enabled"
)

// PossibleReadScaleValues returns an array of possible values for the ReadScale const type.
func PossibleReadScaleValues() []ReadScale {
	return []ReadScale{ReadScaleDisabled, ReadScaleEnabled}
}

// RecommendedIndexAction enumerates the values for recommended index action.
type RecommendedIndexAction string

const (
	// Create ...
	Create RecommendedIndexAction = "Create"
	// Drop ...
	Drop RecommendedIndexAction = "Drop"
	// Rebuild ...
	Rebuild RecommendedIndexAction = "Rebuild"
)

// PossibleRecommendedIndexActionValues returns an array of possible values for the RecommendedIndexAction const type.
func PossibleRecommendedIndexActionValues() []RecommendedIndexAction {
	return []RecommendedIndexAction{Create, Drop, Rebuild}
}

// RecommendedIndexState enumerates the values for recommended index state.
type RecommendedIndexState string

const (
	// Active ...
	Active RecommendedIndexState = "Active"
	// Blocked ...
	Blocked RecommendedIndexState = "Blocked"
	// Executing ...
	Executing RecommendedIndexState = "Executing"
	// Expired ...
	Expired RecommendedIndexState = "Expired"
	// Ignored ...
	Ignored RecommendedIndexState = "Ignored"
	// Pending ...
	Pending RecommendedIndexState = "Pending"
	// PendingRevert ...
	PendingRevert RecommendedIndexState = "Pending Revert"
	// Reverted ...
	Reverted RecommendedIndexState = "Reverted"
	// Reverting ...
	Reverting RecommendedIndexState = "Reverting"
	// Success ...
	Success RecommendedIndexState = "Success"
	// Verifying ...
	Verifying RecommendedIndexState = "Verifying"
)

// PossibleRecommendedIndexStateValues returns an array of possible values for the RecommendedIndexState const type.
func PossibleRecommendedIndexStateValues() []RecommendedIndexState {
	return []RecommendedIndexState{Active, Blocked, Executing, Expired, Ignored, Pending, PendingRevert, Reverted, Reverting, Success, Verifying}
}

// RecommendedIndexType enumerates the values for recommended index type.
type RecommendedIndexType string

const (
	// CLUSTERED ...
	CLUSTERED RecommendedIndexType = "CLUSTERED"
	// CLUSTEREDCOLUMNSTORE ...
	CLUSTEREDCOLUMNSTORE RecommendedIndexType = "CLUSTERED COLUMNSTORE"
	// COLUMNSTORE ...
	COLUMNSTORE RecommendedIndexType = "COLUMNSTORE"
	// NONCLUSTERED ...
	NONCLUSTERED RecommendedIndexType = "NONCLUSTERED"
)

// PossibleRecommendedIndexTypeValues returns an array of possible values for the RecommendedIndexType const type.
func PossibleRecommendedIndexTypeValues() []RecommendedIndexType {
	return []RecommendedIndexType{CLUSTERED, CLUSTEREDCOLUMNSTORE, COLUMNSTORE, NONCLUSTERED}
}

// ReplicationRole enumerates the values for replication role.
type ReplicationRole string

const (
	// ReplicationRoleCopy ...
	ReplicationRoleCopy ReplicationRole = "Copy"
	// ReplicationRoleNonReadableSecondary ...
	ReplicationRoleNonReadableSecondary ReplicationRole = "NonReadableSecondary"
	// ReplicationRolePrimary ...
	ReplicationRolePrimary ReplicationRole = "Primary"
	// ReplicationRoleSecondary ...
	ReplicationRoleSecondary ReplicationRole = "Secondary"
	// ReplicationRoleSource ...
	ReplicationRoleSource ReplicationRole = "Source"
)

// PossibleReplicationRoleValues returns an array of possible values for the ReplicationRole const type.
func PossibleReplicationRoleValues() []ReplicationRole {
	return []ReplicationRole{ReplicationRoleCopy, ReplicationRoleNonReadableSecondary, ReplicationRolePrimary, ReplicationRoleSecondary, ReplicationRoleSource}
}

// ReplicationState enumerates the values for replication state.
type ReplicationState string

const (
	// CATCHUP ...
	CATCHUP ReplicationState = "CATCH_UP"
	// PENDING ...
	PENDING ReplicationState = "PENDING"
	// SEEDING ...
	SEEDING ReplicationState = "SEEDING"
	// SUSPENDED ...
	SUSPENDED ReplicationState = "SUSPENDED"
)

// PossibleReplicationStateValues returns an array of possible values for the ReplicationState const type.
func PossibleReplicationStateValues() []ReplicationState {
	return []ReplicationState{CATCHUP, PENDING, SEEDING, SUSPENDED}
}

// RestorePointType enumerates the values for restore point type.
type RestorePointType string

const (
	// CONTINUOUS ...
	CONTINUOUS RestorePointType = "CONTINUOUS"
	// DISCRETE ...
	DISCRETE RestorePointType = "DISCRETE"
)

// PossibleRestorePointTypeValues returns an array of possible values for the RestorePointType const type.
func PossibleRestorePointTypeValues() []RestorePointType {
	return []RestorePointType{CONTINUOUS, DISCRETE}
}

// SampleName enumerates the values for sample name.
type SampleName string

const (
	// AdventureWorksLT ...
	AdventureWorksLT SampleName = "AdventureWorksLT"
)

// PossibleSampleNameValues returns an array of possible values for the SampleName const type.
func PossibleSampleNameValues() []SampleName {
	return []SampleName{AdventureWorksLT}
}

// SecurityAlertPolicyEmailAccountAdmins enumerates the values for security alert policy email account admins.
type SecurityAlertPolicyEmailAccountAdmins string

const (
	// SecurityAlertPolicyEmailAccountAdminsDisabled ...
	SecurityAlertPolicyEmailAccountAdminsDisabled SecurityAlertPolicyEmailAccountAdmins = "Disabled"
	// SecurityAlertPolicyEmailAccountAdminsEnabled ...
	SecurityAlertPolicyEmailAccountAdminsEnabled SecurityAlertPolicyEmailAccountAdmins = "Enabled"
)

// PossibleSecurityAlertPolicyEmailAccountAdminsValues returns an array of possible values for the SecurityAlertPolicyEmailAccountAdmins const type.
func PossibleSecurityAlertPolicyEmailAccountAdminsValues() []SecurityAlertPolicyEmailAccountAdmins {
	return []SecurityAlertPolicyEmailAccountAdmins{SecurityAlertPolicyEmailAccountAdminsDisabled, SecurityAlertPolicyEmailAccountAdminsEnabled}
}

// SecurityAlertPolicyState enumerates the values for security alert policy state.
type SecurityAlertPolicyState string

const (
	// SecurityAlertPolicyStateDisabled ...
	SecurityAlertPolicyStateDisabled SecurityAlertPolicyState = "Disabled"
	// SecurityAlertPolicyStateEnabled ...
	SecurityAlertPolicyStateEnabled SecurityAlertPolicyState = "Enabled"
	// SecurityAlertPolicyStateNew ...
	SecurityAlertPolicyStateNew SecurityAlertPolicyState = "New"
)

// PossibleSecurityAlertPolicyStateValues returns an array of possible values for the SecurityAlertPolicyState const type.
func PossibleSecurityAlertPolicyStateValues() []SecurityAlertPolicyState {
	return []SecurityAlertPolicyState{SecurityAlertPolicyStateDisabled, SecurityAlertPolicyStateEnabled, SecurityAlertPolicyStateNew}
}

// SecurityAlertPolicyUseServerDefault enumerates the values for security alert policy use server default.
type SecurityAlertPolicyUseServerDefault string

const (
	// SecurityAlertPolicyUseServerDefaultDisabled ...
	SecurityAlertPolicyUseServerDefaultDisabled SecurityAlertPolicyUseServerDefault = "Disabled"
	// SecurityAlertPolicyUseServerDefaultEnabled ...
	SecurityAlertPolicyUseServerDefaultEnabled SecurityAlertPolicyUseServerDefault = "Enabled"
)

// PossibleSecurityAlertPolicyUseServerDefaultValues returns an array of possible values for the SecurityAlertPolicyUseServerDefault const type.
func PossibleSecurityAlertPolicyUseServerDefaultValues() []SecurityAlertPolicyUseServerDefault {
	return []SecurityAlertPolicyUseServerDefault{SecurityAlertPolicyUseServerDefaultDisabled, SecurityAlertPolicyUseServerDefaultEnabled}
}

// ServerConnectionType enumerates the values for server connection type.
type ServerConnectionType string

const (
	// ServerConnectionTypeDefault ...
	ServerConnectionTypeDefault ServerConnectionType = "Default"
	// ServerConnectionTypeProxy ...
	ServerConnectionTypeProxy ServerConnectionType = "Proxy"
	// ServerConnectionTypeRedirect ...
	ServerConnectionTypeRedirect ServerConnectionType = "Redirect"
)

// PossibleServerConnectionTypeValues returns an array of possible values for the ServerConnectionType const type.
func PossibleServerConnectionTypeValues() []ServerConnectionType {
	return []ServerConnectionType{ServerConnectionTypeDefault, ServerConnectionTypeProxy, ServerConnectionTypeRedirect}
}

// ServerState enumerates the values for server state.
type ServerState string

const (
	// ServerStateDisabled ...
	ServerStateDisabled ServerState = "Disabled"
	// ServerStateReady ...
	ServerStateReady ServerState = "Ready"
)

// PossibleServerStateValues returns an array of possible values for the ServerState const type.
func PossibleServerStateValues() []ServerState {
	return []ServerState{ServerStateDisabled, ServerStateReady}
}

// ServerVersion enumerates the values for server version.
type ServerVersion string

const (
	// OneTwoFullStopZero ...
	OneTwoFullStopZero ServerVersion = "12.0"
	// TwoFullStopZero ...
	TwoFullStopZero ServerVersion = "2.0"
)

// PossibleServerVersionValues returns an array of possible values for the ServerVersion const type.
func PossibleServerVersionValues() []ServerVersion {
	return []ServerVersion{OneTwoFullStopZero, TwoFullStopZero}
}

// ServiceObjectiveName enumerates the values for service objective name.
type ServiceObjectiveName string

const (
	// ServiceObjectiveNameBasic ...
	ServiceObjectiveNameBasic ServiceObjectiveName = "Basic"
	// ServiceObjectiveNameDS100 ...
	ServiceObjectiveNameDS100 ServiceObjectiveName = "DS100"
	// ServiceObjectiveNameDS1000 ...
	ServiceObjectiveNameDS1000 ServiceObjectiveName = "DS1000"
	// ServiceObjectiveNameDS1200 ...
	ServiceObjectiveNameDS1200 ServiceObjectiveName = "DS1200"
	// ServiceObjectiveNameDS1500 ...
	ServiceObjectiveNameDS1500 ServiceObjectiveName = "DS1500"
	// ServiceObjectiveNameDS200 ...
	ServiceObjectiveNameDS200 ServiceObjectiveName = "DS200"
	// ServiceObjectiveNameDS2000 ...
	ServiceObjectiveNameDS2000 ServiceObjectiveName = "DS2000"
	// ServiceObjectiveNameDS300 ...
	ServiceObjectiveNameDS300 ServiceObjectiveName = "DS300"
	// ServiceObjectiveNameDS400 ...
	ServiceObjectiveNameDS400 ServiceObjectiveName = "DS400"
	// ServiceObjectiveNameDS500 ...
	ServiceObjectiveNameDS500 ServiceObjectiveName = "DS500"
	// ServiceObjectiveNameDS600 ...
	ServiceObjectiveNameDS600 ServiceObjectiveName = "DS600"
	// ServiceObjectiveNameDW100 ...
	ServiceObjectiveNameDW100 ServiceObjectiveName = "DW100"
	// ServiceObjectiveNameDW1000 ...
	ServiceObjectiveNameDW1000 ServiceObjectiveName = "DW1000"
	// ServiceObjectiveNameDW10000c ...
	ServiceObjectiveNameDW10000c ServiceObjectiveName = "DW10000c"
	// ServiceObjectiveNameDW1000c ...
	ServiceObjectiveNameDW1000c ServiceObjectiveName = "DW1000c"
	// ServiceObjectiveNameDW1200 ...
	ServiceObjectiveNameDW1200 ServiceObjectiveName = "DW1200"
	// ServiceObjectiveNameDW1500 ...
	ServiceObjectiveNameDW1500 ServiceObjectiveName = "DW1500"
	// ServiceObjectiveNameDW15000c ...
	ServiceObjectiveNameDW15000c ServiceObjectiveName = "DW15000c"
	// ServiceObjectiveNameDW1500c ...
	ServiceObjectiveNameDW1500c ServiceObjectiveName = "DW1500c"
	// ServiceObjectiveNameDW200 ...
	ServiceObjectiveNameDW200 ServiceObjectiveName = "DW200"
	// ServiceObjectiveNameDW2000 ...
	ServiceObjectiveNameDW2000 ServiceObjectiveName = "DW2000"
	// ServiceObjectiveNameDW2000c ...
	ServiceObjectiveNameDW2000c ServiceObjectiveName = "DW2000c"
	// ServiceObjectiveNameDW2500c ...
	ServiceObjectiveNameDW2500c ServiceObjectiveName = "DW2500c"
	// ServiceObjectiveNameDW300 ...
	ServiceObjectiveNameDW300 ServiceObjectiveName = "DW300"
	// ServiceObjectiveNameDW3000 ...
	ServiceObjectiveNameDW3000 ServiceObjectiveName = "DW3000"
	// ServiceObjectiveNameDW30000c ...
	ServiceObjectiveNameDW30000c ServiceObjectiveName = "DW30000c"
	// ServiceObjectiveNameDW3000c ...
	ServiceObjectiveNameDW3000c ServiceObjectiveName = "DW3000c"
	// ServiceObjectiveNameDW400 ...
	ServiceObjectiveNameDW400 ServiceObjectiveName = "DW400"
	// ServiceObjectiveNameDW500 ...
	ServiceObjectiveNameDW500 ServiceObjectiveName = "DW500"
	// ServiceObjectiveNameDW5000c ...
	ServiceObjectiveNameDW5000c ServiceObjectiveName = "DW5000c"
	// ServiceObjectiveNameDW600 ...
	ServiceObjectiveNameDW600 ServiceObjectiveName = "DW600"
	// ServiceObjectiveNameDW6000 ...
	ServiceObjectiveNameDW6000 ServiceObjectiveName = "DW6000"
	// ServiceObjectiveNameDW6000c ...
	ServiceObjectiveNameDW6000c ServiceObjectiveName = "DW6000c"
	// ServiceObjectiveNameDW7500c ...
	ServiceObjectiveNameDW7500c ServiceObjectiveName = "DW7500c"
	// ServiceObjectiveNameElasticPool ...
	ServiceObjectiveNameElasticPool ServiceObjectiveName = "ElasticPool"
	// ServiceObjectiveNameFree ...
	ServiceObjectiveNameFree ServiceObjectiveName = "Free"
	// ServiceObjectiveNameP1 ...
	ServiceObjectiveNameP1 ServiceObjectiveName = "P1"
	// ServiceObjectiveNameP11 ...
	ServiceObjectiveNameP11 ServiceObjectiveName = "P11"
	// ServiceObjectiveNameP15 ...
	ServiceObjectiveNameP15 ServiceObjectiveName = "P15"
	// ServiceObjectiveNameP2 ...
	ServiceObjectiveNameP2 ServiceObjectiveName = "P2"
	// ServiceObjectiveNameP3 ...
	ServiceObjectiveNameP3 ServiceObjectiveName = "P3"
	// ServiceObjectiveNameP4 ...
	ServiceObjectiveNameP4 ServiceObjectiveName = "P4"
	// ServiceObjectiveNameP6 ...
	ServiceObjectiveNameP6 ServiceObjectiveName = "P6"
	// ServiceObjectiveNamePRS1 ...
	ServiceObjectiveNamePRS1 ServiceObjectiveName = "PRS1"
	// ServiceObjectiveNamePRS2 ...
	ServiceObjectiveNamePRS2 ServiceObjectiveName = "PRS2"
	// ServiceObjectiveNamePRS4 ...
	ServiceObjectiveNamePRS4 ServiceObjectiveName = "PRS4"
	// ServiceObjectiveNamePRS6 ...
	ServiceObjectiveNamePRS6 ServiceObjectiveName = "PRS6"
	// ServiceObjectiveNameS0 ...
	ServiceObjectiveNameS0 ServiceObjectiveName = "S0"
	// ServiceObjectiveNameS1 ...
	ServiceObjectiveNameS1 ServiceObjectiveName = "S1"
	// ServiceObjectiveNameS12 ...
	ServiceObjectiveNameS12 ServiceObjectiveName = "S12"
	// ServiceObjectiveNameS2 ...
	ServiceObjectiveNameS2 ServiceObjectiveName = "S2"
	// ServiceObjectiveNameS3 ...
	ServiceObjectiveNameS3 ServiceObjectiveName = "S3"
	// ServiceObjectiveNameS4 ...
	ServiceObjectiveNameS4 ServiceObjectiveName = "S4"
	// ServiceObjectiveNameS6 ...
	ServiceObjectiveNameS6 ServiceObjectiveName = "S6"
	// ServiceObjectiveNameS7 ...
	ServiceObjectiveNameS7 ServiceObjectiveName = "S7"
	// ServiceObjectiveNameS9 ...
	ServiceObjectiveNameS9 ServiceObjectiveName = "S9"
	// ServiceObjectiveNameSystem ...
	ServiceObjectiveNameSystem ServiceObjectiveName = "System"
	// ServiceObjectiveNameSystem0 ...
	ServiceObjectiveNameSystem0 ServiceObjectiveName = "System0"
	// ServiceObjectiveNameSystem1 ...
	ServiceObjectiveNameSystem1 ServiceObjectiveName = "System1"
	// ServiceObjectiveNameSystem2 ...
	ServiceObjectiveNameSystem2 ServiceObjectiveName = "System2"
	// ServiceObjectiveNameSystem2L ...
	ServiceObjectiveNameSystem2L ServiceObjectiveName = "System2L"
	// ServiceObjectiveNameSystem3 ...
	ServiceObjectiveNameSystem3 ServiceObjectiveName = "System3"
	// ServiceObjectiveNameSystem3L ...
	ServiceObjectiveNameSystem3L ServiceObjectiveName = "System3L"
	// ServiceObjectiveNameSystem4 ...
	ServiceObjectiveNameSystem4 ServiceObjectiveName = "System4"
	// ServiceObjectiveNameSystem4L ...
	ServiceObjectiveNameSystem4L ServiceObjectiveName = "System4L"
)

// PossibleServiceObjectiveNameValues returns an array of possible values for the ServiceObjectiveName const type.
func PossibleServiceObjectiveNameValues() []ServiceObjectiveName {
	return []ServiceObjectiveName{ServiceObjectiveNameBasic, ServiceObjectiveNameDS100, ServiceObjectiveNameDS1000, ServiceObjectiveNameDS1200, ServiceObjectiveNameDS1500, ServiceObjectiveNameDS200, ServiceObjectiveNameDS2000, ServiceObjectiveNameDS300, ServiceObjectiveNameDS400, ServiceObjectiveNameDS500, ServiceObjectiveNameDS600, ServiceObjectiveNameDW100, ServiceObjectiveNameDW1000, ServiceObjectiveNameDW10000c, ServiceObjectiveNameDW1000c, ServiceObjectiveNameDW1200, ServiceObjectiveNameDW1500, ServiceObjectiveNameDW15000c, ServiceObjectiveNameDW1500c, ServiceObjectiveNameDW200, ServiceObjectiveNameDW2000, ServiceObjectiveNameDW2000c, ServiceObjectiveNameDW2500c, ServiceObjectiveNameDW300, ServiceObjectiveNameDW3000, ServiceObjectiveNameDW30000c, ServiceObjectiveNameDW3000c, ServiceObjectiveNameDW400, ServiceObjectiveNameDW500, ServiceObjectiveNameDW5000c, ServiceObjectiveNameDW600, ServiceObjectiveNameDW6000, ServiceObjectiveNameDW6000c, ServiceObjectiveNameDW7500c, ServiceObjectiveNameElasticPool, ServiceObjectiveNameFree, ServiceObjectiveNameP1, ServiceObjectiveNameP11, ServiceObjectiveNameP15, ServiceObjectiveNameP2, ServiceObjectiveNameP3, ServiceObjectiveNameP4, ServiceObjectiveNameP6, ServiceObjectiveNamePRS1, ServiceObjectiveNamePRS2, ServiceObjectiveNamePRS4, ServiceObjectiveNamePRS6, ServiceObjectiveNameS0, ServiceObjectiveNameS1, ServiceObjectiveNameS12, ServiceObjectiveNameS2, ServiceObjectiveNameS3, ServiceObjectiveNameS4, ServiceObjectiveNameS6, ServiceObjectiveNameS7, ServiceObjectiveNameS9, ServiceObjectiveNameSystem, ServiceObjectiveNameSystem0, ServiceObjectiveNameSystem1, ServiceObjectiveNameSystem2, ServiceObjectiveNameSystem2L, ServiceObjectiveNameSystem3, ServiceObjectiveNameSystem3L, ServiceObjectiveNameSystem4, ServiceObjectiveNameSystem4L}
}

// StorageKeyType enumerates the values for storage key type.
type StorageKeyType string

const (
	// SharedAccessKey ...
	SharedAccessKey StorageKeyType = "SharedAccessKey"
	// StorageAccessKey ...
	StorageAccessKey StorageKeyType = "StorageAccessKey"
)

// PossibleStorageKeyTypeValues returns an array of possible values for the StorageKeyType const type.
func PossibleStorageKeyTypeValues() []StorageKeyType {
	return []StorageKeyType{SharedAccessKey, StorageAccessKey}
}

// TransparentDataEncryptionActivityStatus enumerates the values for transparent data encryption activity
// status.
type TransparentDataEncryptionActivityStatus string

const (
	// Decrypting ...
	Decrypting TransparentDataEncryptionActivityStatus = "Decrypting"
	// Encrypting ...
	Encrypting TransparentDataEncryptionActivityStatus = "Encrypting"
)

// PossibleTransparentDataEncryptionActivityStatusValues returns an array of possible values for the TransparentDataEncryptionActivityStatus const type.
func PossibleTransparentDataEncryptionActivityStatusValues() []TransparentDataEncryptionActivityStatus {
	return []TransparentDataEncryptionActivityStatus{Decrypting, Encrypting}
}

// TransparentDataEncryptionStatus enumerates the values for transparent data encryption status.
type TransparentDataEncryptionStatus string

const (
	// TransparentDataEncryptionStatusDisabled ...
	TransparentDataEncryptionStatusDisabled TransparentDataEncryptionStatus = "Disabled"
	// TransparentDataEncryptionStatusEnabled ...
	TransparentDataEncryptionStatusEnabled TransparentDataEncryptionStatus = "Enabled"
)

// PossibleTransparentDataEncryptionStatusValues returns an array of possible values for the TransparentDataEncryptionStatus const type.
func PossibleTransparentDataEncryptionStatusValues() []TransparentDataEncryptionStatus {
	return []TransparentDataEncryptionStatus{TransparentDataEncryptionStatusDisabled, TransparentDataEncryptionStatusEnabled}
}

// UnitDefinitionType enumerates the values for unit definition type.
type UnitDefinitionType string

const (
	// Bytes ...
	Bytes UnitDefinitionType = "Bytes"
	// BytesPerSecond ...
	BytesPerSecond UnitDefinitionType = "BytesPerSecond"
	// Count ...
	Count UnitDefinitionType = "Count"
	// CountPerSecond ...
	CountPerSecond UnitDefinitionType = "CountPerSecond"
	// Percent ...
	Percent UnitDefinitionType = "Percent"
	// Seconds ...
	Seconds UnitDefinitionType = "Seconds"
)

// PossibleUnitDefinitionTypeValues returns an array of possible values for the UnitDefinitionType const type.
func PossibleUnitDefinitionTypeValues() []UnitDefinitionType {
	return []UnitDefinitionType{Bytes, BytesPerSecond, Count, CountPerSecond, Percent, Seconds}
}

// UnitType enumerates the values for unit type.
type UnitType string

const (
	// UnitTypeBytes ...
	UnitTypeBytes UnitType = "bytes"
	// UnitTypeBytesPerSecond ...
	UnitTypeBytesPerSecond UnitType = "bytesPerSecond"
	// UnitTypeCount ...
	UnitTypeCount UnitType = "count"
	// UnitTypeCountPerSecond ...
	UnitTypeCountPerSecond UnitType = "countPerSecond"
	// UnitTypePercent ...
	UnitTypePercent UnitType = "percent"
	// UnitTypeSeconds ...
	UnitTypeSeconds UnitType = "seconds"
)

// PossibleUnitTypeValues returns an array of possible values for the UnitType const type.
func PossibleUnitTypeValues() []UnitType {
	return []UnitType{UnitTypeBytes, UnitTypeBytesPerSecond, UnitTypeCount, UnitTypeCountPerSecond, UnitTypePercent, UnitTypeSeconds}
}
