package containerregistry

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/containerregistry/runtime/2019-07/containerregistry"

// AccessToken ...
type AccessToken struct {
	autorest.Response `json:"-"`
	// AccessToken - The access token for performing authenticated requests
	AccessToken *string `json:"access_token,omitempty"`
}

// AcrErrorInfo error information
type AcrErrorInfo struct {
	// Code - Error code
	Code *string `json:"code,omitempty"`
	// Message - Error message
	Message *string `json:"message,omitempty"`
	// Detail - Error details
	Detail interface{} `json:"detail,omitempty"`
}

// AcrErrors acr error response describing why the operation failed
type AcrErrors struct {
	// Errors - Array of detailed error
	Errors *[]AcrErrorInfo `json:"errors,omitempty"`
}

// AcrManifestAttributes manifest attributes details
type AcrManifestAttributes struct {
	autorest.Response `json:"-"`
	// Registry - Registry name
	Registry *string `json:"registry,omitempty"`
	// ImageName - Image name
	ImageName *string `json:"imageName,omitempty"`
	// ManifestAttributes - Manifest attributes
	ManifestAttributes *AcrManifestAttributesBase `json:"manifest,omitempty"`
}

// AcrManifestAttributesBase manifest details
type AcrManifestAttributesBase struct {
	// Digest - Manifest
	Digest *string `json:"digest,omitempty"`
	// ImageSize - Image size
	ImageSize *int32 `json:"imageSize,omitempty"`
	// CreatedTime - Created time
	CreatedTime *string `json:"createdTime,omitempty"`
	// LastUpdateTime - Last update time
	LastUpdateTime *string `json:"lastUpdateTime,omitempty"`
	// Architecture - CPU architecture
	Architecture *string `json:"architecture,omitempty"`
	// Os - Operating system
	Os *string `json:"os,omitempty"`
	// MediaType - Media type
	MediaType *string `json:"mediaType,omitempty"`
	// ConfigMediaType - Config blob media type
	ConfigMediaType *string `json:"configMediaType,omitempty"`
	// Tags - List of tags
	Tags *[]string `json:"tags,omitempty"`
	// ChangeableAttributes - Changeable attributes
	ChangeableAttributes *ChangeableAttributes `json:"changeableAttributes,omitempty"`
}

// AcrManifests manifest attributes
type AcrManifests struct {
	autorest.Response `json:"-"`
	// Registry - Registry name
	Registry *string `json:"registry,omitempty"`
	// ImageName - Image name
	ImageName *string `json:"imageName,omitempty"`
	// ManifestsAttributes - List of manifests
	ManifestsAttributes *[]AcrManifestAttributesBase `json:"manifests,omitempty"`
}

// AcrRepositoryTags list of tag details
type AcrRepositoryTags struct {
	autorest.Response `json:"-"`
	// Registry - Registry name
	Registry *string `json:"registry,omitempty"`
	// ImageName - Image name
	ImageName *string `json:"imageName,omitempty"`
	// TagsAttributes - List of tag attribute details
	TagsAttributes *[]AcrTagAttributesBase `json:"tags,omitempty"`
}

// AcrTagAttributes tag attributes
type AcrTagAttributes struct {
	autorest.Response `json:"-"`
	// Registry - Registry name
	Registry *string `json:"registry,omitempty"`
	// ImageName - Image name
	ImageName *string `json:"imageName,omitempty"`
	// TagAttributes - List of tag attribute details
	TagAttributes *AcrTagAttributesBase `json:"tag,omitempty"`
}

// AcrTagAttributesBase tag attribute details
type AcrTagAttributesBase struct {
	// Name - Tag name
	Name *string `json:"name,omitempty"`
	// Digest - Tag digest
	Digest *string `json:"digest,omitempty"`
	// CreatedTime - Tag created time
	CreatedTime *string `json:"createdTime,omitempty"`
	// LastUpdateTime - Tag last update time
	LastUpdateTime *string `json:"lastUpdateTime,omitempty"`
	// Signed - Is signed
	Signed *bool `json:"signed,omitempty"`
	// ChangeableAttributes - Changeable attributes
	ChangeableAttributes *ChangeableAttributes `json:"changeableAttributes,omitempty"`
}

// ChangeableAttributes ...
type ChangeableAttributes struct {
	// DeleteEnabled - Delete enabled
	DeleteEnabled *bool `json:"deleteEnabled,omitempty"`
	// WriteEnabled - Write enabled
	WriteEnabled *bool `json:"writeEnabled,omitempty"`
	// ListEnabled - List enabled
	ListEnabled *bool `json:"listEnabled,omitempty"`
	// ReadEnabled - Read enabled
	ReadEnabled *bool `json:"readEnabled,omitempty"`
}

// DeletedRepository deleted repository
type DeletedRepository struct {
	autorest.Response `json:"-"`
	// ManifestsDeleted - SHA of the deleted image
	ManifestsDeleted *[]string `json:"manifestsDeleted,omitempty"`
	// TagsDeleted - Tag of the deleted image
	TagsDeleted *[]string `json:"tagsDeleted,omitempty"`
}

// FsLayer image layer information
type FsLayer struct {
	// BlobSum - SHA of an image layer
	BlobSum *string `json:"blobSum,omitempty"`
}

// History a list of unstructured historical data for v1 compatibility
type History struct {
	// V1Compatibility - The raw v1 compatibility information
	V1Compatibility *string `json:"v1Compatibility,omitempty"`
}

// ImageSignature signature of a signed manifest
type ImageSignature struct {
	// Header - A JSON web signature
	Header *JWK `json:"header,omitempty"`
	// Signature - A signature for the image manifest, signed by a libtrust private key
	Signature *string `json:"signature,omitempty"`
	// Protected - The signed protected header
	Protected *string `json:"protected,omitempty"`
}

// JWK a JSON web signature
type JWK struct {
	Jwk *JWKHeader `json:"jwk,omitempty"`
	// Alg - The algorithm used to sign or encrypt the JWT
	Alg *string `json:"alg,omitempty"`
}

// JWKHeader JSON web key parameter
type JWKHeader struct {
	// Crv - crv value
	Crv *string `json:"crv,omitempty"`
	// Kid - kid value
	Kid *string `json:"kid,omitempty"`
	// Kty - kty value
	Kty *string `json:"kty,omitempty"`
	// X - x value
	X *string `json:"x,omitempty"`
	// Y - y value
	Y *string `json:"y,omitempty"`
}

// Manifest returns the requested manifest file
type Manifest struct {
	autorest.Response `json:"-"`
	// SchemaVersion - Schema version
	SchemaVersion *int32 `json:"schemaVersion,omitempty"`
	// MediaType - Media type usually application/vnd.docker.distribution.manifest.v2+json if this is in the accept header
	MediaType *string `json:"mediaType,omitempty"`
	// Config - V2 image config descriptor
	Config *V2Descriptor `json:"config,omitempty"`
	// Layers - List of V2 image layer information
	Layers *[]V2Descriptor `json:"layers,omitempty"`
	// Architecture - CPU architecture
	Architecture *string `json:"architecture,omitempty"`
	// Name - Image name
	Name *string `json:"name,omitempty"`
	// Tag - Image tag
	Tag *string `json:"tag,omitempty"`
	// FsLayers - List of layer information
	FsLayers *[]FsLayer `json:"fsLayers,omitempty"`
	// History - Image history
	History *[]History `json:"history,omitempty"`
	// Signatures - Image signature
	Signatures *[]ImageSignature `json:"signatures,omitempty"`
}

// ManifestAttributesManifest list of manifest attributes
type ManifestAttributesManifest struct {
	// References - List of manifest attributes details
	References *[]ManifestAttributesManifestReferences `json:"references,omitempty"`
	// QuarantineTag - Quarantine tag name
	QuarantineTag *string `json:"quarantineTag,omitempty"`
}

// ManifestAttributesManifestReferences manifest attributes details
type ManifestAttributesManifestReferences struct {
	// Digest - Manifest digest
	Digest *string `json:"digest,omitempty"`
	// Architecture - CPU architecture
	Architecture *string `json:"architecture,omitempty"`
	// Os - Operating system
	Os *string `json:"os,omitempty"`
}

// ManifestChangeableAttributes changeable attributes
type ManifestChangeableAttributes struct {
	// DeleteEnabled - Delete enabled
	DeleteEnabled *bool `json:"deleteEnabled,omitempty"`
	// WriteEnabled - Write enabled
	WriteEnabled *bool `json:"writeEnabled,omitempty"`
	// ListEnabled - List enabled
	ListEnabled *bool `json:"listEnabled,omitempty"`
	// ReadEnabled - Read enabled
	ReadEnabled *bool `json:"readEnabled,omitempty"`
	// QuarantineState - Quarantine state
	QuarantineState *string `json:"quarantineState,omitempty"`
	// QuarantineDetails - Quarantine details
	QuarantineDetails *string `json:"quarantineDetails,omitempty"`
}

// RefreshToken ...
type RefreshToken struct {
	autorest.Response `json:"-"`
	// RefreshToken - The refresh token to be used for generating access tokens
	RefreshToken *string `json:"refresh_token,omitempty"`
}

// Repositories list of repositories
type Repositories struct {
	autorest.Response `json:"-"`
	// Names - Repository names
	Names *[]string `json:"repositories,omitempty"`
}

// RepositoryAttributes repository attributes
type RepositoryAttributes struct {
	autorest.Response `json:"-"`
	// Registry - Registry name
	Registry *string `json:"registry,omitempty"`
	// ImageName - Image name
	ImageName *string `json:"imageName,omitempty"`
	// CreatedTime - Image created time
	CreatedTime *string `json:"createdTime,omitempty"`
	// LastUpdateTime - Image last update time
	LastUpdateTime *string `json:"lastUpdateTime,omitempty"`
	// ManifestCount - Number of the manifests
	ManifestCount *int32 `json:"manifestCount,omitempty"`
	// TagCount - Number of the tags
	TagCount *int32 `json:"tagCount,omitempty"`
	// ChangeableAttributes - Changeable attributes
	ChangeableAttributes *ChangeableAttributes `json:"changeableAttributes,omitempty"`
}

// RepositoryTags result of the request to list tags of the image
type RepositoryTags struct {
	autorest.Response `json:"-"`
	// Name - Name of the image
	Name *string `json:"name,omitempty"`
	// Tags - List of tags
	Tags *[]string `json:"tags,omitempty"`
}

// SetObject ...
type SetObject struct {
	autorest.Response `json:"-"`
	Value             interface{} `json:"value,omitempty"`
}

// TagAttributes tag attributes
type TagAttributes struct {
	// Registry - Registry name
	Registry *string `json:"registry,omitempty"`
	// ImageName - Image name
	ImageName *string `json:"imageName,omitempty"`
	// Tag - Tag attributes
	Tag *TagAttributesTag `json:"tag,omitempty"`
}

// TagAttributesTag tag
type TagAttributesTag struct {
	// SignatureRecord - SignatureRecord value
	SignatureRecord *string `json:"signatureRecord,omitempty"`
}

// V2Descriptor docker V2 image layer descriptor including config and layers
type V2Descriptor struct {
	// MediaType - Layer media type
	MediaType *string `json:"mediaType,omitempty"`
	// Size - Layer size
	Size *int32 `json:"size,omitempty"`
	// Digest - Layer digest
	Digest *string `json:"digest,omitempty"`
}
