// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/openshift/cluster-node-tuning-operator/pkg/apis/tuned/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// ProfileLister helps list Profiles.
// All objects returned here must be treated as read-only.
type ProfileLister interface {
	// List lists all Profiles in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.Profile, err error)
	// Profiles returns an object that can list and get Profiles.
	Profiles(namespace string) ProfileNamespaceLister
	ProfileListerExpansion
}

// profileLister implements the ProfileLister interface.
type profileLister struct {
	indexer cache.Indexer
}

// NewProfileLister returns a new ProfileLister.
func NewProfileLister(indexer cache.Indexer) ProfileLister {
	return &profileLister{indexer: indexer}
}

// List lists all Profiles in the indexer.
func (s *profileLister) List(selector labels.Selector) (ret []*v1.Profile, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.Profile))
	})
	return ret, err
}

// Profiles returns an object that can list and get Profiles.
func (s *profileLister) Profiles(namespace string) ProfileNamespaceLister {
	return profileNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// ProfileNamespaceLister helps list and get Profiles.
// All objects returned here must be treated as read-only.
type ProfileNamespaceLister interface {
	// List lists all Profiles in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.Profile, err error)
	// Get retrieves the Profile from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.Profile, error)
	ProfileNamespaceListerExpansion
}

// profileNamespaceLister implements the ProfileNamespaceLister
// interface.
type profileNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all Profiles in the indexer for a given namespace.
func (s profileNamespaceLister) List(selector labels.Selector) (ret []*v1.Profile, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.Profile))
	})
	return ret, err
}

// Get retrieves the Profile from the indexer for a given namespace and name.
func (s profileNamespaceLister) Get(name string) (*v1.Profile, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("profile"), name)
	}
	return obj.(*v1.Profile), nil
}
