// Copyright 2021 Tobias Klauser. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// +build ignore

package sysconf

/*
#include <limits.h>
#include <linux/uio.h>
#include <stdio.h>
#include <unistd.h>

#include <grp.h> // for NSS_BUFLEN_GROUP
#include <pwd.h> // for NSS_BUFLEN_PASSWD

// This comes from the Linux kernel header.
#ifndef OPEN_MAX
# define OPEN_MAX	256
#endif
// POSIX_STREAM_MAX is 8, but glibc returns FOPEN_MAX if STREAM_MAX is not
// defined.
#ifndef STREAM_MAX
# define STREAM_MAX	FOPEN_MAX
#endif
#ifndef SYMLOOP_MAX
# define SYMLOOP_MAX	-1	// undefined
#endif

// These are not defined in <bits/environments.h> on all platforms.
#ifndef _POSIX_V6_ILP32_OFF32
# define _POSIX_V6_ILP32_OFF32	-1
#endif
#ifndef _POSIX_V6_ILP32_OFFBIG
# define _POSIX_V6_ILP32_OFFBIG	-1
#endif
#ifndef _POSIX_V6_LP64_OFF64
# define _POSIX_V6_LP64_OFF64	-1
#endif
#ifndef _POSIX_V6_LPBIG_OFFBIG
# define _POSIX_V6_LPBIG_OFFBIG	-1
#endif
#ifndef _POSIX_V6_LPBIG_OFFBIG
# define _POSIX_V6_LPBIG_OFFBIG	-1
#endif
#ifndef _POSIX_V7_ILP32_OFF32
# define _POSIX_V7_ILP32_OFF32	-1
#endif
#ifndef _POSIX_V7_ILP32_OFFBIG
# define _POSIX_V7_ILP32_OFFBIG	-1
#endif
#ifndef _POSIX_V7_LP64_OFF64
# define _POSIX_V7_LP64_OFF64	-1
#endif
#ifndef _POSIX_V7_LPBIG_OFFBIG
# define _POSIX_V7_LPBIG_OFFBIG	-1
#endif
*/
import "C"

// sysconf values, some of these are GOARCH-dependent
const (
	_AIO_PRIO_DELTA_MAX = C.AIO_PRIO_DELTA_MAX
	_BC_BASE_MAX        = C.BC_BASE_MAX
	_BC_DIM_MAX         = C.BC_DIM_MAX
	_BC_SCALE_MAX       = C.BC_SCALE_MAX
	_BC_STRING_MAX      = C.BC_STRING_MAX
	_COLL_WEIGHTS_MAX   = C.COLL_WEIGHTS_MAX
	_DELAYTIMER_MAX     = C.DELAYTIMER_MAX
	_EXPR_NEST_MAX      = C.EXPR_NEST_MAX
	_HOST_NAME_MAX      = C.HOST_NAME_MAX
	_LINE_MAX           = C.LINE_MAX
	_LOGIN_NAME_MAX     = C.LOGIN_NAME_MAX
	_MQ_PRIO_MAX        = C.MQ_PRIO_MAX
	_NGROUPS_MAX        = C.NGROUPS_MAX
	_NSS_BUFLEN_GROUP   = C.NSS_BUFLEN_GROUP
	_NSS_BUFLEN_PASSWD  = C.NSS_BUFLEN_PASSWD
	_OPEN_MAX           = C.OPEN_MAX
	_PTHREAD_KEYS_MAX   = C.PTHREAD_KEYS_MAX
	_PTHREAD_STACK_MIN  = C.PTHREAD_STACK_MIN
	_RE_DUP_MAX         = C.RE_DUP_MAX
	_RTSIG_MAX          = C.RTSIG_MAX
	_SEM_VALUE_MAX      = C.SEM_VALUE_MAX
	_STREAM_MAX         = C.STREAM_MAX
	_SYMLOOP_MAX        = C.SYMLOOP_MAX
	_TTY_NAME_MAX       = C.TTY_NAME_MAX

	_UIO_MAXIOV = C.UIO_MAXIOV

	_INT_MAX = C.INT_MAX

	_POSIX_ADVISORY_INFO                = C._POSIX_ADVISORY_INFO
	_POSIX_ARG_MAX                      = C._POSIX_ARG_MAX
	_POSIX_ASYNCHRONOUS_IO              = C._POSIX_ASYNCHRONOUS_IO
	_POSIX_BARRIERS                     = C._POSIX_BARRIERS
	_POSIX_CHILD_MAX                    = C._POSIX_CHILD_MAX
	_POSIX_CLOCK_SELECTION              = C._POSIX_CLOCK_SELECTION
	_POSIX_CPUTIME                      = C._POSIX_CPUTIME
	_POSIX_FSYNC                        = C._POSIX_FSYNC
	_POSIX_IPV6                         = C._POSIX_IPV6
	_POSIX_JOB_CONTROL                  = C._POSIX_JOB_CONTROL
	_POSIX_MAPPED_FILES                 = C._POSIX_MAPPED_FILES
	_POSIX_MEMLOCK                      = C._POSIX_MEMLOCK
	_POSIX_MEMLOCK_RANGE                = C._POSIX_MEMLOCK_RANGE
	_POSIX_MEMORY_PROTECTION            = C._POSIX_MEMORY_PROTECTION
	_POSIX_MESSAGE_PASSING              = C._POSIX_MESSAGE_PASSING
	_POSIX_MONOTONIC_CLOCK              = C._POSIX_MONOTONIC_CLOCK
	_POSIX_PRIORITIZED_IO               = C._POSIX_PRIORITIZED_IO
	_POSIX_PRIORITY_SCHEDULING          = C._POSIX_PRIORITY_SCHEDULING
	_POSIX_RAW_SOCKETS                  = C._POSIX_RAW_SOCKETS
	_POSIX_READER_WRITER_LOCKS          = C._POSIX_READER_WRITER_LOCKS
	_POSIX_REALTIME_SIGNALS             = C._POSIX_REALTIME_SIGNALS
	_POSIX_REGEXP                       = C._POSIX_REGEXP
	_POSIX_SAVED_IDS                    = C._POSIX_SAVED_IDS
	_POSIX_SEMAPHORES                   = C._POSIX_SEMAPHORES
	_POSIX_SHARED_MEMORY_OBJECTS        = C._POSIX_SHARED_MEMORY_OBJECTS
	_POSIX_SHELL                        = C._POSIX_SHELL
	_POSIX_SIGQUEUE_MAX                 = C._POSIX_SIGQUEUE_MAX
	_POSIX_SPAWN                        = C._POSIX_SPAWN
	_POSIX_SPIN_LOCKS                   = C._POSIX_SPIN_LOCKS
	_POSIX_SPORADIC_SERVER              = C._POSIX_SPORADIC_SERVER
	_POSIX_SYNCHRONIZED_IO              = C._POSIX_SYNCHRONIZED_IO
	_POSIX_THREAD_ATTR_STACKADDR        = C._POSIX_THREAD_ATTR_STACKADDR
	_POSIX_THREAD_ATTR_STACKSIZE        = C._POSIX_THREAD_ATTR_STACKSIZE
	_POSIX_THREAD_DESTRUCTOR_ITERATIONS = C._POSIX_THREAD_DESTRUCTOR_ITERATIONS
	_POSIX_THREAD_PRIO_INHERIT          = C._POSIX_THREAD_PRIO_INHERIT
	_POSIX_THREAD_PRIO_PROTECT          = C._POSIX_THREAD_PRIO_PROTECT
	_POSIX_THREAD_PRIORITY_SCHEDULING   = C._POSIX_THREAD_PRIORITY_SCHEDULING
	_POSIX_THREAD_PROCESS_SHARED        = C._POSIX_THREAD_PROCESS_SHARED
	_POSIX_THREAD_SAFE_FUNCTIONS        = C._POSIX_THREAD_SAFE_FUNCTIONS
	_POSIX_THREAD_SPORADIC_SERVER       = C._POSIX_THREAD_SPORADIC_SERVER
	_POSIX_THREADS                      = C._POSIX_THREADS
	_POSIX_TIMEOUTS                     = C._POSIX_TIMEOUTS
	_POSIX_TIMERS                       = C._POSIX_TIMERS
	_POSIX_TRACE                        = C._POSIX_TRACE
	_POSIX_TRACE_EVENT_FILTER           = C._POSIX_TRACE_EVENT_FILTER
	_POSIX_TRACE_INHERIT                = C._POSIX_TRACE_INHERIT
	_POSIX_TRACE_LOG                    = C._POSIX_TRACE_LOG
	_POSIX_TYPED_MEMORY_OBJECTS         = C._POSIX_TYPED_MEMORY_OBJECTS
	_POSIX_VERSION                      = C._POSIX_VERSION

	_POSIX_V7_ILP32_OFF32  = C._POSIX_V7_ILP32_OFF32
	_POSIX_V7_ILP32_OFFBIG = C._POSIX_V7_ILP32_OFFBIG
	_POSIX_V7_LP64_OFF64   = C._POSIX_V7_LP64_OFF64
	_POSIX_V7_LPBIG_OFFBIG = C._POSIX_V7_LPBIG_OFFBIG

	_POSIX_V6_ILP32_OFF32  = C._POSIX_V6_ILP32_OFF32
	_POSIX_V6_ILP32_OFFBIG = C._POSIX_V6_ILP32_OFFBIG
	_POSIX_V6_LP64_OFF64   = C._POSIX_V6_LP64_OFF64
	_POSIX_V6_LPBIG_OFFBIG = C._POSIX_V6_LPBIG_OFFBIG

	_POSIX2_C_BIND    = C._POSIX2_C_BIND
	_POSIX2_C_DEV     = C._POSIX2_C_DEV
	_POSIX2_C_VERSION = C._POSIX2_C_VERSION
	_POSIX2_CHAR_TERM = C._POSIX2_CHAR_TERM
	_POSIX2_LOCALEDEF = C._POSIX2_LOCALEDEF
	_POSIX2_SW_DEV    = C._POSIX2_SW_DEV
	_POSIX2_VERSION   = C._POSIX2_VERSION

	_XOPEN_ENH_I18N         = C._XOPEN_ENH_I18N
	_XOPEN_REALTIME         = C._XOPEN_REALTIME
	_XOPEN_REALTIME_THREADS = C._XOPEN_REALTIME_THREADS
	_XOPEN_SHM              = C._XOPEN_SHM
	_XOPEN_UNIX             = C._XOPEN_UNIX
	_XOPEN_VERSION          = C._XOPEN_VERSION
	_XOPEN_XCU_VERSION      = C._XOPEN_XCU_VERSION
)
