// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/spanner/admin/instance/v1/spanner_instance_admin.proto

package instance

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	v1 "google.golang.org/genproto/googleapis/iam/v1"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Indicates the type of replica.  See the [replica types
// documentation](https://cloud.google.com/spanner/docs/replication#replica_types)
// for more details.
type ReplicaInfo_ReplicaType int32

const (
	// Not specified.
	ReplicaInfo_TYPE_UNSPECIFIED ReplicaInfo_ReplicaType = 0
	// Read-write replicas support both reads and writes. These replicas:
	//
	// * Maintain a full copy of your data.
	// * Serve reads.
	// * Can vote whether to commit a write.
	// * Participate in leadership election.
	// * Are eligible to become a leader.
	ReplicaInfo_READ_WRITE ReplicaInfo_ReplicaType = 1
	// Read-only replicas only support reads (not writes). Read-only replicas:
	//
	// * Maintain a full copy of your data.
	// * Serve reads.
	// * Do not participate in voting to commit writes.
	// * Are not eligible to become a leader.
	ReplicaInfo_READ_ONLY ReplicaInfo_ReplicaType = 2
	// Witness replicas don't support reads but do participate in voting to
	// commit writes. Witness replicas:
	//
	// * Do not maintain a full copy of data.
	// * Do not serve reads.
	// * Vote whether to commit writes.
	// * Participate in leader election but are not eligible to become leader.
	ReplicaInfo_WITNESS ReplicaInfo_ReplicaType = 3
)

var ReplicaInfo_ReplicaType_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "READ_WRITE",
	2: "READ_ONLY",
	3: "WITNESS",
}

var ReplicaInfo_ReplicaType_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"READ_WRITE":       1,
	"READ_ONLY":        2,
	"WITNESS":          3,
}

func (x ReplicaInfo_ReplicaType) String() string {
	return proto.EnumName(ReplicaInfo_ReplicaType_name, int32(x))
}

func (ReplicaInfo_ReplicaType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_3837da4dfb7336ac, []int{0, 0}
}

// Indicates the current state of the instance.
type Instance_State int32

const (
	// Not specified.
	Instance_STATE_UNSPECIFIED Instance_State = 0
	// The instance is still being created. Resources may not be
	// available yet, and operations such as database creation may not
	// work.
	Instance_CREATING Instance_State = 1
	// The instance is fully created and ready to do work such as
	// creating databases.
	Instance_READY Instance_State = 2
)

var Instance_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "CREATING",
	2: "READY",
}

var Instance_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"CREATING":          1,
	"READY":             2,
}

func (x Instance_State) String() string {
	return proto.EnumName(Instance_State_name, int32(x))
}

func (Instance_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_3837da4dfb7336ac, []int{2, 0}
}

type ReplicaInfo struct {
	// The location of the serving resources, e.g. "us-central1".
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// The type of replica.
	Type ReplicaInfo_ReplicaType `protobuf:"varint,2,opt,name=type,proto3,enum=google.spanner.admin.instance.v1.ReplicaInfo_ReplicaType" json:"type,omitempty"`
	// If true, this location is designated as the default leader location where
	// leader replicas are placed. See the [region types
	// documentation](https://cloud.google.com/spanner/docs/instances#region_types)
	// for more details.
	DefaultLeaderLocation bool     `protobuf:"varint,3,opt,name=default_leader_location,json=defaultLeaderLocation,proto3" json:"default_leader_location,omitempty"`
	XXX_NoUnkeyedLiteral  struct{} `json:"-"`
	XXX_unrecognized      []byte   `json:"-"`
	XXX_sizecache         int32    `json:"-"`
}

func (m *ReplicaInfo) Reset()         { *m = ReplicaInfo{} }
func (m *ReplicaInfo) String() string { return proto.CompactTextString(m) }
func (*ReplicaInfo) ProtoMessage()    {}
func (*ReplicaInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_3837da4dfb7336ac, []int{0}
}

func (m *ReplicaInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReplicaInfo.Unmarshal(m, b)
}
func (m *ReplicaInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReplicaInfo.Marshal(b, m, deterministic)
}
func (m *ReplicaInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplicaInfo.Merge(m, src)
}
func (m *ReplicaInfo) XXX_Size() int {
	return xxx_messageInfo_ReplicaInfo.Size(m)
}
func (m *ReplicaInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplicaInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ReplicaInfo proto.InternalMessageInfo

func (m *ReplicaInfo) GetLocation() string {
	if m != nil {
		return m.Location
	}
	return ""
}

func (m *ReplicaInfo) GetType() ReplicaInfo_ReplicaType {
	if m != nil {
		return m.Type
	}
	return ReplicaInfo_TYPE_UNSPECIFIED
}

func (m *ReplicaInfo) GetDefaultLeaderLocation() bool {
	if m != nil {
		return m.DefaultLeaderLocation
	}
	return false
}

// A possible configuration for a Cloud Spanner instance. Configurations
// define the geographic placement of nodes and their replication.
type InstanceConfig struct {
	// A unique identifier for the instance configuration.  Values
	// are of the form
	// `projects/<project>/instanceConfigs/[a-z][-a-z0-9]*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The name of this instance configuration as it appears in UIs.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The geographic placement of nodes in this instance configuration and their
	// replication properties.
	Replicas             []*ReplicaInfo `protobuf:"bytes,3,rep,name=replicas,proto3" json:"replicas,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *InstanceConfig) Reset()         { *m = InstanceConfig{} }
func (m *InstanceConfig) String() string { return proto.CompactTextString(m) }
func (*InstanceConfig) ProtoMessage()    {}
func (*InstanceConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_3837da4dfb7336ac, []int{1}
}

func (m *InstanceConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InstanceConfig.Unmarshal(m, b)
}
func (m *InstanceConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InstanceConfig.Marshal(b, m, deterministic)
}
func (m *InstanceConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstanceConfig.Merge(m, src)
}
func (m *InstanceConfig) XXX_Size() int {
	return xxx_messageInfo_InstanceConfig.Size(m)
}
func (m *InstanceConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_InstanceConfig.DiscardUnknown(m)
}

var xxx_messageInfo_InstanceConfig proto.InternalMessageInfo

func (m *InstanceConfig) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *InstanceConfig) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *InstanceConfig) GetReplicas() []*ReplicaInfo {
	if m != nil {
		return m.Replicas
	}
	return nil
}

// An isolated set of Cloud Spanner resources on which databases can be hosted.
type Instance struct {
	// Required. A unique identifier for the instance, which cannot be changed
	// after the instance is created. Values are of the form
	// `projects/<project>/instances/[a-z][-a-z0-9]*[a-z0-9]`. The final
	// segment of the name must be between 2 and 64 characters in length.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The name of the instance's configuration. Values are of the form
	// `projects/<project>/instanceConfigs/<configuration>`. See
	// also [InstanceConfig][google.spanner.admin.instance.v1.InstanceConfig] and
	// [ListInstanceConfigs][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs].
	Config string `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	// Required. The descriptive name for this instance as it appears in UIs.
	// Must be unique per project and between 4 and 30 characters in length.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. The number of nodes allocated to this instance. This may be zero
	// in API responses for instances that are not yet in state `READY`.
	//
	// See [the
	// documentation](https://cloud.google.com/spanner/docs/instances#node_count)
	// for more information about nodes.
	NodeCount int32 `protobuf:"varint,5,opt,name=node_count,json=nodeCount,proto3" json:"node_count,omitempty"`
	// Output only. The current instance state. For
	// [CreateInstance][google.spanner.admin.instance.v1.InstanceAdmin.CreateInstance], the state must be
	// either omitted or set to `CREATING`. For
	// [UpdateInstance][google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstance], the state must be
	// either omitted or set to `READY`.
	State Instance_State `protobuf:"varint,6,opt,name=state,proto3,enum=google.spanner.admin.instance.v1.Instance_State" json:"state,omitempty"`
	// Cloud Labels are a flexible and lightweight mechanism for organizing cloud
	// resources into groups that reflect a customer's organizational needs and
	// deployment strategies. Cloud Labels can be used to filter collections of
	// resources. They can be used to control how resource metrics are aggregated.
	// And they can be used as arguments to policy management rules (e.g. route,
	// firewall, load balancing, etc.).
	//
	//  * Label keys must be between 1 and 63 characters long and must conform to
	//    the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
	//  * Label values must be between 0 and 63 characters long and must conform
	//    to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
	//  * No more than 64 labels can be associated with a given resource.
	//
	// See https://goo.gl/xmQnxf for more information on and examples of labels.
	//
	// If you plan to use labels in your own code, please note that additional
	// characters may be allowed in the future. And so you are advised to use an
	// internal label representation, such as JSON, which doesn't rely upon
	// specific characters being disallowed.  For example, representing labels
	// as the string:  name + "_" + value  would prove problematic if we were to
	// allow "_" in a future release.
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The endpoint URIs based on the instance config.
	// For example, instances located in a specific cloud region (or multi region)
	// such as nam3, would have a nam3 specific endpoint URI.
	// This URI is to be used implictly by SDK clients, with fallback to default
	// URI. These endpoints are intended to optimize the network routing between
	// the client and the instance's serving resources.
	// If multiple endpoints are present, client may establish connections using
	// any of the given URIs.
	EndpointUris         []string `protobuf:"bytes,8,rep,name=endpoint_uris,json=endpointUris,proto3" json:"endpoint_uris,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Instance) Reset()         { *m = Instance{} }
func (m *Instance) String() string { return proto.CompactTextString(m) }
func (*Instance) ProtoMessage()    {}
func (*Instance) Descriptor() ([]byte, []int) {
	return fileDescriptor_3837da4dfb7336ac, []int{2}
}

func (m *Instance) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Instance.Unmarshal(m, b)
}
func (m *Instance) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Instance.Marshal(b, m, deterministic)
}
func (m *Instance) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Instance.Merge(m, src)
}
func (m *Instance) XXX_Size() int {
	return xxx_messageInfo_Instance.Size(m)
}
func (m *Instance) XXX_DiscardUnknown() {
	xxx_messageInfo_Instance.DiscardUnknown(m)
}

var xxx_messageInfo_Instance proto.InternalMessageInfo

func (m *Instance) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Instance) GetConfig() string {
	if m != nil {
		return m.Config
	}
	return ""
}

func (m *Instance) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Instance) GetNodeCount() int32 {
	if m != nil {
		return m.NodeCount
	}
	return 0
}

func (m *Instance) GetState() Instance_State {
	if m != nil {
		return m.State
	}
	return Instance_STATE_UNSPECIFIED
}

func (m *Instance) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Instance) GetEndpointUris() []string {
	if m != nil {
		return m.EndpointUris
	}
	return nil
}

// The request for [ListInstanceConfigs][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs].
type ListInstanceConfigsRequest struct {
	// Required. The name of the project for which a list of supported instance
	// configurations is requested. Values are of the form
	// `projects/<project>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Number of instance configurations to be returned in the response. If 0 or
	// less, defaults to the server's maximum allowed page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If non-empty, `page_token` should contain a
	// [next_page_token][google.spanner.admin.instance.v1.ListInstanceConfigsResponse.next_page_token]
	// from a previous [ListInstanceConfigsResponse][google.spanner.admin.instance.v1.ListInstanceConfigsResponse].
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListInstanceConfigsRequest) Reset()         { *m = ListInstanceConfigsRequest{} }
func (m *ListInstanceConfigsRequest) String() string { return proto.CompactTextString(m) }
func (*ListInstanceConfigsRequest) ProtoMessage()    {}
func (*ListInstanceConfigsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3837da4dfb7336ac, []int{3}
}

func (m *ListInstanceConfigsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInstanceConfigsRequest.Unmarshal(m, b)
}
func (m *ListInstanceConfigsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInstanceConfigsRequest.Marshal(b, m, deterministic)
}
func (m *ListInstanceConfigsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInstanceConfigsRequest.Merge(m, src)
}
func (m *ListInstanceConfigsRequest) XXX_Size() int {
	return xxx_messageInfo_ListInstanceConfigsRequest.Size(m)
}
func (m *ListInstanceConfigsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInstanceConfigsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListInstanceConfigsRequest proto.InternalMessageInfo

func (m *ListInstanceConfigsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListInstanceConfigsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListInstanceConfigsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The response for [ListInstanceConfigs][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs].
type ListInstanceConfigsResponse struct {
	// The list of requested instance configurations.
	InstanceConfigs []*InstanceConfig `protobuf:"bytes,1,rep,name=instance_configs,json=instanceConfigs,proto3" json:"instance_configs,omitempty"`
	// `next_page_token` can be sent in a subsequent
	// [ListInstanceConfigs][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs] call to
	// fetch more of the matching instance configurations.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListInstanceConfigsResponse) Reset()         { *m = ListInstanceConfigsResponse{} }
func (m *ListInstanceConfigsResponse) String() string { return proto.CompactTextString(m) }
func (*ListInstanceConfigsResponse) ProtoMessage()    {}
func (*ListInstanceConfigsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3837da4dfb7336ac, []int{4}
}

func (m *ListInstanceConfigsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInstanceConfigsResponse.Unmarshal(m, b)
}
func (m *ListInstanceConfigsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInstanceConfigsResponse.Marshal(b, m, deterministic)
}
func (m *ListInstanceConfigsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInstanceConfigsResponse.Merge(m, src)
}
func (m *ListInstanceConfigsResponse) XXX_Size() int {
	return xxx_messageInfo_ListInstanceConfigsResponse.Size(m)
}
func (m *ListInstanceConfigsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInstanceConfigsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListInstanceConfigsResponse proto.InternalMessageInfo

func (m *ListInstanceConfigsResponse) GetInstanceConfigs() []*InstanceConfig {
	if m != nil {
		return m.InstanceConfigs
	}
	return nil
}

func (m *ListInstanceConfigsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request for
// [GetInstanceConfigRequest][google.spanner.admin.instance.v1.InstanceAdmin.GetInstanceConfig].
type GetInstanceConfigRequest struct {
	// Required. The name of the requested instance configuration. Values are of
	// the form `projects/<project>/instanceConfigs/<config>`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetInstanceConfigRequest) Reset()         { *m = GetInstanceConfigRequest{} }
func (m *GetInstanceConfigRequest) String() string { return proto.CompactTextString(m) }
func (*GetInstanceConfigRequest) ProtoMessage()    {}
func (*GetInstanceConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3837da4dfb7336ac, []int{5}
}

func (m *GetInstanceConfigRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetInstanceConfigRequest.Unmarshal(m, b)
}
func (m *GetInstanceConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetInstanceConfigRequest.Marshal(b, m, deterministic)
}
func (m *GetInstanceConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetInstanceConfigRequest.Merge(m, src)
}
func (m *GetInstanceConfigRequest) XXX_Size() int {
	return xxx_messageInfo_GetInstanceConfigRequest.Size(m)
}
func (m *GetInstanceConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetInstanceConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetInstanceConfigRequest proto.InternalMessageInfo

func (m *GetInstanceConfigRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request for [GetInstance][google.spanner.admin.instance.v1.InstanceAdmin.GetInstance].
type GetInstanceRequest struct {
	// Required. The name of the requested instance. Values are of the form
	// `projects/<project>/instances/<instance>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If field_mask is present, specifies the subset of [][Instance] fields that
	// should be returned.
	// If absent, all [][Instance] fields are returned.
	FieldMask            *field_mask.FieldMask `protobuf:"bytes,2,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *GetInstanceRequest) Reset()         { *m = GetInstanceRequest{} }
func (m *GetInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*GetInstanceRequest) ProtoMessage()    {}
func (*GetInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3837da4dfb7336ac, []int{6}
}

func (m *GetInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetInstanceRequest.Unmarshal(m, b)
}
func (m *GetInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetInstanceRequest.Marshal(b, m, deterministic)
}
func (m *GetInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetInstanceRequest.Merge(m, src)
}
func (m *GetInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_GetInstanceRequest.Size(m)
}
func (m *GetInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetInstanceRequest proto.InternalMessageInfo

func (m *GetInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetInstanceRequest) GetFieldMask() *field_mask.FieldMask {
	if m != nil {
		return m.FieldMask
	}
	return nil
}

// The request for [CreateInstance][google.spanner.admin.instance.v1.InstanceAdmin.CreateInstance].
type CreateInstanceRequest struct {
	// Required. The name of the project in which to create the instance. Values
	// are of the form `projects/<project>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID of the instance to create.  Valid identifiers are of the
	// form `[a-z][-a-z0-9]*[a-z0-9]` and must be between 2 and 64 characters in
	// length.
	InstanceId string `protobuf:"bytes,2,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// Required. The instance to create.  The name may be omitted, but if
	// specified must be `<parent>/instances/<instance_id>`.
	Instance             *Instance `protobuf:"bytes,3,opt,name=instance,proto3" json:"instance,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *CreateInstanceRequest) Reset()         { *m = CreateInstanceRequest{} }
func (m *CreateInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*CreateInstanceRequest) ProtoMessage()    {}
func (*CreateInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3837da4dfb7336ac, []int{7}
}

func (m *CreateInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateInstanceRequest.Unmarshal(m, b)
}
func (m *CreateInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateInstanceRequest.Marshal(b, m, deterministic)
}
func (m *CreateInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateInstanceRequest.Merge(m, src)
}
func (m *CreateInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_CreateInstanceRequest.Size(m)
}
func (m *CreateInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateInstanceRequest proto.InternalMessageInfo

func (m *CreateInstanceRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateInstanceRequest) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

func (m *CreateInstanceRequest) GetInstance() *Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

// The request for [ListInstances][google.spanner.admin.instance.v1.InstanceAdmin.ListInstances].
type ListInstancesRequest struct {
	// Required. The name of the project for which a list of instances is
	// requested. Values are of the form `projects/<project>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Number of instances to be returned in the response. If 0 or less, defaults
	// to the server's maximum allowed page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If non-empty, `page_token` should contain a
	// [next_page_token][google.spanner.admin.instance.v1.ListInstancesResponse.next_page_token] from a
	// previous [ListInstancesResponse][google.spanner.admin.instance.v1.ListInstancesResponse].
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// An expression for filtering the results of the request. Filter rules are
	// case insensitive. The fields eligible for filtering are:
	//
	//   * `name`
	//   * `display_name`
	//   * `labels.key` where key is the name of a label
	//
	// Some examples of using filters are:
	//
	//   * `name:*` --> The instance has a name.
	//   * `name:Howl` --> The instance's name contains the string "howl".
	//   * `name:HOWL` --> Equivalent to above.
	//   * `NAME:howl` --> Equivalent to above.
	//   * `labels.env:*` --> The instance has the label "env".
	//   * `labels.env:dev` --> The instance has the label "env" and the value of
	//                        the label contains the string "dev".
	//   * `name:howl labels.env:dev` --> The instance's name contains "howl" and
	//                                  it has the label "env" with its value
	//                                  containing "dev".
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListInstancesRequest) Reset()         { *m = ListInstancesRequest{} }
func (m *ListInstancesRequest) String() string { return proto.CompactTextString(m) }
func (*ListInstancesRequest) ProtoMessage()    {}
func (*ListInstancesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3837da4dfb7336ac, []int{8}
}

func (m *ListInstancesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInstancesRequest.Unmarshal(m, b)
}
func (m *ListInstancesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInstancesRequest.Marshal(b, m, deterministic)
}
func (m *ListInstancesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInstancesRequest.Merge(m, src)
}
func (m *ListInstancesRequest) XXX_Size() int {
	return xxx_messageInfo_ListInstancesRequest.Size(m)
}
func (m *ListInstancesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInstancesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListInstancesRequest proto.InternalMessageInfo

func (m *ListInstancesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListInstancesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListInstancesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListInstancesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

// The response for [ListInstances][google.spanner.admin.instance.v1.InstanceAdmin.ListInstances].
type ListInstancesResponse struct {
	// The list of requested instances.
	Instances []*Instance `protobuf:"bytes,1,rep,name=instances,proto3" json:"instances,omitempty"`
	// `next_page_token` can be sent in a subsequent
	// [ListInstances][google.spanner.admin.instance.v1.InstanceAdmin.ListInstances] call to fetch more
	// of the matching instances.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListInstancesResponse) Reset()         { *m = ListInstancesResponse{} }
func (m *ListInstancesResponse) String() string { return proto.CompactTextString(m) }
func (*ListInstancesResponse) ProtoMessage()    {}
func (*ListInstancesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3837da4dfb7336ac, []int{9}
}

func (m *ListInstancesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInstancesResponse.Unmarshal(m, b)
}
func (m *ListInstancesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInstancesResponse.Marshal(b, m, deterministic)
}
func (m *ListInstancesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInstancesResponse.Merge(m, src)
}
func (m *ListInstancesResponse) XXX_Size() int {
	return xxx_messageInfo_ListInstancesResponse.Size(m)
}
func (m *ListInstancesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInstancesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListInstancesResponse proto.InternalMessageInfo

func (m *ListInstancesResponse) GetInstances() []*Instance {
	if m != nil {
		return m.Instances
	}
	return nil
}

func (m *ListInstancesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request for [UpdateInstance][google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstance].
type UpdateInstanceRequest struct {
	// Required. The instance to update, which must always include the instance
	// name.  Otherwise, only fields mentioned in [][google.spanner.admin.instance.v1.UpdateInstanceRequest.field_mask] need be included.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Required. A mask specifying which fields in [][google.spanner.admin.instance.v1.UpdateInstanceRequest.instance] should be updated.
	// The field mask must always be specified; this prevents any future fields in
	// [][google.spanner.admin.instance.v1.Instance] from being erased accidentally by clients that do not know
	// about them.
	FieldMask            *field_mask.FieldMask `protobuf:"bytes,2,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateInstanceRequest) Reset()         { *m = UpdateInstanceRequest{} }
func (m *UpdateInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateInstanceRequest) ProtoMessage()    {}
func (*UpdateInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3837da4dfb7336ac, []int{10}
}

func (m *UpdateInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateInstanceRequest.Unmarshal(m, b)
}
func (m *UpdateInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateInstanceRequest.Marshal(b, m, deterministic)
}
func (m *UpdateInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateInstanceRequest.Merge(m, src)
}
func (m *UpdateInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateInstanceRequest.Size(m)
}
func (m *UpdateInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateInstanceRequest proto.InternalMessageInfo

func (m *UpdateInstanceRequest) GetInstance() *Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

func (m *UpdateInstanceRequest) GetFieldMask() *field_mask.FieldMask {
	if m != nil {
		return m.FieldMask
	}
	return nil
}

// The request for [DeleteInstance][google.spanner.admin.instance.v1.InstanceAdmin.DeleteInstance].
type DeleteInstanceRequest struct {
	// Required. The name of the instance to be deleted. Values are of the form
	// `projects/<project>/instances/<instance>`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteInstanceRequest) Reset()         { *m = DeleteInstanceRequest{} }
func (m *DeleteInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteInstanceRequest) ProtoMessage()    {}
func (*DeleteInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3837da4dfb7336ac, []int{11}
}

func (m *DeleteInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteInstanceRequest.Unmarshal(m, b)
}
func (m *DeleteInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteInstanceRequest.Marshal(b, m, deterministic)
}
func (m *DeleteInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteInstanceRequest.Merge(m, src)
}
func (m *DeleteInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteInstanceRequest.Size(m)
}
func (m *DeleteInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteInstanceRequest proto.InternalMessageInfo

func (m *DeleteInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Metadata type for the operation returned by
// [CreateInstance][google.spanner.admin.instance.v1.InstanceAdmin.CreateInstance].
type CreateInstanceMetadata struct {
	// The instance being created.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// The time at which the
	// [CreateInstance][google.spanner.admin.instance.v1.InstanceAdmin.CreateInstance] request was
	// received.
	StartTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time at which this operation was cancelled. If set, this operation is
	// in the process of undoing itself (which is guaranteed to succeed) and
	// cannot be cancelled again.
	CancelTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=cancel_time,json=cancelTime,proto3" json:"cancel_time,omitempty"`
	// The time at which this operation failed or was completed successfully.
	EndTime              *timestamp.Timestamp `protobuf:"bytes,4,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *CreateInstanceMetadata) Reset()         { *m = CreateInstanceMetadata{} }
func (m *CreateInstanceMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateInstanceMetadata) ProtoMessage()    {}
func (*CreateInstanceMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_3837da4dfb7336ac, []int{12}
}

func (m *CreateInstanceMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateInstanceMetadata.Unmarshal(m, b)
}
func (m *CreateInstanceMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateInstanceMetadata.Marshal(b, m, deterministic)
}
func (m *CreateInstanceMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateInstanceMetadata.Merge(m, src)
}
func (m *CreateInstanceMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateInstanceMetadata.Size(m)
}
func (m *CreateInstanceMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateInstanceMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateInstanceMetadata proto.InternalMessageInfo

func (m *CreateInstanceMetadata) GetInstance() *Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

func (m *CreateInstanceMetadata) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *CreateInstanceMetadata) GetCancelTime() *timestamp.Timestamp {
	if m != nil {
		return m.CancelTime
	}
	return nil
}

func (m *CreateInstanceMetadata) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

// Metadata type for the operation returned by
// [UpdateInstance][google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstance].
type UpdateInstanceMetadata struct {
	// The desired end state of the update.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// The time at which [UpdateInstance][google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstance]
	// request was received.
	StartTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time at which this operation was cancelled. If set, this operation is
	// in the process of undoing itself (which is guaranteed to succeed) and
	// cannot be cancelled again.
	CancelTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=cancel_time,json=cancelTime,proto3" json:"cancel_time,omitempty"`
	// The time at which this operation failed or was completed successfully.
	EndTime              *timestamp.Timestamp `protobuf:"bytes,4,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *UpdateInstanceMetadata) Reset()         { *m = UpdateInstanceMetadata{} }
func (m *UpdateInstanceMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateInstanceMetadata) ProtoMessage()    {}
func (*UpdateInstanceMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_3837da4dfb7336ac, []int{13}
}

func (m *UpdateInstanceMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateInstanceMetadata.Unmarshal(m, b)
}
func (m *UpdateInstanceMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateInstanceMetadata.Marshal(b, m, deterministic)
}
func (m *UpdateInstanceMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateInstanceMetadata.Merge(m, src)
}
func (m *UpdateInstanceMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateInstanceMetadata.Size(m)
}
func (m *UpdateInstanceMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateInstanceMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateInstanceMetadata proto.InternalMessageInfo

func (m *UpdateInstanceMetadata) GetInstance() *Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

func (m *UpdateInstanceMetadata) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *UpdateInstanceMetadata) GetCancelTime() *timestamp.Timestamp {
	if m != nil {
		return m.CancelTime
	}
	return nil
}

func (m *UpdateInstanceMetadata) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.spanner.admin.instance.v1.ReplicaInfo_ReplicaType", ReplicaInfo_ReplicaType_name, ReplicaInfo_ReplicaType_value)
	proto.RegisterEnum("google.spanner.admin.instance.v1.Instance_State", Instance_State_name, Instance_State_value)
	proto.RegisterType((*ReplicaInfo)(nil), "google.spanner.admin.instance.v1.ReplicaInfo")
	proto.RegisterType((*InstanceConfig)(nil), "google.spanner.admin.instance.v1.InstanceConfig")
	proto.RegisterType((*Instance)(nil), "google.spanner.admin.instance.v1.Instance")
	proto.RegisterMapType((map[string]string)(nil), "google.spanner.admin.instance.v1.Instance.LabelsEntry")
	proto.RegisterType((*ListInstanceConfigsRequest)(nil), "google.spanner.admin.instance.v1.ListInstanceConfigsRequest")
	proto.RegisterType((*ListInstanceConfigsResponse)(nil), "google.spanner.admin.instance.v1.ListInstanceConfigsResponse")
	proto.RegisterType((*GetInstanceConfigRequest)(nil), "google.spanner.admin.instance.v1.GetInstanceConfigRequest")
	proto.RegisterType((*GetInstanceRequest)(nil), "google.spanner.admin.instance.v1.GetInstanceRequest")
	proto.RegisterType((*CreateInstanceRequest)(nil), "google.spanner.admin.instance.v1.CreateInstanceRequest")
	proto.RegisterType((*ListInstancesRequest)(nil), "google.spanner.admin.instance.v1.ListInstancesRequest")
	proto.RegisterType((*ListInstancesResponse)(nil), "google.spanner.admin.instance.v1.ListInstancesResponse")
	proto.RegisterType((*UpdateInstanceRequest)(nil), "google.spanner.admin.instance.v1.UpdateInstanceRequest")
	proto.RegisterType((*DeleteInstanceRequest)(nil), "google.spanner.admin.instance.v1.DeleteInstanceRequest")
	proto.RegisterType((*CreateInstanceMetadata)(nil), "google.spanner.admin.instance.v1.CreateInstanceMetadata")
	proto.RegisterType((*UpdateInstanceMetadata)(nil), "google.spanner.admin.instance.v1.UpdateInstanceMetadata")
}

func init() {
	proto.RegisterFile("google/spanner/admin/instance/v1/spanner_instance_admin.proto", fileDescriptor_3837da4dfb7336ac)
}

var fileDescriptor_3837da4dfb7336ac = []byte{
	// 1683 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe4, 0x58, 0x4d, 0x6c, 0x23, 0x49,
	0x15, 0xa6, 0xed, 0x24, 0x63, 0x3f, 0x27, 0x19, 0x6f, 0x6d, 0x92, 0xf5, 0x3a, 0x2c, 0xeb, 0xe9,
	0x59, 0x26, 0x19, 0x93, 0xb8, 0x37, 0xde, 0x25, 0x99, 0x64, 0x08, 0x52, 0x27, 0xe3, 0x64, 0xcc,
	0xe6, 0x4f, 0x6d, 0xcf, 0xae, 0x66, 0xc9, 0xca, 0x54, 0xec, 0xb2, 0xa7, 0x49, 0xff, 0xd1, 0x5d,
	0xce, 0x6c, 0x76, 0x94, 0x03, 0xdc, 0x90, 0x90, 0x38, 0xec, 0x0d, 0xc1, 0x01, 0xb4, 0x5c, 0xb8,
	0x81, 0x90, 0x10, 0x27, 0x4e, 0x5c, 0x46, 0x9c, 0xe0, 0x80, 0x94, 0x0b, 0x7b, 0xe0, 0x34, 0x67,
	0x4e, 0x73, 0x42, 0x5d, 0x5d, 0x65, 0xb7, 0x7f, 0x32, 0xb6, 0x99, 0x39, 0x20, 0xed, 0xad, 0xaa,
	0xde, 0x4f, 0x7d, 0xef, 0xab, 0xf7, 0x5e, 0x55, 0x37, 0x6c, 0x36, 0x6c, 0xbb, 0x61, 0x10, 0xc5,
	0x73, 0xb0, 0x65, 0x11, 0x57, 0xc1, 0x35, 0x53, 0xb7, 0x14, 0xdd, 0xf2, 0x28, 0xb6, 0xaa, 0x44,
	0x39, 0x5b, 0x11, 0x92, 0x8a, 0x58, 0xab, 0x30, 0x95, 0x9c, 0xe3, 0xda, 0xd4, 0x46, 0x99, 0xc0,
	0x3c, 0xc7, 0x95, 0x72, 0x81, 0x4c, 0xa8, 0xe6, 0xce, 0x56, 0xd2, 0x5f, 0xe7, 0x1b, 0x60, 0x47,
	0x57, 0xb0, 0x65, 0xd9, 0x14, 0x53, 0xdd, 0xb6, 0xbc, 0xc0, 0x3e, 0xfd, 0x46, 0x48, 0x5a, 0x35,
	0x74, 0x62, 0x51, 0x2e, 0x78, 0x3b, 0x24, 0xa8, 0xeb, 0xc4, 0xa8, 0x55, 0x4e, 0xc8, 0x23, 0x7c,
	0xa6, 0xdb, 0x2e, 0x57, 0x78, 0x33, 0xa4, 0xe0, 0x12, 0xcf, 0x6e, 0xba, 0x55, 0xc2, 0x45, 0xdf,
	0xe0, 0x22, 0x1d, 0x9b, 0x7e, 0x00, 0x3a, 0x36, 0x2b, 0x8e, 0x6d, 0xe8, 0xd5, 0x73, 0x2e, 0x4f,
	0x77, 0xca, 0x3b, 0x64, 0x37, 0xb9, 0xcc, 0xb0, 0xad, 0x86, 0xdb, 0xb4, 0x2c, 0xdd, 0x6a, 0x28,
	0xb6, 0x43, 0xdc, 0x0e, 0xd4, 0xf3, 0x5c, 0x89, 0xcd, 0x4e, 0x9a, 0x75, 0x85, 0x98, 0x0e, 0x15,
	0x1e, 0x32, 0xdd, 0xc2, 0x00, 0xbe, 0x89, 0xbd, 0xd3, 0xae, 0xd8, 0x5a, 0x1a, 0x54, 0x37, 0x89,
	0x47, 0xb1, 0xe9, 0x04, 0x0a, 0xf2, 0x8f, 0x23, 0x90, 0xd0, 0x88, 0x63, 0xe8, 0x55, 0x5c, 0xb4,
	0xea, 0x36, 0x4a, 0x43, 0xcc, 0xb0, 0xab, 0x0c, 0x42, 0x4a, 0xca, 0x48, 0x8b, 0x71, 0xad, 0x35,
	0x47, 0xfb, 0x30, 0x46, 0xcf, 0x1d, 0x92, 0x8a, 0x64, 0xa4, 0xc5, 0xe9, 0xfc, 0x7a, 0x6e, 0xd0,
	0x81, 0xe4, 0x42, 0x8e, 0xc5, 0xb8, 0x7c, 0xee, 0x10, 0x8d, 0xb9, 0x41, 0xab, 0xf0, 0x46, 0x8d,
	0xd4, 0x71, 0xd3, 0xa0, 0x15, 0x83, 0xe0, 0x1a, 0x71, 0x2b, 0xad, 0x9d, 0xa3, 0x19, 0x69, 0x31,
	0xa6, 0xcd, 0x72, 0xf1, 0x1e, 0x93, 0xee, 0x71, 0xa1, 0x7c, 0xd8, 0x42, 0xec, 0x3b, 0x43, 0x33,
	0x90, 0x2c, 0x3f, 0x3c, 0x2a, 0x54, 0x1e, 0x1c, 0x94, 0x8e, 0x0a, 0xdb, 0xc5, 0x9d, 0x62, 0xe1,
	0x5e, 0xf2, 0x6b, 0x68, 0x1a, 0x40, 0x2b, 0xa8, 0xf7, 0x2a, 0x1f, 0x69, 0xc5, 0x72, 0x21, 0x29,
	0xa1, 0x29, 0x88, 0xb3, 0xf9, 0xe1, 0xc1, 0xde, 0xc3, 0x64, 0x04, 0x25, 0xe0, 0xda, 0x47, 0xc5,
	0xf2, 0x41, 0xa1, 0x54, 0x4a, 0x46, 0xe5, 0xff, 0x48, 0x30, 0x5d, 0xe4, 0xb0, 0xb7, 0x6d, 0xab,
	0xae, 0x37, 0x10, 0x82, 0x31, 0x0b, 0x9b, 0x84, 0x53, 0xc0, 0xc6, 0xe8, 0x06, 0x4c, 0xd6, 0x74,
	0xcf, 0x31, 0xf0, 0x79, 0x85, 0xc9, 0x22, 0x4c, 0x96, 0xe0, 0x6b, 0x07, 0xbe, 0x4a, 0x11, 0x62,
	0x6e, 0x00, 0xcd, 0x4b, 0x45, 0x33, 0xd1, 0xc5, 0x44, 0x7e, 0x79, 0x24, 0x96, 0xb4, 0x96, 0xf9,
	0xc6, 0x0f, 0x9e, 0xa9, 0x9f, 0xc0, 0x37, 0x85, 0x55, 0xe0, 0x04, 0x3b, 0xba, 0x97, 0xab, 0xda,
	0xa6, 0xd2, 0x85, 0xf6, 0x7d, 0xc7, 0xb5, 0x7f, 0x48, 0xaa, 0xd4, 0x53, 0x9e, 0xf0, 0xd1, 0x45,
	0xab, 0xae, 0x02, 0x15, 0x4f, 0x79, 0xd2, 0x2a, 0xaa, 0x2a, 0x5b, 0xb9, 0x90, 0xbf, 0x18, 0x83,
	0x98, 0x70, 0xd4, 0x37, 0xe0, 0x2d, 0x98, 0x08, 0x74, 0x83, 0x50, 0xb7, 0xb2, 0xcf, 0xd5, 0x85,
	0x21, 0x21, 0x69, 0xdc, 0xb2, 0x87, 0xb4, 0x68, 0x2f, 0x69, 0x6f, 0x01, 0x58, 0x76, 0xcd, 0xc7,
	0xd5, 0xb4, 0x68, 0x6a, 0x3c, 0x23, 0x2d, 0x8e, 0x6b, 0x71, 0x7f, 0x65, 0xdb, 0x5f, 0x40, 0x3b,
	0x30, 0xee, 0x51, 0x4c, 0x49, 0x6a, 0x82, 0xa5, 0xdd, 0xbb, 0x83, 0x09, 0x15, 0x50, 0x72, 0x25,
	0xdf, 0x4e, 0x0b, 0xcc, 0xd1, 0x01, 0x4c, 0x18, 0xf8, 0x84, 0x18, 0x5e, 0xea, 0x1a, 0x3b, 0x99,
	0xd5, 0x11, 0x1c, 0xed, 0x31, 0xc3, 0x82, 0x45, 0xdd, 0x73, 0x8d, 0x7b, 0x41, 0x37, 0x61, 0x8a,
	0x58, 0x35, 0xc7, 0xd6, 0x2d, 0x5a, 0x69, 0xba, 0xba, 0x97, 0x8a, 0x65, 0xa2, 0x8b, 0x71, 0x6d,
	0x52, 0x2c, 0x3e, 0x70, 0x75, 0x2f, 0xbd, 0x0e, 0x89, 0x90, 0x2d, 0x4a, 0x42, 0xf4, 0x94, 0x9c,
	0x73, 0x92, 0xfd, 0x21, 0x9a, 0x81, 0xf1, 0x33, 0x6c, 0x34, 0x45, 0x36, 0x05, 0x93, 0x8d, 0xc8,
	0x1d, 0x49, 0x5e, 0x83, 0x71, 0x86, 0x1f, 0xcd, 0xc2, 0x6b, 0xa5, 0xb2, 0x5a, 0xee, 0xce, 0xf0,
	0x49, 0x88, 0x6d, 0x6b, 0x05, 0xb5, 0x5c, 0x3c, 0xd8, 0x4d, 0x4a, 0x28, 0x0e, 0xe3, 0x7e, 0x7e,
	0x3f, 0x4c, 0x46, 0x36, 0xf6, 0x9f, 0xa9, 0xdf, 0x83, 0xb7, 0x07, 0x1c, 0x13, 0x5a, 0x78, 0x41,
	0xce, 0x84, 0xb2, 0xe5, 0x42, 0xfe, 0xad, 0x04, 0xe9, 0x3d, 0xdd, 0xa3, 0x9d, 0x07, 0xec, 0x69,
	0xe4, 0x47, 0x4d, 0xe2, 0x51, 0xf4, 0x01, 0x4c, 0x38, 0xd8, 0x25, 0x16, 0x0d, 0xa2, 0xda, 0x7a,
	0xef, 0x4b, 0x35, 0xf2, 0x5c, 0x5d, 0x86, 0x6f, 0x55, 0x0d, 0xbb, 0x59, 0x13, 0xed, 0xd2, 0xc4,
	0x16, 0x6e, 0xf4, 0xa2, 0x39, 0x0a, 0x76, 0xd6, 0xb8, 0x0b, 0x34, 0x0f, 0x71, 0x07, 0x37, 0x48,
	0xc5, 0xd3, 0x3f, 0x0b, 0x18, 0x19, 0xd7, 0x62, 0xfe, 0x42, 0x49, 0xff, 0x8c, 0xe5, 0x09, 0x13,
	0x52, 0xfb, 0x94, 0x58, 0x3c, 0x91, 0x98, 0x7a, 0xd9, 0x5f, 0x90, 0x7f, 0x23, 0xc1, 0x7c, 0x5f,
	0x9c, 0x9e, 0x63, 0x5b, 0x1e, 0x41, 0xdf, 0x87, 0x64, 0x57, 0x09, 0x78, 0x29, 0x89, 0x65, 0xc2,
	0x08, 0x29, 0xc5, 0xb3, 0xfb, 0x7a, 0x57, 0x75, 0xa1, 0x5b, 0x70, 0xdd, 0x22, 0x9f, 0xd2, 0x4a,
	0x08, 0x60, 0x70, 0xa0, 0x53, 0xfe, 0xf2, 0x51, 0x0b, 0xe4, 0x27, 0x90, 0xda, 0x25, 0x5d, 0x10,
	0x05, 0x93, 0x6a, 0xb8, 0x04, 0xb7, 0x96, 0x19, 0x8f, 0x43, 0xd7, 0x1b, 0x33, 0x95, 0x7f, 0x26,
	0x01, 0x0a, 0xf9, 0x17, 0x9e, 0xef, 0x76, 0x78, 0x5e, 0x60, 0x9e, 0x6f, 0x0c, 0x4c, 0x11, 0xde,
	0x05, 0xd6, 0x01, 0xda, 0xd7, 0x0a, 0x8b, 0x2a, 0x91, 0x4f, 0x0b, 0xc6, 0xc4, 0xbd, 0x92, 0xdb,
	0xf1, 0x55, 0xf6, 0xb1, 0x77, 0xaa, 0xc5, 0xeb, 0x62, 0x28, 0xff, 0x53, 0x82, 0xd9, 0x6d, 0x97,
	0x60, 0x4a, 0xba, 0x11, 0xbd, 0xd2, 0xac, 0x79, 0x07, 0x12, 0xad, 0x93, 0xd5, 0x6b, 0xbc, 0x59,
	0x45, 0xbf, 0x54, 0x23, 0x1a, 0x88, 0xf5, 0x62, 0x0d, 0x7d, 0x00, 0x31, 0x31, 0x63, 0xc9, 0x93,
	0xc8, 0x67, 0x87, 0x3f, 0xf7, 0xc0, 0x5d, 0xcb, 0x81, 0xfc, 0x27, 0x09, 0x66, 0xc2, 0xc9, 0xf6,
	0x7f, 0x57, 0x0e, 0x68, 0x0e, 0x26, 0xea, 0xba, 0x41, 0x89, 0x9b, 0x1a, 0x63, 0x22, 0x3e, 0x93,
	0x7f, 0x2a, 0xc1, 0x6c, 0x17, 0x72, 0x5e, 0x20, 0xf7, 0x21, 0xde, 0x6a, 0x00, 0xbc, 0x32, 0x46,
	0x60, 0x48, 0x6b, 0x1b, 0x0f, 0x5d, 0x0d, 0x5f, 0x48, 0x30, 0xfb, 0xc0, 0xa9, 0xf5, 0xcd, 0x8f,
	0xf6, 0x61, 0x49, 0x2f, 0x79, 0x58, 0xe8, 0xbb, 0xa3, 0x65, 0x70, 0x60, 0x1e, 0x4a, 0xe3, 0x32,
	0xcc, 0xde, 0x23, 0x06, 0xe9, 0x45, 0xf9, 0x32, 0x75, 0x25, 0xff, 0x3c, 0x02, 0x73, 0x9d, 0xc5,
	0xb1, 0x4f, 0x28, 0xae, 0x61, 0x8a, 0xd1, 0xce, 0xcb, 0x44, 0x1f, 0x0a, 0x7c, 0x1d, 0xc0, 0xa3,
	0xd8, 0xa5, 0x15, 0xff, 0xd5, 0x77, 0x65, 0xe0, 0x65, 0xf1, 0x24, 0xd4, 0xe2, 0x4c, 0xdb, 0x9f,
	0xa3, 0xbb, 0x90, 0xa8, 0xfa, 0x3e, 0x8c, 0xc0, 0x36, 0x3a, 0xd0, 0x16, 0x02, 0x75, 0x66, 0xfc,
	0x6d, 0x88, 0x11, 0xab, 0x16, 0x58, 0x8e, 0x0d, 0xb4, 0xbc, 0x46, 0xac, 0x9a, 0x3f, 0x63, 0x8c,
	0x74, 0xa6, 0xc3, 0x57, 0x9c, 0x91, 0xfc, 0x5f, 0x92, 0x30, 0x25, 0xa2, 0x50, 0xfd, 0xf8, 0xd0,
	0xdf, 0x24, 0x78, 0xbd, 0xcf, 0x2d, 0x87, 0xbe, 0x33, 0x98, 0x8e, 0xab, 0x2f, 0xf1, 0xf4, 0xe6,
	0xff, 0x68, 0x1d, 0x74, 0x0e, 0xf9, 0xce, 0xa5, 0xca, 0x5b, 0xd6, 0x4f, 0xfe, 0xf1, 0xef, 0xcf,
	0x23, 0xb7, 0xd1, 0x82, 0xff, 0xb1, 0xf3, 0x24, 0x58, 0xda, 0x6c, 0x3d, 0x34, 0xb2, 0x3d, 0xaf,
	0x52, 0xf4, 0x67, 0x09, 0x5e, 0xeb, 0xb9, 0x10, 0xd1, 0xc6, 0x60, 0x38, 0x57, 0xdd, 0xa2, 0xe9,
	0x91, 0x2f, 0x73, 0x79, 0xf5, 0x52, 0x65, 0x15, 0xd9, 0x81, 0xdd, 0x5f, 0x08, 0x21, 0xef, 0x79,
	0x4e, 0x67, 0x2f, 0xd0, 0x1f, 0x25, 0x98, 0xea, 0xe8, 0xa4, 0x68, 0x75, 0x34, 0x1a, 0x5b, 0xf4,
	0xaf, 0x8d, 0x6c, 0xc7, 0x89, 0xcf, 0x77, 0x12, 0x7f, 0x13, 0xdd, 0x18, 0x44, 0xbc, 0x87, 0x7e,
	0x2d, 0x41, 0x22, 0xc4, 0x1e, 0x7a, 0x7f, 0x24, 0xb2, 0x05, 0xe4, 0x11, 0xca, 0x4f, 0x7e, 0x37,
	0x4c, 0xb0, 0xc0, 0x78, 0x15, 0xc1, 0x8c, 0xda, 0x5f, 0x46, 0x60, 0xba, 0xb3, 0x37, 0xa2, 0x21,
	0x38, 0xea, 0xfb, 0xd4, 0x48, 0xbf, 0x25, 0x0c, 0x43, 0xdf, 0xd9, 0xb9, 0x43, 0xf1, 0x9d, 0x2d,
	0xff, 0x5e, 0x7a, 0xaa, 0xd6, 0xe0, 0xf6, 0xd0, 0xd1, 0xa0, 0xb5, 0x11, 0x71, 0x88, 0x1e, 0x76,
	0xa9, 0xce, 0x07, 0xe7, 0xb2, 0x14, 0x7a, 0xac, 0xb4, 0xc6, 0x8c, 0x9b, 0x5b, 0xf2, 0xe0, 0xf3,
	0xdb, 0x90, 0xb2, 0xe8, 0x57, 0x11, 0x98, 0xee, 0x6c, 0x94, 0xc3, 0xd0, 0xd3, 0xf7, 0xa6, 0x1d,
	0x44, 0xcf, 0x1f, 0x5e, 0x3d, 0x3d, 0xfd, 0x5b, 0xfc, 0xa5, 0xfa, 0xba, 0x50, 0x5a, 0x6a, 0xdf,
	0xd6, 0x8c, 0x16, 0x25, 0x9f, 0x65, 0xb4, 0xb4, 0x9c, 0xbc, 0x28, 0x77, 0x7c, 0x7e, 0x3e, 0x97,
	0x60, 0xba, 0xf3, 0xc6, 0x1e, 0x86, 0x9f, 0xbe, 0x77, 0x7c, 0x7a, 0xae, 0xa7, 0x4f, 0x17, 0x4c,
	0x87, 0x9e, 0x77, 0x25, 0x75, 0x76, 0x88, 0xa4, 0xfe, 0x85, 0x04, 0x93, 0x25, 0x42, 0x8b, 0xd8,
	0x3c, 0x62, 0xbf, 0x81, 0x90, 0x2c, 0x5c, 0xeb, 0xd8, 0xf4, 0x01, 0x84, 0x85, 0x62, 0xfb, 0xd9,
	0x2e, 0x9d, 0x40, 0x2a, 0x1f, 0x5e, 0xaa, 0xd7, 0xc5, 0x63, 0x72, 0x29, 0xf8, 0xab, 0xc4, 0x80,
	0xac, 0xc9, 0x79, 0x06, 0x44, 0xc8, 0xae, 0x64, 0xc9, 0x0b, 0xed, 0xc5, 0x29, 0x9b, 0xdc, 0x7d,
	0x11, 0xb8, 0xdd, 0xe1, 0xc1, 0xdd, 0xbf, 0x54, 0x63, 0x02, 0xc0, 0x68, 0xa8, 0x1a, 0x5d, 0xa8,
	0xfe, 0x2a, 0x01, 0x2a, 0x13, 0x8f, 0x2d, 0x12, 0xd7, 0xd4, 0x3d, 0x4f, 0xb7, 0x2d, 0x0f, 0x2d,
	0x76, 0xed, 0xdb, 0xab, 0x22, 0x10, 0xde, 0x1e, 0x42, 0x93, 0xf7, 0xd2, 0x8f, 0x2f, 0xd5, 0x99,
	0x36, 0xa5, 0x6d, 0x05, 0x16, 0xc1, 0xa6, 0x7c, 0x67, 0xb8, 0x08, 0x68, 0xcf, 0x06, 0x1b, 0x52,
	0x36, 0xfd, 0xe9, 0x53, 0x75, 0xae, 0xff, 0xab, 0xf0, 0xef, 0xea, 0xf1, 0x23, 0x4a, 0x1d, 0x6f,
	0x43, 0x51, 0x1e, 0x3f, 0x7e, 0xdc, 0xfd, 0x64, 0xc4, 0x4d, 0xfa, 0x48, 0x61, 0x5f, 0x0e, 0xcb,
	0x8e, 0x81, 0x69, 0xdd, 0x76, 0xcd, 0xa5, 0x41, 0xea, 0x1d, 0x09, 0xbe, 0xf5, 0x2f, 0x09, 0xde,
	0xa9, 0xda, 0xe6, 0xc0, 0xec, 0xdf, 0x7a, 0xb3, 0x14, 0x88, 0x3a, 0x9e, 0x1b, 0x47, 0x7e, 0xce,
	0x1f, 0x49, 0x1f, 0xdf, 0xe7, 0xe6, 0x0d, 0xdb, 0xc0, 0x56, 0x23, 0x67, 0xbb, 0x0d, 0xa5, 0x41,
	0x2c, 0x56, 0x11, 0x4a, 0x1b, 0xc3, 0xd5, 0x7f, 0x76, 0xef, 0x8a, 0xf1, 0xef, 0x22, 0xb7, 0x76,
	0x03, 0x57, 0xdb, 0x7e, 0x54, 0x39, 0xbe, 0x69, 0x8e, 0xed, 0xd6, 0xfe, 0xdf, 0xf2, 0xe1, 0xca,
	0x53, 0xa1, 0x78, 0xcc, 0x14, 0x8f, 0xb9, 0xe2, 0x31, 0x53, 0x3c, 0x16, 0x8a, 0xc7, 0x1f, 0xae,
	0x9c, 0x4c, 0x30, 0x18, 0xef, 0xfd, 0x37, 0x00, 0x00, 0xff, 0xff, 0x94, 0xae, 0x04, 0x93, 0x5f,
	0x16, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// InstanceAdminClient is the client API for InstanceAdmin service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type InstanceAdminClient interface {
	// Lists the supported instance configurations for a given project.
	ListInstanceConfigs(ctx context.Context, in *ListInstanceConfigsRequest, opts ...grpc.CallOption) (*ListInstanceConfigsResponse, error)
	// Gets information about a particular instance configuration.
	GetInstanceConfig(ctx context.Context, in *GetInstanceConfigRequest, opts ...grpc.CallOption) (*InstanceConfig, error)
	// Lists all instances in the given project.
	ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error)
	// Gets information about a particular instance.
	GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error)
	// Creates an instance and begins preparing it to begin serving. The
	// returned [long-running operation][google.longrunning.Operation]
	// can be used to track the progress of preparing the new
	// instance. The instance name is assigned by the caller. If the
	// named instance already exists, `CreateInstance` returns
	// `ALREADY_EXISTS`.
	//
	// Immediately upon completion of this request:
	//
	//   * The instance is readable via the API, with all requested attributes
	//     but no allocated resources. Its state is `CREATING`.
	//
	// Until completion of the returned operation:
	//
	//   * Cancelling the operation renders the instance immediately unreadable
	//     via the API.
	//   * The instance can be deleted.
	//   * All other attempts to modify the instance are rejected.
	//
	// Upon completion of the returned operation:
	//
	//   * Billing for all successfully-allocated resources begins (some types
	//     may have lower than the requested levels).
	//   * Databases can be created in the instance.
	//   * The instance's allocated resource levels are readable via the API.
	//   * The instance's state becomes `READY`.
	//
	// The returned [long-running operation][google.longrunning.Operation] will
	// have a name of the format `<instance_name>/operations/<operation_id>` and
	// can be used to track creation of the instance.  The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [CreateInstanceMetadata][google.spanner.admin.instance.v1.CreateInstanceMetadata].
	// The [response][google.longrunning.Operation.response] field type is
	// [Instance][google.spanner.admin.instance.v1.Instance], if successful.
	CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates an instance, and begins allocating or releasing resources
	// as requested. The returned [long-running
	// operation][google.longrunning.Operation] can be used to track the
	// progress of updating the instance. If the named instance does not
	// exist, returns `NOT_FOUND`.
	//
	// Immediately upon completion of this request:
	//
	//   * For resource types for which a decrease in the instance's allocation
	//     has been requested, billing is based on the newly-requested level.
	//
	// Until completion of the returned operation:
	//
	//   * Cancelling the operation sets its metadata's
	//     [cancel_time][google.spanner.admin.instance.v1.UpdateInstanceMetadata.cancel_time], and begins
	//     restoring resources to their pre-request values. The operation
	//     is guaranteed to succeed at undoing all resource changes,
	//     after which point it terminates with a `CANCELLED` status.
	//   * All other attempts to modify the instance are rejected.
	//   * Reading the instance via the API continues to give the pre-request
	//     resource levels.
	//
	// Upon completion of the returned operation:
	//
	//   * Billing begins for all successfully-allocated resources (some types
	//     may have lower than the requested levels).
	//   * All newly-reserved resources are available for serving the instance's
	//     tables.
	//   * The instance's new resource levels are readable via the API.
	//
	// The returned [long-running operation][google.longrunning.Operation] will
	// have a name of the format `<instance_name>/operations/<operation_id>` and
	// can be used to track the instance modification.  The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [UpdateInstanceMetadata][google.spanner.admin.instance.v1.UpdateInstanceMetadata].
	// The [response][google.longrunning.Operation.response] field type is
	// [Instance][google.spanner.admin.instance.v1.Instance], if successful.
	//
	// Authorization requires `spanner.instances.update` permission on
	// resource [name][google.spanner.admin.instance.v1.Instance.name].
	UpdateInstance(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes an instance.
	//
	// Immediately upon completion of the request:
	//
	//   * Billing ceases for all of the instance's reserved resources.
	//
	// Soon afterward:
	//
	//   * The instance and *all of its databases* immediately and
	//     irrevocably disappear from the API. All data in the databases
	//     is permanently deleted.
	DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Sets the access control policy on an instance resource. Replaces any
	// existing policy.
	//
	// Authorization requires `spanner.instances.setIamPolicy` on
	// [resource][google.iam.v1.SetIamPolicyRequest.resource].
	SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Gets the access control policy for an instance resource. Returns an empty
	// policy if an instance exists but does not have a policy set.
	//
	// Authorization requires `spanner.instances.getIamPolicy` on
	// [resource][google.iam.v1.GetIamPolicyRequest.resource].
	GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Returns permissions that the caller has on the specified instance resource.
	//
	// Attempting this RPC on a non-existent Cloud Spanner instance resource will
	// result in a NOT_FOUND error if the user has `spanner.instances.list`
	// permission on the containing Google Cloud Project. Otherwise returns an
	// empty set of permissions.
	TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error)
}

type instanceAdminClient struct {
	cc grpc.ClientConnInterface
}

func NewInstanceAdminClient(cc grpc.ClientConnInterface) InstanceAdminClient {
	return &instanceAdminClient{cc}
}

func (c *instanceAdminClient) ListInstanceConfigs(ctx context.Context, in *ListInstanceConfigsRequest, opts ...grpc.CallOption) (*ListInstanceConfigsResponse, error) {
	out := new(ListInstanceConfigsResponse)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/ListInstanceConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) GetInstanceConfig(ctx context.Context, in *GetInstanceConfigRequest, opts ...grpc.CallOption) (*InstanceConfig, error) {
	out := new(InstanceConfig)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/GetInstanceConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error) {
	out := new(ListInstancesResponse)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/ListInstances", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error) {
	out := new(Instance)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/GetInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/CreateInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) UpdateInstance(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/UpdateInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/DeleteInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error) {
	out := new(v1.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// InstanceAdminServer is the server API for InstanceAdmin service.
type InstanceAdminServer interface {
	// Lists the supported instance configurations for a given project.
	ListInstanceConfigs(context.Context, *ListInstanceConfigsRequest) (*ListInstanceConfigsResponse, error)
	// Gets information about a particular instance configuration.
	GetInstanceConfig(context.Context, *GetInstanceConfigRequest) (*InstanceConfig, error)
	// Lists all instances in the given project.
	ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error)
	// Gets information about a particular instance.
	GetInstance(context.Context, *GetInstanceRequest) (*Instance, error)
	// Creates an instance and begins preparing it to begin serving. The
	// returned [long-running operation][google.longrunning.Operation]
	// can be used to track the progress of preparing the new
	// instance. The instance name is assigned by the caller. If the
	// named instance already exists, `CreateInstance` returns
	// `ALREADY_EXISTS`.
	//
	// Immediately upon completion of this request:
	//
	//   * The instance is readable via the API, with all requested attributes
	//     but no allocated resources. Its state is `CREATING`.
	//
	// Until completion of the returned operation:
	//
	//   * Cancelling the operation renders the instance immediately unreadable
	//     via the API.
	//   * The instance can be deleted.
	//   * All other attempts to modify the instance are rejected.
	//
	// Upon completion of the returned operation:
	//
	//   * Billing for all successfully-allocated resources begins (some types
	//     may have lower than the requested levels).
	//   * Databases can be created in the instance.
	//   * The instance's allocated resource levels are readable via the API.
	//   * The instance's state becomes `READY`.
	//
	// The returned [long-running operation][google.longrunning.Operation] will
	// have a name of the format `<instance_name>/operations/<operation_id>` and
	// can be used to track creation of the instance.  The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [CreateInstanceMetadata][google.spanner.admin.instance.v1.CreateInstanceMetadata].
	// The [response][google.longrunning.Operation.response] field type is
	// [Instance][google.spanner.admin.instance.v1.Instance], if successful.
	CreateInstance(context.Context, *CreateInstanceRequest) (*longrunning.Operation, error)
	// Updates an instance, and begins allocating or releasing resources
	// as requested. The returned [long-running
	// operation][google.longrunning.Operation] can be used to track the
	// progress of updating the instance. If the named instance does not
	// exist, returns `NOT_FOUND`.
	//
	// Immediately upon completion of this request:
	//
	//   * For resource types for which a decrease in the instance's allocation
	//     has been requested, billing is based on the newly-requested level.
	//
	// Until completion of the returned operation:
	//
	//   * Cancelling the operation sets its metadata's
	//     [cancel_time][google.spanner.admin.instance.v1.UpdateInstanceMetadata.cancel_time], and begins
	//     restoring resources to their pre-request values. The operation
	//     is guaranteed to succeed at undoing all resource changes,
	//     after which point it terminates with a `CANCELLED` status.
	//   * All other attempts to modify the instance are rejected.
	//   * Reading the instance via the API continues to give the pre-request
	//     resource levels.
	//
	// Upon completion of the returned operation:
	//
	//   * Billing begins for all successfully-allocated resources (some types
	//     may have lower than the requested levels).
	//   * All newly-reserved resources are available for serving the instance's
	//     tables.
	//   * The instance's new resource levels are readable via the API.
	//
	// The returned [long-running operation][google.longrunning.Operation] will
	// have a name of the format `<instance_name>/operations/<operation_id>` and
	// can be used to track the instance modification.  The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [UpdateInstanceMetadata][google.spanner.admin.instance.v1.UpdateInstanceMetadata].
	// The [response][google.longrunning.Operation.response] field type is
	// [Instance][google.spanner.admin.instance.v1.Instance], if successful.
	//
	// Authorization requires `spanner.instances.update` permission on
	// resource [name][google.spanner.admin.instance.v1.Instance.name].
	UpdateInstance(context.Context, *UpdateInstanceRequest) (*longrunning.Operation, error)
	// Deletes an instance.
	//
	// Immediately upon completion of the request:
	//
	//   * Billing ceases for all of the instance's reserved resources.
	//
	// Soon afterward:
	//
	//   * The instance and *all of its databases* immediately and
	//     irrevocably disappear from the API. All data in the databases
	//     is permanently deleted.
	DeleteInstance(context.Context, *DeleteInstanceRequest) (*empty.Empty, error)
	// Sets the access control policy on an instance resource. Replaces any
	// existing policy.
	//
	// Authorization requires `spanner.instances.setIamPolicy` on
	// [resource][google.iam.v1.SetIamPolicyRequest.resource].
	SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error)
	// Gets the access control policy for an instance resource. Returns an empty
	// policy if an instance exists but does not have a policy set.
	//
	// Authorization requires `spanner.instances.getIamPolicy` on
	// [resource][google.iam.v1.GetIamPolicyRequest.resource].
	GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error)
	// Returns permissions that the caller has on the specified instance resource.
	//
	// Attempting this RPC on a non-existent Cloud Spanner instance resource will
	// result in a NOT_FOUND error if the user has `spanner.instances.list`
	// permission on the containing Google Cloud Project. Otherwise returns an
	// empty set of permissions.
	TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error)
}

// UnimplementedInstanceAdminServer can be embedded to have forward compatible implementations.
type UnimplementedInstanceAdminServer struct {
}

func (*UnimplementedInstanceAdminServer) ListInstanceConfigs(ctx context.Context, req *ListInstanceConfigsRequest) (*ListInstanceConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInstanceConfigs not implemented")
}
func (*UnimplementedInstanceAdminServer) GetInstanceConfig(ctx context.Context, req *GetInstanceConfigRequest) (*InstanceConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInstanceConfig not implemented")
}
func (*UnimplementedInstanceAdminServer) ListInstances(ctx context.Context, req *ListInstancesRequest) (*ListInstancesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInstances not implemented")
}
func (*UnimplementedInstanceAdminServer) GetInstance(ctx context.Context, req *GetInstanceRequest) (*Instance, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInstance not implemented")
}
func (*UnimplementedInstanceAdminServer) CreateInstance(ctx context.Context, req *CreateInstanceRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateInstance not implemented")
}
func (*UnimplementedInstanceAdminServer) UpdateInstance(ctx context.Context, req *UpdateInstanceRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateInstance not implemented")
}
func (*UnimplementedInstanceAdminServer) DeleteInstance(ctx context.Context, req *DeleteInstanceRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteInstance not implemented")
}
func (*UnimplementedInstanceAdminServer) SetIamPolicy(ctx context.Context, req *v1.SetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (*UnimplementedInstanceAdminServer) GetIamPolicy(ctx context.Context, req *v1.GetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (*UnimplementedInstanceAdminServer) TestIamPermissions(ctx context.Context, req *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

func RegisterInstanceAdminServer(s *grpc.Server, srv InstanceAdminServer) {
	s.RegisterService(&_InstanceAdmin_serviceDesc, srv)
}

func _InstanceAdmin_ListInstanceConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstanceConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).ListInstanceConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/ListInstanceConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).ListInstanceConfigs(ctx, req.(*ListInstanceConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_GetInstanceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).GetInstanceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/GetInstanceConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).GetInstanceConfig(ctx, req.(*GetInstanceConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_ListInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).ListInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/ListInstances",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).ListInstances(ctx, req.(*ListInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_GetInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).GetInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/GetInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).GetInstance(ctx, req.(*GetInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_CreateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).CreateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/CreateInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).CreateInstance(ctx, req.(*CreateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_UpdateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).UpdateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/UpdateInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).UpdateInstance(ctx, req.(*UpdateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_DeleteInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).DeleteInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/DeleteInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).DeleteInstance(ctx, req.(*DeleteInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).SetIamPolicy(ctx, req.(*v1.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).GetIamPolicy(ctx, req.(*v1.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).TestIamPermissions(ctx, req.(*v1.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _InstanceAdmin_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.spanner.admin.instance.v1.InstanceAdmin",
	HandlerType: (*InstanceAdminServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListInstanceConfigs",
			Handler:    _InstanceAdmin_ListInstanceConfigs_Handler,
		},
		{
			MethodName: "GetInstanceConfig",
			Handler:    _InstanceAdmin_GetInstanceConfig_Handler,
		},
		{
			MethodName: "ListInstances",
			Handler:    _InstanceAdmin_ListInstances_Handler,
		},
		{
			MethodName: "GetInstance",
			Handler:    _InstanceAdmin_GetInstance_Handler,
		},
		{
			MethodName: "CreateInstance",
			Handler:    _InstanceAdmin_CreateInstance_Handler,
		},
		{
			MethodName: "UpdateInstance",
			Handler:    _InstanceAdmin_UpdateInstance_Handler,
		},
		{
			MethodName: "DeleteInstance",
			Handler:    _InstanceAdmin_DeleteInstance_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _InstanceAdmin_SetIamPolicy_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _InstanceAdmin_GetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _InstanceAdmin_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/spanner/admin/instance/v1/spanner_instance_admin.proto",
}
