/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/openshift/sriov-network-operator/pkg/apis/sriovnetwork/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// SriovOperatorConfigLister helps list SriovOperatorConfigs.
type SriovOperatorConfigLister interface {
	// List lists all SriovOperatorConfigs in the indexer.
	List(selector labels.Selector) (ret []*v1.SriovOperatorConfig, err error)
	// SriovOperatorConfigs returns an object that can list and get SriovOperatorConfigs.
	SriovOperatorConfigs(namespace string) SriovOperatorConfigNamespaceLister
	SriovOperatorConfigListerExpansion
}

// sriovOperatorConfigLister implements the SriovOperatorConfigLister interface.
type sriovOperatorConfigLister struct {
	indexer cache.Indexer
}

// NewSriovOperatorConfigLister returns a new SriovOperatorConfigLister.
func NewSriovOperatorConfigLister(indexer cache.Indexer) SriovOperatorConfigLister {
	return &sriovOperatorConfigLister{indexer: indexer}
}

// List lists all SriovOperatorConfigs in the indexer.
func (s *sriovOperatorConfigLister) List(selector labels.Selector) (ret []*v1.SriovOperatorConfig, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.SriovOperatorConfig))
	})
	return ret, err
}

// SriovOperatorConfigs returns an object that can list and get SriovOperatorConfigs.
func (s *sriovOperatorConfigLister) SriovOperatorConfigs(namespace string) SriovOperatorConfigNamespaceLister {
	return sriovOperatorConfigNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// SriovOperatorConfigNamespaceLister helps list and get SriovOperatorConfigs.
type SriovOperatorConfigNamespaceLister interface {
	// List lists all SriovOperatorConfigs in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1.SriovOperatorConfig, err error)
	// Get retrieves the SriovOperatorConfig from the indexer for a given namespace and name.
	Get(name string) (*v1.SriovOperatorConfig, error)
	SriovOperatorConfigNamespaceListerExpansion
}

// sriovOperatorConfigNamespaceLister implements the SriovOperatorConfigNamespaceLister
// interface.
type sriovOperatorConfigNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all SriovOperatorConfigs in the indexer for a given namespace.
func (s sriovOperatorConfigNamespaceLister) List(selector labels.Selector) (ret []*v1.SriovOperatorConfig, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.SriovOperatorConfig))
	})
	return ret, err
}

// Get retrieves the SriovOperatorConfig from the indexer for a given namespace and name.
func (s sriovOperatorConfigNamespaceLister) Get(name string) (*v1.SriovOperatorConfig, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("sriovoperatorconfig"), name)
	}
	return obj.(*v1.SriovOperatorConfig), nil
}
