/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	ptpv1 "github.com/openshift/ptp-operator/pkg/apis/ptp/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakePtpConfigs implements PtpConfigInterface
type FakePtpConfigs struct {
	Fake *FakePtpV1
	ns   string
}

var ptpconfigsResource = schema.GroupVersionResource{Group: "ptp.openshift.io", Version: "v1", Resource: "ptpconfigs"}

var ptpconfigsKind = schema.GroupVersionKind{Group: "ptp.openshift.io", Version: "v1", Kind: "PtpConfig"}

// Get takes name of the ptpConfig, and returns the corresponding ptpConfig object, and an error if there is any.
func (c *FakePtpConfigs) Get(name string, options v1.GetOptions) (result *ptpv1.PtpConfig, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(ptpconfigsResource, c.ns, name), &ptpv1.PtpConfig{})

	if obj == nil {
		return nil, err
	}
	return obj.(*ptpv1.PtpConfig), err
}

// List takes label and field selectors, and returns the list of PtpConfigs that match those selectors.
func (c *FakePtpConfigs) List(opts v1.ListOptions) (result *ptpv1.PtpConfigList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(ptpconfigsResource, ptpconfigsKind, c.ns, opts), &ptpv1.PtpConfigList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &ptpv1.PtpConfigList{ListMeta: obj.(*ptpv1.PtpConfigList).ListMeta}
	for _, item := range obj.(*ptpv1.PtpConfigList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested ptpConfigs.
func (c *FakePtpConfigs) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(ptpconfigsResource, c.ns, opts))

}

// Create takes the representation of a ptpConfig and creates it.  Returns the server's representation of the ptpConfig, and an error, if there is any.
func (c *FakePtpConfigs) Create(ptpConfig *ptpv1.PtpConfig) (result *ptpv1.PtpConfig, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(ptpconfigsResource, c.ns, ptpConfig), &ptpv1.PtpConfig{})

	if obj == nil {
		return nil, err
	}
	return obj.(*ptpv1.PtpConfig), err
}

// Update takes the representation of a ptpConfig and updates it. Returns the server's representation of the ptpConfig, and an error, if there is any.
func (c *FakePtpConfigs) Update(ptpConfig *ptpv1.PtpConfig) (result *ptpv1.PtpConfig, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(ptpconfigsResource, c.ns, ptpConfig), &ptpv1.PtpConfig{})

	if obj == nil {
		return nil, err
	}
	return obj.(*ptpv1.PtpConfig), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakePtpConfigs) UpdateStatus(ptpConfig *ptpv1.PtpConfig) (*ptpv1.PtpConfig, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(ptpconfigsResource, "status", c.ns, ptpConfig), &ptpv1.PtpConfig{})

	if obj == nil {
		return nil, err
	}
	return obj.(*ptpv1.PtpConfig), err
}

// Delete takes name of the ptpConfig and deletes it. Returns an error if one occurs.
func (c *FakePtpConfigs) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(ptpconfigsResource, c.ns, name), &ptpv1.PtpConfig{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakePtpConfigs) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(ptpconfigsResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &ptpv1.PtpConfigList{})
	return err
}

// Patch applies the patch and returns the patched ptpConfig.
func (c *FakePtpConfigs) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *ptpv1.PtpConfig, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(ptpconfigsResource, c.ns, name, pt, data, subresources...), &ptpv1.PtpConfig{})

	if obj == nil {
		return nil, err
	}
	return obj.(*ptpv1.PtpConfig), err
}
