// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/storage/v1/storage.proto

package storage

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	v1 "google.golang.org/genproto/googleapis/iam/v1"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// A collection of constant values meaningful to the Storage API.
type ServiceConstants_Values int32

const (
	// Unused. Proto3 requires first enum to be 0.
	ServiceConstants_VALUES_UNSPECIFIED ServiceConstants_Values = 0
	// The maximum size chunk that can will be returned in a single
	// ReadRequest.
	// 2 MiB.
	ServiceConstants_MAX_READ_CHUNK_BYTES ServiceConstants_Values = 2097152
	// The maximum size chunk that can be sent in a single InsertObjectRequest.
	// 2 MiB.
	ServiceConstants_MAX_WRITE_CHUNK_BYTES ServiceConstants_Values = 2097152
	// The maximum size of an object in MB - whether written in a single stream
	// or composed from multiple other objects.
	// 5 TiB.
	ServiceConstants_MAX_OBJECT_SIZE_MB ServiceConstants_Values = 5242880
	// The maximum length field name that can be sent in a single
	// custom metadata field.
	// 1 KiB.
	ServiceConstants_MAX_CUSTOM_METADATA_FIELD_NAME_BYTES ServiceConstants_Values = 1024
	// The maximum length field value that can be sent in a single
	// custom_metadata field.
	// 4 KiB.
	ServiceConstants_MAX_CUSTOM_METADATA_FIELD_VALUE_BYTES ServiceConstants_Values = 4096
	// The maximum total bytes that can be populated into all field names and
	// values of the custom_metadata for one object.
	// 8 KiB.
	ServiceConstants_MAX_CUSTOM_METADATA_TOTAL_SIZE_BYTES ServiceConstants_Values = 8192
	// The maximum total bytes that can be populated into all bucket metadata
	// fields.
	// 20 KiB.
	ServiceConstants_MAX_BUCKET_METADATA_TOTAL_SIZE_BYTES ServiceConstants_Values = 20480
	// The maximum number of NotificationConfigurations that can be registered
	// for a given bucket.
	ServiceConstants_MAX_NOTIFICATION_CONFIGS_PER_BUCKET ServiceConstants_Values = 100
	// The maximum number of LifecycleRules that can be registered for a given
	// bucket.
	ServiceConstants_MAX_LIFECYCLE_RULES_PER_BUCKET ServiceConstants_Values = 100
	// The maximum number of custom attributes per NotificationConfig.
	ServiceConstants_MAX_NOTIFICATION_CUSTOM_ATTRIBUTES ServiceConstants_Values = 5
	// The maximum length of a custom attribute key included in
	// NotificationConfig.
	ServiceConstants_MAX_NOTIFICATION_CUSTOM_ATTRIBUTE_KEY_LENGTH ServiceConstants_Values = 256
	// The maximum length of a custom attribute value included in a
	// NotificationConfig.
	ServiceConstants_MAX_NOTIFICATION_CUSTOM_ATTRIBUTE_VALUE_LENGTH ServiceConstants_Values = 1024
	// The maximum number of key/value entries per bucket label.
	ServiceConstants_MAX_LABELS_ENTRIES_COUNT ServiceConstants_Values = 64
	// The maximum character length of the key or value in a bucket
	// label map.
	ServiceConstants_MAX_LABELS_KEY_VALUE_LENGTH ServiceConstants_Values = 63
	// The maximum byte size of the key or value in a bucket label
	// map.
	ServiceConstants_MAX_LABELS_KEY_VALUE_BYTES ServiceConstants_Values = 128
	// The maximum number of object IDs that can be included in a
	// DeleteObjectsRequest.
	ServiceConstants_MAX_OBJECT_IDS_PER_DELETE_OBJECTS_REQUEST ServiceConstants_Values = 1000
	// The maximum number of days for which a token returned by the
	// GetListObjectsSplitPoints RPC is valid.
	ServiceConstants_SPLIT_TOKEN_MAX_VALID_DAYS ServiceConstants_Values = 14
)

var ServiceConstants_Values_name = map[int32]string{
	0:       "VALUES_UNSPECIFIED",
	2097152: "MAX_READ_CHUNK_BYTES",
	// Duplicate value: 2097152: "MAX_WRITE_CHUNK_BYTES",
	5242880: "MAX_OBJECT_SIZE_MB",
	1024:    "MAX_CUSTOM_METADATA_FIELD_NAME_BYTES",
	4096:    "MAX_CUSTOM_METADATA_FIELD_VALUE_BYTES",
	8192:    "MAX_CUSTOM_METADATA_TOTAL_SIZE_BYTES",
	20480:   "MAX_BUCKET_METADATA_TOTAL_SIZE_BYTES",
	100:     "MAX_NOTIFICATION_CONFIGS_PER_BUCKET",
	// Duplicate value: 100: "MAX_LIFECYCLE_RULES_PER_BUCKET",
	5:   "MAX_NOTIFICATION_CUSTOM_ATTRIBUTES",
	256: "MAX_NOTIFICATION_CUSTOM_ATTRIBUTE_KEY_LENGTH",
	// Duplicate value: 1024: "MAX_NOTIFICATION_CUSTOM_ATTRIBUTE_VALUE_LENGTH",
	64:   "MAX_LABELS_ENTRIES_COUNT",
	63:   "MAX_LABELS_KEY_VALUE_LENGTH",
	128:  "MAX_LABELS_KEY_VALUE_BYTES",
	1000: "MAX_OBJECT_IDS_PER_DELETE_OBJECTS_REQUEST",
	14:   "SPLIT_TOKEN_MAX_VALID_DAYS",
}

var ServiceConstants_Values_value = map[string]int32{
	"VALUES_UNSPECIFIED":                             0,
	"MAX_READ_CHUNK_BYTES":                           2097152,
	"MAX_WRITE_CHUNK_BYTES":                          2097152,
	"MAX_OBJECT_SIZE_MB":                             5242880,
	"MAX_CUSTOM_METADATA_FIELD_NAME_BYTES":           1024,
	"MAX_CUSTOM_METADATA_FIELD_VALUE_BYTES":          4096,
	"MAX_CUSTOM_METADATA_TOTAL_SIZE_BYTES":           8192,
	"MAX_BUCKET_METADATA_TOTAL_SIZE_BYTES":           20480,
	"MAX_NOTIFICATION_CONFIGS_PER_BUCKET":            100,
	"MAX_LIFECYCLE_RULES_PER_BUCKET":                 100,
	"MAX_NOTIFICATION_CUSTOM_ATTRIBUTES":             5,
	"MAX_NOTIFICATION_CUSTOM_ATTRIBUTE_KEY_LENGTH":   256,
	"MAX_NOTIFICATION_CUSTOM_ATTRIBUTE_VALUE_LENGTH": 1024,
	"MAX_LABELS_ENTRIES_COUNT":                       64,
	"MAX_LABELS_KEY_VALUE_LENGTH":                    63,
	"MAX_LABELS_KEY_VALUE_BYTES":                     128,
	"MAX_OBJECT_IDS_PER_DELETE_OBJECTS_REQUEST":      1000,
	"SPLIT_TOKEN_MAX_VALID_DAYS":                     14,
}

func (x ServiceConstants_Values) String() string {
	return proto.EnumName(ServiceConstants_Values_name, int32(x))
}

func (ServiceConstants_Values) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{58, 0}
}

// Request message for DeleteBucketAccessControl.
type DeleteBucketAccessControlRequest struct {
	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. The entity holding the permission. Can be one of:
	// * `user-`*userId*
	// * `user-`*emailAddress*
	// * `group-`*groupId*
	// * `group-`*emailAddress*
	// * `allUsers`
	// * `allAuthenticatedUsers`
	Entity string `protobuf:"bytes,2,opt,name=entity,proto3" json:"entity,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,4,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *DeleteBucketAccessControlRequest) Reset()         { *m = DeleteBucketAccessControlRequest{} }
func (m *DeleteBucketAccessControlRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteBucketAccessControlRequest) ProtoMessage()    {}
func (*DeleteBucketAccessControlRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{0}
}

func (m *DeleteBucketAccessControlRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteBucketAccessControlRequest.Unmarshal(m, b)
}
func (m *DeleteBucketAccessControlRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteBucketAccessControlRequest.Marshal(b, m, deterministic)
}
func (m *DeleteBucketAccessControlRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteBucketAccessControlRequest.Merge(m, src)
}
func (m *DeleteBucketAccessControlRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteBucketAccessControlRequest.Size(m)
}
func (m *DeleteBucketAccessControlRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteBucketAccessControlRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteBucketAccessControlRequest proto.InternalMessageInfo

func (m *DeleteBucketAccessControlRequest) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *DeleteBucketAccessControlRequest) GetEntity() string {
	if m != nil {
		return m.Entity
	}
	return ""
}

func (m *DeleteBucketAccessControlRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Request message for GetBucketAccessControl.
type GetBucketAccessControlRequest struct {
	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. The entity holding the permission. Can be one of:
	// * `user-`*userId*
	// * `user-`*emailAddress*
	// * `group-`*groupId*
	// * `group-`*emailAddress*
	// * `allUsers`
	// * `allAuthenticatedUsers`
	Entity string `protobuf:"bytes,2,opt,name=entity,proto3" json:"entity,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,4,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *GetBucketAccessControlRequest) Reset()         { *m = GetBucketAccessControlRequest{} }
func (m *GetBucketAccessControlRequest) String() string { return proto.CompactTextString(m) }
func (*GetBucketAccessControlRequest) ProtoMessage()    {}
func (*GetBucketAccessControlRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{1}
}

func (m *GetBucketAccessControlRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetBucketAccessControlRequest.Unmarshal(m, b)
}
func (m *GetBucketAccessControlRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetBucketAccessControlRequest.Marshal(b, m, deterministic)
}
func (m *GetBucketAccessControlRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetBucketAccessControlRequest.Merge(m, src)
}
func (m *GetBucketAccessControlRequest) XXX_Size() int {
	return xxx_messageInfo_GetBucketAccessControlRequest.Size(m)
}
func (m *GetBucketAccessControlRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetBucketAccessControlRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetBucketAccessControlRequest proto.InternalMessageInfo

func (m *GetBucketAccessControlRequest) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *GetBucketAccessControlRequest) GetEntity() string {
	if m != nil {
		return m.Entity
	}
	return ""
}

func (m *GetBucketAccessControlRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Request message for InsertBucketAccessControl.
type InsertBucketAccessControlRequest struct {
	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Properties of the new bucket access control being inserted.
	BucketAccessControl *BucketAccessControl `protobuf:"bytes,3,opt,name=bucket_access_control,json=bucketAccessControl,proto3" json:"bucket_access_control,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,4,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *InsertBucketAccessControlRequest) Reset()         { *m = InsertBucketAccessControlRequest{} }
func (m *InsertBucketAccessControlRequest) String() string { return proto.CompactTextString(m) }
func (*InsertBucketAccessControlRequest) ProtoMessage()    {}
func (*InsertBucketAccessControlRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{2}
}

func (m *InsertBucketAccessControlRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InsertBucketAccessControlRequest.Unmarshal(m, b)
}
func (m *InsertBucketAccessControlRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InsertBucketAccessControlRequest.Marshal(b, m, deterministic)
}
func (m *InsertBucketAccessControlRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InsertBucketAccessControlRequest.Merge(m, src)
}
func (m *InsertBucketAccessControlRequest) XXX_Size() int {
	return xxx_messageInfo_InsertBucketAccessControlRequest.Size(m)
}
func (m *InsertBucketAccessControlRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_InsertBucketAccessControlRequest.DiscardUnknown(m)
}

var xxx_messageInfo_InsertBucketAccessControlRequest proto.InternalMessageInfo

func (m *InsertBucketAccessControlRequest) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *InsertBucketAccessControlRequest) GetBucketAccessControl() *BucketAccessControl {
	if m != nil {
		return m.BucketAccessControl
	}
	return nil
}

func (m *InsertBucketAccessControlRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Request message for ListBucketAccessControl.
type ListBucketAccessControlsRequest struct {
	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,3,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ListBucketAccessControlsRequest) Reset()         { *m = ListBucketAccessControlsRequest{} }
func (m *ListBucketAccessControlsRequest) String() string { return proto.CompactTextString(m) }
func (*ListBucketAccessControlsRequest) ProtoMessage()    {}
func (*ListBucketAccessControlsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{3}
}

func (m *ListBucketAccessControlsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListBucketAccessControlsRequest.Unmarshal(m, b)
}
func (m *ListBucketAccessControlsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListBucketAccessControlsRequest.Marshal(b, m, deterministic)
}
func (m *ListBucketAccessControlsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListBucketAccessControlsRequest.Merge(m, src)
}
func (m *ListBucketAccessControlsRequest) XXX_Size() int {
	return xxx_messageInfo_ListBucketAccessControlsRequest.Size(m)
}
func (m *ListBucketAccessControlsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListBucketAccessControlsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListBucketAccessControlsRequest proto.InternalMessageInfo

func (m *ListBucketAccessControlsRequest) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *ListBucketAccessControlsRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Request for PatchBucketAccessControl.
type PatchBucketAccessControlRequest struct {
	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. The entity holding the permission. Can be one of:
	// * `user-`*userId*
	// * `user-`*emailAddress*
	// * `group-`*groupId*
	// * `group-`*emailAddress*
	// * `allUsers`
	// * `allAuthenticatedUsers`
	Entity string `protobuf:"bytes,2,opt,name=entity,proto3" json:"entity,omitempty"`
	// The BucketAccessControl for updating.
	BucketAccessControl *BucketAccessControl `protobuf:"bytes,4,opt,name=bucket_access_control,json=bucketAccessControl,proto3" json:"bucket_access_control,omitempty"`
	// List of fields to be updated.
	//
	// To specify ALL fields, equivalent to the JSON API's "update" function,
	// specify a single field with the value `*`.
	//
	// Not specifying any fields is an error.
	// Not specifying a field while setting that field to a non-default value is
	// an error.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,5,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,6,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *PatchBucketAccessControlRequest) Reset()         { *m = PatchBucketAccessControlRequest{} }
func (m *PatchBucketAccessControlRequest) String() string { return proto.CompactTextString(m) }
func (*PatchBucketAccessControlRequest) ProtoMessage()    {}
func (*PatchBucketAccessControlRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{4}
}

func (m *PatchBucketAccessControlRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PatchBucketAccessControlRequest.Unmarshal(m, b)
}
func (m *PatchBucketAccessControlRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PatchBucketAccessControlRequest.Marshal(b, m, deterministic)
}
func (m *PatchBucketAccessControlRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PatchBucketAccessControlRequest.Merge(m, src)
}
func (m *PatchBucketAccessControlRequest) XXX_Size() int {
	return xxx_messageInfo_PatchBucketAccessControlRequest.Size(m)
}
func (m *PatchBucketAccessControlRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PatchBucketAccessControlRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PatchBucketAccessControlRequest proto.InternalMessageInfo

func (m *PatchBucketAccessControlRequest) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *PatchBucketAccessControlRequest) GetEntity() string {
	if m != nil {
		return m.Entity
	}
	return ""
}

func (m *PatchBucketAccessControlRequest) GetBucketAccessControl() *BucketAccessControl {
	if m != nil {
		return m.BucketAccessControl
	}
	return nil
}

func (m *PatchBucketAccessControlRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *PatchBucketAccessControlRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Request for UpdateBucketAccessControl.
type UpdateBucketAccessControlRequest struct {
	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. The entity holding the permission. Can be one of:
	// * `user-`*userId*
	// * `user-`*emailAddress*
	// * `group-`*groupId*
	// * `group-`*emailAddress*
	// * `allUsers`
	// * `allAuthenticatedUsers`
	Entity string `protobuf:"bytes,2,opt,name=entity,proto3" json:"entity,omitempty"`
	// The BucketAccessControl for updating.
	BucketAccessControl *BucketAccessControl `protobuf:"bytes,4,opt,name=bucket_access_control,json=bucketAccessControl,proto3" json:"bucket_access_control,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,5,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *UpdateBucketAccessControlRequest) Reset()         { *m = UpdateBucketAccessControlRequest{} }
func (m *UpdateBucketAccessControlRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateBucketAccessControlRequest) ProtoMessage()    {}
func (*UpdateBucketAccessControlRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{5}
}

func (m *UpdateBucketAccessControlRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateBucketAccessControlRequest.Unmarshal(m, b)
}
func (m *UpdateBucketAccessControlRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateBucketAccessControlRequest.Marshal(b, m, deterministic)
}
func (m *UpdateBucketAccessControlRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateBucketAccessControlRequest.Merge(m, src)
}
func (m *UpdateBucketAccessControlRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateBucketAccessControlRequest.Size(m)
}
func (m *UpdateBucketAccessControlRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateBucketAccessControlRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateBucketAccessControlRequest proto.InternalMessageInfo

func (m *UpdateBucketAccessControlRequest) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *UpdateBucketAccessControlRequest) GetEntity() string {
	if m != nil {
		return m.Entity
	}
	return ""
}

func (m *UpdateBucketAccessControlRequest) GetBucketAccessControl() *BucketAccessControl {
	if m != nil {
		return m.BucketAccessControl
	}
	return nil
}

func (m *UpdateBucketAccessControlRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Request message for DeleteBucket.
type DeleteBucketRequest struct {
	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// If set, only deletes the bucket if its metageneration matches this value.
	IfMetagenerationMatch *wrappers.Int64Value `protobuf:"bytes,2,opt,name=if_metageneration_match,json=ifMetagenerationMatch,proto3" json:"if_metageneration_match,omitempty"`
	// If set, only deletes the bucket if its metageneration does not match this
	// value.
	IfMetagenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,3,opt,name=if_metageneration_not_match,json=ifMetagenerationNotMatch,proto3" json:"if_metageneration_not_match,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,5,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *DeleteBucketRequest) Reset()         { *m = DeleteBucketRequest{} }
func (m *DeleteBucketRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteBucketRequest) ProtoMessage()    {}
func (*DeleteBucketRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{6}
}

func (m *DeleteBucketRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteBucketRequest.Unmarshal(m, b)
}
func (m *DeleteBucketRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteBucketRequest.Marshal(b, m, deterministic)
}
func (m *DeleteBucketRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteBucketRequest.Merge(m, src)
}
func (m *DeleteBucketRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteBucketRequest.Size(m)
}
func (m *DeleteBucketRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteBucketRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteBucketRequest proto.InternalMessageInfo

func (m *DeleteBucketRequest) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *DeleteBucketRequest) GetIfMetagenerationMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfMetagenerationMatch
	}
	return nil
}

func (m *DeleteBucketRequest) GetIfMetagenerationNotMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfMetagenerationNotMatch
	}
	return nil
}

func (m *DeleteBucketRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Request message for GetBucket.
type GetBucketRequest struct {
	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Makes the return of the bucket metadata conditional on whether the bucket's
	// current metageneration matches the given value.
	IfMetagenerationMatch *wrappers.Int64Value `protobuf:"bytes,2,opt,name=if_metageneration_match,json=ifMetagenerationMatch,proto3" json:"if_metageneration_match,omitempty"`
	// Makes the return of the bucket metadata conditional on whether the bucket's
	// current metageneration does not match the given value.
	IfMetagenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,3,opt,name=if_metageneration_not_match,json=ifMetagenerationNotMatch,proto3" json:"if_metageneration_not_match,omitempty"`
	// Set of properties to return. Defaults to `NO_ACL`.
	Projection CommonEnums_Projection `protobuf:"varint,4,opt,name=projection,proto3,enum=google.storage.v1.CommonEnums_Projection" json:"projection,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,6,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *GetBucketRequest) Reset()         { *m = GetBucketRequest{} }
func (m *GetBucketRequest) String() string { return proto.CompactTextString(m) }
func (*GetBucketRequest) ProtoMessage()    {}
func (*GetBucketRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{7}
}

func (m *GetBucketRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetBucketRequest.Unmarshal(m, b)
}
func (m *GetBucketRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetBucketRequest.Marshal(b, m, deterministic)
}
func (m *GetBucketRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetBucketRequest.Merge(m, src)
}
func (m *GetBucketRequest) XXX_Size() int {
	return xxx_messageInfo_GetBucketRequest.Size(m)
}
func (m *GetBucketRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetBucketRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetBucketRequest proto.InternalMessageInfo

func (m *GetBucketRequest) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *GetBucketRequest) GetIfMetagenerationMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfMetagenerationMatch
	}
	return nil
}

func (m *GetBucketRequest) GetIfMetagenerationNotMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfMetagenerationNotMatch
	}
	return nil
}

func (m *GetBucketRequest) GetProjection() CommonEnums_Projection {
	if m != nil {
		return m.Projection
	}
	return CommonEnums_PROJECTION_UNSPECIFIED
}

func (m *GetBucketRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Request message for InsertBucket.
type InsertBucketRequest struct {
	// Apply a predefined set of access controls to this bucket.
	PredefinedAcl CommonEnums_PredefinedBucketAcl `protobuf:"varint,1,opt,name=predefined_acl,json=predefinedAcl,proto3,enum=google.storage.v1.CommonEnums_PredefinedBucketAcl" json:"predefined_acl,omitempty"`
	// Apply a predefined set of default object access controls to this bucket.
	PredefinedDefaultObjectAcl CommonEnums_PredefinedObjectAcl `protobuf:"varint,2,opt,name=predefined_default_object_acl,json=predefinedDefaultObjectAcl,proto3,enum=google.storage.v1.CommonEnums_PredefinedObjectAcl" json:"predefined_default_object_acl,omitempty"`
	// Required. A valid API project identifier.
	Project string `protobuf:"bytes,3,opt,name=project,proto3" json:"project,omitempty"`
	// Set of properties to return. Defaults to `NO_ACL`, unless the
	// bucket resource specifies `acl` or `defaultObjectAcl`
	// properties, when it defaults to `FULL`.
	Projection CommonEnums_Projection `protobuf:"varint,4,opt,name=projection,proto3,enum=google.storage.v1.CommonEnums_Projection" json:"projection,omitempty"`
	// Properties of the new bucket being inserted, including its name.
	Bucket *Bucket `protobuf:"bytes,6,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,7,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *InsertBucketRequest) Reset()         { *m = InsertBucketRequest{} }
func (m *InsertBucketRequest) String() string { return proto.CompactTextString(m) }
func (*InsertBucketRequest) ProtoMessage()    {}
func (*InsertBucketRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{8}
}

func (m *InsertBucketRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InsertBucketRequest.Unmarshal(m, b)
}
func (m *InsertBucketRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InsertBucketRequest.Marshal(b, m, deterministic)
}
func (m *InsertBucketRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InsertBucketRequest.Merge(m, src)
}
func (m *InsertBucketRequest) XXX_Size() int {
	return xxx_messageInfo_InsertBucketRequest.Size(m)
}
func (m *InsertBucketRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_InsertBucketRequest.DiscardUnknown(m)
}

var xxx_messageInfo_InsertBucketRequest proto.InternalMessageInfo

func (m *InsertBucketRequest) GetPredefinedAcl() CommonEnums_PredefinedBucketAcl {
	if m != nil {
		return m.PredefinedAcl
	}
	return CommonEnums_PREDEFINED_BUCKET_ACL_UNSPECIFIED
}

func (m *InsertBucketRequest) GetPredefinedDefaultObjectAcl() CommonEnums_PredefinedObjectAcl {
	if m != nil {
		return m.PredefinedDefaultObjectAcl
	}
	return CommonEnums_PREDEFINED_OBJECT_ACL_UNSPECIFIED
}

func (m *InsertBucketRequest) GetProject() string {
	if m != nil {
		return m.Project
	}
	return ""
}

func (m *InsertBucketRequest) GetProjection() CommonEnums_Projection {
	if m != nil {
		return m.Projection
	}
	return CommonEnums_PROJECTION_UNSPECIFIED
}

func (m *InsertBucketRequest) GetBucket() *Bucket {
	if m != nil {
		return m.Bucket
	}
	return nil
}

func (m *InsertBucketRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Request message for ListChannels.
type ListChannelsRequest struct {
	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,3,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ListChannelsRequest) Reset()         { *m = ListChannelsRequest{} }
func (m *ListChannelsRequest) String() string { return proto.CompactTextString(m) }
func (*ListChannelsRequest) ProtoMessage()    {}
func (*ListChannelsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{9}
}

func (m *ListChannelsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListChannelsRequest.Unmarshal(m, b)
}
func (m *ListChannelsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListChannelsRequest.Marshal(b, m, deterministic)
}
func (m *ListChannelsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListChannelsRequest.Merge(m, src)
}
func (m *ListChannelsRequest) XXX_Size() int {
	return xxx_messageInfo_ListChannelsRequest.Size(m)
}
func (m *ListChannelsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListChannelsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListChannelsRequest proto.InternalMessageInfo

func (m *ListChannelsRequest) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *ListChannelsRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Request message for ListBuckets.
type ListBucketsRequest struct {
	// Maximum number of buckets to return in a single response. The service will
	// use this parameter or 1,000 items, whichever is smaller.
	MaxResults int32 `protobuf:"varint,1,opt,name=max_results,json=maxResults,proto3" json:"max_results,omitempty"`
	// A previously-returned page token representing part of the larger set of
	// results to view.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filter results to buckets whose names begin with this prefix.
	Prefix string `protobuf:"bytes,3,opt,name=prefix,proto3" json:"prefix,omitempty"`
	// Required. A valid API project identifier.
	Project string `protobuf:"bytes,4,opt,name=project,proto3" json:"project,omitempty"`
	// Set of properties to return. Defaults to `NO_ACL`.
	Projection CommonEnums_Projection `protobuf:"varint,5,opt,name=projection,proto3,enum=google.storage.v1.CommonEnums_Projection" json:"projection,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,7,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ListBucketsRequest) Reset()         { *m = ListBucketsRequest{} }
func (m *ListBucketsRequest) String() string { return proto.CompactTextString(m) }
func (*ListBucketsRequest) ProtoMessage()    {}
func (*ListBucketsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{10}
}

func (m *ListBucketsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListBucketsRequest.Unmarshal(m, b)
}
func (m *ListBucketsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListBucketsRequest.Marshal(b, m, deterministic)
}
func (m *ListBucketsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListBucketsRequest.Merge(m, src)
}
func (m *ListBucketsRequest) XXX_Size() int {
	return xxx_messageInfo_ListBucketsRequest.Size(m)
}
func (m *ListBucketsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListBucketsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListBucketsRequest proto.InternalMessageInfo

func (m *ListBucketsRequest) GetMaxResults() int32 {
	if m != nil {
		return m.MaxResults
	}
	return 0
}

func (m *ListBucketsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListBucketsRequest) GetPrefix() string {
	if m != nil {
		return m.Prefix
	}
	return ""
}

func (m *ListBucketsRequest) GetProject() string {
	if m != nil {
		return m.Project
	}
	return ""
}

func (m *ListBucketsRequest) GetProjection() CommonEnums_Projection {
	if m != nil {
		return m.Projection
	}
	return CommonEnums_PROJECTION_UNSPECIFIED
}

func (m *ListBucketsRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Request message for LockRetentionPolicy.
type LockRetentionPolicyRequest struct {
	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Makes the operation conditional on whether bucket's current metageneration
	// matches the given value. Must be positive.
	IfMetagenerationMatch int64 `protobuf:"varint,2,opt,name=if_metageneration_match,json=ifMetagenerationMatch,proto3" json:"if_metageneration_match,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,4,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *LockRetentionPolicyRequest) Reset()         { *m = LockRetentionPolicyRequest{} }
func (m *LockRetentionPolicyRequest) String() string { return proto.CompactTextString(m) }
func (*LockRetentionPolicyRequest) ProtoMessage()    {}
func (*LockRetentionPolicyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{11}
}

func (m *LockRetentionPolicyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LockRetentionPolicyRequest.Unmarshal(m, b)
}
func (m *LockRetentionPolicyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LockRetentionPolicyRequest.Marshal(b, m, deterministic)
}
func (m *LockRetentionPolicyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LockRetentionPolicyRequest.Merge(m, src)
}
func (m *LockRetentionPolicyRequest) XXX_Size() int {
	return xxx_messageInfo_LockRetentionPolicyRequest.Size(m)
}
func (m *LockRetentionPolicyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_LockRetentionPolicyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_LockRetentionPolicyRequest proto.InternalMessageInfo

func (m *LockRetentionPolicyRequest) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *LockRetentionPolicyRequest) GetIfMetagenerationMatch() int64 {
	if m != nil {
		return m.IfMetagenerationMatch
	}
	return 0
}

func (m *LockRetentionPolicyRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Request for PatchBucket method.
type PatchBucketRequest struct {
	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Makes the return of the bucket metadata conditional on whether the bucket's
	// current metageneration matches the given value.
	IfMetagenerationMatch *wrappers.Int64Value `protobuf:"bytes,2,opt,name=if_metageneration_match,json=ifMetagenerationMatch,proto3" json:"if_metageneration_match,omitempty"`
	// Makes the return of the bucket metadata conditional on whether the bucket's
	// current metageneration does not match the given value.
	IfMetagenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,3,opt,name=if_metageneration_not_match,json=ifMetagenerationNotMatch,proto3" json:"if_metageneration_not_match,omitempty"`
	// Apply a predefined set of access controls to this bucket.
	PredefinedAcl CommonEnums_PredefinedBucketAcl `protobuf:"varint,4,opt,name=predefined_acl,json=predefinedAcl,proto3,enum=google.storage.v1.CommonEnums_PredefinedBucketAcl" json:"predefined_acl,omitempty"`
	// Apply a predefined set of default object access controls to this bucket.
	PredefinedDefaultObjectAcl CommonEnums_PredefinedObjectAcl `protobuf:"varint,5,opt,name=predefined_default_object_acl,json=predefinedDefaultObjectAcl,proto3,enum=google.storage.v1.CommonEnums_PredefinedObjectAcl" json:"predefined_default_object_acl,omitempty"`
	// Set of properties to return. Defaults to `FULL`.
	Projection CommonEnums_Projection `protobuf:"varint,6,opt,name=projection,proto3,enum=google.storage.v1.CommonEnums_Projection" json:"projection,omitempty"`
	// The Bucket metadata for updating.
	Metadata *Bucket `protobuf:"bytes,8,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// List of fields to be updated.
	//
	// To specify ALL fields, equivalent to the JSON API's "update" function,
	// specify a single field with the value `*`. Note: not recommended. If a new
	// field is introduced at a later time, an older client updating with the `*`
	// may accidentally reset the new field's value.
	//
	// Not specifying any fields is an error.
	// Not specifying a field while setting that field to a non-default value is
	// an error.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,9,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,10,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *PatchBucketRequest) Reset()         { *m = PatchBucketRequest{} }
func (m *PatchBucketRequest) String() string { return proto.CompactTextString(m) }
func (*PatchBucketRequest) ProtoMessage()    {}
func (*PatchBucketRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{12}
}

func (m *PatchBucketRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PatchBucketRequest.Unmarshal(m, b)
}
func (m *PatchBucketRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PatchBucketRequest.Marshal(b, m, deterministic)
}
func (m *PatchBucketRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PatchBucketRequest.Merge(m, src)
}
func (m *PatchBucketRequest) XXX_Size() int {
	return xxx_messageInfo_PatchBucketRequest.Size(m)
}
func (m *PatchBucketRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PatchBucketRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PatchBucketRequest proto.InternalMessageInfo

func (m *PatchBucketRequest) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *PatchBucketRequest) GetIfMetagenerationMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfMetagenerationMatch
	}
	return nil
}

func (m *PatchBucketRequest) GetIfMetagenerationNotMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfMetagenerationNotMatch
	}
	return nil
}

func (m *PatchBucketRequest) GetPredefinedAcl() CommonEnums_PredefinedBucketAcl {
	if m != nil {
		return m.PredefinedAcl
	}
	return CommonEnums_PREDEFINED_BUCKET_ACL_UNSPECIFIED
}

func (m *PatchBucketRequest) GetPredefinedDefaultObjectAcl() CommonEnums_PredefinedObjectAcl {
	if m != nil {
		return m.PredefinedDefaultObjectAcl
	}
	return CommonEnums_PREDEFINED_OBJECT_ACL_UNSPECIFIED
}

func (m *PatchBucketRequest) GetProjection() CommonEnums_Projection {
	if m != nil {
		return m.Projection
	}
	return CommonEnums_PROJECTION_UNSPECIFIED
}

func (m *PatchBucketRequest) GetMetadata() *Bucket {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PatchBucketRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *PatchBucketRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Request for UpdateBucket method.
type UpdateBucketRequest struct {
	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Makes the return of the bucket metadata conditional on whether the bucket's
	// current metageneration matches the given value.
	IfMetagenerationMatch *wrappers.Int64Value `protobuf:"bytes,2,opt,name=if_metageneration_match,json=ifMetagenerationMatch,proto3" json:"if_metageneration_match,omitempty"`
	// Makes the return of the bucket metadata conditional on whether the bucket's
	// current metageneration does not match the given value.
	IfMetagenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,3,opt,name=if_metageneration_not_match,json=ifMetagenerationNotMatch,proto3" json:"if_metageneration_not_match,omitempty"`
	// Apply a predefined set of access controls to this bucket.
	PredefinedAcl CommonEnums_PredefinedBucketAcl `protobuf:"varint,4,opt,name=predefined_acl,json=predefinedAcl,proto3,enum=google.storage.v1.CommonEnums_PredefinedBucketAcl" json:"predefined_acl,omitempty"`
	// Apply a predefined set of default object access controls to this bucket.
	PredefinedDefaultObjectAcl CommonEnums_PredefinedObjectAcl `protobuf:"varint,5,opt,name=predefined_default_object_acl,json=predefinedDefaultObjectAcl,proto3,enum=google.storage.v1.CommonEnums_PredefinedObjectAcl" json:"predefined_default_object_acl,omitempty"`
	// Set of properties to return. Defaults to `FULL`.
	Projection CommonEnums_Projection `protobuf:"varint,6,opt,name=projection,proto3,enum=google.storage.v1.CommonEnums_Projection" json:"projection,omitempty"`
	// The Bucket metadata for updating.
	Metadata *Bucket `protobuf:"bytes,8,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,9,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *UpdateBucketRequest) Reset()         { *m = UpdateBucketRequest{} }
func (m *UpdateBucketRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateBucketRequest) ProtoMessage()    {}
func (*UpdateBucketRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{13}
}

func (m *UpdateBucketRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateBucketRequest.Unmarshal(m, b)
}
func (m *UpdateBucketRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateBucketRequest.Marshal(b, m, deterministic)
}
func (m *UpdateBucketRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateBucketRequest.Merge(m, src)
}
func (m *UpdateBucketRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateBucketRequest.Size(m)
}
func (m *UpdateBucketRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateBucketRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateBucketRequest proto.InternalMessageInfo

func (m *UpdateBucketRequest) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *UpdateBucketRequest) GetIfMetagenerationMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfMetagenerationMatch
	}
	return nil
}

func (m *UpdateBucketRequest) GetIfMetagenerationNotMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfMetagenerationNotMatch
	}
	return nil
}

func (m *UpdateBucketRequest) GetPredefinedAcl() CommonEnums_PredefinedBucketAcl {
	if m != nil {
		return m.PredefinedAcl
	}
	return CommonEnums_PREDEFINED_BUCKET_ACL_UNSPECIFIED
}

func (m *UpdateBucketRequest) GetPredefinedDefaultObjectAcl() CommonEnums_PredefinedObjectAcl {
	if m != nil {
		return m.PredefinedDefaultObjectAcl
	}
	return CommonEnums_PREDEFINED_OBJECT_ACL_UNSPECIFIED
}

func (m *UpdateBucketRequest) GetProjection() CommonEnums_Projection {
	if m != nil {
		return m.Projection
	}
	return CommonEnums_PROJECTION_UNSPECIFIED
}

func (m *UpdateBucketRequest) GetMetadata() *Bucket {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *UpdateBucketRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Request message for StopChannel.
type StopChannelRequest struct {
	// The channel to be stopped.
	Channel *Channel `protobuf:"bytes,1,opt,name=channel,proto3" json:"channel,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,2,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *StopChannelRequest) Reset()         { *m = StopChannelRequest{} }
func (m *StopChannelRequest) String() string { return proto.CompactTextString(m) }
func (*StopChannelRequest) ProtoMessage()    {}
func (*StopChannelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{14}
}

func (m *StopChannelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StopChannelRequest.Unmarshal(m, b)
}
func (m *StopChannelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StopChannelRequest.Marshal(b, m, deterministic)
}
func (m *StopChannelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StopChannelRequest.Merge(m, src)
}
func (m *StopChannelRequest) XXX_Size() int {
	return xxx_messageInfo_StopChannelRequest.Size(m)
}
func (m *StopChannelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StopChannelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StopChannelRequest proto.InternalMessageInfo

func (m *StopChannelRequest) GetChannel() *Channel {
	if m != nil {
		return m.Channel
	}
	return nil
}

func (m *StopChannelRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Request message for DeleteDefaultObjectAccessControl.
type DeleteDefaultObjectAccessControlRequest struct {
	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. The entity holding the permission. Can be one of:
	// * `user-`*userId*
	// * `user-`*emailAddress*
	// * `group-`*groupId*
	// * `group-`*emailAddress*
	// * `allUsers`
	// * `allAuthenticatedUsers`
	Entity string `protobuf:"bytes,2,opt,name=entity,proto3" json:"entity,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,4,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *DeleteDefaultObjectAccessControlRequest) Reset() {
	*m = DeleteDefaultObjectAccessControlRequest{}
}
func (m *DeleteDefaultObjectAccessControlRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteDefaultObjectAccessControlRequest) ProtoMessage()    {}
func (*DeleteDefaultObjectAccessControlRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{15}
}

func (m *DeleteDefaultObjectAccessControlRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteDefaultObjectAccessControlRequest.Unmarshal(m, b)
}
func (m *DeleteDefaultObjectAccessControlRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteDefaultObjectAccessControlRequest.Marshal(b, m, deterministic)
}
func (m *DeleteDefaultObjectAccessControlRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteDefaultObjectAccessControlRequest.Merge(m, src)
}
func (m *DeleteDefaultObjectAccessControlRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteDefaultObjectAccessControlRequest.Size(m)
}
func (m *DeleteDefaultObjectAccessControlRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteDefaultObjectAccessControlRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteDefaultObjectAccessControlRequest proto.InternalMessageInfo

func (m *DeleteDefaultObjectAccessControlRequest) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *DeleteDefaultObjectAccessControlRequest) GetEntity() string {
	if m != nil {
		return m.Entity
	}
	return ""
}

func (m *DeleteDefaultObjectAccessControlRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Request message for GetDefaultObjectAccessControl.
type GetDefaultObjectAccessControlRequest struct {
	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. The entity holding the permission. Can be one of:
	// * `user-`*userId*
	// * `user-`*emailAddress*
	// * `group-`*groupId*
	// * `group-`*emailAddress*
	// * `allUsers`
	// * `allAuthenticatedUsers`
	Entity string `protobuf:"bytes,2,opt,name=entity,proto3" json:"entity,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,4,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *GetDefaultObjectAccessControlRequest) Reset()         { *m = GetDefaultObjectAccessControlRequest{} }
func (m *GetDefaultObjectAccessControlRequest) String() string { return proto.CompactTextString(m) }
func (*GetDefaultObjectAccessControlRequest) ProtoMessage()    {}
func (*GetDefaultObjectAccessControlRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{16}
}

func (m *GetDefaultObjectAccessControlRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetDefaultObjectAccessControlRequest.Unmarshal(m, b)
}
func (m *GetDefaultObjectAccessControlRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetDefaultObjectAccessControlRequest.Marshal(b, m, deterministic)
}
func (m *GetDefaultObjectAccessControlRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDefaultObjectAccessControlRequest.Merge(m, src)
}
func (m *GetDefaultObjectAccessControlRequest) XXX_Size() int {
	return xxx_messageInfo_GetDefaultObjectAccessControlRequest.Size(m)
}
func (m *GetDefaultObjectAccessControlRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDefaultObjectAccessControlRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDefaultObjectAccessControlRequest proto.InternalMessageInfo

func (m *GetDefaultObjectAccessControlRequest) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *GetDefaultObjectAccessControlRequest) GetEntity() string {
	if m != nil {
		return m.Entity
	}
	return ""
}

func (m *GetDefaultObjectAccessControlRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Request message for InsertDefaultObjectAccessControl.
type InsertDefaultObjectAccessControlRequest struct {
	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Properties of the object access control being inserted.
	ObjectAccessControl *ObjectAccessControl `protobuf:"bytes,3,opt,name=object_access_control,json=objectAccessControl,proto3" json:"object_access_control,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,4,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *InsertDefaultObjectAccessControlRequest) Reset() {
	*m = InsertDefaultObjectAccessControlRequest{}
}
func (m *InsertDefaultObjectAccessControlRequest) String() string { return proto.CompactTextString(m) }
func (*InsertDefaultObjectAccessControlRequest) ProtoMessage()    {}
func (*InsertDefaultObjectAccessControlRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{17}
}

func (m *InsertDefaultObjectAccessControlRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InsertDefaultObjectAccessControlRequest.Unmarshal(m, b)
}
func (m *InsertDefaultObjectAccessControlRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InsertDefaultObjectAccessControlRequest.Marshal(b, m, deterministic)
}
func (m *InsertDefaultObjectAccessControlRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InsertDefaultObjectAccessControlRequest.Merge(m, src)
}
func (m *InsertDefaultObjectAccessControlRequest) XXX_Size() int {
	return xxx_messageInfo_InsertDefaultObjectAccessControlRequest.Size(m)
}
func (m *InsertDefaultObjectAccessControlRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_InsertDefaultObjectAccessControlRequest.DiscardUnknown(m)
}

var xxx_messageInfo_InsertDefaultObjectAccessControlRequest proto.InternalMessageInfo

func (m *InsertDefaultObjectAccessControlRequest) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *InsertDefaultObjectAccessControlRequest) GetObjectAccessControl() *ObjectAccessControl {
	if m != nil {
		return m.ObjectAccessControl
	}
	return nil
}

func (m *InsertDefaultObjectAccessControlRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Request message for ListDefaultObjectAccessControls.
type ListDefaultObjectAccessControlsRequest struct {
	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// If present, only return default ACL listing if the bucket's current
	// metageneration matches this value.
	IfMetagenerationMatch *wrappers.Int64Value `protobuf:"bytes,2,opt,name=if_metageneration_match,json=ifMetagenerationMatch,proto3" json:"if_metageneration_match,omitempty"`
	// If present, only return default ACL listing if the bucket's current
	// metageneration does not match the given value.
	IfMetagenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,3,opt,name=if_metageneration_not_match,json=ifMetagenerationNotMatch,proto3" json:"if_metageneration_not_match,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,5,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ListDefaultObjectAccessControlsRequest) Reset() {
	*m = ListDefaultObjectAccessControlsRequest{}
}
func (m *ListDefaultObjectAccessControlsRequest) String() string { return proto.CompactTextString(m) }
func (*ListDefaultObjectAccessControlsRequest) ProtoMessage()    {}
func (*ListDefaultObjectAccessControlsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{18}
}

func (m *ListDefaultObjectAccessControlsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDefaultObjectAccessControlsRequest.Unmarshal(m, b)
}
func (m *ListDefaultObjectAccessControlsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDefaultObjectAccessControlsRequest.Marshal(b, m, deterministic)
}
func (m *ListDefaultObjectAccessControlsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDefaultObjectAccessControlsRequest.Merge(m, src)
}
func (m *ListDefaultObjectAccessControlsRequest) XXX_Size() int {
	return xxx_messageInfo_ListDefaultObjectAccessControlsRequest.Size(m)
}
func (m *ListDefaultObjectAccessControlsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDefaultObjectAccessControlsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListDefaultObjectAccessControlsRequest proto.InternalMessageInfo

func (m *ListDefaultObjectAccessControlsRequest) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *ListDefaultObjectAccessControlsRequest) GetIfMetagenerationMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfMetagenerationMatch
	}
	return nil
}

func (m *ListDefaultObjectAccessControlsRequest) GetIfMetagenerationNotMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfMetagenerationNotMatch
	}
	return nil
}

func (m *ListDefaultObjectAccessControlsRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Request message for PatchDefaultObjectAccessControl.
type PatchDefaultObjectAccessControlRequest struct {
	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. The entity holding the permission. Can be one of:
	// * `user-`*userId*
	// * `user-`*emailAddress*
	// * `group-`*groupId*
	// * `group-`*emailAddress*
	// * `allUsers`
	// * `allAuthenticatedUsers`
	Entity string `protobuf:"bytes,2,opt,name=entity,proto3" json:"entity,omitempty"`
	// The ObjectAccessControl for updating.
	ObjectAccessControl *ObjectAccessControl `protobuf:"bytes,4,opt,name=object_access_control,json=objectAccessControl,proto3" json:"object_access_control,omitempty"`
	// List of fields to be updated.
	//
	// To specify ALL fields, equivalent to the JSON API's "update" function,
	// specify a single field with the value `*`. Note: not recommended. If a new
	// field is introduced at a later time, an older client updating with the `*`
	// may accidentally reset the new field's value.
	//
	// Not specifying any fields is an error.
	// Not specifying a field while setting that field to a non-default value is
	// an error.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,5,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,6,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *PatchDefaultObjectAccessControlRequest) Reset() {
	*m = PatchDefaultObjectAccessControlRequest{}
}
func (m *PatchDefaultObjectAccessControlRequest) String() string { return proto.CompactTextString(m) }
func (*PatchDefaultObjectAccessControlRequest) ProtoMessage()    {}
func (*PatchDefaultObjectAccessControlRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{19}
}

func (m *PatchDefaultObjectAccessControlRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PatchDefaultObjectAccessControlRequest.Unmarshal(m, b)
}
func (m *PatchDefaultObjectAccessControlRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PatchDefaultObjectAccessControlRequest.Marshal(b, m, deterministic)
}
func (m *PatchDefaultObjectAccessControlRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PatchDefaultObjectAccessControlRequest.Merge(m, src)
}
func (m *PatchDefaultObjectAccessControlRequest) XXX_Size() int {
	return xxx_messageInfo_PatchDefaultObjectAccessControlRequest.Size(m)
}
func (m *PatchDefaultObjectAccessControlRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PatchDefaultObjectAccessControlRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PatchDefaultObjectAccessControlRequest proto.InternalMessageInfo

func (m *PatchDefaultObjectAccessControlRequest) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *PatchDefaultObjectAccessControlRequest) GetEntity() string {
	if m != nil {
		return m.Entity
	}
	return ""
}

func (m *PatchDefaultObjectAccessControlRequest) GetObjectAccessControl() *ObjectAccessControl {
	if m != nil {
		return m.ObjectAccessControl
	}
	return nil
}

func (m *PatchDefaultObjectAccessControlRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *PatchDefaultObjectAccessControlRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Request message for UpdateDefaultObjectAccessControl.
type UpdateDefaultObjectAccessControlRequest struct {
	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. The entity holding the permission. Can be one of:
	// * `user-`*userId*
	// * `user-`*emailAddress*
	// * `group-`*groupId*
	// * `group-`*emailAddress*
	// * `allUsers`
	// * `allAuthenticatedUsers`
	Entity string `protobuf:"bytes,2,opt,name=entity,proto3" json:"entity,omitempty"`
	// The ObjectAccessControl for updating.
	ObjectAccessControl *ObjectAccessControl `protobuf:"bytes,4,opt,name=object_access_control,json=objectAccessControl,proto3" json:"object_access_control,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,5,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *UpdateDefaultObjectAccessControlRequest) Reset() {
	*m = UpdateDefaultObjectAccessControlRequest{}
}
func (m *UpdateDefaultObjectAccessControlRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateDefaultObjectAccessControlRequest) ProtoMessage()    {}
func (*UpdateDefaultObjectAccessControlRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{20}
}

func (m *UpdateDefaultObjectAccessControlRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateDefaultObjectAccessControlRequest.Unmarshal(m, b)
}
func (m *UpdateDefaultObjectAccessControlRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateDefaultObjectAccessControlRequest.Marshal(b, m, deterministic)
}
func (m *UpdateDefaultObjectAccessControlRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateDefaultObjectAccessControlRequest.Merge(m, src)
}
func (m *UpdateDefaultObjectAccessControlRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateDefaultObjectAccessControlRequest.Size(m)
}
func (m *UpdateDefaultObjectAccessControlRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateDefaultObjectAccessControlRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateDefaultObjectAccessControlRequest proto.InternalMessageInfo

func (m *UpdateDefaultObjectAccessControlRequest) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *UpdateDefaultObjectAccessControlRequest) GetEntity() string {
	if m != nil {
		return m.Entity
	}
	return ""
}

func (m *UpdateDefaultObjectAccessControlRequest) GetObjectAccessControl() *ObjectAccessControl {
	if m != nil {
		return m.ObjectAccessControl
	}
	return nil
}

func (m *UpdateDefaultObjectAccessControlRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Request message for DeleteNotification.
type DeleteNotificationRequest struct {
	// Required. The parent bucket of the notification.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. ID of the notification to delete.
	Notification string `protobuf:"bytes,2,opt,name=notification,proto3" json:"notification,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,4,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *DeleteNotificationRequest) Reset()         { *m = DeleteNotificationRequest{} }
func (m *DeleteNotificationRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteNotificationRequest) ProtoMessage()    {}
func (*DeleteNotificationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{21}
}

func (m *DeleteNotificationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteNotificationRequest.Unmarshal(m, b)
}
func (m *DeleteNotificationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteNotificationRequest.Marshal(b, m, deterministic)
}
func (m *DeleteNotificationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteNotificationRequest.Merge(m, src)
}
func (m *DeleteNotificationRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteNotificationRequest.Size(m)
}
func (m *DeleteNotificationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteNotificationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteNotificationRequest proto.InternalMessageInfo

func (m *DeleteNotificationRequest) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *DeleteNotificationRequest) GetNotification() string {
	if m != nil {
		return m.Notification
	}
	return ""
}

func (m *DeleteNotificationRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Request message for GetNotification.
type GetNotificationRequest struct {
	// Required. The parent bucket of the notification.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. Notification ID.
	// Required.
	Notification string `protobuf:"bytes,2,opt,name=notification,proto3" json:"notification,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,4,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *GetNotificationRequest) Reset()         { *m = GetNotificationRequest{} }
func (m *GetNotificationRequest) String() string { return proto.CompactTextString(m) }
func (*GetNotificationRequest) ProtoMessage()    {}
func (*GetNotificationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{22}
}

func (m *GetNotificationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetNotificationRequest.Unmarshal(m, b)
}
func (m *GetNotificationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetNotificationRequest.Marshal(b, m, deterministic)
}
func (m *GetNotificationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetNotificationRequest.Merge(m, src)
}
func (m *GetNotificationRequest) XXX_Size() int {
	return xxx_messageInfo_GetNotificationRequest.Size(m)
}
func (m *GetNotificationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetNotificationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetNotificationRequest proto.InternalMessageInfo

func (m *GetNotificationRequest) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *GetNotificationRequest) GetNotification() string {
	if m != nil {
		return m.Notification
	}
	return ""
}

func (m *GetNotificationRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Request message for InsertNotification.
type InsertNotificationRequest struct {
	// Required. The parent bucket of the notification.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Properties of the notification to be inserted.
	Notification *Notification `protobuf:"bytes,3,opt,name=notification,proto3" json:"notification,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,4,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *InsertNotificationRequest) Reset()         { *m = InsertNotificationRequest{} }
func (m *InsertNotificationRequest) String() string { return proto.CompactTextString(m) }
func (*InsertNotificationRequest) ProtoMessage()    {}
func (*InsertNotificationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{23}
}

func (m *InsertNotificationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InsertNotificationRequest.Unmarshal(m, b)
}
func (m *InsertNotificationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InsertNotificationRequest.Marshal(b, m, deterministic)
}
func (m *InsertNotificationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InsertNotificationRequest.Merge(m, src)
}
func (m *InsertNotificationRequest) XXX_Size() int {
	return xxx_messageInfo_InsertNotificationRequest.Size(m)
}
func (m *InsertNotificationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_InsertNotificationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_InsertNotificationRequest proto.InternalMessageInfo

func (m *InsertNotificationRequest) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *InsertNotificationRequest) GetNotification() *Notification {
	if m != nil {
		return m.Notification
	}
	return nil
}

func (m *InsertNotificationRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Request message for ListNotifications.
type ListNotificationsRequest struct {
	// Required. Name of a Google Cloud Storage bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,3,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ListNotificationsRequest) Reset()         { *m = ListNotificationsRequest{} }
func (m *ListNotificationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListNotificationsRequest) ProtoMessage()    {}
func (*ListNotificationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{24}
}

func (m *ListNotificationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListNotificationsRequest.Unmarshal(m, b)
}
func (m *ListNotificationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListNotificationsRequest.Marshal(b, m, deterministic)
}
func (m *ListNotificationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListNotificationsRequest.Merge(m, src)
}
func (m *ListNotificationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListNotificationsRequest.Size(m)
}
func (m *ListNotificationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListNotificationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListNotificationsRequest proto.InternalMessageInfo

func (m *ListNotificationsRequest) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *ListNotificationsRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Request message for DeleteObjectAccessControl.
type DeleteObjectAccessControlRequest struct {
	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. The entity holding the permission. Can be one of:
	// * `user-`*userId*
	// * `user-`*emailAddress*
	// * `group-`*groupId*
	// * `group-`*emailAddress*
	// * `allUsers`
	// * `allAuthenticatedUsers`
	Entity string `protobuf:"bytes,2,opt,name=entity,proto3" json:"entity,omitempty"`
	// Required. Name of the object.
	Object string `protobuf:"bytes,3,opt,name=object,proto3" json:"object,omitempty"`
	// If present, selects a specific revision of this object (as opposed to the
	// latest version, the default).
	Generation int64 `protobuf:"varint,4,opt,name=generation,proto3" json:"generation,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,6,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *DeleteObjectAccessControlRequest) Reset()         { *m = DeleteObjectAccessControlRequest{} }
func (m *DeleteObjectAccessControlRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteObjectAccessControlRequest) ProtoMessage()    {}
func (*DeleteObjectAccessControlRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{25}
}

func (m *DeleteObjectAccessControlRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteObjectAccessControlRequest.Unmarshal(m, b)
}
func (m *DeleteObjectAccessControlRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteObjectAccessControlRequest.Marshal(b, m, deterministic)
}
func (m *DeleteObjectAccessControlRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteObjectAccessControlRequest.Merge(m, src)
}
func (m *DeleteObjectAccessControlRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteObjectAccessControlRequest.Size(m)
}
func (m *DeleteObjectAccessControlRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteObjectAccessControlRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteObjectAccessControlRequest proto.InternalMessageInfo

func (m *DeleteObjectAccessControlRequest) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *DeleteObjectAccessControlRequest) GetEntity() string {
	if m != nil {
		return m.Entity
	}
	return ""
}

func (m *DeleteObjectAccessControlRequest) GetObject() string {
	if m != nil {
		return m.Object
	}
	return ""
}

func (m *DeleteObjectAccessControlRequest) GetGeneration() int64 {
	if m != nil {
		return m.Generation
	}
	return 0
}

func (m *DeleteObjectAccessControlRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Request message for GetObjectAccessControl.
type GetObjectAccessControlRequest struct {
	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. The entity holding the permission. Can be one of:
	// * `user-`*userId*
	// * `user-`*emailAddress*
	// * `group-`*groupId*
	// * `group-`*emailAddress*
	// * `allUsers`
	// * `allAuthenticatedUsers`
	Entity string `protobuf:"bytes,2,opt,name=entity,proto3" json:"entity,omitempty"`
	// Required. Name of the object.
	Object string `protobuf:"bytes,3,opt,name=object,proto3" json:"object,omitempty"`
	// If present, selects a specific revision of this object (as opposed to the
	// latest version, the default).
	Generation int64 `protobuf:"varint,4,opt,name=generation,proto3" json:"generation,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,6,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *GetObjectAccessControlRequest) Reset()         { *m = GetObjectAccessControlRequest{} }
func (m *GetObjectAccessControlRequest) String() string { return proto.CompactTextString(m) }
func (*GetObjectAccessControlRequest) ProtoMessage()    {}
func (*GetObjectAccessControlRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{26}
}

func (m *GetObjectAccessControlRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetObjectAccessControlRequest.Unmarshal(m, b)
}
func (m *GetObjectAccessControlRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetObjectAccessControlRequest.Marshal(b, m, deterministic)
}
func (m *GetObjectAccessControlRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetObjectAccessControlRequest.Merge(m, src)
}
func (m *GetObjectAccessControlRequest) XXX_Size() int {
	return xxx_messageInfo_GetObjectAccessControlRequest.Size(m)
}
func (m *GetObjectAccessControlRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetObjectAccessControlRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetObjectAccessControlRequest proto.InternalMessageInfo

func (m *GetObjectAccessControlRequest) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *GetObjectAccessControlRequest) GetEntity() string {
	if m != nil {
		return m.Entity
	}
	return ""
}

func (m *GetObjectAccessControlRequest) GetObject() string {
	if m != nil {
		return m.Object
	}
	return ""
}

func (m *GetObjectAccessControlRequest) GetGeneration() int64 {
	if m != nil {
		return m.Generation
	}
	return 0
}

func (m *GetObjectAccessControlRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Request message for InsertObjectAccessControl.
type InsertObjectAccessControlRequest struct {
	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. Name of the object.
	Object string `protobuf:"bytes,2,opt,name=object,proto3" json:"object,omitempty"`
	// If present, selects a specific revision of this object (as opposed to the
	// latest version, the default).
	Generation int64 `protobuf:"varint,3,opt,name=generation,proto3" json:"generation,omitempty"`
	// Properties of the object access control to be inserted.
	ObjectAccessControl *ObjectAccessControl `protobuf:"bytes,5,opt,name=object_access_control,json=objectAccessControl,proto3" json:"object_access_control,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,6,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *InsertObjectAccessControlRequest) Reset()         { *m = InsertObjectAccessControlRequest{} }
func (m *InsertObjectAccessControlRequest) String() string { return proto.CompactTextString(m) }
func (*InsertObjectAccessControlRequest) ProtoMessage()    {}
func (*InsertObjectAccessControlRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{27}
}

func (m *InsertObjectAccessControlRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InsertObjectAccessControlRequest.Unmarshal(m, b)
}
func (m *InsertObjectAccessControlRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InsertObjectAccessControlRequest.Marshal(b, m, deterministic)
}
func (m *InsertObjectAccessControlRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InsertObjectAccessControlRequest.Merge(m, src)
}
func (m *InsertObjectAccessControlRequest) XXX_Size() int {
	return xxx_messageInfo_InsertObjectAccessControlRequest.Size(m)
}
func (m *InsertObjectAccessControlRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_InsertObjectAccessControlRequest.DiscardUnknown(m)
}

var xxx_messageInfo_InsertObjectAccessControlRequest proto.InternalMessageInfo

func (m *InsertObjectAccessControlRequest) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *InsertObjectAccessControlRequest) GetObject() string {
	if m != nil {
		return m.Object
	}
	return ""
}

func (m *InsertObjectAccessControlRequest) GetGeneration() int64 {
	if m != nil {
		return m.Generation
	}
	return 0
}

func (m *InsertObjectAccessControlRequest) GetObjectAccessControl() *ObjectAccessControl {
	if m != nil {
		return m.ObjectAccessControl
	}
	return nil
}

func (m *InsertObjectAccessControlRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Request message for ListObjectAccessControls.
type ListObjectAccessControlsRequest struct {
	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. Name of the object.
	Object string `protobuf:"bytes,2,opt,name=object,proto3" json:"object,omitempty"`
	// If present, selects a specific revision of this object (as opposed to the
	// latest version, the default).
	Generation int64 `protobuf:"varint,3,opt,name=generation,proto3" json:"generation,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,5,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ListObjectAccessControlsRequest) Reset()         { *m = ListObjectAccessControlsRequest{} }
func (m *ListObjectAccessControlsRequest) String() string { return proto.CompactTextString(m) }
func (*ListObjectAccessControlsRequest) ProtoMessage()    {}
func (*ListObjectAccessControlsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{28}
}

func (m *ListObjectAccessControlsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListObjectAccessControlsRequest.Unmarshal(m, b)
}
func (m *ListObjectAccessControlsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListObjectAccessControlsRequest.Marshal(b, m, deterministic)
}
func (m *ListObjectAccessControlsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListObjectAccessControlsRequest.Merge(m, src)
}
func (m *ListObjectAccessControlsRequest) XXX_Size() int {
	return xxx_messageInfo_ListObjectAccessControlsRequest.Size(m)
}
func (m *ListObjectAccessControlsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListObjectAccessControlsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListObjectAccessControlsRequest proto.InternalMessageInfo

func (m *ListObjectAccessControlsRequest) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *ListObjectAccessControlsRequest) GetObject() string {
	if m != nil {
		return m.Object
	}
	return ""
}

func (m *ListObjectAccessControlsRequest) GetGeneration() int64 {
	if m != nil {
		return m.Generation
	}
	return 0
}

func (m *ListObjectAccessControlsRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Request message for UpdateObjetAccessControl.
type UpdateObjectAccessControlRequest struct {
	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. The entity holding the permission. Can be one of:
	// * `user-`*userId*
	// * `user-`*emailAddress*
	// * `group-`*groupId*
	// * `group-`*emailAddress*
	// * `allUsers`
	// * `allAuthenticatedUsers`
	Entity string `protobuf:"bytes,2,opt,name=entity,proto3" json:"entity,omitempty"`
	// Required. Name of the object.
	// Required.
	Object string `protobuf:"bytes,3,opt,name=object,proto3" json:"object,omitempty"`
	// If present, selects a specific revision of this object (as opposed to the
	// latest version, the default).
	Generation int64 `protobuf:"varint,4,opt,name=generation,proto3" json:"generation,omitempty"`
	// The ObjectAccessControl for updating.
	ObjectAccessControl *ObjectAccessControl `protobuf:"bytes,6,opt,name=object_access_control,json=objectAccessControl,proto3" json:"object_access_control,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,7,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	// List of fields to be updated.
	//
	// To specify ALL fields, equivalent to the JSON API's "update" function,
	// specify a single field with the value `*`. Note: not recommended. If a new
	// field is introduced at a later time, an older client updating with the `*`
	// may accidentally reset the new field's value.
	//
	// Not specifying any fields is an error.
	// Not specifying a field while setting that field to a non-default value is
	// an error.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,8,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateObjectAccessControlRequest) Reset()         { *m = UpdateObjectAccessControlRequest{} }
func (m *UpdateObjectAccessControlRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateObjectAccessControlRequest) ProtoMessage()    {}
func (*UpdateObjectAccessControlRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{29}
}

func (m *UpdateObjectAccessControlRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateObjectAccessControlRequest.Unmarshal(m, b)
}
func (m *UpdateObjectAccessControlRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateObjectAccessControlRequest.Marshal(b, m, deterministic)
}
func (m *UpdateObjectAccessControlRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateObjectAccessControlRequest.Merge(m, src)
}
func (m *UpdateObjectAccessControlRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateObjectAccessControlRequest.Size(m)
}
func (m *UpdateObjectAccessControlRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateObjectAccessControlRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateObjectAccessControlRequest proto.InternalMessageInfo

func (m *UpdateObjectAccessControlRequest) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *UpdateObjectAccessControlRequest) GetEntity() string {
	if m != nil {
		return m.Entity
	}
	return ""
}

func (m *UpdateObjectAccessControlRequest) GetObject() string {
	if m != nil {
		return m.Object
	}
	return ""
}

func (m *UpdateObjectAccessControlRequest) GetGeneration() int64 {
	if m != nil {
		return m.Generation
	}
	return 0
}

func (m *UpdateObjectAccessControlRequest) GetObjectAccessControl() *ObjectAccessControl {
	if m != nil {
		return m.ObjectAccessControl
	}
	return nil
}

func (m *UpdateObjectAccessControlRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

func (m *UpdateObjectAccessControlRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for ComposeObject.
type ComposeObjectRequest struct {
	// Required. Name of the bucket containing the source objects. The destination object is
	// stored in this bucket.
	DestinationBucket string `protobuf:"bytes,1,opt,name=destination_bucket,json=destinationBucket,proto3" json:"destination_bucket,omitempty"`
	// Required. Name of the new object.
	DestinationObject string `protobuf:"bytes,2,opt,name=destination_object,json=destinationObject,proto3" json:"destination_object,omitempty"`
	// Apply a predefined set of access controls to the destination object.
	DestinationPredefinedAcl CommonEnums_PredefinedObjectAcl `protobuf:"varint,3,opt,name=destination_predefined_acl,json=destinationPredefinedAcl,proto3,enum=google.storage.v1.CommonEnums_PredefinedObjectAcl" json:"destination_predefined_acl,omitempty"`
	// Properties of the resulting object.
	Destination *Object `protobuf:"bytes,11,opt,name=destination,proto3" json:"destination,omitempty"`
	// The list of source objects that will be concatenated into a single object.
	SourceObjects []*ComposeObjectRequest_SourceObjects `protobuf:"bytes,12,rep,name=source_objects,json=sourceObjects,proto3" json:"source_objects,omitempty"`
	// Makes the operation conditional on whether the object's current generation
	// matches the given value. Setting to 0 makes the operation succeed only if
	// there are no live versions of the object.
	IfGenerationMatch *wrappers.Int64Value `protobuf:"bytes,4,opt,name=if_generation_match,json=ifGenerationMatch,proto3" json:"if_generation_match,omitempty"`
	// Makes the operation conditional on whether the object's current
	// metageneration matches the given value.
	IfMetagenerationMatch *wrappers.Int64Value `protobuf:"bytes,5,opt,name=if_metageneration_match,json=ifMetagenerationMatch,proto3" json:"if_metageneration_match,omitempty"`
	// Resource name of the Cloud KMS key, of the form
	// `projects/my-project/locations/my-location/keyRings/my-kr/cryptoKeys/my-key`,
	// that will be used to encrypt the object. Overrides the object
	// metadata's `kms_key_name` value, if any.
	KmsKeyName string `protobuf:"bytes,6,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
	// A set of parameters common to Storage API requests concerning an object.
	CommonObjectRequestParams *CommonObjectRequestParams `protobuf:"bytes,9,opt,name=common_object_request_params,json=commonObjectRequestParams,proto3" json:"common_object_request_params,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,10,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ComposeObjectRequest) Reset()         { *m = ComposeObjectRequest{} }
func (m *ComposeObjectRequest) String() string { return proto.CompactTextString(m) }
func (*ComposeObjectRequest) ProtoMessage()    {}
func (*ComposeObjectRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{30}
}

func (m *ComposeObjectRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ComposeObjectRequest.Unmarshal(m, b)
}
func (m *ComposeObjectRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ComposeObjectRequest.Marshal(b, m, deterministic)
}
func (m *ComposeObjectRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ComposeObjectRequest.Merge(m, src)
}
func (m *ComposeObjectRequest) XXX_Size() int {
	return xxx_messageInfo_ComposeObjectRequest.Size(m)
}
func (m *ComposeObjectRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ComposeObjectRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ComposeObjectRequest proto.InternalMessageInfo

func (m *ComposeObjectRequest) GetDestinationBucket() string {
	if m != nil {
		return m.DestinationBucket
	}
	return ""
}

func (m *ComposeObjectRequest) GetDestinationObject() string {
	if m != nil {
		return m.DestinationObject
	}
	return ""
}

func (m *ComposeObjectRequest) GetDestinationPredefinedAcl() CommonEnums_PredefinedObjectAcl {
	if m != nil {
		return m.DestinationPredefinedAcl
	}
	return CommonEnums_PREDEFINED_OBJECT_ACL_UNSPECIFIED
}

func (m *ComposeObjectRequest) GetDestination() *Object {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (m *ComposeObjectRequest) GetSourceObjects() []*ComposeObjectRequest_SourceObjects {
	if m != nil {
		return m.SourceObjects
	}
	return nil
}

func (m *ComposeObjectRequest) GetIfGenerationMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfGenerationMatch
	}
	return nil
}

func (m *ComposeObjectRequest) GetIfMetagenerationMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfMetagenerationMatch
	}
	return nil
}

func (m *ComposeObjectRequest) GetKmsKeyName() string {
	if m != nil {
		return m.KmsKeyName
	}
	return ""
}

func (m *ComposeObjectRequest) GetCommonObjectRequestParams() *CommonObjectRequestParams {
	if m != nil {
		return m.CommonObjectRequestParams
	}
	return nil
}

func (m *ComposeObjectRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Description of a source object for a composition request.
type ComposeObjectRequest_SourceObjects struct {
	// The source object's name. All source objects must reside in the same
	// bucket.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The generation of this object to use as the source.
	Generation int64 `protobuf:"varint,2,opt,name=generation,proto3" json:"generation,omitempty"`
	// Conditions that must be met for this operation to execute.
	ObjectPreconditions  *ComposeObjectRequest_SourceObjects_ObjectPreconditions `protobuf:"bytes,3,opt,name=object_preconditions,json=objectPreconditions,proto3" json:"object_preconditions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                                `json:"-"`
	XXX_unrecognized     []byte                                                  `json:"-"`
	XXX_sizecache        int32                                                   `json:"-"`
}

func (m *ComposeObjectRequest_SourceObjects) Reset()         { *m = ComposeObjectRequest_SourceObjects{} }
func (m *ComposeObjectRequest_SourceObjects) String() string { return proto.CompactTextString(m) }
func (*ComposeObjectRequest_SourceObjects) ProtoMessage()    {}
func (*ComposeObjectRequest_SourceObjects) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{30, 0}
}

func (m *ComposeObjectRequest_SourceObjects) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ComposeObjectRequest_SourceObjects.Unmarshal(m, b)
}
func (m *ComposeObjectRequest_SourceObjects) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ComposeObjectRequest_SourceObjects.Marshal(b, m, deterministic)
}
func (m *ComposeObjectRequest_SourceObjects) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ComposeObjectRequest_SourceObjects.Merge(m, src)
}
func (m *ComposeObjectRequest_SourceObjects) XXX_Size() int {
	return xxx_messageInfo_ComposeObjectRequest_SourceObjects.Size(m)
}
func (m *ComposeObjectRequest_SourceObjects) XXX_DiscardUnknown() {
	xxx_messageInfo_ComposeObjectRequest_SourceObjects.DiscardUnknown(m)
}

var xxx_messageInfo_ComposeObjectRequest_SourceObjects proto.InternalMessageInfo

func (m *ComposeObjectRequest_SourceObjects) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ComposeObjectRequest_SourceObjects) GetGeneration() int64 {
	if m != nil {
		return m.Generation
	}
	return 0
}

func (m *ComposeObjectRequest_SourceObjects) GetObjectPreconditions() *ComposeObjectRequest_SourceObjects_ObjectPreconditions {
	if m != nil {
		return m.ObjectPreconditions
	}
	return nil
}

// Preconditions for a source object of a composition request.
type ComposeObjectRequest_SourceObjects_ObjectPreconditions struct {
	// Only perform the composition if the generation of the source object
	// that would be used matches this value.  If this value and a generation
	// are both specified, they must be the same value or the call will fail.
	IfGenerationMatch    *wrappers.Int64Value `protobuf:"bytes,1,opt,name=if_generation_match,json=ifGenerationMatch,proto3" json:"if_generation_match,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ComposeObjectRequest_SourceObjects_ObjectPreconditions) Reset() {
	*m = ComposeObjectRequest_SourceObjects_ObjectPreconditions{}
}
func (m *ComposeObjectRequest_SourceObjects_ObjectPreconditions) String() string {
	return proto.CompactTextString(m)
}
func (*ComposeObjectRequest_SourceObjects_ObjectPreconditions) ProtoMessage() {}
func (*ComposeObjectRequest_SourceObjects_ObjectPreconditions) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{30, 0, 0}
}

func (m *ComposeObjectRequest_SourceObjects_ObjectPreconditions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ComposeObjectRequest_SourceObjects_ObjectPreconditions.Unmarshal(m, b)
}
func (m *ComposeObjectRequest_SourceObjects_ObjectPreconditions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ComposeObjectRequest_SourceObjects_ObjectPreconditions.Marshal(b, m, deterministic)
}
func (m *ComposeObjectRequest_SourceObjects_ObjectPreconditions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ComposeObjectRequest_SourceObjects_ObjectPreconditions.Merge(m, src)
}
func (m *ComposeObjectRequest_SourceObjects_ObjectPreconditions) XXX_Size() int {
	return xxx_messageInfo_ComposeObjectRequest_SourceObjects_ObjectPreconditions.Size(m)
}
func (m *ComposeObjectRequest_SourceObjects_ObjectPreconditions) XXX_DiscardUnknown() {
	xxx_messageInfo_ComposeObjectRequest_SourceObjects_ObjectPreconditions.DiscardUnknown(m)
}

var xxx_messageInfo_ComposeObjectRequest_SourceObjects_ObjectPreconditions proto.InternalMessageInfo

func (m *ComposeObjectRequest_SourceObjects_ObjectPreconditions) GetIfGenerationMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfGenerationMatch
	}
	return nil
}

// Request message for CopyObject.
type CopyObjectRequest struct {
	// Required. Name of the bucket in which to store the new object. Overrides the provided
	// object
	// metadata's `bucket` value, if any.
	DestinationBucket string `protobuf:"bytes,1,opt,name=destination_bucket,json=destinationBucket,proto3" json:"destination_bucket,omitempty"`
	// Required. Name of the new object.
	// Required when the object metadata is not otherwise provided. Overrides the
	// object metadata's `name` value, if any.
	DestinationObject string `protobuf:"bytes,2,opt,name=destination_object,json=destinationObject,proto3" json:"destination_object,omitempty"`
	// Apply a predefined set of access controls to the destination object.
	DestinationPredefinedAcl CommonEnums_PredefinedObjectAcl `protobuf:"varint,3,opt,name=destination_predefined_acl,json=destinationPredefinedAcl,proto3,enum=google.storage.v1.CommonEnums_PredefinedObjectAcl" json:"destination_predefined_acl,omitempty"`
	// Makes the operation conditional on whether the destination object's current
	// generation matches the given value. Setting to 0 makes the operation
	// succeed only if there are no live versions of the object.
	IfGenerationMatch *wrappers.Int64Value `protobuf:"bytes,4,opt,name=if_generation_match,json=ifGenerationMatch,proto3" json:"if_generation_match,omitempty"`
	// Makes the operation conditional on whether the destination object's current
	// generation does not match the given value. If no live object exists, the
	// precondition fails. Setting to 0 makes the operation succeed only if there
	// is a live version of the object.
	IfGenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,5,opt,name=if_generation_not_match,json=ifGenerationNotMatch,proto3" json:"if_generation_not_match,omitempty"`
	// Makes the operation conditional on whether the destination object's current
	// metageneration matches the given value.
	IfMetagenerationMatch *wrappers.Int64Value `protobuf:"bytes,6,opt,name=if_metageneration_match,json=ifMetagenerationMatch,proto3" json:"if_metageneration_match,omitempty"`
	// Makes the operation conditional on whether the destination object's current
	// metageneration does not match the given value.
	IfMetagenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,7,opt,name=if_metageneration_not_match,json=ifMetagenerationNotMatch,proto3" json:"if_metageneration_not_match,omitempty"`
	// Makes the operation conditional on whether the source object's current
	// generation matches the given value.
	IfSourceGenerationMatch *wrappers.Int64Value `protobuf:"bytes,8,opt,name=if_source_generation_match,json=ifSourceGenerationMatch,proto3" json:"if_source_generation_match,omitempty"`
	// Makes the operation conditional on whether the source object's current
	// generation does not match the given value.
	IfSourceGenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,9,opt,name=if_source_generation_not_match,json=ifSourceGenerationNotMatch,proto3" json:"if_source_generation_not_match,omitempty"`
	// Makes the operation conditional on whether the source object's current
	// metageneration matches the given value.
	IfSourceMetagenerationMatch *wrappers.Int64Value `protobuf:"bytes,10,opt,name=if_source_metageneration_match,json=ifSourceMetagenerationMatch,proto3" json:"if_source_metageneration_match,omitempty"`
	// Makes the operation conditional on whether the source object's current
	// metageneration does not match the given value.
	IfSourceMetagenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,11,opt,name=if_source_metageneration_not_match,json=ifSourceMetagenerationNotMatch,proto3" json:"if_source_metageneration_not_match,omitempty"`
	// Set of properties to return. Defaults to `NO_ACL`, unless the
	// object resource specifies the `acl` property, when it defaults
	// to `full`.
	Projection CommonEnums_Projection `protobuf:"varint,12,opt,name=projection,proto3,enum=google.storage.v1.CommonEnums_Projection" json:"projection,omitempty"`
	// Required. Name of the bucket in which to find the source object.
	SourceBucket string `protobuf:"bytes,13,opt,name=source_bucket,json=sourceBucket,proto3" json:"source_bucket,omitempty"`
	// Required. Name of the source object.
	SourceObject string `protobuf:"bytes,14,opt,name=source_object,json=sourceObject,proto3" json:"source_object,omitempty"`
	// If present, selects a specific revision of the source object (as opposed to
	// the latest version, the default).
	SourceGeneration int64 `protobuf:"varint,15,opt,name=source_generation,json=sourceGeneration,proto3" json:"source_generation,omitempty"`
	// Properties of the resulting object. If not set, duplicate properties of
	// source object.
	Destination *Object `protobuf:"bytes,17,opt,name=destination,proto3" json:"destination,omitempty"`
	// Resource name of the Cloud KMS key, of the form
	// `projects/my-project/locations/my-location/keyRings/my-kr/cryptoKeys/my-key`,
	// that will be used to encrypt the object. Overrides the object
	// metadata's `kms_key_name` value, if any.
	DestinationKmsKeyName string `protobuf:"bytes,20,opt,name=destination_kms_key_name,json=destinationKmsKeyName,proto3" json:"destination_kms_key_name,omitempty"`
	// A set of parameters common to Storage API requests concerning an object.
	CommonObjectRequestParams *CommonObjectRequestParams `protobuf:"bytes,18,opt,name=common_object_request_params,json=commonObjectRequestParams,proto3" json:"common_object_request_params,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,19,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *CopyObjectRequest) Reset()         { *m = CopyObjectRequest{} }
func (m *CopyObjectRequest) String() string { return proto.CompactTextString(m) }
func (*CopyObjectRequest) ProtoMessage()    {}
func (*CopyObjectRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{31}
}

func (m *CopyObjectRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CopyObjectRequest.Unmarshal(m, b)
}
func (m *CopyObjectRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CopyObjectRequest.Marshal(b, m, deterministic)
}
func (m *CopyObjectRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CopyObjectRequest.Merge(m, src)
}
func (m *CopyObjectRequest) XXX_Size() int {
	return xxx_messageInfo_CopyObjectRequest.Size(m)
}
func (m *CopyObjectRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CopyObjectRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CopyObjectRequest proto.InternalMessageInfo

func (m *CopyObjectRequest) GetDestinationBucket() string {
	if m != nil {
		return m.DestinationBucket
	}
	return ""
}

func (m *CopyObjectRequest) GetDestinationObject() string {
	if m != nil {
		return m.DestinationObject
	}
	return ""
}

func (m *CopyObjectRequest) GetDestinationPredefinedAcl() CommonEnums_PredefinedObjectAcl {
	if m != nil {
		return m.DestinationPredefinedAcl
	}
	return CommonEnums_PREDEFINED_OBJECT_ACL_UNSPECIFIED
}

func (m *CopyObjectRequest) GetIfGenerationMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfGenerationMatch
	}
	return nil
}

func (m *CopyObjectRequest) GetIfGenerationNotMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfGenerationNotMatch
	}
	return nil
}

func (m *CopyObjectRequest) GetIfMetagenerationMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfMetagenerationMatch
	}
	return nil
}

func (m *CopyObjectRequest) GetIfMetagenerationNotMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfMetagenerationNotMatch
	}
	return nil
}

func (m *CopyObjectRequest) GetIfSourceGenerationMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfSourceGenerationMatch
	}
	return nil
}

func (m *CopyObjectRequest) GetIfSourceGenerationNotMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfSourceGenerationNotMatch
	}
	return nil
}

func (m *CopyObjectRequest) GetIfSourceMetagenerationMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfSourceMetagenerationMatch
	}
	return nil
}

func (m *CopyObjectRequest) GetIfSourceMetagenerationNotMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfSourceMetagenerationNotMatch
	}
	return nil
}

func (m *CopyObjectRequest) GetProjection() CommonEnums_Projection {
	if m != nil {
		return m.Projection
	}
	return CommonEnums_PROJECTION_UNSPECIFIED
}

func (m *CopyObjectRequest) GetSourceBucket() string {
	if m != nil {
		return m.SourceBucket
	}
	return ""
}

func (m *CopyObjectRequest) GetSourceObject() string {
	if m != nil {
		return m.SourceObject
	}
	return ""
}

func (m *CopyObjectRequest) GetSourceGeneration() int64 {
	if m != nil {
		return m.SourceGeneration
	}
	return 0
}

func (m *CopyObjectRequest) GetDestination() *Object {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (m *CopyObjectRequest) GetDestinationKmsKeyName() string {
	if m != nil {
		return m.DestinationKmsKeyName
	}
	return ""
}

func (m *CopyObjectRequest) GetCommonObjectRequestParams() *CommonObjectRequestParams {
	if m != nil {
		return m.CommonObjectRequestParams
	}
	return nil
}

func (m *CopyObjectRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Message for deleting an object.
// Either `bucket` and `object` *or* `upload_id` **must** be set (but not both).
type DeleteObjectRequest struct {
	// Required. Name of the bucket in which the object resides.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. The name of the object to delete (when not using a resumable write).
	Object string `protobuf:"bytes,2,opt,name=object,proto3" json:"object,omitempty"`
	// The resumable upload_id of the object to delete (when using a
	// resumable write). This should be copied from the `upload_id` field of
	// `StartResumableWriteResponse`.
	UploadId string `protobuf:"bytes,3,opt,name=upload_id,json=uploadId,proto3" json:"upload_id,omitempty"`
	// If present, permanently deletes a specific revision of this object (as
	// opposed to the latest version, the default).
	Generation int64 `protobuf:"varint,4,opt,name=generation,proto3" json:"generation,omitempty"`
	// Makes the operation conditional on whether the object's current generation
	// matches the given value. Setting to 0 makes the operation succeed only if
	// there are no live versions of the object.
	IfGenerationMatch *wrappers.Int64Value `protobuf:"bytes,5,opt,name=if_generation_match,json=ifGenerationMatch,proto3" json:"if_generation_match,omitempty"`
	// Makes the operation conditional on whether the object's current generation
	// does not match the given value. If no live object exists, the precondition
	// fails. Setting to 0 makes the operation succeed only if there is a live
	// version of the object.
	IfGenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,6,opt,name=if_generation_not_match,json=ifGenerationNotMatch,proto3" json:"if_generation_not_match,omitempty"`
	// Makes the operation conditional on whether the object's current
	// metageneration matches the given value.
	IfMetagenerationMatch *wrappers.Int64Value `protobuf:"bytes,7,opt,name=if_metageneration_match,json=ifMetagenerationMatch,proto3" json:"if_metageneration_match,omitempty"`
	// Makes the operation conditional on whether the object's current
	// metageneration does not match the given value.
	IfMetagenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,8,opt,name=if_metageneration_not_match,json=ifMetagenerationNotMatch,proto3" json:"if_metageneration_not_match,omitempty"`
	// A set of parameters common to Storage API requests concerning an object.
	CommonObjectRequestParams *CommonObjectRequestParams `protobuf:"bytes,10,opt,name=common_object_request_params,json=commonObjectRequestParams,proto3" json:"common_object_request_params,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,11,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *DeleteObjectRequest) Reset()         { *m = DeleteObjectRequest{} }
func (m *DeleteObjectRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteObjectRequest) ProtoMessage()    {}
func (*DeleteObjectRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{32}
}

func (m *DeleteObjectRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteObjectRequest.Unmarshal(m, b)
}
func (m *DeleteObjectRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteObjectRequest.Marshal(b, m, deterministic)
}
func (m *DeleteObjectRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteObjectRequest.Merge(m, src)
}
func (m *DeleteObjectRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteObjectRequest.Size(m)
}
func (m *DeleteObjectRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteObjectRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteObjectRequest proto.InternalMessageInfo

func (m *DeleteObjectRequest) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *DeleteObjectRequest) GetObject() string {
	if m != nil {
		return m.Object
	}
	return ""
}

func (m *DeleteObjectRequest) GetUploadId() string {
	if m != nil {
		return m.UploadId
	}
	return ""
}

func (m *DeleteObjectRequest) GetGeneration() int64 {
	if m != nil {
		return m.Generation
	}
	return 0
}

func (m *DeleteObjectRequest) GetIfGenerationMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfGenerationMatch
	}
	return nil
}

func (m *DeleteObjectRequest) GetIfGenerationNotMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfGenerationNotMatch
	}
	return nil
}

func (m *DeleteObjectRequest) GetIfMetagenerationMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfMetagenerationMatch
	}
	return nil
}

func (m *DeleteObjectRequest) GetIfMetagenerationNotMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfMetagenerationNotMatch
	}
	return nil
}

func (m *DeleteObjectRequest) GetCommonObjectRequestParams() *CommonObjectRequestParams {
	if m != nil {
		return m.CommonObjectRequestParams
	}
	return nil
}

func (m *DeleteObjectRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Request message for GetObjectMedia.
type GetObjectMediaRequest struct {
	// The name of the bucket containing the object to read.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// The name of the object to read.
	Object string `protobuf:"bytes,2,opt,name=object,proto3" json:"object,omitempty"`
	// If present, selects a specific revision of this object (as opposed
	// to the latest version, the default).
	Generation int64 `protobuf:"varint,3,opt,name=generation,proto3" json:"generation,omitempty"`
	// The offset for the first byte to return in the read, relative to the start
	// of the object.
	//
	// A negative `read_offset` value will be interpreted as the number of bytes
	// back from the end of the object to be returned. For example, if an object's
	// length is 15 bytes, a GetObjectMediaRequest with `read_offset` = -5 and
	// `read_limit` = 3 would return bytes 10 through 12 of the object.
	ReadOffset int64 `protobuf:"varint,4,opt,name=read_offset,json=readOffset,proto3" json:"read_offset,omitempty"`
	// The maximum number of `data` bytes the server is allowed to return in the
	// sum of all `Object` messages. A `read_limit` of zero indicates that there
	// is no limit, and a negative `read_limit` will cause an error.
	//
	// If the stream returns fewer bytes than allowed by the `read_limit` and no
	// error occurred, the stream includes all data from the `read_offset` to the
	// end of the resource.
	ReadLimit int64 `protobuf:"varint,5,opt,name=read_limit,json=readLimit,proto3" json:"read_limit,omitempty"`
	// Makes the operation conditional on whether the object's current generation
	// matches the given value. Setting to 0 makes the operation succeed only if
	// there are no live versions of the object.
	IfGenerationMatch *wrappers.Int64Value `protobuf:"bytes,6,opt,name=if_generation_match,json=ifGenerationMatch,proto3" json:"if_generation_match,omitempty"`
	// Makes the operation conditional on whether the object's current generation
	// does not match the given value. If no live object exists, the precondition
	// fails. Setting to 0 makes the operation succeed only if there is a live
	// version of the object.
	IfGenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,7,opt,name=if_generation_not_match,json=ifGenerationNotMatch,proto3" json:"if_generation_not_match,omitempty"`
	// Makes the operation conditional on whether the object's current
	// metageneration matches the given value.
	IfMetagenerationMatch *wrappers.Int64Value `protobuf:"bytes,8,opt,name=if_metageneration_match,json=ifMetagenerationMatch,proto3" json:"if_metageneration_match,omitempty"`
	// Makes the operation conditional on whether the object's current
	// metageneration does not match the given value.
	IfMetagenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,9,opt,name=if_metageneration_not_match,json=ifMetagenerationNotMatch,proto3" json:"if_metageneration_not_match,omitempty"`
	// A set of parameters common to Storage API requests concerning an object.
	CommonObjectRequestParams *CommonObjectRequestParams `protobuf:"bytes,11,opt,name=common_object_request_params,json=commonObjectRequestParams,proto3" json:"common_object_request_params,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,12,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *GetObjectMediaRequest) Reset()         { *m = GetObjectMediaRequest{} }
func (m *GetObjectMediaRequest) String() string { return proto.CompactTextString(m) }
func (*GetObjectMediaRequest) ProtoMessage()    {}
func (*GetObjectMediaRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{33}
}

func (m *GetObjectMediaRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetObjectMediaRequest.Unmarshal(m, b)
}
func (m *GetObjectMediaRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetObjectMediaRequest.Marshal(b, m, deterministic)
}
func (m *GetObjectMediaRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetObjectMediaRequest.Merge(m, src)
}
func (m *GetObjectMediaRequest) XXX_Size() int {
	return xxx_messageInfo_GetObjectMediaRequest.Size(m)
}
func (m *GetObjectMediaRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetObjectMediaRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetObjectMediaRequest proto.InternalMessageInfo

func (m *GetObjectMediaRequest) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *GetObjectMediaRequest) GetObject() string {
	if m != nil {
		return m.Object
	}
	return ""
}

func (m *GetObjectMediaRequest) GetGeneration() int64 {
	if m != nil {
		return m.Generation
	}
	return 0
}

func (m *GetObjectMediaRequest) GetReadOffset() int64 {
	if m != nil {
		return m.ReadOffset
	}
	return 0
}

func (m *GetObjectMediaRequest) GetReadLimit() int64 {
	if m != nil {
		return m.ReadLimit
	}
	return 0
}

func (m *GetObjectMediaRequest) GetIfGenerationMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfGenerationMatch
	}
	return nil
}

func (m *GetObjectMediaRequest) GetIfGenerationNotMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfGenerationNotMatch
	}
	return nil
}

func (m *GetObjectMediaRequest) GetIfMetagenerationMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfMetagenerationMatch
	}
	return nil
}

func (m *GetObjectMediaRequest) GetIfMetagenerationNotMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfMetagenerationNotMatch
	}
	return nil
}

func (m *GetObjectMediaRequest) GetCommonObjectRequestParams() *CommonObjectRequestParams {
	if m != nil {
		return m.CommonObjectRequestParams
	}
	return nil
}

func (m *GetObjectMediaRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Request message for GetObject.
type GetObjectRequest struct {
	// Required. Name of the bucket in which the object resides.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. Name of the object.
	Object string `protobuf:"bytes,2,opt,name=object,proto3" json:"object,omitempty"`
	// If present, selects a specific revision of this object (as opposed to the
	// latest version, the default).
	Generation int64 `protobuf:"varint,3,opt,name=generation,proto3" json:"generation,omitempty"`
	// Makes the operation conditional on whether the object's current generation
	// matches the given value. Setting to 0 makes the operation succeed only if
	// there are no live versions of the object.
	IfGenerationMatch *wrappers.Int64Value `protobuf:"bytes,4,opt,name=if_generation_match,json=ifGenerationMatch,proto3" json:"if_generation_match,omitempty"`
	// Makes the operation conditional on whether the object's current generation
	// does not match the given value. If no live object exists, the precondition
	// fails. Setting to 0 makes the operation succeed only if there is a live
	// version of the object.
	IfGenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,5,opt,name=if_generation_not_match,json=ifGenerationNotMatch,proto3" json:"if_generation_not_match,omitempty"`
	// Makes the operation conditional on whether the object's current
	// metageneration matches the given value.
	IfMetagenerationMatch *wrappers.Int64Value `protobuf:"bytes,6,opt,name=if_metageneration_match,json=ifMetagenerationMatch,proto3" json:"if_metageneration_match,omitempty"`
	// Makes the operation conditional on whether the object's current
	// metageneration does not match the given value.
	IfMetagenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,7,opt,name=if_metageneration_not_match,json=ifMetagenerationNotMatch,proto3" json:"if_metageneration_not_match,omitempty"`
	// Set of properties to return. Defaults to `NO_ACL`.
	Projection CommonEnums_Projection `protobuf:"varint,8,opt,name=projection,proto3,enum=google.storage.v1.CommonEnums_Projection" json:"projection,omitempty"`
	// A set of parameters common to Storage API requests concerning an object.
	CommonObjectRequestParams *CommonObjectRequestParams `protobuf:"bytes,10,opt,name=common_object_request_params,json=commonObjectRequestParams,proto3" json:"common_object_request_params,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,11,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *GetObjectRequest) Reset()         { *m = GetObjectRequest{} }
func (m *GetObjectRequest) String() string { return proto.CompactTextString(m) }
func (*GetObjectRequest) ProtoMessage()    {}
func (*GetObjectRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{34}
}

func (m *GetObjectRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetObjectRequest.Unmarshal(m, b)
}
func (m *GetObjectRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetObjectRequest.Marshal(b, m, deterministic)
}
func (m *GetObjectRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetObjectRequest.Merge(m, src)
}
func (m *GetObjectRequest) XXX_Size() int {
	return xxx_messageInfo_GetObjectRequest.Size(m)
}
func (m *GetObjectRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetObjectRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetObjectRequest proto.InternalMessageInfo

func (m *GetObjectRequest) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *GetObjectRequest) GetObject() string {
	if m != nil {
		return m.Object
	}
	return ""
}

func (m *GetObjectRequest) GetGeneration() int64 {
	if m != nil {
		return m.Generation
	}
	return 0
}

func (m *GetObjectRequest) GetIfGenerationMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfGenerationMatch
	}
	return nil
}

func (m *GetObjectRequest) GetIfGenerationNotMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfGenerationNotMatch
	}
	return nil
}

func (m *GetObjectRequest) GetIfMetagenerationMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfMetagenerationMatch
	}
	return nil
}

func (m *GetObjectRequest) GetIfMetagenerationNotMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfMetagenerationNotMatch
	}
	return nil
}

func (m *GetObjectRequest) GetProjection() CommonEnums_Projection {
	if m != nil {
		return m.Projection
	}
	return CommonEnums_PROJECTION_UNSPECIFIED
}

func (m *GetObjectRequest) GetCommonObjectRequestParams() *CommonObjectRequestParams {
	if m != nil {
		return m.CommonObjectRequestParams
	}
	return nil
}

func (m *GetObjectRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Response message for GetObject.
type GetObjectMediaResponse struct {
	// A portion of the data for the object. The service **may** leave `data`
	// empty for any given `ReadResponse`. This enables the service to inform the
	// client that the request is still live while it is running an operation to
	// generate more data.
	ChecksummedData *ChecksummedData `protobuf:"bytes,1,opt,name=checksummed_data,json=checksummedData,proto3" json:"checksummed_data,omitempty"`
	// The checksums of the complete object. The client should compute one of
	// these checksums over the downloaded object and compare it against the value
	// provided here.
	ObjectChecksums *ObjectChecksums `protobuf:"bytes,2,opt,name=object_checksums,json=objectChecksums,proto3" json:"object_checksums,omitempty"`
	// If read_offset and or read_limit was specified on the
	// GetObjectMediaRequest, ContentRange will be populated on the first
	// GetObjectMediaResponse message of the read stream.
	ContentRange         *ContentRange `protobuf:"bytes,3,opt,name=content_range,json=contentRange,proto3" json:"content_range,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *GetObjectMediaResponse) Reset()         { *m = GetObjectMediaResponse{} }
func (m *GetObjectMediaResponse) String() string { return proto.CompactTextString(m) }
func (*GetObjectMediaResponse) ProtoMessage()    {}
func (*GetObjectMediaResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{35}
}

func (m *GetObjectMediaResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetObjectMediaResponse.Unmarshal(m, b)
}
func (m *GetObjectMediaResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetObjectMediaResponse.Marshal(b, m, deterministic)
}
func (m *GetObjectMediaResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetObjectMediaResponse.Merge(m, src)
}
func (m *GetObjectMediaResponse) XXX_Size() int {
	return xxx_messageInfo_GetObjectMediaResponse.Size(m)
}
func (m *GetObjectMediaResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetObjectMediaResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetObjectMediaResponse proto.InternalMessageInfo

func (m *GetObjectMediaResponse) GetChecksummedData() *ChecksummedData {
	if m != nil {
		return m.ChecksummedData
	}
	return nil
}

func (m *GetObjectMediaResponse) GetObjectChecksums() *ObjectChecksums {
	if m != nil {
		return m.ObjectChecksums
	}
	return nil
}

func (m *GetObjectMediaResponse) GetContentRange() *ContentRange {
	if m != nil {
		return m.ContentRange
	}
	return nil
}

// Describes an attempt to insert an object, possibly over multiple requests.
type InsertObjectSpec struct {
	// Destination object, including its name and its metadata.
	Resource *Object `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	// Apply a predefined set of access controls to this object.
	PredefinedAcl CommonEnums_PredefinedObjectAcl `protobuf:"varint,2,opt,name=predefined_acl,json=predefinedAcl,proto3,enum=google.storage.v1.CommonEnums_PredefinedObjectAcl" json:"predefined_acl,omitempty"`
	// Makes the operation conditional on whether the object's current
	// generation matches the given value. Setting to 0 makes the operation
	// succeed only if there are no live versions of the object.
	IfGenerationMatch *wrappers.Int64Value `protobuf:"bytes,3,opt,name=if_generation_match,json=ifGenerationMatch,proto3" json:"if_generation_match,omitempty"`
	// Makes the operation conditional on whether the object's current
	// generation does not match the given value. If no live object exists, the
	// precondition fails. Setting to 0 makes the operation succeed only if
	// there is a live version of the object.
	IfGenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,4,opt,name=if_generation_not_match,json=ifGenerationNotMatch,proto3" json:"if_generation_not_match,omitempty"`
	// Makes the operation conditional on whether the object's current
	// metageneration matches the given value.
	IfMetagenerationMatch *wrappers.Int64Value `protobuf:"bytes,5,opt,name=if_metageneration_match,json=ifMetagenerationMatch,proto3" json:"if_metageneration_match,omitempty"`
	// Makes the operation conditional on whether the object's current
	// metageneration does not match the given value.
	IfMetagenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,6,opt,name=if_metageneration_not_match,json=ifMetagenerationNotMatch,proto3" json:"if_metageneration_not_match,omitempty"`
	// Set of properties to return. Defaults to `NO_ACL`, unless the
	// object resource specifies the `acl` property, when it defaults
	// to `full`.
	Projection           CommonEnums_Projection `protobuf:"varint,7,opt,name=projection,proto3,enum=google.storage.v1.CommonEnums_Projection" json:"projection,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *InsertObjectSpec) Reset()         { *m = InsertObjectSpec{} }
func (m *InsertObjectSpec) String() string { return proto.CompactTextString(m) }
func (*InsertObjectSpec) ProtoMessage()    {}
func (*InsertObjectSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{36}
}

func (m *InsertObjectSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InsertObjectSpec.Unmarshal(m, b)
}
func (m *InsertObjectSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InsertObjectSpec.Marshal(b, m, deterministic)
}
func (m *InsertObjectSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InsertObjectSpec.Merge(m, src)
}
func (m *InsertObjectSpec) XXX_Size() int {
	return xxx_messageInfo_InsertObjectSpec.Size(m)
}
func (m *InsertObjectSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_InsertObjectSpec.DiscardUnknown(m)
}

var xxx_messageInfo_InsertObjectSpec proto.InternalMessageInfo

func (m *InsertObjectSpec) GetResource() *Object {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *InsertObjectSpec) GetPredefinedAcl() CommonEnums_PredefinedObjectAcl {
	if m != nil {
		return m.PredefinedAcl
	}
	return CommonEnums_PREDEFINED_OBJECT_ACL_UNSPECIFIED
}

func (m *InsertObjectSpec) GetIfGenerationMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfGenerationMatch
	}
	return nil
}

func (m *InsertObjectSpec) GetIfGenerationNotMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfGenerationNotMatch
	}
	return nil
}

func (m *InsertObjectSpec) GetIfMetagenerationMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfMetagenerationMatch
	}
	return nil
}

func (m *InsertObjectSpec) GetIfMetagenerationNotMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfMetagenerationNotMatch
	}
	return nil
}

func (m *InsertObjectSpec) GetProjection() CommonEnums_Projection {
	if m != nil {
		return m.Projection
	}
	return CommonEnums_PROJECTION_UNSPECIFIED
}

// Message for writing an object.
type InsertObjectRequest struct {
	// The first message of each stream should set one of the following.
	//
	// Types that are valid to be assigned to FirstMessage:
	//	*InsertObjectRequest_UploadId
	//	*InsertObjectRequest_InsertObjectSpec
	FirstMessage isInsertObjectRequest_FirstMessage `protobuf_oneof:"first_message"`
	// Required. The offset from the beginning of the object at which the data should be
	// written.
	//
	// In the first `InsertObjectRequest` of a `InsertObject()` action, it
	// indicates the initial offset for the `Insert()` call. The value **must** be
	// equal to the `committed_size` that a call to `QueryWriteStatus()` would
	// return (0 if this is the first write to the object).
	//
	// On subsequent calls, this value **must** be no larger than the sum of the
	// first `write_offset` and the sizes of all `data` chunks sent previously on
	// this stream.
	//
	// An incorrect value will cause an error.
	WriteOffset int64 `protobuf:"varint,3,opt,name=write_offset,json=writeOffset,proto3" json:"write_offset,omitempty"`
	// A portion of the data for the object.
	//
	// Types that are valid to be assigned to Data:
	//	*InsertObjectRequest_ChecksummedData
	//	*InsertObjectRequest_Reference
	Data isInsertObjectRequest_Data `protobuf_oneof:"data"`
	// Checksums for the complete object. If the checksums computed by the service
	// don't match the specifified checksums the call will fail. May only be
	// provided in the first or last request (either with first_message, or
	// finish_write set).
	ObjectChecksums *ObjectChecksums `protobuf:"bytes,6,opt,name=object_checksums,json=objectChecksums,proto3" json:"object_checksums,omitempty"`
	// If `true`, this indicates that the write is complete. Sending any
	// `InsertObjectRequest`s subsequent to one in which `finish_write` is `true`
	// will cause an error.
	// For a non-resumable write (where the upload_id was not set in the first
	// message), it is an error not to set this field in the final message of the
	// stream.
	FinishWrite bool `protobuf:"varint,7,opt,name=finish_write,json=finishWrite,proto3" json:"finish_write,omitempty"`
	// A set of parameters common to Storage API requests concerning an object.
	CommonObjectRequestParams *CommonObjectRequestParams `protobuf:"bytes,8,opt,name=common_object_request_params,json=commonObjectRequestParams,proto3" json:"common_object_request_params,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,9,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *InsertObjectRequest) Reset()         { *m = InsertObjectRequest{} }
func (m *InsertObjectRequest) String() string { return proto.CompactTextString(m) }
func (*InsertObjectRequest) ProtoMessage()    {}
func (*InsertObjectRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{37}
}

func (m *InsertObjectRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InsertObjectRequest.Unmarshal(m, b)
}
func (m *InsertObjectRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InsertObjectRequest.Marshal(b, m, deterministic)
}
func (m *InsertObjectRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InsertObjectRequest.Merge(m, src)
}
func (m *InsertObjectRequest) XXX_Size() int {
	return xxx_messageInfo_InsertObjectRequest.Size(m)
}
func (m *InsertObjectRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_InsertObjectRequest.DiscardUnknown(m)
}

var xxx_messageInfo_InsertObjectRequest proto.InternalMessageInfo

type isInsertObjectRequest_FirstMessage interface {
	isInsertObjectRequest_FirstMessage()
}

type InsertObjectRequest_UploadId struct {
	UploadId string `protobuf:"bytes,1,opt,name=upload_id,json=uploadId,proto3,oneof"`
}

type InsertObjectRequest_InsertObjectSpec struct {
	InsertObjectSpec *InsertObjectSpec `protobuf:"bytes,2,opt,name=insert_object_spec,json=insertObjectSpec,proto3,oneof"`
}

func (*InsertObjectRequest_UploadId) isInsertObjectRequest_FirstMessage() {}

func (*InsertObjectRequest_InsertObjectSpec) isInsertObjectRequest_FirstMessage() {}

func (m *InsertObjectRequest) GetFirstMessage() isInsertObjectRequest_FirstMessage {
	if m != nil {
		return m.FirstMessage
	}
	return nil
}

func (m *InsertObjectRequest) GetUploadId() string {
	if x, ok := m.GetFirstMessage().(*InsertObjectRequest_UploadId); ok {
		return x.UploadId
	}
	return ""
}

func (m *InsertObjectRequest) GetInsertObjectSpec() *InsertObjectSpec {
	if x, ok := m.GetFirstMessage().(*InsertObjectRequest_InsertObjectSpec); ok {
		return x.InsertObjectSpec
	}
	return nil
}

func (m *InsertObjectRequest) GetWriteOffset() int64 {
	if m != nil {
		return m.WriteOffset
	}
	return 0
}

type isInsertObjectRequest_Data interface {
	isInsertObjectRequest_Data()
}

type InsertObjectRequest_ChecksummedData struct {
	ChecksummedData *ChecksummedData `protobuf:"bytes,4,opt,name=checksummed_data,json=checksummedData,proto3,oneof"`
}

type InsertObjectRequest_Reference struct {
	Reference *GetObjectMediaRequest `protobuf:"bytes,5,opt,name=reference,proto3,oneof"`
}

func (*InsertObjectRequest_ChecksummedData) isInsertObjectRequest_Data() {}

func (*InsertObjectRequest_Reference) isInsertObjectRequest_Data() {}

func (m *InsertObjectRequest) GetData() isInsertObjectRequest_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *InsertObjectRequest) GetChecksummedData() *ChecksummedData {
	if x, ok := m.GetData().(*InsertObjectRequest_ChecksummedData); ok {
		return x.ChecksummedData
	}
	return nil
}

func (m *InsertObjectRequest) GetReference() *GetObjectMediaRequest {
	if x, ok := m.GetData().(*InsertObjectRequest_Reference); ok {
		return x.Reference
	}
	return nil
}

func (m *InsertObjectRequest) GetObjectChecksums() *ObjectChecksums {
	if m != nil {
		return m.ObjectChecksums
	}
	return nil
}

func (m *InsertObjectRequest) GetFinishWrite() bool {
	if m != nil {
		return m.FinishWrite
	}
	return false
}

func (m *InsertObjectRequest) GetCommonObjectRequestParams() *CommonObjectRequestParams {
	if m != nil {
		return m.CommonObjectRequestParams
	}
	return nil
}

func (m *InsertObjectRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*InsertObjectRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*InsertObjectRequest_UploadId)(nil),
		(*InsertObjectRequest_InsertObjectSpec)(nil),
		(*InsertObjectRequest_ChecksummedData)(nil),
		(*InsertObjectRequest_Reference)(nil),
	}
}

// Request message for ListObjects.
type ListObjectsRequest struct {
	// Required. Name of the bucket in which to look for objects.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Returns results in a directory-like mode. `items` will contain
	// only objects whose names, aside from the `prefix`, do not
	// contain `delimiter`. Objects whose names, aside from the
	// `prefix`, contain `delimiter` will have their name,
	// truncated after the `delimiter`, returned in
	// `prefixes`. Duplicate `prefixes` are omitted.
	Delimiter string `protobuf:"bytes,2,opt,name=delimiter,proto3" json:"delimiter,omitempty"`
	// If true, objects that end in exactly one instance of `delimiter`
	// will have their metadata included in `items` in addition to
	// `prefixes`.
	IncludeTrailingDelimiter bool `protobuf:"varint,3,opt,name=include_trailing_delimiter,json=includeTrailingDelimiter,proto3" json:"include_trailing_delimiter,omitempty"`
	// Maximum number of `items` plus `prefixes` to return
	// in a single page of responses. As duplicate `prefixes` are
	// omitted, fewer total results may be returned than requested. The service
	// will use this parameter or 1,000 items, whichever is smaller.
	MaxResults int32 `protobuf:"varint,4,opt,name=max_results,json=maxResults,proto3" json:"max_results,omitempty"`
	// A previously-returned page token representing part of the larger set of
	// results to view.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filter results to objects whose names begin with this prefix.
	Prefix string `protobuf:"bytes,6,opt,name=prefix,proto3" json:"prefix,omitempty"`
	// Set of properties to return. Defaults to `NO_ACL`.
	Projection CommonEnums_Projection `protobuf:"varint,7,opt,name=projection,proto3,enum=google.storage.v1.CommonEnums_Projection" json:"projection,omitempty"`
	// If `true`, lists all versions of an object as distinct results.
	// The default is `false`. For more information, see
	// [Object
	// Versioning](https://cloud.google.com/storage/docs/object-versioning).
	Versions bool `protobuf:"varint,9,opt,name=versions,proto3" json:"versions,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,10,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ListObjectsRequest) Reset()         { *m = ListObjectsRequest{} }
func (m *ListObjectsRequest) String() string { return proto.CompactTextString(m) }
func (*ListObjectsRequest) ProtoMessage()    {}
func (*ListObjectsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{38}
}

func (m *ListObjectsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListObjectsRequest.Unmarshal(m, b)
}
func (m *ListObjectsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListObjectsRequest.Marshal(b, m, deterministic)
}
func (m *ListObjectsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListObjectsRequest.Merge(m, src)
}
func (m *ListObjectsRequest) XXX_Size() int {
	return xxx_messageInfo_ListObjectsRequest.Size(m)
}
func (m *ListObjectsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListObjectsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListObjectsRequest proto.InternalMessageInfo

func (m *ListObjectsRequest) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *ListObjectsRequest) GetDelimiter() string {
	if m != nil {
		return m.Delimiter
	}
	return ""
}

func (m *ListObjectsRequest) GetIncludeTrailingDelimiter() bool {
	if m != nil {
		return m.IncludeTrailingDelimiter
	}
	return false
}

func (m *ListObjectsRequest) GetMaxResults() int32 {
	if m != nil {
		return m.MaxResults
	}
	return 0
}

func (m *ListObjectsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListObjectsRequest) GetPrefix() string {
	if m != nil {
		return m.Prefix
	}
	return ""
}

func (m *ListObjectsRequest) GetProjection() CommonEnums_Projection {
	if m != nil {
		return m.Projection
	}
	return CommonEnums_PROJECTION_UNSPECIFIED
}

func (m *ListObjectsRequest) GetVersions() bool {
	if m != nil {
		return m.Versions
	}
	return false
}

func (m *ListObjectsRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Request object for `ByteStream.QueryWriteStatus`.
type QueryWriteStatusRequest struct {
	// Required. The name of the resume token for the object whose write status is being
	// requested.
	UploadId string `protobuf:"bytes,1,opt,name=upload_id,json=uploadId,proto3" json:"upload_id,omitempty"`
	// A set of parameters common to Storage API requests concerning an object.
	CommonObjectRequestParams *CommonObjectRequestParams `protobuf:"bytes,2,opt,name=common_object_request_params,json=commonObjectRequestParams,proto3" json:"common_object_request_params,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,3,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *QueryWriteStatusRequest) Reset()         { *m = QueryWriteStatusRequest{} }
func (m *QueryWriteStatusRequest) String() string { return proto.CompactTextString(m) }
func (*QueryWriteStatusRequest) ProtoMessage()    {}
func (*QueryWriteStatusRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{39}
}

func (m *QueryWriteStatusRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryWriteStatusRequest.Unmarshal(m, b)
}
func (m *QueryWriteStatusRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryWriteStatusRequest.Marshal(b, m, deterministic)
}
func (m *QueryWriteStatusRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryWriteStatusRequest.Merge(m, src)
}
func (m *QueryWriteStatusRequest) XXX_Size() int {
	return xxx_messageInfo_QueryWriteStatusRequest.Size(m)
}
func (m *QueryWriteStatusRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryWriteStatusRequest.DiscardUnknown(m)
}

var xxx_messageInfo_QueryWriteStatusRequest proto.InternalMessageInfo

func (m *QueryWriteStatusRequest) GetUploadId() string {
	if m != nil {
		return m.UploadId
	}
	return ""
}

func (m *QueryWriteStatusRequest) GetCommonObjectRequestParams() *CommonObjectRequestParams {
	if m != nil {
		return m.CommonObjectRequestParams
	}
	return nil
}

func (m *QueryWriteStatusRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Response object for `ByteStream.QueryWriteStatus`.
type QueryWriteStatusResponse struct {
	// The number of bytes that have been processed for the given object.
	CommittedSize int64 `protobuf:"varint,1,opt,name=committed_size,json=committedSize,proto3" json:"committed_size,omitempty"`
	// `complete` is `true` only if the client has sent a `InsertObjectRequest`
	// with `finish_write` set to true, and the server has processed that request.
	Complete             bool     `protobuf:"varint,2,opt,name=complete,proto3" json:"complete,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *QueryWriteStatusResponse) Reset()         { *m = QueryWriteStatusResponse{} }
func (m *QueryWriteStatusResponse) String() string { return proto.CompactTextString(m) }
func (*QueryWriteStatusResponse) ProtoMessage()    {}
func (*QueryWriteStatusResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{40}
}

func (m *QueryWriteStatusResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryWriteStatusResponse.Unmarshal(m, b)
}
func (m *QueryWriteStatusResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryWriteStatusResponse.Marshal(b, m, deterministic)
}
func (m *QueryWriteStatusResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryWriteStatusResponse.Merge(m, src)
}
func (m *QueryWriteStatusResponse) XXX_Size() int {
	return xxx_messageInfo_QueryWriteStatusResponse.Size(m)
}
func (m *QueryWriteStatusResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryWriteStatusResponse.DiscardUnknown(m)
}

var xxx_messageInfo_QueryWriteStatusResponse proto.InternalMessageInfo

func (m *QueryWriteStatusResponse) GetCommittedSize() int64 {
	if m != nil {
		return m.CommittedSize
	}
	return 0
}

func (m *QueryWriteStatusResponse) GetComplete() bool {
	if m != nil {
		return m.Complete
	}
	return false
}

// Request message for RewriteObject.
type RewriteObjectRequest struct {
	// Required. Name of the bucket in which to store the new object. Overrides the provided
	// object metadata's `bucket` value, if any.
	DestinationBucket string `protobuf:"bytes,1,opt,name=destination_bucket,json=destinationBucket,proto3" json:"destination_bucket,omitempty"`
	// Required. Name of the new object.
	// Required when the object metadata is not otherwise provided. Overrides the
	// object metadata's `name` value, if any.
	DestinationObject string `protobuf:"bytes,2,opt,name=destination_object,json=destinationObject,proto3" json:"destination_object,omitempty"`
	// Resource name of the Cloud KMS key, of the form
	// `projects/my-project/locations/my-location/keyRings/my-kr/cryptoKeys/my-key`,
	// that will be used to encrypt the object. Overrides the object
	// metadata's `kms_key_name` value, if any.
	DestinationKmsKeyName string `protobuf:"bytes,3,opt,name=destination_kms_key_name,json=destinationKmsKeyName,proto3" json:"destination_kms_key_name,omitempty"`
	// Apply a predefined set of access controls to the destination object.
	DestinationPredefinedAcl CommonEnums_PredefinedObjectAcl `protobuf:"varint,4,opt,name=destination_predefined_acl,json=destinationPredefinedAcl,proto3,enum=google.storage.v1.CommonEnums_PredefinedObjectAcl" json:"destination_predefined_acl,omitempty"`
	// Makes the operation conditional on whether the object's current generation
	// matches the given value. Setting to 0 makes the operation succeed only if
	// there are no live versions of the object.
	IfGenerationMatch *wrappers.Int64Value `protobuf:"bytes,5,opt,name=if_generation_match,json=ifGenerationMatch,proto3" json:"if_generation_match,omitempty"`
	// Makes the operation conditional on whether the object's current generation
	// does not match the given value. If no live object exists, the precondition
	// fails. Setting to 0 makes the operation succeed only if there is a live
	// version of the object.
	IfGenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,6,opt,name=if_generation_not_match,json=ifGenerationNotMatch,proto3" json:"if_generation_not_match,omitempty"`
	// Makes the operation conditional on whether the destination object's current
	// metageneration matches the given value.
	IfMetagenerationMatch *wrappers.Int64Value `protobuf:"bytes,7,opt,name=if_metageneration_match,json=ifMetagenerationMatch,proto3" json:"if_metageneration_match,omitempty"`
	// Makes the operation conditional on whether the destination object's current
	// metageneration does not match the given value.
	IfMetagenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,8,opt,name=if_metageneration_not_match,json=ifMetagenerationNotMatch,proto3" json:"if_metageneration_not_match,omitempty"`
	// Makes the operation conditional on whether the source object's current
	// generation matches the given value.
	IfSourceGenerationMatch *wrappers.Int64Value `protobuf:"bytes,9,opt,name=if_source_generation_match,json=ifSourceGenerationMatch,proto3" json:"if_source_generation_match,omitempty"`
	// Makes the operation conditional on whether the source object's current
	// generation does not match the given value.
	IfSourceGenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,10,opt,name=if_source_generation_not_match,json=ifSourceGenerationNotMatch,proto3" json:"if_source_generation_not_match,omitempty"`
	// Makes the operation conditional on whether the source object's current
	// metageneration matches the given value.
	IfSourceMetagenerationMatch *wrappers.Int64Value `protobuf:"bytes,11,opt,name=if_source_metageneration_match,json=ifSourceMetagenerationMatch,proto3" json:"if_source_metageneration_match,omitempty"`
	// Makes the operation conditional on whether the source object's current
	// metageneration does not match the given value.
	IfSourceMetagenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,12,opt,name=if_source_metageneration_not_match,json=ifSourceMetagenerationNotMatch,proto3" json:"if_source_metageneration_not_match,omitempty"`
	// The maximum number of bytes that will be rewritten per rewrite request.
	// Most callers
	// shouldn't need to specify this parameter - it is primarily in place to
	// support testing. If specified the value must be an integral multiple of
	// 1 MiB (1048576). Also, this only applies to requests where the source and
	// destination span locations and/or storage classes. Finally, this value must
	// not change across rewrite calls else you'll get an error that the
	// `rewriteToken` is invalid.
	MaxBytesRewrittenPerCall int64 `protobuf:"varint,13,opt,name=max_bytes_rewritten_per_call,json=maxBytesRewrittenPerCall,proto3" json:"max_bytes_rewritten_per_call,omitempty"`
	// Set of properties to return. Defaults to `NO_ACL`, unless the
	// object resource specifies the `acl` property, when it defaults
	// to `full`.
	Projection CommonEnums_Projection `protobuf:"varint,14,opt,name=projection,proto3,enum=google.storage.v1.CommonEnums_Projection" json:"projection,omitempty"`
	// Include this field (from the previous rewrite response) on each rewrite
	// request after the first one, until the rewrite response 'done' flag is
	// true. Calls that provide a rewriteToken can omit all other request fields,
	// but if included those fields must match the values provided in the first
	// rewrite request.
	RewriteToken string `protobuf:"bytes,15,opt,name=rewrite_token,json=rewriteToken,proto3" json:"rewrite_token,omitempty"`
	// Required. Name of the bucket in which to find the source object.
	SourceBucket string `protobuf:"bytes,16,opt,name=source_bucket,json=sourceBucket,proto3" json:"source_bucket,omitempty"`
	// Required. Name of the source object.
	SourceObject string `protobuf:"bytes,17,opt,name=source_object,json=sourceObject,proto3" json:"source_object,omitempty"`
	// If present, selects a specific revision of the source object (as opposed to
	// the latest version, the default).
	SourceGeneration int64 `protobuf:"varint,18,opt,name=source_generation,json=sourceGeneration,proto3" json:"source_generation,omitempty"`
	// Properties of the destination, post-rewrite object.
	Object *Object `protobuf:"bytes,20,opt,name=object,proto3" json:"object,omitempty"`
	// The algorithm used to encrypt the source object, if any.
	CopySourceEncryptionAlgorithm string `protobuf:"bytes,21,opt,name=copy_source_encryption_algorithm,json=copySourceEncryptionAlgorithm,proto3" json:"copy_source_encryption_algorithm,omitempty"`
	// The encryption key used to encrypt the source object, if any.
	CopySourceEncryptionKey string `protobuf:"bytes,22,opt,name=copy_source_encryption_key,json=copySourceEncryptionKey,proto3" json:"copy_source_encryption_key,omitempty"`
	// The SHA-256 hash of the key used to encrypt the source object, if any.
	CopySourceEncryptionKeySha256 string `protobuf:"bytes,23,opt,name=copy_source_encryption_key_sha256,json=copySourceEncryptionKeySha256,proto3" json:"copy_source_encryption_key_sha256,omitempty"`
	// A set of parameters common to Storage API requests concerning an object.
	CommonObjectRequestParams *CommonObjectRequestParams `protobuf:"bytes,24,opt,name=common_object_request_params,json=commonObjectRequestParams,proto3" json:"common_object_request_params,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,25,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *RewriteObjectRequest) Reset()         { *m = RewriteObjectRequest{} }
func (m *RewriteObjectRequest) String() string { return proto.CompactTextString(m) }
func (*RewriteObjectRequest) ProtoMessage()    {}
func (*RewriteObjectRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{41}
}

func (m *RewriteObjectRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RewriteObjectRequest.Unmarshal(m, b)
}
func (m *RewriteObjectRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RewriteObjectRequest.Marshal(b, m, deterministic)
}
func (m *RewriteObjectRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RewriteObjectRequest.Merge(m, src)
}
func (m *RewriteObjectRequest) XXX_Size() int {
	return xxx_messageInfo_RewriteObjectRequest.Size(m)
}
func (m *RewriteObjectRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RewriteObjectRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RewriteObjectRequest proto.InternalMessageInfo

func (m *RewriteObjectRequest) GetDestinationBucket() string {
	if m != nil {
		return m.DestinationBucket
	}
	return ""
}

func (m *RewriteObjectRequest) GetDestinationObject() string {
	if m != nil {
		return m.DestinationObject
	}
	return ""
}

func (m *RewriteObjectRequest) GetDestinationKmsKeyName() string {
	if m != nil {
		return m.DestinationKmsKeyName
	}
	return ""
}

func (m *RewriteObjectRequest) GetDestinationPredefinedAcl() CommonEnums_PredefinedObjectAcl {
	if m != nil {
		return m.DestinationPredefinedAcl
	}
	return CommonEnums_PREDEFINED_OBJECT_ACL_UNSPECIFIED
}

func (m *RewriteObjectRequest) GetIfGenerationMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfGenerationMatch
	}
	return nil
}

func (m *RewriteObjectRequest) GetIfGenerationNotMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfGenerationNotMatch
	}
	return nil
}

func (m *RewriteObjectRequest) GetIfMetagenerationMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfMetagenerationMatch
	}
	return nil
}

func (m *RewriteObjectRequest) GetIfMetagenerationNotMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfMetagenerationNotMatch
	}
	return nil
}

func (m *RewriteObjectRequest) GetIfSourceGenerationMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfSourceGenerationMatch
	}
	return nil
}

func (m *RewriteObjectRequest) GetIfSourceGenerationNotMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfSourceGenerationNotMatch
	}
	return nil
}

func (m *RewriteObjectRequest) GetIfSourceMetagenerationMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfSourceMetagenerationMatch
	}
	return nil
}

func (m *RewriteObjectRequest) GetIfSourceMetagenerationNotMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfSourceMetagenerationNotMatch
	}
	return nil
}

func (m *RewriteObjectRequest) GetMaxBytesRewrittenPerCall() int64 {
	if m != nil {
		return m.MaxBytesRewrittenPerCall
	}
	return 0
}

func (m *RewriteObjectRequest) GetProjection() CommonEnums_Projection {
	if m != nil {
		return m.Projection
	}
	return CommonEnums_PROJECTION_UNSPECIFIED
}

func (m *RewriteObjectRequest) GetRewriteToken() string {
	if m != nil {
		return m.RewriteToken
	}
	return ""
}

func (m *RewriteObjectRequest) GetSourceBucket() string {
	if m != nil {
		return m.SourceBucket
	}
	return ""
}

func (m *RewriteObjectRequest) GetSourceObject() string {
	if m != nil {
		return m.SourceObject
	}
	return ""
}

func (m *RewriteObjectRequest) GetSourceGeneration() int64 {
	if m != nil {
		return m.SourceGeneration
	}
	return 0
}

func (m *RewriteObjectRequest) GetObject() *Object {
	if m != nil {
		return m.Object
	}
	return nil
}

func (m *RewriteObjectRequest) GetCopySourceEncryptionAlgorithm() string {
	if m != nil {
		return m.CopySourceEncryptionAlgorithm
	}
	return ""
}

func (m *RewriteObjectRequest) GetCopySourceEncryptionKey() string {
	if m != nil {
		return m.CopySourceEncryptionKey
	}
	return ""
}

func (m *RewriteObjectRequest) GetCopySourceEncryptionKeySha256() string {
	if m != nil {
		return m.CopySourceEncryptionKeySha256
	}
	return ""
}

func (m *RewriteObjectRequest) GetCommonObjectRequestParams() *CommonObjectRequestParams {
	if m != nil {
		return m.CommonObjectRequestParams
	}
	return nil
}

func (m *RewriteObjectRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// A rewrite response.
type RewriteResponse struct {
	// The total bytes written so far, which can be used to provide a waiting user
	// with a progress indicator. This property is always present in the response.
	TotalBytesRewritten int64 `protobuf:"varint,1,opt,name=total_bytes_rewritten,json=totalBytesRewritten,proto3" json:"total_bytes_rewritten,omitempty"`
	// The total size of the object being copied in bytes. This property is always
	// present in the response.
	ObjectSize int64 `protobuf:"varint,2,opt,name=object_size,json=objectSize,proto3" json:"object_size,omitempty"`
	// `true` if the copy is finished; otherwise, `false` if
	// the copy is in progress. This property is always present in the response.
	Done bool `protobuf:"varint,3,opt,name=done,proto3" json:"done,omitempty"`
	// A token to use in subsequent requests to continue copying data. This token
	// is present in the response only when there is more data to copy.
	RewriteToken string `protobuf:"bytes,4,opt,name=rewrite_token,json=rewriteToken,proto3" json:"rewrite_token,omitempty"`
	// A resource containing the metadata for the copied-to object. This property
	// is present in the response only when copying completes.
	Resource             *Object  `protobuf:"bytes,5,opt,name=resource,proto3" json:"resource,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RewriteResponse) Reset()         { *m = RewriteResponse{} }
func (m *RewriteResponse) String() string { return proto.CompactTextString(m) }
func (*RewriteResponse) ProtoMessage()    {}
func (*RewriteResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{42}
}

func (m *RewriteResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RewriteResponse.Unmarshal(m, b)
}
func (m *RewriteResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RewriteResponse.Marshal(b, m, deterministic)
}
func (m *RewriteResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RewriteResponse.Merge(m, src)
}
func (m *RewriteResponse) XXX_Size() int {
	return xxx_messageInfo_RewriteResponse.Size(m)
}
func (m *RewriteResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RewriteResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RewriteResponse proto.InternalMessageInfo

func (m *RewriteResponse) GetTotalBytesRewritten() int64 {
	if m != nil {
		return m.TotalBytesRewritten
	}
	return 0
}

func (m *RewriteResponse) GetObjectSize() int64 {
	if m != nil {
		return m.ObjectSize
	}
	return 0
}

func (m *RewriteResponse) GetDone() bool {
	if m != nil {
		return m.Done
	}
	return false
}

func (m *RewriteResponse) GetRewriteToken() string {
	if m != nil {
		return m.RewriteToken
	}
	return ""
}

func (m *RewriteResponse) GetResource() *Object {
	if m != nil {
		return m.Resource
	}
	return nil
}

// Request message StartResumableWrite.
type StartResumableWriteRequest struct {
	// The destination bucket, object, and metadata, as well as any preconditions.
	InsertObjectSpec *InsertObjectSpec `protobuf:"bytes,1,opt,name=insert_object_spec,json=insertObjectSpec,proto3" json:"insert_object_spec,omitempty"`
	// A set of parameters common to Storage API requests concerning an object.
	CommonObjectRequestParams *CommonObjectRequestParams `protobuf:"bytes,3,opt,name=common_object_request_params,json=commonObjectRequestParams,proto3" json:"common_object_request_params,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,4,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *StartResumableWriteRequest) Reset()         { *m = StartResumableWriteRequest{} }
func (m *StartResumableWriteRequest) String() string { return proto.CompactTextString(m) }
func (*StartResumableWriteRequest) ProtoMessage()    {}
func (*StartResumableWriteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{43}
}

func (m *StartResumableWriteRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartResumableWriteRequest.Unmarshal(m, b)
}
func (m *StartResumableWriteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartResumableWriteRequest.Marshal(b, m, deterministic)
}
func (m *StartResumableWriteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartResumableWriteRequest.Merge(m, src)
}
func (m *StartResumableWriteRequest) XXX_Size() int {
	return xxx_messageInfo_StartResumableWriteRequest.Size(m)
}
func (m *StartResumableWriteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StartResumableWriteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StartResumableWriteRequest proto.InternalMessageInfo

func (m *StartResumableWriteRequest) GetInsertObjectSpec() *InsertObjectSpec {
	if m != nil {
		return m.InsertObjectSpec
	}
	return nil
}

func (m *StartResumableWriteRequest) GetCommonObjectRequestParams() *CommonObjectRequestParams {
	if m != nil {
		return m.CommonObjectRequestParams
	}
	return nil
}

func (m *StartResumableWriteRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Response object for ByteStream.StartResumableWrite.
type StartResumableWriteResponse struct {
	// The upload_id of the newly started resumable write operation. This
	// value should be copied into the `InsertObjectRequest.upload_id` field.
	UploadId             string   `protobuf:"bytes,1,opt,name=upload_id,json=uploadId,proto3" json:"upload_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StartResumableWriteResponse) Reset()         { *m = StartResumableWriteResponse{} }
func (m *StartResumableWriteResponse) String() string { return proto.CompactTextString(m) }
func (*StartResumableWriteResponse) ProtoMessage()    {}
func (*StartResumableWriteResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{44}
}

func (m *StartResumableWriteResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartResumableWriteResponse.Unmarshal(m, b)
}
func (m *StartResumableWriteResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartResumableWriteResponse.Marshal(b, m, deterministic)
}
func (m *StartResumableWriteResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartResumableWriteResponse.Merge(m, src)
}
func (m *StartResumableWriteResponse) XXX_Size() int {
	return xxx_messageInfo_StartResumableWriteResponse.Size(m)
}
func (m *StartResumableWriteResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StartResumableWriteResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StartResumableWriteResponse proto.InternalMessageInfo

func (m *StartResumableWriteResponse) GetUploadId() string {
	if m != nil {
		return m.UploadId
	}
	return ""
}

// Request message for PatchObject.
type PatchObjectRequest struct {
	// Required. Name of the bucket in which the object resides.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. Name of the object.
	Object string `protobuf:"bytes,2,opt,name=object,proto3" json:"object,omitempty"`
	// If present, selects a specific revision of this object (as opposed to the
	// latest version, the default).
	Generation int64 `protobuf:"varint,3,opt,name=generation,proto3" json:"generation,omitempty"`
	// Makes the operation conditional on whether the object's current generation
	// matches the given value. Setting to 0 makes the operation succeed only if
	// there are no live versions of the object.
	IfGenerationMatch *wrappers.Int64Value `protobuf:"bytes,4,opt,name=if_generation_match,json=ifGenerationMatch,proto3" json:"if_generation_match,omitempty"`
	// Makes the operation conditional on whether the object's current generation
	// does not match the given value. If no live object exists, the precondition
	// fails. Setting to 0 makes the operation succeed only if there is a live
	// version of the object.
	IfGenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,5,opt,name=if_generation_not_match,json=ifGenerationNotMatch,proto3" json:"if_generation_not_match,omitempty"`
	// Makes the operation conditional on whether the object's current
	// metageneration matches the given value.
	IfMetagenerationMatch *wrappers.Int64Value `protobuf:"bytes,6,opt,name=if_metageneration_match,json=ifMetagenerationMatch,proto3" json:"if_metageneration_match,omitempty"`
	// Makes the operation conditional on whether the object's current
	// metageneration does not match the given value.
	IfMetagenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,7,opt,name=if_metageneration_not_match,json=ifMetagenerationNotMatch,proto3" json:"if_metageneration_not_match,omitempty"`
	// Apply a predefined set of access controls to this object.
	PredefinedAcl CommonEnums_PredefinedObjectAcl `protobuf:"varint,8,opt,name=predefined_acl,json=predefinedAcl,proto3,enum=google.storage.v1.CommonEnums_PredefinedObjectAcl" json:"predefined_acl,omitempty"`
	// Set of properties to return. Defaults to `FULL`.
	Projection CommonEnums_Projection `protobuf:"varint,9,opt,name=projection,proto3,enum=google.storage.v1.CommonEnums_Projection" json:"projection,omitempty"`
	// The Object metadata for updating.
	Metadata *Object `protobuf:"bytes,11,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// List of fields to be updated.
	//
	// To specify ALL fields, equivalent to the JSON API's "update" function,
	// specify a single field with the value `*`. Note: not recommended. If a new
	// field is introduced at a later time, an older client updating with the `*`
	// may accidentally reset the new field's value.
	//
	// Not specifying any fields is an error.
	// Not specifying a field while setting that field to a non-default value is
	// an error.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,12,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// A set of parameters common to Storage API requests concerning an object.
	CommonObjectRequestParams *CommonObjectRequestParams `protobuf:"bytes,13,opt,name=common_object_request_params,json=commonObjectRequestParams,proto3" json:"common_object_request_params,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,14,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *PatchObjectRequest) Reset()         { *m = PatchObjectRequest{} }
func (m *PatchObjectRequest) String() string { return proto.CompactTextString(m) }
func (*PatchObjectRequest) ProtoMessage()    {}
func (*PatchObjectRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{45}
}

func (m *PatchObjectRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PatchObjectRequest.Unmarshal(m, b)
}
func (m *PatchObjectRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PatchObjectRequest.Marshal(b, m, deterministic)
}
func (m *PatchObjectRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PatchObjectRequest.Merge(m, src)
}
func (m *PatchObjectRequest) XXX_Size() int {
	return xxx_messageInfo_PatchObjectRequest.Size(m)
}
func (m *PatchObjectRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PatchObjectRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PatchObjectRequest proto.InternalMessageInfo

func (m *PatchObjectRequest) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *PatchObjectRequest) GetObject() string {
	if m != nil {
		return m.Object
	}
	return ""
}

func (m *PatchObjectRequest) GetGeneration() int64 {
	if m != nil {
		return m.Generation
	}
	return 0
}

func (m *PatchObjectRequest) GetIfGenerationMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfGenerationMatch
	}
	return nil
}

func (m *PatchObjectRequest) GetIfGenerationNotMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfGenerationNotMatch
	}
	return nil
}

func (m *PatchObjectRequest) GetIfMetagenerationMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfMetagenerationMatch
	}
	return nil
}

func (m *PatchObjectRequest) GetIfMetagenerationNotMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfMetagenerationNotMatch
	}
	return nil
}

func (m *PatchObjectRequest) GetPredefinedAcl() CommonEnums_PredefinedObjectAcl {
	if m != nil {
		return m.PredefinedAcl
	}
	return CommonEnums_PREDEFINED_OBJECT_ACL_UNSPECIFIED
}

func (m *PatchObjectRequest) GetProjection() CommonEnums_Projection {
	if m != nil {
		return m.Projection
	}
	return CommonEnums_PROJECTION_UNSPECIFIED
}

func (m *PatchObjectRequest) GetMetadata() *Object {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PatchObjectRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *PatchObjectRequest) GetCommonObjectRequestParams() *CommonObjectRequestParams {
	if m != nil {
		return m.CommonObjectRequestParams
	}
	return nil
}

func (m *PatchObjectRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Request message for UpdateObject.
type UpdateObjectRequest struct {
	// Required. Name of the bucket in which the object resides.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. Name of the object.
	Object string `protobuf:"bytes,2,opt,name=object,proto3" json:"object,omitempty"`
	// If present, selects a specific revision of this object (as opposed to the
	// latest version, the default).
	Generation int64 `protobuf:"varint,3,opt,name=generation,proto3" json:"generation,omitempty"`
	// Makes the operation conditional on whether the object's current generation
	// matches the given value. Setting to 0 makes the operation succeed only if
	// there are no live versions of the object.
	IfGenerationMatch *wrappers.Int64Value `protobuf:"bytes,4,opt,name=if_generation_match,json=ifGenerationMatch,proto3" json:"if_generation_match,omitempty"`
	// Makes the operation conditional on whether the object's current generation
	// does not match the given value. If no live object exists, the precondition
	// fails. Setting to 0 makes the operation succeed only if there is a live
	// version of the object.
	IfGenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,5,opt,name=if_generation_not_match,json=ifGenerationNotMatch,proto3" json:"if_generation_not_match,omitempty"`
	// Makes the operation conditional on whether the object's current
	// metageneration matches the given value.
	IfMetagenerationMatch *wrappers.Int64Value `protobuf:"bytes,6,opt,name=if_metageneration_match,json=ifMetagenerationMatch,proto3" json:"if_metageneration_match,omitempty"`
	// Makes the operation conditional on whether the object's current
	// metageneration does not match the given value.
	IfMetagenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,7,opt,name=if_metageneration_not_match,json=ifMetagenerationNotMatch,proto3" json:"if_metageneration_not_match,omitempty"`
	// Apply a predefined set of access controls to this object.
	PredefinedAcl CommonEnums_PredefinedObjectAcl `protobuf:"varint,8,opt,name=predefined_acl,json=predefinedAcl,proto3,enum=google.storage.v1.CommonEnums_PredefinedObjectAcl" json:"predefined_acl,omitempty"`
	// Set of properties to return. Defaults to `FULL`.
	Projection CommonEnums_Projection `protobuf:"varint,9,opt,name=projection,proto3,enum=google.storage.v1.CommonEnums_Projection" json:"projection,omitempty"`
	// The Object metadata for updating.
	Metadata *Object `protobuf:"bytes,11,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// A set of parameters common to Storage API requests concerning an object.
	CommonObjectRequestParams *CommonObjectRequestParams `protobuf:"bytes,12,opt,name=common_object_request_params,json=commonObjectRequestParams,proto3" json:"common_object_request_params,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,13,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *UpdateObjectRequest) Reset()         { *m = UpdateObjectRequest{} }
func (m *UpdateObjectRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateObjectRequest) ProtoMessage()    {}
func (*UpdateObjectRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{46}
}

func (m *UpdateObjectRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateObjectRequest.Unmarshal(m, b)
}
func (m *UpdateObjectRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateObjectRequest.Marshal(b, m, deterministic)
}
func (m *UpdateObjectRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateObjectRequest.Merge(m, src)
}
func (m *UpdateObjectRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateObjectRequest.Size(m)
}
func (m *UpdateObjectRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateObjectRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateObjectRequest proto.InternalMessageInfo

func (m *UpdateObjectRequest) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *UpdateObjectRequest) GetObject() string {
	if m != nil {
		return m.Object
	}
	return ""
}

func (m *UpdateObjectRequest) GetGeneration() int64 {
	if m != nil {
		return m.Generation
	}
	return 0
}

func (m *UpdateObjectRequest) GetIfGenerationMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfGenerationMatch
	}
	return nil
}

func (m *UpdateObjectRequest) GetIfGenerationNotMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfGenerationNotMatch
	}
	return nil
}

func (m *UpdateObjectRequest) GetIfMetagenerationMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfMetagenerationMatch
	}
	return nil
}

func (m *UpdateObjectRequest) GetIfMetagenerationNotMatch() *wrappers.Int64Value {
	if m != nil {
		return m.IfMetagenerationNotMatch
	}
	return nil
}

func (m *UpdateObjectRequest) GetPredefinedAcl() CommonEnums_PredefinedObjectAcl {
	if m != nil {
		return m.PredefinedAcl
	}
	return CommonEnums_PREDEFINED_OBJECT_ACL_UNSPECIFIED
}

func (m *UpdateObjectRequest) GetProjection() CommonEnums_Projection {
	if m != nil {
		return m.Projection
	}
	return CommonEnums_PROJECTION_UNSPECIFIED
}

func (m *UpdateObjectRequest) GetMetadata() *Object {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *UpdateObjectRequest) GetCommonObjectRequestParams() *CommonObjectRequestParams {
	if m != nil {
		return m.CommonObjectRequestParams
	}
	return nil
}

func (m *UpdateObjectRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Request message for WatchAllObjects.
type WatchAllObjectsRequest struct {
	// Name of the bucket in which to look for objects.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// If `true`, lists all versions of an object as distinct results.
	// The default is `false`. For more information, see
	// [Object
	// Versioning](https://cloud.google.com/storage/docs/object-versioning).
	Versions bool `protobuf:"varint,2,opt,name=versions,proto3" json:"versions,omitempty"`
	// Returns results in a directory-like mode. `items` will contain
	// only objects whose names, aside from the `prefix`, do not
	// contain `delimiter`. Objects whose names, aside from the
	// `prefix`, contain `delimiter` will have their name,
	// truncated after the `delimiter`, returned in
	// `prefixes`. Duplicate `prefixes` are omitted.
	Delimiter string `protobuf:"bytes,3,opt,name=delimiter,proto3" json:"delimiter,omitempty"`
	// Maximum number of `items` plus `prefixes` to return
	// in a single page of responses. As duplicate `prefixes` are
	// omitted, fewer total results may be returned than requested. The service
	// will use this parameter or 1,000 items, whichever is smaller.
	MaxResults int32 `protobuf:"varint,4,opt,name=max_results,json=maxResults,proto3" json:"max_results,omitempty"`
	// Filter results to objects whose names begin with this prefix.
	Prefix string `protobuf:"bytes,5,opt,name=prefix,proto3" json:"prefix,omitempty"`
	// If true, objects that end in exactly one instance of `delimiter`
	// will have their metadata included in `items` in addition to
	// `prefixes`.
	IncludeTrailingDelimiter bool `protobuf:"varint,6,opt,name=include_trailing_delimiter,json=includeTrailingDelimiter,proto3" json:"include_trailing_delimiter,omitempty"`
	// A previously-returned page token representing part of the larger set of
	// results to view.
	PageToken string `protobuf:"bytes,7,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Set of properties to return. Defaults to `NO_ACL`.
	Projection CommonEnums_Projection `protobuf:"varint,8,opt,name=projection,proto3,enum=google.storage.v1.CommonEnums_Projection" json:"projection,omitempty"`
	// Properties of the channel to be inserted.
	Channel *Channel `protobuf:"bytes,10,opt,name=channel,proto3" json:"channel,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,11,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *WatchAllObjectsRequest) Reset()         { *m = WatchAllObjectsRequest{} }
func (m *WatchAllObjectsRequest) String() string { return proto.CompactTextString(m) }
func (*WatchAllObjectsRequest) ProtoMessage()    {}
func (*WatchAllObjectsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{47}
}

func (m *WatchAllObjectsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WatchAllObjectsRequest.Unmarshal(m, b)
}
func (m *WatchAllObjectsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WatchAllObjectsRequest.Marshal(b, m, deterministic)
}
func (m *WatchAllObjectsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WatchAllObjectsRequest.Merge(m, src)
}
func (m *WatchAllObjectsRequest) XXX_Size() int {
	return xxx_messageInfo_WatchAllObjectsRequest.Size(m)
}
func (m *WatchAllObjectsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_WatchAllObjectsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_WatchAllObjectsRequest proto.InternalMessageInfo

func (m *WatchAllObjectsRequest) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *WatchAllObjectsRequest) GetVersions() bool {
	if m != nil {
		return m.Versions
	}
	return false
}

func (m *WatchAllObjectsRequest) GetDelimiter() string {
	if m != nil {
		return m.Delimiter
	}
	return ""
}

func (m *WatchAllObjectsRequest) GetMaxResults() int32 {
	if m != nil {
		return m.MaxResults
	}
	return 0
}

func (m *WatchAllObjectsRequest) GetPrefix() string {
	if m != nil {
		return m.Prefix
	}
	return ""
}

func (m *WatchAllObjectsRequest) GetIncludeTrailingDelimiter() bool {
	if m != nil {
		return m.IncludeTrailingDelimiter
	}
	return false
}

func (m *WatchAllObjectsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *WatchAllObjectsRequest) GetProjection() CommonEnums_Projection {
	if m != nil {
		return m.Projection
	}
	return CommonEnums_PROJECTION_UNSPECIFIED
}

func (m *WatchAllObjectsRequest) GetChannel() *Channel {
	if m != nil {
		return m.Channel
	}
	return nil
}

func (m *WatchAllObjectsRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Request message for GetProjectServiceAccount.
type GetProjectServiceAccountRequest struct {
	// Required. Project ID.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,3,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *GetProjectServiceAccountRequest) Reset()         { *m = GetProjectServiceAccountRequest{} }
func (m *GetProjectServiceAccountRequest) String() string { return proto.CompactTextString(m) }
func (*GetProjectServiceAccountRequest) ProtoMessage()    {}
func (*GetProjectServiceAccountRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{48}
}

func (m *GetProjectServiceAccountRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetProjectServiceAccountRequest.Unmarshal(m, b)
}
func (m *GetProjectServiceAccountRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetProjectServiceAccountRequest.Marshal(b, m, deterministic)
}
func (m *GetProjectServiceAccountRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetProjectServiceAccountRequest.Merge(m, src)
}
func (m *GetProjectServiceAccountRequest) XXX_Size() int {
	return xxx_messageInfo_GetProjectServiceAccountRequest.Size(m)
}
func (m *GetProjectServiceAccountRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetProjectServiceAccountRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetProjectServiceAccountRequest proto.InternalMessageInfo

func (m *GetProjectServiceAccountRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *GetProjectServiceAccountRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

type CreateHmacKeyRequest struct {
	// Required. The project that the HMAC-owning service account lives in.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The service account to create the HMAC for.
	ServiceAccountEmail string `protobuf:"bytes,2,opt,name=service_account_email,json=serviceAccountEmail,proto3" json:"service_account_email,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,3,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *CreateHmacKeyRequest) Reset()         { *m = CreateHmacKeyRequest{} }
func (m *CreateHmacKeyRequest) String() string { return proto.CompactTextString(m) }
func (*CreateHmacKeyRequest) ProtoMessage()    {}
func (*CreateHmacKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{49}
}

func (m *CreateHmacKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateHmacKeyRequest.Unmarshal(m, b)
}
func (m *CreateHmacKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateHmacKeyRequest.Marshal(b, m, deterministic)
}
func (m *CreateHmacKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateHmacKeyRequest.Merge(m, src)
}
func (m *CreateHmacKeyRequest) XXX_Size() int {
	return xxx_messageInfo_CreateHmacKeyRequest.Size(m)
}
func (m *CreateHmacKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateHmacKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateHmacKeyRequest proto.InternalMessageInfo

func (m *CreateHmacKeyRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *CreateHmacKeyRequest) GetServiceAccountEmail() string {
	if m != nil {
		return m.ServiceAccountEmail
	}
	return ""
}

func (m *CreateHmacKeyRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Create hmac response.  The only time the secret for an HMAC will be returned.
type CreateHmacKeyResponse struct {
	// Key metadata.
	Metadata *HmacKeyMetadata `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// HMAC key secret material.
	Secret               string   `protobuf:"bytes,2,opt,name=secret,proto3" json:"secret,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateHmacKeyResponse) Reset()         { *m = CreateHmacKeyResponse{} }
func (m *CreateHmacKeyResponse) String() string { return proto.CompactTextString(m) }
func (*CreateHmacKeyResponse) ProtoMessage()    {}
func (*CreateHmacKeyResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{50}
}

func (m *CreateHmacKeyResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateHmacKeyResponse.Unmarshal(m, b)
}
func (m *CreateHmacKeyResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateHmacKeyResponse.Marshal(b, m, deterministic)
}
func (m *CreateHmacKeyResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateHmacKeyResponse.Merge(m, src)
}
func (m *CreateHmacKeyResponse) XXX_Size() int {
	return xxx_messageInfo_CreateHmacKeyResponse.Size(m)
}
func (m *CreateHmacKeyResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateHmacKeyResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CreateHmacKeyResponse proto.InternalMessageInfo

func (m *CreateHmacKeyResponse) GetMetadata() *HmacKeyMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *CreateHmacKeyResponse) GetSecret() string {
	if m != nil {
		return m.Secret
	}
	return ""
}

// Request object to delete a given HMAC key.
type DeleteHmacKeyRequest struct {
	// Required. The identifying key for the HMAC to delete.
	AccessId string `protobuf:"bytes,1,opt,name=access_id,json=accessId,proto3" json:"access_id,omitempty"`
	// Required. The project id the HMAC key lies in.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,3,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *DeleteHmacKeyRequest) Reset()         { *m = DeleteHmacKeyRequest{} }
func (m *DeleteHmacKeyRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteHmacKeyRequest) ProtoMessage()    {}
func (*DeleteHmacKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{51}
}

func (m *DeleteHmacKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteHmacKeyRequest.Unmarshal(m, b)
}
func (m *DeleteHmacKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteHmacKeyRequest.Marshal(b, m, deterministic)
}
func (m *DeleteHmacKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteHmacKeyRequest.Merge(m, src)
}
func (m *DeleteHmacKeyRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteHmacKeyRequest.Size(m)
}
func (m *DeleteHmacKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteHmacKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteHmacKeyRequest proto.InternalMessageInfo

func (m *DeleteHmacKeyRequest) GetAccessId() string {
	if m != nil {
		return m.AccessId
	}
	return ""
}

func (m *DeleteHmacKeyRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *DeleteHmacKeyRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Request object to get metadata on a given HMAC key.
type GetHmacKeyRequest struct {
	// Required. The identifying key for the HMAC to delete.
	AccessId string `protobuf:"bytes,1,opt,name=access_id,json=accessId,proto3" json:"access_id,omitempty"`
	// Required. The project id the HMAC key lies in.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,3,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *GetHmacKeyRequest) Reset()         { *m = GetHmacKeyRequest{} }
func (m *GetHmacKeyRequest) String() string { return proto.CompactTextString(m) }
func (*GetHmacKeyRequest) ProtoMessage()    {}
func (*GetHmacKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{52}
}

func (m *GetHmacKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetHmacKeyRequest.Unmarshal(m, b)
}
func (m *GetHmacKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetHmacKeyRequest.Marshal(b, m, deterministic)
}
func (m *GetHmacKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetHmacKeyRequest.Merge(m, src)
}
func (m *GetHmacKeyRequest) XXX_Size() int {
	return xxx_messageInfo_GetHmacKeyRequest.Size(m)
}
func (m *GetHmacKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetHmacKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetHmacKeyRequest proto.InternalMessageInfo

func (m *GetHmacKeyRequest) GetAccessId() string {
	if m != nil {
		return m.AccessId
	}
	return ""
}

func (m *GetHmacKeyRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *GetHmacKeyRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Request to fetch a list of HMAC keys under a given project.
type ListHmacKeysRequest struct {
	// Required. The project id to list HMAC keys for.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// An optional filter to only return HMAC keys for one service account.
	ServiceAccountEmail string `protobuf:"bytes,2,opt,name=service_account_email,json=serviceAccountEmail,proto3" json:"service_account_email,omitempty"`
	// An optional bool to return deleted keys that have not been wiped out yet.
	ShowDeletedKeys bool `protobuf:"varint,3,opt,name=show_deleted_keys,json=showDeletedKeys,proto3" json:"show_deleted_keys,omitempty"`
	// The maximum number of keys to return.
	MaxResults int32 `protobuf:"varint,4,opt,name=max_results,json=maxResults,proto3" json:"max_results,omitempty"`
	// A previously returned token from ListHmacKeysResponse to get the next page.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,6,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ListHmacKeysRequest) Reset()         { *m = ListHmacKeysRequest{} }
func (m *ListHmacKeysRequest) String() string { return proto.CompactTextString(m) }
func (*ListHmacKeysRequest) ProtoMessage()    {}
func (*ListHmacKeysRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{53}
}

func (m *ListHmacKeysRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListHmacKeysRequest.Unmarshal(m, b)
}
func (m *ListHmacKeysRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListHmacKeysRequest.Marshal(b, m, deterministic)
}
func (m *ListHmacKeysRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListHmacKeysRequest.Merge(m, src)
}
func (m *ListHmacKeysRequest) XXX_Size() int {
	return xxx_messageInfo_ListHmacKeysRequest.Size(m)
}
func (m *ListHmacKeysRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListHmacKeysRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListHmacKeysRequest proto.InternalMessageInfo

func (m *ListHmacKeysRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ListHmacKeysRequest) GetServiceAccountEmail() string {
	if m != nil {
		return m.ServiceAccountEmail
	}
	return ""
}

func (m *ListHmacKeysRequest) GetShowDeletedKeys() bool {
	if m != nil {
		return m.ShowDeletedKeys
	}
	return false
}

func (m *ListHmacKeysRequest) GetMaxResults() int32 {
	if m != nil {
		return m.MaxResults
	}
	return 0
}

func (m *ListHmacKeysRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListHmacKeysRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Hmac key list response with next page information.
type ListHmacKeysResponse struct {
	// The continuation token, used to page through large result sets. Provide
	// this value in a subsequent request to return the next page of results.
	NextPageToken string `protobuf:"bytes,1,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The list of items.
	Items                []*HmacKeyMetadata `protobuf:"bytes,2,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *ListHmacKeysResponse) Reset()         { *m = ListHmacKeysResponse{} }
func (m *ListHmacKeysResponse) String() string { return proto.CompactTextString(m) }
func (*ListHmacKeysResponse) ProtoMessage()    {}
func (*ListHmacKeysResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{54}
}

func (m *ListHmacKeysResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListHmacKeysResponse.Unmarshal(m, b)
}
func (m *ListHmacKeysResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListHmacKeysResponse.Marshal(b, m, deterministic)
}
func (m *ListHmacKeysResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListHmacKeysResponse.Merge(m, src)
}
func (m *ListHmacKeysResponse) XXX_Size() int {
	return xxx_messageInfo_ListHmacKeysResponse.Size(m)
}
func (m *ListHmacKeysResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListHmacKeysResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListHmacKeysResponse proto.InternalMessageInfo

func (m *ListHmacKeysResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListHmacKeysResponse) GetItems() []*HmacKeyMetadata {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request object to update an HMAC key state.
type UpdateHmacKeyRequest struct {
	// Required. The id of the HMAC key.
	AccessId string `protobuf:"bytes,1,opt,name=access_id,json=accessId,proto3" json:"access_id,omitempty"`
	// Required. The project id the HMAC's service account lies in.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The service account owner of the HMAC key.
	Metadata *HmacKeyMetadata `protobuf:"bytes,3,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams  *CommonRequestParams `protobuf:"bytes,5,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *UpdateHmacKeyRequest) Reset()         { *m = UpdateHmacKeyRequest{} }
func (m *UpdateHmacKeyRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateHmacKeyRequest) ProtoMessage()    {}
func (*UpdateHmacKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{55}
}

func (m *UpdateHmacKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateHmacKeyRequest.Unmarshal(m, b)
}
func (m *UpdateHmacKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateHmacKeyRequest.Marshal(b, m, deterministic)
}
func (m *UpdateHmacKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateHmacKeyRequest.Merge(m, src)
}
func (m *UpdateHmacKeyRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateHmacKeyRequest.Size(m)
}
func (m *UpdateHmacKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateHmacKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateHmacKeyRequest proto.InternalMessageInfo

func (m *UpdateHmacKeyRequest) GetAccessId() string {
	if m != nil {
		return m.AccessId
	}
	return ""
}

func (m *UpdateHmacKeyRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *UpdateHmacKeyRequest) GetMetadata() *HmacKeyMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *UpdateHmacKeyRequest) GetCommonRequestParams() *CommonRequestParams {
	if m != nil {
		return m.CommonRequestParams
	}
	return nil
}

// Parameters that can be passed to any object request.
type CommonObjectRequestParams struct {
	// Encryption algorithm used with Customer-Supplied Encryption Keys feature.
	EncryptionAlgorithm string `protobuf:"bytes,1,opt,name=encryption_algorithm,json=encryptionAlgorithm,proto3" json:"encryption_algorithm,omitempty"`
	// Encryption key used with Customer-Supplied Encryption Keys feature.
	EncryptionKey string `protobuf:"bytes,2,opt,name=encryption_key,json=encryptionKey,proto3" json:"encryption_key,omitempty"`
	// SHA256 hash of encryption key used with Customer-Supplied Encryption Keys
	// feature.
	EncryptionKeySha256  string   `protobuf:"bytes,3,opt,name=encryption_key_sha256,json=encryptionKeySha256,proto3" json:"encryption_key_sha256,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommonObjectRequestParams) Reset()         { *m = CommonObjectRequestParams{} }
func (m *CommonObjectRequestParams) String() string { return proto.CompactTextString(m) }
func (*CommonObjectRequestParams) ProtoMessage()    {}
func (*CommonObjectRequestParams) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{56}
}

func (m *CommonObjectRequestParams) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommonObjectRequestParams.Unmarshal(m, b)
}
func (m *CommonObjectRequestParams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommonObjectRequestParams.Marshal(b, m, deterministic)
}
func (m *CommonObjectRequestParams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommonObjectRequestParams.Merge(m, src)
}
func (m *CommonObjectRequestParams) XXX_Size() int {
	return xxx_messageInfo_CommonObjectRequestParams.Size(m)
}
func (m *CommonObjectRequestParams) XXX_DiscardUnknown() {
	xxx_messageInfo_CommonObjectRequestParams.DiscardUnknown(m)
}

var xxx_messageInfo_CommonObjectRequestParams proto.InternalMessageInfo

func (m *CommonObjectRequestParams) GetEncryptionAlgorithm() string {
	if m != nil {
		return m.EncryptionAlgorithm
	}
	return ""
}

func (m *CommonObjectRequestParams) GetEncryptionKey() string {
	if m != nil {
		return m.EncryptionKey
	}
	return ""
}

func (m *CommonObjectRequestParams) GetEncryptionKeySha256() string {
	if m != nil {
		return m.EncryptionKeySha256
	}
	return ""
}

// Parameters that can be passed to any request.
type CommonRequestParams struct {
	// Required. Required when using buckets with Requestor Pays feature enabled.
	UserProject string `protobuf:"bytes,1,opt,name=user_project,json=userProject,proto3" json:"user_project,omitempty"`
	// Lets you enforce per-user quotas from a server-side application even in
	// cases when the user's IP address is unknown. This can occur, for example,
	// with applications that run cron jobs on App Engine on a user's behalf.
	// You can choose any arbitrary string that uniquely identifies a user, but it
	// is limited to 40 characters.
	// Overrides user_ip if both are provided.
	QuotaUser string `protobuf:"bytes,2,opt,name=quota_user,json=quotaUser,proto3" json:"quota_user,omitempty"`
	// Subset of fields to include in the response.
	Fields               *field_mask.FieldMask `protobuf:"bytes,4,opt,name=fields,proto3" json:"fields,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *CommonRequestParams) Reset()         { *m = CommonRequestParams{} }
func (m *CommonRequestParams) String() string { return proto.CompactTextString(m) }
func (*CommonRequestParams) ProtoMessage()    {}
func (*CommonRequestParams) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{57}
}

func (m *CommonRequestParams) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommonRequestParams.Unmarshal(m, b)
}
func (m *CommonRequestParams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommonRequestParams.Marshal(b, m, deterministic)
}
func (m *CommonRequestParams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommonRequestParams.Merge(m, src)
}
func (m *CommonRequestParams) XXX_Size() int {
	return xxx_messageInfo_CommonRequestParams.Size(m)
}
func (m *CommonRequestParams) XXX_DiscardUnknown() {
	xxx_messageInfo_CommonRequestParams.DiscardUnknown(m)
}

var xxx_messageInfo_CommonRequestParams proto.InternalMessageInfo

func (m *CommonRequestParams) GetUserProject() string {
	if m != nil {
		return m.UserProject
	}
	return ""
}

func (m *CommonRequestParams) GetQuotaUser() string {
	if m != nil {
		return m.QuotaUser
	}
	return ""
}

func (m *CommonRequestParams) GetFields() *field_mask.FieldMask {
	if m != nil {
		return m.Fields
	}
	return nil
}

// Shared constants.
type ServiceConstants struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ServiceConstants) Reset()         { *m = ServiceConstants{} }
func (m *ServiceConstants) String() string { return proto.CompactTextString(m) }
func (*ServiceConstants) ProtoMessage()    {}
func (*ServiceConstants) Descriptor() ([]byte, []int) {
	return fileDescriptor_cfff1fb85921a0a4, []int{58}
}

func (m *ServiceConstants) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ServiceConstants.Unmarshal(m, b)
}
func (m *ServiceConstants) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ServiceConstants.Marshal(b, m, deterministic)
}
func (m *ServiceConstants) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServiceConstants.Merge(m, src)
}
func (m *ServiceConstants) XXX_Size() int {
	return xxx_messageInfo_ServiceConstants.Size(m)
}
func (m *ServiceConstants) XXX_DiscardUnknown() {
	xxx_messageInfo_ServiceConstants.DiscardUnknown(m)
}

var xxx_messageInfo_ServiceConstants proto.InternalMessageInfo

func init() {
	proto.RegisterEnum("google.storage.v1.ServiceConstants_Values", ServiceConstants_Values_name, ServiceConstants_Values_value)
	proto.RegisterType((*DeleteBucketAccessControlRequest)(nil), "google.storage.v1.DeleteBucketAccessControlRequest")
	proto.RegisterType((*GetBucketAccessControlRequest)(nil), "google.storage.v1.GetBucketAccessControlRequest")
	proto.RegisterType((*InsertBucketAccessControlRequest)(nil), "google.storage.v1.InsertBucketAccessControlRequest")
	proto.RegisterType((*ListBucketAccessControlsRequest)(nil), "google.storage.v1.ListBucketAccessControlsRequest")
	proto.RegisterType((*PatchBucketAccessControlRequest)(nil), "google.storage.v1.PatchBucketAccessControlRequest")
	proto.RegisterType((*UpdateBucketAccessControlRequest)(nil), "google.storage.v1.UpdateBucketAccessControlRequest")
	proto.RegisterType((*DeleteBucketRequest)(nil), "google.storage.v1.DeleteBucketRequest")
	proto.RegisterType((*GetBucketRequest)(nil), "google.storage.v1.GetBucketRequest")
	proto.RegisterType((*InsertBucketRequest)(nil), "google.storage.v1.InsertBucketRequest")
	proto.RegisterType((*ListChannelsRequest)(nil), "google.storage.v1.ListChannelsRequest")
	proto.RegisterType((*ListBucketsRequest)(nil), "google.storage.v1.ListBucketsRequest")
	proto.RegisterType((*LockRetentionPolicyRequest)(nil), "google.storage.v1.LockRetentionPolicyRequest")
	proto.RegisterType((*PatchBucketRequest)(nil), "google.storage.v1.PatchBucketRequest")
	proto.RegisterType((*UpdateBucketRequest)(nil), "google.storage.v1.UpdateBucketRequest")
	proto.RegisterType((*StopChannelRequest)(nil), "google.storage.v1.StopChannelRequest")
	proto.RegisterType((*DeleteDefaultObjectAccessControlRequest)(nil), "google.storage.v1.DeleteDefaultObjectAccessControlRequest")
	proto.RegisterType((*GetDefaultObjectAccessControlRequest)(nil), "google.storage.v1.GetDefaultObjectAccessControlRequest")
	proto.RegisterType((*InsertDefaultObjectAccessControlRequest)(nil), "google.storage.v1.InsertDefaultObjectAccessControlRequest")
	proto.RegisterType((*ListDefaultObjectAccessControlsRequest)(nil), "google.storage.v1.ListDefaultObjectAccessControlsRequest")
	proto.RegisterType((*PatchDefaultObjectAccessControlRequest)(nil), "google.storage.v1.PatchDefaultObjectAccessControlRequest")
	proto.RegisterType((*UpdateDefaultObjectAccessControlRequest)(nil), "google.storage.v1.UpdateDefaultObjectAccessControlRequest")
	proto.RegisterType((*DeleteNotificationRequest)(nil), "google.storage.v1.DeleteNotificationRequest")
	proto.RegisterType((*GetNotificationRequest)(nil), "google.storage.v1.GetNotificationRequest")
	proto.RegisterType((*InsertNotificationRequest)(nil), "google.storage.v1.InsertNotificationRequest")
	proto.RegisterType((*ListNotificationsRequest)(nil), "google.storage.v1.ListNotificationsRequest")
	proto.RegisterType((*DeleteObjectAccessControlRequest)(nil), "google.storage.v1.DeleteObjectAccessControlRequest")
	proto.RegisterType((*GetObjectAccessControlRequest)(nil), "google.storage.v1.GetObjectAccessControlRequest")
	proto.RegisterType((*InsertObjectAccessControlRequest)(nil), "google.storage.v1.InsertObjectAccessControlRequest")
	proto.RegisterType((*ListObjectAccessControlsRequest)(nil), "google.storage.v1.ListObjectAccessControlsRequest")
	proto.RegisterType((*UpdateObjectAccessControlRequest)(nil), "google.storage.v1.UpdateObjectAccessControlRequest")
	proto.RegisterType((*ComposeObjectRequest)(nil), "google.storage.v1.ComposeObjectRequest")
	proto.RegisterType((*ComposeObjectRequest_SourceObjects)(nil), "google.storage.v1.ComposeObjectRequest.SourceObjects")
	proto.RegisterType((*ComposeObjectRequest_SourceObjects_ObjectPreconditions)(nil), "google.storage.v1.ComposeObjectRequest.SourceObjects.ObjectPreconditions")
	proto.RegisterType((*CopyObjectRequest)(nil), "google.storage.v1.CopyObjectRequest")
	proto.RegisterType((*DeleteObjectRequest)(nil), "google.storage.v1.DeleteObjectRequest")
	proto.RegisterType((*GetObjectMediaRequest)(nil), "google.storage.v1.GetObjectMediaRequest")
	proto.RegisterType((*GetObjectRequest)(nil), "google.storage.v1.GetObjectRequest")
	proto.RegisterType((*GetObjectMediaResponse)(nil), "google.storage.v1.GetObjectMediaResponse")
	proto.RegisterType((*InsertObjectSpec)(nil), "google.storage.v1.InsertObjectSpec")
	proto.RegisterType((*InsertObjectRequest)(nil), "google.storage.v1.InsertObjectRequest")
	proto.RegisterType((*ListObjectsRequest)(nil), "google.storage.v1.ListObjectsRequest")
	proto.RegisterType((*QueryWriteStatusRequest)(nil), "google.storage.v1.QueryWriteStatusRequest")
	proto.RegisterType((*QueryWriteStatusResponse)(nil), "google.storage.v1.QueryWriteStatusResponse")
	proto.RegisterType((*RewriteObjectRequest)(nil), "google.storage.v1.RewriteObjectRequest")
	proto.RegisterType((*RewriteResponse)(nil), "google.storage.v1.RewriteResponse")
	proto.RegisterType((*StartResumableWriteRequest)(nil), "google.storage.v1.StartResumableWriteRequest")
	proto.RegisterType((*StartResumableWriteResponse)(nil), "google.storage.v1.StartResumableWriteResponse")
	proto.RegisterType((*PatchObjectRequest)(nil), "google.storage.v1.PatchObjectRequest")
	proto.RegisterType((*UpdateObjectRequest)(nil), "google.storage.v1.UpdateObjectRequest")
	proto.RegisterType((*WatchAllObjectsRequest)(nil), "google.storage.v1.WatchAllObjectsRequest")
	proto.RegisterType((*GetProjectServiceAccountRequest)(nil), "google.storage.v1.GetProjectServiceAccountRequest")
	proto.RegisterType((*CreateHmacKeyRequest)(nil), "google.storage.v1.CreateHmacKeyRequest")
	proto.RegisterType((*CreateHmacKeyResponse)(nil), "google.storage.v1.CreateHmacKeyResponse")
	proto.RegisterType((*DeleteHmacKeyRequest)(nil), "google.storage.v1.DeleteHmacKeyRequest")
	proto.RegisterType((*GetHmacKeyRequest)(nil), "google.storage.v1.GetHmacKeyRequest")
	proto.RegisterType((*ListHmacKeysRequest)(nil), "google.storage.v1.ListHmacKeysRequest")
	proto.RegisterType((*ListHmacKeysResponse)(nil), "google.storage.v1.ListHmacKeysResponse")
	proto.RegisterType((*UpdateHmacKeyRequest)(nil), "google.storage.v1.UpdateHmacKeyRequest")
	proto.RegisterType((*CommonObjectRequestParams)(nil), "google.storage.v1.CommonObjectRequestParams")
	proto.RegisterType((*CommonRequestParams)(nil), "google.storage.v1.CommonRequestParams")
	proto.RegisterType((*ServiceConstants)(nil), "google.storage.v1.ServiceConstants")
}

func init() { proto.RegisterFile("google/storage/v1/storage.proto", fileDescriptor_cfff1fb85921a0a4) }

var fileDescriptor_cfff1fb85921a0a4 = []byte{
	// 4394 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x3d, 0x5d, 0x6c, 0xe3, 0x46,
	0x7a, 0xa6, 0x64, 0xc9, 0xf6, 0x27, 0xff, 0x8e, 0xed, 0x5d, 0xad, 0x9c, 0x5d, 0x3b, 0xda, 0xac,
	0x77, 0x37, 0xd9, 0xd8, 0xb7, 0xce, 0x25, 0xb9, 0x4b, 0x8a, 0xeb, 0xc9, 0xb2, 0xd6, 0x56, 0xfd,
	0xbb, 0x94, 0x9c, 0x64, 0x17, 0xd7, 0xb2, 0x34, 0x35, 0xb2, 0x79, 0x16, 0x49, 0x85, 0xa4, 0x76,
	0xd7, 0x41, 0x1f, 0x16, 0x45, 0x7b, 0x2d, 0xfa, 0x70, 0x28, 0x90, 0x3e, 0xb5, 0x2f, 0x6d, 0x81,
	0x6b, 0x7b, 0xaf, 0x45, 0x03, 0x1c, 0x0e, 0x2d, 0xfa, 0x83, 0x3e, 0x1d, 0x50, 0x5c, 0x11, 0x14,
	0x3d, 0xf4, 0xa1, 0xc0, 0x3d, 0xb6, 0xaf, 0x05, 0x8a, 0xbe, 0xb4, 0xc5, 0x81, 0x9c, 0x21, 0x4d,
	0x52, 0x43, 0x91, 0xb2, 0x24, 0x5f, 0x36, 0xb7, 0x6f, 0xd6, 0xcc, 0x37, 0xdf, 0xcc, 0x7c, 0xff,
	0xf3, 0xcd, 0xf0, 0x33, 0x2c, 0x1e, 0x6b, 0xda, 0x71, 0x03, 0xaf, 0x1a, 0xa6, 0xa6, 0x8b, 0xc7,
	0x78, 0xf5, 0xc9, 0x7d, 0xe7, 0xcf, 0x95, 0xa6, 0xae, 0x99, 0x1a, 0x9a, 0x21, 0x00, 0x2b, 0x4e,
	0xeb, 0x93, 0xfb, 0x39, 0x67, 0x8c, 0xd8, 0x94, 0x57, 0xeb, 0x32, 0x6e, 0xd4, 0x84, 0x23, 0x7c,
	0x22, 0x3e, 0x91, 0x35, 0x9d, 0x8c, 0xc9, 0xdd, 0xa0, 0x00, 0xb2, 0xa8, 0x58, 0x08, 0x65, 0x51,
	0x11, 0x9a, 0x5a, 0x43, 0x96, 0xce, 0x68, 0x7f, 0xce, 0xdf, 0xef, 0xeb, 0x5b, 0xa0, 0x7d, 0xf6,
	0xaf, 0xa3, 0x56, 0x7d, 0x15, 0x2b, 0x4d, 0xd3, 0xe9, 0x5c, 0x0a, 0x76, 0x92, 0xe9, 0x15, 0xd1,
	0x38, 0x0d, 0x4c, 0xed, 0x42, 0x3c, 0xd5, 0xc5, 0x66, 0x13, 0xeb, 0x06, 0xed, 0xbf, 0x1b, 0xba,
	0x5f, 0x41, 0xc7, 0x86, 0xd6, 0xd2, 0x25, 0xec, 0x80, 0x5e, 0xf5, 0x6c, 0x53, 0x6a, 0xc8, 0x58,
	0x35, 0x49, 0x47, 0xfe, 0x07, 0x1c, 0x2c, 0x6d, 0xe0, 0x06, 0x36, 0xf1, 0x7a, 0x4b, 0x3a, 0xc5,
	0x66, 0x41, 0x92, 0xb0, 0x61, 0x14, 0x35, 0xd5, 0xd4, 0xb5, 0x06, 0x8f, 0x3f, 0x6e, 0x61, 0xc3,
	0x44, 0x0b, 0x90, 0x3e, 0xb2, 0x7b, 0xb3, 0xdc, 0x12, 0x77, 0x67, 0x6c, 0x3d, 0xf9, 0xd3, 0x42,
	0x82, 0xa7, 0x4d, 0x56, 0x27, 0x56, 0x4d, 0xd9, 0x3c, 0xcb, 0x26, 0x3c, 0x9d, 0xa4, 0x09, 0x3d,
	0x86, 0x79, 0x49, 0x53, 0x14, 0x4d, 0x15, 0x74, 0x82, 0x4b, 0x68, 0x8a, 0xba, 0xa8, 0x18, 0xd9,
	0xe1, 0x25, 0xee, 0x4e, 0x66, 0x6d, 0x79, 0xa5, 0x8d, 0x23, 0x2b, 0x45, 0x1b, 0x9e, 0x4e, 0x7d,
	0x60, 0x43, 0xf3, 0xb3, 0x52, 0x7b, 0x63, 0xfe, 0x33, 0x0e, 0xae, 0x6f, 0x62, 0xf3, 0x85, 0x5b,
	0xf7, 0xff, 0x70, 0xb0, 0x54, 0x56, 0x0d, 0xac, 0x5f, 0x78, 0xe9, 0x8f, 0x61, 0x9e, 0xfc, 0x25,
	0x88, 0xf6, 0x58, 0x41, 0x22, 0x83, 0xb3, 0xc9, 0xd0, 0xd5, 0xb1, 0xa6, 0x9a, 0x3d, 0x6a, 0x6f,
	0x1c, 0xe8, 0xce, 0xff, 0x90, 0x83, 0xc5, 0x1d, 0xd9, 0x60, 0xed, 0xdb, 0x88, 0xbb, 0x71, 0xf6,
	0xe2, 0x92, 0xbd, 0x2f, 0xee, 0x9f, 0x13, 0xb0, 0x78, 0x20, 0x9a, 0xd2, 0xc9, 0xa0, 0x04, 0x8a,
	0xcd, 0xb2, 0xe1, 0xde, 0x59, 0xf6, 0x3e, 0x64, 0x5a, 0xcd, 0x9a, 0x68, 0x62, 0xdb, 0x78, 0x64,
	0x53, 0x36, 0xc6, 0x9c, 0x83, 0xd1, 0xb1, 0x1e, 0x2b, 0x0f, 0x2c, 0xfb, 0xb2, 0x2b, 0x1a, 0xa7,
	0x3c, 0x10, 0x70, 0xeb, 0xef, 0x70, 0x92, 0xa6, 0x7b, 0x27, 0xe9, 0x1f, 0x24, 0x60, 0xe9, 0xd0,
	0x9e, 0xea, 0x85, 0xa3, 0x69, 0x28, 0x59, 0x52, 0xbd, 0x93, 0xe5, 0x6f, 0x13, 0x30, 0xeb, 0xb5,
	0xb9, 0xb1, 0x28, 0x51, 0x81, 0xab, 0x72, 0x5d, 0x50, 0xb0, 0x29, 0x1e, 0x63, 0x15, 0xeb, 0xa2,
	0x29, 0x6b, 0xaa, 0xa0, 0x58, 0xf2, 0x6a, 0x93, 0x26, 0xb3, 0xb6, 0xd0, 0xc6, 0xf0, 0xb2, 0x6a,
	0xbe, 0xf3, 0xd5, 0x0f, 0xc4, 0x46, 0x0b, 0xf3, 0xf3, 0x72, 0x7d, 0xd7, 0x37, 0x74, 0xd7, 0x1a,
	0x89, 0x1e, 0xc3, 0x42, 0x3b, 0x52, 0x55, 0x33, 0x29, 0xe2, 0x64, 0x34, 0xe2, 0x6c, 0x10, 0xf1,
	0x9e, 0x66, 0x3a, 0xb8, 0x07, 0x47, 0xc1, 0xdf, 0x49, 0xc2, 0xb4, 0x6b, 0xfa, 0xbf, 0x9c, 0xe4,
	0x2b, 0x03, 0x34, 0x75, 0xed, 0xdb, 0x58, 0xb2, 0x5a, 0x6d, 0x89, 0x9e, 0x5c, 0xbb, 0x1b, 0x4a,
	0xb3, 0x92, 0xda, 0x52, 0x8c, 0x95, 0x03, 0x77, 0x00, 0xef, 0x19, 0x3c, 0x50, 0x15, 0xff, 0x69,
	0x12, 0x66, 0xbd, 0xce, 0xcc, 0x61, 0xc6, 0x23, 0x98, 0x6c, 0xea, 0xb8, 0x86, 0xeb, 0xb2, 0x8a,
	0x6b, 0x82, 0x28, 0x35, 0x6c, 0xa6, 0x4c, 0xae, 0xad, 0x45, 0x6e, 0xc1, 0x19, 0xe4, 0xa8, 0x6a,
	0x83, 0x9f, 0x38, 0xc7, 0x54, 0x90, 0x1a, 0xa8, 0x05, 0xd7, 0x3d, 0xa8, 0x6b, 0xb8, 0x2e, 0xb6,
	0x1a, 0xa6, 0xa0, 0x1d, 0x59, 0xdb, 0xb5, 0x67, 0x4a, 0x74, 0x39, 0xd3, 0xbe, 0x3d, 0xd4, 0x9a,
	0x29, 0x77, 0x8e, 0x78, 0x83, 0xe0, 0x75, 0xfb, 0xd0, 0x75, 0x18, 0xa1, 0x34, 0xb5, 0x19, 0x4b,
	0xe5, 0xcb, 0x69, 0xeb, 0x27, 0xbf, 0xee, 0xbb, 0x82, 0x4c, 0x18, 0x74, 0x2d, 0xd4, 0x90, 0x45,
	0x3b, 0xc6, 0x91, 0xde, 0x59, 0xfc, 0x5d, 0x0e, 0x66, 0x2d, 0xaf, 0x5d, 0x3c, 0x11, 0x55, 0x15,
	0x7f, 0x01, 0x3c, 0xf5, 0x5f, 0x26, 0x00, 0x9d, 0x87, 0x11, 0xee, 0x7a, 0x16, 0x21, 0xa3, 0x88,
	0xcf, 0xac, 0xd0, 0xb7, 0xd5, 0x30, 0x0d, 0x7b, 0x51, 0x29, 0x1e, 0x14, 0xf1, 0x19, 0x4f, 0x5a,
	0xd0, 0x75, 0x80, 0xa6, 0x15, 0x1c, 0x9b, 0xda, 0x29, 0x56, 0x89, 0x43, 0xe1, 0xc7, 0xac, 0x96,
	0xaa, 0xd5, 0x80, 0xae, 0x40, 0xba, 0xa9, 0xe3, 0xba, 0xfc, 0x8c, 0xf0, 0x97, 0xa7, 0xbf, 0xbc,
	0x8c, 0x1f, 0x8e, 0x64, 0x7c, 0x6a, 0x20, 0x8a, 0xda, 0x07, 0x2e, 0xfe, 0x13, 0x07, 0xb9, 0x1d,
	0x4d, 0x3a, 0xe5, 0xb1, 0x69, 0xb9, 0x4f, 0x4d, 0x3d, 0xb0, 0x4f, 0x2a, 0xb1, 0x98, 0xf9, 0x4e,
	0x67, 0xe3, 0x99, 0x0c, 0xb7, 0x8f, 0x83, 0x8b, 0x25, 0x7f, 0x9c, 0x02, 0xe4, 0x09, 0xd7, 0xbe,
	0x9c, 0x4e, 0xa0, 0xdd, 0x8a, 0x0e, 0x5f, 0x9a, 0x15, 0x4d, 0x0d, 0xc4, 0x8a, 0xfa, 0xb5, 0x25,
	0xdd, 0x8b, 0xb6, 0xbc, 0x0d, 0xa3, 0x16, 0xd5, 0x6b, 0xa2, 0x29, 0x66, 0x47, 0xa3, 0x0c, 0xa5,
	0x0b, 0x1a, 0x8c, 0x96, 0xc7, 0xfa, 0x13, 0x2d, 0x43, 0xef, 0x12, 0xfd, 0x69, 0x0a, 0x66, 0xbd,
	0xd1, 0xf2, 0x4b, 0x91, 0x7e, 0x29, 0xd2, 0xf1, 0x44, 0x3a, 0x54, 0x2a, 0xc7, 0x7a, 0x97, 0xca,
	0x3f, 0xe3, 0x00, 0x55, 0x4c, 0xad, 0x49, 0xbd, 0xbf, 0x23, 0x94, 0x5f, 0x85, 0x11, 0x89, 0xb4,
	0xd8, 0x52, 0xe9, 0xd1, 0x20, 0xef, 0x24, 0x74, 0x8c, 0x03, 0x1a, 0xbe, 0xd0, 0x44, 0x1f, 0x4e,
	0x55, 0x1c, 0xdc, 0x26, 0xa7, 0xaa, 0x00, 0x87, 0x5e, 0x98, 0xc4, 0xd0, 0x5f, 0x73, 0xf0, 0xda,
	0x26, 0x36, 0x5f, 0xd4, 0xe5, 0xff, 0x3f, 0x07, 0xb7, 0xc9, 0x51, 0xa0, 0xc7, 0x1d, 0x3c, 0x86,
	0x79, 0x57, 0x69, 0x63, 0xa6, 0xb7, 0x58, 0x53, 0xcd, 0x6a, 0xed, 0x8d, 0x03, 0x25, 0xc0, 0xe7,
	0x09, 0x58, 0xb6, 0xe2, 0xd2, 0xf0, 0xed, 0x1b, 0x2f, 0x8f, 0xfa, 0xdd, 0x12, 0xf5, 0x27, 0x09,
	0x58, 0xb6, 0xe3, 0xbc, 0x01, 0xab, 0x05, 0x5b, 0xe2, 0x86, 0x7b, 0x97, 0xb8, 0x2f, 0x6c, 0x76,
	0xee, 0x8f, 0x12, 0x70, 0x9b, 0xc4, 0x1b, 0x2f, 0x2a, 0x69, 0x07, 0x29, 0x77, 0x7f, 0xc3, 0xc1,
	0x35, 0xe2, 0x4e, 0xf6, 0x34, 0x53, 0xae, 0xcb, 0x92, 0x2d, 0xf2, 0xb1, 0xe8, 0x71, 0x1b, 0xc6,
	0x55, 0xcf, 0x18, 0x2f, 0x55, 0x7c, 0x1d, 0x03, 0x35, 0x46, 0x3f, 0xe4, 0xe0, 0xca, 0x26, 0x36,
	0x5f, 0xcc, 0xc5, 0xff, 0x1b, 0x07, 0xd7, 0x88, 0x2b, 0xe9, 0x7a, 0xfd, 0xc5, 0xc0, 0xfa, 0x89,
	0x61, 0x5b, 0x64, 0xac, 0xc6, 0x87, 0xfa, 0xf2, 0xf6, 0xf6, 0x29, 0x07, 0x59, 0xcb, 0x4b, 0x78,
	0xa7, 0xff, 0xf9, 0xe7, 0x54, 0xfe, 0xdb, 0xbd, 0x07, 0x1c, 0x88, 0x15, 0x58, 0x80, 0x34, 0x51,
	0x60, 0x6f, 0xee, 0x8c, 0x36, 0xa1, 0x1b, 0x00, 0xe7, 0x4e, 0xc5, 0x26, 0x71, 0x92, 0xf7, 0xb4,
	0x0c, 0xd4, 0x08, 0xfe, 0x17, 0xb9, 0x44, 0xfc, 0xc5, 0xda, 0xf4, 0x5f, 0x25, 0x9c, 0x1b, 0xc8,
	0x1e, 0xf6, 0x4d, 0xb7, 0x96, 0x88, 0xda, 0x5a, 0x92, 0xb5, 0x35, 0xb6, 0x4b, 0x48, 0x0d, 0xd0,
	0x25, 0xf4, 0x81, 0x6c, 0x3f, 0xa1, 0xd7, 0x97, 0x17, 0x0e, 0xec, 0x7a, 0xa5, 0xda, 0xc0, 0x9c,
	0xdd, 0x77, 0x93, 0xce, 0x45, 0xdd, 0x17, 0x52, 0x11, 0xd8, 0xd2, 0x92, 0x1e, 0xa0, 0xb4, 0xf4,
	0x9e, 0x70, 0x0d, 0xc6, 0x7d, 0xa3, 0xdd, 0xc4, 0x7d, 0xf9, 0x7f, 0x18, 0x85, 0xb9, 0xa2, 0xa6,
	0x34, 0x35, 0x83, 0x72, 0xc4, 0x61, 0xc2, 0x1a, 0xa0, 0x1a, 0x36, 0x4c, 0x59, 0x25, 0x01, 0x7c,
	0x3b, 0x43, 0x66, 0x3c, 0xdd, 0x24, 0x51, 0x10, 0x1c, 0xd3, 0x2e, 0x82, 0xde, 0x31, 0x64, 0x3a,
	0xd4, 0x84, 0x9c, 0x77, 0x4c, 0x20, 0x65, 0x93, 0xbc, 0x70, 0x22, 0x25, 0xeb, 0xc1, 0x7a, 0xe0,
	0xcb, 0xde, 0xbc, 0x0f, 0x19, 0x4f, 0x5f, 0x36, 0x13, 0x9a, 0xfe, 0xa0, 0x04, 0xf1, 0x42, 0xa3,
	0x6f, 0xc1, 0x24, 0x79, 0xf0, 0x42, 0x77, 0x67, 0x64, 0xc7, 0x97, 0x92, 0x77, 0x32, 0x6b, 0x6f,
	0xb3, 0x97, 0xd8, 0x46, 0xd7, 0x95, 0x8a, 0x3d, 0x9a, 0xb4, 0x19, 0xfc, 0x84, 0xe1, 0xfd, 0x89,
	0xb6, 0x61, 0x56, 0xae, 0x0b, 0x6d, 0x87, 0xb1, 0xe1, 0xe8, 0x33, 0xd3, 0x8c, 0x5c, 0xdf, 0x0c,
	0x1c, 0xc4, 0x3a, 0x9c, 0xee, 0x52, 0x17, 0x3e, 0xdd, 0x2d, 0xc1, 0xf8, 0xa9, 0x62, 0x08, 0xa7,
	0xf8, 0x4c, 0x50, 0x45, 0x05, 0xdb, 0xba, 0x31, 0xc6, 0xc3, 0xa9, 0x62, 0x6c, 0xe3, 0xb3, 0x3d,
	0x51, 0xc1, 0x48, 0x81, 0x57, 0xa8, 0xa8, 0x53, 0x6d, 0x62, 0xa6, 0x8a, 0xee, 0x85, 0xb2, 0xd4,
	0x47, 0x2e, 0x2a, 0xf7, 0xd7, 0xa4, 0xb0, 0xae, 0x41, 0x26, 0x4a, 0x73, 0xdf, 0x4b, 0xc0, 0x84,
	0x8f, 0x5f, 0x08, 0xc1, 0xb0, 0xbd, 0x6d, 0x5b, 0x0f, 0x78, 0xfb, 0xef, 0x80, 0x5d, 0x49, 0xb4,
	0xd9, 0x95, 0xdf, 0x80, 0x39, 0x4a, 0x89, 0xa6, 0x8e, 0x25, 0x4d, 0xad, 0xc9, 0x76, 0x24, 0x46,
	0x83, 0xa9, 0xf2, 0x85, 0x04, 0x87, 0xca, 0xe6, 0x81, 0x17, 0xa1, 0x63, 0x79, 0x7c, 0x8d, 0xb9,
	0x23, 0x98, 0x65, 0xc0, 0x86, 0x49, 0x1a, 0x77, 0x11, 0x49, 0xcb, 0x7f, 0x9e, 0x81, 0x99, 0xa2,
	0xd6, 0x3c, 0xfb, 0x45, 0xb1, 0x20, 0x7d, 0x55, 0x53, 0xde, 0x56, 0x53, 0x66, 0xae, 0x24, 0x86,
	0x9a, 0xce, 0x79, 0x11, 0xba, 0x79, 0x92, 0x0e, 0xaa, 0x9f, 0x1e, 0x54, 0x62, 0x67, 0xa4, 0x97,
	0xc4, 0xce, 0x47, 0x90, 0x93, 0xeb, 0x02, 0xb5, 0xac, 0x6d, 0x6b, 0x1e, 0x8d, 0x46, 0x7d, 0x55,
	0xae, 0x13, 0x05, 0x09, 0x92, 0x57, 0x80, 0x1b, 0x4c, 0xcc, 0xe7, 0x0b, 0x1f, 0x8b, 0xc6, 0x9e,
	0x6b, 0xc7, 0xee, 0x2e, 0xfd, 0xd7, 0xbd, 0x13, 0x30, 0x49, 0x0e, 0xd1, 0x13, 0x2c, 0x38, 0x13,
	0xb0, 0x08, 0x7f, 0x0c, 0xf9, 0xd0, 0x19, 0xce, 0xb7, 0x91, 0x89, 0x9e, 0xe5, 0x06, 0x7b, 0x96,
	0x90, 0xa7, 0x20, 0xe3, 0xbd, 0x5c, 0x30, 0xdc, 0x01, 0xea, 0xda, 0x1c, 0xbd, 0x9f, 0xf0, 0x1c,
	0xef, 0x49, 0x0f, 0x55, 0xf9, 0x73, 0x48, 0xaa, 0xed, 0x93, 0x6d, 0x90, 0x54, 0xd1, 0xdf, 0x80,
	0x99, 0x36, 0x3e, 0x66, 0xa7, 0x6c, 0x7b, 0x3b, 0x6d, 0x04, 0xd8, 0x13, 0xf4, 0xf2, 0x33, 0x5d,
	0x79, 0xf9, 0x77, 0xc1, 0xab, 0xfc, 0x82, 0xcf, 0xe3, 0xcd, 0xd9, 0xa6, 0x7f, 0xde, 0xd3, 0xbf,
	0x1d, 0xdf, 0xf9, 0xa1, 0x4b, 0x72, 0x7e, 0xb3, 0xbd, 0x87, 0xea, 0xdf, 0x4f, 0x39, 0x8f, 0xc7,
	0xfc, 0x66, 0xfd, 0xe2, 0x07, 0x8f, 0x05, 0x18, 0x6b, 0x35, 0x1b, 0x9a, 0x58, 0x13, 0xe4, 0x1a,
	0x7d, 0xfa, 0x30, 0x4a, 0x1a, 0xca, 0xb5, 0xc8, 0xe8, 0x3c, 0xc4, 0xe6, 0xa6, 0xfa, 0x6d, 0x73,
	0xd3, 0x03, 0xb0, 0xb9, 0x23, 0x83, 0xb2, 0xb9, 0xa3, 0xbd, 0xd8, 0xdc, 0x28, 0x59, 0x85, 0x4b,
	0x92, 0xd5, 0x4c, 0xef, 0xb2, 0xfa, 0x8f, 0x29, 0x98, 0x77, 0x93, 0x2b, 0xbb, 0xb8, 0x26, 0x8b,
	0x8e, 0xb4, 0x5e, 0xf1, 0x4b, 0xab, 0x2b, 0xa8, 0x57, 0xfc, 0x82, 0x1a, 0xfb, 0x70, 0xbc, 0x08,
	0x19, 0x1d, 0x8b, 0x35, 0x41, 0xab, 0xd7, 0x0d, 0x6c, 0x3a, 0x72, 0x6a, 0x35, 0xed, 0xdb, 0x2d,
	0xe8, 0x3a, 0xd8, 0xbf, 0x84, 0x86, 0xac, 0xc8, 0xa6, 0x2d, 0x9e, 0x49, 0x7e, 0xcc, 0x6a, 0xd9,
	0xb1, 0x1a, 0xc2, 0xc4, 0x38, 0xdd, 0x6f, 0x31, 0x1e, 0x19, 0x80, 0x18, 0x8f, 0x0e, 0x4a, 0x8c,
	0xc7, 0x06, 0x29, 0xc6, 0x99, 0x4b, 0x12, 0xe3, 0xf1, 0xde, 0xc5, 0xf8, 0x5f, 0x52, 0xf6, 0x6b,
	0xd3, 0x7e, 0xd9, 0xdb, 0x28, 0x59, 0x7e, 0x19, 0xc6, 0xf6, 0x3b, 0x8c, 0xf5, 0x07, 0x50, 0xa3,
	0xbd, 0x04, 0x50, 0x5f, 0x22, 0xeb, 0xfc, 0xbf, 0xe4, 0x86, 0xc8, 0x67, 0x9d, 0x8d, 0xa6, 0xa6,
	0x1a, 0x18, 0xed, 0xc2, 0xb4, 0x74, 0x82, 0xa5, 0x53, 0xa3, 0xa5, 0x28, 0xb8, 0x26, 0xd8, 0xef,
	0x51, 0xc8, 0x19, 0x34, 0xcf, 0x7c, 0xe6, 0xe1, 0x82, 0x6e, 0x88, 0xa6, 0xc8, 0x4f, 0x49, 0xfe,
	0x06, 0x0b, 0x1d, 0xa5, 0x96, 0xd3, 0xe3, 0xbc, 0xf8, 0xc8, 0x87, 0x46, 0x7e, 0x0e, 0x52, 0x83,
	0x9f, 0xd2, 0xfc, 0x0d, 0x68, 0x03, 0x26, 0x24, 0x4d, 0x35, 0xb1, 0x6a, 0x0a, 0xba, 0xa8, 0x1e,
	0xe3, 0x0e, 0x77, 0x3c, 0x45, 0x02, 0xc7, 0x5b, 0x60, 0xfc, 0xb8, 0xe4, 0xf9, 0x95, 0xff, 0xfb,
	0x61, 0x98, 0xf6, 0x26, 0xc1, 0x2b, 0x4d, 0x2c, 0xa1, 0xb7, 0x61, 0xd4, 0xf9, 0x74, 0x8a, 0x6e,
	0xb8, 0x43, 0x6c, 0xea, 0x82, 0x32, 0x1e, 0x35, 0x5d, 0xfc, 0x0d, 0x72, 0xe0, 0x51, 0x53, 0x88,
	0x35, 0x48, 0xf6, 0xdb, 0x1a, 0x0c, 0x0f, 0xc0, 0x1a, 0xa4, 0x06, 0x65, 0x0d, 0xd2, 0xfd, 0xb3,
	0x06, 0x23, 0x3d, 0x58, 0x83, 0xfc, 0x9f, 0xa6, 0x9c, 0xd7, 0xef, 0x7e, 0xe7, 0x70, 0xdd, 0x1b,
	0x52, 0xdb, 0xfe, 0x61, 0x6b, 0xc8, 0x13, 0x54, 0x57, 0x00, 0xc9, 0xf6, 0x28, 0xc7, 0x88, 0x18,
	0x4d, 0x2c, 0x51, 0x8d, 0xb8, 0xc9, 0x58, 0x49, 0x50, 0x4c, 0xb7, 0x86, 0xf8, 0x69, 0x39, 0x28,
	0xba, 0xcb, 0x30, 0xfe, 0x54, 0x97, 0x4d, 0xec, 0xc4, 0x40, 0xb6, 0x63, 0x21, 0x9e, 0x27, 0x63,
	0x77, 0xd0, 0x48, 0x68, 0x9f, 0xa1, 0xdb, 0xc3, 0x71, 0x75, 0x7b, 0x8b, 0x6b, 0xd7, 0xee, 0x2d,
	0x18, 0xd3, 0x71, 0x1d, 0xeb, 0x58, 0x95, 0x30, 0x65, 0xf9, 0x1d, 0x06, 0x26, 0x66, 0x20, 0xb8,
	0xc5, 0xf1, 0xe7, 0x83, 0x99, 0x76, 0x22, 0x7d, 0x71, 0x3b, 0xf1, 0x2a, 0x8c, 0xd7, 0x65, 0x55,
	0x36, 0x4e, 0x04, 0x7b, 0xff, 0x36, 0xab, 0x47, 0xf9, 0x0c, 0x69, 0xfb, 0xd0, 0x6a, 0x8a, 0x34,
	0xe7, 0xa3, 0x97, 0x64, 0xce, 0x7b, 0x7f, 0xa8, 0xb7, 0x3e, 0x05, 0x13, 0x75, 0x59, 0x37, 0x4c,
	0x41, 0xc1, 0x86, 0x21, 0x1e, 0xe3, 0xf5, 0x34, 0x0c, 0x5b, 0xcc, 0xcd, 0xff, 0x45, 0x92, 0x3c,
	0x97, 0x77, 0x92, 0xdb, 0x71, 0x02, 0x98, 0x57, 0x60, 0xac, 0x86, 0xed, 0x58, 0x19, 0xeb, 0xce,
	0x4b, 0x79, 0xb7, 0x01, 0xfd, 0x12, 0xe4, 0x64, 0x55, 0x6a, 0xb4, 0x6a, 0x58, 0x30, 0x75, 0x51,
	0x6e, 0xc8, 0xea, 0xb1, 0x70, 0x0e, 0x9e, 0xb4, 0xc9, 0x9c, 0xa5, 0x10, 0x55, 0x0a, 0xb0, 0xe1,
	0x8e, 0x0e, 0xbc, 0xd3, 0x1f, 0x8e, 0x78, 0xa7, 0x9f, 0x0a, 0x7f, 0xa7, 0x9f, 0xf6, 0xbd, 0xd3,
	0xef, 0x9f, 0x5e, 0xa3, 0x1c, 0x8c, 0x3e, 0xc1, 0xba, 0x61, 0xe7, 0x83, 0xc7, 0xec, 0xed, 0xb8,
	0xbf, 0x07, 0xfa, 0x04, 0xf8, 0x3b, 0x09, 0xb8, 0xfa, 0xb0, 0x85, 0xf5, 0x33, 0x5b, 0x3a, 0x2b,
	0xa6, 0x68, 0xb6, 0x5c, 0x7e, 0x2d, 0xb5, 0xd9, 0x14, 0xc2, 0xb2, 0x73, 0xb3, 0x12, 0x25, 0xcc,
	0x89, 0x4b, 0x12, 0xe6, 0x3e, 0x3c, 0x47, 0xf8, 0x55, 0xc8, 0xb6, 0xd3, 0x81, 0x06, 0x27, 0xb7,
	0x60, 0xd2, 0x1a, 0x22, 0x9b, 0x26, 0xae, 0x09, 0x86, 0xfc, 0x09, 0xf1, 0xd4, 0x49, 0x7e, 0xc2,
	0x6d, 0xad, 0xc8, 0x9f, 0x60, 0x8b, 0x87, 0x92, 0xa6, 0x34, 0x1b, 0xd8, 0xc4, 0xf6, 0xce, 0x47,
	0x79, 0xf7, 0x77, 0xfe, 0xf9, 0x24, 0xcc, 0xf1, 0x98, 0x58, 0xc5, 0x9f, 0x4b, 0x72, 0xbc, 0x53,
	0x26, 0x2b, 0xd9, 0x29, 0x93, 0xd5, 0x39, 0xab, 0x3e, 0x7c, 0x79, 0x59, 0xf5, 0x97, 0x19, 0x9e,
	0x01, 0x65, 0xd5, 0xc7, 0x06, 0x9a, 0x55, 0x87, 0x41, 0x67, 0xd5, 0x33, 0x97, 0x92, 0x55, 0x1f,
	0xef, 0x3d, 0xab, 0xfe, 0x0d, 0x78, 0xc5, 0x72, 0x43, 0x47, 0x67, 0x26, 0x36, 0x04, 0xdd, 0x36,
	0x06, 0x26, 0x56, 0x85, 0x26, 0xd6, 0x05, 0x49, 0x6c, 0x34, 0xec, 0xcc, 0x78, 0x92, 0xcf, 0x2a,
	0xe2, 0xb3, 0x75, 0x0b, 0x84, 0x77, 0x20, 0x0e, 0xb0, 0x5e, 0x14, 0x1b, 0xc1, 0x67, 0xff, 0x93,
	0xbd, 0xb8, 0x9b, 0x9b, 0x30, 0x41, 0x16, 0xe0, 0xf8, 0xbc, 0x29, 0xdb, 0x04, 0x8c, 0xd3, 0x46,
	0xe2, 0xf6, 0xda, 0x52, 0xf7, 0xd3, 0xb1, 0x53, 0xf7, 0x33, 0x5d, 0xa5, 0xee, 0x51, 0x48, 0xea,
	0xfe, 0xbe, 0x9b, 0xd4, 0x98, 0x8b, 0x3a, 0x19, 0x39, 0xa9, 0x8e, 0x4d, 0x58, 0x92, 0xb4, 0xe6,
	0x99, 0xc3, 0x4e, 0xac, 0x4a, 0xfa, 0x59, 0xd3, 0x66, 0xa5, 0xd8, 0x38, 0xd6, 0x74, 0xd9, 0x3c,
	0x51, 0xb2, 0xf3, 0xf6, 0x5e, 0xaf, 0x5b, 0x70, 0x84, 0x5f, 0x25, 0x17, 0xaa, 0xe0, 0x00, 0xa1,
	0xf7, 0x21, 0x17, 0x82, 0xe8, 0x14, 0x9f, 0x65, 0xaf, 0xd8, 0x28, 0xae, 0xb2, 0x50, 0x6c, 0xe3,
	0x33, 0xb4, 0x05, 0xaf, 0x86, 0x0f, 0x16, 0x8c, 0x13, 0x71, 0xed, 0xed, 0x77, 0xb2, 0x57, 0xc3,
	0x97, 0xb1, 0x8d, 0xcf, 0x2a, 0x36, 0x50, 0xa4, 0x87, 0xcd, 0x5e, 0x92, 0x87, 0xbd, 0xd6, 0xbb,
	0x87, 0xfd, 0x57, 0x0e, 0xa6, 0xa8, 0x0b, 0x74, 0x3d, 0xeb, 0x1a, 0xcc, 0x9b, 0x9a, 0x29, 0x36,
	0x82, 0x4a, 0x41, 0x1d, 0xec, 0xac, 0xdd, 0xe9, 0xd7, 0x06, 0x2b, 0x9a, 0x73, 0x0e, 0x31, 0x96,
	0x2b, 0xa6, 0xf7, 0xec, 0xa4, 0xc9, 0xf6, 0xc3, 0x08, 0x86, 0x6b, 0x9a, 0x8a, 0x69, 0x58, 0x68,
	0xff, 0xdd, 0x2e, 0xf0, 0xc3, 0x0c, 0x81, 0xf7, 0x9e, 0xc5, 0x53, 0xb1, 0xcf, 0xe2, 0xf9, 0x1f,
	0x26, 0x20, 0x57, 0x31, 0x45, 0xdd, 0xb4, 0xc2, 0x49, 0x45, 0x3c, 0x6a, 0xe0, 0x0f, 0xc9, 0x26,
	0x89, 0x87, 0x7f, 0xc8, 0x3c, 0x7b, 0x71, 0xb1, 0xcf, 0x5e, 0x8c, 0x93, 0x57, 0x94, 0x54, 0x24,
	0x2f, 0x49, 0x2a, 0xfa, 0xf0, 0x38, 0xf5, 0x3d, 0x58, 0x60, 0xd2, 0x8e, 0x0a, 0xc8, 0x42, 0x5b,
	0x0c, 0x7a, 0x1e, 0x7e, 0xe6, 0xbf, 0x37, 0x42, 0xbf, 0xc8, 0x7c, 0x99, 0x28, 0x7d, 0x51, 0x13,
	0xa5, 0xed, 0x79, 0xac, 0xd1, 0x7e, 0xe5, 0xb1, 0xfc, 0xee, 0x72, 0xac, 0x5f, 0x5f, 0xc9, 0x45,
	0x3e, 0x13, 0x0b, 0xfd, 0xf0, 0x73, 0xbc, 0xab, 0x0f, 0x31, 0xa2, 0x74, 0x7c, 0xe2, 0x92, 0x74,
	0x7c, 0xb2, 0x77, 0x1d, 0xff, 0xcf, 0xb4, 0xf3, 0x9d, 0xe9, 0x4b, 0x45, 0x7d, 0xa9, 0xa8, 0x5f,
	0x40, 0x45, 0x8d, 0xd2, 0xb5, 0xf1, 0x4b, 0xd2, 0xb5, 0x89, 0xde, 0x75, 0xed, 0xdf, 0x93, 0x70,
	0xe5, 0x43, 0x8b, 0x63, 0x85, 0x46, 0x23, 0x90, 0x7f, 0x0b, 0xbb, 0x02, 0xf7, 0xe6, 0x9e, 0x12,
	0x81, 0xdc, 0x93, 0x2f, 0x2d, 0x97, 0x0c, 0xa6, 0xe5, 0x22, 0x13, 0x6b, 0xe7, 0x99, 0xb3, 0x94,
	0x2f, 0x73, 0xd6, 0x39, 0x9f, 0x97, 0x8e, 0xc8, 0xe7, 0xf9, 0xd3, 0x75, 0x23, 0xc1, 0x74, 0x5d,
	0x1f, 0x2f, 0xdf, 0x3c, 0x1f, 0x1d, 0x43, 0x1f, 0x3e, 0x3a, 0xee, 0xc3, 0x1d, 0xda, 0x9f, 0x70,
	0xb0, 0xb8, 0x89, 0x4d, 0xba, 0xde, 0x0a, 0xd6, 0x9f, 0xc8, 0x12, 0x2e, 0x48, 0x92, 0xd6, 0x52,
	0x5d, 0xbb, 0x9a, 0x77, 0x09, 0x10, 0xc8, 0xdc, 0x8d, 0xd1, 0xe6, 0x72, 0x6d, 0xa0, 0xb9, 0xb4,
	0x1f, 0x73, 0x30, 0x57, 0xd4, 0xb1, 0x68, 0xe2, 0x2d, 0x45, 0x94, 0xb6, 0xf1, 0x59, 0x37, 0x0b,
	0x7b, 0x17, 0xe6, 0x0d, 0xb2, 0x2b, 0x41, 0x24, 0xdb, 0x12, 0xb0, 0x22, 0xca, 0x0d, 0xaf, 0x1b,
	0x98, 0x35, 0x7c, 0xfb, 0x2e, 0x59, 0xfd, 0x03, 0xdd, 0x91, 0x06, 0xf3, 0x81, 0x0d, 0xd1, 0xf8,
	0xf4, 0x1b, 0x1e, 0x83, 0x13, 0x7e, 0x5f, 0x49, 0x47, 0xed, 0x52, 0x48, 0x8f, 0xe5, 0xb9, 0x02,
	0x69, 0x03, 0x4b, 0x3a, 0x76, 0x9f, 0x9f, 0x90, 0x5f, 0xf9, 0x1f, 0x70, 0x30, 0x47, 0x1e, 0x5d,
	0x05, 0x48, 0xb8, 0x04, 0x63, 0xf4, 0xab, 0x84, 0x40, 0x52, 0x96, 0xb4, 0x96, 0x6b, 0x01, 0x22,
	0x27, 0x2e, 0x9d, 0xfb, 0x9f, 0x71, 0x30, 0xb3, 0x89, 0xcd, 0x17, 0x6f, 0xdd, 0x09, 0x52, 0x75,
	0x88, 0x2e, 0xdc, 0xe8, 0x46, 0x68, 0xd7, 0x3a, 0x0a, 0x2d, 0x5b, 0x5e, 0x5f, 0x87, 0x19, 0xe3,
	0x44, 0x7b, 0x6a, 0xd9, 0x3d, 0x6c, 0xe2, 0x9a, 0x70, 0x8a, 0xcf, 0x0c, 0x7a, 0x66, 0x9d, 0xb2,
	0x3a, 0x08, 0xfb, 0x6b, 0xd6, 0x52, 0x7a, 0xbe, 0xc1, 0x18, 0xe4, 0x47, 0x4a, 0xcf, 0x60, 0xce,
	0x4f, 0x36, 0xaa, 0x1a, 0xcb, 0x30, 0xa5, 0xe2, 0x67, 0xd6, 0x4c, 0xee, 0xba, 0x88, 0xdf, 0x99,
	0xb0, 0x9a, 0x0f, 0xdc, 0xb5, 0x7d, 0x0d, 0x52, 0xb2, 0x89, 0xed, 0xdb, 0x82, 0x64, 0x4c, 0xfd,
	0x21, 0x03, 0xf2, 0xff, 0xc7, 0xc1, 0x1c, 0x89, 0x2b, 0x07, 0x22, 0x6c, 0x45, 0x8f, 0x6e, 0x27,
	0xe3, 0xea, 0x36, 0x9d, 0x28, 0xba, 0x52, 0x46, 0x1f, 0x3e, 0xa2, 0xfa, 0x3e, 0x07, 0xd7, 0x42,
	0x03, 0x10, 0x74, 0x1f, 0xe6, 0x98, 0xe9, 0x2f, 0xc2, 0x84, 0x59, 0xcc, 0x48, 0x7a, 0xdd, 0x82,
	0xc9, 0x40, 0xa2, 0x8b, 0xc8, 0xef, 0x04, 0xf6, 0xa5, 0xb7, 0xd6, 0x60, 0x9e, 0x9d, 0xd2, 0x4a,
	0x06, 0x51, 0xbb, 0x89, 0xac, 0xfc, 0xef, 0x73, 0x30, 0xcb, 0xd8, 0x18, 0x5a, 0x86, 0xf1, 0x96,
	0x81, 0x75, 0xc1, 0x29, 0x78, 0xe5, 0xe1, 0x56, 0xc6, 0xea, 0xa0, 0x8e, 0xce, 0x12, 0xf0, 0x8f,
	0x5b, 0x9a, 0x29, 0x0a, 0x56, 0xa3, 0x73, 0x41, 0x68, 0xb7, 0x1c, 0x1a, 0x58, 0x47, 0x6b, 0x90,
	0xb6, 0xab, 0xd9, 0x3a, 0x39, 0x89, 0x4e, 0xa7, 0x2c, 0x0a, 0x99, 0xff, 0x51, 0x0a, 0xa6, 0xa9,
	0x03, 0x2d, 0x6a, 0xaa, 0x61, 0x8a, 0xaa, 0x69, 0xe4, 0x3f, 0x4b, 0x41, 0xda, 0x8e, 0x85, 0xad,
	0xe0, 0x05, 0x7d, 0x50, 0xd8, 0x39, 0x2c, 0x55, 0x84, 0xc3, 0xbd, 0xca, 0x41, 0xa9, 0x58, 0x7e,
	0x50, 0x2e, 0x6d, 0x4c, 0x0f, 0xa1, 0x05, 0x98, 0xdb, 0x2d, 0x7c, 0x24, 0xf0, 0xa5, 0xc2, 0x86,
	0x50, 0xdc, 0x3a, 0xdc, 0xdb, 0x16, 0xd6, 0x1f, 0x55, 0x4b, 0x95, 0xe9, 0xe7, 0xcf, 0x9f, 0x73,
	0xe8, 0x15, 0x98, 0xb7, 0x3a, 0x3f, 0xe4, 0xcb, 0xd5, 0x52, 0x7b, 0xef, 0x35, 0x40, 0x56, 0xef,
	0xfe, 0xfa, 0xaf, 0x94, 0x8a, 0x55, 0xa1, 0x52, 0x7e, 0x5c, 0x12, 0x76, 0xd7, 0xa7, 0x9f, 0x3f,
	0xff, 0xbb, 0x04, 0xba, 0x0b, 0xaf, 0x59, 0x5d, 0xc5, 0xc3, 0x4a, 0x75, 0x7f, 0x57, 0xd8, 0x2d,
	0x55, 0x0b, 0x1b, 0x85, 0x6a, 0x41, 0x78, 0x50, 0x2e, 0xed, 0x6c, 0x08, 0x7b, 0x85, 0xdd, 0x92,
	0x83, 0x67, 0x14, 0xbd, 0x0e, 0xb7, 0xc2, 0x41, 0xed, 0x25, 0x3b, 0xb0, 0x4b, 0x61, 0x68, 0xab,
	0xfb, 0xd5, 0xc2, 0x0e, 0x59, 0x00, 0x05, 0xfd, 0x26, 0x7a, 0x9d, 0x80, 0xae, 0x1f, 0x16, 0xb7,
	0x4b, 0xd5, 0x4e, 0xa0, 0x7f, 0xcc, 0xa1, 0xdb, 0x70, 0xd3, 0x82, 0xdd, 0xdb, 0xaf, 0x96, 0x1f,
	0x94, 0x8b, 0x85, 0x6a, 0x79, 0x7f, 0x4f, 0x28, 0xee, 0xef, 0x3d, 0x28, 0x6f, 0x56, 0x84, 0x83,
	0x12, 0x4f, 0x91, 0x4c, 0x5b, 0x8a, 0x76, 0xc3, 0x02, 0xdc, 0x29, 0x3f, 0x28, 0x15, 0x1f, 0x15,
	0x77, 0x4a, 0x02, 0x7f, 0xb8, 0x53, 0x0a, 0xc0, 0x2c, 0x43, 0xbe, 0x1d, 0x19, 0x59, 0x70, 0xa1,
	0x5a, 0xe5, 0xcb, 0xeb, 0x87, 0xd6, 0xb4, 0x29, 0x74, 0x1f, 0xee, 0x45, 0xc2, 0x09, 0xdb, 0xa5,
	0x47, 0xc2, 0x4e, 0x69, 0x6f, 0xb3, 0xba, 0x35, 0xfd, 0x3c, 0x81, 0xde, 0x82, 0x95, 0xe8, 0x21,
	0x84, 0x64, 0xce, 0xa0, 0x51, 0xf4, 0x0a, 0x64, 0xed, 0x35, 0x17, 0xd6, 0x4b, 0x3b, 0x15, 0xa1,
	0xb4, 0x57, 0xe5, 0xcb, 0xa5, 0x8a, 0x50, 0xdc, 0x3f, 0xdc, 0xab, 0x4e, 0x7f, 0x13, 0x2d, 0xc2,
	0x82, 0xa7, 0xd7, 0x9a, 0xce, 0x37, 0xfe, 0x97, 0xd1, 0x22, 0xe4, 0x98, 0x00, 0x94, 0x7a, 0x1c,
	0x5a, 0x81, 0xbb, 0x1e, 0x29, 0x28, 0x6f, 0x10, 0x72, 0x6c, 0x94, 0x76, 0x4a, 0xd5, 0x12, 0x6d,
	0xad, 0x08, 0x7c, 0xe9, 0xe1, 0x61, 0xa9, 0x52, 0x9d, 0xfe, 0x8f, 0x11, 0x74, 0x03, 0x72, 0x95,
	0x83, 0x9d, 0x72, 0x55, 0xa8, 0xee, 0x6f, 0x97, 0xf6, 0x04, 0x6b, 0xec, 0x07, 0x85, 0x9d, 0xf2,
	0x86, 0xb0, 0x51, 0x78, 0x54, 0x99, 0x9e, 0xcc, 0x25, 0xa6, 0xb9, 0xb5, 0xdf, 0x5a, 0x85, 0x91,
	0x0a, 0xb1, 0x21, 0xe8, 0xdb, 0x4e, 0x21, 0x01, 0x46, 0xf1, 0x51, 0xf4, 0x16, 0xc3, 0xe2, 0x44,
	0xd5, 0x63, 0xce, 0x5d, 0x69, 0x53, 0xa7, 0x92, 0xd2, 0x34, 0xcf, 0xf2, 0x43, 0xc8, 0xb4, 0x9f,
	0x74, 0xb1, 0x26, 0xfa, 0x0a, 0xfb, 0x49, 0x46, 0x87, 0x59, 0x62, 0xd6, 0x4f, 0xcd, 0x0f, 0xa1,
	0x4f, 0x9c, 0xaf, 0xf5, 0xe3, 0xee, 0x30, 0xaa, 0xfc, 0x71, 0x17, 0x73, 0xff, 0x36, 0xfd, 0x9c,
	0x9e, 0x55, 0x53, 0x18, 0xb1, 0x8e, 0xc3, 0x11, 0x05, 0x88, 0x73, 0x6f, 0x75, 0x35, 0x86, 0x78,
	0x57, 0x42, 0x83, 0xd0, 0x52, 0xb7, 0x4c, 0x1a, 0x44, 0x15, 0xc6, 0xed, 0x82, 0x06, 0xcf, 0x20,
	0x1b, 0x56, 0xb9, 0x98, 0x49, 0x82, 0x88, 0x32, 0xc7, 0x5d, 0xcc, 0x7c, 0x00, 0xe3, 0x5e, 0x69,
	0x45, 0xcb, 0x11, 0xe2, 0x1c, 0x2d, 0xc1, 0xbb, 0x30, 0xe6, 0x8a, 0x25, 0xba, 0xd9, 0x49, 0x68,
	0x1d, 0x5c, 0xe1, 0x25, 0xb2, 0xf2, 0x43, 0xa8, 0x02, 0xe3, 0x5e, 0x61, 0x63, 0x2e, 0x90, 0x51,
	0xbf, 0xb4, 0x33, 0x52, 0x11, 0xc6, 0xbd, 0x05, 0x31, 0x99, 0x48, 0x19, 0x15, 0x33, 0x73, 0xb7,
	0x23, 0xe1, 0x5c, 0x71, 0xfa, 0x35, 0xc8, 0x78, 0x4a, 0x5c, 0xa2, 0x5b, 0x1d, 0x85, 0xd2, 0xe8,
	0xc4, 0x38, 0x1f, 0x98, 0x8b, 0xff, 0x18, 0xae, 0xed, 0x68, 0xd2, 0xa9, 0xb3, 0x69, 0x5f, 0x4d,
	0x48, 0xf4, 0x26, 0x0b, 0x4d, 0x68, 0xed, 0xc8, 0xce, 0xb4, 0x7a, 0x08, 0xc8, 0xe5, 0x58, 0x59,
	0x54, 0xe8, 0x0c, 0x6e, 0xe8, 0x26, 0x8b, 0x0a, 0x65, 0xaa, 0xdb, 0xe9, 0xa0, 0x9d, 0x0f, 0xc0,
	0x90, 0x5e, 0x82, 0xb2, 0x12, 0x8d, 0xb2, 0xd2, 0x0d, 0xca, 0x8f, 0x21, 0x5b, 0xc5, 0x86, 0x07,
	0x27, 0xd6, 0x15, 0xd9, 0x20, 0x49, 0x97, 0x3b, 0x81, 0x41, 0x16, 0xa0, 0x1f, 0xc4, 0x41, 0x7f,
	0x37, 0x06, 0xa4, 0xcb, 0x81, 0x87, 0x90, 0xf1, 0xe8, 0x21, 0x93, 0xc3, 0xed, 0xf5, 0x2d, 0x23,
	0x85, 0xdd, 0x6b, 0x55, 0x98, 0x72, 0xc9, 0xa8, 0x30, 0xd8, 0x19, 0xe9, 0x1e, 0x64, 0x3c, 0xf5,
	0xdf, 0x98, 0xeb, 0x6c, 0xaf, 0x0f, 0xd7, 0x41, 0xc1, 0x9f, 0x39, 0x85, 0x46, 0xc2, 0xab, 0x0e,
	0xa1, 0xf7, 0x42, 0xcd, 0x48, 0x64, 0xa9, 0xa2, 0x0e, 0x33, 0xff, 0x26, 0xa9, 0xf5, 0xd1, 0x61,
	0xde, 0x77, 0xd9, 0xf6, 0x26, 0x7a, 0xd2, 0x98, 0x55, 0x08, 0xf2, 0x43, 0xe8, 0x77, 0xdd, 0xea,
	0xff, 0x5d, 0xee, 0x3f, 0x66, 0x69, 0xb5, 0x2e, 0x96, 0xf2, 0x29, 0xad, 0x67, 0xd1, 0xa1, 0x5e,
	0x19, 0xfa, 0x7a, 0x88, 0x45, 0x89, 0xae, 0x71, 0x16, 0xea, 0x48, 0xd9, 0x63, 0x5c, 0xbd, 0xf8,
	0x0e, 0x47, 0xeb, 0xf0, 0x77, 0xa0, 0xcf, 0xd7, 0xc3, 0x94, 0xa5, 0xdf, 0x9c, 0x8a, 0xaa, 0x8f,
	0xc5, 0xe4, 0x54, 0xcc, 0xa2, 0x5a, 0x5d, 0x2c, 0xe5, 0x5b, 0x80, 0xda, 0x6b, 0x51, 0xa1, 0x7b,
	0xa1, 0x5a, 0xc2, 0xa8, 0x9a, 0xd4, 0x41, 0x2f, 0x04, 0x98, 0x0a, 0x54, 0x8a, 0x42, 0x77, 0xd9,
	0x8a, 0xc0, 0xc2, 0x1b, 0x55, 0x5a, 0x29, 0x3f, 0x84, 0x30, 0xa0, 0xf6, 0x6a, 0x4e, 0xcc, 0xe5,
	0x87, 0x16, 0x7d, 0x8a, 0x33, 0x4d, 0x13, 0x66, 0xda, 0x0a, 0x2b, 0xa1, 0x37, 0x42, 0xa4, 0x90,
	0x55, 0x7e, 0x29, 0x77, 0x2f, 0x1e, 0xb0, 0x2b, 0xab, 0x6e, 0x68, 0xcf, 0x12, 0x8d, 0xf0, 0xd0,
	0xfe, 0x42, 0xd6, 0xcb, 0xf4, 0x7c, 0xad, 0x11, 0x2b, 0xb4, 0xef, 0x8b, 0xe4, 0xb9, 0xa1, 0x7d,
	0xdc, 0x1d, 0x46, 0xd5, 0x15, 0xea, 0x62, 0x6e, 0x27, 0xb4, 0x67, 0x1a, 0xa6, 0xb5, 0xae, 0xac,
	0x4b, 0x4f, 0x16, 0xc9, 0x0d, 0xed, 0xe3, 0xd2, 0x20, 0xaa, 0x94, 0x4e, 0x17, 0x34, 0x38, 0x84,
	0x09, 0x5f, 0xd9, 0x09, 0x74, 0x3b, 0x66, 0x61, 0x8a, 0x5c, 0xf8, 0x55, 0x5b, 0x7e, 0x08, 0xed,
	0x03, 0x9c, 0x57, 0x86, 0x40, 0xaf, 0x31, 0x71, 0x06, 0x0a, 0x47, 0x74, 0x46, 0xe8, 0x1e, 0x04,
	0x28, 0xca, 0xe5, 0x08, 0xe1, 0x8f, 0x7b, 0x10, 0xa0, 0xe8, 0x6e, 0x76, 0x12, 0xf1, 0x58, 0x0b,
	0x94, 0x61, 0xd2, 0xff, 0x05, 0x02, 0x8a, 0xfd, 0x91, 0x42, 0xee, 0x6e, 0x0c, 0x48, 0x47, 0x5a,
	0xbe, 0xc2, 0xa1, 0x43, 0xe7, 0xcc, 0xd1, 0x81, 0x16, 0x8c, 0xaf, 0x46, 0x3a, 0xae, 0xff, 0x0e,
	0xe7, 0x1c, 0x09, 0x9c, 0x9a, 0x27, 0xb7, 0x3a, 0x0a, 0x73, 0xe4, 0x91, 0xc0, 0x05, 0xf3, 0x1c,
	0x39, 0x26, 0x7c, 0x6f, 0xa2, 0x99, 0xa2, 0xc6, 0x7a, 0x35, 0x9d, 0xcb, 0x87, 0x03, 0x7a, 0xf0,
	0x3f, 0x81, 0x59, 0xc6, 0xdb, 0x22, 0xe6, 0x61, 0x23, 0xfc, 0xfd, 0x56, 0x6e, 0x25, 0x2e, 0xb8,
	0x3b, 0xaf, 0x02, 0xd3, 0xc1, 0xb7, 0xe4, 0xe8, 0x75, 0x06, 0x96, 0x90, 0x87, 0xf7, 0xb9, 0x37,
	0x62, 0xc1, 0xb6, 0xc5, 0xf5, 0x94, 0x88, 0xa1, 0x71, 0x7d, 0x17, 0xb2, 0xeb, 0xc6, 0xf5, 0x1d,
	0x04, 0x8a, 0xf1, 0xa2, 0xa3, 0x33, 0x52, 0x72, 0x30, 0x23, 0x3f, 0xfb, 0x7a, 0x30, 0x8b, 0x42,
	0x79, 0x91, 0x83, 0xd9, 0x39, 0xce, 0xc1, 0x1f, 0xcc, 0x1e, 0xc3, 0x54, 0xe0, 0xca, 0x9e, 0x19,
	0x0e, 0xb1, 0xaf, 0xf5, 0x73, 0x1d, 0xae, 0xa4, 0xf3, 0x43, 0xa8, 0x61, 0x5f, 0xc6, 0xf9, 0xef,
	0x89, 0x99, 0xae, 0x2c, 0xe2, 0x52, 0x39, 0xf7, 0x2a, 0x4b, 0x0d, 0x7c, 0x90, 0xf9, 0x21, 0x54,
	0x83, 0x09, 0xdf, 0x3d, 0x29, 0xdb, 0x79, 0x30, 0xae, 0x86, 0x73, 0x77, 0xa2, 0x01, 0x5d, 0x7a,
	0xf1, 0x30, 0xe1, 0xbb, 0x1b, 0x65, 0xce, 0xc2, 0xba, 0x3d, 0xed, 0x60, 0xfc, 0x3f, 0x02, 0x38,
	0xbf, 0xb4, 0x64, 0xfa, 0xa7, 0xb6, 0x3b, 0xcd, 0x5c, 0x8c, 0xeb, 0xa0, 0xf3, 0xdc, 0x8d, 0x73,
	0x3f, 0x16, 0x9a, 0xbb, 0x09, 0xdc, 0x3b, 0x86, 0xe6, 0x6e, 0x82, 0x17, 0x6d, 0xc4, 0x90, 0xfa,
	0xee, 0xc1, 0x98, 0x04, 0x61, 0xdd, 0x94, 0xc5, 0xdb, 0x42, 0xee, 0xcf, 0x13, 0x3f, 0x2a, 0x5c,
	0x71, 0x20, 0xc8, 0x00, 0xb1, 0x29, 0x1b, 0x2b, 0x92, 0xa6, 0x7c, 0x5e, 0xf8, 0xbd, 0xc4, 0x89,
	0x69, 0x36, 0x8d, 0xf7, 0x56, 0x57, 0x9f, 0x3e, 0x7d, 0x1a, 0xe8, 0x5d, 0x15, 0x5b, 0xe6, 0xc9,
	0xaa, 0xd4, 0xd0, 0x5a, 0xb5, 0x37, 0x9b, 0x0d, 0xd1, 0xac, 0x6b, 0xba, 0x72, 0xaf, 0x3b, 0xf0,
	0x15, 0x1d, 0x8b, 0xb5, 0x37, 0x35, 0xb5, 0x71, 0x16, 0x39, 0xb0, 0x86, 0x9f, 0x38, 0x8b, 0xac,
	0xb7, 0x1a, 0x0d, 0xa7, 0x6e, 0x5f, 0x37, 0xe3, 0x48, 0x4d, 0x87, 0x2e, 0x27, 0xb3, 0x07, 0xd9,
	0xce, 0x67, 0xbd, 0x62, 0x5f, 0xf7, 0xb5, 0x13, 0xf5, 0x80, 0x7b, 0xfc, 0x35, 0xda, 0x78, 0xac,
	0x35, 0x44, 0xf5, 0x78, 0x45, 0xd3, 0x8f, 0x57, 0x8f, 0xb1, 0x6a, 0x0b, 0xe2, 0xea, 0xf9, 0x04,
	0x9e, 0xff, 0xad, 0xf8, 0x3e, 0xfd, 0xf3, 0x28, 0x6d, 0x03, 0xbd, 0xf5, 0xb3, 0x00, 0x00, 0x00,
	0xff, 0xff, 0x8c, 0xd4, 0x3b, 0xb3, 0x6f, 0x72, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// StorageClient is the client API for Storage service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type StorageClient interface {
	// Permanently deletes the ACL entry for the specified entity on the specified
	// bucket.
	DeleteBucketAccessControl(ctx context.Context, in *DeleteBucketAccessControlRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Returns the ACL entry for the specified entity on the specified bucket.
	GetBucketAccessControl(ctx context.Context, in *GetBucketAccessControlRequest, opts ...grpc.CallOption) (*BucketAccessControl, error)
	// Creates a new ACL entry on the specified bucket.
	InsertBucketAccessControl(ctx context.Context, in *InsertBucketAccessControlRequest, opts ...grpc.CallOption) (*BucketAccessControl, error)
	// Retrieves ACL entries on the specified bucket.
	ListBucketAccessControls(ctx context.Context, in *ListBucketAccessControlsRequest, opts ...grpc.CallOption) (*ListBucketAccessControlsResponse, error)
	// Updates an ACL entry on the specified bucket. Equivalent to
	// PatchBucketAccessControl, but all unspecified fields will be
	// reset to their default values.
	UpdateBucketAccessControl(ctx context.Context, in *UpdateBucketAccessControlRequest, opts ...grpc.CallOption) (*BucketAccessControl, error)
	// Updates an ACL entry on the specified bucket.
	PatchBucketAccessControl(ctx context.Context, in *PatchBucketAccessControlRequest, opts ...grpc.CallOption) (*BucketAccessControl, error)
	// Permanently deletes an empty bucket.
	DeleteBucket(ctx context.Context, in *DeleteBucketRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Returns metadata for the specified bucket.
	GetBucket(ctx context.Context, in *GetBucketRequest, opts ...grpc.CallOption) (*Bucket, error)
	// Creates a new bucket.
	InsertBucket(ctx context.Context, in *InsertBucketRequest, opts ...grpc.CallOption) (*Bucket, error)
	// List active object change notification channels for this bucket.
	ListChannels(ctx context.Context, in *ListChannelsRequest, opts ...grpc.CallOption) (*ListChannelsResponse, error)
	// Retrieves a list of buckets for a given project.
	ListBuckets(ctx context.Context, in *ListBucketsRequest, opts ...grpc.CallOption) (*ListBucketsResponse, error)
	// Locks retention policy on a bucket.
	LockBucketRetentionPolicy(ctx context.Context, in *LockRetentionPolicyRequest, opts ...grpc.CallOption) (*Bucket, error)
	// Gets the IAM policy for the specified bucket.
	GetBucketIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Updates an IAM policy for the specified bucket.
	SetBucketIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Tests a set of permissions on the given bucket to see which, if
	// any, are held by the caller.
	TestBucketIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error)
	// Updates a bucket. Changes to the bucket will be readable immediately after
	// writing, but configuration changes may take time to propagate.
	PatchBucket(ctx context.Context, in *PatchBucketRequest, opts ...grpc.CallOption) (*Bucket, error)
	// Updates a bucket. Equivalent to PatchBucket, but always replaces all
	// mutatable fields of the bucket with new values, reverting all
	// unspecified fields to their default values.
	// Like PatchBucket, Changes to the bucket will be readable immediately after
	// writing, but configuration changes may take time to propagate.
	UpdateBucket(ctx context.Context, in *UpdateBucketRequest, opts ...grpc.CallOption) (*Bucket, error)
	// Halts "Object Change Notification" push messagages.
	// See https://cloud.google.com/storage/docs/object-change-notification
	// Note: this is not related to the newer "Notifications" resource, which
	// are stopped using DeleteNotification.
	StopChannel(ctx context.Context, in *StopChannelRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Permanently deletes the default object ACL entry for the specified entity
	// on the specified bucket.
	DeleteDefaultObjectAccessControl(ctx context.Context, in *DeleteDefaultObjectAccessControlRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Returns the default object ACL entry for the specified entity on the
	// specified bucket.
	GetDefaultObjectAccessControl(ctx context.Context, in *GetDefaultObjectAccessControlRequest, opts ...grpc.CallOption) (*ObjectAccessControl, error)
	// Creates a new default object ACL entry on the specified bucket.
	InsertDefaultObjectAccessControl(ctx context.Context, in *InsertDefaultObjectAccessControlRequest, opts ...grpc.CallOption) (*ObjectAccessControl, error)
	// Retrieves default object ACL entries on the specified bucket.
	ListDefaultObjectAccessControls(ctx context.Context, in *ListDefaultObjectAccessControlsRequest, opts ...grpc.CallOption) (*ListObjectAccessControlsResponse, error)
	// Updates a default object ACL entry on the specified bucket.
	PatchDefaultObjectAccessControl(ctx context.Context, in *PatchDefaultObjectAccessControlRequest, opts ...grpc.CallOption) (*ObjectAccessControl, error)
	// Updates a default object ACL entry on the specified bucket. Equivalent to
	// PatchDefaultObjectAccessControl, but modifies all unspecified fields to
	// their default values.
	UpdateDefaultObjectAccessControl(ctx context.Context, in *UpdateDefaultObjectAccessControlRequest, opts ...grpc.CallOption) (*ObjectAccessControl, error)
	// Permanently deletes a notification subscription.
	// Note: Older, "Object Change Notification" push subscriptions should be
	// deleted using StopChannel instead.
	DeleteNotification(ctx context.Context, in *DeleteNotificationRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// View a notification configuration.
	GetNotification(ctx context.Context, in *GetNotificationRequest, opts ...grpc.CallOption) (*Notification, error)
	// Creates a notification subscription for a given bucket.
	// These notifications, when triggered, publish messages to the specified
	// Cloud Pub/Sub topics.
	// See https://cloud.google.com/storage/docs/pubsub-notifications.
	InsertNotification(ctx context.Context, in *InsertNotificationRequest, opts ...grpc.CallOption) (*Notification, error)
	// Retrieves a list of notification subscriptions for a given bucket.
	ListNotifications(ctx context.Context, in *ListNotificationsRequest, opts ...grpc.CallOption) (*ListNotificationsResponse, error)
	// Permanently deletes the ACL entry for the specified entity on the specified
	// object.
	DeleteObjectAccessControl(ctx context.Context, in *DeleteObjectAccessControlRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Returns the ACL entry for the specified entity on the specified object.
	GetObjectAccessControl(ctx context.Context, in *GetObjectAccessControlRequest, opts ...grpc.CallOption) (*ObjectAccessControl, error)
	// Creates a new ACL entry on the specified object.
	InsertObjectAccessControl(ctx context.Context, in *InsertObjectAccessControlRequest, opts ...grpc.CallOption) (*ObjectAccessControl, error)
	// Retrieves ACL entries on the specified object.
	ListObjectAccessControls(ctx context.Context, in *ListObjectAccessControlsRequest, opts ...grpc.CallOption) (*ListObjectAccessControlsResponse, error)
	// Updates an ACL entry on the specified object.
	UpdateObjectAccessControl(ctx context.Context, in *UpdateObjectAccessControlRequest, opts ...grpc.CallOption) (*ObjectAccessControl, error)
	// Concatenates a list of existing objects into a new object in the same
	// bucket.
	ComposeObject(ctx context.Context, in *ComposeObjectRequest, opts ...grpc.CallOption) (*Object, error)
	// Copies a source object to a destination object. Optionally overrides
	// metadata.
	CopyObject(ctx context.Context, in *CopyObjectRequest, opts ...grpc.CallOption) (*Object, error)
	// Deletes an object and its metadata. Deletions are permanent if versioning
	// is not enabled for the bucket, or if the `generation` parameter
	// is used.
	DeleteObject(ctx context.Context, in *DeleteObjectRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Retrieves an object's metadata.
	GetObject(ctx context.Context, in *GetObjectRequest, opts ...grpc.CallOption) (*Object, error)
	// Reads an object's data.
	GetObjectMedia(ctx context.Context, in *GetObjectMediaRequest, opts ...grpc.CallOption) (Storage_GetObjectMediaClient, error)
	// Stores a new object and metadata.
	//
	// An object can be written either in a single message stream or in a
	// resumable sequence of message streams. To write using a single stream,
	// the client should include in the first message of the stream an
	// `InsertObjectSpec` describing the destination bucket, object, and any
	// preconditions. Additionally, the final message must set 'finish_write' to
	// true, or else it is an error.
	//
	// For a resumable write, the client should instead call
	// `StartResumableWrite()` and provide that method an `InsertObjectSpec.`
	// They should then attach the returned `upload_id` to the first message of
	// each following call to `Insert`. If there is an error or the connection is
	// broken during the resumable `Insert()`, the client should check the status
	// of the `Insert()` by calling `QueryWriteStatus()` and continue writing from
	// the returned `committed_size`. This may be less than the amount of data the
	// client previously sent.
	//
	// The service will not view the object as complete until the client has
	// sent an `Insert` with `finish_write` set to `true`. Sending any
	// requests on a stream after sending a request with `finish_write` set to
	// `true` will cause an error. The client **should** check the
	// `Object` it receives to determine how much data the service was
	// able to commit and whether the service views the object as complete.
	InsertObject(ctx context.Context, opts ...grpc.CallOption) (Storage_InsertObjectClient, error)
	// Retrieves a list of objects matching the criteria.
	ListObjects(ctx context.Context, in *ListObjectsRequest, opts ...grpc.CallOption) (*ListObjectsResponse, error)
	// Rewrites a source object to a destination object. Optionally overrides
	// metadata.
	RewriteObject(ctx context.Context, in *RewriteObjectRequest, opts ...grpc.CallOption) (*RewriteResponse, error)
	// Starts a resumable write. How long the write operation remains valid, and
	// what happens when the write operation becomes invalid, are
	// service-dependent.
	StartResumableWrite(ctx context.Context, in *StartResumableWriteRequest, opts ...grpc.CallOption) (*StartResumableWriteResponse, error)
	// Determines the `committed_size` for an object that is being written, which
	// can then be used as the `write_offset` for the next `Write()` call.
	//
	// If the object does not exist (i.e., the object has been deleted, or the
	// first `Write()` has not yet reached the service), this method returns the
	// error `NOT_FOUND`.
	//
	// The client **may** call `QueryWriteStatus()` at any time to determine how
	// much data has been processed for this object. This is useful if the
	// client is buffering data and needs to know which data can be safely
	// evicted. For any sequence of `QueryWriteStatus()` calls for a given
	// object name, the sequence of returned `committed_size` values will be
	// non-decreasing.
	QueryWriteStatus(ctx context.Context, in *QueryWriteStatusRequest, opts ...grpc.CallOption) (*QueryWriteStatusResponse, error)
	// Updates an object's metadata.
	PatchObject(ctx context.Context, in *PatchObjectRequest, opts ...grpc.CallOption) (*Object, error)
	// Updates an object's metadata. Equivalent to PatchObject, but always
	// replaces all mutatable fields of the bucket with new values, reverting all
	// unspecified fields to their default values.
	UpdateObject(ctx context.Context, in *UpdateObjectRequest, opts ...grpc.CallOption) (*Object, error)
	// Gets the IAM policy for the specified object.
	GetObjectIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Updates an IAM policy for the specified object.
	SetObjectIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Tests a set of permissions on the given object to see which, if
	// any, are held by the caller.
	TestObjectIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error)
	// Watch for changes on all objects in a bucket.
	WatchAllObjects(ctx context.Context, in *WatchAllObjectsRequest, opts ...grpc.CallOption) (*Channel, error)
	// Retrieves the name of a project's Google Cloud Storage service account.
	GetServiceAccount(ctx context.Context, in *GetProjectServiceAccountRequest, opts ...grpc.CallOption) (*ServiceAccount, error)
	// Creates a new HMAC key for the given service account.
	CreateHmacKey(ctx context.Context, in *CreateHmacKeyRequest, opts ...grpc.CallOption) (*CreateHmacKeyResponse, error)
	// Deletes a given HMAC key.  Key must be in an INACTIVE state.
	DeleteHmacKey(ctx context.Context, in *DeleteHmacKeyRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Gets an existing HMAC key metadata for the given id.
	GetHmacKey(ctx context.Context, in *GetHmacKeyRequest, opts ...grpc.CallOption) (*HmacKeyMetadata, error)
	// Lists HMAC keys under a given project with the additional filters provided.
	ListHmacKeys(ctx context.Context, in *ListHmacKeysRequest, opts ...grpc.CallOption) (*ListHmacKeysResponse, error)
	// Updates a given HMAC key state between ACTIVE and INACTIVE.
	UpdateHmacKey(ctx context.Context, in *UpdateHmacKeyRequest, opts ...grpc.CallOption) (*HmacKeyMetadata, error)
}

type storageClient struct {
	cc grpc.ClientConnInterface
}

func NewStorageClient(cc grpc.ClientConnInterface) StorageClient {
	return &storageClient{cc}
}

func (c *storageClient) DeleteBucketAccessControl(ctx context.Context, in *DeleteBucketAccessControlRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/DeleteBucketAccessControl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) GetBucketAccessControl(ctx context.Context, in *GetBucketAccessControlRequest, opts ...grpc.CallOption) (*BucketAccessControl, error) {
	out := new(BucketAccessControl)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/GetBucketAccessControl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) InsertBucketAccessControl(ctx context.Context, in *InsertBucketAccessControlRequest, opts ...grpc.CallOption) (*BucketAccessControl, error) {
	out := new(BucketAccessControl)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/InsertBucketAccessControl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) ListBucketAccessControls(ctx context.Context, in *ListBucketAccessControlsRequest, opts ...grpc.CallOption) (*ListBucketAccessControlsResponse, error) {
	out := new(ListBucketAccessControlsResponse)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/ListBucketAccessControls", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) UpdateBucketAccessControl(ctx context.Context, in *UpdateBucketAccessControlRequest, opts ...grpc.CallOption) (*BucketAccessControl, error) {
	out := new(BucketAccessControl)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/UpdateBucketAccessControl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) PatchBucketAccessControl(ctx context.Context, in *PatchBucketAccessControlRequest, opts ...grpc.CallOption) (*BucketAccessControl, error) {
	out := new(BucketAccessControl)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/PatchBucketAccessControl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) DeleteBucket(ctx context.Context, in *DeleteBucketRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/DeleteBucket", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) GetBucket(ctx context.Context, in *GetBucketRequest, opts ...grpc.CallOption) (*Bucket, error) {
	out := new(Bucket)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/GetBucket", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) InsertBucket(ctx context.Context, in *InsertBucketRequest, opts ...grpc.CallOption) (*Bucket, error) {
	out := new(Bucket)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/InsertBucket", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) ListChannels(ctx context.Context, in *ListChannelsRequest, opts ...grpc.CallOption) (*ListChannelsResponse, error) {
	out := new(ListChannelsResponse)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/ListChannels", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) ListBuckets(ctx context.Context, in *ListBucketsRequest, opts ...grpc.CallOption) (*ListBucketsResponse, error) {
	out := new(ListBucketsResponse)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/ListBuckets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) LockBucketRetentionPolicy(ctx context.Context, in *LockRetentionPolicyRequest, opts ...grpc.CallOption) (*Bucket, error) {
	out := new(Bucket)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/LockBucketRetentionPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) GetBucketIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/GetBucketIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) SetBucketIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/SetBucketIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) TestBucketIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error) {
	out := new(v1.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/TestBucketIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) PatchBucket(ctx context.Context, in *PatchBucketRequest, opts ...grpc.CallOption) (*Bucket, error) {
	out := new(Bucket)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/PatchBucket", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) UpdateBucket(ctx context.Context, in *UpdateBucketRequest, opts ...grpc.CallOption) (*Bucket, error) {
	out := new(Bucket)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/UpdateBucket", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) StopChannel(ctx context.Context, in *StopChannelRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/StopChannel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) DeleteDefaultObjectAccessControl(ctx context.Context, in *DeleteDefaultObjectAccessControlRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/DeleteDefaultObjectAccessControl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) GetDefaultObjectAccessControl(ctx context.Context, in *GetDefaultObjectAccessControlRequest, opts ...grpc.CallOption) (*ObjectAccessControl, error) {
	out := new(ObjectAccessControl)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/GetDefaultObjectAccessControl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) InsertDefaultObjectAccessControl(ctx context.Context, in *InsertDefaultObjectAccessControlRequest, opts ...grpc.CallOption) (*ObjectAccessControl, error) {
	out := new(ObjectAccessControl)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/InsertDefaultObjectAccessControl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) ListDefaultObjectAccessControls(ctx context.Context, in *ListDefaultObjectAccessControlsRequest, opts ...grpc.CallOption) (*ListObjectAccessControlsResponse, error) {
	out := new(ListObjectAccessControlsResponse)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/ListDefaultObjectAccessControls", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) PatchDefaultObjectAccessControl(ctx context.Context, in *PatchDefaultObjectAccessControlRequest, opts ...grpc.CallOption) (*ObjectAccessControl, error) {
	out := new(ObjectAccessControl)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/PatchDefaultObjectAccessControl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) UpdateDefaultObjectAccessControl(ctx context.Context, in *UpdateDefaultObjectAccessControlRequest, opts ...grpc.CallOption) (*ObjectAccessControl, error) {
	out := new(ObjectAccessControl)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/UpdateDefaultObjectAccessControl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) DeleteNotification(ctx context.Context, in *DeleteNotificationRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/DeleteNotification", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) GetNotification(ctx context.Context, in *GetNotificationRequest, opts ...grpc.CallOption) (*Notification, error) {
	out := new(Notification)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/GetNotification", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) InsertNotification(ctx context.Context, in *InsertNotificationRequest, opts ...grpc.CallOption) (*Notification, error) {
	out := new(Notification)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/InsertNotification", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) ListNotifications(ctx context.Context, in *ListNotificationsRequest, opts ...grpc.CallOption) (*ListNotificationsResponse, error) {
	out := new(ListNotificationsResponse)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/ListNotifications", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) DeleteObjectAccessControl(ctx context.Context, in *DeleteObjectAccessControlRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/DeleteObjectAccessControl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) GetObjectAccessControl(ctx context.Context, in *GetObjectAccessControlRequest, opts ...grpc.CallOption) (*ObjectAccessControl, error) {
	out := new(ObjectAccessControl)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/GetObjectAccessControl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) InsertObjectAccessControl(ctx context.Context, in *InsertObjectAccessControlRequest, opts ...grpc.CallOption) (*ObjectAccessControl, error) {
	out := new(ObjectAccessControl)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/InsertObjectAccessControl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) ListObjectAccessControls(ctx context.Context, in *ListObjectAccessControlsRequest, opts ...grpc.CallOption) (*ListObjectAccessControlsResponse, error) {
	out := new(ListObjectAccessControlsResponse)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/ListObjectAccessControls", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) UpdateObjectAccessControl(ctx context.Context, in *UpdateObjectAccessControlRequest, opts ...grpc.CallOption) (*ObjectAccessControl, error) {
	out := new(ObjectAccessControl)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/UpdateObjectAccessControl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) ComposeObject(ctx context.Context, in *ComposeObjectRequest, opts ...grpc.CallOption) (*Object, error) {
	out := new(Object)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/ComposeObject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) CopyObject(ctx context.Context, in *CopyObjectRequest, opts ...grpc.CallOption) (*Object, error) {
	out := new(Object)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/CopyObject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) DeleteObject(ctx context.Context, in *DeleteObjectRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/DeleteObject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) GetObject(ctx context.Context, in *GetObjectRequest, opts ...grpc.CallOption) (*Object, error) {
	out := new(Object)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/GetObject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) GetObjectMedia(ctx context.Context, in *GetObjectMediaRequest, opts ...grpc.CallOption) (Storage_GetObjectMediaClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Storage_serviceDesc.Streams[0], "/google.storage.v1.Storage/GetObjectMedia", opts...)
	if err != nil {
		return nil, err
	}
	x := &storageGetObjectMediaClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Storage_GetObjectMediaClient interface {
	Recv() (*GetObjectMediaResponse, error)
	grpc.ClientStream
}

type storageGetObjectMediaClient struct {
	grpc.ClientStream
}

func (x *storageGetObjectMediaClient) Recv() (*GetObjectMediaResponse, error) {
	m := new(GetObjectMediaResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *storageClient) InsertObject(ctx context.Context, opts ...grpc.CallOption) (Storage_InsertObjectClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Storage_serviceDesc.Streams[1], "/google.storage.v1.Storage/InsertObject", opts...)
	if err != nil {
		return nil, err
	}
	x := &storageInsertObjectClient{stream}
	return x, nil
}

type Storage_InsertObjectClient interface {
	Send(*InsertObjectRequest) error
	CloseAndRecv() (*Object, error)
	grpc.ClientStream
}

type storageInsertObjectClient struct {
	grpc.ClientStream
}

func (x *storageInsertObjectClient) Send(m *InsertObjectRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *storageInsertObjectClient) CloseAndRecv() (*Object, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(Object)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *storageClient) ListObjects(ctx context.Context, in *ListObjectsRequest, opts ...grpc.CallOption) (*ListObjectsResponse, error) {
	out := new(ListObjectsResponse)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/ListObjects", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) RewriteObject(ctx context.Context, in *RewriteObjectRequest, opts ...grpc.CallOption) (*RewriteResponse, error) {
	out := new(RewriteResponse)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/RewriteObject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) StartResumableWrite(ctx context.Context, in *StartResumableWriteRequest, opts ...grpc.CallOption) (*StartResumableWriteResponse, error) {
	out := new(StartResumableWriteResponse)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/StartResumableWrite", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) QueryWriteStatus(ctx context.Context, in *QueryWriteStatusRequest, opts ...grpc.CallOption) (*QueryWriteStatusResponse, error) {
	out := new(QueryWriteStatusResponse)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/QueryWriteStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) PatchObject(ctx context.Context, in *PatchObjectRequest, opts ...grpc.CallOption) (*Object, error) {
	out := new(Object)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/PatchObject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) UpdateObject(ctx context.Context, in *UpdateObjectRequest, opts ...grpc.CallOption) (*Object, error) {
	out := new(Object)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/UpdateObject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) GetObjectIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/GetObjectIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) SetObjectIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/SetObjectIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) TestObjectIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error) {
	out := new(v1.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/TestObjectIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) WatchAllObjects(ctx context.Context, in *WatchAllObjectsRequest, opts ...grpc.CallOption) (*Channel, error) {
	out := new(Channel)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/WatchAllObjects", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) GetServiceAccount(ctx context.Context, in *GetProjectServiceAccountRequest, opts ...grpc.CallOption) (*ServiceAccount, error) {
	out := new(ServiceAccount)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/GetServiceAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) CreateHmacKey(ctx context.Context, in *CreateHmacKeyRequest, opts ...grpc.CallOption) (*CreateHmacKeyResponse, error) {
	out := new(CreateHmacKeyResponse)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/CreateHmacKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) DeleteHmacKey(ctx context.Context, in *DeleteHmacKeyRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/DeleteHmacKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) GetHmacKey(ctx context.Context, in *GetHmacKeyRequest, opts ...grpc.CallOption) (*HmacKeyMetadata, error) {
	out := new(HmacKeyMetadata)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/GetHmacKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) ListHmacKeys(ctx context.Context, in *ListHmacKeysRequest, opts ...grpc.CallOption) (*ListHmacKeysResponse, error) {
	out := new(ListHmacKeysResponse)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/ListHmacKeys", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) UpdateHmacKey(ctx context.Context, in *UpdateHmacKeyRequest, opts ...grpc.CallOption) (*HmacKeyMetadata, error) {
	out := new(HmacKeyMetadata)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/UpdateHmacKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// StorageServer is the server API for Storage service.
type StorageServer interface {
	// Permanently deletes the ACL entry for the specified entity on the specified
	// bucket.
	DeleteBucketAccessControl(context.Context, *DeleteBucketAccessControlRequest) (*empty.Empty, error)
	// Returns the ACL entry for the specified entity on the specified bucket.
	GetBucketAccessControl(context.Context, *GetBucketAccessControlRequest) (*BucketAccessControl, error)
	// Creates a new ACL entry on the specified bucket.
	InsertBucketAccessControl(context.Context, *InsertBucketAccessControlRequest) (*BucketAccessControl, error)
	// Retrieves ACL entries on the specified bucket.
	ListBucketAccessControls(context.Context, *ListBucketAccessControlsRequest) (*ListBucketAccessControlsResponse, error)
	// Updates an ACL entry on the specified bucket. Equivalent to
	// PatchBucketAccessControl, but all unspecified fields will be
	// reset to their default values.
	UpdateBucketAccessControl(context.Context, *UpdateBucketAccessControlRequest) (*BucketAccessControl, error)
	// Updates an ACL entry on the specified bucket.
	PatchBucketAccessControl(context.Context, *PatchBucketAccessControlRequest) (*BucketAccessControl, error)
	// Permanently deletes an empty bucket.
	DeleteBucket(context.Context, *DeleteBucketRequest) (*empty.Empty, error)
	// Returns metadata for the specified bucket.
	GetBucket(context.Context, *GetBucketRequest) (*Bucket, error)
	// Creates a new bucket.
	InsertBucket(context.Context, *InsertBucketRequest) (*Bucket, error)
	// List active object change notification channels for this bucket.
	ListChannels(context.Context, *ListChannelsRequest) (*ListChannelsResponse, error)
	// Retrieves a list of buckets for a given project.
	ListBuckets(context.Context, *ListBucketsRequest) (*ListBucketsResponse, error)
	// Locks retention policy on a bucket.
	LockBucketRetentionPolicy(context.Context, *LockRetentionPolicyRequest) (*Bucket, error)
	// Gets the IAM policy for the specified bucket.
	GetBucketIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error)
	// Updates an IAM policy for the specified bucket.
	SetBucketIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error)
	// Tests a set of permissions on the given bucket to see which, if
	// any, are held by the caller.
	TestBucketIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error)
	// Updates a bucket. Changes to the bucket will be readable immediately after
	// writing, but configuration changes may take time to propagate.
	PatchBucket(context.Context, *PatchBucketRequest) (*Bucket, error)
	// Updates a bucket. Equivalent to PatchBucket, but always replaces all
	// mutatable fields of the bucket with new values, reverting all
	// unspecified fields to their default values.
	// Like PatchBucket, Changes to the bucket will be readable immediately after
	// writing, but configuration changes may take time to propagate.
	UpdateBucket(context.Context, *UpdateBucketRequest) (*Bucket, error)
	// Halts "Object Change Notification" push messagages.
	// See https://cloud.google.com/storage/docs/object-change-notification
	// Note: this is not related to the newer "Notifications" resource, which
	// are stopped using DeleteNotification.
	StopChannel(context.Context, *StopChannelRequest) (*empty.Empty, error)
	// Permanently deletes the default object ACL entry for the specified entity
	// on the specified bucket.
	DeleteDefaultObjectAccessControl(context.Context, *DeleteDefaultObjectAccessControlRequest) (*empty.Empty, error)
	// Returns the default object ACL entry for the specified entity on the
	// specified bucket.
	GetDefaultObjectAccessControl(context.Context, *GetDefaultObjectAccessControlRequest) (*ObjectAccessControl, error)
	// Creates a new default object ACL entry on the specified bucket.
	InsertDefaultObjectAccessControl(context.Context, *InsertDefaultObjectAccessControlRequest) (*ObjectAccessControl, error)
	// Retrieves default object ACL entries on the specified bucket.
	ListDefaultObjectAccessControls(context.Context, *ListDefaultObjectAccessControlsRequest) (*ListObjectAccessControlsResponse, error)
	// Updates a default object ACL entry on the specified bucket.
	PatchDefaultObjectAccessControl(context.Context, *PatchDefaultObjectAccessControlRequest) (*ObjectAccessControl, error)
	// Updates a default object ACL entry on the specified bucket. Equivalent to
	// PatchDefaultObjectAccessControl, but modifies all unspecified fields to
	// their default values.
	UpdateDefaultObjectAccessControl(context.Context, *UpdateDefaultObjectAccessControlRequest) (*ObjectAccessControl, error)
	// Permanently deletes a notification subscription.
	// Note: Older, "Object Change Notification" push subscriptions should be
	// deleted using StopChannel instead.
	DeleteNotification(context.Context, *DeleteNotificationRequest) (*empty.Empty, error)
	// View a notification configuration.
	GetNotification(context.Context, *GetNotificationRequest) (*Notification, error)
	// Creates a notification subscription for a given bucket.
	// These notifications, when triggered, publish messages to the specified
	// Cloud Pub/Sub topics.
	// See https://cloud.google.com/storage/docs/pubsub-notifications.
	InsertNotification(context.Context, *InsertNotificationRequest) (*Notification, error)
	// Retrieves a list of notification subscriptions for a given bucket.
	ListNotifications(context.Context, *ListNotificationsRequest) (*ListNotificationsResponse, error)
	// Permanently deletes the ACL entry for the specified entity on the specified
	// object.
	DeleteObjectAccessControl(context.Context, *DeleteObjectAccessControlRequest) (*empty.Empty, error)
	// Returns the ACL entry for the specified entity on the specified object.
	GetObjectAccessControl(context.Context, *GetObjectAccessControlRequest) (*ObjectAccessControl, error)
	// Creates a new ACL entry on the specified object.
	InsertObjectAccessControl(context.Context, *InsertObjectAccessControlRequest) (*ObjectAccessControl, error)
	// Retrieves ACL entries on the specified object.
	ListObjectAccessControls(context.Context, *ListObjectAccessControlsRequest) (*ListObjectAccessControlsResponse, error)
	// Updates an ACL entry on the specified object.
	UpdateObjectAccessControl(context.Context, *UpdateObjectAccessControlRequest) (*ObjectAccessControl, error)
	// Concatenates a list of existing objects into a new object in the same
	// bucket.
	ComposeObject(context.Context, *ComposeObjectRequest) (*Object, error)
	// Copies a source object to a destination object. Optionally overrides
	// metadata.
	CopyObject(context.Context, *CopyObjectRequest) (*Object, error)
	// Deletes an object and its metadata. Deletions are permanent if versioning
	// is not enabled for the bucket, or if the `generation` parameter
	// is used.
	DeleteObject(context.Context, *DeleteObjectRequest) (*empty.Empty, error)
	// Retrieves an object's metadata.
	GetObject(context.Context, *GetObjectRequest) (*Object, error)
	// Reads an object's data.
	GetObjectMedia(*GetObjectMediaRequest, Storage_GetObjectMediaServer) error
	// Stores a new object and metadata.
	//
	// An object can be written either in a single message stream or in a
	// resumable sequence of message streams. To write using a single stream,
	// the client should include in the first message of the stream an
	// `InsertObjectSpec` describing the destination bucket, object, and any
	// preconditions. Additionally, the final message must set 'finish_write' to
	// true, or else it is an error.
	//
	// For a resumable write, the client should instead call
	// `StartResumableWrite()` and provide that method an `InsertObjectSpec.`
	// They should then attach the returned `upload_id` to the first message of
	// each following call to `Insert`. If there is an error or the connection is
	// broken during the resumable `Insert()`, the client should check the status
	// of the `Insert()` by calling `QueryWriteStatus()` and continue writing from
	// the returned `committed_size`. This may be less than the amount of data the
	// client previously sent.
	//
	// The service will not view the object as complete until the client has
	// sent an `Insert` with `finish_write` set to `true`. Sending any
	// requests on a stream after sending a request with `finish_write` set to
	// `true` will cause an error. The client **should** check the
	// `Object` it receives to determine how much data the service was
	// able to commit and whether the service views the object as complete.
	InsertObject(Storage_InsertObjectServer) error
	// Retrieves a list of objects matching the criteria.
	ListObjects(context.Context, *ListObjectsRequest) (*ListObjectsResponse, error)
	// Rewrites a source object to a destination object. Optionally overrides
	// metadata.
	RewriteObject(context.Context, *RewriteObjectRequest) (*RewriteResponse, error)
	// Starts a resumable write. How long the write operation remains valid, and
	// what happens when the write operation becomes invalid, are
	// service-dependent.
	StartResumableWrite(context.Context, *StartResumableWriteRequest) (*StartResumableWriteResponse, error)
	// Determines the `committed_size` for an object that is being written, which
	// can then be used as the `write_offset` for the next `Write()` call.
	//
	// If the object does not exist (i.e., the object has been deleted, or the
	// first `Write()` has not yet reached the service), this method returns the
	// error `NOT_FOUND`.
	//
	// The client **may** call `QueryWriteStatus()` at any time to determine how
	// much data has been processed for this object. This is useful if the
	// client is buffering data and needs to know which data can be safely
	// evicted. For any sequence of `QueryWriteStatus()` calls for a given
	// object name, the sequence of returned `committed_size` values will be
	// non-decreasing.
	QueryWriteStatus(context.Context, *QueryWriteStatusRequest) (*QueryWriteStatusResponse, error)
	// Updates an object's metadata.
	PatchObject(context.Context, *PatchObjectRequest) (*Object, error)
	// Updates an object's metadata. Equivalent to PatchObject, but always
	// replaces all mutatable fields of the bucket with new values, reverting all
	// unspecified fields to their default values.
	UpdateObject(context.Context, *UpdateObjectRequest) (*Object, error)
	// Gets the IAM policy for the specified object.
	GetObjectIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error)
	// Updates an IAM policy for the specified object.
	SetObjectIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error)
	// Tests a set of permissions on the given object to see which, if
	// any, are held by the caller.
	TestObjectIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error)
	// Watch for changes on all objects in a bucket.
	WatchAllObjects(context.Context, *WatchAllObjectsRequest) (*Channel, error)
	// Retrieves the name of a project's Google Cloud Storage service account.
	GetServiceAccount(context.Context, *GetProjectServiceAccountRequest) (*ServiceAccount, error)
	// Creates a new HMAC key for the given service account.
	CreateHmacKey(context.Context, *CreateHmacKeyRequest) (*CreateHmacKeyResponse, error)
	// Deletes a given HMAC key.  Key must be in an INACTIVE state.
	DeleteHmacKey(context.Context, *DeleteHmacKeyRequest) (*empty.Empty, error)
	// Gets an existing HMAC key metadata for the given id.
	GetHmacKey(context.Context, *GetHmacKeyRequest) (*HmacKeyMetadata, error)
	// Lists HMAC keys under a given project with the additional filters provided.
	ListHmacKeys(context.Context, *ListHmacKeysRequest) (*ListHmacKeysResponse, error)
	// Updates a given HMAC key state between ACTIVE and INACTIVE.
	UpdateHmacKey(context.Context, *UpdateHmacKeyRequest) (*HmacKeyMetadata, error)
}

// UnimplementedStorageServer can be embedded to have forward compatible implementations.
type UnimplementedStorageServer struct {
}

func (*UnimplementedStorageServer) DeleteBucketAccessControl(ctx context.Context, req *DeleteBucketAccessControlRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteBucketAccessControl not implemented")
}
func (*UnimplementedStorageServer) GetBucketAccessControl(ctx context.Context, req *GetBucketAccessControlRequest) (*BucketAccessControl, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBucketAccessControl not implemented")
}
func (*UnimplementedStorageServer) InsertBucketAccessControl(ctx context.Context, req *InsertBucketAccessControlRequest) (*BucketAccessControl, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InsertBucketAccessControl not implemented")
}
func (*UnimplementedStorageServer) ListBucketAccessControls(ctx context.Context, req *ListBucketAccessControlsRequest) (*ListBucketAccessControlsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBucketAccessControls not implemented")
}
func (*UnimplementedStorageServer) UpdateBucketAccessControl(ctx context.Context, req *UpdateBucketAccessControlRequest) (*BucketAccessControl, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateBucketAccessControl not implemented")
}
func (*UnimplementedStorageServer) PatchBucketAccessControl(ctx context.Context, req *PatchBucketAccessControlRequest) (*BucketAccessControl, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PatchBucketAccessControl not implemented")
}
func (*UnimplementedStorageServer) DeleteBucket(ctx context.Context, req *DeleteBucketRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteBucket not implemented")
}
func (*UnimplementedStorageServer) GetBucket(ctx context.Context, req *GetBucketRequest) (*Bucket, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBucket not implemented")
}
func (*UnimplementedStorageServer) InsertBucket(ctx context.Context, req *InsertBucketRequest) (*Bucket, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InsertBucket not implemented")
}
func (*UnimplementedStorageServer) ListChannels(ctx context.Context, req *ListChannelsRequest) (*ListChannelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListChannels not implemented")
}
func (*UnimplementedStorageServer) ListBuckets(ctx context.Context, req *ListBucketsRequest) (*ListBucketsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBuckets not implemented")
}
func (*UnimplementedStorageServer) LockBucketRetentionPolicy(ctx context.Context, req *LockRetentionPolicyRequest) (*Bucket, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LockBucketRetentionPolicy not implemented")
}
func (*UnimplementedStorageServer) GetBucketIamPolicy(ctx context.Context, req *v1.GetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBucketIamPolicy not implemented")
}
func (*UnimplementedStorageServer) SetBucketIamPolicy(ctx context.Context, req *v1.SetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetBucketIamPolicy not implemented")
}
func (*UnimplementedStorageServer) TestBucketIamPermissions(ctx context.Context, req *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestBucketIamPermissions not implemented")
}
func (*UnimplementedStorageServer) PatchBucket(ctx context.Context, req *PatchBucketRequest) (*Bucket, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PatchBucket not implemented")
}
func (*UnimplementedStorageServer) UpdateBucket(ctx context.Context, req *UpdateBucketRequest) (*Bucket, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateBucket not implemented")
}
func (*UnimplementedStorageServer) StopChannel(ctx context.Context, req *StopChannelRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopChannel not implemented")
}
func (*UnimplementedStorageServer) DeleteDefaultObjectAccessControl(ctx context.Context, req *DeleteDefaultObjectAccessControlRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDefaultObjectAccessControl not implemented")
}
func (*UnimplementedStorageServer) GetDefaultObjectAccessControl(ctx context.Context, req *GetDefaultObjectAccessControlRequest) (*ObjectAccessControl, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDefaultObjectAccessControl not implemented")
}
func (*UnimplementedStorageServer) InsertDefaultObjectAccessControl(ctx context.Context, req *InsertDefaultObjectAccessControlRequest) (*ObjectAccessControl, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InsertDefaultObjectAccessControl not implemented")
}
func (*UnimplementedStorageServer) ListDefaultObjectAccessControls(ctx context.Context, req *ListDefaultObjectAccessControlsRequest) (*ListObjectAccessControlsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDefaultObjectAccessControls not implemented")
}
func (*UnimplementedStorageServer) PatchDefaultObjectAccessControl(ctx context.Context, req *PatchDefaultObjectAccessControlRequest) (*ObjectAccessControl, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PatchDefaultObjectAccessControl not implemented")
}
func (*UnimplementedStorageServer) UpdateDefaultObjectAccessControl(ctx context.Context, req *UpdateDefaultObjectAccessControlRequest) (*ObjectAccessControl, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDefaultObjectAccessControl not implemented")
}
func (*UnimplementedStorageServer) DeleteNotification(ctx context.Context, req *DeleteNotificationRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteNotification not implemented")
}
func (*UnimplementedStorageServer) GetNotification(ctx context.Context, req *GetNotificationRequest) (*Notification, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNotification not implemented")
}
func (*UnimplementedStorageServer) InsertNotification(ctx context.Context, req *InsertNotificationRequest) (*Notification, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InsertNotification not implemented")
}
func (*UnimplementedStorageServer) ListNotifications(ctx context.Context, req *ListNotificationsRequest) (*ListNotificationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNotifications not implemented")
}
func (*UnimplementedStorageServer) DeleteObjectAccessControl(ctx context.Context, req *DeleteObjectAccessControlRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteObjectAccessControl not implemented")
}
func (*UnimplementedStorageServer) GetObjectAccessControl(ctx context.Context, req *GetObjectAccessControlRequest) (*ObjectAccessControl, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetObjectAccessControl not implemented")
}
func (*UnimplementedStorageServer) InsertObjectAccessControl(ctx context.Context, req *InsertObjectAccessControlRequest) (*ObjectAccessControl, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InsertObjectAccessControl not implemented")
}
func (*UnimplementedStorageServer) ListObjectAccessControls(ctx context.Context, req *ListObjectAccessControlsRequest) (*ListObjectAccessControlsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListObjectAccessControls not implemented")
}
func (*UnimplementedStorageServer) UpdateObjectAccessControl(ctx context.Context, req *UpdateObjectAccessControlRequest) (*ObjectAccessControl, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateObjectAccessControl not implemented")
}
func (*UnimplementedStorageServer) ComposeObject(ctx context.Context, req *ComposeObjectRequest) (*Object, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ComposeObject not implemented")
}
func (*UnimplementedStorageServer) CopyObject(ctx context.Context, req *CopyObjectRequest) (*Object, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CopyObject not implemented")
}
func (*UnimplementedStorageServer) DeleteObject(ctx context.Context, req *DeleteObjectRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteObject not implemented")
}
func (*UnimplementedStorageServer) GetObject(ctx context.Context, req *GetObjectRequest) (*Object, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetObject not implemented")
}
func (*UnimplementedStorageServer) GetObjectMedia(req *GetObjectMediaRequest, srv Storage_GetObjectMediaServer) error {
	return status.Errorf(codes.Unimplemented, "method GetObjectMedia not implemented")
}
func (*UnimplementedStorageServer) InsertObject(srv Storage_InsertObjectServer) error {
	return status.Errorf(codes.Unimplemented, "method InsertObject not implemented")
}
func (*UnimplementedStorageServer) ListObjects(ctx context.Context, req *ListObjectsRequest) (*ListObjectsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListObjects not implemented")
}
func (*UnimplementedStorageServer) RewriteObject(ctx context.Context, req *RewriteObjectRequest) (*RewriteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RewriteObject not implemented")
}
func (*UnimplementedStorageServer) StartResumableWrite(ctx context.Context, req *StartResumableWriteRequest) (*StartResumableWriteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartResumableWrite not implemented")
}
func (*UnimplementedStorageServer) QueryWriteStatus(ctx context.Context, req *QueryWriteStatusRequest) (*QueryWriteStatusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryWriteStatus not implemented")
}
func (*UnimplementedStorageServer) PatchObject(ctx context.Context, req *PatchObjectRequest) (*Object, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PatchObject not implemented")
}
func (*UnimplementedStorageServer) UpdateObject(ctx context.Context, req *UpdateObjectRequest) (*Object, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateObject not implemented")
}
func (*UnimplementedStorageServer) GetObjectIamPolicy(ctx context.Context, req *v1.GetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetObjectIamPolicy not implemented")
}
func (*UnimplementedStorageServer) SetObjectIamPolicy(ctx context.Context, req *v1.SetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetObjectIamPolicy not implemented")
}
func (*UnimplementedStorageServer) TestObjectIamPermissions(ctx context.Context, req *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestObjectIamPermissions not implemented")
}
func (*UnimplementedStorageServer) WatchAllObjects(ctx context.Context, req *WatchAllObjectsRequest) (*Channel, error) {
	return nil, status.Errorf(codes.Unimplemented, "method WatchAllObjects not implemented")
}
func (*UnimplementedStorageServer) GetServiceAccount(ctx context.Context, req *GetProjectServiceAccountRequest) (*ServiceAccount, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetServiceAccount not implemented")
}
func (*UnimplementedStorageServer) CreateHmacKey(ctx context.Context, req *CreateHmacKeyRequest) (*CreateHmacKeyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateHmacKey not implemented")
}
func (*UnimplementedStorageServer) DeleteHmacKey(ctx context.Context, req *DeleteHmacKeyRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteHmacKey not implemented")
}
func (*UnimplementedStorageServer) GetHmacKey(ctx context.Context, req *GetHmacKeyRequest) (*HmacKeyMetadata, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetHmacKey not implemented")
}
func (*UnimplementedStorageServer) ListHmacKeys(ctx context.Context, req *ListHmacKeysRequest) (*ListHmacKeysResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListHmacKeys not implemented")
}
func (*UnimplementedStorageServer) UpdateHmacKey(ctx context.Context, req *UpdateHmacKeyRequest) (*HmacKeyMetadata, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateHmacKey not implemented")
}

func RegisterStorageServer(s *grpc.Server, srv StorageServer) {
	s.RegisterService(&_Storage_serviceDesc, srv)
}

func _Storage_DeleteBucketAccessControl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBucketAccessControlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).DeleteBucketAccessControl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/DeleteBucketAccessControl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).DeleteBucketAccessControl(ctx, req.(*DeleteBucketAccessControlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_GetBucketAccessControl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBucketAccessControlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).GetBucketAccessControl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/GetBucketAccessControl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).GetBucketAccessControl(ctx, req.(*GetBucketAccessControlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_InsertBucketAccessControl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertBucketAccessControlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).InsertBucketAccessControl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/InsertBucketAccessControl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).InsertBucketAccessControl(ctx, req.(*InsertBucketAccessControlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_ListBucketAccessControls_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBucketAccessControlsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).ListBucketAccessControls(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/ListBucketAccessControls",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).ListBucketAccessControls(ctx, req.(*ListBucketAccessControlsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_UpdateBucketAccessControl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBucketAccessControlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).UpdateBucketAccessControl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/UpdateBucketAccessControl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).UpdateBucketAccessControl(ctx, req.(*UpdateBucketAccessControlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_PatchBucketAccessControl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchBucketAccessControlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).PatchBucketAccessControl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/PatchBucketAccessControl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).PatchBucketAccessControl(ctx, req.(*PatchBucketAccessControlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_DeleteBucket_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).DeleteBucket(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/DeleteBucket",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).DeleteBucket(ctx, req.(*DeleteBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_GetBucket_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).GetBucket(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/GetBucket",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).GetBucket(ctx, req.(*GetBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_InsertBucket_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).InsertBucket(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/InsertBucket",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).InsertBucket(ctx, req.(*InsertBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_ListChannels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListChannelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).ListChannels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/ListChannels",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).ListChannels(ctx, req.(*ListChannelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_ListBuckets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBucketsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).ListBuckets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/ListBuckets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).ListBuckets(ctx, req.(*ListBucketsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_LockBucketRetentionPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LockRetentionPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).LockBucketRetentionPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/LockBucketRetentionPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).LockBucketRetentionPolicy(ctx, req.(*LockRetentionPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_GetBucketIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).GetBucketIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/GetBucketIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).GetBucketIamPolicy(ctx, req.(*v1.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_SetBucketIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).SetBucketIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/SetBucketIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).SetBucketIamPolicy(ctx, req.(*v1.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_TestBucketIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).TestBucketIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/TestBucketIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).TestBucketIamPermissions(ctx, req.(*v1.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_PatchBucket_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).PatchBucket(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/PatchBucket",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).PatchBucket(ctx, req.(*PatchBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_UpdateBucket_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).UpdateBucket(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/UpdateBucket",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).UpdateBucket(ctx, req.(*UpdateBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_StopChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).StopChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/StopChannel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).StopChannel(ctx, req.(*StopChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_DeleteDefaultObjectAccessControl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDefaultObjectAccessControlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).DeleteDefaultObjectAccessControl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/DeleteDefaultObjectAccessControl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).DeleteDefaultObjectAccessControl(ctx, req.(*DeleteDefaultObjectAccessControlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_GetDefaultObjectAccessControl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDefaultObjectAccessControlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).GetDefaultObjectAccessControl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/GetDefaultObjectAccessControl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).GetDefaultObjectAccessControl(ctx, req.(*GetDefaultObjectAccessControlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_InsertDefaultObjectAccessControl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertDefaultObjectAccessControlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).InsertDefaultObjectAccessControl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/InsertDefaultObjectAccessControl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).InsertDefaultObjectAccessControl(ctx, req.(*InsertDefaultObjectAccessControlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_ListDefaultObjectAccessControls_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDefaultObjectAccessControlsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).ListDefaultObjectAccessControls(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/ListDefaultObjectAccessControls",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).ListDefaultObjectAccessControls(ctx, req.(*ListDefaultObjectAccessControlsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_PatchDefaultObjectAccessControl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchDefaultObjectAccessControlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).PatchDefaultObjectAccessControl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/PatchDefaultObjectAccessControl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).PatchDefaultObjectAccessControl(ctx, req.(*PatchDefaultObjectAccessControlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_UpdateDefaultObjectAccessControl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDefaultObjectAccessControlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).UpdateDefaultObjectAccessControl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/UpdateDefaultObjectAccessControl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).UpdateDefaultObjectAccessControl(ctx, req.(*UpdateDefaultObjectAccessControlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_DeleteNotification_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNotificationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).DeleteNotification(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/DeleteNotification",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).DeleteNotification(ctx, req.(*DeleteNotificationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_GetNotification_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNotificationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).GetNotification(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/GetNotification",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).GetNotification(ctx, req.(*GetNotificationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_InsertNotification_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertNotificationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).InsertNotification(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/InsertNotification",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).InsertNotification(ctx, req.(*InsertNotificationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_ListNotifications_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNotificationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).ListNotifications(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/ListNotifications",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).ListNotifications(ctx, req.(*ListNotificationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_DeleteObjectAccessControl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteObjectAccessControlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).DeleteObjectAccessControl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/DeleteObjectAccessControl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).DeleteObjectAccessControl(ctx, req.(*DeleteObjectAccessControlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_GetObjectAccessControl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetObjectAccessControlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).GetObjectAccessControl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/GetObjectAccessControl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).GetObjectAccessControl(ctx, req.(*GetObjectAccessControlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_InsertObjectAccessControl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertObjectAccessControlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).InsertObjectAccessControl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/InsertObjectAccessControl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).InsertObjectAccessControl(ctx, req.(*InsertObjectAccessControlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_ListObjectAccessControls_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListObjectAccessControlsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).ListObjectAccessControls(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/ListObjectAccessControls",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).ListObjectAccessControls(ctx, req.(*ListObjectAccessControlsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_UpdateObjectAccessControl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateObjectAccessControlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).UpdateObjectAccessControl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/UpdateObjectAccessControl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).UpdateObjectAccessControl(ctx, req.(*UpdateObjectAccessControlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_ComposeObject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ComposeObjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).ComposeObject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/ComposeObject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).ComposeObject(ctx, req.(*ComposeObjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_CopyObject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CopyObjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).CopyObject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/CopyObject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).CopyObject(ctx, req.(*CopyObjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_DeleteObject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteObjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).DeleteObject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/DeleteObject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).DeleteObject(ctx, req.(*DeleteObjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_GetObject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetObjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).GetObject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/GetObject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).GetObject(ctx, req.(*GetObjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_GetObjectMedia_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetObjectMediaRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(StorageServer).GetObjectMedia(m, &storageGetObjectMediaServer{stream})
}

type Storage_GetObjectMediaServer interface {
	Send(*GetObjectMediaResponse) error
	grpc.ServerStream
}

type storageGetObjectMediaServer struct {
	grpc.ServerStream
}

func (x *storageGetObjectMediaServer) Send(m *GetObjectMediaResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Storage_InsertObject_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(StorageServer).InsertObject(&storageInsertObjectServer{stream})
}

type Storage_InsertObjectServer interface {
	SendAndClose(*Object) error
	Recv() (*InsertObjectRequest, error)
	grpc.ServerStream
}

type storageInsertObjectServer struct {
	grpc.ServerStream
}

func (x *storageInsertObjectServer) SendAndClose(m *Object) error {
	return x.ServerStream.SendMsg(m)
}

func (x *storageInsertObjectServer) Recv() (*InsertObjectRequest, error) {
	m := new(InsertObjectRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Storage_ListObjects_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListObjectsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).ListObjects(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/ListObjects",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).ListObjects(ctx, req.(*ListObjectsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_RewriteObject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RewriteObjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).RewriteObject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/RewriteObject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).RewriteObject(ctx, req.(*RewriteObjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_StartResumableWrite_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartResumableWriteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).StartResumableWrite(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/StartResumableWrite",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).StartResumableWrite(ctx, req.(*StartResumableWriteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_QueryWriteStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryWriteStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).QueryWriteStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/QueryWriteStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).QueryWriteStatus(ctx, req.(*QueryWriteStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_PatchObject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchObjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).PatchObject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/PatchObject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).PatchObject(ctx, req.(*PatchObjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_UpdateObject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateObjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).UpdateObject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/UpdateObject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).UpdateObject(ctx, req.(*UpdateObjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_GetObjectIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).GetObjectIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/GetObjectIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).GetObjectIamPolicy(ctx, req.(*v1.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_SetObjectIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).SetObjectIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/SetObjectIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).SetObjectIamPolicy(ctx, req.(*v1.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_TestObjectIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).TestObjectIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/TestObjectIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).TestObjectIamPermissions(ctx, req.(*v1.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_WatchAllObjects_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WatchAllObjectsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).WatchAllObjects(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/WatchAllObjects",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).WatchAllObjects(ctx, req.(*WatchAllObjectsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_GetServiceAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProjectServiceAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).GetServiceAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/GetServiceAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).GetServiceAccount(ctx, req.(*GetProjectServiceAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_CreateHmacKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateHmacKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).CreateHmacKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/CreateHmacKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).CreateHmacKey(ctx, req.(*CreateHmacKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_DeleteHmacKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteHmacKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).DeleteHmacKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/DeleteHmacKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).DeleteHmacKey(ctx, req.(*DeleteHmacKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_GetHmacKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetHmacKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).GetHmacKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/GetHmacKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).GetHmacKey(ctx, req.(*GetHmacKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_ListHmacKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListHmacKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).ListHmacKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/ListHmacKeys",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).ListHmacKeys(ctx, req.(*ListHmacKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_UpdateHmacKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateHmacKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).UpdateHmacKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/UpdateHmacKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).UpdateHmacKey(ctx, req.(*UpdateHmacKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Storage_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.storage.v1.Storage",
	HandlerType: (*StorageServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "DeleteBucketAccessControl",
			Handler:    _Storage_DeleteBucketAccessControl_Handler,
		},
		{
			MethodName: "GetBucketAccessControl",
			Handler:    _Storage_GetBucketAccessControl_Handler,
		},
		{
			MethodName: "InsertBucketAccessControl",
			Handler:    _Storage_InsertBucketAccessControl_Handler,
		},
		{
			MethodName: "ListBucketAccessControls",
			Handler:    _Storage_ListBucketAccessControls_Handler,
		},
		{
			MethodName: "UpdateBucketAccessControl",
			Handler:    _Storage_UpdateBucketAccessControl_Handler,
		},
		{
			MethodName: "PatchBucketAccessControl",
			Handler:    _Storage_PatchBucketAccessControl_Handler,
		},
		{
			MethodName: "DeleteBucket",
			Handler:    _Storage_DeleteBucket_Handler,
		},
		{
			MethodName: "GetBucket",
			Handler:    _Storage_GetBucket_Handler,
		},
		{
			MethodName: "InsertBucket",
			Handler:    _Storage_InsertBucket_Handler,
		},
		{
			MethodName: "ListChannels",
			Handler:    _Storage_ListChannels_Handler,
		},
		{
			MethodName: "ListBuckets",
			Handler:    _Storage_ListBuckets_Handler,
		},
		{
			MethodName: "LockBucketRetentionPolicy",
			Handler:    _Storage_LockBucketRetentionPolicy_Handler,
		},
		{
			MethodName: "GetBucketIamPolicy",
			Handler:    _Storage_GetBucketIamPolicy_Handler,
		},
		{
			MethodName: "SetBucketIamPolicy",
			Handler:    _Storage_SetBucketIamPolicy_Handler,
		},
		{
			MethodName: "TestBucketIamPermissions",
			Handler:    _Storage_TestBucketIamPermissions_Handler,
		},
		{
			MethodName: "PatchBucket",
			Handler:    _Storage_PatchBucket_Handler,
		},
		{
			MethodName: "UpdateBucket",
			Handler:    _Storage_UpdateBucket_Handler,
		},
		{
			MethodName: "StopChannel",
			Handler:    _Storage_StopChannel_Handler,
		},
		{
			MethodName: "DeleteDefaultObjectAccessControl",
			Handler:    _Storage_DeleteDefaultObjectAccessControl_Handler,
		},
		{
			MethodName: "GetDefaultObjectAccessControl",
			Handler:    _Storage_GetDefaultObjectAccessControl_Handler,
		},
		{
			MethodName: "InsertDefaultObjectAccessControl",
			Handler:    _Storage_InsertDefaultObjectAccessControl_Handler,
		},
		{
			MethodName: "ListDefaultObjectAccessControls",
			Handler:    _Storage_ListDefaultObjectAccessControls_Handler,
		},
		{
			MethodName: "PatchDefaultObjectAccessControl",
			Handler:    _Storage_PatchDefaultObjectAccessControl_Handler,
		},
		{
			MethodName: "UpdateDefaultObjectAccessControl",
			Handler:    _Storage_UpdateDefaultObjectAccessControl_Handler,
		},
		{
			MethodName: "DeleteNotification",
			Handler:    _Storage_DeleteNotification_Handler,
		},
		{
			MethodName: "GetNotification",
			Handler:    _Storage_GetNotification_Handler,
		},
		{
			MethodName: "InsertNotification",
			Handler:    _Storage_InsertNotification_Handler,
		},
		{
			MethodName: "ListNotifications",
			Handler:    _Storage_ListNotifications_Handler,
		},
		{
			MethodName: "DeleteObjectAccessControl",
			Handler:    _Storage_DeleteObjectAccessControl_Handler,
		},
		{
			MethodName: "GetObjectAccessControl",
			Handler:    _Storage_GetObjectAccessControl_Handler,
		},
		{
			MethodName: "InsertObjectAccessControl",
			Handler:    _Storage_InsertObjectAccessControl_Handler,
		},
		{
			MethodName: "ListObjectAccessControls",
			Handler:    _Storage_ListObjectAccessControls_Handler,
		},
		{
			MethodName: "UpdateObjectAccessControl",
			Handler:    _Storage_UpdateObjectAccessControl_Handler,
		},
		{
			MethodName: "ComposeObject",
			Handler:    _Storage_ComposeObject_Handler,
		},
		{
			MethodName: "CopyObject",
			Handler:    _Storage_CopyObject_Handler,
		},
		{
			MethodName: "DeleteObject",
			Handler:    _Storage_DeleteObject_Handler,
		},
		{
			MethodName: "GetObject",
			Handler:    _Storage_GetObject_Handler,
		},
		{
			MethodName: "ListObjects",
			Handler:    _Storage_ListObjects_Handler,
		},
		{
			MethodName: "RewriteObject",
			Handler:    _Storage_RewriteObject_Handler,
		},
		{
			MethodName: "StartResumableWrite",
			Handler:    _Storage_StartResumableWrite_Handler,
		},
		{
			MethodName: "QueryWriteStatus",
			Handler:    _Storage_QueryWriteStatus_Handler,
		},
		{
			MethodName: "PatchObject",
			Handler:    _Storage_PatchObject_Handler,
		},
		{
			MethodName: "UpdateObject",
			Handler:    _Storage_UpdateObject_Handler,
		},
		{
			MethodName: "GetObjectIamPolicy",
			Handler:    _Storage_GetObjectIamPolicy_Handler,
		},
		{
			MethodName: "SetObjectIamPolicy",
			Handler:    _Storage_SetObjectIamPolicy_Handler,
		},
		{
			MethodName: "TestObjectIamPermissions",
			Handler:    _Storage_TestObjectIamPermissions_Handler,
		},
		{
			MethodName: "WatchAllObjects",
			Handler:    _Storage_WatchAllObjects_Handler,
		},
		{
			MethodName: "GetServiceAccount",
			Handler:    _Storage_GetServiceAccount_Handler,
		},
		{
			MethodName: "CreateHmacKey",
			Handler:    _Storage_CreateHmacKey_Handler,
		},
		{
			MethodName: "DeleteHmacKey",
			Handler:    _Storage_DeleteHmacKey_Handler,
		},
		{
			MethodName: "GetHmacKey",
			Handler:    _Storage_GetHmacKey_Handler,
		},
		{
			MethodName: "ListHmacKeys",
			Handler:    _Storage_ListHmacKeys_Handler,
		},
		{
			MethodName: "UpdateHmacKey",
			Handler:    _Storage_UpdateHmacKey_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "GetObjectMedia",
			Handler:       _Storage_GetObjectMedia_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "InsertObject",
			Handler:       _Storage_InsertObject_Handler,
			ClientStreams: true,
		},
	},
	Metadata: "google/storage/v1/storage.proto",
}
