// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/bigquery/storage/v1beta2/stream.proto

package storage

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Data format for input or output data.
type DataFormat int32

const (
	DataFormat_DATA_FORMAT_UNSPECIFIED DataFormat = 0
	// Avro is a standard open source row based file format.
	// See https://avro.apache.org/ for more details.
	DataFormat_AVRO DataFormat = 1
	// Arrow is a standard open source column-based message format.
	// See https://arrow.apache.org/ for more details.
	DataFormat_ARROW DataFormat = 2
)

var DataFormat_name = map[int32]string{
	0: "DATA_FORMAT_UNSPECIFIED",
	1: "AVRO",
	2: "ARROW",
}

var DataFormat_value = map[string]int32{
	"DATA_FORMAT_UNSPECIFIED": 0,
	"AVRO":                    1,
	"ARROW":                   2,
}

func (x DataFormat) String() string {
	return proto.EnumName(DataFormat_name, int32(x))
}

func (DataFormat) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_c242eb28e47086d8, []int{0}
}

// Information about the ReadSession.
type ReadSession struct {
	// Output only. Unique identifier for the session, in the form
	// `projects/{project_id}/locations/{location}/sessions/{session_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Time at which the session becomes invalid. After this time, subsequent
	// requests to read this Session will return errors. The expire_time is
	// automatically assigned and currently cannot be specified or updated.
	ExpireTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// Immutable. Data format of the output data.
	DataFormat DataFormat `protobuf:"varint,3,opt,name=data_format,json=dataFormat,proto3,enum=google.cloud.bigquery.storage.v1beta2.DataFormat" json:"data_format,omitempty"`
	// The schema for the read. If read_options.selected_fields is set, the
	// schema may be different from the table schema as it will only contain
	// the selected fields.
	//
	// Types that are valid to be assigned to Schema:
	//	*ReadSession_AvroSchema
	//	*ReadSession_ArrowSchema
	Schema isReadSession_Schema `protobuf_oneof:"schema"`
	// Immutable. Table that this ReadSession is reading from, in the form
	// `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}
	Table string `protobuf:"bytes,6,opt,name=table,proto3" json:"table,omitempty"`
	// Optional. Any modifiers which are applied when reading from the specified table.
	TableModifiers *ReadSession_TableModifiers `protobuf:"bytes,7,opt,name=table_modifiers,json=tableModifiers,proto3" json:"table_modifiers,omitempty"`
	// Optional. Read options for this session (e.g. column selection, filters).
	ReadOptions *ReadSession_TableReadOptions `protobuf:"bytes,8,opt,name=read_options,json=readOptions,proto3" json:"read_options,omitempty"`
	// Output only. A list of streams created with the session.
	//
	// At least one stream is created with the session. In the future, larger
	// request_stream_count values *may* result in this list being unpopulated,
	// in that case, the user will need to use a List method to get the streams
	// instead, which is not yet available.
	Streams              []*ReadStream `protobuf:"bytes,10,rep,name=streams,proto3" json:"streams,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ReadSession) Reset()         { *m = ReadSession{} }
func (m *ReadSession) String() string { return proto.CompactTextString(m) }
func (*ReadSession) ProtoMessage()    {}
func (*ReadSession) Descriptor() ([]byte, []int) {
	return fileDescriptor_c242eb28e47086d8, []int{0}
}

func (m *ReadSession) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReadSession.Unmarshal(m, b)
}
func (m *ReadSession) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReadSession.Marshal(b, m, deterministic)
}
func (m *ReadSession) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadSession.Merge(m, src)
}
func (m *ReadSession) XXX_Size() int {
	return xxx_messageInfo_ReadSession.Size(m)
}
func (m *ReadSession) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadSession.DiscardUnknown(m)
}

var xxx_messageInfo_ReadSession proto.InternalMessageInfo

func (m *ReadSession) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ReadSession) GetExpireTime() *timestamp.Timestamp {
	if m != nil {
		return m.ExpireTime
	}
	return nil
}

func (m *ReadSession) GetDataFormat() DataFormat {
	if m != nil {
		return m.DataFormat
	}
	return DataFormat_DATA_FORMAT_UNSPECIFIED
}

type isReadSession_Schema interface {
	isReadSession_Schema()
}

type ReadSession_AvroSchema struct {
	AvroSchema *AvroSchema `protobuf:"bytes,4,opt,name=avro_schema,json=avroSchema,proto3,oneof"`
}

type ReadSession_ArrowSchema struct {
	ArrowSchema *ArrowSchema `protobuf:"bytes,5,opt,name=arrow_schema,json=arrowSchema,proto3,oneof"`
}

func (*ReadSession_AvroSchema) isReadSession_Schema() {}

func (*ReadSession_ArrowSchema) isReadSession_Schema() {}

func (m *ReadSession) GetSchema() isReadSession_Schema {
	if m != nil {
		return m.Schema
	}
	return nil
}

func (m *ReadSession) GetAvroSchema() *AvroSchema {
	if x, ok := m.GetSchema().(*ReadSession_AvroSchema); ok {
		return x.AvroSchema
	}
	return nil
}

func (m *ReadSession) GetArrowSchema() *ArrowSchema {
	if x, ok := m.GetSchema().(*ReadSession_ArrowSchema); ok {
		return x.ArrowSchema
	}
	return nil
}

func (m *ReadSession) GetTable() string {
	if m != nil {
		return m.Table
	}
	return ""
}

func (m *ReadSession) GetTableModifiers() *ReadSession_TableModifiers {
	if m != nil {
		return m.TableModifiers
	}
	return nil
}

func (m *ReadSession) GetReadOptions() *ReadSession_TableReadOptions {
	if m != nil {
		return m.ReadOptions
	}
	return nil
}

func (m *ReadSession) GetStreams() []*ReadStream {
	if m != nil {
		return m.Streams
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ReadSession) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ReadSession_AvroSchema)(nil),
		(*ReadSession_ArrowSchema)(nil),
	}
}

// Additional attributes when reading a table.
type ReadSession_TableModifiers struct {
	// The snapshot time of the table. If not set, interpreted as now.
	SnapshotTime         *timestamp.Timestamp `protobuf:"bytes,1,opt,name=snapshot_time,json=snapshotTime,proto3" json:"snapshot_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ReadSession_TableModifiers) Reset()         { *m = ReadSession_TableModifiers{} }
func (m *ReadSession_TableModifiers) String() string { return proto.CompactTextString(m) }
func (*ReadSession_TableModifiers) ProtoMessage()    {}
func (*ReadSession_TableModifiers) Descriptor() ([]byte, []int) {
	return fileDescriptor_c242eb28e47086d8, []int{0, 0}
}

func (m *ReadSession_TableModifiers) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReadSession_TableModifiers.Unmarshal(m, b)
}
func (m *ReadSession_TableModifiers) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReadSession_TableModifiers.Marshal(b, m, deterministic)
}
func (m *ReadSession_TableModifiers) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadSession_TableModifiers.Merge(m, src)
}
func (m *ReadSession_TableModifiers) XXX_Size() int {
	return xxx_messageInfo_ReadSession_TableModifiers.Size(m)
}
func (m *ReadSession_TableModifiers) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadSession_TableModifiers.DiscardUnknown(m)
}

var xxx_messageInfo_ReadSession_TableModifiers proto.InternalMessageInfo

func (m *ReadSession_TableModifiers) GetSnapshotTime() *timestamp.Timestamp {
	if m != nil {
		return m.SnapshotTime
	}
	return nil
}

// Options dictating how we read a table.
type ReadSession_TableReadOptions struct {
	// Names of the fields in the table that should be read. If empty, all
	// fields will be read. If the specified field is a nested field, all
	// the sub-fields in the field will be selected. The output field order is
	// unrelated to the order of fields in selected_fields.
	SelectedFields []string `protobuf:"bytes,1,rep,name=selected_fields,json=selectedFields,proto3" json:"selected_fields,omitempty"`
	// SQL text filtering statement, similar to a WHERE clause in a query.
	// Currently, only a single predicate that is a comparison between a column
	// and a constant value is supported. Aggregates are not supported.
	//
	// Examples: "int_field > 5"
	//           "date_field = CAST('2014-9-27' as DATE)"
	//           "nullable_field is not NULL"
	//           "st_equals(geo_field, st_geofromtext("POINT(2, 2)"))"
	//           "numeric_field BETWEEN 1.0 AND 5.0"
	RowRestriction string `protobuf:"bytes,2,opt,name=row_restriction,json=rowRestriction,proto3" json:"row_restriction,omitempty"`
	// Optional. Options specific to the Apache Arrow output format.
	ArrowSerializationOptions *ArrowSerializationOptions `protobuf:"bytes,3,opt,name=arrow_serialization_options,json=arrowSerializationOptions,proto3" json:"arrow_serialization_options,omitempty"`
	XXX_NoUnkeyedLiteral      struct{}                   `json:"-"`
	XXX_unrecognized          []byte                     `json:"-"`
	XXX_sizecache             int32                      `json:"-"`
}

func (m *ReadSession_TableReadOptions) Reset()         { *m = ReadSession_TableReadOptions{} }
func (m *ReadSession_TableReadOptions) String() string { return proto.CompactTextString(m) }
func (*ReadSession_TableReadOptions) ProtoMessage()    {}
func (*ReadSession_TableReadOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_c242eb28e47086d8, []int{0, 1}
}

func (m *ReadSession_TableReadOptions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReadSession_TableReadOptions.Unmarshal(m, b)
}
func (m *ReadSession_TableReadOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReadSession_TableReadOptions.Marshal(b, m, deterministic)
}
func (m *ReadSession_TableReadOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadSession_TableReadOptions.Merge(m, src)
}
func (m *ReadSession_TableReadOptions) XXX_Size() int {
	return xxx_messageInfo_ReadSession_TableReadOptions.Size(m)
}
func (m *ReadSession_TableReadOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadSession_TableReadOptions.DiscardUnknown(m)
}

var xxx_messageInfo_ReadSession_TableReadOptions proto.InternalMessageInfo

func (m *ReadSession_TableReadOptions) GetSelectedFields() []string {
	if m != nil {
		return m.SelectedFields
	}
	return nil
}

func (m *ReadSession_TableReadOptions) GetRowRestriction() string {
	if m != nil {
		return m.RowRestriction
	}
	return ""
}

func (m *ReadSession_TableReadOptions) GetArrowSerializationOptions() *ArrowSerializationOptions {
	if m != nil {
		return m.ArrowSerializationOptions
	}
	return nil
}

// Information about a single stream that gets data out of the storage system.
// Most of the information about `ReadStream` instances is aggregated, making
// `ReadStream` lightweight.
type ReadStream struct {
	// Output only. Name of the stream, in the form
	// `projects/{project_id}/locations/{location}/sessions/{session_id}/streams/{stream_id}`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReadStream) Reset()         { *m = ReadStream{} }
func (m *ReadStream) String() string { return proto.CompactTextString(m) }
func (*ReadStream) ProtoMessage()    {}
func (*ReadStream) Descriptor() ([]byte, []int) {
	return fileDescriptor_c242eb28e47086d8, []int{1}
}

func (m *ReadStream) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReadStream.Unmarshal(m, b)
}
func (m *ReadStream) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReadStream.Marshal(b, m, deterministic)
}
func (m *ReadStream) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadStream.Merge(m, src)
}
func (m *ReadStream) XXX_Size() int {
	return xxx_messageInfo_ReadStream.Size(m)
}
func (m *ReadStream) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadStream.DiscardUnknown(m)
}

var xxx_messageInfo_ReadStream proto.InternalMessageInfo

func (m *ReadStream) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.cloud.bigquery.storage.v1beta2.DataFormat", DataFormat_name, DataFormat_value)
	proto.RegisterType((*ReadSession)(nil), "google.cloud.bigquery.storage.v1beta2.ReadSession")
	proto.RegisterType((*ReadSession_TableModifiers)(nil), "google.cloud.bigquery.storage.v1beta2.ReadSession.TableModifiers")
	proto.RegisterType((*ReadSession_TableReadOptions)(nil), "google.cloud.bigquery.storage.v1beta2.ReadSession.TableReadOptions")
	proto.RegisterType((*ReadStream)(nil), "google.cloud.bigquery.storage.v1beta2.ReadStream")
}

func init() {
	proto.RegisterFile("google/cloud/bigquery/storage/v1beta2/stream.proto", fileDescriptor_c242eb28e47086d8)
}

var fileDescriptor_c242eb28e47086d8 = []byte{
	// 773 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x55, 0x4d, 0x8f, 0xdb, 0x44,
	0x18, 0xae, 0x9b, 0xcd, 0x76, 0xf3, 0x7a, 0x49, 0xa3, 0xb9, 0xd4, 0x4d, 0x85, 0x1a, 0x55, 0xaa,
	0x48, 0x7b, 0xf0, 0xb0, 0x81, 0xd3, 0x56, 0x82, 0x3a, 0xdd, 0x46, 0x54, 0x50, 0x12, 0xbc, 0x29,
	0x15, 0x08, 0xc9, 0x9a, 0xd8, 0x13, 0xc7, 0xd4, 0xce, 0x98, 0x99, 0x49, 0x5a, 0x88, 0x72, 0xe4,
	0x7f, 0x20, 0x7e, 0xd9, 0x9e, 0x57, 0xfc, 0x02, 0x4e, 0x68, 0x66, 0xec, 0x7c, 0x54, 0x54, 0xeb,
	0xee, 0xc9, 0xaf, 0x1f, 0xcf, 0xf3, 0xcc, 0x33, 0xf3, 0x7e, 0x18, 0x7a, 0x31, 0x63, 0x71, 0x4a,
	0x71, 0x98, 0xb2, 0x45, 0x84, 0x27, 0x49, 0xfc, 0xdb, 0x82, 0xf2, 0xdf, 0xb1, 0x90, 0x8c, 0x93,
	0x98, 0xe2, 0xe5, 0xc9, 0x84, 0x4a, 0xd2, 0xc3, 0x42, 0x72, 0x4a, 0x32, 0x37, 0xe7, 0x4c, 0x32,
	0xf4, 0xd0, 0x70, 0x5c, 0xcd, 0x71, 0x4b, 0x8e, 0x5b, 0x70, 0xdc, 0x82, 0xd3, 0xbe, 0x5f, 0x48,
	0x93, 0x3c, 0xc1, 0xd3, 0x84, 0xa6, 0x51, 0x30, 0xa1, 0x33, 0xb2, 0x4c, 0x18, 0x37, 0x3a, 0xed,
	0xbb, 0x3b, 0x0b, 0x38, 0x15, 0x6c, 0xc1, 0x43, 0x5a, 0x7c, 0x3a, 0xa9, 0x66, 0x8b, 0x70, 0xce,
	0xde, 0x16, 0x94, 0xcf, 0x2b, 0x52, 0x96, 0x9c, 0x15, 0x8c, 0xd2, 0xa0, 0x7e, 0x9b, 0x2c, 0xa6,
	0x58, 0x26, 0x19, 0x15, 0x92, 0x64, 0xb9, 0x59, 0xf0, 0xe0, 0xaf, 0x06, 0xd8, 0x3e, 0x25, 0xd1,
	0x39, 0x15, 0x22, 0x61, 0x73, 0x74, 0x07, 0x0e, 0xe6, 0x24, 0xa3, 0x8e, 0xd5, 0xb1, 0xba, 0x8d,
	0x7e, 0xed, 0xc2, 0xab, 0xf9, 0x1a, 0x40, 0x4f, 0xc1, 0xa6, 0xef, 0xf2, 0x84, 0xd3, 0x40, 0x49,
	0x38, 0x37, 0x3b, 0x56, 0xd7, 0xee, 0xb5, 0xdd, 0xe2, 0x9e, 0x4a, 0x7d, 0x77, 0x5c, 0xea, 0x1b,
	0x2e, 0x18, 0x8e, 0x42, 0xd1, 0x6b, 0xb0, 0x23, 0x22, 0x49, 0x30, 0x65, 0x3c, 0x23, 0xd2, 0xa9,
	0x75, 0xac, 0x6e, 0xb3, 0x77, 0xe2, 0x56, 0xba, 0x69, 0xf7, 0x8c, 0x48, 0x32, 0xd0, 0x44, 0x25,
	0x5c, 0xf7, 0x21, 0xda, 0x00, 0xe8, 0x27, 0xb0, 0xd5, 0x91, 0x03, 0x11, 0xce, 0x68, 0x46, 0x9c,
	0x03, 0x6d, 0xad, 0xaa, 0xb0, 0xb7, 0xe4, 0xec, 0x5c, 0x13, 0xb5, 0xe3, 0x6f, 0x6e, 0xf8, 0x40,
	0x36, 0x10, 0xfa, 0x05, 0x8e, 0x75, 0x02, 0x4a, 0xed, 0xba, 0xd6, 0xee, 0x55, 0xd5, 0x56, 0xd4,
	0x7d, 0x71, 0x9b, 0x6c, 0x31, 0xf4, 0x04, 0xea, 0x92, 0x4c, 0x52, 0xea, 0x1c, 0xea, 0xdb, 0x7e,
	0x78, 0xe1, 0xd5, 0xff, 0xf5, 0xee, 0xc3, 0xa7, 0x1b, 0x41, 0xb3, 0x0d, 0xc9, 0x13, 0xe1, 0x86,
	0x2c, 0xc3, 0x63, 0xb5, 0xd8, 0x37, 0x1c, 0xc4, 0xe0, 0xb6, 0x0e, 0x82, 0x8c, 0x45, 0xc9, 0x34,
	0xa1, 0x5c, 0x38, 0xb7, 0xb4, 0x3b, 0xaf, 0xa2, 0xbb, 0x9d, 0xb4, 0xbb, 0x5a, 0xf9, 0x65, 0x29,
	0xa4, 0xcc, 0x5a, 0x7e, 0x53, 0xee, 0x81, 0xe8, 0x0d, 0x1c, 0x73, 0x4a, 0xa2, 0x80, 0xe5, 0x32,
	0x61, 0x73, 0xe1, 0x1c, 0xe9, 0xdd, 0x9e, 0x5d, 0x77, 0x37, 0x05, 0x0c, 0x8d, 0x94, 0xd9, 0xcf,
	0xe6, 0x5b, 0x04, 0x8d, 0xe0, 0x96, 0x69, 0x48, 0xe1, 0x40, 0xa7, 0xf6, 0x11, 0xf9, 0xd4, 0xfb,
	0x68, 0xa6, 0xa9, 0xc0, 0x52, 0xa6, 0xfd, 0x03, 0x34, 0xf7, 0x4f, 0x89, 0xbe, 0x86, 0x4f, 0xc4,
	0x9c, 0xe4, 0x62, 0xc6, 0xa4, 0x29, 0x6a, 0xeb, 0xaa, 0xa2, 0xf6, 0x8f, 0x4b, 0x82, 0x82, 0xda,
	0xff, 0x58, 0xd0, 0x7a, 0xff, 0x2c, 0xe8, 0x33, 0xb8, 0x2d, 0x68, 0x4a, 0x43, 0x49, 0xa3, 0x40,
	0xcf, 0x04, 0xe1, 0x58, 0x9d, 0x5a, 0xb7, 0xe1, 0x37, 0x4b, 0x78, 0xa0, 0x51, 0xb5, 0x50, 0x55,
	0x16, 0xa7, 0x42, 0xf2, 0x24, 0x54, 0x64, 0xdd, 0x55, 0x0d, 0xbf, 0xc9, 0xd9, 0x5b, 0x7f, 0x8b,
	0xa2, 0x3f, 0x2d, 0xb8, 0x57, 0x54, 0x21, 0xe5, 0x09, 0x49, 0x93, 0x3f, 0x88, 0xc2, 0x37, 0x89,
	0xa8, 0x69, 0xdb, 0x4f, 0x3f, 0xaa, 0x28, 0x77, 0x85, 0xf6, 0xb2, 0x70, 0x97, 0x7c, 0xe8, 0xfb,
	0xe9, 0x9b, 0x4b, 0x6f, 0x06, 0x8f, 0x4b, 0xe1, 0x52, 0xf7, 0xbd, 0x1a, 0xdd, 0x1d, 0x26, 0xa7,
	0x39, 0x67, 0xbf, 0xd2, 0x50, 0x0a, 0xbc, 0x2a, 0xa2, 0x35, 0x4e, 0x59, 0xa8, 0x45, 0x05, 0x5e,
	0x95, 0xe1, 0x1a, 0x0b, 0x43, 0x10, 0x78, 0x55, 0x44, 0xeb, 0xfe, 0x11, 0x1c, 0x9a, 0x9e, 0x7b,
	0xf0, 0xb7, 0x05, 0xb0, 0xcd, 0xea, 0x07, 0x27, 0xd4, 0xe9, 0xea, 0xd2, 0x7b, 0x07, 0x8f, 0xaa,
	0xd8, 0x33, 0x42, 0xdf, 0x5e, 0xdf, 0x5d, 0xf1, 0xb3, 0x50, 0x88, 0x0e, 0xd6, 0x8f, 0xbf, 0x02,
	0xd8, 0x8e, 0x28, 0x74, 0x0f, 0xee, 0x9c, 0x79, 0x63, 0x2f, 0x18, 0x0c, 0xfd, 0x97, 0xde, 0x38,
	0x78, 0xf5, 0xfd, 0xf9, 0xe8, 0xf9, 0xb3, 0x17, 0x83, 0x17, 0xcf, 0xcf, 0x5a, 0x37, 0xd0, 0x11,
	0x1c, 0x78, 0x3f, 0xfa, 0xc3, 0x96, 0x85, 0x1a, 0x50, 0xf7, 0x7c, 0x7f, 0xf8, 0xba, 0x75, 0xb3,
	0x7f, 0x61, 0x5d, 0x7a, 0xaf, 0xae, 0xe8, 0x7c, 0xf4, 0xe5, 0xff, 0x38, 0x56, 0x73, 0x50, 0x50,
	0x05, 0x15, 0xd1, 0x1a, 0xeb, 0xbe, 0x15, 0x78, 0xa5, 0x9f, 0x6b, 0x78, 0x14, 0xb2, 0xac, 0x5a,
	0x6d, 0xf4, 0x6d, 0x73, 0x35, 0x23, 0x55, 0xf8, 0x23, 0xeb, 0xe7, 0xef, 0x0a, 0x56, 0xcc, 0x52,
	0x32, 0x8f, 0x5d, 0xc6, 0x63, 0x1c, 0xd3, 0xb9, 0x6e, 0x0b, 0xbc, 0x35, 0x78, 0xc5, 0xef, 0xe8,
	0x49, 0xf1, 0x3e, 0x39, 0xd4, 0xc4, 0x2f, 0xfe, 0x0b, 0x00, 0x00, 0xff, 0xff, 0x17, 0xf6, 0xa1,
	0x7d, 0x90, 0x07, 0x00, 0x00,
}
