// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/datalabeling/v1beta1/dataset.proto

package datalabeling

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type DataType int32

const (
	DataType_DATA_TYPE_UNSPECIFIED DataType = 0
	// Allowed for continuous evaluation.
	DataType_IMAGE DataType = 1
	DataType_VIDEO DataType = 2
	// Allowed for continuous evaluation.
	DataType_TEXT DataType = 4
	// Allowed for continuous evaluation.
	DataType_GENERAL_DATA DataType = 6
)

var DataType_name = map[int32]string{
	0: "DATA_TYPE_UNSPECIFIED",
	1: "IMAGE",
	2: "VIDEO",
	4: "TEXT",
	6: "GENERAL_DATA",
}

var DataType_value = map[string]int32{
	"DATA_TYPE_UNSPECIFIED": 0,
	"IMAGE":                 1,
	"VIDEO":                 2,
	"TEXT":                  4,
	"GENERAL_DATA":          6,
}

func (x DataType) String() string {
	return proto.EnumName(DataType_name, int32(x))
}

func (DataType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_70a9435b8b2ad223, []int{0}
}

// Dataset is the resource to hold your data. You can request multiple labeling
// tasks for a dataset while each one will generate an AnnotatedDataset.
type Dataset struct {
	// Output only. Dataset resource name, format is:
	// projects/{project_id}/datasets/{dataset_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The display name of the dataset. Maximum of 64 characters.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. User-provided description of the annotation specification set.
	// The description can be up to 10000 characters long.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Time the dataset is created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. This is populated with the original input configs
	// where ImportData is called. It is available only after the clients
	// import data to this dataset.
	InputConfigs []*InputConfig `protobuf:"bytes,5,rep,name=input_configs,json=inputConfigs,proto3" json:"input_configs,omitempty"`
	// Output only. The names of any related resources that are blocking changes
	// to the dataset.
	BlockingResources []string `protobuf:"bytes,6,rep,name=blocking_resources,json=blockingResources,proto3" json:"blocking_resources,omitempty"`
	// Output only. The number of data items in the dataset.
	DataItemCount        int64    `protobuf:"varint,7,opt,name=data_item_count,json=dataItemCount,proto3" json:"data_item_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Dataset) Reset()         { *m = Dataset{} }
func (m *Dataset) String() string { return proto.CompactTextString(m) }
func (*Dataset) ProtoMessage()    {}
func (*Dataset) Descriptor() ([]byte, []int) {
	return fileDescriptor_70a9435b8b2ad223, []int{0}
}

func (m *Dataset) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Dataset.Unmarshal(m, b)
}
func (m *Dataset) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Dataset.Marshal(b, m, deterministic)
}
func (m *Dataset) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Dataset.Merge(m, src)
}
func (m *Dataset) XXX_Size() int {
	return xxx_messageInfo_Dataset.Size(m)
}
func (m *Dataset) XXX_DiscardUnknown() {
	xxx_messageInfo_Dataset.DiscardUnknown(m)
}

var xxx_messageInfo_Dataset proto.InternalMessageInfo

func (m *Dataset) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Dataset) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Dataset) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Dataset) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Dataset) GetInputConfigs() []*InputConfig {
	if m != nil {
		return m.InputConfigs
	}
	return nil
}

func (m *Dataset) GetBlockingResources() []string {
	if m != nil {
		return m.BlockingResources
	}
	return nil
}

func (m *Dataset) GetDataItemCount() int64 {
	if m != nil {
		return m.DataItemCount
	}
	return 0
}

// The configuration of input data, including data type, location, etc.
type InputConfig struct {
	// Optional. The metadata associated with each data type.
	//
	// Types that are valid to be assigned to DataTypeMetadata:
	//	*InputConfig_TextMetadata
	DataTypeMetadata isInputConfig_DataTypeMetadata `protobuf_oneof:"data_type_metadata"`
	// Required. Where the data is from.
	//
	// Types that are valid to be assigned to Source:
	//	*InputConfig_GcsSource
	//	*InputConfig_BigquerySource
	Source isInputConfig_Source `protobuf_oneof:"source"`
	// Required. Data type must be specifed when user tries to import data.
	DataType DataType `protobuf:"varint,1,opt,name=data_type,json=dataType,proto3,enum=google.cloud.datalabeling.v1beta1.DataType" json:"data_type,omitempty"`
	// Optional. The type of annotation to be performed on this data. You must
	// specify this field if you are using this InputConfig in an
	// [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob].
	AnnotationType AnnotationType `protobuf:"varint,3,opt,name=annotation_type,json=annotationType,proto3,enum=google.cloud.datalabeling.v1beta1.AnnotationType" json:"annotation_type,omitempty"`
	// Optional. Metadata about annotations for the input. You must specify this
	// field if you are using this InputConfig in an [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob] for a
	// model version that performs classification.
	ClassificationMetadata *ClassificationMetadata `protobuf:"bytes,4,opt,name=classification_metadata,json=classificationMetadata,proto3" json:"classification_metadata,omitempty"`
	XXX_NoUnkeyedLiteral   struct{}                `json:"-"`
	XXX_unrecognized       []byte                  `json:"-"`
	XXX_sizecache          int32                   `json:"-"`
}

func (m *InputConfig) Reset()         { *m = InputConfig{} }
func (m *InputConfig) String() string { return proto.CompactTextString(m) }
func (*InputConfig) ProtoMessage()    {}
func (*InputConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_70a9435b8b2ad223, []int{1}
}

func (m *InputConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InputConfig.Unmarshal(m, b)
}
func (m *InputConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InputConfig.Marshal(b, m, deterministic)
}
func (m *InputConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InputConfig.Merge(m, src)
}
func (m *InputConfig) XXX_Size() int {
	return xxx_messageInfo_InputConfig.Size(m)
}
func (m *InputConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_InputConfig.DiscardUnknown(m)
}

var xxx_messageInfo_InputConfig proto.InternalMessageInfo

type isInputConfig_DataTypeMetadata interface {
	isInputConfig_DataTypeMetadata()
}

type InputConfig_TextMetadata struct {
	TextMetadata *TextMetadata `protobuf:"bytes,6,opt,name=text_metadata,json=textMetadata,proto3,oneof"`
}

func (*InputConfig_TextMetadata) isInputConfig_DataTypeMetadata() {}

func (m *InputConfig) GetDataTypeMetadata() isInputConfig_DataTypeMetadata {
	if m != nil {
		return m.DataTypeMetadata
	}
	return nil
}

func (m *InputConfig) GetTextMetadata() *TextMetadata {
	if x, ok := m.GetDataTypeMetadata().(*InputConfig_TextMetadata); ok {
		return x.TextMetadata
	}
	return nil
}

type isInputConfig_Source interface {
	isInputConfig_Source()
}

type InputConfig_GcsSource struct {
	GcsSource *GcsSource `protobuf:"bytes,2,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

type InputConfig_BigquerySource struct {
	BigquerySource *BigQuerySource `protobuf:"bytes,5,opt,name=bigquery_source,json=bigquerySource,proto3,oneof"`
}

func (*InputConfig_GcsSource) isInputConfig_Source() {}

func (*InputConfig_BigquerySource) isInputConfig_Source() {}

func (m *InputConfig) GetSource() isInputConfig_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *InputConfig) GetGcsSource() *GcsSource {
	if x, ok := m.GetSource().(*InputConfig_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

func (m *InputConfig) GetBigquerySource() *BigQuerySource {
	if x, ok := m.GetSource().(*InputConfig_BigquerySource); ok {
		return x.BigquerySource
	}
	return nil
}

func (m *InputConfig) GetDataType() DataType {
	if m != nil {
		return m.DataType
	}
	return DataType_DATA_TYPE_UNSPECIFIED
}

func (m *InputConfig) GetAnnotationType() AnnotationType {
	if m != nil {
		return m.AnnotationType
	}
	return AnnotationType_ANNOTATION_TYPE_UNSPECIFIED
}

func (m *InputConfig) GetClassificationMetadata() *ClassificationMetadata {
	if m != nil {
		return m.ClassificationMetadata
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*InputConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*InputConfig_TextMetadata)(nil),
		(*InputConfig_GcsSource)(nil),
		(*InputConfig_BigquerySource)(nil),
	}
}

// Metadata for the text.
type TextMetadata struct {
	// The language of this text, as a
	// [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
	// Default value is en-US.
	LanguageCode         string   `protobuf:"bytes,1,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TextMetadata) Reset()         { *m = TextMetadata{} }
func (m *TextMetadata) String() string { return proto.CompactTextString(m) }
func (*TextMetadata) ProtoMessage()    {}
func (*TextMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_70a9435b8b2ad223, []int{2}
}

func (m *TextMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TextMetadata.Unmarshal(m, b)
}
func (m *TextMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TextMetadata.Marshal(b, m, deterministic)
}
func (m *TextMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TextMetadata.Merge(m, src)
}
func (m *TextMetadata) XXX_Size() int {
	return xxx_messageInfo_TextMetadata.Size(m)
}
func (m *TextMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_TextMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_TextMetadata proto.InternalMessageInfo

func (m *TextMetadata) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// Metadata for classification annotations.
type ClassificationMetadata struct {
	// Whether the classification task is multi-label or not.
	IsMultiLabel         bool     `protobuf:"varint,1,opt,name=is_multi_label,json=isMultiLabel,proto3" json:"is_multi_label,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ClassificationMetadata) Reset()         { *m = ClassificationMetadata{} }
func (m *ClassificationMetadata) String() string { return proto.CompactTextString(m) }
func (*ClassificationMetadata) ProtoMessage()    {}
func (*ClassificationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_70a9435b8b2ad223, []int{3}
}

func (m *ClassificationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClassificationMetadata.Unmarshal(m, b)
}
func (m *ClassificationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClassificationMetadata.Marshal(b, m, deterministic)
}
func (m *ClassificationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClassificationMetadata.Merge(m, src)
}
func (m *ClassificationMetadata) XXX_Size() int {
	return xxx_messageInfo_ClassificationMetadata.Size(m)
}
func (m *ClassificationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ClassificationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ClassificationMetadata proto.InternalMessageInfo

func (m *ClassificationMetadata) GetIsMultiLabel() bool {
	if m != nil {
		return m.IsMultiLabel
	}
	return false
}

// Source of the Cloud Storage file to be imported.
type GcsSource struct {
	// Required. The input URI of source file. This must be a Cloud Storage path
	// (`gs://...`).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// Required. The format of the source file. Only "text/csv" is supported.
	MimeType             string   `protobuf:"bytes,2,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GcsSource) Reset()         { *m = GcsSource{} }
func (m *GcsSource) String() string { return proto.CompactTextString(m) }
func (*GcsSource) ProtoMessage()    {}
func (*GcsSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_70a9435b8b2ad223, []int{4}
}

func (m *GcsSource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GcsSource.Unmarshal(m, b)
}
func (m *GcsSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GcsSource.Marshal(b, m, deterministic)
}
func (m *GcsSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GcsSource.Merge(m, src)
}
func (m *GcsSource) XXX_Size() int {
	return xxx_messageInfo_GcsSource.Size(m)
}
func (m *GcsSource) XXX_DiscardUnknown() {
	xxx_messageInfo_GcsSource.DiscardUnknown(m)
}

var xxx_messageInfo_GcsSource proto.InternalMessageInfo

func (m *GcsSource) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *GcsSource) GetMimeType() string {
	if m != nil {
		return m.MimeType
	}
	return ""
}

// The BigQuery location for input data. If used in an [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob], this
// is where the service saves the prediction input and output sampled from the
// model version.
type BigQuerySource struct {
	// Required. BigQuery URI to a table, up to 2,000 characters long. If you
	// specify the URI of a table that does not exist, Data Labeling Service
	// creates a table at the URI with the correct schema when you create your
	// [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob]. If you specify the URI of a table that already exists,
	// it must have the
	// [correct
	// schema](/ml-engine/docs/continuous-evaluation/create-job#table-schema).
	//
	// Provide the table URI in the following format:
	//
	// "bq://<var>{your_project_id}</var>/<var>{your_dataset_name}</var>/<var>{your_table_name}</var>"
	//
	// [Learn
	// more](/ml-engine/docs/continuous-evaluation/create-job#table-schema).
	InputUri             string   `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BigQuerySource) Reset()         { *m = BigQuerySource{} }
func (m *BigQuerySource) String() string { return proto.CompactTextString(m) }
func (*BigQuerySource) ProtoMessage()    {}
func (*BigQuerySource) Descriptor() ([]byte, []int) {
	return fileDescriptor_70a9435b8b2ad223, []int{5}
}

func (m *BigQuerySource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BigQuerySource.Unmarshal(m, b)
}
func (m *BigQuerySource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BigQuerySource.Marshal(b, m, deterministic)
}
func (m *BigQuerySource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BigQuerySource.Merge(m, src)
}
func (m *BigQuerySource) XXX_Size() int {
	return xxx_messageInfo_BigQuerySource.Size(m)
}
func (m *BigQuerySource) XXX_DiscardUnknown() {
	xxx_messageInfo_BigQuerySource.DiscardUnknown(m)
}

var xxx_messageInfo_BigQuerySource proto.InternalMessageInfo

func (m *BigQuerySource) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

// The configuration of output data.
type OutputConfig struct {
	// Required. Location to output data to.
	//
	// Types that are valid to be assigned to Destination:
	//	*OutputConfig_GcsDestination
	//	*OutputConfig_GcsFolderDestination
	Destination          isOutputConfig_Destination `protobuf_oneof:"destination"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *OutputConfig) Reset()         { *m = OutputConfig{} }
func (m *OutputConfig) String() string { return proto.CompactTextString(m) }
func (*OutputConfig) ProtoMessage()    {}
func (*OutputConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_70a9435b8b2ad223, []int{6}
}

func (m *OutputConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OutputConfig.Unmarshal(m, b)
}
func (m *OutputConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OutputConfig.Marshal(b, m, deterministic)
}
func (m *OutputConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OutputConfig.Merge(m, src)
}
func (m *OutputConfig) XXX_Size() int {
	return xxx_messageInfo_OutputConfig.Size(m)
}
func (m *OutputConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_OutputConfig.DiscardUnknown(m)
}

var xxx_messageInfo_OutputConfig proto.InternalMessageInfo

type isOutputConfig_Destination interface {
	isOutputConfig_Destination()
}

type OutputConfig_GcsDestination struct {
	GcsDestination *GcsDestination `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3,oneof"`
}

type OutputConfig_GcsFolderDestination struct {
	GcsFolderDestination *GcsFolderDestination `protobuf:"bytes,2,opt,name=gcs_folder_destination,json=gcsFolderDestination,proto3,oneof"`
}

func (*OutputConfig_GcsDestination) isOutputConfig_Destination() {}

func (*OutputConfig_GcsFolderDestination) isOutputConfig_Destination() {}

func (m *OutputConfig) GetDestination() isOutputConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (m *OutputConfig) GetGcsDestination() *GcsDestination {
	if x, ok := m.GetDestination().(*OutputConfig_GcsDestination); ok {
		return x.GcsDestination
	}
	return nil
}

func (m *OutputConfig) GetGcsFolderDestination() *GcsFolderDestination {
	if x, ok := m.GetDestination().(*OutputConfig_GcsFolderDestination); ok {
		return x.GcsFolderDestination
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*OutputConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*OutputConfig_GcsDestination)(nil),
		(*OutputConfig_GcsFolderDestination)(nil),
	}
}

// Export destination of the data.Only gcs path is allowed in
// output_uri.
type GcsDestination struct {
	// Required. The output uri of destination file.
	OutputUri string `protobuf:"bytes,1,opt,name=output_uri,json=outputUri,proto3" json:"output_uri,omitempty"`
	// Required. The format of the gcs destination. Only "text/csv" and
	// "application/json"
	// are supported.
	MimeType             string   `protobuf:"bytes,2,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GcsDestination) Reset()         { *m = GcsDestination{} }
func (m *GcsDestination) String() string { return proto.CompactTextString(m) }
func (*GcsDestination) ProtoMessage()    {}
func (*GcsDestination) Descriptor() ([]byte, []int) {
	return fileDescriptor_70a9435b8b2ad223, []int{7}
}

func (m *GcsDestination) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GcsDestination.Unmarshal(m, b)
}
func (m *GcsDestination) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GcsDestination.Marshal(b, m, deterministic)
}
func (m *GcsDestination) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GcsDestination.Merge(m, src)
}
func (m *GcsDestination) XXX_Size() int {
	return xxx_messageInfo_GcsDestination.Size(m)
}
func (m *GcsDestination) XXX_DiscardUnknown() {
	xxx_messageInfo_GcsDestination.DiscardUnknown(m)
}

var xxx_messageInfo_GcsDestination proto.InternalMessageInfo

func (m *GcsDestination) GetOutputUri() string {
	if m != nil {
		return m.OutputUri
	}
	return ""
}

func (m *GcsDestination) GetMimeType() string {
	if m != nil {
		return m.MimeType
	}
	return ""
}

// Export folder destination of the data.
type GcsFolderDestination struct {
	// Required. Cloud Storage directory to export data to.
	OutputFolderUri      string   `protobuf:"bytes,1,opt,name=output_folder_uri,json=outputFolderUri,proto3" json:"output_folder_uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GcsFolderDestination) Reset()         { *m = GcsFolderDestination{} }
func (m *GcsFolderDestination) String() string { return proto.CompactTextString(m) }
func (*GcsFolderDestination) ProtoMessage()    {}
func (*GcsFolderDestination) Descriptor() ([]byte, []int) {
	return fileDescriptor_70a9435b8b2ad223, []int{8}
}

func (m *GcsFolderDestination) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GcsFolderDestination.Unmarshal(m, b)
}
func (m *GcsFolderDestination) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GcsFolderDestination.Marshal(b, m, deterministic)
}
func (m *GcsFolderDestination) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GcsFolderDestination.Merge(m, src)
}
func (m *GcsFolderDestination) XXX_Size() int {
	return xxx_messageInfo_GcsFolderDestination.Size(m)
}
func (m *GcsFolderDestination) XXX_DiscardUnknown() {
	xxx_messageInfo_GcsFolderDestination.DiscardUnknown(m)
}

var xxx_messageInfo_GcsFolderDestination proto.InternalMessageInfo

func (m *GcsFolderDestination) GetOutputFolderUri() string {
	if m != nil {
		return m.OutputFolderUri
	}
	return ""
}

// DataItem is a piece of data, without annotation. For example, an image.
type DataItem struct {
	// Output only.
	//
	// Types that are valid to be assigned to Payload:
	//	*DataItem_ImagePayload
	//	*DataItem_TextPayload
	//	*DataItem_VideoPayload
	Payload isDataItem_Payload `protobuf_oneof:"payload"`
	// Output only. Name of the data item, in format of:
	// projects/{project_id}/datasets/{dataset_id}/dataItems/{data_item_id}
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DataItem) Reset()         { *m = DataItem{} }
func (m *DataItem) String() string { return proto.CompactTextString(m) }
func (*DataItem) ProtoMessage()    {}
func (*DataItem) Descriptor() ([]byte, []int) {
	return fileDescriptor_70a9435b8b2ad223, []int{9}
}

func (m *DataItem) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DataItem.Unmarshal(m, b)
}
func (m *DataItem) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DataItem.Marshal(b, m, deterministic)
}
func (m *DataItem) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DataItem.Merge(m, src)
}
func (m *DataItem) XXX_Size() int {
	return xxx_messageInfo_DataItem.Size(m)
}
func (m *DataItem) XXX_DiscardUnknown() {
	xxx_messageInfo_DataItem.DiscardUnknown(m)
}

var xxx_messageInfo_DataItem proto.InternalMessageInfo

type isDataItem_Payload interface {
	isDataItem_Payload()
}

type DataItem_ImagePayload struct {
	ImagePayload *ImagePayload `protobuf:"bytes,2,opt,name=image_payload,json=imagePayload,proto3,oneof"`
}

type DataItem_TextPayload struct {
	TextPayload *TextPayload `protobuf:"bytes,3,opt,name=text_payload,json=textPayload,proto3,oneof"`
}

type DataItem_VideoPayload struct {
	VideoPayload *VideoPayload `protobuf:"bytes,4,opt,name=video_payload,json=videoPayload,proto3,oneof"`
}

func (*DataItem_ImagePayload) isDataItem_Payload() {}

func (*DataItem_TextPayload) isDataItem_Payload() {}

func (*DataItem_VideoPayload) isDataItem_Payload() {}

func (m *DataItem) GetPayload() isDataItem_Payload {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *DataItem) GetImagePayload() *ImagePayload {
	if x, ok := m.GetPayload().(*DataItem_ImagePayload); ok {
		return x.ImagePayload
	}
	return nil
}

func (m *DataItem) GetTextPayload() *TextPayload {
	if x, ok := m.GetPayload().(*DataItem_TextPayload); ok {
		return x.TextPayload
	}
	return nil
}

func (m *DataItem) GetVideoPayload() *VideoPayload {
	if x, ok := m.GetPayload().(*DataItem_VideoPayload); ok {
		return x.VideoPayload
	}
	return nil
}

func (m *DataItem) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*DataItem) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*DataItem_ImagePayload)(nil),
		(*DataItem_TextPayload)(nil),
		(*DataItem_VideoPayload)(nil),
	}
}

// AnnotatedDataset is a set holding annotations for data in a Dataset. Each
// labeling task will generate an AnnotatedDataset under the Dataset that the
// task is requested for.
type AnnotatedDataset struct {
	// Output only. AnnotatedDataset resource name in format of:
	// projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/
	// {annotated_dataset_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The display name of the AnnotatedDataset. It is specified in
	// HumanAnnotationConfig when user starts a labeling task. Maximum of 64
	// characters.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. The description of the AnnotatedDataset. It is specified in
	// HumanAnnotationConfig when user starts a labeling task. Maximum of 10000
	// characters.
	Description string `protobuf:"bytes,9,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Source of the annotation.
	AnnotationSource AnnotationSource `protobuf:"varint,3,opt,name=annotation_source,json=annotationSource,proto3,enum=google.cloud.datalabeling.v1beta1.AnnotationSource" json:"annotation_source,omitempty"`
	// Output only. Type of the annotation. It is specified when starting labeling
	// task.
	AnnotationType AnnotationType `protobuf:"varint,8,opt,name=annotation_type,json=annotationType,proto3,enum=google.cloud.datalabeling.v1beta1.AnnotationType" json:"annotation_type,omitempty"`
	// Output only. Number of examples in the annotated dataset.
	ExampleCount int64 `protobuf:"varint,4,opt,name=example_count,json=exampleCount,proto3" json:"example_count,omitempty"`
	// Output only. Number of examples that have annotation in the annotated
	// dataset.
	CompletedExampleCount int64 `protobuf:"varint,5,opt,name=completed_example_count,json=completedExampleCount,proto3" json:"completed_example_count,omitempty"`
	// Output only. Per label statistics.
	LabelStats *LabelStats `protobuf:"bytes,6,opt,name=label_stats,json=labelStats,proto3" json:"label_stats,omitempty"`
	// Output only. Time the AnnotatedDataset was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Additional information about AnnotatedDataset.
	Metadata *AnnotatedDatasetMetadata `protobuf:"bytes,10,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Output only. The names of any related resources that are blocking changes
	// to the annotated dataset.
	BlockingResources    []string `protobuf:"bytes,11,rep,name=blocking_resources,json=blockingResources,proto3" json:"blocking_resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AnnotatedDataset) Reset()         { *m = AnnotatedDataset{} }
func (m *AnnotatedDataset) String() string { return proto.CompactTextString(m) }
func (*AnnotatedDataset) ProtoMessage()    {}
func (*AnnotatedDataset) Descriptor() ([]byte, []int) {
	return fileDescriptor_70a9435b8b2ad223, []int{10}
}

func (m *AnnotatedDataset) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotatedDataset.Unmarshal(m, b)
}
func (m *AnnotatedDataset) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotatedDataset.Marshal(b, m, deterministic)
}
func (m *AnnotatedDataset) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotatedDataset.Merge(m, src)
}
func (m *AnnotatedDataset) XXX_Size() int {
	return xxx_messageInfo_AnnotatedDataset.Size(m)
}
func (m *AnnotatedDataset) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotatedDataset.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotatedDataset proto.InternalMessageInfo

func (m *AnnotatedDataset) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *AnnotatedDataset) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *AnnotatedDataset) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *AnnotatedDataset) GetAnnotationSource() AnnotationSource {
	if m != nil {
		return m.AnnotationSource
	}
	return AnnotationSource_ANNOTATION_SOURCE_UNSPECIFIED
}

func (m *AnnotatedDataset) GetAnnotationType() AnnotationType {
	if m != nil {
		return m.AnnotationType
	}
	return AnnotationType_ANNOTATION_TYPE_UNSPECIFIED
}

func (m *AnnotatedDataset) GetExampleCount() int64 {
	if m != nil {
		return m.ExampleCount
	}
	return 0
}

func (m *AnnotatedDataset) GetCompletedExampleCount() int64 {
	if m != nil {
		return m.CompletedExampleCount
	}
	return 0
}

func (m *AnnotatedDataset) GetLabelStats() *LabelStats {
	if m != nil {
		return m.LabelStats
	}
	return nil
}

func (m *AnnotatedDataset) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *AnnotatedDataset) GetMetadata() *AnnotatedDatasetMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *AnnotatedDataset) GetBlockingResources() []string {
	if m != nil {
		return m.BlockingResources
	}
	return nil
}

// Statistics about annotation specs.
type LabelStats struct {
	// Map of each annotation spec's example count. Key is the annotation spec
	// name and value is the number of examples for that annotation spec.
	// If the annotated dataset does not have annotation spec, the map will return
	// a pair where the key is empty string and value is the total number of
	// annotations.
	ExampleCount         map[string]int64 `protobuf:"bytes,1,rep,name=example_count,json=exampleCount,proto3" json:"example_count,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *LabelStats) Reset()         { *m = LabelStats{} }
func (m *LabelStats) String() string { return proto.CompactTextString(m) }
func (*LabelStats) ProtoMessage()    {}
func (*LabelStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_70a9435b8b2ad223, []int{11}
}

func (m *LabelStats) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelStats.Unmarshal(m, b)
}
func (m *LabelStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelStats.Marshal(b, m, deterministic)
}
func (m *LabelStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelStats.Merge(m, src)
}
func (m *LabelStats) XXX_Size() int {
	return xxx_messageInfo_LabelStats.Size(m)
}
func (m *LabelStats) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelStats.DiscardUnknown(m)
}

var xxx_messageInfo_LabelStats proto.InternalMessageInfo

func (m *LabelStats) GetExampleCount() map[string]int64 {
	if m != nil {
		return m.ExampleCount
	}
	return nil
}

// Metadata on AnnotatedDataset.
type AnnotatedDatasetMetadata struct {
	// Specific request configuration used when requesting the labeling task.
	//
	// Types that are valid to be assigned to AnnotationRequestConfig:
	//	*AnnotatedDatasetMetadata_ImageClassificationConfig
	//	*AnnotatedDatasetMetadata_BoundingPolyConfig
	//	*AnnotatedDatasetMetadata_PolylineConfig
	//	*AnnotatedDatasetMetadata_SegmentationConfig
	//	*AnnotatedDatasetMetadata_VideoClassificationConfig
	//	*AnnotatedDatasetMetadata_ObjectDetectionConfig
	//	*AnnotatedDatasetMetadata_ObjectTrackingConfig
	//	*AnnotatedDatasetMetadata_EventConfig
	//	*AnnotatedDatasetMetadata_TextClassificationConfig
	//	*AnnotatedDatasetMetadata_TextEntityExtractionConfig
	AnnotationRequestConfig isAnnotatedDatasetMetadata_AnnotationRequestConfig `protobuf_oneof:"annotation_request_config"`
	// HumanAnnotationConfig used when requesting the human labeling task for this
	// AnnotatedDataset.
	HumanAnnotationConfig *HumanAnnotationConfig `protobuf:"bytes,1,opt,name=human_annotation_config,json=humanAnnotationConfig,proto3" json:"human_annotation_config,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}               `json:"-"`
	XXX_unrecognized      []byte                 `json:"-"`
	XXX_sizecache         int32                  `json:"-"`
}

func (m *AnnotatedDatasetMetadata) Reset()         { *m = AnnotatedDatasetMetadata{} }
func (m *AnnotatedDatasetMetadata) String() string { return proto.CompactTextString(m) }
func (*AnnotatedDatasetMetadata) ProtoMessage()    {}
func (*AnnotatedDatasetMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_70a9435b8b2ad223, []int{12}
}

func (m *AnnotatedDatasetMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotatedDatasetMetadata.Unmarshal(m, b)
}
func (m *AnnotatedDatasetMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotatedDatasetMetadata.Marshal(b, m, deterministic)
}
func (m *AnnotatedDatasetMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotatedDatasetMetadata.Merge(m, src)
}
func (m *AnnotatedDatasetMetadata) XXX_Size() int {
	return xxx_messageInfo_AnnotatedDatasetMetadata.Size(m)
}
func (m *AnnotatedDatasetMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotatedDatasetMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotatedDatasetMetadata proto.InternalMessageInfo

type isAnnotatedDatasetMetadata_AnnotationRequestConfig interface {
	isAnnotatedDatasetMetadata_AnnotationRequestConfig()
}

type AnnotatedDatasetMetadata_ImageClassificationConfig struct {
	ImageClassificationConfig *ImageClassificationConfig `protobuf:"bytes,2,opt,name=image_classification_config,json=imageClassificationConfig,proto3,oneof"`
}

type AnnotatedDatasetMetadata_BoundingPolyConfig struct {
	BoundingPolyConfig *BoundingPolyConfig `protobuf:"bytes,3,opt,name=bounding_poly_config,json=boundingPolyConfig,proto3,oneof"`
}

type AnnotatedDatasetMetadata_PolylineConfig struct {
	PolylineConfig *PolylineConfig `protobuf:"bytes,4,opt,name=polyline_config,json=polylineConfig,proto3,oneof"`
}

type AnnotatedDatasetMetadata_SegmentationConfig struct {
	SegmentationConfig *SegmentationConfig `protobuf:"bytes,5,opt,name=segmentation_config,json=segmentationConfig,proto3,oneof"`
}

type AnnotatedDatasetMetadata_VideoClassificationConfig struct {
	VideoClassificationConfig *VideoClassificationConfig `protobuf:"bytes,6,opt,name=video_classification_config,json=videoClassificationConfig,proto3,oneof"`
}

type AnnotatedDatasetMetadata_ObjectDetectionConfig struct {
	ObjectDetectionConfig *ObjectDetectionConfig `protobuf:"bytes,7,opt,name=object_detection_config,json=objectDetectionConfig,proto3,oneof"`
}

type AnnotatedDatasetMetadata_ObjectTrackingConfig struct {
	ObjectTrackingConfig *ObjectTrackingConfig `protobuf:"bytes,8,opt,name=object_tracking_config,json=objectTrackingConfig,proto3,oneof"`
}

type AnnotatedDatasetMetadata_EventConfig struct {
	EventConfig *EventConfig `protobuf:"bytes,9,opt,name=event_config,json=eventConfig,proto3,oneof"`
}

type AnnotatedDatasetMetadata_TextClassificationConfig struct {
	TextClassificationConfig *TextClassificationConfig `protobuf:"bytes,10,opt,name=text_classification_config,json=textClassificationConfig,proto3,oneof"`
}

type AnnotatedDatasetMetadata_TextEntityExtractionConfig struct {
	TextEntityExtractionConfig *TextEntityExtractionConfig `protobuf:"bytes,11,opt,name=text_entity_extraction_config,json=textEntityExtractionConfig,proto3,oneof"`
}

func (*AnnotatedDatasetMetadata_ImageClassificationConfig) isAnnotatedDatasetMetadata_AnnotationRequestConfig() {
}

func (*AnnotatedDatasetMetadata_BoundingPolyConfig) isAnnotatedDatasetMetadata_AnnotationRequestConfig() {
}

func (*AnnotatedDatasetMetadata_PolylineConfig) isAnnotatedDatasetMetadata_AnnotationRequestConfig() {}

func (*AnnotatedDatasetMetadata_SegmentationConfig) isAnnotatedDatasetMetadata_AnnotationRequestConfig() {
}

func (*AnnotatedDatasetMetadata_VideoClassificationConfig) isAnnotatedDatasetMetadata_AnnotationRequestConfig() {
}

func (*AnnotatedDatasetMetadata_ObjectDetectionConfig) isAnnotatedDatasetMetadata_AnnotationRequestConfig() {
}

func (*AnnotatedDatasetMetadata_ObjectTrackingConfig) isAnnotatedDatasetMetadata_AnnotationRequestConfig() {
}

func (*AnnotatedDatasetMetadata_EventConfig) isAnnotatedDatasetMetadata_AnnotationRequestConfig() {}

func (*AnnotatedDatasetMetadata_TextClassificationConfig) isAnnotatedDatasetMetadata_AnnotationRequestConfig() {
}

func (*AnnotatedDatasetMetadata_TextEntityExtractionConfig) isAnnotatedDatasetMetadata_AnnotationRequestConfig() {
}

func (m *AnnotatedDatasetMetadata) GetAnnotationRequestConfig() isAnnotatedDatasetMetadata_AnnotationRequestConfig {
	if m != nil {
		return m.AnnotationRequestConfig
	}
	return nil
}

func (m *AnnotatedDatasetMetadata) GetImageClassificationConfig() *ImageClassificationConfig {
	if x, ok := m.GetAnnotationRequestConfig().(*AnnotatedDatasetMetadata_ImageClassificationConfig); ok {
		return x.ImageClassificationConfig
	}
	return nil
}

func (m *AnnotatedDatasetMetadata) GetBoundingPolyConfig() *BoundingPolyConfig {
	if x, ok := m.GetAnnotationRequestConfig().(*AnnotatedDatasetMetadata_BoundingPolyConfig); ok {
		return x.BoundingPolyConfig
	}
	return nil
}

func (m *AnnotatedDatasetMetadata) GetPolylineConfig() *PolylineConfig {
	if x, ok := m.GetAnnotationRequestConfig().(*AnnotatedDatasetMetadata_PolylineConfig); ok {
		return x.PolylineConfig
	}
	return nil
}

func (m *AnnotatedDatasetMetadata) GetSegmentationConfig() *SegmentationConfig {
	if x, ok := m.GetAnnotationRequestConfig().(*AnnotatedDatasetMetadata_SegmentationConfig); ok {
		return x.SegmentationConfig
	}
	return nil
}

func (m *AnnotatedDatasetMetadata) GetVideoClassificationConfig() *VideoClassificationConfig {
	if x, ok := m.GetAnnotationRequestConfig().(*AnnotatedDatasetMetadata_VideoClassificationConfig); ok {
		return x.VideoClassificationConfig
	}
	return nil
}

func (m *AnnotatedDatasetMetadata) GetObjectDetectionConfig() *ObjectDetectionConfig {
	if x, ok := m.GetAnnotationRequestConfig().(*AnnotatedDatasetMetadata_ObjectDetectionConfig); ok {
		return x.ObjectDetectionConfig
	}
	return nil
}

func (m *AnnotatedDatasetMetadata) GetObjectTrackingConfig() *ObjectTrackingConfig {
	if x, ok := m.GetAnnotationRequestConfig().(*AnnotatedDatasetMetadata_ObjectTrackingConfig); ok {
		return x.ObjectTrackingConfig
	}
	return nil
}

func (m *AnnotatedDatasetMetadata) GetEventConfig() *EventConfig {
	if x, ok := m.GetAnnotationRequestConfig().(*AnnotatedDatasetMetadata_EventConfig); ok {
		return x.EventConfig
	}
	return nil
}

func (m *AnnotatedDatasetMetadata) GetTextClassificationConfig() *TextClassificationConfig {
	if x, ok := m.GetAnnotationRequestConfig().(*AnnotatedDatasetMetadata_TextClassificationConfig); ok {
		return x.TextClassificationConfig
	}
	return nil
}

func (m *AnnotatedDatasetMetadata) GetTextEntityExtractionConfig() *TextEntityExtractionConfig {
	if x, ok := m.GetAnnotationRequestConfig().(*AnnotatedDatasetMetadata_TextEntityExtractionConfig); ok {
		return x.TextEntityExtractionConfig
	}
	return nil
}

func (m *AnnotatedDatasetMetadata) GetHumanAnnotationConfig() *HumanAnnotationConfig {
	if m != nil {
		return m.HumanAnnotationConfig
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*AnnotatedDatasetMetadata) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*AnnotatedDatasetMetadata_ImageClassificationConfig)(nil),
		(*AnnotatedDatasetMetadata_BoundingPolyConfig)(nil),
		(*AnnotatedDatasetMetadata_PolylineConfig)(nil),
		(*AnnotatedDatasetMetadata_SegmentationConfig)(nil),
		(*AnnotatedDatasetMetadata_VideoClassificationConfig)(nil),
		(*AnnotatedDatasetMetadata_ObjectDetectionConfig)(nil),
		(*AnnotatedDatasetMetadata_ObjectTrackingConfig)(nil),
		(*AnnotatedDatasetMetadata_EventConfig)(nil),
		(*AnnotatedDatasetMetadata_TextClassificationConfig)(nil),
		(*AnnotatedDatasetMetadata_TextEntityExtractionConfig)(nil),
	}
}

// An Example is a piece of data and its annotation. For example, an image with
// label "house".
type Example struct {
	// Output only. The data part of Example.
	//
	// Types that are valid to be assigned to Payload:
	//	*Example_ImagePayload
	//	*Example_TextPayload
	//	*Example_VideoPayload
	Payload isExample_Payload `protobuf_oneof:"payload"`
	// Output only. Name of the example, in format of:
	// projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/
	// {annotated_dataset_id}/examples/{example_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Annotations for the piece of data in Example.
	// One piece of data can have multiple annotations.
	Annotations          []*Annotation `protobuf:"bytes,5,rep,name=annotations,proto3" json:"annotations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *Example) Reset()         { *m = Example{} }
func (m *Example) String() string { return proto.CompactTextString(m) }
func (*Example) ProtoMessage()    {}
func (*Example) Descriptor() ([]byte, []int) {
	return fileDescriptor_70a9435b8b2ad223, []int{13}
}

func (m *Example) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Example.Unmarshal(m, b)
}
func (m *Example) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Example.Marshal(b, m, deterministic)
}
func (m *Example) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Example.Merge(m, src)
}
func (m *Example) XXX_Size() int {
	return xxx_messageInfo_Example.Size(m)
}
func (m *Example) XXX_DiscardUnknown() {
	xxx_messageInfo_Example.DiscardUnknown(m)
}

var xxx_messageInfo_Example proto.InternalMessageInfo

type isExample_Payload interface {
	isExample_Payload()
}

type Example_ImagePayload struct {
	ImagePayload *ImagePayload `protobuf:"bytes,2,opt,name=image_payload,json=imagePayload,proto3,oneof"`
}

type Example_TextPayload struct {
	TextPayload *TextPayload `protobuf:"bytes,6,opt,name=text_payload,json=textPayload,proto3,oneof"`
}

type Example_VideoPayload struct {
	VideoPayload *VideoPayload `protobuf:"bytes,7,opt,name=video_payload,json=videoPayload,proto3,oneof"`
}

func (*Example_ImagePayload) isExample_Payload() {}

func (*Example_TextPayload) isExample_Payload() {}

func (*Example_VideoPayload) isExample_Payload() {}

func (m *Example) GetPayload() isExample_Payload {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *Example) GetImagePayload() *ImagePayload {
	if x, ok := m.GetPayload().(*Example_ImagePayload); ok {
		return x.ImagePayload
	}
	return nil
}

func (m *Example) GetTextPayload() *TextPayload {
	if x, ok := m.GetPayload().(*Example_TextPayload); ok {
		return x.TextPayload
	}
	return nil
}

func (m *Example) GetVideoPayload() *VideoPayload {
	if x, ok := m.GetPayload().(*Example_VideoPayload); ok {
		return x.VideoPayload
	}
	return nil
}

func (m *Example) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Example) GetAnnotations() []*Annotation {
	if m != nil {
		return m.Annotations
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Example) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Example_ImagePayload)(nil),
		(*Example_TextPayload)(nil),
		(*Example_VideoPayload)(nil),
	}
}

func init() {
	proto.RegisterEnum("google.cloud.datalabeling.v1beta1.DataType", DataType_name, DataType_value)
	proto.RegisterType((*Dataset)(nil), "google.cloud.datalabeling.v1beta1.Dataset")
	proto.RegisterType((*InputConfig)(nil), "google.cloud.datalabeling.v1beta1.InputConfig")
	proto.RegisterType((*TextMetadata)(nil), "google.cloud.datalabeling.v1beta1.TextMetadata")
	proto.RegisterType((*ClassificationMetadata)(nil), "google.cloud.datalabeling.v1beta1.ClassificationMetadata")
	proto.RegisterType((*GcsSource)(nil), "google.cloud.datalabeling.v1beta1.GcsSource")
	proto.RegisterType((*BigQuerySource)(nil), "google.cloud.datalabeling.v1beta1.BigQuerySource")
	proto.RegisterType((*OutputConfig)(nil), "google.cloud.datalabeling.v1beta1.OutputConfig")
	proto.RegisterType((*GcsDestination)(nil), "google.cloud.datalabeling.v1beta1.GcsDestination")
	proto.RegisterType((*GcsFolderDestination)(nil), "google.cloud.datalabeling.v1beta1.GcsFolderDestination")
	proto.RegisterType((*DataItem)(nil), "google.cloud.datalabeling.v1beta1.DataItem")
	proto.RegisterType((*AnnotatedDataset)(nil), "google.cloud.datalabeling.v1beta1.AnnotatedDataset")
	proto.RegisterType((*LabelStats)(nil), "google.cloud.datalabeling.v1beta1.LabelStats")
	proto.RegisterMapType((map[string]int64)(nil), "google.cloud.datalabeling.v1beta1.LabelStats.ExampleCountEntry")
	proto.RegisterType((*AnnotatedDatasetMetadata)(nil), "google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata")
	proto.RegisterType((*Example)(nil), "google.cloud.datalabeling.v1beta1.Example")
}

func init() {
	proto.RegisterFile("google/cloud/datalabeling/v1beta1/dataset.proto", fileDescriptor_70a9435b8b2ad223)
}

var fileDescriptor_70a9435b8b2ad223 = []byte{
	// 1611 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x58, 0xef, 0x6e, 0xdb, 0x46,
	0x12, 0xb7, 0x22, 0x59, 0x96, 0x46, 0xb2, 0x2c, 0xef, 0xd9, 0x89, 0xec, 0x5c, 0x70, 0x8e, 0x92,
	0x1c, 0x8c, 0x5c, 0x2c, 0x22, 0x0e, 0x72, 0x97, 0xb3, 0xef, 0x1a, 0x48, 0xb6, 0x62, 0x1b, 0xf5,
	0xbf, 0xd2, 0x4a, 0xd2, 0x06, 0x41, 0x59, 0x8a, 0x5c, 0x33, 0x6c, 0x28, 0x2e, 0x43, 0xae, 0x0c,
	0x0b, 0x46, 0xf2, 0xa1, 0x40, 0x3f, 0xb4, 0x0f, 0x50, 0x14, 0x68, 0xdf, 0xa2, 0xaf, 0xd1, 0x27,
	0x31, 0xfa, 0x10, 0xc5, 0xfe, 0x21, 0x45, 0xd9, 0x92, 0x4d, 0x03, 0x49, 0xbf, 0xed, 0xce, 0xee,
	0xef, 0x37, 0xb3, 0x3b, 0xb3, 0x33, 0x43, 0x82, 0x62, 0x11, 0x62, 0x39, 0x58, 0x31, 0x1c, 0xd2,
	0x35, 0x15, 0x53, 0xa7, 0xba, 0xa3, 0xb7, 0xb1, 0x63, 0xbb, 0x96, 0x72, 0xf4, 0xb0, 0x8d, 0xa9,
	0xfe, 0x90, 0x0b, 0x03, 0x4c, 0x6b, 0x9e, 0x4f, 0x28, 0x41, 0xb7, 0x05, 0xa0, 0xc6, 0x01, 0xb5,
	0x38, 0xa0, 0x26, 0x01, 0xf3, 0x7f, 0x97, 0x9c, 0xba, 0x67, 0x2b, 0xba, 0xeb, 0x12, 0xaa, 0x53,
	0x9b, 0xb8, 0x81, 0x20, 0x98, 0x9f, 0x8b, 0xad, 0xfa, 0x38, 0x20, 0x5d, 0xdf, 0xc0, 0x72, 0x69,
	0xf9, 0x72, 0x63, 0xfa, 0x7c, 0x12, 0xb3, 0x7a, 0x15, 0x8c, 0x16, 0x78, 0xd8, 0xd0, 0xa2, 0xc3,
	0xcc, 0x3f, 0x4e, 0x76, 0x7a, 0xcd, 0xd3, 0x7b, 0x0e, 0xd1, 0xcd, 0xf0, 0x08, 0x4f, 0x2f, 0x87,
	0xbd, 0xe9, 0x76, 0x74, 0x57, 0x8b, 0x69, 0x36, 0x88, 0x7b, 0x68, 0x5b, 0x92, 0xe0, 0x1f, 0x92,
	0x80, 0xcf, 0xda, 0xdd, 0x43, 0x85, 0xda, 0x1d, 0x1c, 0x50, 0xbd, 0xe3, 0x89, 0x0d, 0xd5, 0x5f,
	0xd3, 0x30, 0xb1, 0x2e, 0xee, 0x1d, 0x21, 0xc8, 0xb8, 0x7a, 0x07, 0x57, 0x52, 0x0b, 0xa9, 0xc5,
	0xbc, 0xca, 0xc7, 0xe8, 0x36, 0x14, 0x4d, 0x3b, 0xf0, 0x1c, 0xbd, 0xa7, 0xf1, 0xb5, 0x6b, 0x7c,
	0xad, 0x20, 0x65, 0xbb, 0x6c, 0xcb, 0x02, 0x14, 0x4c, 0x1c, 0x18, 0xbe, 0xed, 0x31, 0xfd, 0x95,
	0xb4, 0xdc, 0xd1, 0x17, 0xa1, 0x55, 0x28, 0x18, 0x3e, 0xd6, 0x29, 0xd6, 0x98, 0xfa, 0x4a, 0x66,
	0x21, 0xb5, 0x58, 0x58, 0x9e, 0xaf, 0x49, 0x07, 0x87, 0xb6, 0xd5, 0x5a, 0xa1, 0x6d, 0x2a, 0x88,
	0xed, 0x4c, 0x80, 0x0e, 0x60, 0xd2, 0x76, 0xbd, 0x2e, 0x95, 0x07, 0x0b, 0x2a, 0xe3, 0x0b, 0xe9,
	0xc5, 0xc2, 0x72, 0xad, 0x76, 0x69, 0x7c, 0xd4, 0xb6, 0x18, 0x6e, 0x8d, 0xc3, 0xd4, 0xa2, 0xdd,
	0x9f, 0x04, 0x68, 0x09, 0x50, 0xdb, 0x21, 0xc6, 0x5b, 0xdb, 0xb5, 0xb4, 0x30, 0x36, 0x82, 0x4a,
	0x76, 0x21, 0xbd, 0x98, 0x57, 0xa7, 0xc3, 0x15, 0x35, 0x5c, 0x40, 0xff, 0x84, 0x29, 0xee, 0x1e,
	0x9b, 0xe2, 0x8e, 0x66, 0x90, 0xae, 0x4b, 0x2b, 0x13, 0x0b, 0xa9, 0xc5, 0xb4, 0x3a, 0xc9, 0xc4,
	0x5b, 0x14, 0x77, 0xd6, 0x98, 0x70, 0x65, 0xef, 0xb4, 0xbe, 0x0d, 0x77, 0x06, 0x6c, 0x11, 0x56,
	0xea, 0x9e, 0x1d, 0xd4, 0x0c, 0xd2, 0x51, 0xc2, 0xbb, 0xbe, 0xe7, 0xf9, 0xe4, 0x5b, 0x6c, 0xd0,
	0x40, 0x39, 0x91, 0xa3, 0xf7, 0x61, 0xfc, 0x07, 0xca, 0x89, 0x1c, 0xbd, 0xaf, 0xfe, 0x9e, 0x81,
	0x42, 0xec, 0x14, 0xe8, 0x05, 0x4c, 0x52, 0x7c, 0x4c, 0xb5, 0x0e, 0xa6, 0x3a, 0xdb, 0x54, 0xc9,
	0xf2, 0xbb, 0x54, 0x12, 0x5c, 0x46, 0x0b, 0x1f, 0xd3, 0x1d, 0x09, 0xdb, 0x1c, 0x53, 0x8b, 0x34,
	0x36, 0x47, 0x3b, 0x00, 0x96, 0x11, 0x68, 0xe2, 0xbc, 0xdc, 0xc9, 0x85, 0xe5, 0x07, 0x09, 0x48,
	0x37, 0x8c, 0xe0, 0x80, 0x63, 0x36, 0x53, 0x6a, 0xde, 0x0a, 0x27, 0xe8, 0x35, 0x4c, 0xb5, 0x6d,
	0xeb, 0x5d, 0x17, 0xfb, 0xbd, 0x90, 0x73, 0x9c, 0x73, 0x3e, 0x4c, 0xc0, 0xd9, 0xb0, 0xad, 0x2f,
	0x18, 0x32, 0x22, 0x2e, 0x85, 0x5c, 0x92, 0x7d, 0x13, 0xf2, 0xdc, 0x1b, 0xb4, 0xe7, 0x89, 0x60,
	0x2d, 0x2d, 0xff, 0x2b, 0x01, 0x2f, 0xbb, 0xfa, 0x56, 0xcf, 0xc3, 0x6a, 0xce, 0x94, 0x23, 0xf4,
	0x0a, 0xa6, 0x62, 0x2f, 0x87, 0xf3, 0xa5, 0x39, 0x5f, 0x12, 0x3b, 0xeb, 0x11, 0x92, 0xb3, 0x96,
	0xf4, 0x81, 0x39, 0xf2, 0xe1, 0x86, 0xe1, 0xe8, 0x41, 0x60, 0x1f, 0xda, 0x86, 0xe0, 0x8f, 0x9c,
	0x26, 0x1e, 0xc0, 0x7f, 0x13, 0xe8, 0x58, 0x1b, 0x60, 0x08, 0xdd, 0xa5, 0x5e, 0x37, 0x86, 0xca,
	0x1b, 0x33, 0x80, 0xa2, 0x9b, 0x89, 0xd4, 0x35, 0x72, 0x90, 0x15, 0x4e, 0xa8, 0x3e, 0x82, 0x62,
	0x3c, 0x0c, 0xd0, 0x1d, 0x98, 0x74, 0x74, 0xd7, 0xea, 0xea, 0x16, 0xd6, 0x0c, 0x62, 0x86, 0x4f,
	0xbf, 0x18, 0x0a, 0xd7, 0x88, 0x89, 0xab, 0x9f, 0xc1, 0xf5, 0xe1, 0x66, 0xa0, 0xbb, 0x50, 0xb2,
	0x03, 0xad, 0xd3, 0x75, 0xa8, 0xad, 0x71, 0xd3, 0x39, 0x3e, 0xa7, 0x16, 0xed, 0x60, 0x87, 0x09,
	0xb7, 0x99, 0xac, 0xda, 0x84, 0x7c, 0x14, 0x26, 0xe8, 0x26, 0xe4, 0xc5, 0x6b, 0xee, 0xfa, 0xb6,
	0xd4, 0x96, 0xe3, 0x82, 0xe7, 0xbe, 0xcd, 0x16, 0x3b, 0x76, 0x07, 0x0b, 0x47, 0x88, 0x4c, 0x93,
	0x63, 0x02, 0x76, 0x9f, 0xd5, 0x25, 0x28, 0x0d, 0x46, 0xc6, 0x85, 0x5c, 0xd5, 0x3f, 0x52, 0x50,
	0xdc, 0xeb, 0xd2, 0xfe, 0xd3, 0x79, 0x0d, 0x53, 0x2c, 0xc4, 0x4d, 0x1c, 0x50, 0xdb, 0xe5, 0xe7,
	0xe0, 0x98, 0x64, 0x31, 0xb9, 0x61, 0x04, 0xeb, 0x7d, 0xe0, 0xe6, 0x98, 0x5a, 0xb2, 0x06, 0x24,
	0x88, 0xc0, 0x75, 0xc6, 0x7e, 0x48, 0x1c, 0x13, 0xfb, 0x03, 0x4a, 0xc4, 0x63, 0xfa, 0x4f, 0x32,
	0x25, 0xcf, 0x38, 0x7e, 0x50, 0xd5, 0x8c, 0x35, 0x44, 0xde, 0x98, 0xe4, 0x59, 0x37, 0x9c, 0x56,
	0xb7, 0xa1, 0x34, 0x68, 0x23, 0xba, 0x05, 0x40, 0xf8, 0xf9, 0x63, 0xd7, 0x93, 0x17, 0x92, 0x4b,
	0xef, 0xba, 0x01, 0x33, 0xc3, 0x8c, 0x41, 0xf7, 0x61, 0x5a, 0x72, 0xca, 0x83, 0xf6, 0xa9, 0xa7,
	0xc4, 0x82, 0xc0, 0x30, 0x07, 0xfc, 0x94, 0x86, 0xdc, 0xba, 0xcc, 0x8e, 0x2c, 0x6f, 0xd9, 0x1d,
	0x16, 0x65, 0xb2, 0xc0, 0xc9, 0x5b, 0x49, 0x92, 0xb7, 0xb6, 0x18, 0x6e, 0x5f, 0xc0, 0x58, 0xde,
	0xb2, 0x63, 0x73, 0x74, 0x00, 0x3c, 0x8f, 0x45, 0xb4, 0x69, 0x4e, 0x5b, 0x4b, 0x98, 0x0e, 0xfb,
	0xac, 0x05, 0xda, 0x9f, 0x32, 0x63, 0x8f, 0x6c, 0x13, 0x93, 0x88, 0x35, 0x93, 0xd8, 0xd8, 0x17,
	0x0c, 0x17, 0x33, 0xf6, 0x28, 0x36, 0x1f, 0x56, 0x5f, 0x57, 0x0e, 0x4f, 0xeb, 0x06, 0xdc, 0xbd,
	0xac, 0x62, 0xf0, 0x3b, 0x5c, 0x4d, 0x54, 0x32, 0x94, 0xb0, 0x22, 0x49, 0x19, 0xaf, 0x59, 0xef,
	0x1b, 0x79, 0x98, 0x90, 0xa7, 0xa9, 0xfe, 0x92, 0x85, 0xb2, 0xcc, 0x5d, 0xd8, 0xfc, 0xb8, 0xb5,
	0x3f, 0x7f, 0xbe, 0xf6, 0x7f, 0x03, 0xd3, 0xf1, 0xb6, 0x48, 0x14, 0x03, 0x91, 0x64, 0x1f, 0x5d,
	0x29, 0xc9, 0x8a, 0x47, 0xaf, 0x96, 0xf5, 0x33, 0x92, 0x61, 0x49, 0x3c, 0xf7, 0xb1, 0x92, 0xf8,
	0x1d, 0x98, 0xc4, 0xc7, 0x7a, 0xc7, 0x73, 0xb0, 0x2c, 0xfb, 0x19, 0x5e, 0xf6, 0x8b, 0x52, 0xc8,
	0xab, 0x3e, 0xfa, 0x37, 0xdc, 0x30, 0x08, 0x9b, 0x52, 0x6c, 0x6a, 0x83, 0xdb, 0xc7, 0xf9, 0xf6,
	0xd9, 0x68, 0xb9, 0x19, 0xc7, 0xed, 0x42, 0x81, 0xdb, 0xa3, 0x05, 0x54, 0xa7, 0x81, 0x2c, 0xe5,
	0x4b, 0x09, 0x8c, 0xe6, 0x79, 0xf5, 0x80, 0x81, 0x54, 0x70, 0xa2, 0xf1, 0xd9, 0x36, 0x6b, 0xe2,
	0x4a, 0x6d, 0xd6, 0x4b, 0xc8, 0x45, 0xf5, 0x09, 0x38, 0x72, 0x35, 0xf9, 0xf5, 0x45, 0x71, 0x14,
	0x55, 0xa8, 0x88, 0x6c, 0x44, 0xab, 0x55, 0x18, 0xd1, 0x6a, 0xad, 0x7c, 0x38, 0xad, 0x9f, 0xc0,
	0x83, 0x8b, 0x1e, 0xc4, 0xb9, 0xd8, 0xfd, 0x3c, 0xd9, 0xc3, 0xd0, 0xcf, 0xe0, 0x02, 0xe5, 0x24,
	0x12, 0x69, 0x51, 0xc7, 0xf5, 0x5b, 0x0a, 0xa0, 0x7f, 0xbf, 0xc8, 0x3c, 0x1b, 0x00, 0x29, 0xde,
	0x7d, 0x3e, 0xbd, 0x92, 0x97, 0x6a, 0x71, 0xb7, 0x37, 0x5d, 0xea, 0xf7, 0x06, 0x23, 0x68, 0xfe,
	0x29, 0x4c, 0x9f, 0xdb, 0x82, 0xca, 0x90, 0x7e, 0x8b, 0x7b, 0xf2, 0x45, 0xb2, 0x21, 0x9a, 0x81,
	0xf1, 0x23, 0xdd, 0xe9, 0x8a, 0x97, 0x98, 0x56, 0xc5, 0x64, 0xe5, 0xda, 0x93, 0x54, 0xf5, 0x67,
	0x80, 0xca, 0x28, 0x5f, 0xa0, 0x0f, 0x70, 0x53, 0x24, 0xdf, 0x33, 0xfd, 0x88, 0x68, 0xa8, 0x65,
	0x2a, 0xfe, 0x5f, 0xd2, 0x54, 0x3c, 0xd8, 0x0b, 0x88, 0xe2, 0xba, 0x39, 0xa6, 0xce, 0xd9, 0xa3,
	0x16, 0x91, 0x0d, 0x33, 0x6d, 0xd2, 0x75, 0x4d, 0x16, 0x01, 0x1e, 0x71, 0x7a, 0xa1, 0x62, 0x91,
	0xac, 0x1f, 0x27, 0x69, 0x09, 0x25, 0x7c, 0x9f, 0x38, 0xbd, 0x48, 0x23, 0x6a, 0x9f, 0x93, 0xb2,
	0x22, 0xcf, 0x34, 0x38, 0xb6, 0x8b, 0x43, 0x2d, 0x99, 0xc4, 0x45, 0x7e, 0x5f, 0x22, 0x23, 0x0d,
	0x25, 0x6f, 0x40, 0x82, 0xde, 0xc0, 0xdf, 0x02, 0x6c, 0x75, 0xb0, 0x3b, 0xf0, 0xa9, 0x25, 0x5b,
	0xdb, 0x24, 0xe7, 0x38, 0x88, 0xa1, 0xfb, 0xe7, 0x08, 0xce, 0x49, 0x99, 0xcb, 0x44, 0x09, 0x1a,
	0xee, 0xb2, 0x6c, 0x62, 0x97, 0xf1, 0x82, 0x34, 0xca, 0x65, 0x47, 0xa3, 0x16, 0x59, 0xf3, 0x4a,
	0xda, 0xec, 0x25, 0x69, 0x26, 0xa6, 0xd8, 0x88, 0xeb, 0x16, 0x69, 0xe5, 0x49, 0x02, 0xdd, 0x7b,
	0x9c, 0x61, 0x3d, 0x24, 0x88, 0xf4, 0xce, 0x92, 0x61, 0x0b, 0xac, 0x85, 0x92, 0x3a, 0xa9, 0xaf,
	0x8b, 0x7c, 0x21, 0x55, 0xe6, 0x12, 0xb7, 0x50, 0x42, 0x65, 0x4b, 0xe2, 0x23, 0x8d, 0x33, 0x64,
	0x88, 0x9c, 0x35, 0x0f, 0xf8, 0x08, 0xbb, 0xe1, 0x97, 0x25, 0xaf, 0x5e, 0xc9, 0x9a, 0x87, 0x26,
	0x83, 0x45, 0xec, 0x05, 0xdc, 0x9f, 0xa2, 0x13, 0x98, 0xe7, 0x1d, 0xc9, 0x70, 0xc7, 0x25, 0xcf,
	0xac, 0xac, 0x3f, 0x19, 0xe1, 0xb7, 0x0a, 0x1d, 0xb1, 0x86, 0xbe, 0x4b, 0xc1, 0x2d, 0xae, 0x1d,
	0xbb, 0xd4, 0xa6, 0x3d, 0x0d, 0x1f, 0xb3, 0xab, 0x8c, 0x1b, 0x50, 0xe0, 0x06, 0xfc, 0x3f, 0xa1,
	0x01, 0x4d, 0x4e, 0xd3, 0x8c, 0x58, 0x22, 0x13, 0xf8, 0x19, 0x87, 0xaf, 0x22, 0x0f, 0x6e, 0x8c,
	0xf8, 0x29, 0x21, 0x1b, 0xee, 0x24, 0xb1, 0xb3, 0xc9, 0x18, 0xfa, 0xc5, 0x59, 0x7e, 0xc4, 0xcf,
	0xbe, 0x19, 0x26, 0x6e, 0xdc, 0x84, 0xb9, 0x98, 0x2e, 0x1f, 0xbf, 0xeb, 0xe2, 0x20, 0xf4, 0x6a,
	0xf5, 0xc7, 0x0c, 0x4c, 0xc8, 0xe4, 0xfa, 0x97, 0xb5, 0xa1, 0xd9, 0x4f, 0xd2, 0x86, 0x4e, 0x7c,
	0xb2, 0x36, 0x14, 0xed, 0x41, 0x21, 0xf6, 0x03, 0x4d, 0xfe, 0x62, 0x59, 0xba, 0x52, 0xff, 0xa4,
	0xc6, 0x19, 0x56, 0x7e, 0x48, 0x9d, 0xd6, 0xbf, 0x4f, 0x5d, 0xfc, 0x2f, 0x24, 0xf4, 0xca, 0xd7,
	0x1f, 0xb1, 0x7e, 0x2b, 0xb2, 0xae, 0x06, 0xca, 0x89, 0x1c, 0xc5, 0x7b, 0xdf, 0xfb, 0x2f, 0xc5,
	0x37, 0x09, 0xef, 0xed, 0xe6, 0x60, 0x76, 0xbd, 0xde, 0xaa, 0x6b, 0xad, 0xaf, 0xf6, 0x9b, 0xda,
	0xf3, 0xdd, 0x83, 0xfd, 0xe6, 0xda, 0xd6, 0xb3, 0xad, 0xe6, 0x7a, 0x79, 0x0c, 0xe5, 0x61, 0x7c,
	0x6b, 0xa7, 0xbe, 0xd1, 0x2c, 0xa7, 0xd8, 0xf0, 0xc5, 0xd6, 0x7a, 0x73, 0xaf, 0x7c, 0x0d, 0xe5,
	0x20, 0xd3, 0x6a, 0x7e, 0xd9, 0x2a, 0x67, 0x50, 0x19, 0x8a, 0x1b, 0xcd, 0xdd, 0xa6, 0x5a, 0xdf,
	0xd6, 0x18, 0x45, 0x39, 0xdb, 0x38, 0x86, 0x7b, 0x06, 0xe9, 0x5c, 0x7e, 0x61, 0xfb, 0xa9, 0x57,
	0x3b, 0x72, 0x93, 0x45, 0xd8, 0x67, 0x76, 0x8d, 0xf8, 0x96, 0x62, 0x61, 0x97, 0xb7, 0x67, 0x4a,
	0xff, 0x86, 0x2e, 0xf8, 0xe7, 0xb7, 0x1a, 0x17, 0xb6, 0xb3, 0x1c, 0xf9, 0xe8, 0xcf, 0x00, 0x00,
	0x00, 0xff, 0xff, 0x0e, 0x94, 0xcd, 0x0c, 0x61, 0x15, 0x00, 0x00,
}
