# Gatekeeper Helm Chart

## Parameters

| Parameter                           | Description                                                                                                                                                                                            | Default                                                                   |
| :-------------------------------    | :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :------------------------------------------------------------------------ |
| auditInterval                       | The frequency with which audit is run                                                                                                                                                                  | `60`                                                                      |
| constraintViolationsLimit           | The maximum # of audit violations reported on a constraint                                                                                                                                             | `20`                                                                      |
| auditFromCache                      | Take the roster of resources to audit from the OPA cache                                                                                                                                               | `false`                                                                   |
| auditChunkSize                      | Chunk size for listing cluster resources for audit (alpha feature)                                                                                                                                     | `0`                                                                       |
| disableValidatingWebhook            | Disable ValidatingWebhook                                                                                                                                                                              | `false`                                                                   |
| emitAdmissionEvents                 | Emit K8s events in gatekeeper namespace for admission violations (alpha feature)                                                                                                                       | `false`                                                                   |
| emitAuditEvents                     | Emit K8s events in gatekeeper namespace for audit violations (alpha feature)                                                                                                                           | `false`                                                                   |
| logLevel                            | Minimum log level                                                                                                                                                                                      | `INFO`                                                                    |
| image.pullPolicy                    | The image pull policy                                                                                                                                                                                  | `IfNotPresent`                                                            |
| image.repository                    | Image repository                                                                                                                                                                                       | `openpolicyagent/gatekeeper`                                              |
| image.release                       | The image release tag to use                                                                                                                                                                           | Current release version: `v3.3.0-beta.2`                                  |
| image.pullSecrets                   | Specify an array of imagePullSecrets                                                                                                                                                                   | `[]`                                                                      |
| resources                           | The resource request/limits for the container image                                                                                                                                                    | limits: 1 CPU, 512Mi, requests: 100mCPU, 256Mi                            |
| nodeSelector                        | The node selector to use for pod scheduling                                                                                                                                                            | `kubernetes.io/os: linux`                                                 |
| affinity                            | The node affinity to use for pod scheduling                                                                                                                                                            | `{}`                                                                      |
| tolerations                         | The tolerations to use for pod scheduling                                                                                                                                                              | `[]`                                                                      |
| controllerManager.priorityClassName | Priority class name for controller manager                                                                                                                                                             | `system-cluster-critical`                                                 |
| audit.priorityClassName             | Priority class name for audit controller                                                                                                                                                               | `system-cluster-critical`                                                 |
| replicas                            | The number of Gatekeeper replicas to deploy for the webhook                                                                                                                                            | `1`                                                                       |
| podAnnotations                      | The annotations to add to the Gatekeeper pods                                                                                                                                                          | `container.seccomp.security.alpha.kubernetes.io/manager: runtime/default` |
| secretAnnotations                   | The annotations to add to the Gatekeeper secrets                                                                                                                                                       | `{}`                                                                      |
| customResourceDefinitions.create    | Whether the release should install CRDs. Regardless of this value, Helm v3+ will install the CRDs if those are not present already. Use --skip-crds with helm install if you want to skip CRD creation | `true`                                                                    |

## Contributing Changes

This Helm chart is autogenerated from the Gatekeeper static manifest. The
generator code lives under `cmd/build/helmify`. To make modifications to this
template, please edit `kustomization.yaml` and `replacements.go` under that
directory and then run `make manifests`. Your changes will show up in the
`manifest_staging` directory and will be promoted to the root `charts` directory
the next time a Gatekeeper release is cut.
