package containerregistry

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/containerregistry/mgmt/2018-02-01/containerregistry"

// Actor the agent that initiated the event. For most situations, this could be from the authorization
// context of the request.
type Actor struct {
	// Name - The subject or username associated with the request context that generated the event.
	Name *string `json:"name,omitempty"`
}

// BaseImageDependency properties that describe a base image dependency.
type BaseImageDependency struct {
	// Type - The type of the base image dependency. Possible values include: 'BuildTime', 'RunTime'
	Type BaseImageDependencyType `json:"type,omitempty"`
	// Registry - The registry login server.
	Registry *string `json:"registry,omitempty"`
	// Repository - The repository name.
	Repository *string `json:"repository,omitempty"`
	// Tag - The tag name.
	Tag *string `json:"tag,omitempty"`
	// Digest - The sha256-based digest of the image manifest.
	Digest *string `json:"digest,omitempty"`
}

// Build build resource properties
type Build struct {
	autorest.Response `json:"-"`
	// BuildProperties - The properties of a build.
	*BuildProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Build.
func (b Build) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if b.BuildProperties != nil {
		objectMap["properties"] = b.BuildProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Build struct.
func (b *Build) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var buildProperties BuildProperties
				err = json.Unmarshal(*v, &buildProperties)
				if err != nil {
					return err
				}
				b.BuildProperties = &buildProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				b.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				b.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				b.Type = &typeVar
			}
		}
	}

	return nil
}

// BuildArgument properties of a build argument.
type BuildArgument struct {
	// Type - The type of the argument.
	Type *string `json:"type,omitempty"`
	// Name - The name of the argument.
	Name *string `json:"name,omitempty"`
	// Value - The value of the argument.
	Value *string `json:"value,omitempty"`
	// IsSecret - Flag to indicate whether the argument represents a secret and want to be removed from build logs.
	IsSecret *bool `json:"isSecret,omitempty"`
}

// BuildArgumentList the list of build arguments for a build step.
type BuildArgumentList struct {
	autorest.Response `json:"-"`
	// Value - The collection value.
	Value *[]BuildArgument `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next set of paged results.
	NextLink *string `json:"nextLink,omitempty"`
}

// BuildArgumentListIterator provides access to a complete listing of BuildArgument values.
type BuildArgumentListIterator struct {
	i    int
	page BuildArgumentListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BuildArgumentListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BuildArgumentListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BuildArgumentListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BuildArgumentListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BuildArgumentListIterator) Response() BuildArgumentList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BuildArgumentListIterator) Value() BuildArgument {
	if !iter.page.NotDone() {
		return BuildArgument{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BuildArgumentListIterator type.
func NewBuildArgumentListIterator(page BuildArgumentListPage) BuildArgumentListIterator {
	return BuildArgumentListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (bal BuildArgumentList) IsEmpty() bool {
	return bal.Value == nil || len(*bal.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (bal BuildArgumentList) hasNextLink() bool {
	return bal.NextLink != nil && len(*bal.NextLink) != 0
}

// buildArgumentListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bal BuildArgumentList) buildArgumentListPreparer(ctx context.Context) (*http.Request, error) {
	if !bal.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bal.NextLink)))
}

// BuildArgumentListPage contains a page of BuildArgument values.
type BuildArgumentListPage struct {
	fn  func(context.Context, BuildArgumentList) (BuildArgumentList, error)
	bal BuildArgumentList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BuildArgumentListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BuildArgumentListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.bal)
		if err != nil {
			return err
		}
		page.bal = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BuildArgumentListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BuildArgumentListPage) NotDone() bool {
	return !page.bal.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BuildArgumentListPage) Response() BuildArgumentList {
	return page.bal
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BuildArgumentListPage) Values() []BuildArgument {
	if page.bal.IsEmpty() {
		return nil
	}
	return *page.bal.Value
}

// Creates a new instance of the BuildArgumentListPage type.
func NewBuildArgumentListPage(cur BuildArgumentList, getNextPage func(context.Context, BuildArgumentList) (BuildArgumentList, error)) BuildArgumentListPage {
	return BuildArgumentListPage{
		fn:  getNextPage,
		bal: cur,
	}
}

// BuildFilter properties that are enabled for Odata querying.
type BuildFilter struct {
	// BuildID - The unique identifier for the build.
	BuildID *string `json:"buildId,omitempty"`
	// BuildType - The type of build. Possible values include: 'AutoBuild', 'QuickBuild'
	BuildType BuildType `json:"buildType,omitempty"`
	// Status - The current status of the build. Possible values include: 'Queued', 'Started', 'Running', 'Succeeded', 'Failed', 'Canceled', 'Error', 'Timeout'
	Status BuildStatus `json:"status,omitempty"`
	// CreateTime - The create time for a build.
	CreateTime *date.Time `json:"createTime,omitempty"`
	// FinishTime - The time the build finished.
	FinishTime *date.Time `json:"finishTime,omitempty"`
	// OutputImageManifests - The list of comma-separated image manifests that were generated from the build.
	OutputImageManifests *string `json:"outputImageManifests,omitempty"`
	// IsArchiveEnabled - The value that indicates whether archiving is enabled or not.
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`
	// BuildTaskName - The name of the build task that the build corresponds to.
	BuildTaskName *string `json:"buildTaskName,omitempty"`
}

// BuildGetLogResult the result of get log link operation.
type BuildGetLogResult struct {
	autorest.Response `json:"-"`
	// LogLink - The link to logs for a azure container registry build.
	LogLink *string `json:"logLink,omitempty"`
}

// BuildListResult collection of builds.
type BuildListResult struct {
	autorest.Response `json:"-"`
	// Value - The collection value.
	Value *[]Build `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next set of paged results.
	NextLink *string `json:"nextLink,omitempty"`
}

// BuildListResultIterator provides access to a complete listing of Build values.
type BuildListResultIterator struct {
	i    int
	page BuildListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BuildListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BuildListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BuildListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BuildListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BuildListResultIterator) Response() BuildListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BuildListResultIterator) Value() Build {
	if !iter.page.NotDone() {
		return Build{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BuildListResultIterator type.
func NewBuildListResultIterator(page BuildListResultPage) BuildListResultIterator {
	return BuildListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (blr BuildListResult) IsEmpty() bool {
	return blr.Value == nil || len(*blr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (blr BuildListResult) hasNextLink() bool {
	return blr.NextLink != nil && len(*blr.NextLink) != 0
}

// buildListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (blr BuildListResult) buildListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !blr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(blr.NextLink)))
}

// BuildListResultPage contains a page of Build values.
type BuildListResultPage struct {
	fn  func(context.Context, BuildListResult) (BuildListResult, error)
	blr BuildListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BuildListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BuildListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.blr)
		if err != nil {
			return err
		}
		page.blr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BuildListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BuildListResultPage) NotDone() bool {
	return !page.blr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BuildListResultPage) Response() BuildListResult {
	return page.blr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BuildListResultPage) Values() []Build {
	if page.blr.IsEmpty() {
		return nil
	}
	return *page.blr.Value
}

// Creates a new instance of the BuildListResultPage type.
func NewBuildListResultPage(cur BuildListResult, getNextPage func(context.Context, BuildListResult) (BuildListResult, error)) BuildListResultPage {
	return BuildListResultPage{
		fn:  getNextPage,
		blr: cur,
	}
}

// BuildProperties the properties for a build.
type BuildProperties struct {
	// BuildID - The unique identifier for the build.
	BuildID *string `json:"buildId,omitempty"`
	// Status - The current status of the build. Possible values include: 'Queued', 'Started', 'Running', 'Succeeded', 'Failed', 'Canceled', 'Error', 'Timeout'
	Status BuildStatus `json:"status,omitempty"`
	// LastUpdatedTime - The last updated time for the build.
	LastUpdatedTime *date.Time `json:"lastUpdatedTime,omitempty"`
	// BuildType - The type of build. Possible values include: 'AutoBuild', 'QuickBuild'
	BuildType BuildType `json:"buildType,omitempty"`
	// CreateTime - The time the build was created.
	CreateTime *date.Time `json:"createTime,omitempty"`
	// StartTime - The time the build started.
	StartTime *date.Time `json:"startTime,omitempty"`
	// FinishTime - The time the build finished.
	FinishTime *date.Time `json:"finishTime,omitempty"`
	// OutputImages - The list of all images that were generated from the build.
	OutputImages *[]ImageDescriptor `json:"outputImages,omitempty"`
	// BuildTask - The build task with which the build was started.
	BuildTask *string `json:"buildTask,omitempty"`
	// ImageUpdateTrigger - The image update trigger that caused the build.
	ImageUpdateTrigger *ImageUpdateTrigger `json:"imageUpdateTrigger,omitempty"`
	// GitCommitTrigger - The git commit trigger that caused the build.
	GitCommitTrigger *GitCommitTrigger `json:"gitCommitTrigger,omitempty"`
	// IsArchiveEnabled - The value that indicates whether archiving is enabled or not.
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`
	// Platform - The platform properties against which the build will happen.
	Platform *PlatformProperties `json:"platform,omitempty"`
	// ProvisioningState - The provisioning state of a build. Possible values include: 'ProvisioningStateCreating', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// BuildsCancelFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type BuildsCancelFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BuildsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BuildsCancelFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BuildsCancelFuture.Result.
func (future *BuildsCancelFuture) result(client BuildsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BuildsCancelFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerregistry.BuildsCancelFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// BuildStep build step resource properties
type BuildStep struct {
	autorest.Response `json:"-"`
	// Properties - The properties of a build step.
	Properties BasicBuildStepProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BuildStep.
func (bs BuildStep) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = bs.Properties
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BuildStep struct.
func (bs *BuildStep) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicBuildStepProperties(*v)
				if err != nil {
					return err
				}
				bs.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bs.Type = &typeVar
			}
		}
	}

	return nil
}

// BuildStepList the collection of build items.
type BuildStepList struct {
	autorest.Response `json:"-"`
	// Value - The collection value.
	Value *[]BuildStep `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next set of paged results.
	NextLink *string `json:"nextLink,omitempty"`
}

// BuildStepListIterator provides access to a complete listing of BuildStep values.
type BuildStepListIterator struct {
	i    int
	page BuildStepListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BuildStepListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BuildStepListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BuildStepListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BuildStepListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BuildStepListIterator) Response() BuildStepList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BuildStepListIterator) Value() BuildStep {
	if !iter.page.NotDone() {
		return BuildStep{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BuildStepListIterator type.
func NewBuildStepListIterator(page BuildStepListPage) BuildStepListIterator {
	return BuildStepListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (bsl BuildStepList) IsEmpty() bool {
	return bsl.Value == nil || len(*bsl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (bsl BuildStepList) hasNextLink() bool {
	return bsl.NextLink != nil && len(*bsl.NextLink) != 0
}

// buildStepListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bsl BuildStepList) buildStepListPreparer(ctx context.Context) (*http.Request, error) {
	if !bsl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bsl.NextLink)))
}

// BuildStepListPage contains a page of BuildStep values.
type BuildStepListPage struct {
	fn  func(context.Context, BuildStepList) (BuildStepList, error)
	bsl BuildStepList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BuildStepListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BuildStepListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.bsl)
		if err != nil {
			return err
		}
		page.bsl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BuildStepListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BuildStepListPage) NotDone() bool {
	return !page.bsl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BuildStepListPage) Response() BuildStepList {
	return page.bsl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BuildStepListPage) Values() []BuildStep {
	if page.bsl.IsEmpty() {
		return nil
	}
	return *page.bsl.Value
}

// Creates a new instance of the BuildStepListPage type.
func NewBuildStepListPage(cur BuildStepList, getNextPage func(context.Context, BuildStepList) (BuildStepList, error)) BuildStepListPage {
	return BuildStepListPage{
		fn:  getNextPage,
		bsl: cur,
	}
}

// BasicBuildStepProperties base properties for any build step.
type BasicBuildStepProperties interface {
	AsDockerBuildStep() (*DockerBuildStep, bool)
	AsBuildStepProperties() (*BuildStepProperties, bool)
}

// BuildStepProperties base properties for any build step.
type BuildStepProperties struct {
	// ProvisioningState - READ-ONLY; The provisioning state of the build step. Possible values include: 'ProvisioningStateCreating', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Type - Possible values include: 'TypeBuildStepProperties', 'TypeDocker'
	Type Type `json:"type,omitempty"`
}

func unmarshalBasicBuildStepProperties(body []byte) (BasicBuildStepProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeDocker):
		var dbs DockerBuildStep
		err := json.Unmarshal(body, &dbs)
		return dbs, err
	default:
		var bsp BuildStepProperties
		err := json.Unmarshal(body, &bsp)
		return bsp, err
	}
}
func unmarshalBasicBuildStepPropertiesArray(body []byte) ([]BasicBuildStepProperties, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	bspArray := make([]BasicBuildStepProperties, len(rawMessages))

	for index, rawMessage := range rawMessages {
		bsp, err := unmarshalBasicBuildStepProperties(*rawMessage)
		if err != nil {
			return nil, err
		}
		bspArray[index] = bsp
	}
	return bspArray, nil
}

// MarshalJSON is the custom marshaler for BuildStepProperties.
func (bsp BuildStepProperties) MarshalJSON() ([]byte, error) {
	bsp.Type = TypeBuildStepProperties
	objectMap := make(map[string]interface{})
	if bsp.Type != "" {
		objectMap["type"] = bsp.Type
	}
	return json.Marshal(objectMap)
}

// AsDockerBuildStep is the BasicBuildStepProperties implementation for BuildStepProperties.
func (bsp BuildStepProperties) AsDockerBuildStep() (*DockerBuildStep, bool) {
	return nil, false
}

// AsBuildStepProperties is the BasicBuildStepProperties implementation for BuildStepProperties.
func (bsp BuildStepProperties) AsBuildStepProperties() (*BuildStepProperties, bool) {
	return &bsp, true
}

// AsBasicBuildStepProperties is the BasicBuildStepProperties implementation for BuildStepProperties.
func (bsp BuildStepProperties) AsBasicBuildStepProperties() (BasicBuildStepProperties, bool) {
	return &bsp, true
}

// BasicBuildStepPropertiesUpdateParameters the properties for updating a build step.
type BasicBuildStepPropertiesUpdateParameters interface {
	AsDockerBuildStepUpdateParameters() (*DockerBuildStepUpdateParameters, bool)
	AsBuildStepPropertiesUpdateParameters() (*BuildStepPropertiesUpdateParameters, bool)
}

// BuildStepPropertiesUpdateParameters the properties for updating a build step.
type BuildStepPropertiesUpdateParameters struct {
	// Type - Possible values include: 'TypeBasicBuildStepPropertiesUpdateParametersTypeBuildStepPropertiesUpdateParameters', 'TypeBasicBuildStepPropertiesUpdateParametersTypeDocker'
	Type TypeBasicBuildStepPropertiesUpdateParameters `json:"type,omitempty"`
}

func unmarshalBasicBuildStepPropertiesUpdateParameters(body []byte) (BasicBuildStepPropertiesUpdateParameters, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeBasicBuildStepPropertiesUpdateParametersTypeDocker):
		var dbsup DockerBuildStepUpdateParameters
		err := json.Unmarshal(body, &dbsup)
		return dbsup, err
	default:
		var bspup BuildStepPropertiesUpdateParameters
		err := json.Unmarshal(body, &bspup)
		return bspup, err
	}
}
func unmarshalBasicBuildStepPropertiesUpdateParametersArray(body []byte) ([]BasicBuildStepPropertiesUpdateParameters, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	bspupArray := make([]BasicBuildStepPropertiesUpdateParameters, len(rawMessages))

	for index, rawMessage := range rawMessages {
		bspup, err := unmarshalBasicBuildStepPropertiesUpdateParameters(*rawMessage)
		if err != nil {
			return nil, err
		}
		bspupArray[index] = bspup
	}
	return bspupArray, nil
}

// MarshalJSON is the custom marshaler for BuildStepPropertiesUpdateParameters.
func (bspup BuildStepPropertiesUpdateParameters) MarshalJSON() ([]byte, error) {
	bspup.Type = TypeBasicBuildStepPropertiesUpdateParametersTypeBuildStepPropertiesUpdateParameters
	objectMap := make(map[string]interface{})
	if bspup.Type != "" {
		objectMap["type"] = bspup.Type
	}
	return json.Marshal(objectMap)
}

// AsDockerBuildStepUpdateParameters is the BasicBuildStepPropertiesUpdateParameters implementation for BuildStepPropertiesUpdateParameters.
func (bspup BuildStepPropertiesUpdateParameters) AsDockerBuildStepUpdateParameters() (*DockerBuildStepUpdateParameters, bool) {
	return nil, false
}

// AsBuildStepPropertiesUpdateParameters is the BasicBuildStepPropertiesUpdateParameters implementation for BuildStepPropertiesUpdateParameters.
func (bspup BuildStepPropertiesUpdateParameters) AsBuildStepPropertiesUpdateParameters() (*BuildStepPropertiesUpdateParameters, bool) {
	return &bspup, true
}

// AsBasicBuildStepPropertiesUpdateParameters is the BasicBuildStepPropertiesUpdateParameters implementation for BuildStepPropertiesUpdateParameters.
func (bspup BuildStepPropertiesUpdateParameters) AsBasicBuildStepPropertiesUpdateParameters() (BasicBuildStepPropertiesUpdateParameters, bool) {
	return &bspup, true
}

// BuildStepsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type BuildStepsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BuildStepsClient) (BuildStep, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BuildStepsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BuildStepsCreateFuture.Result.
func (future *BuildStepsCreateFuture) result(client BuildStepsClient) (bs BuildStep, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BuildStepsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		bs.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerregistry.BuildStepsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if bs.Response.Response, err = future.GetResult(sender); err == nil && bs.Response.Response.StatusCode != http.StatusNoContent {
		bs, err = client.CreateResponder(bs.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.BuildStepsCreateFuture", "Result", bs.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BuildStepsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type BuildStepsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BuildStepsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BuildStepsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BuildStepsDeleteFuture.Result.
func (future *BuildStepsDeleteFuture) result(client BuildStepsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BuildStepsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerregistry.BuildStepsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// BuildStepsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type BuildStepsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BuildStepsClient) (BuildStep, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BuildStepsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BuildStepsUpdateFuture.Result.
func (future *BuildStepsUpdateFuture) result(client BuildStepsClient) (bs BuildStep, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BuildStepsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		bs.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerregistry.BuildStepsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if bs.Response.Response, err = future.GetResult(sender); err == nil && bs.Response.Response.StatusCode != http.StatusNoContent {
		bs, err = client.UpdateResponder(bs.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.BuildStepsUpdateFuture", "Result", bs.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BuildStepUpdateParameters the parameters for updating a build step.
type BuildStepUpdateParameters struct {
	// Properties - The properties for updating a build step.
	Properties BasicBuildStepPropertiesUpdateParameters `json:"properties,omitempty"`
	// Tags - The ARM resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for BuildStepUpdateParameters.
func (bsup BuildStepUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = bsup.Properties
	if bsup.Tags != nil {
		objectMap["tags"] = bsup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BuildStepUpdateParameters struct.
func (bsup *BuildStepUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicBuildStepPropertiesUpdateParameters(*v)
				if err != nil {
					return err
				}
				bsup.Properties = properties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				bsup.Tags = tags
			}
		}
	}

	return nil
}

// BuildsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type BuildsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BuildsClient) (Build, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BuildsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BuildsUpdateFuture.Result.
func (future *BuildsUpdateFuture) result(client BuildsClient) (b Build, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BuildsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		b.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerregistry.BuildsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if b.Response.Response, err = future.GetResult(sender); err == nil && b.Response.Response.StatusCode != http.StatusNoContent {
		b, err = client.UpdateResponder(b.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.BuildsUpdateFuture", "Result", b.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BuildTask the build task that has the resource properties and all build items. The build task will have
// all information to schedule a build against it.
type BuildTask struct {
	autorest.Response `json:"-"`
	// BuildTaskProperties - The properties of a build task.
	*BuildTaskProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource. This cannot be changed after the resource is created.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for BuildTask.
func (bt BuildTask) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bt.BuildTaskProperties != nil {
		objectMap["properties"] = bt.BuildTaskProperties
	}
	if bt.Location != nil {
		objectMap["location"] = bt.Location
	}
	if bt.Tags != nil {
		objectMap["tags"] = bt.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BuildTask struct.
func (bt *BuildTask) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var buildTaskProperties BuildTaskProperties
				err = json.Unmarshal(*v, &buildTaskProperties)
				if err != nil {
					return err
				}
				bt.BuildTaskProperties = &buildTaskProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bt.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bt.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bt.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				bt.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				bt.Tags = tags
			}
		}
	}

	return nil
}

// BuildTaskBuildRequest the queue build parameters based on a build task.
type BuildTaskBuildRequest struct {
	// BuildTaskName - The name of build task against which build has to be queued.
	BuildTaskName *string `json:"buildTaskName,omitempty"`
	// Type - Possible values include: 'TypeQueueBuildRequest', 'TypeBuildTask', 'TypeQuickBuild'
	Type TypeBasicQueueBuildRequest `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BuildTaskBuildRequest.
func (btbr BuildTaskBuildRequest) MarshalJSON() ([]byte, error) {
	btbr.Type = TypeBuildTask
	objectMap := make(map[string]interface{})
	if btbr.BuildTaskName != nil {
		objectMap["buildTaskName"] = btbr.BuildTaskName
	}
	if btbr.Type != "" {
		objectMap["type"] = btbr.Type
	}
	return json.Marshal(objectMap)
}

// AsBuildTaskBuildRequest is the BasicQueueBuildRequest implementation for BuildTaskBuildRequest.
func (btbr BuildTaskBuildRequest) AsBuildTaskBuildRequest() (*BuildTaskBuildRequest, bool) {
	return &btbr, true
}

// AsQuickBuildRequest is the BasicQueueBuildRequest implementation for BuildTaskBuildRequest.
func (btbr BuildTaskBuildRequest) AsQuickBuildRequest() (*QuickBuildRequest, bool) {
	return nil, false
}

// AsQueueBuildRequest is the BasicQueueBuildRequest implementation for BuildTaskBuildRequest.
func (btbr BuildTaskBuildRequest) AsQueueBuildRequest() (*QueueBuildRequest, bool) {
	return nil, false
}

// AsBasicQueueBuildRequest is the BasicQueueBuildRequest implementation for BuildTaskBuildRequest.
func (btbr BuildTaskBuildRequest) AsBasicQueueBuildRequest() (BasicQueueBuildRequest, bool) {
	return &btbr, true
}

// BuildTaskFilter the filter that can be used for listing build tasks.
type BuildTaskFilter struct {
	// Alias - The alternative name for build task.
	Alias *string `json:"alias,omitempty"`
}

// BuildTaskListResult the collection of build tasks.
type BuildTaskListResult struct {
	autorest.Response `json:"-"`
	// Value - The collection value.
	Value *[]BuildTask `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next set of paged results.
	NextLink *string `json:"nextLink,omitempty"`
}

// BuildTaskListResultIterator provides access to a complete listing of BuildTask values.
type BuildTaskListResultIterator struct {
	i    int
	page BuildTaskListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BuildTaskListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BuildTaskListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BuildTaskListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BuildTaskListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BuildTaskListResultIterator) Response() BuildTaskListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BuildTaskListResultIterator) Value() BuildTask {
	if !iter.page.NotDone() {
		return BuildTask{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BuildTaskListResultIterator type.
func NewBuildTaskListResultIterator(page BuildTaskListResultPage) BuildTaskListResultIterator {
	return BuildTaskListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (btlr BuildTaskListResult) IsEmpty() bool {
	return btlr.Value == nil || len(*btlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (btlr BuildTaskListResult) hasNextLink() bool {
	return btlr.NextLink != nil && len(*btlr.NextLink) != 0
}

// buildTaskListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (btlr BuildTaskListResult) buildTaskListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !btlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(btlr.NextLink)))
}

// BuildTaskListResultPage contains a page of BuildTask values.
type BuildTaskListResultPage struct {
	fn   func(context.Context, BuildTaskListResult) (BuildTaskListResult, error)
	btlr BuildTaskListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BuildTaskListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BuildTaskListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.btlr)
		if err != nil {
			return err
		}
		page.btlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BuildTaskListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BuildTaskListResultPage) NotDone() bool {
	return !page.btlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BuildTaskListResultPage) Response() BuildTaskListResult {
	return page.btlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BuildTaskListResultPage) Values() []BuildTask {
	if page.btlr.IsEmpty() {
		return nil
	}
	return *page.btlr.Value
}

// Creates a new instance of the BuildTaskListResultPage type.
func NewBuildTaskListResultPage(cur BuildTaskListResult, getNextPage func(context.Context, BuildTaskListResult) (BuildTaskListResult, error)) BuildTaskListResultPage {
	return BuildTaskListResultPage{
		fn:   getNextPage,
		btlr: cur,
	}
}

// BuildTaskProperties the properties of a build task.
type BuildTaskProperties struct {
	// ProvisioningState - READ-ONLY; The provisioning state of the build task. Possible values include: 'ProvisioningStateCreating', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// CreationDate - READ-ONLY; The creation date of build task.
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// Alias - The alternative updatable name for a build task.
	Alias *string `json:"alias,omitempty"`
	// Status - The current status of build task. Possible values include: 'Disabled', 'Enabled'
	Status BuildTaskStatus `json:"status,omitempty"`
	// SourceRepository - The properties that describes the source(code) for the build task.
	SourceRepository *SourceRepositoryProperties `json:"sourceRepository,omitempty"`
	// Platform - The platform properties against which the build has to happen.
	Platform *PlatformProperties `json:"platform,omitempty"`
	// Timeout - Build timeout in seconds.
	Timeout *int32 `json:"timeout,omitempty"`
}

// MarshalJSON is the custom marshaler for BuildTaskProperties.
func (btp BuildTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if btp.Alias != nil {
		objectMap["alias"] = btp.Alias
	}
	if btp.Status != "" {
		objectMap["status"] = btp.Status
	}
	if btp.SourceRepository != nil {
		objectMap["sourceRepository"] = btp.SourceRepository
	}
	if btp.Platform != nil {
		objectMap["platform"] = btp.Platform
	}
	if btp.Timeout != nil {
		objectMap["timeout"] = btp.Timeout
	}
	return json.Marshal(objectMap)
}

// BuildTaskPropertiesUpdateParameters the properties for updating a build task.
type BuildTaskPropertiesUpdateParameters struct {
	// Alias - The alternative updatable name for a build task.
	Alias *string `json:"alias,omitempty"`
	// Status - The current status of build task. Possible values include: 'Disabled', 'Enabled'
	Status BuildTaskStatus `json:"status,omitempty"`
	// Platform - The platform properties against which the build has to happen.
	Platform *PlatformProperties `json:"platform,omitempty"`
	// Timeout - Build timeout in seconds.
	Timeout *int32 `json:"timeout,omitempty"`
	// SourceRepository - The properties that describes the source(code) for the build task.
	SourceRepository *SourceRepositoryUpdateParameters `json:"sourceRepository,omitempty"`
}

// BuildTasksCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type BuildTasksCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BuildTasksClient) (BuildTask, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BuildTasksCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BuildTasksCreateFuture.Result.
func (future *BuildTasksCreateFuture) result(client BuildTasksClient) (bt BuildTask, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BuildTasksCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		bt.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerregistry.BuildTasksCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if bt.Response.Response, err = future.GetResult(sender); err == nil && bt.Response.Response.StatusCode != http.StatusNoContent {
		bt, err = client.CreateResponder(bt.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.BuildTasksCreateFuture", "Result", bt.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BuildTasksDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type BuildTasksDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BuildTasksClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BuildTasksDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BuildTasksDeleteFuture.Result.
func (future *BuildTasksDeleteFuture) result(client BuildTasksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BuildTasksDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerregistry.BuildTasksDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// BuildTasksUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type BuildTasksUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BuildTasksClient) (BuildTask, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BuildTasksUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BuildTasksUpdateFuture.Result.
func (future *BuildTasksUpdateFuture) result(client BuildTasksClient) (bt BuildTask, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BuildTasksUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		bt.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerregistry.BuildTasksUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if bt.Response.Response, err = future.GetResult(sender); err == nil && bt.Response.Response.StatusCode != http.StatusNoContent {
		bt, err = client.UpdateResponder(bt.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.BuildTasksUpdateFuture", "Result", bt.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BuildTaskUpdateParameters the parameters for updating a build task.
type BuildTaskUpdateParameters struct {
	// BuildTaskPropertiesUpdateParameters - The properties for updating a build task.
	*BuildTaskPropertiesUpdateParameters `json:"properties,omitempty"`
	// Tags - The ARM resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for BuildTaskUpdateParameters.
func (btup BuildTaskUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if btup.BuildTaskPropertiesUpdateParameters != nil {
		objectMap["properties"] = btup.BuildTaskPropertiesUpdateParameters
	}
	if btup.Tags != nil {
		objectMap["tags"] = btup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BuildTaskUpdateParameters struct.
func (btup *BuildTaskUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var buildTaskPropertiesUpdateParameters BuildTaskPropertiesUpdateParameters
				err = json.Unmarshal(*v, &buildTaskPropertiesUpdateParameters)
				if err != nil {
					return err
				}
				btup.BuildTaskPropertiesUpdateParameters = &buildTaskPropertiesUpdateParameters
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				btup.Tags = tags
			}
		}
	}

	return nil
}

// BuildUpdateParameters the set of build properties that can be updated.
type BuildUpdateParameters struct {
	// IsArchiveEnabled - The value that indicates whether archiving is enabled or not.
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`
}

// CallbackConfig the configuration of service URI and custom headers for the webhook.
type CallbackConfig struct {
	autorest.Response `json:"-"`
	// ServiceURI - The service URI for the webhook to post notifications.
	ServiceURI *string `json:"serviceUri,omitempty"`
	// CustomHeaders - Custom headers that will be added to the webhook notifications.
	CustomHeaders map[string]*string `json:"customHeaders"`
}

// MarshalJSON is the custom marshaler for CallbackConfig.
func (cc CallbackConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cc.ServiceURI != nil {
		objectMap["serviceUri"] = cc.ServiceURI
	}
	if cc.CustomHeaders != nil {
		objectMap["customHeaders"] = cc.CustomHeaders
	}
	return json.Marshal(objectMap)
}

// DockerBuildStep the Docker build step.
type DockerBuildStep struct {
	// Branch - The repository branch name.
	Branch *string `json:"branch,omitempty"`
	// ImageNames - The fully qualified image names including the repository and tag.
	ImageNames *[]string `json:"imageNames,omitempty"`
	// IsPushEnabled - The value of this property indicates whether the image built should be pushed to the registry or not.
	IsPushEnabled *bool `json:"isPushEnabled,omitempty"`
	// NoCache - The value of this property indicates whether the image cache is enabled or not.
	NoCache *bool `json:"noCache,omitempty"`
	// DockerFilePath - The Docker file path relative to the source control root.
	DockerFilePath *string `json:"dockerFilePath,omitempty"`
	// ContextPath - The relative context path for a docker build in the source.
	ContextPath *string `json:"contextPath,omitempty"`
	// BuildArguments - The custom arguments for building this build step.
	BuildArguments *[]BuildArgument `json:"buildArguments,omitempty"`
	// BaseImageDependencies - READ-ONLY; List of base image dependencies for a step.
	BaseImageDependencies *[]BaseImageDependency `json:"baseImageDependencies,omitempty"`
	// BaseImageTrigger - The type of the auto trigger for base image dependency updates. Possible values include: 'All', 'Runtime', 'None'
	BaseImageTrigger BaseImageTriggerType `json:"baseImageTrigger,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the build step. Possible values include: 'ProvisioningStateCreating', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Type - Possible values include: 'TypeBuildStepProperties', 'TypeDocker'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DockerBuildStep.
func (dbs DockerBuildStep) MarshalJSON() ([]byte, error) {
	dbs.Type = TypeDocker
	objectMap := make(map[string]interface{})
	if dbs.Branch != nil {
		objectMap["branch"] = dbs.Branch
	}
	if dbs.ImageNames != nil {
		objectMap["imageNames"] = dbs.ImageNames
	}
	if dbs.IsPushEnabled != nil {
		objectMap["isPushEnabled"] = dbs.IsPushEnabled
	}
	if dbs.NoCache != nil {
		objectMap["noCache"] = dbs.NoCache
	}
	if dbs.DockerFilePath != nil {
		objectMap["dockerFilePath"] = dbs.DockerFilePath
	}
	if dbs.ContextPath != nil {
		objectMap["contextPath"] = dbs.ContextPath
	}
	if dbs.BuildArguments != nil {
		objectMap["buildArguments"] = dbs.BuildArguments
	}
	if dbs.BaseImageTrigger != "" {
		objectMap["baseImageTrigger"] = dbs.BaseImageTrigger
	}
	if dbs.Type != "" {
		objectMap["type"] = dbs.Type
	}
	return json.Marshal(objectMap)
}

// AsDockerBuildStep is the BasicBuildStepProperties implementation for DockerBuildStep.
func (dbs DockerBuildStep) AsDockerBuildStep() (*DockerBuildStep, bool) {
	return &dbs, true
}

// AsBuildStepProperties is the BasicBuildStepProperties implementation for DockerBuildStep.
func (dbs DockerBuildStep) AsBuildStepProperties() (*BuildStepProperties, bool) {
	return nil, false
}

// AsBasicBuildStepProperties is the BasicBuildStepProperties implementation for DockerBuildStep.
func (dbs DockerBuildStep) AsBasicBuildStepProperties() (BasicBuildStepProperties, bool) {
	return &dbs, true
}

// DockerBuildStepUpdateParameters the properties for updating a docker build step.
type DockerBuildStepUpdateParameters struct {
	// Branch - The repository branch name.
	Branch *string `json:"branch,omitempty"`
	// ImageNames - The fully qualified image names including the repository and tag.
	ImageNames *[]string `json:"imageNames,omitempty"`
	// IsPushEnabled - The value of this property indicates whether the image built should be pushed to the registry or not.
	IsPushEnabled *bool `json:"isPushEnabled,omitempty"`
	// NoCache - The value of this property indicates whether the image cache is enabled or not.
	NoCache *bool `json:"noCache,omitempty"`
	// DockerFilePath - The Docker file path relative to the source control root.
	DockerFilePath *string `json:"dockerFilePath,omitempty"`
	// ContextPath - The relative context path for a docker build in the source.
	ContextPath *string `json:"contextPath,omitempty"`
	// BuildArguments - The custom arguments for building this build step.
	BuildArguments *[]BuildArgument `json:"buildArguments,omitempty"`
	// BaseImageTrigger - The type of the auto trigger for base image dependency updates. Possible values include: 'All', 'Runtime', 'None'
	BaseImageTrigger BaseImageTriggerType `json:"baseImageTrigger,omitempty"`
	// Type - Possible values include: 'TypeBasicBuildStepPropertiesUpdateParametersTypeBuildStepPropertiesUpdateParameters', 'TypeBasicBuildStepPropertiesUpdateParametersTypeDocker'
	Type TypeBasicBuildStepPropertiesUpdateParameters `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DockerBuildStepUpdateParameters.
func (dbsup DockerBuildStepUpdateParameters) MarshalJSON() ([]byte, error) {
	dbsup.Type = TypeBasicBuildStepPropertiesUpdateParametersTypeDocker
	objectMap := make(map[string]interface{})
	if dbsup.Branch != nil {
		objectMap["branch"] = dbsup.Branch
	}
	if dbsup.ImageNames != nil {
		objectMap["imageNames"] = dbsup.ImageNames
	}
	if dbsup.IsPushEnabled != nil {
		objectMap["isPushEnabled"] = dbsup.IsPushEnabled
	}
	if dbsup.NoCache != nil {
		objectMap["noCache"] = dbsup.NoCache
	}
	if dbsup.DockerFilePath != nil {
		objectMap["dockerFilePath"] = dbsup.DockerFilePath
	}
	if dbsup.ContextPath != nil {
		objectMap["contextPath"] = dbsup.ContextPath
	}
	if dbsup.BuildArguments != nil {
		objectMap["buildArguments"] = dbsup.BuildArguments
	}
	if dbsup.BaseImageTrigger != "" {
		objectMap["baseImageTrigger"] = dbsup.BaseImageTrigger
	}
	if dbsup.Type != "" {
		objectMap["type"] = dbsup.Type
	}
	return json.Marshal(objectMap)
}

// AsDockerBuildStepUpdateParameters is the BasicBuildStepPropertiesUpdateParameters implementation for DockerBuildStepUpdateParameters.
func (dbsup DockerBuildStepUpdateParameters) AsDockerBuildStepUpdateParameters() (*DockerBuildStepUpdateParameters, bool) {
	return &dbsup, true
}

// AsBuildStepPropertiesUpdateParameters is the BasicBuildStepPropertiesUpdateParameters implementation for DockerBuildStepUpdateParameters.
func (dbsup DockerBuildStepUpdateParameters) AsBuildStepPropertiesUpdateParameters() (*BuildStepPropertiesUpdateParameters, bool) {
	return nil, false
}

// AsBasicBuildStepPropertiesUpdateParameters is the BasicBuildStepPropertiesUpdateParameters implementation for DockerBuildStepUpdateParameters.
func (dbsup DockerBuildStepUpdateParameters) AsBasicBuildStepPropertiesUpdateParameters() (BasicBuildStepPropertiesUpdateParameters, bool) {
	return &dbsup, true
}

// Event the event for a webhook.
type Event struct {
	// EventRequestMessage - The event request message sent to the service URI.
	EventRequestMessage *EventRequestMessage `json:"eventRequestMessage,omitempty"`
	// EventResponseMessage - The event response message received from the service URI.
	EventResponseMessage *EventResponseMessage `json:"eventResponseMessage,omitempty"`
	// ID - The event ID.
	ID *string `json:"id,omitempty"`
}

// EventContent the content of the event request message.
type EventContent struct {
	// ID - The event ID.
	ID *string `json:"id,omitempty"`
	// Timestamp - The time at which the event occurred.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Action - The action that encompasses the provided event.
	Action *string `json:"action,omitempty"`
	// Target - The target of the event.
	Target *Target `json:"target,omitempty"`
	// Request - The request that generated the event.
	Request *Request `json:"request,omitempty"`
	// Actor - The agent that initiated the event. For most situations, this could be from the authorization context of the request.
	Actor *Actor `json:"actor,omitempty"`
	// Source - The registry node that generated the event. Put differently, while the actor initiates the event, the source generates it.
	Source *Source `json:"source,omitempty"`
}

// EventInfo the basic information of an event.
type EventInfo struct {
	autorest.Response `json:"-"`
	// ID - The event ID.
	ID *string `json:"id,omitempty"`
}

// EventListResult the result of a request to list events for a webhook.
type EventListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of events. Since this list may be incomplete, the nextLink field should be used to request the next list of events.
	Value *[]Event `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next list of events.
	NextLink *string `json:"nextLink,omitempty"`
}

// EventListResultIterator provides access to a complete listing of Event values.
type EventListResultIterator struct {
	i    int
	page EventListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EventListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EventListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EventListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EventListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EventListResultIterator) Response() EventListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EventListResultIterator) Value() Event {
	if !iter.page.NotDone() {
		return Event{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EventListResultIterator type.
func NewEventListResultIterator(page EventListResultPage) EventListResultIterator {
	return EventListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (elr EventListResult) IsEmpty() bool {
	return elr.Value == nil || len(*elr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (elr EventListResult) hasNextLink() bool {
	return elr.NextLink != nil && len(*elr.NextLink) != 0
}

// eventListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (elr EventListResult) eventListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !elr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(elr.NextLink)))
}

// EventListResultPage contains a page of Event values.
type EventListResultPage struct {
	fn  func(context.Context, EventListResult) (EventListResult, error)
	elr EventListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EventListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EventListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.elr)
		if err != nil {
			return err
		}
		page.elr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EventListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EventListResultPage) NotDone() bool {
	return !page.elr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EventListResultPage) Response() EventListResult {
	return page.elr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EventListResultPage) Values() []Event {
	if page.elr.IsEmpty() {
		return nil
	}
	return *page.elr.Value
}

// Creates a new instance of the EventListResultPage type.
func NewEventListResultPage(cur EventListResult, getNextPage func(context.Context, EventListResult) (EventListResult, error)) EventListResultPage {
	return EventListResultPage{
		fn:  getNextPage,
		elr: cur,
	}
}

// EventRequestMessage the event request message sent to the service URI.
type EventRequestMessage struct {
	// Content - The content of the event request message.
	Content *EventContent `json:"content,omitempty"`
	// Headers - The headers of the event request message.
	Headers map[string]*string `json:"headers"`
	// Method - The HTTP method used to send the event request message.
	Method *string `json:"method,omitempty"`
	// RequestURI - The URI used to send the event request message.
	RequestURI *string `json:"requestUri,omitempty"`
	// Version - The HTTP message version.
	Version *string `json:"version,omitempty"`
}

// MarshalJSON is the custom marshaler for EventRequestMessage.
func (erm EventRequestMessage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erm.Content != nil {
		objectMap["content"] = erm.Content
	}
	if erm.Headers != nil {
		objectMap["headers"] = erm.Headers
	}
	if erm.Method != nil {
		objectMap["method"] = erm.Method
	}
	if erm.RequestURI != nil {
		objectMap["requestUri"] = erm.RequestURI
	}
	if erm.Version != nil {
		objectMap["version"] = erm.Version
	}
	return json.Marshal(objectMap)
}

// EventResponseMessage the event response message received from the service URI.
type EventResponseMessage struct {
	// Content - The content of the event response message.
	Content *string `json:"content,omitempty"`
	// Headers - The headers of the event response message.
	Headers map[string]*string `json:"headers"`
	// ReasonPhrase - The reason phrase of the event response message.
	ReasonPhrase *string `json:"reasonPhrase,omitempty"`
	// StatusCode - The status code of the event response message.
	StatusCode *string `json:"statusCode,omitempty"`
	// Version - The HTTP message version.
	Version *string `json:"version,omitempty"`
}

// MarshalJSON is the custom marshaler for EventResponseMessage.
func (erm EventResponseMessage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erm.Content != nil {
		objectMap["content"] = erm.Content
	}
	if erm.Headers != nil {
		objectMap["headers"] = erm.Headers
	}
	if erm.ReasonPhrase != nil {
		objectMap["reasonPhrase"] = erm.ReasonPhrase
	}
	if erm.StatusCode != nil {
		objectMap["statusCode"] = erm.StatusCode
	}
	if erm.Version != nil {
		objectMap["version"] = erm.Version
	}
	return json.Marshal(objectMap)
}

// GitCommitTrigger the git commit trigger that caused a build.
type GitCommitTrigger struct {
	// ID - The unique ID of the trigger.
	ID *string `json:"id,omitempty"`
	// CommitID - The unique ID that identifies a commit.
	CommitID *string `json:"commitId,omitempty"`
	// RepositoryURL - The repository URL.
	RepositoryURL *string `json:"repositoryUrl,omitempty"`
	// BranchName - The branch name in the repository.
	BranchName *string `json:"branchName,omitempty"`
	// ProviderType - The source control provider type.
	ProviderType *string `json:"providerType,omitempty"`
}

// ImageDescriptor properties for a registry image.
type ImageDescriptor struct {
	// Registry - The registry login server.
	Registry *string `json:"registry,omitempty"`
	// Repository - The repository name.
	Repository *string `json:"repository,omitempty"`
	// Tag - The tag name.
	Tag *string `json:"tag,omitempty"`
	// Digest - The sha256-based digest of the image manifest.
	Digest *string `json:"digest,omitempty"`
}

// ImageUpdateTrigger the image update trigger that caused a build.
type ImageUpdateTrigger struct {
	// ID - The unique ID of the trigger.
	ID *string `json:"id,omitempty"`
	// Timestamp - The timestamp when the image update happened.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Images - The list of image updates that caused the build.
	Images *[]ImageDescriptor `json:"images,omitempty"`
}

// ImportImageParameters ...
type ImportImageParameters struct {
	// Source - The source of the image.
	Source *ImportSource `json:"source,omitempty"`
	// TargetTags - List of strings of the form repo[:tag]. When tag is omitted the source will be used (or 'latest' if source tag is also omitted).
	TargetTags *[]string `json:"targetTags,omitempty"`
	// UntaggedTargetRepositories - List of strings of repository names to do a manifest only copy. No tag will be created.
	UntaggedTargetRepositories *[]string `json:"untaggedTargetRepositories,omitempty"`
	// Mode - When Force, any existing target tags will be overwritten. When NoForce, any existing target tags will fail the operation before any copying begins. Possible values include: 'NoForce', 'Force'
	Mode ImportMode `json:"mode,omitempty"`
}

// ImportSource ...
type ImportSource struct {
	// ResourceID - The resource identifier of the source Azure Container Registry.
	ResourceID *string `json:"resourceId,omitempty"`
	// RegistryURI - The address of the source registry (e.g. 'mcr.microsoft.com').
	RegistryURI *string `json:"registryUri,omitempty"`
	// Credentials - Credentials used when importing from a registry uri.
	Credentials *ImportSourceCredentials `json:"credentials,omitempty"`
	// SourceImage - Repository name of the source image.
	// Specify an image by repository ('hello-world'). This will use the 'latest' tag.
	// Specify an image by tag ('hello-world:latest').
	// Specify an image by sha256-based manifest digest ('hello-world@sha256:abc123').
	SourceImage *string `json:"sourceImage,omitempty"`
}

// ImportSourceCredentials ...
type ImportSourceCredentials struct {
	// Username - The username to authenticate with the source registry.
	Username *string `json:"username,omitempty"`
	// Password - The password used to authenticate with the source registry.
	Password *string `json:"password,omitempty"`
}

// IPRule IP rule with specific IP or IP range in CIDR format.
type IPRule struct {
	// Action - The action of IP ACL rule. Possible values include: 'Allow'
	Action Action `json:"action,omitempty"`
	// IPAddressOrRange - Specifies the IP or IP range in CIDR format. Only IPV4 address is allowed.
	IPAddressOrRange *string `json:"value,omitempty"`
}

// NetworkRuleSet the network rule set for a container registry.
type NetworkRuleSet struct {
	// DefaultAction - The default action of allow or deny when no other rules match. Possible values include: 'DefaultActionAllow', 'DefaultActionDeny'
	DefaultAction DefaultAction `json:"defaultAction,omitempty"`
	// VirtualNetworkRules - The virtual network rules.
	VirtualNetworkRules *[]VirtualNetworkRule `json:"virtualNetworkRules,omitempty"`
	// IPRules - The IP ACL rules.
	IPRules *[]IPRule `json:"ipRules,omitempty"`
}

// OperationDefinition the definition of a container registry operation.
type OperationDefinition struct {
	// Origin - The origin information of the container registry operation.
	Origin *string `json:"origin,omitempty"`
	// Name - Operation name: {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty"`
	// Display - The display information for the container registry operation.
	Display *OperationDisplayDefinition `json:"display,omitempty"`
	// OperationPropertiesDefinition - The properties information for the container registry operation.
	*OperationPropertiesDefinition `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationDefinition.
func (od OperationDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if od.Origin != nil {
		objectMap["origin"] = od.Origin
	}
	if od.Name != nil {
		objectMap["name"] = od.Name
	}
	if od.Display != nil {
		objectMap["display"] = od.Display
	}
	if od.OperationPropertiesDefinition != nil {
		objectMap["properties"] = od.OperationPropertiesDefinition
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OperationDefinition struct.
func (od *OperationDefinition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "origin":
			if v != nil {
				var origin string
				err = json.Unmarshal(*v, &origin)
				if err != nil {
					return err
				}
				od.Origin = &origin
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				od.Name = &name
			}
		case "display":
			if v != nil {
				var display OperationDisplayDefinition
				err = json.Unmarshal(*v, &display)
				if err != nil {
					return err
				}
				od.Display = &display
			}
		case "properties":
			if v != nil {
				var operationPropertiesDefinition OperationPropertiesDefinition
				err = json.Unmarshal(*v, &operationPropertiesDefinition)
				if err != nil {
					return err
				}
				od.OperationPropertiesDefinition = &operationPropertiesDefinition
			}
		}
	}

	return nil
}

// OperationDisplayDefinition the display information for a container registry operation.
type OperationDisplayDefinition struct {
	// Provider - The resource provider name: Microsoft.ContainerRegistry.
	Provider *string `json:"provider,omitempty"`
	// Resource - The resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - The operation that users can perform.
	Operation *string `json:"operation,omitempty"`
	// Description - The description for the operation.
	Description *string `json:"description,omitempty"`
}

// OperationListResult the result of a request to list container registry operations.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of container registry operations. Since this list may be incomplete, the nextLink field should be used to request the next list of operations.
	Value *[]OperationDefinition `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next list of container registry operations.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of OperationDefinition values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() OperationDefinition {
	if !iter.page.NotDone() {
		return OperationDefinition{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of OperationDefinition values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []OperationDefinition {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// OperationMetricSpecificationDefinition the definition of Azure Monitoring metric.
type OperationMetricSpecificationDefinition struct {
	// Name - Metric name.
	Name *string `json:"name,omitempty"`
	// DisplayName - Metric display name.
	DisplayName *string `json:"displayName,omitempty"`
	// DisplayDescription - Metric description.
	DisplayDescription *string `json:"displayDescription,omitempty"`
	// Unit - Metric unit.
	Unit *string `json:"unit,omitempty"`
	// AggregationType - Metric aggregation type.
	AggregationType *string `json:"aggregationType,omitempty"`
	// InternalMetricName - Internal metric name.
	InternalMetricName *string `json:"internalMetricName,omitempty"`
}

// OperationPropertiesDefinition the definition of Azure Monitoring properties.
type OperationPropertiesDefinition struct {
	// ServiceSpecification - The definition of Azure Monitoring service.
	ServiceSpecification *OperationServiceSpecificationDefinition `json:"serviceSpecification,omitempty"`
}

// OperationServiceSpecificationDefinition the definition of Azure Monitoring metrics list.
type OperationServiceSpecificationDefinition struct {
	// MetricSpecifications - A list of Azure Monitoring metrics definition.
	MetricSpecifications *[]OperationMetricSpecificationDefinition `json:"metricSpecifications,omitempty"`
}

// PlatformProperties the platform properties against which the build has to happen.
type PlatformProperties struct {
	// OsType - The operating system type required for the build. Possible values include: 'Windows', 'Linux'
	OsType OsType `json:"osType,omitempty"`
	// CPU - The CPU configuration in terms of number of cores required for the build.
	CPU *int32 `json:"cpu,omitempty"`
}

// ProxyResource the resource model definition for a ARM proxy resource. It will have everything other than
// required location and tags.
type ProxyResource struct {
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// QuarantinePolicy an object that represents quarantine policy for a container registry.
type QuarantinePolicy struct {
	// Status - The value that indicates whether the policy is enabled or not. Possible values include: 'PolicyStatusEnabled', 'PolicyStatusDisabled'
	Status PolicyStatus `json:"status,omitempty"`
}

// BasicQueueBuildRequest the queue build request parameters.
type BasicQueueBuildRequest interface {
	AsBuildTaskBuildRequest() (*BuildTaskBuildRequest, bool)
	AsQuickBuildRequest() (*QuickBuildRequest, bool)
	AsQueueBuildRequest() (*QueueBuildRequest, bool)
}

// QueueBuildRequest the queue build request parameters.
type QueueBuildRequest struct {
	// Type - Possible values include: 'TypeQueueBuildRequest', 'TypeBuildTask', 'TypeQuickBuild'
	Type TypeBasicQueueBuildRequest `json:"type,omitempty"`
}

func unmarshalBasicQueueBuildRequest(body []byte) (BasicQueueBuildRequest, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeBuildTask):
		var btbr BuildTaskBuildRequest
		err := json.Unmarshal(body, &btbr)
		return btbr, err
	case string(TypeQuickBuild):
		var qbr QuickBuildRequest
		err := json.Unmarshal(body, &qbr)
		return qbr, err
	default:
		var qbr QueueBuildRequest
		err := json.Unmarshal(body, &qbr)
		return qbr, err
	}
}
func unmarshalBasicQueueBuildRequestArray(body []byte) ([]BasicQueueBuildRequest, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	qbrArray := make([]BasicQueueBuildRequest, len(rawMessages))

	for index, rawMessage := range rawMessages {
		qbr, err := unmarshalBasicQueueBuildRequest(*rawMessage)
		if err != nil {
			return nil, err
		}
		qbrArray[index] = qbr
	}
	return qbrArray, nil
}

// MarshalJSON is the custom marshaler for QueueBuildRequest.
func (qbr QueueBuildRequest) MarshalJSON() ([]byte, error) {
	qbr.Type = TypeQueueBuildRequest
	objectMap := make(map[string]interface{})
	if qbr.Type != "" {
		objectMap["type"] = qbr.Type
	}
	return json.Marshal(objectMap)
}

// AsBuildTaskBuildRequest is the BasicQueueBuildRequest implementation for QueueBuildRequest.
func (qbr QueueBuildRequest) AsBuildTaskBuildRequest() (*BuildTaskBuildRequest, bool) {
	return nil, false
}

// AsQuickBuildRequest is the BasicQueueBuildRequest implementation for QueueBuildRequest.
func (qbr QueueBuildRequest) AsQuickBuildRequest() (*QuickBuildRequest, bool) {
	return nil, false
}

// AsQueueBuildRequest is the BasicQueueBuildRequest implementation for QueueBuildRequest.
func (qbr QueueBuildRequest) AsQueueBuildRequest() (*QueueBuildRequest, bool) {
	return &qbr, true
}

// AsBasicQueueBuildRequest is the BasicQueueBuildRequest implementation for QueueBuildRequest.
func (qbr QueueBuildRequest) AsBasicQueueBuildRequest() (BasicQueueBuildRequest, bool) {
	return &qbr, true
}

// QuickBuildRequest the queue build request parameters for a quick build.
type QuickBuildRequest struct {
	// ImageNames - The fully qualified image names including the repository and tag.
	ImageNames *[]string `json:"imageNames,omitempty"`
	// SourceLocation - The URL(absolute or relative) of the source that needs to be built. For Docker build, it can be an URL to a tar or github repository as supported by Docker.
	// If it is relative URL, the relative path should be obtained from calling getSourceUploadUrl API.
	SourceLocation *string `json:"sourceLocation,omitempty"`
	// BuildArguments - The collection of build arguments to be used.
	BuildArguments *[]BuildArgument `json:"buildArguments,omitempty"`
	// IsPushEnabled - The value of this property indicates whether the image built should be pushed to the registry or not.
	IsPushEnabled *bool `json:"isPushEnabled,omitempty"`
	// NoCache - The value of this property indicates whether the image cache is enabled or not.
	NoCache *bool `json:"noCache,omitempty"`
	// Timeout - Build timeout in seconds.
	Timeout *int32 `json:"timeout,omitempty"`
	// Platform - The platform properties against which the build will happen.
	Platform *PlatformProperties `json:"platform,omitempty"`
	// DockerFilePath - The Docker file path relative to the source location.
	DockerFilePath *string `json:"dockerFilePath,omitempty"`
	// Type - Possible values include: 'TypeQueueBuildRequest', 'TypeBuildTask', 'TypeQuickBuild'
	Type TypeBasicQueueBuildRequest `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for QuickBuildRequest.
func (qbr QuickBuildRequest) MarshalJSON() ([]byte, error) {
	qbr.Type = TypeQuickBuild
	objectMap := make(map[string]interface{})
	if qbr.ImageNames != nil {
		objectMap["imageNames"] = qbr.ImageNames
	}
	if qbr.SourceLocation != nil {
		objectMap["sourceLocation"] = qbr.SourceLocation
	}
	if qbr.BuildArguments != nil {
		objectMap["buildArguments"] = qbr.BuildArguments
	}
	if qbr.IsPushEnabled != nil {
		objectMap["isPushEnabled"] = qbr.IsPushEnabled
	}
	if qbr.NoCache != nil {
		objectMap["noCache"] = qbr.NoCache
	}
	if qbr.Timeout != nil {
		objectMap["timeout"] = qbr.Timeout
	}
	if qbr.Platform != nil {
		objectMap["platform"] = qbr.Platform
	}
	if qbr.DockerFilePath != nil {
		objectMap["dockerFilePath"] = qbr.DockerFilePath
	}
	if qbr.Type != "" {
		objectMap["type"] = qbr.Type
	}
	return json.Marshal(objectMap)
}

// AsBuildTaskBuildRequest is the BasicQueueBuildRequest implementation for QuickBuildRequest.
func (qbr QuickBuildRequest) AsBuildTaskBuildRequest() (*BuildTaskBuildRequest, bool) {
	return nil, false
}

// AsQuickBuildRequest is the BasicQueueBuildRequest implementation for QuickBuildRequest.
func (qbr QuickBuildRequest) AsQuickBuildRequest() (*QuickBuildRequest, bool) {
	return &qbr, true
}

// AsQueueBuildRequest is the BasicQueueBuildRequest implementation for QuickBuildRequest.
func (qbr QuickBuildRequest) AsQueueBuildRequest() (*QueueBuildRequest, bool) {
	return nil, false
}

// AsBasicQueueBuildRequest is the BasicQueueBuildRequest implementation for QuickBuildRequest.
func (qbr QuickBuildRequest) AsBasicQueueBuildRequest() (BasicQueueBuildRequest, bool) {
	return &qbr, true
}

// RegenerateCredentialParameters the parameters used to regenerate the login credential.
type RegenerateCredentialParameters struct {
	// Name - Specifies name of the password which should be regenerated -- password or password2. Possible values include: 'Password', 'Password2'
	Name PasswordName `json:"name,omitempty"`
}

// RegistriesCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RegistriesCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RegistriesClient) (Registry, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RegistriesCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RegistriesCreateFuture.Result.
func (future *RegistriesCreateFuture) result(client RegistriesClient) (r Registry, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.RegistriesCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		r.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerregistry.RegistriesCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if r.Response.Response, err = future.GetResult(sender); err == nil && r.Response.Response.StatusCode != http.StatusNoContent {
		r, err = client.CreateResponder(r.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.RegistriesCreateFuture", "Result", r.Response.Response, "Failure responding to request")
		}
	}
	return
}

// RegistriesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RegistriesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RegistriesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RegistriesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RegistriesDeleteFuture.Result.
func (future *RegistriesDeleteFuture) result(client RegistriesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.RegistriesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerregistry.RegistriesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// RegistriesImportImageFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RegistriesImportImageFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RegistriesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RegistriesImportImageFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RegistriesImportImageFuture.Result.
func (future *RegistriesImportImageFuture) result(client RegistriesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.RegistriesImportImageFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerregistry.RegistriesImportImageFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// RegistriesQueueBuildFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RegistriesQueueBuildFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RegistriesClient) (Build, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RegistriesQueueBuildFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RegistriesQueueBuildFuture.Result.
func (future *RegistriesQueueBuildFuture) result(client RegistriesClient) (b Build, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.RegistriesQueueBuildFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		b.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerregistry.RegistriesQueueBuildFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if b.Response.Response, err = future.GetResult(sender); err == nil && b.Response.Response.StatusCode != http.StatusNoContent {
		b, err = client.QueueBuildResponder(b.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.RegistriesQueueBuildFuture", "Result", b.Response.Response, "Failure responding to request")
		}
	}
	return
}

// RegistriesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RegistriesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RegistriesClient) (Registry, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RegistriesUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RegistriesUpdateFuture.Result.
func (future *RegistriesUpdateFuture) result(client RegistriesClient) (r Registry, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.RegistriesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		r.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerregistry.RegistriesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if r.Response.Response, err = future.GetResult(sender); err == nil && r.Response.Response.StatusCode != http.StatusNoContent {
		r, err = client.UpdateResponder(r.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.RegistriesUpdateFuture", "Result", r.Response.Response, "Failure responding to request")
		}
	}
	return
}

// RegistriesUpdatePoliciesFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type RegistriesUpdatePoliciesFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RegistriesClient) (RegistryPolicies, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RegistriesUpdatePoliciesFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RegistriesUpdatePoliciesFuture.Result.
func (future *RegistriesUpdatePoliciesFuture) result(client RegistriesClient) (rp RegistryPolicies, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.RegistriesUpdatePoliciesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		rp.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerregistry.RegistriesUpdatePoliciesFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rp.Response.Response, err = future.GetResult(sender); err == nil && rp.Response.Response.StatusCode != http.StatusNoContent {
		rp, err = client.UpdatePoliciesResponder(rp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.RegistriesUpdatePoliciesFuture", "Result", rp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// Registry an object that represents a container registry.
type Registry struct {
	autorest.Response `json:"-"`
	// Sku - The SKU of the container registry.
	Sku *Sku `json:"sku,omitempty"`
	// RegistryProperties - The properties of the container registry.
	*RegistryProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource. This cannot be changed after the resource is created.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Registry.
func (r Registry) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Sku != nil {
		objectMap["sku"] = r.Sku
	}
	if r.RegistryProperties != nil {
		objectMap["properties"] = r.RegistryProperties
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Registry struct.
func (r *Registry) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				r.Sku = &sku
			}
		case "properties":
			if v != nil {
				var registryProperties RegistryProperties
				err = json.Unmarshal(*v, &registryProperties)
				if err != nil {
					return err
				}
				r.RegistryProperties = &registryProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				r.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				r.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				r.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				r.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				r.Tags = tags
			}
		}
	}

	return nil
}

// RegistryListCredentialsResult the response from the ListCredentials operation.
type RegistryListCredentialsResult struct {
	autorest.Response `json:"-"`
	// Username - The username for a container registry.
	Username *string `json:"username,omitempty"`
	// Passwords - The list of passwords for a container registry.
	Passwords *[]RegistryPassword `json:"passwords,omitempty"`
}

// RegistryListResult the result of a request to list container registries.
type RegistryListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of container registries. Since this list may be incomplete, the nextLink field should be used to request the next list of container registries.
	Value *[]Registry `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next list of container registries.
	NextLink *string `json:"nextLink,omitempty"`
}

// RegistryListResultIterator provides access to a complete listing of Registry values.
type RegistryListResultIterator struct {
	i    int
	page RegistryListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RegistryListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RegistryListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RegistryListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RegistryListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RegistryListResultIterator) Response() RegistryListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RegistryListResultIterator) Value() Registry {
	if !iter.page.NotDone() {
		return Registry{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RegistryListResultIterator type.
func NewRegistryListResultIterator(page RegistryListResultPage) RegistryListResultIterator {
	return RegistryListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rlr RegistryListResult) IsEmpty() bool {
	return rlr.Value == nil || len(*rlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rlr RegistryListResult) hasNextLink() bool {
	return rlr.NextLink != nil && len(*rlr.NextLink) != 0
}

// registryListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rlr RegistryListResult) registryListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rlr.NextLink)))
}

// RegistryListResultPage contains a page of Registry values.
type RegistryListResultPage struct {
	fn  func(context.Context, RegistryListResult) (RegistryListResult, error)
	rlr RegistryListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RegistryListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RegistryListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rlr)
		if err != nil {
			return err
		}
		page.rlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RegistryListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RegistryListResultPage) NotDone() bool {
	return !page.rlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RegistryListResultPage) Response() RegistryListResult {
	return page.rlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RegistryListResultPage) Values() []Registry {
	if page.rlr.IsEmpty() {
		return nil
	}
	return *page.rlr.Value
}

// Creates a new instance of the RegistryListResultPage type.
func NewRegistryListResultPage(cur RegistryListResult, getNextPage func(context.Context, RegistryListResult) (RegistryListResult, error)) RegistryListResultPage {
	return RegistryListResultPage{
		fn:  getNextPage,
		rlr: cur,
	}
}

// RegistryNameCheckRequest a request to check whether a container registry name is available.
type RegistryNameCheckRequest struct {
	// Name - The name of the container registry.
	Name *string `json:"name,omitempty"`
	// Type - The resource type of the container registry. This field must be set to 'Microsoft.ContainerRegistry/registries'.
	Type *string `json:"type,omitempty"`
}

// RegistryNameStatus the result of a request to check the availability of a container registry name.
type RegistryNameStatus struct {
	autorest.Response `json:"-"`
	// NameAvailable - The value that indicates whether the name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - If any, the reason that the name is not available.
	Reason *string `json:"reason,omitempty"`
	// Message - If any, the error message that provides more detail for the reason that the name is not available.
	Message *string `json:"message,omitempty"`
}

// RegistryPassword the login password for the container registry.
type RegistryPassword struct {
	// Name - The password name. Possible values include: 'Password', 'Password2'
	Name PasswordName `json:"name,omitempty"`
	// Value - The password value.
	Value *string `json:"value,omitempty"`
}

// RegistryPolicies an object that represents policies for a container registry.
type RegistryPolicies struct {
	autorest.Response `json:"-"`
	// QuarantinePolicy - An object that represents quarantine policy for a container registry.
	QuarantinePolicy *QuarantinePolicy `json:"quarantinePolicy,omitempty"`
	// TrustPolicy - An object that represents content trust policy for a container registry.
	TrustPolicy *TrustPolicy `json:"trustPolicy,omitempty"`
}

// RegistryProperties the properties of a container registry.
type RegistryProperties struct {
	// LoginServer - READ-ONLY; The URL that can be used to log into the container registry.
	LoginServer *string `json:"loginServer,omitempty"`
	// CreationDate - READ-ONLY; The creation date of the container registry in ISO8601 format.
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the container registry at the time the operation was called. Possible values include: 'ProvisioningStateCreating', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Status - READ-ONLY; The status of the container registry at the time the operation was called.
	Status *Status `json:"status,omitempty"`
	// AdminUserEnabled - The value that indicates whether the admin user is enabled.
	AdminUserEnabled *bool `json:"adminUserEnabled,omitempty"`
	// StorageAccount - The properties of the storage account for the container registry. Only applicable to Classic SKU.
	StorageAccount *StorageAccountProperties `json:"storageAccount,omitempty"`
	// NetworkRuleSet - The network rule set for a container registry.
	NetworkRuleSet *NetworkRuleSet `json:"networkRuleSet,omitempty"`
}

// MarshalJSON is the custom marshaler for RegistryProperties.
func (rp RegistryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rp.AdminUserEnabled != nil {
		objectMap["adminUserEnabled"] = rp.AdminUserEnabled
	}
	if rp.StorageAccount != nil {
		objectMap["storageAccount"] = rp.StorageAccount
	}
	if rp.NetworkRuleSet != nil {
		objectMap["networkRuleSet"] = rp.NetworkRuleSet
	}
	return json.Marshal(objectMap)
}

// RegistryPropertiesUpdateParameters the parameters for updating the properties of a container registry.
type RegistryPropertiesUpdateParameters struct {
	// AdminUserEnabled - The value that indicates whether the admin user is enabled.
	AdminUserEnabled *bool `json:"adminUserEnabled,omitempty"`
	// StorageAccount - The parameters of a storage account for the container registry. Only applicable to Classic SKU. If specified, the storage account must be in the same physical location as the container registry.
	StorageAccount *StorageAccountProperties `json:"storageAccount,omitempty"`
	// NetworkRuleSet - The network rule set for a container registry.
	NetworkRuleSet *NetworkRuleSet `json:"networkRuleSet,omitempty"`
}

// RegistryUpdateParameters the parameters for updating a container registry.
type RegistryUpdateParameters struct {
	// Tags - The tags for the container registry.
	Tags map[string]*string `json:"tags"`
	// Sku - The SKU of the container registry.
	Sku *Sku `json:"sku,omitempty"`
	// RegistryPropertiesUpdateParameters - The properties that the container registry will be updated with.
	*RegistryPropertiesUpdateParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for RegistryUpdateParameters.
func (rup RegistryUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rup.Tags != nil {
		objectMap["tags"] = rup.Tags
	}
	if rup.Sku != nil {
		objectMap["sku"] = rup.Sku
	}
	if rup.RegistryPropertiesUpdateParameters != nil {
		objectMap["properties"] = rup.RegistryPropertiesUpdateParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RegistryUpdateParameters struct.
func (rup *RegistryUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rup.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				rup.Sku = &sku
			}
		case "properties":
			if v != nil {
				var registryPropertiesUpdateParameters RegistryPropertiesUpdateParameters
				err = json.Unmarshal(*v, &registryPropertiesUpdateParameters)
				if err != nil {
					return err
				}
				rup.RegistryPropertiesUpdateParameters = &registryPropertiesUpdateParameters
			}
		}
	}

	return nil
}

// RegistryUsage the quota usage for a container registry.
type RegistryUsage struct {
	// Name - The name of the usage.
	Name *string `json:"name,omitempty"`
	// Limit - The limit of the usage.
	Limit *int64 `json:"limit,omitempty"`
	// CurrentValue - The current value of the usage.
	CurrentValue *int64 `json:"currentValue,omitempty"`
	// Unit - The unit of measurement. Possible values include: 'Count', 'Bytes'
	Unit RegistryUsageUnit `json:"unit,omitempty"`
}

// RegistryUsageListResult the result of a request to get container registry quota usages.
type RegistryUsageListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of container registry quota usages.
	Value *[]RegistryUsage `json:"value,omitempty"`
}

// Replication an object that represents a replication for a container registry.
type Replication struct {
	autorest.Response `json:"-"`
	// ReplicationProperties - The properties of the replication.
	*ReplicationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource. This cannot be changed after the resource is created.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Replication.
func (r Replication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ReplicationProperties != nil {
		objectMap["properties"] = r.ReplicationProperties
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Replication struct.
func (r *Replication) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var replicationProperties ReplicationProperties
				err = json.Unmarshal(*v, &replicationProperties)
				if err != nil {
					return err
				}
				r.ReplicationProperties = &replicationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				r.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				r.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				r.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				r.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				r.Tags = tags
			}
		}
	}

	return nil
}

// ReplicationListResult the result of a request to list replications for a container registry.
type ReplicationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of replications. Since this list may be incomplete, the nextLink field should be used to request the next list of replications.
	Value *[]Replication `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next list of replications.
	NextLink *string `json:"nextLink,omitempty"`
}

// ReplicationListResultIterator provides access to a complete listing of Replication values.
type ReplicationListResultIterator struct {
	i    int
	page ReplicationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ReplicationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ReplicationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ReplicationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ReplicationListResultIterator) Response() ReplicationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ReplicationListResultIterator) Value() Replication {
	if !iter.page.NotDone() {
		return Replication{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ReplicationListResultIterator type.
func NewReplicationListResultIterator(page ReplicationListResultPage) ReplicationListResultIterator {
	return ReplicationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rlr ReplicationListResult) IsEmpty() bool {
	return rlr.Value == nil || len(*rlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rlr ReplicationListResult) hasNextLink() bool {
	return rlr.NextLink != nil && len(*rlr.NextLink) != 0
}

// replicationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rlr ReplicationListResult) replicationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rlr.NextLink)))
}

// ReplicationListResultPage contains a page of Replication values.
type ReplicationListResultPage struct {
	fn  func(context.Context, ReplicationListResult) (ReplicationListResult, error)
	rlr ReplicationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ReplicationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rlr)
		if err != nil {
			return err
		}
		page.rlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ReplicationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ReplicationListResultPage) NotDone() bool {
	return !page.rlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ReplicationListResultPage) Response() ReplicationListResult {
	return page.rlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ReplicationListResultPage) Values() []Replication {
	if page.rlr.IsEmpty() {
		return nil
	}
	return *page.rlr.Value
}

// Creates a new instance of the ReplicationListResultPage type.
func NewReplicationListResultPage(cur ReplicationListResult, getNextPage func(context.Context, ReplicationListResult) (ReplicationListResult, error)) ReplicationListResultPage {
	return ReplicationListResultPage{
		fn:  getNextPage,
		rlr: cur,
	}
}

// ReplicationProperties the properties of a replication.
type ReplicationProperties struct {
	// ProvisioningState - READ-ONLY; The provisioning state of the replication at the time the operation was called. Possible values include: 'ProvisioningStateCreating', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Status - READ-ONLY; The status of the replication at the time the operation was called.
	Status *Status `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for ReplicationProperties.
func (rp ReplicationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ReplicationsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationsClient) (Replication, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReplicationsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReplicationsCreateFuture.Result.
func (future *ReplicationsCreateFuture) result(client ReplicationsClient) (r Replication, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.ReplicationsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		r.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerregistry.ReplicationsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if r.Response.Response, err = future.GetResult(sender); err == nil && r.Response.Response.StatusCode != http.StatusNoContent {
		r, err = client.CreateResponder(r.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.ReplicationsCreateFuture", "Result", r.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReplicationsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReplicationsDeleteFuture.Result.
func (future *ReplicationsDeleteFuture) result(client ReplicationsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.ReplicationsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerregistry.ReplicationsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ReplicationsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationsClient) (Replication, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReplicationsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReplicationsUpdateFuture.Result.
func (future *ReplicationsUpdateFuture) result(client ReplicationsClient) (r Replication, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.ReplicationsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		r.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerregistry.ReplicationsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if r.Response.Response, err = future.GetResult(sender); err == nil && r.Response.Response.StatusCode != http.StatusNoContent {
		r, err = client.UpdateResponder(r.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.ReplicationsUpdateFuture", "Result", r.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationUpdateParameters the parameters for updating a replication.
type ReplicationUpdateParameters struct {
	// Tags - The tags for the replication.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ReplicationUpdateParameters.
func (rup ReplicationUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rup.Tags != nil {
		objectMap["tags"] = rup.Tags
	}
	return json.Marshal(objectMap)
}

// Request the request that generated the event.
type Request struct {
	// ID - The ID of the request that initiated the event.
	ID *string `json:"id,omitempty"`
	// Addr - The IP or hostname and possibly port of the client connection that initiated the event. This is the RemoteAddr from the standard http request.
	Addr *string `json:"addr,omitempty"`
	// Host - The externally accessible hostname of the registry instance, as specified by the http host header on incoming requests.
	Host *string `json:"host,omitempty"`
	// Method - The request method that generated the event.
	Method *string `json:"method,omitempty"`
	// Useragent - The user agent header of the request.
	Useragent *string `json:"useragent,omitempty"`
}

// Resource an Azure resource.
type Resource struct {
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource. This cannot be changed after the resource is created.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// Sku the SKU of a container registry.
type Sku struct {
	// Name - The SKU name of the container registry. Required for registry creation. Possible values include: 'Classic', 'Basic', 'Standard', 'Premium'
	Name SkuName `json:"name,omitempty"`
	// Tier - READ-ONLY; The SKU tier based on the SKU name. Possible values include: 'SkuTierClassic', 'SkuTierBasic', 'SkuTierStandard', 'SkuTierPremium'
	Tier SkuTier `json:"tier,omitempty"`
}

// MarshalJSON is the custom marshaler for Sku.
func (s Sku) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.Name != "" {
		objectMap["name"] = s.Name
	}
	return json.Marshal(objectMap)
}

// Source the registry node that generated the event. Put differently, while the actor initiates the event,
// the source generates it.
type Source struct {
	// Addr - The IP or hostname and the port of the registry node that generated the event. Generally, this will be resolved by os.Hostname() along with the running port.
	Addr *string `json:"addr,omitempty"`
	// InstanceID - The running instance of an application. Changes after each restart.
	InstanceID *string `json:"instanceID,omitempty"`
}

// SourceControlAuthInfo the authorization properties for accessing the source code repository.
type SourceControlAuthInfo struct {
	// TokenType - The type of Auth token. Possible values include: 'PAT', 'OAuth'
	TokenType TokenType `json:"tokenType,omitempty"`
	// Token - The access token used to access the source control provider.
	Token *string `json:"token,omitempty"`
	// RefreshToken - The refresh token used to refresh the access token.
	RefreshToken *string `json:"refreshToken,omitempty"`
	// Scope - The scope of the access token.
	Scope *string `json:"scope,omitempty"`
	// ExpiresIn - Time in seconds that the token remains valid
	ExpiresIn *int32 `json:"expiresIn,omitempty"`
}

// SourceRepositoryProperties the properties of the source code repository.
type SourceRepositoryProperties struct {
	autorest.Response `json:"-"`
	// SourceControlType - The type of source control service. Possible values include: 'Github', 'VisualStudioTeamService'
	SourceControlType SourceControlType `json:"sourceControlType,omitempty"`
	// RepositoryURL - The full URL to the source code repository
	RepositoryURL *string `json:"repositoryUrl,omitempty"`
	// IsCommitTriggerEnabled - The value of this property indicates whether the source control commit trigger is enabled or not.
	IsCommitTriggerEnabled *bool `json:"isCommitTriggerEnabled,omitempty"`
	// SourceControlAuthProperties - The authorization properties for accessing the source code repository.
	SourceControlAuthProperties *SourceControlAuthInfo `json:"sourceControlAuthProperties,omitempty"`
}

// SourceRepositoryUpdateParameters the properties for updating the source code repository configuration.
type SourceRepositoryUpdateParameters struct {
	// SourceControlAuthProperties - The authorization properties for accessing the source code repository.
	SourceControlAuthProperties *SourceControlAuthInfo `json:"sourceControlAuthProperties,omitempty"`
	// IsCommitTriggerEnabled - The value of this property indicates whether the source control commit trigger is enabled or not.
	IsCommitTriggerEnabled *bool `json:"isCommitTriggerEnabled,omitempty"`
}

// SourceUploadDefinition the properties of a response to source upload request.
type SourceUploadDefinition struct {
	autorest.Response `json:"-"`
	// UploadURL - The URL where the client can upload the source.
	UploadURL *string `json:"uploadUrl,omitempty"`
	// RelativePath - The relative path to the source. This is used to submit the subsequent queue build request.
	RelativePath *string `json:"relativePath,omitempty"`
}

// Status the status of an Azure resource at the time the operation was called.
type Status struct {
	// DisplayStatus - READ-ONLY; The short label for the status.
	DisplayStatus *string `json:"displayStatus,omitempty"`
	// Message - READ-ONLY; The detailed message for the status, including alerts and error messages.
	Message *string `json:"message,omitempty"`
	// Timestamp - READ-ONLY; The timestamp when the status was changed to the current value.
	Timestamp *date.Time `json:"timestamp,omitempty"`
}

// MarshalJSON is the custom marshaler for Status.
func (s Status) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// StorageAccountProperties the properties of a storage account for a container registry. Only applicable
// to Classic SKU.
type StorageAccountProperties struct {
	// ID - The resource ID of the storage account.
	ID *string `json:"id,omitempty"`
}

// Target the target of the event.
type Target struct {
	// MediaType - The MIME type of the referenced object.
	MediaType *string `json:"mediaType,omitempty"`
	// Size - The number of bytes of the content. Same as Length field.
	Size *int64 `json:"size,omitempty"`
	// Digest - The digest of the content, as defined by the Registry V2 HTTP API Specification.
	Digest *string `json:"digest,omitempty"`
	// Length - The number of bytes of the content. Same as Size field.
	Length *int64 `json:"length,omitempty"`
	// Repository - The repository name.
	Repository *string `json:"repository,omitempty"`
	// URL - The direct URL to the content.
	URL *string `json:"url,omitempty"`
	// Tag - The tag name.
	Tag *string `json:"tag,omitempty"`
	// Name - The name of the artifact.
	Name *string `json:"name,omitempty"`
	// Version - The version of the artifact.
	Version *string `json:"version,omitempty"`
}

// TrustPolicy an object that represents content trust policy for a container registry.
type TrustPolicy struct {
	// Type - The type of trust policy. Possible values include: 'Notary'
	Type TrustPolicyType `json:"type,omitempty"`
	// Status - The value that indicates whether the policy is enabled or not. Possible values include: 'PolicyStatusEnabled', 'PolicyStatusDisabled'
	Status PolicyStatus `json:"status,omitempty"`
}

// VirtualNetworkRule virtual network rule.
type VirtualNetworkRule struct {
	// Action - The action of virtual network rule. Possible values include: 'Allow'
	Action Action `json:"action,omitempty"`
	// VirtualNetworkResourceID - Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
	VirtualNetworkResourceID *string `json:"id,omitempty"`
}

// Webhook an object that represents a webhook for a container registry.
type Webhook struct {
	autorest.Response `json:"-"`
	// WebhookProperties - The properties of the webhook.
	*WebhookProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource. This cannot be changed after the resource is created.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Webhook.
func (w Webhook) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if w.WebhookProperties != nil {
		objectMap["properties"] = w.WebhookProperties
	}
	if w.Location != nil {
		objectMap["location"] = w.Location
	}
	if w.Tags != nil {
		objectMap["tags"] = w.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Webhook struct.
func (w *Webhook) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var webhookProperties WebhookProperties
				err = json.Unmarshal(*v, &webhookProperties)
				if err != nil {
					return err
				}
				w.WebhookProperties = &webhookProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				w.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				w.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				w.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				w.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				w.Tags = tags
			}
		}
	}

	return nil
}

// WebhookCreateParameters the parameters for creating a webhook.
type WebhookCreateParameters struct {
	// Tags - The tags for the webhook.
	Tags map[string]*string `json:"tags"`
	// Location - The location of the webhook. This cannot be changed after the resource is created.
	Location *string `json:"location,omitempty"`
	// WebhookPropertiesCreateParameters - The properties that the webhook will be created with.
	*WebhookPropertiesCreateParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for WebhookCreateParameters.
func (wcp WebhookCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wcp.Tags != nil {
		objectMap["tags"] = wcp.Tags
	}
	if wcp.Location != nil {
		objectMap["location"] = wcp.Location
	}
	if wcp.WebhookPropertiesCreateParameters != nil {
		objectMap["properties"] = wcp.WebhookPropertiesCreateParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WebhookCreateParameters struct.
func (wcp *WebhookCreateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				wcp.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				wcp.Location = &location
			}
		case "properties":
			if v != nil {
				var webhookPropertiesCreateParameters WebhookPropertiesCreateParameters
				err = json.Unmarshal(*v, &webhookPropertiesCreateParameters)
				if err != nil {
					return err
				}
				wcp.WebhookPropertiesCreateParameters = &webhookPropertiesCreateParameters
			}
		}
	}

	return nil
}

// WebhookListResult the result of a request to list webhooks for a container registry.
type WebhookListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of webhooks. Since this list may be incomplete, the nextLink field should be used to request the next list of webhooks.
	Value *[]Webhook `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next list of webhooks.
	NextLink *string `json:"nextLink,omitempty"`
}

// WebhookListResultIterator provides access to a complete listing of Webhook values.
type WebhookListResultIterator struct {
	i    int
	page WebhookListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WebhookListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WebhookListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WebhookListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WebhookListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WebhookListResultIterator) Response() WebhookListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WebhookListResultIterator) Value() Webhook {
	if !iter.page.NotDone() {
		return Webhook{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WebhookListResultIterator type.
func NewWebhookListResultIterator(page WebhookListResultPage) WebhookListResultIterator {
	return WebhookListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wlr WebhookListResult) IsEmpty() bool {
	return wlr.Value == nil || len(*wlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wlr WebhookListResult) hasNextLink() bool {
	return wlr.NextLink != nil && len(*wlr.NextLink) != 0
}

// webhookListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wlr WebhookListResult) webhookListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !wlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wlr.NextLink)))
}

// WebhookListResultPage contains a page of Webhook values.
type WebhookListResultPage struct {
	fn  func(context.Context, WebhookListResult) (WebhookListResult, error)
	wlr WebhookListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WebhookListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WebhookListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wlr)
		if err != nil {
			return err
		}
		page.wlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WebhookListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WebhookListResultPage) NotDone() bool {
	return !page.wlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WebhookListResultPage) Response() WebhookListResult {
	return page.wlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WebhookListResultPage) Values() []Webhook {
	if page.wlr.IsEmpty() {
		return nil
	}
	return *page.wlr.Value
}

// Creates a new instance of the WebhookListResultPage type.
func NewWebhookListResultPage(cur WebhookListResult, getNextPage func(context.Context, WebhookListResult) (WebhookListResult, error)) WebhookListResultPage {
	return WebhookListResultPage{
		fn:  getNextPage,
		wlr: cur,
	}
}

// WebhookProperties the properties of a webhook.
type WebhookProperties struct {
	// Status - The status of the webhook at the time the operation was called. Possible values include: 'WebhookStatusEnabled', 'WebhookStatusDisabled'
	Status WebhookStatus `json:"status,omitempty"`
	// Scope - The scope of repositories where the event can be triggered. For example, 'foo:*' means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only. 'foo' is equivalent to 'foo:latest'. Empty means all events.
	Scope *string `json:"scope,omitempty"`
	// Actions - The list of actions that trigger the webhook to post notifications.
	Actions *[]WebhookAction `json:"actions,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the webhook at the time the operation was called. Possible values include: 'ProvisioningStateCreating', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for WebhookProperties.
func (wp WebhookProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wp.Status != "" {
		objectMap["status"] = wp.Status
	}
	if wp.Scope != nil {
		objectMap["scope"] = wp.Scope
	}
	if wp.Actions != nil {
		objectMap["actions"] = wp.Actions
	}
	return json.Marshal(objectMap)
}

// WebhookPropertiesCreateParameters the parameters for creating the properties of a webhook.
type WebhookPropertiesCreateParameters struct {
	// ServiceURI - The service URI for the webhook to post notifications.
	ServiceURI *string `json:"serviceUri,omitempty"`
	// CustomHeaders - Custom headers that will be added to the webhook notifications.
	CustomHeaders map[string]*string `json:"customHeaders"`
	// Status - The status of the webhook at the time the operation was called. Possible values include: 'WebhookStatusEnabled', 'WebhookStatusDisabled'
	Status WebhookStatus `json:"status,omitempty"`
	// Scope - The scope of repositories where the event can be triggered. For example, 'foo:*' means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only. 'foo' is equivalent to 'foo:latest'. Empty means all events.
	Scope *string `json:"scope,omitempty"`
	// Actions - The list of actions that trigger the webhook to post notifications.
	Actions *[]WebhookAction `json:"actions,omitempty"`
}

// MarshalJSON is the custom marshaler for WebhookPropertiesCreateParameters.
func (wpcp WebhookPropertiesCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wpcp.ServiceURI != nil {
		objectMap["serviceUri"] = wpcp.ServiceURI
	}
	if wpcp.CustomHeaders != nil {
		objectMap["customHeaders"] = wpcp.CustomHeaders
	}
	if wpcp.Status != "" {
		objectMap["status"] = wpcp.Status
	}
	if wpcp.Scope != nil {
		objectMap["scope"] = wpcp.Scope
	}
	if wpcp.Actions != nil {
		objectMap["actions"] = wpcp.Actions
	}
	return json.Marshal(objectMap)
}

// WebhookPropertiesUpdateParameters the parameters for updating the properties of a webhook.
type WebhookPropertiesUpdateParameters struct {
	// ServiceURI - The service URI for the webhook to post notifications.
	ServiceURI *string `json:"serviceUri,omitempty"`
	// CustomHeaders - Custom headers that will be added to the webhook notifications.
	CustomHeaders map[string]*string `json:"customHeaders"`
	// Status - The status of the webhook at the time the operation was called. Possible values include: 'WebhookStatusEnabled', 'WebhookStatusDisabled'
	Status WebhookStatus `json:"status,omitempty"`
	// Scope - The scope of repositories where the event can be triggered. For example, 'foo:*' means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only. 'foo' is equivalent to 'foo:latest'. Empty means all events.
	Scope *string `json:"scope,omitempty"`
	// Actions - The list of actions that trigger the webhook to post notifications.
	Actions *[]WebhookAction `json:"actions,omitempty"`
}

// MarshalJSON is the custom marshaler for WebhookPropertiesUpdateParameters.
func (wpup WebhookPropertiesUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wpup.ServiceURI != nil {
		objectMap["serviceUri"] = wpup.ServiceURI
	}
	if wpup.CustomHeaders != nil {
		objectMap["customHeaders"] = wpup.CustomHeaders
	}
	if wpup.Status != "" {
		objectMap["status"] = wpup.Status
	}
	if wpup.Scope != nil {
		objectMap["scope"] = wpup.Scope
	}
	if wpup.Actions != nil {
		objectMap["actions"] = wpup.Actions
	}
	return json.Marshal(objectMap)
}

// WebhooksCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type WebhooksCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WebhooksClient) (Webhook, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WebhooksCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WebhooksCreateFuture.Result.
func (future *WebhooksCreateFuture) result(client WebhooksClient) (w Webhook, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.WebhooksCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		w.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerregistry.WebhooksCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if w.Response.Response, err = future.GetResult(sender); err == nil && w.Response.Response.StatusCode != http.StatusNoContent {
		w, err = client.CreateResponder(w.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.WebhooksCreateFuture", "Result", w.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WebhooksDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type WebhooksDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WebhooksClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WebhooksDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WebhooksDeleteFuture.Result.
func (future *WebhooksDeleteFuture) result(client WebhooksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.WebhooksDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerregistry.WebhooksDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// WebhooksUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type WebhooksUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WebhooksClient) (Webhook, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WebhooksUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WebhooksUpdateFuture.Result.
func (future *WebhooksUpdateFuture) result(client WebhooksClient) (w Webhook, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.WebhooksUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		w.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerregistry.WebhooksUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if w.Response.Response, err = future.GetResult(sender); err == nil && w.Response.Response.StatusCode != http.StatusNoContent {
		w, err = client.UpdateResponder(w.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.WebhooksUpdateFuture", "Result", w.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WebhookUpdateParameters the parameters for updating a webhook.
type WebhookUpdateParameters struct {
	// Tags - The tags for the webhook.
	Tags map[string]*string `json:"tags"`
	// WebhookPropertiesUpdateParameters - The properties that the webhook will be updated with.
	*WebhookPropertiesUpdateParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for WebhookUpdateParameters.
func (wup WebhookUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wup.Tags != nil {
		objectMap["tags"] = wup.Tags
	}
	if wup.WebhookPropertiesUpdateParameters != nil {
		objectMap["properties"] = wup.WebhookPropertiesUpdateParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WebhookUpdateParameters struct.
func (wup *WebhookUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				wup.Tags = tags
			}
		case "properties":
			if v != nil {
				var webhookPropertiesUpdateParameters WebhookPropertiesUpdateParameters
				err = json.Unmarshal(*v, &webhookPropertiesUpdateParameters)
				if err != nil {
					return err
				}
				wup.WebhookPropertiesUpdateParameters = &webhookPropertiesUpdateParameters
			}
		}
	}

	return nil
}
