// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package greengrassv2

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAssociateServiceRoleToAccount = "AssociateServiceRoleToAccount"

// AssociateServiceRoleToAccountRequest generates a "aws/request.Request" representing the
// client's request for the AssociateServiceRoleToAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateServiceRoleToAccount for more information on using the AssociateServiceRoleToAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateServiceRoleToAccountRequest method.
//    req, resp := client.AssociateServiceRoleToAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/AssociateServiceRoleToAccount
func (c *GreengrassV2) AssociateServiceRoleToAccountRequest(input *AssociateServiceRoleToAccountInput) (req *request.Request, output *AssociateServiceRoleToAccountOutput) {
	op := &request.Operation{
		Name:       opAssociateServiceRoleToAccount,
		HTTPMethod: "PUT",
		HTTPPath:   "/greengrass/servicerole",
	}

	if input == nil {
		input = &AssociateServiceRoleToAccountInput{}
	}

	output = &AssociateServiceRoleToAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateServiceRoleToAccount API operation for AWS IoT Greengrass V2.
//
// Associates a Greengrass service role with IoT Greengrass for your Amazon
// Web Services account in this Amazon Web Services Region. IoT Greengrass uses
// this role to verify the identity of client devices and manage core device
// connectivity information. The role must include the AWSGreengrassResourceAccessRolePolicy
// (https://console.aws.amazon.com/iam/home#/policies/arn:awsiam::aws:policy/service-role/AWSGreengrassResourceAccessRolePolicy)
// managed policy or a custom policy that defines equivalent permissions for
// the IoT Greengrass features that you use. For more information, see Greengrass
// service role (https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-service-role.html)
// in the IoT Greengrass Version 2 Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Greengrass V2's
// API operation AssociateServiceRoleToAccount for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters.
//
//   * InternalServerException
//   IoT Greengrass can't process your request right now. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/AssociateServiceRoleToAccount
func (c *GreengrassV2) AssociateServiceRoleToAccount(input *AssociateServiceRoleToAccountInput) (*AssociateServiceRoleToAccountOutput, error) {
	req, out := c.AssociateServiceRoleToAccountRequest(input)
	return out, req.Send()
}

// AssociateServiceRoleToAccountWithContext is the same as AssociateServiceRoleToAccount with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateServiceRoleToAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GreengrassV2) AssociateServiceRoleToAccountWithContext(ctx aws.Context, input *AssociateServiceRoleToAccountInput, opts ...request.Option) (*AssociateServiceRoleToAccountOutput, error) {
	req, out := c.AssociateServiceRoleToAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchAssociateClientDeviceWithCoreDevice = "BatchAssociateClientDeviceWithCoreDevice"

// BatchAssociateClientDeviceWithCoreDeviceRequest generates a "aws/request.Request" representing the
// client's request for the BatchAssociateClientDeviceWithCoreDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchAssociateClientDeviceWithCoreDevice for more information on using the BatchAssociateClientDeviceWithCoreDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchAssociateClientDeviceWithCoreDeviceRequest method.
//    req, resp := client.BatchAssociateClientDeviceWithCoreDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/BatchAssociateClientDeviceWithCoreDevice
func (c *GreengrassV2) BatchAssociateClientDeviceWithCoreDeviceRequest(input *BatchAssociateClientDeviceWithCoreDeviceInput) (req *request.Request, output *BatchAssociateClientDeviceWithCoreDeviceOutput) {
	op := &request.Operation{
		Name:       opBatchAssociateClientDeviceWithCoreDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/v2/coreDevices/{coreDeviceThingName}/associateClientDevices",
	}

	if input == nil {
		input = &BatchAssociateClientDeviceWithCoreDeviceInput{}
	}

	output = &BatchAssociateClientDeviceWithCoreDeviceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchAssociateClientDeviceWithCoreDevice API operation for AWS IoT Greengrass V2.
//
// Associates a list of client devices with a core device. Use this API operation
// to specify which client devices can discover a core device through cloud
// discovery. With cloud discovery, client devices connect to IoT Greengrass
// to retrieve associated core devices' connectivity information and certificates.
// For more information, see Configure cloud discovery (https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-cloud-discovery.html)
// in the IoT Greengrass V2 Developer Guide.
//
// Client devices are local IoT devices that connect to and communicate with
// an IoT Greengrass core device over MQTT. You can connect client devices to
// a core device to sync MQTT messages and data to Amazon Web Services IoT Core
// and interact with client devices in Greengrass components. For more information,
// see Interact with local IoT devices (https://docs.aws.amazon.com/greengrass/v2/developerguide/interact-with-local-iot-devices.html)
// in the IoT Greengrass V2 Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Greengrass V2's
// API operation BatchAssociateClientDeviceWithCoreDevice for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * AccessDeniedException
//   You don't have permission to perform the action.
//
//   * InternalServerException
//   IoT Greengrass can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a request rate quota. For example, you might have exceeded
//   the amount of times that you can retrieve device or deployment status per
//   second.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/BatchAssociateClientDeviceWithCoreDevice
func (c *GreengrassV2) BatchAssociateClientDeviceWithCoreDevice(input *BatchAssociateClientDeviceWithCoreDeviceInput) (*BatchAssociateClientDeviceWithCoreDeviceOutput, error) {
	req, out := c.BatchAssociateClientDeviceWithCoreDeviceRequest(input)
	return out, req.Send()
}

// BatchAssociateClientDeviceWithCoreDeviceWithContext is the same as BatchAssociateClientDeviceWithCoreDevice with the addition of
// the ability to pass a context and additional request options.
//
// See BatchAssociateClientDeviceWithCoreDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GreengrassV2) BatchAssociateClientDeviceWithCoreDeviceWithContext(ctx aws.Context, input *BatchAssociateClientDeviceWithCoreDeviceInput, opts ...request.Option) (*BatchAssociateClientDeviceWithCoreDeviceOutput, error) {
	req, out := c.BatchAssociateClientDeviceWithCoreDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDisassociateClientDeviceFromCoreDevice = "BatchDisassociateClientDeviceFromCoreDevice"

// BatchDisassociateClientDeviceFromCoreDeviceRequest generates a "aws/request.Request" representing the
// client's request for the BatchDisassociateClientDeviceFromCoreDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDisassociateClientDeviceFromCoreDevice for more information on using the BatchDisassociateClientDeviceFromCoreDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDisassociateClientDeviceFromCoreDeviceRequest method.
//    req, resp := client.BatchDisassociateClientDeviceFromCoreDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/BatchDisassociateClientDeviceFromCoreDevice
func (c *GreengrassV2) BatchDisassociateClientDeviceFromCoreDeviceRequest(input *BatchDisassociateClientDeviceFromCoreDeviceInput) (req *request.Request, output *BatchDisassociateClientDeviceFromCoreDeviceOutput) {
	op := &request.Operation{
		Name:       opBatchDisassociateClientDeviceFromCoreDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/v2/coreDevices/{coreDeviceThingName}/disassociateClientDevices",
	}

	if input == nil {
		input = &BatchDisassociateClientDeviceFromCoreDeviceInput{}
	}

	output = &BatchDisassociateClientDeviceFromCoreDeviceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDisassociateClientDeviceFromCoreDevice API operation for AWS IoT Greengrass V2.
//
// Disassociates a list of client devices from a core device. After you disassociate
// a client device from a core device, the client device won't be able to use
// cloud discovery to retrieve the core device's connectivity information and
// certificates.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Greengrass V2's
// API operation BatchDisassociateClientDeviceFromCoreDevice for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * AccessDeniedException
//   You don't have permission to perform the action.
//
//   * InternalServerException
//   IoT Greengrass can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a request rate quota. For example, you might have exceeded
//   the amount of times that you can retrieve device or deployment status per
//   second.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/BatchDisassociateClientDeviceFromCoreDevice
func (c *GreengrassV2) BatchDisassociateClientDeviceFromCoreDevice(input *BatchDisassociateClientDeviceFromCoreDeviceInput) (*BatchDisassociateClientDeviceFromCoreDeviceOutput, error) {
	req, out := c.BatchDisassociateClientDeviceFromCoreDeviceRequest(input)
	return out, req.Send()
}

// BatchDisassociateClientDeviceFromCoreDeviceWithContext is the same as BatchDisassociateClientDeviceFromCoreDevice with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDisassociateClientDeviceFromCoreDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GreengrassV2) BatchDisassociateClientDeviceFromCoreDeviceWithContext(ctx aws.Context, input *BatchDisassociateClientDeviceFromCoreDeviceInput, opts ...request.Option) (*BatchDisassociateClientDeviceFromCoreDeviceOutput, error) {
	req, out := c.BatchDisassociateClientDeviceFromCoreDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelDeployment = "CancelDeployment"

// CancelDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the CancelDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelDeployment for more information on using the CancelDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelDeploymentRequest method.
//    req, resp := client.CancelDeploymentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/CancelDeployment
func (c *GreengrassV2) CancelDeploymentRequest(input *CancelDeploymentInput) (req *request.Request, output *CancelDeploymentOutput) {
	op := &request.Operation{
		Name:       opCancelDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/v2/deployments/{deploymentId}/cancel",
	}

	if input == nil {
		input = &CancelDeploymentInput{}
	}

	output = &CancelDeploymentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelDeployment API operation for AWS IoT Greengrass V2.
//
// Cancels a deployment. This operation cancels the deployment for devices that
// haven't yet received it. If a device already received the deployment, this
// operation doesn't change anything for that device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Greengrass V2's
// API operation CancelDeployment for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * ValidationException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters.
//
//   * AccessDeniedException
//   You don't have permission to perform the action.
//
//   * InternalServerException
//   IoT Greengrass can't process your request right now. Try again later.
//
//   * ConflictException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
//   * ThrottlingException
//   Your request exceeded a request rate quota. For example, you might have exceeded
//   the amount of times that you can retrieve device or deployment status per
//   second.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/CancelDeployment
func (c *GreengrassV2) CancelDeployment(input *CancelDeploymentInput) (*CancelDeploymentOutput, error) {
	req, out := c.CancelDeploymentRequest(input)
	return out, req.Send()
}

// CancelDeploymentWithContext is the same as CancelDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See CancelDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GreengrassV2) CancelDeploymentWithContext(ctx aws.Context, input *CancelDeploymentInput, opts ...request.Option) (*CancelDeploymentOutput, error) {
	req, out := c.CancelDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateComponentVersion = "CreateComponentVersion"

// CreateComponentVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateComponentVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateComponentVersion for more information on using the CreateComponentVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateComponentVersionRequest method.
//    req, resp := client.CreateComponentVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/CreateComponentVersion
func (c *GreengrassV2) CreateComponentVersionRequest(input *CreateComponentVersionInput) (req *request.Request, output *CreateComponentVersionOutput) {
	op := &request.Operation{
		Name:       opCreateComponentVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/v2/createComponentVersion",
	}

	if input == nil {
		input = &CreateComponentVersionInput{}
	}

	output = &CreateComponentVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateComponentVersion API operation for AWS IoT Greengrass V2.
//
// Creates a component. Components are software that run on Greengrass core
// devices. After you develop and test a component on your core device, you
// can use this operation to upload your component to IoT Greengrass. Then,
// you can deploy the component to other core devices.
//
// You can use this operation to do the following:
//
//    * Create components from recipes Create a component from a recipe, which
//    is a file that defines the component's metadata, parameters, dependencies,
//    lifecycle, artifacts, and platform capability. For more information, see
//    IoT Greengrass component recipe reference (https://docs.aws.amazon.com/greengrass/v2/developerguide/component-recipe-reference.html)
//    in the IoT Greengrass V2 Developer Guide. To create a component from a
//    recipe, specify inlineRecipe when you call this operation.
//
//    * Create components from Lambda functions Create a component from an Lambda
//    function that runs on IoT Greengrass. This creates a recipe and artifacts
//    from the Lambda function's deployment package. You can use this operation
//    to migrate Lambda functions from IoT Greengrass V1 to IoT Greengrass V2.
//    This function only accepts Lambda functions that use the following runtimes:
//    Python 2.7 – python2.7 Python 3.7 – python3.7 Python 3.8 – python3.8
//    Java 8 – java8 Node.js 10 – nodejs10.x Node.js 12 – nodejs12.x To
//    create a component from a Lambda function, specify lambdaFunction when
//    you call this operation. IoT Greengrass currently supports Lambda functions
//    on only Linux core devices.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Greengrass V2's
// API operation CreateComponentVersion for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters.
//
//   * ServiceQuotaExceededException
//   Your request exceeds a service quota. For example, you might have the maximum
//   number of components that you can create.
//
//   * AccessDeniedException
//   You don't have permission to perform the action.
//
//   * ConflictException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
//   * ThrottlingException
//   Your request exceeded a request rate quota. For example, you might have exceeded
//   the amount of times that you can retrieve device or deployment status per
//   second.
//
//   * InternalServerException
//   IoT Greengrass can't process your request right now. Try again later.
//
//   * RequestAlreadyInProgressException
//   The request is already in progress. This exception occurs when you use a
//   client token for multiple requests while IoT Greengrass is still processing
//   an earlier request that uses the same client token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/CreateComponentVersion
func (c *GreengrassV2) CreateComponentVersion(input *CreateComponentVersionInput) (*CreateComponentVersionOutput, error) {
	req, out := c.CreateComponentVersionRequest(input)
	return out, req.Send()
}

// CreateComponentVersionWithContext is the same as CreateComponentVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateComponentVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GreengrassV2) CreateComponentVersionWithContext(ctx aws.Context, input *CreateComponentVersionInput, opts ...request.Option) (*CreateComponentVersionOutput, error) {
	req, out := c.CreateComponentVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDeployment = "CreateDeployment"

// CreateDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the CreateDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDeployment for more information on using the CreateDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDeploymentRequest method.
//    req, resp := client.CreateDeploymentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/CreateDeployment
func (c *GreengrassV2) CreateDeploymentRequest(input *CreateDeploymentInput) (req *request.Request, output *CreateDeploymentOutput) {
	op := &request.Operation{
		Name:       opCreateDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/v2/deployments",
	}

	if input == nil {
		input = &CreateDeploymentInput{}
	}

	output = &CreateDeploymentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDeployment API operation for AWS IoT Greengrass V2.
//
// Creates a continuous deployment for a target, which is a Greengrass core
// device or group of core devices. When you add a new core device to a group
// of core devices that has a deployment, IoT Greengrass deploys that group's
// deployment to the new device.
//
// You can define one deployment for each target. When you create a new deployment
// for a target that has an existing deployment, you replace the previous deployment.
// IoT Greengrass applies the new deployment to the target devices.
//
// Every deployment has a revision number that indicates how many deployment
// revisions you define for a target. Use this operation to create a new revision
// of an existing deployment. This operation returns the revision number of
// the new deployment when you create it.
//
// For more information, see the Create deployments (https://docs.aws.amazon.com/greengrass/v2/developerguide/create-deployments.html)
// in the IoT Greengrass V2 Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Greengrass V2's
// API operation CreateDeployment for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * ValidationException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters.
//
//   * AccessDeniedException
//   You don't have permission to perform the action.
//
//   * ThrottlingException
//   Your request exceeded a request rate quota. For example, you might have exceeded
//   the amount of times that you can retrieve device or deployment status per
//   second.
//
//   * InternalServerException
//   IoT Greengrass can't process your request right now. Try again later.
//
//   * RequestAlreadyInProgressException
//   The request is already in progress. This exception occurs when you use a
//   client token for multiple requests while IoT Greengrass is still processing
//   an earlier request that uses the same client token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/CreateDeployment
func (c *GreengrassV2) CreateDeployment(input *CreateDeploymentInput) (*CreateDeploymentOutput, error) {
	req, out := c.CreateDeploymentRequest(input)
	return out, req.Send()
}

// CreateDeploymentWithContext is the same as CreateDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GreengrassV2) CreateDeploymentWithContext(ctx aws.Context, input *CreateDeploymentInput, opts ...request.Option) (*CreateDeploymentOutput, error) {
	req, out := c.CreateDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteComponent = "DeleteComponent"

// DeleteComponentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteComponent for more information on using the DeleteComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteComponentRequest method.
//    req, resp := client.DeleteComponentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/DeleteComponent
func (c *GreengrassV2) DeleteComponentRequest(input *DeleteComponentInput) (req *request.Request, output *DeleteComponentOutput) {
	op := &request.Operation{
		Name:       opDeleteComponent,
		HTTPMethod: "DELETE",
		HTTPPath:   "/greengrass/v2/components/{arn}",
	}

	if input == nil {
		input = &DeleteComponentInput{}
	}

	output = &DeleteComponentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteComponent API operation for AWS IoT Greengrass V2.
//
// Deletes a version of a component from IoT Greengrass.
//
// This operation deletes the component's recipe and artifacts. As a result,
// deployments that refer to this component version will fail. If you have deployments
// that use this component version, you can remove the component from the deployment
// or update the deployment to use a valid version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Greengrass V2's
// API operation DeleteComponent for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters.
//
//   * AccessDeniedException
//   You don't have permission to perform the action.
//
//   * ConflictException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * ThrottlingException
//   Your request exceeded a request rate quota. For example, you might have exceeded
//   the amount of times that you can retrieve device or deployment status per
//   second.
//
//   * InternalServerException
//   IoT Greengrass can't process your request right now. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/DeleteComponent
func (c *GreengrassV2) DeleteComponent(input *DeleteComponentInput) (*DeleteComponentOutput, error) {
	req, out := c.DeleteComponentRequest(input)
	return out, req.Send()
}

// DeleteComponentWithContext is the same as DeleteComponent with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GreengrassV2) DeleteComponentWithContext(ctx aws.Context, input *DeleteComponentInput, opts ...request.Option) (*DeleteComponentOutput, error) {
	req, out := c.DeleteComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCoreDevice = "DeleteCoreDevice"

// DeleteCoreDeviceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCoreDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCoreDevice for more information on using the DeleteCoreDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCoreDeviceRequest method.
//    req, resp := client.DeleteCoreDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/DeleteCoreDevice
func (c *GreengrassV2) DeleteCoreDeviceRequest(input *DeleteCoreDeviceInput) (req *request.Request, output *DeleteCoreDeviceOutput) {
	op := &request.Operation{
		Name:       opDeleteCoreDevice,
		HTTPMethod: "DELETE",
		HTTPPath:   "/greengrass/v2/coreDevices/{coreDeviceThingName}",
	}

	if input == nil {
		input = &DeleteCoreDeviceInput{}
	}

	output = &DeleteCoreDeviceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCoreDevice API operation for AWS IoT Greengrass V2.
//
// Deletes a Greengrass core device, which is an IoT thing. This operation removes
// the core device from the list of core devices. This operation doesn't delete
// the IoT thing. For more information about how to delete the IoT thing, see
// DeleteThing (https://docs.aws.amazon.com/iot/latest/apireference/API_DeleteThing.html)
// in the IoT API Reference.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Greengrass V2's
// API operation DeleteCoreDevice for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * AccessDeniedException
//   You don't have permission to perform the action.
//
//   * InternalServerException
//   IoT Greengrass can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a request rate quota. For example, you might have exceeded
//   the amount of times that you can retrieve device or deployment status per
//   second.
//
//   * ConflictException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/DeleteCoreDevice
func (c *GreengrassV2) DeleteCoreDevice(input *DeleteCoreDeviceInput) (*DeleteCoreDeviceOutput, error) {
	req, out := c.DeleteCoreDeviceRequest(input)
	return out, req.Send()
}

// DeleteCoreDeviceWithContext is the same as DeleteCoreDevice with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCoreDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GreengrassV2) DeleteCoreDeviceWithContext(ctx aws.Context, input *DeleteCoreDeviceInput, opts ...request.Option) (*DeleteCoreDeviceOutput, error) {
	req, out := c.DeleteCoreDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeComponent = "DescribeComponent"

// DescribeComponentRequest generates a "aws/request.Request" representing the
// client's request for the DescribeComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeComponent for more information on using the DescribeComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeComponentRequest method.
//    req, resp := client.DescribeComponentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/DescribeComponent
func (c *GreengrassV2) DescribeComponentRequest(input *DescribeComponentInput) (req *request.Request, output *DescribeComponentOutput) {
	op := &request.Operation{
		Name:       opDescribeComponent,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/v2/components/{arn}/metadata",
	}

	if input == nil {
		input = &DescribeComponentInput{}
	}

	output = &DescribeComponentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeComponent API operation for AWS IoT Greengrass V2.
//
// Retrieves metadata for a version of a component.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Greengrass V2's
// API operation DescribeComponent for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters.
//
//   * AccessDeniedException
//   You don't have permission to perform the action.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * ThrottlingException
//   Your request exceeded a request rate quota. For example, you might have exceeded
//   the amount of times that you can retrieve device or deployment status per
//   second.
//
//   * InternalServerException
//   IoT Greengrass can't process your request right now. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/DescribeComponent
func (c *GreengrassV2) DescribeComponent(input *DescribeComponentInput) (*DescribeComponentOutput, error) {
	req, out := c.DescribeComponentRequest(input)
	return out, req.Send()
}

// DescribeComponentWithContext is the same as DescribeComponent with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GreengrassV2) DescribeComponentWithContext(ctx aws.Context, input *DescribeComponentInput, opts ...request.Option) (*DescribeComponentOutput, error) {
	req, out := c.DescribeComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateServiceRoleFromAccount = "DisassociateServiceRoleFromAccount"

// DisassociateServiceRoleFromAccountRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateServiceRoleFromAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateServiceRoleFromAccount for more information on using the DisassociateServiceRoleFromAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateServiceRoleFromAccountRequest method.
//    req, resp := client.DisassociateServiceRoleFromAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/DisassociateServiceRoleFromAccount
func (c *GreengrassV2) DisassociateServiceRoleFromAccountRequest(input *DisassociateServiceRoleFromAccountInput) (req *request.Request, output *DisassociateServiceRoleFromAccountOutput) {
	op := &request.Operation{
		Name:       opDisassociateServiceRoleFromAccount,
		HTTPMethod: "DELETE",
		HTTPPath:   "/greengrass/servicerole",
	}

	if input == nil {
		input = &DisassociateServiceRoleFromAccountInput{}
	}

	output = &DisassociateServiceRoleFromAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateServiceRoleFromAccount API operation for AWS IoT Greengrass V2.
//
// Disassociates the Greengrass service role from IoT Greengrass for your Amazon
// Web Services account in this Amazon Web Services Region. Without a service
// role, IoT Greengrass can't verify the identity of client devices or manage
// core device connectivity information. For more information, see Greengrass
// service role (https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-service-role.html)
// in the IoT Greengrass Version 2 Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Greengrass V2's
// API operation DisassociateServiceRoleFromAccount for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   IoT Greengrass can't process your request right now. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/DisassociateServiceRoleFromAccount
func (c *GreengrassV2) DisassociateServiceRoleFromAccount(input *DisassociateServiceRoleFromAccountInput) (*DisassociateServiceRoleFromAccountOutput, error) {
	req, out := c.DisassociateServiceRoleFromAccountRequest(input)
	return out, req.Send()
}

// DisassociateServiceRoleFromAccountWithContext is the same as DisassociateServiceRoleFromAccount with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateServiceRoleFromAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GreengrassV2) DisassociateServiceRoleFromAccountWithContext(ctx aws.Context, input *DisassociateServiceRoleFromAccountInput, opts ...request.Option) (*DisassociateServiceRoleFromAccountOutput, error) {
	req, out := c.DisassociateServiceRoleFromAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetComponent = "GetComponent"

// GetComponentRequest generates a "aws/request.Request" representing the
// client's request for the GetComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetComponent for more information on using the GetComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetComponentRequest method.
//    req, resp := client.GetComponentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/GetComponent
func (c *GreengrassV2) GetComponentRequest(input *GetComponentInput) (req *request.Request, output *GetComponentOutput) {
	op := &request.Operation{
		Name:       opGetComponent,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/v2/components/{arn}",
	}

	if input == nil {
		input = &GetComponentInput{}
	}

	output = &GetComponentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetComponent API operation for AWS IoT Greengrass V2.
//
// Gets the recipe for a version of a component. Core devices can call this
// operation to identify the artifacts and requirements to install a component.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Greengrass V2's
// API operation GetComponent for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters.
//
//   * AccessDeniedException
//   You don't have permission to perform the action.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * ThrottlingException
//   Your request exceeded a request rate quota. For example, you might have exceeded
//   the amount of times that you can retrieve device or deployment status per
//   second.
//
//   * InternalServerException
//   IoT Greengrass can't process your request right now. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/GetComponent
func (c *GreengrassV2) GetComponent(input *GetComponentInput) (*GetComponentOutput, error) {
	req, out := c.GetComponentRequest(input)
	return out, req.Send()
}

// GetComponentWithContext is the same as GetComponent with the addition of
// the ability to pass a context and additional request options.
//
// See GetComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GreengrassV2) GetComponentWithContext(ctx aws.Context, input *GetComponentInput, opts ...request.Option) (*GetComponentOutput, error) {
	req, out := c.GetComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetComponentVersionArtifact = "GetComponentVersionArtifact"

// GetComponentVersionArtifactRequest generates a "aws/request.Request" representing the
// client's request for the GetComponentVersionArtifact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetComponentVersionArtifact for more information on using the GetComponentVersionArtifact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetComponentVersionArtifactRequest method.
//    req, resp := client.GetComponentVersionArtifactRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/GetComponentVersionArtifact
func (c *GreengrassV2) GetComponentVersionArtifactRequest(input *GetComponentVersionArtifactInput) (req *request.Request, output *GetComponentVersionArtifactOutput) {
	op := &request.Operation{
		Name:       opGetComponentVersionArtifact,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/v2/components/{arn}/artifacts/{artifactName+}",
	}

	if input == nil {
		input = &GetComponentVersionArtifactInput{}
	}

	output = &GetComponentVersionArtifactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetComponentVersionArtifact API operation for AWS IoT Greengrass V2.
//
// Gets the pre-signed URL to download a public component artifact. Core devices
// call this operation to identify the URL that they can use to download an
// artifact to install.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Greengrass V2's
// API operation GetComponentVersionArtifact for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters.
//
//   * AccessDeniedException
//   You don't have permission to perform the action.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * ThrottlingException
//   Your request exceeded a request rate quota. For example, you might have exceeded
//   the amount of times that you can retrieve device or deployment status per
//   second.
//
//   * InternalServerException
//   IoT Greengrass can't process your request right now. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/GetComponentVersionArtifact
func (c *GreengrassV2) GetComponentVersionArtifact(input *GetComponentVersionArtifactInput) (*GetComponentVersionArtifactOutput, error) {
	req, out := c.GetComponentVersionArtifactRequest(input)
	return out, req.Send()
}

// GetComponentVersionArtifactWithContext is the same as GetComponentVersionArtifact with the addition of
// the ability to pass a context and additional request options.
//
// See GetComponentVersionArtifact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GreengrassV2) GetComponentVersionArtifactWithContext(ctx aws.Context, input *GetComponentVersionArtifactInput, opts ...request.Option) (*GetComponentVersionArtifactOutput, error) {
	req, out := c.GetComponentVersionArtifactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetConnectivityInfo = "GetConnectivityInfo"

// GetConnectivityInfoRequest generates a "aws/request.Request" representing the
// client's request for the GetConnectivityInfo operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConnectivityInfo for more information on using the GetConnectivityInfo
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetConnectivityInfoRequest method.
//    req, resp := client.GetConnectivityInfoRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/GetConnectivityInfo
func (c *GreengrassV2) GetConnectivityInfoRequest(input *GetConnectivityInfoInput) (req *request.Request, output *GetConnectivityInfoOutput) {
	op := &request.Operation{
		Name:       opGetConnectivityInfo,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/things/{thingName}/connectivityInfo",
	}

	if input == nil {
		input = &GetConnectivityInfoInput{}
	}

	output = &GetConnectivityInfoOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConnectivityInfo API operation for AWS IoT Greengrass V2.
//
// Retrieves connectivity information for a Greengrass core device.
//
// Connectivity information includes endpoints and ports where client devices
// can connect to an MQTT broker on the core device. When a client device calls
// the Greengrass discovery API (https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-discover-api.html),
// IoT Greengrass returns connectivity information for all of the core devices
// where the client device can connect. For more information, see Connect client
// devices to core devices (https://docs.aws.amazon.com/greengrass/v2/developerguide/connect-client-devices.html)
// in the IoT Greengrass Version 2 Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Greengrass V2's
// API operation GetConnectivityInfo for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters.
//
//   * InternalServerException
//   IoT Greengrass can't process your request right now. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/GetConnectivityInfo
func (c *GreengrassV2) GetConnectivityInfo(input *GetConnectivityInfoInput) (*GetConnectivityInfoOutput, error) {
	req, out := c.GetConnectivityInfoRequest(input)
	return out, req.Send()
}

// GetConnectivityInfoWithContext is the same as GetConnectivityInfo with the addition of
// the ability to pass a context and additional request options.
//
// See GetConnectivityInfo for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GreengrassV2) GetConnectivityInfoWithContext(ctx aws.Context, input *GetConnectivityInfoInput, opts ...request.Option) (*GetConnectivityInfoOutput, error) {
	req, out := c.GetConnectivityInfoRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCoreDevice = "GetCoreDevice"

// GetCoreDeviceRequest generates a "aws/request.Request" representing the
// client's request for the GetCoreDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCoreDevice for more information on using the GetCoreDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCoreDeviceRequest method.
//    req, resp := client.GetCoreDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/GetCoreDevice
func (c *GreengrassV2) GetCoreDeviceRequest(input *GetCoreDeviceInput) (req *request.Request, output *GetCoreDeviceOutput) {
	op := &request.Operation{
		Name:       opGetCoreDevice,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/v2/coreDevices/{coreDeviceThingName}",
	}

	if input == nil {
		input = &GetCoreDeviceInput{}
	}

	output = &GetCoreDeviceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCoreDevice API operation for AWS IoT Greengrass V2.
//
// Retrieves metadata for a Greengrass core device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Greengrass V2's
// API operation GetCoreDevice for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * AccessDeniedException
//   You don't have permission to perform the action.
//
//   * InternalServerException
//   IoT Greengrass can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a request rate quota. For example, you might have exceeded
//   the amount of times that you can retrieve device or deployment status per
//   second.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/GetCoreDevice
func (c *GreengrassV2) GetCoreDevice(input *GetCoreDeviceInput) (*GetCoreDeviceOutput, error) {
	req, out := c.GetCoreDeviceRequest(input)
	return out, req.Send()
}

// GetCoreDeviceWithContext is the same as GetCoreDevice with the addition of
// the ability to pass a context and additional request options.
//
// See GetCoreDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GreengrassV2) GetCoreDeviceWithContext(ctx aws.Context, input *GetCoreDeviceInput, opts ...request.Option) (*GetCoreDeviceOutput, error) {
	req, out := c.GetCoreDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDeployment = "GetDeployment"

// GetDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the GetDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDeployment for more information on using the GetDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDeploymentRequest method.
//    req, resp := client.GetDeploymentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/GetDeployment
func (c *GreengrassV2) GetDeploymentRequest(input *GetDeploymentInput) (req *request.Request, output *GetDeploymentOutput) {
	op := &request.Operation{
		Name:       opGetDeployment,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/v2/deployments/{deploymentId}",
	}

	if input == nil {
		input = &GetDeploymentInput{}
	}

	output = &GetDeploymentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDeployment API operation for AWS IoT Greengrass V2.
//
// Gets a deployment. Deployments define the components that run on Greengrass
// core devices.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Greengrass V2's
// API operation GetDeployment for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * AccessDeniedException
//   You don't have permission to perform the action.
//
//   * InternalServerException
//   IoT Greengrass can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a request rate quota. For example, you might have exceeded
//   the amount of times that you can retrieve device or deployment status per
//   second.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/GetDeployment
func (c *GreengrassV2) GetDeployment(input *GetDeploymentInput) (*GetDeploymentOutput, error) {
	req, out := c.GetDeploymentRequest(input)
	return out, req.Send()
}

// GetDeploymentWithContext is the same as GetDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See GetDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GreengrassV2) GetDeploymentWithContext(ctx aws.Context, input *GetDeploymentInput, opts ...request.Option) (*GetDeploymentOutput, error) {
	req, out := c.GetDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetServiceRoleForAccount = "GetServiceRoleForAccount"

// GetServiceRoleForAccountRequest generates a "aws/request.Request" representing the
// client's request for the GetServiceRoleForAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetServiceRoleForAccount for more information on using the GetServiceRoleForAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetServiceRoleForAccountRequest method.
//    req, resp := client.GetServiceRoleForAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/GetServiceRoleForAccount
func (c *GreengrassV2) GetServiceRoleForAccountRequest(input *GetServiceRoleForAccountInput) (req *request.Request, output *GetServiceRoleForAccountOutput) {
	op := &request.Operation{
		Name:       opGetServiceRoleForAccount,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/servicerole",
	}

	if input == nil {
		input = &GetServiceRoleForAccountInput{}
	}

	output = &GetServiceRoleForAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetServiceRoleForAccount API operation for AWS IoT Greengrass V2.
//
// Gets the service role associated with IoT Greengrass for your Amazon Web
// Services account in this Amazon Web Services Region. IoT Greengrass uses
// this role to verify the identity of client devices and manage core device
// connectivity information. For more information, see Greengrass service role
// (https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-service-role.html)
// in the IoT Greengrass Version 2 Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Greengrass V2's
// API operation GetServiceRoleForAccount for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   IoT Greengrass can't process your request right now. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/GetServiceRoleForAccount
func (c *GreengrassV2) GetServiceRoleForAccount(input *GetServiceRoleForAccountInput) (*GetServiceRoleForAccountOutput, error) {
	req, out := c.GetServiceRoleForAccountRequest(input)
	return out, req.Send()
}

// GetServiceRoleForAccountWithContext is the same as GetServiceRoleForAccount with the addition of
// the ability to pass a context and additional request options.
//
// See GetServiceRoleForAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GreengrassV2) GetServiceRoleForAccountWithContext(ctx aws.Context, input *GetServiceRoleForAccountInput, opts ...request.Option) (*GetServiceRoleForAccountOutput, error) {
	req, out := c.GetServiceRoleForAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListClientDevicesAssociatedWithCoreDevice = "ListClientDevicesAssociatedWithCoreDevice"

// ListClientDevicesAssociatedWithCoreDeviceRequest generates a "aws/request.Request" representing the
// client's request for the ListClientDevicesAssociatedWithCoreDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListClientDevicesAssociatedWithCoreDevice for more information on using the ListClientDevicesAssociatedWithCoreDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListClientDevicesAssociatedWithCoreDeviceRequest method.
//    req, resp := client.ListClientDevicesAssociatedWithCoreDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListClientDevicesAssociatedWithCoreDevice
func (c *GreengrassV2) ListClientDevicesAssociatedWithCoreDeviceRequest(input *ListClientDevicesAssociatedWithCoreDeviceInput) (req *request.Request, output *ListClientDevicesAssociatedWithCoreDeviceOutput) {
	op := &request.Operation{
		Name:       opListClientDevicesAssociatedWithCoreDevice,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/v2/coreDevices/{coreDeviceThingName}/associatedClientDevices",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListClientDevicesAssociatedWithCoreDeviceInput{}
	}

	output = &ListClientDevicesAssociatedWithCoreDeviceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListClientDevicesAssociatedWithCoreDevice API operation for AWS IoT Greengrass V2.
//
// Retrieves a paginated list of client devices that are associated with a core
// device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Greengrass V2's
// API operation ListClientDevicesAssociatedWithCoreDevice for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * AccessDeniedException
//   You don't have permission to perform the action.
//
//   * InternalServerException
//   IoT Greengrass can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a request rate quota. For example, you might have exceeded
//   the amount of times that you can retrieve device or deployment status per
//   second.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListClientDevicesAssociatedWithCoreDevice
func (c *GreengrassV2) ListClientDevicesAssociatedWithCoreDevice(input *ListClientDevicesAssociatedWithCoreDeviceInput) (*ListClientDevicesAssociatedWithCoreDeviceOutput, error) {
	req, out := c.ListClientDevicesAssociatedWithCoreDeviceRequest(input)
	return out, req.Send()
}

// ListClientDevicesAssociatedWithCoreDeviceWithContext is the same as ListClientDevicesAssociatedWithCoreDevice with the addition of
// the ability to pass a context and additional request options.
//
// See ListClientDevicesAssociatedWithCoreDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GreengrassV2) ListClientDevicesAssociatedWithCoreDeviceWithContext(ctx aws.Context, input *ListClientDevicesAssociatedWithCoreDeviceInput, opts ...request.Option) (*ListClientDevicesAssociatedWithCoreDeviceOutput, error) {
	req, out := c.ListClientDevicesAssociatedWithCoreDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListClientDevicesAssociatedWithCoreDevicePages iterates over the pages of a ListClientDevicesAssociatedWithCoreDevice operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListClientDevicesAssociatedWithCoreDevice method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListClientDevicesAssociatedWithCoreDevice operation.
//    pageNum := 0
//    err := client.ListClientDevicesAssociatedWithCoreDevicePages(params,
//        func(page *greengrassv2.ListClientDevicesAssociatedWithCoreDeviceOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *GreengrassV2) ListClientDevicesAssociatedWithCoreDevicePages(input *ListClientDevicesAssociatedWithCoreDeviceInput, fn func(*ListClientDevicesAssociatedWithCoreDeviceOutput, bool) bool) error {
	return c.ListClientDevicesAssociatedWithCoreDevicePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListClientDevicesAssociatedWithCoreDevicePagesWithContext same as ListClientDevicesAssociatedWithCoreDevicePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GreengrassV2) ListClientDevicesAssociatedWithCoreDevicePagesWithContext(ctx aws.Context, input *ListClientDevicesAssociatedWithCoreDeviceInput, fn func(*ListClientDevicesAssociatedWithCoreDeviceOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListClientDevicesAssociatedWithCoreDeviceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListClientDevicesAssociatedWithCoreDeviceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListClientDevicesAssociatedWithCoreDeviceOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListComponentVersions = "ListComponentVersions"

// ListComponentVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListComponentVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListComponentVersions for more information on using the ListComponentVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListComponentVersionsRequest method.
//    req, resp := client.ListComponentVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListComponentVersions
func (c *GreengrassV2) ListComponentVersionsRequest(input *ListComponentVersionsInput) (req *request.Request, output *ListComponentVersionsOutput) {
	op := &request.Operation{
		Name:       opListComponentVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/v2/components/{arn}/versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListComponentVersionsInput{}
	}

	output = &ListComponentVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListComponentVersions API operation for AWS IoT Greengrass V2.
//
// Retrieves a paginated list of all versions for a component. Greater versions
// are listed first.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Greengrass V2's
// API operation ListComponentVersions for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters.
//
//   * AccessDeniedException
//   You don't have permission to perform the action.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * ThrottlingException
//   Your request exceeded a request rate quota. For example, you might have exceeded
//   the amount of times that you can retrieve device or deployment status per
//   second.
//
//   * InternalServerException
//   IoT Greengrass can't process your request right now. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListComponentVersions
func (c *GreengrassV2) ListComponentVersions(input *ListComponentVersionsInput) (*ListComponentVersionsOutput, error) {
	req, out := c.ListComponentVersionsRequest(input)
	return out, req.Send()
}

// ListComponentVersionsWithContext is the same as ListComponentVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListComponentVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GreengrassV2) ListComponentVersionsWithContext(ctx aws.Context, input *ListComponentVersionsInput, opts ...request.Option) (*ListComponentVersionsOutput, error) {
	req, out := c.ListComponentVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListComponentVersionsPages iterates over the pages of a ListComponentVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListComponentVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListComponentVersions operation.
//    pageNum := 0
//    err := client.ListComponentVersionsPages(params,
//        func(page *greengrassv2.ListComponentVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *GreengrassV2) ListComponentVersionsPages(input *ListComponentVersionsInput, fn func(*ListComponentVersionsOutput, bool) bool) error {
	return c.ListComponentVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListComponentVersionsPagesWithContext same as ListComponentVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GreengrassV2) ListComponentVersionsPagesWithContext(ctx aws.Context, input *ListComponentVersionsInput, fn func(*ListComponentVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListComponentVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListComponentVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListComponentVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListComponents = "ListComponents"

// ListComponentsRequest generates a "aws/request.Request" representing the
// client's request for the ListComponents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListComponents for more information on using the ListComponents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListComponentsRequest method.
//    req, resp := client.ListComponentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListComponents
func (c *GreengrassV2) ListComponentsRequest(input *ListComponentsInput) (req *request.Request, output *ListComponentsOutput) {
	op := &request.Operation{
		Name:       opListComponents,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/v2/components",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListComponentsInput{}
	}

	output = &ListComponentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListComponents API operation for AWS IoT Greengrass V2.
//
// Retrieves a paginated list of component summaries. This list includes components
// that you have permission to view.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Greengrass V2's
// API operation ListComponents for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters.
//
//   * AccessDeniedException
//   You don't have permission to perform the action.
//
//   * ThrottlingException
//   Your request exceeded a request rate quota. For example, you might have exceeded
//   the amount of times that you can retrieve device or deployment status per
//   second.
//
//   * InternalServerException
//   IoT Greengrass can't process your request right now. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListComponents
func (c *GreengrassV2) ListComponents(input *ListComponentsInput) (*ListComponentsOutput, error) {
	req, out := c.ListComponentsRequest(input)
	return out, req.Send()
}

// ListComponentsWithContext is the same as ListComponents with the addition of
// the ability to pass a context and additional request options.
//
// See ListComponents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GreengrassV2) ListComponentsWithContext(ctx aws.Context, input *ListComponentsInput, opts ...request.Option) (*ListComponentsOutput, error) {
	req, out := c.ListComponentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListComponentsPages iterates over the pages of a ListComponents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListComponents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListComponents operation.
//    pageNum := 0
//    err := client.ListComponentsPages(params,
//        func(page *greengrassv2.ListComponentsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *GreengrassV2) ListComponentsPages(input *ListComponentsInput, fn func(*ListComponentsOutput, bool) bool) error {
	return c.ListComponentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListComponentsPagesWithContext same as ListComponentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GreengrassV2) ListComponentsPagesWithContext(ctx aws.Context, input *ListComponentsInput, fn func(*ListComponentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListComponentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListComponentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListComponentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCoreDevices = "ListCoreDevices"

// ListCoreDevicesRequest generates a "aws/request.Request" representing the
// client's request for the ListCoreDevices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCoreDevices for more information on using the ListCoreDevices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCoreDevicesRequest method.
//    req, resp := client.ListCoreDevicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListCoreDevices
func (c *GreengrassV2) ListCoreDevicesRequest(input *ListCoreDevicesInput) (req *request.Request, output *ListCoreDevicesOutput) {
	op := &request.Operation{
		Name:       opListCoreDevices,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/v2/coreDevices",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCoreDevicesInput{}
	}

	output = &ListCoreDevicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCoreDevices API operation for AWS IoT Greengrass V2.
//
// Retrieves a paginated list of Greengrass core devices.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Greengrass V2's
// API operation ListCoreDevices for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters.
//
//   * AccessDeniedException
//   You don't have permission to perform the action.
//
//   * InternalServerException
//   IoT Greengrass can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a request rate quota. For example, you might have exceeded
//   the amount of times that you can retrieve device or deployment status per
//   second.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListCoreDevices
func (c *GreengrassV2) ListCoreDevices(input *ListCoreDevicesInput) (*ListCoreDevicesOutput, error) {
	req, out := c.ListCoreDevicesRequest(input)
	return out, req.Send()
}

// ListCoreDevicesWithContext is the same as ListCoreDevices with the addition of
// the ability to pass a context and additional request options.
//
// See ListCoreDevices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GreengrassV2) ListCoreDevicesWithContext(ctx aws.Context, input *ListCoreDevicesInput, opts ...request.Option) (*ListCoreDevicesOutput, error) {
	req, out := c.ListCoreDevicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCoreDevicesPages iterates over the pages of a ListCoreDevices operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCoreDevices method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListCoreDevices operation.
//    pageNum := 0
//    err := client.ListCoreDevicesPages(params,
//        func(page *greengrassv2.ListCoreDevicesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *GreengrassV2) ListCoreDevicesPages(input *ListCoreDevicesInput, fn func(*ListCoreDevicesOutput, bool) bool) error {
	return c.ListCoreDevicesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCoreDevicesPagesWithContext same as ListCoreDevicesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GreengrassV2) ListCoreDevicesPagesWithContext(ctx aws.Context, input *ListCoreDevicesInput, fn func(*ListCoreDevicesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCoreDevicesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCoreDevicesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCoreDevicesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDeployments = "ListDeployments"

// ListDeploymentsRequest generates a "aws/request.Request" representing the
// client's request for the ListDeployments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDeployments for more information on using the ListDeployments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDeploymentsRequest method.
//    req, resp := client.ListDeploymentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListDeployments
func (c *GreengrassV2) ListDeploymentsRequest(input *ListDeploymentsInput) (req *request.Request, output *ListDeploymentsOutput) {
	op := &request.Operation{
		Name:       opListDeployments,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/v2/deployments",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDeploymentsInput{}
	}

	output = &ListDeploymentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDeployments API operation for AWS IoT Greengrass V2.
//
// Retrieves a paginated list of deployments.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Greengrass V2's
// API operation ListDeployments for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters.
//
//   * AccessDeniedException
//   You don't have permission to perform the action.
//
//   * InternalServerException
//   IoT Greengrass can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a request rate quota. For example, you might have exceeded
//   the amount of times that you can retrieve device or deployment status per
//   second.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListDeployments
func (c *GreengrassV2) ListDeployments(input *ListDeploymentsInput) (*ListDeploymentsOutput, error) {
	req, out := c.ListDeploymentsRequest(input)
	return out, req.Send()
}

// ListDeploymentsWithContext is the same as ListDeployments with the addition of
// the ability to pass a context and additional request options.
//
// See ListDeployments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GreengrassV2) ListDeploymentsWithContext(ctx aws.Context, input *ListDeploymentsInput, opts ...request.Option) (*ListDeploymentsOutput, error) {
	req, out := c.ListDeploymentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDeploymentsPages iterates over the pages of a ListDeployments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDeployments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDeployments operation.
//    pageNum := 0
//    err := client.ListDeploymentsPages(params,
//        func(page *greengrassv2.ListDeploymentsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *GreengrassV2) ListDeploymentsPages(input *ListDeploymentsInput, fn func(*ListDeploymentsOutput, bool) bool) error {
	return c.ListDeploymentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDeploymentsPagesWithContext same as ListDeploymentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GreengrassV2) ListDeploymentsPagesWithContext(ctx aws.Context, input *ListDeploymentsInput, fn func(*ListDeploymentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDeploymentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDeploymentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDeploymentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEffectiveDeployments = "ListEffectiveDeployments"

// ListEffectiveDeploymentsRequest generates a "aws/request.Request" representing the
// client's request for the ListEffectiveDeployments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEffectiveDeployments for more information on using the ListEffectiveDeployments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEffectiveDeploymentsRequest method.
//    req, resp := client.ListEffectiveDeploymentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListEffectiveDeployments
func (c *GreengrassV2) ListEffectiveDeploymentsRequest(input *ListEffectiveDeploymentsInput) (req *request.Request, output *ListEffectiveDeploymentsOutput) {
	op := &request.Operation{
		Name:       opListEffectiveDeployments,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/v2/coreDevices/{coreDeviceThingName}/effectiveDeployments",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEffectiveDeploymentsInput{}
	}

	output = &ListEffectiveDeploymentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEffectiveDeployments API operation for AWS IoT Greengrass V2.
//
// Retrieves a paginated list of deployment jobs that IoT Greengrass sends to
// Greengrass core devices.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Greengrass V2's
// API operation ListEffectiveDeployments for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * AccessDeniedException
//   You don't have permission to perform the action.
//
//   * InternalServerException
//   IoT Greengrass can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a request rate quota. For example, you might have exceeded
//   the amount of times that you can retrieve device or deployment status per
//   second.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListEffectiveDeployments
func (c *GreengrassV2) ListEffectiveDeployments(input *ListEffectiveDeploymentsInput) (*ListEffectiveDeploymentsOutput, error) {
	req, out := c.ListEffectiveDeploymentsRequest(input)
	return out, req.Send()
}

// ListEffectiveDeploymentsWithContext is the same as ListEffectiveDeployments with the addition of
// the ability to pass a context and additional request options.
//
// See ListEffectiveDeployments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GreengrassV2) ListEffectiveDeploymentsWithContext(ctx aws.Context, input *ListEffectiveDeploymentsInput, opts ...request.Option) (*ListEffectiveDeploymentsOutput, error) {
	req, out := c.ListEffectiveDeploymentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEffectiveDeploymentsPages iterates over the pages of a ListEffectiveDeployments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEffectiveDeployments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListEffectiveDeployments operation.
//    pageNum := 0
//    err := client.ListEffectiveDeploymentsPages(params,
//        func(page *greengrassv2.ListEffectiveDeploymentsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *GreengrassV2) ListEffectiveDeploymentsPages(input *ListEffectiveDeploymentsInput, fn func(*ListEffectiveDeploymentsOutput, bool) bool) error {
	return c.ListEffectiveDeploymentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEffectiveDeploymentsPagesWithContext same as ListEffectiveDeploymentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GreengrassV2) ListEffectiveDeploymentsPagesWithContext(ctx aws.Context, input *ListEffectiveDeploymentsInput, fn func(*ListEffectiveDeploymentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEffectiveDeploymentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEffectiveDeploymentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEffectiveDeploymentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListInstalledComponents = "ListInstalledComponents"

// ListInstalledComponentsRequest generates a "aws/request.Request" representing the
// client's request for the ListInstalledComponents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInstalledComponents for more information on using the ListInstalledComponents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListInstalledComponentsRequest method.
//    req, resp := client.ListInstalledComponentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListInstalledComponents
func (c *GreengrassV2) ListInstalledComponentsRequest(input *ListInstalledComponentsInput) (req *request.Request, output *ListInstalledComponentsOutput) {
	op := &request.Operation{
		Name:       opListInstalledComponents,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/v2/coreDevices/{coreDeviceThingName}/installedComponents",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInstalledComponentsInput{}
	}

	output = &ListInstalledComponentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInstalledComponents API operation for AWS IoT Greengrass V2.
//
// Retrieves a paginated list of the components that a Greengrass core device
// runs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Greengrass V2's
// API operation ListInstalledComponents for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * AccessDeniedException
//   You don't have permission to perform the action.
//
//   * InternalServerException
//   IoT Greengrass can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a request rate quota. For example, you might have exceeded
//   the amount of times that you can retrieve device or deployment status per
//   second.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListInstalledComponents
func (c *GreengrassV2) ListInstalledComponents(input *ListInstalledComponentsInput) (*ListInstalledComponentsOutput, error) {
	req, out := c.ListInstalledComponentsRequest(input)
	return out, req.Send()
}

// ListInstalledComponentsWithContext is the same as ListInstalledComponents with the addition of
// the ability to pass a context and additional request options.
//
// See ListInstalledComponents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GreengrassV2) ListInstalledComponentsWithContext(ctx aws.Context, input *ListInstalledComponentsInput, opts ...request.Option) (*ListInstalledComponentsOutput, error) {
	req, out := c.ListInstalledComponentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInstalledComponentsPages iterates over the pages of a ListInstalledComponents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInstalledComponents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListInstalledComponents operation.
//    pageNum := 0
//    err := client.ListInstalledComponentsPages(params,
//        func(page *greengrassv2.ListInstalledComponentsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *GreengrassV2) ListInstalledComponentsPages(input *ListInstalledComponentsInput, fn func(*ListInstalledComponentsOutput, bool) bool) error {
	return c.ListInstalledComponentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInstalledComponentsPagesWithContext same as ListInstalledComponentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GreengrassV2) ListInstalledComponentsPagesWithContext(ctx aws.Context, input *ListInstalledComponentsInput, fn func(*ListInstalledComponentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInstalledComponentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInstalledComponentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInstalledComponentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListTagsForResource
func (c *GreengrassV2) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS IoT Greengrass V2.
//
// Retrieves the list of tags for an IoT Greengrass resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Greengrass V2's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   IoT Greengrass can't process your request right now. Try again later.
//
//   * ValidationException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListTagsForResource
func (c *GreengrassV2) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GreengrassV2) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResolveComponentCandidates = "ResolveComponentCandidates"

// ResolveComponentCandidatesRequest generates a "aws/request.Request" representing the
// client's request for the ResolveComponentCandidates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResolveComponentCandidates for more information on using the ResolveComponentCandidates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ResolveComponentCandidatesRequest method.
//    req, resp := client.ResolveComponentCandidatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ResolveComponentCandidates
func (c *GreengrassV2) ResolveComponentCandidatesRequest(input *ResolveComponentCandidatesInput) (req *request.Request, output *ResolveComponentCandidatesOutput) {
	op := &request.Operation{
		Name:       opResolveComponentCandidates,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/v2/resolveComponentCandidates",
	}

	if input == nil {
		input = &ResolveComponentCandidatesInput{}
	}

	output = &ResolveComponentCandidatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ResolveComponentCandidates API operation for AWS IoT Greengrass V2.
//
// Retrieves a list of components that meet the component, version, and platform
// requirements of a deployment. Greengrass core devices call this operation
// when they receive a deployment to identify the components to install.
//
// This operation identifies components that meet all dependency requirements
// for a deployment. If the requirements conflict, then this operation returns
// an error and the deployment fails. For example, this occurs if component
// A requires version >2.0.0 and component B requires version <2.0.0 of a component
// dependency.
//
// When you specify the component candidates to resolve, IoT Greengrass compares
// each component's digest from the core device with the component's digest
// in the Amazon Web Services Cloud. If the digests don't match, then IoT Greengrass
// specifies to use the version from the Amazon Web Services Cloud.
//
// To use this operation, you must use the data plane API endpoint and authenticate
// with an IoT device certificate. For more information, see IoT Greengrass
// endpoints and quotas (https://docs.aws.amazon.com/general/latest/gr/greengrass.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Greengrass V2's
// API operation ResolveComponentCandidates for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters.
//
//   * AccessDeniedException
//   You don't have permission to perform the action.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * ThrottlingException
//   Your request exceeded a request rate quota. For example, you might have exceeded
//   the amount of times that you can retrieve device or deployment status per
//   second.
//
//   * InternalServerException
//   IoT Greengrass can't process your request right now. Try again later.
//
//   * ConflictException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ResolveComponentCandidates
func (c *GreengrassV2) ResolveComponentCandidates(input *ResolveComponentCandidatesInput) (*ResolveComponentCandidatesOutput, error) {
	req, out := c.ResolveComponentCandidatesRequest(input)
	return out, req.Send()
}

// ResolveComponentCandidatesWithContext is the same as ResolveComponentCandidates with the addition of
// the ability to pass a context and additional request options.
//
// See ResolveComponentCandidates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GreengrassV2) ResolveComponentCandidatesWithContext(ctx aws.Context, input *ResolveComponentCandidatesInput, opts ...request.Option) (*ResolveComponentCandidatesOutput, error) {
	req, out := c.ResolveComponentCandidatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/TagResource
func (c *GreengrassV2) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS IoT Greengrass V2.
//
// Adds tags to an IoT Greengrass resource. If a tag already exists for the
// resource, this operation updates the tag's value.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Greengrass V2's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   IoT Greengrass can't process your request right now. Try again later.
//
//   * ValidationException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/TagResource
func (c *GreengrassV2) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GreengrassV2) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/UntagResource
func (c *GreengrassV2) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS IoT Greengrass V2.
//
// Removes a tag from an IoT Greengrass resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Greengrass V2's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   IoT Greengrass can't process your request right now. Try again later.
//
//   * ValidationException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/UntagResource
func (c *GreengrassV2) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GreengrassV2) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateConnectivityInfo = "UpdateConnectivityInfo"

// UpdateConnectivityInfoRequest generates a "aws/request.Request" representing the
// client's request for the UpdateConnectivityInfo operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateConnectivityInfo for more information on using the UpdateConnectivityInfo
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateConnectivityInfoRequest method.
//    req, resp := client.UpdateConnectivityInfoRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/UpdateConnectivityInfo
func (c *GreengrassV2) UpdateConnectivityInfoRequest(input *UpdateConnectivityInfoInput) (req *request.Request, output *UpdateConnectivityInfoOutput) {
	op := &request.Operation{
		Name:       opUpdateConnectivityInfo,
		HTTPMethod: "PUT",
		HTTPPath:   "/greengrass/things/{thingName}/connectivityInfo",
	}

	if input == nil {
		input = &UpdateConnectivityInfoInput{}
	}

	output = &UpdateConnectivityInfoOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateConnectivityInfo API operation for AWS IoT Greengrass V2.
//
// Updates connectivity information for a Greengrass core device.
//
// Connectivity information includes endpoints and ports where client devices
// can connect to an MQTT broker on the core device. When a client device calls
// the Greengrass discovery API (https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-discover-api.html),
// IoT Greengrass returns connectivity information for all of the core devices
// where the client device can connect. For more information, see Connect client
// devices to core devices (https://docs.aws.amazon.com/greengrass/v2/developerguide/connect-client-devices.html)
// in the IoT Greengrass Version 2 Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Greengrass V2's
// API operation UpdateConnectivityInfo for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters.
//
//   * InternalServerException
//   IoT Greengrass can't process your request right now. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/UpdateConnectivityInfo
func (c *GreengrassV2) UpdateConnectivityInfo(input *UpdateConnectivityInfoInput) (*UpdateConnectivityInfoOutput, error) {
	req, out := c.UpdateConnectivityInfoRequest(input)
	return out, req.Send()
}

// UpdateConnectivityInfoWithContext is the same as UpdateConnectivityInfo with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateConnectivityInfo for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GreengrassV2) UpdateConnectivityInfoWithContext(ctx aws.Context, input *UpdateConnectivityInfoInput, opts ...request.Option) (*UpdateConnectivityInfoOutput, error) {
	req, out := c.UpdateConnectivityInfoRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You don't have permission to perform the action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains a request to associate a client device with a core device. The BatchAssociateClientDeviceWithCoreDevice
// (https://docs.aws.amazon.com/greengrass/v2/APIReference/API_BatchAssociateClientDeviceWithCoreDevice.html)
// operation consumes a list of these requests.
type AssociateClientDeviceWithCoreDeviceEntry struct {
	_ struct{} `type:"structure"`

	// The name of the IoT thing that represents the client device to associate.
	//
	// ThingName is a required field
	ThingName *string `locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateClientDeviceWithCoreDeviceEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateClientDeviceWithCoreDeviceEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateClientDeviceWithCoreDeviceEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateClientDeviceWithCoreDeviceEntry"}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetThingName sets the ThingName field's value.
func (s *AssociateClientDeviceWithCoreDeviceEntry) SetThingName(v string) *AssociateClientDeviceWithCoreDeviceEntry {
	s.ThingName = &v
	return s
}

// Contains an error that occurs from a request to associate a client device
// with a core device. The BatchAssociateClientDeviceWithCoreDevice (https://docs.aws.amazon.com/greengrass/v2/APIReference/API_BatchAssociateClientDeviceWithCoreDevice.html)
// operation returns a list of these errors.
type AssociateClientDeviceWithCoreDeviceErrorEntry struct {
	_ struct{} `type:"structure"`

	// The error code for the request.
	Code *string `locationName:"code" min:"1" type:"string"`

	// A message that provides additional information about the error.
	Message *string `locationName:"message" min:"1" type:"string"`

	// The name of the IoT thing whose associate request failed.
	ThingName *string `locationName:"thingName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateClientDeviceWithCoreDeviceErrorEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateClientDeviceWithCoreDeviceErrorEntry) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *AssociateClientDeviceWithCoreDeviceErrorEntry) SetCode(v string) *AssociateClientDeviceWithCoreDeviceErrorEntry {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *AssociateClientDeviceWithCoreDeviceErrorEntry) SetMessage(v string) *AssociateClientDeviceWithCoreDeviceErrorEntry {
	s.Message = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *AssociateClientDeviceWithCoreDeviceErrorEntry) SetThingName(v string) *AssociateClientDeviceWithCoreDeviceErrorEntry {
	s.ThingName = &v
	return s
}

type AssociateServiceRoleToAccountInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the service role to associate with IoT
	// Greengrass for your Amazon Web Services account in this Amazon Web Services
	// Region.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"RoleArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateServiceRoleToAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateServiceRoleToAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateServiceRoleToAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateServiceRoleToAccountInput"}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoleArn sets the RoleArn field's value.
func (s *AssociateServiceRoleToAccountInput) SetRoleArn(v string) *AssociateServiceRoleToAccountInput {
	s.RoleArn = &v
	return s
}

type AssociateServiceRoleToAccountOutput struct {
	_ struct{} `type:"structure"`

	// The time when the service role was associated with IoT Greengrass for your
	// Amazon Web Services account in this Amazon Web Services Region.
	AssociatedAt *string `locationName:"AssociatedAt" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateServiceRoleToAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateServiceRoleToAccountOutput) GoString() string {
	return s.String()
}

// SetAssociatedAt sets the AssociatedAt field's value.
func (s *AssociateServiceRoleToAccountOutput) SetAssociatedAt(v string) *AssociateServiceRoleToAccountOutput {
	s.AssociatedAt = &v
	return s
}

// Contains information about a client device that is associated to a core device
// for cloud discovery.
type AssociatedClientDevice struct {
	_ struct{} `type:"structure"`

	// The time that the client device was associated, expressed in ISO 8601 format.
	AssociationTimestamp *time.Time `locationName:"associationTimestamp" type:"timestamp"`

	// The name of the IoT thing that represents the associated client device.
	ThingName *string `locationName:"thingName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatedClientDevice) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatedClientDevice) GoString() string {
	return s.String()
}

// SetAssociationTimestamp sets the AssociationTimestamp field's value.
func (s *AssociatedClientDevice) SetAssociationTimestamp(v time.Time) *AssociatedClientDevice {
	s.AssociationTimestamp = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *AssociatedClientDevice) SetThingName(v string) *AssociatedClientDevice {
	s.ThingName = &v
	return s
}

type BatchAssociateClientDeviceWithCoreDeviceInput struct {
	_ struct{} `type:"structure"`

	// The name of the core device. This is also the name of the IoT thing.
	//
	// CoreDeviceThingName is a required field
	CoreDeviceThingName *string `location:"uri" locationName:"coreDeviceThingName" min:"1" type:"string" required:"true"`

	// The list of client devices to associate.
	Entries []*AssociateClientDeviceWithCoreDeviceEntry `locationName:"entries" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchAssociateClientDeviceWithCoreDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchAssociateClientDeviceWithCoreDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchAssociateClientDeviceWithCoreDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchAssociateClientDeviceWithCoreDeviceInput"}
	if s.CoreDeviceThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("CoreDeviceThingName"))
	}
	if s.CoreDeviceThingName != nil && len(*s.CoreDeviceThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CoreDeviceThingName", 1))
	}
	if s.Entries != nil && len(s.Entries) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Entries", 1))
	}
	if s.Entries != nil {
		for i, v := range s.Entries {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Entries", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCoreDeviceThingName sets the CoreDeviceThingName field's value.
func (s *BatchAssociateClientDeviceWithCoreDeviceInput) SetCoreDeviceThingName(v string) *BatchAssociateClientDeviceWithCoreDeviceInput {
	s.CoreDeviceThingName = &v
	return s
}

// SetEntries sets the Entries field's value.
func (s *BatchAssociateClientDeviceWithCoreDeviceInput) SetEntries(v []*AssociateClientDeviceWithCoreDeviceEntry) *BatchAssociateClientDeviceWithCoreDeviceInput {
	s.Entries = v
	return s
}

type BatchAssociateClientDeviceWithCoreDeviceOutput struct {
	_ struct{} `type:"structure"`

	// The list of any errors for the entries in the request. Each error entry contains
	// the name of the IoT thing that failed to associate.
	ErrorEntries []*AssociateClientDeviceWithCoreDeviceErrorEntry `locationName:"errorEntries" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchAssociateClientDeviceWithCoreDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchAssociateClientDeviceWithCoreDeviceOutput) GoString() string {
	return s.String()
}

// SetErrorEntries sets the ErrorEntries field's value.
func (s *BatchAssociateClientDeviceWithCoreDeviceOutput) SetErrorEntries(v []*AssociateClientDeviceWithCoreDeviceErrorEntry) *BatchAssociateClientDeviceWithCoreDeviceOutput {
	s.ErrorEntries = v
	return s
}

type BatchDisassociateClientDeviceFromCoreDeviceInput struct {
	_ struct{} `type:"structure"`

	// The name of the core device. This is also the name of the IoT thing.
	//
	// CoreDeviceThingName is a required field
	CoreDeviceThingName *string `location:"uri" locationName:"coreDeviceThingName" min:"1" type:"string" required:"true"`

	// The list of client devices to disassociate.
	Entries []*DisassociateClientDeviceFromCoreDeviceEntry `locationName:"entries" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDisassociateClientDeviceFromCoreDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDisassociateClientDeviceFromCoreDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDisassociateClientDeviceFromCoreDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDisassociateClientDeviceFromCoreDeviceInput"}
	if s.CoreDeviceThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("CoreDeviceThingName"))
	}
	if s.CoreDeviceThingName != nil && len(*s.CoreDeviceThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CoreDeviceThingName", 1))
	}
	if s.Entries != nil && len(s.Entries) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Entries", 1))
	}
	if s.Entries != nil {
		for i, v := range s.Entries {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Entries", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCoreDeviceThingName sets the CoreDeviceThingName field's value.
func (s *BatchDisassociateClientDeviceFromCoreDeviceInput) SetCoreDeviceThingName(v string) *BatchDisassociateClientDeviceFromCoreDeviceInput {
	s.CoreDeviceThingName = &v
	return s
}

// SetEntries sets the Entries field's value.
func (s *BatchDisassociateClientDeviceFromCoreDeviceInput) SetEntries(v []*DisassociateClientDeviceFromCoreDeviceEntry) *BatchDisassociateClientDeviceFromCoreDeviceInput {
	s.Entries = v
	return s
}

type BatchDisassociateClientDeviceFromCoreDeviceOutput struct {
	_ struct{} `type:"structure"`

	// The list of any errors for the entries in the request. Each error entry contains
	// the name of the IoT thing that failed to disassociate.
	ErrorEntries []*DisassociateClientDeviceFromCoreDeviceErrorEntry `locationName:"errorEntries" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDisassociateClientDeviceFromCoreDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDisassociateClientDeviceFromCoreDeviceOutput) GoString() string {
	return s.String()
}

// SetErrorEntries sets the ErrorEntries field's value.
func (s *BatchDisassociateClientDeviceFromCoreDeviceOutput) SetErrorEntries(v []*DisassociateClientDeviceFromCoreDeviceErrorEntry) *BatchDisassociateClientDeviceFromCoreDeviceOutput {
	s.ErrorEntries = v
	return s
}

type CancelDeploymentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the deployment.
	//
	// DeploymentId is a required field
	DeploymentId *string `location:"uri" locationName:"deploymentId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelDeploymentInput"}
	if s.DeploymentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentId"))
	}
	if s.DeploymentId != nil && len(*s.DeploymentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *CancelDeploymentInput) SetDeploymentId(v string) *CancelDeploymentInput {
	s.DeploymentId = &v
	return s
}

type CancelDeploymentOutput struct {
	_ struct{} `type:"structure"`

	// A message that communicates if the cancel was successful.
	Message *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelDeploymentOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *CancelDeploymentOutput) SetMessage(v string) *CancelDeploymentOutput {
	s.Message = &v
	return s
}

// Contains the status of a component in the IoT Greengrass service.
type CloudComponentStatus struct {
	_ struct{} `type:"structure"`

	// The state of the component.
	ComponentState *string `locationName:"componentState" type:"string" enum:"CloudComponentState"`

	// A dictionary of errors that communicate why the component is in an error
	// state. For example, if IoT Greengrass can't access an artifact for the component,
	// then errors contains the artifact's URI as a key, and the error message as
	// the value for that key.
	Errors map[string]*string `locationName:"errors" type:"map"`

	// A message that communicates details, such as errors, about the status of
	// the component.
	Message *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudComponentStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudComponentStatus) GoString() string {
	return s.String()
}

// SetComponentState sets the ComponentState field's value.
func (s *CloudComponentStatus) SetComponentState(v string) *CloudComponentStatus {
	s.ComponentState = &v
	return s
}

// SetErrors sets the Errors field's value.
func (s *CloudComponentStatus) SetErrors(v map[string]*string) *CloudComponentStatus {
	s.Errors = v
	return s
}

// SetMessage sets the Message field's value.
func (s *CloudComponentStatus) SetMessage(v string) *CloudComponentStatus {
	s.Message = &v
	return s
}

// Contains information about a component.
type Component struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the component version.
	Arn *string `locationName:"arn" type:"string"`

	// The name of the component.
	ComponentName *string `locationName:"componentName" min:"1" type:"string"`

	// The latest version of the component and its details.
	LatestVersion *ComponentLatestVersion `locationName:"latestVersion" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Component) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Component) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Component) SetArn(v string) *Component {
	s.Arn = &v
	return s
}

// SetComponentName sets the ComponentName field's value.
func (s *Component) SetComponentName(v string) *Component {
	s.ComponentName = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *Component) SetLatestVersion(v *ComponentLatestVersion) *Component {
	s.LatestVersion = v
	return s
}

// Contains information about a component that is a candidate to deploy to a
// Greengrass core device.
type ComponentCandidate struct {
	_ struct{} `type:"structure"`

	// The name of the component.
	ComponentName *string `locationName:"componentName" min:"1" type:"string"`

	// The version of the component.
	ComponentVersion *string `locationName:"componentVersion" min:"1" type:"string"`

	// The version requirements for the component's dependencies. Greengrass core
	// devices get the version requirements from component recipes.
	//
	// IoT Greengrass V2 uses semantic version constraints. For more information,
	// see Semantic Versioning (https://semver.org/).
	VersionRequirements map[string]*string `locationName:"versionRequirements" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentCandidate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentCandidate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComponentCandidate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComponentCandidate"}
	if s.ComponentName != nil && len(*s.ComponentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentName", 1))
	}
	if s.ComponentVersion != nil && len(*s.ComponentVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentName sets the ComponentName field's value.
func (s *ComponentCandidate) SetComponentName(v string) *ComponentCandidate {
	s.ComponentName = &v
	return s
}

// SetComponentVersion sets the ComponentVersion field's value.
func (s *ComponentCandidate) SetComponentVersion(v string) *ComponentCandidate {
	s.ComponentVersion = &v
	return s
}

// SetVersionRequirements sets the VersionRequirements field's value.
func (s *ComponentCandidate) SetVersionRequirements(v map[string]*string) *ComponentCandidate {
	s.VersionRequirements = v
	return s
}

// Contains information about a deployment's update to a component's configuration
// on Greengrass core devices. For more information, see Update component configurations
// (https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html)
// in the IoT Greengrass V2 Developer Guide.
type ComponentConfigurationUpdate struct {
	_ struct{} `type:"structure"`

	// A serialized JSON string that contains the configuration object to merge
	// to target devices. The core device merges this configuration with the component's
	// existing configuration. If this is the first time a component deploys on
	// a device, the core device merges this configuration with the component's
	// default configuration. This means that the core device keeps it's existing
	// configuration for keys and values that you don't specify in this object.
	// For more information, see Merge configuration updates (https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html#merge-configuration-update)
	// in the IoT Greengrass V2 Developer Guide.
	Merge *string `locationName:"merge" min:"1" type:"string"`

	// The list of configuration nodes to reset to default values on target devices.
	// Use JSON pointers to specify each node to reset. JSON pointers start with
	// a forward slash (/) and use forward slashes to separate the key for each
	// level in the object. For more information, see the JSON pointer specification
	// (https://tools.ietf.org/html/rfc6901) and Reset configuration updates (https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html#reset-configuration-update)
	// in the IoT Greengrass V2 Developer Guide.
	Reset []*string `locationName:"reset" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentConfigurationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentConfigurationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComponentConfigurationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComponentConfigurationUpdate"}
	if s.Merge != nil && len(*s.Merge) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Merge", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMerge sets the Merge field's value.
func (s *ComponentConfigurationUpdate) SetMerge(v string) *ComponentConfigurationUpdate {
	s.Merge = &v
	return s
}

// SetReset sets the Reset field's value.
func (s *ComponentConfigurationUpdate) SetReset(v []*string) *ComponentConfigurationUpdate {
	s.Reset = v
	return s
}

// Contains information about a component dependency for a Lambda function component.
type ComponentDependencyRequirement struct {
	_ struct{} `type:"structure"`

	// The type of this dependency. Choose from the following options:
	//
	//    * SOFT – The component doesn't restart if the dependency changes state.
	//
	//    * HARD – The component restarts if the dependency changes state.
	//
	// Default: HARD
	DependencyType *string `locationName:"dependencyType" type:"string" enum:"ComponentDependencyType"`

	// The component version requirement for the component dependency.
	//
	// IoT Greengrass V2 uses semantic version constraints. For more information,
	// see Semantic Versioning (https://semver.org/).
	VersionRequirement *string `locationName:"versionRequirement" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentDependencyRequirement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentDependencyRequirement) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComponentDependencyRequirement) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComponentDependencyRequirement"}
	if s.VersionRequirement != nil && len(*s.VersionRequirement) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionRequirement", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDependencyType sets the DependencyType field's value.
func (s *ComponentDependencyRequirement) SetDependencyType(v string) *ComponentDependencyRequirement {
	s.DependencyType = &v
	return s
}

// SetVersionRequirement sets the VersionRequirement field's value.
func (s *ComponentDependencyRequirement) SetVersionRequirement(v string) *ComponentDependencyRequirement {
	s.VersionRequirement = &v
	return s
}

// Contains information about a component to deploy.
type ComponentDeploymentSpecification struct {
	_ struct{} `type:"structure"`

	// The version of the component.
	ComponentVersion *string `locationName:"componentVersion" min:"1" type:"string"`

	// The configuration updates to deploy for the component. You can define reset
	// updates and merge updates. A reset updates the keys that you specify to the
	// default configuration for the component. A merge updates the core device's
	// component configuration with the keys and values that you specify. The IoT
	// Greengrass Core software applies reset updates before it applies merge updates.
	// For more information, see Update component configurations (https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html)
	// in the IoT Greengrass V2 Developer Guide.
	ConfigurationUpdate *ComponentConfigurationUpdate `locationName:"configurationUpdate" type:"structure"`

	// The system user and group that the IoT Greengrass Core software uses to run
	// component processes on the core device. If you omit this parameter, the IoT
	// Greengrass Core software uses the system user and group that you configure
	// for the core device. For more information, see Configure the user and group
	// that run components (https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user)
	// in the IoT Greengrass V2 Developer Guide.
	RunWith *ComponentRunWith `locationName:"runWith" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentDeploymentSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentDeploymentSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComponentDeploymentSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComponentDeploymentSpecification"}
	if s.ComponentVersion != nil && len(*s.ComponentVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentVersion", 1))
	}
	if s.ConfigurationUpdate != nil {
		if err := s.ConfigurationUpdate.Validate(); err != nil {
			invalidParams.AddNested("ConfigurationUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.RunWith != nil {
		if err := s.RunWith.Validate(); err != nil {
			invalidParams.AddNested("RunWith", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentVersion sets the ComponentVersion field's value.
func (s *ComponentDeploymentSpecification) SetComponentVersion(v string) *ComponentDeploymentSpecification {
	s.ComponentVersion = &v
	return s
}

// SetConfigurationUpdate sets the ConfigurationUpdate field's value.
func (s *ComponentDeploymentSpecification) SetConfigurationUpdate(v *ComponentConfigurationUpdate) *ComponentDeploymentSpecification {
	s.ConfigurationUpdate = v
	return s
}

// SetRunWith sets the RunWith field's value.
func (s *ComponentDeploymentSpecification) SetRunWith(v *ComponentRunWith) *ComponentDeploymentSpecification {
	s.RunWith = v
	return s
}

// Contains information about the latest version of a component.
type ComponentLatestVersion struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the component version.
	Arn *string `locationName:"arn" type:"string"`

	// The version of the component.
	ComponentVersion *string `locationName:"componentVersion" min:"1" type:"string"`

	// The time at which the component was created, expressed in ISO 8601 format.
	CreationTimestamp *time.Time `locationName:"creationTimestamp" type:"timestamp"`

	// The description of the component version.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The platforms that the component version supports.
	Platforms []*ComponentPlatform `locationName:"platforms" type:"list"`

	// The publisher of the component version.
	Publisher *string `locationName:"publisher" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentLatestVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentLatestVersion) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ComponentLatestVersion) SetArn(v string) *ComponentLatestVersion {
	s.Arn = &v
	return s
}

// SetComponentVersion sets the ComponentVersion field's value.
func (s *ComponentLatestVersion) SetComponentVersion(v string) *ComponentLatestVersion {
	s.ComponentVersion = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *ComponentLatestVersion) SetCreationTimestamp(v time.Time) *ComponentLatestVersion {
	s.CreationTimestamp = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ComponentLatestVersion) SetDescription(v string) *ComponentLatestVersion {
	s.Description = &v
	return s
}

// SetPlatforms sets the Platforms field's value.
func (s *ComponentLatestVersion) SetPlatforms(v []*ComponentPlatform) *ComponentLatestVersion {
	s.Platforms = v
	return s
}

// SetPublisher sets the Publisher field's value.
func (s *ComponentLatestVersion) SetPublisher(v string) *ComponentLatestVersion {
	s.Publisher = &v
	return s
}

// Contains information about a platform that a component supports.
type ComponentPlatform struct {
	_ struct{} `type:"structure"`

	// A dictionary of attributes for the platform. The IoT Greengrass Core software
	// defines the os and platform by default. You can specify additional platform
	// attributes for a core device when you deploy the Greengrass nucleus component.
	// For more information, see the Greengrass nucleus component (https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html)
	// in the IoT Greengrass V2 Developer Guide.
	Attributes map[string]*string `locationName:"attributes" type:"map"`

	// The friendly name of the platform. This name helps you identify the platform.
	//
	// If you omit this parameter, IoT Greengrass creates a friendly name from the
	// os and architecture of the platform.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentPlatform) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentPlatform) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComponentPlatform) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComponentPlatform"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *ComponentPlatform) SetAttributes(v map[string]*string) *ComponentPlatform {
	s.Attributes = v
	return s
}

// SetName sets the Name field's value.
func (s *ComponentPlatform) SetName(v string) *ComponentPlatform {
	s.Name = &v
	return s
}

// Contains information system user and group that the IoT Greengrass Core software
// uses to run component processes on the core device. For more information,
// see Configure the user and group that run components (https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user)
// in the IoT Greengrass V2 Developer Guide.
type ComponentRunWith struct {
	_ struct{} `type:"structure"`

	// The POSIX system user and, optionally, group to use to run this component
	// on Linux core devices. The user, and group if specified, must exist on each
	// Linux core device. Specify the user and group separated by a colon (:) in
	// the following format: user:group. The group is optional. If you don't specify
	// a group, the IoT Greengrass Core software uses the primary user for the group.
	//
	// If you omit this parameter, the IoT Greengrass Core software uses the default
	// system user and group that you configure on the Greengrass nucleus component.
	// For more information, see Configure the user and group that run components
	// (https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user).
	PosixUser *string `locationName:"posixUser" min:"1" type:"string"`

	// The system resource limits to apply to this component's process on the core
	// device. IoT Greengrass currently supports this feature on only Linux core
	// devices.
	//
	// If you omit this parameter, the IoT Greengrass Core software uses the default
	// system resource limits that you configure on the Greengrass nucleus component.
	// For more information, see Configure system resource limits for components
	// (https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-system-resource-limits).
	SystemResourceLimits *SystemResourceLimits `locationName:"systemResourceLimits" type:"structure"`

	// The Windows user to use to run this component on Windows core devices. The
	// user must exist on each Windows core device, and its name and password must
	// be in the LocalSystem account's Credentials Manager instance.
	//
	// If you omit this parameter, the IoT Greengrass Core software uses the default
	// Windows user that you configure on the Greengrass nucleus component. For
	// more information, see Configure the user and group that run components (https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user).
	WindowsUser *string `locationName:"windowsUser" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentRunWith) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentRunWith) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComponentRunWith) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComponentRunWith"}
	if s.PosixUser != nil && len(*s.PosixUser) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PosixUser", 1))
	}
	if s.WindowsUser != nil && len(*s.WindowsUser) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WindowsUser", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPosixUser sets the PosixUser field's value.
func (s *ComponentRunWith) SetPosixUser(v string) *ComponentRunWith {
	s.PosixUser = &v
	return s
}

// SetSystemResourceLimits sets the SystemResourceLimits field's value.
func (s *ComponentRunWith) SetSystemResourceLimits(v *SystemResourceLimits) *ComponentRunWith {
	s.SystemResourceLimits = v
	return s
}

// SetWindowsUser sets the WindowsUser field's value.
func (s *ComponentRunWith) SetWindowsUser(v string) *ComponentRunWith {
	s.WindowsUser = &v
	return s
}

// Contains information about a component version in a list.
type ComponentVersionListItem struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the component version.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The name of the component.
	ComponentName *string `locationName:"componentName" min:"1" type:"string"`

	// The version of the component.
	ComponentVersion *string `locationName:"componentVersion" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentVersionListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentVersionListItem) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ComponentVersionListItem) SetArn(v string) *ComponentVersionListItem {
	s.Arn = &v
	return s
}

// SetComponentName sets the ComponentName field's value.
func (s *ComponentVersionListItem) SetComponentName(v string) *ComponentVersionListItem {
	s.ComponentName = &v
	return s
}

// SetComponentVersion sets the ComponentVersion field's value.
func (s *ComponentVersionListItem) SetComponentVersion(v string) *ComponentVersionListItem {
	s.ComponentVersion = &v
	return s
}

// Your request has conflicting operations. This can occur if you're trying
// to perform more than one operation on the same resource at the same time.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the resource that conflicts with the request.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The type of the resource that conflicts with the request.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about an endpoint and port where client devices can
// connect to an MQTT broker on a Greengrass core device.
type ConnectivityInfo struct {
	_ struct{} `type:"structure"`

	// The IP address or DNS address where client devices can connect to an MQTT
	// broker on the Greengrass core device.
	HostAddress *string `locationName:"HostAddress" type:"string"`

	// An ID for the connectivity information.
	Id *string `locationName:"Id" type:"string"`

	// Additional metadata to provide to client devices that connect to this core
	// device.
	Metadata *string `locationName:"Metadata" type:"string"`

	// The port where the MQTT broker operates on the core device. This port is
	// typically 8883, which is the default port for the MQTT broker component that
	// runs on core devices.
	PortNumber *int64 `locationName:"PortNumber" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectivityInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectivityInfo) GoString() string {
	return s.String()
}

// SetHostAddress sets the HostAddress field's value.
func (s *ConnectivityInfo) SetHostAddress(v string) *ConnectivityInfo {
	s.HostAddress = &v
	return s
}

// SetId sets the Id field's value.
func (s *ConnectivityInfo) SetId(v string) *ConnectivityInfo {
	s.Id = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *ConnectivityInfo) SetMetadata(v string) *ConnectivityInfo {
	s.Metadata = &v
	return s
}

// SetPortNumber sets the PortNumber field's value.
func (s *ConnectivityInfo) SetPortNumber(v int64) *ConnectivityInfo {
	s.PortNumber = &v
	return s
}

// Contains information about a Greengrass core device, which is an IoT thing
// that runs the IoT Greengrass Core software.
type CoreDevice struct {
	_ struct{} `type:"structure"`

	// The name of the core device. This is also the name of the IoT thing.
	CoreDeviceThingName *string `locationName:"coreDeviceThingName" min:"1" type:"string"`

	// The time at which the core device's status last updated, expressed in ISO
	// 8601 format.
	LastStatusUpdateTimestamp *time.Time `locationName:"lastStatusUpdateTimestamp" type:"timestamp"`

	// The status of the core device. Core devices can have the following statuses:
	//
	//    * HEALTHY – The IoT Greengrass Core software and all components run
	//    on the core device without issue.
	//
	//    * UNHEALTHY – The IoT Greengrass Core software or a component is in
	//    a failed state on the core device.
	Status *string `locationName:"status" type:"string" enum:"CoreDeviceStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CoreDevice) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CoreDevice) GoString() string {
	return s.String()
}

// SetCoreDeviceThingName sets the CoreDeviceThingName field's value.
func (s *CoreDevice) SetCoreDeviceThingName(v string) *CoreDevice {
	s.CoreDeviceThingName = &v
	return s
}

// SetLastStatusUpdateTimestamp sets the LastStatusUpdateTimestamp field's value.
func (s *CoreDevice) SetLastStatusUpdateTimestamp(v time.Time) *CoreDevice {
	s.LastStatusUpdateTimestamp = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CoreDevice) SetStatus(v string) *CoreDevice {
	s.Status = &v
	return s
}

type CreateComponentVersionInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you can provide to ensure that the
	// request is idempotent. Idempotency means that the request is successfully
	// processed only once, even if you send the request multiple times. When a
	// request succeeds, and you specify the same client token for subsequent successful
	// requests, the IoT Greengrass V2 service returns the successful response that
	// it caches from the previous request. IoT Greengrass V2 caches successful
	// responses for idempotent requests for up to 8 hours.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The recipe to use to create the component. The recipe defines the component's
	// metadata, parameters, dependencies, lifecycle, artifacts, and platform compatibility.
	//
	// You must specify either inlineRecipe or lambdaFunction.
	// InlineRecipe is automatically base64 encoded/decoded by the SDK.
	InlineRecipe []byte `locationName:"inlineRecipe" type:"blob"`

	// The parameters to create a component from a Lambda function.
	//
	// You must specify either inlineRecipe or lambdaFunction.
	LambdaFunction *LambdaFunctionRecipeSource `locationName:"lambdaFunction" type:"structure"`

	// A list of key-value pairs that contain metadata for the resource. For more
	// information, see Tag your resources (https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html)
	// in the IoT Greengrass V2 Developer Guide.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateComponentVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateComponentVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateComponentVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateComponentVersionInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.LambdaFunction != nil {
		if err := s.LambdaFunction.Validate(); err != nil {
			invalidParams.AddNested("LambdaFunction", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateComponentVersionInput) SetClientToken(v string) *CreateComponentVersionInput {
	s.ClientToken = &v
	return s
}

// SetInlineRecipe sets the InlineRecipe field's value.
func (s *CreateComponentVersionInput) SetInlineRecipe(v []byte) *CreateComponentVersionInput {
	s.InlineRecipe = v
	return s
}

// SetLambdaFunction sets the LambdaFunction field's value.
func (s *CreateComponentVersionInput) SetLambdaFunction(v *LambdaFunctionRecipeSource) *CreateComponentVersionInput {
	s.LambdaFunction = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateComponentVersionInput) SetTags(v map[string]*string) *CreateComponentVersionInput {
	s.Tags = v
	return s
}

type CreateComponentVersionOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the component version.
	Arn *string `locationName:"arn" type:"string"`

	// The name of the component.
	//
	// ComponentName is a required field
	ComponentName *string `locationName:"componentName" min:"1" type:"string" required:"true"`

	// The version of the component.
	//
	// ComponentVersion is a required field
	ComponentVersion *string `locationName:"componentVersion" min:"1" type:"string" required:"true"`

	// The time at which the component was created, expressed in ISO 8601 format.
	//
	// CreationTimestamp is a required field
	CreationTimestamp *time.Time `locationName:"creationTimestamp" type:"timestamp" required:"true"`

	// The status of the component version in IoT Greengrass V2. This status is
	// different from the status of the component on a core device.
	//
	// Status is a required field
	Status *CloudComponentStatus `locationName:"status" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateComponentVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateComponentVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateComponentVersionOutput) SetArn(v string) *CreateComponentVersionOutput {
	s.Arn = &v
	return s
}

// SetComponentName sets the ComponentName field's value.
func (s *CreateComponentVersionOutput) SetComponentName(v string) *CreateComponentVersionOutput {
	s.ComponentName = &v
	return s
}

// SetComponentVersion sets the ComponentVersion field's value.
func (s *CreateComponentVersionOutput) SetComponentVersion(v string) *CreateComponentVersionOutput {
	s.ComponentVersion = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *CreateComponentVersionOutput) SetCreationTimestamp(v time.Time) *CreateComponentVersionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateComponentVersionOutput) SetStatus(v *CloudComponentStatus) *CreateComponentVersionOutput {
	s.Status = v
	return s
}

type CreateDeploymentInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you can provide to ensure that the
	// request is idempotent. Idempotency means that the request is successfully
	// processed only once, even if you send the request multiple times. When a
	// request succeeds, and you specify the same client token for subsequent successful
	// requests, the IoT Greengrass V2 service returns the successful response that
	// it caches from the previous request. IoT Greengrass V2 caches successful
	// responses for idempotent requests for up to 8 hours.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The components to deploy. This is a dictionary, where each key is the name
	// of a component, and each key's value is the version and configuration to
	// deploy for that component.
	Components map[string]*ComponentDeploymentSpecification `locationName:"components" type:"map"`

	// The name of the deployment.
	DeploymentName *string `locationName:"deploymentName" min:"1" type:"string"`

	// The deployment policies for the deployment. These policies define how the
	// deployment updates components and handles failure.
	DeploymentPolicies *DeploymentPolicies `locationName:"deploymentPolicies" type:"structure"`

	// The job configuration for the deployment configuration. The job configuration
	// specifies the rollout, timeout, and stop configurations for the deployment
	// configuration.
	IotJobConfiguration *DeploymentIoTJobConfiguration `locationName:"iotJobConfiguration" type:"structure"`

	// A list of key-value pairs that contain metadata for the resource. For more
	// information, see Tag your resources (https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html)
	// in the IoT Greengrass V2 Developer Guide.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the target IoT thing or thing group.
	//
	// TargetArn is a required field
	TargetArn *string `locationName:"targetArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDeploymentInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DeploymentName != nil && len(*s.DeploymentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentName", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.TargetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetArn"))
	}
	if s.Components != nil {
		for i, v := range s.Components {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Components", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.IotJobConfiguration != nil {
		if err := s.IotJobConfiguration.Validate(); err != nil {
			invalidParams.AddNested("IotJobConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateDeploymentInput) SetClientToken(v string) *CreateDeploymentInput {
	s.ClientToken = &v
	return s
}

// SetComponents sets the Components field's value.
func (s *CreateDeploymentInput) SetComponents(v map[string]*ComponentDeploymentSpecification) *CreateDeploymentInput {
	s.Components = v
	return s
}

// SetDeploymentName sets the DeploymentName field's value.
func (s *CreateDeploymentInput) SetDeploymentName(v string) *CreateDeploymentInput {
	s.DeploymentName = &v
	return s
}

// SetDeploymentPolicies sets the DeploymentPolicies field's value.
func (s *CreateDeploymentInput) SetDeploymentPolicies(v *DeploymentPolicies) *CreateDeploymentInput {
	s.DeploymentPolicies = v
	return s
}

// SetIotJobConfiguration sets the IotJobConfiguration field's value.
func (s *CreateDeploymentInput) SetIotJobConfiguration(v *DeploymentIoTJobConfiguration) *CreateDeploymentInput {
	s.IotJobConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDeploymentInput) SetTags(v map[string]*string) *CreateDeploymentInput {
	s.Tags = v
	return s
}

// SetTargetArn sets the TargetArn field's value.
func (s *CreateDeploymentInput) SetTargetArn(v string) *CreateDeploymentInput {
	s.TargetArn = &v
	return s
}

type CreateDeploymentOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the deployment.
	DeploymentId *string `locationName:"deploymentId" min:"1" type:"string"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the IoT job that applies the deployment to target devices.
	IotJobArn *string `locationName:"iotJobArn" type:"string"`

	// The ID of the IoT job that applies the deployment to target devices.
	IotJobId *string `locationName:"iotJobId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDeploymentOutput) GoString() string {
	return s.String()
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *CreateDeploymentOutput) SetDeploymentId(v string) *CreateDeploymentOutput {
	s.DeploymentId = &v
	return s
}

// SetIotJobArn sets the IotJobArn field's value.
func (s *CreateDeploymentOutput) SetIotJobArn(v string) *CreateDeploymentOutput {
	s.IotJobArn = &v
	return s
}

// SetIotJobId sets the IotJobId field's value.
func (s *CreateDeploymentOutput) SetIotJobId(v string) *CreateDeploymentOutput {
	s.IotJobId = &v
	return s
}

type DeleteComponentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the component version.
	//
	// Arn is a required field
	Arn *string `location:"uri" locationName:"arn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteComponentInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteComponentInput) SetArn(v string) *DeleteComponentInput {
	s.Arn = &v
	return s
}

type DeleteComponentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteComponentOutput) GoString() string {
	return s.String()
}

type DeleteCoreDeviceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the core device. This is also the name of the IoT thing.
	//
	// CoreDeviceThingName is a required field
	CoreDeviceThingName *string `location:"uri" locationName:"coreDeviceThingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCoreDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCoreDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCoreDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCoreDeviceInput"}
	if s.CoreDeviceThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("CoreDeviceThingName"))
	}
	if s.CoreDeviceThingName != nil && len(*s.CoreDeviceThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CoreDeviceThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCoreDeviceThingName sets the CoreDeviceThingName field's value.
func (s *DeleteCoreDeviceInput) SetCoreDeviceThingName(v string) *DeleteCoreDeviceInput {
	s.CoreDeviceThingName = &v
	return s
}

type DeleteCoreDeviceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCoreDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCoreDeviceOutput) GoString() string {
	return s.String()
}

// Contains information about a deployment.
type Deployment struct {
	_ struct{} `type:"structure"`

	// The time at which the deployment was created, expressed in ISO 8601 format.
	CreationTimestamp *time.Time `locationName:"creationTimestamp" type:"timestamp"`

	// The ID of the deployment.
	DeploymentId *string `locationName:"deploymentId" min:"1" type:"string"`

	// The name of the deployment.
	DeploymentName *string `locationName:"deploymentName" min:"1" type:"string"`

	// The status of the deployment.
	DeploymentStatus *string `locationName:"deploymentStatus" type:"string" enum:"DeploymentStatus"`

	// Whether or not the deployment is the latest revision for its target.
	IsLatestForTarget *bool `locationName:"isLatestForTarget" type:"boolean"`

	// The revision number of the deployment.
	RevisionId *string `locationName:"revisionId" min:"1" type:"string"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the target IoT thing or thing group.
	TargetArn *string `locationName:"targetArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Deployment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Deployment) GoString() string {
	return s.String()
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *Deployment) SetCreationTimestamp(v time.Time) *Deployment {
	s.CreationTimestamp = &v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *Deployment) SetDeploymentId(v string) *Deployment {
	s.DeploymentId = &v
	return s
}

// SetDeploymentName sets the DeploymentName field's value.
func (s *Deployment) SetDeploymentName(v string) *Deployment {
	s.DeploymentName = &v
	return s
}

// SetDeploymentStatus sets the DeploymentStatus field's value.
func (s *Deployment) SetDeploymentStatus(v string) *Deployment {
	s.DeploymentStatus = &v
	return s
}

// SetIsLatestForTarget sets the IsLatestForTarget field's value.
func (s *Deployment) SetIsLatestForTarget(v bool) *Deployment {
	s.IsLatestForTarget = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *Deployment) SetRevisionId(v string) *Deployment {
	s.RevisionId = &v
	return s
}

// SetTargetArn sets the TargetArn field's value.
func (s *Deployment) SetTargetArn(v string) *Deployment {
	s.TargetArn = &v
	return s
}

// Contains information about a deployment's policy that defines when components
// are safe to update.
//
// Each component on a device can report whether or not it's ready to update.
// After a component and its dependencies are ready, they can apply the update
// in the deployment. You can configure whether or not the deployment notifies
// components of an update and waits for a response. You specify the amount
// of time each component has to respond to the update notification.
type DeploymentComponentUpdatePolicy struct {
	_ struct{} `type:"structure"`

	// Whether or not to notify components and wait for components to become safe
	// to update. Choose from the following options:
	//
	//    * NOTIFY_COMPONENTS – The deployment notifies each component before
	//    it stops and updates that component. Components can use the SubscribeToComponentUpdates
	//    (https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-subscribetocomponentupdates)
	//    IPC operation to receive these notifications. Then, components can respond
	//    with the DeferComponentUpdate (https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-defercomponentupdate)
	//    IPC operation. For more information, see Create deployments (https://docs.aws.amazon.com/greengrass/v2/developerguide/create-deployments.html)
	//    in the IoT Greengrass V2 Developer Guide.
	//
	//    * SKIP_NOTIFY_COMPONENTS – The deployment doesn't notify components
	//    or wait for them to be safe to update.
	//
	// Default: NOTIFY_COMPONENTS
	Action *string `locationName:"action" type:"string" enum:"DeploymentComponentUpdatePolicyAction"`

	// The amount of time in seconds that each component on a device has to report
	// that it's safe to update. If the component waits for longer than this timeout,
	// then the deployment proceeds on the device.
	//
	// Default: 60
	TimeoutInSeconds *int64 `locationName:"timeoutInSeconds" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentComponentUpdatePolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentComponentUpdatePolicy) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *DeploymentComponentUpdatePolicy) SetAction(v string) *DeploymentComponentUpdatePolicy {
	s.Action = &v
	return s
}

// SetTimeoutInSeconds sets the TimeoutInSeconds field's value.
func (s *DeploymentComponentUpdatePolicy) SetTimeoutInSeconds(v int64) *DeploymentComponentUpdatePolicy {
	s.TimeoutInSeconds = &v
	return s
}

// Contains information about how long a component on a core device can validate
// its configuration updates before it times out. Components can use the SubscribeToValidateConfigurationUpdates
// (https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-subscribetovalidateconfigurationupdates)
// IPC operation to receive notifications when a deployment specifies a configuration
// update. Then, components can respond with the SendConfigurationValidityReport
// (https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-sendconfigurationvalidityreport)
// IPC operation. For more information, see Create deployments (https://docs.aws.amazon.com/greengrass/v2/developerguide/create-deployments.html)
// in the IoT Greengrass V2 Developer Guide.
type DeploymentConfigurationValidationPolicy struct {
	_ struct{} `type:"structure"`

	// The amount of time in seconds that a component can validate its configuration
	// updates. If the validation time exceeds this timeout, then the deployment
	// proceeds for the device.
	//
	// Default: 30
	TimeoutInSeconds *int64 `locationName:"timeoutInSeconds" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentConfigurationValidationPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentConfigurationValidationPolicy) GoString() string {
	return s.String()
}

// SetTimeoutInSeconds sets the TimeoutInSeconds field's value.
func (s *DeploymentConfigurationValidationPolicy) SetTimeoutInSeconds(v int64) *DeploymentConfigurationValidationPolicy {
	s.TimeoutInSeconds = &v
	return s
}

// Contains information about an IoT job configuration.
type DeploymentIoTJobConfiguration struct {
	_ struct{} `type:"structure"`

	// The stop configuration for the job. This configuration defines when and how
	// to stop a job rollout.
	AbortConfig *IoTJobAbortConfig `locationName:"abortConfig" type:"structure"`

	// The rollout configuration for the job. This configuration defines the rate
	// at which the job rolls out to the fleet of target devices.
	JobExecutionsRolloutConfig *IoTJobExecutionsRolloutConfig `locationName:"jobExecutionsRolloutConfig" type:"structure"`

	// The timeout configuration for the job. This configuration defines the amount
	// of time each device has to complete the job.
	TimeoutConfig *IoTJobTimeoutConfig `locationName:"timeoutConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentIoTJobConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentIoTJobConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeploymentIoTJobConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeploymentIoTJobConfiguration"}
	if s.AbortConfig != nil {
		if err := s.AbortConfig.Validate(); err != nil {
			invalidParams.AddNested("AbortConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.JobExecutionsRolloutConfig != nil {
		if err := s.JobExecutionsRolloutConfig.Validate(); err != nil {
			invalidParams.AddNested("JobExecutionsRolloutConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAbortConfig sets the AbortConfig field's value.
func (s *DeploymentIoTJobConfiguration) SetAbortConfig(v *IoTJobAbortConfig) *DeploymentIoTJobConfiguration {
	s.AbortConfig = v
	return s
}

// SetJobExecutionsRolloutConfig sets the JobExecutionsRolloutConfig field's value.
func (s *DeploymentIoTJobConfiguration) SetJobExecutionsRolloutConfig(v *IoTJobExecutionsRolloutConfig) *DeploymentIoTJobConfiguration {
	s.JobExecutionsRolloutConfig = v
	return s
}

// SetTimeoutConfig sets the TimeoutConfig field's value.
func (s *DeploymentIoTJobConfiguration) SetTimeoutConfig(v *IoTJobTimeoutConfig) *DeploymentIoTJobConfiguration {
	s.TimeoutConfig = v
	return s
}

// Contains information about policies that define how a deployment updates
// components and handles failure.
type DeploymentPolicies struct {
	_ struct{} `type:"structure"`

	// The component update policy for the configuration deployment. This policy
	// defines when it's safe to deploy the configuration to devices.
	ComponentUpdatePolicy *DeploymentComponentUpdatePolicy `locationName:"componentUpdatePolicy" type:"structure"`

	// The configuration validation policy for the configuration deployment. This
	// policy defines how long each component has to validate its configure updates.
	ConfigurationValidationPolicy *DeploymentConfigurationValidationPolicy `locationName:"configurationValidationPolicy" type:"structure"`

	// The failure handling policy for the configuration deployment. This policy
	// defines what to do if the deployment fails.
	//
	// Default: ROLLBACK
	FailureHandlingPolicy *string `locationName:"failureHandlingPolicy" type:"string" enum:"DeploymentFailureHandlingPolicy"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentPolicies) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentPolicies) GoString() string {
	return s.String()
}

// SetComponentUpdatePolicy sets the ComponentUpdatePolicy field's value.
func (s *DeploymentPolicies) SetComponentUpdatePolicy(v *DeploymentComponentUpdatePolicy) *DeploymentPolicies {
	s.ComponentUpdatePolicy = v
	return s
}

// SetConfigurationValidationPolicy sets the ConfigurationValidationPolicy field's value.
func (s *DeploymentPolicies) SetConfigurationValidationPolicy(v *DeploymentConfigurationValidationPolicy) *DeploymentPolicies {
	s.ConfigurationValidationPolicy = v
	return s
}

// SetFailureHandlingPolicy sets the FailureHandlingPolicy field's value.
func (s *DeploymentPolicies) SetFailureHandlingPolicy(v string) *DeploymentPolicies {
	s.FailureHandlingPolicy = &v
	return s
}

type DescribeComponentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the component version.
	//
	// Arn is a required field
	Arn *string `location:"uri" locationName:"arn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeComponentInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DescribeComponentInput) SetArn(v string) *DescribeComponentInput {
	s.Arn = &v
	return s
}

type DescribeComponentOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the component version.
	Arn *string `locationName:"arn" type:"string"`

	// The name of the component.
	ComponentName *string `locationName:"componentName" min:"1" type:"string"`

	// The version of the component.
	ComponentVersion *string `locationName:"componentVersion" min:"1" type:"string"`

	// The time at which the component was created, expressed in ISO 8601 format.
	CreationTimestamp *time.Time `locationName:"creationTimestamp" type:"timestamp"`

	// The description of the component version.
	Description *string `locationName:"description" type:"string"`

	// The platforms that the component version supports.
	Platforms []*ComponentPlatform `locationName:"platforms" type:"list"`

	// The publisher of the component version.
	Publisher *string `locationName:"publisher" type:"string"`

	// The status of the component version in IoT Greengrass V2. This status is
	// different from the status of the component on a core device.
	Status *CloudComponentStatus `locationName:"status" type:"structure"`

	// A list of key-value pairs that contain metadata for the resource. For more
	// information, see Tag your resources (https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html)
	// in the IoT Greengrass V2 Developer Guide.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeComponentOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeComponentOutput) SetArn(v string) *DescribeComponentOutput {
	s.Arn = &v
	return s
}

// SetComponentName sets the ComponentName field's value.
func (s *DescribeComponentOutput) SetComponentName(v string) *DescribeComponentOutput {
	s.ComponentName = &v
	return s
}

// SetComponentVersion sets the ComponentVersion field's value.
func (s *DescribeComponentOutput) SetComponentVersion(v string) *DescribeComponentOutput {
	s.ComponentVersion = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *DescribeComponentOutput) SetCreationTimestamp(v time.Time) *DescribeComponentOutput {
	s.CreationTimestamp = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeComponentOutput) SetDescription(v string) *DescribeComponentOutput {
	s.Description = &v
	return s
}

// SetPlatforms sets the Platforms field's value.
func (s *DescribeComponentOutput) SetPlatforms(v []*ComponentPlatform) *DescribeComponentOutput {
	s.Platforms = v
	return s
}

// SetPublisher sets the Publisher field's value.
func (s *DescribeComponentOutput) SetPublisher(v string) *DescribeComponentOutput {
	s.Publisher = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeComponentOutput) SetStatus(v *CloudComponentStatus) *DescribeComponentOutput {
	s.Status = v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeComponentOutput) SetTags(v map[string]*string) *DescribeComponentOutput {
	s.Tags = v
	return s
}

// Contains a request to disassociate a client device from a core device. The
// BatchDisassociateClientDeviceWithCoreDevice (https://docs.aws.amazon.com/greengrass/v2/APIReference/API_BatchDisassociateClientDeviceWithCoreDevice.html)
// operation consumes a list of these requests.
type DisassociateClientDeviceFromCoreDeviceEntry struct {
	_ struct{} `type:"structure"`

	// The name of the IoT thing that represents the client device to disassociate.
	//
	// ThingName is a required field
	ThingName *string `locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateClientDeviceFromCoreDeviceEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateClientDeviceFromCoreDeviceEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateClientDeviceFromCoreDeviceEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateClientDeviceFromCoreDeviceEntry"}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetThingName sets the ThingName field's value.
func (s *DisassociateClientDeviceFromCoreDeviceEntry) SetThingName(v string) *DisassociateClientDeviceFromCoreDeviceEntry {
	s.ThingName = &v
	return s
}

// Contains an error that occurs from a request to disassociate a client device
// from a core device. The BatchDisassociateClientDeviceWithCoreDevice (https://docs.aws.amazon.com/greengrass/v2/APIReference/API_BatchDisassociateClientDeviceWithCoreDevice.html)
// operation returns a list of these errors.
type DisassociateClientDeviceFromCoreDeviceErrorEntry struct {
	_ struct{} `type:"structure"`

	// The error code for the request.
	Code *string `locationName:"code" min:"1" type:"string"`

	// A message that provides additional information about the error.
	Message *string `locationName:"message" min:"1" type:"string"`

	// The name of the IoT thing whose disassociate request failed.
	ThingName *string `locationName:"thingName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateClientDeviceFromCoreDeviceErrorEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateClientDeviceFromCoreDeviceErrorEntry) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *DisassociateClientDeviceFromCoreDeviceErrorEntry) SetCode(v string) *DisassociateClientDeviceFromCoreDeviceErrorEntry {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *DisassociateClientDeviceFromCoreDeviceErrorEntry) SetMessage(v string) *DisassociateClientDeviceFromCoreDeviceErrorEntry {
	s.Message = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *DisassociateClientDeviceFromCoreDeviceErrorEntry) SetThingName(v string) *DisassociateClientDeviceFromCoreDeviceErrorEntry {
	s.ThingName = &v
	return s
}

type DisassociateServiceRoleFromAccountInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateServiceRoleFromAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateServiceRoleFromAccountInput) GoString() string {
	return s.String()
}

type DisassociateServiceRoleFromAccountOutput struct {
	_ struct{} `type:"structure"`

	// The time when the service role was disassociated from IoT Greengrass for
	// your Amazon Web Services account in this Amazon Web Services Region.
	DisassociatedAt *string `locationName:"DisassociatedAt" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateServiceRoleFromAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateServiceRoleFromAccountOutput) GoString() string {
	return s.String()
}

// SetDisassociatedAt sets the DisassociatedAt field's value.
func (s *DisassociateServiceRoleFromAccountOutput) SetDisassociatedAt(v string) *DisassociateServiceRoleFromAccountOutput {
	s.DisassociatedAt = &v
	return s
}

// Contains information about a deployment job that IoT Greengrass sends to
// a Greengrass core device.
type EffectiveDeployment struct {
	_ struct{} `type:"structure"`

	// The status of the deployment job on the Greengrass core device.
	//
	// CoreDeviceExecutionStatus is a required field
	CoreDeviceExecutionStatus *string `locationName:"coreDeviceExecutionStatus" type:"string" required:"true" enum:"EffectiveDeploymentExecutionStatus"`

	// The time at which the deployment was created, expressed in ISO 8601 format.
	//
	// CreationTimestamp is a required field
	CreationTimestamp *time.Time `locationName:"creationTimestamp" type:"timestamp" required:"true"`

	// The ID of the deployment.
	//
	// DeploymentId is a required field
	DeploymentId *string `locationName:"deploymentId" type:"string" required:"true"`

	// The name of the deployment.
	//
	// DeploymentName is a required field
	DeploymentName *string `locationName:"deploymentName" type:"string" required:"true"`

	// The description of the deployment job.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the IoT job that applies the deployment to target devices.
	IotJobArn *string `locationName:"iotJobArn" type:"string"`

	// The ID of the IoT job that applies the deployment to target devices.
	IotJobId *string `locationName:"iotJobId" min:"1" type:"string"`

	// The time at which the deployment job was last modified, expressed in ISO
	// 8601 format.
	//
	// ModifiedTimestamp is a required field
	ModifiedTimestamp *time.Time `locationName:"modifiedTimestamp" type:"timestamp" required:"true"`

	// The reason code for the update, if the job was updated.
	Reason *string `locationName:"reason" type:"string"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the target IoT thing or thing group.
	//
	// TargetArn is a required field
	TargetArn *string `locationName:"targetArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EffectiveDeployment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EffectiveDeployment) GoString() string {
	return s.String()
}

// SetCoreDeviceExecutionStatus sets the CoreDeviceExecutionStatus field's value.
func (s *EffectiveDeployment) SetCoreDeviceExecutionStatus(v string) *EffectiveDeployment {
	s.CoreDeviceExecutionStatus = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *EffectiveDeployment) SetCreationTimestamp(v time.Time) *EffectiveDeployment {
	s.CreationTimestamp = &v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *EffectiveDeployment) SetDeploymentId(v string) *EffectiveDeployment {
	s.DeploymentId = &v
	return s
}

// SetDeploymentName sets the DeploymentName field's value.
func (s *EffectiveDeployment) SetDeploymentName(v string) *EffectiveDeployment {
	s.DeploymentName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *EffectiveDeployment) SetDescription(v string) *EffectiveDeployment {
	s.Description = &v
	return s
}

// SetIotJobArn sets the IotJobArn field's value.
func (s *EffectiveDeployment) SetIotJobArn(v string) *EffectiveDeployment {
	s.IotJobArn = &v
	return s
}

// SetIotJobId sets the IotJobId field's value.
func (s *EffectiveDeployment) SetIotJobId(v string) *EffectiveDeployment {
	s.IotJobId = &v
	return s
}

// SetModifiedTimestamp sets the ModifiedTimestamp field's value.
func (s *EffectiveDeployment) SetModifiedTimestamp(v time.Time) *EffectiveDeployment {
	s.ModifiedTimestamp = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *EffectiveDeployment) SetReason(v string) *EffectiveDeployment {
	s.Reason = &v
	return s
}

// SetTargetArn sets the TargetArn field's value.
func (s *EffectiveDeployment) SetTargetArn(v string) *EffectiveDeployment {
	s.TargetArn = &v
	return s
}

type GetComponentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the component version.
	//
	// Arn is a required field
	Arn *string `location:"uri" locationName:"arn" type:"string" required:"true"`

	// The format of the recipe.
	RecipeOutputFormat *string `location:"querystring" locationName:"recipeOutputFormat" type:"string" enum:"RecipeOutputFormat"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetComponentInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetComponentInput) SetArn(v string) *GetComponentInput {
	s.Arn = &v
	return s
}

// SetRecipeOutputFormat sets the RecipeOutputFormat field's value.
func (s *GetComponentInput) SetRecipeOutputFormat(v string) *GetComponentInput {
	s.RecipeOutputFormat = &v
	return s
}

type GetComponentOutput struct {
	_ struct{} `type:"structure"`

	// The recipe of the component version.
	// Recipe is automatically base64 encoded/decoded by the SDK.
	//
	// Recipe is a required field
	Recipe []byte `locationName:"recipe" type:"blob" required:"true"`

	// The format of the recipe.
	//
	// RecipeOutputFormat is a required field
	RecipeOutputFormat *string `locationName:"recipeOutputFormat" type:"string" required:"true" enum:"RecipeOutputFormat"`

	// A list of key-value pairs that contain metadata for the resource. For more
	// information, see Tag your resources (https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html)
	// in the IoT Greengrass V2 Developer Guide.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComponentOutput) GoString() string {
	return s.String()
}

// SetRecipe sets the Recipe field's value.
func (s *GetComponentOutput) SetRecipe(v []byte) *GetComponentOutput {
	s.Recipe = v
	return s
}

// SetRecipeOutputFormat sets the RecipeOutputFormat field's value.
func (s *GetComponentOutput) SetRecipeOutputFormat(v string) *GetComponentOutput {
	s.RecipeOutputFormat = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetComponentOutput) SetTags(v map[string]*string) *GetComponentOutput {
	s.Tags = v
	return s
}

type GetComponentVersionArtifactInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the component version. Specify the ARN of a public component version.
	//
	// Arn is a required field
	Arn *string `location:"uri" locationName:"arn" type:"string" required:"true"`

	// The name of the artifact.
	//
	// You can use the GetComponent (https://docs.aws.amazon.com/greengrass/v2/APIReference/API_GetComponent.html)
	// operation to download the component recipe, which includes the URI of the
	// artifact. The artifact name is the section of the URI after the scheme. For
	// example, in the artifact URI greengrass:SomeArtifact.zip, the artifact name
	// is SomeArtifact.zip.
	//
	// ArtifactName is a required field
	ArtifactName *string `location:"uri" locationName:"artifactName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComponentVersionArtifactInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComponentVersionArtifactInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetComponentVersionArtifactInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetComponentVersionArtifactInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}
	if s.ArtifactName == nil {
		invalidParams.Add(request.NewErrParamRequired("ArtifactName"))
	}
	if s.ArtifactName != nil && len(*s.ArtifactName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ArtifactName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetComponentVersionArtifactInput) SetArn(v string) *GetComponentVersionArtifactInput {
	s.Arn = &v
	return s
}

// SetArtifactName sets the ArtifactName field's value.
func (s *GetComponentVersionArtifactInput) SetArtifactName(v string) *GetComponentVersionArtifactInput {
	s.ArtifactName = &v
	return s
}

type GetComponentVersionArtifactOutput struct {
	_ struct{} `type:"structure"`

	// The URL of the artifact.
	//
	// PreSignedUrl is a required field
	PreSignedUrl *string `locationName:"preSignedUrl" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComponentVersionArtifactOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComponentVersionArtifactOutput) GoString() string {
	return s.String()
}

// SetPreSignedUrl sets the PreSignedUrl field's value.
func (s *GetComponentVersionArtifactOutput) SetPreSignedUrl(v string) *GetComponentVersionArtifactOutput {
	s.PreSignedUrl = &v
	return s
}

type GetConnectivityInfoInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the core device. This is also the name of the IoT thing.
	//
	// ThingName is a required field
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConnectivityInfoInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConnectivityInfoInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConnectivityInfoInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetConnectivityInfoInput"}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetThingName sets the ThingName field's value.
func (s *GetConnectivityInfoInput) SetThingName(v string) *GetConnectivityInfoInput {
	s.ThingName = &v
	return s
}

type GetConnectivityInfoOutput struct {
	_ struct{} `type:"structure"`

	// The connectivity information for the core device.
	ConnectivityInfo []*ConnectivityInfo `locationName:"ConnectivityInfo" type:"list"`

	// A message about the connectivity information request.
	Message *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConnectivityInfoOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConnectivityInfoOutput) GoString() string {
	return s.String()
}

// SetConnectivityInfo sets the ConnectivityInfo field's value.
func (s *GetConnectivityInfoOutput) SetConnectivityInfo(v []*ConnectivityInfo) *GetConnectivityInfoOutput {
	s.ConnectivityInfo = v
	return s
}

// SetMessage sets the Message field's value.
func (s *GetConnectivityInfoOutput) SetMessage(v string) *GetConnectivityInfoOutput {
	s.Message = &v
	return s
}

type GetCoreDeviceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the core device. This is also the name of the IoT thing.
	//
	// CoreDeviceThingName is a required field
	CoreDeviceThingName *string `location:"uri" locationName:"coreDeviceThingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCoreDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCoreDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCoreDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCoreDeviceInput"}
	if s.CoreDeviceThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("CoreDeviceThingName"))
	}
	if s.CoreDeviceThingName != nil && len(*s.CoreDeviceThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CoreDeviceThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCoreDeviceThingName sets the CoreDeviceThingName field's value.
func (s *GetCoreDeviceInput) SetCoreDeviceThingName(v string) *GetCoreDeviceInput {
	s.CoreDeviceThingName = &v
	return s
}

type GetCoreDeviceOutput struct {
	_ struct{} `type:"structure"`

	// The computer architecture of the core device.
	Architecture *string `locationName:"architecture" min:"1" type:"string"`

	// The name of the core device. This is also the name of the IoT thing.
	CoreDeviceThingName *string `locationName:"coreDeviceThingName" min:"1" type:"string"`

	// The version of the IoT Greengrass Core software that the core device runs.
	// This version is equivalent to the version of the Greengrass nucleus component
	// that runs on the core device. For more information, see the Greengrass nucleus
	// component (https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html)
	// in the IoT Greengrass V2 Developer Guide.
	CoreVersion *string `locationName:"coreVersion" min:"1" type:"string"`

	// The time at which the core device's status last updated, expressed in ISO
	// 8601 format.
	LastStatusUpdateTimestamp *time.Time `locationName:"lastStatusUpdateTimestamp" type:"timestamp"`

	// The operating system platform that the core device runs.
	Platform *string `locationName:"platform" min:"1" type:"string"`

	// The status of the core device. The core device status can be:
	//
	//    * HEALTHY – The IoT Greengrass Core software and all components run
	//    on the core device without issue.
	//
	//    * UNHEALTHY – The IoT Greengrass Core software or a component is in
	//    a failed state on the core device.
	Status *string `locationName:"status" type:"string" enum:"CoreDeviceStatus"`

	// A list of key-value pairs that contain metadata for the resource. For more
	// information, see Tag your resources (https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html)
	// in the IoT Greengrass V2 Developer Guide.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCoreDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCoreDeviceOutput) GoString() string {
	return s.String()
}

// SetArchitecture sets the Architecture field's value.
func (s *GetCoreDeviceOutput) SetArchitecture(v string) *GetCoreDeviceOutput {
	s.Architecture = &v
	return s
}

// SetCoreDeviceThingName sets the CoreDeviceThingName field's value.
func (s *GetCoreDeviceOutput) SetCoreDeviceThingName(v string) *GetCoreDeviceOutput {
	s.CoreDeviceThingName = &v
	return s
}

// SetCoreVersion sets the CoreVersion field's value.
func (s *GetCoreDeviceOutput) SetCoreVersion(v string) *GetCoreDeviceOutput {
	s.CoreVersion = &v
	return s
}

// SetLastStatusUpdateTimestamp sets the LastStatusUpdateTimestamp field's value.
func (s *GetCoreDeviceOutput) SetLastStatusUpdateTimestamp(v time.Time) *GetCoreDeviceOutput {
	s.LastStatusUpdateTimestamp = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *GetCoreDeviceOutput) SetPlatform(v string) *GetCoreDeviceOutput {
	s.Platform = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetCoreDeviceOutput) SetStatus(v string) *GetCoreDeviceOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetCoreDeviceOutput) SetTags(v map[string]*string) *GetCoreDeviceOutput {
	s.Tags = v
	return s
}

type GetDeploymentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the deployment.
	//
	// DeploymentId is a required field
	DeploymentId *string `location:"uri" locationName:"deploymentId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeploymentInput"}
	if s.DeploymentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentId"))
	}
	if s.DeploymentId != nil && len(*s.DeploymentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *GetDeploymentInput) SetDeploymentId(v string) *GetDeploymentInput {
	s.DeploymentId = &v
	return s
}

type GetDeploymentOutput struct {
	_ struct{} `type:"structure"`

	// The components to deploy. This is a dictionary, where each key is the name
	// of a component, and each key's value is the version and configuration to
	// deploy for that component.
	Components map[string]*ComponentDeploymentSpecification `locationName:"components" type:"map"`

	// The time at which the deployment was created, expressed in ISO 8601 format.
	CreationTimestamp *time.Time `locationName:"creationTimestamp" type:"timestamp"`

	// The ID of the deployment.
	DeploymentId *string `locationName:"deploymentId" min:"1" type:"string"`

	// The name of the deployment.
	DeploymentName *string `locationName:"deploymentName" type:"string"`

	// The deployment policies for the deployment. These policies define how the
	// deployment updates components and handles failure.
	DeploymentPolicies *DeploymentPolicies `locationName:"deploymentPolicies" type:"structure"`

	// The status of the deployment.
	DeploymentStatus *string `locationName:"deploymentStatus" type:"string" enum:"DeploymentStatus"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the IoT job that applies the deployment to target devices.
	IotJobArn *string `locationName:"iotJobArn" type:"string"`

	// The job configuration for the deployment configuration. The job configuration
	// specifies the rollout, timeout, and stop configurations for the deployment
	// configuration.
	IotJobConfiguration *DeploymentIoTJobConfiguration `locationName:"iotJobConfiguration" type:"structure"`

	// The ID of the IoT job that applies the deployment to target devices.
	IotJobId *string `locationName:"iotJobId" type:"string"`

	// Whether or not the deployment is the latest revision for its target.
	IsLatestForTarget *bool `locationName:"isLatestForTarget" type:"boolean"`

	// The revision number of the deployment.
	RevisionId *string `locationName:"revisionId" min:"1" type:"string"`

	// A list of key-value pairs that contain metadata for the resource. For more
	// information, see Tag your resources (https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html)
	// in the IoT Greengrass V2 Developer Guide.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the target IoT thing or thing group.
	TargetArn *string `locationName:"targetArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeploymentOutput) GoString() string {
	return s.String()
}

// SetComponents sets the Components field's value.
func (s *GetDeploymentOutput) SetComponents(v map[string]*ComponentDeploymentSpecification) *GetDeploymentOutput {
	s.Components = v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *GetDeploymentOutput) SetCreationTimestamp(v time.Time) *GetDeploymentOutput {
	s.CreationTimestamp = &v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *GetDeploymentOutput) SetDeploymentId(v string) *GetDeploymentOutput {
	s.DeploymentId = &v
	return s
}

// SetDeploymentName sets the DeploymentName field's value.
func (s *GetDeploymentOutput) SetDeploymentName(v string) *GetDeploymentOutput {
	s.DeploymentName = &v
	return s
}

// SetDeploymentPolicies sets the DeploymentPolicies field's value.
func (s *GetDeploymentOutput) SetDeploymentPolicies(v *DeploymentPolicies) *GetDeploymentOutput {
	s.DeploymentPolicies = v
	return s
}

// SetDeploymentStatus sets the DeploymentStatus field's value.
func (s *GetDeploymentOutput) SetDeploymentStatus(v string) *GetDeploymentOutput {
	s.DeploymentStatus = &v
	return s
}

// SetIotJobArn sets the IotJobArn field's value.
func (s *GetDeploymentOutput) SetIotJobArn(v string) *GetDeploymentOutput {
	s.IotJobArn = &v
	return s
}

// SetIotJobConfiguration sets the IotJobConfiguration field's value.
func (s *GetDeploymentOutput) SetIotJobConfiguration(v *DeploymentIoTJobConfiguration) *GetDeploymentOutput {
	s.IotJobConfiguration = v
	return s
}

// SetIotJobId sets the IotJobId field's value.
func (s *GetDeploymentOutput) SetIotJobId(v string) *GetDeploymentOutput {
	s.IotJobId = &v
	return s
}

// SetIsLatestForTarget sets the IsLatestForTarget field's value.
func (s *GetDeploymentOutput) SetIsLatestForTarget(v bool) *GetDeploymentOutput {
	s.IsLatestForTarget = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *GetDeploymentOutput) SetRevisionId(v string) *GetDeploymentOutput {
	s.RevisionId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetDeploymentOutput) SetTags(v map[string]*string) *GetDeploymentOutput {
	s.Tags = v
	return s
}

// SetTargetArn sets the TargetArn field's value.
func (s *GetDeploymentOutput) SetTargetArn(v string) *GetDeploymentOutput {
	s.TargetArn = &v
	return s
}

type GetServiceRoleForAccountInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceRoleForAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceRoleForAccountInput) GoString() string {
	return s.String()
}

type GetServiceRoleForAccountOutput struct {
	_ struct{} `type:"structure"`

	// The time when the service role was associated with IoT Greengrass for your
	// Amazon Web Services account in this Amazon Web Services Region.
	AssociatedAt *string `locationName:"AssociatedAt" type:"string"`

	// The ARN of the service role that is associated with IoT Greengrass for your
	// Amazon Web Services account in this Amazon Web Services Region.
	RoleArn *string `locationName:"RoleArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceRoleForAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceRoleForAccountOutput) GoString() string {
	return s.String()
}

// SetAssociatedAt sets the AssociatedAt field's value.
func (s *GetServiceRoleForAccountOutput) SetAssociatedAt(v string) *GetServiceRoleForAccountOutput {
	s.AssociatedAt = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *GetServiceRoleForAccountOutput) SetRoleArn(v string) *GetServiceRoleForAccountOutput {
	s.RoleArn = &v
	return s
}

// Contains information about a component on a Greengrass core device.
type InstalledComponent struct {
	_ struct{} `type:"structure"`

	// The name of the component.
	ComponentName *string `locationName:"componentName" min:"1" type:"string"`

	// The version of the component.
	ComponentVersion *string `locationName:"componentVersion" min:"1" type:"string"`

	// Whether or not the component is a root component.
	IsRoot *bool `locationName:"isRoot" type:"boolean"`

	// The lifecycle state of the component.
	LifecycleState *string `locationName:"lifecycleState" type:"string" enum:"InstalledComponentLifecycleState"`

	// The details about the lifecycle state of the component.
	LifecycleStateDetails *string `locationName:"lifecycleStateDetails" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstalledComponent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstalledComponent) GoString() string {
	return s.String()
}

// SetComponentName sets the ComponentName field's value.
func (s *InstalledComponent) SetComponentName(v string) *InstalledComponent {
	s.ComponentName = &v
	return s
}

// SetComponentVersion sets the ComponentVersion field's value.
func (s *InstalledComponent) SetComponentVersion(v string) *InstalledComponent {
	s.ComponentVersion = &v
	return s
}

// SetIsRoot sets the IsRoot field's value.
func (s *InstalledComponent) SetIsRoot(v bool) *InstalledComponent {
	s.IsRoot = &v
	return s
}

// SetLifecycleState sets the LifecycleState field's value.
func (s *InstalledComponent) SetLifecycleState(v string) *InstalledComponent {
	s.LifecycleState = &v
	return s
}

// SetLifecycleStateDetails sets the LifecycleStateDetails field's value.
func (s *InstalledComponent) SetLifecycleStateDetails(v string) *InstalledComponent {
	s.LifecycleStateDetails = &v
	return s
}

// IoT Greengrass can't process your request right now. Try again later.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The amount of time to wait before you retry the request.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains a list of criteria that define when and how to cancel a configuration
// deployment.
type IoTJobAbortConfig struct {
	_ struct{} `type:"structure"`

	// The list of criteria that define when and how to cancel the configuration
	// deployment.
	//
	// CriteriaList is a required field
	CriteriaList []*IoTJobAbortCriteria `locationName:"criteriaList" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IoTJobAbortConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IoTJobAbortConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IoTJobAbortConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IoTJobAbortConfig"}
	if s.CriteriaList == nil {
		invalidParams.Add(request.NewErrParamRequired("CriteriaList"))
	}
	if s.CriteriaList != nil && len(s.CriteriaList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CriteriaList", 1))
	}
	if s.CriteriaList != nil {
		for i, v := range s.CriteriaList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CriteriaList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCriteriaList sets the CriteriaList field's value.
func (s *IoTJobAbortConfig) SetCriteriaList(v []*IoTJobAbortCriteria) *IoTJobAbortConfig {
	s.CriteriaList = v
	return s
}

// Contains criteria that define when and how to cancel a job.
//
// The deployment stops if the following conditions are true:
//
// The number of things that receive the deployment exceeds the minNumberOfExecutedThings.
//
// The percentage of failures with type failureType exceeds the thresholdPercentage.
type IoTJobAbortCriteria struct {
	_ struct{} `type:"structure"`

	// The action to perform when the criteria are met.
	//
	// Action is a required field
	Action *string `locationName:"action" type:"string" required:"true" enum:"IoTJobAbortAction"`

	// The type of job deployment failure that can cancel a job.
	//
	// FailureType is a required field
	FailureType *string `locationName:"failureType" type:"string" required:"true" enum:"IoTJobExecutionFailureType"`

	// The minimum number of things that receive the configuration before the job
	// can cancel.
	//
	// MinNumberOfExecutedThings is a required field
	MinNumberOfExecutedThings *int64 `locationName:"minNumberOfExecutedThings" min:"1" type:"integer" required:"true"`

	// The minimum percentage of failureType failures that occur before the job
	// can cancel.
	//
	// This parameter supports up to two digits after the decimal (for example,
	// you can specify 10.9 or 10.99, but not 10.999).
	//
	// ThresholdPercentage is a required field
	ThresholdPercentage *float64 `locationName:"thresholdPercentage" type:"double" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IoTJobAbortCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IoTJobAbortCriteria) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IoTJobAbortCriteria) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IoTJobAbortCriteria"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.FailureType == nil {
		invalidParams.Add(request.NewErrParamRequired("FailureType"))
	}
	if s.MinNumberOfExecutedThings == nil {
		invalidParams.Add(request.NewErrParamRequired("MinNumberOfExecutedThings"))
	}
	if s.MinNumberOfExecutedThings != nil && *s.MinNumberOfExecutedThings < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MinNumberOfExecutedThings", 1))
	}
	if s.ThresholdPercentage == nil {
		invalidParams.Add(request.NewErrParamRequired("ThresholdPercentage"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *IoTJobAbortCriteria) SetAction(v string) *IoTJobAbortCriteria {
	s.Action = &v
	return s
}

// SetFailureType sets the FailureType field's value.
func (s *IoTJobAbortCriteria) SetFailureType(v string) *IoTJobAbortCriteria {
	s.FailureType = &v
	return s
}

// SetMinNumberOfExecutedThings sets the MinNumberOfExecutedThings field's value.
func (s *IoTJobAbortCriteria) SetMinNumberOfExecutedThings(v int64) *IoTJobAbortCriteria {
	s.MinNumberOfExecutedThings = &v
	return s
}

// SetThresholdPercentage sets the ThresholdPercentage field's value.
func (s *IoTJobAbortCriteria) SetThresholdPercentage(v float64) *IoTJobAbortCriteria {
	s.ThresholdPercentage = &v
	return s
}

// Contains information about the rollout configuration for a job. This configuration
// defines the rate at which the job deploys a configuration to a fleet of target
// devices.
type IoTJobExecutionsRolloutConfig struct {
	_ struct{} `type:"structure"`

	// The exponential rate to increase the job rollout rate.
	ExponentialRate *IoTJobExponentialRolloutRate `locationName:"exponentialRate" type:"structure"`

	// The maximum number of devices that receive a pending job notification, per
	// minute.
	MaximumPerMinute *int64 `locationName:"maximumPerMinute" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IoTJobExecutionsRolloutConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IoTJobExecutionsRolloutConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IoTJobExecutionsRolloutConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IoTJobExecutionsRolloutConfig"}
	if s.MaximumPerMinute != nil && *s.MaximumPerMinute < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaximumPerMinute", 1))
	}
	if s.ExponentialRate != nil {
		if err := s.ExponentialRate.Validate(); err != nil {
			invalidParams.AddNested("ExponentialRate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExponentialRate sets the ExponentialRate field's value.
func (s *IoTJobExecutionsRolloutConfig) SetExponentialRate(v *IoTJobExponentialRolloutRate) *IoTJobExecutionsRolloutConfig {
	s.ExponentialRate = v
	return s
}

// SetMaximumPerMinute sets the MaximumPerMinute field's value.
func (s *IoTJobExecutionsRolloutConfig) SetMaximumPerMinute(v int64) *IoTJobExecutionsRolloutConfig {
	s.MaximumPerMinute = &v
	return s
}

// Contains information about an exponential rollout rate for a configuration
// deployment job.
type IoTJobExponentialRolloutRate struct {
	_ struct{} `type:"structure"`

	// The minimum number of devices that receive a pending job notification, per
	// minute, when the job starts. This parameter defines the initial rollout rate
	// of the job.
	//
	// BaseRatePerMinute is a required field
	BaseRatePerMinute *int64 `locationName:"baseRatePerMinute" min:"1" type:"integer" required:"true"`

	// The exponential factor to increase the rollout rate for the job.
	//
	// This parameter supports up to one digit after the decimal (for example, you
	// can specify 1.5, but not 1.55).
	//
	// IncrementFactor is a required field
	IncrementFactor *float64 `locationName:"incrementFactor" min:"1" type:"double" required:"true"`

	// The criteria to increase the rollout rate for the job.
	//
	// RateIncreaseCriteria is a required field
	RateIncreaseCriteria *IoTJobRateIncreaseCriteria `locationName:"rateIncreaseCriteria" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IoTJobExponentialRolloutRate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IoTJobExponentialRolloutRate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IoTJobExponentialRolloutRate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IoTJobExponentialRolloutRate"}
	if s.BaseRatePerMinute == nil {
		invalidParams.Add(request.NewErrParamRequired("BaseRatePerMinute"))
	}
	if s.BaseRatePerMinute != nil && *s.BaseRatePerMinute < 1 {
		invalidParams.Add(request.NewErrParamMinValue("BaseRatePerMinute", 1))
	}
	if s.IncrementFactor == nil {
		invalidParams.Add(request.NewErrParamRequired("IncrementFactor"))
	}
	if s.IncrementFactor != nil && *s.IncrementFactor < 1 {
		invalidParams.Add(request.NewErrParamMinValue("IncrementFactor", 1))
	}
	if s.RateIncreaseCriteria == nil {
		invalidParams.Add(request.NewErrParamRequired("RateIncreaseCriteria"))
	}
	if s.RateIncreaseCriteria != nil {
		if err := s.RateIncreaseCriteria.Validate(); err != nil {
			invalidParams.AddNested("RateIncreaseCriteria", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBaseRatePerMinute sets the BaseRatePerMinute field's value.
func (s *IoTJobExponentialRolloutRate) SetBaseRatePerMinute(v int64) *IoTJobExponentialRolloutRate {
	s.BaseRatePerMinute = &v
	return s
}

// SetIncrementFactor sets the IncrementFactor field's value.
func (s *IoTJobExponentialRolloutRate) SetIncrementFactor(v float64) *IoTJobExponentialRolloutRate {
	s.IncrementFactor = &v
	return s
}

// SetRateIncreaseCriteria sets the RateIncreaseCriteria field's value.
func (s *IoTJobExponentialRolloutRate) SetRateIncreaseCriteria(v *IoTJobRateIncreaseCriteria) *IoTJobExponentialRolloutRate {
	s.RateIncreaseCriteria = v
	return s
}

// Contains information about criteria to meet before a job increases its rollout
// rate. Specify either numberOfNotifiedThings or numberOfSucceededThings.
type IoTJobRateIncreaseCriteria struct {
	_ struct{} `type:"structure"`

	// The number of devices to receive the job notification before the rollout
	// rate increases.
	NumberOfNotifiedThings *int64 `locationName:"numberOfNotifiedThings" min:"1" type:"integer"`

	// The number of devices to successfully run the configuration job before the
	// rollout rate increases.
	NumberOfSucceededThings *int64 `locationName:"numberOfSucceededThings" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IoTJobRateIncreaseCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IoTJobRateIncreaseCriteria) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IoTJobRateIncreaseCriteria) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IoTJobRateIncreaseCriteria"}
	if s.NumberOfNotifiedThings != nil && *s.NumberOfNotifiedThings < 1 {
		invalidParams.Add(request.NewErrParamMinValue("NumberOfNotifiedThings", 1))
	}
	if s.NumberOfSucceededThings != nil && *s.NumberOfSucceededThings < 1 {
		invalidParams.Add(request.NewErrParamMinValue("NumberOfSucceededThings", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNumberOfNotifiedThings sets the NumberOfNotifiedThings field's value.
func (s *IoTJobRateIncreaseCriteria) SetNumberOfNotifiedThings(v int64) *IoTJobRateIncreaseCriteria {
	s.NumberOfNotifiedThings = &v
	return s
}

// SetNumberOfSucceededThings sets the NumberOfSucceededThings field's value.
func (s *IoTJobRateIncreaseCriteria) SetNumberOfSucceededThings(v int64) *IoTJobRateIncreaseCriteria {
	s.NumberOfSucceededThings = &v
	return s
}

// Contains information about the timeout configuration for a job.
type IoTJobTimeoutConfig struct {
	_ struct{} `type:"structure"`

	// The amount of time, in minutes, that devices have to complete the job. The
	// timer starts when the job status is set to IN_PROGRESS. If the job status
	// doesn't change to a terminal state before the time expires, then the job
	// status is set to TIMED_OUT.
	//
	// The timeout interval must be between 1 minute and 7 days (10080 minutes).
	InProgressTimeoutInMinutes *int64 `locationName:"inProgressTimeoutInMinutes" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IoTJobTimeoutConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IoTJobTimeoutConfig) GoString() string {
	return s.String()
}

// SetInProgressTimeoutInMinutes sets the InProgressTimeoutInMinutes field's value.
func (s *IoTJobTimeoutConfig) SetInProgressTimeoutInMinutes(v int64) *IoTJobTimeoutConfig {
	s.InProgressTimeoutInMinutes = &v
	return s
}

// Contains information about a container in which Lambda functions run on Greengrass
// core devices.
type LambdaContainerParams struct {
	_ struct{} `type:"structure"`

	// The list of system devices that the container can access.
	Devices []*LambdaDeviceMount `locationName:"devices" type:"list"`

	// The memory size of the container, expressed in kilobytes.
	//
	// Default: 16384 (16 MB)
	MemorySizeInKB *int64 `locationName:"memorySizeInKB" type:"integer"`

	// Whether or not the container can read information from the device's /sys
	// folder.
	//
	// Default: false
	MountROSysfs *bool `locationName:"mountROSysfs" type:"boolean"`

	// The list of volumes that the container can access.
	Volumes []*LambdaVolumeMount `locationName:"volumes" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaContainerParams) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaContainerParams) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaContainerParams) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaContainerParams"}
	if s.Devices != nil {
		for i, v := range s.Devices {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Devices", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Volumes != nil {
		for i, v := range s.Volumes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Volumes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDevices sets the Devices field's value.
func (s *LambdaContainerParams) SetDevices(v []*LambdaDeviceMount) *LambdaContainerParams {
	s.Devices = v
	return s
}

// SetMemorySizeInKB sets the MemorySizeInKB field's value.
func (s *LambdaContainerParams) SetMemorySizeInKB(v int64) *LambdaContainerParams {
	s.MemorySizeInKB = &v
	return s
}

// SetMountROSysfs sets the MountROSysfs field's value.
func (s *LambdaContainerParams) SetMountROSysfs(v bool) *LambdaContainerParams {
	s.MountROSysfs = &v
	return s
}

// SetVolumes sets the Volumes field's value.
func (s *LambdaContainerParams) SetVolumes(v []*LambdaVolumeMount) *LambdaContainerParams {
	s.Volumes = v
	return s
}

// Contains information about a device that Linux processes in a container can
// access.
type LambdaDeviceMount struct {
	_ struct{} `type:"structure"`

	// Whether or not to add the component's system user as an owner of the device.
	//
	// Default: false
	AddGroupOwner *bool `locationName:"addGroupOwner" type:"boolean"`

	// The mount path for the device in the file system.
	//
	// Path is a required field
	Path *string `locationName:"path" type:"string" required:"true"`

	// The permission to access the device: read/only (ro) or read/write (rw).
	//
	// Default: ro
	Permission *string `locationName:"permission" type:"string" enum:"LambdaFilesystemPermission"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaDeviceMount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaDeviceMount) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaDeviceMount) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaDeviceMount"}
	if s.Path == nil {
		invalidParams.Add(request.NewErrParamRequired("Path"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddGroupOwner sets the AddGroupOwner field's value.
func (s *LambdaDeviceMount) SetAddGroupOwner(v bool) *LambdaDeviceMount {
	s.AddGroupOwner = &v
	return s
}

// SetPath sets the Path field's value.
func (s *LambdaDeviceMount) SetPath(v string) *LambdaDeviceMount {
	s.Path = &v
	return s
}

// SetPermission sets the Permission field's value.
func (s *LambdaDeviceMount) SetPermission(v string) *LambdaDeviceMount {
	s.Permission = &v
	return s
}

// Contains information about an event source for an Lambda function. The event
// source defines the topics on which this Lambda function subscribes to receive
// messages that run the function.
type LambdaEventSource struct {
	_ struct{} `type:"structure"`

	// The topic to which to subscribe to receive event messages.
	//
	// Topic is a required field
	Topic *string `locationName:"topic" type:"string" required:"true"`

	// The type of event source. Choose from the following options:
	//
	//    * PUB_SUB – Subscribe to local publish/subscribe messages. This event
	//    source type doesn't support MQTT wildcards (+ and #) in the event source
	//    topic.
	//
	//    * IOT_CORE – Subscribe to Amazon Web Services IoT Core MQTT messages.
	//    This event source type supports MQTT wildcards (+ and #) in the event
	//    source topic.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"LambdaEventSourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaEventSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaEventSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaEventSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaEventSource"}
	if s.Topic == nil {
		invalidParams.Add(request.NewErrParamRequired("Topic"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTopic sets the Topic field's value.
func (s *LambdaEventSource) SetTopic(v string) *LambdaEventSource {
	s.Topic = &v
	return s
}

// SetType sets the Type field's value.
func (s *LambdaEventSource) SetType(v string) *LambdaEventSource {
	s.Type = &v
	return s
}

// Contains parameters for a Lambda function that runs on IoT Greengrass.
type LambdaExecutionParameters struct {
	_ struct{} `type:"structure"`

	// The map of environment variables that are available to the Lambda function
	// when it runs.
	EnvironmentVariables map[string]*string `locationName:"environmentVariables" type:"map"`

	// The list of event sources to which to subscribe to receive work messages.
	// The Lambda function runs when it receives a message from an event source.
	// You can subscribe this function to local publish/subscribe messages and Amazon
	// Web Services IoT Core MQTT messages.
	EventSources []*LambdaEventSource `locationName:"eventSources" type:"list"`

	// The list of arguments to pass to the Lambda function when it runs.
	ExecArgs []*string `locationName:"execArgs" type:"list"`

	// The encoding type that the Lambda function supports.
	//
	// Default: json
	InputPayloadEncodingType *string `locationName:"inputPayloadEncodingType" type:"string" enum:"LambdaInputPayloadEncodingType"`

	// The parameters for the Linux process that contains the Lambda function.
	LinuxProcessParams *LambdaLinuxProcessParams `locationName:"linuxProcessParams" type:"structure"`

	// The maximum amount of time in seconds that a non-pinned Lambda function can
	// idle before the IoT Greengrass Core software stops its process.
	MaxIdleTimeInSeconds *int64 `locationName:"maxIdleTimeInSeconds" type:"integer"`

	// The maximum number of instances that a non-pinned Lambda function can run
	// at the same time.
	MaxInstancesCount *int64 `locationName:"maxInstancesCount" type:"integer"`

	// The maximum size of the message queue for the Lambda function component.
	// The IoT Greengrass core stores messages in a FIFO (first-in-first-out) queue
	// until it can run the Lambda function to consume each message.
	MaxQueueSize *int64 `locationName:"maxQueueSize" type:"integer"`

	// Whether or not the Lambda function is pinned, or long-lived.
	//
	//    * A pinned Lambda function starts when IoT Greengrass starts and keeps
	//    running in its own container.
	//
	//    * A non-pinned Lambda function starts only when it receives a work item
	//    and exists after it idles for maxIdleTimeInSeconds. If the function has
	//    multiple work items, the IoT Greengrass Core software creates multiple
	//    instances of the function.
	//
	// Default: true
	Pinned *bool `locationName:"pinned" type:"boolean"`

	// The interval in seconds at which a pinned (also known as long-lived) Lambda
	// function component sends status updates to the Lambda manager component.
	StatusTimeoutInSeconds *int64 `locationName:"statusTimeoutInSeconds" type:"integer"`

	// The maximum amount of time in seconds that the Lambda function can process
	// a work item.
	TimeoutInSeconds *int64 `locationName:"timeoutInSeconds" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaExecutionParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaExecutionParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaExecutionParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaExecutionParameters"}
	if s.EventSources != nil {
		for i, v := range s.EventSources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EventSources", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.LinuxProcessParams != nil {
		if err := s.LinuxProcessParams.Validate(); err != nil {
			invalidParams.AddNested("LinuxProcessParams", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentVariables sets the EnvironmentVariables field's value.
func (s *LambdaExecutionParameters) SetEnvironmentVariables(v map[string]*string) *LambdaExecutionParameters {
	s.EnvironmentVariables = v
	return s
}

// SetEventSources sets the EventSources field's value.
func (s *LambdaExecutionParameters) SetEventSources(v []*LambdaEventSource) *LambdaExecutionParameters {
	s.EventSources = v
	return s
}

// SetExecArgs sets the ExecArgs field's value.
func (s *LambdaExecutionParameters) SetExecArgs(v []*string) *LambdaExecutionParameters {
	s.ExecArgs = v
	return s
}

// SetInputPayloadEncodingType sets the InputPayloadEncodingType field's value.
func (s *LambdaExecutionParameters) SetInputPayloadEncodingType(v string) *LambdaExecutionParameters {
	s.InputPayloadEncodingType = &v
	return s
}

// SetLinuxProcessParams sets the LinuxProcessParams field's value.
func (s *LambdaExecutionParameters) SetLinuxProcessParams(v *LambdaLinuxProcessParams) *LambdaExecutionParameters {
	s.LinuxProcessParams = v
	return s
}

// SetMaxIdleTimeInSeconds sets the MaxIdleTimeInSeconds field's value.
func (s *LambdaExecutionParameters) SetMaxIdleTimeInSeconds(v int64) *LambdaExecutionParameters {
	s.MaxIdleTimeInSeconds = &v
	return s
}

// SetMaxInstancesCount sets the MaxInstancesCount field's value.
func (s *LambdaExecutionParameters) SetMaxInstancesCount(v int64) *LambdaExecutionParameters {
	s.MaxInstancesCount = &v
	return s
}

// SetMaxQueueSize sets the MaxQueueSize field's value.
func (s *LambdaExecutionParameters) SetMaxQueueSize(v int64) *LambdaExecutionParameters {
	s.MaxQueueSize = &v
	return s
}

// SetPinned sets the Pinned field's value.
func (s *LambdaExecutionParameters) SetPinned(v bool) *LambdaExecutionParameters {
	s.Pinned = &v
	return s
}

// SetStatusTimeoutInSeconds sets the StatusTimeoutInSeconds field's value.
func (s *LambdaExecutionParameters) SetStatusTimeoutInSeconds(v int64) *LambdaExecutionParameters {
	s.StatusTimeoutInSeconds = &v
	return s
}

// SetTimeoutInSeconds sets the TimeoutInSeconds field's value.
func (s *LambdaExecutionParameters) SetTimeoutInSeconds(v int64) *LambdaExecutionParameters {
	s.TimeoutInSeconds = &v
	return s
}

// Contains information about an Lambda function to import to create a component.
type LambdaFunctionRecipeSource struct {
	_ struct{} `type:"structure"`

	// The component versions on which this Lambda function component depends.
	ComponentDependencies map[string]*ComponentDependencyRequirement `locationName:"componentDependencies" type:"map"`

	// The system and runtime parameters for the Lambda function as it runs on the
	// Greengrass core device.
	ComponentLambdaParameters *LambdaExecutionParameters `locationName:"componentLambdaParameters" type:"structure"`

	// The name of the component.
	//
	// Defaults to the name of the Lambda function.
	ComponentName *string `locationName:"componentName" min:"1" type:"string"`

	// The platforms that the component version supports.
	ComponentPlatforms []*ComponentPlatform `locationName:"componentPlatforms" type:"list"`

	// The version of the component.
	//
	// Defaults to the version of the Lambda function as a semantic version. For
	// example, if your function version is 3, the component version becomes 3.0.0.
	ComponentVersion *string `locationName:"componentVersion" min:"1" type:"string"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the Lambda function. The ARN must include the version of the function
	// to import. You can't use version aliases like $LATEST.
	//
	// LambdaArn is a required field
	LambdaArn *string `locationName:"lambdaArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaFunctionRecipeSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaFunctionRecipeSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaFunctionRecipeSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaFunctionRecipeSource"}
	if s.ComponentName != nil && len(*s.ComponentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentName", 1))
	}
	if s.ComponentVersion != nil && len(*s.ComponentVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentVersion", 1))
	}
	if s.LambdaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LambdaArn"))
	}
	if s.ComponentDependencies != nil {
		for i, v := range s.ComponentDependencies {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ComponentDependencies", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ComponentLambdaParameters != nil {
		if err := s.ComponentLambdaParameters.Validate(); err != nil {
			invalidParams.AddNested("ComponentLambdaParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.ComponentPlatforms != nil {
		for i, v := range s.ComponentPlatforms {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ComponentPlatforms", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentDependencies sets the ComponentDependencies field's value.
func (s *LambdaFunctionRecipeSource) SetComponentDependencies(v map[string]*ComponentDependencyRequirement) *LambdaFunctionRecipeSource {
	s.ComponentDependencies = v
	return s
}

// SetComponentLambdaParameters sets the ComponentLambdaParameters field's value.
func (s *LambdaFunctionRecipeSource) SetComponentLambdaParameters(v *LambdaExecutionParameters) *LambdaFunctionRecipeSource {
	s.ComponentLambdaParameters = v
	return s
}

// SetComponentName sets the ComponentName field's value.
func (s *LambdaFunctionRecipeSource) SetComponentName(v string) *LambdaFunctionRecipeSource {
	s.ComponentName = &v
	return s
}

// SetComponentPlatforms sets the ComponentPlatforms field's value.
func (s *LambdaFunctionRecipeSource) SetComponentPlatforms(v []*ComponentPlatform) *LambdaFunctionRecipeSource {
	s.ComponentPlatforms = v
	return s
}

// SetComponentVersion sets the ComponentVersion field's value.
func (s *LambdaFunctionRecipeSource) SetComponentVersion(v string) *LambdaFunctionRecipeSource {
	s.ComponentVersion = &v
	return s
}

// SetLambdaArn sets the LambdaArn field's value.
func (s *LambdaFunctionRecipeSource) SetLambdaArn(v string) *LambdaFunctionRecipeSource {
	s.LambdaArn = &v
	return s
}

// Contains parameters for a Linux process that contains an Lambda function.
type LambdaLinuxProcessParams struct {
	_ struct{} `type:"structure"`

	// The parameters for the container in which the Lambda function runs.
	ContainerParams *LambdaContainerParams `locationName:"containerParams" type:"structure"`

	// The isolation mode for the process that contains the Lambda function. The
	// process can run in an isolated runtime environment inside the IoT Greengrass
	// container, or as a regular process outside any container.
	//
	// Default: GreengrassContainer
	IsolationMode *string `locationName:"isolationMode" type:"string" enum:"LambdaIsolationMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaLinuxProcessParams) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaLinuxProcessParams) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaLinuxProcessParams) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaLinuxProcessParams"}
	if s.ContainerParams != nil {
		if err := s.ContainerParams.Validate(); err != nil {
			invalidParams.AddNested("ContainerParams", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerParams sets the ContainerParams field's value.
func (s *LambdaLinuxProcessParams) SetContainerParams(v *LambdaContainerParams) *LambdaLinuxProcessParams {
	s.ContainerParams = v
	return s
}

// SetIsolationMode sets the IsolationMode field's value.
func (s *LambdaLinuxProcessParams) SetIsolationMode(v string) *LambdaLinuxProcessParams {
	s.IsolationMode = &v
	return s
}

// Contains information about a volume that Linux processes in a container can
// access. When you define a volume, the IoT Greengrass Core software mounts
// the source files to the destination inside the container.
type LambdaVolumeMount struct {
	_ struct{} `type:"structure"`

	// Whether or not to add the IoT Greengrass user group as an owner of the volume.
	//
	// Default: false
	AddGroupOwner *bool `locationName:"addGroupOwner" type:"boolean"`

	// The path to the logical volume in the file system.
	//
	// DestinationPath is a required field
	DestinationPath *string `locationName:"destinationPath" type:"string" required:"true"`

	// The permission to access the volume: read/only (ro) or read/write (rw).
	//
	// Default: ro
	Permission *string `locationName:"permission" type:"string" enum:"LambdaFilesystemPermission"`

	// The path to the physical volume in the file system.
	//
	// SourcePath is a required field
	SourcePath *string `locationName:"sourcePath" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaVolumeMount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaVolumeMount) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaVolumeMount) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaVolumeMount"}
	if s.DestinationPath == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationPath"))
	}
	if s.SourcePath == nil {
		invalidParams.Add(request.NewErrParamRequired("SourcePath"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddGroupOwner sets the AddGroupOwner field's value.
func (s *LambdaVolumeMount) SetAddGroupOwner(v bool) *LambdaVolumeMount {
	s.AddGroupOwner = &v
	return s
}

// SetDestinationPath sets the DestinationPath field's value.
func (s *LambdaVolumeMount) SetDestinationPath(v string) *LambdaVolumeMount {
	s.DestinationPath = &v
	return s
}

// SetPermission sets the Permission field's value.
func (s *LambdaVolumeMount) SetPermission(v string) *LambdaVolumeMount {
	s.Permission = &v
	return s
}

// SetSourcePath sets the SourcePath field's value.
func (s *LambdaVolumeMount) SetSourcePath(v string) *LambdaVolumeMount {
	s.SourcePath = &v
	return s
}

type ListClientDevicesAssociatedWithCoreDeviceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the core device. This is also the name of the IoT thing.
	//
	// CoreDeviceThingName is a required field
	CoreDeviceThingName *string `location:"uri" locationName:"coreDeviceThingName" min:"1" type:"string" required:"true"`

	// The maximum number of results to be returned per paginated request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClientDevicesAssociatedWithCoreDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClientDevicesAssociatedWithCoreDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListClientDevicesAssociatedWithCoreDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListClientDevicesAssociatedWithCoreDeviceInput"}
	if s.CoreDeviceThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("CoreDeviceThingName"))
	}
	if s.CoreDeviceThingName != nil && len(*s.CoreDeviceThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CoreDeviceThingName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCoreDeviceThingName sets the CoreDeviceThingName field's value.
func (s *ListClientDevicesAssociatedWithCoreDeviceInput) SetCoreDeviceThingName(v string) *ListClientDevicesAssociatedWithCoreDeviceInput {
	s.CoreDeviceThingName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListClientDevicesAssociatedWithCoreDeviceInput) SetMaxResults(v int64) *ListClientDevicesAssociatedWithCoreDeviceInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClientDevicesAssociatedWithCoreDeviceInput) SetNextToken(v string) *ListClientDevicesAssociatedWithCoreDeviceInput {
	s.NextToken = &v
	return s
}

type ListClientDevicesAssociatedWithCoreDeviceOutput struct {
	_ struct{} `type:"structure"`

	// A list that describes the client devices that are associated with the core
	// device.
	AssociatedClientDevices []*AssociatedClientDevice `locationName:"associatedClientDevices" min:"1" type:"list"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClientDevicesAssociatedWithCoreDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClientDevicesAssociatedWithCoreDeviceOutput) GoString() string {
	return s.String()
}

// SetAssociatedClientDevices sets the AssociatedClientDevices field's value.
func (s *ListClientDevicesAssociatedWithCoreDeviceOutput) SetAssociatedClientDevices(v []*AssociatedClientDevice) *ListClientDevicesAssociatedWithCoreDeviceOutput {
	s.AssociatedClientDevices = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClientDevicesAssociatedWithCoreDeviceOutput) SetNextToken(v string) *ListClientDevicesAssociatedWithCoreDeviceOutput {
	s.NextToken = &v
	return s
}

type ListComponentVersionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the component version.
	//
	// Arn is a required field
	Arn *string `location:"uri" locationName:"arn" type:"string" required:"true"`

	// The maximum number of results to be returned per paginated request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListComponentVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListComponentVersionsInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListComponentVersionsInput) SetArn(v string) *ListComponentVersionsInput {
	s.Arn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListComponentVersionsInput) SetMaxResults(v int64) *ListComponentVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListComponentVersionsInput) SetNextToken(v string) *ListComponentVersionsInput {
	s.NextToken = &v
	return s
}

type ListComponentVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of versions that exist for the component.
	ComponentVersions []*ComponentVersionListItem `locationName:"componentVersions" type:"list"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentVersionsOutput) GoString() string {
	return s.String()
}

// SetComponentVersions sets the ComponentVersions field's value.
func (s *ListComponentVersionsOutput) SetComponentVersions(v []*ComponentVersionListItem) *ListComponentVersionsOutput {
	s.ComponentVersions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListComponentVersionsOutput) SetNextToken(v string) *ListComponentVersionsOutput {
	s.NextToken = &v
	return s
}

type ListComponentsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to be returned per paginated request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The scope of the components to list.
	//
	// Default: PRIVATE
	Scope *string `location:"querystring" locationName:"scope" type:"string" enum:"ComponentVisibilityScope"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListComponentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListComponentsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListComponentsInput) SetMaxResults(v int64) *ListComponentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListComponentsInput) SetNextToken(v string) *ListComponentsInput {
	s.NextToken = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *ListComponentsInput) SetScope(v string) *ListComponentsInput {
	s.Scope = &v
	return s
}

type ListComponentsOutput struct {
	_ struct{} `type:"structure"`

	// A list that summarizes each component.
	Components []*Component `locationName:"components" type:"list"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentsOutput) GoString() string {
	return s.String()
}

// SetComponents sets the Components field's value.
func (s *ListComponentsOutput) SetComponents(v []*Component) *ListComponentsOutput {
	s.Components = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListComponentsOutput) SetNextToken(v string) *ListComponentsOutput {
	s.NextToken = &v
	return s
}

type ListCoreDevicesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to be returned per paginated request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The core device status by which to filter. If you specify this parameter,
	// the list includes only core devices that have this status. Choose one of
	// the following options:
	//
	//    * HEALTHY – The IoT Greengrass Core software and all components run
	//    on the core device without issue.
	//
	//    * UNHEALTHY – The IoT Greengrass Core software or a component is in
	//    a failed state on the core device.
	Status *string `location:"querystring" locationName:"status" type:"string" enum:"CoreDeviceStatus"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the IoT thing group by which to filter. If you specify this parameter,
	// the list includes only core devices that are members of this thing group.
	ThingGroupArn *string `location:"querystring" locationName:"thingGroupArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCoreDevicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCoreDevicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCoreDevicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCoreDevicesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCoreDevicesInput) SetMaxResults(v int64) *ListCoreDevicesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCoreDevicesInput) SetNextToken(v string) *ListCoreDevicesInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListCoreDevicesInput) SetStatus(v string) *ListCoreDevicesInput {
	s.Status = &v
	return s
}

// SetThingGroupArn sets the ThingGroupArn field's value.
func (s *ListCoreDevicesInput) SetThingGroupArn(v string) *ListCoreDevicesInput {
	s.ThingGroupArn = &v
	return s
}

type ListCoreDevicesOutput struct {
	_ struct{} `type:"structure"`

	// A list that summarizes each core device.
	CoreDevices []*CoreDevice `locationName:"coreDevices" type:"list"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCoreDevicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCoreDevicesOutput) GoString() string {
	return s.String()
}

// SetCoreDevices sets the CoreDevices field's value.
func (s *ListCoreDevicesOutput) SetCoreDevices(v []*CoreDevice) *ListCoreDevicesOutput {
	s.CoreDevices = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCoreDevicesOutput) SetNextToken(v string) *ListCoreDevicesOutput {
	s.NextToken = &v
	return s
}

type ListDeploymentsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The filter for the list of deployments. Choose one of the following options:
	//
	//    * ALL – The list includes all deployments.
	//
	//    * LATEST_ONLY – The list includes only the latest revision of each deployment.
	//
	// Default: LATEST_ONLY
	HistoryFilter *string `location:"querystring" locationName:"historyFilter" type:"string" enum:"DeploymentHistoryFilter"`

	// The maximum number of results to be returned per paginated request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the target IoT thing or thing group.
	TargetArn *string `location:"querystring" locationName:"targetArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeploymentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeploymentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDeploymentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDeploymentsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHistoryFilter sets the HistoryFilter field's value.
func (s *ListDeploymentsInput) SetHistoryFilter(v string) *ListDeploymentsInput {
	s.HistoryFilter = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDeploymentsInput) SetMaxResults(v int64) *ListDeploymentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeploymentsInput) SetNextToken(v string) *ListDeploymentsInput {
	s.NextToken = &v
	return s
}

// SetTargetArn sets the TargetArn field's value.
func (s *ListDeploymentsInput) SetTargetArn(v string) *ListDeploymentsInput {
	s.TargetArn = &v
	return s
}

type ListDeploymentsOutput struct {
	_ struct{} `type:"structure"`

	// A list that summarizes each deployment.
	Deployments []*Deployment `locationName:"deployments" type:"list"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeploymentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeploymentsOutput) GoString() string {
	return s.String()
}

// SetDeployments sets the Deployments field's value.
func (s *ListDeploymentsOutput) SetDeployments(v []*Deployment) *ListDeploymentsOutput {
	s.Deployments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeploymentsOutput) SetNextToken(v string) *ListDeploymentsOutput {
	s.NextToken = &v
	return s
}

type ListEffectiveDeploymentsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the core device. This is also the name of the IoT thing.
	//
	// CoreDeviceThingName is a required field
	CoreDeviceThingName *string `location:"uri" locationName:"coreDeviceThingName" min:"1" type:"string" required:"true"`

	// The maximum number of results to be returned per paginated request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEffectiveDeploymentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEffectiveDeploymentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEffectiveDeploymentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEffectiveDeploymentsInput"}
	if s.CoreDeviceThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("CoreDeviceThingName"))
	}
	if s.CoreDeviceThingName != nil && len(*s.CoreDeviceThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CoreDeviceThingName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCoreDeviceThingName sets the CoreDeviceThingName field's value.
func (s *ListEffectiveDeploymentsInput) SetCoreDeviceThingName(v string) *ListEffectiveDeploymentsInput {
	s.CoreDeviceThingName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEffectiveDeploymentsInput) SetMaxResults(v int64) *ListEffectiveDeploymentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEffectiveDeploymentsInput) SetNextToken(v string) *ListEffectiveDeploymentsInput {
	s.NextToken = &v
	return s
}

type ListEffectiveDeploymentsOutput struct {
	_ struct{} `type:"structure"`

	// A list that summarizes each deployment on the core device.
	EffectiveDeployments []*EffectiveDeployment `locationName:"effectiveDeployments" type:"list"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEffectiveDeploymentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEffectiveDeploymentsOutput) GoString() string {
	return s.String()
}

// SetEffectiveDeployments sets the EffectiveDeployments field's value.
func (s *ListEffectiveDeploymentsOutput) SetEffectiveDeployments(v []*EffectiveDeployment) *ListEffectiveDeploymentsOutput {
	s.EffectiveDeployments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEffectiveDeploymentsOutput) SetNextToken(v string) *ListEffectiveDeploymentsOutput {
	s.NextToken = &v
	return s
}

type ListInstalledComponentsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the core device. This is also the name of the IoT thing.
	//
	// CoreDeviceThingName is a required field
	CoreDeviceThingName *string `location:"uri" locationName:"coreDeviceThingName" min:"1" type:"string" required:"true"`

	// The maximum number of results to be returned per paginated request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInstalledComponentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInstalledComponentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInstalledComponentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInstalledComponentsInput"}
	if s.CoreDeviceThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("CoreDeviceThingName"))
	}
	if s.CoreDeviceThingName != nil && len(*s.CoreDeviceThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CoreDeviceThingName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCoreDeviceThingName sets the CoreDeviceThingName field's value.
func (s *ListInstalledComponentsInput) SetCoreDeviceThingName(v string) *ListInstalledComponentsInput {
	s.CoreDeviceThingName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListInstalledComponentsInput) SetMaxResults(v int64) *ListInstalledComponentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInstalledComponentsInput) SetNextToken(v string) *ListInstalledComponentsInput {
	s.NextToken = &v
	return s
}

type ListInstalledComponentsOutput struct {
	_ struct{} `type:"structure"`

	// A list that summarizes each component on the core device.
	InstalledComponents []*InstalledComponent `locationName:"installedComponents" type:"list"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInstalledComponentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInstalledComponentsOutput) GoString() string {
	return s.String()
}

// SetInstalledComponents sets the InstalledComponents field's value.
func (s *ListInstalledComponentsOutput) SetInstalledComponents(v []*InstalledComponent) *ListInstalledComponentsOutput {
	s.InstalledComponents = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInstalledComponentsOutput) SetNextToken(v string) *ListInstalledComponentsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A list of key-value pairs that contain metadata for the resource. For more
	// information, see Tag your resources (https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html)
	// in the IoT Greengrass V2 Developer Guide.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// The request is already in progress. This exception occurs when you use a
// client token for multiple requests while IoT Greengrass is still processing
// an earlier request that uses the same client token.
type RequestAlreadyInProgressException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequestAlreadyInProgressException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequestAlreadyInProgressException) GoString() string {
	return s.String()
}

func newErrorRequestAlreadyInProgressException(v protocol.ResponseMetadata) error {
	return &RequestAlreadyInProgressException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *RequestAlreadyInProgressException) Code() string {
	return "RequestAlreadyInProgressException"
}

// Message returns the exception's message.
func (s *RequestAlreadyInProgressException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *RequestAlreadyInProgressException) OrigErr() error {
	return nil
}

func (s *RequestAlreadyInProgressException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *RequestAlreadyInProgressException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *RequestAlreadyInProgressException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ResolveComponentCandidatesInput struct {
	_ struct{} `type:"structure"`

	// The list of components to resolve.
	//
	// ComponentCandidates is a required field
	ComponentCandidates []*ComponentCandidate `locationName:"componentCandidates" type:"list" required:"true"`

	// The platform to use to resolve compatible components.
	//
	// Platform is a required field
	Platform *ComponentPlatform `locationName:"platform" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolveComponentCandidatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolveComponentCandidatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResolveComponentCandidatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResolveComponentCandidatesInput"}
	if s.ComponentCandidates == nil {
		invalidParams.Add(request.NewErrParamRequired("ComponentCandidates"))
	}
	if s.Platform == nil {
		invalidParams.Add(request.NewErrParamRequired("Platform"))
	}
	if s.ComponentCandidates != nil {
		for i, v := range s.ComponentCandidates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ComponentCandidates", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Platform != nil {
		if err := s.Platform.Validate(); err != nil {
			invalidParams.AddNested("Platform", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentCandidates sets the ComponentCandidates field's value.
func (s *ResolveComponentCandidatesInput) SetComponentCandidates(v []*ComponentCandidate) *ResolveComponentCandidatesInput {
	s.ComponentCandidates = v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *ResolveComponentCandidatesInput) SetPlatform(v *ComponentPlatform) *ResolveComponentCandidatesInput {
	s.Platform = v
	return s
}

type ResolveComponentCandidatesOutput struct {
	_ struct{} `type:"structure"`

	// A list of components that meet the requirements that you specify in the request.
	// This list includes each component's recipe that you can use to install the
	// component.
	ResolvedComponentVersions []*ResolvedComponentVersion `locationName:"resolvedComponentVersions" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolveComponentCandidatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolveComponentCandidatesOutput) GoString() string {
	return s.String()
}

// SetResolvedComponentVersions sets the ResolvedComponentVersions field's value.
func (s *ResolveComponentCandidatesOutput) SetResolvedComponentVersions(v []*ResolvedComponentVersion) *ResolveComponentCandidatesOutput {
	s.ResolvedComponentVersions = v
	return s
}

// Contains information about a component version that is compatible to run
// on a Greengrass core device.
type ResolvedComponentVersion struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the component version.
	Arn *string `locationName:"arn" type:"string"`

	// The name of the component.
	ComponentName *string `locationName:"componentName" min:"1" type:"string"`

	// The version of the component.
	ComponentVersion *string `locationName:"componentVersion" min:"1" type:"string"`

	// The recipe of the component version.
	// Recipe is automatically base64 encoded/decoded by the SDK.
	Recipe []byte `locationName:"recipe" type:"blob"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolvedComponentVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolvedComponentVersion) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ResolvedComponentVersion) SetArn(v string) *ResolvedComponentVersion {
	s.Arn = &v
	return s
}

// SetComponentName sets the ComponentName field's value.
func (s *ResolvedComponentVersion) SetComponentName(v string) *ResolvedComponentVersion {
	s.ComponentName = &v
	return s
}

// SetComponentVersion sets the ComponentVersion field's value.
func (s *ResolvedComponentVersion) SetComponentVersion(v string) *ResolvedComponentVersion {
	s.ComponentVersion = &v
	return s
}

// SetRecipe sets the Recipe field's value.
func (s *ResolvedComponentVersion) SetRecipe(v []byte) *ResolvedComponentVersion {
	s.Recipe = v
	return s
}

// The requested resource can't be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the resource that isn't found.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The type of the resource that isn't found.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Your request exceeds a service quota. For example, you might have the maximum
// number of components that you can create.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The code for the quota in Service Quotas (https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html).
	//
	// QuotaCode is a required field
	QuotaCode *string `locationName:"quotaCode" type:"string" required:"true"`

	// The ID of the resource that exceeds the service quota.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The type of the resource that exceeds the service quota.
	ResourceType *string `locationName:"resourceType" type:"string"`

	// The code for the service in Service Quotas (https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html).
	//
	// ServiceCode is a required field
	ServiceCode *string `locationName:"serviceCode" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about system resource limits that the IoT Greengrass
// Core software applies to a component's processes. For more information, see
// Configure system resource limits for components (https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-system-resource-limits).
type SystemResourceLimits struct {
	_ struct{} `type:"structure"`

	// The maximum amount of CPU time that a component's processes can use on the
	// core device. A core device's total CPU time is equivalent to the device's
	// number of CPU cores. For example, on a core device with 4 CPU cores, you
	// can set this value to 2 to limit the component's processes to 50 percent
	// usage of each CPU core. On a device with 1 CPU core, you can set this value
	// to 0.25 to limit the component's processes to 25 percent usage of the CPU.
	// If you set this value to a number greater than the number of CPU cores, the
	// IoT Greengrass Core software doesn't limit the component's CPU usage.
	Cpus *float64 `locationName:"cpus" type:"double"`

	// The maximum amount of RAM, expressed in kilobytes, that a component's processes
	// can use on the core device.
	Memory *int64 `locationName:"memory" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SystemResourceLimits) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SystemResourceLimits) GoString() string {
	return s.String()
}

// SetCpus sets the Cpus field's value.
func (s *SystemResourceLimits) SetCpus(v float64) *SystemResourceLimits {
	s.Cpus = &v
	return s
}

// SetMemory sets the Memory field's value.
func (s *SystemResourceLimits) SetMemory(v int64) *SystemResourceLimits {
	s.Memory = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the resource to tag.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// A list of key-value pairs that contain metadata for the resource. For more
	// information, see Tag your resources (https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html)
	// in the IoT Greengrass V2 Developer Guide.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Your request exceeded a request rate quota. For example, you might have exceeded
// the amount of times that you can retrieve device or deployment status per
// second.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The code for the quota in Service Quotas (https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html).
	QuotaCode *string `locationName:"quotaCode" type:"string"`

	// The amount of time to wait before you retry the request.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`

	// The code for the service in Service Quotas (https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html).
	ServiceCode *string `locationName:"serviceCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the resource to untag.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// A list of keys for tags to remove from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateConnectivityInfoInput struct {
	_ struct{} `type:"structure"`

	// The connectivity information for the core device.
	//
	// ConnectivityInfo is a required field
	ConnectivityInfo []*ConnectivityInfo `locationName:"ConnectivityInfo" type:"list" required:"true"`

	// The name of the core device. This is also the name of the IoT thing.
	//
	// ThingName is a required field
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectivityInfoInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectivityInfoInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConnectivityInfoInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConnectivityInfoInput"}
	if s.ConnectivityInfo == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectivityInfo"))
	}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectivityInfo sets the ConnectivityInfo field's value.
func (s *UpdateConnectivityInfoInput) SetConnectivityInfo(v []*ConnectivityInfo) *UpdateConnectivityInfoInput {
	s.ConnectivityInfo = v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *UpdateConnectivityInfoInput) SetThingName(v string) *UpdateConnectivityInfoInput {
	s.ThingName = &v
	return s
}

type UpdateConnectivityInfoOutput struct {
	_ struct{} `type:"structure"`

	// A message about the connectivity information update request.
	Message *string `locationName:"Message" type:"string"`

	// The new version of the connectivity information for the core device.
	Version *string `locationName:"Version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectivityInfoOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectivityInfoOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *UpdateConnectivityInfoOutput) SetMessage(v string) *UpdateConnectivityInfoOutput {
	s.Message = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *UpdateConnectivityInfoOutput) SetVersion(v string) *UpdateConnectivityInfoOutput {
	s.Version = &v
	return s
}

// The request isn't valid. This can occur if your request contains malformed
// JSON or unsupported characters.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The list of fields that failed to validate.
	Fields []*ValidationExceptionField `locationName:"fields" type:"list"`

	Message_ *string `locationName:"message" type:"string"`

	// The reason for the validation exception.
	Reason *string `locationName:"reason" type:"string" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about a validation exception field.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// The message of the exception field.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// The name of the exception field.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

const (
	// CloudComponentStateRequested is a CloudComponentState enum value
	CloudComponentStateRequested = "REQUESTED"

	// CloudComponentStateInitiated is a CloudComponentState enum value
	CloudComponentStateInitiated = "INITIATED"

	// CloudComponentStateDeployable is a CloudComponentState enum value
	CloudComponentStateDeployable = "DEPLOYABLE"

	// CloudComponentStateFailed is a CloudComponentState enum value
	CloudComponentStateFailed = "FAILED"

	// CloudComponentStateDeprecated is a CloudComponentState enum value
	CloudComponentStateDeprecated = "DEPRECATED"
)

// CloudComponentState_Values returns all elements of the CloudComponentState enum
func CloudComponentState_Values() []string {
	return []string{
		CloudComponentStateRequested,
		CloudComponentStateInitiated,
		CloudComponentStateDeployable,
		CloudComponentStateFailed,
		CloudComponentStateDeprecated,
	}
}

const (
	// ComponentDependencyTypeHard is a ComponentDependencyType enum value
	ComponentDependencyTypeHard = "HARD"

	// ComponentDependencyTypeSoft is a ComponentDependencyType enum value
	ComponentDependencyTypeSoft = "SOFT"
)

// ComponentDependencyType_Values returns all elements of the ComponentDependencyType enum
func ComponentDependencyType_Values() []string {
	return []string{
		ComponentDependencyTypeHard,
		ComponentDependencyTypeSoft,
	}
}

const (
	// ComponentVisibilityScopePrivate is a ComponentVisibilityScope enum value
	ComponentVisibilityScopePrivate = "PRIVATE"

	// ComponentVisibilityScopePublic is a ComponentVisibilityScope enum value
	ComponentVisibilityScopePublic = "PUBLIC"
)

// ComponentVisibilityScope_Values returns all elements of the ComponentVisibilityScope enum
func ComponentVisibilityScope_Values() []string {
	return []string{
		ComponentVisibilityScopePrivate,
		ComponentVisibilityScopePublic,
	}
}

const (
	// CoreDeviceStatusHealthy is a CoreDeviceStatus enum value
	CoreDeviceStatusHealthy = "HEALTHY"

	// CoreDeviceStatusUnhealthy is a CoreDeviceStatus enum value
	CoreDeviceStatusUnhealthy = "UNHEALTHY"
)

// CoreDeviceStatus_Values returns all elements of the CoreDeviceStatus enum
func CoreDeviceStatus_Values() []string {
	return []string{
		CoreDeviceStatusHealthy,
		CoreDeviceStatusUnhealthy,
	}
}

const (
	// DeploymentComponentUpdatePolicyActionNotifyComponents is a DeploymentComponentUpdatePolicyAction enum value
	DeploymentComponentUpdatePolicyActionNotifyComponents = "NOTIFY_COMPONENTS"

	// DeploymentComponentUpdatePolicyActionSkipNotifyComponents is a DeploymentComponentUpdatePolicyAction enum value
	DeploymentComponentUpdatePolicyActionSkipNotifyComponents = "SKIP_NOTIFY_COMPONENTS"
)

// DeploymentComponentUpdatePolicyAction_Values returns all elements of the DeploymentComponentUpdatePolicyAction enum
func DeploymentComponentUpdatePolicyAction_Values() []string {
	return []string{
		DeploymentComponentUpdatePolicyActionNotifyComponents,
		DeploymentComponentUpdatePolicyActionSkipNotifyComponents,
	}
}

const (
	// DeploymentFailureHandlingPolicyRollback is a DeploymentFailureHandlingPolicy enum value
	DeploymentFailureHandlingPolicyRollback = "ROLLBACK"

	// DeploymentFailureHandlingPolicyDoNothing is a DeploymentFailureHandlingPolicy enum value
	DeploymentFailureHandlingPolicyDoNothing = "DO_NOTHING"
)

// DeploymentFailureHandlingPolicy_Values returns all elements of the DeploymentFailureHandlingPolicy enum
func DeploymentFailureHandlingPolicy_Values() []string {
	return []string{
		DeploymentFailureHandlingPolicyRollback,
		DeploymentFailureHandlingPolicyDoNothing,
	}
}

const (
	// DeploymentHistoryFilterAll is a DeploymentHistoryFilter enum value
	DeploymentHistoryFilterAll = "ALL"

	// DeploymentHistoryFilterLatestOnly is a DeploymentHistoryFilter enum value
	DeploymentHistoryFilterLatestOnly = "LATEST_ONLY"
)

// DeploymentHistoryFilter_Values returns all elements of the DeploymentHistoryFilter enum
func DeploymentHistoryFilter_Values() []string {
	return []string{
		DeploymentHistoryFilterAll,
		DeploymentHistoryFilterLatestOnly,
	}
}

const (
	// DeploymentStatusActive is a DeploymentStatus enum value
	DeploymentStatusActive = "ACTIVE"

	// DeploymentStatusCompleted is a DeploymentStatus enum value
	DeploymentStatusCompleted = "COMPLETED"

	// DeploymentStatusCanceled is a DeploymentStatus enum value
	DeploymentStatusCanceled = "CANCELED"

	// DeploymentStatusFailed is a DeploymentStatus enum value
	DeploymentStatusFailed = "FAILED"

	// DeploymentStatusInactive is a DeploymentStatus enum value
	DeploymentStatusInactive = "INACTIVE"
)

// DeploymentStatus_Values returns all elements of the DeploymentStatus enum
func DeploymentStatus_Values() []string {
	return []string{
		DeploymentStatusActive,
		DeploymentStatusCompleted,
		DeploymentStatusCanceled,
		DeploymentStatusFailed,
		DeploymentStatusInactive,
	}
}

const (
	// EffectiveDeploymentExecutionStatusInProgress is a EffectiveDeploymentExecutionStatus enum value
	EffectiveDeploymentExecutionStatusInProgress = "IN_PROGRESS"

	// EffectiveDeploymentExecutionStatusQueued is a EffectiveDeploymentExecutionStatus enum value
	EffectiveDeploymentExecutionStatusQueued = "QUEUED"

	// EffectiveDeploymentExecutionStatusFailed is a EffectiveDeploymentExecutionStatus enum value
	EffectiveDeploymentExecutionStatusFailed = "FAILED"

	// EffectiveDeploymentExecutionStatusCompleted is a EffectiveDeploymentExecutionStatus enum value
	EffectiveDeploymentExecutionStatusCompleted = "COMPLETED"

	// EffectiveDeploymentExecutionStatusTimedOut is a EffectiveDeploymentExecutionStatus enum value
	EffectiveDeploymentExecutionStatusTimedOut = "TIMED_OUT"

	// EffectiveDeploymentExecutionStatusCanceled is a EffectiveDeploymentExecutionStatus enum value
	EffectiveDeploymentExecutionStatusCanceled = "CANCELED"

	// EffectiveDeploymentExecutionStatusRejected is a EffectiveDeploymentExecutionStatus enum value
	EffectiveDeploymentExecutionStatusRejected = "REJECTED"
)

// EffectiveDeploymentExecutionStatus_Values returns all elements of the EffectiveDeploymentExecutionStatus enum
func EffectiveDeploymentExecutionStatus_Values() []string {
	return []string{
		EffectiveDeploymentExecutionStatusInProgress,
		EffectiveDeploymentExecutionStatusQueued,
		EffectiveDeploymentExecutionStatusFailed,
		EffectiveDeploymentExecutionStatusCompleted,
		EffectiveDeploymentExecutionStatusTimedOut,
		EffectiveDeploymentExecutionStatusCanceled,
		EffectiveDeploymentExecutionStatusRejected,
	}
}

const (
	// InstalledComponentLifecycleStateNew is a InstalledComponentLifecycleState enum value
	InstalledComponentLifecycleStateNew = "NEW"

	// InstalledComponentLifecycleStateInstalled is a InstalledComponentLifecycleState enum value
	InstalledComponentLifecycleStateInstalled = "INSTALLED"

	// InstalledComponentLifecycleStateStarting is a InstalledComponentLifecycleState enum value
	InstalledComponentLifecycleStateStarting = "STARTING"

	// InstalledComponentLifecycleStateRunning is a InstalledComponentLifecycleState enum value
	InstalledComponentLifecycleStateRunning = "RUNNING"

	// InstalledComponentLifecycleStateStopping is a InstalledComponentLifecycleState enum value
	InstalledComponentLifecycleStateStopping = "STOPPING"

	// InstalledComponentLifecycleStateErrored is a InstalledComponentLifecycleState enum value
	InstalledComponentLifecycleStateErrored = "ERRORED"

	// InstalledComponentLifecycleStateBroken is a InstalledComponentLifecycleState enum value
	InstalledComponentLifecycleStateBroken = "BROKEN"

	// InstalledComponentLifecycleStateFinished is a InstalledComponentLifecycleState enum value
	InstalledComponentLifecycleStateFinished = "FINISHED"
)

// InstalledComponentLifecycleState_Values returns all elements of the InstalledComponentLifecycleState enum
func InstalledComponentLifecycleState_Values() []string {
	return []string{
		InstalledComponentLifecycleStateNew,
		InstalledComponentLifecycleStateInstalled,
		InstalledComponentLifecycleStateStarting,
		InstalledComponentLifecycleStateRunning,
		InstalledComponentLifecycleStateStopping,
		InstalledComponentLifecycleStateErrored,
		InstalledComponentLifecycleStateBroken,
		InstalledComponentLifecycleStateFinished,
	}
}

const (
	// IoTJobAbortActionCancel is a IoTJobAbortAction enum value
	IoTJobAbortActionCancel = "CANCEL"
)

// IoTJobAbortAction_Values returns all elements of the IoTJobAbortAction enum
func IoTJobAbortAction_Values() []string {
	return []string{
		IoTJobAbortActionCancel,
	}
}

const (
	// IoTJobExecutionFailureTypeFailed is a IoTJobExecutionFailureType enum value
	IoTJobExecutionFailureTypeFailed = "FAILED"

	// IoTJobExecutionFailureTypeRejected is a IoTJobExecutionFailureType enum value
	IoTJobExecutionFailureTypeRejected = "REJECTED"

	// IoTJobExecutionFailureTypeTimedOut is a IoTJobExecutionFailureType enum value
	IoTJobExecutionFailureTypeTimedOut = "TIMED_OUT"

	// IoTJobExecutionFailureTypeAll is a IoTJobExecutionFailureType enum value
	IoTJobExecutionFailureTypeAll = "ALL"
)

// IoTJobExecutionFailureType_Values returns all elements of the IoTJobExecutionFailureType enum
func IoTJobExecutionFailureType_Values() []string {
	return []string{
		IoTJobExecutionFailureTypeFailed,
		IoTJobExecutionFailureTypeRejected,
		IoTJobExecutionFailureTypeTimedOut,
		IoTJobExecutionFailureTypeAll,
	}
}

const (
	// LambdaEventSourceTypePubSub is a LambdaEventSourceType enum value
	LambdaEventSourceTypePubSub = "PUB_SUB"

	// LambdaEventSourceTypeIotCore is a LambdaEventSourceType enum value
	LambdaEventSourceTypeIotCore = "IOT_CORE"
)

// LambdaEventSourceType_Values returns all elements of the LambdaEventSourceType enum
func LambdaEventSourceType_Values() []string {
	return []string{
		LambdaEventSourceTypePubSub,
		LambdaEventSourceTypeIotCore,
	}
}

const (
	// LambdaFilesystemPermissionRo is a LambdaFilesystemPermission enum value
	LambdaFilesystemPermissionRo = "ro"

	// LambdaFilesystemPermissionRw is a LambdaFilesystemPermission enum value
	LambdaFilesystemPermissionRw = "rw"
)

// LambdaFilesystemPermission_Values returns all elements of the LambdaFilesystemPermission enum
func LambdaFilesystemPermission_Values() []string {
	return []string{
		LambdaFilesystemPermissionRo,
		LambdaFilesystemPermissionRw,
	}
}

const (
	// LambdaInputPayloadEncodingTypeJson is a LambdaInputPayloadEncodingType enum value
	LambdaInputPayloadEncodingTypeJson = "json"

	// LambdaInputPayloadEncodingTypeBinary is a LambdaInputPayloadEncodingType enum value
	LambdaInputPayloadEncodingTypeBinary = "binary"
)

// LambdaInputPayloadEncodingType_Values returns all elements of the LambdaInputPayloadEncodingType enum
func LambdaInputPayloadEncodingType_Values() []string {
	return []string{
		LambdaInputPayloadEncodingTypeJson,
		LambdaInputPayloadEncodingTypeBinary,
	}
}

const (
	// LambdaIsolationModeGreengrassContainer is a LambdaIsolationMode enum value
	LambdaIsolationModeGreengrassContainer = "GreengrassContainer"

	// LambdaIsolationModeNoContainer is a LambdaIsolationMode enum value
	LambdaIsolationModeNoContainer = "NoContainer"
)

// LambdaIsolationMode_Values returns all elements of the LambdaIsolationMode enum
func LambdaIsolationMode_Values() []string {
	return []string{
		LambdaIsolationModeGreengrassContainer,
		LambdaIsolationModeNoContainer,
	}
}

const (
	// RecipeOutputFormatJson is a RecipeOutputFormat enum value
	RecipeOutputFormatJson = "JSON"

	// RecipeOutputFormatYaml is a RecipeOutputFormat enum value
	RecipeOutputFormatYaml = "YAML"
)

// RecipeOutputFormat_Values returns all elements of the RecipeOutputFormat enum
func RecipeOutputFormat_Values() []string {
	return []string{
		RecipeOutputFormatJson,
		RecipeOutputFormatYaml,
	}
}

const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "UNKNOWN_OPERATION"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "CANNOT_PARSE"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "FIELD_VALIDATION_FAILED"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "OTHER"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}
