// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lookoutmetrics

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opActivateAnomalyDetector = "ActivateAnomalyDetector"

// ActivateAnomalyDetectorRequest generates a "aws/request.Request" representing the
// client's request for the ActivateAnomalyDetector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ActivateAnomalyDetector for more information on using the ActivateAnomalyDetector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ActivateAnomalyDetectorRequest method.
//    req, resp := client.ActivateAnomalyDetectorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ActivateAnomalyDetector
func (c *LookoutMetrics) ActivateAnomalyDetectorRequest(input *ActivateAnomalyDetectorInput) (req *request.Request, output *ActivateAnomalyDetectorOutput) {
	op := &request.Operation{
		Name:       opActivateAnomalyDetector,
		HTTPMethod: "POST",
		HTTPPath:   "/ActivateAnomalyDetector",
	}

	if input == nil {
		input = &ActivateAnomalyDetectorInput{}
	}

	output = &ActivateAnomalyDetectorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ActivateAnomalyDetector API operation for Amazon Lookout for Metrics.
//
// Activates an anomaly detector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Metrics's
// API operation ActivateAnomalyDetector for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input fails to satisfy the constraints specified by the AWS service.
//   Check your input values and try again.
//
//   * ResourceNotFoundException
//   The specified resource cannot be found. Check the ARN of the resource and
//   try again.
//
//   * AccessDeniedException
//   You do not have sufficient permissions to perform this action.
//
//   * TooManyRequestsException
//   The request was denied due to too many requests being submitted at the same
//   time.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ConflictException
//   There was a conflict processing the request. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ActivateAnomalyDetector
func (c *LookoutMetrics) ActivateAnomalyDetector(input *ActivateAnomalyDetectorInput) (*ActivateAnomalyDetectorOutput, error) {
	req, out := c.ActivateAnomalyDetectorRequest(input)
	return out, req.Send()
}

// ActivateAnomalyDetectorWithContext is the same as ActivateAnomalyDetector with the addition of
// the ability to pass a context and additional request options.
//
// See ActivateAnomalyDetector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutMetrics) ActivateAnomalyDetectorWithContext(ctx aws.Context, input *ActivateAnomalyDetectorInput, opts ...request.Option) (*ActivateAnomalyDetectorOutput, error) {
	req, out := c.ActivateAnomalyDetectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBackTestAnomalyDetector = "BackTestAnomalyDetector"

// BackTestAnomalyDetectorRequest generates a "aws/request.Request" representing the
// client's request for the BackTestAnomalyDetector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BackTestAnomalyDetector for more information on using the BackTestAnomalyDetector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BackTestAnomalyDetectorRequest method.
//    req, resp := client.BackTestAnomalyDetectorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/BackTestAnomalyDetector
func (c *LookoutMetrics) BackTestAnomalyDetectorRequest(input *BackTestAnomalyDetectorInput) (req *request.Request, output *BackTestAnomalyDetectorOutput) {
	op := &request.Operation{
		Name:       opBackTestAnomalyDetector,
		HTTPMethod: "POST",
		HTTPPath:   "/BackTestAnomalyDetector",
	}

	if input == nil {
		input = &BackTestAnomalyDetectorInput{}
	}

	output = &BackTestAnomalyDetectorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// BackTestAnomalyDetector API operation for Amazon Lookout for Metrics.
//
// Runs a backtest for anomaly detection for the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Metrics's
// API operation BackTestAnomalyDetector for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input fails to satisfy the constraints specified by the AWS service.
//   Check your input values and try again.
//
//   * ResourceNotFoundException
//   The specified resource cannot be found. Check the ARN of the resource and
//   try again.
//
//   * AccessDeniedException
//   You do not have sufficient permissions to perform this action.
//
//   * TooManyRequestsException
//   The request was denied due to too many requests being submitted at the same
//   time.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/BackTestAnomalyDetector
func (c *LookoutMetrics) BackTestAnomalyDetector(input *BackTestAnomalyDetectorInput) (*BackTestAnomalyDetectorOutput, error) {
	req, out := c.BackTestAnomalyDetectorRequest(input)
	return out, req.Send()
}

// BackTestAnomalyDetectorWithContext is the same as BackTestAnomalyDetector with the addition of
// the ability to pass a context and additional request options.
//
// See BackTestAnomalyDetector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutMetrics) BackTestAnomalyDetectorWithContext(ctx aws.Context, input *BackTestAnomalyDetectorInput, opts ...request.Option) (*BackTestAnomalyDetectorOutput, error) {
	req, out := c.BackTestAnomalyDetectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAlert = "CreateAlert"

// CreateAlertRequest generates a "aws/request.Request" representing the
// client's request for the CreateAlert operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAlert for more information on using the CreateAlert
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAlertRequest method.
//    req, resp := client.CreateAlertRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/CreateAlert
func (c *LookoutMetrics) CreateAlertRequest(input *CreateAlertInput) (req *request.Request, output *CreateAlertOutput) {
	op := &request.Operation{
		Name:       opCreateAlert,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateAlert",
	}

	if input == nil {
		input = &CreateAlertInput{}
	}

	output = &CreateAlertOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAlert API operation for Amazon Lookout for Metrics.
//
// Creates an alert for an anomaly detector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Metrics's
// API operation CreateAlert for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   There was a conflict processing the request. Try your request again.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by the AWS service.
//   Check your input values and try again.
//
//   * ServiceQuotaExceededException
//   The request exceeded the service's quotas. Check the service quotas and try
//   again.
//
//   * AccessDeniedException
//   You do not have sufficient permissions to perform this action.
//
//   * TooManyRequestsException
//   The request was denied due to too many requests being submitted at the same
//   time.
//
//   * ResourceNotFoundException
//   The specified resource cannot be found. Check the ARN of the resource and
//   try again.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/CreateAlert
func (c *LookoutMetrics) CreateAlert(input *CreateAlertInput) (*CreateAlertOutput, error) {
	req, out := c.CreateAlertRequest(input)
	return out, req.Send()
}

// CreateAlertWithContext is the same as CreateAlert with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAlert for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutMetrics) CreateAlertWithContext(ctx aws.Context, input *CreateAlertInput, opts ...request.Option) (*CreateAlertOutput, error) {
	req, out := c.CreateAlertRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAnomalyDetector = "CreateAnomalyDetector"

// CreateAnomalyDetectorRequest generates a "aws/request.Request" representing the
// client's request for the CreateAnomalyDetector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAnomalyDetector for more information on using the CreateAnomalyDetector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAnomalyDetectorRequest method.
//    req, resp := client.CreateAnomalyDetectorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/CreateAnomalyDetector
func (c *LookoutMetrics) CreateAnomalyDetectorRequest(input *CreateAnomalyDetectorInput) (req *request.Request, output *CreateAnomalyDetectorOutput) {
	op := &request.Operation{
		Name:       opCreateAnomalyDetector,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateAnomalyDetector",
	}

	if input == nil {
		input = &CreateAnomalyDetectorInput{}
	}

	output = &CreateAnomalyDetectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAnomalyDetector API operation for Amazon Lookout for Metrics.
//
// Creates an anomaly detector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Metrics's
// API operation CreateAnomalyDetector for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   There was a conflict processing the request. Try your request again.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by the AWS service.
//   Check your input values and try again.
//
//   * ServiceQuotaExceededException
//   The request exceeded the service's quotas. Check the service quotas and try
//   again.
//
//   * ConflictException
//   There was a conflict processing the request. Try your request again.
//
//   * AccessDeniedException
//   You do not have sufficient permissions to perform this action.
//
//   * TooManyRequestsException
//   The request was denied due to too many requests being submitted at the same
//   time.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/CreateAnomalyDetector
func (c *LookoutMetrics) CreateAnomalyDetector(input *CreateAnomalyDetectorInput) (*CreateAnomalyDetectorOutput, error) {
	req, out := c.CreateAnomalyDetectorRequest(input)
	return out, req.Send()
}

// CreateAnomalyDetectorWithContext is the same as CreateAnomalyDetector with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAnomalyDetector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutMetrics) CreateAnomalyDetectorWithContext(ctx aws.Context, input *CreateAnomalyDetectorInput, opts ...request.Option) (*CreateAnomalyDetectorOutput, error) {
	req, out := c.CreateAnomalyDetectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMetricSet = "CreateMetricSet"

// CreateMetricSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateMetricSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMetricSet for more information on using the CreateMetricSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateMetricSetRequest method.
//    req, resp := client.CreateMetricSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/CreateMetricSet
func (c *LookoutMetrics) CreateMetricSetRequest(input *CreateMetricSetInput) (req *request.Request, output *CreateMetricSetOutput) {
	op := &request.Operation{
		Name:       opCreateMetricSet,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateMetricSet",
	}

	if input == nil {
		input = &CreateMetricSetInput{}
	}

	output = &CreateMetricSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMetricSet API operation for Amazon Lookout for Metrics.
//
// Creates a dataset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Metrics's
// API operation CreateMetricSet for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   There was a conflict processing the request. Try your request again.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by the AWS service.
//   Check your input values and try again.
//
//   * ResourceNotFoundException
//   The specified resource cannot be found. Check the ARN of the resource and
//   try again.
//
//   * ServiceQuotaExceededException
//   The request exceeded the service's quotas. Check the service quotas and try
//   again.
//
//   * AccessDeniedException
//   You do not have sufficient permissions to perform this action.
//
//   * TooManyRequestsException
//   The request was denied due to too many requests being submitted at the same
//   time.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/CreateMetricSet
func (c *LookoutMetrics) CreateMetricSet(input *CreateMetricSetInput) (*CreateMetricSetOutput, error) {
	req, out := c.CreateMetricSetRequest(input)
	return out, req.Send()
}

// CreateMetricSetWithContext is the same as CreateMetricSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMetricSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutMetrics) CreateMetricSetWithContext(ctx aws.Context, input *CreateMetricSetInput, opts ...request.Option) (*CreateMetricSetOutput, error) {
	req, out := c.CreateMetricSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAlert = "DeleteAlert"

// DeleteAlertRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAlert operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAlert for more information on using the DeleteAlert
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAlertRequest method.
//    req, resp := client.DeleteAlertRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DeleteAlert
func (c *LookoutMetrics) DeleteAlertRequest(input *DeleteAlertInput) (req *request.Request, output *DeleteAlertOutput) {
	op := &request.Operation{
		Name:       opDeleteAlert,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteAlert",
	}

	if input == nil {
		input = &DeleteAlertInput{}
	}

	output = &DeleteAlertOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAlert API operation for Amazon Lookout for Metrics.
//
// Deletes an alert.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Metrics's
// API operation DeleteAlert for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource cannot be found. Check the ARN of the resource and
//   try again.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by the AWS service.
//   Check your input values and try again.
//
//   * TooManyRequestsException
//   The request was denied due to too many requests being submitted at the same
//   time.
//
//   * AccessDeniedException
//   You do not have sufficient permissions to perform this action.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DeleteAlert
func (c *LookoutMetrics) DeleteAlert(input *DeleteAlertInput) (*DeleteAlertOutput, error) {
	req, out := c.DeleteAlertRequest(input)
	return out, req.Send()
}

// DeleteAlertWithContext is the same as DeleteAlert with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAlert for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutMetrics) DeleteAlertWithContext(ctx aws.Context, input *DeleteAlertInput, opts ...request.Option) (*DeleteAlertOutput, error) {
	req, out := c.DeleteAlertRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAnomalyDetector = "DeleteAnomalyDetector"

// DeleteAnomalyDetectorRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAnomalyDetector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAnomalyDetector for more information on using the DeleteAnomalyDetector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAnomalyDetectorRequest method.
//    req, resp := client.DeleteAnomalyDetectorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DeleteAnomalyDetector
func (c *LookoutMetrics) DeleteAnomalyDetectorRequest(input *DeleteAnomalyDetectorInput) (req *request.Request, output *DeleteAnomalyDetectorOutput) {
	op := &request.Operation{
		Name:       opDeleteAnomalyDetector,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteAnomalyDetector",
	}

	if input == nil {
		input = &DeleteAnomalyDetectorInput{}
	}

	output = &DeleteAnomalyDetectorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAnomalyDetector API operation for Amazon Lookout for Metrics.
//
// Deletes a detector. Deleting an anomaly detector will delete all of its corresponding
// resources including any configured datasets and alerts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Metrics's
// API operation DeleteAnomalyDetector for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource cannot be found. Check the ARN of the resource and
//   try again.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by the AWS service.
//   Check your input values and try again.
//
//   * ConflictException
//   There was a conflict processing the request. Try your request again.
//
//   * TooManyRequestsException
//   The request was denied due to too many requests being submitted at the same
//   time.
//
//   * AccessDeniedException
//   You do not have sufficient permissions to perform this action.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DeleteAnomalyDetector
func (c *LookoutMetrics) DeleteAnomalyDetector(input *DeleteAnomalyDetectorInput) (*DeleteAnomalyDetectorOutput, error) {
	req, out := c.DeleteAnomalyDetectorRequest(input)
	return out, req.Send()
}

// DeleteAnomalyDetectorWithContext is the same as DeleteAnomalyDetector with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAnomalyDetector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutMetrics) DeleteAnomalyDetectorWithContext(ctx aws.Context, input *DeleteAnomalyDetectorInput, opts ...request.Option) (*DeleteAnomalyDetectorOutput, error) {
	req, out := c.DeleteAnomalyDetectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAlert = "DescribeAlert"

// DescribeAlertRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAlert operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAlert for more information on using the DescribeAlert
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAlertRequest method.
//    req, resp := client.DescribeAlertRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DescribeAlert
func (c *LookoutMetrics) DescribeAlertRequest(input *DescribeAlertInput) (req *request.Request, output *DescribeAlertOutput) {
	op := &request.Operation{
		Name:       opDescribeAlert,
		HTTPMethod: "POST",
		HTTPPath:   "/DescribeAlert",
	}

	if input == nil {
		input = &DescribeAlertInput{}
	}

	output = &DescribeAlertOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAlert API operation for Amazon Lookout for Metrics.
//
// Describes an alert.
//
// Amazon Lookout for Metrics API actions are eventually consistent. If you
// do a read operation on a resource immediately after creating or modifying
// it, use retries to allow time for the write operation to complete.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Metrics's
// API operation DescribeAlert for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource cannot be found. Check the ARN of the resource and
//   try again.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by the AWS service.
//   Check your input values and try again.
//
//   * AccessDeniedException
//   You do not have sufficient permissions to perform this action.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * TooManyRequestsException
//   The request was denied due to too many requests being submitted at the same
//   time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DescribeAlert
func (c *LookoutMetrics) DescribeAlert(input *DescribeAlertInput) (*DescribeAlertOutput, error) {
	req, out := c.DescribeAlertRequest(input)
	return out, req.Send()
}

// DescribeAlertWithContext is the same as DescribeAlert with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAlert for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutMetrics) DescribeAlertWithContext(ctx aws.Context, input *DescribeAlertInput, opts ...request.Option) (*DescribeAlertOutput, error) {
	req, out := c.DescribeAlertRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAnomalyDetectionExecutions = "DescribeAnomalyDetectionExecutions"

// DescribeAnomalyDetectionExecutionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAnomalyDetectionExecutions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAnomalyDetectionExecutions for more information on using the DescribeAnomalyDetectionExecutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAnomalyDetectionExecutionsRequest method.
//    req, resp := client.DescribeAnomalyDetectionExecutionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DescribeAnomalyDetectionExecutions
func (c *LookoutMetrics) DescribeAnomalyDetectionExecutionsRequest(input *DescribeAnomalyDetectionExecutionsInput) (req *request.Request, output *DescribeAnomalyDetectionExecutionsOutput) {
	op := &request.Operation{
		Name:       opDescribeAnomalyDetectionExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/DescribeAnomalyDetectionExecutions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAnomalyDetectionExecutionsInput{}
	}

	output = &DescribeAnomalyDetectionExecutionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAnomalyDetectionExecutions API operation for Amazon Lookout for Metrics.
//
// Returns information about the status of the specified anomaly detection jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Metrics's
// API operation DescribeAnomalyDetectionExecutions for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource cannot be found. Check the ARN of the resource and
//   try again.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by the AWS service.
//   Check your input values and try again.
//
//   * AccessDeniedException
//   You do not have sufficient permissions to perform this action.
//
//   * TooManyRequestsException
//   The request was denied due to too many requests being submitted at the same
//   time.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DescribeAnomalyDetectionExecutions
func (c *LookoutMetrics) DescribeAnomalyDetectionExecutions(input *DescribeAnomalyDetectionExecutionsInput) (*DescribeAnomalyDetectionExecutionsOutput, error) {
	req, out := c.DescribeAnomalyDetectionExecutionsRequest(input)
	return out, req.Send()
}

// DescribeAnomalyDetectionExecutionsWithContext is the same as DescribeAnomalyDetectionExecutions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAnomalyDetectionExecutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutMetrics) DescribeAnomalyDetectionExecutionsWithContext(ctx aws.Context, input *DescribeAnomalyDetectionExecutionsInput, opts ...request.Option) (*DescribeAnomalyDetectionExecutionsOutput, error) {
	req, out := c.DescribeAnomalyDetectionExecutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeAnomalyDetectionExecutionsPages iterates over the pages of a DescribeAnomalyDetectionExecutions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeAnomalyDetectionExecutions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeAnomalyDetectionExecutions operation.
//    pageNum := 0
//    err := client.DescribeAnomalyDetectionExecutionsPages(params,
//        func(page *lookoutmetrics.DescribeAnomalyDetectionExecutionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *LookoutMetrics) DescribeAnomalyDetectionExecutionsPages(input *DescribeAnomalyDetectionExecutionsInput, fn func(*DescribeAnomalyDetectionExecutionsOutput, bool) bool) error {
	return c.DescribeAnomalyDetectionExecutionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeAnomalyDetectionExecutionsPagesWithContext same as DescribeAnomalyDetectionExecutionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutMetrics) DescribeAnomalyDetectionExecutionsPagesWithContext(ctx aws.Context, input *DescribeAnomalyDetectionExecutionsInput, fn func(*DescribeAnomalyDetectionExecutionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeAnomalyDetectionExecutionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeAnomalyDetectionExecutionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeAnomalyDetectionExecutionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeAnomalyDetector = "DescribeAnomalyDetector"

// DescribeAnomalyDetectorRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAnomalyDetector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAnomalyDetector for more information on using the DescribeAnomalyDetector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAnomalyDetectorRequest method.
//    req, resp := client.DescribeAnomalyDetectorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DescribeAnomalyDetector
func (c *LookoutMetrics) DescribeAnomalyDetectorRequest(input *DescribeAnomalyDetectorInput) (req *request.Request, output *DescribeAnomalyDetectorOutput) {
	op := &request.Operation{
		Name:       opDescribeAnomalyDetector,
		HTTPMethod: "POST",
		HTTPPath:   "/DescribeAnomalyDetector",
	}

	if input == nil {
		input = &DescribeAnomalyDetectorInput{}
	}

	output = &DescribeAnomalyDetectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAnomalyDetector API operation for Amazon Lookout for Metrics.
//
// Describes a detector.
//
// Amazon Lookout for Metrics API actions are eventually consistent. If you
// do a read operation on a resource immediately after creating or modifying
// it, use retries to allow time for the write operation to complete.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Metrics's
// API operation DescribeAnomalyDetector for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource cannot be found. Check the ARN of the resource and
//   try again.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by the AWS service.
//   Check your input values and try again.
//
//   * AccessDeniedException
//   You do not have sufficient permissions to perform this action.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * TooManyRequestsException
//   The request was denied due to too many requests being submitted at the same
//   time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DescribeAnomalyDetector
func (c *LookoutMetrics) DescribeAnomalyDetector(input *DescribeAnomalyDetectorInput) (*DescribeAnomalyDetectorOutput, error) {
	req, out := c.DescribeAnomalyDetectorRequest(input)
	return out, req.Send()
}

// DescribeAnomalyDetectorWithContext is the same as DescribeAnomalyDetector with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAnomalyDetector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutMetrics) DescribeAnomalyDetectorWithContext(ctx aws.Context, input *DescribeAnomalyDetectorInput, opts ...request.Option) (*DescribeAnomalyDetectorOutput, error) {
	req, out := c.DescribeAnomalyDetectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeMetricSet = "DescribeMetricSet"

// DescribeMetricSetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMetricSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMetricSet for more information on using the DescribeMetricSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeMetricSetRequest method.
//    req, resp := client.DescribeMetricSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DescribeMetricSet
func (c *LookoutMetrics) DescribeMetricSetRequest(input *DescribeMetricSetInput) (req *request.Request, output *DescribeMetricSetOutput) {
	op := &request.Operation{
		Name:       opDescribeMetricSet,
		HTTPMethod: "POST",
		HTTPPath:   "/DescribeMetricSet",
	}

	if input == nil {
		input = &DescribeMetricSetInput{}
	}

	output = &DescribeMetricSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMetricSet API operation for Amazon Lookout for Metrics.
//
// Describes a dataset.
//
// Amazon Lookout for Metrics API actions are eventually consistent. If you
// do a read operation on a resource immediately after creating or modifying
// it, use retries to allow time for the write operation to complete.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Metrics's
// API operation DescribeMetricSet for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource cannot be found. Check the ARN of the resource and
//   try again.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by the AWS service.
//   Check your input values and try again.
//
//   * AccessDeniedException
//   You do not have sufficient permissions to perform this action.
//
//   * TooManyRequestsException
//   The request was denied due to too many requests being submitted at the same
//   time.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DescribeMetricSet
func (c *LookoutMetrics) DescribeMetricSet(input *DescribeMetricSetInput) (*DescribeMetricSetOutput, error) {
	req, out := c.DescribeMetricSetRequest(input)
	return out, req.Send()
}

// DescribeMetricSetWithContext is the same as DescribeMetricSet with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMetricSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutMetrics) DescribeMetricSetWithContext(ctx aws.Context, input *DescribeMetricSetInput, opts ...request.Option) (*DescribeMetricSetOutput, error) {
	req, out := c.DescribeMetricSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAnomalyGroup = "GetAnomalyGroup"

// GetAnomalyGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetAnomalyGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAnomalyGroup for more information on using the GetAnomalyGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAnomalyGroupRequest method.
//    req, resp := client.GetAnomalyGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/GetAnomalyGroup
func (c *LookoutMetrics) GetAnomalyGroupRequest(input *GetAnomalyGroupInput) (req *request.Request, output *GetAnomalyGroupOutput) {
	op := &request.Operation{
		Name:       opGetAnomalyGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/GetAnomalyGroup",
	}

	if input == nil {
		input = &GetAnomalyGroupInput{}
	}

	output = &GetAnomalyGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAnomalyGroup API operation for Amazon Lookout for Metrics.
//
// Returns details about a group of anomalous metrics.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Metrics's
// API operation GetAnomalyGroup for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource cannot be found. Check the ARN of the resource and
//   try again.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by the AWS service.
//   Check your input values and try again.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * AccessDeniedException
//   You do not have sufficient permissions to perform this action.
//
//   * TooManyRequestsException
//   The request was denied due to too many requests being submitted at the same
//   time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/GetAnomalyGroup
func (c *LookoutMetrics) GetAnomalyGroup(input *GetAnomalyGroupInput) (*GetAnomalyGroupOutput, error) {
	req, out := c.GetAnomalyGroupRequest(input)
	return out, req.Send()
}

// GetAnomalyGroupWithContext is the same as GetAnomalyGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetAnomalyGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutMetrics) GetAnomalyGroupWithContext(ctx aws.Context, input *GetAnomalyGroupInput, opts ...request.Option) (*GetAnomalyGroupOutput, error) {
	req, out := c.GetAnomalyGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFeedback = "GetFeedback"

// GetFeedbackRequest generates a "aws/request.Request" representing the
// client's request for the GetFeedback operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFeedback for more information on using the GetFeedback
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFeedbackRequest method.
//    req, resp := client.GetFeedbackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/GetFeedback
func (c *LookoutMetrics) GetFeedbackRequest(input *GetFeedbackInput) (req *request.Request, output *GetFeedbackOutput) {
	op := &request.Operation{
		Name:       opGetFeedback,
		HTTPMethod: "POST",
		HTTPPath:   "/GetFeedback",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetFeedbackInput{}
	}

	output = &GetFeedbackOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFeedback API operation for Amazon Lookout for Metrics.
//
// Get feedback for an anomaly group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Metrics's
// API operation GetFeedback for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource cannot be found. Check the ARN of the resource and
//   try again.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by the AWS service.
//   Check your input values and try again.
//
//   * AccessDeniedException
//   You do not have sufficient permissions to perform this action.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * TooManyRequestsException
//   The request was denied due to too many requests being submitted at the same
//   time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/GetFeedback
func (c *LookoutMetrics) GetFeedback(input *GetFeedbackInput) (*GetFeedbackOutput, error) {
	req, out := c.GetFeedbackRequest(input)
	return out, req.Send()
}

// GetFeedbackWithContext is the same as GetFeedback with the addition of
// the ability to pass a context and additional request options.
//
// See GetFeedback for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutMetrics) GetFeedbackWithContext(ctx aws.Context, input *GetFeedbackInput, opts ...request.Option) (*GetFeedbackOutput, error) {
	req, out := c.GetFeedbackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetFeedbackPages iterates over the pages of a GetFeedback operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetFeedback method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetFeedback operation.
//    pageNum := 0
//    err := client.GetFeedbackPages(params,
//        func(page *lookoutmetrics.GetFeedbackOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *LookoutMetrics) GetFeedbackPages(input *GetFeedbackInput, fn func(*GetFeedbackOutput, bool) bool) error {
	return c.GetFeedbackPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetFeedbackPagesWithContext same as GetFeedbackPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutMetrics) GetFeedbackPagesWithContext(ctx aws.Context, input *GetFeedbackInput, fn func(*GetFeedbackOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetFeedbackInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetFeedbackRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetFeedbackOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetSampleData = "GetSampleData"

// GetSampleDataRequest generates a "aws/request.Request" representing the
// client's request for the GetSampleData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSampleData for more information on using the GetSampleData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSampleDataRequest method.
//    req, resp := client.GetSampleDataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/GetSampleData
func (c *LookoutMetrics) GetSampleDataRequest(input *GetSampleDataInput) (req *request.Request, output *GetSampleDataOutput) {
	op := &request.Operation{
		Name:       opGetSampleData,
		HTTPMethod: "POST",
		HTTPPath:   "/GetSampleData",
	}

	if input == nil {
		input = &GetSampleDataInput{}
	}

	output = &GetSampleDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSampleData API operation for Amazon Lookout for Metrics.
//
// Returns a selection of sample records from an Amazon S3 datasource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Metrics's
// API operation GetSampleData for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input fails to satisfy the constraints specified by the AWS service.
//   Check your input values and try again.
//
//   * ResourceNotFoundException
//   The specified resource cannot be found. Check the ARN of the resource and
//   try again.
//
//   * AccessDeniedException
//   You do not have sufficient permissions to perform this action.
//
//   * TooManyRequestsException
//   The request was denied due to too many requests being submitted at the same
//   time.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/GetSampleData
func (c *LookoutMetrics) GetSampleData(input *GetSampleDataInput) (*GetSampleDataOutput, error) {
	req, out := c.GetSampleDataRequest(input)
	return out, req.Send()
}

// GetSampleDataWithContext is the same as GetSampleData with the addition of
// the ability to pass a context and additional request options.
//
// See GetSampleData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutMetrics) GetSampleDataWithContext(ctx aws.Context, input *GetSampleDataInput, opts ...request.Option) (*GetSampleDataOutput, error) {
	req, out := c.GetSampleDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAlerts = "ListAlerts"

// ListAlertsRequest generates a "aws/request.Request" representing the
// client's request for the ListAlerts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAlerts for more information on using the ListAlerts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAlertsRequest method.
//    req, resp := client.ListAlertsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAlerts
func (c *LookoutMetrics) ListAlertsRequest(input *ListAlertsInput) (req *request.Request, output *ListAlertsOutput) {
	op := &request.Operation{
		Name:       opListAlerts,
		HTTPMethod: "POST",
		HTTPPath:   "/ListAlerts",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAlertsInput{}
	}

	output = &ListAlertsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAlerts API operation for Amazon Lookout for Metrics.
//
// Lists the alerts attached to a detector.
//
// Amazon Lookout for Metrics API actions are eventually consistent. If you
// do a read operation on a resource immediately after creating or modifying
// it, use retries to allow time for the write operation to complete.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Metrics's
// API operation ListAlerts for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource cannot be found. Check the ARN of the resource and
//   try again.
//
//   * AccessDeniedException
//   You do not have sufficient permissions to perform this action.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * TooManyRequestsException
//   The request was denied due to too many requests being submitted at the same
//   time.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by the AWS service.
//   Check your input values and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAlerts
func (c *LookoutMetrics) ListAlerts(input *ListAlertsInput) (*ListAlertsOutput, error) {
	req, out := c.ListAlertsRequest(input)
	return out, req.Send()
}

// ListAlertsWithContext is the same as ListAlerts with the addition of
// the ability to pass a context and additional request options.
//
// See ListAlerts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutMetrics) ListAlertsWithContext(ctx aws.Context, input *ListAlertsInput, opts ...request.Option) (*ListAlertsOutput, error) {
	req, out := c.ListAlertsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAlertsPages iterates over the pages of a ListAlerts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAlerts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAlerts operation.
//    pageNum := 0
//    err := client.ListAlertsPages(params,
//        func(page *lookoutmetrics.ListAlertsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *LookoutMetrics) ListAlertsPages(input *ListAlertsInput, fn func(*ListAlertsOutput, bool) bool) error {
	return c.ListAlertsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAlertsPagesWithContext same as ListAlertsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutMetrics) ListAlertsPagesWithContext(ctx aws.Context, input *ListAlertsInput, fn func(*ListAlertsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAlertsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAlertsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAlertsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAnomalyDetectors = "ListAnomalyDetectors"

// ListAnomalyDetectorsRequest generates a "aws/request.Request" representing the
// client's request for the ListAnomalyDetectors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAnomalyDetectors for more information on using the ListAnomalyDetectors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAnomalyDetectorsRequest method.
//    req, resp := client.ListAnomalyDetectorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyDetectors
func (c *LookoutMetrics) ListAnomalyDetectorsRequest(input *ListAnomalyDetectorsInput) (req *request.Request, output *ListAnomalyDetectorsOutput) {
	op := &request.Operation{
		Name:       opListAnomalyDetectors,
		HTTPMethod: "POST",
		HTTPPath:   "/ListAnomalyDetectors",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAnomalyDetectorsInput{}
	}

	output = &ListAnomalyDetectorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAnomalyDetectors API operation for Amazon Lookout for Metrics.
//
// Lists the detectors in the current AWS Region.
//
// Amazon Lookout for Metrics API actions are eventually consistent. If you
// do a read operation on a resource immediately after creating or modifying
// it, use retries to allow time for the write operation to complete.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Metrics's
// API operation ListAnomalyDetectors for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource cannot be found. Check the ARN of the resource and
//   try again.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by the AWS service.
//   Check your input values and try again.
//
//   * AccessDeniedException
//   You do not have sufficient permissions to perform this action.
//
//   * TooManyRequestsException
//   The request was denied due to too many requests being submitted at the same
//   time.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyDetectors
func (c *LookoutMetrics) ListAnomalyDetectors(input *ListAnomalyDetectorsInput) (*ListAnomalyDetectorsOutput, error) {
	req, out := c.ListAnomalyDetectorsRequest(input)
	return out, req.Send()
}

// ListAnomalyDetectorsWithContext is the same as ListAnomalyDetectors with the addition of
// the ability to pass a context and additional request options.
//
// See ListAnomalyDetectors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutMetrics) ListAnomalyDetectorsWithContext(ctx aws.Context, input *ListAnomalyDetectorsInput, opts ...request.Option) (*ListAnomalyDetectorsOutput, error) {
	req, out := c.ListAnomalyDetectorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAnomalyDetectorsPages iterates over the pages of a ListAnomalyDetectors operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAnomalyDetectors method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAnomalyDetectors operation.
//    pageNum := 0
//    err := client.ListAnomalyDetectorsPages(params,
//        func(page *lookoutmetrics.ListAnomalyDetectorsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *LookoutMetrics) ListAnomalyDetectorsPages(input *ListAnomalyDetectorsInput, fn func(*ListAnomalyDetectorsOutput, bool) bool) error {
	return c.ListAnomalyDetectorsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAnomalyDetectorsPagesWithContext same as ListAnomalyDetectorsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutMetrics) ListAnomalyDetectorsPagesWithContext(ctx aws.Context, input *ListAnomalyDetectorsInput, fn func(*ListAnomalyDetectorsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAnomalyDetectorsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAnomalyDetectorsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAnomalyDetectorsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAnomalyGroupRelatedMetrics = "ListAnomalyGroupRelatedMetrics"

// ListAnomalyGroupRelatedMetricsRequest generates a "aws/request.Request" representing the
// client's request for the ListAnomalyGroupRelatedMetrics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAnomalyGroupRelatedMetrics for more information on using the ListAnomalyGroupRelatedMetrics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAnomalyGroupRelatedMetricsRequest method.
//    req, resp := client.ListAnomalyGroupRelatedMetricsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyGroupRelatedMetrics
func (c *LookoutMetrics) ListAnomalyGroupRelatedMetricsRequest(input *ListAnomalyGroupRelatedMetricsInput) (req *request.Request, output *ListAnomalyGroupRelatedMetricsOutput) {
	op := &request.Operation{
		Name:       opListAnomalyGroupRelatedMetrics,
		HTTPMethod: "POST",
		HTTPPath:   "/ListAnomalyGroupRelatedMetrics",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAnomalyGroupRelatedMetricsInput{}
	}

	output = &ListAnomalyGroupRelatedMetricsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAnomalyGroupRelatedMetrics API operation for Amazon Lookout for Metrics.
//
// Returns a list of measures that are potential causes or effects of an anomaly
// group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Metrics's
// API operation ListAnomalyGroupRelatedMetrics for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource cannot be found. Check the ARN of the resource and
//   try again.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by the AWS service.
//   Check your input values and try again.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * AccessDeniedException
//   You do not have sufficient permissions to perform this action.
//
//   * TooManyRequestsException
//   The request was denied due to too many requests being submitted at the same
//   time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyGroupRelatedMetrics
func (c *LookoutMetrics) ListAnomalyGroupRelatedMetrics(input *ListAnomalyGroupRelatedMetricsInput) (*ListAnomalyGroupRelatedMetricsOutput, error) {
	req, out := c.ListAnomalyGroupRelatedMetricsRequest(input)
	return out, req.Send()
}

// ListAnomalyGroupRelatedMetricsWithContext is the same as ListAnomalyGroupRelatedMetrics with the addition of
// the ability to pass a context and additional request options.
//
// See ListAnomalyGroupRelatedMetrics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutMetrics) ListAnomalyGroupRelatedMetricsWithContext(ctx aws.Context, input *ListAnomalyGroupRelatedMetricsInput, opts ...request.Option) (*ListAnomalyGroupRelatedMetricsOutput, error) {
	req, out := c.ListAnomalyGroupRelatedMetricsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAnomalyGroupRelatedMetricsPages iterates over the pages of a ListAnomalyGroupRelatedMetrics operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAnomalyGroupRelatedMetrics method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAnomalyGroupRelatedMetrics operation.
//    pageNum := 0
//    err := client.ListAnomalyGroupRelatedMetricsPages(params,
//        func(page *lookoutmetrics.ListAnomalyGroupRelatedMetricsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *LookoutMetrics) ListAnomalyGroupRelatedMetricsPages(input *ListAnomalyGroupRelatedMetricsInput, fn func(*ListAnomalyGroupRelatedMetricsOutput, bool) bool) error {
	return c.ListAnomalyGroupRelatedMetricsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAnomalyGroupRelatedMetricsPagesWithContext same as ListAnomalyGroupRelatedMetricsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutMetrics) ListAnomalyGroupRelatedMetricsPagesWithContext(ctx aws.Context, input *ListAnomalyGroupRelatedMetricsInput, fn func(*ListAnomalyGroupRelatedMetricsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAnomalyGroupRelatedMetricsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAnomalyGroupRelatedMetricsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAnomalyGroupRelatedMetricsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAnomalyGroupSummaries = "ListAnomalyGroupSummaries"

// ListAnomalyGroupSummariesRequest generates a "aws/request.Request" representing the
// client's request for the ListAnomalyGroupSummaries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAnomalyGroupSummaries for more information on using the ListAnomalyGroupSummaries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAnomalyGroupSummariesRequest method.
//    req, resp := client.ListAnomalyGroupSummariesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyGroupSummaries
func (c *LookoutMetrics) ListAnomalyGroupSummariesRequest(input *ListAnomalyGroupSummariesInput) (req *request.Request, output *ListAnomalyGroupSummariesOutput) {
	op := &request.Operation{
		Name:       opListAnomalyGroupSummaries,
		HTTPMethod: "POST",
		HTTPPath:   "/ListAnomalyGroupSummaries",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAnomalyGroupSummariesInput{}
	}

	output = &ListAnomalyGroupSummariesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAnomalyGroupSummaries API operation for Amazon Lookout for Metrics.
//
// Returns a list of anomaly groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Metrics's
// API operation ListAnomalyGroupSummaries for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource cannot be found. Check the ARN of the resource and
//   try again.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by the AWS service.
//   Check your input values and try again.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * AccessDeniedException
//   You do not have sufficient permissions to perform this action.
//
//   * TooManyRequestsException
//   The request was denied due to too many requests being submitted at the same
//   time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyGroupSummaries
func (c *LookoutMetrics) ListAnomalyGroupSummaries(input *ListAnomalyGroupSummariesInput) (*ListAnomalyGroupSummariesOutput, error) {
	req, out := c.ListAnomalyGroupSummariesRequest(input)
	return out, req.Send()
}

// ListAnomalyGroupSummariesWithContext is the same as ListAnomalyGroupSummaries with the addition of
// the ability to pass a context and additional request options.
//
// See ListAnomalyGroupSummaries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutMetrics) ListAnomalyGroupSummariesWithContext(ctx aws.Context, input *ListAnomalyGroupSummariesInput, opts ...request.Option) (*ListAnomalyGroupSummariesOutput, error) {
	req, out := c.ListAnomalyGroupSummariesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAnomalyGroupSummariesPages iterates over the pages of a ListAnomalyGroupSummaries operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAnomalyGroupSummaries method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAnomalyGroupSummaries operation.
//    pageNum := 0
//    err := client.ListAnomalyGroupSummariesPages(params,
//        func(page *lookoutmetrics.ListAnomalyGroupSummariesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *LookoutMetrics) ListAnomalyGroupSummariesPages(input *ListAnomalyGroupSummariesInput, fn func(*ListAnomalyGroupSummariesOutput, bool) bool) error {
	return c.ListAnomalyGroupSummariesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAnomalyGroupSummariesPagesWithContext same as ListAnomalyGroupSummariesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutMetrics) ListAnomalyGroupSummariesPagesWithContext(ctx aws.Context, input *ListAnomalyGroupSummariesInput, fn func(*ListAnomalyGroupSummariesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAnomalyGroupSummariesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAnomalyGroupSummariesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAnomalyGroupSummariesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAnomalyGroupTimeSeries = "ListAnomalyGroupTimeSeries"

// ListAnomalyGroupTimeSeriesRequest generates a "aws/request.Request" representing the
// client's request for the ListAnomalyGroupTimeSeries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAnomalyGroupTimeSeries for more information on using the ListAnomalyGroupTimeSeries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAnomalyGroupTimeSeriesRequest method.
//    req, resp := client.ListAnomalyGroupTimeSeriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyGroupTimeSeries
func (c *LookoutMetrics) ListAnomalyGroupTimeSeriesRequest(input *ListAnomalyGroupTimeSeriesInput) (req *request.Request, output *ListAnomalyGroupTimeSeriesOutput) {
	op := &request.Operation{
		Name:       opListAnomalyGroupTimeSeries,
		HTTPMethod: "POST",
		HTTPPath:   "/ListAnomalyGroupTimeSeries",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAnomalyGroupTimeSeriesInput{}
	}

	output = &ListAnomalyGroupTimeSeriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAnomalyGroupTimeSeries API operation for Amazon Lookout for Metrics.
//
// Gets a list of anomalous metrics for a measure in an anomaly group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Metrics's
// API operation ListAnomalyGroupTimeSeries for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * AccessDeniedException
//   You do not have sufficient permissions to perform this action.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by the AWS service.
//   Check your input values and try again.
//
//   * ResourceNotFoundException
//   The specified resource cannot be found. Check the ARN of the resource and
//   try again.
//
//   * TooManyRequestsException
//   The request was denied due to too many requests being submitted at the same
//   time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyGroupTimeSeries
func (c *LookoutMetrics) ListAnomalyGroupTimeSeries(input *ListAnomalyGroupTimeSeriesInput) (*ListAnomalyGroupTimeSeriesOutput, error) {
	req, out := c.ListAnomalyGroupTimeSeriesRequest(input)
	return out, req.Send()
}

// ListAnomalyGroupTimeSeriesWithContext is the same as ListAnomalyGroupTimeSeries with the addition of
// the ability to pass a context and additional request options.
//
// See ListAnomalyGroupTimeSeries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutMetrics) ListAnomalyGroupTimeSeriesWithContext(ctx aws.Context, input *ListAnomalyGroupTimeSeriesInput, opts ...request.Option) (*ListAnomalyGroupTimeSeriesOutput, error) {
	req, out := c.ListAnomalyGroupTimeSeriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAnomalyGroupTimeSeriesPages iterates over the pages of a ListAnomalyGroupTimeSeries operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAnomalyGroupTimeSeries method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAnomalyGroupTimeSeries operation.
//    pageNum := 0
//    err := client.ListAnomalyGroupTimeSeriesPages(params,
//        func(page *lookoutmetrics.ListAnomalyGroupTimeSeriesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *LookoutMetrics) ListAnomalyGroupTimeSeriesPages(input *ListAnomalyGroupTimeSeriesInput, fn func(*ListAnomalyGroupTimeSeriesOutput, bool) bool) error {
	return c.ListAnomalyGroupTimeSeriesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAnomalyGroupTimeSeriesPagesWithContext same as ListAnomalyGroupTimeSeriesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutMetrics) ListAnomalyGroupTimeSeriesPagesWithContext(ctx aws.Context, input *ListAnomalyGroupTimeSeriesInput, fn func(*ListAnomalyGroupTimeSeriesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAnomalyGroupTimeSeriesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAnomalyGroupTimeSeriesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAnomalyGroupTimeSeriesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMetricSets = "ListMetricSets"

// ListMetricSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListMetricSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMetricSets for more information on using the ListMetricSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMetricSetsRequest method.
//    req, resp := client.ListMetricSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListMetricSets
func (c *LookoutMetrics) ListMetricSetsRequest(input *ListMetricSetsInput) (req *request.Request, output *ListMetricSetsOutput) {
	op := &request.Operation{
		Name:       opListMetricSets,
		HTTPMethod: "POST",
		HTTPPath:   "/ListMetricSets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMetricSetsInput{}
	}

	output = &ListMetricSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMetricSets API operation for Amazon Lookout for Metrics.
//
// Lists the datasets in the current AWS Region.
//
// Amazon Lookout for Metrics API actions are eventually consistent. If you
// do a read operation on a resource immediately after creating or modifying
// it, use retries to allow time for the write operation to complete.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Metrics's
// API operation ListMetricSets for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource cannot be found. Check the ARN of the resource and
//   try again.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by the AWS service.
//   Check your input values and try again.
//
//   * AccessDeniedException
//   You do not have sufficient permissions to perform this action.
//
//   * TooManyRequestsException
//   The request was denied due to too many requests being submitted at the same
//   time.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListMetricSets
func (c *LookoutMetrics) ListMetricSets(input *ListMetricSetsInput) (*ListMetricSetsOutput, error) {
	req, out := c.ListMetricSetsRequest(input)
	return out, req.Send()
}

// ListMetricSetsWithContext is the same as ListMetricSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListMetricSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutMetrics) ListMetricSetsWithContext(ctx aws.Context, input *ListMetricSetsInput, opts ...request.Option) (*ListMetricSetsOutput, error) {
	req, out := c.ListMetricSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMetricSetsPages iterates over the pages of a ListMetricSets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMetricSets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMetricSets operation.
//    pageNum := 0
//    err := client.ListMetricSetsPages(params,
//        func(page *lookoutmetrics.ListMetricSetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *LookoutMetrics) ListMetricSetsPages(input *ListMetricSetsInput, fn func(*ListMetricSetsOutput, bool) bool) error {
	return c.ListMetricSetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMetricSetsPagesWithContext same as ListMetricSetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutMetrics) ListMetricSetsPagesWithContext(ctx aws.Context, input *ListMetricSetsInput, fn func(*ListMetricSetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMetricSetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMetricSetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMetricSetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListTagsForResource
func (c *LookoutMetrics) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Lookout for Metrics.
//
// Gets a list of tags (https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html)
// for a detector, dataset, or alert.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Metrics's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by the AWS service.
//   Check your input values and try again.
//
//   * ResourceNotFoundException
//   The specified resource cannot be found. Check the ARN of the resource and
//   try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListTagsForResource
func (c *LookoutMetrics) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutMetrics) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutFeedback = "PutFeedback"

// PutFeedbackRequest generates a "aws/request.Request" representing the
// client's request for the PutFeedback operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutFeedback for more information on using the PutFeedback
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutFeedbackRequest method.
//    req, resp := client.PutFeedbackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/PutFeedback
func (c *LookoutMetrics) PutFeedbackRequest(input *PutFeedbackInput) (req *request.Request, output *PutFeedbackOutput) {
	op := &request.Operation{
		Name:       opPutFeedback,
		HTTPMethod: "POST",
		HTTPPath:   "/PutFeedback",
	}

	if input == nil {
		input = &PutFeedbackInput{}
	}

	output = &PutFeedbackOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutFeedback API operation for Amazon Lookout for Metrics.
//
// Add feedback for an anomalous metric.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Metrics's
// API operation PutFeedback for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource cannot be found. Check the ARN of the resource and
//   try again.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by the AWS service.
//   Check your input values and try again.
//
//   * AccessDeniedException
//   You do not have sufficient permissions to perform this action.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * TooManyRequestsException
//   The request was denied due to too many requests being submitted at the same
//   time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/PutFeedback
func (c *LookoutMetrics) PutFeedback(input *PutFeedbackInput) (*PutFeedbackOutput, error) {
	req, out := c.PutFeedbackRequest(input)
	return out, req.Send()
}

// PutFeedbackWithContext is the same as PutFeedback with the addition of
// the ability to pass a context and additional request options.
//
// See PutFeedback for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutMetrics) PutFeedbackWithContext(ctx aws.Context, input *PutFeedbackInput, opts ...request.Option) (*PutFeedbackOutput, error) {
	req, out := c.PutFeedbackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/TagResource
func (c *LookoutMetrics) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Lookout for Metrics.
//
// Adds tags (https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html)
// to a detector, dataset, or alert.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Metrics's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by the AWS service.
//   Check your input values and try again.
//
//   * ResourceNotFoundException
//   The specified resource cannot be found. Check the ARN of the resource and
//   try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/TagResource
func (c *LookoutMetrics) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutMetrics) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/UntagResource
func (c *LookoutMetrics) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Lookout for Metrics.
//
// Removes tags (https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html)
// from a detector, dataset, or alert.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Metrics's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by the AWS service.
//   Check your input values and try again.
//
//   * ResourceNotFoundException
//   The specified resource cannot be found. Check the ARN of the resource and
//   try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/UntagResource
func (c *LookoutMetrics) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutMetrics) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAnomalyDetector = "UpdateAnomalyDetector"

// UpdateAnomalyDetectorRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAnomalyDetector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAnomalyDetector for more information on using the UpdateAnomalyDetector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAnomalyDetectorRequest method.
//    req, resp := client.UpdateAnomalyDetectorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/UpdateAnomalyDetector
func (c *LookoutMetrics) UpdateAnomalyDetectorRequest(input *UpdateAnomalyDetectorInput) (req *request.Request, output *UpdateAnomalyDetectorOutput) {
	op := &request.Operation{
		Name:       opUpdateAnomalyDetector,
		HTTPMethod: "POST",
		HTTPPath:   "/UpdateAnomalyDetector",
	}

	if input == nil {
		input = &UpdateAnomalyDetectorInput{}
	}

	output = &UpdateAnomalyDetectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAnomalyDetector API operation for Amazon Lookout for Metrics.
//
// Updates a detector. After activation, you can only change a detector's ingestion
// delay and description.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Metrics's
// API operation UpdateAnomalyDetector for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource cannot be found. Check the ARN of the resource and
//   try again.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by the AWS service.
//   Check your input values and try again.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * AccessDeniedException
//   You do not have sufficient permissions to perform this action.
//
//   * TooManyRequestsException
//   The request was denied due to too many requests being submitted at the same
//   time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/UpdateAnomalyDetector
func (c *LookoutMetrics) UpdateAnomalyDetector(input *UpdateAnomalyDetectorInput) (*UpdateAnomalyDetectorOutput, error) {
	req, out := c.UpdateAnomalyDetectorRequest(input)
	return out, req.Send()
}

// UpdateAnomalyDetectorWithContext is the same as UpdateAnomalyDetector with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAnomalyDetector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutMetrics) UpdateAnomalyDetectorWithContext(ctx aws.Context, input *UpdateAnomalyDetectorInput, opts ...request.Option) (*UpdateAnomalyDetectorOutput, error) {
	req, out := c.UpdateAnomalyDetectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMetricSet = "UpdateMetricSet"

// UpdateMetricSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMetricSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMetricSet for more information on using the UpdateMetricSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateMetricSetRequest method.
//    req, resp := client.UpdateMetricSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/UpdateMetricSet
func (c *LookoutMetrics) UpdateMetricSetRequest(input *UpdateMetricSetInput) (req *request.Request, output *UpdateMetricSetOutput) {
	op := &request.Operation{
		Name:       opUpdateMetricSet,
		HTTPMethod: "POST",
		HTTPPath:   "/UpdateMetricSet",
	}

	if input == nil {
		input = &UpdateMetricSetInput{}
	}

	output = &UpdateMetricSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMetricSet API operation for Amazon Lookout for Metrics.
//
// Updates a dataset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Metrics's
// API operation UpdateMetricSet for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource cannot be found. Check the ARN of the resource and
//   try again.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by the AWS service.
//   Check your input values and try again.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * AccessDeniedException
//   You do not have sufficient permissions to perform this action.
//
//   * TooManyRequestsException
//   The request was denied due to too many requests being submitted at the same
//   time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/UpdateMetricSet
func (c *LookoutMetrics) UpdateMetricSet(input *UpdateMetricSetInput) (*UpdateMetricSetOutput, error) {
	req, out := c.UpdateMetricSetRequest(input)
	return out, req.Send()
}

// UpdateMetricSetWithContext is the same as UpdateMetricSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMetricSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutMetrics) UpdateMetricSetWithContext(ctx aws.Context, input *UpdateMetricSetInput, opts ...request.Option) (*UpdateMetricSetOutput, error) {
	req, out := c.UpdateMetricSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient permissions to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A configuration that specifies the action to perform when anomalies are detected.
type Action struct {
	_ struct{} `type:"structure"`

	// A configuration for an AWS Lambda channel.
	LambdaConfiguration *LambdaConfiguration `type:"structure"`

	// A configuration for an Amazon SNS channel.
	SNSConfiguration *SNSConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Action) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Action) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Action) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Action"}
	if s.LambdaConfiguration != nil {
		if err := s.LambdaConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LambdaConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.SNSConfiguration != nil {
		if err := s.SNSConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SNSConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLambdaConfiguration sets the LambdaConfiguration field's value.
func (s *Action) SetLambdaConfiguration(v *LambdaConfiguration) *Action {
	s.LambdaConfiguration = v
	return s
}

// SetSNSConfiguration sets the SNSConfiguration field's value.
func (s *Action) SetSNSConfiguration(v *SNSConfiguration) *Action {
	s.SNSConfiguration = v
	return s
}

type ActivateAnomalyDetectorInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the anomaly detector.
	//
	// AnomalyDetectorArn is a required field
	AnomalyDetectorArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateAnomalyDetectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateAnomalyDetectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActivateAnomalyDetectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActivateAnomalyDetectorInput"}
	if s.AnomalyDetectorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AnomalyDetectorArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnomalyDetectorArn sets the AnomalyDetectorArn field's value.
func (s *ActivateAnomalyDetectorInput) SetAnomalyDetectorArn(v string) *ActivateAnomalyDetectorInput {
	s.AnomalyDetectorArn = &v
	return s
}

type ActivateAnomalyDetectorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateAnomalyDetectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateAnomalyDetectorOutput) GoString() string {
	return s.String()
}

// A configuration for Amazon SNS-integrated notifications.
type Alert struct {
	_ struct{} `type:"structure"`

	// Action that will be triggered when there is an alert.
	Action *Action `type:"structure"`

	// The ARN of the alert.
	AlertArn *string `type:"string"`

	// A description of the alert.
	AlertDescription *string `type:"string"`

	// The name of the alert.
	AlertName *string `min:"1" type:"string"`

	// The minimum severity for an anomaly to trigger the alert.
	AlertSensitivityThreshold *int64 `type:"integer"`

	// The status of the alert.
	AlertStatus *string `type:"string" enum:"AlertStatus"`

	// The type of the alert.
	AlertType *string `type:"string" enum:"AlertType"`

	// The ARN of the detector to which the alert is attached.
	AnomalyDetectorArn *string `type:"string"`

	// The time at which the alert was created.
	CreationTime *time.Time `type:"timestamp"`

	// The time at which the alert was last modified.
	LastModificationTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Alert) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Alert) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *Alert) SetAction(v *Action) *Alert {
	s.Action = v
	return s
}

// SetAlertArn sets the AlertArn field's value.
func (s *Alert) SetAlertArn(v string) *Alert {
	s.AlertArn = &v
	return s
}

// SetAlertDescription sets the AlertDescription field's value.
func (s *Alert) SetAlertDescription(v string) *Alert {
	s.AlertDescription = &v
	return s
}

// SetAlertName sets the AlertName field's value.
func (s *Alert) SetAlertName(v string) *Alert {
	s.AlertName = &v
	return s
}

// SetAlertSensitivityThreshold sets the AlertSensitivityThreshold field's value.
func (s *Alert) SetAlertSensitivityThreshold(v int64) *Alert {
	s.AlertSensitivityThreshold = &v
	return s
}

// SetAlertStatus sets the AlertStatus field's value.
func (s *Alert) SetAlertStatus(v string) *Alert {
	s.AlertStatus = &v
	return s
}

// SetAlertType sets the AlertType field's value.
func (s *Alert) SetAlertType(v string) *Alert {
	s.AlertType = &v
	return s
}

// SetAnomalyDetectorArn sets the AnomalyDetectorArn field's value.
func (s *Alert) SetAnomalyDetectorArn(v string) *Alert {
	s.AnomalyDetectorArn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Alert) SetCreationTime(v time.Time) *Alert {
	s.CreationTime = &v
	return s
}

// SetLastModificationTime sets the LastModificationTime field's value.
func (s *Alert) SetLastModificationTime(v time.Time) *Alert {
	s.LastModificationTime = &v
	return s
}

// Provides a summary of an alert's configuration.
type AlertSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the alert.
	AlertArn *string `type:"string"`

	// The name of the alert.
	AlertName *string `min:"1" type:"string"`

	// The minimum severity for an anomaly to trigger the alert.
	AlertSensitivityThreshold *int64 `type:"integer"`

	// The status of the alert.
	AlertStatus *string `type:"string" enum:"AlertStatus"`

	// The type of the alert.
	AlertType *string `type:"string" enum:"AlertType"`

	// The ARN of the detector to which the alert is attached.
	AnomalyDetectorArn *string `type:"string"`

	// The time at which the alert was created.
	CreationTime *time.Time `type:"timestamp"`

	// The time at which the alert was last modified.
	LastModificationTime *time.Time `type:"timestamp"`

	// The alert's tags (https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html).
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlertSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlertSummary) GoString() string {
	return s.String()
}

// SetAlertArn sets the AlertArn field's value.
func (s *AlertSummary) SetAlertArn(v string) *AlertSummary {
	s.AlertArn = &v
	return s
}

// SetAlertName sets the AlertName field's value.
func (s *AlertSummary) SetAlertName(v string) *AlertSummary {
	s.AlertName = &v
	return s
}

// SetAlertSensitivityThreshold sets the AlertSensitivityThreshold field's value.
func (s *AlertSummary) SetAlertSensitivityThreshold(v int64) *AlertSummary {
	s.AlertSensitivityThreshold = &v
	return s
}

// SetAlertStatus sets the AlertStatus field's value.
func (s *AlertSummary) SetAlertStatus(v string) *AlertSummary {
	s.AlertStatus = &v
	return s
}

// SetAlertType sets the AlertType field's value.
func (s *AlertSummary) SetAlertType(v string) *AlertSummary {
	s.AlertType = &v
	return s
}

// SetAnomalyDetectorArn sets the AnomalyDetectorArn field's value.
func (s *AlertSummary) SetAnomalyDetectorArn(v string) *AlertSummary {
	s.AnomalyDetectorArn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *AlertSummary) SetCreationTime(v time.Time) *AlertSummary {
	s.CreationTime = &v
	return s
}

// SetLastModificationTime sets the LastModificationTime field's value.
func (s *AlertSummary) SetLastModificationTime(v time.Time) *AlertSummary {
	s.LastModificationTime = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AlertSummary) SetTags(v map[string]*string) *AlertSummary {
	s.Tags = v
	return s
}

// Contains information about a detector's configuration.
type AnomalyDetectorConfig struct {
	_ struct{} `type:"structure"`

	// The frequency at which the detector analyzes its source data.
	AnomalyDetectorFrequency *string `type:"string" enum:"Frequency"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalyDetectorConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalyDetectorConfig) GoString() string {
	return s.String()
}

// SetAnomalyDetectorFrequency sets the AnomalyDetectorFrequency field's value.
func (s *AnomalyDetectorConfig) SetAnomalyDetectorFrequency(v string) *AnomalyDetectorConfig {
	s.AnomalyDetectorFrequency = &v
	return s
}

// Contains information about a detector's configuration.
type AnomalyDetectorConfigSummary struct {
	_ struct{} `type:"structure"`

	// The interval at which the detector analyzes its source data.
	AnomalyDetectorFrequency *string `type:"string" enum:"Frequency"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalyDetectorConfigSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalyDetectorConfigSummary) GoString() string {
	return s.String()
}

// SetAnomalyDetectorFrequency sets the AnomalyDetectorFrequency field's value.
func (s *AnomalyDetectorConfigSummary) SetAnomalyDetectorFrequency(v string) *AnomalyDetectorConfigSummary {
	s.AnomalyDetectorFrequency = &v
	return s
}

// Contains information about an an anomaly detector.
type AnomalyDetectorSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the detector.
	AnomalyDetectorArn *string `type:"string"`

	// A description of the detector.
	AnomalyDetectorDescription *string `min:"1" type:"string"`

	// The name of the detector.
	AnomalyDetectorName *string `min:"1" type:"string"`

	// The time at which the detector was created.
	CreationTime *time.Time `type:"timestamp"`

	// The time at which the detector was last modified.
	LastModificationTime *time.Time `type:"timestamp"`

	// The status of detector.
	Status *string `type:"string" enum:"AnomalyDetectorStatus"`

	// The detector's tags (https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html).
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalyDetectorSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalyDetectorSummary) GoString() string {
	return s.String()
}

// SetAnomalyDetectorArn sets the AnomalyDetectorArn field's value.
func (s *AnomalyDetectorSummary) SetAnomalyDetectorArn(v string) *AnomalyDetectorSummary {
	s.AnomalyDetectorArn = &v
	return s
}

// SetAnomalyDetectorDescription sets the AnomalyDetectorDescription field's value.
func (s *AnomalyDetectorSummary) SetAnomalyDetectorDescription(v string) *AnomalyDetectorSummary {
	s.AnomalyDetectorDescription = &v
	return s
}

// SetAnomalyDetectorName sets the AnomalyDetectorName field's value.
func (s *AnomalyDetectorSummary) SetAnomalyDetectorName(v string) *AnomalyDetectorSummary {
	s.AnomalyDetectorName = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *AnomalyDetectorSummary) SetCreationTime(v time.Time) *AnomalyDetectorSummary {
	s.CreationTime = &v
	return s
}

// SetLastModificationTime sets the LastModificationTime field's value.
func (s *AnomalyDetectorSummary) SetLastModificationTime(v time.Time) *AnomalyDetectorSummary {
	s.LastModificationTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AnomalyDetectorSummary) SetStatus(v string) *AnomalyDetectorSummary {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AnomalyDetectorSummary) SetTags(v map[string]*string) *AnomalyDetectorSummary {
	s.Tags = v
	return s
}

// A group of anomalous metrics
type AnomalyGroup struct {
	_ struct{} `type:"structure"`

	// The ID of the anomaly group.
	AnomalyGroupId *string `type:"string"`

	// The severity score of the group.
	AnomalyGroupScore *float64 `type:"double"`

	// The end time for the group.
	EndTime *string `type:"string"`

	// A list of measures affected by the anomaly.
	MetricLevelImpactList []*MetricLevelImpact `type:"list"`

	// The name of the primary affected measure for the group.
	PrimaryMetricName *string `type:"string"`

	// The start time for the group.
	StartTime *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalyGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalyGroup) GoString() string {
	return s.String()
}

// SetAnomalyGroupId sets the AnomalyGroupId field's value.
func (s *AnomalyGroup) SetAnomalyGroupId(v string) *AnomalyGroup {
	s.AnomalyGroupId = &v
	return s
}

// SetAnomalyGroupScore sets the AnomalyGroupScore field's value.
func (s *AnomalyGroup) SetAnomalyGroupScore(v float64) *AnomalyGroup {
	s.AnomalyGroupScore = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *AnomalyGroup) SetEndTime(v string) *AnomalyGroup {
	s.EndTime = &v
	return s
}

// SetMetricLevelImpactList sets the MetricLevelImpactList field's value.
func (s *AnomalyGroup) SetMetricLevelImpactList(v []*MetricLevelImpact) *AnomalyGroup {
	s.MetricLevelImpactList = v
	return s
}

// SetPrimaryMetricName sets the PrimaryMetricName field's value.
func (s *AnomalyGroup) SetPrimaryMetricName(v string) *AnomalyGroup {
	s.PrimaryMetricName = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *AnomalyGroup) SetStartTime(v string) *AnomalyGroup {
	s.StartTime = &v
	return s
}

// Aggregated statistics for a group of anomalous metrics.
type AnomalyGroupStatistics struct {
	_ struct{} `type:"structure"`

	// The start of the time range that was searched.
	EvaluationStartDate *string `type:"string"`

	// Statistics for individual metrics within the group.
	ItemizedMetricStatsList []*ItemizedMetricStats `type:"list"`

	// The number of groups found.
	TotalCount *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalyGroupStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalyGroupStatistics) GoString() string {
	return s.String()
}

// SetEvaluationStartDate sets the EvaluationStartDate field's value.
func (s *AnomalyGroupStatistics) SetEvaluationStartDate(v string) *AnomalyGroupStatistics {
	s.EvaluationStartDate = &v
	return s
}

// SetItemizedMetricStatsList sets the ItemizedMetricStatsList field's value.
func (s *AnomalyGroupStatistics) SetItemizedMetricStatsList(v []*ItemizedMetricStats) *AnomalyGroupStatistics {
	s.ItemizedMetricStatsList = v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *AnomalyGroupStatistics) SetTotalCount(v int64) *AnomalyGroupStatistics {
	s.TotalCount = &v
	return s
}

// Details about a group of anomalous metrics.
type AnomalyGroupSummary struct {
	_ struct{} `type:"structure"`

	// The ID of the anomaly group.
	AnomalyGroupId *string `type:"string"`

	// The severity score of the group.
	AnomalyGroupScore *float64 `type:"double"`

	// The end time for the group.
	EndTime *string `type:"string"`

	// The name of the primary affected measure for the group.
	PrimaryMetricName *string `type:"string"`

	// The start time for the group.
	StartTime *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalyGroupSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalyGroupSummary) GoString() string {
	return s.String()
}

// SetAnomalyGroupId sets the AnomalyGroupId field's value.
func (s *AnomalyGroupSummary) SetAnomalyGroupId(v string) *AnomalyGroupSummary {
	s.AnomalyGroupId = &v
	return s
}

// SetAnomalyGroupScore sets the AnomalyGroupScore field's value.
func (s *AnomalyGroupSummary) SetAnomalyGroupScore(v float64) *AnomalyGroupSummary {
	s.AnomalyGroupScore = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *AnomalyGroupSummary) SetEndTime(v string) *AnomalyGroupSummary {
	s.EndTime = &v
	return s
}

// SetPrimaryMetricName sets the PrimaryMetricName field's value.
func (s *AnomalyGroupSummary) SetPrimaryMetricName(v string) *AnomalyGroupSummary {
	s.PrimaryMetricName = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *AnomalyGroupSummary) SetStartTime(v string) *AnomalyGroupSummary {
	s.StartTime = &v
	return s
}

// An anomalous metric in an anomaly group.
type AnomalyGroupTimeSeries struct {
	_ struct{} `type:"structure"`

	// The ID of the anomaly group.
	//
	// AnomalyGroupId is a required field
	AnomalyGroupId *string `type:"string" required:"true"`

	// The ID of the metric.
	TimeSeriesId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalyGroupTimeSeries) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalyGroupTimeSeries) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnomalyGroupTimeSeries) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnomalyGroupTimeSeries"}
	if s.AnomalyGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("AnomalyGroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnomalyGroupId sets the AnomalyGroupId field's value.
func (s *AnomalyGroupTimeSeries) SetAnomalyGroupId(v string) *AnomalyGroupTimeSeries {
	s.AnomalyGroupId = &v
	return s
}

// SetTimeSeriesId sets the TimeSeriesId field's value.
func (s *AnomalyGroupTimeSeries) SetTimeSeriesId(v string) *AnomalyGroupTimeSeries {
	s.TimeSeriesId = &v
	return s
}

// Feedback for an anomalous metric.
type AnomalyGroupTimeSeriesFeedback struct {
	_ struct{} `type:"structure"`

	// The ID of the anomaly group.
	//
	// AnomalyGroupId is a required field
	AnomalyGroupId *string `type:"string" required:"true"`

	// Feedback on whether the metric is a legitimate anomaly.
	//
	// IsAnomaly is a required field
	IsAnomaly *bool `type:"boolean" required:"true"`

	// The ID of the metric.
	//
	// TimeSeriesId is a required field
	TimeSeriesId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalyGroupTimeSeriesFeedback) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalyGroupTimeSeriesFeedback) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnomalyGroupTimeSeriesFeedback) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnomalyGroupTimeSeriesFeedback"}
	if s.AnomalyGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("AnomalyGroupId"))
	}
	if s.IsAnomaly == nil {
		invalidParams.Add(request.NewErrParamRequired("IsAnomaly"))
	}
	if s.TimeSeriesId == nil {
		invalidParams.Add(request.NewErrParamRequired("TimeSeriesId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnomalyGroupId sets the AnomalyGroupId field's value.
func (s *AnomalyGroupTimeSeriesFeedback) SetAnomalyGroupId(v string) *AnomalyGroupTimeSeriesFeedback {
	s.AnomalyGroupId = &v
	return s
}

// SetIsAnomaly sets the IsAnomaly field's value.
func (s *AnomalyGroupTimeSeriesFeedback) SetIsAnomaly(v bool) *AnomalyGroupTimeSeriesFeedback {
	s.IsAnomaly = &v
	return s
}

// SetTimeSeriesId sets the TimeSeriesId field's value.
func (s *AnomalyGroupTimeSeriesFeedback) SetTimeSeriesId(v string) *AnomalyGroupTimeSeriesFeedback {
	s.TimeSeriesId = &v
	return s
}

// Details about an Amazon AppFlow flow datasource.
type AppFlowConfig struct {
	_ struct{} `type:"structure"`

	// name of the flow.
	//
	// FlowName is a required field
	FlowName *string `type:"string" required:"true"`

	// An IAM role that gives Amazon Lookout for Metrics permission to access the
	// flow.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppFlowConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppFlowConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AppFlowConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AppFlowConfig"}
	if s.FlowName == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowName"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowName sets the FlowName field's value.
func (s *AppFlowConfig) SetFlowName(v string) *AppFlowConfig {
	s.FlowName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *AppFlowConfig) SetRoleArn(v string) *AppFlowConfig {
	s.RoleArn = &v
	return s
}

type BackTestAnomalyDetectorInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the anomaly detector.
	//
	// AnomalyDetectorArn is a required field
	AnomalyDetectorArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BackTestAnomalyDetectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BackTestAnomalyDetectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BackTestAnomalyDetectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BackTestAnomalyDetectorInput"}
	if s.AnomalyDetectorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AnomalyDetectorArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnomalyDetectorArn sets the AnomalyDetectorArn field's value.
func (s *BackTestAnomalyDetectorInput) SetAnomalyDetectorArn(v string) *BackTestAnomalyDetectorInput {
	s.AnomalyDetectorArn = &v
	return s
}

type BackTestAnomalyDetectorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BackTestAnomalyDetectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BackTestAnomalyDetectorOutput) GoString() string {
	return s.String()
}

// Details about an Amazon CloudWatch datasource.
type CloudWatchConfig struct {
	_ struct{} `type:"structure"`

	// An IAM role that gives Amazon Lookout for Metrics permission to access data
	// in Amazon CloudWatch.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudWatchConfig"}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoleArn sets the RoleArn field's value.
func (s *CloudWatchConfig) SetRoleArn(v string) *CloudWatchConfig {
	s.RoleArn = &v
	return s
}

// There was a conflict processing the request. Try your request again.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The ID of the resource.
	ResourceId *string `type:"string"`

	// The type of the resource.
	ResourceType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Details about dimensions that contributed to an anomaly.
type ContributionMatrix struct {
	_ struct{} `type:"structure"`

	// A list of contributing dimensions.
	DimensionContributionList []*DimensionContribution `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContributionMatrix) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContributionMatrix) GoString() string {
	return s.String()
}

// SetDimensionContributionList sets the DimensionContributionList field's value.
func (s *ContributionMatrix) SetDimensionContributionList(v []*DimensionContribution) *ContributionMatrix {
	s.DimensionContributionList = v
	return s
}

type CreateAlertInput struct {
	_ struct{} `type:"structure"`

	// Action that will be triggered when there is an alert.
	//
	// Action is a required field
	Action *Action `type:"structure" required:"true"`

	// A description of the alert.
	AlertDescription *string `type:"string"`

	// The name of the alert.
	//
	// AlertName is a required field
	AlertName *string `min:"1" type:"string" required:"true"`

	// An integer from 0 to 100 specifying the alert sensitivity threshold.
	//
	// AlertSensitivityThreshold is a required field
	AlertSensitivityThreshold *int64 `type:"integer" required:"true"`

	// The ARN of the detector to which the alert is attached.
	//
	// AnomalyDetectorArn is a required field
	AnomalyDetectorArn *string `type:"string" required:"true"`

	// A list of tags (https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html)
	// to apply to the alert.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAlertInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAlertInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAlertInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAlertInput"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.AlertName == nil {
		invalidParams.Add(request.NewErrParamRequired("AlertName"))
	}
	if s.AlertName != nil && len(*s.AlertName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AlertName", 1))
	}
	if s.AlertSensitivityThreshold == nil {
		invalidParams.Add(request.NewErrParamRequired("AlertSensitivityThreshold"))
	}
	if s.AnomalyDetectorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AnomalyDetectorArn"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Action != nil {
		if err := s.Action.Validate(); err != nil {
			invalidParams.AddNested("Action", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *CreateAlertInput) SetAction(v *Action) *CreateAlertInput {
	s.Action = v
	return s
}

// SetAlertDescription sets the AlertDescription field's value.
func (s *CreateAlertInput) SetAlertDescription(v string) *CreateAlertInput {
	s.AlertDescription = &v
	return s
}

// SetAlertName sets the AlertName field's value.
func (s *CreateAlertInput) SetAlertName(v string) *CreateAlertInput {
	s.AlertName = &v
	return s
}

// SetAlertSensitivityThreshold sets the AlertSensitivityThreshold field's value.
func (s *CreateAlertInput) SetAlertSensitivityThreshold(v int64) *CreateAlertInput {
	s.AlertSensitivityThreshold = &v
	return s
}

// SetAnomalyDetectorArn sets the AnomalyDetectorArn field's value.
func (s *CreateAlertInput) SetAnomalyDetectorArn(v string) *CreateAlertInput {
	s.AnomalyDetectorArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAlertInput) SetTags(v map[string]*string) *CreateAlertInput {
	s.Tags = v
	return s
}

type CreateAlertOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the alert.
	AlertArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAlertOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAlertOutput) GoString() string {
	return s.String()
}

// SetAlertArn sets the AlertArn field's value.
func (s *CreateAlertOutput) SetAlertArn(v string) *CreateAlertOutput {
	s.AlertArn = &v
	return s
}

type CreateAnomalyDetectorInput struct {
	_ struct{} `type:"structure"`

	// Contains information about the configuration of the anomaly detector.
	//
	// AnomalyDetectorConfig is a required field
	AnomalyDetectorConfig *AnomalyDetectorConfig `type:"structure" required:"true"`

	// A description of the detector.
	AnomalyDetectorDescription *string `min:"1" type:"string"`

	// The name of the detector.
	//
	// AnomalyDetectorName is a required field
	AnomalyDetectorName *string `min:"1" type:"string" required:"true"`

	// The ARN of the KMS key to use to encrypt your data.
	KmsKeyArn *string `min:"20" type:"string"`

	// A list of tags (https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html)
	// to apply to the anomaly detector.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAnomalyDetectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAnomalyDetectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAnomalyDetectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAnomalyDetectorInput"}
	if s.AnomalyDetectorConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("AnomalyDetectorConfig"))
	}
	if s.AnomalyDetectorDescription != nil && len(*s.AnomalyDetectorDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AnomalyDetectorDescription", 1))
	}
	if s.AnomalyDetectorName == nil {
		invalidParams.Add(request.NewErrParamRequired("AnomalyDetectorName"))
	}
	if s.AnomalyDetectorName != nil && len(*s.AnomalyDetectorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AnomalyDetectorName", 1))
	}
	if s.KmsKeyArn != nil && len(*s.KmsKeyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyArn", 20))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnomalyDetectorConfig sets the AnomalyDetectorConfig field's value.
func (s *CreateAnomalyDetectorInput) SetAnomalyDetectorConfig(v *AnomalyDetectorConfig) *CreateAnomalyDetectorInput {
	s.AnomalyDetectorConfig = v
	return s
}

// SetAnomalyDetectorDescription sets the AnomalyDetectorDescription field's value.
func (s *CreateAnomalyDetectorInput) SetAnomalyDetectorDescription(v string) *CreateAnomalyDetectorInput {
	s.AnomalyDetectorDescription = &v
	return s
}

// SetAnomalyDetectorName sets the AnomalyDetectorName field's value.
func (s *CreateAnomalyDetectorInput) SetAnomalyDetectorName(v string) *CreateAnomalyDetectorInput {
	s.AnomalyDetectorName = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *CreateAnomalyDetectorInput) SetKmsKeyArn(v string) *CreateAnomalyDetectorInput {
	s.KmsKeyArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAnomalyDetectorInput) SetTags(v map[string]*string) *CreateAnomalyDetectorInput {
	s.Tags = v
	return s
}

type CreateAnomalyDetectorOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the detector.
	AnomalyDetectorArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAnomalyDetectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAnomalyDetectorOutput) GoString() string {
	return s.String()
}

// SetAnomalyDetectorArn sets the AnomalyDetectorArn field's value.
func (s *CreateAnomalyDetectorOutput) SetAnomalyDetectorArn(v string) *CreateAnomalyDetectorOutput {
	s.AnomalyDetectorArn = &v
	return s
}

type CreateMetricSetInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the anomaly detector that will use the dataset.
	//
	// AnomalyDetectorArn is a required field
	AnomalyDetectorArn *string `type:"string" required:"true"`

	// A list of the fields you want to treat as dimensions.
	DimensionList []*string `min:"1" type:"list"`

	// A list of metrics that the dataset will contain.
	//
	// MetricList is a required field
	MetricList []*Metric `min:"1" type:"list" required:"true"`

	// A description of the dataset you are creating.
	MetricSetDescription *string `min:"1" type:"string"`

	// The frequency with which the source data will be analyzed for anomalies.
	MetricSetFrequency *string `type:"string" enum:"Frequency"`

	// The name of the dataset.
	//
	// MetricSetName is a required field
	MetricSetName *string `min:"1" type:"string" required:"true"`

	// Contains information about how the source data should be interpreted.
	//
	// MetricSource is a required field
	MetricSource *MetricSource `type:"structure" required:"true"`

	// After an interval ends, the amount of seconds that the detector waits before
	// importing data. Offset is only supported for S3 and Redshift datasources.
	Offset *int64 `type:"integer"`

	// A list of tags (https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html)
	// to apply to the dataset.
	Tags map[string]*string `min:"1" type:"map"`

	// Contains information about the column used for tracking time in your source
	// data.
	TimestampColumn *TimestampColumn `type:"structure"`

	// The time zone in which your source data was recorded.
	Timezone *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMetricSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMetricSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMetricSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMetricSetInput"}
	if s.AnomalyDetectorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AnomalyDetectorArn"))
	}
	if s.DimensionList != nil && len(s.DimensionList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DimensionList", 1))
	}
	if s.MetricList == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricList"))
	}
	if s.MetricList != nil && len(s.MetricList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricList", 1))
	}
	if s.MetricSetDescription != nil && len(*s.MetricSetDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricSetDescription", 1))
	}
	if s.MetricSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricSetName"))
	}
	if s.MetricSetName != nil && len(*s.MetricSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricSetName", 1))
	}
	if s.MetricSource == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricSource"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.MetricList != nil {
		for i, v := range s.MetricList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MetricList", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.MetricSource != nil {
		if err := s.MetricSource.Validate(); err != nil {
			invalidParams.AddNested("MetricSource", err.(request.ErrInvalidParams))
		}
	}
	if s.TimestampColumn != nil {
		if err := s.TimestampColumn.Validate(); err != nil {
			invalidParams.AddNested("TimestampColumn", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnomalyDetectorArn sets the AnomalyDetectorArn field's value.
func (s *CreateMetricSetInput) SetAnomalyDetectorArn(v string) *CreateMetricSetInput {
	s.AnomalyDetectorArn = &v
	return s
}

// SetDimensionList sets the DimensionList field's value.
func (s *CreateMetricSetInput) SetDimensionList(v []*string) *CreateMetricSetInput {
	s.DimensionList = v
	return s
}

// SetMetricList sets the MetricList field's value.
func (s *CreateMetricSetInput) SetMetricList(v []*Metric) *CreateMetricSetInput {
	s.MetricList = v
	return s
}

// SetMetricSetDescription sets the MetricSetDescription field's value.
func (s *CreateMetricSetInput) SetMetricSetDescription(v string) *CreateMetricSetInput {
	s.MetricSetDescription = &v
	return s
}

// SetMetricSetFrequency sets the MetricSetFrequency field's value.
func (s *CreateMetricSetInput) SetMetricSetFrequency(v string) *CreateMetricSetInput {
	s.MetricSetFrequency = &v
	return s
}

// SetMetricSetName sets the MetricSetName field's value.
func (s *CreateMetricSetInput) SetMetricSetName(v string) *CreateMetricSetInput {
	s.MetricSetName = &v
	return s
}

// SetMetricSource sets the MetricSource field's value.
func (s *CreateMetricSetInput) SetMetricSource(v *MetricSource) *CreateMetricSetInput {
	s.MetricSource = v
	return s
}

// SetOffset sets the Offset field's value.
func (s *CreateMetricSetInput) SetOffset(v int64) *CreateMetricSetInput {
	s.Offset = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateMetricSetInput) SetTags(v map[string]*string) *CreateMetricSetInput {
	s.Tags = v
	return s
}

// SetTimestampColumn sets the TimestampColumn field's value.
func (s *CreateMetricSetInput) SetTimestampColumn(v *TimestampColumn) *CreateMetricSetInput {
	s.TimestampColumn = v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *CreateMetricSetInput) SetTimezone(v string) *CreateMetricSetInput {
	s.Timezone = &v
	return s
}

type CreateMetricSetOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the dataset.
	MetricSetArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMetricSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMetricSetOutput) GoString() string {
	return s.String()
}

// SetMetricSetArn sets the MetricSetArn field's value.
func (s *CreateMetricSetOutput) SetMetricSetArn(v string) *CreateMetricSetOutput {
	s.MetricSetArn = &v
	return s
}

// Contains information about how a source CSV data file should be analyzed.
type CsvFormatDescriptor struct {
	_ struct{} `type:"structure"`

	// The character set in which the source CSV file is written.
	Charset *string `type:"string"`

	// Whether or not the source CSV file contains a header.
	ContainsHeader *bool `type:"boolean"`

	// The character used to delimit the source CSV file.
	Delimiter *string `type:"string"`

	// The level of compression of the source CSV file.
	FileCompression *string `type:"string" enum:"CSVFileCompression"`

	// A list of the source CSV file's headers, if any.
	HeaderList []*string `type:"list"`

	// The character used as a quote character.
	QuoteSymbol *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CsvFormatDescriptor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CsvFormatDescriptor) GoString() string {
	return s.String()
}

// SetCharset sets the Charset field's value.
func (s *CsvFormatDescriptor) SetCharset(v string) *CsvFormatDescriptor {
	s.Charset = &v
	return s
}

// SetContainsHeader sets the ContainsHeader field's value.
func (s *CsvFormatDescriptor) SetContainsHeader(v bool) *CsvFormatDescriptor {
	s.ContainsHeader = &v
	return s
}

// SetDelimiter sets the Delimiter field's value.
func (s *CsvFormatDescriptor) SetDelimiter(v string) *CsvFormatDescriptor {
	s.Delimiter = &v
	return s
}

// SetFileCompression sets the FileCompression field's value.
func (s *CsvFormatDescriptor) SetFileCompression(v string) *CsvFormatDescriptor {
	s.FileCompression = &v
	return s
}

// SetHeaderList sets the HeaderList field's value.
func (s *CsvFormatDescriptor) SetHeaderList(v []*string) *CsvFormatDescriptor {
	s.HeaderList = v
	return s
}

// SetQuoteSymbol sets the QuoteSymbol field's value.
func (s *CsvFormatDescriptor) SetQuoteSymbol(v string) *CsvFormatDescriptor {
	s.QuoteSymbol = &v
	return s
}

type DeleteAlertInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the alert to delete.
	//
	// AlertArn is a required field
	AlertArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAlertInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAlertInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAlertInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAlertInput"}
	if s.AlertArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AlertArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlertArn sets the AlertArn field's value.
func (s *DeleteAlertInput) SetAlertArn(v string) *DeleteAlertInput {
	s.AlertArn = &v
	return s
}

type DeleteAlertOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAlertOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAlertOutput) GoString() string {
	return s.String()
}

type DeleteAnomalyDetectorInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the detector to delete.
	//
	// AnomalyDetectorArn is a required field
	AnomalyDetectorArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAnomalyDetectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAnomalyDetectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAnomalyDetectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAnomalyDetectorInput"}
	if s.AnomalyDetectorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AnomalyDetectorArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnomalyDetectorArn sets the AnomalyDetectorArn field's value.
func (s *DeleteAnomalyDetectorInput) SetAnomalyDetectorArn(v string) *DeleteAnomalyDetectorInput {
	s.AnomalyDetectorArn = &v
	return s
}

type DeleteAnomalyDetectorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAnomalyDetectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAnomalyDetectorOutput) GoString() string {
	return s.String()
}

type DescribeAlertInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the alert to describe.
	//
	// AlertArn is a required field
	AlertArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAlertInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAlertInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAlertInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAlertInput"}
	if s.AlertArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AlertArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlertArn sets the AlertArn field's value.
func (s *DescribeAlertInput) SetAlertArn(v string) *DescribeAlertInput {
	s.AlertArn = &v
	return s
}

type DescribeAlertOutput struct {
	_ struct{} `type:"structure"`

	// Contains information about an alert.
	Alert *Alert `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAlertOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAlertOutput) GoString() string {
	return s.String()
}

// SetAlert sets the Alert field's value.
func (s *DescribeAlertOutput) SetAlert(v *Alert) *DescribeAlertOutput {
	s.Alert = v
	return s
}

type DescribeAnomalyDetectionExecutionsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the anomaly detector.
	//
	// AnomalyDetectorArn is a required field
	AnomalyDetectorArn *string `type:"string" required:"true"`

	// The number of items to return in the response.
	MaxResults *int64 `min:"1" type:"integer"`

	// Specify the pagination token that's returned by a previous request to retrieve
	// the next page of results.
	NextToken *string `min:"1" type:"string"`

	// The timestamp of the anomaly detection job.
	Timestamp *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAnomalyDetectionExecutionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAnomalyDetectionExecutionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAnomalyDetectionExecutionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAnomalyDetectionExecutionsInput"}
	if s.AnomalyDetectorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AnomalyDetectorArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnomalyDetectorArn sets the AnomalyDetectorArn field's value.
func (s *DescribeAnomalyDetectionExecutionsInput) SetAnomalyDetectorArn(v string) *DescribeAnomalyDetectionExecutionsInput {
	s.AnomalyDetectorArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeAnomalyDetectionExecutionsInput) SetMaxResults(v int64) *DescribeAnomalyDetectionExecutionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAnomalyDetectionExecutionsInput) SetNextToken(v string) *DescribeAnomalyDetectionExecutionsInput {
	s.NextToken = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *DescribeAnomalyDetectionExecutionsInput) SetTimestamp(v string) *DescribeAnomalyDetectionExecutionsInput {
	s.Timestamp = &v
	return s
}

type DescribeAnomalyDetectionExecutionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of detection jobs.
	ExecutionList []*ExecutionStatus `type:"list"`

	// The pagination token that's included if more results are available.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAnomalyDetectionExecutionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAnomalyDetectionExecutionsOutput) GoString() string {
	return s.String()
}

// SetExecutionList sets the ExecutionList field's value.
func (s *DescribeAnomalyDetectionExecutionsOutput) SetExecutionList(v []*ExecutionStatus) *DescribeAnomalyDetectionExecutionsOutput {
	s.ExecutionList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAnomalyDetectionExecutionsOutput) SetNextToken(v string) *DescribeAnomalyDetectionExecutionsOutput {
	s.NextToken = &v
	return s
}

type DescribeAnomalyDetectorInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the detector to describe.
	//
	// AnomalyDetectorArn is a required field
	AnomalyDetectorArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAnomalyDetectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAnomalyDetectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAnomalyDetectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAnomalyDetectorInput"}
	if s.AnomalyDetectorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AnomalyDetectorArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnomalyDetectorArn sets the AnomalyDetectorArn field's value.
func (s *DescribeAnomalyDetectorInput) SetAnomalyDetectorArn(v string) *DescribeAnomalyDetectorInput {
	s.AnomalyDetectorArn = &v
	return s
}

type DescribeAnomalyDetectorOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the detector.
	AnomalyDetectorArn *string `type:"string"`

	// Contains information about the detector's configuration.
	AnomalyDetectorConfig *AnomalyDetectorConfigSummary `type:"structure"`

	// A description of the detector.
	AnomalyDetectorDescription *string `min:"1" type:"string"`

	// The name of the detector.
	AnomalyDetectorName *string `min:"1" type:"string"`

	// The time at which the detector was created.
	CreationTime *time.Time `type:"timestamp"`

	// The reason that the detector failed, if any.
	FailureReason *string `type:"string"`

	// The ARN of the KMS key to use to encrypt your data.
	KmsKeyArn *string `min:"20" type:"string"`

	// The time at which the detector was last modified.
	LastModificationTime *time.Time `type:"timestamp"`

	// The status of the detector.
	Status *string `type:"string" enum:"AnomalyDetectorStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAnomalyDetectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAnomalyDetectorOutput) GoString() string {
	return s.String()
}

// SetAnomalyDetectorArn sets the AnomalyDetectorArn field's value.
func (s *DescribeAnomalyDetectorOutput) SetAnomalyDetectorArn(v string) *DescribeAnomalyDetectorOutput {
	s.AnomalyDetectorArn = &v
	return s
}

// SetAnomalyDetectorConfig sets the AnomalyDetectorConfig field's value.
func (s *DescribeAnomalyDetectorOutput) SetAnomalyDetectorConfig(v *AnomalyDetectorConfigSummary) *DescribeAnomalyDetectorOutput {
	s.AnomalyDetectorConfig = v
	return s
}

// SetAnomalyDetectorDescription sets the AnomalyDetectorDescription field's value.
func (s *DescribeAnomalyDetectorOutput) SetAnomalyDetectorDescription(v string) *DescribeAnomalyDetectorOutput {
	s.AnomalyDetectorDescription = &v
	return s
}

// SetAnomalyDetectorName sets the AnomalyDetectorName field's value.
func (s *DescribeAnomalyDetectorOutput) SetAnomalyDetectorName(v string) *DescribeAnomalyDetectorOutput {
	s.AnomalyDetectorName = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeAnomalyDetectorOutput) SetCreationTime(v time.Time) *DescribeAnomalyDetectorOutput {
	s.CreationTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DescribeAnomalyDetectorOutput) SetFailureReason(v string) *DescribeAnomalyDetectorOutput {
	s.FailureReason = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *DescribeAnomalyDetectorOutput) SetKmsKeyArn(v string) *DescribeAnomalyDetectorOutput {
	s.KmsKeyArn = &v
	return s
}

// SetLastModificationTime sets the LastModificationTime field's value.
func (s *DescribeAnomalyDetectorOutput) SetLastModificationTime(v time.Time) *DescribeAnomalyDetectorOutput {
	s.LastModificationTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeAnomalyDetectorOutput) SetStatus(v string) *DescribeAnomalyDetectorOutput {
	s.Status = &v
	return s
}

type DescribeMetricSetInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the dataset.
	//
	// MetricSetArn is a required field
	MetricSetArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMetricSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMetricSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMetricSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMetricSetInput"}
	if s.MetricSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricSetArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetricSetArn sets the MetricSetArn field's value.
func (s *DescribeMetricSetInput) SetMetricSetArn(v string) *DescribeMetricSetInput {
	s.MetricSetArn = &v
	return s
}

type DescribeMetricSetOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the detector that contains the dataset.
	AnomalyDetectorArn *string `type:"string"`

	// The time at which the dataset was created.
	CreationTime *time.Time `type:"timestamp"`

	// A list of the dimensions chosen for analysis.
	DimensionList []*string `min:"1" type:"list"`

	// The time at which the dataset was last modified.
	LastModificationTime *time.Time `type:"timestamp"`

	// A list of the metrics defined by the dataset.
	MetricList []*Metric `min:"1" type:"list"`

	// The ARN of the dataset.
	MetricSetArn *string `type:"string"`

	// The dataset's description.
	MetricSetDescription *string `min:"1" type:"string"`

	// The interval at which the data will be analyzed for anomalies.
	MetricSetFrequency *string `type:"string" enum:"Frequency"`

	// The name of the dataset.
	MetricSetName *string `min:"1" type:"string"`

	// Contains information about the dataset's source data.
	MetricSource *MetricSource `type:"structure"`

	// The offset in seconds. Only supported for S3 and Redshift datasources.
	Offset *int64 `type:"integer"`

	// Contains information about the column used for tracking time in your source
	// data.
	TimestampColumn *TimestampColumn `type:"structure"`

	// The time zone in which the dataset's data was recorded.
	Timezone *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMetricSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMetricSetOutput) GoString() string {
	return s.String()
}

// SetAnomalyDetectorArn sets the AnomalyDetectorArn field's value.
func (s *DescribeMetricSetOutput) SetAnomalyDetectorArn(v string) *DescribeMetricSetOutput {
	s.AnomalyDetectorArn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeMetricSetOutput) SetCreationTime(v time.Time) *DescribeMetricSetOutput {
	s.CreationTime = &v
	return s
}

// SetDimensionList sets the DimensionList field's value.
func (s *DescribeMetricSetOutput) SetDimensionList(v []*string) *DescribeMetricSetOutput {
	s.DimensionList = v
	return s
}

// SetLastModificationTime sets the LastModificationTime field's value.
func (s *DescribeMetricSetOutput) SetLastModificationTime(v time.Time) *DescribeMetricSetOutput {
	s.LastModificationTime = &v
	return s
}

// SetMetricList sets the MetricList field's value.
func (s *DescribeMetricSetOutput) SetMetricList(v []*Metric) *DescribeMetricSetOutput {
	s.MetricList = v
	return s
}

// SetMetricSetArn sets the MetricSetArn field's value.
func (s *DescribeMetricSetOutput) SetMetricSetArn(v string) *DescribeMetricSetOutput {
	s.MetricSetArn = &v
	return s
}

// SetMetricSetDescription sets the MetricSetDescription field's value.
func (s *DescribeMetricSetOutput) SetMetricSetDescription(v string) *DescribeMetricSetOutput {
	s.MetricSetDescription = &v
	return s
}

// SetMetricSetFrequency sets the MetricSetFrequency field's value.
func (s *DescribeMetricSetOutput) SetMetricSetFrequency(v string) *DescribeMetricSetOutput {
	s.MetricSetFrequency = &v
	return s
}

// SetMetricSetName sets the MetricSetName field's value.
func (s *DescribeMetricSetOutput) SetMetricSetName(v string) *DescribeMetricSetOutput {
	s.MetricSetName = &v
	return s
}

// SetMetricSource sets the MetricSource field's value.
func (s *DescribeMetricSetOutput) SetMetricSource(v *MetricSource) *DescribeMetricSetOutput {
	s.MetricSource = v
	return s
}

// SetOffset sets the Offset field's value.
func (s *DescribeMetricSetOutput) SetOffset(v int64) *DescribeMetricSetOutput {
	s.Offset = &v
	return s
}

// SetTimestampColumn sets the TimestampColumn field's value.
func (s *DescribeMetricSetOutput) SetTimestampColumn(v *TimestampColumn) *DescribeMetricSetOutput {
	s.TimestampColumn = v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *DescribeMetricSetOutput) SetTimezone(v string) *DescribeMetricSetOutput {
	s.Timezone = &v
	return s
}

// Details about a dimension that contributed to an anomaly.
type DimensionContribution struct {
	_ struct{} `type:"structure"`

	// The name of the dimension.
	DimensionName *string `min:"1" type:"string"`

	// A list of dimension values that contributed to the anomaly.
	DimensionValueContributionList []*DimensionValueContribution `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DimensionContribution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DimensionContribution) GoString() string {
	return s.String()
}

// SetDimensionName sets the DimensionName field's value.
func (s *DimensionContribution) SetDimensionName(v string) *DimensionContribution {
	s.DimensionName = &v
	return s
}

// SetDimensionValueContributionList sets the DimensionValueContributionList field's value.
func (s *DimensionContribution) SetDimensionValueContributionList(v []*DimensionValueContribution) *DimensionContribution {
	s.DimensionValueContributionList = v
	return s
}

// A dimension name and value.
type DimensionNameValue struct {
	_ struct{} `type:"structure"`

	// The name of the dimension.
	//
	// DimensionName is a required field
	DimensionName *string `min:"1" type:"string" required:"true"`

	// The value of the dimension.
	//
	// DimensionValue is a required field
	DimensionValue *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DimensionNameValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DimensionNameValue) GoString() string {
	return s.String()
}

// SetDimensionName sets the DimensionName field's value.
func (s *DimensionNameValue) SetDimensionName(v string) *DimensionNameValue {
	s.DimensionName = &v
	return s
}

// SetDimensionValue sets the DimensionValue field's value.
func (s *DimensionNameValue) SetDimensionValue(v string) *DimensionNameValue {
	s.DimensionValue = &v
	return s
}

// The severity of a value of a dimension that contributed to an anomaly.
type DimensionValueContribution struct {
	_ struct{} `type:"structure"`

	// The severity score of the value.
	ContributionScore *float64 `type:"double"`

	// The value of the dimension.
	DimensionValue *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DimensionValueContribution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DimensionValueContribution) GoString() string {
	return s.String()
}

// SetContributionScore sets the ContributionScore field's value.
func (s *DimensionValueContribution) SetContributionScore(v float64) *DimensionValueContribution {
	s.ContributionScore = &v
	return s
}

// SetDimensionValue sets the DimensionValue field's value.
func (s *DimensionValueContribution) SetDimensionValue(v string) *DimensionValueContribution {
	s.DimensionValue = &v
	return s
}

// The status of an anomaly detector run.
type ExecutionStatus struct {
	_ struct{} `type:"structure"`

	// The reason that the run failed, if applicable.
	FailureReason *string `min:"1" type:"string"`

	// The run's status.
	Status *string `type:"string" enum:"AnomalyDetectionTaskStatus"`

	// The run's timestamp.
	Timestamp *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecutionStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecutionStatus) GoString() string {
	return s.String()
}

// SetFailureReason sets the FailureReason field's value.
func (s *ExecutionStatus) SetFailureReason(v string) *ExecutionStatus {
	s.FailureReason = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ExecutionStatus) SetStatus(v string) *ExecutionStatus {
	s.Status = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *ExecutionStatus) SetTimestamp(v string) *ExecutionStatus {
	s.Timestamp = &v
	return s
}

// Contains information about a source file's formatting.
type FileFormatDescriptor struct {
	_ struct{} `type:"structure"`

	// Contains information about how a source CSV data file should be analyzed.
	CsvFormatDescriptor *CsvFormatDescriptor `type:"structure"`

	// Contains information about how a source JSON data file should be analyzed.
	JsonFormatDescriptor *JsonFormatDescriptor `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FileFormatDescriptor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FileFormatDescriptor) GoString() string {
	return s.String()
}

// SetCsvFormatDescriptor sets the CsvFormatDescriptor field's value.
func (s *FileFormatDescriptor) SetCsvFormatDescriptor(v *CsvFormatDescriptor) *FileFormatDescriptor {
	s.CsvFormatDescriptor = v
	return s
}

// SetJsonFormatDescriptor sets the JsonFormatDescriptor field's value.
func (s *FileFormatDescriptor) SetJsonFormatDescriptor(v *JsonFormatDescriptor) *FileFormatDescriptor {
	s.JsonFormatDescriptor = v
	return s
}

type GetAnomalyGroupInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the anomaly detector.
	//
	// AnomalyDetectorArn is a required field
	AnomalyDetectorArn *string `type:"string" required:"true"`

	// The ID of the anomaly group.
	//
	// AnomalyGroupId is a required field
	AnomalyGroupId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnomalyGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnomalyGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAnomalyGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAnomalyGroupInput"}
	if s.AnomalyDetectorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AnomalyDetectorArn"))
	}
	if s.AnomalyGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("AnomalyGroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnomalyDetectorArn sets the AnomalyDetectorArn field's value.
func (s *GetAnomalyGroupInput) SetAnomalyDetectorArn(v string) *GetAnomalyGroupInput {
	s.AnomalyDetectorArn = &v
	return s
}

// SetAnomalyGroupId sets the AnomalyGroupId field's value.
func (s *GetAnomalyGroupInput) SetAnomalyGroupId(v string) *GetAnomalyGroupInput {
	s.AnomalyGroupId = &v
	return s
}

type GetAnomalyGroupOutput struct {
	_ struct{} `type:"structure"`

	// Details about the anomaly group.
	AnomalyGroup *AnomalyGroup `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnomalyGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnomalyGroupOutput) GoString() string {
	return s.String()
}

// SetAnomalyGroup sets the AnomalyGroup field's value.
func (s *GetAnomalyGroupOutput) SetAnomalyGroup(v *AnomalyGroup) *GetAnomalyGroupOutput {
	s.AnomalyGroup = v
	return s
}

type GetFeedbackInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the anomaly detector.
	//
	// AnomalyDetectorArn is a required field
	AnomalyDetectorArn *string `type:"string" required:"true"`

	// The anomalous metric and group ID.
	//
	// AnomalyGroupTimeSeriesFeedback is a required field
	AnomalyGroupTimeSeriesFeedback *AnomalyGroupTimeSeries `type:"structure" required:"true"`

	// The maximum number of results to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// Specify the pagination token that's returned by a previous request to retrieve
	// the next page of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFeedbackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFeedbackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFeedbackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFeedbackInput"}
	if s.AnomalyDetectorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AnomalyDetectorArn"))
	}
	if s.AnomalyGroupTimeSeriesFeedback == nil {
		invalidParams.Add(request.NewErrParamRequired("AnomalyGroupTimeSeriesFeedback"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.AnomalyGroupTimeSeriesFeedback != nil {
		if err := s.AnomalyGroupTimeSeriesFeedback.Validate(); err != nil {
			invalidParams.AddNested("AnomalyGroupTimeSeriesFeedback", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnomalyDetectorArn sets the AnomalyDetectorArn field's value.
func (s *GetFeedbackInput) SetAnomalyDetectorArn(v string) *GetFeedbackInput {
	s.AnomalyDetectorArn = &v
	return s
}

// SetAnomalyGroupTimeSeriesFeedback sets the AnomalyGroupTimeSeriesFeedback field's value.
func (s *GetFeedbackInput) SetAnomalyGroupTimeSeriesFeedback(v *AnomalyGroupTimeSeries) *GetFeedbackInput {
	s.AnomalyGroupTimeSeriesFeedback = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetFeedbackInput) SetMaxResults(v int64) *GetFeedbackInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetFeedbackInput) SetNextToken(v string) *GetFeedbackInput {
	s.NextToken = &v
	return s
}

type GetFeedbackOutput struct {
	_ struct{} `type:"structure"`

	// Feedback for an anomalous metric.
	AnomalyGroupTimeSeriesFeedback []*TimeSeriesFeedback `type:"list"`

	// The pagination token that's included if more results are available.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFeedbackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFeedbackOutput) GoString() string {
	return s.String()
}

// SetAnomalyGroupTimeSeriesFeedback sets the AnomalyGroupTimeSeriesFeedback field's value.
func (s *GetFeedbackOutput) SetAnomalyGroupTimeSeriesFeedback(v []*TimeSeriesFeedback) *GetFeedbackOutput {
	s.AnomalyGroupTimeSeriesFeedback = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetFeedbackOutput) SetNextToken(v string) *GetFeedbackOutput {
	s.NextToken = &v
	return s
}

type GetSampleDataInput struct {
	_ struct{} `type:"structure"`

	// A datasource bucket in Amazon S3.
	S3SourceConfig *SampleDataS3SourceConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSampleDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSampleDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSampleDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSampleDataInput"}
	if s.S3SourceConfig != nil {
		if err := s.S3SourceConfig.Validate(); err != nil {
			invalidParams.AddNested("S3SourceConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3SourceConfig sets the S3SourceConfig field's value.
func (s *GetSampleDataInput) SetS3SourceConfig(v *SampleDataS3SourceConfig) *GetSampleDataInput {
	s.S3SourceConfig = v
	return s
}

type GetSampleDataOutput struct {
	_ struct{} `type:"structure"`

	// A list of header labels for the records.
	HeaderValues []*string `type:"list"`

	// A list of records.
	SampleRows [][]*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSampleDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSampleDataOutput) GoString() string {
	return s.String()
}

// SetHeaderValues sets the HeaderValues field's value.
func (s *GetSampleDataOutput) SetHeaderValues(v []*string) *GetSampleDataOutput {
	s.HeaderValues = v
	return s
}

// SetSampleRows sets the SampleRows field's value.
func (s *GetSampleDataOutput) SetSampleRows(v [][]*string) *GetSampleDataOutput {
	s.SampleRows = v
	return s
}

// Aggregated details about the measures contributing to the anomaly group,
// and the measures potentially impacted by the anomaly group.
type InterMetricImpactDetails struct {
	_ struct{} `type:"structure"`

	// The ID of the anomaly group.
	AnomalyGroupId *string `type:"string"`

	// For potential causes (CAUSE_OF_INPUT_ANOMALY_GROUP), the percentage contribution
	// the measure has in causing the anomalies.
	ContributionPercentage *float64 `type:"double"`

	// The name of the measure.
	MetricName *string `type:"string"`

	// Whether a measure is a potential cause of the anomaly group (CAUSE_OF_INPUT_ANOMALY_GROUP),
	// or whether the measure is impacted by the anomaly group (EFFECT_OF_INPUT_ANOMALY_GROUP).
	RelationshipType *string `type:"string" enum:"RelationshipType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InterMetricImpactDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InterMetricImpactDetails) GoString() string {
	return s.String()
}

// SetAnomalyGroupId sets the AnomalyGroupId field's value.
func (s *InterMetricImpactDetails) SetAnomalyGroupId(v string) *InterMetricImpactDetails {
	s.AnomalyGroupId = &v
	return s
}

// SetContributionPercentage sets the ContributionPercentage field's value.
func (s *InterMetricImpactDetails) SetContributionPercentage(v float64) *InterMetricImpactDetails {
	s.ContributionPercentage = &v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *InterMetricImpactDetails) SetMetricName(v string) *InterMetricImpactDetails {
	s.MetricName = &v
	return s
}

// SetRelationshipType sets the RelationshipType field's value.
func (s *InterMetricImpactDetails) SetRelationshipType(v string) *InterMetricImpactDetails {
	s.RelationshipType = &v
	return s
}

// The request processing has failed because of an unknown error, exception,
// or failure.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Aggregated statistics about a measure affected by an anomaly.
type ItemizedMetricStats struct {
	_ struct{} `type:"structure"`

	// The name of the measure.
	MetricName *string `min:"1" type:"string"`

	// The number of times that the measure appears.
	OccurrenceCount *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ItemizedMetricStats) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ItemizedMetricStats) GoString() string {
	return s.String()
}

// SetMetricName sets the MetricName field's value.
func (s *ItemizedMetricStats) SetMetricName(v string) *ItemizedMetricStats {
	s.MetricName = &v
	return s
}

// SetOccurrenceCount sets the OccurrenceCount field's value.
func (s *ItemizedMetricStats) SetOccurrenceCount(v int64) *ItemizedMetricStats {
	s.OccurrenceCount = &v
	return s
}

// Contains information about how a source JSON data file should be analyzed.
type JsonFormatDescriptor struct {
	_ struct{} `type:"structure"`

	// The character set in which the source JSON file is written.
	Charset *string `type:"string"`

	// The level of compression of the source CSV file.
	FileCompression *string `type:"string" enum:"JsonFileCompression"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JsonFormatDescriptor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JsonFormatDescriptor) GoString() string {
	return s.String()
}

// SetCharset sets the Charset field's value.
func (s *JsonFormatDescriptor) SetCharset(v string) *JsonFormatDescriptor {
	s.Charset = &v
	return s
}

// SetFileCompression sets the FileCompression field's value.
func (s *JsonFormatDescriptor) SetFileCompression(v string) *JsonFormatDescriptor {
	s.FileCompression = &v
	return s
}

// Contains information about a Lambda configuration.
type LambdaConfiguration struct {
	_ struct{} `type:"structure"`

	// The ARN of the Lambda function.
	//
	// LambdaArn is a required field
	LambdaArn *string `type:"string" required:"true"`

	// The ARN of an IAM role that has permission to invoke the Lambda function.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaConfiguration"}
	if s.LambdaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LambdaArn"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLambdaArn sets the LambdaArn field's value.
func (s *LambdaConfiguration) SetLambdaArn(v string) *LambdaConfiguration {
	s.LambdaArn = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *LambdaConfiguration) SetRoleArn(v string) *LambdaConfiguration {
	s.RoleArn = &v
	return s
}

type ListAlertsInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the alert's detector.
	AnomalyDetectorArn *string `type:"string"`

	// The maximum number of results that will be displayed by the request.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the result of the previous request is truncated, the response includes
	// a NextToken. To retrieve the next set of results, use the token in the next
	// request. Tokens expire after 24 hours.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAlertsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAlertsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAlertsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAlertsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnomalyDetectorArn sets the AnomalyDetectorArn field's value.
func (s *ListAlertsInput) SetAnomalyDetectorArn(v string) *ListAlertsInput {
	s.AnomalyDetectorArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAlertsInput) SetMaxResults(v int64) *ListAlertsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAlertsInput) SetNextToken(v string) *ListAlertsInput {
	s.NextToken = &v
	return s
}

type ListAlertsOutput struct {
	_ struct{} `type:"structure"`

	// Contains information about an alert.
	AlertSummaryList []*AlertSummary `type:"list"`

	// If the response is truncated, the service returns this token. To retrieve
	// the next set of results, use this token in the next request.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAlertsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAlertsOutput) GoString() string {
	return s.String()
}

// SetAlertSummaryList sets the AlertSummaryList field's value.
func (s *ListAlertsOutput) SetAlertSummaryList(v []*AlertSummary) *ListAlertsOutput {
	s.AlertSummaryList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAlertsOutput) SetNextToken(v string) *ListAlertsOutput {
	s.NextToken = &v
	return s
}

type ListAnomalyDetectorsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the result of the previous request was truncated, the response includes
	// a NextToken. To retrieve the next set of results, use the token in the next
	// request. Tokens expire after 24 hours.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnomalyDetectorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnomalyDetectorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAnomalyDetectorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAnomalyDetectorsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAnomalyDetectorsInput) SetMaxResults(v int64) *ListAnomalyDetectorsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAnomalyDetectorsInput) SetNextToken(v string) *ListAnomalyDetectorsInput {
	s.NextToken = &v
	return s
}

type ListAnomalyDetectorsOutput struct {
	_ struct{} `type:"structure"`

	// A list of anomaly detectors in the account in the current region.
	AnomalyDetectorSummaryList []*AnomalyDetectorSummary `type:"list"`

	// If the response is truncated, the service returns this token. To retrieve
	// the next set of results, use the token in the next request.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnomalyDetectorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnomalyDetectorsOutput) GoString() string {
	return s.String()
}

// SetAnomalyDetectorSummaryList sets the AnomalyDetectorSummaryList field's value.
func (s *ListAnomalyDetectorsOutput) SetAnomalyDetectorSummaryList(v []*AnomalyDetectorSummary) *ListAnomalyDetectorsOutput {
	s.AnomalyDetectorSummaryList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAnomalyDetectorsOutput) SetNextToken(v string) *ListAnomalyDetectorsOutput {
	s.NextToken = &v
	return s
}

type ListAnomalyGroupRelatedMetricsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the anomaly detector.
	//
	// AnomalyDetectorArn is a required field
	AnomalyDetectorArn *string `type:"string" required:"true"`

	// The ID of the anomaly group.
	//
	// AnomalyGroupId is a required field
	AnomalyGroupId *string `type:"string" required:"true"`

	// The maximum number of results to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// Specify the pagination token that's returned by a previous request to retrieve
	// the next page of results.
	NextToken *string `min:"1" type:"string"`

	// Filter for potential causes (CAUSE_OF_INPUT_ANOMALY_GROUP) or downstream
	// effects (EFFECT_OF_INPUT_ANOMALY_GROUP) of the anomaly group.
	RelationshipTypeFilter *string `type:"string" enum:"RelationshipType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnomalyGroupRelatedMetricsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnomalyGroupRelatedMetricsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAnomalyGroupRelatedMetricsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAnomalyGroupRelatedMetricsInput"}
	if s.AnomalyDetectorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AnomalyDetectorArn"))
	}
	if s.AnomalyGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("AnomalyGroupId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnomalyDetectorArn sets the AnomalyDetectorArn field's value.
func (s *ListAnomalyGroupRelatedMetricsInput) SetAnomalyDetectorArn(v string) *ListAnomalyGroupRelatedMetricsInput {
	s.AnomalyDetectorArn = &v
	return s
}

// SetAnomalyGroupId sets the AnomalyGroupId field's value.
func (s *ListAnomalyGroupRelatedMetricsInput) SetAnomalyGroupId(v string) *ListAnomalyGroupRelatedMetricsInput {
	s.AnomalyGroupId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAnomalyGroupRelatedMetricsInput) SetMaxResults(v int64) *ListAnomalyGroupRelatedMetricsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAnomalyGroupRelatedMetricsInput) SetNextToken(v string) *ListAnomalyGroupRelatedMetricsInput {
	s.NextToken = &v
	return s
}

// SetRelationshipTypeFilter sets the RelationshipTypeFilter field's value.
func (s *ListAnomalyGroupRelatedMetricsInput) SetRelationshipTypeFilter(v string) *ListAnomalyGroupRelatedMetricsInput {
	s.RelationshipTypeFilter = &v
	return s
}

type ListAnomalyGroupRelatedMetricsOutput struct {
	_ struct{} `type:"structure"`

	// Aggregated details about the measures contributing to the anomaly group,
	// and the measures potentially impacted by the anomaly group.
	InterMetricImpactList []*InterMetricImpactDetails `type:"list"`

	// The pagination token that's included if more results are available.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnomalyGroupRelatedMetricsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnomalyGroupRelatedMetricsOutput) GoString() string {
	return s.String()
}

// SetInterMetricImpactList sets the InterMetricImpactList field's value.
func (s *ListAnomalyGroupRelatedMetricsOutput) SetInterMetricImpactList(v []*InterMetricImpactDetails) *ListAnomalyGroupRelatedMetricsOutput {
	s.InterMetricImpactList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAnomalyGroupRelatedMetricsOutput) SetNextToken(v string) *ListAnomalyGroupRelatedMetricsOutput {
	s.NextToken = &v
	return s
}

type ListAnomalyGroupSummariesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the anomaly detector.
	//
	// AnomalyDetectorArn is a required field
	AnomalyDetectorArn *string `type:"string" required:"true"`

	// The maximum number of results to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// Specify the pagination token that's returned by a previous request to retrieve
	// the next page of results.
	NextToken *string `min:"1" type:"string"`

	// The minimum severity score for inclusion in the output.
	//
	// SensitivityThreshold is a required field
	SensitivityThreshold *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnomalyGroupSummariesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnomalyGroupSummariesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAnomalyGroupSummariesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAnomalyGroupSummariesInput"}
	if s.AnomalyDetectorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AnomalyDetectorArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.SensitivityThreshold == nil {
		invalidParams.Add(request.NewErrParamRequired("SensitivityThreshold"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnomalyDetectorArn sets the AnomalyDetectorArn field's value.
func (s *ListAnomalyGroupSummariesInput) SetAnomalyDetectorArn(v string) *ListAnomalyGroupSummariesInput {
	s.AnomalyDetectorArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAnomalyGroupSummariesInput) SetMaxResults(v int64) *ListAnomalyGroupSummariesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAnomalyGroupSummariesInput) SetNextToken(v string) *ListAnomalyGroupSummariesInput {
	s.NextToken = &v
	return s
}

// SetSensitivityThreshold sets the SensitivityThreshold field's value.
func (s *ListAnomalyGroupSummariesInput) SetSensitivityThreshold(v int64) *ListAnomalyGroupSummariesInput {
	s.SensitivityThreshold = &v
	return s
}

type ListAnomalyGroupSummariesOutput struct {
	_ struct{} `type:"structure"`

	// Aggregated details about the anomaly groups.
	AnomalyGroupStatistics *AnomalyGroupStatistics `type:"structure"`

	// A list of anomaly group summaries.
	AnomalyGroupSummaryList []*AnomalyGroupSummary `type:"list"`

	// The pagination token that's included if more results are available.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnomalyGroupSummariesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnomalyGroupSummariesOutput) GoString() string {
	return s.String()
}

// SetAnomalyGroupStatistics sets the AnomalyGroupStatistics field's value.
func (s *ListAnomalyGroupSummariesOutput) SetAnomalyGroupStatistics(v *AnomalyGroupStatistics) *ListAnomalyGroupSummariesOutput {
	s.AnomalyGroupStatistics = v
	return s
}

// SetAnomalyGroupSummaryList sets the AnomalyGroupSummaryList field's value.
func (s *ListAnomalyGroupSummariesOutput) SetAnomalyGroupSummaryList(v []*AnomalyGroupSummary) *ListAnomalyGroupSummariesOutput {
	s.AnomalyGroupSummaryList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAnomalyGroupSummariesOutput) SetNextToken(v string) *ListAnomalyGroupSummariesOutput {
	s.NextToken = &v
	return s
}

type ListAnomalyGroupTimeSeriesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the anomaly detector.
	//
	// AnomalyDetectorArn is a required field
	AnomalyDetectorArn *string `type:"string" required:"true"`

	// The ID of the anomaly group.
	//
	// AnomalyGroupId is a required field
	AnomalyGroupId *string `type:"string" required:"true"`

	// The maximum number of results to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// The name of the measure field.
	//
	// MetricName is a required field
	MetricName *string `type:"string" required:"true"`

	// Specify the pagination token that's returned by a previous request to retrieve
	// the next page of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnomalyGroupTimeSeriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnomalyGroupTimeSeriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAnomalyGroupTimeSeriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAnomalyGroupTimeSeriesInput"}
	if s.AnomalyDetectorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AnomalyDetectorArn"))
	}
	if s.AnomalyGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("AnomalyGroupId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnomalyDetectorArn sets the AnomalyDetectorArn field's value.
func (s *ListAnomalyGroupTimeSeriesInput) SetAnomalyDetectorArn(v string) *ListAnomalyGroupTimeSeriesInput {
	s.AnomalyDetectorArn = &v
	return s
}

// SetAnomalyGroupId sets the AnomalyGroupId field's value.
func (s *ListAnomalyGroupTimeSeriesInput) SetAnomalyGroupId(v string) *ListAnomalyGroupTimeSeriesInput {
	s.AnomalyGroupId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAnomalyGroupTimeSeriesInput) SetMaxResults(v int64) *ListAnomalyGroupTimeSeriesInput {
	s.MaxResults = &v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *ListAnomalyGroupTimeSeriesInput) SetMetricName(v string) *ListAnomalyGroupTimeSeriesInput {
	s.MetricName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAnomalyGroupTimeSeriesInput) SetNextToken(v string) *ListAnomalyGroupTimeSeriesInput {
	s.NextToken = &v
	return s
}

type ListAnomalyGroupTimeSeriesOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the anomaly group.
	AnomalyGroupId *string `type:"string"`

	// The name of the measure field.
	MetricName *string `type:"string"`

	// The pagination token that's included if more results are available.
	NextToken *string `min:"1" type:"string"`

	// A list of anomalous metrics.
	TimeSeriesList []*TimeSeries `type:"list"`

	// Timestamps for the anomalous metrics.
	TimestampList []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnomalyGroupTimeSeriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnomalyGroupTimeSeriesOutput) GoString() string {
	return s.String()
}

// SetAnomalyGroupId sets the AnomalyGroupId field's value.
func (s *ListAnomalyGroupTimeSeriesOutput) SetAnomalyGroupId(v string) *ListAnomalyGroupTimeSeriesOutput {
	s.AnomalyGroupId = &v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *ListAnomalyGroupTimeSeriesOutput) SetMetricName(v string) *ListAnomalyGroupTimeSeriesOutput {
	s.MetricName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAnomalyGroupTimeSeriesOutput) SetNextToken(v string) *ListAnomalyGroupTimeSeriesOutput {
	s.NextToken = &v
	return s
}

// SetTimeSeriesList sets the TimeSeriesList field's value.
func (s *ListAnomalyGroupTimeSeriesOutput) SetTimeSeriesList(v []*TimeSeries) *ListAnomalyGroupTimeSeriesOutput {
	s.TimeSeriesList = v
	return s
}

// SetTimestampList sets the TimestampList field's value.
func (s *ListAnomalyGroupTimeSeriesOutput) SetTimestampList(v []*string) *ListAnomalyGroupTimeSeriesOutput {
	s.TimestampList = v
	return s
}

type ListMetricSetsInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the anomaly detector containing the metrics sets to list.
	AnomalyDetectorArn *string `type:"string"`

	// The maximum number of results to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the result of the previous request was truncated, the response includes
	// a NextToken. To retrieve the next set of results, use the token in the next
	// request. Tokens expire after 24 hours.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMetricSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMetricSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMetricSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMetricSetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnomalyDetectorArn sets the AnomalyDetectorArn field's value.
func (s *ListMetricSetsInput) SetAnomalyDetectorArn(v string) *ListMetricSetsInput {
	s.AnomalyDetectorArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMetricSetsInput) SetMaxResults(v int64) *ListMetricSetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMetricSetsInput) SetNextToken(v string) *ListMetricSetsInput {
	s.NextToken = &v
	return s
}

type ListMetricSetsOutput struct {
	_ struct{} `type:"structure"`

	// A list of the datasets in the AWS Region, with configuration details for
	// each.
	MetricSetSummaryList []*MetricSetSummary `type:"list"`

	// If the response is truncated, the list call returns this token. To retrieve
	// the next set of results, use the token in the next list request.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMetricSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMetricSetsOutput) GoString() string {
	return s.String()
}

// SetMetricSetSummaryList sets the MetricSetSummaryList field's value.
func (s *ListMetricSetsOutput) SetMetricSetSummaryList(v []*MetricSetSummary) *ListMetricSetsOutput {
	s.MetricSetSummaryList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMetricSetsOutput) SetNextToken(v string) *ListMetricSetsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The resource's Amazon Resource Name (ARN).
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The resource's tags.
	Tags map[string]*string `locationName:"Tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// A calculation made by contrasting a measure and a dimension from your source
// data.
type Metric struct {
	_ struct{} `type:"structure"`

	// The function with which the metric is calculated.
	//
	// AggregationFunction is a required field
	AggregationFunction *string `type:"string" required:"true" enum:"AggregationFunction"`

	// The name of the metric.
	//
	// MetricName is a required field
	MetricName *string `min:"1" type:"string" required:"true"`

	// The namespace for the metric.
	Namespace *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Metric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Metric) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Metric) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Metric"}
	if s.AggregationFunction == nil {
		invalidParams.Add(request.NewErrParamRequired("AggregationFunction"))
	}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.MetricName != nil && len(*s.MetricName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricName", 1))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAggregationFunction sets the AggregationFunction field's value.
func (s *Metric) SetAggregationFunction(v string) *Metric {
	s.AggregationFunction = &v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *Metric) SetMetricName(v string) *Metric {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *Metric) SetNamespace(v string) *Metric {
	s.Namespace = &v
	return s
}

// Details about a measure affected by an anomaly.
type MetricLevelImpact struct {
	_ struct{} `type:"structure"`

	// Details about the dimensions that contributed to the anomaly.
	ContributionMatrix *ContributionMatrix `type:"structure"`

	// The name of the measure.
	MetricName *string `type:"string"`

	// The number of anomalous metrics for the measure.
	NumTimeSeries *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricLevelImpact) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricLevelImpact) GoString() string {
	return s.String()
}

// SetContributionMatrix sets the ContributionMatrix field's value.
func (s *MetricLevelImpact) SetContributionMatrix(v *ContributionMatrix) *MetricLevelImpact {
	s.ContributionMatrix = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *MetricLevelImpact) SetMetricName(v string) *MetricLevelImpact {
	s.MetricName = &v
	return s
}

// SetNumTimeSeries sets the NumTimeSeries field's value.
func (s *MetricLevelImpact) SetNumTimeSeries(v int64) *MetricLevelImpact {
	s.NumTimeSeries = &v
	return s
}

// Contains information about a dataset.
type MetricSetSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the detector to which the dataset belongs.
	AnomalyDetectorArn *string `type:"string"`

	// The time at which the dataset was created.
	CreationTime *time.Time `type:"timestamp"`

	// The time at which the dataset was last modified.
	LastModificationTime *time.Time `type:"timestamp"`

	// The ARN of the dataset.
	MetricSetArn *string `type:"string"`

	// The description of the dataset.
	MetricSetDescription *string `min:"1" type:"string"`

	// The name of the dataset.
	MetricSetName *string `min:"1" type:"string"`

	// The dataset's tags (https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html).
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricSetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricSetSummary) GoString() string {
	return s.String()
}

// SetAnomalyDetectorArn sets the AnomalyDetectorArn field's value.
func (s *MetricSetSummary) SetAnomalyDetectorArn(v string) *MetricSetSummary {
	s.AnomalyDetectorArn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *MetricSetSummary) SetCreationTime(v time.Time) *MetricSetSummary {
	s.CreationTime = &v
	return s
}

// SetLastModificationTime sets the LastModificationTime field's value.
func (s *MetricSetSummary) SetLastModificationTime(v time.Time) *MetricSetSummary {
	s.LastModificationTime = &v
	return s
}

// SetMetricSetArn sets the MetricSetArn field's value.
func (s *MetricSetSummary) SetMetricSetArn(v string) *MetricSetSummary {
	s.MetricSetArn = &v
	return s
}

// SetMetricSetDescription sets the MetricSetDescription field's value.
func (s *MetricSetSummary) SetMetricSetDescription(v string) *MetricSetSummary {
	s.MetricSetDescription = &v
	return s
}

// SetMetricSetName sets the MetricSetName field's value.
func (s *MetricSetSummary) SetMetricSetName(v string) *MetricSetSummary {
	s.MetricSetName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *MetricSetSummary) SetTags(v map[string]*string) *MetricSetSummary {
	s.Tags = v
	return s
}

// Contains information about source data used to generate a metric.
type MetricSource struct {
	_ struct{} `type:"structure"`

	// An object containing information about the AppFlow configuration.
	AppFlowConfig *AppFlowConfig `type:"structure"`

	// An object containing information about the Amazon CloudWatch monitoring configuration.
	CloudWatchConfig *CloudWatchConfig `type:"structure"`

	// An object containing information about the Amazon Relational Database Service
	// (RDS) configuration.
	RDSSourceConfig *RDSSourceConfig `type:"structure"`

	// An object containing information about the Amazon Redshift database configuration.
	RedshiftSourceConfig *RedshiftSourceConfig `type:"structure"`

	// Contains information about the configuration of the S3 bucket that contains
	// source files.
	S3SourceConfig *S3SourceConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricSource"}
	if s.AppFlowConfig != nil {
		if err := s.AppFlowConfig.Validate(); err != nil {
			invalidParams.AddNested("AppFlowConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.CloudWatchConfig != nil {
		if err := s.CloudWatchConfig.Validate(); err != nil {
			invalidParams.AddNested("CloudWatchConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.RDSSourceConfig != nil {
		if err := s.RDSSourceConfig.Validate(); err != nil {
			invalidParams.AddNested("RDSSourceConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.RedshiftSourceConfig != nil {
		if err := s.RedshiftSourceConfig.Validate(); err != nil {
			invalidParams.AddNested("RedshiftSourceConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.S3SourceConfig != nil {
		if err := s.S3SourceConfig.Validate(); err != nil {
			invalidParams.AddNested("S3SourceConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppFlowConfig sets the AppFlowConfig field's value.
func (s *MetricSource) SetAppFlowConfig(v *AppFlowConfig) *MetricSource {
	s.AppFlowConfig = v
	return s
}

// SetCloudWatchConfig sets the CloudWatchConfig field's value.
func (s *MetricSource) SetCloudWatchConfig(v *CloudWatchConfig) *MetricSource {
	s.CloudWatchConfig = v
	return s
}

// SetRDSSourceConfig sets the RDSSourceConfig field's value.
func (s *MetricSource) SetRDSSourceConfig(v *RDSSourceConfig) *MetricSource {
	s.RDSSourceConfig = v
	return s
}

// SetRedshiftSourceConfig sets the RedshiftSourceConfig field's value.
func (s *MetricSource) SetRedshiftSourceConfig(v *RedshiftSourceConfig) *MetricSource {
	s.RedshiftSourceConfig = v
	return s
}

// SetS3SourceConfig sets the S3SourceConfig field's value.
func (s *MetricSource) SetS3SourceConfig(v *S3SourceConfig) *MetricSource {
	s.S3SourceConfig = v
	return s
}

type PutFeedbackInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the anomaly detector.
	//
	// AnomalyDetectorArn is a required field
	AnomalyDetectorArn *string `type:"string" required:"true"`

	// Feedback for an anomalous metric.
	//
	// AnomalyGroupTimeSeriesFeedback is a required field
	AnomalyGroupTimeSeriesFeedback *AnomalyGroupTimeSeriesFeedback `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutFeedbackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutFeedbackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutFeedbackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutFeedbackInput"}
	if s.AnomalyDetectorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AnomalyDetectorArn"))
	}
	if s.AnomalyGroupTimeSeriesFeedback == nil {
		invalidParams.Add(request.NewErrParamRequired("AnomalyGroupTimeSeriesFeedback"))
	}
	if s.AnomalyGroupTimeSeriesFeedback != nil {
		if err := s.AnomalyGroupTimeSeriesFeedback.Validate(); err != nil {
			invalidParams.AddNested("AnomalyGroupTimeSeriesFeedback", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnomalyDetectorArn sets the AnomalyDetectorArn field's value.
func (s *PutFeedbackInput) SetAnomalyDetectorArn(v string) *PutFeedbackInput {
	s.AnomalyDetectorArn = &v
	return s
}

// SetAnomalyGroupTimeSeriesFeedback sets the AnomalyGroupTimeSeriesFeedback field's value.
func (s *PutFeedbackInput) SetAnomalyGroupTimeSeriesFeedback(v *AnomalyGroupTimeSeriesFeedback) *PutFeedbackInput {
	s.AnomalyGroupTimeSeriesFeedback = v
	return s
}

type PutFeedbackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutFeedbackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutFeedbackOutput) GoString() string {
	return s.String()
}

// Contains information about the Amazon Relational Database Service (RDS) configuration.
type RDSSourceConfig struct {
	_ struct{} `type:"structure"`

	// A string identifying the database instance.
	//
	// DBInstanceIdentifier is a required field
	DBInstanceIdentifier *string `min:"1" type:"string" required:"true"`

	// The host name of the database.
	//
	// DatabaseHost is a required field
	DatabaseHost *string `min:"1" type:"string" required:"true"`

	// The name of the RDS database.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The port number where the database can be accessed.
	//
	// DatabasePort is a required field
	DatabasePort *int64 `min:"1" type:"integer" required:"true"`

	// The Amazon Resource Name (ARN) of the role.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the AWS Secrets Manager role.
	//
	// SecretManagerArn is a required field
	SecretManagerArn *string `type:"string" required:"true"`

	// The name of the table in the database.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`

	// An object containing information about the Amazon Virtual Private Cloud (VPC)
	// configuration.
	//
	// VpcConfiguration is a required field
	VpcConfiguration *VpcConfiguration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RDSSourceConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RDSSourceConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RDSSourceConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RDSSourceConfig"}
	if s.DBInstanceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBInstanceIdentifier"))
	}
	if s.DBInstanceIdentifier != nil && len(*s.DBInstanceIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DBInstanceIdentifier", 1))
	}
	if s.DatabaseHost == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseHost"))
	}
	if s.DatabaseHost != nil && len(*s.DatabaseHost) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseHost", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.DatabasePort == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabasePort"))
	}
	if s.DatabasePort != nil && *s.DatabasePort < 1 {
		invalidParams.Add(request.NewErrParamMinValue("DatabasePort", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.SecretManagerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretManagerArn"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}
	if s.VpcConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcConfiguration"))
	}
	if s.VpcConfiguration != nil {
		if err := s.VpcConfiguration.Validate(); err != nil {
			invalidParams.AddNested("VpcConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *RDSSourceConfig) SetDBInstanceIdentifier(v string) *RDSSourceConfig {
	s.DBInstanceIdentifier = &v
	return s
}

// SetDatabaseHost sets the DatabaseHost field's value.
func (s *RDSSourceConfig) SetDatabaseHost(v string) *RDSSourceConfig {
	s.DatabaseHost = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *RDSSourceConfig) SetDatabaseName(v string) *RDSSourceConfig {
	s.DatabaseName = &v
	return s
}

// SetDatabasePort sets the DatabasePort field's value.
func (s *RDSSourceConfig) SetDatabasePort(v int64) *RDSSourceConfig {
	s.DatabasePort = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *RDSSourceConfig) SetRoleArn(v string) *RDSSourceConfig {
	s.RoleArn = &v
	return s
}

// SetSecretManagerArn sets the SecretManagerArn field's value.
func (s *RDSSourceConfig) SetSecretManagerArn(v string) *RDSSourceConfig {
	s.SecretManagerArn = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *RDSSourceConfig) SetTableName(v string) *RDSSourceConfig {
	s.TableName = &v
	return s
}

// SetVpcConfiguration sets the VpcConfiguration field's value.
func (s *RDSSourceConfig) SetVpcConfiguration(v *VpcConfiguration) *RDSSourceConfig {
	s.VpcConfiguration = v
	return s
}

// Provides information about the Amazon Redshift database configuration.
type RedshiftSourceConfig struct {
	_ struct{} `type:"structure"`

	// A string identifying the Redshift cluster.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `min:"1" type:"string" required:"true"`

	// The name of the database host.
	//
	// DatabaseHost is a required field
	DatabaseHost *string `min:"1" type:"string" required:"true"`

	// The Redshift database name.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The port number where the database can be accessed.
	//
	// DatabasePort is a required field
	DatabasePort *int64 `min:"1" type:"integer" required:"true"`

	// The Amazon Resource Name (ARN) of the role providing access to the database.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the AWS Secrets Manager role.
	//
	// SecretManagerArn is a required field
	SecretManagerArn *string `type:"string" required:"true"`

	// The table name of the Redshift database.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`

	// Contains information about the Amazon Virtual Private Cloud (VPC) configuration.
	//
	// VpcConfiguration is a required field
	VpcConfiguration *VpcConfiguration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RedshiftSourceConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RedshiftSourceConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RedshiftSourceConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RedshiftSourceConfig"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}
	if s.ClusterIdentifier != nil && len(*s.ClusterIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterIdentifier", 1))
	}
	if s.DatabaseHost == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseHost"))
	}
	if s.DatabaseHost != nil && len(*s.DatabaseHost) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseHost", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.DatabasePort == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabasePort"))
	}
	if s.DatabasePort != nil && *s.DatabasePort < 1 {
		invalidParams.Add(request.NewErrParamMinValue("DatabasePort", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.SecretManagerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretManagerArn"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}
	if s.VpcConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcConfiguration"))
	}
	if s.VpcConfiguration != nil {
		if err := s.VpcConfiguration.Validate(); err != nil {
			invalidParams.AddNested("VpcConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *RedshiftSourceConfig) SetClusterIdentifier(v string) *RedshiftSourceConfig {
	s.ClusterIdentifier = &v
	return s
}

// SetDatabaseHost sets the DatabaseHost field's value.
func (s *RedshiftSourceConfig) SetDatabaseHost(v string) *RedshiftSourceConfig {
	s.DatabaseHost = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *RedshiftSourceConfig) SetDatabaseName(v string) *RedshiftSourceConfig {
	s.DatabaseName = &v
	return s
}

// SetDatabasePort sets the DatabasePort field's value.
func (s *RedshiftSourceConfig) SetDatabasePort(v int64) *RedshiftSourceConfig {
	s.DatabasePort = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *RedshiftSourceConfig) SetRoleArn(v string) *RedshiftSourceConfig {
	s.RoleArn = &v
	return s
}

// SetSecretManagerArn sets the SecretManagerArn field's value.
func (s *RedshiftSourceConfig) SetSecretManagerArn(v string) *RedshiftSourceConfig {
	s.SecretManagerArn = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *RedshiftSourceConfig) SetTableName(v string) *RedshiftSourceConfig {
	s.TableName = &v
	return s
}

// SetVpcConfiguration sets the VpcConfiguration field's value.
func (s *RedshiftSourceConfig) SetVpcConfiguration(v *VpcConfiguration) *RedshiftSourceConfig {
	s.VpcConfiguration = v
	return s
}

// The specified resource cannot be found. Check the ARN of the resource and
// try again.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The ID of the resource.
	ResourceId *string `type:"string"`

	// The type of the resource.
	ResourceType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about the configuration of the S3 bucket that contains
// source files.
type S3SourceConfig struct {
	_ struct{} `type:"structure"`

	// Contains information about a source file's formatting.
	FileFormatDescriptor *FileFormatDescriptor `type:"structure"`

	// A list of paths to the historical data files.
	HistoricalDataPathList []*string `min:"1" type:"list"`

	// The ARN of an IAM role that has read and write access permissions to the
	// source S3 bucket.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`

	// A list of templated paths to the source files.
	TemplatedPathList []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3SourceConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3SourceConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3SourceConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3SourceConfig"}
	if s.HistoricalDataPathList != nil && len(s.HistoricalDataPathList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HistoricalDataPathList", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.TemplatedPathList != nil && len(s.TemplatedPathList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplatedPathList", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileFormatDescriptor sets the FileFormatDescriptor field's value.
func (s *S3SourceConfig) SetFileFormatDescriptor(v *FileFormatDescriptor) *S3SourceConfig {
	s.FileFormatDescriptor = v
	return s
}

// SetHistoricalDataPathList sets the HistoricalDataPathList field's value.
func (s *S3SourceConfig) SetHistoricalDataPathList(v []*string) *S3SourceConfig {
	s.HistoricalDataPathList = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *S3SourceConfig) SetRoleArn(v string) *S3SourceConfig {
	s.RoleArn = &v
	return s
}

// SetTemplatedPathList sets the TemplatedPathList field's value.
func (s *S3SourceConfig) SetTemplatedPathList(v []*string) *S3SourceConfig {
	s.TemplatedPathList = v
	return s
}

// Contains information about the SNS topic to which you want to send your alerts
// and the IAM role that has access to that topic.
type SNSConfiguration struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM role that has access to the target SNS topic.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`

	// The ARN of the target SNS topic.
	//
	// SnsTopicArn is a required field
	SnsTopicArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SNSConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SNSConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SNSConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SNSConfiguration"}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.SnsTopicArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SnsTopicArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoleArn sets the RoleArn field's value.
func (s *SNSConfiguration) SetRoleArn(v string) *SNSConfiguration {
	s.RoleArn = &v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *SNSConfiguration) SetSnsTopicArn(v string) *SNSConfiguration {
	s.SnsTopicArn = &v
	return s
}

// Contains information about the source configuration in Amazon S3.
type SampleDataS3SourceConfig struct {
	_ struct{} `type:"structure"`

	// Contains information about a source file's formatting.
	//
	// FileFormatDescriptor is a required field
	FileFormatDescriptor *FileFormatDescriptor `type:"structure" required:"true"`

	// An array of strings containing the historical set of data paths.
	HistoricalDataPathList []*string `min:"1" type:"list"`

	// The Amazon Resource Name (ARN) of the role.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`

	// An array of strings containing the list of templated paths.
	TemplatedPathList []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SampleDataS3SourceConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SampleDataS3SourceConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SampleDataS3SourceConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SampleDataS3SourceConfig"}
	if s.FileFormatDescriptor == nil {
		invalidParams.Add(request.NewErrParamRequired("FileFormatDescriptor"))
	}
	if s.HistoricalDataPathList != nil && len(s.HistoricalDataPathList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HistoricalDataPathList", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.TemplatedPathList != nil && len(s.TemplatedPathList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplatedPathList", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileFormatDescriptor sets the FileFormatDescriptor field's value.
func (s *SampleDataS3SourceConfig) SetFileFormatDescriptor(v *FileFormatDescriptor) *SampleDataS3SourceConfig {
	s.FileFormatDescriptor = v
	return s
}

// SetHistoricalDataPathList sets the HistoricalDataPathList field's value.
func (s *SampleDataS3SourceConfig) SetHistoricalDataPathList(v []*string) *SampleDataS3SourceConfig {
	s.HistoricalDataPathList = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *SampleDataS3SourceConfig) SetRoleArn(v string) *SampleDataS3SourceConfig {
	s.RoleArn = &v
	return s
}

// SetTemplatedPathList sets the TemplatedPathList field's value.
func (s *SampleDataS3SourceConfig) SetTemplatedPathList(v []*string) *SampleDataS3SourceConfig {
	s.TemplatedPathList = v
	return s
}

// The request exceeded the service's quotas. Check the service quotas and try
// again.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The quota code.
	QuotaCode *string `type:"string"`

	// The ID of the resource.
	ResourceId *string `type:"string"`

	// The type of the resource.
	ResourceType *string `type:"string"`

	// The service code.
	ServiceCode *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The resource's Amazon Resource Name (ARN).
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// Tags to apply to the resource. Tag keys and values can contain letters, numbers,
	// spaces, and the following symbols: _.:/=+@-
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Details about a metric. A metric is an aggregation of the values of a measure
// for a dimension value, such as availability in the us-east-1 Region.
type TimeSeries struct {
	_ struct{} `type:"structure"`

	// The dimensions of the metric.
	//
	// DimensionList is a required field
	DimensionList []*DimensionNameValue `type:"list" required:"true"`

	// The values for the metric.
	//
	// MetricValueList is a required field
	MetricValueList []*float64 `type:"list" required:"true"`

	// The ID of the metric.
	//
	// TimeSeriesId is a required field
	TimeSeriesId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeSeries) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeSeries) GoString() string {
	return s.String()
}

// SetDimensionList sets the DimensionList field's value.
func (s *TimeSeries) SetDimensionList(v []*DimensionNameValue) *TimeSeries {
	s.DimensionList = v
	return s
}

// SetMetricValueList sets the MetricValueList field's value.
func (s *TimeSeries) SetMetricValueList(v []*float64) *TimeSeries {
	s.MetricValueList = v
	return s
}

// SetTimeSeriesId sets the TimeSeriesId field's value.
func (s *TimeSeries) SetTimeSeriesId(v string) *TimeSeries {
	s.TimeSeriesId = &v
	return s
}

// Details about feedback submitted for an anomalous metric.
type TimeSeriesFeedback struct {
	_ struct{} `type:"structure"`

	// Feedback on whether the metric is a legitimate anomaly.
	IsAnomaly *bool `type:"boolean"`

	// The ID of the metric.
	TimeSeriesId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeSeriesFeedback) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeSeriesFeedback) GoString() string {
	return s.String()
}

// SetIsAnomaly sets the IsAnomaly field's value.
func (s *TimeSeriesFeedback) SetIsAnomaly(v bool) *TimeSeriesFeedback {
	s.IsAnomaly = &v
	return s
}

// SetTimeSeriesId sets the TimeSeriesId field's value.
func (s *TimeSeriesFeedback) SetTimeSeriesId(v string) *TimeSeriesFeedback {
	s.TimeSeriesId = &v
	return s
}

// Contains information about the column used to track time in a source data
// file.
type TimestampColumn struct {
	_ struct{} `type:"structure"`

	// The format of the timestamp column.
	ColumnFormat *string `type:"string"`

	// The name of the timestamp column.
	ColumnName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimestampColumn) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimestampColumn) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TimestampColumn) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TimestampColumn"}
	if s.ColumnName != nil && len(*s.ColumnName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ColumnName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumnFormat sets the ColumnFormat field's value.
func (s *TimestampColumn) SetColumnFormat(v string) *TimestampColumn {
	s.ColumnFormat = &v
	return s
}

// SetColumnName sets the ColumnName field's value.
func (s *TimestampColumn) SetColumnName(v string) *TimestampColumn {
	s.ColumnName = &v
	return s
}

// The request was denied due to too many requests being submitted at the same
// time.
type TooManyRequestsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) GoString() string {
	return s.String()
}

func newErrorTooManyRequestsException(v protocol.ResponseMetadata) error {
	return &TooManyRequestsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyRequestsException) Code() string {
	return "TooManyRequestsException"
}

// Message returns the exception's message.
func (s *TooManyRequestsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyRequestsException) OrigErr() error {
	return nil
}

func (s *TooManyRequestsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyRequestsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyRequestsException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The resource's Amazon Resource Name (ARN).
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// Keys to remove from the resource's tags.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateAnomalyDetectorInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the detector to update.
	//
	// AnomalyDetectorArn is a required field
	AnomalyDetectorArn *string `type:"string" required:"true"`

	// Contains information about the configuration to which the detector will be
	// updated.
	AnomalyDetectorConfig *AnomalyDetectorConfig `type:"structure"`

	// The updated detector description.
	AnomalyDetectorDescription *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of an AWS KMS encryption key.
	KmsKeyArn *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAnomalyDetectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAnomalyDetectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAnomalyDetectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAnomalyDetectorInput"}
	if s.AnomalyDetectorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AnomalyDetectorArn"))
	}
	if s.AnomalyDetectorDescription != nil && len(*s.AnomalyDetectorDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AnomalyDetectorDescription", 1))
	}
	if s.KmsKeyArn != nil && len(*s.KmsKeyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnomalyDetectorArn sets the AnomalyDetectorArn field's value.
func (s *UpdateAnomalyDetectorInput) SetAnomalyDetectorArn(v string) *UpdateAnomalyDetectorInput {
	s.AnomalyDetectorArn = &v
	return s
}

// SetAnomalyDetectorConfig sets the AnomalyDetectorConfig field's value.
func (s *UpdateAnomalyDetectorInput) SetAnomalyDetectorConfig(v *AnomalyDetectorConfig) *UpdateAnomalyDetectorInput {
	s.AnomalyDetectorConfig = v
	return s
}

// SetAnomalyDetectorDescription sets the AnomalyDetectorDescription field's value.
func (s *UpdateAnomalyDetectorInput) SetAnomalyDetectorDescription(v string) *UpdateAnomalyDetectorInput {
	s.AnomalyDetectorDescription = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *UpdateAnomalyDetectorInput) SetKmsKeyArn(v string) *UpdateAnomalyDetectorInput {
	s.KmsKeyArn = &v
	return s
}

type UpdateAnomalyDetectorOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the updated detector.
	AnomalyDetectorArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAnomalyDetectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAnomalyDetectorOutput) GoString() string {
	return s.String()
}

// SetAnomalyDetectorArn sets the AnomalyDetectorArn field's value.
func (s *UpdateAnomalyDetectorOutput) SetAnomalyDetectorArn(v string) *UpdateAnomalyDetectorOutput {
	s.AnomalyDetectorArn = &v
	return s
}

type UpdateMetricSetInput struct {
	_ struct{} `type:"structure"`

	// The dimension list.
	DimensionList []*string `min:"1" type:"list"`

	// The metric list.
	MetricList []*Metric `min:"1" type:"list"`

	// The ARN of the dataset to update.
	//
	// MetricSetArn is a required field
	MetricSetArn *string `type:"string" required:"true"`

	// The dataset's description.
	MetricSetDescription *string `min:"1" type:"string"`

	// The dataset's interval.
	MetricSetFrequency *string `type:"string" enum:"Frequency"`

	// Contains information about source data used to generate a metric.
	MetricSource *MetricSource `type:"structure"`

	// After an interval ends, the amount of seconds that the detector waits before
	// importing data. Offset is only supported for S3 and Redshift datasources.
	Offset *int64 `type:"integer"`

	// The timestamp column.
	TimestampColumn *TimestampColumn `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMetricSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMetricSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMetricSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateMetricSetInput"}
	if s.DimensionList != nil && len(s.DimensionList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DimensionList", 1))
	}
	if s.MetricList != nil && len(s.MetricList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricList", 1))
	}
	if s.MetricSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricSetArn"))
	}
	if s.MetricSetDescription != nil && len(*s.MetricSetDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricSetDescription", 1))
	}
	if s.MetricList != nil {
		for i, v := range s.MetricList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MetricList", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.MetricSource != nil {
		if err := s.MetricSource.Validate(); err != nil {
			invalidParams.AddNested("MetricSource", err.(request.ErrInvalidParams))
		}
	}
	if s.TimestampColumn != nil {
		if err := s.TimestampColumn.Validate(); err != nil {
			invalidParams.AddNested("TimestampColumn", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensionList sets the DimensionList field's value.
func (s *UpdateMetricSetInput) SetDimensionList(v []*string) *UpdateMetricSetInput {
	s.DimensionList = v
	return s
}

// SetMetricList sets the MetricList field's value.
func (s *UpdateMetricSetInput) SetMetricList(v []*Metric) *UpdateMetricSetInput {
	s.MetricList = v
	return s
}

// SetMetricSetArn sets the MetricSetArn field's value.
func (s *UpdateMetricSetInput) SetMetricSetArn(v string) *UpdateMetricSetInput {
	s.MetricSetArn = &v
	return s
}

// SetMetricSetDescription sets the MetricSetDescription field's value.
func (s *UpdateMetricSetInput) SetMetricSetDescription(v string) *UpdateMetricSetInput {
	s.MetricSetDescription = &v
	return s
}

// SetMetricSetFrequency sets the MetricSetFrequency field's value.
func (s *UpdateMetricSetInput) SetMetricSetFrequency(v string) *UpdateMetricSetInput {
	s.MetricSetFrequency = &v
	return s
}

// SetMetricSource sets the MetricSource field's value.
func (s *UpdateMetricSetInput) SetMetricSource(v *MetricSource) *UpdateMetricSetInput {
	s.MetricSource = v
	return s
}

// SetOffset sets the Offset field's value.
func (s *UpdateMetricSetInput) SetOffset(v int64) *UpdateMetricSetInput {
	s.Offset = &v
	return s
}

// SetTimestampColumn sets the TimestampColumn field's value.
func (s *UpdateMetricSetInput) SetTimestampColumn(v *TimestampColumn) *UpdateMetricSetInput {
	s.TimestampColumn = v
	return s
}

type UpdateMetricSetOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the dataset.
	MetricSetArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMetricSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMetricSetOutput) GoString() string {
	return s.String()
}

// SetMetricSetArn sets the MetricSetArn field's value.
func (s *UpdateMetricSetOutput) SetMetricSetArn(v string) *UpdateMetricSetOutput {
	s.MetricSetArn = &v
	return s
}

// The input fails to satisfy the constraints specified by the AWS service.
// Check your input values and try again.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Fields that failed validation.
	Fields []*ValidationExceptionField `type:"list"`

	Message_ *string `locationName:"Message" type:"string"`

	// The reason that validation failed.
	Reason *string `type:"string" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about a a field in a validation exception.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// The message with more information about the validation exception.
	//
	// Message is a required field
	Message *string `type:"string" required:"true"`

	// The name of the field.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

// Contains configuration information about the Amazon Virtual Private Cloud
// (VPC).
type VpcConfiguration struct {
	_ struct{} `type:"structure"`

	// An array of strings containing the list of security groups.
	//
	// SecurityGroupIdList is a required field
	SecurityGroupIdList []*string `type:"list" required:"true"`

	// An array of strings containing the Amazon VPC subnet IDs (e.g., subnet-0bb1c79de3EXAMPLE.
	//
	// SubnetIdList is a required field
	SubnetIdList []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VpcConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VpcConfiguration"}
	if s.SecurityGroupIdList == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupIdList"))
	}
	if s.SubnetIdList == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIdList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecurityGroupIdList sets the SecurityGroupIdList field's value.
func (s *VpcConfiguration) SetSecurityGroupIdList(v []*string) *VpcConfiguration {
	s.SecurityGroupIdList = v
	return s
}

// SetSubnetIdList sets the SubnetIdList field's value.
func (s *VpcConfiguration) SetSubnetIdList(v []*string) *VpcConfiguration {
	s.SubnetIdList = v
	return s
}

const (
	// AggregationFunctionAvg is a AggregationFunction enum value
	AggregationFunctionAvg = "AVG"

	// AggregationFunctionSum is a AggregationFunction enum value
	AggregationFunctionSum = "SUM"
)

// AggregationFunction_Values returns all elements of the AggregationFunction enum
func AggregationFunction_Values() []string {
	return []string{
		AggregationFunctionAvg,
		AggregationFunctionSum,
	}
}

const (
	// AlertStatusActive is a AlertStatus enum value
	AlertStatusActive = "ACTIVE"

	// AlertStatusInactive is a AlertStatus enum value
	AlertStatusInactive = "INACTIVE"
)

// AlertStatus_Values returns all elements of the AlertStatus enum
func AlertStatus_Values() []string {
	return []string{
		AlertStatusActive,
		AlertStatusInactive,
	}
}

const (
	// AlertTypeSns is a AlertType enum value
	AlertTypeSns = "SNS"

	// AlertTypeLambda is a AlertType enum value
	AlertTypeLambda = "LAMBDA"
)

// AlertType_Values returns all elements of the AlertType enum
func AlertType_Values() []string {
	return []string{
		AlertTypeSns,
		AlertTypeLambda,
	}
}

const (
	// AnomalyDetectionTaskStatusPending is a AnomalyDetectionTaskStatus enum value
	AnomalyDetectionTaskStatusPending = "PENDING"

	// AnomalyDetectionTaskStatusInProgress is a AnomalyDetectionTaskStatus enum value
	AnomalyDetectionTaskStatusInProgress = "IN_PROGRESS"

	// AnomalyDetectionTaskStatusCompleted is a AnomalyDetectionTaskStatus enum value
	AnomalyDetectionTaskStatusCompleted = "COMPLETED"

	// AnomalyDetectionTaskStatusFailed is a AnomalyDetectionTaskStatus enum value
	AnomalyDetectionTaskStatusFailed = "FAILED"

	// AnomalyDetectionTaskStatusFailedToSchedule is a AnomalyDetectionTaskStatus enum value
	AnomalyDetectionTaskStatusFailedToSchedule = "FAILED_TO_SCHEDULE"
)

// AnomalyDetectionTaskStatus_Values returns all elements of the AnomalyDetectionTaskStatus enum
func AnomalyDetectionTaskStatus_Values() []string {
	return []string{
		AnomalyDetectionTaskStatusPending,
		AnomalyDetectionTaskStatusInProgress,
		AnomalyDetectionTaskStatusCompleted,
		AnomalyDetectionTaskStatusFailed,
		AnomalyDetectionTaskStatusFailedToSchedule,
	}
}

const (
	// AnomalyDetectorStatusActive is a AnomalyDetectorStatus enum value
	AnomalyDetectorStatusActive = "ACTIVE"

	// AnomalyDetectorStatusActivating is a AnomalyDetectorStatus enum value
	AnomalyDetectorStatusActivating = "ACTIVATING"

	// AnomalyDetectorStatusDeleting is a AnomalyDetectorStatus enum value
	AnomalyDetectorStatusDeleting = "DELETING"

	// AnomalyDetectorStatusFailed is a AnomalyDetectorStatus enum value
	AnomalyDetectorStatusFailed = "FAILED"

	// AnomalyDetectorStatusInactive is a AnomalyDetectorStatus enum value
	AnomalyDetectorStatusInactive = "INACTIVE"

	// AnomalyDetectorStatusLearning is a AnomalyDetectorStatus enum value
	AnomalyDetectorStatusLearning = "LEARNING"

	// AnomalyDetectorStatusBackTestActivating is a AnomalyDetectorStatus enum value
	AnomalyDetectorStatusBackTestActivating = "BACK_TEST_ACTIVATING"

	// AnomalyDetectorStatusBackTestActive is a AnomalyDetectorStatus enum value
	AnomalyDetectorStatusBackTestActive = "BACK_TEST_ACTIVE"

	// AnomalyDetectorStatusBackTestComplete is a AnomalyDetectorStatus enum value
	AnomalyDetectorStatusBackTestComplete = "BACK_TEST_COMPLETE"
)

// AnomalyDetectorStatus_Values returns all elements of the AnomalyDetectorStatus enum
func AnomalyDetectorStatus_Values() []string {
	return []string{
		AnomalyDetectorStatusActive,
		AnomalyDetectorStatusActivating,
		AnomalyDetectorStatusDeleting,
		AnomalyDetectorStatusFailed,
		AnomalyDetectorStatusInactive,
		AnomalyDetectorStatusLearning,
		AnomalyDetectorStatusBackTestActivating,
		AnomalyDetectorStatusBackTestActive,
		AnomalyDetectorStatusBackTestComplete,
	}
}

const (
	// CSVFileCompressionNone is a CSVFileCompression enum value
	CSVFileCompressionNone = "NONE"

	// CSVFileCompressionGzip is a CSVFileCompression enum value
	CSVFileCompressionGzip = "GZIP"
)

// CSVFileCompression_Values returns all elements of the CSVFileCompression enum
func CSVFileCompression_Values() []string {
	return []string{
		CSVFileCompressionNone,
		CSVFileCompressionGzip,
	}
}

const (
	// FrequencyP1d is a Frequency enum value
	FrequencyP1d = "P1D"

	// FrequencyPt1h is a Frequency enum value
	FrequencyPt1h = "PT1H"

	// FrequencyPt10m is a Frequency enum value
	FrequencyPt10m = "PT10M"

	// FrequencyPt5m is a Frequency enum value
	FrequencyPt5m = "PT5M"
)

// Frequency_Values returns all elements of the Frequency enum
func Frequency_Values() []string {
	return []string{
		FrequencyP1d,
		FrequencyPt1h,
		FrequencyPt10m,
		FrequencyPt5m,
	}
}

const (
	// JsonFileCompressionNone is a JsonFileCompression enum value
	JsonFileCompressionNone = "NONE"

	// JsonFileCompressionGzip is a JsonFileCompression enum value
	JsonFileCompressionGzip = "GZIP"
)

// JsonFileCompression_Values returns all elements of the JsonFileCompression enum
func JsonFileCompression_Values() []string {
	return []string{
		JsonFileCompressionNone,
		JsonFileCompressionGzip,
	}
}

const (
	// RelationshipTypeCauseOfInputAnomalyGroup is a RelationshipType enum value
	RelationshipTypeCauseOfInputAnomalyGroup = "CAUSE_OF_INPUT_ANOMALY_GROUP"

	// RelationshipTypeEffectOfInputAnomalyGroup is a RelationshipType enum value
	RelationshipTypeEffectOfInputAnomalyGroup = "EFFECT_OF_INPUT_ANOMALY_GROUP"
)

// RelationshipType_Values returns all elements of the RelationshipType enum
func RelationshipType_Values() []string {
	return []string{
		RelationshipTypeCauseOfInputAnomalyGroup,
		RelationshipTypeEffectOfInputAnomalyGroup,
	}
}

const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "UNKNOWN_OPERATION"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "CANNOT_PARSE"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "FIELD_VALIDATION_FAILED"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "OTHER"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}
