// Copyright 2022 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package chromepolicy provides access to the Chrome Policy API.
//
// For product documentation, see: http://developers.google.com/chrome/policy
//
// Creating a client
//
// Usage example:
//
//   import "google.golang.org/api/chromepolicy/v1"
//   ...
//   ctx := context.Background()
//   chromepolicyService, err := chromepolicy.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate. To restrict scopes, use option.WithScopes:
//
//   chromepolicyService, err := chromepolicy.NewService(ctx, option.WithScopes(chromepolicy.ChromeManagementPolicyReadonlyScope))
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//   chromepolicyService, err := chromepolicy.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//   config := &oauth2.Config{...}
//   // ...
//   token, err := config.Exchange(ctx, ...)
//   chromepolicyService, err := chromepolicy.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package chromepolicy // import "google.golang.org/api/chromepolicy/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint

const apiId = "chromepolicy:v1"
const apiName = "chromepolicy"
const apiVersion = "v1"
const basePath = "https://chromepolicy.googleapis.com/"
const mtlsBasePath = "https://chromepolicy.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, create or delete policies applied to Chrome OS and Chrome
	// Browsers managed within your organization
	ChromeManagementPolicyScope = "https://www.googleapis.com/auth/chrome.management.policy"

	// See policies applied to Chrome OS and Chrome Browsers managed within
	// your organization
	ChromeManagementPolicyReadonlyScope = "https://www.googleapis.com/auth/chrome.management.policy.readonly"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := option.WithScopes(
		"https://www.googleapis.com/auth/chrome.management.policy",
		"https://www.googleapis.com/auth/chrome.management.policy.readonly",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Customers = NewCustomersService(s)
	s.Media = NewMediaService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Customers *CustomersService

	Media *MediaService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewCustomersService(s *Service) *CustomersService {
	rs := &CustomersService{s: s}
	rs.Policies = NewCustomersPoliciesService(s)
	rs.PolicySchemas = NewCustomersPolicySchemasService(s)
	return rs
}

type CustomersService struct {
	s *Service

	Policies *CustomersPoliciesService

	PolicySchemas *CustomersPolicySchemasService
}

func NewCustomersPoliciesService(s *Service) *CustomersPoliciesService {
	rs := &CustomersPoliciesService{s: s}
	rs.Orgunits = NewCustomersPoliciesOrgunitsService(s)
	return rs
}

type CustomersPoliciesService struct {
	s *Service

	Orgunits *CustomersPoliciesOrgunitsService
}

func NewCustomersPoliciesOrgunitsService(s *Service) *CustomersPoliciesOrgunitsService {
	rs := &CustomersPoliciesOrgunitsService{s: s}
	return rs
}

type CustomersPoliciesOrgunitsService struct {
	s *Service
}

func NewCustomersPolicySchemasService(s *Service) *CustomersPolicySchemasService {
	rs := &CustomersPolicySchemasService{s: s}
	return rs
}

type CustomersPolicySchemasService struct {
	s *Service
}

func NewMediaService(s *Service) *MediaService {
	rs := &MediaService{s: s}
	return rs
}

type MediaService struct {
	s *Service
}

type ChromeCrosDpanelAutosettingsProtoPolicyApiLifecycle struct {
	// Description: Description about current life cycle.
	Description string `json:"description,omitempty"`

	// EndSupport: End supporting date for current policy.
	EndSupport *GoogleTypeDate `json:"endSupport,omitempty"`

	// PolicyApiLifecycleStage: Indicate current life cycle stage of the
	// policy API.
	//
	// Possible values:
	//   "API_UNSPECIFIED" - unspecified.
	//   "API_PREVIEW" - Policy is not working yet, but giving developers
	// heads up on format. This stage can transfer to API_DEVELOPEMNT or
	// API_CURRENT.
	//   "API_DEVELOPMENT" - Policy can change format in backward
	// incompatible way (breaking change). This stage can transfer to
	// API_CURRENT or API_DEPRECATED. This could be used for policies
	// launched only to TTs or launched to selected customers for emergency
	// usage.
	//   "API_CURRENT" - Policy in official format. Policy can change format
	// in backward compatible way (non-breaking change). Example: this
	// policy can introduce a new field, which is considered non-breaking
	// change, when field masks are properly utilized. This stage can
	// transfer to API_DEPRECATED.
	//   "API_DEPRECATED" - Please stop using this policy. This policy is
	// deprecated and may/will be removed in the future. Most likely a new
	// policy was introduced to replace this one.
	PolicyApiLifecycleStage string `json:"policyApiLifecycleStage,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ChromeCrosDpanelAutosettingsProtoPolicyApiLifecycle) MarshalJSON() ([]byte, error) {
	type NoMethod ChromeCrosDpanelAutosettingsProtoPolicyApiLifecycle
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyV1AdditionalTargetKeyName: Additional key names
// that will be used to identify the target of the policy value.
type GoogleChromePolicyV1AdditionalTargetKeyName struct {
	// Key: Key name.
	Key string `json:"key,omitempty"`

	// KeyDescription: Key description.
	KeyDescription string `json:"keyDescription,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChromePolicyV1AdditionalTargetKeyName) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyV1AdditionalTargetKeyName
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyV1BatchInheritOrgUnitPoliciesRequest: Request
// message for specifying that multiple policy values inherit their
// value from their parents.
type GoogleChromePolicyV1BatchInheritOrgUnitPoliciesRequest struct {
	// Requests: List of policies that have to inherit their values as
	// defined by the `requests`. All requests in the list must follow these
	// restrictions: 1. All schemas in the list must have the same root
	// namespace. 2. All `policyTargetKey.targetResource` values must point
	// to an org unit resource. 3. All `policyTargetKey` values must have
	// the same key names in the ` additionalTargetKeys`. This also means if
	// one of the targets has an empty `additionalTargetKeys` map, all of
	// the targets must have an empty `additionalTargetKeys` map. 4. No two
	// modification requests can reference the same `policySchema` + `
	// policyTargetKey` pair.
	Requests []*GoogleChromePolicyV1InheritOrgUnitPolicyRequest `json:"requests,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Requests") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChromePolicyV1BatchInheritOrgUnitPoliciesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyV1BatchInheritOrgUnitPoliciesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyV1BatchModifyOrgUnitPoliciesRequest: Request
// message for modifying multiple policy values for a specific target.
type GoogleChromePolicyV1BatchModifyOrgUnitPoliciesRequest struct {
	// Requests: List of policies to modify as defined by the `requests`.
	// All requests in the list must follow these restrictions: 1. All
	// schemas in the list must have the same root namespace. 2. All
	// `policyTargetKey.targetResource` values must point to an org unit
	// resource. 3. All `policyTargetKey` values must have the same key
	// names in the ` additionalTargetKeys`. This also means if one of the
	// targets has an empty `additionalTargetKeys` map, all of the targets
	// must have an empty `additionalTargetKeys` map. 4. No two modification
	// requests can reference the same `policySchema` + ` policyTargetKey`
	// pair.
	Requests []*GoogleChromePolicyV1ModifyOrgUnitPolicyRequest `json:"requests,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Requests") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChromePolicyV1BatchModifyOrgUnitPoliciesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyV1BatchModifyOrgUnitPoliciesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyV1InheritOrgUnitPolicyRequest: Request parameters
// for inheriting policy value of a specific org unit target from the
// policy value of its parent org unit.
type GoogleChromePolicyV1InheritOrgUnitPolicyRequest struct {
	// PolicySchema: The fully qualified name of the policy schema that is
	// being inherited.
	PolicySchema string `json:"policySchema,omitempty"`

	// PolicyTargetKey: Required. The key of the target for which we want to
	// modify a policy. The target resource must point to an Org Unit.
	PolicyTargetKey *GoogleChromePolicyV1PolicyTargetKey `json:"policyTargetKey,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PolicySchema") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PolicySchema") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChromePolicyV1InheritOrgUnitPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyV1InheritOrgUnitPolicyRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyV1ListPolicySchemasResponse: Response message for
// listing policy schemas that match a filter.
type GoogleChromePolicyV1ListPolicySchemasResponse struct {
	// NextPageToken: The page token used to get the next page of policy
	// schemas.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// PolicySchemas: The list of policy schemas that match the query.
	PolicySchemas []*GoogleChromePolicyV1PolicySchema `json:"policySchemas,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChromePolicyV1ListPolicySchemasResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyV1ListPolicySchemasResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyV1ModifyOrgUnitPolicyRequest: Request parameters
// for modifying a policy value for a specific org unit target.
type GoogleChromePolicyV1ModifyOrgUnitPolicyRequest struct {
	// PolicyTargetKey: Required. The key of the target for which we want to
	// modify a policy. The target resource must point to an Org Unit.
	PolicyTargetKey *GoogleChromePolicyV1PolicyTargetKey `json:"policyTargetKey,omitempty"`

	// PolicyValue: The new value for the policy.
	PolicyValue *GoogleChromePolicyV1PolicyValue `json:"policyValue,omitempty"`

	// UpdateMask: Required. Policy fields to update. Only fields in this
	// mask will be updated; other fields in `policy_value` will be ignored
	// (even if they have values). If a field is in this list it must have a
	// value in 'policy_value'.
	UpdateMask string `json:"updateMask,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PolicyTargetKey") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PolicyTargetKey") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChromePolicyV1ModifyOrgUnitPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyV1ModifyOrgUnitPolicyRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyV1PolicySchema: Resource representing a policy
// schema. Next ID: 12
type GoogleChromePolicyV1PolicySchema struct {
	// AccessRestrictions: Output only. Specific access restrictions related
	// to this policy.
	AccessRestrictions []string `json:"accessRestrictions,omitempty"`

	// AdditionalTargetKeyNames: Output only. Additional key names that will
	// be used to identify the target of the policy value. When specifying a
	// `policyTargetKey`, each of the additional keys specified here will
	// have to be included in the `additionalTargetKeys` map.
	AdditionalTargetKeyNames []*GoogleChromePolicyV1AdditionalTargetKeyName `json:"additionalTargetKeyNames,omitempty"`

	// Definition: Schema definition using proto descriptor.
	Definition *Proto2FileDescriptorProto `json:"definition,omitempty"`

	// FieldDescriptions: Output only. Detailed description of each field
	// that is part of the schema.
	FieldDescriptions []*GoogleChromePolicyV1PolicySchemaFieldDescription `json:"fieldDescriptions,omitempty"`

	// Name: Format:
	// name=customers/{customer}/policySchemas/{schema_namespace}
	Name string `json:"name,omitempty"`

	// Notices: Output only. Special notice messages related to setting
	// certain values in certain fields in the schema.
	Notices []*GoogleChromePolicyV1PolicySchemaNoticeDescription `json:"notices,omitempty"`

	// PolicyApiLifeycle: Output only. Current life cycle information.
	PolicyApiLifeycle *ChromeCrosDpanelAutosettingsProtoPolicyApiLifecycle `json:"policyApiLifeycle,omitempty"`

	// PolicyDescription: Output only. Description about the policy schema
	// for user consumption.
	PolicyDescription string `json:"policyDescription,omitempty"`

	// SchemaName: Output only. The fully qualified name of the policy
	// schema. This value is used to fill the field `policy_schema` in
	// PolicyValue when calling BatchInheritOrgUnitPolicies or
	// BatchModifyOrgUnitPolicies
	SchemaName string `json:"schemaName,omitempty"`

	// SupportUri: Output only. URI to related support article for this
	// schema.
	SupportUri string `json:"supportUri,omitempty"`

	// ValidTargetResources: Output only. Information about applicable
	// target resources for the policy.
	//
	// Possible values:
	//   "TARGET_RESOURCE_UNSPECIFIED" - Unspecified target resource.
	//   "ORG_UNIT" - Organizational Unit target resource.
	//   "GROUP" - Group target resource.
	ValidTargetResources []string `json:"validTargetResources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AccessRestrictions")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessRestrictions") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChromePolicyV1PolicySchema) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyV1PolicySchema
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyV1PolicySchemaFieldDependencies: The field and the
// value it must have for another field to be allowed to be set.
type GoogleChromePolicyV1PolicySchemaFieldDependencies struct {
	// SourceField: The source field which this field depends on.
	SourceField string `json:"sourceField,omitempty"`

	// SourceFieldValue: The value which the source field must have for this
	// field to be allowed to be set.
	SourceFieldValue string `json:"sourceFieldValue,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SourceField") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SourceField") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChromePolicyV1PolicySchemaFieldDependencies) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyV1PolicySchemaFieldDependencies
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyV1PolicySchemaFieldDescription: Provides detailed
// information for a particular field that is part of a PolicySchema.
type GoogleChromePolicyV1PolicySchemaFieldDescription struct {
	// Description: Output only. The description for the field.
	Description string `json:"description,omitempty"`

	// Field: Output only. The name of the field for associated with this
	// description.
	Field string `json:"field,omitempty"`

	// FieldDependencies: Output only. Provides a list of fields and the
	// values they must have for this field to be allowed to be set.
	FieldDependencies []*GoogleChromePolicyV1PolicySchemaFieldDependencies `json:"fieldDependencies,omitempty"`

	// InputConstraint: Output only. Any input constraints associated on the
	// values for the field.
	InputConstraint string `json:"inputConstraint,omitempty"`

	// KnownValueDescriptions: Output only. If the field has a set of known
	// values, this field will provide a description for these values.
	KnownValueDescriptions []*GoogleChromePolicyV1PolicySchemaFieldKnownValueDescription `json:"knownValueDescriptions,omitempty"`

	// NestedFieldDescriptions: Output only. Provides the description of the
	// fields nested in this field, if the field is a message type that
	// defines multiple fields.
	NestedFieldDescriptions []*GoogleChromePolicyV1PolicySchemaFieldDescription `json:"nestedFieldDescriptions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChromePolicyV1PolicySchemaFieldDescription) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyV1PolicySchemaFieldDescription
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyV1PolicySchemaFieldKnownValueDescription: Provides
// detailed information about a known value that is allowed for a
// particular field in a PolicySchema.
type GoogleChromePolicyV1PolicySchemaFieldKnownValueDescription struct {
	// Description: Output only. Additional description for this value.
	Description string `json:"description,omitempty"`

	// Value: Output only. The string represenstation of the value that can
	// be set for the field.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChromePolicyV1PolicySchemaFieldKnownValueDescription) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyV1PolicySchemaFieldKnownValueDescription
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyV1PolicySchemaNoticeDescription: Provides special
// notice messages related to a particular value in a field that is part
// of a PolicySchema.
type GoogleChromePolicyV1PolicySchemaNoticeDescription struct {
	// AcknowledgementRequired: Output only. Whether the user needs to
	// acknowledge the notice message before the value can be set.
	AcknowledgementRequired bool `json:"acknowledgementRequired,omitempty"`

	// Field: Output only. The field name associated with the notice.
	Field string `json:"field,omitempty"`

	// NoticeMessage: Output only. The notice message associate with the
	// value of the field.
	NoticeMessage string `json:"noticeMessage,omitempty"`

	// NoticeValue: Output only. The value of the field that has a notice.
	// When setting the field to this value, the user may be required to
	// acknowledge the notice message in order for the value to be set.
	NoticeValue string `json:"noticeValue,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AcknowledgementRequired") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AcknowledgementRequired")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChromePolicyV1PolicySchemaNoticeDescription) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyV1PolicySchemaNoticeDescription
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyV1PolicyTargetKey: The key used to identify the
// target on which the policy will be applied.
type GoogleChromePolicyV1PolicyTargetKey struct {
	// AdditionalTargetKeys: Map containing the additional target key name
	// and value pairs used to further identify the target of the policy.
	AdditionalTargetKeys map[string]string `json:"additionalTargetKeys,omitempty"`

	// TargetResource: The target resource on which this policy is applied.
	// The following resources are supported: * Organizational Unit
	// ("orgunits/{orgunit_id}")
	TargetResource string `json:"targetResource,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AdditionalTargetKeys") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdditionalTargetKeys") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChromePolicyV1PolicyTargetKey) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyV1PolicyTargetKey
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyV1PolicyValue: A particular value for a policy
// managed by the service.
type GoogleChromePolicyV1PolicyValue struct {
	// PolicySchema: The fully qualified name of the policy schema
	// associated with this policy.
	PolicySchema string `json:"policySchema,omitempty"`

	// Value: The value of the policy that is compatible with the schema
	// that it is associated with.
	Value googleapi.RawMessage `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PolicySchema") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PolicySchema") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChromePolicyV1PolicyValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyV1PolicyValue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyV1ResolveRequest: Request message for getting the
// resolved policy value for a specific target.
type GoogleChromePolicyV1ResolveRequest struct {
	// PageSize: The maximum number of policies to return, defaults to 100
	// and has a maximum of 1000.
	PageSize int64 `json:"pageSize,omitempty"`

	// PageToken: The page token used to retrieve a specific page of the
	// request.
	PageToken string `json:"pageToken,omitempty"`

	// PolicySchemaFilter: The schema filter to apply to the resolve
	// request. Specify a schema name to view a particular schema, for
	// example: chrome.users.ShowLogoutButton Wildcards are supported, but
	// only in the leaf portion of the schema name. Wildcards cannot be used
	// in namespace directly. Please read
	// https://developers.google.com/chrome/chrome-management/guides/policyapi
	// for details on schema namepsaces. For example: Valid:
	// "chrome.users.*", "chrome.users.apps.*", "chrome.printers.*" Invalid:
	// "*", "*.users", "chrome.*", "chrome.*.apps.*"
	PolicySchemaFilter string `json:"policySchemaFilter,omitempty"`

	// PolicyTargetKey: Required. The key of the target resource on which
	// the policies should be resolved. The target resource must point to an
	// Org Unit.
	PolicyTargetKey *GoogleChromePolicyV1PolicyTargetKey `json:"policyTargetKey,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PageSize") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PageSize") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChromePolicyV1ResolveRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyV1ResolveRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyV1ResolveResponse: Response message for getting the
// resolved policy value for a specific target.
type GoogleChromePolicyV1ResolveResponse struct {
	// NextPageToken: The page token used to get the next set of resolved
	// policies found by the request.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ResolvedPolicies: The list of resolved policies found by the resolve
	// request.
	ResolvedPolicies []*GoogleChromePolicyV1ResolvedPolicy `json:"resolvedPolicies,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChromePolicyV1ResolveResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyV1ResolveResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyV1ResolvedPolicy: The resolved value of a policy
// for a given target.
type GoogleChromePolicyV1ResolvedPolicy struct {
	// SourceKey: Output only. The source resource from which this policy
	// value is obtained. May be the same as `targetKey` if the policy is
	// directly modified on the target, otherwise it would be another
	// resource from which the policy gets its value (if applicable). If not
	// present, the source is the default value for the customer.
	SourceKey *GoogleChromePolicyV1PolicyTargetKey `json:"sourceKey,omitempty"`

	// TargetKey: Output only. The target resource for which the resolved
	// policy value applies.
	TargetKey *GoogleChromePolicyV1PolicyTargetKey `json:"targetKey,omitempty"`

	// Value: Output only. The resolved value of the policy.
	Value *GoogleChromePolicyV1PolicyValue `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SourceKey") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SourceKey") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChromePolicyV1ResolvedPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyV1ResolvedPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyV1UploadPolicyFileRequest: Request message for
// uploading a file for a policy. Next ID: 5
type GoogleChromePolicyV1UploadPolicyFileRequest struct {
	// PolicyField: Required. The fully qualified policy schema and field
	// name this file is uploaded for. This information will be used to
	// validate the content type of the file.
	PolicyField string `json:"policyField,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PolicyField") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PolicyField") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChromePolicyV1UploadPolicyFileRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyV1UploadPolicyFileRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyV1UploadPolicyFileResponse: Response message for
// downloading an uploaded file. Next ID: 2
type GoogleChromePolicyV1UploadPolicyFileResponse struct {
	// DownloadUri: The uri for end user to download the file.
	DownloadUri string `json:"downloadUri,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DownloadUri") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DownloadUri") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChromePolicyV1UploadPolicyFileResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyV1UploadPolicyFileResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleProtobufEmpty: A generic empty message that you can re-use to
// avoid defining duplicated empty messages in your APIs. A typical
// example is to use it as the request or the response type of an API
// method. For instance: service Foo { rpc Bar(google.protobuf.Empty)
// returns (google.protobuf.Empty); } The JSON representation for
// `Empty` is empty JSON object `{}`.
type GoogleProtobufEmpty struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleTypeDate: Represents a whole or partial calendar date, such as
// a birthday. The time of day and time zone are either specified
// elsewhere or are insignificant. The date is relative to the Gregorian
// Calendar. This can represent one of the following: * A full date,
// with non-zero year, month, and day values * A month and day value,
// with a zero year, such as an anniversary * A year on its own, with
// zero month and day values * A year and month value, with a zero day,
// such as a credit card expiration date Related types are
// google.type.TimeOfDay and `google.protobuf.Timestamp`.
type GoogleTypeDate struct {
	// Day: Day of a month. Must be from 1 to 31 and valid for the year and
	// month, or 0 to specify a year by itself or a year and month where the
	// day isn't significant.
	Day int64 `json:"day,omitempty"`

	// Month: Month of a year. Must be from 1 to 12, or 0 to specify a year
	// without a month and day.
	Month int64 `json:"month,omitempty"`

	// Year: Year of the date. Must be from 1 to 9999, or 0 to specify a
	// date without a year.
	Year int64 `json:"year,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Day") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Day") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleTypeDate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeDate
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Proto2DescriptorProto: Describes a message type.
type Proto2DescriptorProto struct {
	EnumType []*Proto2EnumDescriptorProto `json:"enumType,omitempty"`

	Field []*Proto2FieldDescriptorProto `json:"field,omitempty"`

	Name string `json:"name,omitempty"`

	NestedType []*Proto2DescriptorProto `json:"nestedType,omitempty"`

	OneofDecl []*Proto2OneofDescriptorProto `json:"oneofDecl,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EnumType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EnumType") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Proto2DescriptorProto) MarshalJSON() ([]byte, error) {
	type NoMethod Proto2DescriptorProto
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Proto2EnumDescriptorProto: Describes an enum type.
type Proto2EnumDescriptorProto struct {
	Name string `json:"name,omitempty"`

	Value []*Proto2EnumValueDescriptorProto `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Proto2EnumDescriptorProto) MarshalJSON() ([]byte, error) {
	type NoMethod Proto2EnumDescriptorProto
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Proto2EnumValueDescriptorProto: Describes a value within an enum.
type Proto2EnumValueDescriptorProto struct {
	Name string `json:"name,omitempty"`

	Number int64 `json:"number,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Proto2EnumValueDescriptorProto) MarshalJSON() ([]byte, error) {
	type NoMethod Proto2EnumValueDescriptorProto
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Proto2FieldDescriptorProto: Describes a field within a message.
type Proto2FieldDescriptorProto struct {
	// DefaultValue: For numeric types, contains the original text
	// representation of the value. For booleans, "true" or "false". For
	// strings, contains the default text contents (not escaped in any way).
	// For bytes, contains the C escaped value. All bytes >= 128 are
	// escaped.
	DefaultValue string `json:"defaultValue,omitempty"`

	// JsonName: JSON name of this field. The value is set by protocol
	// compiler. If the user has set a "json_name" option on this field,
	// that option's value will be used. Otherwise, it's deduced from the
	// field's name by converting it to camelCase.
	JsonName string `json:"jsonName,omitempty"`

	// Possible values:
	//   "LABEL_OPTIONAL" - 0 is reserved for errors
	//   "LABEL_REQUIRED"
	//   "LABEL_REPEATED"
	Label string `json:"label,omitempty"`

	Name string `json:"name,omitempty"`

	Number int64 `json:"number,omitempty"`

	// OneofIndex: If set, gives the index of a oneof in the containing
	// type's oneof_decl list. This field is a member of that oneof.
	OneofIndex int64 `json:"oneofIndex,omitempty"`

	// Proto3Optional: If true, this is a proto3 "optional". When a proto3
	// field is optional, it tracks presence regardless of field type. When
	// proto3_optional is true, this field must be belong to a oneof to
	// signal to old proto3 clients that presence is tracked for this field.
	// This oneof is known as a "synthetic" oneof, and this field must be
	// its sole member (each proto3 optional field gets its own synthetic
	// oneof). Synthetic oneofs exist in the descriptor only, and do not
	// generate any API. Synthetic oneofs must be ordered after all "real"
	// oneofs. For message fields, proto3_optional doesn't create any
	// semantic change, since non-repeated message fields always track
	// presence. However it still indicates the semantic detail of whether
	// the user wrote "optional" or not. This can be useful for
	// round-tripping the .proto file. For consistency we give message
	// fields a synthetic oneof also, even though it is not required to
	// track presence. This is especially important because the parser can't
	// tell if a field is a message or an enum, so it must always create a
	// synthetic oneof. Proto2 optional fields do not set this flag, because
	// they already indicate optional with `LABEL_OPTIONAL`.
	Proto3Optional bool `json:"proto3Optional,omitempty"`

	// Type: If type_name is set, this need not be set. If both this and
	// type_name are set, this must be one of TYPE_ENUM, TYPE_MESSAGE or
	// TYPE_GROUP.
	//
	// Possible values:
	//   "TYPE_DOUBLE" - 0 is reserved for errors. Order is weird for
	// historical reasons.
	//   "TYPE_FLOAT"
	//   "TYPE_INT64" - Not ZigZag encoded. Negative numbers take 10 bytes.
	// Use TYPE_SINT64 if negative values are likely.
	//   "TYPE_UINT64"
	//   "TYPE_INT32" - Not ZigZag encoded. Negative numbers take 10 bytes.
	// Use TYPE_SINT32 if negative values are likely.
	//   "TYPE_FIXED64"
	//   "TYPE_FIXED32"
	//   "TYPE_BOOL"
	//   "TYPE_STRING"
	//   "TYPE_GROUP" - Tag-delimited aggregate. Group type is deprecated
	// and not supported in proto3. However, Proto3 implementations should
	// still be able to parse the group wire format and treat group fields
	// as unknown fields.
	//   "TYPE_MESSAGE" - Length-delimited aggregate.
	//   "TYPE_BYTES" - New in version 2.
	//   "TYPE_UINT32"
	//   "TYPE_ENUM"
	//   "TYPE_SFIXED32"
	//   "TYPE_SFIXED64"
	//   "TYPE_SINT32" - Uses ZigZag encoding.
	//   "TYPE_SINT64" - Uses ZigZag encoding.
	Type string `json:"type,omitempty"`

	// TypeName: For message and enum types, this is the name of the type.
	// If the name starts with a '.', it is fully-qualified. Otherwise,
	// C++-like scoping rules are used to find the type (i.e. first the
	// nested types within this message are searched, then within the
	// parent, on up to the root namespace).
	TypeName string `json:"typeName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DefaultValue") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DefaultValue") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Proto2FieldDescriptorProto) MarshalJSON() ([]byte, error) {
	type NoMethod Proto2FieldDescriptorProto
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Proto2FileDescriptorProto: Describes a complete .proto file.
type Proto2FileDescriptorProto struct {
	EnumType []*Proto2EnumDescriptorProto `json:"enumType,omitempty"`

	// MessageType: All top-level definitions in this file.
	MessageType []*Proto2DescriptorProto `json:"messageType,omitempty"`

	// Name: file name, relative to root of source tree
	Name string `json:"name,omitempty"`

	// Package: e.g. "foo", "foo.bar", etc.
	Package string `json:"package,omitempty"`

	// Syntax: The syntax of the proto file. The supported values are
	// "proto2" and "proto3".
	Syntax string `json:"syntax,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EnumType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EnumType") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Proto2FileDescriptorProto) MarshalJSON() ([]byte, error) {
	type NoMethod Proto2FileDescriptorProto
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Proto2OneofDescriptorProto: Describes a oneof.
type Proto2OneofDescriptorProto struct {
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Proto2OneofDescriptorProto) MarshalJSON() ([]byte, error) {
	type NoMethod Proto2OneofDescriptorProto
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "chromepolicy.customers.policies.resolve":

type CustomersPoliciesResolveCall struct {
	s                                  *Service
	customer                           string
	googlechromepolicyv1resolverequest *GoogleChromePolicyV1ResolveRequest
	urlParams_                         gensupport.URLParams
	ctx_                               context.Context
	header_                            http.Header
}

// Resolve: Gets the resolved policy values for a list of policies that
// match a search query.
//
// - customer: ID of the G Suite account or literal "my_customer" for
//   the customer associated to the request.
func (r *CustomersPoliciesService) Resolve(customer string, googlechromepolicyv1resolverequest *GoogleChromePolicyV1ResolveRequest) *CustomersPoliciesResolveCall {
	c := &CustomersPoliciesResolveCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.googlechromepolicyv1resolverequest = googlechromepolicyv1resolverequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CustomersPoliciesResolveCall) Fields(s ...googleapi.Field) *CustomersPoliciesResolveCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CustomersPoliciesResolveCall) Context(ctx context.Context) *CustomersPoliciesResolveCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CustomersPoliciesResolveCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersPoliciesResolveCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlechromepolicyv1resolverequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+customer}/policies:resolve")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromepolicy.customers.policies.resolve" call.
// Exactly one of *GoogleChromePolicyV1ResolveResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleChromePolicyV1ResolveResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *CustomersPoliciesResolveCall) Do(opts ...googleapi.CallOption) (*GoogleChromePolicyV1ResolveResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleChromePolicyV1ResolveResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the resolved policy values for a list of policies that match a search query.",
	//   "flatPath": "v1/customers/{customersId}/policies:resolve",
	//   "httpMethod": "POST",
	//   "id": "chromepolicy.customers.policies.resolve",
	//   "parameterOrder": [
	//     "customer"
	//   ],
	//   "parameters": {
	//     "customer": {
	//       "description": "ID of the G Suite account or literal \"my_customer\" for the customer associated to the request.",
	//       "location": "path",
	//       "pattern": "^customers/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+customer}/policies:resolve",
	//   "request": {
	//     "$ref": "GoogleChromePolicyV1ResolveRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleChromePolicyV1ResolveResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/chrome.management.policy",
	//     "https://www.googleapis.com/auth/chrome.management.policy.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CustomersPoliciesResolveCall) Pages(ctx context.Context, f func(*GoogleChromePolicyV1ResolveResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) { c.googlechromepolicyv1resolverequest.PageToken = pt }(c.googlechromepolicyv1resolverequest.PageToken) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.googlechromepolicyv1resolverequest.PageToken = x.NextPageToken
	}
}

// method id "chromepolicy.customers.policies.orgunits.batchInherit":

type CustomersPoliciesOrgunitsBatchInheritCall struct {
	s                                                      *Service
	customer                                               string
	googlechromepolicyv1batchinheritorgunitpoliciesrequest *GoogleChromePolicyV1BatchInheritOrgUnitPoliciesRequest
	urlParams_                                             gensupport.URLParams
	ctx_                                                   context.Context
	header_                                                http.Header
}

// BatchInherit: Modify multiple policy values that are applied to a
// specific org unit so that they now inherit the value from a parent
// (if applicable). All targets must have the same target format. That
// is to say that they must point to the same target resource and must
// have the same keys specified in `additionalTargetKeyNames`, though
// the values for those keys may be different. On failure the request
// will return the error details as part of the google.rpc.Status.
//
// - customer: ID of the G Suite account or literal "my_customer" for
//   the customer associated to the request.
func (r *CustomersPoliciesOrgunitsService) BatchInherit(customer string, googlechromepolicyv1batchinheritorgunitpoliciesrequest *GoogleChromePolicyV1BatchInheritOrgUnitPoliciesRequest) *CustomersPoliciesOrgunitsBatchInheritCall {
	c := &CustomersPoliciesOrgunitsBatchInheritCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.googlechromepolicyv1batchinheritorgunitpoliciesrequest = googlechromepolicyv1batchinheritorgunitpoliciesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CustomersPoliciesOrgunitsBatchInheritCall) Fields(s ...googleapi.Field) *CustomersPoliciesOrgunitsBatchInheritCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CustomersPoliciesOrgunitsBatchInheritCall) Context(ctx context.Context) *CustomersPoliciesOrgunitsBatchInheritCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CustomersPoliciesOrgunitsBatchInheritCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersPoliciesOrgunitsBatchInheritCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlechromepolicyv1batchinheritorgunitpoliciesrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+customer}/policies/orgunits:batchInherit")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromepolicy.customers.policies.orgunits.batchInherit" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *CustomersPoliciesOrgunitsBatchInheritCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Modify multiple policy values that are applied to a specific org unit so that they now inherit the value from a parent (if applicable). All targets must have the same target format. That is to say that they must point to the same target resource and must have the same keys specified in `additionalTargetKeyNames`, though the values for those keys may be different. On failure the request will return the error details as part of the google.rpc.Status.",
	//   "flatPath": "v1/customers/{customersId}/policies/orgunits:batchInherit",
	//   "httpMethod": "POST",
	//   "id": "chromepolicy.customers.policies.orgunits.batchInherit",
	//   "parameterOrder": [
	//     "customer"
	//   ],
	//   "parameters": {
	//     "customer": {
	//       "description": "ID of the G Suite account or literal \"my_customer\" for the customer associated to the request.",
	//       "location": "path",
	//       "pattern": "^customers/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+customer}/policies/orgunits:batchInherit",
	//   "request": {
	//     "$ref": "GoogleChromePolicyV1BatchInheritOrgUnitPoliciesRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/chrome.management.policy"
	//   ]
	// }

}

// method id "chromepolicy.customers.policies.orgunits.batchModify":

type CustomersPoliciesOrgunitsBatchModifyCall struct {
	s                                                     *Service
	customer                                              string
	googlechromepolicyv1batchmodifyorgunitpoliciesrequest *GoogleChromePolicyV1BatchModifyOrgUnitPoliciesRequest
	urlParams_                                            gensupport.URLParams
	ctx_                                                  context.Context
	header_                                               http.Header
}

// BatchModify: Modify multiple policy values that are applied to a
// specific org unit. All targets must have the same target format. That
// is to say that they must point to the same target resource and must
// have the same keys specified in `additionalTargetKeyNames`, though
// the values for those keys may be different. On failure the request
// will return the error details as part of the google.rpc.Status.
//
// - customer: ID of the G Suite account or literal "my_customer" for
//   the customer associated to the request.
func (r *CustomersPoliciesOrgunitsService) BatchModify(customer string, googlechromepolicyv1batchmodifyorgunitpoliciesrequest *GoogleChromePolicyV1BatchModifyOrgUnitPoliciesRequest) *CustomersPoliciesOrgunitsBatchModifyCall {
	c := &CustomersPoliciesOrgunitsBatchModifyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.googlechromepolicyv1batchmodifyorgunitpoliciesrequest = googlechromepolicyv1batchmodifyorgunitpoliciesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CustomersPoliciesOrgunitsBatchModifyCall) Fields(s ...googleapi.Field) *CustomersPoliciesOrgunitsBatchModifyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CustomersPoliciesOrgunitsBatchModifyCall) Context(ctx context.Context) *CustomersPoliciesOrgunitsBatchModifyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CustomersPoliciesOrgunitsBatchModifyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersPoliciesOrgunitsBatchModifyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlechromepolicyv1batchmodifyorgunitpoliciesrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+customer}/policies/orgunits:batchModify")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromepolicy.customers.policies.orgunits.batchModify" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *CustomersPoliciesOrgunitsBatchModifyCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Modify multiple policy values that are applied to a specific org unit. All targets must have the same target format. That is to say that they must point to the same target resource and must have the same keys specified in `additionalTargetKeyNames`, though the values for those keys may be different. On failure the request will return the error details as part of the google.rpc.Status.",
	//   "flatPath": "v1/customers/{customersId}/policies/orgunits:batchModify",
	//   "httpMethod": "POST",
	//   "id": "chromepolicy.customers.policies.orgunits.batchModify",
	//   "parameterOrder": [
	//     "customer"
	//   ],
	//   "parameters": {
	//     "customer": {
	//       "description": "ID of the G Suite account or literal \"my_customer\" for the customer associated to the request.",
	//       "location": "path",
	//       "pattern": "^customers/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+customer}/policies/orgunits:batchModify",
	//   "request": {
	//     "$ref": "GoogleChromePolicyV1BatchModifyOrgUnitPoliciesRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/chrome.management.policy"
	//   ]
	// }

}

// method id "chromepolicy.customers.policySchemas.get":

type CustomersPolicySchemasGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get a specific policy schema for a customer by its resource
// name.
//
// - name: The policy schema resource name to query.
func (r *CustomersPolicySchemasService) Get(name string) *CustomersPolicySchemasGetCall {
	c := &CustomersPolicySchemasGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CustomersPolicySchemasGetCall) Fields(s ...googleapi.Field) *CustomersPolicySchemasGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *CustomersPolicySchemasGetCall) IfNoneMatch(entityTag string) *CustomersPolicySchemasGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CustomersPolicySchemasGetCall) Context(ctx context.Context) *CustomersPolicySchemasGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CustomersPolicySchemasGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersPolicySchemasGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromepolicy.customers.policySchemas.get" call.
// Exactly one of *GoogleChromePolicyV1PolicySchema or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleChromePolicyV1PolicySchema.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *CustomersPolicySchemasGetCall) Do(opts ...googleapi.CallOption) (*GoogleChromePolicyV1PolicySchema, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleChromePolicyV1PolicySchema{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get a specific policy schema for a customer by its resource name.",
	//   "flatPath": "v1/customers/{customersId}/policySchemas/{policySchemasId}",
	//   "httpMethod": "GET",
	//   "id": "chromepolicy.customers.policySchemas.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The policy schema resource name to query.",
	//       "location": "path",
	//       "pattern": "^customers/[^/]+/policySchemas/.*$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleChromePolicyV1PolicySchema"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/chrome.management.policy",
	//     "https://www.googleapis.com/auth/chrome.management.policy.readonly"
	//   ]
	// }

}

// method id "chromepolicy.customers.policySchemas.list":

type CustomersPolicySchemasListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Gets a list of policy schemas that match a specified filter
// value for a given customer.
//
// - parent: The customer for which the listing request will apply.
func (r *CustomersPolicySchemasService) List(parent string) *CustomersPolicySchemasListCall {
	c := &CustomersPolicySchemasListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": The schema filter used
// to find a particular schema based on fields like its resource name,
// description and `additionalTargetKeyNames`.
func (c *CustomersPolicySchemasListCall) Filter(filter string) *CustomersPolicySchemasListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of policy schemas to return.
func (c *CustomersPolicySchemasListCall) PageSize(pageSize int64) *CustomersPolicySchemasListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The page token
// used to retrieve a specific page of the listing request.
func (c *CustomersPolicySchemasListCall) PageToken(pageToken string) *CustomersPolicySchemasListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CustomersPolicySchemasListCall) Fields(s ...googleapi.Field) *CustomersPolicySchemasListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *CustomersPolicySchemasListCall) IfNoneMatch(entityTag string) *CustomersPolicySchemasListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CustomersPolicySchemasListCall) Context(ctx context.Context) *CustomersPolicySchemasListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CustomersPolicySchemasListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersPolicySchemasListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/policySchemas")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromepolicy.customers.policySchemas.list" call.
// Exactly one of *GoogleChromePolicyV1ListPolicySchemasResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleChromePolicyV1ListPolicySchemasResponse.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *CustomersPolicySchemasListCall) Do(opts ...googleapi.CallOption) (*GoogleChromePolicyV1ListPolicySchemasResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleChromePolicyV1ListPolicySchemasResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a list of policy schemas that match a specified filter value for a given customer.",
	//   "flatPath": "v1/customers/{customersId}/policySchemas",
	//   "httpMethod": "GET",
	//   "id": "chromepolicy.customers.policySchemas.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The schema filter used to find a particular schema based on fields like its resource name, description and `additionalTargetKeyNames`.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of policy schemas to return.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The page token used to retrieve a specific page of the listing request.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The customer for which the listing request will apply.",
	//       "location": "path",
	//       "pattern": "^customers/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/policySchemas",
	//   "response": {
	//     "$ref": "GoogleChromePolicyV1ListPolicySchemasResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/chrome.management.policy",
	//     "https://www.googleapis.com/auth/chrome.management.policy.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CustomersPolicySchemasListCall) Pages(ctx context.Context, f func(*GoogleChromePolicyV1ListPolicySchemasResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "chromepolicy.media.upload":

type MediaUploadCall struct {
	s                                           *Service
	customer                                    string
	googlechromepolicyv1uploadpolicyfilerequest *GoogleChromePolicyV1UploadPolicyFileRequest
	urlParams_                                  gensupport.URLParams
	mediaInfo_                                  *gensupport.MediaInfo
	ctx_                                        context.Context
	header_                                     http.Header
}

// Upload: Creates an enterprise file from the content provided by user.
// Returns a public download url for end user.
//
// - customer: The customer for which the file upload will apply.
func (r *MediaService) Upload(customer string, googlechromepolicyv1uploadpolicyfilerequest *GoogleChromePolicyV1UploadPolicyFileRequest) *MediaUploadCall {
	c := &MediaUploadCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.googlechromepolicyv1uploadpolicyfilerequest = googlechromepolicyv1uploadpolicyfilerequest
	return c
}

// Media specifies the media to upload in one or more chunks. The chunk
// size may be controlled by supplying a MediaOption generated by
// googleapi.ChunkSize. The chunk size defaults to
// googleapi.DefaultUploadChunkSize.The Content-Type header used in the
// upload request will be determined by sniffing the contents of r,
// unless a MediaOption generated by googleapi.ContentType is
// supplied.
// At most one of Media and ResumableMedia may be set.
func (c *MediaUploadCall) Media(r io.Reader, options ...googleapi.MediaOption) *MediaUploadCall {
	c.mediaInfo_ = gensupport.NewInfoFromMedia(r, options)
	return c
}

// ResumableMedia specifies the media to upload in chunks and can be
// canceled with ctx.
//
// Deprecated: use Media instead.
//
// At most one of Media and ResumableMedia may be set. mediaType
// identifies the MIME media type of the upload, such as "image/png". If
// mediaType is "", it will be auto-detected. The provided ctx will
// supersede any context previously provided to the Context method.
func (c *MediaUploadCall) ResumableMedia(ctx context.Context, r io.ReaderAt, size int64, mediaType string) *MediaUploadCall {
	c.ctx_ = ctx
	c.mediaInfo_ = gensupport.NewInfoFromResumableMedia(r, size, mediaType)
	return c
}

// ProgressUpdater provides a callback function that will be called
// after every chunk. It should be a low-latency function in order to
// not slow down the upload operation. This should only be called when
// using ResumableMedia (as opposed to Media).
func (c *MediaUploadCall) ProgressUpdater(pu googleapi.ProgressUpdater) *MediaUploadCall {
	c.mediaInfo_.SetProgressUpdater(pu)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MediaUploadCall) Fields(s ...googleapi.Field) *MediaUploadCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
// This context will supersede any context previously provided to the
// ResumableMedia method.
func (c *MediaUploadCall) Context(ctx context.Context) *MediaUploadCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MediaUploadCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MediaUploadCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlechromepolicyv1uploadpolicyfilerequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+customer}/policies/files:uploadPolicyFile")
	if c.mediaInfo_ != nil {
		urls = googleapi.ResolveRelative(c.s.BasePath, "/upload/v1/{+customer}/policies/files:uploadPolicyFile")
		c.urlParams_.Set("uploadType", c.mediaInfo_.UploadType())
	}
	if body == nil {
		body = new(bytes.Buffer)
		reqHeaders.Set("Content-Type", "application/json")
	}
	body, getBody, cleanup := c.mediaInfo_.UploadRequest(reqHeaders, body)
	defer cleanup()
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	req.GetBody = getBody
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromepolicy.media.upload" call.
// Exactly one of *GoogleChromePolicyV1UploadPolicyFileResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleChromePolicyV1UploadPolicyFileResponse.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *MediaUploadCall) Do(opts ...googleapi.CallOption) (*GoogleChromePolicyV1UploadPolicyFileResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	rx := c.mediaInfo_.ResumableUpload(res.Header.Get("Location"))
	if rx != nil {
		rx.Client = c.s.client
		rx.UserAgent = c.s.userAgent()
		ctx := c.ctx_
		if ctx == nil {
			ctx = context.TODO()
		}
		res, err = rx.Upload(ctx)
		if err != nil {
			return nil, err
		}
		defer res.Body.Close()
		if err := googleapi.CheckResponse(res); err != nil {
			return nil, err
		}
	}
	ret := &GoogleChromePolicyV1UploadPolicyFileResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates an enterprise file from the content provided by user. Returns a public download url for end user.",
	//   "flatPath": "v1/customers/{customersId}/policies/files:uploadPolicyFile",
	//   "httpMethod": "POST",
	//   "id": "chromepolicy.media.upload",
	//   "mediaUpload": {
	//     "accept": [
	//       "*/*"
	//     ],
	//     "protocols": {
	//       "simple": {
	//         "multipart": true,
	//         "path": "/upload/v1/{+customer}/policies/files:uploadPolicyFile"
	//       }
	//     }
	//   },
	//   "parameterOrder": [
	//     "customer"
	//   ],
	//   "parameters": {
	//     "customer": {
	//       "description": "Required. The customer for which the file upload will apply.",
	//       "location": "path",
	//       "pattern": "^customers/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+customer}/policies/files:uploadPolicyFile",
	//   "request": {
	//     "$ref": "GoogleChromePolicyV1UploadPolicyFileRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleChromePolicyV1UploadPolicyFileResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/chrome.management.policy"
	//   ],
	//   "supportsMediaUpload": true
	// }

}
