// Copyright 2022 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package content provides access to the Content API for Shopping.
//
// For product documentation, see: https://developers.google.com/shopping-content/v2/
//
// Creating a client
//
// Usage example:
//
//   import "google.golang.org/api/content/v2.1"
//   ...
//   ctx := context.Background()
//   contentService, err := content.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//   contentService, err := content.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//   config := &oauth2.Config{...}
//   // ...
//   token, err := config.Exchange(ctx, ...)
//   contentService, err := content.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package content // import "google.golang.org/api/content/v2.1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint

const apiId = "content:v2.1"
const apiName = "content"
const apiVersion = "v2.1"
const basePath = "https://shoppingcontent.googleapis.com/content/v2.1/"
const mtlsBasePath = "https://shoppingcontent.mtls.googleapis.com/content/v2.1/"

// OAuth2 scopes used by this API.
const (
	// Manage your product listings and accounts for Google Shopping
	ContentScope = "https://www.googleapis.com/auth/content"
)

// NewService creates a new APIService.
func NewService(ctx context.Context, opts ...option.ClientOption) (*APIService, error) {
	scopesOption := option.WithScopes(
		"https://www.googleapis.com/auth/content",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new APIService. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*APIService, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &APIService{client: client, BasePath: basePath}
	s.Accounts = NewAccountsService(s)
	s.Accountstatuses = NewAccountstatusesService(s)
	s.Accounttax = NewAccounttaxService(s)
	s.Buyongoogleprograms = NewBuyongoogleprogramsService(s)
	s.Collections = NewCollectionsService(s)
	s.Collectionstatuses = NewCollectionstatusesService(s)
	s.Csses = NewCssesService(s)
	s.Datafeeds = NewDatafeedsService(s)
	s.Datafeedstatuses = NewDatafeedstatusesService(s)
	s.Freelistingsprogram = NewFreelistingsprogramService(s)
	s.Liasettings = NewLiasettingsService(s)
	s.Localinventory = NewLocalinventoryService(s)
	s.Orderinvoices = NewOrderinvoicesService(s)
	s.Orderreports = NewOrderreportsService(s)
	s.Orderreturns = NewOrderreturnsService(s)
	s.Orders = NewOrdersService(s)
	s.Ordertrackingsignals = NewOrdertrackingsignalsService(s)
	s.Pos = NewPosService(s)
	s.Products = NewProductsService(s)
	s.Productstatuses = NewProductstatusesService(s)
	s.Promotions = NewPromotionsService(s)
	s.Pubsubnotificationsettings = NewPubsubnotificationsettingsService(s)
	s.Regionalinventory = NewRegionalinventoryService(s)
	s.Regions = NewRegionsService(s)
	s.Reports = NewReportsService(s)
	s.Repricingrules = NewRepricingrulesService(s)
	s.Returnaddress = NewReturnaddressService(s)
	s.Returnpolicy = NewReturnpolicyService(s)
	s.Returnpolicyonline = NewReturnpolicyonlineService(s)
	s.Settlementreports = NewSettlementreportsService(s)
	s.Settlementtransactions = NewSettlementtransactionsService(s)
	s.Shippingsettings = NewShippingsettingsService(s)
	s.Shoppingadsprogram = NewShoppingadsprogramService(s)
	return s, nil
}

type APIService struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Accounts *AccountsService

	Accountstatuses *AccountstatusesService

	Accounttax *AccounttaxService

	Buyongoogleprograms *BuyongoogleprogramsService

	Collections *CollectionsService

	Collectionstatuses *CollectionstatusesService

	Csses *CssesService

	Datafeeds *DatafeedsService

	Datafeedstatuses *DatafeedstatusesService

	Freelistingsprogram *FreelistingsprogramService

	Liasettings *LiasettingsService

	Localinventory *LocalinventoryService

	Orderinvoices *OrderinvoicesService

	Orderreports *OrderreportsService

	Orderreturns *OrderreturnsService

	Orders *OrdersService

	Ordertrackingsignals *OrdertrackingsignalsService

	Pos *PosService

	Products *ProductsService

	Productstatuses *ProductstatusesService

	Promotions *PromotionsService

	Pubsubnotificationsettings *PubsubnotificationsettingsService

	Regionalinventory *RegionalinventoryService

	Regions *RegionsService

	Reports *ReportsService

	Repricingrules *RepricingrulesService

	Returnaddress *ReturnaddressService

	Returnpolicy *ReturnpolicyService

	Returnpolicyonline *ReturnpolicyonlineService

	Settlementreports *SettlementreportsService

	Settlementtransactions *SettlementtransactionsService

	Shippingsettings *ShippingsettingsService

	Shoppingadsprogram *ShoppingadsprogramService
}

func (s *APIService) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewAccountsService(s *APIService) *AccountsService {
	rs := &AccountsService{s: s}
	rs.Credentials = NewAccountsCredentialsService(s)
	rs.Labels = NewAccountsLabelsService(s)
	rs.Returncarrier = NewAccountsReturncarrierService(s)
	return rs
}

type AccountsService struct {
	s *APIService

	Credentials *AccountsCredentialsService

	Labels *AccountsLabelsService

	Returncarrier *AccountsReturncarrierService
}

func NewAccountsCredentialsService(s *APIService) *AccountsCredentialsService {
	rs := &AccountsCredentialsService{s: s}
	return rs
}

type AccountsCredentialsService struct {
	s *APIService
}

func NewAccountsLabelsService(s *APIService) *AccountsLabelsService {
	rs := &AccountsLabelsService{s: s}
	return rs
}

type AccountsLabelsService struct {
	s *APIService
}

func NewAccountsReturncarrierService(s *APIService) *AccountsReturncarrierService {
	rs := &AccountsReturncarrierService{s: s}
	return rs
}

type AccountsReturncarrierService struct {
	s *APIService
}

func NewAccountstatusesService(s *APIService) *AccountstatusesService {
	rs := &AccountstatusesService{s: s}
	return rs
}

type AccountstatusesService struct {
	s *APIService
}

func NewAccounttaxService(s *APIService) *AccounttaxService {
	rs := &AccounttaxService{s: s}
	return rs
}

type AccounttaxService struct {
	s *APIService
}

func NewBuyongoogleprogramsService(s *APIService) *BuyongoogleprogramsService {
	rs := &BuyongoogleprogramsService{s: s}
	return rs
}

type BuyongoogleprogramsService struct {
	s *APIService
}

func NewCollectionsService(s *APIService) *CollectionsService {
	rs := &CollectionsService{s: s}
	return rs
}

type CollectionsService struct {
	s *APIService
}

func NewCollectionstatusesService(s *APIService) *CollectionstatusesService {
	rs := &CollectionstatusesService{s: s}
	return rs
}

type CollectionstatusesService struct {
	s *APIService
}

func NewCssesService(s *APIService) *CssesService {
	rs := &CssesService{s: s}
	return rs
}

type CssesService struct {
	s *APIService
}

func NewDatafeedsService(s *APIService) *DatafeedsService {
	rs := &DatafeedsService{s: s}
	return rs
}

type DatafeedsService struct {
	s *APIService
}

func NewDatafeedstatusesService(s *APIService) *DatafeedstatusesService {
	rs := &DatafeedstatusesService{s: s}
	return rs
}

type DatafeedstatusesService struct {
	s *APIService
}

func NewFreelistingsprogramService(s *APIService) *FreelistingsprogramService {
	rs := &FreelistingsprogramService{s: s}
	return rs
}

type FreelistingsprogramService struct {
	s *APIService
}

func NewLiasettingsService(s *APIService) *LiasettingsService {
	rs := &LiasettingsService{s: s}
	return rs
}

type LiasettingsService struct {
	s *APIService
}

func NewLocalinventoryService(s *APIService) *LocalinventoryService {
	rs := &LocalinventoryService{s: s}
	return rs
}

type LocalinventoryService struct {
	s *APIService
}

func NewOrderinvoicesService(s *APIService) *OrderinvoicesService {
	rs := &OrderinvoicesService{s: s}
	return rs
}

type OrderinvoicesService struct {
	s *APIService
}

func NewOrderreportsService(s *APIService) *OrderreportsService {
	rs := &OrderreportsService{s: s}
	return rs
}

type OrderreportsService struct {
	s *APIService
}

func NewOrderreturnsService(s *APIService) *OrderreturnsService {
	rs := &OrderreturnsService{s: s}
	rs.Labels = NewOrderreturnsLabelsService(s)
	return rs
}

type OrderreturnsService struct {
	s *APIService

	Labels *OrderreturnsLabelsService
}

func NewOrderreturnsLabelsService(s *APIService) *OrderreturnsLabelsService {
	rs := &OrderreturnsLabelsService{s: s}
	return rs
}

type OrderreturnsLabelsService struct {
	s *APIService
}

func NewOrdersService(s *APIService) *OrdersService {
	rs := &OrdersService{s: s}
	return rs
}

type OrdersService struct {
	s *APIService
}

func NewOrdertrackingsignalsService(s *APIService) *OrdertrackingsignalsService {
	rs := &OrdertrackingsignalsService{s: s}
	return rs
}

type OrdertrackingsignalsService struct {
	s *APIService
}

func NewPosService(s *APIService) *PosService {
	rs := &PosService{s: s}
	return rs
}

type PosService struct {
	s *APIService
}

func NewProductsService(s *APIService) *ProductsService {
	rs := &ProductsService{s: s}
	return rs
}

type ProductsService struct {
	s *APIService
}

func NewProductstatusesService(s *APIService) *ProductstatusesService {
	rs := &ProductstatusesService{s: s}
	rs.Repricingreports = NewProductstatusesRepricingreportsService(s)
	return rs
}

type ProductstatusesService struct {
	s *APIService

	Repricingreports *ProductstatusesRepricingreportsService
}

func NewProductstatusesRepricingreportsService(s *APIService) *ProductstatusesRepricingreportsService {
	rs := &ProductstatusesRepricingreportsService{s: s}
	return rs
}

type ProductstatusesRepricingreportsService struct {
	s *APIService
}

func NewPromotionsService(s *APIService) *PromotionsService {
	rs := &PromotionsService{s: s}
	return rs
}

type PromotionsService struct {
	s *APIService
}

func NewPubsubnotificationsettingsService(s *APIService) *PubsubnotificationsettingsService {
	rs := &PubsubnotificationsettingsService{s: s}
	return rs
}

type PubsubnotificationsettingsService struct {
	s *APIService
}

func NewRegionalinventoryService(s *APIService) *RegionalinventoryService {
	rs := &RegionalinventoryService{s: s}
	return rs
}

type RegionalinventoryService struct {
	s *APIService
}

func NewRegionsService(s *APIService) *RegionsService {
	rs := &RegionsService{s: s}
	return rs
}

type RegionsService struct {
	s *APIService
}

func NewReportsService(s *APIService) *ReportsService {
	rs := &ReportsService{s: s}
	return rs
}

type ReportsService struct {
	s *APIService
}

func NewRepricingrulesService(s *APIService) *RepricingrulesService {
	rs := &RepricingrulesService{s: s}
	rs.Repricingreports = NewRepricingrulesRepricingreportsService(s)
	return rs
}

type RepricingrulesService struct {
	s *APIService

	Repricingreports *RepricingrulesRepricingreportsService
}

func NewRepricingrulesRepricingreportsService(s *APIService) *RepricingrulesRepricingreportsService {
	rs := &RepricingrulesRepricingreportsService{s: s}
	return rs
}

type RepricingrulesRepricingreportsService struct {
	s *APIService
}

func NewReturnaddressService(s *APIService) *ReturnaddressService {
	rs := &ReturnaddressService{s: s}
	return rs
}

type ReturnaddressService struct {
	s *APIService
}

func NewReturnpolicyService(s *APIService) *ReturnpolicyService {
	rs := &ReturnpolicyService{s: s}
	return rs
}

type ReturnpolicyService struct {
	s *APIService
}

func NewReturnpolicyonlineService(s *APIService) *ReturnpolicyonlineService {
	rs := &ReturnpolicyonlineService{s: s}
	return rs
}

type ReturnpolicyonlineService struct {
	s *APIService
}

func NewSettlementreportsService(s *APIService) *SettlementreportsService {
	rs := &SettlementreportsService{s: s}
	return rs
}

type SettlementreportsService struct {
	s *APIService
}

func NewSettlementtransactionsService(s *APIService) *SettlementtransactionsService {
	rs := &SettlementtransactionsService{s: s}
	return rs
}

type SettlementtransactionsService struct {
	s *APIService
}

func NewShippingsettingsService(s *APIService) *ShippingsettingsService {
	rs := &ShippingsettingsService{s: s}
	return rs
}

type ShippingsettingsService struct {
	s *APIService
}

func NewShoppingadsprogramService(s *APIService) *ShoppingadsprogramService {
	rs := &ShoppingadsprogramService{s: s}
	return rs
}

type ShoppingadsprogramService struct {
	s *APIService
}

// Account: Account data. After the creation of a new account it may
// take a few minutes before it is fully operational. The methods
// delete, insert, and update require the admin role.
type Account struct {
	// AccountManagement: Output only. How the account is managed.
	// Acceptable values are: - "manual" - "automatic"
	AccountManagement string `json:"accountManagement,omitempty"`

	// AdsLinks: Linked Ads accounts that are active or pending approval. To
	// create a new link request, add a new link with status `active` to the
	// list. It will remain in a `pending` state until approved or rejected
	// either in the Ads interface or through the AdWords API. To delete an
	// active link, or to cancel a link request, remove it from the list.
	AdsLinks []*AccountAdsLink `json:"adsLinks,omitempty"`

	// AdultContent: Indicates whether the merchant sells adult content.
	AdultContent bool `json:"adultContent,omitempty"`

	// AutomaticLabelIds: Automatically created label IDs that are assigned
	// to the account by CSS Center.
	AutomaticLabelIds googleapi.Uint64s `json:"automaticLabelIds,omitempty"`

	// BusinessInformation: The business information of the account.
	BusinessInformation *AccountBusinessInformation `json:"businessInformation,omitempty"`

	// CssId: ID of CSS the account belongs to.
	CssId uint64 `json:"cssId,omitempty,string"`

	// GoogleMyBusinessLink: The Business Profile which is linked or in the
	// process of being linked with the Merchant Center account.
	GoogleMyBusinessLink *AccountGoogleMyBusinessLink `json:"googleMyBusinessLink,omitempty"`

	// Id: Required for update. Merchant Center account ID.
	Id uint64 `json:"id,omitempty,string"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#account".
	Kind string `json:"kind,omitempty"`

	// LabelIds: Manually created label IDs that are assigned to the account
	// by CSS.
	LabelIds googleapi.Uint64s `json:"labelIds,omitempty"`

	// Name: Required. Display name for the account.
	Name string `json:"name,omitempty"`

	// SellerId: Client-specific, locally-unique, internal ID for the child
	// account.
	SellerId string `json:"sellerId,omitempty"`

	// Users: Users with access to the account. Every account (except for
	// subaccounts) must have at least one admin user.
	Users []*AccountUser `json:"users,omitempty"`

	// WebsiteUrl: The merchant's website.
	WebsiteUrl string `json:"websiteUrl,omitempty"`

	// YoutubeChannelLinks: Linked YouTube channels that are active or
	// pending approval. To create a new link request, add a new link with
	// status `active` to the list. It will remain in a `pending` state
	// until approved or rejected in the YT Creator Studio interface. To
	// delete an active link, or to cancel a link request, remove it from
	// the list.
	YoutubeChannelLinks []*AccountYouTubeChannelLink `json:"youtubeChannelLinks,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AccountManagement")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccountManagement") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Account) MarshalJSON() ([]byte, error) {
	type NoMethod Account
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AccountAddress struct {
	// Country: CLDR country code (e.g. "US"). All MCA sub-accounts inherit
	// the country of their parent MCA by default, however the country can
	// be updated for individual sub-accounts.
	Country string `json:"country,omitempty"`

	// Locality: City, town or commune. May also include dependent
	// localities or sublocalities (e.g. neighborhoods or suburbs).
	Locality string `json:"locality,omitempty"`

	// PostalCode: Postal code or ZIP (e.g. "94043").
	PostalCode string `json:"postalCode,omitempty"`

	// Region: Top-level administrative subdivision of the country. For
	// example, a state like California ("CA") or a province like Quebec
	// ("QC").
	Region string `json:"region,omitempty"`

	// StreetAddress: Street-level part of the address.
	StreetAddress string `json:"streetAddress,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Country") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Country") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountAddress) MarshalJSON() ([]byte, error) {
	type NoMethod AccountAddress
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AccountAdsLink struct {
	// AdsId: Customer ID of the Ads account.
	AdsId uint64 `json:"adsId,omitempty,string"`

	// Status: Status of the link between this Merchant Center account and
	// the Ads account. Upon retrieval, it represents the actual status of
	// the link and can be either `active` if it was approved in Google Ads
	// or `pending` if it's pending approval. Upon insertion, it represents
	// the *intended* status of the link. Re-uploading a link with status
	// `active` when it's still pending or with status `pending` when it's
	// already active will have no effect: the status will remain unchanged.
	// Re-uploading a link with deprecated status `inactive` is equivalent
	// to not submitting the link at all and will delete the link if it was
	// active or cancel the link request if it was pending. Acceptable
	// values are: - "active" - "pending"
	Status string `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdsId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdsId") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountAdsLink) MarshalJSON() ([]byte, error) {
	type NoMethod AccountAdsLink
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AccountBusinessInformation struct {
	// Address: The address of the business.
	Address *AccountAddress `json:"address,omitempty"`

	// CustomerService: The customer service information of the business.
	CustomerService *AccountCustomerService `json:"customerService,omitempty"`

	// KoreanBusinessRegistrationNumber: The 10-digit Korean business
	// registration number
	// (https://support.google.com/merchants/answer/9037766) separated with
	// dashes in the format: XXX-XX-XXXXX. This field will only be updated
	// if explicitly set.
	KoreanBusinessRegistrationNumber string `json:"koreanBusinessRegistrationNumber,omitempty"`

	// PhoneNumber: The phone number of the business. This can only be
	// updated if a verified phone number is not already set. To replace a
	// verified phone number use the `Accounts.requestphoneverification` and
	// `Accounts.verifyphonenumber`.
	PhoneNumber string `json:"phoneNumber,omitempty"`

	// PhoneVerificationStatus: Verification status of the phone number of
	// the business. This status is read only and can be updated only by
	// successful phone verification. Acceptable values are: - "verified"
	// - "unverified"
	PhoneVerificationStatus string `json:"phoneVerificationStatus,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Address") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Address") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountBusinessInformation) MarshalJSON() ([]byte, error) {
	type NoMethod AccountBusinessInformation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AccountCredentials: Credentials allowing Google to call a partner's
// API on behalf of a merchant.
type AccountCredentials struct {
	// AccessToken: An OAuth access token.
	AccessToken string `json:"accessToken,omitempty"`

	// ExpiresIn: The amount of time, in seconds, after which the access
	// token is no longer valid.
	ExpiresIn int64 `json:"expiresIn,omitempty,string"`

	// Purpose: Indicates to Google how Google should use these OAuth
	// tokens.
	//
	// Possible values:
	//   "ACCOUNT_CREDENTIALS_PURPOSE_UNSPECIFIED" - Unknown purpose.
	//   "SHOPIFY_ORDER_MANAGEMENT" - The credentials allow Google to manage
	// Shopify orders on behalf of the merchant (deprecated).
	//   "SHOPIFY_INTEGRATION" - The credentials allow Google to manage
	// Shopify integration on behalf of the merchant.
	Purpose string `json:"purpose,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AccessToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountCredentials) MarshalJSON() ([]byte, error) {
	type NoMethod AccountCredentials
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AccountCustomerService struct {
	// Email: Customer service email.
	Email string `json:"email,omitempty"`

	// PhoneNumber: Customer service phone number.
	PhoneNumber string `json:"phoneNumber,omitempty"`

	// Url: Customer service URL.
	Url string `json:"url,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Email") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountCustomerService) MarshalJSON() ([]byte, error) {
	type NoMethod AccountCustomerService
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AccountGoogleMyBusinessLink struct {
	// GmbAccountId: The ID of the Business Profile. If this is provided,
	// then `gmbEmail` is ignored. The value of this field should match the
	// `accountId` used by the Business Profile API.
	GmbAccountId string `json:"gmbAccountId,omitempty"`

	// GmbEmail: The Business Profile email address of a specific account
	// within a Business Profile. A sample account within a Business Profile
	// could be a business account with set of locations, managed under the
	// Business Profile.
	GmbEmail string `json:"gmbEmail,omitempty"`

	// Status: Status of the link between this Merchant Center account and
	// the Business Profile. Acceptable values are: - "active" -
	// "pending"
	Status string `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GmbAccountId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GmbAccountId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountGoogleMyBusinessLink) MarshalJSON() ([]byte, error) {
	type NoMethod AccountGoogleMyBusinessLink
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AccountIdentifier struct {
	// AggregatorId: The aggregator ID, set for aggregators and subaccounts
	// (in that case, it represents the aggregator of the subaccount).
	AggregatorId uint64 `json:"aggregatorId,omitempty,string"`

	// MerchantId: The merchant account ID, set for individual accounts and
	// subaccounts.
	MerchantId uint64 `json:"merchantId,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "AggregatorId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AggregatorId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountIdentifier) MarshalJSON() ([]byte, error) {
	type NoMethod AccountIdentifier
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AccountLabel: Label assigned by CSS domain or CSS group to one of its
// sub-accounts.
type AccountLabel struct {
	// AccountId: Immutable. The ID of account this label belongs to.
	AccountId int64 `json:"accountId,omitempty,string"`

	// Description: The description of this label.
	Description string `json:"description,omitempty"`

	// LabelId: Output only. The ID of the label.
	LabelId int64 `json:"labelId,omitempty,string"`

	// LabelType: Output only. The type of this label.
	//
	// Possible values:
	//   "LABEL_TYPE_UNSPECIFIED" - Unknown label type.
	//   "MANUAL" - Indicates that the label was created manually.
	//   "AUTOMATIC" - Indicates that the label was created automatically by
	// CSS Center.
	LabelType string `json:"labelType,omitempty"`

	// Name: The display name of this label.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AccountId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccountId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountLabel) MarshalJSON() ([]byte, error) {
	type NoMethod AccountLabel
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AccountReturnCarrier:  The return carrier information. This service
// is designed for merchants enrolled in the Buy on Google program.
type AccountReturnCarrier struct {
	// CarrierAccountId: Output only. Immutable. The Google-provided unique
	// carrier ID, used to update the resource.
	CarrierAccountId int64 `json:"carrierAccountId,omitempty,string"`

	// CarrierAccountName: Name of the carrier account.
	CarrierAccountName string `json:"carrierAccountName,omitempty"`

	// CarrierAccountNumber: Number of the carrier account.
	CarrierAccountNumber string `json:"carrierAccountNumber,omitempty"`

	// CarrierCode: The carrier code enum. Accepts the values FEDEX or UPS.
	//
	// Possible values:
	//   "CARRIER_CODE_UNSPECIFIED" - Carrier not specified
	//   "FEDEX" - FedEx carrier
	//   "UPS" - UPS carrier
	CarrierCode string `json:"carrierCode,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CarrierAccountId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CarrierAccountId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AccountReturnCarrier) MarshalJSON() ([]byte, error) {
	type NoMethod AccountReturnCarrier
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AccountStatus: The status of an account, i.e., information about its
// products, which is computed offline and not returned immediately at
// insertion time.
type AccountStatus struct {
	// AccountId: The ID of the account for which the status is reported.
	AccountId string `json:"accountId,omitempty"`

	// AccountLevelIssues: A list of account level issues.
	AccountLevelIssues []*AccountStatusAccountLevelIssue `json:"accountLevelIssues,omitempty"`

	// AccountManagement: How the account is managed. Acceptable values are:
	// - "manual" - "automatic"
	AccountManagement string `json:"accountManagement,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#accountStatus"
	Kind string `json:"kind,omitempty"`

	// Products: List of product-related data by channel, destination, and
	// country. Data in this field may be delayed by up to 30 minutes.
	Products []*AccountStatusProducts `json:"products,omitempty"`

	// WebsiteClaimed: Whether the account's website is claimed or not.
	WebsiteClaimed bool `json:"websiteClaimed,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AccountId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccountId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountStatus) MarshalJSON() ([]byte, error) {
	type NoMethod AccountStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AccountStatusAccountLevelIssue struct {
	// Country: Country for which this issue is reported.
	Country string `json:"country,omitempty"`

	// Destination: The destination the issue applies to. If this field is
	// empty then the issue applies to all available destinations.
	Destination string `json:"destination,omitempty"`

	// Detail: Additional details about the issue.
	Detail string `json:"detail,omitempty"`

	// Documentation: The URL of a web page to help resolving this issue.
	Documentation string `json:"documentation,omitempty"`

	// Id: Issue identifier.
	Id string `json:"id,omitempty"`

	// Severity: Severity of the issue. Acceptable values are: -
	// "critical" - "error" - "suggestion"
	Severity string `json:"severity,omitempty"`

	// Title: Short description of the issue.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Country") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Country") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountStatusAccountLevelIssue) MarshalJSON() ([]byte, error) {
	type NoMethod AccountStatusAccountLevelIssue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AccountStatusItemLevelIssue struct {
	// AttributeName: The attribute's name, if the issue is caused by a
	// single attribute.
	AttributeName string `json:"attributeName,omitempty"`

	// Code: The error code of the issue.
	Code string `json:"code,omitempty"`

	// Description: A short issue description in English.
	Description string `json:"description,omitempty"`

	// Detail: A detailed issue description in English.
	Detail string `json:"detail,omitempty"`

	// Documentation: The URL of a web page to help with resolving this
	// issue.
	Documentation string `json:"documentation,omitempty"`

	// NumItems: Number of items with this issue.
	NumItems int64 `json:"numItems,omitempty,string"`

	// Resolution: Whether the issue can be resolved by the merchant.
	Resolution string `json:"resolution,omitempty"`

	// Servability: How this issue affects serving of the offer.
	Servability string `json:"servability,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AttributeName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AttributeName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountStatusItemLevelIssue) MarshalJSON() ([]byte, error) {
	type NoMethod AccountStatusItemLevelIssue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AccountStatusProducts struct {
	// Channel: The channel the data applies to. Acceptable values are: -
	// "local" - "online"
	Channel string `json:"channel,omitempty"`

	// Country: The country the data applies to.
	Country string `json:"country,omitempty"`

	// Destination: The destination the data applies to.
	Destination string `json:"destination,omitempty"`

	// ItemLevelIssues: List of item-level issues.
	ItemLevelIssues []*AccountStatusItemLevelIssue `json:"itemLevelIssues,omitempty"`

	// Statistics: Aggregated product statistics.
	Statistics *AccountStatusStatistics `json:"statistics,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Channel") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Channel") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountStatusProducts) MarshalJSON() ([]byte, error) {
	type NoMethod AccountStatusProducts
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AccountStatusStatistics struct {
	// Active: Number of active offers.
	Active int64 `json:"active,omitempty,string"`

	// Disapproved: Number of disapproved offers.
	Disapproved int64 `json:"disapproved,omitempty,string"`

	// Expiring: Number of expiring offers.
	Expiring int64 `json:"expiring,omitempty,string"`

	// Pending: Number of pending offers.
	Pending int64 `json:"pending,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Active") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Active") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountStatusStatistics) MarshalJSON() ([]byte, error) {
	type NoMethod AccountStatusStatistics
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AccountTax: The tax settings of a merchant account. All methods
// require the admin role.
type AccountTax struct {
	// AccountId: Required. The ID of the account to which these account tax
	// settings belong.
	AccountId uint64 `json:"accountId,omitempty,string"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#accountTax".
	Kind string `json:"kind,omitempty"`

	// Rules: Tax rules. Updating the tax rules will enable US taxes (not
	// reversible). Defining no rules is equivalent to not charging tax at
	// all.
	Rules []*AccountTaxTaxRule `json:"rules,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AccountId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccountId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountTax) MarshalJSON() ([]byte, error) {
	type NoMethod AccountTax
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AccountTaxTaxRule: Tax calculation rule to apply in a state or
// province (USA only).
type AccountTaxTaxRule struct {
	// Country: Country code in which tax is applicable.
	Country string `json:"country,omitempty"`

	// LocationId: Required. State (or province) is which the tax is
	// applicable, described by its location ID (also called criteria ID).
	LocationId uint64 `json:"locationId,omitempty,string"`

	// RatePercent: Explicit tax rate in percent, represented as a floating
	// point number without the percentage character. Must not be negative.
	RatePercent string `json:"ratePercent,omitempty"`

	// ShippingTaxed: If true, shipping charges are also taxed.
	ShippingTaxed bool `json:"shippingTaxed,omitempty"`

	// UseGlobalRate: Whether the tax rate is taken from a global tax table
	// or specified explicitly.
	UseGlobalRate bool `json:"useGlobalRate,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Country") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Country") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountTaxTaxRule) MarshalJSON() ([]byte, error) {
	type NoMethod AccountTaxTaxRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AccountUser struct {
	// Admin: Whether user is an admin.
	Admin bool `json:"admin,omitempty"`

	// EmailAddress: User's email address.
	EmailAddress string `json:"emailAddress,omitempty"`

	// OrderManager: Whether user is an order manager.
	OrderManager bool `json:"orderManager,omitempty"`

	// PaymentsAnalyst: Whether user can access payment statements.
	PaymentsAnalyst bool `json:"paymentsAnalyst,omitempty"`

	// PaymentsManager: Whether user can manage payment settings.
	PaymentsManager bool `json:"paymentsManager,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Admin") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Admin") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountUser) MarshalJSON() ([]byte, error) {
	type NoMethod AccountUser
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AccountYouTubeChannelLink struct {
	// ChannelId: Channel ID.
	ChannelId string `json:"channelId,omitempty"`

	// Status: Status of the link between this Merchant Center account and
	// the YouTube channel. Upon retrieval, it represents the actual status
	// of the link and can be either `active` if it was approved in YT
	// Creator Studio or `pending` if it's pending approval. Upon insertion,
	// it represents the *intended* status of the link. Re-uploading a link
	// with status `active` when it's still pending or with status `pending`
	// when it's already active will have no effect: the status will remain
	// unchanged. Re-uploading a link with deprecated status `inactive` is
	// equivalent to not submitting the link at all and will delete the link
	// if it was active or cancel the link request if it was pending.
	Status string `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ChannelId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ChannelId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountYouTubeChannelLink) MarshalJSON() ([]byte, error) {
	type NoMethod AccountYouTubeChannelLink
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AccountsAuthInfoResponse struct {
	// AccountIdentifiers: The account identifiers corresponding to the
	// authenticated user. - For an individual account: only the merchant ID
	// is defined - For an aggregator: only the aggregator ID is defined -
	// For a subaccount of an MCA: both the merchant ID and the aggregator
	// ID are defined.
	AccountIdentifiers []*AccountIdentifier `json:"accountIdentifiers,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#accountsAuthInfoResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AccountIdentifiers")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccountIdentifiers") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AccountsAuthInfoResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AccountsAuthInfoResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AccountsClaimWebsiteResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#accountsClaimWebsiteResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountsClaimWebsiteResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AccountsClaimWebsiteResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AccountsCustomBatchRequest struct {
	// Entries: The request entries to be processed in the batch.
	Entries []*AccountsCustomBatchRequestEntry `json:"entries,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Entries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountsCustomBatchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AccountsCustomBatchRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AccountsCustomBatchRequestEntry: A batch entry encoding a single
// non-batch accounts request.
type AccountsCustomBatchRequestEntry struct {
	// Account: The account to create or update. Only defined if the method
	// is `insert` or `update`.
	Account *Account `json:"account,omitempty"`

	// AccountId: The ID of the targeted account. Only defined if the method
	// is not `insert`.
	AccountId uint64 `json:"accountId,omitempty,string"`

	// BatchId: An entry ID, unique within the batch request.
	BatchId int64 `json:"batchId,omitempty"`

	// Force: Whether the account should be deleted if the account has
	// offers. Only applicable if the method is `delete`.
	Force bool `json:"force,omitempty"`

	// LabelIds: Label IDs for the 'updatelabels' request.
	LabelIds googleapi.Uint64s `json:"labelIds,omitempty"`

	// LinkRequest: Details about the `link` request.
	LinkRequest *AccountsCustomBatchRequestEntryLinkRequest `json:"linkRequest,omitempty"`

	// MerchantId: The ID of the managing account.
	MerchantId uint64 `json:"merchantId,omitempty,string"`

	// Method: The method of the batch entry. Acceptable values are: -
	// "claimWebsite" - "delete" - "get" - "insert" - "link" -
	// "update"
	Method string `json:"method,omitempty"`

	// Overwrite: Only applicable if the method is `claimwebsite`. Indicates
	// whether or not to take the claim from another account in case there
	// is a conflict.
	Overwrite bool `json:"overwrite,omitempty"`

	// View: Controls which fields are visible. Only applicable if the
	// method is 'get'.
	View string `json:"view,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Account") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Account") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountsCustomBatchRequestEntry) MarshalJSON() ([]byte, error) {
	type NoMethod AccountsCustomBatchRequestEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AccountsCustomBatchRequestEntryLinkRequest struct {
	// Action: Action to perform for this link. The "request" action is
	// only available to select merchants. Acceptable values are: -
	// "approve" - "remove" - "request"
	Action string `json:"action,omitempty"`

	// LinkType: Type of the link between the two accounts. Acceptable
	// values are: - "channelPartner" - "eCommercePlatform" -
	// "paymentServiceProvider"
	LinkType string `json:"linkType,omitempty"`

	// LinkedAccountId: The ID of the linked account.
	LinkedAccountId string `json:"linkedAccountId,omitempty"`

	// Services: Provided services. Acceptable values are: -
	// "shoppingAdsProductManagement" -
	// "shoppingActionsProductManagement" -
	// "shoppingActionsOrderManagement" - "paymentProcessing"
	Services []string `json:"services,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Action") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountsCustomBatchRequestEntryLinkRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AccountsCustomBatchRequestEntryLinkRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AccountsCustomBatchResponse struct {
	// Entries: The result of the execution of the batch requests.
	Entries []*AccountsCustomBatchResponseEntry `json:"entries,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#accountsCustomBatchResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Entries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountsCustomBatchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AccountsCustomBatchResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AccountsCustomBatchResponseEntry: A batch entry encoding a single
// non-batch accounts response.
type AccountsCustomBatchResponseEntry struct {
	// Account: The retrieved, created, or updated account. Not defined if
	// the method was `delete`, `claimwebsite` or `link`.
	Account *Account `json:"account,omitempty"`

	// BatchId: The ID of the request entry this entry responds to.
	BatchId int64 `json:"batchId,omitempty"`

	// Errors: A list of errors defined if and only if the request failed.
	Errors *Errors `json:"errors,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#accountsCustomBatchResponseEntry"
	Kind string `json:"kind,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Account") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Account") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountsCustomBatchResponseEntry) MarshalJSON() ([]byte, error) {
	type NoMethod AccountsCustomBatchResponseEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AccountsLinkRequest struct {
	// Action: Action to perform for this link. The "request" action is
	// only available to select merchants. Acceptable values are: -
	// "approve" - "remove" - "request"
	Action string `json:"action,omitempty"`

	// ECommercePlatformLinkInfo: Additional information required for
	// `eCommercePlatform` link type.
	ECommercePlatformLinkInfo *ECommercePlatformLinkInfo `json:"eCommercePlatformLinkInfo,omitempty"`

	// LinkType: Type of the link between the two accounts. Acceptable
	// values are: - "channelPartner" - "eCommercePlatform" -
	// "paymentServiceProvider"
	LinkType string `json:"linkType,omitempty"`

	// LinkedAccountId: The ID of the linked account.
	LinkedAccountId string `json:"linkedAccountId,omitempty"`

	// PaymentServiceProviderLinkInfo: Additional information required for
	// `paymentServiceProvider` link type.
	PaymentServiceProviderLinkInfo *PaymentServiceProviderLinkInfo `json:"paymentServiceProviderLinkInfo,omitempty"`

	// Services:  Acceptable values are: - "shoppingAdsProductManagement"
	// - "shoppingActionsProductManagement" -
	// "shoppingActionsOrderManagement" - "paymentProcessing"
	Services []string `json:"services,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Action") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountsLinkRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AccountsLinkRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AccountsLinkResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#accountsLinkResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountsLinkResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AccountsLinkResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AccountsListLinksResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#accountsListLinksResponse".
	Kind string `json:"kind,omitempty"`

	// Links: The list of available links.
	Links []*LinkedAccount `json:"links,omitempty"`

	// NextPageToken: The token for the retrieval of the next page of links.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountsListLinksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AccountsListLinksResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AccountsListResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#accountsListResponse".
	Kind string `json:"kind,omitempty"`

	// NextPageToken: The token for the retrieval of the next page of
	// accounts.
	NextPageToken string `json:"nextPageToken,omitempty"`

	Resources []*Account `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountsListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AccountsListResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AccountsUpdateLabelsRequest struct {
	// LabelIds: The IDs of labels that should be assigned to the account.
	LabelIds googleapi.Uint64s `json:"labelIds,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LabelIds") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LabelIds") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountsUpdateLabelsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AccountsUpdateLabelsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AccountsUpdateLabelsResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#accountsUpdateLabelsResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountsUpdateLabelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AccountsUpdateLabelsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AccountstatusesCustomBatchRequest struct {
	// Entries: The request entries to be processed in the batch.
	Entries []*AccountstatusesCustomBatchRequestEntry `json:"entries,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Entries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountstatusesCustomBatchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AccountstatusesCustomBatchRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AccountstatusesCustomBatchRequestEntry: A batch entry encoding a
// single non-batch accountstatuses request.
type AccountstatusesCustomBatchRequestEntry struct {
	// AccountId: The ID of the (sub-)account whose status to get.
	AccountId uint64 `json:"accountId,omitempty,string"`

	// BatchId: An entry ID, unique within the batch request.
	BatchId int64 `json:"batchId,omitempty"`

	// Destinations: If set, only issues for the specified destinations are
	// returned, otherwise only issues for the Shopping destination.
	Destinations []string `json:"destinations,omitempty"`

	// MerchantId: The ID of the managing account.
	MerchantId uint64 `json:"merchantId,omitempty,string"`

	// Method: The method of the batch entry. Acceptable values are: -
	// "get"
	Method string `json:"method,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccountId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccountId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountstatusesCustomBatchRequestEntry) MarshalJSON() ([]byte, error) {
	type NoMethod AccountstatusesCustomBatchRequestEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AccountstatusesCustomBatchResponse struct {
	// Entries: The result of the execution of the batch requests.
	Entries []*AccountstatusesCustomBatchResponseEntry `json:"entries,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#accountstatusesCustomBatchResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Entries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountstatusesCustomBatchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AccountstatusesCustomBatchResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AccountstatusesCustomBatchResponseEntry: A batch entry encoding a
// single non-batch accountstatuses response.
type AccountstatusesCustomBatchResponseEntry struct {
	// AccountStatus: The requested account status. Defined if and only if
	// the request was successful.
	AccountStatus *AccountStatus `json:"accountStatus,omitempty"`

	// BatchId: The ID of the request entry this entry responds to.
	BatchId int64 `json:"batchId,omitempty"`

	// Errors: A list of errors defined if and only if the request failed.
	Errors *Errors `json:"errors,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccountStatus") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccountStatus") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountstatusesCustomBatchResponseEntry) MarshalJSON() ([]byte, error) {
	type NoMethod AccountstatusesCustomBatchResponseEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AccountstatusesListResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#accountstatusesListResponse".
	Kind string `json:"kind,omitempty"`

	// NextPageToken: The token for the retrieval of the next page of
	// account statuses.
	NextPageToken string `json:"nextPageToken,omitempty"`

	Resources []*AccountStatus `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountstatusesListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AccountstatusesListResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AccounttaxCustomBatchRequest struct {
	// Entries: The request entries to be processed in the batch.
	Entries []*AccounttaxCustomBatchRequestEntry `json:"entries,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Entries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccounttaxCustomBatchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AccounttaxCustomBatchRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AccounttaxCustomBatchRequestEntry: A batch entry encoding a single
// non-batch accounttax request.
type AccounttaxCustomBatchRequestEntry struct {
	// AccountId: The ID of the account for which to get/update account tax
	// settings.
	AccountId uint64 `json:"accountId,omitempty,string"`

	// AccountTax: The account tax settings to update. Only defined if the
	// method is `update`.
	AccountTax *AccountTax `json:"accountTax,omitempty"`

	// BatchId: An entry ID, unique within the batch request.
	BatchId int64 `json:"batchId,omitempty"`

	// MerchantId: The ID of the managing account.
	MerchantId uint64 `json:"merchantId,omitempty,string"`

	// Method: The method of the batch entry. Acceptable values are: -
	// "get" - "update"
	Method string `json:"method,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccountId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccountId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccounttaxCustomBatchRequestEntry) MarshalJSON() ([]byte, error) {
	type NoMethod AccounttaxCustomBatchRequestEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AccounttaxCustomBatchResponse struct {
	// Entries: The result of the execution of the batch requests.
	Entries []*AccounttaxCustomBatchResponseEntry `json:"entries,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#accounttaxCustomBatchResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Entries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccounttaxCustomBatchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AccounttaxCustomBatchResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AccounttaxCustomBatchResponseEntry: A batch entry encoding a single
// non-batch accounttax response.
type AccounttaxCustomBatchResponseEntry struct {
	// AccountTax: The retrieved or updated account tax settings.
	AccountTax *AccountTax `json:"accountTax,omitempty"`

	// BatchId: The ID of the request entry this entry responds to.
	BatchId int64 `json:"batchId,omitempty"`

	// Errors: A list of errors defined if and only if the request failed.
	Errors *Errors `json:"errors,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#accounttaxCustomBatchResponseEntry"
	Kind string `json:"kind,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccountTax") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccountTax") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccounttaxCustomBatchResponseEntry) MarshalJSON() ([]byte, error) {
	type NoMethod AccounttaxCustomBatchResponseEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AccounttaxListResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#accounttaxListResponse".
	Kind string `json:"kind,omitempty"`

	// NextPageToken: The token for the retrieval of the next page of
	// account tax settings.
	NextPageToken string `json:"nextPageToken,omitempty"`

	Resources []*AccountTax `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccounttaxListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AccounttaxListResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ActivateBuyOnGoogleProgramRequest: Request message for the
// ActivateProgram method.
type ActivateBuyOnGoogleProgramRequest struct {
}

type Address struct {
	// AdministrativeArea: Required. Top-level administrative subdivision of
	// the country. For example, a state like California ("CA") or a
	// province like Quebec ("QC").
	AdministrativeArea string `json:"administrativeArea,omitempty"`

	// City: Required. City, town or commune. May also include dependent
	// localities or sublocalities (e.g. neighborhoods or suburbs).
	City string `json:"city,omitempty"`

	// Country: Required. CLDR country code
	// (http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml)
	// (e.g. "US").
	Country string `json:"country,omitempty"`

	// PostalCode: Required. Postal code or ZIP (e.g. "94043").
	PostalCode string `json:"postalCode,omitempty"`

	// StreetAddress: Street-level part of the address.
	StreetAddress string `json:"streetAddress,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdministrativeArea")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdministrativeArea") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Address) MarshalJSON() ([]byte, error) {
	type NoMethod Address
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type Amount struct {
	// PriceAmount: [required] The pre-tax or post-tax price depending on
	// the location of the order.
	PriceAmount *Price `json:"priceAmount,omitempty"`

	// TaxAmount: [required] Tax value.
	TaxAmount *Price `json:"taxAmount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PriceAmount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PriceAmount") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Amount) MarshalJSON() ([]byte, error) {
	type NoMethod Amount
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type BusinessDayConfig struct {
	// BusinessDays: Regular business days, such as '"monday"'. May not be
	// empty.
	BusinessDays []string `json:"businessDays,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BusinessDays") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BusinessDays") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BusinessDayConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BusinessDayConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BuyOnGoogleProgramStatus: Response message for the GetProgramStatus
// method.
type BuyOnGoogleProgramStatus struct {
	// BusinessModel: The business models in which merchant participates.
	//
	// Possible values:
	//   "BUSINESS_MODEL_UNSPECIFIED" - Default value when business model is
	// not set.
	//   "MANUFACTURER" - Merchant is a manufacturer.
	//   "IMPORTER" - Merchant is an importer.
	//   "RESELLER" - Merchant is a reseller.
	//   "OTHER" - Merchant has a different business model.
	BusinessModel []string `json:"businessModel,omitempty"`

	// CustomerServicePendingEmail: The customer service pending email.
	// After verification this field becomes empty.
	CustomerServicePendingEmail string `json:"customerServicePendingEmail,omitempty"`

	// CustomerServicePendingPhoneNumber: The pending phone number specified
	// for BuyOnGoogle program. It might be different than account level
	// phone number. In order to update this field the
	// customer_service_pending_phone_region_code must also be set. After
	// verification this field becomes empty.
	CustomerServicePendingPhoneNumber string `json:"customerServicePendingPhoneNumber,omitempty"`

	// CustomerServicePendingPhoneRegionCode: Two letter country code for
	// the pending phone number, for example `CA` for Canadian numbers. See
	// the ISO 3166-1 alpha-2
	// (https://wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements)
	// officially assigned codes. In order to update this field the
	// customer_service_pending_phone_number must also be set. After
	// verification this field becomes empty.
	CustomerServicePendingPhoneRegionCode string `json:"customerServicePendingPhoneRegionCode,omitempty"`

	// CustomerServiceVerifiedEmail: Output only. The customer service
	// verified email.
	CustomerServiceVerifiedEmail string `json:"customerServiceVerifiedEmail,omitempty"`

	// CustomerServiceVerifiedPhoneNumber: Output only. The verified phone
	// number specified for BuyOnGoogle program. It might be different than
	// account level phone number.
	CustomerServiceVerifiedPhoneNumber string `json:"customerServiceVerifiedPhoneNumber,omitempty"`

	// CustomerServiceVerifiedPhoneRegionCode: Output only. Two letter
	// country code for the verified phone number, for example `CA` for
	// Canadian numbers. See the ISO 3166-1 alpha-2
	// (https://wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements)
	// officially assigned codes.
	CustomerServiceVerifiedPhoneRegionCode string `json:"customerServiceVerifiedPhoneRegionCode,omitempty"`

	// OnlineSalesChannel: The channels through which the merchant is
	// selling.
	//
	// Possible values:
	//   "ONLINE_SALES_CHANNEL_UNSPECIFIED" - Default value when online
	// sales channel is not set.
	//   "GOOGLE_EXCLUSIVE" - Merchant is selling exclusively on Google.
	//   "GOOGLE_AND_OTHER_WEBSITES" - Merchant is selling on Google and
	// other websites.
	OnlineSalesChannel string `json:"onlineSalesChannel,omitempty"`

	// ParticipationStage: Output only. The current participation stage for
	// the program.
	//
	// Possible values:
	//   "PROGRAM_PARTICIPATION_STAGE_UNSPECIFIED" - Default value when
	// participation stage is not set.
	//   "NOT_ELIGIBLE" - Merchant is not eligible for onboarding to a given
	// program in a specific region code.
	//   "ELIGIBLE" - Merchant is eligible for onboarding to a given program
	// in a specific region code.
	//   "ONBOARDING" - Merchant is onboarding to a given program in a
	// specific region code.
	//   "ELIGIBLE_FOR_REVIEW" - Merchant fulfilled all the requirements and
	// is ready to request review in a specific region code.
	//   "PENDING_REVIEW" - Merchant is waiting for the review to be
	// completed in a specific region code.
	//   "REVIEW_DISAPPROVED" - The review for a merchant has been rejected
	// in a specific region code.
	//   "ACTIVE" - Merchant's program participation is active for a
	// specific region code.
	//   "PAUSED" - Participation has been paused.
	ParticipationStage string `json:"participationStage,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "BusinessModel") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BusinessModel") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BuyOnGoogleProgramStatus) MarshalJSON() ([]byte, error) {
	type NoMethod BuyOnGoogleProgramStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CaptureOrderRequest: Request message for the CaptureOrder method.
type CaptureOrderRequest struct {
}

// CaptureOrderResponse: Response message for the CaptureOrder method.
type CaptureOrderResponse struct {
	// ExecutionStatus: The status of the execution. Only defined if the
	// request was successful. Acceptable values are: * "duplicate" *
	// "executed"
	//
	// Possible values:
	//   "EXECUTION_STATUS_UNSPECIFIED" - Default value. This value is
	// unused.
	//   "EXECUTED" - The request was completed successfully.
	//   "DUPLICATE" - The request was not performed because it already
	// executed once successfully.
	ExecutionStatus string `json:"executionStatus,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ExecutionStatus") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExecutionStatus") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *CaptureOrderResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CaptureOrderResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type CarrierRate struct {
	// CarrierName: Carrier service, such as "UPS" or "Fedex". The list
	// of supported carriers can be retrieved via the `getSupportedCarriers`
	// method. Required.
	CarrierName string `json:"carrierName,omitempty"`

	// CarrierService: Carrier service, such as "ground" or "2 days".
	// The list of supported services for a carrier can be retrieved via the
	// `getSupportedCarriers` method. Required.
	CarrierService string `json:"carrierService,omitempty"`

	// FlatAdjustment: Additive shipping rate modifier. Can be negative. For
	// example `{ "value": "1", "currency" : "USD" }` adds $1 to the rate,
	// `{ "value": "-3", "currency" : "USD" }` removes $3 from the rate.
	// Optional.
	FlatAdjustment *Price `json:"flatAdjustment,omitempty"`

	// Name: Name of the carrier rate. Must be unique per rate group.
	// Required.
	Name string `json:"name,omitempty"`

	// OriginPostalCode: Shipping origin for this carrier rate. Required.
	OriginPostalCode string `json:"originPostalCode,omitempty"`

	// PercentageAdjustment: Multiplicative shipping rate modifier as a
	// number in decimal notation. Can be negative. For example "5.4"
	// increases the rate by 5.4%, "-3" decreases the rate by 3%.
	// Optional.
	PercentageAdjustment string `json:"percentageAdjustment,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CarrierName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CarrierName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CarrierRate) MarshalJSON() ([]byte, error) {
	type NoMethod CarrierRate
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type CarriersCarrier struct {
	// Country: The CLDR country code of the carrier (e.g., "US"). Always
	// present.
	Country string `json:"country,omitempty"`

	// EddServices: A list of services supported for EDD (Estimated Delivery
	// Date) calculation. This is the list of valid values for
	// WarehouseBasedDeliveryTime.carrierService.
	EddServices []string `json:"eddServices,omitempty"`

	// Name: The name of the carrier (e.g., "UPS"). Always present.
	Name string `json:"name,omitempty"`

	// Services: A list of supported services (e.g., "ground") for that
	// carrier. Contains at least one service. This is the list of valid
	// values for CarrierRate.carrierService.
	Services []string `json:"services,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Country") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Country") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CarriersCarrier) MarshalJSON() ([]byte, error) {
	type NoMethod CarriersCarrier
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Collection: The collection message.
type Collection struct {
	// CustomLabel0: Label that you assign to a collection to help organize
	// bidding and reporting in Shopping campaigns. Custom label
	// (https://support.google.com/merchants/answer/9674217)
	CustomLabel0 string `json:"customLabel0,omitempty"`

	// CustomLabel1: Label that you assign to a collection to help organize
	// bidding and reporting in Shopping campaigns.
	CustomLabel1 string `json:"customLabel1,omitempty"`

	// CustomLabel2: Label that you assign to a collection to help organize
	// bidding and reporting in Shopping campaigns.
	CustomLabel2 string `json:"customLabel2,omitempty"`

	// CustomLabel3: Label that you assign to a collection to help organize
	// bidding and reporting in Shopping campaigns.
	CustomLabel3 string `json:"customLabel3,omitempty"`

	// CustomLabel4: Label that you assign to a collection to help organize
	// bidding and reporting in Shopping campaigns.
	CustomLabel4 string `json:"customLabel4,omitempty"`

	// FeaturedProduct: This identifies one or more products associated with
	// the collection. Used as a lookup to the corresponding product ID in
	// your product feeds. Provide a maximum of 100 featuredProduct (for
	// collections). Provide up to 10 featuredProduct (for Shoppable Images
	// only) with ID and X and Y coordinates. featured_product attribute
	// (https://support.google.com/merchants/answer/9703736)
	FeaturedProduct []*CollectionFeaturedProduct `json:"featuredProduct,omitempty"`

	// Headline: Your collection's name. headline attribute
	// (https://support.google.com/merchants/answer/9673580)
	Headline []string `json:"headline,omitempty"`

	// Id: Required. The REST ID of the collection. Content API methods that
	// operate on collections take this as their collectionId parameter. The
	// REST ID for a collection is of the form collectionId. id attribute
	// (https://support.google.com/merchants/answer/9649290)
	Id string `json:"id,omitempty"`

	// ImageLink: The URL of a collection’s image. image_link attribute
	// (https://support.google.com/merchants/answer/9703236)
	ImageLink []string `json:"imageLink,omitempty"`

	// Language: The language of a collection and the language of any
	// featured products linked to the collection. language attribute
	// (https://support.google.com/merchants/answer/9673781)
	Language string `json:"language,omitempty"`

	// Link: A collection’s landing page. URL directly linking to your
	// collection's page on your website. link attribute
	// (https://support.google.com/merchants/answer/9673983)
	Link string `json:"link,omitempty"`

	// MobileLink: A collection’s mobile-optimized landing page when you
	// have a different URL for mobile and desktop traffic. mobile_link
	// attribute (https://support.google.com/merchants/answer/9646123)
	MobileLink string `json:"mobileLink,omitempty"`

	// ProductCountry: product_country attribute
	// (https://support.google.com/merchants/answer/9674155)
	ProductCountry string `json:"productCountry,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CustomLabel0") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CustomLabel0") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Collection) MarshalJSON() ([]byte, error) {
	type NoMethod Collection
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CollectionFeaturedProduct: The message for FeaturedProduct.
// FeaturedProduct (https://support.google.com/merchants/answer/9703736)
type CollectionFeaturedProduct struct {
	// OfferId: The unique identifier for the product item.
	OfferId string `json:"offerId,omitempty"`

	// X: Required. X-coordinate of the product callout on the Shoppable
	// Image.
	X float64 `json:"x,omitempty"`

	// Y: Required. Y-coordinate of the product callout on the Shoppable
	// Image.
	Y float64 `json:"y,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OfferId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OfferId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CollectionFeaturedProduct) MarshalJSON() ([]byte, error) {
	type NoMethod CollectionFeaturedProduct
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *CollectionFeaturedProduct) UnmarshalJSON(data []byte) error {
	type NoMethod CollectionFeaturedProduct
	var s1 struct {
		X gensupport.JSONFloat64 `json:"x"`
		Y gensupport.JSONFloat64 `json:"y"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.X = float64(s1.X)
	s.Y = float64(s1.Y)
	return nil
}

// CollectionStatus: The collectionstatus message.
type CollectionStatus struct {
	// CollectionLevelIssuses: A list of all issues associated with the
	// collection.
	CollectionLevelIssuses []*CollectionStatusItemLevelIssue `json:"collectionLevelIssuses,omitempty"`

	// CreationDate: Date on which the collection has been created in ISO
	// 8601 (http://en.wikipedia.org/wiki/ISO_8601) format: Date, time, and
	// offset, e.g. "2020-01-02T09:00:00+01:00" or "2020-01-02T09:00:00Z"
	CreationDate string `json:"creationDate,omitempty"`

	// DestinationStatuses: The intended destinations for the collection.
	DestinationStatuses []*CollectionStatusDestinationStatus `json:"destinationStatuses,omitempty"`

	// Id: Required. The ID of the collection for which status is reported.
	Id string `json:"id,omitempty"`

	// LastUpdateDate: Date on which the collection has been last updated in
	// ISO 8601 (http://en.wikipedia.org/wiki/ISO_8601) format: Date, time,
	// and offset, e.g. "2020-01-02T09:00:00+01:00" or
	// "2020-01-02T09:00:00Z"
	LastUpdateDate string `json:"lastUpdateDate,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "CollectionLevelIssuses") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CollectionLevelIssuses")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *CollectionStatus) MarshalJSON() ([]byte, error) {
	type NoMethod CollectionStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CollectionStatusDestinationStatus: Destination status message.
type CollectionStatusDestinationStatus struct {
	// Destination: The name of the destination
	Destination string `json:"destination,omitempty"`

	// Status: The status for the specified destination.
	Status string `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Destination") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Destination") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CollectionStatusDestinationStatus) MarshalJSON() ([]byte, error) {
	type NoMethod CollectionStatusDestinationStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CollectionStatusItemLevelIssue: Issue associated with the collection.
type CollectionStatusItemLevelIssue struct {
	// AttributeName: The attribute's name, if the issue is caused by a
	// single attribute.
	AttributeName string `json:"attributeName,omitempty"`

	// Code: The error code of the issue.
	Code string `json:"code,omitempty"`

	// Description: A short issue description in English.
	Description string `json:"description,omitempty"`

	// Destination: The destination the issue applies to.
	Destination string `json:"destination,omitempty"`

	// Detail: A detailed issue description in English.
	Detail string `json:"detail,omitempty"`

	// Documentation: The URL of a web page to help with resolving this
	// issue.
	Documentation string `json:"documentation,omitempty"`

	// Resolution: Whether the issue can be resolved by the merchant.
	Resolution string `json:"resolution,omitempty"`

	// Servability: How this issue affects the serving of the collection.
	Servability string `json:"servability,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AttributeName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AttributeName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CollectionStatusItemLevelIssue) MarshalJSON() ([]byte, error) {
	type NoMethod CollectionStatusItemLevelIssue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Css: Information about CSS domain.
type Css struct {
	// CssDomainId: Output only. Immutable. The CSS domain ID.
	CssDomainId int64 `json:"cssDomainId,omitempty,string"`

	// CssGroupId: Output only. Immutable. The ID of the CSS group this CSS
	// domain is affiliated with. Only populated for CSS group users.
	CssGroupId int64 `json:"cssGroupId,omitempty,string"`

	// DisplayName: Output only. Immutable. The CSS domain's display name,
	// used when space is constrained.
	DisplayName string `json:"displayName,omitempty"`

	// FullName: Output only. Immutable. The CSS domain's full name.
	FullName string `json:"fullName,omitempty"`

	// HomepageUri: Output only. Immutable. The CSS domain's homepage.
	HomepageUri string `json:"homepageUri,omitempty"`

	// LabelIds: A list of label IDs that are assigned to this CSS domain by
	// its CSS group. Only populated for CSS group users.
	LabelIds googleapi.Int64s `json:"labelIds,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CssDomainId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CssDomainId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Css) MarshalJSON() ([]byte, error) {
	type NoMethod Css
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type CustomAttribute struct {
	// GroupValues: Subattributes within this attribute group. Exactly one
	// of value or groupValues must be provided.
	GroupValues []*CustomAttribute `json:"groupValues,omitempty"`

	// Name: The name of the attribute. Underscores will be replaced by
	// spaces upon insertion.
	Name string `json:"name,omitempty"`

	// Value: The value of the attribute.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GroupValues") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GroupValues") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CustomAttribute) MarshalJSON() ([]byte, error) {
	type NoMethod CustomAttribute
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type CustomerReturnReason struct {
	// Description: Description of the reason.
	Description string `json:"description,omitempty"`

	// ReasonCode: Code of the return reason. Acceptable values are: -
	// "betterPriceFound" - "changedMind" - "damagedOrDefectiveItem" -
	// "didNotMatchDescription" - "doesNotFit" - "expiredItem" -
	// "incorrectItemReceived" - "noLongerNeeded" - "notSpecified" -
	// "orderedWrongItem" - "other" - "qualityNotExpected" -
	// "receivedTooLate" - "undeliverable"
	ReasonCode string `json:"reasonCode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CustomerReturnReason) MarshalJSON() ([]byte, error) {
	type NoMethod CustomerReturnReason
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type CutoffTime struct {
	// Hour: Hour of the cutoff time until which an order has to be placed
	// to be processed in the same day. Required.
	Hour int64 `json:"hour,omitempty"`

	// Minute: Minute of the cutoff time until which an order has to be
	// placed to be processed in the same day. Required.
	Minute int64 `json:"minute,omitempty"`

	// Timezone: Timezone identifier for the cutoff time. A list of
	// identifiers can be found in the AdWords API documentation. E.g.
	// "Europe/Zurich". Required.
	Timezone string `json:"timezone,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Hour") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Hour") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CutoffTime) MarshalJSON() ([]byte, error) {
	type NoMethod CutoffTime
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Datafeed: Datafeed configuration data.
type Datafeed struct {
	// AttributeLanguage: The two-letter ISO 639-1 language in which the
	// attributes are defined in the data feed.
	AttributeLanguage string `json:"attributeLanguage,omitempty"`

	// ContentType: Required. The type of data feed. For product inventory
	// feeds, only feeds for local stores, not online stores, are supported.
	// Acceptable values are: - "local products" - "product inventory" -
	// "products"
	ContentType string `json:"contentType,omitempty"`

	// FetchSchedule: Fetch schedule for the feed file.
	FetchSchedule *DatafeedFetchSchedule `json:"fetchSchedule,omitempty"`

	// FileName: Required. The filename of the feed. All feeds must have a
	// unique file name.
	FileName string `json:"fileName,omitempty"`

	// Format: Format of the feed file.
	Format *DatafeedFormat `json:"format,omitempty"`

	// Id: Required for update. The ID of the data feed.
	Id int64 `json:"id,omitempty,string"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#datafeed"
	Kind string `json:"kind,omitempty"`

	// Name: Required for insert. A descriptive name of the data feed.
	Name string `json:"name,omitempty"`

	// Targets: The targets this feed should apply to (country, language,
	// destinations).
	Targets []*DatafeedTarget `json:"targets,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AttributeLanguage")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AttributeLanguage") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Datafeed) MarshalJSON() ([]byte, error) {
	type NoMethod Datafeed
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DatafeedFetchSchedule: The required fields vary based on the
// frequency of fetching. For a monthly fetch schedule, day_of_month and
// hour are required. For a weekly fetch schedule, weekday and hour are
// required. For a daily fetch schedule, only hour is required.
type DatafeedFetchSchedule struct {
	// DayOfMonth: The day of the month the feed file should be fetched
	// (1-31).
	DayOfMonth int64 `json:"dayOfMonth,omitempty"`

	// FetchUrl: The URL where the feed file can be fetched. Google Merchant
	// Center will support automatic scheduled uploads using the HTTP,
	// HTTPS, FTP, or SFTP protocols, so the value will need to be a valid
	// link using one of those four protocols.
	FetchUrl string `json:"fetchUrl,omitempty"`

	// Hour: The hour of the day the feed file should be fetched (0-23).
	Hour int64 `json:"hour,omitempty"`

	// MinuteOfHour: The minute of the hour the feed file should be fetched
	// (0-59). Read-only.
	MinuteOfHour int64 `json:"minuteOfHour,omitempty"`

	// Password: An optional password for fetch_url.
	Password string `json:"password,omitempty"`

	// Paused: Whether the scheduled fetch is paused or not.
	Paused bool `json:"paused,omitempty"`

	// TimeZone: Time zone used for schedule. UTC by default. E.g.,
	// "America/Los_Angeles".
	TimeZone string `json:"timeZone,omitempty"`

	// Username: An optional user name for fetch_url.
	Username string `json:"username,omitempty"`

	// Weekday: The day of the week the feed file should be fetched.
	// Acceptable values are: - "monday" - "tuesday" - "wednesday" -
	// "thursday" - "friday" - "saturday" - "sunday"
	Weekday string `json:"weekday,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DayOfMonth") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DayOfMonth") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DatafeedFetchSchedule) MarshalJSON() ([]byte, error) {
	type NoMethod DatafeedFetchSchedule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DatafeedFormat struct {
	// ColumnDelimiter: Delimiter for the separation of values in a
	// delimiter-separated values feed. If not specified, the delimiter will
	// be auto-detected. Ignored for non-DSV data feeds. Acceptable values
	// are: - "pipe" - "tab" - "tilde"
	ColumnDelimiter string `json:"columnDelimiter,omitempty"`

	// FileEncoding: Character encoding scheme of the data feed. If not
	// specified, the encoding will be auto-detected. Acceptable values are:
	// - "latin-1" - "utf-16be" - "utf-16le" - "utf-8" -
	// "windows-1252"
	FileEncoding string `json:"fileEncoding,omitempty"`

	// QuotingMode: Specifies how double quotes are interpreted. If not
	// specified, the mode will be auto-detected. Ignored for non-DSV data
	// feeds. Acceptable values are: - "normal character" - "value
	// quoting"
	QuotingMode string `json:"quotingMode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ColumnDelimiter") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ColumnDelimiter") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DatafeedFormat) MarshalJSON() ([]byte, error) {
	type NoMethod DatafeedFormat
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DatafeedStatus: The status of a datafeed, i.e., the result of the
// last retrieval of the datafeed computed asynchronously when the feed
// processing is finished.
type DatafeedStatus struct {
	// Country: The country for which the status is reported, represented as
	// a CLDR territory code.
	Country string `json:"country,omitempty"`

	// DatafeedId: The ID of the feed for which the status is reported.
	DatafeedId uint64 `json:"datafeedId,omitempty,string"`

	// Errors: The list of errors occurring in the feed.
	Errors []*DatafeedStatusError `json:"errors,omitempty"`

	// ItemsTotal: The number of items in the feed that were processed.
	ItemsTotal uint64 `json:"itemsTotal,omitempty,string"`

	// ItemsValid: The number of items in the feed that were valid.
	ItemsValid uint64 `json:"itemsValid,omitempty,string"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#datafeedStatus"
	Kind string `json:"kind,omitempty"`

	// Language: The two-letter ISO 639-1 language for which the status is
	// reported.
	Language string `json:"language,omitempty"`

	// LastUploadDate: The last date at which the feed was uploaded.
	LastUploadDate string `json:"lastUploadDate,omitempty"`

	// ProcessingStatus: The processing status of the feed. Acceptable
	// values are: - ""failure": The feed could not be processed or all
	// items had errors." - "in progress": The feed is being processed. -
	// "none": The feed has not yet been processed. For example, a feed
	// that has never been uploaded will have this processing status. -
	// "success": The feed was processed successfully, though some items
	// might have had errors.
	ProcessingStatus string `json:"processingStatus,omitempty"`

	// Warnings: The list of errors occurring in the feed.
	Warnings []*DatafeedStatusError `json:"warnings,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Country") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Country") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DatafeedStatus) MarshalJSON() ([]byte, error) {
	type NoMethod DatafeedStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DatafeedStatusError: An error occurring in the feed, like "invalid
// price".
type DatafeedStatusError struct {
	// Code: The code of the error, e.g., "validation/invalid_value".
	Code string `json:"code,omitempty"`

	// Count: The number of occurrences of the error in the feed.
	Count uint64 `json:"count,omitempty,string"`

	// Examples: A list of example occurrences of the error, grouped by
	// product.
	Examples []*DatafeedStatusExample `json:"examples,omitempty"`

	// Message: The error message, e.g., "Invalid price".
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DatafeedStatusError) MarshalJSON() ([]byte, error) {
	type NoMethod DatafeedStatusError
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DatafeedStatusExample: An example occurrence for a particular error.
type DatafeedStatusExample struct {
	// ItemId: The ID of the example item.
	ItemId string `json:"itemId,omitempty"`

	// LineNumber: Line number in the data feed where the example is found.
	LineNumber uint64 `json:"lineNumber,omitempty,string"`

	// Value: The problematic value.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ItemId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ItemId") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DatafeedStatusExample) MarshalJSON() ([]byte, error) {
	type NoMethod DatafeedStatusExample
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DatafeedTarget struct {
	// Country: The country where the items in the feed will be included in
	// the search index, represented as a CLDR territory code.
	Country string `json:"country,omitempty"`

	// ExcludedDestinations: The list of destinations to exclude for this
	// target (corresponds to unchecked check boxes in Merchant Center).
	ExcludedDestinations []string `json:"excludedDestinations,omitempty"`

	// IncludedDestinations: The list of destinations to include for this
	// target (corresponds to checked check boxes in Merchant Center).
	// Default destinations are always included unless provided in
	// `excludedDestinations`. List of supported destinations (if available
	// to the account): - DisplayAds - Shopping - ShoppingActions -
	// SurfacesAcrossGoogle
	IncludedDestinations []string `json:"includedDestinations,omitempty"`

	// Language: The two-letter ISO 639-1 language of the items in the feed.
	// Must be a valid language for `targets[].country`.
	Language string `json:"language,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Country") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Country") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DatafeedTarget) MarshalJSON() ([]byte, error) {
	type NoMethod DatafeedTarget
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DatafeedsCustomBatchRequest struct {
	// Entries: The request entries to be processed in the batch.
	Entries []*DatafeedsCustomBatchRequestEntry `json:"entries,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Entries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DatafeedsCustomBatchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod DatafeedsCustomBatchRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DatafeedsCustomBatchRequestEntry: A batch entry encoding a single
// non-batch datafeeds request.
type DatafeedsCustomBatchRequestEntry struct {
	// BatchId: An entry ID, unique within the batch request.
	BatchId int64 `json:"batchId,omitempty"`

	// Datafeed: The data feed to insert.
	Datafeed *Datafeed `json:"datafeed,omitempty"`

	// DatafeedId: The ID of the data feed to get, delete or fetch.
	DatafeedId uint64 `json:"datafeedId,omitempty,string"`

	// MerchantId: The ID of the managing account.
	MerchantId uint64 `json:"merchantId,omitempty,string"`

	// Method: The method of the batch entry. Acceptable values are: -
	// "delete" - "fetchNow" - "get" - "insert" - "update"
	Method string `json:"method,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BatchId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BatchId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DatafeedsCustomBatchRequestEntry) MarshalJSON() ([]byte, error) {
	type NoMethod DatafeedsCustomBatchRequestEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DatafeedsCustomBatchResponse struct {
	// Entries: The result of the execution of the batch requests.
	Entries []*DatafeedsCustomBatchResponseEntry `json:"entries,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#datafeedsCustomBatchResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Entries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DatafeedsCustomBatchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod DatafeedsCustomBatchResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DatafeedsCustomBatchResponseEntry: A batch entry encoding a single
// non-batch datafeeds response.
type DatafeedsCustomBatchResponseEntry struct {
	// BatchId: The ID of the request entry this entry responds to.
	BatchId int64 `json:"batchId,omitempty"`

	// Datafeed: The requested data feed. Defined if and only if the request
	// was successful.
	Datafeed *Datafeed `json:"datafeed,omitempty"`

	// Errors: A list of errors defined if and only if the request failed.
	Errors *Errors `json:"errors,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BatchId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BatchId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DatafeedsCustomBatchResponseEntry) MarshalJSON() ([]byte, error) {
	type NoMethod DatafeedsCustomBatchResponseEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DatafeedsFetchNowResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#datafeedsFetchNowResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DatafeedsFetchNowResponse) MarshalJSON() ([]byte, error) {
	type NoMethod DatafeedsFetchNowResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DatafeedsListResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#datafeedsListResponse".
	Kind string `json:"kind,omitempty"`

	// NextPageToken: The token for the retrieval of the next page of
	// datafeeds.
	NextPageToken string `json:"nextPageToken,omitempty"`

	Resources []*Datafeed `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DatafeedsListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod DatafeedsListResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DatafeedstatusesCustomBatchRequest struct {
	// Entries: The request entries to be processed in the batch.
	Entries []*DatafeedstatusesCustomBatchRequestEntry `json:"entries,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Entries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DatafeedstatusesCustomBatchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod DatafeedstatusesCustomBatchRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DatafeedstatusesCustomBatchRequestEntry: A batch entry encoding a
// single non-batch datafeedstatuses request.
type DatafeedstatusesCustomBatchRequestEntry struct {
	// BatchId: An entry ID, unique within the batch request.
	BatchId int64 `json:"batchId,omitempty"`

	// Country: The country for which to get the datafeed status. If this
	// parameter is provided then language must also be provided. Note that
	// for multi-target datafeeds this parameter is required.
	Country string `json:"country,omitempty"`

	// DatafeedId: The ID of the data feed to get.
	DatafeedId uint64 `json:"datafeedId,omitempty,string"`

	// Language: The language for which to get the datafeed status. If this
	// parameter is provided then country must also be provided. Note that
	// for multi-target datafeeds this parameter is required.
	Language string `json:"language,omitempty"`

	// MerchantId: The ID of the managing account.
	MerchantId uint64 `json:"merchantId,omitempty,string"`

	// Method: The method of the batch entry. Acceptable values are: -
	// "get"
	Method string `json:"method,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BatchId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BatchId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DatafeedstatusesCustomBatchRequestEntry) MarshalJSON() ([]byte, error) {
	type NoMethod DatafeedstatusesCustomBatchRequestEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DatafeedstatusesCustomBatchResponse struct {
	// Entries: The result of the execution of the batch requests.
	Entries []*DatafeedstatusesCustomBatchResponseEntry `json:"entries,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#datafeedstatusesCustomBatchResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Entries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DatafeedstatusesCustomBatchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod DatafeedstatusesCustomBatchResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DatafeedstatusesCustomBatchResponseEntry: A batch entry encoding a
// single non-batch datafeedstatuses response.
type DatafeedstatusesCustomBatchResponseEntry struct {
	// BatchId: The ID of the request entry this entry responds to.
	BatchId int64 `json:"batchId,omitempty"`

	// DatafeedStatus: The requested data feed status. Defined if and only
	// if the request was successful.
	DatafeedStatus *DatafeedStatus `json:"datafeedStatus,omitempty"`

	// Errors: A list of errors defined if and only if the request failed.
	Errors *Errors `json:"errors,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BatchId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BatchId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DatafeedstatusesCustomBatchResponseEntry) MarshalJSON() ([]byte, error) {
	type NoMethod DatafeedstatusesCustomBatchResponseEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DatafeedstatusesListResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#datafeedstatusesListResponse".
	Kind string `json:"kind,omitempty"`

	// NextPageToken: The token for the retrieval of the next page of
	// datafeed statuses.
	NextPageToken string `json:"nextPageToken,omitempty"`

	Resources []*DatafeedStatus `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DatafeedstatusesListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod DatafeedstatusesListResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Date: Represents a whole or partial calendar date, such as a
// birthday. The time of day and time zone are either specified
// elsewhere or are insignificant. The date is relative to the Gregorian
// Calendar. This can represent one of the following: * A full date,
// with non-zero year, month, and day values * A month and day value,
// with a zero year, such as an anniversary * A year on its own, with
// zero month and day values * A year and month value, with a zero day,
// such as a credit card expiration date Related types are
// google.type.TimeOfDay and `google.protobuf.Timestamp`.
type Date struct {
	// Day: Day of a month. Must be from 1 to 31 and valid for the year and
	// month, or 0 to specify a year by itself or a year and month where the
	// day isn't significant.
	Day int64 `json:"day,omitempty"`

	// Month: Month of a year. Must be from 1 to 12, or 0 to specify a year
	// without a month and day.
	Month int64 `json:"month,omitempty"`

	// Year: Year of the date. Must be from 1 to 9999, or 0 to specify a
	// date without a year.
	Year int64 `json:"year,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Day") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Day") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Date) MarshalJSON() ([]byte, error) {
	type NoMethod Date
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DateTime: Represents civil time (or occasionally physical time). This
// type can represent a civil time in one of a few possible ways: * When
// utc_offset is set and time_zone is unset: a civil time on a calendar
// day with a particular offset from UTC. * When time_zone is set and
// utc_offset is unset: a civil time on a calendar day in a particular
// time zone. * When neither time_zone nor utc_offset is set: a civil
// time on a calendar day in local time. The date is relative to the
// Proleptic Gregorian Calendar. If year is 0, the DateTime is
// considered not to have a specific year. month and day must have
// valid, non-zero values. This type may also be used to represent a
// physical time if all the date and time fields are set and either case
// of the `time_offset` oneof is set. Consider using `Timestamp` message
// for physical time instead. If your use case also would like to store
// the user's timezone, that can be done in another field. This type is
// more flexible than some applications may want. Make sure to document
// and validate your application's limitations.
type DateTime struct {
	// Day: Required. Day of month. Must be from 1 to 31 and valid for the
	// year and month.
	Day int64 `json:"day,omitempty"`

	// Hours: Required. Hours of day in 24 hour format. Should be from 0 to
	// 23. An API may choose to allow the value "24:00:00" for scenarios
	// like business closing time.
	Hours int64 `json:"hours,omitempty"`

	// Minutes: Required. Minutes of hour of day. Must be from 0 to 59.
	Minutes int64 `json:"minutes,omitempty"`

	// Month: Required. Month of year. Must be from 1 to 12.
	Month int64 `json:"month,omitempty"`

	// Nanos: Required. Fractions of seconds in nanoseconds. Must be from 0
	// to 999,999,999.
	Nanos int64 `json:"nanos,omitempty"`

	// Seconds: Required. Seconds of minutes of the time. Must normally be
	// from 0 to 59. An API may allow the value 60 if it allows
	// leap-seconds.
	Seconds int64 `json:"seconds,omitempty"`

	// TimeZone: Time zone.
	TimeZone *TimeZone `json:"timeZone,omitempty"`

	// UtcOffset: UTC offset. Must be whole seconds, between -18 hours and
	// +18 hours. For example, a UTC offset of -4:00 would be represented as
	// { seconds: -14400 }.
	UtcOffset string `json:"utcOffset,omitempty"`

	// Year: Optional. Year of date. Must be from 1 to 9999, or 0 if
	// specifying a datetime without a year.
	Year int64 `json:"year,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Day") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Day") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DateTime) MarshalJSON() ([]byte, error) {
	type NoMethod DateTime
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DeliveryTime struct {
	// CutoffTime: Business days cutoff time definition. If not configured
	// the cutoff time will be defaulted to 8AM PST.
	CutoffTime *CutoffTime `json:"cutoffTime,omitempty"`

	// HandlingBusinessDayConfig: The business days during which orders can
	// be handled. If not provided, Monday to Friday business days will be
	// assumed.
	HandlingBusinessDayConfig *BusinessDayConfig `json:"handlingBusinessDayConfig,omitempty"`

	// HolidayCutoffs: Holiday cutoff definitions. If configured, they
	// specify order cutoff times for holiday-specific shipping.
	HolidayCutoffs []*HolidayCutoff `json:"holidayCutoffs,omitempty"`

	// MaxHandlingTimeInDays: Maximum number of business days spent before
	// an order is shipped. 0 means same day shipped, 1 means next day
	// shipped. Must be greater than or equal to `minHandlingTimeInDays`.
	MaxHandlingTimeInDays int64 `json:"maxHandlingTimeInDays,omitempty"`

	// MaxTransitTimeInDays: Maximum number of business days that is spent
	// in transit. 0 means same day delivery, 1 means next day delivery.
	// Must be greater than or equal to `minTransitTimeInDays`.
	MaxTransitTimeInDays int64 `json:"maxTransitTimeInDays,omitempty"`

	// MinHandlingTimeInDays: Minimum number of business days spent before
	// an order is shipped. 0 means same day shipped, 1 means next day
	// shipped.
	MinHandlingTimeInDays int64 `json:"minHandlingTimeInDays,omitempty"`

	// MinTransitTimeInDays: Minimum number of business days that is spent
	// in transit. 0 means same day delivery, 1 means next day delivery.
	// Either `{min,max}TransitTimeInDays` or `transitTimeTable` must be
	// set, but not both.
	MinTransitTimeInDays int64 `json:"minTransitTimeInDays,omitempty"`

	// TransitBusinessDayConfig: The business days during which orders can
	// be in-transit. If not provided, Monday to Friday business days will
	// be assumed.
	TransitBusinessDayConfig *BusinessDayConfig `json:"transitBusinessDayConfig,omitempty"`

	// TransitTimeTable: Transit time table, number of business days spent
	// in transit based on row and column dimensions. Either
	// `{min,max}TransitTimeInDays` or `transitTimeTable` can be set, but
	// not both.
	TransitTimeTable *TransitTable `json:"transitTimeTable,omitempty"`

	// WarehouseBasedDeliveryTimes: Indicates that the delivery time should
	// be calculated per warehouse (shipping origin location) based on the
	// settings of the selected carrier. When set, no other transit time
	// related field in DeliveryTime should be set.
	WarehouseBasedDeliveryTimes []*WarehouseBasedDeliveryTime `json:"warehouseBasedDeliveryTimes,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CutoffTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CutoffTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DeliveryTime) MarshalJSON() ([]byte, error) {
	type NoMethod DeliveryTime
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ECommercePlatformLinkInfo: Additional information required for
// E_COMMERCE_PLATFORM link type.
type ECommercePlatformLinkInfo struct {
	// ExternalAccountId: The id used by the third party service provider to
	// identify the merchant.
	ExternalAccountId string `json:"externalAccountId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExternalAccountId")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExternalAccountId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ECommercePlatformLinkInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ECommercePlatformLinkInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Error: An error returned by the API.
type Error struct {
	// Domain: The domain of the error.
	Domain string `json:"domain,omitempty"`

	// Message: A description of the error.
	Message string `json:"message,omitempty"`

	// Reason: The error code.
	Reason string `json:"reason,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Domain") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Domain") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Error) MarshalJSON() ([]byte, error) {
	type NoMethod Error
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Errors: A list of errors returned by a failed batch entry.
type Errors struct {
	// Code: The HTTP status of the first error in `errors`.
	Code int64 `json:"code,omitempty"`

	// Errors: A list of errors.
	Errors []*Error `json:"errors,omitempty"`

	// Message: The message of the first error in `errors`.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Errors) MarshalJSON() ([]byte, error) {
	type NoMethod Errors
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FreeListingsProgramStatus: Response message for
// GetFreeListingsProgramStatus.
type FreeListingsProgramStatus struct {
	// RegionStatuses: Status of the program in each region. Regions with
	// the same status and review eligibility are grouped together in
	// `regionCodes`.
	RegionStatuses []*FreeListingsProgramStatusRegionStatus `json:"regionStatuses,omitempty"`

	// State: If program is successfully onboarded for at least one region.
	//
	// Possible values:
	//   "PROGRAM_STATE_UNSPECIFIED" - State is not known.
	//   "ONBOARDED" - Program is onboarded for at least one country.
	//   "NOT_ONBOARDED" - Program is not onboarded for any country.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "RegionStatuses") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RegionStatuses") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *FreeListingsProgramStatus) MarshalJSON() ([]byte, error) {
	type NoMethod FreeListingsProgramStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FreeListingsProgramStatusRegionStatus: Status of program and region.
type FreeListingsProgramStatusRegionStatus struct {
	// DisapprovalDate: Date by which `eligibility_status` will go from
	// `WARNING` to `DISAPPROVED`. It will be present when
	// `eligibility_status` is `WARNING`. Date will be provided in ISO 8601
	// format i.e. YYYY-MM-DD
	DisapprovalDate string `json:"disapprovalDate,omitempty"`

	// EligibilityStatus: Eligibility status of the standard free listing
	// program.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State is not known.
	//   "APPROVED" - If the account has no issues and review is completed
	// successfully.
	//   "DISAPPROVED" - There are one or more issues that needs to be
	// resolved for account to be active for the program. Detailed list of
	// account issues are available in
	// [accountstatuses](https://developers.google.com/shopping-content/refer
	// ence/rest/v2.1/accountstatuses) API.
	//   "WARNING" - If account has issues but offers are servable. Some of
	// the issue can make account DISAPPROVED after a certain deadline.
	//   "UNDER_REVIEW" - Account is under review.
	//   "PENDING_REVIEW" - Account is waiting for review to start.
	//   "ONBOARDING" - Program is currently onboarding.
	EligibilityStatus string `json:"eligibilityStatus,omitempty"`

	// EnhancedEligibilityStatus: Eligibility status of the enhanced free
	// listing program.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State is not known.
	//   "APPROVED" - If the account has no issues and review is completed
	// successfully.
	//   "DISAPPROVED" - There are one or more issues that needs to be
	// resolved for account to be active for the program. Detailed list of
	// account issues are available in
	// [accountstatuses](https://developers.google.com/shopping-content/refer
	// ence/rest/v2.1/accountstatuses) API.
	//   "WARNING" - If account has issues but offers are servable. Some of
	// the issue can make account DISAPPROVED after a certain deadline.
	//   "UNDER_REVIEW" - Account is under review.
	//   "PENDING_REVIEW" - Account is waiting for review to start.
	//   "ONBOARDING" - Program is currently onboarding.
	EnhancedEligibilityStatus string `json:"enhancedEligibilityStatus,omitempty"`

	// IneligibilityReason: Reason if a program in a given country is not
	// eligible for review. Populated only if `review_eligibility_status` is
	// `INELIGIBLE`.
	IneligibilityReason string `json:"ineligibilityReason,omitempty"`

	// RegionCodes: The two-letter ISO 3166-1 alpha-2
	// (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) codes for all the
	// regions with the same `eligibilityStatus` and `reviewEligibility`.
	RegionCodes []string `json:"regionCodes,omitempty"`

	// ReviewEligibilityStatus: If a program in a given country is eligible
	// for review. It will be present only if eligibility status is
	// `DISAPPROVED`.
	//
	// Possible values:
	//   "REVIEW_ELIGIBILITY_UNSPECIFIED" - Review eligibility state is
	// unknown.
	//   "ELIGIBLE" - Account for a region code is eligible for review.
	//   "INELIGIBLE" - Account for a region code is not eligible for
	// review.
	ReviewEligibilityStatus string `json:"reviewEligibilityStatus,omitempty"`

	// ReviewIssues: These issues will be evaluated in review process. Fix
	// all the issues before requesting the review.
	ReviewIssues []string `json:"reviewIssues,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisapprovalDate") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisapprovalDate") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *FreeListingsProgramStatusRegionStatus) MarshalJSON() ([]byte, error) {
	type NoMethod FreeListingsProgramStatusRegionStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GmbAccounts struct {
	// AccountId: The ID of the Merchant Center account.
	AccountId uint64 `json:"accountId,omitempty,string"`

	// GmbAccounts: A list of Business Profiles which are available to the
	// merchant.
	GmbAccounts []*GmbAccountsGmbAccount `json:"gmbAccounts,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccountId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccountId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GmbAccounts) MarshalJSON() ([]byte, error) {
	type NoMethod GmbAccounts
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GmbAccountsGmbAccount struct {
	// Email: The email which identifies the Business Profile.
	Email string `json:"email,omitempty"`

	// ListingCount: Number of listings under this account.
	ListingCount uint64 `json:"listingCount,omitempty,string"`

	// Name: The name of the Business Profile.
	Name string `json:"name,omitempty"`

	// Type: The type of the Business Profile (User or Business).
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Email") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GmbAccountsGmbAccount) MarshalJSON() ([]byte, error) {
	type NoMethod GmbAccountsGmbAccount
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Headers: A non-empty list of row or column headers for a table.
// Exactly one of `prices`, `weights`, `numItems`,
// `postalCodeGroupNames`, or `location` must be set.
type Headers struct {
	// Locations: A list of location ID sets. Must be non-empty. Can only be
	// set if all other fields are not set.
	Locations []*LocationIdSet `json:"locations,omitempty"`

	// NumberOfItems: A list of inclusive number of items upper bounds. The
	// last value can be "infinity". For example `["10", "50",
	// "infinity"]` represents the headers "<= 10 items", "<= 50 items", and
	// "> 50 items". Must be non-empty. Can only be set if all other fields
	// are not set.
	NumberOfItems []string `json:"numberOfItems,omitempty"`

	// PostalCodeGroupNames: A list of postal group names. The last value
	// can be "all other locations". Example: `["zone 1", "zone 2", "all
	// other locations"]`. The referred postal code groups must match the
	// delivery country of the service. Must be non-empty. Can only be set
	// if all other fields are not set.
	PostalCodeGroupNames []string `json:"postalCodeGroupNames,omitempty"`

	// Prices: A list of inclusive order price upper bounds. The last
	// price's value can be "infinity". For example `[{"value": "10",
	// "currency": "USD"}, {"value": "500", "currency": "USD"}, {"value":
	// "infinity", "currency": "USD"}]` represents the headers "<= $10", "<=
	// $500", and "> $500". All prices within a service must have the same
	// currency. Must be non-empty. Can only be set if all other fields are
	// not set.
	Prices []*Price `json:"prices,omitempty"`

	// Weights: A list of inclusive order weight upper bounds. The last
	// weight's value can be "infinity". For example `[{"value": "10",
	// "unit": "kg"}, {"value": "50", "unit": "kg"}, {"value": "infinity",
	// "unit": "kg"}]` represents the headers "<= 10kg", "<= 50kg", and ">
	// 50kg". All weights within a service must have the same unit. Must be
	// non-empty. Can only be set if all other fields are not set.
	Weights []*Weight `json:"weights,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Locations") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Headers) MarshalJSON() ([]byte, error) {
	type NoMethod Headers
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HolidayCutoff struct {
	// DeadlineDate: Date of the order deadline, in ISO 8601 format. E.g.
	// "2016-11-29" for 29th November 2016. Required.
	DeadlineDate string `json:"deadlineDate,omitempty"`

	// DeadlineHour: Hour of the day on the deadline date until which the
	// order has to be placed to qualify for the delivery guarantee.
	// Possible values are: 0 (midnight), 1, ..., 12 (noon), 13, ..., 23.
	// Required.
	DeadlineHour int64 `json:"deadlineHour,omitempty"`

	// DeadlineTimezone: Timezone identifier for the deadline hour. A list
	// of identifiers can be found in the AdWords API documentation. E.g.
	// "Europe/Zurich". Required.
	DeadlineTimezone string `json:"deadlineTimezone,omitempty"`

	// HolidayId: Unique identifier for the holiday. Required.
	HolidayId string `json:"holidayId,omitempty"`

	// VisibleFromDate: Date on which the deadline will become visible to
	// consumers in ISO 8601 format. E.g. "2016-10-31" for 31st October
	// 2016. Required.
	VisibleFromDate string `json:"visibleFromDate,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeadlineDate") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeadlineDate") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HolidayCutoff) MarshalJSON() ([]byte, error) {
	type NoMethod HolidayCutoff
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HolidaysHoliday struct {
	// CountryCode: The CLDR territory code of the country in which the
	// holiday is available. E.g. "US", "DE", "GB". A holiday cutoff can
	// only be configured in a shipping settings service with matching
	// delivery country. Always present.
	CountryCode string `json:"countryCode,omitempty"`

	// Date: Date of the holiday, in ISO 8601 format. E.g. "2016-12-25" for
	// Christmas 2016. Always present.
	Date string `json:"date,omitempty"`

	// DeliveryGuaranteeDate: Date on which the order has to arrive at the
	// customer's, in ISO 8601 format. E.g. "2016-12-24" for 24th December
	// 2016. Always present.
	DeliveryGuaranteeDate string `json:"deliveryGuaranteeDate,omitempty"`

	// DeliveryGuaranteeHour: Hour of the day in the delivery location's
	// timezone on the guaranteed delivery date by which the order has to
	// arrive at the customer's. Possible values are: 0 (midnight), 1, ...,
	// 12 (noon), 13, ..., 23. Always present.
	DeliveryGuaranteeHour uint64 `json:"deliveryGuaranteeHour,omitempty,string"`

	// Id: Unique identifier for the holiday to be used when configuring
	// holiday cutoffs. Always present.
	Id string `json:"id,omitempty"`

	// Type: The holiday type. Always present. Acceptable values are: -
	// "Christmas" - "Easter" - "Father's Day" - "Halloween" -
	// "Independence Day (USA)" - "Mother's Day" - "Thanksgiving" -
	// "Valentine's Day"
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CountryCode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CountryCode") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HolidaysHoliday) MarshalJSON() ([]byte, error) {
	type NoMethod HolidaysHoliday
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InapplicabilityDetails: Map of inapplicability details.
type InapplicabilityDetails struct {
	// InapplicableCount: Count of this inapplicable reason code.
	InapplicableCount int64 `json:"inapplicableCount,omitempty,string"`

	// InapplicableReason: Reason code this rule was not applicable.
	//
	// Possible values:
	//   "INAPPLICABLE_REASON_UNSPECIFIED" - Default value. Should not be
	// used.
	//   "CANNOT_BEAT_BUYBOX_WINNER" - The rule set for this product cannot
	// beat the buybox winner.
	//   "ALREADY_WINNING_BUYBOX" - This product can already win the buybox
	// without rule.
	//   "TRIUMPHED_OVER_BY_SAME_TYPE_RULE" - Another rule of the same type
	// takes precedence over this one.
	//   "TRIUMPHED_OVER_BY_OTHER_RULE_ON_OFFER" - Another rule of a
	// different type takes precedence over this one.
	//   "RESTRICTIONS_NOT_MET" - The rule restrictions are not met. For
	// example, this may be the case if the calculated rule price is lower
	// than floor price in the restriction.
	//   "UNCATEGORIZED" - The reason is not categorized to any known
	// reason.
	//   "INVALID_AUTO_PRICE_MIN" - The auto_pricing_min_price is invalid.
	// For example, it is missing or < 0.
	//   "INVALID_FLOOR_CONFIG" - The floor defined in the rule is invalid.
	// For example, it has the wrong sign which results in a floor < 0.
	InapplicableReason string `json:"inapplicableReason,omitempty"`

	// ForceSendFields is a list of field names (e.g. "InapplicableCount")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "InapplicableCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *InapplicabilityDetails) MarshalJSON() ([]byte, error) {
	type NoMethod InapplicabilityDetails
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type Installment struct {
	// Amount: The amount the buyer has to pay per month.
	Amount *Price `json:"amount,omitempty"`

	// Months: The number of installments the buyer has to pay.
	Months int64 `json:"months,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Amount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Amount") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Installment) MarshalJSON() ([]byte, error) {
	type NoMethod Installment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InvoiceSummary struct {
	// AdditionalChargeSummaries: Summary of the total amounts of the
	// additional charges.
	AdditionalChargeSummaries []*InvoiceSummaryAdditionalChargeSummary `json:"additionalChargeSummaries,omitempty"`

	// ProductTotal: [required] Total price for the product.
	ProductTotal *Amount `json:"productTotal,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AdditionalChargeSummaries") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AdditionalChargeSummaries") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InvoiceSummary) MarshalJSON() ([]byte, error) {
	type NoMethod InvoiceSummary
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InvoiceSummaryAdditionalChargeSummary struct {
	// TotalAmount: [required] Total additional charge for this type.
	TotalAmount *Amount `json:"totalAmount,omitempty"`

	// Type: [required] Type of the additional charge. Acceptable values
	// are: - "shipping"
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "TotalAmount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TotalAmount") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InvoiceSummaryAdditionalChargeSummary) MarshalJSON() ([]byte, error) {
	type NoMethod InvoiceSummaryAdditionalChargeSummary
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// LabelIds: The IDs of labels that should be assigned to the CSS
// domain.
type LabelIds struct {
	// LabelIds: The list of label IDs.
	LabelIds googleapi.Int64s `json:"labelIds,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LabelIds") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LabelIds") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LabelIds) MarshalJSON() ([]byte, error) {
	type NoMethod LabelIds
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type LiaAboutPageSettings struct {
	// Status: The status of the verification process for the About page.
	// Acceptable values are: - "active" - "inactive" - "pending"
	Status string `json:"status,omitempty"`

	// Url: The URL for the About page.
	Url string `json:"url,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Status") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LiaAboutPageSettings) MarshalJSON() ([]byte, error) {
	type NoMethod LiaAboutPageSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type LiaCountrySettings struct {
	// About: The settings for the About page.
	About *LiaAboutPageSettings `json:"about,omitempty"`

	// Country: Required. CLDR country code (e.g. "US").
	Country string `json:"country,omitempty"`

	// HostedLocalStorefrontActive: The status of the "Merchant hosted local
	// storefront" feature.
	HostedLocalStorefrontActive bool `json:"hostedLocalStorefrontActive,omitempty"`

	// Inventory: LIA inventory verification settings.
	Inventory *LiaInventorySettings `json:"inventory,omitempty"`

	// OnDisplayToOrder: LIA "On Display To Order" settings.
	OnDisplayToOrder *LiaOnDisplayToOrderSettings `json:"onDisplayToOrder,omitempty"`

	// PosDataProvider: The POS data provider linked with this country.
	PosDataProvider *LiaPosDataProvider `json:"posDataProvider,omitempty"`

	// StorePickupActive: The status of the "Store pickup" feature.
	StorePickupActive bool `json:"storePickupActive,omitempty"`

	// ForceSendFields is a list of field names (e.g. "About") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "About") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LiaCountrySettings) MarshalJSON() ([]byte, error) {
	type NoMethod LiaCountrySettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type LiaInventorySettings struct {
	// InventoryVerificationContactEmail: The email of the contact for the
	// inventory verification process.
	InventoryVerificationContactEmail string `json:"inventoryVerificationContactEmail,omitempty"`

	// InventoryVerificationContactName: The name of the contact for the
	// inventory verification process.
	InventoryVerificationContactName string `json:"inventoryVerificationContactName,omitempty"`

	// InventoryVerificationContactStatus: The status of the verification
	// contact. Acceptable values are: - "active" - "inactive" -
	// "pending"
	InventoryVerificationContactStatus string `json:"inventoryVerificationContactStatus,omitempty"`

	// Status: The status of the inventory verification process. Acceptable
	// values are: - "active" - "inactive" - "pending"
	Status string `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "InventoryVerificationContactEmail") to unconditionally include in
	// API requests. By default, fields with empty or default values are
	// omitted from API requests. However, any non-pointer, non-interface
	// field appearing in ForceSendFields will be sent to the server
	// regardless of whether the field is empty or not. This may be used to
	// include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "InventoryVerificationContactEmail") to include in API requests with
	// the JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LiaInventorySettings) MarshalJSON() ([]byte, error) {
	type NoMethod LiaInventorySettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type LiaOnDisplayToOrderSettings struct {
	// ShippingCostPolicyUrl: Shipping cost and policy URL.
	ShippingCostPolicyUrl string `json:"shippingCostPolicyUrl,omitempty"`

	// Status: The status of the ?On display to order? feature. Acceptable
	// values are: - "active" - "inactive" - "pending"
	Status string `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ShippingCostPolicyUrl") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ShippingCostPolicyUrl") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *LiaOnDisplayToOrderSettings) MarshalJSON() ([]byte, error) {
	type NoMethod LiaOnDisplayToOrderSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type LiaPosDataProvider struct {
	// PosDataProviderId: The ID of the POS data provider.
	PosDataProviderId uint64 `json:"posDataProviderId,omitempty,string"`

	// PosExternalAccountId: The account ID by which this merchant is known
	// to the POS data provider.
	PosExternalAccountId string `json:"posExternalAccountId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PosDataProviderId")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PosDataProviderId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *LiaPosDataProvider) MarshalJSON() ([]byte, error) {
	type NoMethod LiaPosDataProvider
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// LiaSettings: Local Inventory ads (LIA) settings. All methods except
// listposdataproviders require the admin role.
type LiaSettings struct {
	// AccountId: The ID of the account to which these LIA settings belong.
	// Ignored upon update, always present in get request responses.
	AccountId uint64 `json:"accountId,omitempty,string"`

	// CountrySettings: The LIA settings for each country.
	CountrySettings []*LiaCountrySettings `json:"countrySettings,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#liaSettings"
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AccountId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccountId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LiaSettings) MarshalJSON() ([]byte, error) {
	type NoMethod LiaSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type LiasettingsCustomBatchRequest struct {
	// Entries: The request entries to be processed in the batch.
	Entries []*LiasettingsCustomBatchRequestEntry `json:"entries,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Entries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LiasettingsCustomBatchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod LiasettingsCustomBatchRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type LiasettingsCustomBatchRequestEntry struct {
	// AccountId: The ID of the account for which to get/update account LIA
	// settings.
	AccountId uint64 `json:"accountId,omitempty,string"`

	// BatchId: An entry ID, unique within the batch request.
	BatchId int64 `json:"batchId,omitempty"`

	// ContactEmail: Inventory validation contact email. Required only for
	// SetInventoryValidationContact.
	ContactEmail string `json:"contactEmail,omitempty"`

	// ContactName: Inventory validation contact name. Required only for
	// SetInventoryValidationContact.
	ContactName string `json:"contactName,omitempty"`

	// Country: The country code. Required only for
	// RequestInventoryVerification.
	Country string `json:"country,omitempty"`

	// GmbEmail: The Business Profile. Required only for RequestGmbAccess.
	GmbEmail string `json:"gmbEmail,omitempty"`

	// LiaSettings: The account Lia settings to update. Only defined if the
	// method is `update`.
	LiaSettings *LiaSettings `json:"liaSettings,omitempty"`

	// MerchantId: The ID of the managing account.
	MerchantId uint64 `json:"merchantId,omitempty,string"`

	// Method: The method of the batch entry. Acceptable values are: -
	// "get" - "getAccessibleGmbAccounts" - "requestGmbAccess" -
	// "requestInventoryVerification" -
	// "setInventoryVerificationContact" - "update"
	Method string `json:"method,omitempty"`

	// PosDataProviderId: The ID of POS data provider. Required only for
	// SetPosProvider.
	PosDataProviderId uint64 `json:"posDataProviderId,omitempty,string"`

	// PosExternalAccountId: The account ID by which this merchant is known
	// to the POS provider.
	PosExternalAccountId string `json:"posExternalAccountId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccountId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccountId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LiasettingsCustomBatchRequestEntry) MarshalJSON() ([]byte, error) {
	type NoMethod LiasettingsCustomBatchRequestEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type LiasettingsCustomBatchResponse struct {
	// Entries: The result of the execution of the batch requests.
	Entries []*LiasettingsCustomBatchResponseEntry `json:"entries,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#liasettingsCustomBatchResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Entries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LiasettingsCustomBatchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod LiasettingsCustomBatchResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type LiasettingsCustomBatchResponseEntry struct {
	// BatchId: The ID of the request entry to which this entry responds.
	BatchId int64 `json:"batchId,omitempty"`

	// Errors: A list of errors defined if, and only if, the request failed.
	Errors *Errors `json:"errors,omitempty"`

	// GmbAccounts: The list of accessible Business Profiles.
	GmbAccounts *GmbAccounts `json:"gmbAccounts,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#liasettingsCustomBatchResponseEntry"
	Kind string `json:"kind,omitempty"`

	// LiaSettings: The retrieved or updated Lia settings.
	LiaSettings *LiaSettings `json:"liaSettings,omitempty"`

	// PosDataProviders: The list of POS data providers.
	PosDataProviders []*PosDataProviders `json:"posDataProviders,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BatchId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BatchId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LiasettingsCustomBatchResponseEntry) MarshalJSON() ([]byte, error) {
	type NoMethod LiasettingsCustomBatchResponseEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type LiasettingsGetAccessibleGmbAccountsResponse struct {
	// AccountId: The ID of the Merchant Center account.
	AccountId uint64 `json:"accountId,omitempty,string"`

	// GmbAccounts: A list of Business Profiles which are available to the
	// merchant.
	GmbAccounts []*GmbAccountsGmbAccount `json:"gmbAccounts,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#liasettingsGetAccessibleGmbAccountsResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AccountId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccountId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LiasettingsGetAccessibleGmbAccountsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod LiasettingsGetAccessibleGmbAccountsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type LiasettingsListPosDataProvidersResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#liasettingsListPosDataProvidersResponse".
	Kind string `json:"kind,omitempty"`

	// PosDataProviders: The list of POS data providers for each eligible
	// country
	PosDataProviders []*PosDataProviders `json:"posDataProviders,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LiasettingsListPosDataProvidersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod LiasettingsListPosDataProvidersResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type LiasettingsListResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#liasettingsListResponse".
	Kind string `json:"kind,omitempty"`

	// NextPageToken: The token for the retrieval of the next page of LIA
	// settings.
	NextPageToken string `json:"nextPageToken,omitempty"`

	Resources []*LiaSettings `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LiasettingsListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod LiasettingsListResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type LiasettingsRequestGmbAccessResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#liasettingsRequestGmbAccessResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LiasettingsRequestGmbAccessResponse) MarshalJSON() ([]byte, error) {
	type NoMethod LiasettingsRequestGmbAccessResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type LiasettingsRequestInventoryVerificationResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#liasettingsRequestInventoryVerificationResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LiasettingsRequestInventoryVerificationResponse) MarshalJSON() ([]byte, error) {
	type NoMethod LiasettingsRequestInventoryVerificationResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type LiasettingsSetInventoryVerificationContactResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string
	// "content#liasettingsSetInventoryVerificationContactResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LiasettingsSetInventoryVerificationContactResponse) MarshalJSON() ([]byte, error) {
	type NoMethod LiasettingsSetInventoryVerificationContactResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type LiasettingsSetPosDataProviderResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#liasettingsSetPosDataProviderResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LiasettingsSetPosDataProviderResponse) MarshalJSON() ([]byte, error) {
	type NoMethod LiasettingsSetPosDataProviderResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type LinkService struct {
	// Service: Service provided to or by the linked account. Acceptable
	// values are: - "shoppingActionsOrderManagement" -
	// "shoppingActionsProductManagement" -
	// "shoppingAdsProductManagement" - "paymentProcessing"
	Service string `json:"service,omitempty"`

	// Status: Status of the link Acceptable values are: - "active" -
	// "inactive" - "pending"
	Status string `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Service") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Service") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LinkService) MarshalJSON() ([]byte, error) {
	type NoMethod LinkService
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type LinkedAccount struct {
	// LinkedAccountId: The ID of the linked account.
	LinkedAccountId string `json:"linkedAccountId,omitempty"`

	// Services: List of provided services.
	Services []*LinkService `json:"services,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LinkedAccountId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LinkedAccountId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *LinkedAccount) MarshalJSON() ([]byte, error) {
	type NoMethod LinkedAccount
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListAccountLabelsResponse: Response message for the
// `ListAccountLabels` method.
type ListAccountLabelsResponse struct {
	// AccountLabels: The labels from the specified account.
	AccountLabels []*AccountLabel `json:"accountLabels,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AccountLabels") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccountLabels") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListAccountLabelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAccountLabelsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListAccountReturnCarrierResponse: Response for listing account return
// carriers.
type ListAccountReturnCarrierResponse struct {
	// AccountReturnCarriers: List of all available account return carriers
	// for the merchant.
	AccountReturnCarriers []*AccountReturnCarrier `json:"accountReturnCarriers,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "AccountReturnCarriers") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccountReturnCarriers") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ListAccountReturnCarrierResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAccountReturnCarrierResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListCollectionStatusesResponse: Response message for the
// ListCollectionStatuses method.
type ListCollectionStatusesResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Resources: The collectionstatuses listed.
	Resources []*CollectionStatus `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListCollectionStatusesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListCollectionStatusesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListCollectionsResponse: Response message for the ListCollections
// method.
type ListCollectionsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Resources: The collections listed.
	Resources []*Collection `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListCollectionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListCollectionsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListCssesResponse: The response message for the `ListCsses` method
type ListCssesResponse struct {
	// Csses: The CSS domains affiliated with the specified CSS group.
	Csses []*Css `json:"csses,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Csses") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Csses") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListCssesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListCssesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListRegionsResponse: Response message for the `ListRegions` method.
type ListRegionsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Regions: The regions from the specified merchant.
	Regions []*Region `json:"regions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListRegionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListRegionsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListRepricingProductReportsResponse: Response message for the
// ListRepricingProductReports method.
type ListRepricingProductReportsResponse struct {
	// NextPageToken: A token for retrieving the next page. Its absence
	// means there is no subsequent page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// RepricingProductReports: Periodic reports for the given Repricing
	// product.
	RepricingProductReports []*RepricingProductReport `json:"repricingProductReports,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListRepricingProductReportsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListRepricingProductReportsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListRepricingRuleReportsResponse: Response message for the
// ListRepricingRuleReports method.
type ListRepricingRuleReportsResponse struct {
	// NextPageToken: A token for retrieving the next page. Its absence
	// means there is no subsequent page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// RepricingRuleReports: Daily reports for the given Repricing rule.
	RepricingRuleReports []*RepricingRuleReport `json:"repricingRuleReports,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListRepricingRuleReportsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListRepricingRuleReportsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListRepricingRulesResponse: Response message for the
// `ListRepricingRules` method.
type ListRepricingRulesResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// RepricingRules: The rules from the specified merchant.
	RepricingRules []*RepricingRule `json:"repricingRules,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListRepricingRulesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListRepricingRulesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListReturnPolicyOnlineResponse: Response message for the
// `ListReturnPolicyOnline` method.
type ListReturnPolicyOnlineResponse struct {
	// ReturnPolicies: The retrieved return policies.
	ReturnPolicies []*ReturnPolicyOnline `json:"returnPolicies,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ReturnPolicies") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ReturnPolicies") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ListReturnPolicyOnlineResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListReturnPolicyOnlineResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// LocalInventory: Local inventory resource. For accepted attribute
// values, see the local product inventory feed specification.
type LocalInventory struct {
	// Availability: Availability of the product. For accepted attribute
	// values, see the local product inventory feed specification.
	Availability string `json:"availability,omitempty"`

	// InstoreProductLocation: In-store product location.
	InstoreProductLocation string `json:"instoreProductLocation,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#localInventory"
	Kind string `json:"kind,omitempty"`

	// PickupMethod: Supported pickup method for this offer. Unless the
	// value is "not supported", this field must be submitted together with
	// `pickupSla`. For accepted attribute values, see the local product
	// inventory feed specification.
	PickupMethod string `json:"pickupMethod,omitempty"`

	// PickupSla: Expected date that an order will be ready for pickup
	// relative to the order date. Must be submitted together with
	// `pickupMethod`. For accepted attribute values, see the local product
	// inventory feed specification.
	PickupSla string `json:"pickupSla,omitempty"`

	// Price: Price of the product.
	Price *Price `json:"price,omitempty"`

	// Quantity: Quantity of the product. Must be nonnegative.
	Quantity int64 `json:"quantity,omitempty"`

	// SalePrice: Sale price of the product. Mandatory if
	// `sale_price_effective_date` is defined.
	SalePrice *Price `json:"salePrice,omitempty"`

	// SalePriceEffectiveDate: A date range represented by a pair of ISO
	// 8601 dates separated by a space, comma, or slash. Both dates may be
	// specified as 'null' if undecided.
	SalePriceEffectiveDate string `json:"salePriceEffectiveDate,omitempty"`

	// StoreCode: Required. Store code of this local inventory resource.
	StoreCode string `json:"storeCode,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Availability") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Availability") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LocalInventory) MarshalJSON() ([]byte, error) {
	type NoMethod LocalInventory
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type LocalinventoryCustomBatchRequest struct {
	// Entries: The request entries to be processed in the batch.
	Entries []*LocalinventoryCustomBatchRequestEntry `json:"entries,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Entries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LocalinventoryCustomBatchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod LocalinventoryCustomBatchRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// LocalinventoryCustomBatchRequestEntry: Batch entry encoding a single
// local inventory update request.
type LocalinventoryCustomBatchRequestEntry struct {
	// BatchId: An entry ID, unique within the batch request.
	BatchId int64 `json:"batchId,omitempty"`

	// LocalInventory: Local inventory of the product.
	LocalInventory *LocalInventory `json:"localInventory,omitempty"`

	// MerchantId: The ID of the managing account.
	MerchantId uint64 `json:"merchantId,omitempty,string"`

	// Method: Method of the batch request entry. Acceptable values are: -
	// "insert"
	Method string `json:"method,omitempty"`

	// ProductId: The ID of the product for which to update local inventory.
	ProductId string `json:"productId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BatchId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BatchId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LocalinventoryCustomBatchRequestEntry) MarshalJSON() ([]byte, error) {
	type NoMethod LocalinventoryCustomBatchRequestEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type LocalinventoryCustomBatchResponse struct {
	// Entries: The result of the execution of the batch requests.
	Entries []*LocalinventoryCustomBatchResponseEntry `json:"entries,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#localinventoryCustomBatchResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Entries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LocalinventoryCustomBatchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod LocalinventoryCustomBatchResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// LocalinventoryCustomBatchResponseEntry: Batch entry encoding a single
// local inventory update response.
type LocalinventoryCustomBatchResponseEntry struct {
	// BatchId: The ID of the request entry this entry responds to.
	BatchId int64 `json:"batchId,omitempty"`

	// Errors: A list of errors defined if and only if the request failed.
	Errors *Errors `json:"errors,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#localinventoryCustomBatchResponseEntry"
	Kind string `json:"kind,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BatchId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BatchId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LocalinventoryCustomBatchResponseEntry) MarshalJSON() ([]byte, error) {
	type NoMethod LocalinventoryCustomBatchResponseEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type LocationIdSet struct {
	// LocationIds: A non-empty list of location IDs. They must all be of
	// the same location type (e.g., state).
	LocationIds []string `json:"locationIds,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LocationIds") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LocationIds") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LocationIdSet) MarshalJSON() ([]byte, error) {
	type NoMethod LocationIdSet
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type LoyaltyPoints struct {
	// Name: Name of loyalty points program. It is recommended to limit the
	// name to 12 full-width characters or 24 Roman characters.
	Name string `json:"name,omitempty"`

	// PointsValue: The retailer's loyalty points in absolute value.
	PointsValue int64 `json:"pointsValue,omitempty,string"`

	// Ratio: The ratio of a point when converted to currency. Google
	// assumes currency based on Merchant Center settings. If ratio is left
	// out, it defaults to 1.0.
	Ratio float64 `json:"ratio,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LoyaltyPoints) MarshalJSON() ([]byte, error) {
	type NoMethod LoyaltyPoints
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *LoyaltyPoints) UnmarshalJSON(data []byte) error {
	type NoMethod LoyaltyPoints
	var s1 struct {
		Ratio gensupport.JSONFloat64 `json:"ratio"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Ratio = float64(s1.Ratio)
	return nil
}

// MerchantOrderReturn: Order return. Production access (all methods)
// requires the order manager role. Sandbox access does not.
type MerchantOrderReturn struct {
	// CreationDate: The date of creation of the return, in ISO 8601 format.
	CreationDate string `json:"creationDate,omitempty"`

	// MerchantOrderId: Merchant defined order ID.
	MerchantOrderId string `json:"merchantOrderId,omitempty"`

	// OrderId: Google order ID.
	OrderId string `json:"orderId,omitempty"`

	// OrderReturnId: Order return ID generated by Google.
	OrderReturnId string `json:"orderReturnId,omitempty"`

	// ReturnItems: Items of the return.
	ReturnItems []*MerchantOrderReturnItem `json:"returnItems,omitempty"`

	// ReturnPricingInfo: Information about shipping costs.
	ReturnPricingInfo *ReturnPricingInfo `json:"returnPricingInfo,omitempty"`

	// ReturnShipments: Shipments of the return.
	ReturnShipments []*ReturnShipment `json:"returnShipments,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreationDate") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreationDate") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MerchantOrderReturn) MarshalJSON() ([]byte, error) {
	type NoMethod MerchantOrderReturn
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type MerchantOrderReturnItem struct {
	// CustomerReturnReason: The reason that the customer chooses to return
	// an item.
	CustomerReturnReason *CustomerReturnReason `json:"customerReturnReason,omitempty"`

	// ItemId: Product level item ID. If the returned items are of the same
	// product, they will have the same ID.
	ItemId string `json:"itemId,omitempty"`

	// MerchantRejectionReason: The reason that the merchant chose to reject
	// an item return.
	MerchantRejectionReason *MerchantRejectionReason `json:"merchantRejectionReason,omitempty"`

	// MerchantReturnReason: The reason that merchant chooses to accept a
	// return item.
	MerchantReturnReason *RefundReason `json:"merchantReturnReason,omitempty"`

	// Product: Product data from the time of the order placement.
	Product *OrderLineItemProduct `json:"product,omitempty"`

	// RefundableAmount: Maximum amount that can be refunded for this return
	// item.
	RefundableAmount *MonetaryAmount `json:"refundableAmount,omitempty"`

	// ReturnItemId: Unit level ID for the return item. Different units of
	// the same product will have different IDs.
	ReturnItemId string `json:"returnItemId,omitempty"`

	// ReturnShipmentIds: IDs of the return shipments that this return item
	// belongs to.
	ReturnShipmentIds []string `json:"returnShipmentIds,omitempty"`

	// ShipmentGroupId: ID of the original shipment group. Provided for
	// shipments with invoice support.
	ShipmentGroupId string `json:"shipmentGroupId,omitempty"`

	// ShipmentUnitId: ID of the shipment unit assigned by the merchant.
	// Provided for shipments with invoice support.
	ShipmentUnitId string `json:"shipmentUnitId,omitempty"`

	// State: State of the item. Acceptable values are: - "canceled" -
	// "new" - "received" - "refunded" - "rejected"
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "CustomerReturnReason") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CustomerReturnReason") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *MerchantOrderReturnItem) MarshalJSON() ([]byte, error) {
	type NoMethod MerchantOrderReturnItem
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type MerchantRejectionReason struct {
	// Description: Description of the reason.
	Description string `json:"description,omitempty"`

	// ReasonCode: Code of the rejection reason.
	ReasonCode string `json:"reasonCode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MerchantRejectionReason) MarshalJSON() ([]byte, error) {
	type NoMethod MerchantRejectionReason
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Metrics: Performance metrics. Values are only set for metrics
// requested explicitly in the request's search query.
type Metrics struct {
	// Aos: Average order size - the average number of items in an order.
	// **This metric cannot be segmented by product dimensions.**
	Aos float64 `json:"aos,omitempty"`

	// AovMicros: Average order value - the average value (total price of
	// items) of all placed orders. The currency of the returned value is
	// stored in the currency_code segment. If this metric is selected,
	// 'segments.currency_code' is automatically added to the SELECT clause
	// in the search query (unless it is explicitly selected by the user)
	// and the currency_code segment is populated in the response. **This
	// metric cannot be segmented by product dimensions.**
	AovMicros float64 `json:"aovMicros,omitempty"`

	// Clicks: Number of clicks.
	Clicks int64 `json:"clicks,omitempty,string"`

	// Ctr: Click-through rate - the number of clicks merchant's products
	// receive (clicks) divided by the number of times the products are
	// shown (impressions).
	Ctr float64 `json:"ctr,omitempty"`

	// DaysToShip: Average number of days between an order being placed and
	// the order being fully shipped, reported on the last shipment date.
	// **This metric cannot be segmented by product dimensions.**
	DaysToShip float64 `json:"daysToShip,omitempty"`

	// Impressions: Number of times merchant's products are shown.
	Impressions int64 `json:"impressions,omitempty,string"`

	// ItemDaysToShip: Average number of days between an item being ordered
	// and the item being
	ItemDaysToShip float64 `json:"itemDaysToShip,omitempty"`

	// ItemFillRate: Percentage of shipped items in relation to all
	// finalized items (shipped or rejected by the merchant; unshipped items
	// are not taken into account), reported on the order date. Item fill
	// rate is lowered by merchant rejections.
	ItemFillRate float64 `json:"itemFillRate,omitempty"`

	// OrderedItemSalesMicros: Total price of ordered items. Excludes
	// shipping, taxes (US only), and customer cancellations that happened
	// within 30 minutes of placing the order. The currency of the returned
	// value is stored in the currency_code segment. If this metric is
	// selected, 'segments.currency_code' is automatically added to the
	// SELECT clause in the search query (unless it is explicitly selected
	// by the user) and the currency_code segment is populated in the
	// response.
	OrderedItemSalesMicros int64 `json:"orderedItemSalesMicros,omitempty,string"`

	// OrderedItems: Number of ordered items. Excludes customer
	// cancellations that happened within 30 minutes of placing the order.
	OrderedItems int64 `json:"orderedItems,omitempty,string"`

	// Orders: Number of placed orders. Excludes customer cancellations that
	// happened within 30 minutes of placing the order. **This metric cannot
	// be segmented by product dimensions.**
	Orders int64 `json:"orders,omitempty,string"`

	// RejectedItems: Number of ordered items canceled by the merchant,
	// reported on the order date.
	RejectedItems int64 `json:"rejectedItems,omitempty,string"`

	// ReturnRate: Total price of returned items divided by the total price
	// of shipped items, reported on the order date. If this metric is
	// selected, 'segments.currency_code' is automatically added to the
	// SELECT clause in the search query (unless it is explicitly selected
	// by the user) and the currency_code segment is populated in the
	// response.
	ReturnRate float64 `json:"returnRate,omitempty"`

	// ReturnedItems: Number of ordered items sent back for return, reported
	// on the date when the merchant accepted the return.
	ReturnedItems int64 `json:"returnedItems,omitempty,string"`

	// ReturnsMicros: Total price of ordered items sent back for return,
	// reported on the date when the merchant accepted the return. The
	// currency of the returned value is stored in the currency_code
	// segment. If this metric is selected, 'segments.currency_code' is
	// automatically added to the SELECT clause in the search query (unless
	// it is explicitly selected by the user) and the currency_code segment
	// is populated in the response.
	ReturnsMicros int64 `json:"returnsMicros,omitempty,string"`

	// ShippedItemSalesMicros: Total price of shipped items, reported on the
	// order date. Excludes shipping and taxes (US only). The currency of
	// the returned value is stored in the currency_code segment. If this
	// metric is selected, 'segments.currency_code' is automatically added
	// to the SELECT clause in the search query (unless it is explicitly
	// selected by the user) and the currency_code segment is populated in
	// the response.
	ShippedItemSalesMicros int64 `json:"shippedItemSalesMicros,omitempty,string"`

	// ShippedItems: Number of shipped items, reported on the shipment date.
	ShippedItems int64 `json:"shippedItems,omitempty,string"`

	// ShippedOrders: Number of fully shipped orders, reported on the last
	// shipment date. **This metric cannot be segmented by product
	// dimensions.**
	ShippedOrders int64 `json:"shippedOrders,omitempty,string"`

	// UnshippedItems: Number of ordered items not shipped up until the end
	// of the queried day. If a multi-day period is specified in the search
	// query, the returned value is the average number of unshipped items
	// over the days in the queried period.
	UnshippedItems float64 `json:"unshippedItems,omitempty"`

	// UnshippedOrders: Number of orders not shipped or partially shipped up
	// until the end of the queried day. If a multi-day period is specified
	// in the search query, the returned value is the average number of
	// unshipped orders over the days in the queried period. **This metric
	// cannot be segmented by product dimensions.**
	UnshippedOrders float64 `json:"unshippedOrders,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Aos") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Aos") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Metrics) MarshalJSON() ([]byte, error) {
	type NoMethod Metrics
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *Metrics) UnmarshalJSON(data []byte) error {
	type NoMethod Metrics
	var s1 struct {
		Aos             gensupport.JSONFloat64 `json:"aos"`
		AovMicros       gensupport.JSONFloat64 `json:"aovMicros"`
		Ctr             gensupport.JSONFloat64 `json:"ctr"`
		DaysToShip      gensupport.JSONFloat64 `json:"daysToShip"`
		ItemDaysToShip  gensupport.JSONFloat64 `json:"itemDaysToShip"`
		ItemFillRate    gensupport.JSONFloat64 `json:"itemFillRate"`
		ReturnRate      gensupport.JSONFloat64 `json:"returnRate"`
		UnshippedItems  gensupport.JSONFloat64 `json:"unshippedItems"`
		UnshippedOrders gensupport.JSONFloat64 `json:"unshippedOrders"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Aos = float64(s1.Aos)
	s.AovMicros = float64(s1.AovMicros)
	s.Ctr = float64(s1.Ctr)
	s.DaysToShip = float64(s1.DaysToShip)
	s.ItemDaysToShip = float64(s1.ItemDaysToShip)
	s.ItemFillRate = float64(s1.ItemFillRate)
	s.ReturnRate = float64(s1.ReturnRate)
	s.UnshippedItems = float64(s1.UnshippedItems)
	s.UnshippedOrders = float64(s1.UnshippedOrders)
	return nil
}

type MinimumOrderValueTable struct {
	StoreCodeSetWithMovs []*MinimumOrderValueTableStoreCodeSetWithMov `json:"storeCodeSetWithMovs,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "StoreCodeSetWithMovs") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "StoreCodeSetWithMovs") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *MinimumOrderValueTable) MarshalJSON() ([]byte, error) {
	type NoMethod MinimumOrderValueTable
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MinimumOrderValueTableStoreCodeSetWithMov: A list of store code sets
// sharing the same minimum order value. At least two sets are required
// and the last one must be empty, which signifies 'MOV for all other
// stores'. Each store code can only appear once across all the sets.
// All prices within a service must have the same currency.
type MinimumOrderValueTableStoreCodeSetWithMov struct {
	// StoreCodes: A list of unique store codes or empty for the catch all.
	StoreCodes []string `json:"storeCodes,omitempty"`

	// Value: The minimum order value for the given stores.
	Value *Price `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "StoreCodes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "StoreCodes") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MinimumOrderValueTableStoreCodeSetWithMov) MarshalJSON() ([]byte, error) {
	type NoMethod MinimumOrderValueTableStoreCodeSetWithMov
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type MonetaryAmount struct {
	// PriceAmount: The pre-tax or post-tax price depends on the location of
	// the order. - For countries (e.g. US) where price attribute excludes
	// tax, this field corresponds to the pre-tax value. - For coutries
	// (e.g. France) where price attribute includes tax, this field
	// corresponds to the post-tax value .
	PriceAmount *Price `json:"priceAmount,omitempty"`

	// TaxAmount: Tax value, present only for countries where price
	// attribute excludes tax (e.g. US). No tax is referenced as 0 value
	// with the corresponding `currency`.
	TaxAmount *Price `json:"taxAmount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PriceAmount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PriceAmount") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MonetaryAmount) MarshalJSON() ([]byte, error) {
	type NoMethod MonetaryAmount
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// OnboardBuyOnGoogleProgramRequest: Request message for the
// OnboardProgram method.
type OnboardBuyOnGoogleProgramRequest struct {
	// CustomerServiceEmail: The customer service email.
	CustomerServiceEmail string `json:"customerServiceEmail,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "CustomerServiceEmail") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CustomerServiceEmail") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *OnboardBuyOnGoogleProgramRequest) MarshalJSON() ([]byte, error) {
	type NoMethod OnboardBuyOnGoogleProgramRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Order: Order. Production access (all methods) requires the order
// manager role. Sandbox access does not.
type Order struct {
	// Acknowledged: Whether the order was acknowledged.
	Acknowledged bool `json:"acknowledged,omitempty"`

	// Annotations: List of key-value pairs that are attached to a given
	// order.
	Annotations []*OrderOrderAnnotation `json:"annotations,omitempty"`

	// BillingAddress: The billing address.
	BillingAddress *OrderAddress `json:"billingAddress,omitempty"`

	// Customer: The details of the customer who placed the order.
	Customer *OrderCustomer `json:"customer,omitempty"`

	// DeliveryDetails: Delivery details for shipments of type `delivery`.
	DeliveryDetails *OrderDeliveryDetails `json:"deliveryDetails,omitempty"`

	// Id: The REST ID of the order. Globally unique.
	Id string `json:"id,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#order"
	Kind string `json:"kind,omitempty"`

	// LineItems: Line items that are ordered.
	LineItems []*OrderLineItem `json:"lineItems,omitempty"`

	MerchantId uint64 `json:"merchantId,omitempty,string"`

	// MerchantOrderId: Merchant-provided ID of the order.
	MerchantOrderId string `json:"merchantOrderId,omitempty"`

	// NetPriceAmount: The net amount for the order (price part). For
	// example, if an order was originally for $100 and a refund was issued
	// for $20, the net amount will be $80.
	NetPriceAmount *Price `json:"netPriceAmount,omitempty"`

	// NetTaxAmount: The net amount for the order (tax part). Note that in
	// certain cases due to taxable base adjustment `netTaxAmount` might not
	// match to a sum of tax field across all lineItems and refunds.
	NetTaxAmount *Price `json:"netTaxAmount,omitempty"`

	// PaymentStatus: The status of the payment. Acceptable values are: -
	// "paymentCaptured" - "paymentRejected" - "paymentSecured" -
	// "pendingAuthorization"
	PaymentStatus string `json:"paymentStatus,omitempty"`

	// PickupDetails: Pickup details for shipments of type `pickup`.
	PickupDetails *OrderPickupDetails `json:"pickupDetails,omitempty"`

	// PlacedDate: The date when the order was placed, in ISO 8601 format.
	PlacedDate string `json:"placedDate,omitempty"`

	// Promotions: Promotions associated with the order. To determine which
	// promotions apply to which products, check the
	// `Promotions[].appliedItems[].lineItemId` field against the
	// `LineItems[].id` field for each promotion. If a promotion is applied
	// to more than 1 offerId, divide the discount value by the number of
	// affected offers to determine how much discount to apply to each
	// offerId. Examples: 1. To calculate price paid by the customer for a
	// single line item including the discount: For each promotion, subtract
	// the `LineItems[].adjustments[].priceAdjustment.value` amount from the
	// `LineItems[].Price.value`. 2. To calculate price paid by the customer
	// for a single line item including the discount in case of multiple
	// quantity: For each promotion, divide the
	// `LineItems[].adjustments[].priceAdjustment.value` by the quantity of
	// products then subtract the resulting value from the
	// `LineItems[].Product.Price.value` for each quantity item. Only 1
	// promotion can be applied to an offerId in a given order. To refund an
	// item which had a promotion applied to it, make sure to refund the
	// amount after first subtracting the promotion discount from the item
	// price. More details about the program are here.
	Promotions []*OrderPromotion `json:"promotions,omitempty"`

	// Refunds: Refunds for the order.
	Refunds []*OrderRefund `json:"refunds,omitempty"`

	// Shipments: Shipments of the order.
	Shipments []*OrderShipment `json:"shipments,omitempty"`

	// ShippingCost: The total cost of shipping for all items.
	ShippingCost *Price `json:"shippingCost,omitempty"`

	// ShippingCostTax: The tax for the total shipping cost.
	ShippingCostTax *Price `json:"shippingCostTax,omitempty"`

	// Status: The status of the order. Acceptable values are: -
	// "canceled" - "delivered" - "inProgress" -
	// "partiallyDelivered" - "partiallyReturned" - "partiallyShipped"
	// - "pendingShipment" - "returned" - "shipped"
	Status string `json:"status,omitempty"`

	// TaxCollector: The party responsible for collecting and remitting
	// taxes. Acceptable values are: - "marketplaceFacilitator" -
	// "merchant"
	TaxCollector string `json:"taxCollector,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Acknowledged") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Acknowledged") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Order) MarshalJSON() ([]byte, error) {
	type NoMethod Order
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderAddress struct {
	// Country: CLDR country code (e.g. "US").
	Country string `json:"country,omitempty"`

	// FullAddress: Strings representing the lines of the printed label for
	// mailing the order, for example: John Smith 1600 Amphitheatre Parkway
	// Mountain View, CA, 94043 United States
	FullAddress []string `json:"fullAddress,omitempty"`

	// IsPostOfficeBox: Whether the address is a post office box.
	IsPostOfficeBox bool `json:"isPostOfficeBox,omitempty"`

	// Locality: City, town or commune. May also include dependent
	// localities or sublocalities (e.g. neighborhoods or suburbs).
	Locality string `json:"locality,omitempty"`

	// PostalCode: Postal Code or ZIP (e.g. "94043").
	PostalCode string `json:"postalCode,omitempty"`

	// RecipientName: Name of the recipient.
	RecipientName string `json:"recipientName,omitempty"`

	// Region: Top-level administrative subdivision of the country. For
	// example, a state like California ("CA") or a province like Quebec
	// ("QC").
	Region string `json:"region,omitempty"`

	// StreetAddress: Street-level part of the address.
	StreetAddress []string `json:"streetAddress,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Country") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Country") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderAddress) MarshalJSON() ([]byte, error) {
	type NoMethod OrderAddress
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderCancellation struct {
	// Actor: The actor that created the cancellation. Acceptable values
	// are: - "customer" - "googleBot" - "googleCustomerService" -
	// "googlePayments" - "googleSabre" - "merchant"
	Actor string `json:"actor,omitempty"`

	// CreationDate: Date on which the cancellation has been created, in ISO
	// 8601 format.
	CreationDate string `json:"creationDate,omitempty"`

	// Quantity: The quantity that was canceled.
	Quantity int64 `json:"quantity,omitempty"`

	// Reason: The reason for the cancellation. Orders that are canceled
	// with a noInventory reason will lead to the removal of the product
	// from Buy on Google until you make an update to that product. This
	// will not affect your Shopping ads. Acceptable values are: -
	// "autoPostInternal" - "autoPostInvalidBillingAddress" -
	// "autoPostNoInventory" - "autoPostPriceError" -
	// "autoPostUndeliverableShippingAddress" - "couponAbuse" -
	// "customerCanceled" - "customerInitiatedCancel" -
	// "customerSupportRequested" - "failToPushOrderGoogleError" -
	// "failToPushOrderMerchantError" -
	// "failToPushOrderMerchantFulfillmentError" -
	// "failToPushOrderToMerchant" -
	// "failToPushOrderToMerchantOutOfStock" - "invalidCoupon" -
	// "malformedShippingAddress" - "merchantDidNotShipOnTime" -
	// "noInventory" - "orderTimeout" - "other" - "paymentAbuse" -
	// "paymentDeclined" - "priceError" - "returnRefundAbuse" -
	// "shippingPriceError" - "taxError" -
	// "undeliverableShippingAddress" - "unsupportedPoBoxAddress" -
	// "failedToCaptureFunds"
	Reason string `json:"reason,omitempty"`

	// ReasonText: The explanation of the reason.
	ReasonText string `json:"reasonText,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Actor") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Actor") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderCancellation) MarshalJSON() ([]byte, error) {
	type NoMethod OrderCancellation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderCustomer struct {
	// FullName: Full name of the customer.
	FullName string `json:"fullName,omitempty"`

	// InvoiceReceivingEmail: Email address for the merchant to send
	// value-added tax or invoice documentation of the order. Only the last
	// document sent is made available to the customer. For more
	// information, see About automated VAT invoicing for Buy on Google.
	InvoiceReceivingEmail string `json:"invoiceReceivingEmail,omitempty"`

	// LoyaltyInfo: Loyalty program information.
	LoyaltyInfo *OrderCustomerLoyaltyInfo `json:"loyaltyInfo,omitempty"`

	// MarketingRightsInfo: Customer's marketing preferences. Contains the
	// marketing opt-in information that is current at the time that the
	// merchant call. User preference selections can change from one order
	// to the next so preferences must be checked with every order.
	MarketingRightsInfo *OrderCustomerMarketingRightsInfo `json:"marketingRightsInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FullName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FullName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderCustomer) MarshalJSON() ([]byte, error) {
	type NoMethod OrderCustomer
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderCustomerLoyaltyInfo struct {
	// LoyaltyNumber: The loyalty card/membership number.
	LoyaltyNumber string `json:"loyaltyNumber,omitempty"`

	// Name: Name of card/membership holder, this field will be populated
	// when
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LoyaltyNumber") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LoyaltyNumber") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderCustomerLoyaltyInfo) MarshalJSON() ([]byte, error) {
	type NoMethod OrderCustomerLoyaltyInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderCustomerMarketingRightsInfo struct {
	// ExplicitMarketingPreference: Last known customer selection regarding
	// marketing preferences. In certain cases this selection might not be
	// known, so this field would be empty. If a customer selected `granted`
	// in their most recent order, they can be subscribed to marketing
	// emails. Customers who have chosen `denied` must not be subscribed, or
	// must be unsubscribed if already opted-in. Acceptable values are: -
	// "denied" - "granted"
	ExplicitMarketingPreference string `json:"explicitMarketingPreference,omitempty"`

	// LastUpdatedTimestamp: Timestamp when last time marketing preference
	// was updated. Could be empty, if user wasn't offered a selection yet.
	LastUpdatedTimestamp string `json:"lastUpdatedTimestamp,omitempty"`

	// MarketingEmailAddress: Email address that can be used for marketing
	// purposes. The field may be empty even if
	// `explicitMarketingPreference` is 'granted'. This happens when
	// retrieving an old order from the customer who deleted their account.
	MarketingEmailAddress string `json:"marketingEmailAddress,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ExplicitMarketingPreference") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "ExplicitMarketingPreference") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderCustomerMarketingRightsInfo) MarshalJSON() ([]byte, error) {
	type NoMethod OrderCustomerMarketingRightsInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderDeliveryDetails struct {
	// Address: The delivery address
	Address *OrderAddress `json:"address,omitempty"`

	// PhoneNumber: The phone number of the person receiving the delivery.
	PhoneNumber string `json:"phoneNumber,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Address") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Address") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderDeliveryDetails) MarshalJSON() ([]byte, error) {
	type NoMethod OrderDeliveryDetails
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderLineItem struct {
	// Adjustments: Price and tax adjustments applied on the line item.
	Adjustments []*OrderLineItemAdjustment `json:"adjustments,omitempty"`

	// Annotations: Annotations that are attached to the line item.
	Annotations []*OrderMerchantProvidedAnnotation `json:"annotations,omitempty"`

	// Cancellations: Cancellations of the line item.
	Cancellations []*OrderCancellation `json:"cancellations,omitempty"`

	// Id: The ID of the line item.
	Id string `json:"id,omitempty"`

	// Price: Total price for the line item. For example, if two items for
	// $10 are purchased, the total price will be $20.
	Price *Price `json:"price,omitempty"`

	// Product: Product data as seen by customer from the time of the order
	// placement. Note that certain attributes values (e.g. title or gtin)
	// might be reformatted and no longer match values submitted via product
	// feed.
	Product *OrderLineItemProduct `json:"product,omitempty"`

	// QuantityCanceled: Number of items canceled.
	QuantityCanceled int64 `json:"quantityCanceled,omitempty"`

	// QuantityDelivered: Number of items delivered.
	QuantityDelivered int64 `json:"quantityDelivered,omitempty"`

	// QuantityOrdered: Number of items ordered.
	QuantityOrdered int64 `json:"quantityOrdered,omitempty"`

	// QuantityPending: Number of items pending.
	QuantityPending int64 `json:"quantityPending,omitempty"`

	// QuantityReadyForPickup: Number of items ready for pickup.
	QuantityReadyForPickup int64 `json:"quantityReadyForPickup,omitempty"`

	// QuantityReturned: Number of items returned.
	QuantityReturned int64 `json:"quantityReturned,omitempty"`

	// QuantityShipped: Number of items shipped.
	QuantityShipped int64 `json:"quantityShipped,omitempty"`

	// QuantityUndeliverable: Number of items undeliverable.
	QuantityUndeliverable int64 `json:"quantityUndeliverable,omitempty"`

	// ReturnInfo: Details of the return policy for the line item.
	ReturnInfo *OrderLineItemReturnInfo `json:"returnInfo,omitempty"`

	// Returns: Returns of the line item.
	Returns []*OrderReturn `json:"returns,omitempty"`

	// ShippingDetails: Details of the requested shipping for the line item.
	ShippingDetails *OrderLineItemShippingDetails `json:"shippingDetails,omitempty"`

	// Tax: Total tax amount for the line item. For example, if two items
	// are purchased, and each have a cost tax of $2, the total tax amount
	// will be $4.
	Tax *Price `json:"tax,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Adjustments") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Adjustments") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderLineItem) MarshalJSON() ([]byte, error) {
	type NoMethod OrderLineItem
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderLineItemAdjustment struct {
	// PriceAdjustment: Adjustment for total price of the line item.
	PriceAdjustment *Price `json:"priceAdjustment,omitempty"`

	// TaxAdjustment: Adjustment for total tax of the line item.
	TaxAdjustment *Price `json:"taxAdjustment,omitempty"`

	// Type: Type of this adjustment. Acceptable values are: - "promotion"
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PriceAdjustment") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PriceAdjustment") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *OrderLineItemAdjustment) MarshalJSON() ([]byte, error) {
	type NoMethod OrderLineItemAdjustment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderLineItemProduct struct {
	// Brand: Brand of the item.
	Brand string `json:"brand,omitempty"`

	// Condition: Condition or state of the item. Acceptable values are: -
	// "new" - "refurbished" - "used"
	Condition string `json:"condition,omitempty"`

	// ContentLanguage: The two-letter ISO 639-1 language code for the item.
	ContentLanguage string `json:"contentLanguage,omitempty"`

	// Fees: Associated fees at order creation time.
	Fees []*OrderLineItemProductFee `json:"fees,omitempty"`

	// Gtin: Global Trade Item Number (GTIN) of the item.
	Gtin string `json:"gtin,omitempty"`

	// Id: The REST ID of the product.
	Id string `json:"id,omitempty"`

	// ImageLink: URL of an image of the item.
	ImageLink string `json:"imageLink,omitempty"`

	// ItemGroupId: Shared identifier for all variants of the same product.
	ItemGroupId string `json:"itemGroupId,omitempty"`

	// Mpn: Manufacturer Part Number (MPN) of the item.
	Mpn string `json:"mpn,omitempty"`

	// OfferId: An identifier of the item.
	OfferId string `json:"offerId,omitempty"`

	// Price: Price of the item.
	Price *Price `json:"price,omitempty"`

	// ShownImage: URL to the cached image shown to the user when order was
	// placed.
	ShownImage string `json:"shownImage,omitempty"`

	// TargetCountry: The CLDR territory // code of the target country of
	// the product.
	TargetCountry string `json:"targetCountry,omitempty"`

	// Title: The title of the product.
	Title string `json:"title,omitempty"`

	// VariantAttributes: Variant attributes for the item. These are
	// dimensions of the product, such as color, gender, material, pattern,
	// and size. You can find a comprehensive list of variant attributes
	// here.
	VariantAttributes []*OrderLineItemProductVariantAttribute `json:"variantAttributes,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Brand") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Brand") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderLineItemProduct) MarshalJSON() ([]byte, error) {
	type NoMethod OrderLineItemProduct
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderLineItemProductFee struct {
	// Amount: Amount of the fee.
	Amount *Price `json:"amount,omitempty"`

	// Name: Name of the fee.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Amount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Amount") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderLineItemProductFee) MarshalJSON() ([]byte, error) {
	type NoMethod OrderLineItemProductFee
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderLineItemProductVariantAttribute struct {
	// Dimension: The dimension of the variant.
	Dimension string `json:"dimension,omitempty"`

	// Value: The value for the dimension.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dimension") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dimension") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderLineItemProductVariantAttribute) MarshalJSON() ([]byte, error) {
	type NoMethod OrderLineItemProductVariantAttribute
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderLineItemReturnInfo struct {
	// DaysToReturn: Required. How many days later the item can be returned.
	DaysToReturn int64 `json:"daysToReturn,omitempty"`

	// IsReturnable: Required. Whether the item is returnable.
	IsReturnable bool `json:"isReturnable,omitempty"`

	// PolicyUrl: Required. URL of the item return policy.
	PolicyUrl string `json:"policyUrl,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DaysToReturn") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DaysToReturn") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderLineItemReturnInfo) MarshalJSON() ([]byte, error) {
	type NoMethod OrderLineItemReturnInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderLineItemShippingDetails struct {
	// DeliverByDate: Required. The delivery by date, in ISO 8601 format.
	DeliverByDate string `json:"deliverByDate,omitempty"`

	// Method: Required. Details of the shipping method.
	Method *OrderLineItemShippingDetailsMethod `json:"method,omitempty"`

	// PickupPromiseInMinutes: The promised time in minutes in which the
	// order will be ready for pickup. This only applies to
	// buy-online-pickup-in-store same-day order.
	PickupPromiseInMinutes int64 `json:"pickupPromiseInMinutes,omitempty"`

	// ShipByDate: Required. The ship by date, in ISO 8601 format.
	ShipByDate string `json:"shipByDate,omitempty"`

	// Type: Type of shipment. Indicates whether `deliveryDetails` or
	// `pickupDetails` is applicable for this shipment. Acceptable values
	// are: - "delivery" - "pickup"
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeliverByDate") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeliverByDate") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderLineItemShippingDetails) MarshalJSON() ([]byte, error) {
	type NoMethod OrderLineItemShippingDetails
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderLineItemShippingDetailsMethod struct {
	// Carrier: The carrier for the shipping. Optional. See
	// `shipments[].carrier` for a list of acceptable values.
	Carrier string `json:"carrier,omitempty"`

	// MaxDaysInTransit: Required. Maximum transit time.
	MaxDaysInTransit int64 `json:"maxDaysInTransit,omitempty"`

	// MethodName: Required. The name of the shipping method.
	MethodName string `json:"methodName,omitempty"`

	// MinDaysInTransit: Required. Minimum transit time.
	MinDaysInTransit int64 `json:"minDaysInTransit,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Carrier") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Carrier") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderLineItemShippingDetailsMethod) MarshalJSON() ([]byte, error) {
	type NoMethod OrderLineItemShippingDetailsMethod
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderMerchantProvidedAnnotation struct {
	// Key: Key for additional merchant provided (as key-value pairs)
	// annotation about the line item.
	Key string `json:"key,omitempty"`

	// Value: Value for additional merchant provided (as key-value pairs)
	// annotation about the line item.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderMerchantProvidedAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod OrderMerchantProvidedAnnotation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderOrderAnnotation struct {
	// Key: Key for additional google provided (as key-value pairs)
	// annotation.
	Key string `json:"key,omitempty"`

	// Value: Value for additional google provided (as key-value pairs)
	// annotation.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderOrderAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod OrderOrderAnnotation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderPickupDetails struct {
	// Address: Address of the pickup location where the shipment should be
	// sent. Note that `recipientName` in the address is the name of the
	// business at the pickup location.
	Address *OrderAddress `json:"address,omitempty"`

	// Collectors: Collectors authorized to pick up shipment from the pickup
	// location.
	Collectors []*OrderPickupDetailsCollector `json:"collectors,omitempty"`

	// LocationId: ID of the pickup location.
	LocationId string `json:"locationId,omitempty"`

	// PickupType: The pickup type of this order. Acceptable values are: -
	// "merchantStore" - "merchantStoreCurbside" -
	// "merchantStoreLocker" - "thirdPartyPickupPoint" -
	// "thirdPartyLocker"
	PickupType string `json:"pickupType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Address") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Address") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderPickupDetails) MarshalJSON() ([]byte, error) {
	type NoMethod OrderPickupDetails
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderPickupDetailsCollector struct {
	// Name: Name of the person picking up the shipment.
	Name string `json:"name,omitempty"`

	// PhoneNumber: Phone number of the person picking up the shipment.
	PhoneNumber string `json:"phoneNumber,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderPickupDetailsCollector) MarshalJSON() ([]byte, error) {
	type NoMethod OrderPickupDetailsCollector
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderPromotion struct {
	// ApplicableItems: Items that this promotion may be applied to. If
	// empty, there are no restrictions on applicable items and quantity.
	// This field will also be empty for shipping promotions because
	// shipping is not tied to any specific item.
	ApplicableItems []*OrderPromotionItem `json:"applicableItems,omitempty"`

	// AppliedItems: Items that this promotion have been applied to. Do not
	// provide for `orders.createtestorder`. This field will be empty for
	// shipping promotions because shipping is not tied to any specific
	// item.
	AppliedItems []*OrderPromotionItem `json:"appliedItems,omitempty"`

	// EndTime: Promotion end time in ISO 8601 format. Date, time, and
	// offset required, e.g., "2020-01-02T09:00:00+01:00" or
	// "2020-01-02T09:00:00Z".
	EndTime string `json:"endTime,omitempty"`

	// Funder: Required. The party funding the promotion. Only `merchant` is
	// supported for `orders.createtestorder`. Acceptable values are: -
	// "google" - "merchant"
	Funder string `json:"funder,omitempty"`

	// MerchantPromotionId: Required. This field is used to identify
	// promotions within merchants' own systems.
	MerchantPromotionId string `json:"merchantPromotionId,omitempty"`

	// PriceValue: Estimated discount applied to price. Amount is pre-tax or
	// post-tax depending on location of order.
	PriceValue *Price `json:"priceValue,omitempty"`

	// ShortTitle: A short title of the promotion to be shown on the
	// checkout page. Do not provide for `orders.createtestorder`.
	ShortTitle string `json:"shortTitle,omitempty"`

	// StartTime: Promotion start time in ISO 8601 format. Date, time, and
	// offset required, e.g., "2020-01-02T09:00:00+01:00" or
	// "2020-01-02T09:00:00Z".
	StartTime string `json:"startTime,omitempty"`

	// Subtype: Required. The category of the promotion. Only `moneyOff` is
	// supported for `orders.createtestorder`. Acceptable values are: -
	// "buyMGetMoneyOff" - "buyMGetNMoneyOff" - "buyMGetNPercentOff" -
	// "buyMGetPercentOff" - "freeGift" - "freeGiftWithItemId" -
	// "freeGiftWithValue" - "freeShippingOvernight" -
	// "freeShippingStandard" - "freeShippingTwoDay" - "moneyOff" -
	// "percentOff" - "rewardPoints" - "salePrice"
	Subtype string `json:"subtype,omitempty"`

	// TaxValue: Estimated discount applied to tax (if allowed by law). Do
	// not provide for `orders.createtestorder`.
	TaxValue *Price `json:"taxValue,omitempty"`

	// Title: Required. The title of the promotion.
	Title string `json:"title,omitempty"`

	// Type: Required. The scope of the promotion. Only `product` is
	// supported for `orders.createtestorder`. Acceptable values are: -
	// "product" - "shipping"
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ApplicableItems") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApplicableItems") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *OrderPromotion) MarshalJSON() ([]byte, error) {
	type NoMethod OrderPromotion
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderPromotionItem struct {
	// LineItemId: The line item ID of a product. Do not provide for
	// `orders.createtestorder`.
	LineItemId string `json:"lineItemId,omitempty"`

	// OfferId: Required. Offer ID of a product. Only for
	// `orders.createtestorder`.
	OfferId string `json:"offerId,omitempty"`

	// ProductId: `orders.createtestorder`.
	ProductId string `json:"productId,omitempty"`

	// Quantity: The quantity of the associated product. Do not provide for
	// `orders.createtestorder`.
	Quantity int64 `json:"quantity,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LineItemId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LineItemId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderPromotionItem) MarshalJSON() ([]byte, error) {
	type NoMethod OrderPromotionItem
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderRefund struct {
	// Actor: The actor that created the refund. Acceptable values are: -
	// "customer" - "googleBot" - "googleCustomerService" -
	// "googlePayments" - "googleSabre" - "merchant"
	Actor string `json:"actor,omitempty"`

	// Amount: The amount that is refunded.
	Amount *Price `json:"amount,omitempty"`

	// CreationDate: Date on which the item has been created, in ISO 8601
	// format.
	CreationDate string `json:"creationDate,omitempty"`

	// Reason: The reason for the refund. Acceptable values are: -
	// "adjustment" - "autoPostInternal" -
	// "autoPostInvalidBillingAddress" - "autoPostNoInventory" -
	// "autoPostPriceError" - "autoPostUndeliverableShippingAddress" -
	// "couponAbuse" - "courtesyAdjustment" - "customerCanceled" -
	// "customerDiscretionaryReturn" - "customerInitiatedMerchantCancel"
	// - "customerSupportRequested" - "deliveredLateByCarrier" -
	// "deliveredTooLate" - "expiredItem" -
	// "failToPushOrderGoogleError" - "failToPushOrderMerchantError" -
	// "failToPushOrderMerchantFulfillmentError" -
	// "failToPushOrderToMerchant" -
	// "failToPushOrderToMerchantOutOfStock" - "feeAdjustment" -
	// "invalidCoupon" - "lateShipmentCredit" -
	// "malformedShippingAddress" - "merchantDidNotShipOnTime" -
	// "noInventory" - "orderTimeout" - "other" - "paymentAbuse" -
	// "paymentDeclined" - "priceAdjustment" - "priceError" -
	// "productArrivedDamaged" - "productNotAsDescribed" -
	// "promoReallocation" - "qualityNotAsExpected" -
	// "returnRefundAbuse" - "shippingCostAdjustment" -
	// "shippingPriceError" - "taxAdjustment" - "taxError" -
	// "undeliverableShippingAddress" - "unsupportedPoBoxAddress" -
	// "wrongProductShipped"
	Reason string `json:"reason,omitempty"`

	// ReasonText: The explanation of the reason.
	ReasonText string `json:"reasonText,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Actor") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Actor") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderRefund) MarshalJSON() ([]byte, error) {
	type NoMethod OrderRefund
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// OrderReportDisbursement: Order disbursement. All methods require the
// payment analyst role.
type OrderReportDisbursement struct {
	// DisbursementAmount: The disbursement amount.
	DisbursementAmount *Price `json:"disbursementAmount,omitempty"`

	// DisbursementCreationDate: The disbursement date, in ISO 8601 format.
	DisbursementCreationDate string `json:"disbursementCreationDate,omitempty"`

	// DisbursementDate: The date the disbursement was initiated, in ISO
	// 8601 format.
	DisbursementDate string `json:"disbursementDate,omitempty"`

	// DisbursementId: The ID of the disbursement.
	DisbursementId string `json:"disbursementId,omitempty"`

	// MerchantId: The ID of the managing account.
	MerchantId uint64 `json:"merchantId,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "DisbursementAmount")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisbursementAmount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *OrderReportDisbursement) MarshalJSON() ([]byte, error) {
	type NoMethod OrderReportDisbursement
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderReportTransaction struct {
	// DisbursementAmount: The disbursement amount.
	DisbursementAmount *Price `json:"disbursementAmount,omitempty"`

	// DisbursementCreationDate: The date the disbursement was created, in
	// ISO 8601 format.
	DisbursementCreationDate string `json:"disbursementCreationDate,omitempty"`

	// DisbursementDate: The date the disbursement was initiated, in ISO
	// 8601 format.
	DisbursementDate string `json:"disbursementDate,omitempty"`

	// DisbursementId: The ID of the disbursement.
	DisbursementId string `json:"disbursementId,omitempty"`

	// MerchantId: The ID of the managing account.
	MerchantId uint64 `json:"merchantId,omitempty,string"`

	// MerchantOrderId: Merchant-provided ID of the order.
	MerchantOrderId string `json:"merchantOrderId,omitempty"`

	// OrderId: The ID of the order.
	OrderId string `json:"orderId,omitempty"`

	// ProductAmount: Total amount for the items.
	ProductAmount *ProductAmount `json:"productAmount,omitempty"`

	// TransactionDate: The date of the transaction, in ISO 8601 format.
	TransactionDate string `json:"transactionDate,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisbursementAmount")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisbursementAmount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *OrderReportTransaction) MarshalJSON() ([]byte, error) {
	type NoMethod OrderReportTransaction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderReturn struct {
	// Actor: The actor that created the refund. Acceptable values are: -
	// "customer" - "googleBot" - "googleCustomerService" -
	// "googlePayments" - "googleSabre" - "merchant"
	Actor string `json:"actor,omitempty"`

	// CreationDate: Date on which the item has been created, in ISO 8601
	// format.
	CreationDate string `json:"creationDate,omitempty"`

	// Quantity: Quantity that is returned.
	Quantity int64 `json:"quantity,omitempty"`

	// Reason: The reason for the return. Acceptable values are: -
	// "customerDiscretionaryReturn" - "customerInitiatedMerchantCancel"
	// - "deliveredTooLate" - "expiredItem" - "invalidCoupon" -
	// "malformedShippingAddress" - "other" - "productArrivedDamaged"
	// - "productNotAsDescribed" - "qualityNotAsExpected" -
	// "undeliverableShippingAddress" - "unsupportedPoBoxAddress" -
	// "wrongProductShipped"
	Reason string `json:"reason,omitempty"`

	// ReasonText: The explanation of the reason.
	ReasonText string `json:"reasonText,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Actor") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Actor") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderReturn) MarshalJSON() ([]byte, error) {
	type NoMethod OrderReturn
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderShipment struct {
	// Carrier: The carrier handling the shipment. For supported carriers,
	// Google includes the carrier name and tracking URL in emails to
	// customers. For select supported carriers, Google also automatically
	// updates the shipment status based on the provided shipment ID.
	// *Note:* You can also use unsupported carriers, but emails to
	// customers will not include the carrier name or tracking URL, and
	// there will be no automatic order status updates. Supported carriers
	// for US are: - "ups" (United Parcel Service) *automatic status
	// updates* - "usps" (United States Postal Service) *automatic status
	// updates* - "fedex" (FedEx) *automatic status updates * - "dhl"
	// (DHL eCommerce) *automatic status updates* (US only) - "ontrac"
	// (OnTrac) *automatic status updates * - "dhl express" (DHL Express)
	// - "deliv" (Deliv) - "dynamex" (TForce) - "lasership"
	// (LaserShip) - "mpx" (Military Parcel Xpress) - "uds" (United
	// Delivery Service) - "efw" (Estes Forwarding Worldwide) - "jd
	// logistics" (JD Logistics) - "yunexpress" (YunExpress) - "china
	// post" (China Post) - "china ems" (China Post Express Mail Service)
	// - "singapore post" (Singapore Post) - "pos malaysia" (Pos
	// Malaysia) - "postnl" (PostNL) - "ptt" (PTT Turkish Post) -
	// "eub" (ePacket) - "chukou1" (Chukou1 Logistics) - "bestex"
	// (Best Express) - "canada post" (Canada Post) - "purolator"
	// (Purolator) - "canpar" (Canpar) - "india post" (India Post) -
	// "blue dart" (Blue Dart) - "delhivery" (Delhivery) - "dtdc"
	// (DTDC) - "tpc india" (TPC India) - "lso" (Lone Star Overnight) -
	// "tww" (Team Worldwide) Supported carriers for FR are: - "la
	// poste" (La Poste) *automatic status updates * - "colissimo"
	// (Colissimo by La Poste) *automatic status updates* - "ups" (United
	// Parcel Service) *automatic status updates * - "chronopost"
	// (Chronopost by La Poste) - "gls" (General Logistics Systems France)
	// - "dpd" (DPD Group by GeoPost) - "bpost" (Belgian Post Group) -
	// "colis prive" (Colis Privé) - "boxtal" (Boxtal) - "geodis"
	// (GEODIS) - "tnt" (TNT) - "db schenker" (DB Schenker) - "aramex"
	// (Aramex)
	Carrier string `json:"carrier,omitempty"`

	// CreationDate: Date on which the shipment has been created, in ISO
	// 8601 format.
	CreationDate string `json:"creationDate,omitempty"`

	// DeliveryDate: Date on which the shipment has been delivered, in ISO
	// 8601 format. Present only if `status` is `delivered`
	DeliveryDate string `json:"deliveryDate,omitempty"`

	// Id: The ID of the shipment.
	Id string `json:"id,omitempty"`

	// LineItems: The line items that are shipped.
	LineItems []*OrderShipmentLineItemShipment `json:"lineItems,omitempty"`

	// ScheduledDeliveryDetails: Delivery details of the shipment if
	// scheduling is needed.
	ScheduledDeliveryDetails *OrderShipmentScheduledDeliveryDetails `json:"scheduledDeliveryDetails,omitempty"`

	// ShipmentGroupId: The shipment group ID of the shipment. This is set
	// in shiplineitems request.
	ShipmentGroupId string `json:"shipmentGroupId,omitempty"`

	// Status: The status of the shipment. Acceptable values are: -
	// "delivered" - "readyForPickup" - "shipped" - "undeliverable"
	Status string `json:"status,omitempty"`

	// TrackingId: The tracking ID for the shipment.
	TrackingId string `json:"trackingId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Carrier") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Carrier") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderShipment) MarshalJSON() ([]byte, error) {
	type NoMethod OrderShipment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderShipmentLineItemShipment struct {
	// LineItemId: The ID of the line item that is shipped. This value is
	// assigned by Google when an order is created. Either lineItemId or
	// productId is required.
	LineItemId string `json:"lineItemId,omitempty"`

	// ProductId: The ID of the product to ship. This is the REST ID used in
	// the products service. Either lineItemId or productId is required.
	ProductId string `json:"productId,omitempty"`

	// Quantity: The quantity that is shipped.
	Quantity int64 `json:"quantity,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LineItemId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LineItemId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderShipmentLineItemShipment) MarshalJSON() ([]byte, error) {
	type NoMethod OrderShipmentLineItemShipment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderShipmentScheduledDeliveryDetails struct {
	// CarrierPhoneNumber: The phone number of the carrier fulfilling the
	// delivery. The phone number is formatted as the international notation
	// in ITU-T Recommendation E.123 (e.g., "+41 44 668 1800").
	CarrierPhoneNumber string `json:"carrierPhoneNumber,omitempty"`

	// ScheduledDate: The date a shipment is scheduled for delivery, in ISO
	// 8601 format.
	ScheduledDate string `json:"scheduledDate,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CarrierPhoneNumber")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CarrierPhoneNumber") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *OrderShipmentScheduledDeliveryDetails) MarshalJSON() ([]byte, error) {
	type NoMethod OrderShipmentScheduledDeliveryDetails
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// OrderTrackingSignal: Represents a merchant trade from which signals
// are extracted, e.g. shipping.
type OrderTrackingSignal struct {
	// CustomerShippingFee: The shipping fee of the order; this value should
	// be set to zero in the case of free shipping.
	CustomerShippingFee *PriceAmount `json:"customerShippingFee,omitempty"`

	// DeliveryPostalCode: Required. The delivery postal code, as a
	// continuous string without spaces or dashes, e.g. "95016". This field
	// will be anonymized in returned OrderTrackingSignal creation response.
	DeliveryPostalCode string `json:"deliveryPostalCode,omitempty"`

	// DeliveryRegionCode: Required. The [CLDR territory code]
	// (http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml)
	// for the shipping destination.
	DeliveryRegionCode string `json:"deliveryRegionCode,omitempty"`

	// LineItems: Information about line items in the order.
	LineItems []*OrderTrackingSignalLineItemDetails `json:"lineItems,omitempty"`

	// MerchantId: The Google merchant ID of this order tracking signal.
	// This value is optional. If left unset, the caller's merchant ID is
	// used. You must request access in order to provide data on behalf of
	// another merchant. For more information, see Submitting Order Tracking
	// Signals (/shopping-content/guides/order-tracking-signals).
	MerchantId int64 `json:"merchantId,omitempty,string"`

	// OrderCreatedTime: Required. The time when the order was created on
	// the merchant side. Include the year and timezone string, if
	// available.
	OrderCreatedTime *DateTime `json:"orderCreatedTime,omitempty"`

	// OrderId: Required. The ID of the order on the merchant side. This
	// field will be hashed in returned OrderTrackingSignal creation
	// response.
	OrderId string `json:"orderId,omitempty"`

	// OrderTrackingSignalId: Output only. The ID that uniquely identifies
	// this order tracking signal.
	OrderTrackingSignalId int64 `json:"orderTrackingSignalId,omitempty,string"`

	// ShipmentLineItemMapping: The mapping of the line items to the
	// shipment information.
	ShipmentLineItemMapping []*OrderTrackingSignalShipmentLineItemMapping `json:"shipmentLineItemMapping,omitempty"`

	// ShippingInfo: The shipping information for the order.
	ShippingInfo []*OrderTrackingSignalShippingInfo `json:"shippingInfo,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CustomerShippingFee")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CustomerShippingFee") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *OrderTrackingSignal) MarshalJSON() ([]byte, error) {
	type NoMethod OrderTrackingSignal
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// OrderTrackingSignalLineItemDetails: The line items of the order.
type OrderTrackingSignalLineItemDetails struct {
	// Brand: Brand of the product.
	Brand string `json:"brand,omitempty"`

	// Gtin: The Global Trade Item Number.
	Gtin string `json:"gtin,omitempty"`

	// LineItemId: Required. The ID for this line item.
	LineItemId string `json:"lineItemId,omitempty"`

	// Mpn: The manufacturer part number.
	Mpn string `json:"mpn,omitempty"`

	// ProductDescription: Plain text description of this product
	// (deprecated: Please use product_title instead).
	ProductDescription string `json:"productDescription,omitempty"`

	// ProductId: Required. The Content API REST ID of the product, in the
	// form channel:contentLanguage:targetCountry:offerId.
	ProductId string `json:"productId,omitempty"`

	// ProductTitle: Plain text title of this product.
	ProductTitle string `json:"productTitle,omitempty"`

	// Quantity: The quantity of the line item in the order.
	Quantity int64 `json:"quantity,omitempty,string"`

	// Sku: Merchant SKU for this item (deprecated).
	Sku string `json:"sku,omitempty"`

	// Upc: Universal product code for this item (deprecated: Please use
	// GTIN instead).
	Upc string `json:"upc,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Brand") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Brand") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderTrackingSignalLineItemDetails) MarshalJSON() ([]byte, error) {
	type NoMethod OrderTrackingSignalLineItemDetails
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// OrderTrackingSignalShipmentLineItemMapping: Represents how many items
// are in the shipment for the given shipment_id and line_item_id.
type OrderTrackingSignalShipmentLineItemMapping struct {
	// LineItemId: Required. The line item ID.
	LineItemId string `json:"lineItemId,omitempty"`

	// Quantity: The line item quantity in the shipment.
	Quantity int64 `json:"quantity,omitempty,string"`

	// ShipmentId: Required. The shipment ID. This field will be hashed in
	// returned OrderTrackingSignal creation response.
	ShipmentId string `json:"shipmentId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LineItemId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LineItemId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderTrackingSignalShipmentLineItemMapping) MarshalJSON() ([]byte, error) {
	type NoMethod OrderTrackingSignalShipmentLineItemMapping
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// OrderTrackingSignalShippingInfo: The shipping information for the
// order.
type OrderTrackingSignalShippingInfo struct {
	// ActualDeliveryTime: The time when the shipment was actually
	// delivered. Include the year and timezone string, if available. This
	// field is required, if one of the following fields is absent:
	// tracking_id or carrier_name.
	ActualDeliveryTime *DateTime `json:"actualDeliveryTime,omitempty"`

	// CarrierName: The name of the shipping carrier for the delivery. This
	// field is required if one of the following fields is absent:
	// earliest_delivery_promise_time, latest_delivery_promise_time, and
	// actual_delivery_time.
	CarrierName string `json:"carrierName,omitempty"`

	// CarrierServiceName: The service type for fulfillment, e.g., GROUND,
	// FIRST_CLASS, etc.
	CarrierServiceName string `json:"carrierServiceName,omitempty"`

	// EarliestDeliveryPromiseTime: The earliest delivery promised time.
	// Include the year and timezone string, if available. This field is
	// required, if one of the following fields is absent: tracking_id or
	// carrier_name.
	EarliestDeliveryPromiseTime *DateTime `json:"earliestDeliveryPromiseTime,omitempty"`

	// LatestDeliveryPromiseTime: The latest delivery promised time. Include
	// the year and timezone string, if available. This field is required,
	// if one of the following fields is absent: tracking_id or
	// carrier_name.
	LatestDeliveryPromiseTime *DateTime `json:"latestDeliveryPromiseTime,omitempty"`

	// OriginPostalCode: The origin postal code, as a continuous string
	// without spaces or dashes, e.g. "95016". This field will be anonymized
	// in returned OrderTrackingSignal creation response.
	OriginPostalCode string `json:"originPostalCode,omitempty"`

	// OriginRegionCode: The [CLDR territory code]
	// (http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml)
	// for the shipping origin.
	OriginRegionCode string `json:"originRegionCode,omitempty"`

	// ShipmentId: Required. The shipment ID. This field will be hashed in
	// returned OrderTrackingSignal creation response.
	ShipmentId string `json:"shipmentId,omitempty"`

	// ShippedTime: The time when the shipment was shipped. Include the year
	// and timezone string, if available.
	ShippedTime *DateTime `json:"shippedTime,omitempty"`

	// ShippingStatus: The status of the shipment.
	//
	// Possible values:
	//   "SHIPPING_STATE_UNSPECIFIED" - The shipping status is not known to
	// merchant.
	//   "SHIPPED" - All items are shipped.
	//   "DELIVERED" - The shipment is already delivered.
	ShippingStatus string `json:"shippingStatus,omitempty"`

	// TrackingId: The tracking ID of the shipment. This field is required
	// if one of the following fields is absent:
	// earliest_delivery_promise_time, latest_delivery_promise_time, and
	// actual_delivery_time.
	TrackingId string `json:"trackingId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ActualDeliveryTime")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ActualDeliveryTime") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *OrderTrackingSignalShippingInfo) MarshalJSON() ([]byte, error) {
	type NoMethod OrderTrackingSignalShippingInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderinvoicesCreateChargeInvoiceRequest struct {
	// InvoiceId: [required] The ID of the invoice.
	InvoiceId string `json:"invoiceId,omitempty"`

	// InvoiceSummary: [required] Invoice summary.
	InvoiceSummary *InvoiceSummary `json:"invoiceSummary,omitempty"`

	// LineItemInvoices: [required] Invoice details per line item.
	LineItemInvoices []*ShipmentInvoiceLineItemInvoice `json:"lineItemInvoices,omitempty"`

	// OperationId: [required] The ID of the operation, unique across all
	// operations for a given order.
	OperationId string `json:"operationId,omitempty"`

	// ShipmentGroupId: [required] ID of the shipment group. It is assigned
	// by the merchant in the `shipLineItems` method and is used to group
	// multiple line items that have the same kind of shipping charges.
	ShipmentGroupId string `json:"shipmentGroupId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "InvoiceId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "InvoiceId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderinvoicesCreateChargeInvoiceRequest) MarshalJSON() ([]byte, error) {
	type NoMethod OrderinvoicesCreateChargeInvoiceRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderinvoicesCreateChargeInvoiceResponse struct {
	// ExecutionStatus: The status of the execution. Acceptable values are:
	// - "duplicate" - "executed"
	ExecutionStatus string `json:"executionStatus,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#orderinvoicesCreateChargeInvoiceResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ExecutionStatus") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExecutionStatus") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *OrderinvoicesCreateChargeInvoiceResponse) MarshalJSON() ([]byte, error) {
	type NoMethod OrderinvoicesCreateChargeInvoiceResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderinvoicesCreateRefundInvoiceRequest struct {
	// InvoiceId: [required] The ID of the invoice.
	InvoiceId string `json:"invoiceId,omitempty"`

	// OperationId: [required] The ID of the operation, unique across all
	// operations for a given order.
	OperationId string `json:"operationId,omitempty"`

	// RefundOnlyOption: Option to create a refund-only invoice. Exactly one
	// of `refundOnlyOption` or `returnOption` must be provided.
	RefundOnlyOption *OrderinvoicesCustomBatchRequestEntryCreateRefundInvoiceRefundOption `json:"refundOnlyOption,omitempty"`

	// ReturnOption: Option to create an invoice for a refund and mark all
	// items within the invoice as returned. Exactly one of
	// `refundOnlyOption` or `returnOption` must be provided.
	ReturnOption *OrderinvoicesCustomBatchRequestEntryCreateRefundInvoiceReturnOption `json:"returnOption,omitempty"`

	// ShipmentInvoices: Invoice details for different shipment groups.
	ShipmentInvoices []*ShipmentInvoice `json:"shipmentInvoices,omitempty"`

	// ForceSendFields is a list of field names (e.g. "InvoiceId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "InvoiceId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderinvoicesCreateRefundInvoiceRequest) MarshalJSON() ([]byte, error) {
	type NoMethod OrderinvoicesCreateRefundInvoiceRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderinvoicesCreateRefundInvoiceResponse struct {
	// ExecutionStatus: The status of the execution. Acceptable values are:
	// - "duplicate" - "executed"
	ExecutionStatus string `json:"executionStatus,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#orderinvoicesCreateRefundInvoiceResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ExecutionStatus") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExecutionStatus") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *OrderinvoicesCreateRefundInvoiceResponse) MarshalJSON() ([]byte, error) {
	type NoMethod OrderinvoicesCreateRefundInvoiceResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderinvoicesCustomBatchRequestEntryCreateRefundInvoiceRefundOption struct {
	// Description: Optional description of the refund reason.
	Description string `json:"description,omitempty"`

	// Reason: [required] Reason for the refund. Acceptable values are: -
	// "adjustment" - "autoPostInternal" -
	// "autoPostInvalidBillingAddress" - "autoPostNoInventory" -
	// "autoPostPriceError" - "autoPostUndeliverableShippingAddress" -
	// "couponAbuse" - "courtesyAdjustment" - "customerCanceled" -
	// "customerDiscretionaryReturn" - "customerInitiatedMerchantCancel"
	// - "customerSupportRequested" - "deliveredLateByCarrier" -
	// "deliveredTooLate" - "expiredItem" -
	// "failToPushOrderGoogleError" - "failToPushOrderMerchantError" -
	// "failToPushOrderMerchantFulfillmentError" -
	// "failToPushOrderToMerchant" -
	// "failToPushOrderToMerchantOutOfStock" - "feeAdjustment" -
	// "invalidCoupon" - "lateShipmentCredit" -
	// "malformedShippingAddress" - "merchantDidNotShipOnTime" -
	// "noInventory" - "orderTimeout" - "other" - "paymentAbuse" -
	// "paymentDeclined" - "priceAdjustment" - "priceError" -
	// "productArrivedDamaged" - "productNotAsDescribed" -
	// "promoReallocation" - "qualityNotAsExpected" -
	// "returnRefundAbuse" - "shippingCostAdjustment" -
	// "shippingPriceError" - "taxAdjustment" - "taxError" -
	// "undeliverableShippingAddress" - "unsupportedPoBoxAddress" -
	// "wrongProductShipped"
	Reason string `json:"reason,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderinvoicesCustomBatchRequestEntryCreateRefundInvoiceRefundOption) MarshalJSON() ([]byte, error) {
	type NoMethod OrderinvoicesCustomBatchRequestEntryCreateRefundInvoiceRefundOption
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderinvoicesCustomBatchRequestEntryCreateRefundInvoiceReturnOption struct {
	// Description: Optional description of the return reason.
	Description string `json:"description,omitempty"`

	// Reason: [required] Reason for the return. Acceptable values are: -
	// "customerDiscretionaryReturn" - "customerInitiatedMerchantCancel"
	// - "deliveredTooLate" - "expiredItem" - "invalidCoupon" -
	// "malformedShippingAddress" - "other" - "productArrivedDamaged"
	// - "productNotAsDescribed" - "qualityNotAsExpected" -
	// "undeliverableShippingAddress" - "unsupportedPoBoxAddress" -
	// "wrongProductShipped"
	Reason string `json:"reason,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderinvoicesCustomBatchRequestEntryCreateRefundInvoiceReturnOption) MarshalJSON() ([]byte, error) {
	type NoMethod OrderinvoicesCustomBatchRequestEntryCreateRefundInvoiceReturnOption
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderreportsListDisbursementsResponse struct {
	// Disbursements: The list of disbursements.
	Disbursements []*OrderReportDisbursement `json:"disbursements,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#orderreportsListDisbursementsResponse".
	Kind string `json:"kind,omitempty"`

	// NextPageToken: The token for the retrieval of the next page of
	// disbursements.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Disbursements") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Disbursements") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderreportsListDisbursementsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod OrderreportsListDisbursementsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderreportsListTransactionsResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#orderreportsListTransactionsResponse".
	Kind string `json:"kind,omitempty"`

	// NextPageToken: The token for the retrieval of the next page of
	// transactions.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Transactions: The list of transactions.
	Transactions []*OrderReportTransaction `json:"transactions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderreportsListTransactionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod OrderreportsListTransactionsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderreturnsAcknowledgeRequest struct {
	// OperationId: [required] The ID of the operation, unique across all
	// operations for a given order return.
	OperationId string `json:"operationId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OperationId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OperationId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderreturnsAcknowledgeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod OrderreturnsAcknowledgeRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderreturnsAcknowledgeResponse struct {
	// ExecutionStatus: The status of the execution. Acceptable values are:
	// - "duplicate" - "executed"
	ExecutionStatus string `json:"executionStatus,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#orderreturnsAcknowledgeResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ExecutionStatus") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExecutionStatus") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *OrderreturnsAcknowledgeResponse) MarshalJSON() ([]byte, error) {
	type NoMethod OrderreturnsAcknowledgeResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderreturnsCreateOrderReturnRequest struct {
	// LineItems: The list of line items to return.
	LineItems []*OrderreturnsLineItem `json:"lineItems,omitempty"`

	// OperationId: The ID of the operation. Unique across all operations
	// for a given order.
	OperationId string `json:"operationId,omitempty"`

	// OrderId: The ID of the order.
	OrderId string `json:"orderId,omitempty"`

	// ReturnMethodType: The way of the package being returned.
	ReturnMethodType string `json:"returnMethodType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LineItems") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LineItems") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderreturnsCreateOrderReturnRequest) MarshalJSON() ([]byte, error) {
	type NoMethod OrderreturnsCreateOrderReturnRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderreturnsCreateOrderReturnResponse struct {
	// ExecutionStatus: The status of the execution. Acceptable values are:
	// - "duplicate" - "executed"
	ExecutionStatus string `json:"executionStatus,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#orderreturnsCreateOrderReturnResponse".
	Kind string `json:"kind,omitempty"`

	// OrderReturn: Created order return.
	OrderReturn *MerchantOrderReturn `json:"orderReturn,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ExecutionStatus") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExecutionStatus") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *OrderreturnsCreateOrderReturnResponse) MarshalJSON() ([]byte, error) {
	type NoMethod OrderreturnsCreateOrderReturnResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderreturnsLineItem struct {
	// LineItemId: The ID of the line item. This value is assigned by Google
	// when an order is created. Either lineItemId or productId is required.
	LineItemId string `json:"lineItemId,omitempty"`

	// ProductId: The ID of the product to cancel. This is the REST ID used
	// in the products service. Either lineItemId or productId is required.
	ProductId string `json:"productId,omitempty"`

	// Quantity: The quantity of this line item.
	Quantity int64 `json:"quantity,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LineItemId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LineItemId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderreturnsLineItem) MarshalJSON() ([]byte, error) {
	type NoMethod OrderreturnsLineItem
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderreturnsListResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#orderreturnsListResponse".
	Kind string `json:"kind,omitempty"`

	// NextPageToken: The token for the retrieval of the next page of
	// returns.
	NextPageToken string `json:"nextPageToken,omitempty"`

	Resources []*MerchantOrderReturn `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderreturnsListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod OrderreturnsListResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderreturnsPartialRefund struct {
	// PriceAmount: The pre-tax or post-tax amount to be refunded, depending
	// on the location of the order.
	PriceAmount *Price `json:"priceAmount,omitempty"`

	// TaxAmount: Tax amount to be refunded. Note: This has different
	// meaning depending on the location of the order.
	TaxAmount *Price `json:"taxAmount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PriceAmount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PriceAmount") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderreturnsPartialRefund) MarshalJSON() ([]byte, error) {
	type NoMethod OrderreturnsPartialRefund
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderreturnsProcessRequest struct {
	// FullChargeReturnShippingCost: Option to charge the customer return
	// shipping cost.
	FullChargeReturnShippingCost bool `json:"fullChargeReturnShippingCost,omitempty"`

	// OperationId: [required] The ID of the operation, unique across all
	// operations for a given order return.
	OperationId string `json:"operationId,omitempty"`

	// RefundShippingFee: Refunds for original shipping fee.
	RefundShippingFee *OrderreturnsRefundOperation `json:"refundShippingFee,omitempty"`

	// ReturnItems: The list of items to return.
	ReturnItems []*OrderreturnsReturnItem `json:"returnItems,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "FullChargeReturnShippingCost") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "FullChargeReturnShippingCost") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderreturnsProcessRequest) MarshalJSON() ([]byte, error) {
	type NoMethod OrderreturnsProcessRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderreturnsProcessResponse struct {
	// ExecutionStatus: The status of the execution. Acceptable values are:
	// - "duplicate" - "executed"
	ExecutionStatus string `json:"executionStatus,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#orderreturnsProcessResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ExecutionStatus") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExecutionStatus") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *OrderreturnsProcessResponse) MarshalJSON() ([]byte, error) {
	type NoMethod OrderreturnsProcessResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderreturnsRefundOperation struct {
	// FullRefund: If true, the item will be fully refunded. Allowed only
	// when payment_type is FOP. Merchant can choose this refund option to
	// indicate the full remaining amount of corresponding object to be
	// refunded to the customer via FOP.
	FullRefund bool `json:"fullRefund,omitempty"`

	// PartialRefund: If this is set, the item will be partially refunded.
	// Merchant can choose this refund option to specify the customized
	// amount that to be refunded to the customer.
	PartialRefund *OrderreturnsPartialRefund `json:"partialRefund,omitempty"`

	// PaymentType: The payment way of issuing refund. Default value is
	// ORIGINAL_FOP if not set.
	PaymentType string `json:"paymentType,omitempty"`

	// ReasonText: The explanation of the reason.
	ReasonText string `json:"reasonText,omitempty"`

	// ReturnRefundReason: Code of the refund reason.
	ReturnRefundReason string `json:"returnRefundReason,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FullRefund") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FullRefund") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderreturnsRefundOperation) MarshalJSON() ([]byte, error) {
	type NoMethod OrderreturnsRefundOperation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderreturnsRejectOperation struct {
	// Reason: The reason for the return.
	Reason string `json:"reason,omitempty"`

	// ReasonText: The explanation of the reason.
	ReasonText string `json:"reasonText,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Reason") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Reason") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderreturnsRejectOperation) MarshalJSON() ([]byte, error) {
	type NoMethod OrderreturnsRejectOperation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrderreturnsReturnItem struct {
	// Refund: Refunds the item.
	Refund *OrderreturnsRefundOperation `json:"refund,omitempty"`

	// Reject: Rejects the item.
	Reject *OrderreturnsRejectOperation `json:"reject,omitempty"`

	// ReturnItemId: Unit level ID for the return item. Different units of
	// the same product will have different IDs.
	ReturnItemId string `json:"returnItemId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Refund") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Refund") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrderreturnsReturnItem) MarshalJSON() ([]byte, error) {
	type NoMethod OrderreturnsReturnItem
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersAcknowledgeRequest struct {
	// OperationId: The ID of the operation. Unique across all operations
	// for a given order.
	OperationId string `json:"operationId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OperationId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OperationId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrdersAcknowledgeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersAcknowledgeRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersAcknowledgeResponse struct {
	// ExecutionStatus: The status of the execution. Acceptable values are:
	// - "duplicate" - "executed"
	ExecutionStatus string `json:"executionStatus,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#ordersAcknowledgeResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ExecutionStatus") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExecutionStatus") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *OrdersAcknowledgeResponse) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersAcknowledgeResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersAdvanceTestOrderResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#ordersAdvanceTestOrderResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrdersAdvanceTestOrderResponse) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersAdvanceTestOrderResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersCancelLineItemRequest struct {
	// LineItemId: The ID of the line item to cancel. Either lineItemId or
	// productId is required.
	LineItemId string `json:"lineItemId,omitempty"`

	// OperationId: The ID of the operation. Unique across all operations
	// for a given order.
	OperationId string `json:"operationId,omitempty"`

	// ProductId: The ID of the product to cancel. This is the REST ID used
	// in the products service. Either lineItemId or productId is required.
	ProductId string `json:"productId,omitempty"`

	// Quantity: The quantity to cancel.
	Quantity int64 `json:"quantity,omitempty"`

	// Reason: The reason for the cancellation. Acceptable values are: -
	// "customerInitiatedCancel" - "invalidCoupon" -
	// "malformedShippingAddress" - "noInventory" - "other" -
	// "priceError" - "shippingPriceError" - "taxError" -
	// "undeliverableShippingAddress" - "unsupportedPoBoxAddress" -
	// "failedToCaptureFunds"
	Reason string `json:"reason,omitempty"`

	// ReasonText: The explanation of the reason.
	ReasonText string `json:"reasonText,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LineItemId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LineItemId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrdersCancelLineItemRequest) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersCancelLineItemRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersCancelLineItemResponse struct {
	// ExecutionStatus: The status of the execution. Acceptable values are:
	// - "duplicate" - "executed"
	ExecutionStatus string `json:"executionStatus,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#ordersCancelLineItemResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ExecutionStatus") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExecutionStatus") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *OrdersCancelLineItemResponse) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersCancelLineItemResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersCancelRequest struct {
	// OperationId: The ID of the operation. Unique across all operations
	// for a given order.
	OperationId string `json:"operationId,omitempty"`

	// Reason: The reason for the cancellation. Acceptable values are: -
	// "customerInitiatedCancel" - "invalidCoupon" -
	// "malformedShippingAddress" - "noInventory" - "other" -
	// "priceError" - "shippingPriceError" - "taxError" -
	// "undeliverableShippingAddress" - "unsupportedPoBoxAddress" -
	// "failedToCaptureFunds"
	Reason string `json:"reason,omitempty"`

	// ReasonText: The explanation of the reason.
	ReasonText string `json:"reasonText,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OperationId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OperationId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrdersCancelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersCancelRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersCancelResponse struct {
	// ExecutionStatus: The status of the execution. Acceptable values are:
	// - "duplicate" - "executed"
	ExecutionStatus string `json:"executionStatus,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#ordersCancelResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ExecutionStatus") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExecutionStatus") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *OrdersCancelResponse) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersCancelResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersCancelTestOrderByCustomerRequest struct {
	// Reason: The reason for the cancellation. Acceptable values are: -
	// "changedMind" - "orderedWrongItem" - "other"
	Reason string `json:"reason,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Reason") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Reason") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrdersCancelTestOrderByCustomerRequest) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersCancelTestOrderByCustomerRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersCancelTestOrderByCustomerResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#ordersCancelTestOrderByCustomerResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrdersCancelTestOrderByCustomerResponse) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersCancelTestOrderByCustomerResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersCreateTestOrderRequest struct {
	// Country: The CLDR territory code of the country of the test order to
	// create. Affects the currency and addresses of orders created via
	// `template_name`, or the addresses of orders created via `test_order`.
	// Acceptable values are: - "US" - "FR" Defaults to `US`.
	Country string `json:"country,omitempty"`

	// TemplateName: The test order template to use. Specify as an
	// alternative to `testOrder` as a shortcut for retrieving a template
	// and then creating an order using that template. Acceptable values
	// are: - "template1" - "template1a" - "template1b" -
	// "template2" - "template3"
	TemplateName string `json:"templateName,omitempty"`

	// TestOrder: The test order to create.
	TestOrder *TestOrder `json:"testOrder,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Country") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Country") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrdersCreateTestOrderRequest) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersCreateTestOrderRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersCreateTestOrderResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#ordersCreateTestOrderResponse".
	Kind string `json:"kind,omitempty"`

	// OrderId: The ID of the newly created test order.
	OrderId string `json:"orderId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrdersCreateTestOrderResponse) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersCreateTestOrderResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersCreateTestReturnRequest struct {
	// Items: Returned items.
	Items []*OrdersCustomBatchRequestEntryCreateTestReturnReturnItem `json:"items,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Items") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrdersCreateTestReturnRequest) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersCreateTestReturnRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersCreateTestReturnResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#ordersCreateTestReturnResponse".
	Kind string `json:"kind,omitempty"`

	// ReturnId: The ID of the newly created test order return.
	ReturnId string `json:"returnId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrdersCreateTestReturnResponse) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersCreateTestReturnResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersCustomBatchRequestEntryCreateTestReturnReturnItem struct {
	// LineItemId: The ID of the line item to return.
	LineItemId string `json:"lineItemId,omitempty"`

	// Quantity: Quantity that is returned.
	Quantity int64 `json:"quantity,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LineItemId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LineItemId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrdersCustomBatchRequestEntryCreateTestReturnReturnItem) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersCustomBatchRequestEntryCreateTestReturnReturnItem
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersCustomBatchRequestEntryRefundItemItem struct {
	// Amount: The total amount that is refunded. (e.g. refunding $5 each
	// for 2 products should be done by setting quantity to 2 and amount to
	// 10$) In case of multiple refunds, this should be the amount you
	// currently want to refund to the customer.
	Amount *MonetaryAmount `json:"amount,omitempty"`

	// FullRefund: If true, the full item will be refunded. If this is true,
	// amount should not be provided and will be ignored.
	FullRefund bool `json:"fullRefund,omitempty"`

	// LineItemId: The ID of the line item. Either lineItemId or productId
	// is required.
	LineItemId string `json:"lineItemId,omitempty"`

	// ProductId: The ID of the product. This is the REST ID used in the
	// products service. Either lineItemId or productId is required.
	ProductId string `json:"productId,omitempty"`

	// Quantity: The number of products that are refunded.
	Quantity int64 `json:"quantity,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Amount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Amount") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrdersCustomBatchRequestEntryRefundItemItem) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersCustomBatchRequestEntryRefundItemItem
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersCustomBatchRequestEntryRefundItemShipping struct {
	// Amount: The amount that is refunded. If this is not the first refund
	// for the shipment, this should be the newly refunded amount.
	Amount *Price `json:"amount,omitempty"`

	// FullRefund: If set to true, all shipping costs for the order will be
	// refunded. If this is true, amount should not be provided and will be
	// ignored. If set to false, submit the amount of the partial shipping
	// refund, excluding the shipping tax. The shipping tax is calculated
	// and handled on Google's side.
	FullRefund bool `json:"fullRefund,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Amount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Amount") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrdersCustomBatchRequestEntryRefundItemShipping) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersCustomBatchRequestEntryRefundItemShipping
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersCustomBatchRequestEntryShipLineItemsShipmentInfo struct {
	// Carrier: The carrier handling the shipment. See `shipments[].carrier`
	// in the Orders resource representation for a list of acceptable
	// values.
	Carrier string `json:"carrier,omitempty"`

	// ShipmentId: Required. The ID of the shipment. This is assigned by the
	// merchant and is unique to each shipment.
	ShipmentId string `json:"shipmentId,omitempty"`

	// TrackingId: The tracking ID for the shipment.
	TrackingId string `json:"trackingId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Carrier") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Carrier") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrdersCustomBatchRequestEntryShipLineItemsShipmentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersCustomBatchRequestEntryShipLineItemsShipmentInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// OrdersCustomBatchRequestEntryUpdateShipmentScheduledDeliveryDetails:
// ScheduledDeliveryDetails used to update the scheduled delivery order.
type OrdersCustomBatchRequestEntryUpdateShipmentScheduledDeliveryDetails struct {
	// CarrierPhoneNumber: The phone number of the carrier fulfilling the
	// delivery. The phone number should be formatted as the international
	// notation in
	CarrierPhoneNumber string `json:"carrierPhoneNumber,omitempty"`

	// ScheduledDate: The date a shipment is scheduled for delivery, in ISO
	// 8601 format.
	ScheduledDate string `json:"scheduledDate,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CarrierPhoneNumber")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CarrierPhoneNumber") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *OrdersCustomBatchRequestEntryUpdateShipmentScheduledDeliveryDetails) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersCustomBatchRequestEntryUpdateShipmentScheduledDeliveryDetails
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersGetByMerchantOrderIdResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#ordersGetByMerchantOrderIdResponse".
	Kind string `json:"kind,omitempty"`

	// Order: The requested order.
	Order *Order `json:"order,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrdersGetByMerchantOrderIdResponse) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersGetByMerchantOrderIdResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersGetTestOrderTemplateResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#ordersGetTestOrderTemplateResponse".
	Kind string `json:"kind,omitempty"`

	// Template: The requested test order template.
	Template *TestOrder `json:"template,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrdersGetTestOrderTemplateResponse) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersGetTestOrderTemplateResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersInStoreRefundLineItemRequest struct {
	// LineItemId: The ID of the line item to return. Either lineItemId or
	// productId is required.
	LineItemId string `json:"lineItemId,omitempty"`

	// OperationId: The ID of the operation. Unique across all operations
	// for a given order.
	OperationId string `json:"operationId,omitempty"`

	// PriceAmount: The amount to be refunded. This may be pre-tax or
	// post-tax depending on the location of the order. Required.
	PriceAmount *Price `json:"priceAmount,omitempty"`

	// ProductId: The ID of the product to return. This is the REST ID used
	// in the products service. Either lineItemId or productId is required.
	ProductId string `json:"productId,omitempty"`

	// Quantity: The quantity to return and refund.
	Quantity int64 `json:"quantity,omitempty"`

	// Reason: The reason for the return. Acceptable values are: -
	// "customerDiscretionaryReturn" - "customerInitiatedMerchantCancel"
	// - "deliveredTooLate" - "expiredItem" - "invalidCoupon" -
	// "malformedShippingAddress" - "other" - "productArrivedDamaged"
	// - "productNotAsDescribed" - "qualityNotAsExpected" -
	// "undeliverableShippingAddress" - "unsupportedPoBoxAddress" -
	// "wrongProductShipped"
	Reason string `json:"reason,omitempty"`

	// ReasonText: The explanation of the reason.
	ReasonText string `json:"reasonText,omitempty"`

	// TaxAmount: The amount of tax to be refunded. Required.
	TaxAmount *Price `json:"taxAmount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LineItemId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LineItemId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrdersInStoreRefundLineItemRequest) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersInStoreRefundLineItemRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersInStoreRefundLineItemResponse struct {
	// ExecutionStatus: The status of the execution. Acceptable values are:
	// - "duplicate" - "executed"
	ExecutionStatus string `json:"executionStatus,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#ordersInStoreRefundLineItemResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ExecutionStatus") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExecutionStatus") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *OrdersInStoreRefundLineItemResponse) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersInStoreRefundLineItemResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersListResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#ordersListResponse".
	Kind string `json:"kind,omitempty"`

	// NextPageToken: The token for the retrieval of the next page of
	// orders.
	NextPageToken string `json:"nextPageToken,omitempty"`

	Resources []*Order `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrdersListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersListResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersRefundItemRequest struct {
	// Items: The items that are refunded. Either Item or Shipping must be
	// provided in the request.
	Items []*OrdersCustomBatchRequestEntryRefundItemItem `json:"items,omitempty"`

	// OperationId: The ID of the operation. Unique across all operations
	// for a given order.
	OperationId string `json:"operationId,omitempty"`

	// Reason: The reason for the refund. Acceptable values are: -
	// "shippingCostAdjustment" - "priceAdjustment" - "taxAdjustment"
	// - "feeAdjustment" - "courtesyAdjustment" - "adjustment" -
	// "customerCancelled" - "noInventory" - "productNotAsDescribed" -
	// "undeliverableShippingAddress" - "wrongProductShipped" -
	// "lateShipmentCredit" - "deliveredLateByCarrier" -
	// "productArrivedDamaged"
	Reason string `json:"reason,omitempty"`

	// ReasonText: The explanation of the reason.
	ReasonText string `json:"reasonText,omitempty"`

	// Shipping: The refund on shipping. Optional, but either Item or
	// Shipping must be provided in the request.
	Shipping *OrdersCustomBatchRequestEntryRefundItemShipping `json:"shipping,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Items") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrdersRefundItemRequest) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersRefundItemRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersRefundItemResponse struct {
	// ExecutionStatus: The status of the execution. Acceptable values are:
	// - "duplicate" - "executed"
	ExecutionStatus string `json:"executionStatus,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#ordersRefundItemResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ExecutionStatus") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExecutionStatus") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *OrdersRefundItemResponse) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersRefundItemResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersRefundOrderRequest struct {
	// Amount: The amount that is refunded. If this is not the first refund
	// for the order, this should be the newly refunded amount.
	Amount *MonetaryAmount `json:"amount,omitempty"`

	// FullRefund: If true, the full order will be refunded, including
	// shipping. If this is true, amount should not be provided and will be
	// ignored.
	FullRefund bool `json:"fullRefund,omitempty"`

	// OperationId: The ID of the operation. Unique across all operations
	// for a given order.
	OperationId string `json:"operationId,omitempty"`

	// Reason: The reason for the refund. Acceptable values are: -
	// "courtesyAdjustment" - "other"
	Reason string `json:"reason,omitempty"`

	// ReasonText: The explanation of the reason.
	ReasonText string `json:"reasonText,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Amount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Amount") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrdersRefundOrderRequest) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersRefundOrderRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersRefundOrderResponse struct {
	// ExecutionStatus: The status of the execution. Acceptable values are:
	// - "duplicate" - "executed"
	ExecutionStatus string `json:"executionStatus,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#ordersRefundOrderResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ExecutionStatus") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExecutionStatus") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *OrdersRefundOrderResponse) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersRefundOrderResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersRejectReturnLineItemRequest struct {
	// LineItemId: The ID of the line item to return. Either lineItemId or
	// productId is required.
	LineItemId string `json:"lineItemId,omitempty"`

	// OperationId: The ID of the operation. Unique across all operations
	// for a given order.
	OperationId string `json:"operationId,omitempty"`

	// ProductId: The ID of the product to return. This is the REST ID used
	// in the products service. Either lineItemId or productId is required.
	ProductId string `json:"productId,omitempty"`

	// Quantity: The quantity to return and refund.
	Quantity int64 `json:"quantity,omitempty"`

	// Reason: The reason for the return. Acceptable values are: -
	// "damagedOrUsed" - "missingComponent" - "notEligible" -
	// "other" - "outOfReturnWindow"
	Reason string `json:"reason,omitempty"`

	// ReasonText: The explanation of the reason.
	ReasonText string `json:"reasonText,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LineItemId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LineItemId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrdersRejectReturnLineItemRequest) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersRejectReturnLineItemRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersRejectReturnLineItemResponse struct {
	// ExecutionStatus: The status of the execution. Acceptable values are:
	// - "duplicate" - "executed"
	ExecutionStatus string `json:"executionStatus,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#ordersRejectReturnLineItemResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ExecutionStatus") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExecutionStatus") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *OrdersRejectReturnLineItemResponse) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersRejectReturnLineItemResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersReturnRefundLineItemRequest struct {
	// LineItemId: The ID of the line item to return. Either lineItemId or
	// productId is required.
	LineItemId string `json:"lineItemId,omitempty"`

	// OperationId: The ID of the operation. Unique across all operations
	// for a given order.
	OperationId string `json:"operationId,omitempty"`

	// PriceAmount: The amount to be refunded. This may be pre-tax or
	// post-tax depending on the location of the order. If omitted,
	// refundless return is assumed.
	PriceAmount *Price `json:"priceAmount,omitempty"`

	// ProductId: The ID of the product to return. This is the REST ID used
	// in the products service. Either lineItemId or productId is required.
	ProductId string `json:"productId,omitempty"`

	// Quantity: The quantity to return and refund. Quantity is required.
	Quantity int64 `json:"quantity,omitempty"`

	// Reason: The reason for the return. Acceptable values are: -
	// "customerDiscretionaryReturn" - "customerInitiatedMerchantCancel"
	// - "deliveredTooLate" - "expiredItem" - "invalidCoupon" -
	// "malformedShippingAddress" - "other" - "productArrivedDamaged"
	// - "productNotAsDescribed" - "qualityNotAsExpected" -
	// "undeliverableShippingAddress" - "unsupportedPoBoxAddress" -
	// "wrongProductShipped"
	Reason string `json:"reason,omitempty"`

	// ReasonText: The explanation of the reason.
	ReasonText string `json:"reasonText,omitempty"`

	// TaxAmount: The amount of tax to be refunded. Optional, but if filled,
	// then priceAmount must be set. Calculated automatically if not
	// provided.
	TaxAmount *Price `json:"taxAmount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LineItemId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LineItemId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrdersReturnRefundLineItemRequest) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersReturnRefundLineItemRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersReturnRefundLineItemResponse struct {
	// ExecutionStatus: The status of the execution. Acceptable values are:
	// - "duplicate" - "executed"
	ExecutionStatus string `json:"executionStatus,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#ordersReturnRefundLineItemResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ExecutionStatus") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExecutionStatus") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *OrdersReturnRefundLineItemResponse) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersReturnRefundLineItemResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersSetLineItemMetadataRequest struct {
	Annotations []*OrderMerchantProvidedAnnotation `json:"annotations,omitempty"`

	// LineItemId: The ID of the line item to set metadata. Either
	// lineItemId or productId is required.
	LineItemId string `json:"lineItemId,omitempty"`

	// OperationId: The ID of the operation. Unique across all operations
	// for a given order.
	OperationId string `json:"operationId,omitempty"`

	// ProductId: The ID of the product to set metadata. This is the REST ID
	// used in the products service. Either lineItemId or productId is
	// required.
	ProductId string `json:"productId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Annotations") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrdersSetLineItemMetadataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersSetLineItemMetadataRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersSetLineItemMetadataResponse struct {
	// ExecutionStatus: The status of the execution. Acceptable values are:
	// - "duplicate" - "executed"
	ExecutionStatus string `json:"executionStatus,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#ordersSetLineItemMetadataResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ExecutionStatus") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExecutionStatus") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *OrdersSetLineItemMetadataResponse) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersSetLineItemMetadataResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersShipLineItemsRequest struct {
	// LineItems: Line items to ship.
	LineItems []*OrderShipmentLineItemShipment `json:"lineItems,omitempty"`

	// OperationId: The ID of the operation. Unique across all operations
	// for a given order.
	OperationId string `json:"operationId,omitempty"`

	// ShipmentGroupId: ID of the shipment group. Required for orders that
	// use the orderinvoices service.
	ShipmentGroupId string `json:"shipmentGroupId,omitempty"`

	// ShipmentInfos: Shipment information. This field is repeated because a
	// single line item can be shipped in several packages (and have several
	// tracking IDs).
	ShipmentInfos []*OrdersCustomBatchRequestEntryShipLineItemsShipmentInfo `json:"shipmentInfos,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LineItems") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LineItems") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrdersShipLineItemsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersShipLineItemsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersShipLineItemsResponse struct {
	// ExecutionStatus: The status of the execution. Acceptable values are:
	// - "duplicate" - "executed"
	ExecutionStatus string `json:"executionStatus,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#ordersShipLineItemsResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ExecutionStatus") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExecutionStatus") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *OrdersShipLineItemsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersShipLineItemsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersUpdateLineItemShippingDetailsRequest struct {
	// DeliverByDate: Updated delivery by date, in ISO 8601 format. If not
	// specified only ship by date is updated. Provided date should be
	// within 1 year timeframe and can not be a date in the past.
	DeliverByDate string `json:"deliverByDate,omitempty"`

	// LineItemId: The ID of the line item to set metadata. Either
	// lineItemId or productId is required.
	LineItemId string `json:"lineItemId,omitempty"`

	// OperationId: The ID of the operation. Unique across all operations
	// for a given order.
	OperationId string `json:"operationId,omitempty"`

	// ProductId: The ID of the product to set metadata. This is the REST ID
	// used in the products service. Either lineItemId or productId is
	// required.
	ProductId string `json:"productId,omitempty"`

	// ShipByDate: Updated ship by date, in ISO 8601 format. If not
	// specified only deliver by date is updated. Provided date should be
	// within 1 year timeframe and can not be a date in the past.
	ShipByDate string `json:"shipByDate,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeliverByDate") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeliverByDate") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrdersUpdateLineItemShippingDetailsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersUpdateLineItemShippingDetailsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersUpdateLineItemShippingDetailsResponse struct {
	// ExecutionStatus: The status of the execution. Acceptable values are:
	// - "duplicate" - "executed"
	ExecutionStatus string `json:"executionStatus,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#ordersUpdateLineItemShippingDetailsResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ExecutionStatus") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExecutionStatus") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *OrdersUpdateLineItemShippingDetailsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersUpdateLineItemShippingDetailsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersUpdateMerchantOrderIdRequest struct {
	// MerchantOrderId: The merchant order id to be assigned to the order.
	// Must be unique per merchant.
	MerchantOrderId string `json:"merchantOrderId,omitempty"`

	// OperationId: The ID of the operation. Unique across all operations
	// for a given order.
	OperationId string `json:"operationId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MerchantOrderId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MerchantOrderId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *OrdersUpdateMerchantOrderIdRequest) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersUpdateMerchantOrderIdRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersUpdateMerchantOrderIdResponse struct {
	// ExecutionStatus: The status of the execution. Acceptable values are:
	// - "duplicate" - "executed"
	ExecutionStatus string `json:"executionStatus,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#ordersUpdateMerchantOrderIdResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ExecutionStatus") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExecutionStatus") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *OrdersUpdateMerchantOrderIdResponse) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersUpdateMerchantOrderIdResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersUpdateShipmentRequest struct {
	// Carrier: The carrier handling the shipment. Not updated if missing.
	// See `shipments[].carrier` in the Orders resource representation for a
	// list of acceptable values.
	Carrier string `json:"carrier,omitempty"`

	// DeliveryDate: Date on which the shipment has been delivered, in ISO
	// 8601 format. Optional and can be provided only if `status` is
	// `delivered`.
	DeliveryDate string `json:"deliveryDate,omitempty"`

	// LastPickupDate: Date after which the pickup will expire, in ISO 8601
	// format. Required only when order is buy-online-pickup-in-store(BOPIS)
	// and `status` is `ready for pickup`.
	LastPickupDate string `json:"lastPickupDate,omitempty"`

	// OperationId: The ID of the operation. Unique across all operations
	// for a given order.
	OperationId string `json:"operationId,omitempty"`

	// ReadyPickupDate: Date on which the shipment has been ready for
	// pickup, in ISO 8601 format. Optional and can be provided only if
	// `status` is `ready for pickup`.
	ReadyPickupDate string `json:"readyPickupDate,omitempty"`

	// ScheduledDeliveryDetails: Delivery details of the shipment if
	// scheduling is needed.
	ScheduledDeliveryDetails *OrdersCustomBatchRequestEntryUpdateShipmentScheduledDeliveryDetails `json:"scheduledDeliveryDetails,omitempty"`

	// ShipmentId: The ID of the shipment.
	ShipmentId string `json:"shipmentId,omitempty"`

	// Status: New status for the shipment. Not updated if missing.
	// Acceptable values are: - "delivered" - "undeliverable" -
	// "readyForPickup"
	Status string `json:"status,omitempty"`

	// TrackingId: The tracking ID for the shipment. Not updated if missing.
	TrackingId string `json:"trackingId,omitempty"`

	// UndeliveredDate: Date on which the shipment has been undeliverable,
	// in ISO 8601 format. Optional and can be provided only if `status` is
	// `undeliverable`.
	UndeliveredDate string `json:"undeliveredDate,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Carrier") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Carrier") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrdersUpdateShipmentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersUpdateShipmentRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OrdersUpdateShipmentResponse struct {
	// ExecutionStatus: The status of the execution. Acceptable values are:
	// - "duplicate" - "executed"
	ExecutionStatus string `json:"executionStatus,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#ordersUpdateShipmentResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ExecutionStatus") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExecutionStatus") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *OrdersUpdateShipmentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod OrdersUpdateShipmentResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PauseBuyOnGoogleProgramRequest: Request message for the PauseProgram
// method.
type PauseBuyOnGoogleProgramRequest struct {
}

// PaymentServiceProviderLinkInfo: Additional information required for
// PAYMENT_SERVICE_PROVIDER link type.
type PaymentServiceProviderLinkInfo struct {
	// ExternalAccountBusinessCountry: The business country of the merchant
	// account as identified by the third party service provider.
	ExternalAccountBusinessCountry string `json:"externalAccountBusinessCountry,omitempty"`

	// ExternalAccountId: The id used by the third party service provider to
	// identify the merchant.
	ExternalAccountId string `json:"externalAccountId,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ExternalAccountBusinessCountry") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "ExternalAccountBusinessCountry") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PaymentServiceProviderLinkInfo) MarshalJSON() ([]byte, error) {
	type NoMethod PaymentServiceProviderLinkInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type PickupCarrierService struct {
	// CarrierName: The name of the pickup carrier (e.g., "UPS").
	// Required.
	CarrierName string `json:"carrierName,omitempty"`

	// ServiceName: The name of the pickup service (e.g., "Access point").
	// Required.
	ServiceName string `json:"serviceName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CarrierName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CarrierName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PickupCarrierService) MarshalJSON() ([]byte, error) {
	type NoMethod PickupCarrierService
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type PickupServicesPickupService struct {
	// CarrierName: The name of the carrier (e.g., "UPS"). Always present.
	CarrierName string `json:"carrierName,omitempty"`

	// Country: The CLDR country code of the carrier (e.g., "US"). Always
	// present.
	Country string `json:"country,omitempty"`

	// ServiceName: The name of the pickup service (e.g., "Access point").
	// Always present.
	ServiceName string `json:"serviceName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CarrierName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CarrierName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PickupServicesPickupService) MarshalJSON() ([]byte, error) {
	type NoMethod PickupServicesPickupService
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type PosCustomBatchRequest struct {
	// Entries: The request entries to be processed in the batch.
	Entries []*PosCustomBatchRequestEntry `json:"entries,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Entries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PosCustomBatchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod PosCustomBatchRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type PosCustomBatchRequestEntry struct {
	// BatchId: An entry ID, unique within the batch request.
	BatchId int64 `json:"batchId,omitempty"`

	// Inventory: The inventory to submit. This should be set only if the
	// method is `inventory`.
	Inventory *PosInventory `json:"inventory,omitempty"`

	// MerchantId: The ID of the POS data provider.
	MerchantId uint64 `json:"merchantId,omitempty,string"`

	// Method: The method of the batch entry. Acceptable values are: -
	// "delete" - "get" - "insert" - "inventory" - "sale"
	Method string `json:"method,omitempty"`

	// Sale: The sale information to submit. This should be set only if the
	// method is `sale`.
	Sale *PosSale `json:"sale,omitempty"`

	// Store: The store information to submit. This should be set only if
	// the method is `insert`.
	Store *PosStore `json:"store,omitempty"`

	// StoreCode: The store code. This should be set only if the method is
	// `delete` or `get`.
	StoreCode string `json:"storeCode,omitempty"`

	// TargetMerchantId: The ID of the account for which to get/submit data.
	TargetMerchantId uint64 `json:"targetMerchantId,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "BatchId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BatchId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PosCustomBatchRequestEntry) MarshalJSON() ([]byte, error) {
	type NoMethod PosCustomBatchRequestEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type PosCustomBatchResponse struct {
	// Entries: The result of the execution of the batch requests.
	Entries []*PosCustomBatchResponseEntry `json:"entries,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#posCustomBatchResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Entries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PosCustomBatchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod PosCustomBatchResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type PosCustomBatchResponseEntry struct {
	// BatchId: The ID of the request entry to which this entry responds.
	BatchId int64 `json:"batchId,omitempty"`

	// Errors: A list of errors defined if, and only if, the request failed.
	Errors *Errors `json:"errors,omitempty"`

	// Inventory: The updated inventory information.
	Inventory *PosInventory `json:"inventory,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#posCustomBatchResponseEntry"
	Kind string `json:"kind,omitempty"`

	// Sale: The updated sale information.
	Sale *PosSale `json:"sale,omitempty"`

	// Store: The retrieved or updated store information.
	Store *PosStore `json:"store,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BatchId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BatchId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PosCustomBatchResponseEntry) MarshalJSON() ([]byte, error) {
	type NoMethod PosCustomBatchResponseEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type PosDataProviders struct {
	// Country: Country code.
	Country string `json:"country,omitempty"`

	// PosDataProviders: A list of POS data providers.
	PosDataProviders []*PosDataProvidersPosDataProvider `json:"posDataProviders,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Country") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Country") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PosDataProviders) MarshalJSON() ([]byte, error) {
	type NoMethod PosDataProviders
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type PosDataProvidersPosDataProvider struct {
	// DisplayName: The display name of Pos data Provider.
	DisplayName string `json:"displayName,omitempty"`

	// FullName: The full name of this POS data Provider.
	FullName string `json:"fullName,omitempty"`

	// ProviderId: The ID of the account.
	ProviderId uint64 `json:"providerId,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PosDataProvidersPosDataProvider) MarshalJSON() ([]byte, error) {
	type NoMethod PosDataProvidersPosDataProvider
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PosInventory: The absolute quantity of an item available at the given
// store.
type PosInventory struct {
	// ContentLanguage: Required. The two-letter ISO 639-1 language code for
	// the item.
	ContentLanguage string `json:"contentLanguage,omitempty"`

	// Gtin: Global Trade Item Number.
	Gtin string `json:"gtin,omitempty"`

	// ItemId: Required. A unique identifier for the item.
	ItemId string `json:"itemId,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#posInventory"
	Kind string `json:"kind,omitempty"`

	// Price: Required. The current price of the item.
	Price *Price `json:"price,omitempty"`

	// Quantity: Required. The available quantity of the item.
	Quantity int64 `json:"quantity,omitempty,string"`

	// StoreCode: Required. The identifier of the merchant's store. Either a
	// `storeCode` inserted via the API or the code of the store in a
	// Business Profile.
	StoreCode string `json:"storeCode,omitempty"`

	// TargetCountry: Required. The CLDR territory code for the item.
	TargetCountry string `json:"targetCountry,omitempty"`

	// Timestamp: Required. The inventory timestamp, in ISO 8601 format.
	Timestamp string `json:"timestamp,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ContentLanguage") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContentLanguage") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *PosInventory) MarshalJSON() ([]byte, error) {
	type NoMethod PosInventory
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type PosInventoryRequest struct {
	// ContentLanguage: Required. The two-letter ISO 639-1 language code for
	// the item.
	ContentLanguage string `json:"contentLanguage,omitempty"`

	// Gtin: Global Trade Item Number.
	Gtin string `json:"gtin,omitempty"`

	// ItemId: Required. A unique identifier for the item.
	ItemId string `json:"itemId,omitempty"`

	// Price: Required. The current price of the item.
	Price *Price `json:"price,omitempty"`

	// Quantity: Required. The available quantity of the item.
	Quantity int64 `json:"quantity,omitempty,string"`

	// StoreCode: Required. The identifier of the merchant's store. Either a
	// `storeCode` inserted via the API or the code of the store in a
	// Business Profile.
	StoreCode string `json:"storeCode,omitempty"`

	// TargetCountry: Required. The CLDR territory code for the item.
	TargetCountry string `json:"targetCountry,omitempty"`

	// Timestamp: Required. The inventory timestamp, in ISO 8601 format.
	Timestamp string `json:"timestamp,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ContentLanguage") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContentLanguage") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *PosInventoryRequest) MarshalJSON() ([]byte, error) {
	type NoMethod PosInventoryRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type PosInventoryResponse struct {
	// ContentLanguage: Required. The two-letter ISO 639-1 language code for
	// the item.
	ContentLanguage string `json:"contentLanguage,omitempty"`

	// Gtin: Global Trade Item Number.
	Gtin string `json:"gtin,omitempty"`

	// ItemId: Required. A unique identifier for the item.
	ItemId string `json:"itemId,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#posInventoryResponse".
	Kind string `json:"kind,omitempty"`

	// Price: Required. The current price of the item.
	Price *Price `json:"price,omitempty"`

	// Quantity: Required. The available quantity of the item.
	Quantity int64 `json:"quantity,omitempty,string"`

	// StoreCode: Required. The identifier of the merchant's store. Either a
	// `storeCode` inserted via the API or the code of the store in a
	// Business Profile.
	StoreCode string `json:"storeCode,omitempty"`

	// TargetCountry: Required. The CLDR territory code for the item.
	TargetCountry string `json:"targetCountry,omitempty"`

	// Timestamp: Required. The inventory timestamp, in ISO 8601 format.
	Timestamp string `json:"timestamp,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ContentLanguage") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContentLanguage") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *PosInventoryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod PosInventoryResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type PosListResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#posListResponse".
	Kind string `json:"kind,omitempty"`

	Resources []*PosStore `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PosListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod PosListResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PosSale: The change of the available quantity of an item at the given
// store.
type PosSale struct {
	// ContentLanguage: Required. The two-letter ISO 639-1 language code for
	// the item.
	ContentLanguage string `json:"contentLanguage,omitempty"`

	// Gtin: Global Trade Item Number.
	Gtin string `json:"gtin,omitempty"`

	// ItemId: Required. A unique identifier for the item.
	ItemId string `json:"itemId,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#posSale"
	Kind string `json:"kind,omitempty"`

	// Price: Required. The price of the item.
	Price *Price `json:"price,omitempty"`

	// Quantity: Required. The relative change of the available quantity.
	// Negative for items returned.
	Quantity int64 `json:"quantity,omitempty,string"`

	// SaleId: A unique ID to group items from the same sale event.
	SaleId string `json:"saleId,omitempty"`

	// StoreCode: Required. The identifier of the merchant's store. Either a
	// `storeCode` inserted via the API or the code of the store in a
	// Business Profile.
	StoreCode string `json:"storeCode,omitempty"`

	// TargetCountry: Required. The CLDR territory code for the item.
	TargetCountry string `json:"targetCountry,omitempty"`

	// Timestamp: Required. The inventory timestamp, in ISO 8601 format.
	Timestamp string `json:"timestamp,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ContentLanguage") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContentLanguage") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *PosSale) MarshalJSON() ([]byte, error) {
	type NoMethod PosSale
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type PosSaleRequest struct {
	// ContentLanguage: Required. The two-letter ISO 639-1 language code for
	// the item.
	ContentLanguage string `json:"contentLanguage,omitempty"`

	// Gtin: Global Trade Item Number.
	Gtin string `json:"gtin,omitempty"`

	// ItemId: Required. A unique identifier for the item.
	ItemId string `json:"itemId,omitempty"`

	// Price: Required. The price of the item.
	Price *Price `json:"price,omitempty"`

	// Quantity: Required. The relative change of the available quantity.
	// Negative for items returned.
	Quantity int64 `json:"quantity,omitempty,string"`

	// SaleId: A unique ID to group items from the same sale event.
	SaleId string `json:"saleId,omitempty"`

	// StoreCode: Required. The identifier of the merchant's store. Either a
	// `storeCode` inserted via the API or the code of the store in a
	// Business Profile.
	StoreCode string `json:"storeCode,omitempty"`

	// TargetCountry: Required. The CLDR territory code for the item.
	TargetCountry string `json:"targetCountry,omitempty"`

	// Timestamp: Required. The inventory timestamp, in ISO 8601 format.
	Timestamp string `json:"timestamp,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ContentLanguage") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContentLanguage") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *PosSaleRequest) MarshalJSON() ([]byte, error) {
	type NoMethod PosSaleRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type PosSaleResponse struct {
	// ContentLanguage: Required. The two-letter ISO 639-1 language code for
	// the item.
	ContentLanguage string `json:"contentLanguage,omitempty"`

	// Gtin: Global Trade Item Number.
	Gtin string `json:"gtin,omitempty"`

	// ItemId: Required. A unique identifier for the item.
	ItemId string `json:"itemId,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#posSaleResponse".
	Kind string `json:"kind,omitempty"`

	// Price: Required. The price of the item.
	Price *Price `json:"price,omitempty"`

	// Quantity: Required. The relative change of the available quantity.
	// Negative for items returned.
	Quantity int64 `json:"quantity,omitempty,string"`

	// SaleId: A unique ID to group items from the same sale event.
	SaleId string `json:"saleId,omitempty"`

	// StoreCode: Required. The identifier of the merchant's store. Either a
	// `storeCode` inserted via the API or the code of the store in a
	// Business Profile.
	StoreCode string `json:"storeCode,omitempty"`

	// TargetCountry: Required. The CLDR territory code for the item.
	TargetCountry string `json:"targetCountry,omitempty"`

	// Timestamp: Required. The inventory timestamp, in ISO 8601 format.
	Timestamp string `json:"timestamp,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ContentLanguage") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContentLanguage") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *PosSaleResponse) MarshalJSON() ([]byte, error) {
	type NoMethod PosSaleResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PosStore: Store resource.
type PosStore struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#posStore"
	Kind string `json:"kind,omitempty"`

	// StoreAddress: Required. The street address of the store.
	StoreAddress string `json:"storeAddress,omitempty"`

	// StoreCode: Required. A store identifier that is unique for the given
	// merchant.
	StoreCode string `json:"storeCode,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PosStore) MarshalJSON() ([]byte, error) {
	type NoMethod PosStore
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type PostalCodeGroup struct {
	// Country: The CLDR territory code of the country the postal code group
	// applies to. Required.
	Country string `json:"country,omitempty"`

	// Name: The name of the postal code group, referred to in headers.
	// Required.
	Name string `json:"name,omitempty"`

	// PostalCodeRanges: A range of postal codes. Required.
	PostalCodeRanges []*PostalCodeRange `json:"postalCodeRanges,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Country") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Country") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PostalCodeGroup) MarshalJSON() ([]byte, error) {
	type NoMethod PostalCodeGroup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type PostalCodeRange struct {
	// PostalCodeRangeBegin: A postal code or a pattern of the form
	// `prefix*` denoting the inclusive lower bound of the range defining
	// the area. Examples values: "94108", "9410*", "9*". Required.
	PostalCodeRangeBegin string `json:"postalCodeRangeBegin,omitempty"`

	// PostalCodeRangeEnd: A postal code or a pattern of the form `prefix*`
	// denoting the inclusive upper bound of the range defining the area. It
	// must have the same length as `postalCodeRangeBegin`: if
	// `postalCodeRangeBegin` is a postal code then `postalCodeRangeEnd`
	// must be a postal code too; if `postalCodeRangeBegin` is a pattern
	// then `postalCodeRangeEnd` must be a pattern with the same prefix
	// length. Optional: if not set, then the area is defined as being all
	// the postal codes matching `postalCodeRangeBegin`.
	PostalCodeRangeEnd string `json:"postalCodeRangeEnd,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "PostalCodeRangeBegin") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PostalCodeRangeBegin") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *PostalCodeRange) MarshalJSON() ([]byte, error) {
	type NoMethod PostalCodeRange
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type Price struct {
	// Currency: The currency of the price.
	Currency string `json:"currency,omitempty"`

	// Value: The price represented as a number.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Currency") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Currency") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Price) MarshalJSON() ([]byte, error) {
	type NoMethod Price
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PriceAmount: The price represented as a number and currency.
type PriceAmount struct {
	// Currency: The currency of the price.
	Currency string `json:"currency,omitempty"`

	// Value: The price represented as a number.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Currency") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Currency") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PriceAmount) MarshalJSON() ([]byte, error) {
	type NoMethod PriceAmount
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Product:  Required product attributes are primarily defined by the
// products data specification. See the Products Data Specification Help
// Center article for information. Product data. After inserting,
// updating, or deleting a product, it may take several minutes before
// changes take effect.
type Product struct {
	// AdditionalImageLinks: Additional URLs of images of the item.
	AdditionalImageLinks []string `json:"additionalImageLinks,omitempty"`

	// AdditionalSizeType: Additional cut of the item. Used together with
	// size_type to represent combined size types for apparel items.
	AdditionalSizeType string `json:"additionalSizeType,omitempty"`

	// AdsGrouping: Used to group items in an arbitrary way. Only for CPA%,
	// discouraged otherwise.
	AdsGrouping string `json:"adsGrouping,omitempty"`

	// AdsLabels: Similar to ads_grouping, but only works on CPC.
	AdsLabels []string `json:"adsLabels,omitempty"`

	// AdsRedirect: Allows advertisers to override the item URL when the
	// product is shown within the context of Product Ads.
	AdsRedirect string `json:"adsRedirect,omitempty"`

	// Adult: Should be set to true if the item is targeted towards adults.
	Adult bool `json:"adult,omitempty"`

	// AgeGroup: Target age group of the item.
	AgeGroup string `json:"ageGroup,omitempty"`

	// Availability: Availability status of the item.
	Availability string `json:"availability,omitempty"`

	// AvailabilityDate: The day a pre-ordered product becomes available for
	// delivery, in ISO 8601 format.
	AvailabilityDate string `json:"availabilityDate,omitempty"`

	// Brand: Brand of the item.
	Brand string `json:"brand,omitempty"`

	// CanonicalLink: URL for the canonical version of your item's landing
	// page.
	CanonicalLink string `json:"canonicalLink,omitempty"`

	// Channel: Required. The item's channel (online or local). Acceptable
	// values are: - "local" - "online"
	Channel string `json:"channel,omitempty"`

	// Color: Color of the item.
	Color string `json:"color,omitempty"`

	// Condition: Condition or state of the item.
	Condition string `json:"condition,omitempty"`

	// ContentLanguage: Required. The two-letter ISO 639-1 language code for
	// the item.
	ContentLanguage string `json:"contentLanguage,omitempty"`

	// CostOfGoodsSold: Cost of goods sold. Used for gross profit reporting.
	CostOfGoodsSold *Price `json:"costOfGoodsSold,omitempty"`

	// CustomAttributes: A list of custom (merchant-provided) attributes. It
	// can also be used for submitting any attribute of the feed
	// specification in its generic form (e.g., `{ "name": "size type",
	// "value": "regular" }`). This is useful for submitting attributes not
	// explicitly exposed by the API, such as additional attributes used for
	// Buy on Google (formerly known as Shopping Actions).
	CustomAttributes []*CustomAttribute `json:"customAttributes,omitempty"`

	// CustomLabel0: Custom label 0 for custom grouping of items in a
	// Shopping campaign.
	CustomLabel0 string `json:"customLabel0,omitempty"`

	// CustomLabel1: Custom label 1 for custom grouping of items in a
	// Shopping campaign.
	CustomLabel1 string `json:"customLabel1,omitempty"`

	// CustomLabel2: Custom label 2 for custom grouping of items in a
	// Shopping campaign.
	CustomLabel2 string `json:"customLabel2,omitempty"`

	// CustomLabel3: Custom label 3 for custom grouping of items in a
	// Shopping campaign.
	CustomLabel3 string `json:"customLabel3,omitempty"`

	// CustomLabel4: Custom label 4 for custom grouping of items in a
	// Shopping campaign.
	CustomLabel4 string `json:"customLabel4,omitempty"`

	// Description: Description of the item.
	Description string `json:"description,omitempty"`

	// DisplayAdsId: An identifier for an item for dynamic remarketing
	// campaigns.
	DisplayAdsId string `json:"displayAdsId,omitempty"`

	// DisplayAdsLink: URL directly to your item's landing page for dynamic
	// remarketing campaigns.
	DisplayAdsLink string `json:"displayAdsLink,omitempty"`

	// DisplayAdsSimilarIds: Advertiser-specified recommendations.
	DisplayAdsSimilarIds []string `json:"displayAdsSimilarIds,omitempty"`

	// DisplayAdsTitle: Title of an item for dynamic remarketing campaigns.
	DisplayAdsTitle string `json:"displayAdsTitle,omitempty"`

	// DisplayAdsValue: Offer margin for dynamic remarketing campaigns.
	DisplayAdsValue float64 `json:"displayAdsValue,omitempty"`

	// EnergyEfficiencyClass: The energy efficiency class as defined in EU
	// directive 2010/30/EU.
	EnergyEfficiencyClass string `json:"energyEfficiencyClass,omitempty"`

	// ExcludedDestinations: The list of destinations to exclude for this
	// target (corresponds to unchecked check boxes in Merchant Center).
	ExcludedDestinations []string `json:"excludedDestinations,omitempty"`

	// ExpirationDate: Date on which the item should expire, as specified
	// upon insertion, in ISO 8601 format. The actual expiration date in
	// Google Shopping is exposed in `productstatuses` as
	// `googleExpirationDate` and might be earlier if `expirationDate` is
	// too far in the future.
	ExpirationDate string `json:"expirationDate,omitempty"`

	// Gender: Target gender of the item.
	Gender string `json:"gender,omitempty"`

	// GoogleProductCategory: Google's category of the item (see Google
	// product taxonomy
	// (https://support.google.com/merchants/answer/1705911)). When querying
	// products, this field will contain the user provided value. There is
	// currently no way to get back the auto assigned google product
	// categories through the API.
	GoogleProductCategory string `json:"googleProductCategory,omitempty"`

	// Gtin: Global Trade Item Number (GTIN) of the item.
	Gtin string `json:"gtin,omitempty"`

	// Id: The REST ID of the product. Content API methods that operate on
	// products take this as their `productId` parameter. The REST ID for a
	// product is of the form channel:contentLanguage: targetCountry:
	// offerId.
	Id string `json:"id,omitempty"`

	// IdentifierExists: False when the item does not have unique product
	// identifiers appropriate to its category, such as GTIN, MPN, and
	// brand. Required according to the Unique Product Identifier Rules for
	// all target countries except for Canada.
	IdentifierExists bool `json:"identifierExists,omitempty"`

	// ImageLink: URL of an image of the item.
	ImageLink string `json:"imageLink,omitempty"`

	// IncludedDestinations: The list of destinations to include for this
	// target (corresponds to checked check boxes in Merchant Center).
	// Default destinations are always included unless provided in
	// `excludedDestinations`.
	IncludedDestinations []string `json:"includedDestinations,omitempty"`

	// Installment: Number and amount of installments to pay for an item.
	Installment *Installment `json:"installment,omitempty"`

	// IsBundle: Whether the item is a merchant-defined bundle. A bundle is
	// a custom grouping of different products sold by a merchant for a
	// single price.
	IsBundle bool `json:"isBundle,omitempty"`

	// ItemGroupId: Shared identifier for all variants of the same product.
	ItemGroupId string `json:"itemGroupId,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#product"
	Kind string `json:"kind,omitempty"`

	// Link: URL directly linking to your item's page on your website.
	Link string `json:"link,omitempty"`

	// LinkTemplate: URL template for merchant hosted local storefront.
	LinkTemplate string `json:"linkTemplate,omitempty"`

	// LoyaltyPoints: Loyalty points that users receive after purchasing the
	// item. Japan only.
	LoyaltyPoints *LoyaltyPoints `json:"loyaltyPoints,omitempty"`

	// Material: The material of which the item is made.
	Material string `json:"material,omitempty"`

	// MaxEnergyEfficiencyClass: The energy efficiency class as defined in
	// EU directive 2010/30/EU.
	MaxEnergyEfficiencyClass string `json:"maxEnergyEfficiencyClass,omitempty"`

	// MaxHandlingTime: Maximal product handling time (in business days).
	MaxHandlingTime int64 `json:"maxHandlingTime,omitempty,string"`

	// MinEnergyEfficiencyClass: The energy efficiency class as defined in
	// EU directive 2010/30/EU.
	MinEnergyEfficiencyClass string `json:"minEnergyEfficiencyClass,omitempty"`

	// MinHandlingTime: Minimal product handling time (in business days).
	MinHandlingTime int64 `json:"minHandlingTime,omitempty,string"`

	// MobileLink: URL for the mobile-optimized version of your item's
	// landing page.
	MobileLink string `json:"mobileLink,omitempty"`

	// MobileLinkTemplate: URL template for merchant hosted local storefront
	// optimized for mobile devices.
	MobileLinkTemplate string `json:"mobileLinkTemplate,omitempty"`

	// Mpn: Manufacturer Part Number (MPN) of the item.
	Mpn string `json:"mpn,omitempty"`

	// Multipack: The number of identical products in a merchant-defined
	// multipack.
	Multipack int64 `json:"multipack,omitempty,string"`

	// OfferId: Required. A unique identifier for the item. Leading and
	// trailing whitespaces are stripped and multiple whitespaces are
	// replaced by a single whitespace upon submission. Only valid unicode
	// characters are accepted. See the products feed specification for
	// details. *Note:* Content API methods that operate on products take
	// the REST ID of the product, *not* this identifier.
	OfferId string `json:"offerId,omitempty"`

	// Pattern: The item's pattern (e.g. polka dots).
	Pattern string `json:"pattern,omitempty"`

	// PickupMethod: The pick up option for the item. Acceptable values are:
	// - "buy" - "reserve" - "ship to store" - "not supported"
	PickupMethod string `json:"pickupMethod,omitempty"`

	// PickupSla: Item store pickup timeline. Acceptable values are: -
	// "same day" - "next day" - "2-day" - "3-day" - "4-day" -
	// "5-day" - "6-day" - "7-day" - "multi-week"
	PickupSla string `json:"pickupSla,omitempty"`

	// Price: Price of the item.
	Price *Price `json:"price,omitempty"`

	// ProductDetails: Technical specification or additional product
	// details.
	ProductDetails []*ProductProductDetail `json:"productDetails,omitempty"`

	// ProductHeight: The height of the product in the units provided. The
	// value must be between 0 (exclusive) and 3000 (inclusive).
	ProductHeight *ProductDimension `json:"productHeight,omitempty"`

	// ProductHighlights: Bullet points describing the most relevant
	// highlights of a product.
	ProductHighlights []string `json:"productHighlights,omitempty"`

	// ProductLength: The length of the product in the units provided. The
	// value must be between 0 (exclusive) and 3000 (inclusive).
	ProductLength *ProductDimension `json:"productLength,omitempty"`

	// ProductTypes: Categories of the item (formatted as in products data
	// specification).
	ProductTypes []string `json:"productTypes,omitempty"`

	// ProductWeight: The weight of the product in the units provided. The
	// value must be between 0 (exclusive) and 2000 (inclusive).
	ProductWeight *ProductWeight `json:"productWeight,omitempty"`

	// ProductWidth: The width of the product in the units provided. The
	// value must be between 0 (exclusive) and 3000 (inclusive).
	ProductWidth *ProductDimension `json:"productWidth,omitempty"`

	// PromotionIds: The unique ID of a promotion.
	PromotionIds []string `json:"promotionIds,omitempty"`

	// SalePrice: Advertised sale price of the item.
	SalePrice *Price `json:"salePrice,omitempty"`

	// SalePriceEffectiveDate: Date range during which the item is on sale
	// (see products data specification ).
	SalePriceEffectiveDate string `json:"salePriceEffectiveDate,omitempty"`

	// SellOnGoogleQuantity: The quantity of the product that is available
	// for selling on Google. Supported only for online products.
	SellOnGoogleQuantity int64 `json:"sellOnGoogleQuantity,omitempty,string"`

	// Shipping: Shipping rules.
	Shipping []*ProductShipping `json:"shipping,omitempty"`

	// ShippingHeight: Height of the item for shipping.
	ShippingHeight *ProductShippingDimension `json:"shippingHeight,omitempty"`

	// ShippingLabel: The shipping label of the product, used to group
	// product in account-level shipping rules.
	ShippingLabel string `json:"shippingLabel,omitempty"`

	// ShippingLength: Length of the item for shipping.
	ShippingLength *ProductShippingDimension `json:"shippingLength,omitempty"`

	// ShippingWeight: Weight of the item for shipping.
	ShippingWeight *ProductShippingWeight `json:"shippingWeight,omitempty"`

	// ShippingWidth: Width of the item for shipping.
	ShippingWidth *ProductShippingDimension `json:"shippingWidth,omitempty"`

	// ShoppingAdsExcludedCountries: List of country codes (ISO 3166-1
	// alpha-2) to exclude the offer from Shopping Ads destination.
	// Countries from this list are removed from countries configured in MC
	// feed settings.
	ShoppingAdsExcludedCountries []string `json:"shoppingAdsExcludedCountries,omitempty"`

	// SizeSystem: System in which the size is specified. Recommended for
	// apparel items.
	SizeSystem string `json:"sizeSystem,omitempty"`

	// SizeType: The cut of the item. Recommended for apparel items.
	SizeType string `json:"sizeType,omitempty"`

	// Sizes: Size of the item. Only one value is allowed. For variants with
	// different sizes, insert a separate product for each size with the
	// same `itemGroupId` value (see size definition).
	Sizes []string `json:"sizes,omitempty"`

	// Source: The source of the offer, i.e., how the offer was created.
	// Acceptable values are: - "api" - "crawl" - "feed"
	Source string `json:"source,omitempty"`

	// SubscriptionCost: Number of periods (months or years) and amount of
	// payment per period for an item with an associated subscription
	// contract.
	SubscriptionCost *ProductSubscriptionCost `json:"subscriptionCost,omitempty"`

	// TargetCountry: Required. The CLDR territory code for the item.
	TargetCountry string `json:"targetCountry,omitempty"`

	// TaxCategory: The tax category of the product, used to configure
	// detailed tax nexus in account-level tax settings.
	TaxCategory string `json:"taxCategory,omitempty"`

	// Taxes: Tax information.
	Taxes []*ProductTax `json:"taxes,omitempty"`

	// Title: Title of the item.
	Title string `json:"title,omitempty"`

	// TransitTimeLabel: The transit time label of the product, used to
	// group product in account-level transit time tables.
	TransitTimeLabel string `json:"transitTimeLabel,omitempty"`

	// UnitPricingBaseMeasure: The preference of the denominator of the unit
	// price.
	UnitPricingBaseMeasure *ProductUnitPricingBaseMeasure `json:"unitPricingBaseMeasure,omitempty"`

	// UnitPricingMeasure: The measure and dimension of an item.
	UnitPricingMeasure *ProductUnitPricingMeasure `json:"unitPricingMeasure,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "AdditionalImageLinks") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdditionalImageLinks") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Product) MarshalJSON() ([]byte, error) {
	type NoMethod Product
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *Product) UnmarshalJSON(data []byte) error {
	type NoMethod Product
	var s1 struct {
		DisplayAdsValue gensupport.JSONFloat64 `json:"displayAdsValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.DisplayAdsValue = float64(s1.DisplayAdsValue)
	return nil
}

type ProductAmount struct {
	// PriceAmount: The pre-tax or post-tax price depending on the location
	// of the order.
	PriceAmount *Price `json:"priceAmount,omitempty"`

	// RemittedTaxAmount: Remitted tax value.
	RemittedTaxAmount *Price `json:"remittedTaxAmount,omitempty"`

	// TaxAmount: Tax value.
	TaxAmount *Price `json:"taxAmount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PriceAmount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PriceAmount") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ProductAmount) MarshalJSON() ([]byte, error) {
	type NoMethod ProductAmount
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ProductDimension struct {
	// Unit: Required. The length units. Acceptable values are: - "in" -
	// "cm"
	Unit string `json:"unit,omitempty"`

	// Value: Required. The length value represented as a number. The value
	// can have a maximum precision of four decimal places.
	Value float64 `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Unit") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Unit") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ProductDimension) MarshalJSON() ([]byte, error) {
	type NoMethod ProductDimension
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *ProductDimension) UnmarshalJSON(data []byte) error {
	type NoMethod ProductDimension
	var s1 struct {
		Value gensupport.JSONFloat64 `json:"value"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Value = float64(s1.Value)
	return nil
}

type ProductProductDetail struct {
	// AttributeName: The name of the product detail.
	AttributeName string `json:"attributeName,omitempty"`

	// AttributeValue: The value of the product detail.
	AttributeValue string `json:"attributeValue,omitempty"`

	// SectionName: The section header used to group a set of product
	// details.
	SectionName string `json:"sectionName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AttributeName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AttributeName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ProductProductDetail) MarshalJSON() ([]byte, error) {
	type NoMethod ProductProductDetail
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ProductShipping struct {
	// Country: The CLDR territory code of the country to which an item will
	// ship.
	Country string `json:"country,omitempty"`

	// LocationGroupName: The location where the shipping is applicable,
	// represented by a location group name.
	LocationGroupName string `json:"locationGroupName,omitempty"`

	// LocationId: The numeric ID of a location that the shipping rate
	// applies to as defined in the AdWords API.
	LocationId int64 `json:"locationId,omitempty,string"`

	// MaxHandlingTime: Maximum handling time (inclusive) between when the
	// order is received and shipped in business days. 0 means that the
	// order is shipped on the same day as it is received if it happens
	// before the cut-off time. Both maxHandlingTime and maxTransitTime are
	// required if providing shipping speeds.
	MaxHandlingTime int64 `json:"maxHandlingTime,omitempty,string"`

	// MaxTransitTime: Maximum transit time (inclusive) between when the
	// order has shipped and when it is delivered in business days. 0 means
	// that the order is delivered on the same day as it ships. Both
	// maxHandlingTime and maxTransitTime are required if providing shipping
	// speeds.
	MaxTransitTime int64 `json:"maxTransitTime,omitempty,string"`

	// MinHandlingTime: Minimum handling time (inclusive) between when the
	// order is received and shipped in business days. 0 means that the
	// order is shipped on the same day as it is received if it happens
	// before the cut-off time. minHandlingTime can only be present together
	// with maxHandlingTime; but it is not required if maxHandlingTime is
	// present.
	MinHandlingTime int64 `json:"minHandlingTime,omitempty,string"`

	// MinTransitTime: Minimum transit time (inclusive) between when the
	// order has shipped and when it is delivered in business days. 0 means
	// that the order is delivered on the same day as it ships.
	// minTransitTime can only be present together with maxTransitTime; but
	// it is not required if maxTransitTime is present.
	MinTransitTime int64 `json:"minTransitTime,omitempty,string"`

	// PostalCode: The postal code range that the shipping rate applies to,
	// represented by a postal code, a postal code prefix followed by a *
	// wildcard, a range between two postal codes or two postal code
	// prefixes of equal length.
	PostalCode string `json:"postalCode,omitempty"`

	// Price: Fixed shipping price, represented as a number.
	Price *Price `json:"price,omitempty"`

	// Region: The geographic region to which a shipping rate applies.
	Region string `json:"region,omitempty"`

	// Service: A free-form description of the service class or delivery
	// speed.
	Service string `json:"service,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Country") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Country") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ProductShipping) MarshalJSON() ([]byte, error) {
	type NoMethod ProductShipping
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ProductShippingDimension struct {
	// Unit: The unit of value.
	Unit string `json:"unit,omitempty"`

	// Value: The dimension of the product used to calculate the shipping
	// cost of the item.
	Value float64 `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Unit") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Unit") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ProductShippingDimension) MarshalJSON() ([]byte, error) {
	type NoMethod ProductShippingDimension
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *ProductShippingDimension) UnmarshalJSON(data []byte) error {
	type NoMethod ProductShippingDimension
	var s1 struct {
		Value gensupport.JSONFloat64 `json:"value"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Value = float64(s1.Value)
	return nil
}

type ProductShippingWeight struct {
	// Unit: The unit of value.
	Unit string `json:"unit,omitempty"`

	// Value: The weight of the product used to calculate the shipping cost
	// of the item.
	Value float64 `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Unit") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Unit") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ProductShippingWeight) MarshalJSON() ([]byte, error) {
	type NoMethod ProductShippingWeight
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *ProductShippingWeight) UnmarshalJSON(data []byte) error {
	type NoMethod ProductShippingWeight
	var s1 struct {
		Value gensupport.JSONFloat64 `json:"value"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Value = float64(s1.Value)
	return nil
}

// ProductStatus: The status of a product, i.e., information about a
// product computed asynchronously.
type ProductStatus struct {
	// CreationDate: Date on which the item has been created, in ISO 8601
	// format.
	CreationDate string `json:"creationDate,omitempty"`

	// DestinationStatuses: The intended destinations for the product.
	DestinationStatuses []*ProductStatusDestinationStatus `json:"destinationStatuses,omitempty"`

	// GoogleExpirationDate: Date on which the item expires in Google
	// Shopping, in ISO 8601 format.
	GoogleExpirationDate string `json:"googleExpirationDate,omitempty"`

	// ItemLevelIssues: A list of all issues associated with the product.
	ItemLevelIssues []*ProductStatusItemLevelIssue `json:"itemLevelIssues,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#productStatus"
	Kind string `json:"kind,omitempty"`

	// LastUpdateDate: Date on which the item has been last updated, in ISO
	// 8601 format.
	LastUpdateDate string `json:"lastUpdateDate,omitempty"`

	// Link: The link to the product.
	Link string `json:"link,omitempty"`

	// ProductId: The ID of the product for which status is reported.
	ProductId string `json:"productId,omitempty"`

	// Title: The title of the product.
	Title string `json:"title,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreationDate") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreationDate") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ProductStatus) MarshalJSON() ([]byte, error) {
	type NoMethod ProductStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ProductStatusDestinationStatus struct {
	// ApprovedCountries: List of country codes (ISO 3166-1 alpha-2) where
	// the offer is approved.
	ApprovedCountries []string `json:"approvedCountries,omitempty"`

	// Destination: The name of the destination
	Destination string `json:"destination,omitempty"`

	// DisapprovedCountries: List of country codes (ISO 3166-1 alpha-2)
	// where the offer is disapproved.
	DisapprovedCountries []string `json:"disapprovedCountries,omitempty"`

	// PendingCountries: List of country codes (ISO 3166-1 alpha-2) where
	// the offer is pending approval.
	PendingCountries []string `json:"pendingCountries,omitempty"`

	// Status: Destination approval status in `targetCountry` of the offer.
	Status string `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ApprovedCountries")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApprovedCountries") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ProductStatusDestinationStatus) MarshalJSON() ([]byte, error) {
	type NoMethod ProductStatusDestinationStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ProductStatusItemLevelIssue struct {
	// ApplicableCountries: List of country codes (ISO 3166-1 alpha-2) where
	// issue applies to the offer.
	ApplicableCountries []string `json:"applicableCountries,omitempty"`

	// AttributeName: The attribute's name, if the issue is caused by a
	// single attribute.
	AttributeName string `json:"attributeName,omitempty"`

	// Code: The error code of the issue.
	Code string `json:"code,omitempty"`

	// Description: A short issue description in English.
	Description string `json:"description,omitempty"`

	// Destination: The destination the issue applies to.
	Destination string `json:"destination,omitempty"`

	// Detail: A detailed issue description in English.
	Detail string `json:"detail,omitempty"`

	// Documentation: The URL of a web page to help with resolving this
	// issue.
	Documentation string `json:"documentation,omitempty"`

	// Resolution: Whether the issue can be resolved by the merchant.
	Resolution string `json:"resolution,omitempty"`

	// Servability: How this issue affects serving of the offer.
	Servability string `json:"servability,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ApplicableCountries")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApplicableCountries") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ProductStatusItemLevelIssue) MarshalJSON() ([]byte, error) {
	type NoMethod ProductStatusItemLevelIssue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ProductSubscriptionCost struct {
	// Amount: The amount the buyer has to pay per subscription period.
	Amount *Price `json:"amount,omitempty"`

	// Period: The type of subscription period.
	Period string `json:"period,omitempty"`

	// PeriodLength: The number of subscription periods the buyer has to
	// pay.
	PeriodLength int64 `json:"periodLength,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Amount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Amount") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ProductSubscriptionCost) MarshalJSON() ([]byte, error) {
	type NoMethod ProductSubscriptionCost
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ProductTax struct {
	// Country: The country within which the item is taxed, specified as a
	// CLDR territory code.
	Country string `json:"country,omitempty"`

	// LocationId: The numeric ID of a location that the tax rate applies to
	// as defined in the AdWords API.
	LocationId int64 `json:"locationId,omitempty,string"`

	// PostalCode: The postal code range that the tax rate applies to,
	// represented by a ZIP code, a ZIP code prefix using * wildcard, a
	// range between two ZIP codes or two ZIP code prefixes of equal length.
	// Examples: 94114, 94*, 94002-95460, 94*-95*.
	PostalCode string `json:"postalCode,omitempty"`

	// Rate: The percentage of tax rate that applies to the item price.
	Rate float64 `json:"rate,omitempty"`

	// Region: The geographic region to which the tax rate applies.
	Region string `json:"region,omitempty"`

	// TaxShip: Should be set to true if tax is charged on shipping.
	TaxShip bool `json:"taxShip,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Country") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Country") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ProductTax) MarshalJSON() ([]byte, error) {
	type NoMethod ProductTax
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *ProductTax) UnmarshalJSON(data []byte) error {
	type NoMethod ProductTax
	var s1 struct {
		Rate gensupport.JSONFloat64 `json:"rate"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Rate = float64(s1.Rate)
	return nil
}

type ProductUnitPricingBaseMeasure struct {
	// Unit: The unit of the denominator.
	Unit string `json:"unit,omitempty"`

	// Value: The denominator of the unit price.
	Value int64 `json:"value,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Unit") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Unit") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ProductUnitPricingBaseMeasure) MarshalJSON() ([]byte, error) {
	type NoMethod ProductUnitPricingBaseMeasure
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ProductUnitPricingMeasure struct {
	// Unit: The unit of the measure.
	Unit string `json:"unit,omitempty"`

	// Value: The measure of an item.
	Value float64 `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Unit") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Unit") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ProductUnitPricingMeasure) MarshalJSON() ([]byte, error) {
	type NoMethod ProductUnitPricingMeasure
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *ProductUnitPricingMeasure) UnmarshalJSON(data []byte) error {
	type NoMethod ProductUnitPricingMeasure
	var s1 struct {
		Value gensupport.JSONFloat64 `json:"value"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Value = float64(s1.Value)
	return nil
}

type ProductWeight struct {
	// Unit: Required. The weight unit. Acceptable values are: - "g" -
	// "kg" - "oz" - "lb"
	Unit string `json:"unit,omitempty"`

	// Value: Required. The weight represented as a number. The weight can
	// have a maximum precision of four decimal places.
	Value float64 `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Unit") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Unit") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ProductWeight) MarshalJSON() ([]byte, error) {
	type NoMethod ProductWeight
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *ProductWeight) UnmarshalJSON(data []byte) error {
	type NoMethod ProductWeight
	var s1 struct {
		Value gensupport.JSONFloat64 `json:"value"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Value = float64(s1.Value)
	return nil
}

type ProductsCustomBatchRequest struct {
	// Entries: The request entries to be processed in the batch.
	Entries []*ProductsCustomBatchRequestEntry `json:"entries,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Entries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ProductsCustomBatchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ProductsCustomBatchRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ProductsCustomBatchRequestEntry: A batch entry encoding a single
// non-batch products request.
type ProductsCustomBatchRequestEntry struct {
	// BatchId: An entry ID, unique within the batch request.
	BatchId int64 `json:"batchId,omitempty"`

	// FeedId: The Content API Supplemental Feed ID. If present then product
	// insertion or deletion applies to a supplemental feed instead of
	// primary Content API feed.
	FeedId uint64 `json:"feedId,omitempty,string"`

	// MerchantId: The ID of the managing account.
	MerchantId uint64 `json:"merchantId,omitempty,string"`

	// Method: The method of the batch entry. Acceptable values are: -
	// "delete" - "get" - "insert" - "update"
	Method string `json:"method,omitempty"`

	// Product: The product to insert or update. Only required if the method
	// is `insert` or `update`. If the `update` method is used with
	// `updateMask` only to delete a field, then this isn't required. For
	// example, setting `salePrice` on the `updateMask` and not providing a
	// `product` will result in an existing sale price on the product
	// specified by `productId` being deleted.
	Product *Product `json:"product,omitempty"`

	// ProductId: The ID of the product to get or mutate. Only defined if
	// the method is `get`, `delete`, or `update`.
	ProductId string `json:"productId,omitempty"`

	// UpdateMask: The comma-separated list of product attributes to be
	// updated. Example: "title,salePrice". Attributes specified in the
	// update mask without a value specified in the body will be deleted
	// from the product. Only top-level product attributes can be updated.
	// If not defined, product attributes with set values will be updated
	// and other attributes will stay unchanged. Only defined if the method
	// is `update`.
	UpdateMask string `json:"updateMask,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BatchId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BatchId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ProductsCustomBatchRequestEntry) MarshalJSON() ([]byte, error) {
	type NoMethod ProductsCustomBatchRequestEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ProductsCustomBatchResponse struct {
	// Entries: The result of the execution of the batch requests.
	Entries []*ProductsCustomBatchResponseEntry `json:"entries,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#productsCustomBatchResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Entries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ProductsCustomBatchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ProductsCustomBatchResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ProductsCustomBatchResponseEntry: A batch entry encoding a single
// non-batch products response.
type ProductsCustomBatchResponseEntry struct {
	// BatchId: The ID of the request entry this entry responds to.
	BatchId int64 `json:"batchId,omitempty"`

	// Errors: A list of errors defined if and only if the request failed.
	Errors *Errors `json:"errors,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#productsCustomBatchResponseEntry"
	Kind string `json:"kind,omitempty"`

	// Product: The inserted product. Only defined if the method is `insert`
	// and if the request was successful.
	Product *Product `json:"product,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BatchId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BatchId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ProductsCustomBatchResponseEntry) MarshalJSON() ([]byte, error) {
	type NoMethod ProductsCustomBatchResponseEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ProductsListResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#productsListResponse".
	Kind string `json:"kind,omitempty"`

	// NextPageToken: The token for the retrieval of the next page of
	// products.
	NextPageToken string `json:"nextPageToken,omitempty"`

	Resources []*Product `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ProductsListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ProductsListResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ProductstatusesCustomBatchRequest struct {
	// Entries: The request entries to be processed in the batch.
	Entries []*ProductstatusesCustomBatchRequestEntry `json:"entries,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Entries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ProductstatusesCustomBatchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ProductstatusesCustomBatchRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ProductstatusesCustomBatchRequestEntry: A batch entry encoding a
// single non-batch productstatuses request.
type ProductstatusesCustomBatchRequestEntry struct {
	// BatchId: An entry ID, unique within the batch request.
	BatchId int64 `json:"batchId,omitempty"`

	// Destinations: If set, only issues for the specified destinations are
	// returned, otherwise only issues for the Shopping destination.
	Destinations []string `json:"destinations,omitempty"`

	IncludeAttributes bool `json:"includeAttributes,omitempty"`

	// MerchantId: The ID of the managing account.
	MerchantId uint64 `json:"merchantId,omitempty,string"`

	// Method: The method of the batch entry. Acceptable values are: -
	// "get"
	Method string `json:"method,omitempty"`

	// ProductId: The ID of the product whose status to get.
	ProductId string `json:"productId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BatchId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BatchId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ProductstatusesCustomBatchRequestEntry) MarshalJSON() ([]byte, error) {
	type NoMethod ProductstatusesCustomBatchRequestEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ProductstatusesCustomBatchResponse struct {
	// Entries: The result of the execution of the batch requests.
	Entries []*ProductstatusesCustomBatchResponseEntry `json:"entries,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#productstatusesCustomBatchResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Entries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ProductstatusesCustomBatchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ProductstatusesCustomBatchResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ProductstatusesCustomBatchResponseEntry: A batch entry encoding a
// single non-batch productstatuses response.
type ProductstatusesCustomBatchResponseEntry struct {
	// BatchId: The ID of the request entry this entry responds to.
	BatchId int64 `json:"batchId,omitempty"`

	// Errors: A list of errors, if the request failed.
	Errors *Errors `json:"errors,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#productstatusesCustomBatchResponseEntry"
	Kind string `json:"kind,omitempty"`

	// ProductStatus: The requested product status. Only defined if the
	// request was successful.
	ProductStatus *ProductStatus `json:"productStatus,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BatchId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BatchId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ProductstatusesCustomBatchResponseEntry) MarshalJSON() ([]byte, error) {
	type NoMethod ProductstatusesCustomBatchResponseEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ProductstatusesListResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#productstatusesListResponse".
	Kind string `json:"kind,omitempty"`

	// NextPageToken: The token for the retrieval of the next page of
	// products statuses.
	NextPageToken string `json:"nextPageToken,omitempty"`

	Resources []*ProductStatus `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ProductstatusesListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ProductstatusesListResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Promotion:  The Promotions feature is currently in alpha and is not
// yet publicly available via Content API for Shopping. This
// documentation is provided for reference only may be subject to
// change. Represents a promotion. See the following articles for more
// details. * Promotions feed specification
// (https://support.google.com/merchants/answer/2906014) * Local
// promotions feed specification
// (https://support.google.com/merchants/answer/10146130) * Promotions
// on Buy on Google product data specification
// (https://support.google.com/merchants/answer/9173673)
type Promotion struct {
	// Brand: Product filter by brand for the promotion.
	Brand []string `json:"brand,omitempty"`

	// BrandExclusion: Product filter by brand exclusion for the promotion.
	BrandExclusion []string `json:"brandExclusion,omitempty"`

	// ContentLanguage: Required. The content language used as part of the
	// unique identifier.
	ContentLanguage string `json:"contentLanguage,omitempty"`

	// CouponValueType: Required. Coupon value type for the promotion.
	//
	// Possible values:
	//   "COUPON_VALUE_TYPE_UNSPECIFIED" - Indicates that the coupon value
	// type is unspecified.
	//   "MONEY_OFF" - Money off coupon value type.
	//   "PERCENT_OFF" - Percent off coupon value type.
	//   "BUY_M_GET_N_MONEY_OFF" - Buy M quantity, get N money off coupon
	// value type. buy_this_quantity and get_this_quantity must be present.
	// money_off_amount must also be present.
	//   "BUY_M_GET_N_PERCENT_OFF" - Buy M quantity, get N percent off
	// coupon value type. buy_this_quantity and get_this_quantity must be
	// present. percent_off_percentage must also be present.
	//   "BUY_M_GET_MONEY_OFF" - Buy M quantity, get money off.
	// buy_this_quantity and money_off_amount must be present.
	//   "BUY_M_GET_PERCENT_OFF" - Buy M quantity, get money off.
	// buy_this_quantity and percent_off_percentage must be present.
	//   "FREE_GIFT" - Free gift with description only
	//   "FREE_GIFT_WITH_VALUE" - Free gift with value (description is
	// optional).
	//   "FREE_GIFT_WITH_ITEM_ID" - Free gift with item id (description is
	// optional).
	//   "FREE_SHIPPING_STANDARD" - Standard free shipping coupon value
	// type.
	//   "FREE_SHIPPING_OVERNIGHT" - Overnight free shipping coupon value
	// type.
	//   "FREE_SHIPPING_TWO_DAY" - Two day free shipping coupon value type.
	CouponValueType string `json:"couponValueType,omitempty"`

	// FreeGiftDescription: Free gift description for the promotion.
	FreeGiftDescription string `json:"freeGiftDescription,omitempty"`

	// FreeGiftItemId: Free gift item id for the promotion.
	FreeGiftItemId string `json:"freeGiftItemId,omitempty"`

	// FreeGiftValue: Free gift value for the promotion.
	FreeGiftValue *PriceAmount `json:"freeGiftValue,omitempty"`

	// GenericRedemptionCode: Generic redemption code for the promotion. To
	// be used with the above field.
	GenericRedemptionCode string `json:"genericRedemptionCode,omitempty"`

	// GetThisQuantityDiscounted: The number of items discounted in the
	// promotion.
	GetThisQuantityDiscounted int64 `json:"getThisQuantityDiscounted,omitempty"`

	// Id: Required. Output only. The REST promotion id to uniquely identify
	// the promotion. Content API methods that operate on promotions take
	// this as their promotionId parameter. The REST ID for a promotion is
	// of the form channel:contentLanguage:targetCountry:promotionId The
	// channel field will have a value of "online", "in_store", or
	// "online_in_store".
	Id string `json:"id,omitempty"`

	// ItemGroupId: Product filter by item group id for the promotion.
	ItemGroupId []string `json:"itemGroupId,omitempty"`

	// ItemGroupIdExclusion: Product filter by item group id exclusion for
	// the promotion.
	ItemGroupIdExclusion []string `json:"itemGroupIdExclusion,omitempty"`

	// ItemId: Product filter by item id for the promotion.
	ItemId []string `json:"itemId,omitempty"`

	// ItemIdExclusion: Product filter by item id exclusion for the
	// promotion.
	ItemIdExclusion []string `json:"itemIdExclusion,omitempty"`

	// LimitQuantity: Maximum purchase quantity for the promotion.
	LimitQuantity int64 `json:"limitQuantity,omitempty"`

	// LimitValue: Maximum purchase value for the promotion.
	LimitValue *PriceAmount `json:"limitValue,omitempty"`

	// LongTitle: Long title for the promotion.
	LongTitle string `json:"longTitle,omitempty"`

	// MinimumPurchaseAmount: Minimum purchase amount for the promotion.
	MinimumPurchaseAmount *PriceAmount `json:"minimumPurchaseAmount,omitempty"`

	// MinimumPurchaseQuantity: Minimum purchase quantity for the promotion.
	MinimumPurchaseQuantity int64 `json:"minimumPurchaseQuantity,omitempty"`

	// MoneyBudget: Promotion cost cap of the promotion.
	MoneyBudget *PriceAmount `json:"moneyBudget,omitempty"`

	// MoneyOffAmount: The money off amount offered in the promotion.
	MoneyOffAmount *PriceAmount `json:"moneyOffAmount,omitempty"`

	// OfferType: Required. Type of the promotion.
	//
	// Possible values:
	//   "OFFER_TYPE_UNSPECIFIED" - Unknown offer type.
	//   "NO_CODE" - Offer type without a code.
	//   "GENERIC_CODE" - Offer type with a code.
	OfferType string `json:"offerType,omitempty"`

	// OrderLimit: Order limit for the promotion.
	OrderLimit int64 `json:"orderLimit,omitempty"`

	// PercentOff: The percentage discount offered in the promotion.
	PercentOff int64 `json:"percentOff,omitempty"`

	// ProductApplicability: Required. Applicability of the promotion to
	// either all products or only specific products.
	//
	// Possible values:
	//   "PRODUCT_APPLICABILITY_UNSPECIFIED" - Unknown product
	// applicability.
	//   "ALL_PRODUCTS" - Applicable to all products.
	//   "SPECIFIC_PRODUCTS" - Applicable to only a single product or list
	// of products.
	ProductApplicability string `json:"productApplicability,omitempty"`

	// ProductType: Product filter by product type for the promotion.
	ProductType []string `json:"productType,omitempty"`

	// ProductTypeExclusion: Product filter by product type exclusion for
	// the promotion.
	ProductTypeExclusion []string `json:"productTypeExclusion,omitempty"`

	// PromotionDestinationIds: Destination ID for the promotion.
	PromotionDestinationIds []string `json:"promotionDestinationIds,omitempty"`

	// PromotionDisplayDates: String representation of the promotion display
	// dates.
	PromotionDisplayDates string `json:"promotionDisplayDates,omitempty"`

	// PromotionDisplayTimePeriod: TimePeriod representation of the
	// promotion display dates.
	PromotionDisplayTimePeriod *TimePeriod `json:"promotionDisplayTimePeriod,omitempty"`

	// PromotionEffectiveDates: Required. String representation of the
	// promotion effective dates.
	PromotionEffectiveDates string `json:"promotionEffectiveDates,omitempty"`

	// PromotionEffectiveTimePeriod: Required. TimePeriod representation of
	// the promotion effective dates.
	PromotionEffectiveTimePeriod *TimePeriod `json:"promotionEffectiveTimePeriod,omitempty"`

	// PromotionId: Required. The user provided promotion id to uniquely
	// identify the promotion.
	PromotionId string `json:"promotionId,omitempty"`

	// RedemptionChannel: Required. Redemption channel for the promotion. At
	// least one channel is required.
	//
	// Possible values:
	//   "REDEMPTION_CHANNEL_UNSPECIFIED" - Indicates that the channel is
	// unspecified.
	//   "IN_STORE" - Indicates that the channel is in store.
	//   "ONLINE" - Indicates that the channel is online.
	RedemptionChannel []string `json:"redemptionChannel,omitempty"`

	// ShippingServiceNames: Shipping service names for thse promotion.
	ShippingServiceNames []string `json:"shippingServiceNames,omitempty"`

	// TargetCountry: Required. The target country used as part of the
	// unique identifier.
	TargetCountry string `json:"targetCountry,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Brand") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Brand") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Promotion) MarshalJSON() ([]byte, error) {
	type NoMethod Promotion
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PubsubNotificationSettings: Settings for Pub/Sub notifications, all
// methods require that the caller is a direct user of the merchant
// center account.
type PubsubNotificationSettings struct {
	// CloudTopicName: Cloud pub/sub topic to which notifications are sent
	// (read-only).
	CloudTopicName string `json:"cloudTopicName,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#pubsubNotificationSettings"
	Kind string `json:"kind,omitempty"`

	// RegisteredEvents: List of event types. Acceptable values are: -
	// "orderPendingShipment"
	RegisteredEvents []string `json:"registeredEvents,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CloudTopicName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CloudTopicName") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *PubsubNotificationSettings) MarshalJSON() ([]byte, error) {
	type NoMethod PubsubNotificationSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type RateGroup struct {
	// ApplicableShippingLabels: A list of shipping labels defining the
	// products to which this rate group applies to. This is a disjunction:
	// only one of the labels has to match for the rate group to apply. May
	// only be empty for the last rate group of a service. Required.
	ApplicableShippingLabels []string `json:"applicableShippingLabels,omitempty"`

	// CarrierRates: A list of carrier rates that can be referred to by
	// `mainTable` or `singleValue`.
	CarrierRates []*CarrierRate `json:"carrierRates,omitempty"`

	// MainTable: A table defining the rate group, when `singleValue` is not
	// expressive enough. Can only be set if `singleValue` is not set.
	MainTable *Table `json:"mainTable,omitempty"`

	// Name: Name of the rate group. Optional. If set has to be unique
	// within shipping service.
	Name string `json:"name,omitempty"`

	// SingleValue: The value of the rate group (e.g. flat rate $10). Can
	// only be set if `mainTable` and `subtables` are not set.
	SingleValue *Value `json:"singleValue,omitempty"`

	// Subtables: A list of subtables referred to by `mainTable`. Can only
	// be set if `mainTable` is set.
	Subtables []*Table `json:"subtables,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ApplicableShippingLabels") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApplicableShippingLabels")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *RateGroup) MarshalJSON() ([]byte, error) {
	type NoMethod RateGroup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type RefundReason struct {
	// Description: Description of the reason.
	Description string `json:"description,omitempty"`

	// ReasonCode: Code of the refund reason. Acceptable values are: -
	// "adjustment" - "autoPostInternal" -
	// "autoPostInvalidBillingAddress" - "autoPostNoInventory" -
	// "autoPostPriceError" - "autoPostUndeliverableShippingAddress" -
	// "couponAbuse" - "courtesyAdjustment" - "customerCanceled" -
	// "customerDiscretionaryReturn" - "customerInitiatedMerchantCancel"
	// - "customerSupportRequested" - "deliveredLateByCarrier" -
	// "deliveredTooLate" - "expiredItem" -
	// "failToPushOrderGoogleError" - "failToPushOrderMerchantError" -
	// "failToPushOrderMerchantFulfillmentError" -
	// "failToPushOrderToMerchant" -
	// "failToPushOrderToMerchantOutOfStock" - "feeAdjustment" -
	// "invalidCoupon" - "lateShipmentCredit" -
	// "malformedShippingAddress" - "merchantDidNotShipOnTime" -
	// "noInventory" - "orderTimeout" - "other" - "paymentAbuse" -
	// "paymentDeclined" - "priceAdjustment" - "priceError" -
	// "productArrivedDamaged" - "productNotAsDescribed" -
	// "promoReallocation" - "qualityNotAsExpected" -
	// "returnRefundAbuse" - "shippingCostAdjustment" -
	// "shippingPriceError" - "taxAdjustment" - "taxError" -
	// "undeliverableShippingAddress" - "unsupportedPoBoxAddress" -
	// "wrongProductShipped"
	ReasonCode string `json:"reasonCode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RefundReason) MarshalJSON() ([]byte, error) {
	type NoMethod RefundReason
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Region: Represents a geographic region that you can use as a target
// with both the `RegionalInventory` and `ShippingSettings` services.
// You can define regions as collections of either postal codes or, in
// some countries, using predefined geotargets.
type Region struct {
	// DisplayName: The display name of the region.
	DisplayName string `json:"displayName,omitempty"`

	// GeotargetArea: A list of geotargets that defines the region area.
	GeotargetArea *RegionGeoTargetArea `json:"geotargetArea,omitempty"`

	// MerchantId: Output only. Immutable. Merchant that owns the region.
	MerchantId int64 `json:"merchantId,omitempty,string"`

	// PostalCodeArea: A list of postal codes that defines the region area.
	PostalCodeArea *RegionPostalCodeArea `json:"postalCodeArea,omitempty"`

	// RegionId: Output only. Immutable. The ID uniquely identifying each
	// region.
	RegionId string `json:"regionId,omitempty"`

	// RegionalInventoryEligible: Output only. Indicates if the region is
	// eligible to use in the Regional Inventory configuration.
	RegionalInventoryEligible bool `json:"regionalInventoryEligible,omitempty"`

	// ShippingEligible: Output only. Indicates if the region is eligible to
	// use in the Shipping Services configuration.
	ShippingEligible bool `json:"shippingEligible,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Region) MarshalJSON() ([]byte, error) {
	type NoMethod Region
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RegionGeoTargetArea: A list of geotargets that defines the region
// area.
type RegionGeoTargetArea struct {
	// GeotargetCriteriaIds: Required. A non-empty list of location IDs
	// (https://developers.google.com/adwords/api/docs/appendix/geotargeting).
	// They must all be of the same location type (e.g., state).
	GeotargetCriteriaIds googleapi.Int64s `json:"geotargetCriteriaIds,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "GeotargetCriteriaIds") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GeotargetCriteriaIds") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *RegionGeoTargetArea) MarshalJSON() ([]byte, error) {
	type NoMethod RegionGeoTargetArea
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RegionPostalCodeArea: A list of postal codes that defines the region
// area. Note: All regions defined using postal codes are accessible via
// the account's `ShippingSettings.postalCodeGroups` resource.
type RegionPostalCodeArea struct {
	// PostalCodes: Required. A range of postal codes.
	PostalCodes []*RegionPostalCodeAreaPostalCodeRange `json:"postalCodes,omitempty"`

	// RegionCode: Required. CLDR territory code or the country the postal
	// code group applies to.
	RegionCode string `json:"regionCode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PostalCodes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PostalCodes") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RegionPostalCodeArea) MarshalJSON() ([]byte, error) {
	type NoMethod RegionPostalCodeArea
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RegionPostalCodeAreaPostalCodeRange: A range of postal codes that
// defines the region area.
type RegionPostalCodeAreaPostalCodeRange struct {
	// Begin: Required. A postal code or a pattern of the form prefix*
	// denoting the inclusive lower bound of the range defining the area.
	// Examples values: "94108", "9410*", "9*".
	Begin string `json:"begin,omitempty"`

	// End: Optional. A postal code or a pattern of the form prefix*
	// denoting the inclusive upper bound of the range defining the area. It
	// must have the same length as postalCodeRangeBegin: if
	// postalCodeRangeBegin is a postal code then postalCodeRangeEnd must be
	// a postal code too; if postalCodeRangeBegin is a pattern then
	// postalCodeRangeEnd must be a pattern with the same prefix length.
	// Optional: if not set, then the area is defined as being all the
	// postal codes matching postalCodeRangeBegin.
	End string `json:"end,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Begin") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Begin") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RegionPostalCodeAreaPostalCodeRange) MarshalJSON() ([]byte, error) {
	type NoMethod RegionPostalCodeAreaPostalCodeRange
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RegionalInventory: Regional inventory resource. contains the regional
// name and all attributes which are overridden for the specified
// region.
type RegionalInventory struct {
	// Availability: The availability of the product.
	Availability string `json:"availability,omitempty"`

	// CustomAttributes: A list of custom (merchant-provided) attributes. It
	// can also be used for submitting any attribute of the feed
	// specification in its generic form.
	CustomAttributes []*CustomAttribute `json:"customAttributes,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#regionalInventory".
	Kind string `json:"kind,omitempty"`

	// Price: The price of the product.
	Price *Price `json:"price,omitempty"`

	// RegionId: The ID uniquely identifying each region.
	RegionId string `json:"regionId,omitempty"`

	// SalePrice: The sale price of the product. Mandatory if
	// `sale_price_effective_date` is defined.
	SalePrice *Price `json:"salePrice,omitempty"`

	// SalePriceEffectiveDate: A date range represented by a pair of ISO
	// 8601 dates separated by a space, comma, or slash. Both dates might be
	// specified as 'null' if undecided.
	SalePriceEffectiveDate string `json:"salePriceEffectiveDate,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Availability") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Availability") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RegionalInventory) MarshalJSON() ([]byte, error) {
	type NoMethod RegionalInventory
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type RegionalinventoryCustomBatchRequest struct {
	// Entries: The request entries to be processed in the batch.
	Entries []*RegionalinventoryCustomBatchRequestEntry `json:"entries,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Entries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RegionalinventoryCustomBatchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RegionalinventoryCustomBatchRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RegionalinventoryCustomBatchRequestEntry: A batch entry encoding a
// single non-batch regional inventory request.
type RegionalinventoryCustomBatchRequestEntry struct {
	// BatchId: An entry ID, unique within the batch request.
	BatchId int64 `json:"batchId,omitempty"`

	// MerchantId: The ID of the managing account.
	MerchantId uint64 `json:"merchantId,omitempty,string"`

	// Method: Method of the batch request entry. Acceptable values are: -
	// "insert"
	Method string `json:"method,omitempty"`

	// ProductId: The ID of the product for which to update price and
	// availability.
	ProductId string `json:"productId,omitempty"`

	// RegionalInventory: Price and availability of the product.
	RegionalInventory *RegionalInventory `json:"regionalInventory,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BatchId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BatchId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RegionalinventoryCustomBatchRequestEntry) MarshalJSON() ([]byte, error) {
	type NoMethod RegionalinventoryCustomBatchRequestEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type RegionalinventoryCustomBatchResponse struct {
	// Entries: The result of the execution of the batch requests.
	Entries []*RegionalinventoryCustomBatchResponseEntry `json:"entries,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#regionalinventoryCustomBatchResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Entries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RegionalinventoryCustomBatchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod RegionalinventoryCustomBatchResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RegionalinventoryCustomBatchResponseEntry: A batch entry encoding a
// single non-batch regional inventory response.
type RegionalinventoryCustomBatchResponseEntry struct {
	// BatchId: The ID of the request entry this entry responds to.
	BatchId int64 `json:"batchId,omitempty"`

	// Errors: A list of errors defined if and only if the request failed.
	Errors *Errors `json:"errors,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#regionalinventoryCustomBatchResponseEntry".
	Kind string `json:"kind,omitempty"`

	// RegionalInventory: Price and availability of the product.
	RegionalInventory *RegionalInventory `json:"regionalInventory,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BatchId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BatchId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RegionalinventoryCustomBatchResponseEntry) MarshalJSON() ([]byte, error) {
	type NoMethod RegionalinventoryCustomBatchResponseEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ReportRow: Result row returned from the search query.
type ReportRow struct {
	// Metrics: Metrics requested by the merchant in the query. Metric
	// values are only set for metrics requested explicitly in the query.
	Metrics *Metrics `json:"metrics,omitempty"`

	// Segments: Segmentation dimensions requested by the merchant in the
	// query. Dimension values are only set for dimensions requested
	// explicitly in the query.
	Segments *Segments `json:"segments,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Metrics") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Metrics") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ReportRow) MarshalJSON() ([]byte, error) {
	type NoMethod ReportRow
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RepricingProductReport: Resource that represents a daily Repricing
// product report. Each report contains stats for a single type of
// Repricing rule for a single product on a given day. If there are
// multiple rules of the same type for the product on that day, the
// report lists all the rules by rule ids, combines the stats, and
// paginates the results by date. To retrieve the stats of a particular
// rule, provide the rule_id in the request.
type RepricingProductReport struct {
	// ApplicationCount: Total count of Repricer applications. This value
	// captures how many times the rule of this type was applied to this
	// product during this reporting period.
	ApplicationCount int64 `json:"applicationCount,omitempty,string"`

	// BuyboxWinningProductStats: Stats specific to buybox winning rules for
	// product report (deprecated).
	BuyboxWinningProductStats *RepricingProductReportBuyboxWinningProductStats `json:"buyboxWinningProductStats,omitempty"`

	// Date: Date of the stats in this report. The report starts and ends
	// according to the merchant's timezone.
	Date *Date `json:"date,omitempty"`

	// HighWatermark: Maximum displayed price after repriced during this
	// reporting period.
	HighWatermark *PriceAmount `json:"highWatermark,omitempty"`

	// InapplicabilityDetails: List of all reasons the rule did not apply to
	// the product during the specified reporting period.
	InapplicabilityDetails []*InapplicabilityDetails `json:"inapplicabilityDetails,omitempty"`

	// LowWatermark: Minimum displayed price after repriced during this
	// reporting period.
	LowWatermark *PriceAmount `json:"lowWatermark,omitempty"`

	// OrderItemCount: Total unit count of impacted products ordered while
	// the rule was active on the date of the report. This count includes
	// all orders that were started while the rule was active, even if the
	// rule was no longer active when the order was completed.
	OrderItemCount int64 `json:"orderItemCount,omitempty"`

	// RuleIds: Ids of the Repricing rule for this report.
	RuleIds []string `json:"ruleIds,omitempty"`

	// TotalGmv: Total GMV generated by impacted products while the rule was
	// active on the date of the report. This value includes all orders that
	// were started while the rule was active, even if the rule was no
	// longer active when the order was completed.
	TotalGmv *PriceAmount `json:"totalGmv,omitempty"`

	// Type: Type of the rule.
	//
	// Possible values:
	//   "REPRICING_RULE_TYPE_UNSPECIFIED" - Unused.
	//   "TYPE_STATS_BASED" - Statistical measurement based rules among
	// Google SA merchants. If this rule is chosen, repricer will adjust the
	// offer price based on statistical metrics (currently only min is
	// available) among other merchants who sell the same product. Details
	// need to be provdided in the RuleDefinition.
	//   "TYPE_COGS_BASED" - Cost of goods sale based rule. Repricer will
	// adjust the offer price based on the offer's sale cost which is
	// provided by the merchant.
	//   "TYPE_SALES_VOLUME_BASED" - Sales volume based rule. Repricer will
	// adjust the offer price based on the offer's sales volume in the past
	// period of time defined within the rule.
	//   "TYPE_COMPETITIVE_PRICE" - Competitive price rule. Repricer will
	// adjust the offer price based on the min price from a list of unnamed
	// big competitors.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ApplicationCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApplicationCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *RepricingProductReport) MarshalJSON() ([]byte, error) {
	type NoMethod RepricingProductReport
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RepricingProductReportBuyboxWinningProductStats: Stats specific to
// buybox winning rules for product report.
type RepricingProductReportBuyboxWinningProductStats struct {
	// BuyboxWinsCount: Number of times this product won the buybox with
	// these rules during this time period.
	BuyboxWinsCount int64 `json:"buyboxWinsCount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BuyboxWinsCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BuyboxWinsCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *RepricingProductReportBuyboxWinningProductStats) MarshalJSON() ([]byte, error) {
	type NoMethod RepricingProductReportBuyboxWinningProductStats
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RepricingRule: Represents a repricing rule. A repricing rule is used
// by shopping serving to adjust transactable offer prices if conditions
// are met. Next ID: 24
type RepricingRule struct {
	// CogsBasedRule: The rule definition for TYPE_COGS_BASED. Required when
	// the rule type is TYPE_COGS_BASED.
	CogsBasedRule *RepricingRuleCostOfGoodsSaleRule `json:"cogsBasedRule,omitempty"`

	// CountryCode: Required. Immutable. CLDR country code
	// (http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml)
	// (e.g. "US").
	CountryCode string `json:"countryCode,omitempty"`

	// EffectiveTimePeriod: Required. Time period when the rule should take
	// effect.
	EffectiveTimePeriod *RepricingRuleEffectiveTime `json:"effectiveTimePeriod,omitempty"`

	// EligibleOfferMatcher: Required. Match criteria for the eligible
	// offers.
	EligibleOfferMatcher *RepricingRuleEligibleOfferMatcher `json:"eligibleOfferMatcher,omitempty"`

	// LanguageCode: Required. Immutable. The two-letter ISO 639-1 language
	// code associated with the repricing rule.
	LanguageCode string `json:"languageCode,omitempty"`

	// MerchantId: Output only. Immutable. Merchant that owns the repricing
	// rule.
	MerchantId int64 `json:"merchantId,omitempty,string"`

	// Paused: Represents whether a rule is paused. A paused rule will
	// behave like a non-paused rule within CRUD operations, with the major
	// difference that a paused rule will not be evaluated and will have no
	// effect on offers.
	Paused bool `json:"paused,omitempty"`

	// Restriction: Required. Restriction of the rule appliance.
	Restriction *RepricingRuleRestriction `json:"restriction,omitempty"`

	// RuleId: Output only. Immutable. The ID to uniquely identify each
	// repricing rule.
	RuleId string `json:"ruleId,omitempty"`

	// StatsBasedRule: The rule definition for TYPE_STATS_BASED. Required
	// when the rule type is TYPE_STATS_BASED.
	StatsBasedRule *RepricingRuleStatsBasedRule `json:"statsBasedRule,omitempty"`

	// Title: The title for the rule.
	Title string `json:"title,omitempty"`

	// Type: Required. Immutable. The type of the rule.
	//
	// Possible values:
	//   "REPRICING_RULE_TYPE_UNSPECIFIED" - Unused.
	//   "TYPE_STATS_BASED" - Statistical measurement based rules among
	// Google SA merchants. If this rule is chosen, repricer will adjust the
	// offer price based on statistical metrics (currently only min is
	// available) among other merchants who sell the same product. Details
	// need to be provdided in the RuleDefinition.
	//   "TYPE_COGS_BASED" - Cost of goods sale based rule. Repricer will
	// adjust the offer price based on the offer's sale cost which is
	// provided by the merchant.
	//   "TYPE_SALES_VOLUME_BASED" - Sales volume based rule. Repricer will
	// adjust the offer price based on the offer's sales volume in the past
	// period of time defined within the rule.
	//   "TYPE_COMPETITIVE_PRICE" - Competitive price rule. Repricer will
	// adjust the offer price based on the min price from a list of unnamed
	// big competitors.
	Type string `json:"type,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CogsBasedRule") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CogsBasedRule") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RepricingRule) MarshalJSON() ([]byte, error) {
	type NoMethod RepricingRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RepricingRuleCostOfGoodsSaleRule: A repricing rule that changes the
// sale price based on cost of goods sale.
type RepricingRuleCostOfGoodsSaleRule struct {
	// PercentageDelta: The percent change against the COGS. Ex: 20 would
	// mean to set the adjusted price 1.2X of the COGS data.
	PercentageDelta int64 `json:"percentageDelta,omitempty"`

	// PriceDelta: The price delta against the COGS. E.g. 2 means $2 more of
	// the COGS.
	PriceDelta string `json:"priceDelta,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PercentageDelta") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PercentageDelta") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *RepricingRuleCostOfGoodsSaleRule) MarshalJSON() ([]byte, error) {
	type NoMethod RepricingRuleCostOfGoodsSaleRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type RepricingRuleEffectiveTime struct {
	// FixedTimePeriods: A list of fixed time periods combined with OR. The
	// maximum number of entries is limited to 5.
	FixedTimePeriods []*RepricingRuleEffectiveTimeFixedTimePeriod `json:"fixedTimePeriods,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FixedTimePeriods") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FixedTimePeriods") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *RepricingRuleEffectiveTime) MarshalJSON() ([]byte, error) {
	type NoMethod RepricingRuleEffectiveTime
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RepricingRuleEffectiveTimeFixedTimePeriod: Definition of a fixed time
// period.
type RepricingRuleEffectiveTimeFixedTimePeriod struct {
	// EndTime: The end time (exclusive) of the period. It can only be hour
	// granularity.
	EndTime string `json:"endTime,omitempty"`

	// StartTime: The start time (inclusive) of the period. It can only be
	// hour granularity.
	StartTime string `json:"startTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EndTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RepricingRuleEffectiveTimeFixedTimePeriod) MarshalJSON() ([]byte, error) {
	type NoMethod RepricingRuleEffectiveTimeFixedTimePeriod
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RepricingRuleEligibleOfferMatcher: Matcher that specifies eligible
// offers. When the USE_FEED_ATTRIBUTE option is selected, only the
// repricing_rule_id attribute on the product feed is used to specify
// offer-rule mapping. When the CUSTOM_FILTER option is selected, only
// the *_matcher fields are used to filter the offers for offer-rule
// mapping. If the CUSTOM_FILTER option is selected, an offer needs to
// satisfy each custom filter matcher to be eligible for a rule. Size
// limit: the sum of the number of entries in all the matchers should
// not exceed 20. For example, there can be 15 product ids and 5 brands,
// but not 10 product ids and 11 brands.
type RepricingRuleEligibleOfferMatcher struct {
	// BrandMatcher: Filter by the brand.
	BrandMatcher *RepricingRuleEligibleOfferMatcherStringMatcher `json:"brandMatcher,omitempty"`

	// ItemGroupIdMatcher: Filter by the item group id.
	ItemGroupIdMatcher *RepricingRuleEligibleOfferMatcherStringMatcher `json:"itemGroupIdMatcher,omitempty"`

	// MatcherOption: Determines whether to use the custom matchers or the
	// product feed attribute "repricing_rule_id" to specify offer-rule
	// mapping.
	//
	// Possible values:
	//   "MATCHER_OPTION_UNSPECIFIED" - Unused.
	//   "MATCHER_OPTION_CUSTOM_FILTER" - Use custom filters.
	//   "MATCHER_OPTION_USE_FEED_ATTRIBUTE" - Use repricing_rule_id feed
	// attribute on the product resource to specify offer-rule mapping.
	//   "MATCHER_OPTION_ALL_PRODUCTS" - Matching all products.
	MatcherOption string `json:"matcherOption,omitempty"`

	// OfferIdMatcher: Filter by the offer id.
	OfferIdMatcher *RepricingRuleEligibleOfferMatcherStringMatcher `json:"offerIdMatcher,omitempty"`

	// SkipWhenOnPromotion: When true, the rule won't be applied to offers
	// with active promotions.
	SkipWhenOnPromotion bool `json:"skipWhenOnPromotion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BrandMatcher") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BrandMatcher") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RepricingRuleEligibleOfferMatcher) MarshalJSON() ([]byte, error) {
	type NoMethod RepricingRuleEligibleOfferMatcher
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RepricingRuleEligibleOfferMatcherStringMatcher: Matcher by string
// attributes.
type RepricingRuleEligibleOfferMatcherStringMatcher struct {
	// StrAttributes: String attributes, as long as such attribute of an
	// offer is one of the string attribute values, the offer is considered
	// as passing the matcher. The string matcher checks an offer for
	// inclusivity in the string attributes, not equality. Only literal
	// string matching is supported, no regex.
	StrAttributes []string `json:"strAttributes,omitempty"`

	// ForceSendFields is a list of field names (e.g. "StrAttributes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "StrAttributes") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RepricingRuleEligibleOfferMatcherStringMatcher) MarshalJSON() ([]byte, error) {
	type NoMethod RepricingRuleEligibleOfferMatcherStringMatcher
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RepricingRuleReport: Resource that represents a daily Repricing rule
// report. Next ID: 11
type RepricingRuleReport struct {
	// BuyboxWinningRuleStats: Stats specific to buybox winning rules for
	// rule report (deprecated).
	BuyboxWinningRuleStats *RepricingRuleReportBuyboxWinningRuleStats `json:"buyboxWinningRuleStats,omitempty"`

	// Date: Date of the stats in this report. The report starts and ends
	// according to the merchant's timezone.
	Date *Date `json:"date,omitempty"`

	// ImpactedProducts: List of product ids that are impacted by this rule
	// during this reporting period. Out of stock products and products not
	// searched for by customers are examples of non-impacted products.
	ImpactedProducts []string `json:"impactedProducts,omitempty"`

	// InapplicabilityDetails: List of all reasons the rule did not apply to
	// the inapplicable products during the specified reporting period.
	InapplicabilityDetails []*InapplicabilityDetails `json:"inapplicabilityDetails,omitempty"`

	// InapplicableProducts: List of product ids that are inapplicable to
	// this rule during this reporting period. To get the inapplicable
	// reason for a specific product, see RepricingProductReport.
	InapplicableProducts []string `json:"inapplicableProducts,omitempty"`

	// OrderItemCount: Total unit count of impacted products ordered while
	// the rule was active on the date of the report. This count includes
	// all orders that were started while the rule was active, even if the
	// rule was no longer active when the order was completed.
	OrderItemCount int64 `json:"orderItemCount,omitempty"`

	// RuleId: Id of the Repricing rule for this report.
	RuleId string `json:"ruleId,omitempty"`

	// TotalGmv: Total GMV generated by impacted products while the rule was
	// active on the date of the report. This value includes all orders that
	// were started while the rule was active, even if the rule was no
	// longer active when the order was completed.
	TotalGmv *PriceAmount `json:"totalGmv,omitempty"`

	// Type: Type of the rule.
	//
	// Possible values:
	//   "REPRICING_RULE_TYPE_UNSPECIFIED" - Unused.
	//   "TYPE_STATS_BASED" - Statistical measurement based rules among
	// Google SA merchants. If this rule is chosen, repricer will adjust the
	// offer price based on statistical metrics (currently only min is
	// available) among other merchants who sell the same product. Details
	// need to be provdided in the RuleDefinition.
	//   "TYPE_COGS_BASED" - Cost of goods sale based rule. Repricer will
	// adjust the offer price based on the offer's sale cost which is
	// provided by the merchant.
	//   "TYPE_SALES_VOLUME_BASED" - Sales volume based rule. Repricer will
	// adjust the offer price based on the offer's sales volume in the past
	// period of time defined within the rule.
	//   "TYPE_COMPETITIVE_PRICE" - Competitive price rule. Repricer will
	// adjust the offer price based on the min price from a list of unnamed
	// big competitors.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "BuyboxWinningRuleStats") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BuyboxWinningRuleStats")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *RepricingRuleReport) MarshalJSON() ([]byte, error) {
	type NoMethod RepricingRuleReport
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RepricingRuleReportBuyboxWinningRuleStats: Stats specific to buybox
// winning rules for rule report.
type RepricingRuleReportBuyboxWinningRuleStats struct {
	// BuyboxWonProductCount: Number of unique products that won the buybox
	// with this rule during this period of time.
	BuyboxWonProductCount int64 `json:"buyboxWonProductCount,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "BuyboxWonProductCount") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BuyboxWonProductCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *RepricingRuleReportBuyboxWinningRuleStats) MarshalJSON() ([]byte, error) {
	type NoMethod RepricingRuleReportBuyboxWinningRuleStats
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RepricingRuleRestriction: Definition of a rule restriction. At least
// one of the following needs to be true: (1) use_auto_pricing_min_price
// is true (2) floor.price_delta exists (3) floor.percentage_delta
// exists If floor.price_delta and floor.percentage_delta are both set
// on a rule, the highest value will be chosen by the Repricer. In other
// words, for a product with a price of $50, if the
// `floor.percentage_delta` is "-10" and the floor.price_delta is "-12",
// the offer price will only be lowered $5 (10% lower than the original
// offer price).
type RepricingRuleRestriction struct {
	// Floor: The inclusive floor lower bound. The repricing rule only
	// applies when new price >= floor.
	Floor *RepricingRuleRestrictionBoundary `json:"floor,omitempty"`

	// UseAutoPricingMinPrice: If true, use the AUTO_PRICING_MIN_PRICE offer
	// attribute as the lower bound of the rule. If
	// use_auto_pricing_min_price is true, then only offers with
	// `AUTO_PRICING_MIN_PRICE` existing on the offer will get Repricer
	// treatment, even if a floor value is set on the rule. Also, if
	// use_auto_pricing_min_price is true, the floor restriction will be
	// ignored.
	UseAutoPricingMinPrice bool `json:"useAutoPricingMinPrice,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Floor") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Floor") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RepricingRuleRestriction) MarshalJSON() ([]byte, error) {
	type NoMethod RepricingRuleRestriction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RepricingRuleRestrictionBoundary: Definition of a boundary.
type RepricingRuleRestrictionBoundary struct {
	// PercentageDelta: The percentage delta relative to the offer selling
	// price. This field is signed. It must be negative in floor. When it is
	// used in floor, it should be > -100. For example, if an offer is
	// selling at $10 and this field is -30 in floor, the repricing rule
	// only applies if the calculated new price is >= $7.
	PercentageDelta int64 `json:"percentageDelta,omitempty"`

	// PriceDelta: The price micros relative to the offer selling price.
	// This field is signed. It must be negative in floor. For example, if
	// an offer is selling at $10 and this field is -$2 in floor, the
	// repricing rule only applies if the calculated new price is >= $8.
	PriceDelta string `json:"priceDelta,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PercentageDelta") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PercentageDelta") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *RepricingRuleRestrictionBoundary) MarshalJSON() ([]byte, error) {
	type NoMethod RepricingRuleRestrictionBoundary
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RepricingRuleStatsBasedRule: Definition of stats based rule.
type RepricingRuleStatsBasedRule struct {
	// PercentageDelta: The percent change against the price target. Valid
	// from 0 to 100 inclusively.
	PercentageDelta int64 `json:"percentageDelta,omitempty"`

	// PriceDelta: The price delta against the above price target. A
	// positive value means the price should be adjusted to be above
	// statistical measure, and a negative value means below. Currency code
	// must not be included.
	PriceDelta string `json:"priceDelta,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PercentageDelta") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PercentageDelta") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *RepricingRuleStatsBasedRule) MarshalJSON() ([]byte, error) {
	type NoMethod RepricingRuleStatsBasedRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RequestPhoneVerificationRequest: Request message for the
// RequestPhoneVerification method.
type RequestPhoneVerificationRequest struct {
	// LanguageCode: Language code IETF BCP 47 syntax
	// (https://tools.ietf.org/html/bcp47) (for example, en-US). Language
	// code is used to provide localized `SMS` and `PHONE_CALL`. Default
	// language used is en-US if not provided.
	LanguageCode string `json:"languageCode,omitempty"`

	// PhoneNumber: Phone number to be verified.
	PhoneNumber string `json:"phoneNumber,omitempty"`

	// PhoneRegionCode: Required. Two letter country code for the phone
	// number, for example `CA` for Canadian numbers. See the ISO 3166-1
	// alpha-2
	// (https://wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements)
	// officially assigned codes.
	PhoneRegionCode string `json:"phoneRegionCode,omitempty"`

	// PhoneVerificationMethod: Verification method to receive verification
	// code.
	//
	// Possible values:
	//   "PHONE_VERIFICATION_METHOD_UNSPECIFIED" - Unknown method.
	//   "SMS" - Receive verification code by SMS.
	//   "PHONE_CALL" - Receive verification code by phone call.
	PhoneVerificationMethod string `json:"phoneVerificationMethod,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LanguageCode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LanguageCode") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RequestPhoneVerificationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RequestPhoneVerificationRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RequestPhoneVerificationResponse: Response message for the
// RequestPhoneVerification method.
type RequestPhoneVerificationResponse struct {
	// VerificationId: The verification ID to use in subsequent calls to
	// `verifyphonenumber`.
	VerificationId string `json:"verificationId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "VerificationId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "VerificationId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *RequestPhoneVerificationResponse) MarshalJSON() ([]byte, error) {
	type NoMethod RequestPhoneVerificationResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RequestReviewBuyOnGoogleProgramRequest: Request message for the
// RequestReviewProgram method.
type RequestReviewBuyOnGoogleProgramRequest struct {
}

// RequestReviewFreeListingsRequest: Request message for the
// RequestReviewFreeListings Program method.
type RequestReviewFreeListingsRequest struct {
	// RegionCode: The code ISO 3166-1 alpha-2
	// (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) of the country for
	// which review is to be requested.
	RegionCode string `json:"regionCode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RegionCode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RegionCode") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RequestReviewFreeListingsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RequestReviewFreeListingsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RequestReviewShoppingAdsRequest: Request message for the
// RequestReviewShoppingAds program method.
type RequestReviewShoppingAdsRequest struct {
	// RegionCode: The code ISO 3166-1 alpha-2
	// (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) of the country for
	// which review is to be requested.
	RegionCode string `json:"regionCode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RegionCode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RegionCode") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RequestReviewShoppingAdsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RequestReviewShoppingAdsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ReturnAddress: Return address resource.
type ReturnAddress struct {
	// Address: Required. The address.
	Address *ReturnAddressAddress `json:"address,omitempty"`

	// Country: Required. The country of sale where the return address is
	// applicable.
	Country string `json:"country,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#returnAddress"
	Kind string `json:"kind,omitempty"`

	// Label: Required. The user-defined label of the return address. For
	// the default address, use the label "default".
	Label string `json:"label,omitempty"`

	// PhoneNumber: Required. The merchant's contact phone number regarding
	// the return.
	PhoneNumber string `json:"phoneNumber,omitempty"`

	// ReturnAddressId: Return address ID generated by Google.
	ReturnAddressId string `json:"returnAddressId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Address") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Address") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ReturnAddress) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnAddress
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ReturnAddressAddress struct {
	// Country: CLDR country code (e.g. "US").
	Country string `json:"country,omitempty"`

	// Locality: City, town or commune. May also include dependent
	// localities or sublocalities (e.g. neighborhoods or suburbs).
	Locality string `json:"locality,omitempty"`

	// PostalCode: Postal code or ZIP (e.g. "94043").
	PostalCode string `json:"postalCode,omitempty"`

	// RecipientName: Name of the recipient to address returns to.
	RecipientName string `json:"recipientName,omitempty"`

	// Region: Top-level administrative subdivision of the country. For
	// example, a state like California ("CA") or a province like Quebec
	// ("QC").
	Region string `json:"region,omitempty"`

	// StreetAddress: Street-level part of the address. May be up to two
	// lines, each line specified as an array element.
	StreetAddress []string `json:"streetAddress,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Country") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Country") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ReturnAddressAddress) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnAddressAddress
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ReturnPolicy: Return policy resource.
type ReturnPolicy struct {
	// Country: Required. The country of sale where the return policy is
	// applicable.
	Country string `json:"country,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#returnPolicy"
	Kind string `json:"kind,omitempty"`

	// Label: Required. The user-defined label of the return policy. For the
	// default policy, use the label "default".
	Label string `json:"label,omitempty"`

	// Name: Required. The name of the policy as shown in Merchant Center.
	Name string `json:"name,omitempty"`

	// NonFreeReturnReasons: Return reasons that will incur return fees.
	NonFreeReturnReasons []string `json:"nonFreeReturnReasons,omitempty"`

	// Policy: Required. The policy.
	Policy *ReturnPolicyPolicy `json:"policy,omitempty"`

	// ReturnPolicyId: Return policy ID generated by Google.
	ReturnPolicyId string `json:"returnPolicyId,omitempty"`

	// ReturnShippingFee: The return shipping fee that will apply to non
	// free return reasons.
	ReturnShippingFee *Price `json:"returnShippingFee,omitempty"`

	// SeasonalOverrides: An optional list of seasonal overrides.
	SeasonalOverrides []*ReturnPolicySeasonalOverride `json:"seasonalOverrides,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Country") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Country") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ReturnPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ReturnPolicyOnline: Return policy online object. This is currently
// used to represent return policies for ads and free listings programs.
type ReturnPolicyOnline struct {
	// Countries: The countries of sale where the return policy is
	// applicable. The values must be a valid 2 letter ISO 3166 code, e.g.
	// "US".
	Countries []string `json:"countries,omitempty"`

	// ItemConditions: The item conditions that are accepted for returns.
	// This is required to not be empty unless the type of return policy is
	// noReturns.
	//
	// Possible values:
	//   "ITEM_CONDITION_UNSPECIFIED" - Default value. This value is unused.
	//   "NEW" - New.
	//   "USED" - Used.
	ItemConditions []string `json:"itemConditions,omitempty"`

	// Label: The unique user-defined label of the return policy. The same
	// label cannot be used in different return policies for the same
	// country. Policies with the label 'default' will apply to all
	// products, unless a product specifies a return_policy_label attribute.
	Label string `json:"label,omitempty"`

	// Name: The name of the policy as shown in Merchant Center.
	Name string `json:"name,omitempty"`

	// Policy: The return policy.
	Policy *ReturnPolicyOnlinePolicy `json:"policy,omitempty"`

	// RestockingFee: The restocking fee that applies to all return reason
	// categories. This would be treated as a free restocking fee if the
	// value is not set.
	RestockingFee *ReturnPolicyOnlineRestockingFee `json:"restockingFee,omitempty"`

	// ReturnMethods: The return methods of how customers can return an
	// item. This value is required to not be empty unless the type of
	// return policy is noReturns.
	//
	// Possible values:
	//   "RETURN_METHOD_UNSPECIFIED" - Default value. This value is unused.
	//   "BY_MAIL" - By mail.
	//   "IN_STORE" - In store.
	//   "AT_A_KIOSK" - At a kiosk.
	ReturnMethods []string `json:"returnMethods,omitempty"`

	// ReturnPolicyId: Output only. Return policy ID generated by Google.
	ReturnPolicyId string `json:"returnPolicyId,omitempty"`

	// ReturnPolicyUri: The return policy uri. This can used by Google to do
	// a sanity check for the policy.
	ReturnPolicyUri string `json:"returnPolicyUri,omitempty"`

	// ReturnReasonCategoryInfo: The return reason category information.
	// This required to not be empty unless the type of return policy is
	// noReturns.
	ReturnReasonCategoryInfo []*ReturnPolicyOnlineReturnReasonCategoryInfo `json:"returnReasonCategoryInfo,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Countries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Countries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ReturnPolicyOnline) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnPolicyOnline
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ReturnPolicyOnlinePolicy: The available policies.
type ReturnPolicyOnlinePolicy struct {
	// Days: The number of days items can be returned after delivery, where
	// one day is defined to be 24 hours after the delivery timestamp.
	// Required for `numberOfDaysAfterDelivery` returns.
	Days int64 `json:"days,omitempty,string"`

	// Type: Policy type.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Default value. This value is unused.
	//   "NUMBER_OF_DAYS_AFTER_DELIVERY" - Number of days after a return is
	// delivered.
	//   "NO_RETURNS" - No returns.
	//   "LIFETIME_RETURNS" - Life time returns.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Days") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Days") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ReturnPolicyOnlinePolicy) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnPolicyOnlinePolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ReturnPolicyOnlineRestockingFee: The restocking fee. This can either
// be a fixed fee or a micro percent.
type ReturnPolicyOnlineRestockingFee struct {
	// FixedFee: Fixed restocking fee.
	FixedFee *PriceAmount `json:"fixedFee,omitempty"`

	// MicroPercent: Percent of total price in micros. 15,000,000 means 15%
	// of the total price would be charged.
	MicroPercent int64 `json:"microPercent,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FixedFee") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FixedFee") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ReturnPolicyOnlineRestockingFee) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnPolicyOnlineRestockingFee
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ReturnPolicyOnlineReturnReasonCategoryInfo: The return reason
// category info wrapper.
type ReturnPolicyOnlineReturnReasonCategoryInfo struct {
	// ReturnLabelSource: The corresponding return label source.
	//
	// Possible values:
	//   "RETURN_LABEL_SOURCE_UNSPECIFIED" - Default value. This value is
	// unused.
	//   "DOWNLOAD_AND_PRINT" - Download and print the label.
	//   "IN_THE_BOX" - Label in the box.
	//   "CUSTOMER_RESPONSIBILITY" - Customers' responsibility to get the
	// label.
	ReturnLabelSource string `json:"returnLabelSource,omitempty"`

	// ReturnReasonCategory: The return reason category.
	//
	// Possible values:
	//   "RETURN_REASON_CATEGORY_UNSPECIFIED" - Default value. This value is
	// unused.
	//   "BUYER_REMORSE" - Buyer remorse.
	//   "ITEM_DEFECT" - Item defect.
	ReturnReasonCategory string `json:"returnReasonCategory,omitempty"`

	// ReturnShippingFee: The corresponding return shipping fee. This is
	// only applicable when returnLabelSource is not the customer's
	// responsibility.
	ReturnShippingFee *ReturnPolicyOnlineReturnShippingFee `json:"returnShippingFee,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ReturnLabelSource")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ReturnLabelSource") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ReturnPolicyOnlineReturnReasonCategoryInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnPolicyOnlineReturnReasonCategoryInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ReturnPolicyOnlineReturnShippingFee: The return shipping fee. This
// can either be a fixed fee or a boolean to indicate that the customer
// pays the actual shipping cost.
type ReturnPolicyOnlineReturnShippingFee struct {
	// FixedFee: Fixed return shipping fee amount. This value is only
	// applicable when type is FIXED. We will treat the return shipping fee
	// as free if type is FIXED and this value is not set.
	FixedFee *PriceAmount `json:"fixedFee,omitempty"`

	// Type: Type of return shipping fee.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Default value. This value is unused.
	//   "FIXED" - The return shipping fee is a fixed value.
	//   "CUSTOMER_PAYING_ACTUAL_FEE" - Customer will pay the actual return
	// shipping fee.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FixedFee") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FixedFee") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ReturnPolicyOnlineReturnShippingFee) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnPolicyOnlineReturnShippingFee
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ReturnPolicyPolicy struct {
	// LastReturnDate: Required. Last day for returning the items. In ISO
	// 8601 format. When specifying the return window like this, set the
	// policy type to "lastReturnDate". Use this for seasonal overrides
	// only.
	LastReturnDate string `json:"lastReturnDate,omitempty"`

	// NumberOfDays: The number of days items can be returned after
	// delivery, where one day is defined to be 24 hours after the delivery
	// timestamp. When specifying the return window like this, set the
	// policy type to "numberOfDaysAfterDelivery". Acceptable values are 30,
	// 45, 60, 90, 100, 180, 270 and 365 for the default policy. Additional
	// policies further allow 14, 15, 21 and 28 days, but note that for most
	// items a minimum of 30 days is required for returns. Exceptions may be
	// made for electronics. A policy of less than 30 days can only be
	// applied to those items.
	NumberOfDays int64 `json:"numberOfDays,omitempty,string"`

	// Type: Policy type. Use "lastReturnDate" for seasonal overrides only.
	// Note that for most items a minimum of 30 days is required for
	// returns. Exceptions may be made for electronics or non-returnable
	// items such as food, perishables, and living things. A policy of less
	// than 30 days can only be applied to those items. Acceptable values
	// are: - "lastReturnDate" - "lifetimeReturns" - "noReturns" -
	// "numberOfDaysAfterDelivery"
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LastReturnDate") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LastReturnDate") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ReturnPolicyPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnPolicyPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ReturnPolicySeasonalOverride struct {
	// EndDate: Required. Last day on which the override applies. In ISO
	// 8601 format.
	EndDate string `json:"endDate,omitempty"`

	// Name: Required. The name of the seasonal override as shown in
	// Merchant Center.
	Name string `json:"name,omitempty"`

	// Policy: Required. The policy which is in effect during that time.
	Policy *ReturnPolicyPolicy `json:"policy,omitempty"`

	// StartDate: Required. First day on which the override applies. In ISO
	// 8601 format.
	StartDate string `json:"startDate,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EndDate") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndDate") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ReturnPolicySeasonalOverride) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnPolicySeasonalOverride
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ReturnPricingInfo struct {
	// ChargeReturnShippingFee: Default option for whether merchant should
	// charge the customer for return shipping costs, based on customer
	// selected return reason and merchant's return policy for the items
	// being returned.
	ChargeReturnShippingFee bool `json:"chargeReturnShippingFee,omitempty"`

	// MaxReturnShippingFee: Maximum return shipping costs that may be
	// charged to the customer depending on merchant's assessment of the
	// return reason and the merchant's return policy for the items being
	// returned.
	MaxReturnShippingFee *MonetaryAmount `json:"maxReturnShippingFee,omitempty"`

	// RefundableItemsTotalAmount: Total amount that can be refunded for the
	// items in this return. It represents the total amount received by the
	// merchant for the items, after applying merchant coupons.
	RefundableItemsTotalAmount *MonetaryAmount `json:"refundableItemsTotalAmount,omitempty"`

	// RefundableShippingAmount: Maximum amount that can be refunded for the
	// original shipping fee.
	RefundableShippingAmount *MonetaryAmount `json:"refundableShippingAmount,omitempty"`

	// TotalRefundedAmount: Total amount already refunded by the merchant.
	// It includes all types of refunds (items, shipping, etc.) Not provided
	// if no refund has been applied yet.
	TotalRefundedAmount *MonetaryAmount `json:"totalRefundedAmount,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ChargeReturnShippingFee") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ChargeReturnShippingFee")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ReturnPricingInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnPricingInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ReturnShipment struct {
	// CreationDate: The date of creation of the shipment, in ISO 8601
	// format.
	CreationDate string `json:"creationDate,omitempty"`

	// DeliveryDate: The date of delivery of the shipment, in ISO 8601
	// format.
	DeliveryDate string `json:"deliveryDate,omitempty"`

	// ReturnMethodType: Type of the return method. Acceptable values are: -
	// "byMail" - "contactCustomerSupport" - "returnless" -
	// "inStore"
	ReturnMethodType string `json:"returnMethodType,omitempty"`

	// ShipmentId: Shipment ID generated by Google.
	ShipmentId string `json:"shipmentId,omitempty"`

	// ShipmentTrackingInfos: Tracking information of the shipment. One
	// return shipment might be handled by several shipping carriers
	// sequentially.
	ShipmentTrackingInfos []*ShipmentTrackingInfo `json:"shipmentTrackingInfos,omitempty"`

	// ShippingDate: The date of shipping of the shipment, in ISO 8601
	// format.
	ShippingDate string `json:"shippingDate,omitempty"`

	// State: State of the shipment. Acceptable values are: - "completed"
	// - "new" - "shipped" - "undeliverable" - "pending"
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreationDate") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreationDate") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ReturnShipment) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnShipment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ReturnShippingLabel: Return shipping label for a Buy on Google
// merchant-managed return.
type ReturnShippingLabel struct {
	// Carrier: Name of the carrier.
	Carrier string `json:"carrier,omitempty"`

	// LabelUri: The URL for the return shipping label in PDF format
	LabelUri string `json:"labelUri,omitempty"`

	// TrackingId: The tracking id of this return label.
	TrackingId string `json:"trackingId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Carrier") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Carrier") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ReturnShippingLabel) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnShippingLabel
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ReturnaddressCustomBatchRequest struct {
	// Entries: The request entries to be processed in the batch.
	Entries []*ReturnaddressCustomBatchRequestEntry `json:"entries,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Entries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ReturnaddressCustomBatchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnaddressCustomBatchRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ReturnaddressCustomBatchRequestEntry struct {
	// BatchId: An entry ID, unique within the batch request.
	BatchId int64 `json:"batchId,omitempty"`

	// MerchantId: The Merchant Center account ID.
	MerchantId uint64 `json:"merchantId,omitempty,string"`

	// Method: Method of the batch request entry. Acceptable values are: -
	// "delete" - "get" - "insert"
	Method string `json:"method,omitempty"`

	// ReturnAddress: The return address to submit. This should be set only
	// if the method is `insert`.
	ReturnAddress *ReturnAddress `json:"returnAddress,omitempty"`

	// ReturnAddressId: The return address ID. This should be set only if
	// the method is `delete` or `get`.
	ReturnAddressId string `json:"returnAddressId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BatchId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BatchId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ReturnaddressCustomBatchRequestEntry) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnaddressCustomBatchRequestEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ReturnaddressCustomBatchResponse struct {
	// Entries: The result of the execution of the batch requests.
	Entries []*ReturnaddressCustomBatchResponseEntry `json:"entries,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#returnaddressCustomBatchResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Entries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ReturnaddressCustomBatchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnaddressCustomBatchResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ReturnaddressCustomBatchResponseEntry struct {
	// BatchId: The ID of the request entry to which this entry responds.
	BatchId int64 `json:"batchId,omitempty"`

	// Errors: A list of errors defined if, and only if, the request failed.
	Errors *Errors `json:"errors,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#returnaddressCustomBatchResponseEntry"
	Kind string `json:"kind,omitempty"`

	// ReturnAddress: The retrieved return address.
	ReturnAddress *ReturnAddress `json:"returnAddress,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BatchId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BatchId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ReturnaddressCustomBatchResponseEntry) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnaddressCustomBatchResponseEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ReturnaddressListResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#returnaddressListResponse".
	Kind string `json:"kind,omitempty"`

	// NextPageToken: The token for the retrieval of the next page of
	// addresses.
	NextPageToken string `json:"nextPageToken,omitempty"`

	Resources []*ReturnAddress `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ReturnaddressListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnaddressListResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ReturnpolicyCustomBatchRequest struct {
	// Entries: The request entries to be processed in the batch.
	Entries []*ReturnpolicyCustomBatchRequestEntry `json:"entries,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Entries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ReturnpolicyCustomBatchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnpolicyCustomBatchRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ReturnpolicyCustomBatchRequestEntry struct {
	// BatchId: An entry ID, unique within the batch request.
	BatchId int64 `json:"batchId,omitempty"`

	// MerchantId: The Merchant Center account ID.
	MerchantId uint64 `json:"merchantId,omitempty,string"`

	// Method: Method of the batch request entry. Acceptable values are: -
	// "delete" - "get" - "insert"
	Method string `json:"method,omitempty"`

	// ReturnPolicy: The return policy to submit. This should be set only if
	// the method is `insert`.
	ReturnPolicy *ReturnPolicy `json:"returnPolicy,omitempty"`

	// ReturnPolicyId: The return policy ID. This should be set only if the
	// method is `delete` or `get`.
	ReturnPolicyId string `json:"returnPolicyId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BatchId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BatchId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ReturnpolicyCustomBatchRequestEntry) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnpolicyCustomBatchRequestEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ReturnpolicyCustomBatchResponse struct {
	// Entries: The result of the execution of the batch requests.
	Entries []*ReturnpolicyCustomBatchResponseEntry `json:"entries,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#returnpolicyCustomBatchResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Entries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ReturnpolicyCustomBatchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnpolicyCustomBatchResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ReturnpolicyCustomBatchResponseEntry struct {
	// BatchId: The ID of the request entry to which this entry responds.
	BatchId int64 `json:"batchId,omitempty"`

	// Errors: A list of errors defined if, and only if, the request failed.
	Errors *Errors `json:"errors,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#returnpolicyCustomBatchResponseEntry"
	Kind string `json:"kind,omitempty"`

	// ReturnPolicy: The retrieved return policy.
	ReturnPolicy *ReturnPolicy `json:"returnPolicy,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BatchId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BatchId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ReturnpolicyCustomBatchResponseEntry) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnpolicyCustomBatchResponseEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ReturnpolicyListResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#returnpolicyListResponse".
	Kind string `json:"kind,omitempty"`

	Resources []*ReturnPolicy `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ReturnpolicyListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnpolicyListResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type Row struct {
	// Cells: The list of cells that constitute the row. Must have the same
	// length as `columnHeaders` for two-dimensional tables, a length of 1
	// for one-dimensional tables. Required.
	Cells []*Value `json:"cells,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Cells") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cells") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Row) MarshalJSON() ([]byte, error) {
	type NoMethod Row
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SearchRequest: Request message for the ReportService.Search method.
type SearchRequest struct {
	// PageSize: Number of ReportRows to retrieve in a single page. Defaults
	// to the maximum of 1000. Values above 1000 are coerced to 1000.
	PageSize int64 `json:"pageSize,omitempty"`

	// PageToken: Token of the page to retrieve. If not specified, the first
	// page of results is returned. In order to request the next page of
	// results, the value obtained from `next_page_token` in the previous
	// response should be used.
	PageToken string `json:"pageToken,omitempty"`

	// Query: Required. Query that defines performance metrics to retrieve
	// and dimensions according to which the metrics are to be segmented.
	// For details on how to construct your query, see the Query Language
	// guide
	// (https://developers.google.com/shopping-content/guides/reports/query-language/overview).
	Query string `json:"query,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PageSize") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PageSize") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SearchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SearchRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SearchResponse: Response message for the ReportService.Search method.
type SearchResponse struct {
	// NextPageToken: Token which can be sent as `page_token` to retrieve
	// the next page. If omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Results: Rows that matched the search query.
	Results []*ReportRow `json:"results,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SearchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SearchResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Segments: Dimensions according to which metrics are segmented in the
// response. Values of product dimensions, e.g., offer id, reflect the
// state of a product at the time of the corresponding event, e.g.,
// impression or order. Segment fields cannot be selected in queries
// without also selecting at least one metric field. Values are only set
// for dimensions requested explicitly in the request's search query.
type Segments struct {
	// Brand: Brand of the product.
	Brand string `json:"brand,omitempty"`

	// CategoryL1: Product category (1st level)
	// (https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in Google's product taxonomy.
	CategoryL1 string `json:"categoryL1,omitempty"`

	// CategoryL2: Product category (2nd level)
	// (https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in Google's product taxonomy.
	CategoryL2 string `json:"categoryL2,omitempty"`

	// CategoryL3: Product category (3rd level)
	// (https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in Google's product taxonomy.
	CategoryL3 string `json:"categoryL3,omitempty"`

	// CategoryL4: Product category (4th level)
	// (https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in Google's product taxonomy.
	CategoryL4 string `json:"categoryL4,omitempty"`

	// CategoryL5: Product category (5th level)
	// (https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in Google's product taxonomy.
	CategoryL5 string `json:"categoryL5,omitempty"`

	// CurrencyCode: Currency in which price metrics are represented, e.g.,
	// if you select `ordered_item_sales_micros`, the returned value will be
	// represented by this currency.
	CurrencyCode string `json:"currencyCode,omitempty"`

	// CustomLabel0: Custom label 0 for custom grouping of products.
	CustomLabel0 string `json:"customLabel0,omitempty"`

	// CustomLabel1: Custom label 1 for custom grouping of products.
	CustomLabel1 string `json:"customLabel1,omitempty"`

	// CustomLabel2: Custom label 2 for custom grouping of products.
	CustomLabel2 string `json:"customLabel2,omitempty"`

	// CustomLabel3: Custom label 3 for custom grouping of products.
	CustomLabel3 string `json:"customLabel3,omitempty"`

	// CustomLabel4: Custom label 4 for custom grouping of products.
	CustomLabel4 string `json:"customLabel4,omitempty"`

	// Date: Date in the merchant timezone to which metrics apply.
	Date *Date `json:"date,omitempty"`

	// OfferId: Merchant-provided id of the product.
	OfferId string `json:"offerId,omitempty"`

	// ProductTypeL1: Product type (1st level)
	// (https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in merchant's own product taxonomy.
	ProductTypeL1 string `json:"productTypeL1,omitempty"`

	// ProductTypeL2: Product type (2nd level)
	// (https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in merchant's own product taxonomy.
	ProductTypeL2 string `json:"productTypeL2,omitempty"`

	// ProductTypeL3: Product type (3rd level)
	// (https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in merchant's own product taxonomy.
	ProductTypeL3 string `json:"productTypeL3,omitempty"`

	// ProductTypeL4: Product type (4th level)
	// (https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in merchant's own product taxonomy.
	ProductTypeL4 string `json:"productTypeL4,omitempty"`

	// ProductTypeL5: Product type (5th level)
	// (https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in merchant's own product taxonomy.
	ProductTypeL5 string `json:"productTypeL5,omitempty"`

	// Program: Program to which metrics apply, e.g., Free Product Listing.
	//
	// Possible values:
	//   "PROGRAM_UNSPECIFIED" - Not specified.
	//   "SHOPPING_ADS" - Shopping Ads.
	//   "FREE_PRODUCT_LISTING" - Free Product Listing.
	//   "FREE_LOCAL_PRODUCT_LISTING" - Free Local Product Listing.
	//   "BUY_ON_GOOGLE_LISTING" - Buy on Google Listing.
	Program string `json:"program,omitempty"`

	// Title: Title of the product.
	Title string `json:"title,omitempty"`

	// Week: First day of the week (Monday) of the metrics date in the
	// merchant timezone.
	Week *Date `json:"week,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Brand") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Brand") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Segments) MarshalJSON() ([]byte, error) {
	type NoMethod Segments
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type Service struct {
	// Active: A boolean exposing the active status of the shipping service.
	// Required.
	Active bool `json:"active,omitempty"`

	// Currency: The CLDR code of the currency to which this service
	// applies. Must match that of the prices in rate groups.
	Currency string `json:"currency,omitempty"`

	// DeliveryCountry: The CLDR territory code of the country to which the
	// service applies. Required.
	DeliveryCountry string `json:"deliveryCountry,omitempty"`

	// DeliveryTime: Time spent in various aspects from order to the
	// delivery of the product. Required.
	DeliveryTime *DeliveryTime `json:"deliveryTime,omitempty"`

	// Eligibility: Eligibility for this service. Acceptable values are: -
	// "All scenarios" - "All scenarios except Shopping Actions" -
	// "Shopping Actions"
	Eligibility string `json:"eligibility,omitempty"`

	// MinimumOrderValue: Minimum order value for this service. If set,
	// indicates that customers will have to spend at least this amount. All
	// prices within a service must have the same currency. Cannot be set
	// together with minimum_order_value_table.
	MinimumOrderValue *Price `json:"minimumOrderValue,omitempty"`

	// MinimumOrderValueTable: Table of per store minimum order values for
	// the pickup fulfillment type. Cannot be set together with
	// minimum_order_value.
	MinimumOrderValueTable *MinimumOrderValueTable `json:"minimumOrderValueTable,omitempty"`

	// Name: Free-form name of the service. Must be unique within target
	// account. Required.
	Name string `json:"name,omitempty"`

	// PickupService: The carrier-service pair delivering items to
	// collection points. The list of supported pickup services can be
	// retrieved via the `getSupportedPickupServices` method. Required if
	// and only if the service delivery type is `pickup`.
	PickupService *PickupCarrierService `json:"pickupService,omitempty"`

	// RateGroups: Shipping rate group definitions. Only the last one is
	// allowed to have an empty `applicableShippingLabels`, which means
	// "everything else". The other `applicableShippingLabels` must not
	// overlap.
	RateGroups []*RateGroup `json:"rateGroups,omitempty"`

	// ShipmentType: Type of locations this service ships orders to.
	// Acceptable values are: - "delivery" - "pickup"
	ShipmentType string `json:"shipmentType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Active") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Active") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Service) MarshalJSON() ([]byte, error) {
	type NoMethod Service
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SettlementReport:  Settlement reports detail order-level and
// item-level credits and debits between you and Google.
type SettlementReport struct {
	// EndDate: The end date on which all transactions are included in the
	// report, in ISO 8601 format.
	EndDate string `json:"endDate,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#settlementReport"
	Kind string `json:"kind,omitempty"`

	// PreviousBalance: The residual amount from the previous invoice. This
	// is set only if the previous invoices are not paid because of negative
	// balance.
	PreviousBalance *Price `json:"previousBalance,omitempty"`

	// SettlementId: The ID of the settlement report.
	SettlementId string `json:"settlementId,omitempty"`

	// StartDate: The start date on which all transactions are included in
	// the report, in ISO 8601 format.
	StartDate string `json:"startDate,omitempty"`

	// TransferAmount: The money due to the merchant.
	TransferAmount *Price `json:"transferAmount,omitempty"`

	// TransferDate: Date on which transfer for this payment was initiated
	// by Google, in ISO 8601 format.
	TransferDate string `json:"transferDate,omitempty"`

	// TransferIds: The list of bank identifiers used for the transfer. e.g.
	// Trace ID for Federal Automated Clearing House (ACH). This may also be
	// known as the Wire ID.
	TransferIds []string `json:"transferIds,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "EndDate") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndDate") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SettlementReport) MarshalJSON() ([]byte, error) {
	type NoMethod SettlementReport
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SettlementTransaction: Settlement transactions give a detailed
// breakdown of the settlement report.
type SettlementTransaction struct {
	// Amount: The amount for the transaction.
	Amount *SettlementTransactionAmount `json:"amount,omitempty"`

	// Identifiers: Identifiers of the transaction.
	Identifiers *SettlementTransactionIdentifiers `json:"identifiers,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#settlementTransaction"
	Kind string `json:"kind,omitempty"`

	// Transaction: Details of the transaction.
	Transaction *SettlementTransactionTransaction `json:"transaction,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Amount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Amount") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SettlementTransaction) MarshalJSON() ([]byte, error) {
	type NoMethod SettlementTransaction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type SettlementTransactionAmount struct {
	Commission *SettlementTransactionAmountCommission `json:"commission,omitempty"`

	// Description: The description of the event. Acceptable values are: -
	// "taxWithhold" - "principal" - "principalAdjustment" -
	// "shippingFee" - "merchantRemittedSalesTax" -
	// "googleRemittedSalesTax" - "merchantCoupon" -
	// "merchantCouponTax" - "merchantRemittedDisposalTax" -
	// "googleRemittedDisposalTax" - "merchantRemittedRedemptionFee" -
	// "googleRemittedRedemptionFee" - "eeeEcoFee" - "furnitureEcoFee"
	// - "copyPrivateFee" - "eeeEcoFeeCommission" -
	// "furnitureEcoFeeCommission" - "copyPrivateFeeCommission" -
	// "principalRefund" - "principalRefundTax" - "itemCommission" -
	// "adjustmentCommission" - "shippingFeeCommission" -
	// "commissionRefund" - "damaged" - "damagedOrDefectiveItem" -
	// "expiredItem" - "faultyItem" - "incorrectItemReceived" -
	// "itemMissing" - "qualityNotExpected" - "receivedTooLate" -
	// "storePackageMissing" - "transitPackageMissing" -
	// "unsuccessfulDeliveryUndeliverable" - "wrongChargeInStore" -
	// "wrongItem" - "returns" - "undeliverable" -
	// "issueRelatedRefundAndReplacementAmountDescription" -
	// "refundFromMerchant" - "returnLabelShippingFee" -
	// "lumpSumCorrection" - "pspFee" - "principalRefundDoesNotFit" -
	// "principalRefundOrderedWrongItem" -
	// "principalRefundQualityNotExpected" -
	// "principalRefundBetterPriceFound" -
	// "principalRefundNoLongerNeeded" - "principalRefundChangedMind" -
	// "principalRefundReceivedTooLate" -
	// "principalRefundIncorrectItemReceived" -
	// "principalRefundDamagedOrDefectiveItem" -
	// "principalRefundDidNotMatchDescription" -
	// "principalRefundExpiredItem"
	Description string `json:"description,omitempty"`

	// TransactionAmount: The amount that contributes to the line item
	// price.
	TransactionAmount *Price `json:"transactionAmount,omitempty"`

	// Type: The type of the amount. Acceptable values are: - "itemPrice"
	// - "orderPrice" - "refund" - "earlyRefund" - "courtesyRefund"
	// - "returnRefund" - "returnLabelShippingFeeAmount" -
	// "lumpSumCorrectionAmount"
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Commission") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Commission") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SettlementTransactionAmount) MarshalJSON() ([]byte, error) {
	type NoMethod SettlementTransactionAmount
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type SettlementTransactionAmountCommission struct {
	// Category: The category of the commission. Acceptable values are: -
	// "animalsAndPetSupplies" - "dogCatFoodAndCatLitter" -
	// "apparelAndAccessories" - "shoesHandbagsAndSunglasses" -
	// "costumesAndAccessories" - "jewelry" - "watches" -
	// "hobbiesArtsAndCrafts" - "homeAndGarden" -
	// "entertainmentCollectibles" - "collectibleCoins" -
	// "sportsCollectibles" - "sportingGoods" - "toysAndGames" -
	// "musicalInstruments" - "giftCards" - "babyAndToddler" -
	// "babyFoodWipesAndDiapers" - "businessAndIndustrial" -
	// "camerasOpticsAndPhotography" - "consumerElectronics" -
	// "electronicsAccessories" - "personalComputers" -
	// "videoGameConsoles" - "foodAndGrocery" - "beverages" -
	// "tobaccoProducts" - "furniture" - "hardware" -
	// "buildingMaterials" - "tools" - "healthAndPersonalCare" -
	// "beauty" - "householdSupplies" - "kitchenAndDining" -
	// "majorAppliances" - "luggageAndBags" - "media" -
	// "officeSupplies" - "softwareAndVideoGames" -
	// "vehiclePartsAndAccessories" - "vehicleTiresAndWheels" -
	// "vehicles" - "everythingElse"
	Category string `json:"category,omitempty"`

	// Rate: Rate of the commission in percentage.
	Rate string `json:"rate,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Category") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Category") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SettlementTransactionAmountCommission) MarshalJSON() ([]byte, error) {
	type NoMethod SettlementTransactionAmountCommission
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type SettlementTransactionIdentifiers struct {
	// AdjustmentId: The identifier of the adjustments, if it is available.
	AdjustmentId string `json:"adjustmentId,omitempty"`

	// MerchantOrderId: The merchant provided order ID.
	MerchantOrderId string `json:"merchantOrderId,omitempty"`

	// OrderItemId: The identifier of the item.
	OrderItemId string `json:"orderItemId,omitempty"`

	// SettlementEntryId: The unique ID of the settlement transaction entry.
	SettlementEntryId string `json:"settlementEntryId,omitempty"`

	// ShipmentIds: The shipment ids for the item.
	ShipmentIds []string `json:"shipmentIds,omitempty"`

	// TransactionId: The Google transaction ID.
	TransactionId string `json:"transactionId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdjustmentId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdjustmentId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SettlementTransactionIdentifiers) MarshalJSON() ([]byte, error) {
	type NoMethod SettlementTransactionIdentifiers
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type SettlementTransactionTransaction struct {
	// PostDate: The time on which the event occurred in ISO 8601 format.
	PostDate string `json:"postDate,omitempty"`

	// Type: The type of the transaction that occurred. Acceptable values
	// are: - "order" - "reversal" - "orderRefund" -
	// "reversalRefund" - "issueRelatedRefundAndReplacement" -
	// "returnLabelShippingFeeTransaction" -
	// "reversalIssueRelatedRefundAndReplacement" -
	// "reversalReturnLabelShippingFeeTransaction" -
	// "lumpSumCorrectionTransaction"
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PostDate") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PostDate") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SettlementTransactionTransaction) MarshalJSON() ([]byte, error) {
	type NoMethod SettlementTransactionTransaction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type SettlementreportsListResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#settlementreportsListResponse".
	Kind string `json:"kind,omitempty"`

	// NextPageToken: The token for the retrieval of the next page of
	// returns.
	NextPageToken string `json:"nextPageToken,omitempty"`

	Resources []*SettlementReport `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SettlementreportsListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SettlementreportsListResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type SettlementtransactionsListResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#settlementtransactionsListResponse".
	Kind string `json:"kind,omitempty"`

	// NextPageToken: The token for the retrieval of the next page of
	// returns.
	NextPageToken string `json:"nextPageToken,omitempty"`

	Resources []*SettlementTransaction `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SettlementtransactionsListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SettlementtransactionsListResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ShipmentInvoice struct {
	// InvoiceSummary: [required] Invoice summary.
	InvoiceSummary *InvoiceSummary `json:"invoiceSummary,omitempty"`

	// LineItemInvoices: [required] Invoice details per line item.
	LineItemInvoices []*ShipmentInvoiceLineItemInvoice `json:"lineItemInvoices,omitempty"`

	// ShipmentGroupId: [required] ID of the shipment group. It is assigned
	// by the merchant in the `shipLineItems` method and is used to group
	// multiple line items that have the same kind of shipping charges.
	ShipmentGroupId string `json:"shipmentGroupId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "InvoiceSummary") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "InvoiceSummary") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ShipmentInvoice) MarshalJSON() ([]byte, error) {
	type NoMethod ShipmentInvoice
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ShipmentInvoiceLineItemInvoice struct {
	// LineItemId: ID of the line item. Either lineItemId or productId must
	// be set.
	LineItemId string `json:"lineItemId,omitempty"`

	// ProductId: ID of the product. This is the REST ID used in the
	// products service. Either lineItemId or productId must be set.
	ProductId string `json:"productId,omitempty"`

	// ShipmentUnitIds: [required] The shipment unit ID is assigned by the
	// merchant and defines individual quantities within a line item. The
	// same ID can be assigned to units that are the same while units that
	// differ must be assigned a different ID (for example: free or
	// promotional units).
	ShipmentUnitIds []string `json:"shipmentUnitIds,omitempty"`

	// UnitInvoice: [required] Invoice details for a single unit.
	UnitInvoice *UnitInvoice `json:"unitInvoice,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LineItemId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LineItemId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ShipmentInvoiceLineItemInvoice) MarshalJSON() ([]byte, error) {
	type NoMethod ShipmentInvoiceLineItemInvoice
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ShipmentTrackingInfo struct {
	// Carrier: The shipping carrier that handles the package. Acceptable
	// values are: - "boxtal" - "bpost" - "chronopost" -
	// "colisPrive" - "colissimo" - "cxt" - "deliv" - "dhl" -
	// "dpd" - "dynamex" - "eCourier" - "easypost" - "efw" -
	// "fedex" - "fedexSmartpost" - "geodis" - "gls" -
	// "googleCourier" - "gsx" - "jdLogistics" - "laPoste" -
	// "lasership" - "manual" - "mpx" - "onTrac" - "other" -
	// "tnt" - "uds" - "ups" - "usps"
	Carrier string `json:"carrier,omitempty"`

	// TrackingNumber: The tracking number for the package.
	TrackingNumber string `json:"trackingNumber,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Carrier") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Carrier") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ShipmentTrackingInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ShipmentTrackingInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ShippingSettings: The merchant account's shipping settings. All
// methods except getsupportedcarriers and getsupportedholidays require
// the admin role.
type ShippingSettings struct {
	// AccountId: The ID of the account to which these account shipping
	// settings belong. Ignored upon update, always present in get request
	// responses.
	AccountId uint64 `json:"accountId,omitempty,string"`

	// PostalCodeGroups: A list of postal code groups that can be referred
	// to in `services`. Optional.
	PostalCodeGroups []*PostalCodeGroup `json:"postalCodeGroups,omitempty"`

	// Services: The target account's list of services. Optional.
	Services []*Service `json:"services,omitempty"`

	// Warehouses: Optional. A list of warehouses which can be referred to
	// in `services`.
	Warehouses []*Warehouse `json:"warehouses,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AccountId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccountId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ShippingSettings) MarshalJSON() ([]byte, error) {
	type NoMethod ShippingSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ShippingsettingsCustomBatchRequest struct {
	// Entries: The request entries to be processed in the batch.
	Entries []*ShippingsettingsCustomBatchRequestEntry `json:"entries,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Entries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ShippingsettingsCustomBatchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ShippingsettingsCustomBatchRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ShippingsettingsCustomBatchRequestEntry: A batch entry encoding a
// single non-batch shippingsettings request.
type ShippingsettingsCustomBatchRequestEntry struct {
	// AccountId: The ID of the account for which to get/update account
	// shipping settings.
	AccountId uint64 `json:"accountId,omitempty,string"`

	// BatchId: An entry ID, unique within the batch request.
	BatchId int64 `json:"batchId,omitempty"`

	// MerchantId: The ID of the managing account.
	MerchantId uint64 `json:"merchantId,omitempty,string"`

	// Method: The method of the batch entry. Acceptable values are: -
	// "get" - "update"
	Method string `json:"method,omitempty"`

	// ShippingSettings: The account shipping settings to update. Only
	// defined if the method is `update`.
	ShippingSettings *ShippingSettings `json:"shippingSettings,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccountId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccountId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ShippingsettingsCustomBatchRequestEntry) MarshalJSON() ([]byte, error) {
	type NoMethod ShippingsettingsCustomBatchRequestEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ShippingsettingsCustomBatchResponse struct {
	// Entries: The result of the execution of the batch requests.
	Entries []*ShippingsettingsCustomBatchResponseEntry `json:"entries,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#shippingsettingsCustomBatchResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Entries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ShippingsettingsCustomBatchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ShippingsettingsCustomBatchResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ShippingsettingsCustomBatchResponseEntry: A batch entry encoding a
// single non-batch shipping settings response.
type ShippingsettingsCustomBatchResponseEntry struct {
	// BatchId: The ID of the request entry to which this entry responds.
	BatchId int64 `json:"batchId,omitempty"`

	// Errors: A list of errors defined if, and only if, the request failed.
	Errors *Errors `json:"errors,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#shippingsettingsCustomBatchResponseEntry"
	Kind string `json:"kind,omitempty"`

	// ShippingSettings: The retrieved or updated account shipping settings.
	ShippingSettings *ShippingSettings `json:"shippingSettings,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BatchId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BatchId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ShippingsettingsCustomBatchResponseEntry) MarshalJSON() ([]byte, error) {
	type NoMethod ShippingsettingsCustomBatchResponseEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ShippingsettingsGetSupportedCarriersResponse struct {
	// Carriers: A list of supported carriers. May be empty.
	Carriers []*CarriersCarrier `json:"carriers,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#shippingsettingsGetSupportedCarriersResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Carriers") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Carriers") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ShippingsettingsGetSupportedCarriersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ShippingsettingsGetSupportedCarriersResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ShippingsettingsGetSupportedHolidaysResponse struct {
	// Holidays: A list of holidays applicable for delivery guarantees. May
	// be empty.
	Holidays []*HolidaysHoliday `json:"holidays,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#shippingsettingsGetSupportedHolidaysResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Holidays") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Holidays") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ShippingsettingsGetSupportedHolidaysResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ShippingsettingsGetSupportedHolidaysResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ShippingsettingsGetSupportedPickupServicesResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string
	// "content#shippingsettingsGetSupportedPickupServicesResponse".
	Kind string `json:"kind,omitempty"`

	// PickupServices: A list of supported pickup services. May be empty.
	PickupServices []*PickupServicesPickupService `json:"pickupServices,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ShippingsettingsGetSupportedPickupServicesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ShippingsettingsGetSupportedPickupServicesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ShippingsettingsListResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#shippingsettingsListResponse".
	Kind string `json:"kind,omitempty"`

	// NextPageToken: The token for the retrieval of the next page of
	// shipping settings.
	NextPageToken string `json:"nextPageToken,omitempty"`

	Resources []*ShippingSettings `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ShippingsettingsListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ShippingsettingsListResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ShoppingAdsProgramStatus: Response message for
// GetShoppingAdsProgramStatus.
type ShoppingAdsProgramStatus struct {
	// RegionStatuses: Status of the program in each region. Regions with
	// the same status and review eligibility are grouped together in
	// `regionCodes`.
	RegionStatuses []*ShoppingAdsProgramStatusRegionStatus `json:"regionStatuses,omitempty"`

	// State: If program is successfully onboarded for at least one region.
	//
	// Possible values:
	//   "PROGRAM_STATE_UNSPECIFIED" - State is not known.
	//   "ONBOARDED" - Program is onboarded for at least one country.
	//   "NOT_ONBOARDED" - Program is not onboarded for any country.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "RegionStatuses") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RegionStatuses") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ShoppingAdsProgramStatus) MarshalJSON() ([]byte, error) {
	type NoMethod ShoppingAdsProgramStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ShoppingAdsProgramStatusRegionStatus: Status of program and region.
type ShoppingAdsProgramStatusRegionStatus struct {
	// DisapprovalDate: Date by which `eligibility_status` will go from
	// `WARNING` to `DISAPPROVED`. It will be present when
	// `eligibility_status` is `WARNING`. Date will be provided in ISO 8601
	// (https://en.wikipedia.org/wiki/ISO_8601) format i.e. YYYY-MM-DD
	DisapprovalDate string `json:"disapprovalDate,omitempty"`

	// EligibilityStatus: Eligibility status of the Shopping Ads program.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State is not known.
	//   "APPROVED" - If the account has no issues and review is completed
	// successfully.
	//   "DISAPPROVED" - There are one or more issues that needs to be
	// resolved for account to be active for the program. Detailed list of
	// account issues are available in
	// [accountstatuses](https://developers.google.com/shopping-content/refer
	// ence/rest/v2.1/accountstatuses) API.
	//   "WARNING" - If account has issues but offers are servable. Some of
	// the issue can make account DISAPPROVED after a certain deadline.
	//   "UNDER_REVIEW" - Account is under review.
	//   "PENDING_REVIEW" - Account is waiting for review to start.
	//   "ONBOARDING" - Program is currently onboarding.
	EligibilityStatus string `json:"eligibilityStatus,omitempty"`

	// IneligibilityReason: Reason if a program in a given country is not
	// eligible for review. Populated only if `review_eligibility_status` is
	// `INELIGIBLE`.
	IneligibilityReason string `json:"ineligibilityReason,omitempty"`

	// RegionCodes: The two-letter ISO 3166-1 alpha-2
	// (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) codes for all the
	// regions with the same `eligibilityStatus` and `reviewEligibility`.
	RegionCodes []string `json:"regionCodes,omitempty"`

	// ReviewEligibilityStatus: If a program in a given country is eligible
	// for review. It will be present only if eligibility status is
	// `DISAPPROVED`.
	//
	// Possible values:
	//   "REVIEW_ELIGIBILITY_UNSPECIFIED" - Review eligibility state is
	// unknown.
	//   "ELIGIBLE" - Account for a region code is eligible for review.
	//   "INELIGIBLE" - Account for a region code is not eligible for
	// review.
	ReviewEligibilityStatus string `json:"reviewEligibilityStatus,omitempty"`

	// ReviewIssues: These issues will be evaluated in review process. Fix
	// all the issues before requesting the review.
	ReviewIssues []string `json:"reviewIssues,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisapprovalDate") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisapprovalDate") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ShoppingAdsProgramStatusRegionStatus) MarshalJSON() ([]byte, error) {
	type NoMethod ShoppingAdsProgramStatusRegionStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type Table struct {
	// ColumnHeaders: Headers of the table's columns. Optional: if not set
	// then the table has only one dimension.
	ColumnHeaders *Headers `json:"columnHeaders,omitempty"`

	// Name: Name of the table. Required for subtables, ignored for the main
	// table.
	Name string `json:"name,omitempty"`

	// RowHeaders: Headers of the table's rows. Required.
	RowHeaders *Headers `json:"rowHeaders,omitempty"`

	// Rows: The list of rows that constitute the table. Must have the same
	// length as `rowHeaders`. Required.
	Rows []*Row `json:"rows,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ColumnHeaders") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ColumnHeaders") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Table) MarshalJSON() ([]byte, error) {
	type NoMethod Table
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type TestOrder struct {
	// DeliveryDetails: Overrides the predefined delivery details if
	// provided.
	DeliveryDetails *TestOrderDeliveryDetails `json:"deliveryDetails,omitempty"`

	// EnableOrderinvoices: Whether the orderinvoices service should support
	// this order.
	EnableOrderinvoices bool `json:"enableOrderinvoices,omitempty"`

	// Kind: Identifies what kind of resource this is. Value: the fixed
	// string "content#testOrder"
	Kind string `json:"kind,omitempty"`

	// LineItems: Required. Line items that are ordered. At least one line
	// item must be provided.
	LineItems []*TestOrderLineItem `json:"lineItems,omitempty"`

	// NotificationMode: Restricted. Do not use.
	NotificationMode string `json:"notificationMode,omitempty"`

	// PickupDetails: Overrides the predefined pickup details if provided.
	PickupDetails *TestOrderPickupDetails `json:"pickupDetails,omitempty"`

	// PredefinedBillingAddress: Required. The billing address. Acceptable
	// values are: - "dwight" - "jim" - "pam"
	PredefinedBillingAddress string `json:"predefinedBillingAddress,omitempty"`

	// PredefinedDeliveryAddress: Required. Identifier of one of the
	// predefined delivery addresses for the delivery. Acceptable values
	// are: - "dwight" - "jim" - "pam"
	PredefinedDeliveryAddress string `json:"predefinedDeliveryAddress,omitempty"`

	// PredefinedEmail: Required. Email address of the customer. Acceptable
	// values are: - "pog.dwight.schrute@gmail.com" -
	// "pog.jim.halpert@gmail.com" - "penpog.pam.beesly@gmail.comding"
	PredefinedEmail string `json:"predefinedEmail,omitempty"`

	// PredefinedPickupDetails: Identifier of one of the predefined pickup
	// details. Required for orders containing line items with shipping type
	// `pickup`. Acceptable values are: - "dwight" - "jim" - "pam"
	PredefinedPickupDetails string `json:"predefinedPickupDetails,omitempty"`

	// Promotions: Promotions associated with the order.
	Promotions []*OrderPromotion `json:"promotions,omitempty"`

	// ShippingCost: Required. The price of shipping for all items. Shipping
	// tax is automatically calculated for orders where marketplace
	// facilitator tax laws are applicable. Otherwise, tax settings from
	// Merchant Center are applied. Note that shipping is not taxed in
	// certain states.
	ShippingCost *Price `json:"shippingCost,omitempty"`

	// ShippingOption: Required. The requested shipping option. Acceptable
	// values are: - "economy" - "expedited" - "oneDay" - "sameDay"
	// - "standard" - "twoDay"
	ShippingOption string `json:"shippingOption,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeliveryDetails") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeliveryDetails") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *TestOrder) MarshalJSON() ([]byte, error) {
	type NoMethod TestOrder
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type TestOrderAddress struct {
	// Country: CLDR country code (e.g. "US").
	Country string `json:"country,omitempty"`

	// FullAddress: Strings representing the lines of the printed label for
	// mailing the order, for example: John Smith 1600 Amphitheatre Parkway
	// Mountain View, CA, 94043 United States
	FullAddress []string `json:"fullAddress,omitempty"`

	// IsPostOfficeBox: Whether the address is a post office box.
	IsPostOfficeBox bool `json:"isPostOfficeBox,omitempty"`

	// Locality: City, town or commune. May also include dependent
	// localities or sublocalities (e.g. neighborhoods or suburbs).
	Locality string `json:"locality,omitempty"`

	// PostalCode: Postal Code or ZIP (e.g. "94043").
	PostalCode string `json:"postalCode,omitempty"`

	// RecipientName: Name of the recipient.
	RecipientName string `json:"recipientName,omitempty"`

	// Region: Top-level administrative subdivision of the country. For
	// example, a state like California ("CA") or a province like Quebec
	// ("QC").
	Region string `json:"region,omitempty"`

	// StreetAddress: Street-level part of the address.
	StreetAddress []string `json:"streetAddress,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Country") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Country") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *TestOrderAddress) MarshalJSON() ([]byte, error) {
	type NoMethod TestOrderAddress
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type TestOrderDeliveryDetails struct {
	// Address: The delivery address
	Address *TestOrderAddress `json:"address,omitempty"`

	// IsScheduledDelivery: Whether the order is scheduled delivery order.
	IsScheduledDelivery bool `json:"isScheduledDelivery,omitempty"`

	// PhoneNumber: The phone number of the person receiving the delivery.
	PhoneNumber string `json:"phoneNumber,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Address") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Address") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *TestOrderDeliveryDetails) MarshalJSON() ([]byte, error) {
	type NoMethod TestOrderDeliveryDetails
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type TestOrderLineItem struct {
	// Product: Required. Product data from the time of the order placement.
	Product *TestOrderLineItemProduct `json:"product,omitempty"`

	// QuantityOrdered: Required. Number of items ordered.
	QuantityOrdered int64 `json:"quantityOrdered,omitempty"`

	// ReturnInfo: Required. Details of the return policy for the line item.
	ReturnInfo *OrderLineItemReturnInfo `json:"returnInfo,omitempty"`

	// ShippingDetails: Required. Details of the requested shipping for the
	// line item.
	ShippingDetails *OrderLineItemShippingDetails `json:"shippingDetails,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Product") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Product") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *TestOrderLineItem) MarshalJSON() ([]byte, error) {
	type NoMethod TestOrderLineItem
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type TestOrderLineItemProduct struct {
	// Brand: Required. Brand of the item.
	Brand string `json:"brand,omitempty"`

	// Condition: Required. Condition or state of the item. Acceptable
	// values are: - "new"
	Condition string `json:"condition,omitempty"`

	// ContentLanguage: Required. The two-letter ISO 639-1 language code for
	// the item. Acceptable values are: - "en" - "fr"
	ContentLanguage string `json:"contentLanguage,omitempty"`

	// Fees: Fees for the item. Optional.
	Fees []*OrderLineItemProductFee `json:"fees,omitempty"`

	// Gtin: Global Trade Item Number (GTIN) of the item. Optional.
	Gtin string `json:"gtin,omitempty"`

	// ImageLink: Required. URL of an image of the item.
	ImageLink string `json:"imageLink,omitempty"`

	// ItemGroupId: Shared identifier for all variants of the same product.
	// Optional.
	ItemGroupId string `json:"itemGroupId,omitempty"`

	// Mpn: Manufacturer Part Number (MPN) of the item. Optional.
	Mpn string `json:"mpn,omitempty"`

	// OfferId: Required. An identifier of the item.
	OfferId string `json:"offerId,omitempty"`

	// Price: Required. The price for the product. Tax is automatically
	// calculated for orders where marketplace facilitator tax laws are
	// applicable. Otherwise, tax settings from Merchant Center are applied.
	Price *Price `json:"price,omitempty"`

	// TargetCountry: Required. The CLDR territory // code of the target
	// country of the product.
	TargetCountry string `json:"targetCountry,omitempty"`

	// Title: Required. The title of the product.
	Title string `json:"title,omitempty"`

	// VariantAttributes: Variant attributes for the item. Optional.
	VariantAttributes []*OrderLineItemProductVariantAttribute `json:"variantAttributes,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Brand") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Brand") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *TestOrderLineItemProduct) MarshalJSON() ([]byte, error) {
	type NoMethod TestOrderLineItemProduct
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type TestOrderPickupDetails struct {
	// LocationCode: Required. Code of the location defined by provider or
	// merchant.
	LocationCode string `json:"locationCode,omitempty"`

	// PickupLocationAddress: Required. Pickup location address.
	PickupLocationAddress *TestOrderAddress `json:"pickupLocationAddress,omitempty"`

	// PickupLocationType: Pickup location type. Acceptable values are: -
	// "locker" - "store" - "curbside"
	PickupLocationType string `json:"pickupLocationType,omitempty"`

	// PickupPersons: Required. all pickup persons set by users.
	PickupPersons []*TestOrderPickupDetailsPickupPerson `json:"pickupPersons,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LocationCode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LocationCode") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *TestOrderPickupDetails) MarshalJSON() ([]byte, error) {
	type NoMethod TestOrderPickupDetails
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type TestOrderPickupDetailsPickupPerson struct {
	// Name: Required. Full name of the pickup person.
	Name string `json:"name,omitempty"`

	// PhoneNumber: Required. The phone number of the person picking up the
	// items.
	PhoneNumber string `json:"phoneNumber,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *TestOrderPickupDetailsPickupPerson) MarshalJSON() ([]byte, error) {
	type NoMethod TestOrderPickupDetailsPickupPerson
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// TimePeriod: A message that represents a time period.
type TimePeriod struct {
	// EndTime: The ending timestamp.
	EndTime string `json:"endTime,omitempty"`

	// StartTime: The starting timestamp.
	StartTime string `json:"startTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EndTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *TimePeriod) MarshalJSON() ([]byte, error) {
	type NoMethod TimePeriod
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// TimeZone: Represents a time zone from the IANA Time Zone Database
// (https://www.iana.org/time-zones).
type TimeZone struct {
	// Id: IANA Time Zone Database time zone, e.g. "America/New_York".
	Id string `json:"id,omitempty"`

	// Version: Optional. IANA Time Zone Database version number, e.g.
	// "2019a".
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *TimeZone) MarshalJSON() ([]byte, error) {
	type NoMethod TimeZone
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type TransitTable struct {
	// PostalCodeGroupNames: A list of postal group names. The last value
	// can be "all other locations". Example: `["zone 1", "zone 2", "all
	// other locations"]`. The referred postal code groups must match the
	// delivery country of the service.
	PostalCodeGroupNames []string `json:"postalCodeGroupNames,omitempty"`

	Rows []*TransitTableTransitTimeRow `json:"rows,omitempty"`

	// TransitTimeLabels: A list of transit time labels. The last value can
	// be "all other labels". Example: `["food", "electronics", "all other
	// labels"]`.
	TransitTimeLabels []string `json:"transitTimeLabels,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "PostalCodeGroupNames") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PostalCodeGroupNames") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *TransitTable) MarshalJSON() ([]byte, error) {
	type NoMethod TransitTable
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type TransitTableTransitTimeRow struct {
	Values []*TransitTableTransitTimeRowTransitTimeValue `json:"values,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Values") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *TransitTableTransitTimeRow) MarshalJSON() ([]byte, error) {
	type NoMethod TransitTableTransitTimeRow
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type TransitTableTransitTimeRowTransitTimeValue struct {
	// MaxTransitTimeInDays: Must be greater than or equal to
	// `minTransitTimeInDays`.
	MaxTransitTimeInDays int64 `json:"maxTransitTimeInDays,omitempty"`

	// MinTransitTimeInDays: Transit time range (min-max) in business days.
	// 0 means same day delivery, 1 means next day delivery.
	MinTransitTimeInDays int64 `json:"minTransitTimeInDays,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "MaxTransitTimeInDays") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MaxTransitTimeInDays") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *TransitTableTransitTimeRowTransitTimeValue) MarshalJSON() ([]byte, error) {
	type NoMethod TransitTableTransitTimeRowTransitTimeValue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type UnitInvoice struct {
	// AdditionalCharges: Additional charges for a unit, e.g. shipping
	// costs.
	AdditionalCharges []*UnitInvoiceAdditionalCharge `json:"additionalCharges,omitempty"`

	// UnitPrice: [required] Pre-tax or post-tax price of one unit depending
	// on the locality of the order. *Note:* Invoicing works on a per unit
	// basis. The `unitPrice` is the price of a single unit, and will be
	// multiplied by the number of entries in `shipmentUnitId`.
	UnitPrice *Price `json:"unitPrice,omitempty"`

	// UnitPriceTaxes: Tax amounts to apply to the unit price.
	UnitPriceTaxes []*UnitInvoiceTaxLine `json:"unitPriceTaxes,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdditionalCharges")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdditionalCharges") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *UnitInvoice) MarshalJSON() ([]byte, error) {
	type NoMethod UnitInvoice
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type UnitInvoiceAdditionalCharge struct {
	// AdditionalChargeAmount: [required] Amount of the additional charge
	// per unit. *Note:* Invoicing works on a per unit bases. The
	// `additionalChargeAmount` is the amount charged per unit, and will be
	// multiplied by the number of entries in `shipmentUnitID`.
	AdditionalChargeAmount *Amount `json:"additionalChargeAmount,omitempty"`

	// Type: [required] Type of the additional charge. Acceptable values
	// are: - "shipping"
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AdditionalChargeAmount") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdditionalChargeAmount")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *UnitInvoiceAdditionalCharge) MarshalJSON() ([]byte, error) {
	type NoMethod UnitInvoiceAdditionalCharge
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type UnitInvoiceTaxLine struct {
	// TaxAmount: [required] Tax amount for the tax type.
	TaxAmount *Price `json:"taxAmount,omitempty"`

	// TaxName: Optional name of the tax type. This should only be provided
	// if `taxType` is `otherFeeTax`.
	TaxName string `json:"taxName,omitempty"`

	// TaxType: [required] Type of the tax. Acceptable values are: -
	// "otherFee" - "otherFeeTax" - "sales"
	TaxType string `json:"taxType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "TaxAmount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TaxAmount") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *UnitInvoiceTaxLine) MarshalJSON() ([]byte, error) {
	type NoMethod UnitInvoiceTaxLine
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Value: The single value of a rate group or the value of a rate group
// table's cell. Exactly one of `noShipping`, `flatRate`,
// `pricePercentage`, `carrierRateName`, `subtableName` must be set.
type Value struct {
	// CarrierRateName: The name of a carrier rate referring to a carrier
	// rate defined in the same rate group. Can only be set if all other
	// fields are not set.
	CarrierRateName string `json:"carrierRateName,omitempty"`

	// FlatRate: A flat rate. Can only be set if all other fields are not
	// set.
	FlatRate *Price `json:"flatRate,omitempty"`

	// NoShipping: If true, then the product can't ship. Must be true when
	// set, can only be set if all other fields are not set.
	NoShipping bool `json:"noShipping,omitempty"`

	// PricePercentage: A percentage of the price represented as a number in
	// decimal notation (e.g., "5.4"). Can only be set if all other fields
	// are not set.
	PricePercentage string `json:"pricePercentage,omitempty"`

	// SubtableName: The name of a subtable. Can only be set in table cells
	// (i.e., not for single values), and only if all other fields are not
	// set.
	SubtableName string `json:"subtableName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CarrierRateName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CarrierRateName") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Value) MarshalJSON() ([]byte, error) {
	type NoMethod Value
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VerifyPhoneNumberRequest: Request message for the VerifyPhoneNumber
// method.
type VerifyPhoneNumberRequest struct {
	// PhoneVerificationMethod: Verification method used to receive
	// verification code.
	//
	// Possible values:
	//   "PHONE_VERIFICATION_METHOD_UNSPECIFIED" - Unknown method.
	//   "SMS" - Receive verification code by SMS.
	//   "PHONE_CALL" - Receive verification code by phone call.
	PhoneVerificationMethod string `json:"phoneVerificationMethod,omitempty"`

	// VerificationCode: The verification code that was sent to the phone
	// number for validation.
	VerificationCode string `json:"verificationCode,omitempty"`

	// VerificationId: The verification ID returned by
	// `requestphoneverification`.
	VerificationId string `json:"verificationId,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "PhoneVerificationMethod") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PhoneVerificationMethod")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *VerifyPhoneNumberRequest) MarshalJSON() ([]byte, error) {
	type NoMethod VerifyPhoneNumberRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VerifyPhoneNumberResponse: Response message for the VerifyPhoneNumber
// method.
type VerifyPhoneNumberResponse struct {
	// VerifiedPhoneNumber: Verified phone number if verification is
	// successful. This phone number can only be replaced by another
	// verified phone number.
	VerifiedPhoneNumber string `json:"verifiedPhoneNumber,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "VerifiedPhoneNumber")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "VerifiedPhoneNumber") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *VerifyPhoneNumberResponse) MarshalJSON() ([]byte, error) {
	type NoMethod VerifyPhoneNumberResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Warehouse: A fulfillment warehouse, which stores and handles
// inventory.
type Warehouse struct {
	// BusinessDayConfig: Business days of the warehouse. If not set, will
	// be Monday to Friday by default.
	BusinessDayConfig *BusinessDayConfig `json:"businessDayConfig,omitempty"`

	// CutoffTime: Required. The latest time of day that an order can be
	// accepted and begin processing. Later orders will be processed in the
	// next day. The time is based on the warehouse postal code.
	CutoffTime *WarehouseCutoffTime `json:"cutoffTime,omitempty"`

	// HandlingDays: Required. The number of days it takes for this
	// warehouse to pack up and ship an item. This is on the warehouse
	// level, but can be overridden on the offer level based on the
	// attributes of an item.
	HandlingDays int64 `json:"handlingDays,omitempty,string"`

	// Name: Required. The name of the warehouse. Must be unique within
	// account.
	Name string `json:"name,omitempty"`

	// ShippingAddress: Required. Shipping address of the warehouse.
	ShippingAddress *Address `json:"shippingAddress,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BusinessDayConfig")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BusinessDayConfig") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Warehouse) MarshalJSON() ([]byte, error) {
	type NoMethod Warehouse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type WarehouseBasedDeliveryTime struct {
	// Carrier: Required. Carrier, such as "UPS" or "Fedex". The list of
	// supported carriers can be retrieved via the `listSupportedCarriers`
	// method.
	Carrier string `json:"carrier,omitempty"`

	// CarrierService: Required. Carrier service, such as "ground" or "2
	// days". The list of supported services for a carrier can be retrieved
	// via the `listSupportedCarriers` method. The name of the service must
	// be in the eddSupportedServices list.
	CarrierService string `json:"carrierService,omitempty"`

	// OriginAdministrativeArea: Shipping origin's state.
	OriginAdministrativeArea string `json:"originAdministrativeArea,omitempty"`

	// OriginCity: Shipping origin's city.
	OriginCity string `json:"originCity,omitempty"`

	// OriginCountry: Shipping origin's country represented as a CLDR
	// territory code
	// (http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml).
	OriginCountry string `json:"originCountry,omitempty"`

	// OriginPostalCode: Shipping origin.
	OriginPostalCode string `json:"originPostalCode,omitempty"`

	// OriginStreetAddress: Shipping origin's street address.
	OriginStreetAddress string `json:"originStreetAddress,omitempty"`

	// WarehouseName: The name of the warehouse. Warehouse name need to be
	// matched with name. If warehouseName is set, the below fields will be
	// ignored. The warehouse info will be read from warehouse.
	WarehouseName string `json:"warehouseName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Carrier") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Carrier") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *WarehouseBasedDeliveryTime) MarshalJSON() ([]byte, error) {
	type NoMethod WarehouseBasedDeliveryTime
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type WarehouseCutoffTime struct {
	// Hour: Required. Hour (24-hour clock) of the cutoff time until which
	// an order has to be placed to be processed in the same day by the
	// warehouse. Hour is based on the timezone of warehouse.
	Hour int64 `json:"hour,omitempty"`

	// Minute: Required. Minute of the cutoff time until which an order has
	// to be placed to be processed in the same day by the warehouse. Minute
	// is based on the timezone of warehouse.
	Minute int64 `json:"minute,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Hour") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Hour") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *WarehouseCutoffTime) MarshalJSON() ([]byte, error) {
	type NoMethod WarehouseCutoffTime
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type Weight struct {
	// Unit: Required. The weight unit. Acceptable values are: - "kg" -
	// "lb"
	Unit string `json:"unit,omitempty"`

	// Value: Required. The weight represented as a number. The weight can
	// have a maximum precision of four decimal places.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Unit") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Unit") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Weight) MarshalJSON() ([]byte, error) {
	type NoMethod Weight
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "content.accounts.authinfo":

type AccountsAuthinfoCall struct {
	s            *APIService
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Authinfo: Returns information about the authenticated user.
func (r *AccountsService) Authinfo() *AccountsAuthinfoCall {
	c := &AccountsAuthinfoCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsAuthinfoCall) Fields(s ...googleapi.Field) *AccountsAuthinfoCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsAuthinfoCall) IfNoneMatch(entityTag string) *AccountsAuthinfoCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsAuthinfoCall) Context(ctx context.Context) *AccountsAuthinfoCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsAuthinfoCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsAuthinfoCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "accounts/authinfo")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.authinfo" call.
// Exactly one of *AccountsAuthInfoResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *AccountsAuthInfoResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountsAuthinfoCall) Do(opts ...googleapi.CallOption) (*AccountsAuthInfoResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &AccountsAuthInfoResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns information about the authenticated user.",
	//   "flatPath": "accounts/authinfo",
	//   "httpMethod": "GET",
	//   "id": "content.accounts.authinfo",
	//   "parameterOrder": [],
	//   "parameters": {},
	//   "path": "accounts/authinfo",
	//   "response": {
	//     "$ref": "AccountsAuthInfoResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// method id "content.accounts.claimwebsite":

type AccountsClaimwebsiteCall struct {
	s          *APIService
	merchantId uint64
	accountId  uint64
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Claimwebsite: Claims the website of a Merchant Center sub-account.
//
// - accountId: The ID of the account whose website is claimed.
// - merchantId: The ID of the managing account. If this parameter is
//   not the same as accountId, then this account must be a multi-client
//   account and `accountId` must be the ID of a sub-account of this
//   account.
func (r *AccountsService) Claimwebsite(merchantId uint64, accountId uint64) *AccountsClaimwebsiteCall {
	c := &AccountsClaimwebsiteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.accountId = accountId
	return c
}

// Overwrite sets the optional parameter "overwrite": Only available to
// selected merchants. When set to `True`, this flag removes any
// existing claim on the requested website by another account and
// replaces it with a claim from this account.
func (c *AccountsClaimwebsiteCall) Overwrite(overwrite bool) *AccountsClaimwebsiteCall {
	c.urlParams_.Set("overwrite", fmt.Sprint(overwrite))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsClaimwebsiteCall) Fields(s ...googleapi.Field) *AccountsClaimwebsiteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsClaimwebsiteCall) Context(ctx context.Context) *AccountsClaimwebsiteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsClaimwebsiteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsClaimwebsiteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/accounts/{accountId}/claimwebsite")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
		"accountId":  strconv.FormatUint(c.accountId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.claimwebsite" call.
// Exactly one of *AccountsClaimWebsiteResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *AccountsClaimWebsiteResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountsClaimwebsiteCall) Do(opts ...googleapi.CallOption) (*AccountsClaimWebsiteResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &AccountsClaimWebsiteResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Claims the website of a Merchant Center sub-account.",
	//   "flatPath": "{merchantId}/accounts/{accountId}/claimwebsite",
	//   "httpMethod": "POST",
	//   "id": "content.accounts.claimwebsite",
	//   "parameterOrder": [
	//     "merchantId",
	//     "accountId"
	//   ],
	//   "parameters": {
	//     "accountId": {
	//       "description": "The ID of the account whose website is claimed.",
	//       "format": "uint64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "merchantId": {
	//       "description": "The ID of the managing account. If this parameter is not the same as accountId, then this account must be a multi-client account and `accountId` must be the ID of a sub-account of this account.",
	//       "format": "uint64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "overwrite": {
	//       "description": "Only available to selected merchants. When set to `True`, this flag removes any existing claim on the requested website by another account and replaces it with a claim from this account.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "{merchantId}/accounts/{accountId}/claimwebsite",
	//   "response": {
	//     "$ref": "AccountsClaimWebsiteResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// method id "content.accounts.custombatch":

type AccountsCustombatchCall struct {
	s                          *APIService
	accountscustombatchrequest *AccountsCustomBatchRequest
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// Custombatch: Retrieves, inserts, updates, and deletes multiple
// Merchant Center (sub-)accounts in a single request.
func (r *AccountsService) Custombatch(accountscustombatchrequest *AccountsCustomBatchRequest) *AccountsCustombatchCall {
	c := &AccountsCustombatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.accountscustombatchrequest = accountscustombatchrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsCustombatchCall) Fields(s ...googleapi.Field) *AccountsCustombatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsCustombatchCall) Context(ctx context.Context) *AccountsCustombatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsCustombatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsCustombatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.accountscustombatchrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "accounts/batch")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.custombatch" call.
// Exactly one of *AccountsCustomBatchResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *AccountsCustomBatchResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountsCustombatchCall) Do(opts ...googleapi.CallOption) (*AccountsCustomBatchResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &AccountsCustomBatchResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves, inserts, updates, and deletes multiple Merchant Center (sub-)accounts in a single request.",
	//   "flatPath": "accounts/batch",
	//   "httpMethod": "POST",
	//   "id": "content.accounts.custombatch",
	//   "parameterOrder": [],
	//   "parameters": {},
	//   "path": "accounts/batch",
	//   "request": {
	//     "$ref": "AccountsCustomBatchRequest"
	//   },
	//   "response": {
	//     "$ref": "AccountsCustomBatchResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// method id "content.accounts.delete":

type AccountsDeleteCall struct {
	s          *APIService
	merchantId uint64
	accountId  uint64
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a Merchant Center sub-account.
//
// - accountId: The ID of the account.
// - merchantId: The ID of the managing account. This must be a
//   multi-client account, and accountId must be the ID of a sub-account
//   of this account.
func (r *AccountsService) Delete(merchantId uint64, accountId uint64) *AccountsDeleteCall {
	c := &AccountsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.accountId = accountId
	return c
}

// Force sets the optional parameter "force": Flag to delete
// sub-accounts with products. The default value is false.
func (c *AccountsDeleteCall) Force(force bool) *AccountsDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsDeleteCall) Fields(s ...googleapi.Field) *AccountsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsDeleteCall) Context(ctx context.Context) *AccountsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/accounts/{accountId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
		"accountId":  strconv.FormatUint(c.accountId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.delete" call.
func (c *AccountsDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return err
	}
	return nil
	// {
	//   "description": "Deletes a Merchant Center sub-account.",
	//   "flatPath": "{merchantId}/accounts/{accountId}",
	//   "httpMethod": "DELETE",
	//   "id": "content.accounts.delete",
	//   "parameterOrder": [
	//     "merchantId",
	//     "accountId"
	//   ],
	//   "parameters": {
	//     "accountId": {
	//       "description": "The ID of the account.",
	//       "format": "uint64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "force": {
	//       "default": "false",
	//       "description": "Flag to delete sub-accounts with products. The default value is false.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "merchantId": {
	//       "description": "The ID of the managing account. This must be a multi-client account, and accountId must be the ID of a sub-account of this account.",
	//       "format": "uint64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "{merchantId}/accounts/{accountId}",
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// method id "content.accounts.get":

type AccountsGetCall struct {
	s            *APIService
	merchantId   uint64
	accountId    uint64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a Merchant Center account.
//
// - accountId: The ID of the account.
// - merchantId: The ID of the managing account. If this parameter is
//   not the same as accountId, then this account must be a multi-client
//   account and `accountId` must be the ID of a sub-account of this
//   account.
func (r *AccountsService) Get(merchantId uint64, accountId uint64) *AccountsGetCall {
	c := &AccountsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.accountId = accountId
	return c
}

// View sets the optional parameter "view": Controls which fields will
// be populated. Acceptable values are: "merchant" and "css". The
// default value is "merchant".
//
// Possible values:
//   "MERCHANT" - Default. View is populated with Merchant Center
// fields.
//   "CSS" - View is populated with Comparison Shopping Services fields.
func (c *AccountsGetCall) View(view string) *AccountsGetCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsGetCall) Fields(s ...googleapi.Field) *AccountsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsGetCall) IfNoneMatch(entityTag string) *AccountsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsGetCall) Context(ctx context.Context) *AccountsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/accounts/{accountId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
		"accountId":  strconv.FormatUint(c.accountId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.get" call.
// Exactly one of *Account or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Account.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *AccountsGetCall) Do(opts ...googleapi.CallOption) (*Account, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Account{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves a Merchant Center account.",
	//   "flatPath": "{merchantId}/accounts/{accountId}",
	//   "httpMethod": "GET",
	//   "id": "content.accounts.get",
	//   "parameterOrder": [
	//     "merchantId",
	//     "accountId"
	//   ],
	//   "parameters": {
	//     "accountId": {
	//       "description": "The ID of the account.",
	//       "format": "uint64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "merchantId": {
	//       "description": "The ID of the managing account. If this parameter is not the same as accountId, then this account must be a multi-client account and `accountId` must be the ID of a sub-account of this account.",
	//       "format": "uint64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "Controls which fields will be populated. Acceptable values are: \"merchant\" and \"css\". The default value is \"merchant\".",
	//       "enum": [
	//         "MERCHANT",
	//         "CSS"
	//       ],
	//       "enumDescriptions": [
	//         "Default. View is populated with Merchant Center fields.",
	//         "View is populated with Comparison Shopping Services fields."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "{merchantId}/accounts/{accountId}",
	//   "response": {
	//     "$ref": "Account"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// method id "content.accounts.insert":

type AccountsInsertCall struct {
	s          *APIService
	merchantId uint64
	account    *Account
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Insert: Creates a Merchant Center sub-account.
//
// - merchantId: The ID of the managing account. This must be a
//   multi-client account.
func (r *AccountsService) Insert(merchantId uint64, account *Account) *AccountsInsertCall {
	c := &AccountsInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.account = account
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsInsertCall) Fields(s ...googleapi.Field) *AccountsInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsInsertCall) Context(ctx context.Context) *AccountsInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.account)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/accounts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.insert" call.
// Exactly one of *Account or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Account.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *AccountsInsertCall) Do(opts ...googleapi.CallOption) (*Account, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Account{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a Merchant Center sub-account.",
	//   "flatPath": "{merchantId}/accounts",
	//   "httpMethod": "POST",
	//   "id": "content.accounts.insert",
	//   "parameterOrder": [
	//     "merchantId"
	//   ],
	//   "parameters": {
	//     "merchantId": {
	//       "description": "The ID of the managing account. This must be a multi-client account.",
	//       "format": "uint64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "{merchantId}/accounts",
	//   "request": {
	//     "$ref": "Account"
	//   },
	//   "response": {
	//     "$ref": "Account"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// method id "content.accounts.link":

type AccountsLinkCall struct {
	s                   *APIService
	merchantId          uint64
	accountId           uint64
	accountslinkrequest *AccountsLinkRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Link: Performs an action on a link between two Merchant Center
// accounts, namely accountId and linkedAccountId.
//
// - accountId: The ID of the account that should be linked.
// - merchantId: The ID of the managing account. If this parameter is
//   not the same as accountId, then this account must be a multi-client
//   account and `accountId` must be the ID of a sub-account of this
//   account.
func (r *AccountsService) Link(merchantId uint64, accountId uint64, accountslinkrequest *AccountsLinkRequest) *AccountsLinkCall {
	c := &AccountsLinkCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.accountId = accountId
	c.accountslinkrequest = accountslinkrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsLinkCall) Fields(s ...googleapi.Field) *AccountsLinkCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsLinkCall) Context(ctx context.Context) *AccountsLinkCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsLinkCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsLinkCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.accountslinkrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/accounts/{accountId}/link")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
		"accountId":  strconv.FormatUint(c.accountId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.link" call.
// Exactly one of *AccountsLinkResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *AccountsLinkResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountsLinkCall) Do(opts ...googleapi.CallOption) (*AccountsLinkResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &AccountsLinkResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Performs an action on a link between two Merchant Center accounts, namely accountId and linkedAccountId.",
	//   "flatPath": "{merchantId}/accounts/{accountId}/link",
	//   "httpMethod": "POST",
	//   "id": "content.accounts.link",
	//   "parameterOrder": [
	//     "merchantId",
	//     "accountId"
	//   ],
	//   "parameters": {
	//     "accountId": {
	//       "description": "The ID of the account that should be linked.",
	//       "format": "uint64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "merchantId": {
	//       "description": "The ID of the managing account. If this parameter is not the same as accountId, then this account must be a multi-client account and `accountId` must be the ID of a sub-account of this account.",
	//       "format": "uint64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "{merchantId}/accounts/{accountId}/link",
	//   "request": {
	//     "$ref": "AccountsLinkRequest"
	//   },
	//   "response": {
	//     "$ref": "AccountsLinkResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// method id "content.accounts.list":

type AccountsListCall struct {
	s            *APIService
	merchantId   uint64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the sub-accounts in your Merchant Center account.
//
// - merchantId: The ID of the managing account. This must be a
//   multi-client account.
func (r *AccountsService) List(merchantId uint64) *AccountsListCall {
	c := &AccountsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	return c
}

// Label sets the optional parameter "label": If view is set to "css",
// only return accounts that are assigned label with given ID.
func (c *AccountsListCall) Label(label uint64) *AccountsListCall {
	c.urlParams_.Set("label", fmt.Sprint(label))
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum
// number of accounts to return in the response, used for paging.
func (c *AccountsListCall) MaxResults(maxResults int64) *AccountsListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// Name sets the optional parameter "name": If set, only the accounts
// with the given name (case sensitive) will be returned.
func (c *AccountsListCall) Name(name string) *AccountsListCall {
	c.urlParams_.Set("name", name)
	return c
}

// PageToken sets the optional parameter "pageToken": The token returned
// by the previous request.
func (c *AccountsListCall) PageToken(pageToken string) *AccountsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// View sets the optional parameter "view": Controls which fields will
// be populated. Acceptable values are: "merchant" and "css". The
// default value is "merchant".
//
// Possible values:
//   "MERCHANT" - Default. View is populated with Merchant Center
// fields.
//   "CSS" - View is populated with Comparison Shopping Services fields.
func (c *AccountsListCall) View(view string) *AccountsListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsListCall) Fields(s ...googleapi.Field) *AccountsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsListCall) IfNoneMatch(entityTag string) *AccountsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsListCall) Context(ctx context.Context) *AccountsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/accounts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.list" call.
// Exactly one of *AccountsListResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *AccountsListResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountsListCall) Do(opts ...googleapi.CallOption) (*AccountsListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &AccountsListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists the sub-accounts in your Merchant Center account.",
	//   "flatPath": "{merchantId}/accounts",
	//   "httpMethod": "GET",
	//   "id": "content.accounts.list",
	//   "parameterOrder": [
	//     "merchantId"
	//   ],
	//   "parameters": {
	//     "label": {
	//       "description": "If view is set to \"css\", only return accounts that are assigned label with given ID.",
	//       "format": "uint64",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "maxResults": {
	//       "description": "The maximum number of accounts to return in the response, used for paging.",
	//       "format": "uint32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "merchantId": {
	//       "description": "The ID of the managing account. This must be a multi-client account.",
	//       "format": "uint64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "If set, only the accounts with the given name (case sensitive) will be returned.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageToken": {
	//       "description": "The token returned by the previous request.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "Controls which fields will be populated. Acceptable values are: \"merchant\" and \"css\". The default value is \"merchant\".",
	//       "enum": [
	//         "MERCHANT",
	//         "CSS"
	//       ],
	//       "enumDescriptions": [
	//         "Default. View is populated with Merchant Center fields.",
	//         "View is populated with Comparison Shopping Services fields."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "{merchantId}/accounts",
	//   "response": {
	//     "$ref": "AccountsListResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccountsListCall) Pages(ctx context.Context, f func(*AccountsListResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "content.accounts.listlinks":

type AccountsListlinksCall struct {
	s            *APIService
	merchantId   uint64
	accountId    uint64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Listlinks: Returns the list of accounts linked to your Merchant
// Center account.
//
// - accountId: The ID of the account for which to list links.
// - merchantId: The ID of the managing account. If this parameter is
//   not the same as accountId, then this account must be a multi-client
//   account and `accountId` must be the ID of a sub-account of this
//   account.
func (r *AccountsService) Listlinks(merchantId uint64, accountId uint64) *AccountsListlinksCall {
	c := &AccountsListlinksCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.accountId = accountId
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum
// number of links to return in the response, used for pagination. The
// minimum allowed value is 5 results per page. If provided value is
// lower than 5, it will be automatically increased to 5.
func (c *AccountsListlinksCall) MaxResults(maxResults int64) *AccountsListlinksCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// PageToken sets the optional parameter "pageToken": The token returned
// by the previous request.
func (c *AccountsListlinksCall) PageToken(pageToken string) *AccountsListlinksCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsListlinksCall) Fields(s ...googleapi.Field) *AccountsListlinksCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsListlinksCall) IfNoneMatch(entityTag string) *AccountsListlinksCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsListlinksCall) Context(ctx context.Context) *AccountsListlinksCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsListlinksCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsListlinksCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/accounts/{accountId}/listlinks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
		"accountId":  strconv.FormatUint(c.accountId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.listlinks" call.
// Exactly one of *AccountsListLinksResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *AccountsListLinksResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountsListlinksCall) Do(opts ...googleapi.CallOption) (*AccountsListLinksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &AccountsListLinksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns the list of accounts linked to your Merchant Center account.",
	//   "flatPath": "{merchantId}/accounts/{accountId}/listlinks",
	//   "httpMethod": "GET",
	//   "id": "content.accounts.listlinks",
	//   "parameterOrder": [
	//     "merchantId",
	//     "accountId"
	//   ],
	//   "parameters": {
	//     "accountId": {
	//       "description": "The ID of the account for which to list links.",
	//       "format": "uint64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "maxResults": {
	//       "description": "The maximum number of links to return in the response, used for pagination. The minimum allowed value is 5 results per page. If provided value is lower than 5, it will be automatically increased to 5.",
	//       "format": "uint32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "merchantId": {
	//       "description": "The ID of the managing account. If this parameter is not the same as accountId, then this account must be a multi-client account and `accountId` must be the ID of a sub-account of this account.",
	//       "format": "uint64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageToken": {
	//       "description": "The token returned by the previous request.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "{merchantId}/accounts/{accountId}/listlinks",
	//   "response": {
	//     "$ref": "AccountsListLinksResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccountsListlinksCall) Pages(ctx context.Context, f func(*AccountsListLinksResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "content.accounts.requestphoneverification":

type AccountsRequestphoneverificationCall struct {
	s                               *APIService
	merchantId                      int64
	accountId                       int64
	requestphoneverificationrequest *RequestPhoneVerificationRequest
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// Requestphoneverification: Request verification code to start phone
// verification.
//
// - accountId: The ID of the account.
// - merchantId: The ID of the managing account. If this parameter is
//   not the same as accountId, then this account must be a multi-client
//   account and accountId must be the ID of a sub-account of this
//   account.
func (r *AccountsService) Requestphoneverification(merchantId int64, accountId int64, requestphoneverificationrequest *RequestPhoneVerificationRequest) *AccountsRequestphoneverificationCall {
	c := &AccountsRequestphoneverificationCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.accountId = accountId
	c.requestphoneverificationrequest = requestphoneverificationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsRequestphoneverificationCall) Fields(s ...googleapi.Field) *AccountsRequestphoneverificationCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsRequestphoneverificationCall) Context(ctx context.Context) *AccountsRequestphoneverificationCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsRequestphoneverificationCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsRequestphoneverificationCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.requestphoneverificationrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/accounts/{accountId}/requestphoneverification")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatInt(c.merchantId, 10),
		"accountId":  strconv.FormatInt(c.accountId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.requestphoneverification" call.
// Exactly one of *RequestPhoneVerificationResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *RequestPhoneVerificationResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountsRequestphoneverificationCall) Do(opts ...googleapi.CallOption) (*RequestPhoneVerificationResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &RequestPhoneVerificationResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Request verification code to start phone verification.",
	//   "flatPath": "{merchantId}/accounts/{accountId}/requestphoneverification",
	//   "httpMethod": "POST",
	//   "id": "content.accounts.requestphoneverification",
	//   "parameterOrder": [
	//     "merchantId",
	//     "accountId"
	//   ],
	//   "parameters": {
	//     "accountId": {
	//       "description": "Required. The ID of the account.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "merchantId": {
	//       "description": "Required. The ID of the managing account. If this parameter is not the same as accountId, then this account must be a multi-client account and accountId must be the ID of a sub-account of this account.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "{merchantId}/accounts/{accountId}/requestphoneverification",
	//   "request": {
	//     "$ref": "RequestPhoneVerificationRequest"
	//   },
	//   "response": {
	//     "$ref": "RequestPhoneVerificationResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// method id "content.accounts.update":

type AccountsUpdateCall struct {
	s          *APIService
	merchantId uint64
	accountId  uint64
	account    *Account
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Update: Updates a Merchant Center account. Any fields that are not
// provided are deleted from the resource.
//
// - accountId: The ID of the account.
// - merchantId: The ID of the managing account. If this parameter is
//   not the same as accountId, then this account must be a multi-client
//   account and `accountId` must be the ID of a sub-account of this
//   account.
func (r *AccountsService) Update(merchantId uint64, accountId uint64, account *Account) *AccountsUpdateCall {
	c := &AccountsUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.accountId = accountId
	c.account = account
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsUpdateCall) Fields(s ...googleapi.Field) *AccountsUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsUpdateCall) Context(ctx context.Context) *AccountsUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.account)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/accounts/{accountId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
		"accountId":  strconv.FormatUint(c.accountId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.update" call.
// Exactly one of *Account or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Account.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *AccountsUpdateCall) Do(opts ...googleapi.CallOption) (*Account, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Account{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a Merchant Center account. Any fields that are not provided are deleted from the resource.",
	//   "flatPath": "{merchantId}/accounts/{accountId}",
	//   "httpMethod": "PUT",
	//   "id": "content.accounts.update",
	//   "parameterOrder": [
	//     "merchantId",
	//     "accountId"
	//   ],
	//   "parameters": {
	//     "accountId": {
	//       "description": "The ID of the account.",
	//       "format": "uint64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "merchantId": {
	//       "description": "The ID of the managing account. If this parameter is not the same as accountId, then this account must be a multi-client account and `accountId` must be the ID of a sub-account of this account.",
	//       "format": "uint64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "{merchantId}/accounts/{accountId}",
	//   "request": {
	//     "$ref": "Account"
	//   },
	//   "response": {
	//     "$ref": "Account"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// method id "content.accounts.updatelabels":

type AccountsUpdatelabelsCall struct {
	s                           *APIService
	merchantId                  uint64
	accountId                   uint64
	accountsupdatelabelsrequest *AccountsUpdateLabelsRequest
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// Updatelabels: Updates labels that are assigned to the Merchant Center
// account by CSS user.
//
// - accountId: The ID of the account whose labels are updated.
// - merchantId: The ID of the managing account.
func (r *AccountsService) Updatelabels(merchantId uint64, accountId uint64, accountsupdatelabelsrequest *AccountsUpdateLabelsRequest) *AccountsUpdatelabelsCall {
	c := &AccountsUpdatelabelsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.accountId = accountId
	c.accountsupdatelabelsrequest = accountsupdatelabelsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsUpdatelabelsCall) Fields(s ...googleapi.Field) *AccountsUpdatelabelsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsUpdatelabelsCall) Context(ctx context.Context) *AccountsUpdatelabelsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsUpdatelabelsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsUpdatelabelsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.accountsupdatelabelsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/accounts/{accountId}/updatelabels")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
		"accountId":  strconv.FormatUint(c.accountId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.updatelabels" call.
// Exactly one of *AccountsUpdateLabelsResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *AccountsUpdateLabelsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountsUpdatelabelsCall) Do(opts ...googleapi.CallOption) (*AccountsUpdateLabelsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &AccountsUpdateLabelsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates labels that are assigned to the Merchant Center account by CSS user.",
	//   "flatPath": "{merchantId}/accounts/{accountId}/updatelabels",
	//   "httpMethod": "POST",
	//   "id": "content.accounts.updatelabels",
	//   "parameterOrder": [
	//     "merchantId",
	//     "accountId"
	//   ],
	//   "parameters": {
	//     "accountId": {
	//       "description": "The ID of the account whose labels are updated.",
	//       "format": "uint64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "merchantId": {
	//       "description": "The ID of the managing account.",
	//       "format": "uint64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "{merchantId}/accounts/{accountId}/updatelabels",
	//   "request": {
	//     "$ref": "AccountsUpdateLabelsRequest"
	//   },
	//   "response": {
	//     "$ref": "AccountsUpdateLabelsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// method id "content.accounts.verifyphonenumber":

type AccountsVerifyphonenumberCall struct {
	s                        *APIService
	merchantId               int64
	accountId                int64
	verifyphonenumberrequest *VerifyPhoneNumberRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// Verifyphonenumber: Validates verification code to verify phone number
// for the account. If successful this will overwrite the value of
// `accounts.businessinformation.phoneNumber`. Only verified phone
// number will replace an existing verified phone number.
//
// - accountId: The ID of the account.
// - merchantId: The ID of the managing account. If this parameter is
//   not the same as accountId, then this account must be a multi-client
//   account and accountId must be the ID of a sub-account of this
//   account.
func (r *AccountsService) Verifyphonenumber(merchantId int64, accountId int64, verifyphonenumberrequest *VerifyPhoneNumberRequest) *AccountsVerifyphonenumberCall {
	c := &AccountsVerifyphonenumberCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.accountId = accountId
	c.verifyphonenumberrequest = verifyphonenumberrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsVerifyphonenumberCall) Fields(s ...googleapi.Field) *AccountsVerifyphonenumberCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsVerifyphonenumberCall) Context(ctx context.Context) *AccountsVerifyphonenumberCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsVerifyphonenumberCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsVerifyphonenumberCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.verifyphonenumberrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/accounts/{accountId}/verifyphonenumber")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatInt(c.merchantId, 10),
		"accountId":  strconv.FormatInt(c.accountId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.verifyphonenumber" call.
// Exactly one of *VerifyPhoneNumberResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *VerifyPhoneNumberResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountsVerifyphonenumberCall) Do(opts ...googleapi.CallOption) (*VerifyPhoneNumberResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &VerifyPhoneNumberResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Validates verification code to verify phone number for the account. If successful this will overwrite the value of `accounts.businessinformation.phoneNumber`. Only verified phone number will replace an existing verified phone number.",
	//   "flatPath": "{merchantId}/accounts/{accountId}/verifyphonenumber",
	//   "httpMethod": "POST",
	//   "id": "content.accounts.verifyphonenumber",
	//   "parameterOrder": [
	//     "merchantId",
	//     "accountId"
	//   ],
	//   "parameters": {
	//     "accountId": {
	//       "description": "Required. The ID of the account.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "merchantId": {
	//       "description": "Required. The ID of the managing account. If this parameter is not the same as accountId, then this account must be a multi-client account and accountId must be the ID of a sub-account of this account.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "{merchantId}/accounts/{accountId}/verifyphonenumber",
	//   "request": {
	//     "$ref": "VerifyPhoneNumberRequest"
	//   },
	//   "response": {
	//     "$ref": "VerifyPhoneNumberResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// method id "content.accounts.credentials.create":

type AccountsCredentialsCreateCall struct {
	s                  *APIService
	accountId          int64
	accountcredentials *AccountCredentials
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Create: Uploads credentials for the Merchant Center account. If
// credentials already exist for this Merchant Center account and
// purpose, this method updates them.
//
// - accountId: The merchant id of the account these credentials belong
//   to.
func (r *AccountsCredentialsService) Create(accountId int64, accountcredentials *AccountCredentials) *AccountsCredentialsCreateCall {
	c := &AccountsCredentialsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.accountId = accountId
	c.accountcredentials = accountcredentials
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsCredentialsCreateCall) Fields(s ...googleapi.Field) *AccountsCredentialsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsCredentialsCreateCall) Context(ctx context.Context) *AccountsCredentialsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsCredentialsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsCredentialsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.accountcredentials)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "accounts/{accountId}/credentials")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"accountId": strconv.FormatInt(c.accountId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.credentials.create" call.
// Exactly one of *AccountCredentials or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *AccountCredentials.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountsCredentialsCreateCall) Do(opts ...googleapi.CallOption) (*AccountCredentials, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &AccountCredentials{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Uploads credentials for the Merchant Center account. If credentials already exist for this Merchant Center account and purpose, this method updates them.",
	//   "flatPath": "accounts/{accountId}/credentials",
	//   "httpMethod": "POST",
	//   "id": "content.accounts.credentials.create",
	//   "parameterOrder": [
	//     "accountId"
	//   ],
	//   "parameters": {
	//     "accountId": {
	//       "description": "Required. The merchant id of the account these credentials belong to.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "accounts/{accountId}/credentials",
	//   "request": {
	//     "$ref": "AccountCredentials"
	//   },
	//   "response": {
	//     "$ref": "AccountCredentials"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// method id "content.accounts.labels.create":

type AccountsLabelsCreateCall struct {
	s            *APIService
	accountId    int64
	accountlabel *AccountLabel
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Create: Creates a new label, not assigned to any account.
//
// - accountId: The id of the account this label belongs to.
func (r *AccountsLabelsService) Create(accountId int64, accountlabel *AccountLabel) *AccountsLabelsCreateCall {
	c := &AccountsLabelsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.accountId = accountId
	c.accountlabel = accountlabel
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsLabelsCreateCall) Fields(s ...googleapi.Field) *AccountsLabelsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsLabelsCreateCall) Context(ctx context.Context) *AccountsLabelsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsLabelsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsLabelsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.accountlabel)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "accounts/{accountId}/labels")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"accountId": strconv.FormatInt(c.accountId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.labels.create" call.
// Exactly one of *AccountLabel or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *AccountLabel.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountsLabelsCreateCall) Do(opts ...googleapi.CallOption) (*AccountLabel, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &AccountLabel{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a new label, not assigned to any account.",
	//   "flatPath": "accounts/{accountId}/labels",
	//   "httpMethod": "POST",
	//   "id": "content.accounts.labels.create",
	//   "parameterOrder": [
	//     "accountId"
	//   ],
	//   "parameters": {
	//     "accountId": {
	//       "description": "Required. The id of the account this label belongs to.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "accounts/{accountId}/labels",
	//   "request": {
	//     "$ref": "AccountLabel"
	//   },
	//   "response": {
	//     "$ref": "AccountLabel"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// method id "content.accounts.labels.delete":

type AccountsLabelsDeleteCall struct {
	s          *APIService
	accountId  int64
	labelId    int64
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a label and removes it from all accounts to which it
// was assigned.
//
// - accountId: The id of the account that owns the label.
// - labelId: The id of the label to delete.
func (r *AccountsLabelsService) Delete(accountId int64, labelId int64) *AccountsLabelsDeleteCall {
	c := &AccountsLabelsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.accountId = accountId
	c.labelId = labelId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsLabelsDeleteCall) Fields(s ...googleapi.Field) *AccountsLabelsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsLabelsDeleteCall) Context(ctx context.Context) *AccountsLabelsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsLabelsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsLabelsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "accounts/{accountId}/labels/{labelId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"accountId": strconv.FormatInt(c.accountId, 10),
		"labelId":   strconv.FormatInt(c.labelId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.labels.delete" call.
func (c *AccountsLabelsDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return err
	}
	return nil
	// {
	//   "description": "Deletes a label and removes it from all accounts to which it was assigned.",
	//   "flatPath": "accounts/{accountId}/labels/{labelId}",
	//   "httpMethod": "DELETE",
	//   "id": "content.accounts.labels.delete",
	//   "parameterOrder": [
	//     "accountId",
	//     "labelId"
	//   ],
	//   "parameters": {
	//     "accountId": {
	//       "description": "Required. The id of the account that owns the label.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "labelId": {
	//       "description": "Required. The id of the label to delete.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "accounts/{accountId}/labels/{labelId}",
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// method id "content.accounts.labels.list":

type AccountsLabelsListCall struct {
	s            *APIService
	accountId    int64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the labels assigned to an account.
//
// - accountId: The account id for whose labels are to be listed.
func (r *AccountsLabelsService) List(accountId int64) *AccountsLabelsListCall {
	c := &AccountsLabelsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.accountId = accountId
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of labels to return. The service may return fewer than this value. If
// unspecified, at most 50 labels will be returned. The maximum value is
// 1000; values above 1000 will be coerced to 1000.
func (c *AccountsLabelsListCall) PageSize(pageSize int64) *AccountsLabelsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListAccountLabels` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListAccountLabels` must match the call that provided the
// page token.
func (c *AccountsLabelsListCall) PageToken(pageToken string) *AccountsLabelsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsLabelsListCall) Fields(s ...googleapi.Field) *AccountsLabelsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsLabelsListCall) IfNoneMatch(entityTag string) *AccountsLabelsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsLabelsListCall) Context(ctx context.Context) *AccountsLabelsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsLabelsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsLabelsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "accounts/{accountId}/labels")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"accountId": strconv.FormatInt(c.accountId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.labels.list" call.
// Exactly one of *ListAccountLabelsResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *ListAccountLabelsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountsLabelsListCall) Do(opts ...googleapi.CallOption) (*ListAccountLabelsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListAccountLabelsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists the labels assigned to an account.",
	//   "flatPath": "accounts/{accountId}/labels",
	//   "httpMethod": "GET",
	//   "id": "content.accounts.labels.list",
	//   "parameterOrder": [
	//     "accountId"
	//   ],
	//   "parameters": {
	//     "accountId": {
	//       "description": "Required. The account id for whose labels are to be listed.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of labels to return. The service may return fewer than this value. If unspecified, at most 50 labels will be returned. The maximum value is 1000; values above 1000 will be coerced to 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListAccountLabels` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListAccountLabels` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "accounts/{accountId}/labels",
	//   "response": {
	//     "$ref": "ListAccountLabelsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccountsLabelsListCall) Pages(ctx context.Context, f func(*ListAccountLabelsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "content.accounts.labels.patch":

type AccountsLabelsPatchCall struct {
	s            *APIService
	accountId    int64
	labelId      int64
	accountlabel *AccountLabel
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Patch: Updates a label.
//
// - accountId: The id of the account this label belongs to.
// - labelId: The id of the label to update.
func (r *AccountsLabelsService) Patch(accountId int64, labelId int64, accountlabel *AccountLabel) *AccountsLabelsPatchCall {
	c := &AccountsLabelsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.accountId = accountId
	c.labelId = labelId
	c.accountlabel = accountlabel
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsLabelsPatchCall) Fields(s ...googleapi.Field) *AccountsLabelsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsLabelsPatchCall) Context(ctx context.Context) *AccountsLabelsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsLabelsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsLabelsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.accountlabel)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "accounts/{accountId}/labels/{labelId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"accountId": strconv.FormatInt(c.accountId, 10),
		"labelId":   strconv.FormatInt(c.labelId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.labels.patch" call.
// Exactly one of *AccountLabel or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *AccountLabel.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountsLabelsPatchCall) Do(opts ...googleapi.CallOption) (*AccountLabel, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &AccountLabel{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a label.",
	//   "flatPath": "accounts/{accountId}/labels/{labelId}",
	//   "httpMethod": "PATCH",
	//   "id": "content.accounts.labels.patch",
	//   "parameterOrder": [
	//     "accountId",
	//     "labelId"
	//   ],
	//   "parameters": {
	//     "accountId": {
	//       "description": "Required. The id of the account this label belongs to.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "labelId": {
	//       "description": "Required. The id of the label to update.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "accounts/{accountId}/labels/{labelId}",
	//   "request": {
	//     "$ref": "AccountLabel"
	//   },
	//   "response": {
	//     "$ref": "AccountLabel"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// method id "content.accounts.returncarrier.create":

type AccountsReturncarrierCreateCall struct {
	s                    *APIService
	accountId            int64
	accountreturncarrier *AccountReturnCarrier
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Create: Links return carrier to a merchant account.
//
// - accountId: The Merchant Center Account Id under which the Return
//   Carrier is to be linked.
func (r *AccountsReturncarrierService) Create(accountId int64, accountreturncarrier *AccountReturnCarrier) *AccountsReturncarrierCreateCall {
	c := &AccountsReturncarrierCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.accountId = accountId
	c.accountreturncarrier = accountreturncarrier
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsReturncarrierCreateCall) Fields(s ...googleapi.Field) *AccountsReturncarrierCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsReturncarrierCreateCall) Context(ctx context.Context) *AccountsReturncarrierCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsReturncarrierCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsReturncarrierCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.accountreturncarrier)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "accounts/{accountId}/returncarrier")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"accountId": strconv.FormatInt(c.accountId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.returncarrier.create" call.
// Exactly one of *AccountReturnCarrier or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *AccountReturnCarrier.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountsReturncarrierCreateCall) Do(opts ...googleapi.CallOption) (*AccountReturnCarrier, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &AccountReturnCarrier{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Links return carrier to a merchant account.",
	//   "flatPath": "accounts/{accountId}/returncarrier",
	//   "httpMethod": "POST",
	//   "id": "content.accounts.returncarrier.create",
	//   "parameterOrder": [
	//     "accountId"
	//   ],
	//   "parameters": {
	//     "accountId": {
	//       "description": "Required. The Merchant Center Account Id under which the Return Carrier is to be linked.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "accounts/{accountId}/returncarrier",
	//   "request": {
	//     "$ref": "AccountReturnCarrier"
	//   },
	//   "response": {
	//     "$ref": "AccountReturnCarrier"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// method id "content.accounts.returncarrier.delete":

type AccountsReturncarrierDeleteCall struct {
	s                *APIService
	accountId        int64
	carrierAccountId int64
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// Delete: Delete a return carrier in the merchant account.
//
// - accountId: The Merchant Center Account Id under which the Return
//   Carrier is to be linked.
// - carrierAccountId: The Google-provided unique carrier ID, used to
//   update the resource.
func (r *AccountsReturncarrierService) Delete(accountId int64, carrierAccountId int64) *AccountsReturncarrierDeleteCall {
	c := &AccountsReturncarrierDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.accountId = accountId
	c.carrierAccountId = carrierAccountId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsReturncarrierDeleteCall) Fields(s ...googleapi.Field) *AccountsReturncarrierDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsReturncarrierDeleteCall) Context(ctx context.Context) *AccountsReturncarrierDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsReturncarrierDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsReturncarrierDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "accounts/{accountId}/returncarrier/{carrierAccountId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"accountId":        strconv.FormatInt(c.accountId, 10),
		"carrierAccountId": strconv.FormatInt(c.carrierAccountId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.returncarrier.delete" call.
func (c *AccountsReturncarrierDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return err
	}
	return nil
	// {
	//   "description": "Delete a return carrier in the merchant account.",
	//   "flatPath": "accounts/{accountId}/returncarrier/{carrierAccountId}",
	//   "httpMethod": "DELETE",
	//   "id": "content.accounts.returncarrier.delete",
	//   "parameterOrder": [
	//     "accountId",
	//     "carrierAccountId"
	//   ],
	//   "parameters": {
	//     "accountId": {
	//       "description": "Required. The Merchant Center Account Id under which the Return Carrier is to be linked.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "carrierAccountId": {
	//       "description": "Required. The Google-provided unique carrier ID, used to update the resource.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "accounts/{accountId}/returncarrier/{carrierAccountId}",
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// method id "content.accounts.returncarrier.list":

type AccountsReturncarrierListCall struct {
	s            *APIService
	accountId    int64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists available return carriers in the merchant account.
//
// - accountId: The Merchant Center Account Id under which the Return
//   Carrier is to be linked.
func (r *AccountsReturncarrierService) List(accountId int64) *AccountsReturncarrierListCall {
	c := &AccountsReturncarrierListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.accountId = accountId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsReturncarrierListCall) Fields(s ...googleapi.Field) *AccountsReturncarrierListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsReturncarrierListCall) IfNoneMatch(entityTag string) *AccountsReturncarrierListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsReturncarrierListCall) Context(ctx context.Context) *AccountsReturncarrierListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsReturncarrierListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsReturncarrierListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "accounts/{accountId}/returncarrier")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"accountId": strconv.FormatInt(c.accountId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.returncarrier.list" call.
// Exactly one of *ListAccountReturnCarrierResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *ListAccountReturnCarrierResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountsReturncarrierListCall) Do(opts ...googleapi.CallOption) (*ListAccountReturnCarrierResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListAccountReturnCarrierResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists available return carriers in the merchant account.",
	//   "flatPath": "accounts/{accountId}/returncarrier",
	//   "httpMethod": "GET",
	//   "id": "content.accounts.returncarrier.list",
	//   "parameterOrder": [
	//     "accountId"
	//   ],
	//   "parameters": {
	//     "accountId": {
	//       "description": "Required. The Merchant Center Account Id under which the Return Carrier is to be linked.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "accounts/{accountId}/returncarrier",
	//   "response": {
	//     "$ref": "ListAccountReturnCarrierResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// method id "content.accounts.returncarrier.patch":

type AccountsReturncarrierPatchCall struct {
	s                    *APIService
	accountId            int64
	carrierAccountId     int64
	accountreturncarrier *AccountReturnCarrier
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Patch: Updates a return carrier in the merchant account.
//
// - accountId: The Merchant Center Account Id under which the Return
//   Carrier is to be linked.
// - carrierAccountId: The Google-provided unique carrier ID, used to
//   update the resource.
func (r *AccountsReturncarrierService) Patch(accountId int64, carrierAccountId int64, accountreturncarrier *AccountReturnCarrier) *AccountsReturncarrierPatchCall {
	c := &AccountsReturncarrierPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.accountId = accountId
	c.carrierAccountId = carrierAccountId
	c.accountreturncarrier = accountreturncarrier
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsReturncarrierPatchCall) Fields(s ...googleapi.Field) *AccountsReturncarrierPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsReturncarrierPatchCall) Context(ctx context.Context) *AccountsReturncarrierPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsReturncarrierPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsReturncarrierPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.accountreturncarrier)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "accounts/{accountId}/returncarrier/{carrierAccountId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"accountId":        strconv.FormatInt(c.accountId, 10),
		"carrierAccountId": strconv.FormatInt(c.carrierAccountId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.returncarrier.patch" call.
// Exactly one of *AccountReturnCarrier or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *AccountReturnCarrier.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountsReturncarrierPatchCall) Do(opts ...googleapi.CallOption) (*AccountReturnCarrier, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &AccountReturnCarrier{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a return carrier in the merchant account.",
	//   "flatPath": "accounts/{accountId}/returncarrier/{carrierAccountId}",
	//   "httpMethod": "PATCH",
	//   "id": "content.accounts.returncarrier.patch",
	//   "parameterOrder": [
	//     "accountId",
	//     "carrierAccountId"
	//   ],
	//   "parameters": {
	//     "accountId": {
	//       "description": "Required. The Merchant Center Account Id under which the Return Carrier is to be linked.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "carrierAccountId": {
	//       "description": "Required. The Google-provided unique carrier ID, used to update the resource.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "accounts/{accountId}/returncarrier/{carrierAccountId}",
	//   "request": {
	//     "$ref": "AccountReturnCarrier"
	//   },
	//   "response": {
	//     "$ref": "AccountReturnCarrier"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// method id "content.accountstatuses.custombatch":

type AccountstatusesCustombatchCall struct {
	s                                 *APIService
	accountstatusescustombatchrequest *AccountstatusesCustomBatchRequest
	urlParams_                        gensupport.URLParams
	ctx_                              context.Context
	header_                           http.Header
}

// Custombatch: Retrieves multiple Merchant Center account statuses in a
// single request.
func (r *AccountstatusesService) Custombatch(accountstatusescustombatchrequest *AccountstatusesCustomBatchRequest) *AccountstatusesCustombatchCall {
	c := &AccountstatusesCustombatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.accountstatusescustombatchrequest = accountstatusescustombatchrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountstatusesCustombatchCall) Fields(s ...googleapi.Field) *AccountstatusesCustombatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountstatusesCustombatchCall) Context(ctx context.Context) *AccountstatusesCustombatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountstatusesCustombatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountstatusesCustombatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.accountstatusescustombatchrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "accountstatuses/batch")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accountstatuses.custombatch" call.
// Exactly one of *AccountstatusesCustomBatchResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *AccountstatusesCustomBatchResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountstatusesCustombatchCall) Do(opts ...googleapi.CallOption) (*AccountstatusesCustomBatchResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &AccountstatusesCustomBatchResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves multiple Merchant Center account statuses in a single request.",
	//   "flatPath": "accountstatuses/batch",
	//   "httpMethod": "POST",
	//   "id": "content.accountstatuses.custombatch",
	//   "parameterOrder": [],
	//   "parameters": {},
	//   "path": "accountstatuses/batch",
	//   "request": {
	//     "$ref": "AccountstatusesCustomBatchRequest"
	//   },
	//   "response": {
	//     "$ref": "AccountstatusesCustomBatchResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// method id "content.accountstatuses.get":

type AccountstatusesGetCall struct {
	s            *APIService
	merchantId   uint64
	accountId    uint64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves the status of a Merchant Center account. No
// itemLevelIssues are returned for multi-client accounts.
//
// - accountId: The ID of the account.
// - merchantId: The ID of the managing account. If this parameter is
//   not the same as accountId, then this account must be a multi-client
//   account and `accountId` must be the ID of a sub-account of this
//   account.
func (r *AccountstatusesService) Get(merchantId uint64, accountId uint64) *AccountstatusesGetCall {
	c := &AccountstatusesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.accountId = accountId
	return c
}

// Destinations sets the optional parameter "destinations": If set, only
// issues for the specified destinations are returned, otherwise only
// issues for the Shopping destination.
func (c *AccountstatusesGetCall) Destinations(destinations ...string) *AccountstatusesGetCall {
	c.urlParams_.SetMulti("destinations", append([]string{}, destinations...))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountstatusesGetCall) Fields(s ...googleapi.Field) *AccountstatusesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountstatusesGetCall) IfNoneMatch(entityTag string) *AccountstatusesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountstatusesGetCall) Context(ctx context.Context) *AccountstatusesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountstatusesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountstatusesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/accountstatuses/{accountId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
		"accountId":  strconv.FormatUint(c.accountId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accountstatuses.get" call.
// Exactly one of *AccountStatus or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *AccountStatus.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountstatusesGetCall) Do(opts ...googleapi.CallOption) (*AccountStatus, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &AccountStatus{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves the status of a Merchant Center account. No itemLevelIssues are returned for multi-client accounts.",
	//   "flatPath": "{merchantId}/accountstatuses/{accountId}",
	//   "httpMethod": "GET",
	//   "id": "content.accountstatuses.get",
	//   "parameterOrder": [
	//     "merchantId",
	//     "accountId"
	//   ],
	//   "parameters": {
	//     "accountId": {
	//       "description": "The ID of the account.",
	//       "format": "uint64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "destinations": {
	//       "description": "If set, only issues for the specified destinations are returned, otherwise only issues for the Shopping destination.",
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     },
	//     "merchantId": {
	//       "description": "The ID of the managing account. If this parameter is not the same as accountId, then this account must be a multi-client account and `accountId` must be the ID of a sub-account of this account.",
	//       "format": "uint64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "{merchantId}/accountstatuses/{accountId}",
	//   "response": {
	//     "$ref": "AccountStatus"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// method id "content.accountstatuses.list":

type AccountstatusesListCall struct {
	s            *APIService
	merchantId   uint64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the statuses of the sub-accounts in your Merchant Center
// account.
//
// - merchantId: The ID of the managing account. This must be a
//   multi-client account.
func (r *AccountstatusesService) List(merchantId uint64) *AccountstatusesListCall {
	c := &AccountstatusesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	return c
}

// Destinations sets the optional parameter "destinations": If set, only
// issues for the specified destinations are returned, otherwise only
// issues for the Shopping destination.
func (c *AccountstatusesListCall) Destinations(destinations ...string) *AccountstatusesListCall {
	c.urlParams_.SetMulti("destinations", append([]string{}, destinations...))
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum
// number of account statuses to return in the response, used for
// paging.
func (c *AccountstatusesListCall) MaxResults(maxResults int64) *AccountstatusesListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// Name sets the optional parameter "name": If set, only the accounts
// with the given name (case sensitive) will be returned.
func (c *AccountstatusesListCall) Name(name string) *AccountstatusesListCall {
	c.urlParams_.Set("name", name)
	return c
}

// PageToken sets the optional parameter "pageToken": The token returned
// by the previous request.
func (c *AccountstatusesListCall) PageToken(pageToken string) *AccountstatusesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountstatusesListCall) Fields(s ...googleapi.Field) *AccountstatusesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountstatusesListCall) IfNoneMatch(entityTag string) *AccountstatusesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountstatusesListCall) Context(ctx context.Context) *AccountstatusesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountstatusesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountstatusesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/accountstatuses")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accountstatuses.list" call.
// Exactly one of *AccountstatusesListResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *AccountstatusesListResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountstatusesListCall) Do(opts ...googleapi.CallOption) (*AccountstatusesListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &AccountstatusesListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists the statuses of the sub-accounts in your Merchant Center account.",
	//   "flatPath": "{merchantId}/accountstatuses",
	//   "httpMethod": "GET",
	//   "id": "content.accountstatuses.list",
	//   "parameterOrder": [
	//     "merchantId"
	//   ],
	//   "parameters": {
	//     "destinations": {
	//       "description": "If set, only issues for the specified destinations are returned, otherwise only issues for the Shopping destination.",
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     },
	//     "maxResults": {
	//       "description": "The maximum number of account statuses to return in the response, used for paging.",
	//       "format": "uint32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "merchantId": {
	//       "description": "The ID of the managing account. This must be a multi-client account.",
	//       "format": "uint64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "If set, only the accounts with the given name (case sensitive) will be returned.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageToken": {
	//       "description": "The token returned by the previous request.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "{merchantId}/accountstatuses",
	//   "response": {
	//     "$ref": "AccountstatusesListResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccountstatusesListCall) Pages(ctx context.Context, f func(*AccountstatusesListResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "content.accounttax.custombatch":

type AccounttaxCustombatchCall struct {
	s                            *APIService
	accounttaxcustombatchrequest *AccounttaxCustomBatchRequest
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// Custombatch: Retrieves and updates tax settings of multiple accounts
// in a single request.
func (r *AccounttaxService) Custombatch(accounttaxcustombatchrequest *AccounttaxCustomBatchRequest) *AccounttaxCustombatchCall {
	c := &AccounttaxCustombatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.accounttaxcustombatchrequest = accounttaxcustombatchrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccounttaxCustombatchCall) Fields(s ...googleapi.Field) *AccounttaxCustombatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccounttaxCustombatchCall) Context(ctx context.Context) *AccounttaxCustombatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccounttaxCustombatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccounttaxCustombatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.accounttaxcustombatchrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "accounttax/batch")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounttax.custombatch" call.
// Exactly one of *AccounttaxCustomBatchResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *AccounttaxCustomBatchResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccounttaxCustombatchCall) Do(opts ...googleapi.CallOption) (*AccounttaxCustomBatchResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &AccounttaxCustomBatchResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves and updates tax settings of multiple accounts in a single request.",
	//   "flatPath": "accounttax/batch",
	//   "httpMethod": "POST",
	//   "id": "content.accounttax.custombatch",
	//   "parameterOrder": [],
	//   "parameters": {},
	//   "path": "accounttax/batch",
	//   "request": {
	//     "$ref": "AccounttaxCustomBatchRequest"
	//   },
	//   "response": {
	//     "$ref": "AccounttaxCustomBatchResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// method id "content.accounttax.get":

type AccounttaxGetCall struct {
	s            *APIService
	merchantId   uint64
	accountId    uint64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves the tax settings of the account.
//
// - accountId: The ID of the account for which to get/update account
//   tax settings.
// - merchantId: The ID of the managing account. If this parameter is
//   not the same as accountId, then this account must be a multi-client
//   account and `accountId` must be the ID of a sub-account of this
//   account.
func (r *AccounttaxService) Get(merchantId uint64, accountId uint64) *AccounttaxGetCall {
	c := &AccounttaxGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.accountId = accountId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccounttaxGetCall) Fields(s ...googleapi.Field) *AccounttaxGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccounttaxGetCall) IfNoneMatch(entityTag string) *AccounttaxGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccounttaxGetCall) Context(ctx context.Context) *AccounttaxGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccounttaxGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccounttaxGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/accounttax/{accountId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
		"accountId":  strconv.FormatUint(c.accountId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounttax.get" call.
// Exactly one of *AccountTax or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *AccountTax.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccounttaxGetCall) Do(opts ...googleapi.CallOption) (*AccountTax, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &AccountTax{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves the tax settings of the account.",
	//   "flatPath": "{merchantId}/accounttax/{accountId}",
	//   "httpMethod": "GET",
	//   "id": "content.accounttax.get",
	//   "parameterOrder": [
	//     "merchantId",
	//     "accountId"
	//   ],
	//   "parameters": {
	//     "accountId": {
	//       "description": "The ID of the account for which to get/update account tax settings.",
	//       "format": "uint64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "merchantId": {
	//       "description": "The ID of the managing account. If this parameter is not the same as accountId, then this account must be a multi-client account and `accountId` must be the ID of a sub-account of this account.",
	//       "format": "uint64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "{merchantId}/accounttax/{accountId}",
	//   "response": {
	//     "$ref": "AccountTax"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// method id "content.accounttax.list":

type AccounttaxListCall struct {
	s            *APIService
	merchantId   uint64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the tax settings of the sub-accounts in your Merchant
// Center account.
//
// - merchantId: The ID of the managing account. This must be a
//   multi-client account.
func (r *AccounttaxService) List(merchantId uint64) *AccounttaxListCall {
	c := &AccounttaxListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum
// number of tax settings to return in the response, used for paging.
func (c *AccounttaxListCall) MaxResults(maxResults int64) *AccounttaxListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// PageToken sets the optional parameter "pageToken": The token returned
// by the previous request.
func (c *AccounttaxListCall) PageToken(pageToken string) *AccounttaxListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccounttaxListCall) Fields(s ...googleapi.Field) *AccounttaxListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccounttaxListCall) IfNoneMatch(entityTag string) *AccounttaxListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccounttaxListCall) Context(ctx context.Context) *AccounttaxListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccounttaxListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccounttaxListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/accounttax")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounttax.list" call.
// Exactly one of *AccounttaxListResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *AccounttaxListResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccounttaxListCall) Do(opts ...googleapi.CallOption) (*AccounttaxListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &AccounttaxListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists the tax settings of the sub-accounts in your Merchant Center account.",
	//   "flatPath": "{merchantId}/accounttax",
	//   "httpMethod": "GET",
	//   "id": "content.accounttax.list",
	//   "parameterOrder": [
	//     "merchantId"
	//   ],
	//   "parameters": {
	//     "maxResults": {
	//       "description": "The maximum number of tax settings to return in the response, used for paging.",
	//       "format": "uint32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "merchantId": {
	//       "description": "The ID of the managing account. This must be a multi-client account.",
	//       "format": "uint64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageToken": {
	//       "description": "The token returned by the previous request.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "{merchantId}/accounttax",
	//   "response": {
	//     "$ref": "AccounttaxListResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccounttaxListCall) Pages(ctx context.Context, f func(*AccounttaxListResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "content.accounttax.update":

type AccounttaxUpdateCall struct {
	s          *APIService
	merchantId uint64
	accountId  uint64
	accounttax *AccountTax
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Update: Updates the tax settings of the account. Any fields that are
// not provided are deleted from the resource.
//
// - accountId: The ID of the account for which to get/update account
//   tax settings.
// - merchantId: The ID of the managing account. If this parameter is
//   not the same as accountId, then this account must be a multi-client
//   account and `accountId` must be the ID of a sub-account of this
//   account.
func (r *AccounttaxService) Update(merchantId uint64, accountId uint64, accounttax *AccountTax) *AccounttaxUpdateCall {
	c := &AccounttaxUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.accountId = accountId
	c.accounttax = accounttax
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccounttaxUpdateCall) Fields(s ...googleapi.Field) *AccounttaxUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccounttaxUpdateCall) Context(ctx context.Context) *AccounttaxUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccounttaxUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccounttaxUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.accounttax)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/accounttax/{accountId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
		"accountId":  strconv.FormatUint(c.accountId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounttax.update" call.
// Exactly one of *AccountTax or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *AccountTax.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccounttaxUpdateCall) Do(opts ...googleapi.CallOption) (*AccountTax, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &AccountTax{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the tax settings of the account. Any fields that are not provided are deleted from the resource.",
	//   "flatPath": "{merchantId}/accounttax/{accountId}",
	//   "httpMethod": "PUT",
	//   "id": "content.accounttax.update",
	//   "parameterOrder": [
	//     "merchantId",
	//     "accountId"
	//   ],
	//   "parameters": {
	//     "accountId": {
	//       "description": "The ID of the account for which to get/update account tax settings.",
	//       "format": "uint64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "merchantId": {
	//       "description": "The ID of the managing account. If this parameter is not the same as accountId, then this account must be a multi-client account and `accountId` must be the ID of a sub-account of this account.",
	//       "format": "uint64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "{merchantId}/accounttax/{accountId}",
	//   "request": {
	//     "$ref": "AccountTax"
	//   },
	//   "response": {
	//     "$ref": "AccountTax"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// method id "content.buyongoogleprograms.activate":

type BuyongoogleprogramsActivateCall struct {
	s                                 *APIService
	merchantId                        int64
	regionCode                        string
	activatebuyongoogleprogramrequest *ActivateBuyOnGoogleProgramRequest
	urlParams_                        gensupport.URLParams
	ctx_                              context.Context
	header_                           http.Header
}

// Activate: Reactivates the BoG program in your Merchant Center
// account. Moves the program to the active state when allowed, e.g.
// when paused. Important: This method is only whitelisted for selected
// merchants.
//
// - merchantId: The ID of the account.
// - regionCode: The program region code ISO 3166-1 alpha-2
//   (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2). Currently only
//   US is available.
func (r *BuyongoogleprogramsService) Activate(merchantId int64, regionCode string, activatebuyongoogleprogramrequest *ActivateBuyOnGoogleProgramRequest) *BuyongoogleprogramsActivateCall {
	c := &BuyongoogleprogramsActivateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.regionCode = regionCode
	c.activatebuyongoogleprogramrequest = activatebuyongoogleprogramrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *BuyongoogleprogramsActivateCall) Fields(s ...googleapi.Field) *BuyongoogleprogramsActivateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *BuyongoogleprogramsActivateCall) Context(ctx context.Context) *BuyongoogleprogramsActivateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *BuyongoogleprogramsActivateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyongoogleprogramsActivateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.activatebuyongoogleprogramrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/buyongoogleprograms/{regionCode}/activate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatInt(c.merchantId, 10),
		"regionCode": c.regionCode,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.buyongoogleprograms.activate" call.
func (c *BuyongoogleprogramsActivateCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return err
	}
	return nil
	// {
	//   "description": "Reactivates the BoG program in your Merchant Center account. Moves the program to the active state when allowed, e.g. when paused. Important: This method is only whitelisted for selected merchants.",
	//   "flatPath": "{merchantId}/buyongoogleprograms/{regionCode}/activate",
	//   "httpMethod": "POST",
	//   "id": "content.buyongoogleprograms.activate",
	//   "parameterOrder": [
	//     "merchantId",
	//     "regionCode"
	//   ],
	//   "parameters": {
	//     "merchantId": {
	//       "description": "Required. The ID of the account.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "regionCode": {
	//       "description": "Required. The program region code [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2). Currently only US is available.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "{merchantId}/buyongoogleprograms/{regionCode}/activate",
	//   "request": {
	//     "$ref": "ActivateBuyOnGoogleProgramRequest"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// method id "content.buyongoogleprograms.get":

type BuyongoogleprogramsGetCall struct {
	s            *APIService
	merchantId   int64
	regionCode   string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a status of the BoG program for your Merchant Center
// account.
//
// - merchantId: The ID of the account.
// - regionCode: The Program region code ISO 3166-1 alpha-2
//   (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2). Currently only
//   US is available.
func (r *BuyongoogleprogramsService) Get(merchantId int64, regionCode string) *BuyongoogleprogramsGetCall {
	c := &BuyongoogleprogramsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.regionCode = regionCode
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *BuyongoogleprogramsGetCall) Fields(s ...googleapi.Field) *BuyongoogleprogramsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *BuyongoogleprogramsGetCall) IfNoneMatch(entityTag string) *BuyongoogleprogramsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *BuyongoogleprogramsGetCall) Context(ctx context.Context) *BuyongoogleprogramsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *BuyongoogleprogramsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyongoogleprogramsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/buyongoogleprograms/{regionCode}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatInt(c.merchantId, 10),
		"regionCode": c.regionCode,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.buyongoogleprograms.get" call.
// Exactly one of *BuyOnGoogleProgramStatus or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *BuyOnGoogleProgramStatus.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *BuyongoogleprogramsGetCall) Do(opts ...googleapi.CallOption) (*BuyOnGoogleProgramStatus, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &BuyOnGoogleProgramStatus{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves a status of the BoG program for your Merchant Center account.",
	//   "flatPath": "{merchantId}/buyongoogleprograms/{regionCode}",
	//   "httpMethod": "GET",
	//   "id": "content.buyongoogleprograms.get",
	//   "parameterOrder": [
	//     "merchantId",
	//     "regionCode"
	//   ],
	//   "parameters": {
	//     "merchantId": {
	//       "description": "Required. The ID of the account.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "regionCode": {
	//       "description": "Required. The Program region code [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2). Currently only US is available.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "{merchantId}/buyongoogleprograms/{regionCode}",
	//   "response": {
	//     "$ref": "BuyOnGoogleProgramStatus"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// method id "content.buyongoogleprograms.onboard":

type BuyongoogleprogramsOnboardCall struct {
	s                                *APIService
	merchantId                       int64
	regionCode                       string
	onboardbuyongoogleprogramrequest *OnboardBuyOnGoogleProgramRequest
	urlParams_                       gensupport.URLParams
	ctx_                             context.Context
	header_                          http.Header
}

// Onboard: Onboards the BoG program in your Merchant Center account. By
// using this method, you agree to the Terms of Service
// (https://merchants.google.com/mc/termsofservice/transactions/US/latest).
// Calling this method is only possible if the authenticated account is
// the same as the merchant id in the request. Calling this method
// multiple times will only accept Terms of Service if the latest
// version is not currently signed.
//
// - merchantId: The ID of the account.
// - regionCode: The program region code ISO 3166-1 alpha-2
//   (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2). Currently only
//   US is available.
func (r *BuyongoogleprogramsService) Onboard(merchantId int64, regionCode string, onboardbuyongoogleprogramrequest *OnboardBuyOnGoogleProgramRequest) *BuyongoogleprogramsOnboardCall {
	c := &BuyongoogleprogramsOnboardCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.regionCode = regionCode
	c.onboardbuyongoogleprogramrequest = onboardbuyongoogleprogramrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *BuyongoogleprogramsOnboardCall) Fields(s ...googleapi.Field) *BuyongoogleprogramsOnboardCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *BuyongoogleprogramsOnboardCall) Context(ctx context.Context) *BuyongoogleprogramsOnboardCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *BuyongoogleprogramsOnboardCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyongoogleprogramsOnboardCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.onboardbuyongoogleprogramrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/buyongoogleprograms/{regionCode}/onboard")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatInt(c.merchantId, 10),
		"regionCode": c.regionCode,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.buyongoogleprograms.onboard" call.
func (c *BuyongoogleprogramsOnboardCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return err
	}
	return nil
	// {
	//   "description": "Onboards the BoG program in your Merchant Center account. By using this method, you agree to the [Terms of Service](https://merchants.google.com/mc/termsofservice/transactions/US/latest). Calling this method is only possible if the authenticated account is the same as the merchant id in the request. Calling this method multiple times will only accept Terms of Service if the latest version is not currently signed.",
	//   "flatPath": "{merchantId}/buyongoogleprograms/{regionCode}/onboard",
	//   "httpMethod": "POST",
	//   "id": "content.buyongoogleprograms.onboard",
	//   "parameterOrder": [
	//     "merchantId",
	//     "regionCode"
	//   ],
	//   "parameters": {
	//     "merchantId": {
	//       "description": "Required. The ID of the account.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "regionCode": {
	//       "description": "Required. The program region code [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2). Currently only US is available.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "{merchantId}/buyongoogleprograms/{regionCode}/onboard",
	//   "request": {
	//     "$ref": "OnboardBuyOnGoogleProgramRequest"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// method id "content.buyongoogleprograms.patch":

type BuyongoogleprogramsPatchCall struct {
	s                        *APIService
	merchantId               int64
	regionCode               string
	buyongoogleprogramstatus *BuyOnGoogleProgramStatus
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// Patch: Updates the status of the BoG program for your Merchant Center
// account.
//
// - merchantId: The ID of the account.
// - regionCode: The program region code ISO 3166-1 alpha-2
//   (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2). Currently only
//   US is available.
func (r *BuyongoogleprogramsService) Patch(merchantId int64, regionCode string, buyongoogleprogramstatus *BuyOnGoogleProgramStatus) *BuyongoogleprogramsPatchCall {
	c := &BuyongoogleprogramsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.regionCode = regionCode
	c.buyongoogleprogramstatus = buyongoogleprogramstatus
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of
// fields to update. If the update mask is not provided, then all the
// fields set in buyOnGoogleProgramStatus will be updated. Clearing
// fields is only possible if update mask is provided.
func (c *BuyongoogleprogramsPatchCall) UpdateMask(updateMask string) *BuyongoogleprogramsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *BuyongoogleprogramsPatchCall) Fields(s ...googleapi.Field) *BuyongoogleprogramsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *BuyongoogleprogramsPatchCall) Context(ctx context.Context) *BuyongoogleprogramsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *BuyongoogleprogramsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyongoogleprogramsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.buyongoogleprogramstatus)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/buyongoogleprograms/{regionCode}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatInt(c.merchantId, 10),
		"regionCode": c.regionCode,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.buyongoogleprograms.patch" call.
// Exactly one of *BuyOnGoogleProgramStatus or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *BuyOnGoogleProgramStatus.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *BuyongoogleprogramsPatchCall) Do(opts ...googleapi.CallOption) (*BuyOnGoogleProgramStatus, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &BuyOnGoogleProgramStatus{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the status of the BoG program for your Merchant Center account.",
	//   "flatPath": "{merchantId}/buyongoogleprograms/{regionCode}",
	//   "httpMethod": "PATCH",
	//   "id": "content.buyongoogleprograms.patch",
	//   "parameterOrder": [
	//     "merchantId",
	//     "regionCode"
	//   ],
	//   "parameters": {
	//     "merchantId": {
	//       "description": "Required. The ID of the account.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "regionCode": {
	//       "description": "Required. The program region code [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2). Currently only US is available.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The list of fields to update. If the update mask is not provided, then all the fields set in buyOnGoogleProgramStatus will be updated. Clearing fields is only possible if update mask is provided.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "{merchantId}/buyongoogleprograms/{regionCode}",
	//   "request": {
	//     "$ref": "BuyOnGoogleProgramStatus"
	//   },
	//   "response": {
	//     "$ref": "BuyOnGoogleProgramStatus"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// method id "content.buyongoogleprograms.pause":

type BuyongoogleprogramsPauseCall struct {
	s                              *APIService
	merchantId                     int64
	regionCode                     string
	pausebuyongoogleprogramrequest *PauseBuyOnGoogleProgramRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// Pause: Pauses the BoG program in your Merchant Center account.
// Important: This method is only whitelisted for selected merchants.
//
// - merchantId: The ID of the account.
// - regionCode: The program region code ISO 3166-1 alpha-2
//   (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2). Currently only
//   US is available.
func (r *BuyongoogleprogramsService) Pause(merchantId int64, regionCode string, pausebuyongoogleprogramrequest *PauseBuyOnGoogleProgramRequest) *BuyongoogleprogramsPauseCall {
	c := &BuyongoogleprogramsPauseCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.regionCode = regionCode
	c.pausebuyongoogleprogramrequest = pausebuyongoogleprogramrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *BuyongoogleprogramsPauseCall) Fields(s ...googleapi.Field) *BuyongoogleprogramsPauseCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *BuyongoogleprogramsPauseCall) Context(ctx context.Context) *BuyongoogleprogramsPauseCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *BuyongoogleprogramsPauseCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyongoogleprogramsPauseCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.pausebuyongoogleprogramrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/buyongoogleprograms/{regionCode}/pause")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatInt(c.merchantId, 10),
		"regionCode": c.regionCode,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.buyongoogleprograms.pause" call.
func (c *BuyongoogleprogramsPauseCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return err
	}
	return nil
	// {
	//   "description": "Pauses the BoG program in your Merchant Center account. Important: This method is only whitelisted for selected merchants.",
	//   "flatPath": "{merchantId}/buyongoogleprograms/{regionCode}/pause",
	//   "httpMethod": "POST",
	//   "id": "content.buyongoogleprograms.pause",
	//   "parameterOrder": [
	//     "merchantId",
	//     "regionCode"
	//   ],
	//   "parameters": {
	//     "merchantId": {
	//       "description": "Required. The ID of the account.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "regionCode": {
	//       "description": "Required. The program region code [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2). Currently only US is available.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "{merchantId}/buyongoogleprograms/{regionCode}/pause",
	//   "request": {
	//     "$ref": "PauseBuyOnGoogleProgramRequest"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// method id "content.buyongoogleprograms.requestreview":

type BuyongoogleprogramsRequestreviewCall struct {
	s                                      *APIService
	merchantId                             int64
	regionCode                             string
	requestreviewbuyongoogleprogramrequest *RequestReviewBuyOnGoogleProgramRequest
	urlParams_                             gensupport.URLParams
	ctx_                                   context.Context
	header_                                http.Header
}

// Requestreview: Requests review and then activates the BoG program in
// your Merchant Center account for the first time. Moves the program to
// the REVIEW_PENDING state. Important: This method is only whitelisted
// for selected merchants.
//
// - merchantId: The ID of the account.
// - regionCode: The program region code ISO 3166-1 alpha-2
//   (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2). Currently only
//   US is available.
func (r *BuyongoogleprogramsService) Requestreview(merchantId int64, regionCode string, requestreviewbuyongoogleprogramrequest *RequestReviewBuyOnGoogleProgramRequest) *BuyongoogleprogramsRequestreviewCall {
	c := &BuyongoogleprogramsRequestreviewCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.regionCode = regionCode
	c.requestreviewbuyongoogleprogramrequest = requestreviewbuyongoogleprogramrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *BuyongoogleprogramsRequestreviewCall) Fields(s ...googleapi.Field) *BuyongoogleprogramsRequestreviewCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *BuyongoogleprogramsRequestreviewCall) Context(ctx context.Context) *BuyongoogleprogramsRequestreviewCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *BuyongoogleprogramsRequestreviewCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyongoogleprogramsRequestreviewCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.requestreviewbuyongoogleprogramrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/buyongoogleprograms/{regionCode}/requestreview")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatInt(c.merchantId, 10),
		"regionCode": c.regionCode,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.buyongoogleprograms.requestreview" call.
func (c *BuyongoogleprogramsRequestreviewCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return err
	}
	return nil
	// {
	//   "description": "Requests review and then activates the BoG program in your Merchant Center account for the first time. Moves the program to the REVIEW_PENDING state. Important: This method is only whitelisted for selected merchants.",
	//   "flatPath": "{merchantId}/buyongoogleprograms/{regionCode}/requestreview",
	//   "httpMethod": "POST",
	//   "id": "content.buyongoogleprograms.requestreview",
	//   "parameterOrder": [
	//     "merchantId",
	//     "regionCode"
	//   ],
	//   "parameters": {
	//     "merchantId": {
	//       "description": "Required. The ID of the account.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "regionCode": {
	//       "description": "Required. The program region code [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2). Currently only US is available.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "{merchantId}/buyongoogleprograms/{regionCode}/requestreview",
	//   "request": {
	//     "$ref": "RequestReviewBuyOnGoogleProgramRequest"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// method id "content.collections.create":

type CollectionsCreateCall struct {
	s          *APIService
	merchantId int64
	collection *Collection
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Uploads a collection to your Merchant Center account. If a
// collection with the same collectionId already exists, this method
// updates that entry. In each update, the collection is completely
// replaced by the fields in the body of the update request.
//
// - merchantId: The ID of the account that contains the collection.
//   This account cannot be a multi-client account.
func (r *CollectionsService) Create(merchantId int64, collection *Collection) *CollectionsCreateCall {
	c := &CollectionsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.collection = collection
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CollectionsCreateCall) Fields(s ...googleapi.Field) *CollectionsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CollectionsCreateCall) Context(ctx context.Context) *CollectionsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CollectionsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CollectionsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.collection)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/collections")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatInt(c.merchantId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.collections.create" call.
// Exactly one of *Collection or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Collection.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CollectionsCreateCall) Do(opts ...googleapi.CallOption) (*Collection, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Collection{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Uploads a collection to your Merchant Center account. If a collection with the same collectionId already exists, this method updates that entry. In each update, the collection is completely replaced by the fields in the body of the update request.",
	//   "flatPath": "{merchantId}/collections",
	//   "httpMethod": "POST",
	//   "id": "content.collections.create",
	//   "parameterOrder": [
	//     "merchantId"
	//   ],
	//   "parameters": {
	//     "merchantId": {
	//       "description": "Required. The ID of the account that contains the collection. This account cannot be a multi-client account.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "{merchantId}/collections",
	//   "request": {
	//     "$ref": "Collection"
	//   },
	//   "response": {
	//     "$ref": "Collection"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// method id "content.collections.delete":

type CollectionsDeleteCall struct {
	s            *APIService
	merchantId   int64
	collectionId string
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Delete: Deletes a collection from your Merchant Center account.
//
// - collectionId: The collectionId of the collection. CollectionId is
//   the same as the REST ID of the collection.
// - merchantId: The ID of the account that contains the collection.
//   This account cannot be a multi-client account.
func (r *CollectionsService) Delete(merchantId int64, collectionId string) *CollectionsDeleteCall {
	c := &CollectionsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.collectionId = collectionId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CollectionsDeleteCall) Fields(s ...googleapi.Field) *CollectionsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CollectionsDeleteCall) Context(ctx context.Context) *CollectionsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CollectionsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CollectionsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/collections/{collectionId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId":   strconv.FormatInt(c.merchantId, 10),
		"collectionId": c.collectionId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.collections.delete" call.
func (c *CollectionsDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return err
	}
	return nil
	// {
	//   "description": "Deletes a collection from your Merchant Center account.",
	//   "flatPath": "{merchantId}/collections/{collectionId}",
	//   "httpMethod": "DELETE",
	//   "id": "content.collections.delete",
	//   "parameterOrder": [
	//     "merchantId",
	//     "collectionId"
	//   ],
	//   "parameters": {
	//     "collectionId": {
	//       "description": "Required. The collectionId of the collection. CollectionId is the same as the REST ID of the collection.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "merchantId": {
	//       "description": "Required. The ID of the account that contains the collection. This account cannot be a multi-client account.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "{merchantId}/collections/{collectionId}",
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// method id "content.collections.get":

type CollectionsGetCall struct {
	s            *APIService
	merchantId   int64
	collectionId string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a collection from your Merchant Center account.
//
// - collectionId: The REST ID of the collection.
// - merchantId: The ID of the account that contains the collection.
//   This account cannot be a multi-client account.
func (r *CollectionsService) Get(merchantId int64, collectionId string) *CollectionsGetCall {
	c := &CollectionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.collectionId = collectionId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CollectionsGetCall) Fields(s ...googleapi.Field) *CollectionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *CollectionsGetCall) IfNoneMatch(entityTag string) *CollectionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CollectionsGetCall) Context(ctx context.Context) *CollectionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CollectionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CollectionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/collections/{collectionId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId":   strconv.FormatInt(c.merchantId, 10),
		"collectionId": c.collectionId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.collections.get" call.
// Exactly one of *Collection or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Collection.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CollectionsGetCall) Do(opts ...googleapi.CallOption) (*Collection, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Collection{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves a collection from your Merchant Center account.",
	//   "flatPath": "{merchantId}/collections/{collectionId}",
	//   "httpMethod": "GET",
	//   "id": "content.collections.get",
	//   "parameterOrder": [
	//     "merchantId",
	//     "collectionId"
	//   ],
	//   "parameters": {
	//     "collectionId": {
	//       "description": "Required. The REST ID of the collection.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "merchantId": {
	//       "description": "Required. The ID of the account that contains the collection. This account cannot be a multi-client account.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "{merchantId}/collections/{collectionId}",
	//   "response": {
	//     "$ref": "Collection"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// method id "content.collections.list":

type CollectionsListCall struct {
	s            *APIService
	merchantId   int64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the collections in your Merchant Center account. The
// response might contain fewer items than specified by page_size. Rely
// on next_page_token to determine if there are more items to be
// requested.
//
// - merchantId: The ID of the account that contains the collection.
//   This account cannot be a multi-client account.
func (r *CollectionsService) List(merchantId int64) *CollectionsListCall {
	c := &CollectionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of collections to return in the response, used for paging. Defaults
// to 50; values above 1000 will be coerced to 1000.
func (c *CollectionsListCall) PageSize(pageSize int64) *CollectionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token (if
// provided) to retrieve the subsequent page. All other parameters must
// match the original call that provided the page token.
func (c *CollectionsListCall) PageToken(pageToken string) *CollectionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CollectionsListCall) Fields(s ...googleapi.Field) *CollectionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *CollectionsListCall) IfNoneMatch(entityTag string) *CollectionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CollectionsListCall) Context(ctx context.Context) *CollectionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CollectionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CollectionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/collections")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatInt(c.merchantId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.collections.list" call.
// Exactly one of *ListCollectionsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListCollectionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *CollectionsListCall) Do(opts ...googleapi.CallOption) (*ListCollectionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListCollectionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists the collections in your Merchant Center account. The response might contain fewer items than specified by page_size. Rely on next_page_token to determine if there are more items to be requested.",
	//   "flatPath": "{merchantId}/collections",
	//   "httpMethod": "GET",
	//   "id": "content.collections.list",
	//   "parameterOrder": [
	//     "merchantId"
	//   ],
	//   "parameters": {
	//     "merchantId": {
	//       "description": "Required. The ID of the account that contains the collection. This account cannot be a multi-client account.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of collections to return in the response, used for paging. Defaults to 50; values above 1000 will be coerced to 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Token (if provided) to retrieve the subsequent page. All other parameters must match the original call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "{merchantId}/collections",
	//   "response": {
	//     "$ref": "ListCollectionsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CollectionsListCall) Pages(ctx context.Context, f func(*ListCollectionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "content.collectionstatuses.get":

type CollectionstatusesGetCall struct {
	s            *APIService
	merchantId   int64
	collectionId string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the status of a collection from your Merchant Center
// account.
//
// - collectionId: The collectionId of the collection. CollectionId is
//   the same as the REST ID of the collection.
// - merchantId: The ID of the account that contains the collection.
//   This account cannot be a multi-client account.
func (r *CollectionstatusesService) Get(merchantId int64, collectionId string) *CollectionstatusesGetCall {
	c := &CollectionstatusesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.collectionId = collectionId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CollectionstatusesGetCall) Fields(s ...googleapi.Field) *CollectionstatusesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *CollectionstatusesGetCall) IfNoneMatch(entityTag string) *CollectionstatusesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CollectionstatusesGetCall) Context(ctx context.Context) *CollectionstatusesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CollectionstatusesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CollectionstatusesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/collectionstatuses/{collectionId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId":   strconv.FormatInt(c.merchantId, 10),
		"collectionId": c.collectionId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.collectionstatuses.get" call.
// Exactly one of *CollectionStatus or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *CollectionStatus.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *CollectionstatusesGetCall) Do(opts ...googleapi.CallOption) (*CollectionStatus, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &CollectionStatus{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the status of a collection from your Merchant Center account.",
	//   "flatPath": "{merchantId}/collectionstatuses/{collectionId}",
	//   "httpMethod": "GET",
	//   "id": "content.collectionstatuses.get",
	//   "parameterOrder": [
	//     "merchantId",
	//     "collectionId"
	//   ],
	//   "parameters": {
	//     "collectionId": {
	//       "description": "Required. The collectionId of the collection. CollectionId is the same as the REST ID of the collection.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "merchantId": {
	//       "description": "Required. The ID of the account that contains the collection. This account cannot be a multi-client account.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "{merchantId}/collectionstatuses/{collectionId}",
	//   "response": {
	//     "$ref": "CollectionStatus"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// method id "content.collectionstatuses.list":

type CollectionstatusesListCall struct {
	s            *APIService
	merchantId   int64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the statuses of the collections in your Merchant Center
// account.
//
// - merchantId: The ID of the account that contains the collection.
//   This account cannot be a multi-client account.
func (r *CollectionstatusesService) List(merchantId int64) *CollectionstatusesListCall {
	c := &CollectionstatusesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of collection statuses to return in the response, used for paging.
// Defaults to 50; values above 1000 will be coerced to 1000.
func (c *CollectionstatusesListCall) PageSize(pageSize int64) *CollectionstatusesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token (if
// provided) to retrieve the subsequent page. All other parameters must
// match the original call that provided the page token.
func (c *CollectionstatusesListCall) PageToken(pageToken string) *CollectionstatusesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CollectionstatusesListCall) Fields(s ...googleapi.Field) *CollectionstatusesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *CollectionstatusesListCall) IfNoneMatch(entityTag string) *CollectionstatusesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CollectionstatusesListCall) Context(ctx context.Context) *CollectionstatusesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CollectionstatusesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CollectionstatusesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/collectionstatuses")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatInt(c.merchantId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.collectionstatuses.list" call.
// Exactly one of *ListCollectionStatusesResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *ListCollectionStatusesResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *CollectionstatusesListCall) Do(opts ...googleapi.CallOption) (*ListCollectionStatusesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListCollectionStatusesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists the statuses of the collections in your Merchant Center account.",
	//   "flatPath": "{merchantId}/collectionstatuses",
	//   "httpMethod": "GET",
	//   "id": "content.collectionstatuses.list",
	//   "parameterOrder": [
	//     "merchantId"
	//   ],
	//   "parameters": {
	//     "merchantId": {
	//       "description": "Required. The ID of the account that contains the collection. This account cannot be a multi-client account.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of collection statuses to return in the response, used for paging. Defaults to 50; values above 1000 will be coerced to 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Token (if provided) to retrieve the subsequent page. All other parameters must match the original call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "{merchantId}/collectionstatuses",
	//   "response": {
	//     "$ref": "ListCollectionStatusesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CollectionstatusesListCall) Pages(ctx context.Context, f func(*ListCollectionStatusesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "content.csses.get":

type CssesGetCall struct {
	s            *APIService
	cssGroupId   int64
	cssDomainId  int64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a single CSS domain by ID.
//
// - cssDomainId: The ID of the CSS domain to return.
// - cssGroupId: The ID of the managing account. If this parameter is
//   not the same as cssDomainId (#cssDomainId), then this ID must be a
//   CSS group ID and `cssDomainId` must be the ID of a CSS domain
//   affiliated with this group.
func (r *CssesService) Get(cssGroupId int64, cssDomainId int64) *CssesGetCall {
	c := &CssesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.cssGroupId = cssGroupId
	c.cssDomainId = cssDomainId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CssesGetCall) Fields(s ...googleapi.Field) *CssesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *CssesGetCall) IfNoneMatch(entityTag string) *CssesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CssesGetCall) Context(ctx context.Context) *CssesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CssesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CssesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{cssGroupId}/csses/{cssDomainId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"cssGroupId":  strconv.FormatInt(c.cssGroupId, 10),
		"cssDomainId": strconv.FormatInt(c.cssDomainId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.csses.get" call.
// Exactly one of *Css or error will be non-nil. Any non-2xx status code
// is an error. Response headers are in either
// *Css.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *CssesGetCall) Do(opts ...googleapi.CallOption) (*Css, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Css{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves a single CSS domain by ID.",
	//   "flatPath": "{cssGroupId}/csses/{cssDomainId}",
	//   "httpMethod": "GET",
	//   "id": "content.csses.get",
	//   "parameterOrder": [
	//     "cssGroupId",
	//     "cssDomainId"
	//   ],
	//   "parameters": {
	//     "cssDomainId": {
	//       "description": "Required. The ID of the CSS domain to return.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "cssGroupId": {
	//       "description": "Required. The ID of the managing account. If this parameter is not the same as [cssDomainId](#cssDomainId), then this ID must be a CSS group ID and `cssDomainId` must be the ID of a CSS domain affiliated with this group.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "{cssGroupId}/csses/{cssDomainId}",
	//   "response": {
	//     "$ref": "Css"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/content"
	//   ]
	// }

}

// method id "content.csses.list":

type CssesListCall struct {
	s            *APIService
	cssGroupId   int64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists CSS domains affiliated with a CSS group.
//
// - cssGroupId: The CSS group ID of CSS domains to be listed.
func (r *CssesService) List(cssGroupId int64) *CssesListCall {
	c := &CssesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.cssGroupId = cssGroupId
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of CSS domains to return. The service may return fewer than this
// value. If unspecified, at most 50 CSS domains will be returned. The
// maximum value is 1000; values above 1000 will be coerced to 1000.
func (c *CssesListCall) PageSize(pageSize int64) *CssesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListCsses` call. Provide this to retrieve
// the